Danish: `apertium-dan`
===============================================================================

This is an Apertium monolingual language package for Danish. What
you can use this language package for:

* Morphological analysis of Danish
* Morphological generation of Danish
* Part-of-speech tagging of Danish

Requirements
-------------------------------------------------------------------------------

You will need the following software installed:

* lttoolbox (>= 3.5.1)
* apertium (>= 3.6.1)
* vislcg3 (>= 1.3.1)

If this does not make any sense, we recommend you look at: apertium.org.

Compiling
-------------------------------------------------------------------------------

Given the requirements being installed, you should be able to just run:

```bash
$ autoreconf -fvi
$ ./configure
$ make
```

You can use `./autogen.sh` instead of `autoreconf` and `./configure` if you're compiling
from source.

If you're doing development, you don't have to install the data, you
can use it directly from this directory.

If you are installing this language package as a prerequisite for an
Apertium translation pair, then do (typically as root / with sudo):

```console
# make install
```

You can use a `--prefix` with `./configure` to install as a non-root user,
but make sure to use the same prefix when installing the translation
pair and any other language packages.

If any of this doesn't make sense or doesn't work, see https://wiki.apertium.org/wiki/Install_language_data_by_compiling

Testing
-------------------------------------------------------------------------------

If you are in the source directory after running make, the following
commands should work:

```console
$ echo "Mit luftpudefartøj er fyldt med ål" | apertium -d . dan-morph
^Mit/min<det><pos><nt><sg>/min<prn><pos><nt><sg>$ ^luftpudefartøj/luft<n><ut><sg><ind><cmp>+pude<n><ut><sg><ind><cmp>+fartøj<n><nt><sg><ind>$ ^er/være<vbser><pres><actv>$ ^fyldt/fylde<vblex><pp>/fylde<adj><pp><ut><sg><ind>/fylde<adj><pp><nt><sg><ind>$ ^med/med<adv>/med<pr>$ ^ål/åle<vblex><imp>/ål<n><ut><sg><ind>/ål<n><ut><sg><ind>$^./.<sent>$

$ echo "Mit luftpudefartøj er fyldt med ål" | apertium -d . dan-disam
^Mit/Min<det><pos><nt><sg>$ ^luftpudefartøj/luft<n><ut><sg><ind><cmp>+pude<n><ut><sg><ind><cmp>+fartøj<n><nt><sg><ind>$ ^er/være<vbser><pres><actv>$ ^fyldt/fylde<vblex><pp>$ ^med/med<pr>$ ^ål/ål<n><ut><sg><ind>$^./.<sent>$
```

Files and data
-------------------------------------------------------------------------------

* [`apertium-dan.dan.dix`](apertium-dan.dan.dix) - Monolingual dictionary
* [`dan.prob`](dan.prob) - Tagger model
* [`apertium-dan.dan.rlx`](apertium-dan.dan.rlx) - Constraint Grammar disambiguation rules
* [`apertium-dan.post-dan.dix`](apertium-dan.post-dan.dix) - Post-generator
* [`apertium-dan.dan.udx`](apertium-dan.dan.udx) - Mappings from Apertium tags to Universal Dependencies features
* [`modes.xml`](modes.xml) - Translation modes

For more information
-------------------------------------------------------------------------------

* https://wiki.apertium.org/wiki/Installation
* https://wiki.apertium.org/wiki/apertium-dan
* https://wiki.apertium.org/wiki/Using_an_lttoolbox_dictionary

Help and support
-------------------------------------------------------------------------------

If you need help using this language pair or data, you can contact:

* Mailing list: apertium-stuff@lists.sourceforge.net
* IRC: `#apertium` on irc.oftc.net (irc://irc.oftc.net/#apertium)

See also the file [`AUTHORS`](AUTHORS), included in this distribution.
