//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdeviceprovisioningservices

const (
	moduleName    = "armdeviceprovisioningservices"
	moduleVersion = "v1.0.0"
)

// AccessRightsDescription - Rights that this key has.
type AccessRightsDescription string

const (
	AccessRightsDescriptionDeviceConnect           AccessRightsDescription = "DeviceConnect"
	AccessRightsDescriptionEnrollmentRead          AccessRightsDescription = "EnrollmentRead"
	AccessRightsDescriptionEnrollmentWrite         AccessRightsDescription = "EnrollmentWrite"
	AccessRightsDescriptionRegistrationStatusRead  AccessRightsDescription = "RegistrationStatusRead"
	AccessRightsDescriptionRegistrationStatusWrite AccessRightsDescription = "RegistrationStatusWrite"
	AccessRightsDescriptionServiceConfig           AccessRightsDescription = "ServiceConfig"
)

// PossibleAccessRightsDescriptionValues returns the possible values for the AccessRightsDescription const type.
func PossibleAccessRightsDescriptionValues() []AccessRightsDescription {
	return []AccessRightsDescription{
		AccessRightsDescriptionDeviceConnect,
		AccessRightsDescriptionEnrollmentRead,
		AccessRightsDescriptionEnrollmentWrite,
		AccessRightsDescriptionRegistrationStatusRead,
		AccessRightsDescriptionRegistrationStatusWrite,
		AccessRightsDescriptionServiceConfig,
	}
}

// AllocationPolicy - Allocation policy to be used by this provisioning service.
type AllocationPolicy string

const (
	AllocationPolicyGeoLatency AllocationPolicy = "GeoLatency"
	AllocationPolicyHashed     AllocationPolicy = "Hashed"
	AllocationPolicyStatic     AllocationPolicy = "Static"
)

// PossibleAllocationPolicyValues returns the possible values for the AllocationPolicy const type.
func PossibleAllocationPolicyValues() []AllocationPolicy {
	return []AllocationPolicy{
		AllocationPolicyGeoLatency,
		AllocationPolicyHashed,
		AllocationPolicyStatic,
	}
}

type CertificatePurpose string

const (
	CertificatePurposeClientAuthentication CertificatePurpose = "clientAuthentication"
	CertificatePurposeServerAuthentication CertificatePurpose = "serverAuthentication"
)

// PossibleCertificatePurposeValues returns the possible values for the CertificatePurpose const type.
func PossibleCertificatePurposeValues() []CertificatePurpose {
	return []CertificatePurpose{
		CertificatePurposeClientAuthentication,
		CertificatePurposeServerAuthentication,
	}
}

// CreatedByType - The type of identity that created the resource.
type CreatedByType string

const (
	CreatedByTypeApplication     CreatedByType = "Application"
	CreatedByTypeKey             CreatedByType = "Key"
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	CreatedByTypeUser            CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns the possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{
		CreatedByTypeApplication,
		CreatedByTypeKey,
		CreatedByTypeManagedIdentity,
		CreatedByTypeUser,
	}
}

// IPFilterActionType - The desired action for requests captured by this rule.
type IPFilterActionType string

const (
	IPFilterActionTypeAccept IPFilterActionType = "Accept"
	IPFilterActionTypeReject IPFilterActionType = "Reject"
)

// PossibleIPFilterActionTypeValues returns the possible values for the IPFilterActionType const type.
func PossibleIPFilterActionTypeValues() []IPFilterActionType {
	return []IPFilterActionType{
		IPFilterActionTypeAccept,
		IPFilterActionTypeReject,
	}
}

// IPFilterTargetType - Target for requests captured by this rule.
type IPFilterTargetType string

const (
	IPFilterTargetTypeAll        IPFilterTargetType = "all"
	IPFilterTargetTypeServiceAPI IPFilterTargetType = "serviceApi"
	IPFilterTargetTypeDeviceAPI  IPFilterTargetType = "deviceApi"
)

// PossibleIPFilterTargetTypeValues returns the possible values for the IPFilterTargetType const type.
func PossibleIPFilterTargetTypeValues() []IPFilterTargetType {
	return []IPFilterTargetType{
		IPFilterTargetTypeAll,
		IPFilterTargetTypeServiceAPI,
		IPFilterTargetTypeDeviceAPI,
	}
}

// IotDpsSKU - Sku name.
type IotDpsSKU string

const (
	IotDpsSKUS1 IotDpsSKU = "S1"
)

// PossibleIotDpsSKUValues returns the possible values for the IotDpsSKU const type.
func PossibleIotDpsSKUValues() []IotDpsSKU {
	return []IotDpsSKU{
		IotDpsSKUS1,
	}
}

// NameUnavailabilityReason - specifies the reason a name is unavailable
type NameUnavailabilityReason string

const (
	NameUnavailabilityReasonAlreadyExists NameUnavailabilityReason = "AlreadyExists"
	NameUnavailabilityReasonInvalid       NameUnavailabilityReason = "Invalid"
)

// PossibleNameUnavailabilityReasonValues returns the possible values for the NameUnavailabilityReason const type.
func PossibleNameUnavailabilityReasonValues() []NameUnavailabilityReason {
	return []NameUnavailabilityReason{
		NameUnavailabilityReasonAlreadyExists,
		NameUnavailabilityReasonInvalid,
	}
}

// PrivateLinkServiceConnectionStatus - The status of a private endpoint connection
type PrivateLinkServiceConnectionStatus string

const (
	PrivateLinkServiceConnectionStatusApproved     PrivateLinkServiceConnectionStatus = "Approved"
	PrivateLinkServiceConnectionStatusDisconnected PrivateLinkServiceConnectionStatus = "Disconnected"
	PrivateLinkServiceConnectionStatusPending      PrivateLinkServiceConnectionStatus = "Pending"
	PrivateLinkServiceConnectionStatusRejected     PrivateLinkServiceConnectionStatus = "Rejected"
)

// PossiblePrivateLinkServiceConnectionStatusValues returns the possible values for the PrivateLinkServiceConnectionStatus const type.
func PossiblePrivateLinkServiceConnectionStatusValues() []PrivateLinkServiceConnectionStatus {
	return []PrivateLinkServiceConnectionStatus{
		PrivateLinkServiceConnectionStatusApproved,
		PrivateLinkServiceConnectionStatusDisconnected,
		PrivateLinkServiceConnectionStatusPending,
		PrivateLinkServiceConnectionStatusRejected,
	}
}

// PublicNetworkAccess - Whether requests from Public Network are allowed
type PublicNetworkAccess string

const (
	PublicNetworkAccessDisabled PublicNetworkAccess = "Disabled"
	PublicNetworkAccessEnabled  PublicNetworkAccess = "Enabled"
)

// PossiblePublicNetworkAccessValues returns the possible values for the PublicNetworkAccess const type.
func PossiblePublicNetworkAccessValues() []PublicNetworkAccess {
	return []PublicNetworkAccess{
		PublicNetworkAccessDisabled,
		PublicNetworkAccessEnabled,
	}
}

// State - Current state of the provisioning service.
type State string

const (
	StateActivating       State = "Activating"
	StateActivationFailed State = "ActivationFailed"
	StateActive           State = "Active"
	StateDeleted          State = "Deleted"
	StateDeleting         State = "Deleting"
	StateDeletionFailed   State = "DeletionFailed"
	StateFailingOver      State = "FailingOver"
	StateFailoverFailed   State = "FailoverFailed"
	StateResuming         State = "Resuming"
	StateSuspended        State = "Suspended"
	StateSuspending       State = "Suspending"
	StateTransitioning    State = "Transitioning"
)

// PossibleStateValues returns the possible values for the State const type.
func PossibleStateValues() []State {
	return []State{
		StateActivating,
		StateActivationFailed,
		StateActive,
		StateDeleted,
		StateDeleting,
		StateDeletionFailed,
		StateFailingOver,
		StateFailoverFailed,
		StateResuming,
		StateSuspended,
		StateSuspending,
		StateTransitioning,
	}
}
