---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# Sensitive cookie without HttpOnly attribute

## Description

The cookie was transmitted in a `Set-Cookie` header without the `HttpOnly` attribute set.
To prevent JavaScript being able to access the cookie value - usually via `document.cookies` - all
cookies that are used for authorization should have the `HttpOnly` attribute
set.

## Remediation

Most web application frameworks allow configuring how cookies are sent to user-agents. Consult your framework's
documentation for more information on how to enable various security directives when assigning cookies to clients.

If the application is assigning cookies via writing to the response headers directly, ensure all responses include
the `HttpOnly` attribute. By enabling this protection, the application is able to mitigate the impact of
certain Cross-Site Scripting (XSS) attacks.

Example:

```http
Set-Cookie: {cookie_name}=<random secure value>; HttpOnly
```

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:--------|:--------|:--------|:--------|
| 1004.1 | false | 1004 | Passive | Low |

## Links

- [OWASP](https://owasp.org/www-community/HttpOnly)
- [CWE](https://cwe.mitre.org/data/definitions/1004.html)
- [Mozilla MDN](https://developer.mozilla.org/en-US/docs/Web/HTTP/Cookies#restrict_access_to_cookies)
