/**
 * JNA-InChI - Library for calling InChI from Java
 * Copyright © 2018 Daniel Lowe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package io.github.dan2097.jnainchi.inchi;
import java.util.Arrays;
import java.util.List;

import com.sun.jna.Structure;
import com.sun.jna.Structure.ByReference;
/**
 * This file was autogenerated by <a href="http://jnaerator.googlecode.com/">JNAerator</a>,<br>
 * a tool written by <a href="http://ochafik.com/">Olivier Chafik</a> that <a href="http://code.google.com/p/jnaerator/wiki/CreditsAndLicense">uses a few opensource projects.</a>.<br>
 * For help, please visit <a href="http://nativelibs4java.googlecode.com/">NativeLibs4Java</a> , <a href="http://rococoa.dev.java.net/">Rococoa</a>, or <a href="http://jna.dev.java.net/">JNA</a>.
 */
public class tagINCHI_Output extends Structure implements ByReference {
  /**
   * InChI ASCIIZ string<br>
   * C type : char*
   */
  public String szInChI;
  /**
   * Aux info ASCIIZ string<br>
   * C type : char*
   */
  public String szAuxInfo;
  /**
   * Error/warning ASCIIZ message<br>
   * C type : char*
   */
  public String szMessage;
  /**
   * log-file ASCIIZ string, contains a human-readable list<br>
   * C type : char*
   */
  public String szLog;

  protected List<String> getFieldOrder() {
    return Arrays.asList("szInChI", "szAuxInfo", "szMessage", "szLog");
  }
  
  public tagINCHI_Output() {
    super();
  }
  
  /**
   * @param szInChI InChI ASCIIZ string<br>
   * C type : char*<br>
   * @param szAuxInfo Aux info ASCIIZ string<br>
   * C type : char*<br>
   * @param szMessage Error/warning ASCIIZ message<br>
   * C type : char*<br>
   * @param szLog log-file ASCIIZ string, contains a human-readable list<br>
   * C type : char*
   */
  public tagINCHI_Output(String szInChI, String szAuxInfo, String szMessage, String szLog) {
    super();
    this.szInChI = szInChI;
    this.szAuxInfo = szAuxInfo;
    this.szMessage = szMessage;
    this.szLog = szLog;
  }

}
