
/*******************************  LICENSE  *******************************

 * (C) Copyright 1996-2016 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \fileMagnifierVisitorAttributes.h
    \brief Definition of MagnifierVisitor Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 
*/
   

#ifndef MagnifierVisitorAttributes_H
#define MagnifierVisitorAttributes_H

#include "magics.h"
#include "Colour.h"
namespace magics {

class XmlNode;
class MagnifierVisitorAttributes 
{
public:
//  --  constructor
    MagnifierVisitorAttributes();
    
//  --  destructor
    virtual ~MagnifierVisitorAttributes();
    
    virtual void set(const std::map<std::string, std::string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const MagnifierVisitorAttributes&);
    virtual bool accept(const std::string&);

    void setTag(const std::string& tag) { tag_ = tag; }

public:
	//  --  method
	virtual void print(std::ostream&) const;
	virtual void toxml(std::ostream& out) const;
	//  --  members:
	string tag_;
	string symbol_name_;
	string hidden_symbol_name_;
	double symbol_height_;
	double hidden_symbol_height_;
	string text_font_name_;
	double text_font_size_;
	string text_format_;
	unique_ptr<Colour> symbol_colour_;
	unique_ptr<Colour> hidden_symbol_colour_;
	unique_ptr<Colour> text_font_colour_;
	 

private:
	friend ostream& operator<<(ostream& s,const MagnifierVisitorAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif

