#pragma once

#include <QString>

#define LIBRARY_TABLE "library"
#define TRACKLOCATIONS_TABLE "track_locations"

const QString LIBRARYTABLE_ID = QStringLiteral("id");
const QString LIBRARYTABLE_ARTIST = QStringLiteral("artist");
const QString LIBRARYTABLE_TITLE = QStringLiteral("title");
const QString LIBRARYTABLE_ALBUM = QStringLiteral("album");
const QString LIBRARYTABLE_ALBUMARTIST = QStringLiteral("album_artist");
const QString LIBRARYTABLE_YEAR = QStringLiteral("year");
const QString LIBRARYTABLE_GENRE = QStringLiteral("genre");
const QString LIBRARYTABLE_COMPOSER = QStringLiteral("composer");
const QString LIBRARYTABLE_GROUPING = QStringLiteral("grouping");
const QString LIBRARYTABLE_TRACKNUMBER = QStringLiteral("tracknumber");
const QString LIBRARYTABLE_FILETYPE = QStringLiteral("filetype");
const QString LIBRARYTABLE_LOCATION_ID = QStringLiteral("location");
const QString LIBRARYTABLE_COMMENT = QStringLiteral("comment");
const QString LIBRARYTABLE_DURATION = QStringLiteral("duration");
const QString LIBRARYTABLE_BITRATE = QStringLiteral("bitrate");
const QString LIBRARYTABLE_BPM = QStringLiteral("bpm");
const QString LIBRARYTABLE_REPLAYGAIN = QStringLiteral("replaygain");
const QString LIBRARYTABLE_CUEPOINT = QStringLiteral("cuepoint");
const QString LIBRARYTABLE_URL = QStringLiteral("url");
const QString LIBRARYTABLE_SAMPLERATE = QStringLiteral("samplerate");
const QString LIBRARYTABLE_WAVESUMMARYHEX = QStringLiteral("wavesummaryhex");
const QString LIBRARYTABLE_CHANNELS = QStringLiteral("channels");
const QString LIBRARYTABLE_MIXXXDELETED = QStringLiteral("mixxx_deleted");
const QString LIBRARYTABLE_DATETIMEADDED = QStringLiteral("datetime_added");
const QString LIBRARYTABLE_HEADERPARSED = QStringLiteral("header_parsed");
const QString LIBRARYTABLE_TIMESPLAYED = QStringLiteral("timesplayed");
const QString LIBRARYTABLE_PLAYED = QStringLiteral("played");
const QString LIBRARYTABLE_RATING = QStringLiteral("rating");
const QString LIBRARYTABLE_KEY = QStringLiteral("key");
const QString LIBRARYTABLE_KEY_ID = QStringLiteral("key_id");
const QString LIBRARYTABLE_BPM_LOCK = QStringLiteral("bpm_lock");
const QString LIBRARYTABLE_PREVIEW = QStringLiteral("preview");
const QString LIBRARYTABLE_COLOR = QStringLiteral("color");
const QString LIBRARYTABLE_COVERART = QStringLiteral("coverart");
const QString LIBRARYTABLE_COVERART_SOURCE = QStringLiteral("coverart_source");
const QString LIBRARYTABLE_COVERART_TYPE = QStringLiteral("coverart_type");
const QString LIBRARYTABLE_COVERART_LOCATION = QStringLiteral("coverart_location");
const QString LIBRARYTABLE_COVERART_HASH = QStringLiteral("coverart_hash");

const QString TRACKLOCATIONSTABLE_ID = QStringLiteral("id");
const QString TRACKLOCATIONSTABLE_LOCATION = QStringLiteral("location");
const QString TRACKLOCATIONSTABLE_FILENAME = QStringLiteral("filename");
const QString TRACKLOCATIONSTABLE_DIRECTORY = QStringLiteral("directory");
const QString TRACKLOCATIONSTABLE_FILESIZE = QStringLiteral("filesize");
const QString TRACKLOCATIONSTABLE_FSDELETED = QStringLiteral("fs_deleted");
const QString TRACKLOCATIONSTABLE_NEEDSVERIFICATION = QStringLiteral("needs_verification");

const QString REKORDBOX_ANALYZE_PATH = "analyze_path";

namespace mixxx {
namespace trackschema {
// TableForColumn returns the name of the table that contains the named column.
QString tableForColumn(const QString& columnName);
} // namespace trackschema
} // namespace mixxx
