# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.resource.policy import PolicyClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestPolicyVariableValuesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(PolicyClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_variable_values_delete(self, resource_group):
        response = self.client.variable_values.delete(
            variable_name="str",
            variable_value_name="str",
            api_version="2022-08-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_variable_values_create_or_update(self, resource_group):
        response = self.client.variable_values.create_or_update(
            variable_name="str",
            variable_value_name="str",
            parameters={
                "values": [{"columnName": "str", "columnValue": {}}],
                "id": "str",
                "name": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
            api_version="2022-08-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_variable_values_get(self, resource_group):
        response = self.client.variable_values.get(
            variable_name="str",
            variable_value_name="str",
            api_version="2022-08-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_variable_values_list(self, resource_group):
        response = self.client.variable_values.list(
            variable_name="str",
            api_version="2022-08-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_variable_values_list_for_management_group(self, resource_group):
        response = self.client.variable_values.list_for_management_group(
            management_group_id="str",
            variable_name="str",
            api_version="2022-08-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_variable_values_delete_at_management_group(self, resource_group):
        response = self.client.variable_values.delete_at_management_group(
            management_group_id="str",
            variable_name="str",
            variable_value_name="str",
            api_version="2022-08-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_variable_values_create_or_update_at_management_group(self, resource_group):
        response = self.client.variable_values.create_or_update_at_management_group(
            management_group_id="str",
            variable_name="str",
            variable_value_name="str",
            parameters={
                "values": [{"columnName": "str", "columnValue": {}}],
                "id": "str",
                "name": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
            api_version="2022-08-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_variable_values_get_at_management_group(self, resource_group):
        response = self.client.variable_values.get_at_management_group(
            management_group_id="str",
            variable_name="str",
            variable_value_name="str",
            api_version="2022-08-01-preview",
        )

        # please add some check logic here by yourself
        # ...
