# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import deserialize
from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class ByocTrunkList(ListResource):

    def __init__(self, version):
        """
        Initialize the ByocTrunkList

        :param Version version: Version that contains the resource

        :returns: twilio.rest.voice.v1.byoc_trunk.ByocTrunkList
        :rtype: twilio.rest.voice.v1.byoc_trunk.ByocTrunkList
        """
        super(ByocTrunkList, self).__init__(version)

        # Path Solution
        self._solution = {}
        self._uri = '/ByocTrunks'.format(**self._solution)

    def create(self, friendly_name=values.unset, voice_url=values.unset,
               voice_method=values.unset, voice_fallback_url=values.unset,
               voice_fallback_method=values.unset, status_callback_url=values.unset,
               status_callback_method=values.unset,
               cnam_lookup_enabled=values.unset, connection_policy_sid=values.unset,
               from_domain_sid=values.unset):
        """
        Create the ByocTrunkInstance

        :param unicode friendly_name: A string to describe the resource
        :param unicode voice_url: The URL we should call when receiving a call
        :param unicode voice_method: The HTTP method to use with voice_url
        :param unicode voice_fallback_url: The URL we should call when an error occurs in executing TwiML
        :param unicode voice_fallback_method: The HTTP method to use with voice_fallback_url
        :param unicode status_callback_url: The URL that we should call to pass status updates
        :param unicode status_callback_method: The HTTP method we should use to call `status_callback_url`
        :param bool cnam_lookup_enabled: Whether Caller ID Name (CNAM) lookup is enabled for the trunk
        :param unicode connection_policy_sid: Origination Connection Policy (to your Carrier)
        :param unicode from_domain_sid: The SID of the SIP Domain that should be used in the `From` header of originating calls

        :returns: The created ByocTrunkInstance
        :rtype: twilio.rest.voice.v1.byoc_trunk.ByocTrunkInstance
        """
        data = values.of({
            'FriendlyName': friendly_name,
            'VoiceUrl': voice_url,
            'VoiceMethod': voice_method,
            'VoiceFallbackUrl': voice_fallback_url,
            'VoiceFallbackMethod': voice_fallback_method,
            'StatusCallbackUrl': status_callback_url,
            'StatusCallbackMethod': status_callback_method,
            'CnamLookupEnabled': cnam_lookup_enabled,
            'ConnectionPolicySid': connection_policy_sid,
            'FromDomainSid': from_domain_sid,
        })

        payload = self._version.create(method='POST', uri=self._uri, data=data, )

        return ByocTrunkInstance(self._version, payload, )

    def stream(self, limit=None, page_size=None):
        """
        Streams ByocTrunkInstance records from the API as a generator stream.
        This operation lazily loads records as efficiently as possible until the limit
        is reached.
        The results are returned as a generator, so this operation is memory efficient.

        :param int limit: Upper limit for the number of records to return. stream()
                          guarantees to never return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, stream() will attempt to read the
                              limit with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.voice.v1.byoc_trunk.ByocTrunkInstance]
        """
        limits = self._version.read_limits(limit, page_size)

        page = self.page(page_size=limits['page_size'], )

        return self._version.stream(page, limits['limit'])

    def list(self, limit=None, page_size=None):
        """
        Lists ByocTrunkInstance records from the API as a list.
        Unlike stream(), this operation is eager and will load `limit` records into
        memory before returning.

        :param int limit: Upper limit for the number of records to return. list() guarantees
                          never to return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, list() will attempt to read the limit
                              with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.voice.v1.byoc_trunk.ByocTrunkInstance]
        """
        return list(self.stream(limit=limit, page_size=page_size, ))

    def page(self, page_token=values.unset, page_number=values.unset,
             page_size=values.unset):
        """
        Retrieve a single page of ByocTrunkInstance records from the API.
        Request is executed immediately

        :param str page_token: PageToken provided by the API
        :param int page_number: Page Number, this value is simply for client state
        :param int page_size: Number of records to return, defaults to 50

        :returns: Page of ByocTrunkInstance
        :rtype: twilio.rest.voice.v1.byoc_trunk.ByocTrunkPage
        """
        data = values.of({'PageToken': page_token, 'Page': page_number, 'PageSize': page_size, })

        response = self._version.page(method='GET', uri=self._uri, params=data, )

        return ByocTrunkPage(self._version, response, self._solution)

    def get_page(self, target_url):
        """
        Retrieve a specific page of ByocTrunkInstance records from the API.
        Request is executed immediately

        :param str target_url: API-generated URL for the requested results page

        :returns: Page of ByocTrunkInstance
        :rtype: twilio.rest.voice.v1.byoc_trunk.ByocTrunkPage
        """
        response = self._version.domain.twilio.request(
            'GET',
            target_url,
        )

        return ByocTrunkPage(self._version, response, self._solution)

    def get(self, sid):
        """
        Constructs a ByocTrunkContext

        :param sid: The unique string that identifies the resource

        :returns: twilio.rest.voice.v1.byoc_trunk.ByocTrunkContext
        :rtype: twilio.rest.voice.v1.byoc_trunk.ByocTrunkContext
        """
        return ByocTrunkContext(self._version, sid=sid, )

    def __call__(self, sid):
        """
        Constructs a ByocTrunkContext

        :param sid: The unique string that identifies the resource

        :returns: twilio.rest.voice.v1.byoc_trunk.ByocTrunkContext
        :rtype: twilio.rest.voice.v1.byoc_trunk.ByocTrunkContext
        """
        return ByocTrunkContext(self._version, sid=sid, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Voice.V1.ByocTrunkList>'


class ByocTrunkPage(Page):

    def __init__(self, version, response, solution):
        """
        Initialize the ByocTrunkPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API

        :returns: twilio.rest.voice.v1.byoc_trunk.ByocTrunkPage
        :rtype: twilio.rest.voice.v1.byoc_trunk.ByocTrunkPage
        """
        super(ByocTrunkPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of ByocTrunkInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.voice.v1.byoc_trunk.ByocTrunkInstance
        :rtype: twilio.rest.voice.v1.byoc_trunk.ByocTrunkInstance
        """
        return ByocTrunkInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Voice.V1.ByocTrunkPage>'


class ByocTrunkContext(InstanceContext):

    def __init__(self, version, sid):
        """
        Initialize the ByocTrunkContext

        :param Version version: Version that contains the resource
        :param sid: The unique string that identifies the resource

        :returns: twilio.rest.voice.v1.byoc_trunk.ByocTrunkContext
        :rtype: twilio.rest.voice.v1.byoc_trunk.ByocTrunkContext
        """
        super(ByocTrunkContext, self).__init__(version)

        # Path Solution
        self._solution = {'sid': sid, }
        self._uri = '/ByocTrunks/{sid}'.format(**self._solution)

    def fetch(self):
        """
        Fetch the ByocTrunkInstance

        :returns: The fetched ByocTrunkInstance
        :rtype: twilio.rest.voice.v1.byoc_trunk.ByocTrunkInstance
        """
        payload = self._version.fetch(method='GET', uri=self._uri, )

        return ByocTrunkInstance(self._version, payload, sid=self._solution['sid'], )

    def update(self, friendly_name=values.unset, voice_url=values.unset,
               voice_method=values.unset, voice_fallback_url=values.unset,
               voice_fallback_method=values.unset, status_callback_url=values.unset,
               status_callback_method=values.unset,
               cnam_lookup_enabled=values.unset, connection_policy_sid=values.unset,
               from_domain_sid=values.unset):
        """
        Update the ByocTrunkInstance

        :param unicode friendly_name: A string to describe the resource
        :param unicode voice_url: The URL we should call when receiving a call
        :param unicode voice_method: The HTTP method we should use with voice_url
        :param unicode voice_fallback_url: The URL we should call when an error occurs in executing TwiML
        :param unicode voice_fallback_method: The HTTP method used with voice_fallback_url
        :param unicode status_callback_url: The URL that we should call to pass status updates
        :param unicode status_callback_method: The HTTP method we should use to call status_callback_url
        :param bool cnam_lookup_enabled: Whether Caller ID Name (CNAM) lookup is enabled for the trunk
        :param unicode connection_policy_sid: Origination Connection Policy (to your Carrier)
        :param unicode from_domain_sid: The SID of the SIP Domain that should be used in the `From` header of originating calls

        :returns: The updated ByocTrunkInstance
        :rtype: twilio.rest.voice.v1.byoc_trunk.ByocTrunkInstance
        """
        data = values.of({
            'FriendlyName': friendly_name,
            'VoiceUrl': voice_url,
            'VoiceMethod': voice_method,
            'VoiceFallbackUrl': voice_fallback_url,
            'VoiceFallbackMethod': voice_fallback_method,
            'StatusCallbackUrl': status_callback_url,
            'StatusCallbackMethod': status_callback_method,
            'CnamLookupEnabled': cnam_lookup_enabled,
            'ConnectionPolicySid': connection_policy_sid,
            'FromDomainSid': from_domain_sid,
        })

        payload = self._version.update(method='POST', uri=self._uri, data=data, )

        return ByocTrunkInstance(self._version, payload, sid=self._solution['sid'], )

    def delete(self):
        """
        Deletes the ByocTrunkInstance

        :returns: True if delete succeeds, False otherwise
        :rtype: bool
        """
        return self._version.delete(method='DELETE', uri=self._uri, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Voice.V1.ByocTrunkContext {}>'.format(context)


class ByocTrunkInstance(InstanceResource):

    def __init__(self, version, payload, sid=None):
        """
        Initialize the ByocTrunkInstance

        :returns: twilio.rest.voice.v1.byoc_trunk.ByocTrunkInstance
        :rtype: twilio.rest.voice.v1.byoc_trunk.ByocTrunkInstance
        """
        super(ByocTrunkInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'account_sid': payload.get('account_sid'),
            'sid': payload.get('sid'),
            'friendly_name': payload.get('friendly_name'),
            'voice_url': payload.get('voice_url'),
            'voice_method': payload.get('voice_method'),
            'voice_fallback_url': payload.get('voice_fallback_url'),
            'voice_fallback_method': payload.get('voice_fallback_method'),
            'status_callback_url': payload.get('status_callback_url'),
            'status_callback_method': payload.get('status_callback_method'),
            'cnam_lookup_enabled': payload.get('cnam_lookup_enabled'),
            'connection_policy_sid': payload.get('connection_policy_sid'),
            'from_domain_sid': payload.get('from_domain_sid'),
            'date_created': deserialize.iso8601_datetime(payload.get('date_created')),
            'date_updated': deserialize.iso8601_datetime(payload.get('date_updated')),
            'url': payload.get('url'),
        }

        # Context
        self._context = None
        self._solution = {'sid': sid or self._properties['sid'], }

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: ByocTrunkContext for this ByocTrunkInstance
        :rtype: twilio.rest.voice.v1.byoc_trunk.ByocTrunkContext
        """
        if self._context is None:
            self._context = ByocTrunkContext(self._version, sid=self._solution['sid'], )
        return self._context

    @property
    def account_sid(self):
        """
        :returns: The SID of the Account that created the resource
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def sid(self):
        """
        :returns: The unique string that identifies the resource
        :rtype: unicode
        """
        return self._properties['sid']

    @property
    def friendly_name(self):
        """
        :returns: The string that you assigned to describe the resource
        :rtype: unicode
        """
        return self._properties['friendly_name']

    @property
    def voice_url(self):
        """
        :returns: The URL we call when receiving a call
        :rtype: unicode
        """
        return self._properties['voice_url']

    @property
    def voice_method(self):
        """
        :returns: The HTTP method to use with voice_url
        :rtype: unicode
        """
        return self._properties['voice_method']

    @property
    def voice_fallback_url(self):
        """
        :returns: The URL we call when an error occurs while executing TwiML
        :rtype: unicode
        """
        return self._properties['voice_fallback_url']

    @property
    def voice_fallback_method(self):
        """
        :returns: The HTTP method used with voice_fallback_url
        :rtype: unicode
        """
        return self._properties['voice_fallback_method']

    @property
    def status_callback_url(self):
        """
        :returns: The URL that we call with status updates
        :rtype: unicode
        """
        return self._properties['status_callback_url']

    @property
    def status_callback_method(self):
        """
        :returns: The HTTP method we use to call status_callback_url
        :rtype: unicode
        """
        return self._properties['status_callback_method']

    @property
    def cnam_lookup_enabled(self):
        """
        :returns: Whether Caller ID Name (CNAM) lookup is enabled for the trunk
        :rtype: bool
        """
        return self._properties['cnam_lookup_enabled']

    @property
    def connection_policy_sid(self):
        """
        :returns: Origination Connection Policy (to your Carrier)
        :rtype: unicode
        """
        return self._properties['connection_policy_sid']

    @property
    def from_domain_sid(self):
        """
        :returns: The SID of the SIP Domain that should be used in the `From` header of originating calls
        :rtype: unicode
        """
        return self._properties['from_domain_sid']

    @property
    def date_created(self):
        """
        :returns: The RFC 2822 date and time in GMT that the resource was created
        :rtype: datetime
        """
        return self._properties['date_created']

    @property
    def date_updated(self):
        """
        :returns: The RFC 2822 date and time in GMT that the resource was last updated
        :rtype: datetime
        """
        return self._properties['date_updated']

    @property
    def url(self):
        """
        :returns: The absolute URL of the resource
        :rtype: unicode
        """
        return self._properties['url']

    def fetch(self):
        """
        Fetch the ByocTrunkInstance

        :returns: The fetched ByocTrunkInstance
        :rtype: twilio.rest.voice.v1.byoc_trunk.ByocTrunkInstance
        """
        return self._proxy.fetch()

    def update(self, friendly_name=values.unset, voice_url=values.unset,
               voice_method=values.unset, voice_fallback_url=values.unset,
               voice_fallback_method=values.unset, status_callback_url=values.unset,
               status_callback_method=values.unset,
               cnam_lookup_enabled=values.unset, connection_policy_sid=values.unset,
               from_domain_sid=values.unset):
        """
        Update the ByocTrunkInstance

        :param unicode friendly_name: A string to describe the resource
        :param unicode voice_url: The URL we should call when receiving a call
        :param unicode voice_method: The HTTP method we should use with voice_url
        :param unicode voice_fallback_url: The URL we should call when an error occurs in executing TwiML
        :param unicode voice_fallback_method: The HTTP method used with voice_fallback_url
        :param unicode status_callback_url: The URL that we should call to pass status updates
        :param unicode status_callback_method: The HTTP method we should use to call status_callback_url
        :param bool cnam_lookup_enabled: Whether Caller ID Name (CNAM) lookup is enabled for the trunk
        :param unicode connection_policy_sid: Origination Connection Policy (to your Carrier)
        :param unicode from_domain_sid: The SID of the SIP Domain that should be used in the `From` header of originating calls

        :returns: The updated ByocTrunkInstance
        :rtype: twilio.rest.voice.v1.byoc_trunk.ByocTrunkInstance
        """
        return self._proxy.update(
            friendly_name=friendly_name,
            voice_url=voice_url,
            voice_method=voice_method,
            voice_fallback_url=voice_fallback_url,
            voice_fallback_method=voice_fallback_method,
            status_callback_url=status_callback_url,
            status_callback_method=status_callback_method,
            cnam_lookup_enabled=cnam_lookup_enabled,
            connection_policy_sid=connection_policy_sid,
            from_domain_sid=from_domain_sid,
        )

    def delete(self):
        """
        Deletes the ByocTrunkInstance

        :returns: True if delete succeeds, False otherwise
        :rtype: bool
        """
        return self._proxy.delete()

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Voice.V1.ByocTrunkInstance {}>'.format(context)
