% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{ranking}
\alias{ranking}
\alias{ranking.vsel}
\title{Predictor ranking(s)}
\usage{
ranking(object, ...)

\method{ranking}{vsel}(object, nterms_max = NULL, ...)
}
\arguments{
\item{object}{The object from which to retrieve the predictor ranking(s).
Possible classes may be inferred from the names of the corresponding
methods (see also the description).}

\item{...}{Currently ignored.}

\item{nterms_max}{Maximum submodel size (number of predictor terms) for the
predictor ranking(s), i.e., the submodel size at which to cut off the
predictor ranking(s). Using \code{NULL} is effectively the same as setting
\code{nterms_max} to the full model size, i.e., this means to not cut off the
predictor ranking(s) at all. Note that \code{nterms_max} does not count the
intercept, so \code{nterms_max = 1} corresponds to the submodel consisting of
the first (non-intercept) predictor term.}
}
\value{
An object of class \code{ranking} which is a \code{list} with the following
elements:
\itemize{
\item \code{fulldata}: The predictor ranking from the full-data search.
\item \code{foldwise}: The predictor rankings from the fold-wise
searches in the form of a character matrix (only available if \code{object} is
based on a CV with fold-wise searches, otherwise element \code{foldwise} is
\code{NULL}). The rows of this matrix correspond to the CV folds and the columns
to the submodel sizes. Each row contains the predictor ranking from the
search of that CV fold.
}
}
\description{
Extracts the \emph{predictor ranking(s)} from an object of class \code{vsel} (returned
by \code{\link[=varsel]{varsel()}} or \code{\link[=cv_varsel]{cv_varsel()}}). A predictor ranking is simply a character
vector of predictor terms ranked by predictive relevance (with the most
relevant term first). In any case, objects of class \code{vsel} contain the
predictor ranking based on the \emph{full-data} search. If an object of class
\code{vsel} is based on a cross-validation (CV) with fold-wise searches (i.e., if
it was created by \code{\link[=cv_varsel]{cv_varsel()}} with \code{validate_search = TRUE}), then it also
contains \emph{fold-wise} predictor rankings.
}
\examples{
# For an example, see `?plot.cv_proportions`.

}
\seealso{
\code{\link[=cv_proportions]{cv_proportions()}}
}
