An intrinsic was declared without being a function.

Erroneous code example:

```compile_fail,E0622
#![feature(intrinsics)]
extern "rust-intrinsic" {
    pub static breakpoint : fn(); // error: intrinsic must be a function
}

fn main() { unsafe { breakpoint(); } }
```

An intrinsic is a function available for use in a given programming language
whose implementation is handled specially by the compiler. In order to fix this
error, just declare a function. Example:

```no_run
#![feature(intrinsics)]
extern "rust-intrinsic" {
    pub fn breakpoint(); // ok!
}

fn main() { unsafe { breakpoint(); } }
```
