/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize;

import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.info.ClassOptimizationInfo;
import proguard.optimize.info.CodeAttributeOptimizationInfo;
import proguard.optimize.info.FieldOptimizationInfo;
import proguard.optimize.info.MethodOptimizationInfo;

public class KeepMarker
extends SimplifiedVisitor
implements ClassVisitor,
MemberVisitor,
AttributeVisitor {
    @Override
    public void visitProgramClass(ProgramClass programClass) {
        ClassOptimizationInfo.setClassOptimizationInfo(programClass);
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
        ClassOptimizationInfo.setClassOptimizationInfo(libraryClass);
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        FieldOptimizationInfo.setFieldOptimizationInfo(programClass, programField);
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        MethodOptimizationInfo.setMethodOptimizationInfo(programClass, programMethod);
    }

    @Override
    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        FieldOptimizationInfo.setFieldOptimizationInfo(libraryClass, libraryField);
    }

    @Override
    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        MethodOptimizationInfo.setMethodOptimizationInfo(libraryClass, libraryMethod);
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        CodeAttributeOptimizationInfo.setCodeAttributeOptimizationInfo(codeAttribute);
    }

    public static boolean isKept(Clazz clazz) {
        ClassOptimizationInfo classOptimizationInfo = ClassOptimizationInfo.getClassOptimizationInfo(clazz);
        return classOptimizationInfo != null && classOptimizationInfo.isKept();
    }

    public static boolean isKept(Field field) {
        FieldOptimizationInfo fieldOptimizationInfo = FieldOptimizationInfo.getFieldOptimizationInfo(field);
        return fieldOptimizationInfo != null && fieldOptimizationInfo.isKept();
    }

    public static boolean isKept(Method method) {
        MethodOptimizationInfo methodOptimizationInfo = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        return methodOptimizationInfo != null && methodOptimizationInfo.isKept();
    }

    public static boolean isKept(CodeAttribute codeAttribute) {
        CodeAttributeOptimizationInfo codeAttributeOptimizationInfo = CodeAttributeOptimizationInfo.getCodeAttributeOptimizationInfo(codeAttribute);
        return codeAttributeOptimizationInfo != null && codeAttributeOptimizationInfo.isKept();
    }
}

