/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui;

import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.model.Executable;
import com.nvidia.viper.ui.ExecutableAdvancedOptionsDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ExecutableAdvancedOptionsPropertyControl
extends Composite {
    private Button advanced;
    private Text deviceBuffersizeText;
    private Text cdpBuffersizeText;
    private Executable executable;

    public ExecutableAdvancedOptionsPropertyControl(Composite parent, int style, boolean openDialog) {
        super(parent, style);
        if (openDialog) {
            this.advanced = new Button((Composite)this, 8);
            this.advanced.setText("Advanced...");
            this.advanced.setLayoutData((Object)new GridData(136));
            this.advanced.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ExecutableAdvancedOptionsDialog dialog = new ExecutableAdvancedOptionsDialog(ExecutableAdvancedOptionsPropertyControl.this.getShell(), (ExecutableAdvancedOptionsPropertyControl)ExecutableAdvancedOptionsPropertyControl.this.advanced.getParent());
                    if (dialog.open() == 0) {
                        ExecutableAdvancedOptionsPropertyControl.this.executable.setCDPBuffersize(Integer.parseInt(ExecutableAdvancedOptionsPropertyControl.this.deviceBuffersizeText.getText()));
                        ExecutableAdvancedOptionsPropertyControl.this.executable.setDeviceBuffersize(Integer.parseInt(ExecutableAdvancedOptionsPropertyControl.this.cdpBuffersizeText.getText()));
                    } else {
                        ExecutableAdvancedOptionsPropertyControl.this.executable.setDefaultAdvancedOptions();
                    }
                }
            });
        } else {
            GridLayout mainLayout = new GridLayout(2, false);
            mainLayout.marginWidth = 0;
            mainLayout.marginHeight = 0;
            this.setLayout((Layout)mainLayout);
            this.createDeviceBufferSizeText(this);
            this.createCDPBufferSizeText(this);
        }
    }

    public void createDeviceBufferSizeText(Composite container) {
        Label labelDeviceBuffersize = new Label(container, 0);
        labelDeviceBuffersize.setText(ViperMessages.Device_Buffersize_Message);
        this.deviceBuffersizeText = this.createText(container);
        if (this.executable != null) {
            this.deviceBuffersizeText.setText(String.valueOf(this.executable.getDeviceBuffersize()));
        }
        this.deviceBuffersizeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = ExecutableAdvancedOptionsPropertyControl.this.deviceBuffersizeText.getText();
                if (!text.isEmpty() && ExecutableAdvancedOptionsPropertyControl.this.executable != null) {
                    ExecutableAdvancedOptionsPropertyControl.this.executable.setDeviceBuffersize(Integer.parseInt(ExecutableAdvancedOptionsPropertyControl.this.deviceBuffersizeText.getText()));
                }
            }
        });
    }

    public void createCDPBufferSizeText(Composite container) {
        Label labelCDPBuffersize = new Label(container, 0);
        labelCDPBuffersize.setText(ViperMessages.Cdp_Buffersize_Message);
        this.cdpBuffersizeText = this.createText(container);
        if (this.executable != null) {
            this.cdpBuffersizeText.setText(String.valueOf(this.executable.getCDPBuffersize()));
        }
        this.cdpBuffersizeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = ExecutableAdvancedOptionsPropertyControl.this.cdpBuffersizeText.getText();
                if (!text.isEmpty() && ExecutableAdvancedOptionsPropertyControl.this.executable != null) {
                    ExecutableAdvancedOptionsPropertyControl.this.executable.setCDPBuffersize(Integer.parseInt(ExecutableAdvancedOptionsPropertyControl.this.cdpBuffersizeText.getText()));
                }
            }
        });
    }

    private Text createText(Composite container) {
        GridData data = new GridData();
        data.widthHint = 50;
        data.horizontalAlignment = 4;
        Text text = new Text(container, 2048);
        text.setLayoutData((Object)data);
        text.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = e.text.isEmpty() ? true : e.text.matches("[0-9]+");
            }
        });
        return text;
    }

    public void setInput(Executable exec) {
        this.executable = exec;
        if (this.cdpBuffersizeText != null) {
            this.cdpBuffersizeText.setText(String.valueOf(this.executable.getCDPBuffersize()));
        }
        if (this.deviceBuffersizeText != null) {
            this.deviceBuffersizeText.setText(String.valueOf(this.executable.getDeviceBuffersize()));
        }
    }

    public void refresh() {
        this.deviceBuffersizeText.setText(this.executable == null ? "" : Integer.toString(this.executable.getDeviceBuffersize()));
        this.cdpBuffersizeText.setText(this.executable == null ? "" : Integer.toString(this.executable.getCDPBuffersize()));
    }
}

