/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui.chart;

import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.analysis.OccupancyCalculator;
import com.nvidia.viper.model.TimelineIntervalKernel;
import com.nvidia.viper.ui.chart.AbstractOccupancyChart;

public final class RegisterBoundOccupancyChart
extends AbstractOccupancyChart {
    private final String[] points = new String[256];
    private final Double[] warpsActual = new Double[this.points.length];
    private final Double[] warpsTheoretical = new Double[this.points.length];

    public RegisterBoundOccupancyChart(TimelineIntervalKernel kernel, OccupancyCalculator calculator, boolean highlight) throws ViperException {
        super(calculator.getDeviceTimeline().getMaxWarpsPerMultiprocessor(), highlight);
        int i = 0;
        while (i < this.points.length) {
            Double warps = calculator.getWarpsPerSMForRegistersPerThread(i).doubleValue();
            this.points[i] = String.valueOf(i);
            this.warpsActual[i] = null;
            this.warpsTheoretical[i] = warps;
            ++i;
        }
        this.warpsActual[kernel.getRegistersPerThread().intValue()] = this.warpsTheoretical[kernel.getRegistersPerThread()];
    }

    public String getTitle() {
        return ViperMessages.Chart_Register_Title;
    }

    @Override
    public String getXAxisTitle() {
        return ViperMessages.Chart_Register_XAxis;
    }

    @Override
    public String getYAxisTitle() {
        return null;
    }

    public String[] getLabels() {
        return this.points;
    }

    @Override
    public Integer getVerticalLineStep() {
        return 4;
    }

    @Override
    public boolean isZeroBased() {
        return true;
    }

    @Override
    protected Double[] getActualPlotData() {
        return this.warpsActual;
    }

    @Override
    protected Double[] getTheoreticalPlotData() {
        return this.warpsTheoretical;
    }
}

