/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.application;

import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.application.ApplicationWorkbenchAdvisor;
import com.nvidia.viper.ui.ViperMessageDialog;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.ide.ChooseWorkspaceData;
import org.eclipse.ui.internal.ide.ChooseWorkspaceDialog;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class Application
implements IApplication {
    public Object start(IApplicationContext context) {
        Display display = PlatformUI.createDisplay();
        Location instanceLoc = Platform.getInstanceLocation();
        new ScopedPreferenceStore((IScopeContext)new ConfigurationScope(), "org.eclipse.ui.ide");
        boolean doNotShow = true;
        if (!doNotShow) {
            MessageDialogWithToggle messageDialog = MessageDialogWithToggle.openWarning((Shell)display.getActiveShell(), (String)"Deprecated", (String)"Visual Profiler will be deprecated in a future CUDA release. It is recommended to use next-generation tools NVIDIA Nsight Compute for GPU profiling and NVIDIA Nsight Systems for GPU and CPU sampling and tracing", (String)"Do not show this message again", (boolean)doNotShow, null, null);
            boolean state = messageDialog.getToggleState();
            IEclipsePreferences node = new ConfigurationScope().getNode("org.eclipse.ui.ide");
            node.putBoolean("DoNotShowDeprecatedMessage", state);
        }
        URL url = this.getURL(new File(System.getProperty("user.home"), "nvvp_workspace"));
        ChooseWorkspaceData launchData = new ChooseWorkspaceData(url);
        WorkspaceDialog dialog = new WorkspaceDialog(display.getActiveShell(), launchData, false, true);
        boolean force = false;
        while (true) {
            dialog.prompt(force);
            String selection = launchData.getSelection();
            if (selection == null) break;
            force = true;
            try {
                url = this.getURL(new File(selection));
                if (url == null) continue;
                if (instanceLoc.set(url, true)) {
                    launchData.writePersistedData();
                    break;
                }
                ViperMessageDialog.openError((Shell)WorkbenchPlugin.getSplashShell((Display)display), (String)"Workspace Unavailable", (String)String.format("The default workspace '%s' is in use or cannot be created. Please choose a different one.", selection));
            }
            catch (Exception e) {
                ViperExceptionHandler.logError((String)e.getMessage());
            }
        }
        try {
            int returnCode;
            if (launchData.getSelection() != null && !launchData.getSelection().isEmpty() && (returnCode = PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)new ApplicationWorkbenchAdvisor())) == 1) {
                Integer n = IApplication.EXIT_RESTART;
                return n;
            }
            Integer n = IApplication.EXIT_OK;
            return n;
        }
        finally {
            display.dispose();
            if (instanceLoc != null) {
                instanceLoc.release();
            }
        }
    }

    private URL getURL(File file) {
        if (!file.exists()) {
            file.mkdir();
        }
        URL url = null;
        try {
            String path = file.getAbsolutePath().replace(File.separatorChar, '/');
            url = new URL("file", null, path);
        }
        catch (MalformedURLException e) {
            ViperExceptionHandler.logError((String)e.getMessage());
        }
        return url;
    }

    public void stop() {
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        final IWorkbench workbench = PlatformUI.getWorkbench();
        final Display display = workbench.getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (!display.isDisposed()) {
                    workbench.close();
                }
            }
        });
    }

    class WorkspaceDialog
    extends ChooseWorkspaceDialog {
        public WorkspaceDialog(Shell parentShell, ChooseWorkspaceData launchData, boolean suppressAskAgain, boolean centerOnMonitor) {
            super(parentShell, launchData, suppressAskAgain, centerOnMonitor);
        }

        protected Control createDialogArea(Composite parent) {
            Control control = super.createDialogArea(parent);
            this.setMessage(ViperMessages.WorkspaceLauncher_Message);
            return control;
        }
    }
}

