/*
 *
 *  BlueZ - Bluetooth protocol stack for Linux
 *
 *  Copyright (C) 2009  Bastien Nocera <hadess@hadess.net>
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#include <string.h>

#include "bluetooth-client.h"
#include "bluetooth-client-private.h"
#include "bluetooth-utils.h"

static const char *
byte_to_binary (int x)
{
	static char b[9] = {0};

	int z;
	for (z = 256; z > 0; z >>= 1) {
		strcat(b, ((x & z) == z) ? "1" : "0");
	}

	return b;
}

int main(int argc, char *argv[])
{
	GLogLevelFlags fatal_mask;
	guint class;

	fatal_mask = g_log_set_always_fatal (G_LOG_FATAL_MASK);
	fatal_mask |= G_LOG_LEVEL_WARNING | G_LOG_LEVEL_CRITICAL;
	g_log_set_always_fatal (fatal_mask);

	class = g_ascii_strtoull (argv[1], NULL, 0);

	g_message ("device class: 0x%X", class);
	g_message ("major class: 0x%X %s", (class & 0x1f00) >> 8, byte_to_binary ((class & 0x1f00) >> 8));

	g_message ("%d %s", bluetooth_class_to_type (class), bluetooth_type_to_string (bluetooth_class_to_type (class)));

	return 0;
}
