; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -global-isel -march=amdgcn -mcpu=gfx906 -verify-machineinstrs < %s | FileCheck --check-prefix=GFX906 %s
; RUN: llc -global-isel -march=amdgcn -mcpu=gfx908 -verify-machineinstrs < %s | FileCheck --check-prefix=GFX908 %s
; RUN: llc -global-isel -march=amdgcn -mcpu=gfx1011 -verify-machineinstrs < %s | FileCheck --check-prefix=GFX10 %s
; RUN: llc -global-isel -march=amdgcn -mcpu=gfx1012 -verify-machineinstrs < %s | FileCheck --check-prefix=GFX10 %s

define i32 @v_udot2(<2 x i16> %a, <2 x i16> %b, i32 %c) {
; GFX906-LABEL: v_udot2:
; GFX906:       ; %bb.0:
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    v_dot2_u32_u16 v0, v0, v1, v2
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: v_udot2:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_dot2_u32_u16 v0, v0, v1, v2
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_udot2:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_dot2_u32_u16 v0, v0, v1, v2
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %r = call i32 @llvm.amdgcn.udot2(<2 x i16> %a, <2 x i16> %b, i32 %c, i1 false)
  ret i32 %r
}

define i32 @v_udot2_clamp(<2 x i16> %a, <2 x i16> %b, i32 %c) {
; GFX906-LABEL: v_udot2_clamp:
; GFX906:       ; %bb.0:
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    v_dot2_u32_u16 v0, v0, v1, v2 clamp
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: v_udot2_clamp:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_dot2_u32_u16 v0, v0, v1, v2 clamp
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_udot2_clamp:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_dot2_u32_u16 v0, v0, v1, v2 clamp
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %r = call i32 @llvm.amdgcn.udot2(<2 x i16> %a, <2 x i16> %b, i32 %c, i1 true)
  ret i32 %r
}

define amdgpu_ps float @v_udot2_sgpr_sgpr_sgpr(<2 x i16> inreg %a, <2 x i16> inreg %b, i32 inreg %c) {
; GFX906-LABEL: v_udot2_sgpr_sgpr_sgpr:
; GFX906:       ; %bb.0:
; GFX906-NEXT:    v_mov_b32_e32 v0, s1
; GFX906-NEXT:    v_mov_b32_e32 v1, s2
; GFX906-NEXT:    v_dot2_u32_u16 v0, s0, v0, v1
; GFX906-NEXT:    ; return to shader part epilog
;
; GFX908-LABEL: v_udot2_sgpr_sgpr_sgpr:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    v_mov_b32_e32 v0, s1
; GFX908-NEXT:    v_mov_b32_e32 v1, s2
; GFX908-NEXT:    v_dot2_u32_u16 v0, s0, v0, v1
; GFX908-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: v_udot2_sgpr_sgpr_sgpr:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_mov_b32_e32 v0, s2
; GFX10-NEXT:    v_dot2_u32_u16 v0, s0, s1, v0
; GFX10-NEXT:    ; return to shader part epilog
  %r = call i32 @llvm.amdgcn.udot2(<2 x i16> %a, <2 x i16> %b, i32 %c, i1 false)
  %cast = bitcast i32 %r to float
  ret float %cast
}

define i32 @v_udot2_inline_literal_a(<2 x i16> %b, i32 %c) {
; GFX906-LABEL: v_udot2_inline_literal_a:
; GFX906:       ; %bb.0:
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    v_dot2_u32_u16 v0, 4, v0, v1 op_sel_hi:[0,1,1]
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: v_udot2_inline_literal_a:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_dot2_u32_u16 v0, 4, v0, v1 op_sel_hi:[0,1,1]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_udot2_inline_literal_a:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_dot2_u32_u16 v0, 4, v0, v1 op_sel_hi:[0,1,1]
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %r = call i32 @llvm.amdgcn.udot2(<2 x i16> <i16 4, i16 4>, <2 x i16> %b, i32 %c, i1 false)
  ret i32 %r
}

define i32 @v_udot2_inline_literal_b(<2 x i16> %a, i32 %c) {
; GFX906-LABEL: v_udot2_inline_literal_b:
; GFX906:       ; %bb.0:
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    v_dot2_u32_u16 v0, v0, 4, v1 op_sel_hi:[1,0,1]
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: v_udot2_inline_literal_b:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_dot2_u32_u16 v0, v0, 4, v1 op_sel_hi:[1,0,1]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_udot2_inline_literal_b:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_dot2_u32_u16 v0, v0, 4, v1 op_sel_hi:[1,0,1]
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %r = call i32 @llvm.amdgcn.udot2(<2 x i16> %a, <2 x i16> <i16 4, i16 4>, i32 %c, i1 false)
  ret i32 %r
}

define i32 @v_udot2_inline_literal_a_b(<2 x i16> %a, i32 %c) {
; GFX906-LABEL: v_udot2_inline_literal_a_b:
; GFX906:       ; %bb.0:
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    v_dot2_u32_u16 v0, 8, 4, v1 op_sel_hi:[0,0,1]
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: v_udot2_inline_literal_a_b:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_dot2_u32_u16 v0, 8, 4, v1 op_sel_hi:[0,0,1]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_udot2_inline_literal_a_b:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_dot2_u32_u16 v0, 8, 4, v1 op_sel_hi:[0,0,1]
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %r = call i32 @llvm.amdgcn.udot2(<2 x i16> <i16 8, i16 8>, <2 x i16> <i16 4, i16 4>, i32 %c, i1 false)
  ret i32 %r
}

define i32 @v_udot2_inline_literal_a_b_c() {
; GFX906-LABEL: v_udot2_inline_literal_a_b_c:
; GFX906:       ; %bb.0:
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    v_dot2_u32_u16 v0, 8, 4, 8 op_sel_hi:[0,0,1]
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: v_udot2_inline_literal_a_b_c:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_dot2_u32_u16 v0, 8, 4, 8 op_sel_hi:[0,0,1]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_udot2_inline_literal_a_b_c:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_dot2_u32_u16 v0, 8, 4, 8 op_sel_hi:[0,0,1]
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %r = call i32 @llvm.amdgcn.udot2(<2 x i16> <i16 8, i16 8>, <2 x i16> <i16 4, i16 4>, i32 8, i1 false)
  ret i32 %r
}

define i32 @v_udot2_inline_literal_c(<2 x i16> %a, <2 x i16> %b) {
; GFX906-LABEL: v_udot2_inline_literal_c:
; GFX906:       ; %bb.0:
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    v_dot2_u32_u16 v0, v0, v1, 7
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: v_udot2_inline_literal_c:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_dot2_u32_u16 v0, v0, v1, 7
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_udot2_inline_literal_c:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_dot2_u32_u16 v0, v0, v1, 7
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %r = call i32 @llvm.amdgcn.udot2(<2 x i16> %a, <2 x i16> %b, i32 7, i1 false)
  ret i32 %r
}

define i32 @v_udot2_fneg_a(<2 x half> %a, <2 x i16> %b, i32 %c) {
; GFX906-LABEL: v_udot2_fneg_a:
; GFX906:       ; %bb.0:
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    v_dot2_u32_u16 v0, v0, v1, v2 neg_lo:[1,0,0] neg_hi:[1,0,0]
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: v_udot2_fneg_a:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_dot2_u32_u16 v0, v0, v1, v2 neg_lo:[1,0,0] neg_hi:[1,0,0]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_udot2_fneg_a:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_dot2_u32_u16 v0, v0, v1, v2 neg_lo:[1,0,0] neg_hi:[1,0,0]
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %neg.a = fneg <2 x half> %a
  %cast.neg.a = bitcast <2 x half> %neg.a to <2 x i16>
  %r = call i32 @llvm.amdgcn.udot2(<2 x i16> %cast.neg.a, <2 x i16> %b, i32 %c, i1 false)
  ret i32 %r
}

define i32 @v_udot2_fneg_b(<2 x i16> %a, <2 x half> %b, i32 %c) {
; GFX906-LABEL: v_udot2_fneg_b:
; GFX906:       ; %bb.0:
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    v_dot2_u32_u16 v0, v0, v1, v2 neg_lo:[0,1,0] neg_hi:[0,1,0]
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: v_udot2_fneg_b:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_dot2_u32_u16 v0, v0, v1, v2 neg_lo:[0,1,0] neg_hi:[0,1,0]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_udot2_fneg_b:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_dot2_u32_u16 v0, v0, v1, v2 neg_lo:[0,1,0] neg_hi:[0,1,0]
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %neg.b = fneg <2 x half> %b
  %cast.neg.b = bitcast <2 x half> %neg.b to <2 x i16>
  %r = call i32 @llvm.amdgcn.udot2(<2 x i16> %a, <2 x i16> %cast.neg.b, i32 %c, i1 false)
  ret i32 %r
}

define i32 @v_udot2_fnegf32_c(<2 x i16> %a, <2 x i16> %b, float %c) {
; GFX906-LABEL: v_udot2_fnegf32_c:
; GFX906:       ; %bb.0:
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    v_xor_b32_e32 v2, 0x80000000, v2
; GFX906-NEXT:    v_dot2_u32_u16 v0, v0, v1, v2
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: v_udot2_fnegf32_c:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_xor_b32_e32 v2, 0x80000000, v2
; GFX908-NEXT:    v_dot2_u32_u16 v0, v0, v1, v2
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_udot2_fnegf32_c:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_xor_b32_e32 v2, 0x80000000, v2
; GFX10-NEXT:    v_dot2_u32_u16 v0, v0, v1, v2
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %neg.c = fneg float %c
  %cast.neg.c = bitcast float %neg.c to i32
  %r = call i32 @llvm.amdgcn.udot2(<2 x i16> %a, <2 x i16> %b, i32 %cast.neg.c, i1 false)
  ret i32 %r
}

define i32 @v_udot2_fnegv2f16_c(<2 x i16> %a, <2 x i16> %b, <2 x half> %c) {
; GFX906-LABEL: v_udot2_fnegv2f16_c:
; GFX906:       ; %bb.0:
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    v_xor_b32_e32 v2, 0x80008000, v2
; GFX906-NEXT:    v_dot2_u32_u16 v0, v0, v1, v2
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: v_udot2_fnegv2f16_c:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_xor_b32_e32 v2, 0x80008000, v2
; GFX908-NEXT:    v_dot2_u32_u16 v0, v0, v1, v2
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_udot2_fnegv2f16_c:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_xor_b32_e32 v2, 0x80008000, v2
; GFX10-NEXT:    v_dot2_u32_u16 v0, v0, v1, v2
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %neg.c = fneg <2 x half> %c
  %cast.neg.c = bitcast <2 x half> %neg.c to i32
  %r = call i32 @llvm.amdgcn.udot2(<2 x i16> %a, <2 x i16> %b, i32 %cast.neg.c, i1 false)
  ret i32 %r
}

define i32 @v_udot2_shuffle10_a(<2 x i16> %a, <2 x i16> %b, i32 %c) {
; GFX906-LABEL: v_udot2_shuffle10_a:
; GFX906:       ; %bb.0:
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    v_alignbit_b32 v0, v0, v0, 16
; GFX906-NEXT:    v_dot2_u32_u16 v0, v0, v1, v2
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: v_udot2_shuffle10_a:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_alignbit_b32 v0, v0, v0, 16
; GFX908-NEXT:    v_dot2_u32_u16 v0, v0, v1, v2
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_udot2_shuffle10_a:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_alignbit_b32 v0, v0, v0, 16
; GFX10-NEXT:    v_dot2_u32_u16 v0, v0, v1, v2
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %shuf.a = shufflevector <2 x i16> %a, <2 x i16> undef, <2 x i32> <i32 1, i32 0>
  %r = call i32 @llvm.amdgcn.udot2(<2 x i16> %shuf.a, <2 x i16> %b, i32 %c, i1 false)
  ret i32 %r
}

define i32 @v_udot2_shuffle10_b(<2 x i16> %a, <2 x i16> %b, i32 %c) {
; GFX906-LABEL: v_udot2_shuffle10_b:
; GFX906:       ; %bb.0:
; GFX906-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX906-NEXT:    v_alignbit_b32 v1, v1, v1, 16
; GFX906-NEXT:    v_dot2_u32_u16 v0, v0, v1, v2
; GFX906-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: v_udot2_shuffle10_b:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_alignbit_b32 v1, v1, v1, 16
; GFX908-NEXT:    v_dot2_u32_u16 v0, v0, v1, v2
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_udot2_shuffle10_b:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_alignbit_b32 v1, v1, v1, 16
; GFX10-NEXT:    v_dot2_u32_u16 v0, v0, v1, v2
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %shuf.b = shufflevector <2 x i16> %b, <2 x i16> undef, <2 x i32> <i32 1, i32 0>
  %r = call i32 @llvm.amdgcn.udot2(<2 x i16> %a, <2 x i16> %shuf.b, i32 %c, i1 false)
  ret i32 %r
}

declare i32 @llvm.amdgcn.udot2(<2 x i16>, <2 x i16>, i32, i1 immarg) #0

attributes #0 = { nounwind readnone speculatable }
