// RUN: llvm-mc -arch=amdgcn -mcpu=gfx900 -show-encoding %s | FileCheck %s

v_interp_p1_f32_e64 v5, v2, attr0.x
// CHECK: [0x05,0x00,0x70,0xd2,0x00,0x04,0x02,0x00]

v_interp_p1_f32_e64 v255, v2, attr0.x
// CHECK: [0xff,0x00,0x70,0xd2,0x00,0x04,0x02,0x00]

v_interp_p1_f32_e64 v5, v2, attr1.x
// CHECK: [0x05,0x00,0x70,0xd2,0x01,0x04,0x02,0x00]

v_interp_p1_f32_e64 v5, v2, attr31.x
// CHECK: [0x05,0x00,0x70,0xd2,0x1f,0x04,0x02,0x00]

v_interp_p1_f32_e64 v5, v2, attr32.x
// CHECK: [0x05,0x00,0x70,0xd2,0x20,0x04,0x02,0x00]

v_interp_p1_f32_e64 v5, v255, attr0.x
// CHECK: [0x05,0x00,0x70,0xd2,0x00,0xfe,0x03,0x00]

v_interp_p1_f32_e64 v5, -v2, attr0.x
// CHECK: [0x05,0x00,0x70,0xd2,0x00,0x04,0x02,0x40]

v_interp_p1_f32_e64 v5, |v2|, attr0.x
// CHECK: [0x05,0x02,0x70,0xd2,0x00,0x04,0x02,0x00]

v_interp_p1_f32_e64 v5, v2, attr0.y
// CHECK: [0x05,0x00,0x70,0xd2,0x40,0x04,0x02,0x00]

v_interp_p1_f32_e64 v5, v2, attr0.z
// CHECK: [0x05,0x00,0x70,0xd2,0x80,0x04,0x02,0x00]

v_interp_p1_f32_e64 v5, v2, attr0.w
// CHECK: [0x05,0x00,0x70,0xd2,0xc0,0x04,0x02,0x00]

v_interp_p1_f32_e64 v5, v2, attr0.x clamp
// CHECK: [0x05,0x80,0x70,0xd2,0x00,0x04,0x02,0x00]

v_interp_p1_f32_e64 v5, v2, attr0.x mul:2
// CHECK: [0x05,0x00,0x70,0xd2,0x00,0x04,0x02,0x08]

v_interp_p1_f32_e64 v5, v2, attr0.x mul:4
// CHECK: [0x05,0x00,0x70,0xd2,0x00,0x04,0x02,0x10]

v_interp_p1_f32_e64 v5, v2, attr0.x div:2
// CHECK: [0x05,0x00,0x70,0xd2,0x00,0x04,0x02,0x18]

v_interp_p2_f32_e64 v5, v2, attr0.x
// CHECK: [0x05,0x00,0x71,0xd2,0x00,0x04,0x02,0x00]

v_interp_p2_f32_e64 v255, v2, attr0.x
// CHECK: [0xff,0x00,0x71,0xd2,0x00,0x04,0x02,0x00]

v_interp_p2_f32_e64 v5, v2, attr1.x
// CHECK: [0x05,0x00,0x71,0xd2,0x01,0x04,0x02,0x00]

v_interp_p2_f32_e64 v5, v2, attr31.x
// CHECK: [0x05,0x00,0x71,0xd2,0x1f,0x04,0x02,0x00]

v_interp_p2_f32_e64 v5, v2, attr32.x
// CHECK: [0x05,0x00,0x71,0xd2,0x20,0x04,0x02,0x00]

v_interp_p2_f32_e64 v5, v255, attr0.x
// CHECK: [0x05,0x00,0x71,0xd2,0x00,0xfe,0x03,0x00]

v_interp_p2_f32_e64 v5, -v2, attr0.x
// CHECK: [0x05,0x00,0x71,0xd2,0x00,0x04,0x02,0x40]

v_interp_p2_f32_e64 v5, |v2|, attr0.x
// CHECK: [0x05,0x02,0x71,0xd2,0x00,0x04,0x02,0x00]

v_interp_p2_f32_e64 v5, v2, attr0.y
// CHECK: [0x05,0x00,0x71,0xd2,0x40,0x04,0x02,0x00]

v_interp_p2_f32_e64 v5, v2, attr0.z
// CHECK: [0x05,0x00,0x71,0xd2,0x80,0x04,0x02,0x00]

v_interp_p2_f32_e64 v5, v2, attr0.w
// CHECK: [0x05,0x00,0x71,0xd2,0xc0,0x04,0x02,0x00]

v_interp_p2_f32_e64 v5, v2, attr0.x clamp
// CHECK: [0x05,0x80,0x71,0xd2,0x00,0x04,0x02,0x00]

v_interp_p2_f32_e64 v5, v2, attr0.x mul:2
// CHECK: [0x05,0x00,0x71,0xd2,0x00,0x04,0x02,0x08]

v_interp_p2_f32_e64 v5, v2, attr0.x mul:4
// CHECK: [0x05,0x00,0x71,0xd2,0x00,0x04,0x02,0x10]

v_interp_p2_f32_e64 v5, v2, attr0.x div:2
// CHECK: [0x05,0x00,0x71,0xd2,0x00,0x04,0x02,0x18]

v_interp_mov_f32_e64 v5, p10, attr0.x
// CHECK: [0x05,0x00,0x72,0xd2,0x00,0x00,0x00,0x00]

v_interp_mov_f32_e64 v255, p10, attr0.x
// CHECK: [0xff,0x00,0x72,0xd2,0x00,0x00,0x00,0x00]

v_interp_mov_f32_e64 v5, p10, attr1.x
// CHECK: [0x05,0x00,0x72,0xd2,0x01,0x00,0x00,0x00]

v_interp_mov_f32_e64 v5, p10, attr31.x
// CHECK: [0x05,0x00,0x72,0xd2,0x1f,0x00,0x00,0x00]

v_interp_mov_f32_e64 v5, p10, attr32.x
// CHECK: [0x05,0x00,0x72,0xd2,0x20,0x00,0x00,0x00]

v_interp_mov_f32_e64 v5, p20, attr0.x
// CHECK: [0x05,0x00,0x72,0xd2,0x00,0x02,0x00,0x00]

v_interp_mov_f32_e64 v5, p0, attr0.x
// CHECK: [0x05,0x00,0x72,0xd2,0x00,0x04,0x00,0x00]

v_interp_mov_f32_e64 v5, p10, attr0.y
// CHECK: [0x05,0x00,0x72,0xd2,0x40,0x00,0x00,0x00]

v_interp_mov_f32_e64 v5, p10, attr0.z
// CHECK: [0x05,0x00,0x72,0xd2,0x80,0x00,0x00,0x00]

v_interp_mov_f32_e64 v5, p10, attr0.w
// CHECK: [0x05,0x00,0x72,0xd2,0xc0,0x00,0x00,0x00]

v_interp_mov_f32_e64 v5, p10, attr0.x clamp
// CHECK: [0x05,0x80,0x72,0xd2,0x00,0x00,0x00,0x00]

v_interp_mov_f32_e64 v5, p10, attr0.x mul:2
// CHECK: [0x05,0x00,0x72,0xd2,0x00,0x00,0x00,0x08]

v_interp_mov_f32_e64 v5, p10, attr0.x mul:4
// CHECK: [0x05,0x00,0x72,0xd2,0x00,0x00,0x00,0x10]

v_interp_mov_f32_e64 v5, p10, attr0.x div:2
// CHECK: [0x05,0x00,0x72,0xd2,0x00,0x00,0x00,0x18]

v_nop_e64
// CHECK: [0x00,0x00,0x40,0xd1,0x00,0x00,0x00,0x00]

v_mov_b32_e64 v5, v1
// CHECK: [0x05,0x00,0x41,0xd1,0x01,0x01,0x00,0x00]

v_mov_b32_e64 v255, v1
// CHECK: [0xff,0x00,0x41,0xd1,0x01,0x01,0x00,0x00]

v_mov_b32_e64 v5, v255
// CHECK: [0x05,0x00,0x41,0xd1,0xff,0x01,0x00,0x00]

v_mov_b32_e64 v5, s1
// CHECK: [0x05,0x00,0x41,0xd1,0x01,0x00,0x00,0x00]

v_mov_b32_e64 v5, s101
// CHECK: [0x05,0x00,0x41,0xd1,0x65,0x00,0x00,0x00]

v_mov_b32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x41,0xd1,0x66,0x00,0x00,0x00]

v_mov_b32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x41,0xd1,0x67,0x00,0x00,0x00]

v_mov_b32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x41,0xd1,0x6a,0x00,0x00,0x00]

v_mov_b32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x41,0xd1,0x6b,0x00,0x00,0x00]

v_mov_b32_e64 v5, ttmp15
// CHECK: [0x05,0x00,0x41,0xd1,0x7b,0x00,0x00,0x00]

v_mov_b32_e64 v5, m0
// CHECK: [0x05,0x00,0x41,0xd1,0x7c,0x00,0x00,0x00]

v_mov_b32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x41,0xd1,0x7e,0x00,0x00,0x00]

v_mov_b32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x41,0xd1,0x7f,0x00,0x00,0x00]

v_mov_b32_e64 v5, 0
// CHECK: [0x05,0x00,0x41,0xd1,0x80,0x00,0x00,0x00]

v_mov_b32_e64 v5, -1
// CHECK: [0x05,0x00,0x41,0xd1,0xc1,0x00,0x00,0x00]

v_mov_b32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x41,0xd1,0xf0,0x00,0x00,0x00]

v_mov_b32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x41,0xd1,0xf7,0x00,0x00,0x00]

v_mov_b32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x41,0xd1,0xfb,0x00,0x00,0x00]

v_mov_b32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x41,0xd1,0xfc,0x00,0x00,0x00]

v_mov_b32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x41,0xd1,0xfd,0x00,0x00,0x00]

v_mov_b32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x41,0xd1,0xfe,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, v[1:2]
// CHECK: [0x05,0x00,0x43,0xd1,0x01,0x01,0x00,0x00]

v_cvt_i32_f64_e64 v255, v[1:2]
// CHECK: [0xff,0x00,0x43,0xd1,0x01,0x01,0x00,0x00]

v_cvt_i32_f64_e64 v5, v[254:255]
// CHECK: [0x05,0x00,0x43,0xd1,0xfe,0x01,0x00,0x00]

v_cvt_i32_f64_e64 v5, s[2:3]
// CHECK: [0x05,0x00,0x43,0xd1,0x02,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, s[4:5]
// CHECK: [0x05,0x00,0x43,0xd1,0x04,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, s[100:101]
// CHECK: [0x05,0x00,0x43,0xd1,0x64,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, flat_scratch
// CHECK: [0x05,0x00,0x43,0xd1,0x66,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, vcc
// CHECK: [0x05,0x00,0x43,0xd1,0x6a,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, ttmp[14:15]
// CHECK: [0x05,0x00,0x43,0xd1,0x7a,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, exec
// CHECK: [0x05,0x00,0x43,0xd1,0x7e,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, 0
// CHECK: [0x05,0x00,0x43,0xd1,0x80,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, -1
// CHECK: [0x05,0x00,0x43,0xd1,0xc1,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, 0.5
// CHECK: [0x05,0x00,0x43,0xd1,0xf0,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, -4.0
// CHECK: [0x05,0x00,0x43,0xd1,0xf7,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x43,0xd1,0xfb,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, src_execz
// CHECK: [0x05,0x00,0x43,0xd1,0xfc,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, src_scc
// CHECK: [0x05,0x00,0x43,0xd1,0xfd,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, -v[1:2]
// CHECK: [0x05,0x00,0x43,0xd1,0x01,0x01,0x00,0x20]

v_cvt_i32_f64_e64 v5, |v[1:2]|
// CHECK: [0x05,0x01,0x43,0xd1,0x01,0x01,0x00,0x00]

v_cvt_i32_f64_e64 v5, v[1:2] clamp
// CHECK: [0x05,0x80,0x43,0xd1,0x01,0x01,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], v1
// CHECK: [0x05,0x00,0x44,0xd1,0x01,0x01,0x00,0x00]

v_cvt_f64_i32_e64 v[254:255], v1
// CHECK: [0xfe,0x00,0x44,0xd1,0x01,0x01,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], v255
// CHECK: [0x05,0x00,0x44,0xd1,0xff,0x01,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], s1
// CHECK: [0x05,0x00,0x44,0xd1,0x01,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], s101
// CHECK: [0x05,0x00,0x44,0xd1,0x65,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], flat_scratch_lo
// CHECK: [0x05,0x00,0x44,0xd1,0x66,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], flat_scratch_hi
// CHECK: [0x05,0x00,0x44,0xd1,0x67,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], vcc_lo
// CHECK: [0x05,0x00,0x44,0xd1,0x6a,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], vcc_hi
// CHECK: [0x05,0x00,0x44,0xd1,0x6b,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], ttmp15
// CHECK: [0x05,0x00,0x44,0xd1,0x7b,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], m0
// CHECK: [0x05,0x00,0x44,0xd1,0x7c,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], exec_lo
// CHECK: [0x05,0x00,0x44,0xd1,0x7e,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], exec_hi
// CHECK: [0x05,0x00,0x44,0xd1,0x7f,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], 0
// CHECK: [0x05,0x00,0x44,0xd1,0x80,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], -1
// CHECK: [0x05,0x00,0x44,0xd1,0xc1,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], 0.5
// CHECK: [0x05,0x00,0x44,0xd1,0xf0,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], -4.0
// CHECK: [0x05,0x00,0x44,0xd1,0xf7,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], src_vccz
// CHECK: [0x05,0x00,0x44,0xd1,0xfb,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], src_execz
// CHECK: [0x05,0x00,0x44,0xd1,0xfc,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], src_scc
// CHECK: [0x05,0x00,0x44,0xd1,0xfd,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], src_lds_direct
// CHECK: [0x05,0x00,0x44,0xd1,0xfe,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], v1 clamp
// CHECK: [0x05,0x80,0x44,0xd1,0x01,0x01,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], v1 mul:2
// CHECK: [0x05,0x00,0x44,0xd1,0x01,0x01,0x00,0x08]

v_cvt_f64_i32_e64 v[5:6], v1 mul:4
// CHECK: [0x05,0x00,0x44,0xd1,0x01,0x01,0x00,0x10]

v_cvt_f64_i32_e64 v[5:6], v1 div:2
// CHECK: [0x05,0x00,0x44,0xd1,0x01,0x01,0x00,0x18]

v_cvt_f32_i32_e64 v5, v1
// CHECK: [0x05,0x00,0x45,0xd1,0x01,0x01,0x00,0x00]

v_cvt_f32_i32_e64 v255, v1
// CHECK: [0xff,0x00,0x45,0xd1,0x01,0x01,0x00,0x00]

v_cvt_f32_i32_e64 v5, v255
// CHECK: [0x05,0x00,0x45,0xd1,0xff,0x01,0x00,0x00]

v_cvt_f32_i32_e64 v5, s1
// CHECK: [0x05,0x00,0x45,0xd1,0x01,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, s101
// CHECK: [0x05,0x00,0x45,0xd1,0x65,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x45,0xd1,0x66,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x45,0xd1,0x67,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x45,0xd1,0x6a,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x45,0xd1,0x6b,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, ttmp15
// CHECK: [0x05,0x00,0x45,0xd1,0x7b,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, m0
// CHECK: [0x05,0x00,0x45,0xd1,0x7c,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x45,0xd1,0x7e,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x45,0xd1,0x7f,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, 0
// CHECK: [0x05,0x00,0x45,0xd1,0x80,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, -1
// CHECK: [0x05,0x00,0x45,0xd1,0xc1,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x45,0xd1,0xf0,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x45,0xd1,0xf7,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x45,0xd1,0xfb,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x45,0xd1,0xfc,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x45,0xd1,0xfd,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x45,0xd1,0xfe,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, v1 clamp
// CHECK: [0x05,0x80,0x45,0xd1,0x01,0x01,0x00,0x00]

v_cvt_f32_i32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x45,0xd1,0x01,0x01,0x00,0x08]

v_cvt_f32_i32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x45,0xd1,0x01,0x01,0x00,0x10]

v_cvt_f32_i32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x45,0xd1,0x01,0x01,0x00,0x18]

v_cvt_f32_u32_e64 v5, v1
// CHECK: [0x05,0x00,0x46,0xd1,0x01,0x01,0x00,0x00]

v_cvt_f32_u32_e64 v255, v1
// CHECK: [0xff,0x00,0x46,0xd1,0x01,0x01,0x00,0x00]

v_cvt_f32_u32_e64 v5, v255
// CHECK: [0x05,0x00,0x46,0xd1,0xff,0x01,0x00,0x00]

v_cvt_f32_u32_e64 v5, s1
// CHECK: [0x05,0x00,0x46,0xd1,0x01,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, s101
// CHECK: [0x05,0x00,0x46,0xd1,0x65,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x46,0xd1,0x66,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x46,0xd1,0x67,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x46,0xd1,0x6a,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x46,0xd1,0x6b,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, ttmp15
// CHECK: [0x05,0x00,0x46,0xd1,0x7b,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, m0
// CHECK: [0x05,0x00,0x46,0xd1,0x7c,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x46,0xd1,0x7e,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x46,0xd1,0x7f,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, 0
// CHECK: [0x05,0x00,0x46,0xd1,0x80,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, -1
// CHECK: [0x05,0x00,0x46,0xd1,0xc1,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x46,0xd1,0xf0,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x46,0xd1,0xf7,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x46,0xd1,0xfb,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x46,0xd1,0xfc,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x46,0xd1,0xfd,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x46,0xd1,0xfe,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, v1 clamp
// CHECK: [0x05,0x80,0x46,0xd1,0x01,0x01,0x00,0x00]

v_cvt_f32_u32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x46,0xd1,0x01,0x01,0x00,0x08]

v_cvt_f32_u32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x46,0xd1,0x01,0x01,0x00,0x10]

v_cvt_f32_u32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x46,0xd1,0x01,0x01,0x00,0x18]

v_cvt_u32_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x47,0xd1,0x01,0x01,0x00,0x00]

v_cvt_u32_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x47,0xd1,0x01,0x01,0x00,0x00]

v_cvt_u32_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x47,0xd1,0xff,0x01,0x00,0x00]

v_cvt_u32_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x47,0xd1,0x01,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, s101
// CHECK: [0x05,0x00,0x47,0xd1,0x65,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x47,0xd1,0x66,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x47,0xd1,0x67,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x47,0xd1,0x6a,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x47,0xd1,0x6b,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, ttmp15
// CHECK: [0x05,0x00,0x47,0xd1,0x7b,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x47,0xd1,0x7c,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x47,0xd1,0x7e,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x47,0xd1,0x7f,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x47,0xd1,0x80,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x47,0xd1,0xc1,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x47,0xd1,0xf0,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x47,0xd1,0xf7,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x47,0xd1,0xfb,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x47,0xd1,0xfc,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x47,0xd1,0xfd,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x47,0xd1,0xfe,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x47,0xd1,0x01,0x01,0x00,0x20]

v_cvt_u32_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x47,0xd1,0x01,0x01,0x00,0x00]

v_cvt_u32_f32_e64 v5, v1 clamp
// CHECK: [0x05,0x80,0x47,0xd1,0x01,0x01,0x00,0x00]

v_cvt_i32_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x48,0xd1,0x01,0x01,0x00,0x00]

v_cvt_i32_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x48,0xd1,0x01,0x01,0x00,0x00]

v_cvt_i32_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x48,0xd1,0xff,0x01,0x00,0x00]

v_cvt_i32_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x48,0xd1,0x01,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, s101
// CHECK: [0x05,0x00,0x48,0xd1,0x65,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x48,0xd1,0x66,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x48,0xd1,0x67,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x48,0xd1,0x6a,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x48,0xd1,0x6b,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, ttmp15
// CHECK: [0x05,0x00,0x48,0xd1,0x7b,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x48,0xd1,0x7c,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x48,0xd1,0x7e,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x48,0xd1,0x7f,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x48,0xd1,0x80,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x48,0xd1,0xc1,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x48,0xd1,0xf0,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x48,0xd1,0xf7,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x48,0xd1,0xfb,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x48,0xd1,0xfc,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x48,0xd1,0xfd,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x48,0xd1,0xfe,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x48,0xd1,0x01,0x01,0x00,0x20]

v_cvt_i32_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x48,0xd1,0x01,0x01,0x00,0x00]

v_cvt_i32_f32_e64 v5, v1 clamp
// CHECK: [0x05,0x80,0x48,0xd1,0x01,0x01,0x00,0x00]

v_cvt_f16_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x4a,0xd1,0x01,0x01,0x00,0x00]

v_cvt_f16_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x4a,0xd1,0x01,0x01,0x00,0x00]

v_cvt_f16_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x4a,0xd1,0xff,0x01,0x00,0x00]

v_cvt_f16_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x4a,0xd1,0x01,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, s101
// CHECK: [0x05,0x00,0x4a,0xd1,0x65,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x4a,0xd1,0x66,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x4a,0xd1,0x67,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x4a,0xd1,0x6a,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x4a,0xd1,0x6b,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, ttmp15
// CHECK: [0x05,0x00,0x4a,0xd1,0x7b,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x4a,0xd1,0x7c,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x4a,0xd1,0x7e,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x4a,0xd1,0x7f,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x4a,0xd1,0x80,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x4a,0xd1,0xc1,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x4a,0xd1,0xf0,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x4a,0xd1,0xf7,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x4a,0xd1,0xfb,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x4a,0xd1,0xfc,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x4a,0xd1,0xfd,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x4a,0xd1,0xfe,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x4a,0xd1,0x01,0x01,0x00,0x20]

v_cvt_f16_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x4a,0xd1,0x01,0x01,0x00,0x00]

v_cvt_f16_f32_e64 v5, v1 clamp
// CHECK: [0x05,0x80,0x4a,0xd1,0x01,0x01,0x00,0x00]

v_cvt_f16_f32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x4a,0xd1,0x01,0x01,0x00,0x08]

v_cvt_f16_f32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x4a,0xd1,0x01,0x01,0x00,0x10]

v_cvt_f16_f32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x4a,0xd1,0x01,0x01,0x00,0x18]

v_cvt_f32_f16_e64 v5, v1
// CHECK: [0x05,0x00,0x4b,0xd1,0x01,0x01,0x00,0x00]

v_cvt_f32_f16_e64 v255, v1
// CHECK: [0xff,0x00,0x4b,0xd1,0x01,0x01,0x00,0x00]

v_cvt_f32_f16_e64 v5, v255
// CHECK: [0x05,0x00,0x4b,0xd1,0xff,0x01,0x00,0x00]

v_cvt_f32_f16_e64 v5, s1
// CHECK: [0x05,0x00,0x4b,0xd1,0x01,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, s101
// CHECK: [0x05,0x00,0x4b,0xd1,0x65,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x4b,0xd1,0x66,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x4b,0xd1,0x67,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x4b,0xd1,0x6a,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x4b,0xd1,0x6b,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, ttmp15
// CHECK: [0x05,0x00,0x4b,0xd1,0x7b,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, m0
// CHECK: [0x05,0x00,0x4b,0xd1,0x7c,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x4b,0xd1,0x7e,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x4b,0xd1,0x7f,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, 0
// CHECK: [0x05,0x00,0x4b,0xd1,0x80,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, -1
// CHECK: [0x05,0x00,0x4b,0xd1,0xc1,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, 0.5
// CHECK: [0x05,0x00,0x4b,0xd1,0xf0,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, -4.0
// CHECK: [0x05,0x00,0x4b,0xd1,0xf7,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x4b,0xd1,0xfb,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, src_execz
// CHECK: [0x05,0x00,0x4b,0xd1,0xfc,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, src_scc
// CHECK: [0x05,0x00,0x4b,0xd1,0xfd,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x4b,0xd1,0xfe,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, -v1
// CHECK: [0x05,0x00,0x4b,0xd1,0x01,0x01,0x00,0x20]

v_cvt_f32_f16_e64 v5, |v1|
// CHECK: [0x05,0x01,0x4b,0xd1,0x01,0x01,0x00,0x00]

v_cvt_f32_f16_e64 v5, v1 clamp
// CHECK: [0x05,0x80,0x4b,0xd1,0x01,0x01,0x00,0x00]

v_cvt_f32_f16_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x4b,0xd1,0x01,0x01,0x00,0x08]

v_cvt_f32_f16_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x4b,0xd1,0x01,0x01,0x00,0x10]

v_cvt_f32_f16_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x4b,0xd1,0x01,0x01,0x00,0x18]

v_cvt_rpi_i32_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x4c,0xd1,0x01,0x01,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x4c,0xd1,0x01,0x01,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x4c,0xd1,0xff,0x01,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x4c,0xd1,0x01,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, s101
// CHECK: [0x05,0x00,0x4c,0xd1,0x65,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x4c,0xd1,0x66,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x4c,0xd1,0x67,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x4c,0xd1,0x6a,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x4c,0xd1,0x6b,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, ttmp15
// CHECK: [0x05,0x00,0x4c,0xd1,0x7b,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x4c,0xd1,0x7c,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x4c,0xd1,0x7e,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x4c,0xd1,0x7f,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x4c,0xd1,0x80,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x4c,0xd1,0xc1,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x4c,0xd1,0xf0,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x4c,0xd1,0xf7,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x4c,0xd1,0xfb,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x4c,0xd1,0xfc,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x4c,0xd1,0xfd,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x4c,0xd1,0xfe,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x4c,0xd1,0x01,0x01,0x00,0x20]

v_cvt_rpi_i32_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x4c,0xd1,0x01,0x01,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x4d,0xd1,0x01,0x01,0x00,0x00]

v_cvt_flr_i32_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x4d,0xd1,0x01,0x01,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x4d,0xd1,0xff,0x01,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x4d,0xd1,0x01,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, s101
// CHECK: [0x05,0x00,0x4d,0xd1,0x65,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x4d,0xd1,0x66,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x4d,0xd1,0x67,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x4d,0xd1,0x6a,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x4d,0xd1,0x6b,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, ttmp15
// CHECK: [0x05,0x00,0x4d,0xd1,0x7b,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x4d,0xd1,0x7c,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x4d,0xd1,0x7e,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x4d,0xd1,0x7f,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x4d,0xd1,0x80,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x4d,0xd1,0xc1,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x4d,0xd1,0xf0,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x4d,0xd1,0xf7,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x4d,0xd1,0xfb,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x4d,0xd1,0xfc,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x4d,0xd1,0xfd,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x4d,0xd1,0xfe,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x4d,0xd1,0x01,0x01,0x00,0x20]

v_cvt_flr_i32_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x4d,0xd1,0x01,0x01,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, v1
// CHECK: [0x05,0x00,0x4e,0xd1,0x01,0x01,0x00,0x00]

v_cvt_off_f32_i4_e64 v255, v1
// CHECK: [0xff,0x00,0x4e,0xd1,0x01,0x01,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, v255
// CHECK: [0x05,0x00,0x4e,0xd1,0xff,0x01,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, s1
// CHECK: [0x05,0x00,0x4e,0xd1,0x01,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, s101
// CHECK: [0x05,0x00,0x4e,0xd1,0x65,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x4e,0xd1,0x66,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x4e,0xd1,0x67,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x4e,0xd1,0x6a,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x4e,0xd1,0x6b,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, ttmp15
// CHECK: [0x05,0x00,0x4e,0xd1,0x7b,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, m0
// CHECK: [0x05,0x00,0x4e,0xd1,0x7c,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x4e,0xd1,0x7e,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x4e,0xd1,0x7f,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, 0
// CHECK: [0x05,0x00,0x4e,0xd1,0x80,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, -1
// CHECK: [0x05,0x00,0x4e,0xd1,0xc1,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, 0.5
// CHECK: [0x05,0x00,0x4e,0xd1,0xf0,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, -4.0
// CHECK: [0x05,0x00,0x4e,0xd1,0xf7,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x4e,0xd1,0xfb,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, src_execz
// CHECK: [0x05,0x00,0x4e,0xd1,0xfc,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, src_scc
// CHECK: [0x05,0x00,0x4e,0xd1,0xfd,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x4e,0xd1,0xfe,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, v1 clamp
// CHECK: [0x05,0x80,0x4e,0xd1,0x01,0x01,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x4e,0xd1,0x01,0x01,0x00,0x08]

v_cvt_off_f32_i4_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x4e,0xd1,0x01,0x01,0x00,0x10]

v_cvt_off_f32_i4_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x4e,0xd1,0x01,0x01,0x00,0x18]

v_cvt_f32_f64_e64 v5, v[1:2]
// CHECK: [0x05,0x00,0x4f,0xd1,0x01,0x01,0x00,0x00]

v_cvt_f32_f64_e64 v255, v[1:2]
// CHECK: [0xff,0x00,0x4f,0xd1,0x01,0x01,0x00,0x00]

v_cvt_f32_f64_e64 v5, v[254:255]
// CHECK: [0x05,0x00,0x4f,0xd1,0xfe,0x01,0x00,0x00]

v_cvt_f32_f64_e64 v5, s[2:3]
// CHECK: [0x05,0x00,0x4f,0xd1,0x02,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, s[4:5]
// CHECK: [0x05,0x00,0x4f,0xd1,0x04,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, s[100:101]
// CHECK: [0x05,0x00,0x4f,0xd1,0x64,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, flat_scratch
// CHECK: [0x05,0x00,0x4f,0xd1,0x66,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, vcc
// CHECK: [0x05,0x00,0x4f,0xd1,0x6a,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, ttmp[14:15]
// CHECK: [0x05,0x00,0x4f,0xd1,0x7a,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, exec
// CHECK: [0x05,0x00,0x4f,0xd1,0x7e,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, 0
// CHECK: [0x05,0x00,0x4f,0xd1,0x80,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, -1
// CHECK: [0x05,0x00,0x4f,0xd1,0xc1,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, 0.5
// CHECK: [0x05,0x00,0x4f,0xd1,0xf0,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, -4.0
// CHECK: [0x05,0x00,0x4f,0xd1,0xf7,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x4f,0xd1,0xfb,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, src_execz
// CHECK: [0x05,0x00,0x4f,0xd1,0xfc,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, src_scc
// CHECK: [0x05,0x00,0x4f,0xd1,0xfd,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, -v[1:2]
// CHECK: [0x05,0x00,0x4f,0xd1,0x01,0x01,0x00,0x20]

v_cvt_f32_f64_e64 v5, |v[1:2]|
// CHECK: [0x05,0x01,0x4f,0xd1,0x01,0x01,0x00,0x00]

v_cvt_f32_f64_e64 v5, v[1:2] clamp
// CHECK: [0x05,0x80,0x4f,0xd1,0x01,0x01,0x00,0x00]

v_cvt_f32_f64_e64 v5, v[1:2] mul:2
// CHECK: [0x05,0x00,0x4f,0xd1,0x01,0x01,0x00,0x08]

v_cvt_f32_f64_e64 v5, v[1:2] mul:4
// CHECK: [0x05,0x00,0x4f,0xd1,0x01,0x01,0x00,0x10]

v_cvt_f32_f64_e64 v5, v[1:2] div:2
// CHECK: [0x05,0x00,0x4f,0xd1,0x01,0x01,0x00,0x18]

v_cvt_f64_f32_e64 v[5:6], v1
// CHECK: [0x05,0x00,0x50,0xd1,0x01,0x01,0x00,0x00]

v_cvt_f64_f32_e64 v[254:255], v1
// CHECK: [0xfe,0x00,0x50,0xd1,0x01,0x01,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], v255
// CHECK: [0x05,0x00,0x50,0xd1,0xff,0x01,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], s1
// CHECK: [0x05,0x00,0x50,0xd1,0x01,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], s101
// CHECK: [0x05,0x00,0x50,0xd1,0x65,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], flat_scratch_lo
// CHECK: [0x05,0x00,0x50,0xd1,0x66,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], flat_scratch_hi
// CHECK: [0x05,0x00,0x50,0xd1,0x67,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], vcc_lo
// CHECK: [0x05,0x00,0x50,0xd1,0x6a,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], vcc_hi
// CHECK: [0x05,0x00,0x50,0xd1,0x6b,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], ttmp15
// CHECK: [0x05,0x00,0x50,0xd1,0x7b,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], m0
// CHECK: [0x05,0x00,0x50,0xd1,0x7c,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], exec_lo
// CHECK: [0x05,0x00,0x50,0xd1,0x7e,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], exec_hi
// CHECK: [0x05,0x00,0x50,0xd1,0x7f,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], 0
// CHECK: [0x05,0x00,0x50,0xd1,0x80,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], -1
// CHECK: [0x05,0x00,0x50,0xd1,0xc1,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], 0.5
// CHECK: [0x05,0x00,0x50,0xd1,0xf0,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], -4.0
// CHECK: [0x05,0x00,0x50,0xd1,0xf7,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], src_vccz
// CHECK: [0x05,0x00,0x50,0xd1,0xfb,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], src_execz
// CHECK: [0x05,0x00,0x50,0xd1,0xfc,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], src_scc
// CHECK: [0x05,0x00,0x50,0xd1,0xfd,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], src_lds_direct
// CHECK: [0x05,0x00,0x50,0xd1,0xfe,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], -v1
// CHECK: [0x05,0x00,0x50,0xd1,0x01,0x01,0x00,0x20]

v_cvt_f64_f32_e64 v[5:6], |v1|
// CHECK: [0x05,0x01,0x50,0xd1,0x01,0x01,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], v1 clamp
// CHECK: [0x05,0x80,0x50,0xd1,0x01,0x01,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], v1 mul:2
// CHECK: [0x05,0x00,0x50,0xd1,0x01,0x01,0x00,0x08]

v_cvt_f64_f32_e64 v[5:6], v1 mul:4
// CHECK: [0x05,0x00,0x50,0xd1,0x01,0x01,0x00,0x10]

v_cvt_f64_f32_e64 v[5:6], v1 div:2
// CHECK: [0x05,0x00,0x50,0xd1,0x01,0x01,0x00,0x18]

v_cvt_f32_ubyte0_e64 v5, v1
// CHECK: [0x05,0x00,0x51,0xd1,0x01,0x01,0x00,0x00]

v_cvt_f32_ubyte0_e64 v255, v1
// CHECK: [0xff,0x00,0x51,0xd1,0x01,0x01,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, v255
// CHECK: [0x05,0x00,0x51,0xd1,0xff,0x01,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, s1
// CHECK: [0x05,0x00,0x51,0xd1,0x01,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, s101
// CHECK: [0x05,0x00,0x51,0xd1,0x65,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x51,0xd1,0x66,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x51,0xd1,0x67,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x51,0xd1,0x6a,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x51,0xd1,0x6b,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, ttmp15
// CHECK: [0x05,0x00,0x51,0xd1,0x7b,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, m0
// CHECK: [0x05,0x00,0x51,0xd1,0x7c,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x51,0xd1,0x7e,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x51,0xd1,0x7f,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, 0
// CHECK: [0x05,0x00,0x51,0xd1,0x80,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, -1
// CHECK: [0x05,0x00,0x51,0xd1,0xc1,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, 0.5
// CHECK: [0x05,0x00,0x51,0xd1,0xf0,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, -4.0
// CHECK: [0x05,0x00,0x51,0xd1,0xf7,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x51,0xd1,0xfb,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, src_execz
// CHECK: [0x05,0x00,0x51,0xd1,0xfc,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, src_scc
// CHECK: [0x05,0x00,0x51,0xd1,0xfd,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x51,0xd1,0xfe,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, v1 clamp
// CHECK: [0x05,0x80,0x51,0xd1,0x01,0x01,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x51,0xd1,0x01,0x01,0x00,0x08]

v_cvt_f32_ubyte0_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x51,0xd1,0x01,0x01,0x00,0x10]

v_cvt_f32_ubyte0_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x51,0xd1,0x01,0x01,0x00,0x18]

v_cvt_f32_ubyte1_e64 v5, v1
// CHECK: [0x05,0x00,0x52,0xd1,0x01,0x01,0x00,0x00]

v_cvt_f32_ubyte1_e64 v255, v1
// CHECK: [0xff,0x00,0x52,0xd1,0x01,0x01,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, v255
// CHECK: [0x05,0x00,0x52,0xd1,0xff,0x01,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, s1
// CHECK: [0x05,0x00,0x52,0xd1,0x01,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, s101
// CHECK: [0x05,0x00,0x52,0xd1,0x65,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x52,0xd1,0x66,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x52,0xd1,0x67,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x52,0xd1,0x6a,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x52,0xd1,0x6b,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, ttmp15
// CHECK: [0x05,0x00,0x52,0xd1,0x7b,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, m0
// CHECK: [0x05,0x00,0x52,0xd1,0x7c,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x52,0xd1,0x7e,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x52,0xd1,0x7f,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, 0
// CHECK: [0x05,0x00,0x52,0xd1,0x80,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, -1
// CHECK: [0x05,0x00,0x52,0xd1,0xc1,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, 0.5
// CHECK: [0x05,0x00,0x52,0xd1,0xf0,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, -4.0
// CHECK: [0x05,0x00,0x52,0xd1,0xf7,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x52,0xd1,0xfb,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, src_execz
// CHECK: [0x05,0x00,0x52,0xd1,0xfc,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, src_scc
// CHECK: [0x05,0x00,0x52,0xd1,0xfd,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x52,0xd1,0xfe,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, v1 clamp
// CHECK: [0x05,0x80,0x52,0xd1,0x01,0x01,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x52,0xd1,0x01,0x01,0x00,0x08]

v_cvt_f32_ubyte1_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x52,0xd1,0x01,0x01,0x00,0x10]

v_cvt_f32_ubyte1_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x52,0xd1,0x01,0x01,0x00,0x18]

v_cvt_f32_ubyte2_e64 v5, v1
// CHECK: [0x05,0x00,0x53,0xd1,0x01,0x01,0x00,0x00]

v_cvt_f32_ubyte2_e64 v255, v1
// CHECK: [0xff,0x00,0x53,0xd1,0x01,0x01,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, v255
// CHECK: [0x05,0x00,0x53,0xd1,0xff,0x01,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, s1
// CHECK: [0x05,0x00,0x53,0xd1,0x01,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, s101
// CHECK: [0x05,0x00,0x53,0xd1,0x65,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x53,0xd1,0x66,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x53,0xd1,0x67,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x53,0xd1,0x6a,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x53,0xd1,0x6b,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, ttmp15
// CHECK: [0x05,0x00,0x53,0xd1,0x7b,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, m0
// CHECK: [0x05,0x00,0x53,0xd1,0x7c,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x53,0xd1,0x7e,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x53,0xd1,0x7f,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, 0
// CHECK: [0x05,0x00,0x53,0xd1,0x80,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, -1
// CHECK: [0x05,0x00,0x53,0xd1,0xc1,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, 0.5
// CHECK: [0x05,0x00,0x53,0xd1,0xf0,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, -4.0
// CHECK: [0x05,0x00,0x53,0xd1,0xf7,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x53,0xd1,0xfb,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, src_execz
// CHECK: [0x05,0x00,0x53,0xd1,0xfc,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, src_scc
// CHECK: [0x05,0x00,0x53,0xd1,0xfd,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x53,0xd1,0xfe,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, v1 clamp
// CHECK: [0x05,0x80,0x53,0xd1,0x01,0x01,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x53,0xd1,0x01,0x01,0x00,0x08]

v_cvt_f32_ubyte2_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x53,0xd1,0x01,0x01,0x00,0x10]

v_cvt_f32_ubyte2_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x53,0xd1,0x01,0x01,0x00,0x18]

v_cvt_f32_ubyte3_e64 v5, v1
// CHECK: [0x05,0x00,0x54,0xd1,0x01,0x01,0x00,0x00]

v_cvt_f32_ubyte3_e64 v255, v1
// CHECK: [0xff,0x00,0x54,0xd1,0x01,0x01,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, v255
// CHECK: [0x05,0x00,0x54,0xd1,0xff,0x01,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, s1
// CHECK: [0x05,0x00,0x54,0xd1,0x01,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, s101
// CHECK: [0x05,0x00,0x54,0xd1,0x65,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x54,0xd1,0x66,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x54,0xd1,0x67,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x54,0xd1,0x6a,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x54,0xd1,0x6b,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, ttmp15
// CHECK: [0x05,0x00,0x54,0xd1,0x7b,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, m0
// CHECK: [0x05,0x00,0x54,0xd1,0x7c,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x54,0xd1,0x7e,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x54,0xd1,0x7f,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, 0
// CHECK: [0x05,0x00,0x54,0xd1,0x80,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, -1
// CHECK: [0x05,0x00,0x54,0xd1,0xc1,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, 0.5
// CHECK: [0x05,0x00,0x54,0xd1,0xf0,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, -4.0
// CHECK: [0x05,0x00,0x54,0xd1,0xf7,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x54,0xd1,0xfb,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, src_execz
// CHECK: [0x05,0x00,0x54,0xd1,0xfc,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, src_scc
// CHECK: [0x05,0x00,0x54,0xd1,0xfd,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x54,0xd1,0xfe,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, v1 clamp
// CHECK: [0x05,0x80,0x54,0xd1,0x01,0x01,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x54,0xd1,0x01,0x01,0x00,0x08]

v_cvt_f32_ubyte3_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x54,0xd1,0x01,0x01,0x00,0x10]

v_cvt_f32_ubyte3_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x54,0xd1,0x01,0x01,0x00,0x18]

v_cvt_u32_f64_e64 v5, v[1:2]
// CHECK: [0x05,0x00,0x55,0xd1,0x01,0x01,0x00,0x00]

v_cvt_u32_f64_e64 v255, v[1:2]
// CHECK: [0xff,0x00,0x55,0xd1,0x01,0x01,0x00,0x00]

v_cvt_u32_f64_e64 v5, v[254:255]
// CHECK: [0x05,0x00,0x55,0xd1,0xfe,0x01,0x00,0x00]

v_cvt_u32_f64_e64 v5, s[2:3]
// CHECK: [0x05,0x00,0x55,0xd1,0x02,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, s[4:5]
// CHECK: [0x05,0x00,0x55,0xd1,0x04,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, s[100:101]
// CHECK: [0x05,0x00,0x55,0xd1,0x64,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, flat_scratch
// CHECK: [0x05,0x00,0x55,0xd1,0x66,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, vcc
// CHECK: [0x05,0x00,0x55,0xd1,0x6a,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, ttmp[14:15]
// CHECK: [0x05,0x00,0x55,0xd1,0x7a,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, exec
// CHECK: [0x05,0x00,0x55,0xd1,0x7e,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, 0
// CHECK: [0x05,0x00,0x55,0xd1,0x80,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, -1
// CHECK: [0x05,0x00,0x55,0xd1,0xc1,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, 0.5
// CHECK: [0x05,0x00,0x55,0xd1,0xf0,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, -4.0
// CHECK: [0x05,0x00,0x55,0xd1,0xf7,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x55,0xd1,0xfb,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, src_execz
// CHECK: [0x05,0x00,0x55,0xd1,0xfc,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, src_scc
// CHECK: [0x05,0x00,0x55,0xd1,0xfd,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, -v[1:2]
// CHECK: [0x05,0x00,0x55,0xd1,0x01,0x01,0x00,0x20]

v_cvt_u32_f64_e64 v5, |v[1:2]|
// CHECK: [0x05,0x01,0x55,0xd1,0x01,0x01,0x00,0x00]

v_cvt_u32_f64_e64 v5, v[1:2] clamp
// CHECK: [0x05,0x80,0x55,0xd1,0x01,0x01,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], v1
// CHECK: [0x05,0x00,0x56,0xd1,0x01,0x01,0x00,0x00]

v_cvt_f64_u32_e64 v[254:255], v1
// CHECK: [0xfe,0x00,0x56,0xd1,0x01,0x01,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], v255
// CHECK: [0x05,0x00,0x56,0xd1,0xff,0x01,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], s1
// CHECK: [0x05,0x00,0x56,0xd1,0x01,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], s101
// CHECK: [0x05,0x00,0x56,0xd1,0x65,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], flat_scratch_lo
// CHECK: [0x05,0x00,0x56,0xd1,0x66,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], flat_scratch_hi
// CHECK: [0x05,0x00,0x56,0xd1,0x67,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], vcc_lo
// CHECK: [0x05,0x00,0x56,0xd1,0x6a,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], vcc_hi
// CHECK: [0x05,0x00,0x56,0xd1,0x6b,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], ttmp15
// CHECK: [0x05,0x00,0x56,0xd1,0x7b,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], m0
// CHECK: [0x05,0x00,0x56,0xd1,0x7c,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], exec_lo
// CHECK: [0x05,0x00,0x56,0xd1,0x7e,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], exec_hi
// CHECK: [0x05,0x00,0x56,0xd1,0x7f,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], 0
// CHECK: [0x05,0x00,0x56,0xd1,0x80,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], -1
// CHECK: [0x05,0x00,0x56,0xd1,0xc1,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], 0.5
// CHECK: [0x05,0x00,0x56,0xd1,0xf0,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], -4.0
// CHECK: [0x05,0x00,0x56,0xd1,0xf7,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], src_vccz
// CHECK: [0x05,0x00,0x56,0xd1,0xfb,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], src_execz
// CHECK: [0x05,0x00,0x56,0xd1,0xfc,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], src_scc
// CHECK: [0x05,0x00,0x56,0xd1,0xfd,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], src_lds_direct
// CHECK: [0x05,0x00,0x56,0xd1,0xfe,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], v1 clamp
// CHECK: [0x05,0x80,0x56,0xd1,0x01,0x01,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], v1 mul:2
// CHECK: [0x05,0x00,0x56,0xd1,0x01,0x01,0x00,0x08]

v_cvt_f64_u32_e64 v[5:6], v1 mul:4
// CHECK: [0x05,0x00,0x56,0xd1,0x01,0x01,0x00,0x10]

v_cvt_f64_u32_e64 v[5:6], v1 div:2
// CHECK: [0x05,0x00,0x56,0xd1,0x01,0x01,0x00,0x18]

v_trunc_f64_e64 v[5:6], v[1:2]
// CHECK: [0x05,0x00,0x57,0xd1,0x01,0x01,0x00,0x00]

v_trunc_f64_e64 v[254:255], v[1:2]
// CHECK: [0xfe,0x00,0x57,0xd1,0x01,0x01,0x00,0x00]

v_trunc_f64_e64 v[5:6], v[254:255]
// CHECK: [0x05,0x00,0x57,0xd1,0xfe,0x01,0x00,0x00]

v_trunc_f64_e64 v[5:6], s[2:3]
// CHECK: [0x05,0x00,0x57,0xd1,0x02,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], s[4:5]
// CHECK: [0x05,0x00,0x57,0xd1,0x04,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], s[100:101]
// CHECK: [0x05,0x00,0x57,0xd1,0x64,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], flat_scratch
// CHECK: [0x05,0x00,0x57,0xd1,0x66,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], vcc
// CHECK: [0x05,0x00,0x57,0xd1,0x6a,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], ttmp[14:15]
// CHECK: [0x05,0x00,0x57,0xd1,0x7a,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], exec
// CHECK: [0x05,0x00,0x57,0xd1,0x7e,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], 0
// CHECK: [0x05,0x00,0x57,0xd1,0x80,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], -1
// CHECK: [0x05,0x00,0x57,0xd1,0xc1,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], 0.5
// CHECK: [0x05,0x00,0x57,0xd1,0xf0,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], -4.0
// CHECK: [0x05,0x00,0x57,0xd1,0xf7,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], src_vccz
// CHECK: [0x05,0x00,0x57,0xd1,0xfb,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], src_execz
// CHECK: [0x05,0x00,0x57,0xd1,0xfc,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], src_scc
// CHECK: [0x05,0x00,0x57,0xd1,0xfd,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], -v[1:2]
// CHECK: [0x05,0x00,0x57,0xd1,0x01,0x01,0x00,0x20]

v_trunc_f64_e64 v[5:6], |v[1:2]|
// CHECK: [0x05,0x01,0x57,0xd1,0x01,0x01,0x00,0x00]

v_trunc_f64_e64 v[5:6], v[1:2] clamp
// CHECK: [0x05,0x80,0x57,0xd1,0x01,0x01,0x00,0x00]

v_trunc_f64_e64 v[5:6], v[1:2] mul:2
// CHECK: [0x05,0x00,0x57,0xd1,0x01,0x01,0x00,0x08]

v_trunc_f64_e64 v[5:6], v[1:2] mul:4
// CHECK: [0x05,0x00,0x57,0xd1,0x01,0x01,0x00,0x10]

v_trunc_f64_e64 v[5:6], v[1:2] div:2
// CHECK: [0x05,0x00,0x57,0xd1,0x01,0x01,0x00,0x18]

v_ceil_f64_e64 v[5:6], v[1:2]
// CHECK: [0x05,0x00,0x58,0xd1,0x01,0x01,0x00,0x00]

v_ceil_f64_e64 v[254:255], v[1:2]
// CHECK: [0xfe,0x00,0x58,0xd1,0x01,0x01,0x00,0x00]

v_ceil_f64_e64 v[5:6], v[254:255]
// CHECK: [0x05,0x00,0x58,0xd1,0xfe,0x01,0x00,0x00]

v_ceil_f64_e64 v[5:6], s[2:3]
// CHECK: [0x05,0x00,0x58,0xd1,0x02,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], s[4:5]
// CHECK: [0x05,0x00,0x58,0xd1,0x04,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], s[100:101]
// CHECK: [0x05,0x00,0x58,0xd1,0x64,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], flat_scratch
// CHECK: [0x05,0x00,0x58,0xd1,0x66,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], vcc
// CHECK: [0x05,0x00,0x58,0xd1,0x6a,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], ttmp[14:15]
// CHECK: [0x05,0x00,0x58,0xd1,0x7a,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], exec
// CHECK: [0x05,0x00,0x58,0xd1,0x7e,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], 0
// CHECK: [0x05,0x00,0x58,0xd1,0x80,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], -1
// CHECK: [0x05,0x00,0x58,0xd1,0xc1,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], 0.5
// CHECK: [0x05,0x00,0x58,0xd1,0xf0,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], -4.0
// CHECK: [0x05,0x00,0x58,0xd1,0xf7,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], src_vccz
// CHECK: [0x05,0x00,0x58,0xd1,0xfb,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], src_execz
// CHECK: [0x05,0x00,0x58,0xd1,0xfc,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], src_scc
// CHECK: [0x05,0x00,0x58,0xd1,0xfd,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], -v[1:2]
// CHECK: [0x05,0x00,0x58,0xd1,0x01,0x01,0x00,0x20]

v_ceil_f64_e64 v[5:6], |v[1:2]|
// CHECK: [0x05,0x01,0x58,0xd1,0x01,0x01,0x00,0x00]

v_ceil_f64_e64 v[5:6], v[1:2] clamp
// CHECK: [0x05,0x80,0x58,0xd1,0x01,0x01,0x00,0x00]

v_ceil_f64_e64 v[5:6], v[1:2] mul:2
// CHECK: [0x05,0x00,0x58,0xd1,0x01,0x01,0x00,0x08]

v_ceil_f64_e64 v[5:6], v[1:2] mul:4
// CHECK: [0x05,0x00,0x58,0xd1,0x01,0x01,0x00,0x10]

v_ceil_f64_e64 v[5:6], v[1:2] div:2
// CHECK: [0x05,0x00,0x58,0xd1,0x01,0x01,0x00,0x18]

v_rndne_f64_e64 v[5:6], v[1:2]
// CHECK: [0x05,0x00,0x59,0xd1,0x01,0x01,0x00,0x00]

v_rndne_f64_e64 v[254:255], v[1:2]
// CHECK: [0xfe,0x00,0x59,0xd1,0x01,0x01,0x00,0x00]

v_rndne_f64_e64 v[5:6], v[254:255]
// CHECK: [0x05,0x00,0x59,0xd1,0xfe,0x01,0x00,0x00]

v_rndne_f64_e64 v[5:6], s[2:3]
// CHECK: [0x05,0x00,0x59,0xd1,0x02,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], s[4:5]
// CHECK: [0x05,0x00,0x59,0xd1,0x04,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], s[100:101]
// CHECK: [0x05,0x00,0x59,0xd1,0x64,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], flat_scratch
// CHECK: [0x05,0x00,0x59,0xd1,0x66,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], vcc
// CHECK: [0x05,0x00,0x59,0xd1,0x6a,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], ttmp[14:15]
// CHECK: [0x05,0x00,0x59,0xd1,0x7a,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], exec
// CHECK: [0x05,0x00,0x59,0xd1,0x7e,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], 0
// CHECK: [0x05,0x00,0x59,0xd1,0x80,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], -1
// CHECK: [0x05,0x00,0x59,0xd1,0xc1,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], 0.5
// CHECK: [0x05,0x00,0x59,0xd1,0xf0,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], -4.0
// CHECK: [0x05,0x00,0x59,0xd1,0xf7,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], src_vccz
// CHECK: [0x05,0x00,0x59,0xd1,0xfb,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], src_execz
// CHECK: [0x05,0x00,0x59,0xd1,0xfc,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], src_scc
// CHECK: [0x05,0x00,0x59,0xd1,0xfd,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], -v[1:2]
// CHECK: [0x05,0x00,0x59,0xd1,0x01,0x01,0x00,0x20]

v_rndne_f64_e64 v[5:6], |v[1:2]|
// CHECK: [0x05,0x01,0x59,0xd1,0x01,0x01,0x00,0x00]

v_rndne_f64_e64 v[5:6], v[1:2] clamp
// CHECK: [0x05,0x80,0x59,0xd1,0x01,0x01,0x00,0x00]

v_rndne_f64_e64 v[5:6], v[1:2] mul:2
// CHECK: [0x05,0x00,0x59,0xd1,0x01,0x01,0x00,0x08]

v_rndne_f64_e64 v[5:6], v[1:2] mul:4
// CHECK: [0x05,0x00,0x59,0xd1,0x01,0x01,0x00,0x10]

v_rndne_f64_e64 v[5:6], v[1:2] div:2
// CHECK: [0x05,0x00,0x59,0xd1,0x01,0x01,0x00,0x18]

v_floor_f64_e64 v[5:6], v[1:2]
// CHECK: [0x05,0x00,0x5a,0xd1,0x01,0x01,0x00,0x00]

v_floor_f64_e64 v[254:255], v[1:2]
// CHECK: [0xfe,0x00,0x5a,0xd1,0x01,0x01,0x00,0x00]

v_floor_f64_e64 v[5:6], v[254:255]
// CHECK: [0x05,0x00,0x5a,0xd1,0xfe,0x01,0x00,0x00]

v_floor_f64_e64 v[5:6], s[2:3]
// CHECK: [0x05,0x00,0x5a,0xd1,0x02,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], s[4:5]
// CHECK: [0x05,0x00,0x5a,0xd1,0x04,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], s[100:101]
// CHECK: [0x05,0x00,0x5a,0xd1,0x64,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], flat_scratch
// CHECK: [0x05,0x00,0x5a,0xd1,0x66,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], vcc
// CHECK: [0x05,0x00,0x5a,0xd1,0x6a,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], ttmp[14:15]
// CHECK: [0x05,0x00,0x5a,0xd1,0x7a,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], exec
// CHECK: [0x05,0x00,0x5a,0xd1,0x7e,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], 0
// CHECK: [0x05,0x00,0x5a,0xd1,0x80,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], -1
// CHECK: [0x05,0x00,0x5a,0xd1,0xc1,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], 0.5
// CHECK: [0x05,0x00,0x5a,0xd1,0xf0,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], -4.0
// CHECK: [0x05,0x00,0x5a,0xd1,0xf7,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], src_vccz
// CHECK: [0x05,0x00,0x5a,0xd1,0xfb,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], src_execz
// CHECK: [0x05,0x00,0x5a,0xd1,0xfc,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], src_scc
// CHECK: [0x05,0x00,0x5a,0xd1,0xfd,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], -v[1:2]
// CHECK: [0x05,0x00,0x5a,0xd1,0x01,0x01,0x00,0x20]

v_floor_f64_e64 v[5:6], |v[1:2]|
// CHECK: [0x05,0x01,0x5a,0xd1,0x01,0x01,0x00,0x00]

v_floor_f64_e64 v[5:6], v[1:2] clamp
// CHECK: [0x05,0x80,0x5a,0xd1,0x01,0x01,0x00,0x00]

v_floor_f64_e64 v[5:6], v[1:2] mul:2
// CHECK: [0x05,0x00,0x5a,0xd1,0x01,0x01,0x00,0x08]

v_floor_f64_e64 v[5:6], v[1:2] mul:4
// CHECK: [0x05,0x00,0x5a,0xd1,0x01,0x01,0x00,0x10]

v_floor_f64_e64 v[5:6], v[1:2] div:2
// CHECK: [0x05,0x00,0x5a,0xd1,0x01,0x01,0x00,0x18]

v_fract_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x5b,0xd1,0x01,0x01,0x00,0x00]

v_fract_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x5b,0xd1,0x01,0x01,0x00,0x00]

v_fract_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x5b,0xd1,0xff,0x01,0x00,0x00]

v_fract_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x5b,0xd1,0x01,0x00,0x00,0x00]

v_fract_f32_e64 v5, s101
// CHECK: [0x05,0x00,0x5b,0xd1,0x65,0x00,0x00,0x00]

v_fract_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x5b,0xd1,0x66,0x00,0x00,0x00]

v_fract_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x5b,0xd1,0x67,0x00,0x00,0x00]

v_fract_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x5b,0xd1,0x6a,0x00,0x00,0x00]

v_fract_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x5b,0xd1,0x6b,0x00,0x00,0x00]

v_fract_f32_e64 v5, ttmp15
// CHECK: [0x05,0x00,0x5b,0xd1,0x7b,0x00,0x00,0x00]

v_fract_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x5b,0xd1,0x7c,0x00,0x00,0x00]

v_fract_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x5b,0xd1,0x7e,0x00,0x00,0x00]

v_fract_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x5b,0xd1,0x7f,0x00,0x00,0x00]

v_fract_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x5b,0xd1,0x80,0x00,0x00,0x00]

v_fract_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x5b,0xd1,0xc1,0x00,0x00,0x00]

v_fract_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x5b,0xd1,0xf0,0x00,0x00,0x00]

v_fract_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x5b,0xd1,0xf7,0x00,0x00,0x00]

v_fract_f32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x5b,0xd1,0xfb,0x00,0x00,0x00]

v_fract_f32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x5b,0xd1,0xfc,0x00,0x00,0x00]

v_fract_f32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x5b,0xd1,0xfd,0x00,0x00,0x00]

v_fract_f32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x5b,0xd1,0xfe,0x00,0x00,0x00]

v_fract_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x5b,0xd1,0x01,0x01,0x00,0x20]

v_fract_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x5b,0xd1,0x01,0x01,0x00,0x00]

v_fract_f32_e64 v5, v1 clamp
// CHECK: [0x05,0x80,0x5b,0xd1,0x01,0x01,0x00,0x00]

v_fract_f32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x5b,0xd1,0x01,0x01,0x00,0x08]

v_fract_f32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x5b,0xd1,0x01,0x01,0x00,0x10]

v_fract_f32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x5b,0xd1,0x01,0x01,0x00,0x18]

v_trunc_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x5c,0xd1,0x01,0x01,0x00,0x00]

v_trunc_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x5c,0xd1,0x01,0x01,0x00,0x00]

v_trunc_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x5c,0xd1,0xff,0x01,0x00,0x00]

v_trunc_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x5c,0xd1,0x01,0x00,0x00,0x00]

v_trunc_f32_e64 v5, s101
// CHECK: [0x05,0x00,0x5c,0xd1,0x65,0x00,0x00,0x00]

v_trunc_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x5c,0xd1,0x66,0x00,0x00,0x00]

v_trunc_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x5c,0xd1,0x67,0x00,0x00,0x00]

v_trunc_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x5c,0xd1,0x6a,0x00,0x00,0x00]

v_trunc_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x5c,0xd1,0x6b,0x00,0x00,0x00]

v_trunc_f32_e64 v5, ttmp15
// CHECK: [0x05,0x00,0x5c,0xd1,0x7b,0x00,0x00,0x00]

v_trunc_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x5c,0xd1,0x7c,0x00,0x00,0x00]

v_trunc_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x5c,0xd1,0x7e,0x00,0x00,0x00]

v_trunc_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x5c,0xd1,0x7f,0x00,0x00,0x00]

v_trunc_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x5c,0xd1,0x80,0x00,0x00,0x00]

v_trunc_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x5c,0xd1,0xc1,0x00,0x00,0x00]

v_trunc_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x5c,0xd1,0xf0,0x00,0x00,0x00]

v_trunc_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x5c,0xd1,0xf7,0x00,0x00,0x00]

v_trunc_f32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x5c,0xd1,0xfb,0x00,0x00,0x00]

v_trunc_f32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x5c,0xd1,0xfc,0x00,0x00,0x00]

v_trunc_f32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x5c,0xd1,0xfd,0x00,0x00,0x00]

v_trunc_f32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x5c,0xd1,0xfe,0x00,0x00,0x00]

v_trunc_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x5c,0xd1,0x01,0x01,0x00,0x20]

v_trunc_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x5c,0xd1,0x01,0x01,0x00,0x00]

v_trunc_f32_e64 v5, v1 clamp
// CHECK: [0x05,0x80,0x5c,0xd1,0x01,0x01,0x00,0x00]

v_trunc_f32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x5c,0xd1,0x01,0x01,0x00,0x08]

v_trunc_f32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x5c,0xd1,0x01,0x01,0x00,0x10]

v_trunc_f32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x5c,0xd1,0x01,0x01,0x00,0x18]

v_ceil_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x5d,0xd1,0x01,0x01,0x00,0x00]

v_ceil_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x5d,0xd1,0x01,0x01,0x00,0x00]

v_ceil_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x5d,0xd1,0xff,0x01,0x00,0x00]

v_ceil_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x5d,0xd1,0x01,0x00,0x00,0x00]

v_ceil_f32_e64 v5, s101
// CHECK: [0x05,0x00,0x5d,0xd1,0x65,0x00,0x00,0x00]

v_ceil_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x5d,0xd1,0x66,0x00,0x00,0x00]

v_ceil_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x5d,0xd1,0x67,0x00,0x00,0x00]

v_ceil_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x5d,0xd1,0x6a,0x00,0x00,0x00]

v_ceil_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x5d,0xd1,0x6b,0x00,0x00,0x00]

v_ceil_f32_e64 v5, ttmp15
// CHECK: [0x05,0x00,0x5d,0xd1,0x7b,0x00,0x00,0x00]

v_ceil_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x5d,0xd1,0x7c,0x00,0x00,0x00]

v_ceil_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x5d,0xd1,0x7e,0x00,0x00,0x00]

v_ceil_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x5d,0xd1,0x7f,0x00,0x00,0x00]

v_ceil_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x5d,0xd1,0x80,0x00,0x00,0x00]

v_ceil_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x5d,0xd1,0xc1,0x00,0x00,0x00]

v_ceil_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x5d,0xd1,0xf0,0x00,0x00,0x00]

v_ceil_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x5d,0xd1,0xf7,0x00,0x00,0x00]

v_ceil_f32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x5d,0xd1,0xfb,0x00,0x00,0x00]

v_ceil_f32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x5d,0xd1,0xfc,0x00,0x00,0x00]

v_ceil_f32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x5d,0xd1,0xfd,0x00,0x00,0x00]

v_ceil_f32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x5d,0xd1,0xfe,0x00,0x00,0x00]

v_ceil_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x5d,0xd1,0x01,0x01,0x00,0x20]

v_ceil_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x5d,0xd1,0x01,0x01,0x00,0x00]

v_ceil_f32_e64 v5, v1 clamp
// CHECK: [0x05,0x80,0x5d,0xd1,0x01,0x01,0x00,0x00]

v_ceil_f32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x5d,0xd1,0x01,0x01,0x00,0x08]

v_ceil_f32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x5d,0xd1,0x01,0x01,0x00,0x10]

v_ceil_f32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x5d,0xd1,0x01,0x01,0x00,0x18]

v_rndne_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x5e,0xd1,0x01,0x01,0x00,0x00]

v_rndne_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x5e,0xd1,0x01,0x01,0x00,0x00]

v_rndne_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x5e,0xd1,0xff,0x01,0x00,0x00]

v_rndne_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x5e,0xd1,0x01,0x00,0x00,0x00]

v_rndne_f32_e64 v5, s101
// CHECK: [0x05,0x00,0x5e,0xd1,0x65,0x00,0x00,0x00]

v_rndne_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x5e,0xd1,0x66,0x00,0x00,0x00]

v_rndne_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x5e,0xd1,0x67,0x00,0x00,0x00]

v_rndne_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x5e,0xd1,0x6a,0x00,0x00,0x00]

v_rndne_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x5e,0xd1,0x6b,0x00,0x00,0x00]

v_rndne_f32_e64 v5, ttmp15
// CHECK: [0x05,0x00,0x5e,0xd1,0x7b,0x00,0x00,0x00]

v_rndne_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x5e,0xd1,0x7c,0x00,0x00,0x00]

v_rndne_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x5e,0xd1,0x7e,0x00,0x00,0x00]

v_rndne_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x5e,0xd1,0x7f,0x00,0x00,0x00]

v_rndne_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x5e,0xd1,0x80,0x00,0x00,0x00]

v_rndne_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x5e,0xd1,0xc1,0x00,0x00,0x00]

v_rndne_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x5e,0xd1,0xf0,0x00,0x00,0x00]

v_rndne_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x5e,0xd1,0xf7,0x00,0x00,0x00]

v_rndne_f32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x5e,0xd1,0xfb,0x00,0x00,0x00]

v_rndne_f32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x5e,0xd1,0xfc,0x00,0x00,0x00]

v_rndne_f32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x5e,0xd1,0xfd,0x00,0x00,0x00]

v_rndne_f32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x5e,0xd1,0xfe,0x00,0x00,0x00]

v_rndne_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x5e,0xd1,0x01,0x01,0x00,0x20]

v_rndne_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x5e,0xd1,0x01,0x01,0x00,0x00]

v_rndne_f32_e64 v5, v1 clamp
// CHECK: [0x05,0x80,0x5e,0xd1,0x01,0x01,0x00,0x00]

v_rndne_f32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x5e,0xd1,0x01,0x01,0x00,0x08]

v_rndne_f32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x5e,0xd1,0x01,0x01,0x00,0x10]

v_rndne_f32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x5e,0xd1,0x01,0x01,0x00,0x18]

v_floor_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x5f,0xd1,0x01,0x01,0x00,0x00]

v_floor_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x5f,0xd1,0x01,0x01,0x00,0x00]

v_floor_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x5f,0xd1,0xff,0x01,0x00,0x00]

v_floor_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x5f,0xd1,0x01,0x00,0x00,0x00]

v_floor_f32_e64 v5, s101
// CHECK: [0x05,0x00,0x5f,0xd1,0x65,0x00,0x00,0x00]

v_floor_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x5f,0xd1,0x66,0x00,0x00,0x00]

v_floor_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x5f,0xd1,0x67,0x00,0x00,0x00]

v_floor_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x5f,0xd1,0x6a,0x00,0x00,0x00]

v_floor_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x5f,0xd1,0x6b,0x00,0x00,0x00]

v_floor_f32_e64 v5, ttmp15
// CHECK: [0x05,0x00,0x5f,0xd1,0x7b,0x00,0x00,0x00]

v_floor_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x5f,0xd1,0x7c,0x00,0x00,0x00]

v_floor_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x5f,0xd1,0x7e,0x00,0x00,0x00]

v_floor_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x5f,0xd1,0x7f,0x00,0x00,0x00]

v_floor_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x5f,0xd1,0x80,0x00,0x00,0x00]

v_floor_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x5f,0xd1,0xc1,0x00,0x00,0x00]

v_floor_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x5f,0xd1,0xf0,0x00,0x00,0x00]

v_floor_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x5f,0xd1,0xf7,0x00,0x00,0x00]

v_floor_f32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x5f,0xd1,0xfb,0x00,0x00,0x00]

v_floor_f32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x5f,0xd1,0xfc,0x00,0x00,0x00]

v_floor_f32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x5f,0xd1,0xfd,0x00,0x00,0x00]

v_floor_f32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x5f,0xd1,0xfe,0x00,0x00,0x00]

v_floor_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x5f,0xd1,0x01,0x01,0x00,0x20]

v_floor_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x5f,0xd1,0x01,0x01,0x00,0x00]

v_floor_f32_e64 v5, v1 clamp
// CHECK: [0x05,0x80,0x5f,0xd1,0x01,0x01,0x00,0x00]

v_floor_f32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x5f,0xd1,0x01,0x01,0x00,0x08]

v_floor_f32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x5f,0xd1,0x01,0x01,0x00,0x10]

v_floor_f32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x5f,0xd1,0x01,0x01,0x00,0x18]

v_exp_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x60,0xd1,0x01,0x01,0x00,0x00]

v_exp_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x60,0xd1,0x01,0x01,0x00,0x00]

v_exp_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x60,0xd1,0xff,0x01,0x00,0x00]

v_exp_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x60,0xd1,0x01,0x00,0x00,0x00]

v_exp_f32_e64 v5, s101
// CHECK: [0x05,0x00,0x60,0xd1,0x65,0x00,0x00,0x00]

v_exp_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x60,0xd1,0x66,0x00,0x00,0x00]

v_exp_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x60,0xd1,0x67,0x00,0x00,0x00]

v_exp_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x60,0xd1,0x6a,0x00,0x00,0x00]

v_exp_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x60,0xd1,0x6b,0x00,0x00,0x00]

v_exp_f32_e64 v5, ttmp15
// CHECK: [0x05,0x00,0x60,0xd1,0x7b,0x00,0x00,0x00]

v_exp_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x60,0xd1,0x7c,0x00,0x00,0x00]

v_exp_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x60,0xd1,0x7e,0x00,0x00,0x00]

v_exp_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x60,0xd1,0x7f,0x00,0x00,0x00]

v_exp_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x60,0xd1,0x80,0x00,0x00,0x00]

v_exp_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x60,0xd1,0xc1,0x00,0x00,0x00]

v_exp_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x60,0xd1,0xf0,0x00,0x00,0x00]

v_exp_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x60,0xd1,0xf7,0x00,0x00,0x00]

v_exp_f32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x60,0xd1,0xfb,0x00,0x00,0x00]

v_exp_f32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x60,0xd1,0xfc,0x00,0x00,0x00]

v_exp_f32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x60,0xd1,0xfd,0x00,0x00,0x00]

v_exp_f32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x60,0xd1,0xfe,0x00,0x00,0x00]

v_exp_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x60,0xd1,0x01,0x01,0x00,0x20]

v_exp_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x60,0xd1,0x01,0x01,0x00,0x00]

v_exp_f32_e64 v5, v1 clamp
// CHECK: [0x05,0x80,0x60,0xd1,0x01,0x01,0x00,0x00]

v_exp_f32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x60,0xd1,0x01,0x01,0x00,0x08]

v_exp_f32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x60,0xd1,0x01,0x01,0x00,0x10]

v_exp_f32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x60,0xd1,0x01,0x01,0x00,0x18]

v_log_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x61,0xd1,0x01,0x01,0x00,0x00]

v_log_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x61,0xd1,0x01,0x01,0x00,0x00]

v_log_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x61,0xd1,0xff,0x01,0x00,0x00]

v_log_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x61,0xd1,0x01,0x00,0x00,0x00]

v_log_f32_e64 v5, s101
// CHECK: [0x05,0x00,0x61,0xd1,0x65,0x00,0x00,0x00]

v_log_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x61,0xd1,0x66,0x00,0x00,0x00]

v_log_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x61,0xd1,0x67,0x00,0x00,0x00]

v_log_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x61,0xd1,0x6a,0x00,0x00,0x00]

v_log_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x61,0xd1,0x6b,0x00,0x00,0x00]

v_log_f32_e64 v5, ttmp15
// CHECK: [0x05,0x00,0x61,0xd1,0x7b,0x00,0x00,0x00]

v_log_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x61,0xd1,0x7c,0x00,0x00,0x00]

v_log_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x61,0xd1,0x7e,0x00,0x00,0x00]

v_log_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x61,0xd1,0x7f,0x00,0x00,0x00]

v_log_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x61,0xd1,0x80,0x00,0x00,0x00]

v_log_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x61,0xd1,0xc1,0x00,0x00,0x00]

v_log_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x61,0xd1,0xf0,0x00,0x00,0x00]

v_log_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x61,0xd1,0xf7,0x00,0x00,0x00]

v_log_f32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x61,0xd1,0xfb,0x00,0x00,0x00]

v_log_f32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x61,0xd1,0xfc,0x00,0x00,0x00]

v_log_f32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x61,0xd1,0xfd,0x00,0x00,0x00]

v_log_f32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x61,0xd1,0xfe,0x00,0x00,0x00]

v_log_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x61,0xd1,0x01,0x01,0x00,0x20]

v_log_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x61,0xd1,0x01,0x01,0x00,0x00]

v_log_f32_e64 v5, v1 clamp
// CHECK: [0x05,0x80,0x61,0xd1,0x01,0x01,0x00,0x00]

v_log_f32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x61,0xd1,0x01,0x01,0x00,0x08]

v_log_f32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x61,0xd1,0x01,0x01,0x00,0x10]

v_log_f32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x61,0xd1,0x01,0x01,0x00,0x18]

v_rcp_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x62,0xd1,0x01,0x01,0x00,0x00]

v_rcp_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x62,0xd1,0x01,0x01,0x00,0x00]

v_rcp_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x62,0xd1,0xff,0x01,0x00,0x00]

v_rcp_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x62,0xd1,0x01,0x00,0x00,0x00]

v_rcp_f32_e64 v5, s101
// CHECK: [0x05,0x00,0x62,0xd1,0x65,0x00,0x00,0x00]

v_rcp_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x62,0xd1,0x66,0x00,0x00,0x00]

v_rcp_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x62,0xd1,0x67,0x00,0x00,0x00]

v_rcp_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x62,0xd1,0x6a,0x00,0x00,0x00]

v_rcp_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x62,0xd1,0x6b,0x00,0x00,0x00]

v_rcp_f32_e64 v5, ttmp15
// CHECK: [0x05,0x00,0x62,0xd1,0x7b,0x00,0x00,0x00]

v_rcp_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x62,0xd1,0x7c,0x00,0x00,0x00]

v_rcp_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x62,0xd1,0x7e,0x00,0x00,0x00]

v_rcp_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x62,0xd1,0x7f,0x00,0x00,0x00]

v_rcp_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x62,0xd1,0x80,0x00,0x00,0x00]

v_rcp_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x62,0xd1,0xc1,0x00,0x00,0x00]

v_rcp_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x62,0xd1,0xf0,0x00,0x00,0x00]

v_rcp_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x62,0xd1,0xf7,0x00,0x00,0x00]

v_rcp_f32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x62,0xd1,0xfb,0x00,0x00,0x00]

v_rcp_f32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x62,0xd1,0xfc,0x00,0x00,0x00]

v_rcp_f32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x62,0xd1,0xfd,0x00,0x00,0x00]

v_rcp_f32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x62,0xd1,0xfe,0x00,0x00,0x00]

v_rcp_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x62,0xd1,0x01,0x01,0x00,0x20]

v_rcp_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x62,0xd1,0x01,0x01,0x00,0x00]

v_rcp_f32_e64 v5, v1 clamp
// CHECK: [0x05,0x80,0x62,0xd1,0x01,0x01,0x00,0x00]

v_rcp_f32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x62,0xd1,0x01,0x01,0x00,0x08]

v_rcp_f32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x62,0xd1,0x01,0x01,0x00,0x10]

v_rcp_f32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x62,0xd1,0x01,0x01,0x00,0x18]

v_rcp_iflag_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x63,0xd1,0x01,0x01,0x00,0x00]

v_rcp_iflag_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x63,0xd1,0x01,0x01,0x00,0x00]

v_rcp_iflag_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x63,0xd1,0xff,0x01,0x00,0x00]

v_rcp_iflag_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x63,0xd1,0x01,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, s101
// CHECK: [0x05,0x00,0x63,0xd1,0x65,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x63,0xd1,0x66,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x63,0xd1,0x67,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x63,0xd1,0x6a,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x63,0xd1,0x6b,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, ttmp15
// CHECK: [0x05,0x00,0x63,0xd1,0x7b,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x63,0xd1,0x7c,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x63,0xd1,0x7e,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x63,0xd1,0x7f,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x63,0xd1,0x80,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x63,0xd1,0xc1,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x63,0xd1,0xf0,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x63,0xd1,0xf7,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x63,0xd1,0xfb,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x63,0xd1,0xfc,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x63,0xd1,0xfd,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x63,0xd1,0xfe,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x63,0xd1,0x01,0x01,0x00,0x20]

v_rcp_iflag_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x63,0xd1,0x01,0x01,0x00,0x00]

v_rcp_iflag_f32_e64 v5, v1 clamp
// CHECK: [0x05,0x80,0x63,0xd1,0x01,0x01,0x00,0x00]

v_rcp_iflag_f32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x63,0xd1,0x01,0x01,0x00,0x08]

v_rcp_iflag_f32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x63,0xd1,0x01,0x01,0x00,0x10]

v_rcp_iflag_f32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x63,0xd1,0x01,0x01,0x00,0x18]

v_rsq_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x64,0xd1,0x01,0x01,0x00,0x00]

v_rsq_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x64,0xd1,0x01,0x01,0x00,0x00]

v_rsq_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x64,0xd1,0xff,0x01,0x00,0x00]

v_rsq_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x64,0xd1,0x01,0x00,0x00,0x00]

v_rsq_f32_e64 v5, s101
// CHECK: [0x05,0x00,0x64,0xd1,0x65,0x00,0x00,0x00]

v_rsq_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x64,0xd1,0x66,0x00,0x00,0x00]

v_rsq_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x64,0xd1,0x67,0x00,0x00,0x00]

v_rsq_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x64,0xd1,0x6a,0x00,0x00,0x00]

v_rsq_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x64,0xd1,0x6b,0x00,0x00,0x00]

v_rsq_f32_e64 v5, ttmp15
// CHECK: [0x05,0x00,0x64,0xd1,0x7b,0x00,0x00,0x00]

v_rsq_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x64,0xd1,0x7c,0x00,0x00,0x00]

v_rsq_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x64,0xd1,0x7e,0x00,0x00,0x00]

v_rsq_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x64,0xd1,0x7f,0x00,0x00,0x00]

v_rsq_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x64,0xd1,0x80,0x00,0x00,0x00]

v_rsq_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x64,0xd1,0xc1,0x00,0x00,0x00]

v_rsq_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x64,0xd1,0xf0,0x00,0x00,0x00]

v_rsq_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x64,0xd1,0xf7,0x00,0x00,0x00]

v_rsq_f32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x64,0xd1,0xfb,0x00,0x00,0x00]

v_rsq_f32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x64,0xd1,0xfc,0x00,0x00,0x00]

v_rsq_f32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x64,0xd1,0xfd,0x00,0x00,0x00]

v_rsq_f32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x64,0xd1,0xfe,0x00,0x00,0x00]

v_rsq_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x64,0xd1,0x01,0x01,0x00,0x20]

v_rsq_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x64,0xd1,0x01,0x01,0x00,0x00]

v_rsq_f32_e64 v5, v1 clamp
// CHECK: [0x05,0x80,0x64,0xd1,0x01,0x01,0x00,0x00]

v_rsq_f32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x64,0xd1,0x01,0x01,0x00,0x08]

v_rsq_f32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x64,0xd1,0x01,0x01,0x00,0x10]

v_rsq_f32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x64,0xd1,0x01,0x01,0x00,0x18]

v_rcp_f64_e64 v[5:6], v[1:2]
// CHECK: [0x05,0x00,0x65,0xd1,0x01,0x01,0x00,0x00]

v_rcp_f64_e64 v[254:255], v[1:2]
// CHECK: [0xfe,0x00,0x65,0xd1,0x01,0x01,0x00,0x00]

v_rcp_f64_e64 v[5:6], v[254:255]
// CHECK: [0x05,0x00,0x65,0xd1,0xfe,0x01,0x00,0x00]

v_rcp_f64_e64 v[5:6], s[2:3]
// CHECK: [0x05,0x00,0x65,0xd1,0x02,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], s[4:5]
// CHECK: [0x05,0x00,0x65,0xd1,0x04,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], s[100:101]
// CHECK: [0x05,0x00,0x65,0xd1,0x64,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], flat_scratch
// CHECK: [0x05,0x00,0x65,0xd1,0x66,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], vcc
// CHECK: [0x05,0x00,0x65,0xd1,0x6a,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], ttmp[14:15]
// CHECK: [0x05,0x00,0x65,0xd1,0x7a,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], exec
// CHECK: [0x05,0x00,0x65,0xd1,0x7e,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], 0
// CHECK: [0x05,0x00,0x65,0xd1,0x80,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], -1
// CHECK: [0x05,0x00,0x65,0xd1,0xc1,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], 0.5
// CHECK: [0x05,0x00,0x65,0xd1,0xf0,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], -4.0
// CHECK: [0x05,0x00,0x65,0xd1,0xf7,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], src_vccz
// CHECK: [0x05,0x00,0x65,0xd1,0xfb,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], src_execz
// CHECK: [0x05,0x00,0x65,0xd1,0xfc,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], src_scc
// CHECK: [0x05,0x00,0x65,0xd1,0xfd,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], -v[1:2]
// CHECK: [0x05,0x00,0x65,0xd1,0x01,0x01,0x00,0x20]

v_rcp_f64_e64 v[5:6], |v[1:2]|
// CHECK: [0x05,0x01,0x65,0xd1,0x01,0x01,0x00,0x00]

v_rcp_f64_e64 v[5:6], v[1:2] clamp
// CHECK: [0x05,0x80,0x65,0xd1,0x01,0x01,0x00,0x00]

v_rcp_f64_e64 v[5:6], v[1:2] mul:2
// CHECK: [0x05,0x00,0x65,0xd1,0x01,0x01,0x00,0x08]

v_rcp_f64_e64 v[5:6], v[1:2] mul:4
// CHECK: [0x05,0x00,0x65,0xd1,0x01,0x01,0x00,0x10]

v_rcp_f64_e64 v[5:6], v[1:2] div:2
// CHECK: [0x05,0x00,0x65,0xd1,0x01,0x01,0x00,0x18]

v_rsq_f64_e64 v[5:6], v[1:2]
// CHECK: [0x05,0x00,0x66,0xd1,0x01,0x01,0x00,0x00]

v_rsq_f64_e64 v[254:255], v[1:2]
// CHECK: [0xfe,0x00,0x66,0xd1,0x01,0x01,0x00,0x00]

v_rsq_f64_e64 v[5:6], v[254:255]
// CHECK: [0x05,0x00,0x66,0xd1,0xfe,0x01,0x00,0x00]

v_rsq_f64_e64 v[5:6], s[2:3]
// CHECK: [0x05,0x00,0x66,0xd1,0x02,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], s[4:5]
// CHECK: [0x05,0x00,0x66,0xd1,0x04,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], s[100:101]
// CHECK: [0x05,0x00,0x66,0xd1,0x64,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], flat_scratch
// CHECK: [0x05,0x00,0x66,0xd1,0x66,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], vcc
// CHECK: [0x05,0x00,0x66,0xd1,0x6a,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], ttmp[14:15]
// CHECK: [0x05,0x00,0x66,0xd1,0x7a,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], exec
// CHECK: [0x05,0x00,0x66,0xd1,0x7e,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], 0
// CHECK: [0x05,0x00,0x66,0xd1,0x80,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], -1
// CHECK: [0x05,0x00,0x66,0xd1,0xc1,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], 0.5
// CHECK: [0x05,0x00,0x66,0xd1,0xf0,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], -4.0
// CHECK: [0x05,0x00,0x66,0xd1,0xf7,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], src_vccz
// CHECK: [0x05,0x00,0x66,0xd1,0xfb,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], src_execz
// CHECK: [0x05,0x00,0x66,0xd1,0xfc,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], src_scc
// CHECK: [0x05,0x00,0x66,0xd1,0xfd,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], -v[1:2]
// CHECK: [0x05,0x00,0x66,0xd1,0x01,0x01,0x00,0x20]

v_rsq_f64_e64 v[5:6], |v[1:2]|
// CHECK: [0x05,0x01,0x66,0xd1,0x01,0x01,0x00,0x00]

v_rsq_f64_e64 v[5:6], v[1:2] clamp
// CHECK: [0x05,0x80,0x66,0xd1,0x01,0x01,0x00,0x00]

v_rsq_f64_e64 v[5:6], v[1:2] mul:2
// CHECK: [0x05,0x00,0x66,0xd1,0x01,0x01,0x00,0x08]

v_rsq_f64_e64 v[5:6], v[1:2] mul:4
// CHECK: [0x05,0x00,0x66,0xd1,0x01,0x01,0x00,0x10]

v_rsq_f64_e64 v[5:6], v[1:2] div:2
// CHECK: [0x05,0x00,0x66,0xd1,0x01,0x01,0x00,0x18]

v_sqrt_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x67,0xd1,0x01,0x01,0x00,0x00]

v_sqrt_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x67,0xd1,0x01,0x01,0x00,0x00]

v_sqrt_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x67,0xd1,0xff,0x01,0x00,0x00]

v_sqrt_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x67,0xd1,0x01,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, s101
// CHECK: [0x05,0x00,0x67,0xd1,0x65,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x67,0xd1,0x66,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x67,0xd1,0x67,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x67,0xd1,0x6a,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x67,0xd1,0x6b,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, ttmp15
// CHECK: [0x05,0x00,0x67,0xd1,0x7b,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x67,0xd1,0x7c,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x67,0xd1,0x7e,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x67,0xd1,0x7f,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x67,0xd1,0x80,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x67,0xd1,0xc1,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x67,0xd1,0xf0,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x67,0xd1,0xf7,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x67,0xd1,0xfb,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x67,0xd1,0xfc,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x67,0xd1,0xfd,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x67,0xd1,0xfe,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x67,0xd1,0x01,0x01,0x00,0x20]

v_sqrt_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x67,0xd1,0x01,0x01,0x00,0x00]

v_sqrt_f32_e64 v5, v1 clamp
// CHECK: [0x05,0x80,0x67,0xd1,0x01,0x01,0x00,0x00]

v_sqrt_f32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x67,0xd1,0x01,0x01,0x00,0x08]

v_sqrt_f32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x67,0xd1,0x01,0x01,0x00,0x10]

v_sqrt_f32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x67,0xd1,0x01,0x01,0x00,0x18]

v_sqrt_f64_e64 v[5:6], v[1:2]
// CHECK: [0x05,0x00,0x68,0xd1,0x01,0x01,0x00,0x00]

v_sqrt_f64_e64 v[254:255], v[1:2]
// CHECK: [0xfe,0x00,0x68,0xd1,0x01,0x01,0x00,0x00]

v_sqrt_f64_e64 v[5:6], v[254:255]
// CHECK: [0x05,0x00,0x68,0xd1,0xfe,0x01,0x00,0x00]

v_sqrt_f64_e64 v[5:6], s[2:3]
// CHECK: [0x05,0x00,0x68,0xd1,0x02,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], s[4:5]
// CHECK: [0x05,0x00,0x68,0xd1,0x04,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], s[100:101]
// CHECK: [0x05,0x00,0x68,0xd1,0x64,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], flat_scratch
// CHECK: [0x05,0x00,0x68,0xd1,0x66,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], vcc
// CHECK: [0x05,0x00,0x68,0xd1,0x6a,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], ttmp[14:15]
// CHECK: [0x05,0x00,0x68,0xd1,0x7a,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], exec
// CHECK: [0x05,0x00,0x68,0xd1,0x7e,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], 0
// CHECK: [0x05,0x00,0x68,0xd1,0x80,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], -1
// CHECK: [0x05,0x00,0x68,0xd1,0xc1,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], 0.5
// CHECK: [0x05,0x00,0x68,0xd1,0xf0,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], -4.0
// CHECK: [0x05,0x00,0x68,0xd1,0xf7,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], src_vccz
// CHECK: [0x05,0x00,0x68,0xd1,0xfb,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], src_execz
// CHECK: [0x05,0x00,0x68,0xd1,0xfc,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], src_scc
// CHECK: [0x05,0x00,0x68,0xd1,0xfd,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], -v[1:2]
// CHECK: [0x05,0x00,0x68,0xd1,0x01,0x01,0x00,0x20]

v_sqrt_f64_e64 v[5:6], |v[1:2]|
// CHECK: [0x05,0x01,0x68,0xd1,0x01,0x01,0x00,0x00]

v_sqrt_f64_e64 v[5:6], v[1:2] clamp
// CHECK: [0x05,0x80,0x68,0xd1,0x01,0x01,0x00,0x00]

v_sqrt_f64_e64 v[5:6], v[1:2] mul:2
// CHECK: [0x05,0x00,0x68,0xd1,0x01,0x01,0x00,0x08]

v_sqrt_f64_e64 v[5:6], v[1:2] mul:4
// CHECK: [0x05,0x00,0x68,0xd1,0x01,0x01,0x00,0x10]

v_sqrt_f64_e64 v[5:6], v[1:2] div:2
// CHECK: [0x05,0x00,0x68,0xd1,0x01,0x01,0x00,0x18]

v_sin_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x69,0xd1,0x01,0x01,0x00,0x00]

v_sin_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x69,0xd1,0x01,0x01,0x00,0x00]

v_sin_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x69,0xd1,0xff,0x01,0x00,0x00]

v_sin_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x69,0xd1,0x01,0x00,0x00,0x00]

v_sin_f32_e64 v5, s101
// CHECK: [0x05,0x00,0x69,0xd1,0x65,0x00,0x00,0x00]

v_sin_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x69,0xd1,0x66,0x00,0x00,0x00]

v_sin_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x69,0xd1,0x67,0x00,0x00,0x00]

v_sin_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x69,0xd1,0x6a,0x00,0x00,0x00]

v_sin_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x69,0xd1,0x6b,0x00,0x00,0x00]

v_sin_f32_e64 v5, ttmp15
// CHECK: [0x05,0x00,0x69,0xd1,0x7b,0x00,0x00,0x00]

v_sin_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x69,0xd1,0x7c,0x00,0x00,0x00]

v_sin_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x69,0xd1,0x7e,0x00,0x00,0x00]

v_sin_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x69,0xd1,0x7f,0x00,0x00,0x00]

v_sin_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x69,0xd1,0x80,0x00,0x00,0x00]

v_sin_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x69,0xd1,0xc1,0x00,0x00,0x00]

v_sin_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x69,0xd1,0xf0,0x00,0x00,0x00]

v_sin_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x69,0xd1,0xf7,0x00,0x00,0x00]

v_sin_f32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x69,0xd1,0xfb,0x00,0x00,0x00]

v_sin_f32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x69,0xd1,0xfc,0x00,0x00,0x00]

v_sin_f32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x69,0xd1,0xfd,0x00,0x00,0x00]

v_sin_f32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x69,0xd1,0xfe,0x00,0x00,0x00]

v_sin_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x69,0xd1,0x01,0x01,0x00,0x20]

v_sin_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x69,0xd1,0x01,0x01,0x00,0x00]

v_sin_f32_e64 v5, v1 clamp
// CHECK: [0x05,0x80,0x69,0xd1,0x01,0x01,0x00,0x00]

v_sin_f32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x69,0xd1,0x01,0x01,0x00,0x08]

v_sin_f32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x69,0xd1,0x01,0x01,0x00,0x10]

v_sin_f32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x69,0xd1,0x01,0x01,0x00,0x18]

v_cos_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x6a,0xd1,0x01,0x01,0x00,0x00]

v_cos_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x6a,0xd1,0x01,0x01,0x00,0x00]

v_cos_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x6a,0xd1,0xff,0x01,0x00,0x00]

v_cos_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x6a,0xd1,0x01,0x00,0x00,0x00]

v_cos_f32_e64 v5, s101
// CHECK: [0x05,0x00,0x6a,0xd1,0x65,0x00,0x00,0x00]

v_cos_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x6a,0xd1,0x66,0x00,0x00,0x00]

v_cos_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x6a,0xd1,0x67,0x00,0x00,0x00]

v_cos_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x6a,0xd1,0x6a,0x00,0x00,0x00]

v_cos_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x6a,0xd1,0x6b,0x00,0x00,0x00]

v_cos_f32_e64 v5, ttmp15
// CHECK: [0x05,0x00,0x6a,0xd1,0x7b,0x00,0x00,0x00]

v_cos_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x6a,0xd1,0x7c,0x00,0x00,0x00]

v_cos_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x6a,0xd1,0x7e,0x00,0x00,0x00]

v_cos_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x6a,0xd1,0x7f,0x00,0x00,0x00]

v_cos_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x6a,0xd1,0x80,0x00,0x00,0x00]

v_cos_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x6a,0xd1,0xc1,0x00,0x00,0x00]

v_cos_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x6a,0xd1,0xf0,0x00,0x00,0x00]

v_cos_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x6a,0xd1,0xf7,0x00,0x00,0x00]

v_cos_f32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x6a,0xd1,0xfb,0x00,0x00,0x00]

v_cos_f32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x6a,0xd1,0xfc,0x00,0x00,0x00]

v_cos_f32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x6a,0xd1,0xfd,0x00,0x00,0x00]

v_cos_f32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x6a,0xd1,0xfe,0x00,0x00,0x00]

v_cos_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x6a,0xd1,0x01,0x01,0x00,0x20]

v_cos_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x6a,0xd1,0x01,0x01,0x00,0x00]

v_cos_f32_e64 v5, v1 clamp
// CHECK: [0x05,0x80,0x6a,0xd1,0x01,0x01,0x00,0x00]

v_cos_f32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x6a,0xd1,0x01,0x01,0x00,0x08]

v_cos_f32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x6a,0xd1,0x01,0x01,0x00,0x10]

v_cos_f32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x6a,0xd1,0x01,0x01,0x00,0x18]

v_not_b32_e64 v5, v1
// CHECK: [0x05,0x00,0x6b,0xd1,0x01,0x01,0x00,0x00]

v_not_b32_e64 v255, v1
// CHECK: [0xff,0x00,0x6b,0xd1,0x01,0x01,0x00,0x00]

v_not_b32_e64 v5, v255
// CHECK: [0x05,0x00,0x6b,0xd1,0xff,0x01,0x00,0x00]

v_not_b32_e64 v5, s1
// CHECK: [0x05,0x00,0x6b,0xd1,0x01,0x00,0x00,0x00]

v_not_b32_e64 v5, s101
// CHECK: [0x05,0x00,0x6b,0xd1,0x65,0x00,0x00,0x00]

v_not_b32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x6b,0xd1,0x66,0x00,0x00,0x00]

v_not_b32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x6b,0xd1,0x67,0x00,0x00,0x00]

v_not_b32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x6b,0xd1,0x6a,0x00,0x00,0x00]

v_not_b32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x6b,0xd1,0x6b,0x00,0x00,0x00]

v_not_b32_e64 v5, ttmp15
// CHECK: [0x05,0x00,0x6b,0xd1,0x7b,0x00,0x00,0x00]

v_not_b32_e64 v5, m0
// CHECK: [0x05,0x00,0x6b,0xd1,0x7c,0x00,0x00,0x00]

v_not_b32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x6b,0xd1,0x7e,0x00,0x00,0x00]

v_not_b32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x6b,0xd1,0x7f,0x00,0x00,0x00]

v_not_b32_e64 v5, 0
// CHECK: [0x05,0x00,0x6b,0xd1,0x80,0x00,0x00,0x00]

v_not_b32_e64 v5, -1
// CHECK: [0x05,0x00,0x6b,0xd1,0xc1,0x00,0x00,0x00]

v_not_b32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x6b,0xd1,0xf0,0x00,0x00,0x00]

v_not_b32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x6b,0xd1,0xf7,0x00,0x00,0x00]

v_not_b32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x6b,0xd1,0xfb,0x00,0x00,0x00]

v_not_b32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x6b,0xd1,0xfc,0x00,0x00,0x00]

v_not_b32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x6b,0xd1,0xfd,0x00,0x00,0x00]

v_not_b32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x6b,0xd1,0xfe,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, v1
// CHECK: [0x05,0x00,0x6c,0xd1,0x01,0x01,0x00,0x00]

v_bfrev_b32_e64 v255, v1
// CHECK: [0xff,0x00,0x6c,0xd1,0x01,0x01,0x00,0x00]

v_bfrev_b32_e64 v5, v255
// CHECK: [0x05,0x00,0x6c,0xd1,0xff,0x01,0x00,0x00]

v_bfrev_b32_e64 v5, s1
// CHECK: [0x05,0x00,0x6c,0xd1,0x01,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, s101
// CHECK: [0x05,0x00,0x6c,0xd1,0x65,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x6c,0xd1,0x66,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x6c,0xd1,0x67,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x6c,0xd1,0x6a,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x6c,0xd1,0x6b,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, ttmp15
// CHECK: [0x05,0x00,0x6c,0xd1,0x7b,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, m0
// CHECK: [0x05,0x00,0x6c,0xd1,0x7c,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x6c,0xd1,0x7e,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x6c,0xd1,0x7f,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, 0
// CHECK: [0x05,0x00,0x6c,0xd1,0x80,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, -1
// CHECK: [0x05,0x00,0x6c,0xd1,0xc1,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x6c,0xd1,0xf0,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x6c,0xd1,0xf7,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x6c,0xd1,0xfb,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x6c,0xd1,0xfc,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x6c,0xd1,0xfd,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x6c,0xd1,0xfe,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, v1
// CHECK: [0x05,0x00,0x6d,0xd1,0x01,0x01,0x00,0x00]

v_ffbh_u32_e64 v255, v1
// CHECK: [0xff,0x00,0x6d,0xd1,0x01,0x01,0x00,0x00]

v_ffbh_u32_e64 v5, v255
// CHECK: [0x05,0x00,0x6d,0xd1,0xff,0x01,0x00,0x00]

v_ffbh_u32_e64 v5, s1
// CHECK: [0x05,0x00,0x6d,0xd1,0x01,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, s101
// CHECK: [0x05,0x00,0x6d,0xd1,0x65,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x6d,0xd1,0x66,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x6d,0xd1,0x67,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x6d,0xd1,0x6a,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x6d,0xd1,0x6b,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, ttmp15
// CHECK: [0x05,0x00,0x6d,0xd1,0x7b,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, m0
// CHECK: [0x05,0x00,0x6d,0xd1,0x7c,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x6d,0xd1,0x7e,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x6d,0xd1,0x7f,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, 0
// CHECK: [0x05,0x00,0x6d,0xd1,0x80,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, -1
// CHECK: [0x05,0x00,0x6d,0xd1,0xc1,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x6d,0xd1,0xf0,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x6d,0xd1,0xf7,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x6d,0xd1,0xfb,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x6d,0xd1,0xfc,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x6d,0xd1,0xfd,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x6d,0xd1,0xfe,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, v1
// CHECK: [0x05,0x00,0x6e,0xd1,0x01,0x01,0x00,0x00]

v_ffbl_b32_e64 v255, v1
// CHECK: [0xff,0x00,0x6e,0xd1,0x01,0x01,0x00,0x00]

v_ffbl_b32_e64 v5, v255
// CHECK: [0x05,0x00,0x6e,0xd1,0xff,0x01,0x00,0x00]

v_ffbl_b32_e64 v5, s1
// CHECK: [0x05,0x00,0x6e,0xd1,0x01,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, s101
// CHECK: [0x05,0x00,0x6e,0xd1,0x65,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x6e,0xd1,0x66,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x6e,0xd1,0x67,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x6e,0xd1,0x6a,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x6e,0xd1,0x6b,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, ttmp15
// CHECK: [0x05,0x00,0x6e,0xd1,0x7b,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, m0
// CHECK: [0x05,0x00,0x6e,0xd1,0x7c,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x6e,0xd1,0x7e,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x6e,0xd1,0x7f,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, 0
// CHECK: [0x05,0x00,0x6e,0xd1,0x80,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, -1
// CHECK: [0x05,0x00,0x6e,0xd1,0xc1,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x6e,0xd1,0xf0,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x6e,0xd1,0xf7,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x6e,0xd1,0xfb,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x6e,0xd1,0xfc,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x6e,0xd1,0xfd,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x6e,0xd1,0xfe,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, v1
// CHECK: [0x05,0x00,0x6f,0xd1,0x01,0x01,0x00,0x00]

v_ffbh_i32_e64 v255, v1
// CHECK: [0xff,0x00,0x6f,0xd1,0x01,0x01,0x00,0x00]

v_ffbh_i32_e64 v5, v255
// CHECK: [0x05,0x00,0x6f,0xd1,0xff,0x01,0x00,0x00]

v_ffbh_i32_e64 v5, s1
// CHECK: [0x05,0x00,0x6f,0xd1,0x01,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, s101
// CHECK: [0x05,0x00,0x6f,0xd1,0x65,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x6f,0xd1,0x66,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x6f,0xd1,0x67,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x6f,0xd1,0x6a,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x6f,0xd1,0x6b,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, ttmp15
// CHECK: [0x05,0x00,0x6f,0xd1,0x7b,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, m0
// CHECK: [0x05,0x00,0x6f,0xd1,0x7c,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x6f,0xd1,0x7e,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x6f,0xd1,0x7f,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, 0
// CHECK: [0x05,0x00,0x6f,0xd1,0x80,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, -1
// CHECK: [0x05,0x00,0x6f,0xd1,0xc1,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x6f,0xd1,0xf0,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x6f,0xd1,0xf7,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x6f,0xd1,0xfb,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x6f,0xd1,0xfc,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x6f,0xd1,0xfd,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x6f,0xd1,0xfe,0x00,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, v[1:2]
// CHECK: [0x05,0x00,0x70,0xd1,0x01,0x01,0x00,0x00]

v_frexp_exp_i32_f64_e64 v255, v[1:2]
// CHECK: [0xff,0x00,0x70,0xd1,0x01,0x01,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, v[254:255]
// CHECK: [0x05,0x00,0x70,0xd1,0xfe,0x01,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, s[2:3]
// CHECK: [0x05,0x00,0x70,0xd1,0x02,0x00,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, s[4:5]
// CHECK: [0x05,0x00,0x70,0xd1,0x04,0x00,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, s[100:101]
// CHECK: [0x05,0x00,0x70,0xd1,0x64,0x00,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, flat_scratch
// CHECK: [0x05,0x00,0x70,0xd1,0x66,0x00,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, vcc
// CHECK: [0x05,0x00,0x70,0xd1,0x6a,0x00,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, ttmp[14:15]
// CHECK: [0x05,0x00,0x70,0xd1,0x7a,0x00,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, exec
// CHECK: [0x05,0x00,0x70,0xd1,0x7e,0x00,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, 0
// CHECK: [0x05,0x00,0x70,0xd1,0x80,0x00,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, -1
// CHECK: [0x05,0x00,0x70,0xd1,0xc1,0x00,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, 0.5
// CHECK: [0x05,0x00,0x70,0xd1,0xf0,0x00,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, -4.0
// CHECK: [0x05,0x00,0x70,0xd1,0xf7,0x00,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x70,0xd1,0xfb,0x00,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, src_execz
// CHECK: [0x05,0x00,0x70,0xd1,0xfc,0x00,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, src_scc
// CHECK: [0x05,0x00,0x70,0xd1,0xfd,0x00,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, -v[1:2]
// CHECK: [0x05,0x00,0x70,0xd1,0x01,0x01,0x00,0x20]

v_frexp_exp_i32_f64_e64 v5, |v[1:2]|
// CHECK: [0x05,0x01,0x70,0xd1,0x01,0x01,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], v[1:2]
// CHECK: [0x05,0x00,0x71,0xd1,0x01,0x01,0x00,0x00]

v_frexp_mant_f64_e64 v[254:255], v[1:2]
// CHECK: [0xfe,0x00,0x71,0xd1,0x01,0x01,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], v[254:255]
// CHECK: [0x05,0x00,0x71,0xd1,0xfe,0x01,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], s[2:3]
// CHECK: [0x05,0x00,0x71,0xd1,0x02,0x00,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], s[4:5]
// CHECK: [0x05,0x00,0x71,0xd1,0x04,0x00,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], s[100:101]
// CHECK: [0x05,0x00,0x71,0xd1,0x64,0x00,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], flat_scratch
// CHECK: [0x05,0x00,0x71,0xd1,0x66,0x00,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], vcc
// CHECK: [0x05,0x00,0x71,0xd1,0x6a,0x00,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], ttmp[14:15]
// CHECK: [0x05,0x00,0x71,0xd1,0x7a,0x00,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], exec
// CHECK: [0x05,0x00,0x71,0xd1,0x7e,0x00,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], 0
// CHECK: [0x05,0x00,0x71,0xd1,0x80,0x00,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], -1
// CHECK: [0x05,0x00,0x71,0xd1,0xc1,0x00,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], 0.5
// CHECK: [0x05,0x00,0x71,0xd1,0xf0,0x00,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], -4.0
// CHECK: [0x05,0x00,0x71,0xd1,0xf7,0x00,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], src_vccz
// CHECK: [0x05,0x00,0x71,0xd1,0xfb,0x00,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], src_execz
// CHECK: [0x05,0x00,0x71,0xd1,0xfc,0x00,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], src_scc
// CHECK: [0x05,0x00,0x71,0xd1,0xfd,0x00,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], -v[1:2]
// CHECK: [0x05,0x00,0x71,0xd1,0x01,0x01,0x00,0x20]

v_frexp_mant_f64_e64 v[5:6], |v[1:2]|
// CHECK: [0x05,0x01,0x71,0xd1,0x01,0x01,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], v[1:2] clamp
// CHECK: [0x05,0x80,0x71,0xd1,0x01,0x01,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], v[1:2] mul:2
// CHECK: [0x05,0x00,0x71,0xd1,0x01,0x01,0x00,0x08]

v_frexp_mant_f64_e64 v[5:6], v[1:2] mul:4
// CHECK: [0x05,0x00,0x71,0xd1,0x01,0x01,0x00,0x10]

v_frexp_mant_f64_e64 v[5:6], v[1:2] div:2
// CHECK: [0x05,0x00,0x71,0xd1,0x01,0x01,0x00,0x18]

v_fract_f64_e64 v[5:6], v[1:2]
// CHECK: [0x05,0x00,0x72,0xd1,0x01,0x01,0x00,0x00]

v_fract_f64_e64 v[254:255], v[1:2]
// CHECK: [0xfe,0x00,0x72,0xd1,0x01,0x01,0x00,0x00]

v_fract_f64_e64 v[5:6], v[254:255]
// CHECK: [0x05,0x00,0x72,0xd1,0xfe,0x01,0x00,0x00]

v_fract_f64_e64 v[5:6], s[2:3]
// CHECK: [0x05,0x00,0x72,0xd1,0x02,0x00,0x00,0x00]

v_fract_f64_e64 v[5:6], s[4:5]
// CHECK: [0x05,0x00,0x72,0xd1,0x04,0x00,0x00,0x00]

v_fract_f64_e64 v[5:6], s[100:101]
// CHECK: [0x05,0x00,0x72,0xd1,0x64,0x00,0x00,0x00]

v_fract_f64_e64 v[5:6], flat_scratch
// CHECK: [0x05,0x00,0x72,0xd1,0x66,0x00,0x00,0x00]

v_fract_f64_e64 v[5:6], vcc
// CHECK: [0x05,0x00,0x72,0xd1,0x6a,0x00,0x00,0x00]

v_fract_f64_e64 v[5:6], ttmp[14:15]
// CHECK: [0x05,0x00,0x72,0xd1,0x7a,0x00,0x00,0x00]

v_fract_f64_e64 v[5:6], exec
// CHECK: [0x05,0x00,0x72,0xd1,0x7e,0x00,0x00,0x00]

v_fract_f64_e64 v[5:6], 0
// CHECK: [0x05,0x00,0x72,0xd1,0x80,0x00,0x00,0x00]

v_fract_f64_e64 v[5:6], -1
// CHECK: [0x05,0x00,0x72,0xd1,0xc1,0x00,0x00,0x00]

v_fract_f64_e64 v[5:6], 0.5
// CHECK: [0x05,0x00,0x72,0xd1,0xf0,0x00,0x00,0x00]

v_fract_f64_e64 v[5:6], -4.0
// CHECK: [0x05,0x00,0x72,0xd1,0xf7,0x00,0x00,0x00]

v_fract_f64_e64 v[5:6], src_vccz
// CHECK: [0x05,0x00,0x72,0xd1,0xfb,0x00,0x00,0x00]

v_fract_f64_e64 v[5:6], src_execz
// CHECK: [0x05,0x00,0x72,0xd1,0xfc,0x00,0x00,0x00]

v_fract_f64_e64 v[5:6], src_scc
// CHECK: [0x05,0x00,0x72,0xd1,0xfd,0x00,0x00,0x00]

v_fract_f64_e64 v[5:6], -v[1:2]
// CHECK: [0x05,0x00,0x72,0xd1,0x01,0x01,0x00,0x20]

v_fract_f64_e64 v[5:6], |v[1:2]|
// CHECK: [0x05,0x01,0x72,0xd1,0x01,0x01,0x00,0x00]

v_fract_f64_e64 v[5:6], v[1:2] clamp
// CHECK: [0x05,0x80,0x72,0xd1,0x01,0x01,0x00,0x00]

v_fract_f64_e64 v[5:6], v[1:2] mul:2
// CHECK: [0x05,0x00,0x72,0xd1,0x01,0x01,0x00,0x08]

v_fract_f64_e64 v[5:6], v[1:2] mul:4
// CHECK: [0x05,0x00,0x72,0xd1,0x01,0x01,0x00,0x10]

v_fract_f64_e64 v[5:6], v[1:2] div:2
// CHECK: [0x05,0x00,0x72,0xd1,0x01,0x01,0x00,0x18]

v_frexp_exp_i32_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x73,0xd1,0x01,0x01,0x00,0x00]

v_frexp_exp_i32_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x73,0xd1,0x01,0x01,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x73,0xd1,0xff,0x01,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x73,0xd1,0x01,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, s101
// CHECK: [0x05,0x00,0x73,0xd1,0x65,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x73,0xd1,0x66,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x73,0xd1,0x67,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x73,0xd1,0x6a,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x73,0xd1,0x6b,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, ttmp15
// CHECK: [0x05,0x00,0x73,0xd1,0x7b,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x73,0xd1,0x7c,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x73,0xd1,0x7e,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x73,0xd1,0x7f,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x73,0xd1,0x80,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x73,0xd1,0xc1,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x73,0xd1,0xf0,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x73,0xd1,0xf7,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x73,0xd1,0xfb,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x73,0xd1,0xfc,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x73,0xd1,0xfd,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x73,0xd1,0xfe,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x73,0xd1,0x01,0x01,0x00,0x20]

v_frexp_exp_i32_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x73,0xd1,0x01,0x01,0x00,0x00]

v_frexp_mant_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x74,0xd1,0x01,0x01,0x00,0x00]

v_frexp_mant_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x74,0xd1,0x01,0x01,0x00,0x00]

v_frexp_mant_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x74,0xd1,0xff,0x01,0x00,0x00]

v_frexp_mant_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x74,0xd1,0x01,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, s101
// CHECK: [0x05,0x00,0x74,0xd1,0x65,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x74,0xd1,0x66,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x74,0xd1,0x67,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x74,0xd1,0x6a,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x74,0xd1,0x6b,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, ttmp15
// CHECK: [0x05,0x00,0x74,0xd1,0x7b,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x74,0xd1,0x7c,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x74,0xd1,0x7e,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x74,0xd1,0x7f,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x74,0xd1,0x80,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x74,0xd1,0xc1,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x74,0xd1,0xf0,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x74,0xd1,0xf7,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x74,0xd1,0xfb,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x74,0xd1,0xfc,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x74,0xd1,0xfd,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x74,0xd1,0xfe,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x74,0xd1,0x01,0x01,0x00,0x20]

v_frexp_mant_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x74,0xd1,0x01,0x01,0x00,0x00]

v_frexp_mant_f32_e64 v5, v1 clamp
// CHECK: [0x05,0x80,0x74,0xd1,0x01,0x01,0x00,0x00]

v_frexp_mant_f32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x74,0xd1,0x01,0x01,0x00,0x08]

v_frexp_mant_f32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x74,0xd1,0x01,0x01,0x00,0x10]

v_frexp_mant_f32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x74,0xd1,0x01,0x01,0x00,0x18]

v_clrexcp_e64
// CHECK: [0x00,0x00,0x75,0xd1,0x00,0x00,0x00,0x00]

v_screen_partition_4se_b32_e64 v5, v1
// CHECK: [0x05,0x00,0x77,0xd1,0x01,0x01,0x00,0x00]

v_screen_partition_4se_b32_e64 v255, v1
// CHECK: [0xff,0x00,0x77,0xd1,0x01,0x01,0x00,0x00]

v_screen_partition_4se_b32_e64 v5, v255
// CHECK: [0x05,0x00,0x77,0xd1,0xff,0x01,0x00,0x00]

v_screen_partition_4se_b32_e64 v5, s1
// CHECK: [0x05,0x00,0x77,0xd1,0x01,0x00,0x00,0x00]

v_screen_partition_4se_b32_e64 v5, s101
// CHECK: [0x05,0x00,0x77,0xd1,0x65,0x00,0x00,0x00]

v_screen_partition_4se_b32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x77,0xd1,0x66,0x00,0x00,0x00]

v_screen_partition_4se_b32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x77,0xd1,0x67,0x00,0x00,0x00]

v_screen_partition_4se_b32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x77,0xd1,0x6a,0x00,0x00,0x00]

v_screen_partition_4se_b32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x77,0xd1,0x6b,0x00,0x00,0x00]

v_screen_partition_4se_b32_e64 v5, ttmp15
// CHECK: [0x05,0x00,0x77,0xd1,0x7b,0x00,0x00,0x00]

v_screen_partition_4se_b32_e64 v5, m0
// CHECK: [0x05,0x00,0x77,0xd1,0x7c,0x00,0x00,0x00]

v_screen_partition_4se_b32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x77,0xd1,0x7e,0x00,0x00,0x00]

v_screen_partition_4se_b32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x77,0xd1,0x7f,0x00,0x00,0x00]

v_screen_partition_4se_b32_e64 v5, 0
// CHECK: [0x05,0x00,0x77,0xd1,0x80,0x00,0x00,0x00]

v_screen_partition_4se_b32_e64 v5, -1
// CHECK: [0x05,0x00,0x77,0xd1,0xc1,0x00,0x00,0x00]

v_screen_partition_4se_b32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x77,0xd1,0xf0,0x00,0x00,0x00]

v_screen_partition_4se_b32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x77,0xd1,0xf7,0x00,0x00,0x00]

v_screen_partition_4se_b32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x77,0xd1,0xfb,0x00,0x00,0x00]

v_screen_partition_4se_b32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x77,0xd1,0xfc,0x00,0x00,0x00]

v_screen_partition_4se_b32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x77,0xd1,0xfd,0x00,0x00,0x00]

v_screen_partition_4se_b32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x77,0xd1,0xfe,0x00,0x00,0x00]

v_cvt_f16_u16_e64 v5, v1
// CHECK: [0x05,0x00,0x79,0xd1,0x01,0x01,0x00,0x00]

v_cvt_f16_u16_e64 v255, v1
// CHECK: [0xff,0x00,0x79,0xd1,0x01,0x01,0x00,0x00]

v_cvt_f16_u16_e64 v5, v255
// CHECK: [0x05,0x00,0x79,0xd1,0xff,0x01,0x00,0x00]

v_cvt_f16_u16_e64 v5, s1
// CHECK: [0x05,0x00,0x79,0xd1,0x01,0x00,0x00,0x00]

v_cvt_f16_u16_e64 v5, s101
// CHECK: [0x05,0x00,0x79,0xd1,0x65,0x00,0x00,0x00]

v_cvt_f16_u16_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x79,0xd1,0x66,0x00,0x00,0x00]

v_cvt_f16_u16_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x79,0xd1,0x67,0x00,0x00,0x00]

v_cvt_f16_u16_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x79,0xd1,0x6a,0x00,0x00,0x00]

v_cvt_f16_u16_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x79,0xd1,0x6b,0x00,0x00,0x00]

v_cvt_f16_u16_e64 v5, ttmp15
// CHECK: [0x05,0x00,0x79,0xd1,0x7b,0x00,0x00,0x00]

v_cvt_f16_u16_e64 v5, m0
// CHECK: [0x05,0x00,0x79,0xd1,0x7c,0x00,0x00,0x00]

v_cvt_f16_u16_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x79,0xd1,0x7e,0x00,0x00,0x00]

v_cvt_f16_u16_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x79,0xd1,0x7f,0x00,0x00,0x00]

v_cvt_f16_u16_e64 v5, 0
// CHECK: [0x05,0x00,0x79,0xd1,0x80,0x00,0x00,0x00]

v_cvt_f16_u16_e64 v5, -1
// CHECK: [0x05,0x00,0x79,0xd1,0xc1,0x00,0x00,0x00]

v_cvt_f16_u16_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x79,0xd1,0xfb,0x00,0x00,0x00]

v_cvt_f16_u16_e64 v5, src_execz
// CHECK: [0x05,0x00,0x79,0xd1,0xfc,0x00,0x00,0x00]

v_cvt_f16_u16_e64 v5, src_scc
// CHECK: [0x05,0x00,0x79,0xd1,0xfd,0x00,0x00,0x00]

v_cvt_f16_u16_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x79,0xd1,0xfe,0x00,0x00,0x00]

v_cvt_f16_u16_e64 v5, v1 clamp
// CHECK: [0x05,0x80,0x79,0xd1,0x01,0x01,0x00,0x00]

v_cvt_f16_i16_e64 v5, v1
// CHECK: [0x05,0x00,0x7a,0xd1,0x01,0x01,0x00,0x00]

v_cvt_f16_i16_e64 v255, v1
// CHECK: [0xff,0x00,0x7a,0xd1,0x01,0x01,0x00,0x00]

v_cvt_f16_i16_e64 v5, v255
// CHECK: [0x05,0x00,0x7a,0xd1,0xff,0x01,0x00,0x00]

v_cvt_f16_i16_e64 v5, s1
// CHECK: [0x05,0x00,0x7a,0xd1,0x01,0x00,0x00,0x00]

v_cvt_f16_i16_e64 v5, s101
// CHECK: [0x05,0x00,0x7a,0xd1,0x65,0x00,0x00,0x00]

v_cvt_f16_i16_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x7a,0xd1,0x66,0x00,0x00,0x00]

v_cvt_f16_i16_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x7a,0xd1,0x67,0x00,0x00,0x00]

v_cvt_f16_i16_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x7a,0xd1,0x6a,0x00,0x00,0x00]

v_cvt_f16_i16_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x7a,0xd1,0x6b,0x00,0x00,0x00]

v_cvt_f16_i16_e64 v5, ttmp15
// CHECK: [0x05,0x00,0x7a,0xd1,0x7b,0x00,0x00,0x00]

v_cvt_f16_i16_e64 v5, m0
// CHECK: [0x05,0x00,0x7a,0xd1,0x7c,0x00,0x00,0x00]

v_cvt_f16_i16_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x7a,0xd1,0x7e,0x00,0x00,0x00]

v_cvt_f16_i16_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x7a,0xd1,0x7f,0x00,0x00,0x00]

v_cvt_f16_i16_e64 v5, 0
// CHECK: [0x05,0x00,0x7a,0xd1,0x80,0x00,0x00,0x00]

v_cvt_f16_i16_e64 v5, -1
// CHECK: [0x05,0x00,0x7a,0xd1,0xc1,0x00,0x00,0x00]

v_cvt_f16_i16_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x7a,0xd1,0xfb,0x00,0x00,0x00]

v_cvt_f16_i16_e64 v5, src_execz
// CHECK: [0x05,0x00,0x7a,0xd1,0xfc,0x00,0x00,0x00]

v_cvt_f16_i16_e64 v5, src_scc
// CHECK: [0x05,0x00,0x7a,0xd1,0xfd,0x00,0x00,0x00]

v_cvt_f16_i16_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x7a,0xd1,0xfe,0x00,0x00,0x00]

v_cvt_f16_i16_e64 v5, v1 clamp
// CHECK: [0x05,0x80,0x7a,0xd1,0x01,0x01,0x00,0x00]

v_cvt_u16_f16_e64 v5, v1
// CHECK: [0x05,0x00,0x7b,0xd1,0x01,0x01,0x00,0x00]

v_cvt_u16_f16_e64 v255, v1
// CHECK: [0xff,0x00,0x7b,0xd1,0x01,0x01,0x00,0x00]

v_cvt_u16_f16_e64 v5, v255
// CHECK: [0x05,0x00,0x7b,0xd1,0xff,0x01,0x00,0x00]

v_cvt_u16_f16_e64 v5, s1
// CHECK: [0x05,0x00,0x7b,0xd1,0x01,0x00,0x00,0x00]

v_cvt_u16_f16_e64 v5, s101
// CHECK: [0x05,0x00,0x7b,0xd1,0x65,0x00,0x00,0x00]

v_cvt_u16_f16_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x7b,0xd1,0x66,0x00,0x00,0x00]

v_cvt_u16_f16_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x7b,0xd1,0x67,0x00,0x00,0x00]

v_cvt_u16_f16_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x7b,0xd1,0x6a,0x00,0x00,0x00]

v_cvt_u16_f16_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x7b,0xd1,0x6b,0x00,0x00,0x00]

v_cvt_u16_f16_e64 v5, ttmp15
// CHECK: [0x05,0x00,0x7b,0xd1,0x7b,0x00,0x00,0x00]

v_cvt_u16_f16_e64 v5, m0
// CHECK: [0x05,0x00,0x7b,0xd1,0x7c,0x00,0x00,0x00]

v_cvt_u16_f16_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x7b,0xd1,0x7e,0x00,0x00,0x00]

v_cvt_u16_f16_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x7b,0xd1,0x7f,0x00,0x00,0x00]

v_cvt_u16_f16_e64 v5, 0
// CHECK: [0x05,0x00,0x7b,0xd1,0x80,0x00,0x00,0x00]

v_cvt_u16_f16_e64 v5, -1
// CHECK: [0x05,0x00,0x7b,0xd1,0xc1,0x00,0x00,0x00]

v_cvt_u16_f16_e64 v5, 0.5
// CHECK: [0x05,0x00,0x7b,0xd1,0xf0,0x00,0x00,0x00]

v_cvt_u16_f16_e64 v5, -4.0
// CHECK: [0x05,0x00,0x7b,0xd1,0xf7,0x00,0x00,0x00]

v_cvt_u16_f16_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x7b,0xd1,0xfb,0x00,0x00,0x00]

v_cvt_u16_f16_e64 v5, src_execz
// CHECK: [0x05,0x00,0x7b,0xd1,0xfc,0x00,0x00,0x00]

v_cvt_u16_f16_e64 v5, src_scc
// CHECK: [0x05,0x00,0x7b,0xd1,0xfd,0x00,0x00,0x00]

v_cvt_u16_f16_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x7b,0xd1,0xfe,0x00,0x00,0x00]

v_cvt_u16_f16_e64 v5, -v1
// CHECK: [0x05,0x00,0x7b,0xd1,0x01,0x01,0x00,0x20]

v_cvt_u16_f16_e64 v5, |v1|
// CHECK: [0x05,0x01,0x7b,0xd1,0x01,0x01,0x00,0x00]

v_cvt_u16_f16_e64 v5, v1 clamp
// CHECK: [0x05,0x80,0x7b,0xd1,0x01,0x01,0x00,0x00]

v_cvt_i16_f16_e64 v5, v1
// CHECK: [0x05,0x00,0x7c,0xd1,0x01,0x01,0x00,0x00]

v_cvt_i16_f16_e64 v255, v1
// CHECK: [0xff,0x00,0x7c,0xd1,0x01,0x01,0x00,0x00]

v_cvt_i16_f16_e64 v5, v255
// CHECK: [0x05,0x00,0x7c,0xd1,0xff,0x01,0x00,0x00]

v_cvt_i16_f16_e64 v5, s1
// CHECK: [0x05,0x00,0x7c,0xd1,0x01,0x00,0x00,0x00]

v_cvt_i16_f16_e64 v5, s101
// CHECK: [0x05,0x00,0x7c,0xd1,0x65,0x00,0x00,0x00]

v_cvt_i16_f16_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x7c,0xd1,0x66,0x00,0x00,0x00]

v_cvt_i16_f16_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x7c,0xd1,0x67,0x00,0x00,0x00]

v_cvt_i16_f16_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x7c,0xd1,0x6a,0x00,0x00,0x00]

v_cvt_i16_f16_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x7c,0xd1,0x6b,0x00,0x00,0x00]

v_cvt_i16_f16_e64 v5, ttmp15
// CHECK: [0x05,0x00,0x7c,0xd1,0x7b,0x00,0x00,0x00]

v_cvt_i16_f16_e64 v5, m0
// CHECK: [0x05,0x00,0x7c,0xd1,0x7c,0x00,0x00,0x00]

v_cvt_i16_f16_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x7c,0xd1,0x7e,0x00,0x00,0x00]

v_cvt_i16_f16_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x7c,0xd1,0x7f,0x00,0x00,0x00]

v_cvt_i16_f16_e64 v5, 0
// CHECK: [0x05,0x00,0x7c,0xd1,0x80,0x00,0x00,0x00]

v_cvt_i16_f16_e64 v5, -1
// CHECK: [0x05,0x00,0x7c,0xd1,0xc1,0x00,0x00,0x00]

v_cvt_i16_f16_e64 v5, 0.5
// CHECK: [0x05,0x00,0x7c,0xd1,0xf0,0x00,0x00,0x00]

v_cvt_i16_f16_e64 v5, -4.0
// CHECK: [0x05,0x00,0x7c,0xd1,0xf7,0x00,0x00,0x00]

v_cvt_i16_f16_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x7c,0xd1,0xfb,0x00,0x00,0x00]

v_cvt_i16_f16_e64 v5, src_execz
// CHECK: [0x05,0x00,0x7c,0xd1,0xfc,0x00,0x00,0x00]

v_cvt_i16_f16_e64 v5, src_scc
// CHECK: [0x05,0x00,0x7c,0xd1,0xfd,0x00,0x00,0x00]

v_cvt_i16_f16_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x7c,0xd1,0xfe,0x00,0x00,0x00]

v_cvt_i16_f16_e64 v5, -v1
// CHECK: [0x05,0x00,0x7c,0xd1,0x01,0x01,0x00,0x20]

v_cvt_i16_f16_e64 v5, |v1|
// CHECK: [0x05,0x01,0x7c,0xd1,0x01,0x01,0x00,0x00]

v_cvt_i16_f16_e64 v5, v1 clamp
// CHECK: [0x05,0x80,0x7c,0xd1,0x01,0x01,0x00,0x00]

v_rcp_f16_e64 v5, v1
// CHECK: [0x05,0x00,0x7d,0xd1,0x01,0x01,0x00,0x00]

v_rcp_f16_e64 v255, v1
// CHECK: [0xff,0x00,0x7d,0xd1,0x01,0x01,0x00,0x00]

v_rcp_f16_e64 v5, v255
// CHECK: [0x05,0x00,0x7d,0xd1,0xff,0x01,0x00,0x00]

v_rcp_f16_e64 v5, s1
// CHECK: [0x05,0x00,0x7d,0xd1,0x01,0x00,0x00,0x00]

v_rcp_f16_e64 v5, s101
// CHECK: [0x05,0x00,0x7d,0xd1,0x65,0x00,0x00,0x00]

v_rcp_f16_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x7d,0xd1,0x66,0x00,0x00,0x00]

v_rcp_f16_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x7d,0xd1,0x67,0x00,0x00,0x00]

v_rcp_f16_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x7d,0xd1,0x6a,0x00,0x00,0x00]

v_rcp_f16_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x7d,0xd1,0x6b,0x00,0x00,0x00]

v_rcp_f16_e64 v5, ttmp15
// CHECK: [0x05,0x00,0x7d,0xd1,0x7b,0x00,0x00,0x00]

v_rcp_f16_e64 v5, m0
// CHECK: [0x05,0x00,0x7d,0xd1,0x7c,0x00,0x00,0x00]

v_rcp_f16_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x7d,0xd1,0x7e,0x00,0x00,0x00]

v_rcp_f16_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x7d,0xd1,0x7f,0x00,0x00,0x00]

v_rcp_f16_e64 v5, 0
// CHECK: [0x05,0x00,0x7d,0xd1,0x80,0x00,0x00,0x00]

v_rcp_f16_e64 v5, -1
// CHECK: [0x05,0x00,0x7d,0xd1,0xc1,0x00,0x00,0x00]

v_rcp_f16_e64 v5, 0.5
// CHECK: [0x05,0x00,0x7d,0xd1,0xf0,0x00,0x00,0x00]

v_rcp_f16_e64 v5, -4.0
// CHECK: [0x05,0x00,0x7d,0xd1,0xf7,0x00,0x00,0x00]

v_rcp_f16_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x7d,0xd1,0xfb,0x00,0x00,0x00]

v_rcp_f16_e64 v5, src_execz
// CHECK: [0x05,0x00,0x7d,0xd1,0xfc,0x00,0x00,0x00]

v_rcp_f16_e64 v5, src_scc
// CHECK: [0x05,0x00,0x7d,0xd1,0xfd,0x00,0x00,0x00]

v_rcp_f16_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x7d,0xd1,0xfe,0x00,0x00,0x00]

v_rcp_f16_e64 v5, -v1
// CHECK: [0x05,0x00,0x7d,0xd1,0x01,0x01,0x00,0x20]

v_rcp_f16_e64 v5, |v1|
// CHECK: [0x05,0x01,0x7d,0xd1,0x01,0x01,0x00,0x00]

v_rcp_f16_e64 v5, v1 clamp
// CHECK: [0x05,0x80,0x7d,0xd1,0x01,0x01,0x00,0x00]

v_sqrt_f16_e64 v5, v1
// CHECK: [0x05,0x00,0x7e,0xd1,0x01,0x01,0x00,0x00]

v_sqrt_f16_e64 v255, v1
// CHECK: [0xff,0x00,0x7e,0xd1,0x01,0x01,0x00,0x00]

v_sqrt_f16_e64 v5, v255
// CHECK: [0x05,0x00,0x7e,0xd1,0xff,0x01,0x00,0x00]

v_sqrt_f16_e64 v5, s1
// CHECK: [0x05,0x00,0x7e,0xd1,0x01,0x00,0x00,0x00]

v_sqrt_f16_e64 v5, s101
// CHECK: [0x05,0x00,0x7e,0xd1,0x65,0x00,0x00,0x00]

v_sqrt_f16_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x7e,0xd1,0x66,0x00,0x00,0x00]

v_sqrt_f16_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x7e,0xd1,0x67,0x00,0x00,0x00]

v_sqrt_f16_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x7e,0xd1,0x6a,0x00,0x00,0x00]

v_sqrt_f16_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x7e,0xd1,0x6b,0x00,0x00,0x00]

v_sqrt_f16_e64 v5, ttmp15
// CHECK: [0x05,0x00,0x7e,0xd1,0x7b,0x00,0x00,0x00]

v_sqrt_f16_e64 v5, m0
// CHECK: [0x05,0x00,0x7e,0xd1,0x7c,0x00,0x00,0x00]

v_sqrt_f16_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x7e,0xd1,0x7e,0x00,0x00,0x00]

v_sqrt_f16_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x7e,0xd1,0x7f,0x00,0x00,0x00]

v_sqrt_f16_e64 v5, 0
// CHECK: [0x05,0x00,0x7e,0xd1,0x80,0x00,0x00,0x00]

v_sqrt_f16_e64 v5, -1
// CHECK: [0x05,0x00,0x7e,0xd1,0xc1,0x00,0x00,0x00]

v_sqrt_f16_e64 v5, 0.5
// CHECK: [0x05,0x00,0x7e,0xd1,0xf0,0x00,0x00,0x00]

v_sqrt_f16_e64 v5, -4.0
// CHECK: [0x05,0x00,0x7e,0xd1,0xf7,0x00,0x00,0x00]

v_sqrt_f16_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x7e,0xd1,0xfb,0x00,0x00,0x00]

v_sqrt_f16_e64 v5, src_execz
// CHECK: [0x05,0x00,0x7e,0xd1,0xfc,0x00,0x00,0x00]

v_sqrt_f16_e64 v5, src_scc
// CHECK: [0x05,0x00,0x7e,0xd1,0xfd,0x00,0x00,0x00]

v_sqrt_f16_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x7e,0xd1,0xfe,0x00,0x00,0x00]

v_sqrt_f16_e64 v5, -v1
// CHECK: [0x05,0x00,0x7e,0xd1,0x01,0x01,0x00,0x20]

v_sqrt_f16_e64 v5, |v1|
// CHECK: [0x05,0x01,0x7e,0xd1,0x01,0x01,0x00,0x00]

v_sqrt_f16_e64 v5, v1 clamp
// CHECK: [0x05,0x80,0x7e,0xd1,0x01,0x01,0x00,0x00]

v_rsq_f16_e64 v5, v1
// CHECK: [0x05,0x00,0x7f,0xd1,0x01,0x01,0x00,0x00]

v_rsq_f16_e64 v255, v1
// CHECK: [0xff,0x00,0x7f,0xd1,0x01,0x01,0x00,0x00]

v_rsq_f16_e64 v5, v255
// CHECK: [0x05,0x00,0x7f,0xd1,0xff,0x01,0x00,0x00]

v_rsq_f16_e64 v5, s1
// CHECK: [0x05,0x00,0x7f,0xd1,0x01,0x00,0x00,0x00]

v_rsq_f16_e64 v5, s101
// CHECK: [0x05,0x00,0x7f,0xd1,0x65,0x00,0x00,0x00]

v_rsq_f16_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x7f,0xd1,0x66,0x00,0x00,0x00]

v_rsq_f16_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x7f,0xd1,0x67,0x00,0x00,0x00]

v_rsq_f16_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x7f,0xd1,0x6a,0x00,0x00,0x00]

v_rsq_f16_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x7f,0xd1,0x6b,0x00,0x00,0x00]

v_rsq_f16_e64 v5, ttmp15
// CHECK: [0x05,0x00,0x7f,0xd1,0x7b,0x00,0x00,0x00]

v_rsq_f16_e64 v5, m0
// CHECK: [0x05,0x00,0x7f,0xd1,0x7c,0x00,0x00,0x00]

v_rsq_f16_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x7f,0xd1,0x7e,0x00,0x00,0x00]

v_rsq_f16_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x7f,0xd1,0x7f,0x00,0x00,0x00]

v_rsq_f16_e64 v5, 0
// CHECK: [0x05,0x00,0x7f,0xd1,0x80,0x00,0x00,0x00]

v_rsq_f16_e64 v5, -1
// CHECK: [0x05,0x00,0x7f,0xd1,0xc1,0x00,0x00,0x00]

v_rsq_f16_e64 v5, 0.5
// CHECK: [0x05,0x00,0x7f,0xd1,0xf0,0x00,0x00,0x00]

v_rsq_f16_e64 v5, -4.0
// CHECK: [0x05,0x00,0x7f,0xd1,0xf7,0x00,0x00,0x00]

v_rsq_f16_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x7f,0xd1,0xfb,0x00,0x00,0x00]

v_rsq_f16_e64 v5, src_execz
// CHECK: [0x05,0x00,0x7f,0xd1,0xfc,0x00,0x00,0x00]

v_rsq_f16_e64 v5, src_scc
// CHECK: [0x05,0x00,0x7f,0xd1,0xfd,0x00,0x00,0x00]

v_rsq_f16_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x7f,0xd1,0xfe,0x00,0x00,0x00]

v_rsq_f16_e64 v5, -v1
// CHECK: [0x05,0x00,0x7f,0xd1,0x01,0x01,0x00,0x20]

v_rsq_f16_e64 v5, |v1|
// CHECK: [0x05,0x01,0x7f,0xd1,0x01,0x01,0x00,0x00]

v_rsq_f16_e64 v5, v1 clamp
// CHECK: [0x05,0x80,0x7f,0xd1,0x01,0x01,0x00,0x00]

v_log_f16_e64 v5, v1
// CHECK: [0x05,0x00,0x80,0xd1,0x01,0x01,0x00,0x00]

v_log_f16_e64 v255, v1
// CHECK: [0xff,0x00,0x80,0xd1,0x01,0x01,0x00,0x00]

v_log_f16_e64 v5, v255
// CHECK: [0x05,0x00,0x80,0xd1,0xff,0x01,0x00,0x00]

v_log_f16_e64 v5, s1
// CHECK: [0x05,0x00,0x80,0xd1,0x01,0x00,0x00,0x00]

v_log_f16_e64 v5, s101
// CHECK: [0x05,0x00,0x80,0xd1,0x65,0x00,0x00,0x00]

v_log_f16_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x80,0xd1,0x66,0x00,0x00,0x00]

v_log_f16_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x80,0xd1,0x67,0x00,0x00,0x00]

v_log_f16_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x80,0xd1,0x6a,0x00,0x00,0x00]

v_log_f16_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x80,0xd1,0x6b,0x00,0x00,0x00]

v_log_f16_e64 v5, ttmp15
// CHECK: [0x05,0x00,0x80,0xd1,0x7b,0x00,0x00,0x00]

v_log_f16_e64 v5, m0
// CHECK: [0x05,0x00,0x80,0xd1,0x7c,0x00,0x00,0x00]

v_log_f16_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x80,0xd1,0x7e,0x00,0x00,0x00]

v_log_f16_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x80,0xd1,0x7f,0x00,0x00,0x00]

v_log_f16_e64 v5, 0
// CHECK: [0x05,0x00,0x80,0xd1,0x80,0x00,0x00,0x00]

v_log_f16_e64 v5, -1
// CHECK: [0x05,0x00,0x80,0xd1,0xc1,0x00,0x00,0x00]

v_log_f16_e64 v5, 0.5
// CHECK: [0x05,0x00,0x80,0xd1,0xf0,0x00,0x00,0x00]

v_log_f16_e64 v5, -4.0
// CHECK: [0x05,0x00,0x80,0xd1,0xf7,0x00,0x00,0x00]

v_log_f16_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x80,0xd1,0xfb,0x00,0x00,0x00]

v_log_f16_e64 v5, src_execz
// CHECK: [0x05,0x00,0x80,0xd1,0xfc,0x00,0x00,0x00]

v_log_f16_e64 v5, src_scc
// CHECK: [0x05,0x00,0x80,0xd1,0xfd,0x00,0x00,0x00]

v_log_f16_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x80,0xd1,0xfe,0x00,0x00,0x00]

v_log_f16_e64 v5, -v1
// CHECK: [0x05,0x00,0x80,0xd1,0x01,0x01,0x00,0x20]

v_log_f16_e64 v5, |v1|
// CHECK: [0x05,0x01,0x80,0xd1,0x01,0x01,0x00,0x00]

v_log_f16_e64 v5, v1 clamp
// CHECK: [0x05,0x80,0x80,0xd1,0x01,0x01,0x00,0x00]

v_exp_f16_e64 v5, v1
// CHECK: [0x05,0x00,0x81,0xd1,0x01,0x01,0x00,0x00]

v_exp_f16_e64 v255, v1
// CHECK: [0xff,0x00,0x81,0xd1,0x01,0x01,0x00,0x00]

v_exp_f16_e64 v5, v255
// CHECK: [0x05,0x00,0x81,0xd1,0xff,0x01,0x00,0x00]

v_exp_f16_e64 v5, s1
// CHECK: [0x05,0x00,0x81,0xd1,0x01,0x00,0x00,0x00]

v_exp_f16_e64 v5, s101
// CHECK: [0x05,0x00,0x81,0xd1,0x65,0x00,0x00,0x00]

v_exp_f16_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x81,0xd1,0x66,0x00,0x00,0x00]

v_exp_f16_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x81,0xd1,0x67,0x00,0x00,0x00]

v_exp_f16_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x81,0xd1,0x6a,0x00,0x00,0x00]

v_exp_f16_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x81,0xd1,0x6b,0x00,0x00,0x00]

v_exp_f16_e64 v5, ttmp15
// CHECK: [0x05,0x00,0x81,0xd1,0x7b,0x00,0x00,0x00]

v_exp_f16_e64 v5, m0
// CHECK: [0x05,0x00,0x81,0xd1,0x7c,0x00,0x00,0x00]

v_exp_f16_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x81,0xd1,0x7e,0x00,0x00,0x00]

v_exp_f16_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x81,0xd1,0x7f,0x00,0x00,0x00]

v_exp_f16_e64 v5, 0
// CHECK: [0x05,0x00,0x81,0xd1,0x80,0x00,0x00,0x00]

v_exp_f16_e64 v5, -1
// CHECK: [0x05,0x00,0x81,0xd1,0xc1,0x00,0x00,0x00]

v_exp_f16_e64 v5, 0.5
// CHECK: [0x05,0x00,0x81,0xd1,0xf0,0x00,0x00,0x00]

v_exp_f16_e64 v5, -4.0
// CHECK: [0x05,0x00,0x81,0xd1,0xf7,0x00,0x00,0x00]

v_exp_f16_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x81,0xd1,0xfb,0x00,0x00,0x00]

v_exp_f16_e64 v5, src_execz
// CHECK: [0x05,0x00,0x81,0xd1,0xfc,0x00,0x00,0x00]

v_exp_f16_e64 v5, src_scc
// CHECK: [0x05,0x00,0x81,0xd1,0xfd,0x00,0x00,0x00]

v_exp_f16_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x81,0xd1,0xfe,0x00,0x00,0x00]

v_exp_f16_e64 v5, -v1
// CHECK: [0x05,0x00,0x81,0xd1,0x01,0x01,0x00,0x20]

v_exp_f16_e64 v5, |v1|
// CHECK: [0x05,0x01,0x81,0xd1,0x01,0x01,0x00,0x00]

v_exp_f16_e64 v5, v1 clamp
// CHECK: [0x05,0x80,0x81,0xd1,0x01,0x01,0x00,0x00]

v_frexp_mant_f16_e64 v5, v1
// CHECK: [0x05,0x00,0x82,0xd1,0x01,0x01,0x00,0x00]

v_frexp_mant_f16_e64 v255, v1
// CHECK: [0xff,0x00,0x82,0xd1,0x01,0x01,0x00,0x00]

v_frexp_mant_f16_e64 v5, v255
// CHECK: [0x05,0x00,0x82,0xd1,0xff,0x01,0x00,0x00]

v_frexp_mant_f16_e64 v5, s1
// CHECK: [0x05,0x00,0x82,0xd1,0x01,0x00,0x00,0x00]

v_frexp_mant_f16_e64 v5, s101
// CHECK: [0x05,0x00,0x82,0xd1,0x65,0x00,0x00,0x00]

v_frexp_mant_f16_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x82,0xd1,0x66,0x00,0x00,0x00]

v_frexp_mant_f16_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x82,0xd1,0x67,0x00,0x00,0x00]

v_frexp_mant_f16_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x82,0xd1,0x6a,0x00,0x00,0x00]

v_frexp_mant_f16_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x82,0xd1,0x6b,0x00,0x00,0x00]

v_frexp_mant_f16_e64 v5, ttmp15
// CHECK: [0x05,0x00,0x82,0xd1,0x7b,0x00,0x00,0x00]

v_frexp_mant_f16_e64 v5, m0
// CHECK: [0x05,0x00,0x82,0xd1,0x7c,0x00,0x00,0x00]

v_frexp_mant_f16_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x82,0xd1,0x7e,0x00,0x00,0x00]

v_frexp_mant_f16_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x82,0xd1,0x7f,0x00,0x00,0x00]

v_frexp_mant_f16_e64 v5, 0
// CHECK: [0x05,0x00,0x82,0xd1,0x80,0x00,0x00,0x00]

v_frexp_mant_f16_e64 v5, -1
// CHECK: [0x05,0x00,0x82,0xd1,0xc1,0x00,0x00,0x00]

v_frexp_mant_f16_e64 v5, 0.5
// CHECK: [0x05,0x00,0x82,0xd1,0xf0,0x00,0x00,0x00]

v_frexp_mant_f16_e64 v5, -4.0
// CHECK: [0x05,0x00,0x82,0xd1,0xf7,0x00,0x00,0x00]

v_frexp_mant_f16_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x82,0xd1,0xfb,0x00,0x00,0x00]

v_frexp_mant_f16_e64 v5, src_execz
// CHECK: [0x05,0x00,0x82,0xd1,0xfc,0x00,0x00,0x00]

v_frexp_mant_f16_e64 v5, src_scc
// CHECK: [0x05,0x00,0x82,0xd1,0xfd,0x00,0x00,0x00]

v_frexp_mant_f16_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x82,0xd1,0xfe,0x00,0x00,0x00]

v_frexp_mant_f16_e64 v5, -v1
// CHECK: [0x05,0x00,0x82,0xd1,0x01,0x01,0x00,0x20]

v_frexp_mant_f16_e64 v5, |v1|
// CHECK: [0x05,0x01,0x82,0xd1,0x01,0x01,0x00,0x00]

v_frexp_mant_f16_e64 v5, v1 clamp
// CHECK: [0x05,0x80,0x82,0xd1,0x01,0x01,0x00,0x00]

v_frexp_exp_i16_f16_e64 v5, v1
// CHECK: [0x05,0x00,0x83,0xd1,0x01,0x01,0x00,0x00]

v_frexp_exp_i16_f16_e64 v255, v1
// CHECK: [0xff,0x00,0x83,0xd1,0x01,0x01,0x00,0x00]

v_frexp_exp_i16_f16_e64 v5, v255
// CHECK: [0x05,0x00,0x83,0xd1,0xff,0x01,0x00,0x00]

v_frexp_exp_i16_f16_e64 v5, s1
// CHECK: [0x05,0x00,0x83,0xd1,0x01,0x00,0x00,0x00]

v_frexp_exp_i16_f16_e64 v5, s101
// CHECK: [0x05,0x00,0x83,0xd1,0x65,0x00,0x00,0x00]

v_frexp_exp_i16_f16_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x83,0xd1,0x66,0x00,0x00,0x00]

v_frexp_exp_i16_f16_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x83,0xd1,0x67,0x00,0x00,0x00]

v_frexp_exp_i16_f16_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x83,0xd1,0x6a,0x00,0x00,0x00]

v_frexp_exp_i16_f16_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x83,0xd1,0x6b,0x00,0x00,0x00]

v_frexp_exp_i16_f16_e64 v5, ttmp15
// CHECK: [0x05,0x00,0x83,0xd1,0x7b,0x00,0x00,0x00]

v_frexp_exp_i16_f16_e64 v5, m0
// CHECK: [0x05,0x00,0x83,0xd1,0x7c,0x00,0x00,0x00]

v_frexp_exp_i16_f16_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x83,0xd1,0x7e,0x00,0x00,0x00]

v_frexp_exp_i16_f16_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x83,0xd1,0x7f,0x00,0x00,0x00]

v_frexp_exp_i16_f16_e64 v5, 0
// CHECK: [0x05,0x00,0x83,0xd1,0x80,0x00,0x00,0x00]

v_frexp_exp_i16_f16_e64 v5, -1
// CHECK: [0x05,0x00,0x83,0xd1,0xc1,0x00,0x00,0x00]

v_frexp_exp_i16_f16_e64 v5, 0.5
// CHECK: [0x05,0x00,0x83,0xd1,0xf0,0x00,0x00,0x00]

v_frexp_exp_i16_f16_e64 v5, -4.0
// CHECK: [0x05,0x00,0x83,0xd1,0xf7,0x00,0x00,0x00]

v_frexp_exp_i16_f16_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x83,0xd1,0xfb,0x00,0x00,0x00]

v_frexp_exp_i16_f16_e64 v5, src_execz
// CHECK: [0x05,0x00,0x83,0xd1,0xfc,0x00,0x00,0x00]

v_frexp_exp_i16_f16_e64 v5, src_scc
// CHECK: [0x05,0x00,0x83,0xd1,0xfd,0x00,0x00,0x00]

v_frexp_exp_i16_f16_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x83,0xd1,0xfe,0x00,0x00,0x00]

v_frexp_exp_i16_f16_e64 v5, -v1
// CHECK: [0x05,0x00,0x83,0xd1,0x01,0x01,0x00,0x20]

v_frexp_exp_i16_f16_e64 v5, |v1|
// CHECK: [0x05,0x01,0x83,0xd1,0x01,0x01,0x00,0x00]

v_floor_f16_e64 v5, v1
// CHECK: [0x05,0x00,0x84,0xd1,0x01,0x01,0x00,0x00]

v_floor_f16_e64 v255, v1
// CHECK: [0xff,0x00,0x84,0xd1,0x01,0x01,0x00,0x00]

v_floor_f16_e64 v5, v255
// CHECK: [0x05,0x00,0x84,0xd1,0xff,0x01,0x00,0x00]

v_floor_f16_e64 v5, s1
// CHECK: [0x05,0x00,0x84,0xd1,0x01,0x00,0x00,0x00]

v_floor_f16_e64 v5, s101
// CHECK: [0x05,0x00,0x84,0xd1,0x65,0x00,0x00,0x00]

v_floor_f16_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x84,0xd1,0x66,0x00,0x00,0x00]

v_floor_f16_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x84,0xd1,0x67,0x00,0x00,0x00]

v_floor_f16_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x84,0xd1,0x6a,0x00,0x00,0x00]

v_floor_f16_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x84,0xd1,0x6b,0x00,0x00,0x00]

v_floor_f16_e64 v5, ttmp15
// CHECK: [0x05,0x00,0x84,0xd1,0x7b,0x00,0x00,0x00]

v_floor_f16_e64 v5, m0
// CHECK: [0x05,0x00,0x84,0xd1,0x7c,0x00,0x00,0x00]

v_floor_f16_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x84,0xd1,0x7e,0x00,0x00,0x00]

v_floor_f16_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x84,0xd1,0x7f,0x00,0x00,0x00]

v_floor_f16_e64 v5, 0
// CHECK: [0x05,0x00,0x84,0xd1,0x80,0x00,0x00,0x00]

v_floor_f16_e64 v5, -1
// CHECK: [0x05,0x00,0x84,0xd1,0xc1,0x00,0x00,0x00]

v_floor_f16_e64 v5, 0.5
// CHECK: [0x05,0x00,0x84,0xd1,0xf0,0x00,0x00,0x00]

v_floor_f16_e64 v5, -4.0
// CHECK: [0x05,0x00,0x84,0xd1,0xf7,0x00,0x00,0x00]

v_floor_f16_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x84,0xd1,0xfb,0x00,0x00,0x00]

v_floor_f16_e64 v5, src_execz
// CHECK: [0x05,0x00,0x84,0xd1,0xfc,0x00,0x00,0x00]

v_floor_f16_e64 v5, src_scc
// CHECK: [0x05,0x00,0x84,0xd1,0xfd,0x00,0x00,0x00]

v_floor_f16_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x84,0xd1,0xfe,0x00,0x00,0x00]

v_floor_f16_e64 v5, -v1
// CHECK: [0x05,0x00,0x84,0xd1,0x01,0x01,0x00,0x20]

v_floor_f16_e64 v5, |v1|
// CHECK: [0x05,0x01,0x84,0xd1,0x01,0x01,0x00,0x00]

v_floor_f16_e64 v5, v1 clamp
// CHECK: [0x05,0x80,0x84,0xd1,0x01,0x01,0x00,0x00]

v_ceil_f16_e64 v5, v1
// CHECK: [0x05,0x00,0x85,0xd1,0x01,0x01,0x00,0x00]

v_ceil_f16_e64 v255, v1
// CHECK: [0xff,0x00,0x85,0xd1,0x01,0x01,0x00,0x00]

v_ceil_f16_e64 v5, v255
// CHECK: [0x05,0x00,0x85,0xd1,0xff,0x01,0x00,0x00]

v_ceil_f16_e64 v5, s1
// CHECK: [0x05,0x00,0x85,0xd1,0x01,0x00,0x00,0x00]

v_ceil_f16_e64 v5, s101
// CHECK: [0x05,0x00,0x85,0xd1,0x65,0x00,0x00,0x00]

v_ceil_f16_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x85,0xd1,0x66,0x00,0x00,0x00]

v_ceil_f16_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x85,0xd1,0x67,0x00,0x00,0x00]

v_ceil_f16_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x85,0xd1,0x6a,0x00,0x00,0x00]

v_ceil_f16_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x85,0xd1,0x6b,0x00,0x00,0x00]

v_ceil_f16_e64 v5, ttmp15
// CHECK: [0x05,0x00,0x85,0xd1,0x7b,0x00,0x00,0x00]

v_ceil_f16_e64 v5, m0
// CHECK: [0x05,0x00,0x85,0xd1,0x7c,0x00,0x00,0x00]

v_ceil_f16_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x85,0xd1,0x7e,0x00,0x00,0x00]

v_ceil_f16_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x85,0xd1,0x7f,0x00,0x00,0x00]

v_ceil_f16_e64 v5, 0
// CHECK: [0x05,0x00,0x85,0xd1,0x80,0x00,0x00,0x00]

v_ceil_f16_e64 v5, -1
// CHECK: [0x05,0x00,0x85,0xd1,0xc1,0x00,0x00,0x00]

v_ceil_f16_e64 v5, 0.5
// CHECK: [0x05,0x00,0x85,0xd1,0xf0,0x00,0x00,0x00]

v_ceil_f16_e64 v5, -4.0
// CHECK: [0x05,0x00,0x85,0xd1,0xf7,0x00,0x00,0x00]

v_ceil_f16_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x85,0xd1,0xfb,0x00,0x00,0x00]

v_ceil_f16_e64 v5, src_execz
// CHECK: [0x05,0x00,0x85,0xd1,0xfc,0x00,0x00,0x00]

v_ceil_f16_e64 v5, src_scc
// CHECK: [0x05,0x00,0x85,0xd1,0xfd,0x00,0x00,0x00]

v_ceil_f16_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x85,0xd1,0xfe,0x00,0x00,0x00]

v_ceil_f16_e64 v5, -v1
// CHECK: [0x05,0x00,0x85,0xd1,0x01,0x01,0x00,0x20]

v_ceil_f16_e64 v5, |v1|
// CHECK: [0x05,0x01,0x85,0xd1,0x01,0x01,0x00,0x00]

v_ceil_f16_e64 v5, v1 clamp
// CHECK: [0x05,0x80,0x85,0xd1,0x01,0x01,0x00,0x00]

v_trunc_f16_e64 v5, v1
// CHECK: [0x05,0x00,0x86,0xd1,0x01,0x01,0x00,0x00]

v_trunc_f16_e64 v255, v1
// CHECK: [0xff,0x00,0x86,0xd1,0x01,0x01,0x00,0x00]

v_trunc_f16_e64 v5, v255
// CHECK: [0x05,0x00,0x86,0xd1,0xff,0x01,0x00,0x00]

v_trunc_f16_e64 v5, s1
// CHECK: [0x05,0x00,0x86,0xd1,0x01,0x00,0x00,0x00]

v_trunc_f16_e64 v5, s101
// CHECK: [0x05,0x00,0x86,0xd1,0x65,0x00,0x00,0x00]

v_trunc_f16_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x86,0xd1,0x66,0x00,0x00,0x00]

v_trunc_f16_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x86,0xd1,0x67,0x00,0x00,0x00]

v_trunc_f16_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x86,0xd1,0x6a,0x00,0x00,0x00]

v_trunc_f16_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x86,0xd1,0x6b,0x00,0x00,0x00]

v_trunc_f16_e64 v5, ttmp15
// CHECK: [0x05,0x00,0x86,0xd1,0x7b,0x00,0x00,0x00]

v_trunc_f16_e64 v5, m0
// CHECK: [0x05,0x00,0x86,0xd1,0x7c,0x00,0x00,0x00]

v_trunc_f16_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x86,0xd1,0x7e,0x00,0x00,0x00]

v_trunc_f16_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x86,0xd1,0x7f,0x00,0x00,0x00]

v_trunc_f16_e64 v5, 0
// CHECK: [0x05,0x00,0x86,0xd1,0x80,0x00,0x00,0x00]

v_trunc_f16_e64 v5, -1
// CHECK: [0x05,0x00,0x86,0xd1,0xc1,0x00,0x00,0x00]

v_trunc_f16_e64 v5, 0.5
// CHECK: [0x05,0x00,0x86,0xd1,0xf0,0x00,0x00,0x00]

v_trunc_f16_e64 v5, -4.0
// CHECK: [0x05,0x00,0x86,0xd1,0xf7,0x00,0x00,0x00]

v_trunc_f16_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x86,0xd1,0xfb,0x00,0x00,0x00]

v_trunc_f16_e64 v5, src_execz
// CHECK: [0x05,0x00,0x86,0xd1,0xfc,0x00,0x00,0x00]

v_trunc_f16_e64 v5, src_scc
// CHECK: [0x05,0x00,0x86,0xd1,0xfd,0x00,0x00,0x00]

v_trunc_f16_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x86,0xd1,0xfe,0x00,0x00,0x00]

v_trunc_f16_e64 v5, -v1
// CHECK: [0x05,0x00,0x86,0xd1,0x01,0x01,0x00,0x20]

v_trunc_f16_e64 v5, |v1|
// CHECK: [0x05,0x01,0x86,0xd1,0x01,0x01,0x00,0x00]

v_trunc_f16_e64 v5, v1 clamp
// CHECK: [0x05,0x80,0x86,0xd1,0x01,0x01,0x00,0x00]

v_rndne_f16_e64 v5, v1
// CHECK: [0x05,0x00,0x87,0xd1,0x01,0x01,0x00,0x00]

v_rndne_f16_e64 v255, v1
// CHECK: [0xff,0x00,0x87,0xd1,0x01,0x01,0x00,0x00]

v_rndne_f16_e64 v5, v255
// CHECK: [0x05,0x00,0x87,0xd1,0xff,0x01,0x00,0x00]

v_rndne_f16_e64 v5, s1
// CHECK: [0x05,0x00,0x87,0xd1,0x01,0x00,0x00,0x00]

v_rndne_f16_e64 v5, s101
// CHECK: [0x05,0x00,0x87,0xd1,0x65,0x00,0x00,0x00]

v_rndne_f16_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x87,0xd1,0x66,0x00,0x00,0x00]

v_rndne_f16_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x87,0xd1,0x67,0x00,0x00,0x00]

v_rndne_f16_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x87,0xd1,0x6a,0x00,0x00,0x00]

v_rndne_f16_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x87,0xd1,0x6b,0x00,0x00,0x00]

v_rndne_f16_e64 v5, ttmp15
// CHECK: [0x05,0x00,0x87,0xd1,0x7b,0x00,0x00,0x00]

v_rndne_f16_e64 v5, m0
// CHECK: [0x05,0x00,0x87,0xd1,0x7c,0x00,0x00,0x00]

v_rndne_f16_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x87,0xd1,0x7e,0x00,0x00,0x00]

v_rndne_f16_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x87,0xd1,0x7f,0x00,0x00,0x00]

v_rndne_f16_e64 v5, 0
// CHECK: [0x05,0x00,0x87,0xd1,0x80,0x00,0x00,0x00]

v_rndne_f16_e64 v5, -1
// CHECK: [0x05,0x00,0x87,0xd1,0xc1,0x00,0x00,0x00]

v_rndne_f16_e64 v5, 0.5
// CHECK: [0x05,0x00,0x87,0xd1,0xf0,0x00,0x00,0x00]

v_rndne_f16_e64 v5, -4.0
// CHECK: [0x05,0x00,0x87,0xd1,0xf7,0x00,0x00,0x00]

v_rndne_f16_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x87,0xd1,0xfb,0x00,0x00,0x00]

v_rndne_f16_e64 v5, src_execz
// CHECK: [0x05,0x00,0x87,0xd1,0xfc,0x00,0x00,0x00]

v_rndne_f16_e64 v5, src_scc
// CHECK: [0x05,0x00,0x87,0xd1,0xfd,0x00,0x00,0x00]

v_rndne_f16_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x87,0xd1,0xfe,0x00,0x00,0x00]

v_rndne_f16_e64 v5, -v1
// CHECK: [0x05,0x00,0x87,0xd1,0x01,0x01,0x00,0x20]

v_rndne_f16_e64 v5, |v1|
// CHECK: [0x05,0x01,0x87,0xd1,0x01,0x01,0x00,0x00]

v_rndne_f16_e64 v5, v1 clamp
// CHECK: [0x05,0x80,0x87,0xd1,0x01,0x01,0x00,0x00]

v_fract_f16_e64 v5, v1
// CHECK: [0x05,0x00,0x88,0xd1,0x01,0x01,0x00,0x00]

v_fract_f16_e64 v255, v1
// CHECK: [0xff,0x00,0x88,0xd1,0x01,0x01,0x00,0x00]

v_fract_f16_e64 v5, v255
// CHECK: [0x05,0x00,0x88,0xd1,0xff,0x01,0x00,0x00]

v_fract_f16_e64 v5, s1
// CHECK: [0x05,0x00,0x88,0xd1,0x01,0x00,0x00,0x00]

v_fract_f16_e64 v5, s101
// CHECK: [0x05,0x00,0x88,0xd1,0x65,0x00,0x00,0x00]

v_fract_f16_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x88,0xd1,0x66,0x00,0x00,0x00]

v_fract_f16_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x88,0xd1,0x67,0x00,0x00,0x00]

v_fract_f16_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x88,0xd1,0x6a,0x00,0x00,0x00]

v_fract_f16_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x88,0xd1,0x6b,0x00,0x00,0x00]

v_fract_f16_e64 v5, ttmp15
// CHECK: [0x05,0x00,0x88,0xd1,0x7b,0x00,0x00,0x00]

v_fract_f16_e64 v5, m0
// CHECK: [0x05,0x00,0x88,0xd1,0x7c,0x00,0x00,0x00]

v_fract_f16_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x88,0xd1,0x7e,0x00,0x00,0x00]

v_fract_f16_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x88,0xd1,0x7f,0x00,0x00,0x00]

v_fract_f16_e64 v5, 0
// CHECK: [0x05,0x00,0x88,0xd1,0x80,0x00,0x00,0x00]

v_fract_f16_e64 v5, -1
// CHECK: [0x05,0x00,0x88,0xd1,0xc1,0x00,0x00,0x00]

v_fract_f16_e64 v5, 0.5
// CHECK: [0x05,0x00,0x88,0xd1,0xf0,0x00,0x00,0x00]

v_fract_f16_e64 v5, -4.0
// CHECK: [0x05,0x00,0x88,0xd1,0xf7,0x00,0x00,0x00]

v_fract_f16_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x88,0xd1,0xfb,0x00,0x00,0x00]

v_fract_f16_e64 v5, src_execz
// CHECK: [0x05,0x00,0x88,0xd1,0xfc,0x00,0x00,0x00]

v_fract_f16_e64 v5, src_scc
// CHECK: [0x05,0x00,0x88,0xd1,0xfd,0x00,0x00,0x00]

v_fract_f16_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x88,0xd1,0xfe,0x00,0x00,0x00]

v_fract_f16_e64 v5, -v1
// CHECK: [0x05,0x00,0x88,0xd1,0x01,0x01,0x00,0x20]

v_fract_f16_e64 v5, |v1|
// CHECK: [0x05,0x01,0x88,0xd1,0x01,0x01,0x00,0x00]

v_fract_f16_e64 v5, v1 clamp
// CHECK: [0x05,0x80,0x88,0xd1,0x01,0x01,0x00,0x00]

v_sin_f16_e64 v5, v1
// CHECK: [0x05,0x00,0x89,0xd1,0x01,0x01,0x00,0x00]

v_sin_f16_e64 v255, v1
// CHECK: [0xff,0x00,0x89,0xd1,0x01,0x01,0x00,0x00]

v_sin_f16_e64 v5, v255
// CHECK: [0x05,0x00,0x89,0xd1,0xff,0x01,0x00,0x00]

v_sin_f16_e64 v5, s1
// CHECK: [0x05,0x00,0x89,0xd1,0x01,0x00,0x00,0x00]

v_sin_f16_e64 v5, s101
// CHECK: [0x05,0x00,0x89,0xd1,0x65,0x00,0x00,0x00]

v_sin_f16_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x89,0xd1,0x66,0x00,0x00,0x00]

v_sin_f16_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x89,0xd1,0x67,0x00,0x00,0x00]

v_sin_f16_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x89,0xd1,0x6a,0x00,0x00,0x00]

v_sin_f16_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x89,0xd1,0x6b,0x00,0x00,0x00]

v_sin_f16_e64 v5, ttmp15
// CHECK: [0x05,0x00,0x89,0xd1,0x7b,0x00,0x00,0x00]

v_sin_f16_e64 v5, m0
// CHECK: [0x05,0x00,0x89,0xd1,0x7c,0x00,0x00,0x00]

v_sin_f16_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x89,0xd1,0x7e,0x00,0x00,0x00]

v_sin_f16_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x89,0xd1,0x7f,0x00,0x00,0x00]

v_sin_f16_e64 v5, 0
// CHECK: [0x05,0x00,0x89,0xd1,0x80,0x00,0x00,0x00]

v_sin_f16_e64 v5, -1
// CHECK: [0x05,0x00,0x89,0xd1,0xc1,0x00,0x00,0x00]

v_sin_f16_e64 v5, 0.5
// CHECK: [0x05,0x00,0x89,0xd1,0xf0,0x00,0x00,0x00]

v_sin_f16_e64 v5, -4.0
// CHECK: [0x05,0x00,0x89,0xd1,0xf7,0x00,0x00,0x00]

v_sin_f16_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x89,0xd1,0xfb,0x00,0x00,0x00]

v_sin_f16_e64 v5, src_execz
// CHECK: [0x05,0x00,0x89,0xd1,0xfc,0x00,0x00,0x00]

v_sin_f16_e64 v5, src_scc
// CHECK: [0x05,0x00,0x89,0xd1,0xfd,0x00,0x00,0x00]

v_sin_f16_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x89,0xd1,0xfe,0x00,0x00,0x00]

v_sin_f16_e64 v5, -v1
// CHECK: [0x05,0x00,0x89,0xd1,0x01,0x01,0x00,0x20]

v_sin_f16_e64 v5, |v1|
// CHECK: [0x05,0x01,0x89,0xd1,0x01,0x01,0x00,0x00]

v_sin_f16_e64 v5, v1 clamp
// CHECK: [0x05,0x80,0x89,0xd1,0x01,0x01,0x00,0x00]

v_cos_f16_e64 v5, v1
// CHECK: [0x05,0x00,0x8a,0xd1,0x01,0x01,0x00,0x00]

v_cos_f16_e64 v255, v1
// CHECK: [0xff,0x00,0x8a,0xd1,0x01,0x01,0x00,0x00]

v_cos_f16_e64 v5, v255
// CHECK: [0x05,0x00,0x8a,0xd1,0xff,0x01,0x00,0x00]

v_cos_f16_e64 v5, s1
// CHECK: [0x05,0x00,0x8a,0xd1,0x01,0x00,0x00,0x00]

v_cos_f16_e64 v5, s101
// CHECK: [0x05,0x00,0x8a,0xd1,0x65,0x00,0x00,0x00]

v_cos_f16_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x8a,0xd1,0x66,0x00,0x00,0x00]

v_cos_f16_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x8a,0xd1,0x67,0x00,0x00,0x00]

v_cos_f16_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x8a,0xd1,0x6a,0x00,0x00,0x00]

v_cos_f16_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x8a,0xd1,0x6b,0x00,0x00,0x00]

v_cos_f16_e64 v5, ttmp15
// CHECK: [0x05,0x00,0x8a,0xd1,0x7b,0x00,0x00,0x00]

v_cos_f16_e64 v5, m0
// CHECK: [0x05,0x00,0x8a,0xd1,0x7c,0x00,0x00,0x00]

v_cos_f16_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x8a,0xd1,0x7e,0x00,0x00,0x00]

v_cos_f16_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x8a,0xd1,0x7f,0x00,0x00,0x00]

v_cos_f16_e64 v5, 0
// CHECK: [0x05,0x00,0x8a,0xd1,0x80,0x00,0x00,0x00]

v_cos_f16_e64 v5, -1
// CHECK: [0x05,0x00,0x8a,0xd1,0xc1,0x00,0x00,0x00]

v_cos_f16_e64 v5, 0.5
// CHECK: [0x05,0x00,0x8a,0xd1,0xf0,0x00,0x00,0x00]

v_cos_f16_e64 v5, -4.0
// CHECK: [0x05,0x00,0x8a,0xd1,0xf7,0x00,0x00,0x00]

v_cos_f16_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x8a,0xd1,0xfb,0x00,0x00,0x00]

v_cos_f16_e64 v5, src_execz
// CHECK: [0x05,0x00,0x8a,0xd1,0xfc,0x00,0x00,0x00]

v_cos_f16_e64 v5, src_scc
// CHECK: [0x05,0x00,0x8a,0xd1,0xfd,0x00,0x00,0x00]

v_cos_f16_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x8a,0xd1,0xfe,0x00,0x00,0x00]

v_cos_f16_e64 v5, -v1
// CHECK: [0x05,0x00,0x8a,0xd1,0x01,0x01,0x00,0x20]

v_cos_f16_e64 v5, |v1|
// CHECK: [0x05,0x01,0x8a,0xd1,0x01,0x01,0x00,0x00]

v_cos_f16_e64 v5, v1 clamp
// CHECK: [0x05,0x80,0x8a,0xd1,0x01,0x01,0x00,0x00]

v_exp_legacy_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x8b,0xd1,0x01,0x01,0x00,0x00]

v_exp_legacy_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x8b,0xd1,0x01,0x01,0x00,0x00]

v_exp_legacy_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x8b,0xd1,0xff,0x01,0x00,0x00]

v_exp_legacy_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x8b,0xd1,0x01,0x00,0x00,0x00]

v_exp_legacy_f32_e64 v5, s101
// CHECK: [0x05,0x00,0x8b,0xd1,0x65,0x00,0x00,0x00]

v_exp_legacy_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x8b,0xd1,0x66,0x00,0x00,0x00]

v_exp_legacy_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x8b,0xd1,0x67,0x00,0x00,0x00]

v_exp_legacy_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x8b,0xd1,0x6a,0x00,0x00,0x00]

v_exp_legacy_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x8b,0xd1,0x6b,0x00,0x00,0x00]

v_exp_legacy_f32_e64 v5, ttmp15
// CHECK: [0x05,0x00,0x8b,0xd1,0x7b,0x00,0x00,0x00]

v_exp_legacy_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x8b,0xd1,0x7c,0x00,0x00,0x00]

v_exp_legacy_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x8b,0xd1,0x7e,0x00,0x00,0x00]

v_exp_legacy_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x8b,0xd1,0x7f,0x00,0x00,0x00]

v_exp_legacy_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x8b,0xd1,0x80,0x00,0x00,0x00]

v_exp_legacy_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x8b,0xd1,0xc1,0x00,0x00,0x00]

v_exp_legacy_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x8b,0xd1,0xf0,0x00,0x00,0x00]

v_exp_legacy_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x8b,0xd1,0xf7,0x00,0x00,0x00]

v_exp_legacy_f32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x8b,0xd1,0xfb,0x00,0x00,0x00]

v_exp_legacy_f32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x8b,0xd1,0xfc,0x00,0x00,0x00]

v_exp_legacy_f32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x8b,0xd1,0xfd,0x00,0x00,0x00]

v_exp_legacy_f32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x8b,0xd1,0xfe,0x00,0x00,0x00]

v_exp_legacy_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x8b,0xd1,0x01,0x01,0x00,0x20]

v_exp_legacy_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x8b,0xd1,0x01,0x01,0x00,0x00]

v_exp_legacy_f32_e64 v5, v1 clamp
// CHECK: [0x05,0x80,0x8b,0xd1,0x01,0x01,0x00,0x00]

v_exp_legacy_f32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x8b,0xd1,0x01,0x01,0x00,0x08]

v_exp_legacy_f32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x8b,0xd1,0x01,0x01,0x00,0x10]

v_exp_legacy_f32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x8b,0xd1,0x01,0x01,0x00,0x18]

v_log_legacy_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x8c,0xd1,0x01,0x01,0x00,0x00]

v_log_legacy_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x8c,0xd1,0x01,0x01,0x00,0x00]

v_log_legacy_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x8c,0xd1,0xff,0x01,0x00,0x00]

v_log_legacy_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x8c,0xd1,0x01,0x00,0x00,0x00]

v_log_legacy_f32_e64 v5, s101
// CHECK: [0x05,0x00,0x8c,0xd1,0x65,0x00,0x00,0x00]

v_log_legacy_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x8c,0xd1,0x66,0x00,0x00,0x00]

v_log_legacy_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x8c,0xd1,0x67,0x00,0x00,0x00]

v_log_legacy_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x8c,0xd1,0x6a,0x00,0x00,0x00]

v_log_legacy_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x8c,0xd1,0x6b,0x00,0x00,0x00]

v_log_legacy_f32_e64 v5, ttmp15
// CHECK: [0x05,0x00,0x8c,0xd1,0x7b,0x00,0x00,0x00]

v_log_legacy_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x8c,0xd1,0x7c,0x00,0x00,0x00]

v_log_legacy_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x8c,0xd1,0x7e,0x00,0x00,0x00]

v_log_legacy_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x8c,0xd1,0x7f,0x00,0x00,0x00]

v_log_legacy_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x8c,0xd1,0x80,0x00,0x00,0x00]

v_log_legacy_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x8c,0xd1,0xc1,0x00,0x00,0x00]

v_log_legacy_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x8c,0xd1,0xf0,0x00,0x00,0x00]

v_log_legacy_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x8c,0xd1,0xf7,0x00,0x00,0x00]

v_log_legacy_f32_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x8c,0xd1,0xfb,0x00,0x00,0x00]

v_log_legacy_f32_e64 v5, src_execz
// CHECK: [0x05,0x00,0x8c,0xd1,0xfc,0x00,0x00,0x00]

v_log_legacy_f32_e64 v5, src_scc
// CHECK: [0x05,0x00,0x8c,0xd1,0xfd,0x00,0x00,0x00]

v_log_legacy_f32_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x8c,0xd1,0xfe,0x00,0x00,0x00]

v_log_legacy_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x8c,0xd1,0x01,0x01,0x00,0x20]

v_log_legacy_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x8c,0xd1,0x01,0x01,0x00,0x00]

v_log_legacy_f32_e64 v5, v1 clamp
// CHECK: [0x05,0x80,0x8c,0xd1,0x01,0x01,0x00,0x00]

v_log_legacy_f32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x8c,0xd1,0x01,0x01,0x00,0x08]

v_log_legacy_f32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x8c,0xd1,0x01,0x01,0x00,0x10]

v_log_legacy_f32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x8c,0xd1,0x01,0x01,0x00,0x18]

v_cvt_norm_i16_f16_e64 v5, v1
// CHECK: [0x05,0x00,0x8d,0xd1,0x01,0x01,0x00,0x00]

v_cvt_norm_i16_f16_e64 v255, v1
// CHECK: [0xff,0x00,0x8d,0xd1,0x01,0x01,0x00,0x00]

v_cvt_norm_i16_f16_e64 v5, v255
// CHECK: [0x05,0x00,0x8d,0xd1,0xff,0x01,0x00,0x00]

v_cvt_norm_i16_f16_e64 v5, s1
// CHECK: [0x05,0x00,0x8d,0xd1,0x01,0x00,0x00,0x00]

v_cvt_norm_i16_f16_e64 v5, s101
// CHECK: [0x05,0x00,0x8d,0xd1,0x65,0x00,0x00,0x00]

v_cvt_norm_i16_f16_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x8d,0xd1,0x66,0x00,0x00,0x00]

v_cvt_norm_i16_f16_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x8d,0xd1,0x67,0x00,0x00,0x00]

v_cvt_norm_i16_f16_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x8d,0xd1,0x6a,0x00,0x00,0x00]

v_cvt_norm_i16_f16_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x8d,0xd1,0x6b,0x00,0x00,0x00]

v_cvt_norm_i16_f16_e64 v5, ttmp15
// CHECK: [0x05,0x00,0x8d,0xd1,0x7b,0x00,0x00,0x00]

v_cvt_norm_i16_f16_e64 v5, m0
// CHECK: [0x05,0x00,0x8d,0xd1,0x7c,0x00,0x00,0x00]

v_cvt_norm_i16_f16_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x8d,0xd1,0x7e,0x00,0x00,0x00]

v_cvt_norm_i16_f16_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x8d,0xd1,0x7f,0x00,0x00,0x00]

v_cvt_norm_i16_f16_e64 v5, 0
// CHECK: [0x05,0x00,0x8d,0xd1,0x80,0x00,0x00,0x00]

v_cvt_norm_i16_f16_e64 v5, -1
// CHECK: [0x05,0x00,0x8d,0xd1,0xc1,0x00,0x00,0x00]

v_cvt_norm_i16_f16_e64 v5, 0.5
// CHECK: [0x05,0x00,0x8d,0xd1,0xf0,0x00,0x00,0x00]

v_cvt_norm_i16_f16_e64 v5, -4.0
// CHECK: [0x05,0x00,0x8d,0xd1,0xf7,0x00,0x00,0x00]

v_cvt_norm_i16_f16_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x8d,0xd1,0xfb,0x00,0x00,0x00]

v_cvt_norm_i16_f16_e64 v5, src_execz
// CHECK: [0x05,0x00,0x8d,0xd1,0xfc,0x00,0x00,0x00]

v_cvt_norm_i16_f16_e64 v5, src_scc
// CHECK: [0x05,0x00,0x8d,0xd1,0xfd,0x00,0x00,0x00]

v_cvt_norm_i16_f16_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x8d,0xd1,0xfe,0x00,0x00,0x00]

v_cvt_norm_i16_f16_e64 v5, -v1
// CHECK: [0x05,0x00,0x8d,0xd1,0x01,0x01,0x00,0x20]

v_cvt_norm_i16_f16_e64 v5, |v1|
// CHECK: [0x05,0x01,0x8d,0xd1,0x01,0x01,0x00,0x00]

v_cvt_norm_i16_f16_e64 v5, v1 clamp
// CHECK: [0x05,0x80,0x8d,0xd1,0x01,0x01,0x00,0x00]

v_cvt_norm_u16_f16_e64 v5, v1
// CHECK: [0x05,0x00,0x8e,0xd1,0x01,0x01,0x00,0x00]

v_cvt_norm_u16_f16_e64 v255, v1
// CHECK: [0xff,0x00,0x8e,0xd1,0x01,0x01,0x00,0x00]

v_cvt_norm_u16_f16_e64 v5, v255
// CHECK: [0x05,0x00,0x8e,0xd1,0xff,0x01,0x00,0x00]

v_cvt_norm_u16_f16_e64 v5, s1
// CHECK: [0x05,0x00,0x8e,0xd1,0x01,0x00,0x00,0x00]

v_cvt_norm_u16_f16_e64 v5, s101
// CHECK: [0x05,0x00,0x8e,0xd1,0x65,0x00,0x00,0x00]

v_cvt_norm_u16_f16_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x8e,0xd1,0x66,0x00,0x00,0x00]

v_cvt_norm_u16_f16_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x8e,0xd1,0x67,0x00,0x00,0x00]

v_cvt_norm_u16_f16_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x8e,0xd1,0x6a,0x00,0x00,0x00]

v_cvt_norm_u16_f16_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x8e,0xd1,0x6b,0x00,0x00,0x00]

v_cvt_norm_u16_f16_e64 v5, ttmp15
// CHECK: [0x05,0x00,0x8e,0xd1,0x7b,0x00,0x00,0x00]

v_cvt_norm_u16_f16_e64 v5, m0
// CHECK: [0x05,0x00,0x8e,0xd1,0x7c,0x00,0x00,0x00]

v_cvt_norm_u16_f16_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x8e,0xd1,0x7e,0x00,0x00,0x00]

v_cvt_norm_u16_f16_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x8e,0xd1,0x7f,0x00,0x00,0x00]

v_cvt_norm_u16_f16_e64 v5, 0
// CHECK: [0x05,0x00,0x8e,0xd1,0x80,0x00,0x00,0x00]

v_cvt_norm_u16_f16_e64 v5, -1
// CHECK: [0x05,0x00,0x8e,0xd1,0xc1,0x00,0x00,0x00]

v_cvt_norm_u16_f16_e64 v5, 0.5
// CHECK: [0x05,0x00,0x8e,0xd1,0xf0,0x00,0x00,0x00]

v_cvt_norm_u16_f16_e64 v5, -4.0
// CHECK: [0x05,0x00,0x8e,0xd1,0xf7,0x00,0x00,0x00]

v_cvt_norm_u16_f16_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x8e,0xd1,0xfb,0x00,0x00,0x00]

v_cvt_norm_u16_f16_e64 v5, src_execz
// CHECK: [0x05,0x00,0x8e,0xd1,0xfc,0x00,0x00,0x00]

v_cvt_norm_u16_f16_e64 v5, src_scc
// CHECK: [0x05,0x00,0x8e,0xd1,0xfd,0x00,0x00,0x00]

v_cvt_norm_u16_f16_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x8e,0xd1,0xfe,0x00,0x00,0x00]

v_cvt_norm_u16_f16_e64 v5, -v1
// CHECK: [0x05,0x00,0x8e,0xd1,0x01,0x01,0x00,0x20]

v_cvt_norm_u16_f16_e64 v5, |v1|
// CHECK: [0x05,0x01,0x8e,0xd1,0x01,0x01,0x00,0x00]

v_cvt_norm_u16_f16_e64 v5, v1 clamp
// CHECK: [0x05,0x80,0x8e,0xd1,0x01,0x01,0x00,0x00]

v_sat_pk_u8_i16_e64 v5, v1
// CHECK: [0x05,0x00,0x8f,0xd1,0x01,0x01,0x00,0x00]

v_sat_pk_u8_i16_e64 v255, v1
// CHECK: [0xff,0x00,0x8f,0xd1,0x01,0x01,0x00,0x00]

v_sat_pk_u8_i16_e64 v5, v255
// CHECK: [0x05,0x00,0x8f,0xd1,0xff,0x01,0x00,0x00]

v_sat_pk_u8_i16_e64 v5, s1
// CHECK: [0x05,0x00,0x8f,0xd1,0x01,0x00,0x00,0x00]

v_sat_pk_u8_i16_e64 v5, s101
// CHECK: [0x05,0x00,0x8f,0xd1,0x65,0x00,0x00,0x00]

v_sat_pk_u8_i16_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x8f,0xd1,0x66,0x00,0x00,0x00]

v_sat_pk_u8_i16_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x8f,0xd1,0x67,0x00,0x00,0x00]

v_sat_pk_u8_i16_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x8f,0xd1,0x6a,0x00,0x00,0x00]

v_sat_pk_u8_i16_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x8f,0xd1,0x6b,0x00,0x00,0x00]

v_sat_pk_u8_i16_e64 v5, ttmp15
// CHECK: [0x05,0x00,0x8f,0xd1,0x7b,0x00,0x00,0x00]

v_sat_pk_u8_i16_e64 v5, m0
// CHECK: [0x05,0x00,0x8f,0xd1,0x7c,0x00,0x00,0x00]

v_sat_pk_u8_i16_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x8f,0xd1,0x7e,0x00,0x00,0x00]

v_sat_pk_u8_i16_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x8f,0xd1,0x7f,0x00,0x00,0x00]

v_sat_pk_u8_i16_e64 v5, 0
// CHECK: [0x05,0x00,0x8f,0xd1,0x80,0x00,0x00,0x00]

v_sat_pk_u8_i16_e64 v5, -1
// CHECK: [0x05,0x00,0x8f,0xd1,0xc1,0x00,0x00,0x00]

v_sat_pk_u8_i16_e64 v5, 0.5
// CHECK: [0x05,0x00,0x8f,0xd1,0xf0,0x00,0x00,0x00]

v_sat_pk_u8_i16_e64 v5, -4.0
// CHECK: [0x05,0x00,0x8f,0xd1,0xf7,0x00,0x00,0x00]

v_sat_pk_u8_i16_e64 v5, src_vccz
// CHECK: [0x05,0x00,0x8f,0xd1,0xfb,0x00,0x00,0x00]

v_sat_pk_u8_i16_e64 v5, src_execz
// CHECK: [0x05,0x00,0x8f,0xd1,0xfc,0x00,0x00,0x00]

v_sat_pk_u8_i16_e64 v5, src_scc
// CHECK: [0x05,0x00,0x8f,0xd1,0xfd,0x00,0x00,0x00]

v_sat_pk_u8_i16_e64 v5, src_lds_direct
// CHECK: [0x05,0x00,0x8f,0xd1,0xfe,0x00,0x00,0x00]

v_cndmask_b32_e64 v5, v1, v2, s[6:7]
// CHECK: [0x05,0x00,0x00,0xd1,0x01,0x05,0x1a,0x00]

v_cndmask_b32_e64 v255, v1, v2, s[6:7]
// CHECK: [0xff,0x00,0x00,0xd1,0x01,0x05,0x1a,0x00]

v_cndmask_b32_e64 v5, v255, v2, s[6:7]
// CHECK: [0x05,0x00,0x00,0xd1,0xff,0x05,0x1a,0x00]

v_cndmask_b32_e64 v5, 0, v2, s[6:7]
// CHECK: [0x05,0x00,0x00,0xd1,0x80,0x04,0x1a,0x00]

v_cndmask_b32_e64 v5, -1, v2, s[6:7]
// CHECK: [0x05,0x00,0x00,0xd1,0xc1,0x04,0x1a,0x00]

v_cndmask_b32_e64 v5, 0.5, v2, s[6:7]
// CHECK: [0x05,0x00,0x00,0xd1,0xf0,0x04,0x1a,0x00]

v_cndmask_b32_e64 v5, -4.0, v2, s[6:7]
// CHECK: [0x05,0x00,0x00,0xd1,0xf7,0x04,0x1a,0x00]

v_cndmask_b32_e64 v5, src_lds_direct, v2, s[6:7]
// CHECK: [0x05,0x00,0x00,0xd1,0xfe,0x04,0x1a,0x00]

v_cndmask_b32_e64 v5, v1, v255, s[6:7]
// CHECK: [0x05,0x00,0x00,0xd1,0x01,0xff,0x1b,0x00]

v_cndmask_b32_e64 v5, v1, 0, s[6:7]
// CHECK: [0x05,0x00,0x00,0xd1,0x01,0x01,0x19,0x00]

v_cndmask_b32_e64 v5, v1, -1, s[6:7]
// CHECK: [0x05,0x00,0x00,0xd1,0x01,0x83,0x19,0x00]

v_cndmask_b32_e64 v5, v1, 0.5, s[6:7]
// CHECK: [0x05,0x00,0x00,0xd1,0x01,0xe1,0x19,0x00]

v_cndmask_b32_e64 v5, v1, -4.0, s[6:7]
// CHECK: [0x05,0x00,0x00,0xd1,0x01,0xef,0x19,0x00]

v_cndmask_b32_e64 v5, v1, v2, s[8:9]
// CHECK: [0x05,0x00,0x00,0xd1,0x01,0x05,0x22,0x00]

v_cndmask_b32_e64 v5, v1, v2, s[100:101]
// CHECK: [0x05,0x00,0x00,0xd1,0x01,0x05,0x92,0x01]

v_cndmask_b32_e64 v5, v1, v2, flat_scratch
// CHECK: [0x05,0x00,0x00,0xd1,0x01,0x05,0x9a,0x01]

v_cndmask_b32_e64 v5, v1, v2, vcc
// CHECK: [0x05,0x00,0x00,0xd1,0x01,0x05,0xaa,0x01]

v_cndmask_b32_e64 v5, v1, v2, ttmp[14:15]
// CHECK: [0x05,0x00,0x00,0xd1,0x01,0x05,0xea,0x01]

v_add_f32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x01,0xd1,0x01,0x05,0x02,0x00]

v_add_f32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x01,0xd1,0x01,0x05,0x02,0x00]

v_add_f32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x01,0xd1,0xff,0x05,0x02,0x00]

v_add_f32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x01,0xd1,0x01,0x04,0x02,0x00]

v_add_f32_e64 v5, s101, v2
// CHECK: [0x05,0x00,0x01,0xd1,0x65,0x04,0x02,0x00]

v_add_f32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x01,0xd1,0x66,0x04,0x02,0x00]

v_add_f32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x01,0xd1,0x67,0x04,0x02,0x00]

v_add_f32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x01,0xd1,0x6a,0x04,0x02,0x00]

v_add_f32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x01,0xd1,0x6b,0x04,0x02,0x00]

v_add_f32_e64 v5, ttmp15, v2
// CHECK: [0x05,0x00,0x01,0xd1,0x7b,0x04,0x02,0x00]

v_add_f32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x01,0xd1,0x7c,0x04,0x02,0x00]

v_add_f32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x01,0xd1,0x7e,0x04,0x02,0x00]

v_add_f32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x01,0xd1,0x7f,0x04,0x02,0x00]

v_add_f32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x01,0xd1,0x80,0x04,0x02,0x00]

v_add_f32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x01,0xd1,0xc1,0x04,0x02,0x00]

v_add_f32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x01,0xd1,0xf0,0x04,0x02,0x00]

v_add_f32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x01,0xd1,0xf7,0x04,0x02,0x00]

v_add_f32_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x01,0xd1,0xfb,0x04,0x02,0x00]

v_add_f32_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x01,0xd1,0xfc,0x04,0x02,0x00]

v_add_f32_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x01,0xd1,0xfd,0x04,0x02,0x00]

v_add_f32_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x01,0xd1,0xfe,0x04,0x02,0x00]

v_add_f32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x01,0xd1,0x01,0xff,0x03,0x00]

v_add_f32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x01,0xd1,0x01,0x05,0x00,0x00]

v_add_f32_e64 v5, v1, s101
// CHECK: [0x05,0x00,0x01,0xd1,0x01,0xcb,0x00,0x00]

v_add_f32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x01,0xd1,0x01,0xcd,0x00,0x00]

v_add_f32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x01,0xd1,0x01,0xcf,0x00,0x00]

v_add_f32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x01,0xd1,0x01,0xd5,0x00,0x00]

v_add_f32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x01,0xd1,0x01,0xd7,0x00,0x00]

v_add_f32_e64 v5, v1, ttmp15
// CHECK: [0x05,0x00,0x01,0xd1,0x01,0xf7,0x00,0x00]

v_add_f32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x01,0xd1,0x01,0xf9,0x00,0x00]

v_add_f32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x01,0xd1,0x01,0xfd,0x00,0x00]

v_add_f32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x01,0xd1,0x01,0xff,0x00,0x00]

v_add_f32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x01,0xd1,0x01,0x01,0x01,0x00]

v_add_f32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x01,0xd1,0x01,0x83,0x01,0x00]

v_add_f32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x01,0xd1,0x01,0xe1,0x01,0x00]

v_add_f32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x01,0xd1,0x01,0xef,0x01,0x00]

v_add_f32_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x01,0xd1,0x01,0xf7,0x01,0x00]

v_add_f32_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x01,0xd1,0x01,0xf9,0x01,0x00]

v_add_f32_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x01,0xd1,0x01,0xfb,0x01,0x00]

v_add_f32_e64 v5, -v1, v2
// CHECK: [0x05,0x00,0x01,0xd1,0x01,0x05,0x02,0x20]

v_add_f32_e64 v5, v1, -v2
// CHECK: [0x05,0x00,0x01,0xd1,0x01,0x05,0x02,0x40]

v_add_f32_e64 v5, -v1, -v2
// CHECK: [0x05,0x00,0x01,0xd1,0x01,0x05,0x02,0x60]

v_add_f32_e64 v5, |v1|, v2
// CHECK: [0x05,0x01,0x01,0xd1,0x01,0x05,0x02,0x00]

v_add_f32_e64 v5, v1, |v2|
// CHECK: [0x05,0x02,0x01,0xd1,0x01,0x05,0x02,0x00]

v_add_f32_e64 v5, |v1|, |v2|
// CHECK: [0x05,0x03,0x01,0xd1,0x01,0x05,0x02,0x00]

v_add_f32_e64 v5, v1, v2 clamp
// CHECK: [0x05,0x80,0x01,0xd1,0x01,0x05,0x02,0x00]

v_add_f32_e64 v5, v1, v2 mul:2
// CHECK: [0x05,0x00,0x01,0xd1,0x01,0x05,0x02,0x08]

v_add_f32_e64 v5, v1, v2 mul:4
// CHECK: [0x05,0x00,0x01,0xd1,0x01,0x05,0x02,0x10]

v_add_f32_e64 v5, v1, v2 div:2
// CHECK: [0x05,0x00,0x01,0xd1,0x01,0x05,0x02,0x18]

v_sub_f32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x02,0xd1,0x01,0x05,0x02,0x00]

v_sub_f32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x02,0xd1,0x01,0x05,0x02,0x00]

v_sub_f32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x02,0xd1,0xff,0x05,0x02,0x00]

v_sub_f32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x02,0xd1,0x01,0x04,0x02,0x00]

v_sub_f32_e64 v5, s101, v2
// CHECK: [0x05,0x00,0x02,0xd1,0x65,0x04,0x02,0x00]

v_sub_f32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x02,0xd1,0x66,0x04,0x02,0x00]

v_sub_f32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x02,0xd1,0x67,0x04,0x02,0x00]

v_sub_f32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x02,0xd1,0x6a,0x04,0x02,0x00]

v_sub_f32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x02,0xd1,0x6b,0x04,0x02,0x00]

v_sub_f32_e64 v5, ttmp15, v2
// CHECK: [0x05,0x00,0x02,0xd1,0x7b,0x04,0x02,0x00]

v_sub_f32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x02,0xd1,0x7c,0x04,0x02,0x00]

v_sub_f32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x02,0xd1,0x7e,0x04,0x02,0x00]

v_sub_f32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x02,0xd1,0x7f,0x04,0x02,0x00]

v_sub_f32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x02,0xd1,0x80,0x04,0x02,0x00]

v_sub_f32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x02,0xd1,0xc1,0x04,0x02,0x00]

v_sub_f32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x02,0xd1,0xf0,0x04,0x02,0x00]

v_sub_f32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x02,0xd1,0xf7,0x04,0x02,0x00]

v_sub_f32_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x02,0xd1,0xfb,0x04,0x02,0x00]

v_sub_f32_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x02,0xd1,0xfc,0x04,0x02,0x00]

v_sub_f32_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x02,0xd1,0xfd,0x04,0x02,0x00]

v_sub_f32_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x02,0xd1,0xfe,0x04,0x02,0x00]

v_sub_f32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x02,0xd1,0x01,0xff,0x03,0x00]

v_sub_f32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x02,0xd1,0x01,0x05,0x00,0x00]

v_sub_f32_e64 v5, v1, s101
// CHECK: [0x05,0x00,0x02,0xd1,0x01,0xcb,0x00,0x00]

v_sub_f32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x02,0xd1,0x01,0xcd,0x00,0x00]

v_sub_f32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x02,0xd1,0x01,0xcf,0x00,0x00]

v_sub_f32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x02,0xd1,0x01,0xd5,0x00,0x00]

v_sub_f32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x02,0xd1,0x01,0xd7,0x00,0x00]

v_sub_f32_e64 v5, v1, ttmp15
// CHECK: [0x05,0x00,0x02,0xd1,0x01,0xf7,0x00,0x00]

v_sub_f32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x02,0xd1,0x01,0xf9,0x00,0x00]

v_sub_f32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x02,0xd1,0x01,0xfd,0x00,0x00]

v_sub_f32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x02,0xd1,0x01,0xff,0x00,0x00]

v_sub_f32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x02,0xd1,0x01,0x01,0x01,0x00]

v_sub_f32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x02,0xd1,0x01,0x83,0x01,0x00]

v_sub_f32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x02,0xd1,0x01,0xe1,0x01,0x00]

v_sub_f32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x02,0xd1,0x01,0xef,0x01,0x00]

v_sub_f32_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x02,0xd1,0x01,0xf7,0x01,0x00]

v_sub_f32_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x02,0xd1,0x01,0xf9,0x01,0x00]

v_sub_f32_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x02,0xd1,0x01,0xfb,0x01,0x00]

v_sub_f32_e64 v5, -v1, v2
// CHECK: [0x05,0x00,0x02,0xd1,0x01,0x05,0x02,0x20]

v_sub_f32_e64 v5, v1, -v2
// CHECK: [0x05,0x00,0x02,0xd1,0x01,0x05,0x02,0x40]

v_sub_f32_e64 v5, -v1, -v2
// CHECK: [0x05,0x00,0x02,0xd1,0x01,0x05,0x02,0x60]

v_sub_f32_e64 v5, |v1|, v2
// CHECK: [0x05,0x01,0x02,0xd1,0x01,0x05,0x02,0x00]

v_sub_f32_e64 v5, v1, |v2|
// CHECK: [0x05,0x02,0x02,0xd1,0x01,0x05,0x02,0x00]

v_sub_f32_e64 v5, |v1|, |v2|
// CHECK: [0x05,0x03,0x02,0xd1,0x01,0x05,0x02,0x00]

v_sub_f32_e64 v5, v1, v2 clamp
// CHECK: [0x05,0x80,0x02,0xd1,0x01,0x05,0x02,0x00]

v_sub_f32_e64 v5, v1, v2 mul:2
// CHECK: [0x05,0x00,0x02,0xd1,0x01,0x05,0x02,0x08]

v_sub_f32_e64 v5, v1, v2 mul:4
// CHECK: [0x05,0x00,0x02,0xd1,0x01,0x05,0x02,0x10]

v_sub_f32_e64 v5, v1, v2 div:2
// CHECK: [0x05,0x00,0x02,0xd1,0x01,0x05,0x02,0x18]

v_subrev_f32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x03,0xd1,0x01,0x05,0x02,0x00]

v_subrev_f32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x03,0xd1,0x01,0x05,0x02,0x00]

v_subrev_f32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x03,0xd1,0xff,0x05,0x02,0x00]

v_subrev_f32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x03,0xd1,0x01,0x04,0x02,0x00]

v_subrev_f32_e64 v5, s101, v2
// CHECK: [0x05,0x00,0x03,0xd1,0x65,0x04,0x02,0x00]

v_subrev_f32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x03,0xd1,0x66,0x04,0x02,0x00]

v_subrev_f32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x03,0xd1,0x67,0x04,0x02,0x00]

v_subrev_f32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x03,0xd1,0x6a,0x04,0x02,0x00]

v_subrev_f32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x03,0xd1,0x6b,0x04,0x02,0x00]

v_subrev_f32_e64 v5, ttmp15, v2
// CHECK: [0x05,0x00,0x03,0xd1,0x7b,0x04,0x02,0x00]

v_subrev_f32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x03,0xd1,0x7c,0x04,0x02,0x00]

v_subrev_f32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x03,0xd1,0x7e,0x04,0x02,0x00]

v_subrev_f32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x03,0xd1,0x7f,0x04,0x02,0x00]

v_subrev_f32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x03,0xd1,0x80,0x04,0x02,0x00]

v_subrev_f32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x03,0xd1,0xc1,0x04,0x02,0x00]

v_subrev_f32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x03,0xd1,0xf0,0x04,0x02,0x00]

v_subrev_f32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x03,0xd1,0xf7,0x04,0x02,0x00]

v_subrev_f32_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x03,0xd1,0xfb,0x04,0x02,0x00]

v_subrev_f32_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x03,0xd1,0xfc,0x04,0x02,0x00]

v_subrev_f32_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x03,0xd1,0xfd,0x04,0x02,0x00]

v_subrev_f32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x03,0xd1,0x01,0xff,0x03,0x00]

v_subrev_f32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x03,0xd1,0x01,0x05,0x00,0x00]

v_subrev_f32_e64 v5, v1, s101
// CHECK: [0x05,0x00,0x03,0xd1,0x01,0xcb,0x00,0x00]

v_subrev_f32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x03,0xd1,0x01,0xcd,0x00,0x00]

v_subrev_f32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x03,0xd1,0x01,0xcf,0x00,0x00]

v_subrev_f32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x03,0xd1,0x01,0xd5,0x00,0x00]

v_subrev_f32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x03,0xd1,0x01,0xd7,0x00,0x00]

v_subrev_f32_e64 v5, v1, ttmp15
// CHECK: [0x05,0x00,0x03,0xd1,0x01,0xf7,0x00,0x00]

v_subrev_f32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x03,0xd1,0x01,0xf9,0x00,0x00]

v_subrev_f32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x03,0xd1,0x01,0xfd,0x00,0x00]

v_subrev_f32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x03,0xd1,0x01,0xff,0x00,0x00]

v_subrev_f32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x03,0xd1,0x01,0x01,0x01,0x00]

v_subrev_f32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x03,0xd1,0x01,0x83,0x01,0x00]

v_subrev_f32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x03,0xd1,0x01,0xe1,0x01,0x00]

v_subrev_f32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x03,0xd1,0x01,0xef,0x01,0x00]

v_subrev_f32_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x03,0xd1,0x01,0xf7,0x01,0x00]

v_subrev_f32_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x03,0xd1,0x01,0xf9,0x01,0x00]

v_subrev_f32_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x03,0xd1,0x01,0xfb,0x01,0x00]

v_subrev_f32_e64 v5, -v1, v2
// CHECK: [0x05,0x00,0x03,0xd1,0x01,0x05,0x02,0x20]

v_subrev_f32_e64 v5, v1, -v2
// CHECK: [0x05,0x00,0x03,0xd1,0x01,0x05,0x02,0x40]

v_subrev_f32_e64 v5, -v1, -v2
// CHECK: [0x05,0x00,0x03,0xd1,0x01,0x05,0x02,0x60]

v_subrev_f32_e64 v5, |v1|, v2
// CHECK: [0x05,0x01,0x03,0xd1,0x01,0x05,0x02,0x00]

v_subrev_f32_e64 v5, v1, |v2|
// CHECK: [0x05,0x02,0x03,0xd1,0x01,0x05,0x02,0x00]

v_subrev_f32_e64 v5, |v1|, |v2|
// CHECK: [0x05,0x03,0x03,0xd1,0x01,0x05,0x02,0x00]

v_subrev_f32_e64 v5, v1, v2 clamp
// CHECK: [0x05,0x80,0x03,0xd1,0x01,0x05,0x02,0x00]

v_subrev_f32_e64 v5, v1, v2 mul:2
// CHECK: [0x05,0x00,0x03,0xd1,0x01,0x05,0x02,0x08]

v_subrev_f32_e64 v5, v1, v2 mul:4
// CHECK: [0x05,0x00,0x03,0xd1,0x01,0x05,0x02,0x10]

v_subrev_f32_e64 v5, v1, v2 div:2
// CHECK: [0x05,0x00,0x03,0xd1,0x01,0x05,0x02,0x18]

v_mul_legacy_f32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x04,0xd1,0x01,0x05,0x02,0x00]

v_mul_legacy_f32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x04,0xd1,0x01,0x05,0x02,0x00]

v_mul_legacy_f32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x04,0xd1,0xff,0x05,0x02,0x00]

v_mul_legacy_f32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x04,0xd1,0x01,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, s101, v2
// CHECK: [0x05,0x00,0x04,0xd1,0x65,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x04,0xd1,0x66,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x04,0xd1,0x67,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x04,0xd1,0x6a,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x04,0xd1,0x6b,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, ttmp15, v2
// CHECK: [0x05,0x00,0x04,0xd1,0x7b,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x04,0xd1,0x7c,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x04,0xd1,0x7e,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x04,0xd1,0x7f,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x04,0xd1,0x80,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x04,0xd1,0xc1,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x04,0xd1,0xf0,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x04,0xd1,0xf7,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x04,0xd1,0xfb,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x04,0xd1,0xfc,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x04,0xd1,0xfd,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x04,0xd1,0xfe,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x04,0xd1,0x01,0xff,0x03,0x00]

v_mul_legacy_f32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x04,0xd1,0x01,0x05,0x00,0x00]

v_mul_legacy_f32_e64 v5, v1, s101
// CHECK: [0x05,0x00,0x04,0xd1,0x01,0xcb,0x00,0x00]

v_mul_legacy_f32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x04,0xd1,0x01,0xcd,0x00,0x00]

v_mul_legacy_f32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x04,0xd1,0x01,0xcf,0x00,0x00]

v_mul_legacy_f32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x04,0xd1,0x01,0xd5,0x00,0x00]

v_mul_legacy_f32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x04,0xd1,0x01,0xd7,0x00,0x00]

v_mul_legacy_f32_e64 v5, v1, ttmp15
// CHECK: [0x05,0x00,0x04,0xd1,0x01,0xf7,0x00,0x00]

v_mul_legacy_f32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x04,0xd1,0x01,0xf9,0x00,0x00]

v_mul_legacy_f32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x04,0xd1,0x01,0xfd,0x00,0x00]

v_mul_legacy_f32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x04,0xd1,0x01,0xff,0x00,0x00]

v_mul_legacy_f32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x04,0xd1,0x01,0x01,0x01,0x00]

v_mul_legacy_f32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x04,0xd1,0x01,0x83,0x01,0x00]

v_mul_legacy_f32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x04,0xd1,0x01,0xe1,0x01,0x00]

v_mul_legacy_f32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x04,0xd1,0x01,0xef,0x01,0x00]

v_mul_legacy_f32_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x04,0xd1,0x01,0xf7,0x01,0x00]

v_mul_legacy_f32_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x04,0xd1,0x01,0xf9,0x01,0x00]

v_mul_legacy_f32_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x04,0xd1,0x01,0xfb,0x01,0x00]

v_mul_legacy_f32_e64 v5, -v1, v2
// CHECK: [0x05,0x00,0x04,0xd1,0x01,0x05,0x02,0x20]

v_mul_legacy_f32_e64 v5, v1, -v2
// CHECK: [0x05,0x00,0x04,0xd1,0x01,0x05,0x02,0x40]

v_mul_legacy_f32_e64 v5, -v1, -v2
// CHECK: [0x05,0x00,0x04,0xd1,0x01,0x05,0x02,0x60]

v_mul_legacy_f32_e64 v5, |v1|, v2
// CHECK: [0x05,0x01,0x04,0xd1,0x01,0x05,0x02,0x00]

v_mul_legacy_f32_e64 v5, v1, |v2|
// CHECK: [0x05,0x02,0x04,0xd1,0x01,0x05,0x02,0x00]

v_mul_legacy_f32_e64 v5, |v1|, |v2|
// CHECK: [0x05,0x03,0x04,0xd1,0x01,0x05,0x02,0x00]

v_mul_legacy_f32_e64 v5, v1, v2 clamp
// CHECK: [0x05,0x80,0x04,0xd1,0x01,0x05,0x02,0x00]

v_mul_legacy_f32_e64 v5, v1, v2 mul:2
// CHECK: [0x05,0x00,0x04,0xd1,0x01,0x05,0x02,0x08]

v_mul_legacy_f32_e64 v5, v1, v2 mul:4
// CHECK: [0x05,0x00,0x04,0xd1,0x01,0x05,0x02,0x10]

v_mul_legacy_f32_e64 v5, v1, v2 div:2
// CHECK: [0x05,0x00,0x04,0xd1,0x01,0x05,0x02,0x18]

v_mul_f32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x05,0xd1,0x01,0x05,0x02,0x00]

v_mul_f32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x05,0xd1,0x01,0x05,0x02,0x00]

v_mul_f32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x05,0xd1,0xff,0x05,0x02,0x00]

v_mul_f32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x05,0xd1,0x01,0x04,0x02,0x00]

v_mul_f32_e64 v5, s101, v2
// CHECK: [0x05,0x00,0x05,0xd1,0x65,0x04,0x02,0x00]

v_mul_f32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x05,0xd1,0x66,0x04,0x02,0x00]

v_mul_f32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x05,0xd1,0x67,0x04,0x02,0x00]

v_mul_f32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x05,0xd1,0x6a,0x04,0x02,0x00]

v_mul_f32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x05,0xd1,0x6b,0x04,0x02,0x00]

v_mul_f32_e64 v5, ttmp15, v2
// CHECK: [0x05,0x00,0x05,0xd1,0x7b,0x04,0x02,0x00]

v_mul_f32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x05,0xd1,0x7c,0x04,0x02,0x00]

v_mul_f32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x05,0xd1,0x7e,0x04,0x02,0x00]

v_mul_f32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x05,0xd1,0x7f,0x04,0x02,0x00]

v_mul_f32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x05,0xd1,0x80,0x04,0x02,0x00]

v_mul_f32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x05,0xd1,0xc1,0x04,0x02,0x00]

v_mul_f32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x05,0xd1,0xf0,0x04,0x02,0x00]

v_mul_f32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x05,0xd1,0xf7,0x04,0x02,0x00]

v_mul_f32_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x05,0xd1,0xfb,0x04,0x02,0x00]

v_mul_f32_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x05,0xd1,0xfc,0x04,0x02,0x00]

v_mul_f32_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x05,0xd1,0xfd,0x04,0x02,0x00]

v_mul_f32_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x05,0xd1,0xfe,0x04,0x02,0x00]

v_mul_f32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x05,0xd1,0x01,0xff,0x03,0x00]

v_mul_f32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x05,0xd1,0x01,0x05,0x00,0x00]

v_mul_f32_e64 v5, v1, s101
// CHECK: [0x05,0x00,0x05,0xd1,0x01,0xcb,0x00,0x00]

v_mul_f32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x05,0xd1,0x01,0xcd,0x00,0x00]

v_mul_f32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x05,0xd1,0x01,0xcf,0x00,0x00]

v_mul_f32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x05,0xd1,0x01,0xd5,0x00,0x00]

v_mul_f32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x05,0xd1,0x01,0xd7,0x00,0x00]

v_mul_f32_e64 v5, v1, ttmp15
// CHECK: [0x05,0x00,0x05,0xd1,0x01,0xf7,0x00,0x00]

v_mul_f32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x05,0xd1,0x01,0xf9,0x00,0x00]

v_mul_f32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x05,0xd1,0x01,0xfd,0x00,0x00]

v_mul_f32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x05,0xd1,0x01,0xff,0x00,0x00]

v_mul_f32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x05,0xd1,0x01,0x01,0x01,0x00]

v_mul_f32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x05,0xd1,0x01,0x83,0x01,0x00]

v_mul_f32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x05,0xd1,0x01,0xe1,0x01,0x00]

v_mul_f32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x05,0xd1,0x01,0xef,0x01,0x00]

v_mul_f32_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x05,0xd1,0x01,0xf7,0x01,0x00]

v_mul_f32_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x05,0xd1,0x01,0xf9,0x01,0x00]

v_mul_f32_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x05,0xd1,0x01,0xfb,0x01,0x00]

v_mul_f32_e64 v5, -v1, v2
// CHECK: [0x05,0x00,0x05,0xd1,0x01,0x05,0x02,0x20]

v_mul_f32_e64 v5, v1, -v2
// CHECK: [0x05,0x00,0x05,0xd1,0x01,0x05,0x02,0x40]

v_mul_f32_e64 v5, -v1, -v2
// CHECK: [0x05,0x00,0x05,0xd1,0x01,0x05,0x02,0x60]

v_mul_f32_e64 v5, |v1|, v2
// CHECK: [0x05,0x01,0x05,0xd1,0x01,0x05,0x02,0x00]

v_mul_f32_e64 v5, v1, |v2|
// CHECK: [0x05,0x02,0x05,0xd1,0x01,0x05,0x02,0x00]

v_mul_f32_e64 v5, |v1|, |v2|
// CHECK: [0x05,0x03,0x05,0xd1,0x01,0x05,0x02,0x00]

v_mul_f32_e64 v5, v1, v2 clamp
// CHECK: [0x05,0x80,0x05,0xd1,0x01,0x05,0x02,0x00]

v_mul_f32_e64 v5, v1, v2 mul:2
// CHECK: [0x05,0x00,0x05,0xd1,0x01,0x05,0x02,0x08]

v_mul_f32_e64 v5, v1, v2 mul:4
// CHECK: [0x05,0x00,0x05,0xd1,0x01,0x05,0x02,0x10]

v_mul_f32_e64 v5, v1, v2 div:2
// CHECK: [0x05,0x00,0x05,0xd1,0x01,0x05,0x02,0x18]

v_mul_i32_i24_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x06,0xd1,0x01,0x05,0x02,0x00]

v_mul_i32_i24_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x06,0xd1,0x01,0x05,0x02,0x00]

v_mul_i32_i24_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x06,0xd1,0xff,0x05,0x02,0x00]

v_mul_i32_i24_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x06,0xd1,0x01,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, s101, v2
// CHECK: [0x05,0x00,0x06,0xd1,0x65,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x06,0xd1,0x66,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x06,0xd1,0x67,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x06,0xd1,0x6a,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x06,0xd1,0x6b,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, ttmp15, v2
// CHECK: [0x05,0x00,0x06,0xd1,0x7b,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x06,0xd1,0x7c,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x06,0xd1,0x7e,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x06,0xd1,0x7f,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x06,0xd1,0x80,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x06,0xd1,0xc1,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x06,0xd1,0xf0,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x06,0xd1,0xf7,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x06,0xd1,0xfb,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x06,0xd1,0xfc,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x06,0xd1,0xfd,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x06,0xd1,0xfe,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x06,0xd1,0x01,0xff,0x03,0x00]

v_mul_i32_i24_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x06,0xd1,0x01,0x05,0x00,0x00]

v_mul_i32_i24_e64 v5, v1, s101
// CHECK: [0x05,0x00,0x06,0xd1,0x01,0xcb,0x00,0x00]

v_mul_i32_i24_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x06,0xd1,0x01,0xcd,0x00,0x00]

v_mul_i32_i24_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x06,0xd1,0x01,0xcf,0x00,0x00]

v_mul_i32_i24_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x06,0xd1,0x01,0xd5,0x00,0x00]

v_mul_i32_i24_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x06,0xd1,0x01,0xd7,0x00,0x00]

v_mul_i32_i24_e64 v5, v1, ttmp15
// CHECK: [0x05,0x00,0x06,0xd1,0x01,0xf7,0x00,0x00]

v_mul_i32_i24_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x06,0xd1,0x01,0xf9,0x00,0x00]

v_mul_i32_i24_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x06,0xd1,0x01,0xfd,0x00,0x00]

v_mul_i32_i24_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x06,0xd1,0x01,0xff,0x00,0x00]

v_mul_i32_i24_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x06,0xd1,0x01,0x01,0x01,0x00]

v_mul_i32_i24_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x06,0xd1,0x01,0x83,0x01,0x00]

v_mul_i32_i24_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x06,0xd1,0x01,0xe1,0x01,0x00]

v_mul_i32_i24_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x06,0xd1,0x01,0xef,0x01,0x00]

v_mul_i32_i24_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x06,0xd1,0x01,0xf7,0x01,0x00]

v_mul_i32_i24_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x06,0xd1,0x01,0xf9,0x01,0x00]

v_mul_i32_i24_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x06,0xd1,0x01,0xfb,0x01,0x00]

v_mul_i32_i24_e64 v5, v1, v2 clamp
// CHECK: [0x05,0x80,0x06,0xd1,0x01,0x05,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x07,0xd1,0x01,0x05,0x02,0x00]

v_mul_hi_i32_i24_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x07,0xd1,0x01,0x05,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x07,0xd1,0xff,0x05,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x07,0xd1,0x01,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, s101, v2
// CHECK: [0x05,0x00,0x07,0xd1,0x65,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x07,0xd1,0x66,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x07,0xd1,0x67,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x07,0xd1,0x6a,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x07,0xd1,0x6b,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, ttmp15, v2
// CHECK: [0x05,0x00,0x07,0xd1,0x7b,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x07,0xd1,0x7c,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x07,0xd1,0x7e,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x07,0xd1,0x7f,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x07,0xd1,0x80,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x07,0xd1,0xc1,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x07,0xd1,0xf0,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x07,0xd1,0xf7,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x07,0xd1,0xfb,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x07,0xd1,0xfc,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x07,0xd1,0xfd,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x07,0xd1,0xfe,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x07,0xd1,0x01,0xff,0x03,0x00]

v_mul_hi_i32_i24_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x07,0xd1,0x01,0x05,0x00,0x00]

v_mul_hi_i32_i24_e64 v5, v1, s101
// CHECK: [0x05,0x00,0x07,0xd1,0x01,0xcb,0x00,0x00]

v_mul_hi_i32_i24_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x07,0xd1,0x01,0xcd,0x00,0x00]

v_mul_hi_i32_i24_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x07,0xd1,0x01,0xcf,0x00,0x00]

v_mul_hi_i32_i24_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x07,0xd1,0x01,0xd5,0x00,0x00]

v_mul_hi_i32_i24_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x07,0xd1,0x01,0xd7,0x00,0x00]

v_mul_hi_i32_i24_e64 v5, v1, ttmp15
// CHECK: [0x05,0x00,0x07,0xd1,0x01,0xf7,0x00,0x00]

v_mul_hi_i32_i24_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x07,0xd1,0x01,0xf9,0x00,0x00]

v_mul_hi_i32_i24_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x07,0xd1,0x01,0xfd,0x00,0x00]

v_mul_hi_i32_i24_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x07,0xd1,0x01,0xff,0x00,0x00]

v_mul_hi_i32_i24_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x07,0xd1,0x01,0x01,0x01,0x00]

v_mul_hi_i32_i24_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x07,0xd1,0x01,0x83,0x01,0x00]

v_mul_hi_i32_i24_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x07,0xd1,0x01,0xe1,0x01,0x00]

v_mul_hi_i32_i24_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x07,0xd1,0x01,0xef,0x01,0x00]

v_mul_hi_i32_i24_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x07,0xd1,0x01,0xf7,0x01,0x00]

v_mul_hi_i32_i24_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x07,0xd1,0x01,0xf9,0x01,0x00]

v_mul_hi_i32_i24_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x07,0xd1,0x01,0xfb,0x01,0x00]

v_mul_u32_u24_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x08,0xd1,0x01,0x05,0x02,0x00]

v_mul_u32_u24_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x08,0xd1,0x01,0x05,0x02,0x00]

v_mul_u32_u24_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x08,0xd1,0xff,0x05,0x02,0x00]

v_mul_u32_u24_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x08,0xd1,0x01,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, s101, v2
// CHECK: [0x05,0x00,0x08,0xd1,0x65,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x08,0xd1,0x66,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x08,0xd1,0x67,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x08,0xd1,0x6a,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x08,0xd1,0x6b,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, ttmp15, v2
// CHECK: [0x05,0x00,0x08,0xd1,0x7b,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x08,0xd1,0x7c,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x08,0xd1,0x7e,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x08,0xd1,0x7f,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x08,0xd1,0x80,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x08,0xd1,0xc1,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x08,0xd1,0xf0,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x08,0xd1,0xf7,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x08,0xd1,0xfb,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x08,0xd1,0xfc,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x08,0xd1,0xfd,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x08,0xd1,0xfe,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x08,0xd1,0x01,0xff,0x03,0x00]

v_mul_u32_u24_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x08,0xd1,0x01,0x05,0x00,0x00]

v_mul_u32_u24_e64 v5, v1, s101
// CHECK: [0x05,0x00,0x08,0xd1,0x01,0xcb,0x00,0x00]

v_mul_u32_u24_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x08,0xd1,0x01,0xcd,0x00,0x00]

v_mul_u32_u24_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x08,0xd1,0x01,0xcf,0x00,0x00]

v_mul_u32_u24_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x08,0xd1,0x01,0xd5,0x00,0x00]

v_mul_u32_u24_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x08,0xd1,0x01,0xd7,0x00,0x00]

v_mul_u32_u24_e64 v5, v1, ttmp15
// CHECK: [0x05,0x00,0x08,0xd1,0x01,0xf7,0x00,0x00]

v_mul_u32_u24_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x08,0xd1,0x01,0xf9,0x00,0x00]

v_mul_u32_u24_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x08,0xd1,0x01,0xfd,0x00,0x00]

v_mul_u32_u24_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x08,0xd1,0x01,0xff,0x00,0x00]

v_mul_u32_u24_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x08,0xd1,0x01,0x01,0x01,0x00]

v_mul_u32_u24_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x08,0xd1,0x01,0x83,0x01,0x00]

v_mul_u32_u24_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x08,0xd1,0x01,0xe1,0x01,0x00]

v_mul_u32_u24_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x08,0xd1,0x01,0xef,0x01,0x00]

v_mul_u32_u24_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x08,0xd1,0x01,0xf7,0x01,0x00]

v_mul_u32_u24_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x08,0xd1,0x01,0xf9,0x01,0x00]

v_mul_u32_u24_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x08,0xd1,0x01,0xfb,0x01,0x00]

v_mul_u32_u24_e64 v5, v1, v2 clamp
// CHECK: [0x05,0x80,0x08,0xd1,0x01,0x05,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x09,0xd1,0x01,0x05,0x02,0x00]

v_mul_hi_u32_u24_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x09,0xd1,0x01,0x05,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x09,0xd1,0xff,0x05,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x09,0xd1,0x01,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, s101, v2
// CHECK: [0x05,0x00,0x09,0xd1,0x65,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x09,0xd1,0x66,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x09,0xd1,0x67,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x09,0xd1,0x6a,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x09,0xd1,0x6b,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, ttmp15, v2
// CHECK: [0x05,0x00,0x09,0xd1,0x7b,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x09,0xd1,0x7c,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x09,0xd1,0x7e,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x09,0xd1,0x7f,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x09,0xd1,0x80,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x09,0xd1,0xc1,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x09,0xd1,0xf0,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x09,0xd1,0xf7,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x09,0xd1,0xfb,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x09,0xd1,0xfc,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x09,0xd1,0xfd,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x09,0xd1,0xfe,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x09,0xd1,0x01,0xff,0x03,0x00]

v_mul_hi_u32_u24_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x09,0xd1,0x01,0x05,0x00,0x00]

v_mul_hi_u32_u24_e64 v5, v1, s101
// CHECK: [0x05,0x00,0x09,0xd1,0x01,0xcb,0x00,0x00]

v_mul_hi_u32_u24_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x09,0xd1,0x01,0xcd,0x00,0x00]

v_mul_hi_u32_u24_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x09,0xd1,0x01,0xcf,0x00,0x00]

v_mul_hi_u32_u24_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x09,0xd1,0x01,0xd5,0x00,0x00]

v_mul_hi_u32_u24_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x09,0xd1,0x01,0xd7,0x00,0x00]

v_mul_hi_u32_u24_e64 v5, v1, ttmp15
// CHECK: [0x05,0x00,0x09,0xd1,0x01,0xf7,0x00,0x00]

v_mul_hi_u32_u24_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x09,0xd1,0x01,0xf9,0x00,0x00]

v_mul_hi_u32_u24_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x09,0xd1,0x01,0xfd,0x00,0x00]

v_mul_hi_u32_u24_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x09,0xd1,0x01,0xff,0x00,0x00]

v_mul_hi_u32_u24_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x09,0xd1,0x01,0x01,0x01,0x00]

v_mul_hi_u32_u24_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x09,0xd1,0x01,0x83,0x01,0x00]

v_mul_hi_u32_u24_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x09,0xd1,0x01,0xe1,0x01,0x00]

v_mul_hi_u32_u24_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x09,0xd1,0x01,0xef,0x01,0x00]

v_mul_hi_u32_u24_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x09,0xd1,0x01,0xf7,0x01,0x00]

v_mul_hi_u32_u24_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x09,0xd1,0x01,0xf9,0x01,0x00]

v_mul_hi_u32_u24_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x09,0xd1,0x01,0xfb,0x01,0x00]

v_min_f32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x0a,0xd1,0x01,0x05,0x02,0x00]

v_min_f32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x0a,0xd1,0x01,0x05,0x02,0x00]

v_min_f32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x0a,0xd1,0xff,0x05,0x02,0x00]

v_min_f32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x0a,0xd1,0x01,0x04,0x02,0x00]

v_min_f32_e64 v5, s101, v2
// CHECK: [0x05,0x00,0x0a,0xd1,0x65,0x04,0x02,0x00]

v_min_f32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x0a,0xd1,0x66,0x04,0x02,0x00]

v_min_f32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x0a,0xd1,0x67,0x04,0x02,0x00]

v_min_f32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x0a,0xd1,0x6a,0x04,0x02,0x00]

v_min_f32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x0a,0xd1,0x6b,0x04,0x02,0x00]

v_min_f32_e64 v5, ttmp15, v2
// CHECK: [0x05,0x00,0x0a,0xd1,0x7b,0x04,0x02,0x00]

v_min_f32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x0a,0xd1,0x7c,0x04,0x02,0x00]

v_min_f32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x0a,0xd1,0x7e,0x04,0x02,0x00]

v_min_f32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x0a,0xd1,0x7f,0x04,0x02,0x00]

v_min_f32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x0a,0xd1,0x80,0x04,0x02,0x00]

v_min_f32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x0a,0xd1,0xc1,0x04,0x02,0x00]

v_min_f32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x0a,0xd1,0xf0,0x04,0x02,0x00]

v_min_f32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x0a,0xd1,0xf7,0x04,0x02,0x00]

v_min_f32_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x0a,0xd1,0xfb,0x04,0x02,0x00]

v_min_f32_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x0a,0xd1,0xfc,0x04,0x02,0x00]

v_min_f32_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x0a,0xd1,0xfd,0x04,0x02,0x00]

v_min_f32_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x0a,0xd1,0xfe,0x04,0x02,0x00]

v_min_f32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x0a,0xd1,0x01,0xff,0x03,0x00]

v_min_f32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x0a,0xd1,0x01,0x05,0x00,0x00]

v_min_f32_e64 v5, v1, s101
// CHECK: [0x05,0x00,0x0a,0xd1,0x01,0xcb,0x00,0x00]

v_min_f32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x0a,0xd1,0x01,0xcd,0x00,0x00]

v_min_f32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x0a,0xd1,0x01,0xcf,0x00,0x00]

v_min_f32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x0a,0xd1,0x01,0xd5,0x00,0x00]

v_min_f32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x0a,0xd1,0x01,0xd7,0x00,0x00]

v_min_f32_e64 v5, v1, ttmp15
// CHECK: [0x05,0x00,0x0a,0xd1,0x01,0xf7,0x00,0x00]

v_min_f32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x0a,0xd1,0x01,0xf9,0x00,0x00]

v_min_f32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x0a,0xd1,0x01,0xfd,0x00,0x00]

v_min_f32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x0a,0xd1,0x01,0xff,0x00,0x00]

v_min_f32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x0a,0xd1,0x01,0x01,0x01,0x00]

v_min_f32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x0a,0xd1,0x01,0x83,0x01,0x00]

v_min_f32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x0a,0xd1,0x01,0xe1,0x01,0x00]

v_min_f32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x0a,0xd1,0x01,0xef,0x01,0x00]

v_min_f32_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x0a,0xd1,0x01,0xf7,0x01,0x00]

v_min_f32_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x0a,0xd1,0x01,0xf9,0x01,0x00]

v_min_f32_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x0a,0xd1,0x01,0xfb,0x01,0x00]

v_min_f32_e64 v5, -v1, v2
// CHECK: [0x05,0x00,0x0a,0xd1,0x01,0x05,0x02,0x20]

v_min_f32_e64 v5, v1, -v2
// CHECK: [0x05,0x00,0x0a,0xd1,0x01,0x05,0x02,0x40]

v_min_f32_e64 v5, -v1, -v2
// CHECK: [0x05,0x00,0x0a,0xd1,0x01,0x05,0x02,0x60]

v_min_f32_e64 v5, |v1|, v2
// CHECK: [0x05,0x01,0x0a,0xd1,0x01,0x05,0x02,0x00]

v_min_f32_e64 v5, v1, |v2|
// CHECK: [0x05,0x02,0x0a,0xd1,0x01,0x05,0x02,0x00]

v_min_f32_e64 v5, |v1|, |v2|
// CHECK: [0x05,0x03,0x0a,0xd1,0x01,0x05,0x02,0x00]

v_min_f32_e64 v5, v1, v2 clamp
// CHECK: [0x05,0x80,0x0a,0xd1,0x01,0x05,0x02,0x00]

v_min_f32_e64 v5, v1, v2 mul:2
// CHECK: [0x05,0x00,0x0a,0xd1,0x01,0x05,0x02,0x08]

v_min_f32_e64 v5, v1, v2 mul:4
// CHECK: [0x05,0x00,0x0a,0xd1,0x01,0x05,0x02,0x10]

v_min_f32_e64 v5, v1, v2 div:2
// CHECK: [0x05,0x00,0x0a,0xd1,0x01,0x05,0x02,0x18]

v_max_f32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x0b,0xd1,0x01,0x05,0x02,0x00]

v_max_f32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x0b,0xd1,0x01,0x05,0x02,0x00]

v_max_f32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x0b,0xd1,0xff,0x05,0x02,0x00]

v_max_f32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x0b,0xd1,0x01,0x04,0x02,0x00]

v_max_f32_e64 v5, s101, v2
// CHECK: [0x05,0x00,0x0b,0xd1,0x65,0x04,0x02,0x00]

v_max_f32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x0b,0xd1,0x66,0x04,0x02,0x00]

v_max_f32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x0b,0xd1,0x67,0x04,0x02,0x00]

v_max_f32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x0b,0xd1,0x6a,0x04,0x02,0x00]

v_max_f32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x0b,0xd1,0x6b,0x04,0x02,0x00]

v_max_f32_e64 v5, ttmp15, v2
// CHECK: [0x05,0x00,0x0b,0xd1,0x7b,0x04,0x02,0x00]

v_max_f32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x0b,0xd1,0x7c,0x04,0x02,0x00]

v_max_f32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x0b,0xd1,0x7e,0x04,0x02,0x00]

v_max_f32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x0b,0xd1,0x7f,0x04,0x02,0x00]

v_max_f32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x0b,0xd1,0x80,0x04,0x02,0x00]

v_max_f32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x0b,0xd1,0xc1,0x04,0x02,0x00]

v_max_f32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x0b,0xd1,0xf0,0x04,0x02,0x00]

v_max_f32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x0b,0xd1,0xf7,0x04,0x02,0x00]

v_max_f32_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x0b,0xd1,0xfb,0x04,0x02,0x00]

v_max_f32_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x0b,0xd1,0xfc,0x04,0x02,0x00]

v_max_f32_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x0b,0xd1,0xfd,0x04,0x02,0x00]

v_max_f32_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x0b,0xd1,0xfe,0x04,0x02,0x00]

v_max_f32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x0b,0xd1,0x01,0xff,0x03,0x00]

v_max_f32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x0b,0xd1,0x01,0x05,0x00,0x00]

v_max_f32_e64 v5, v1, s101
// CHECK: [0x05,0x00,0x0b,0xd1,0x01,0xcb,0x00,0x00]

v_max_f32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x0b,0xd1,0x01,0xcd,0x00,0x00]

v_max_f32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x0b,0xd1,0x01,0xcf,0x00,0x00]

v_max_f32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x0b,0xd1,0x01,0xd5,0x00,0x00]

v_max_f32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x0b,0xd1,0x01,0xd7,0x00,0x00]

v_max_f32_e64 v5, v1, ttmp15
// CHECK: [0x05,0x00,0x0b,0xd1,0x01,0xf7,0x00,0x00]

v_max_f32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x0b,0xd1,0x01,0xf9,0x00,0x00]

v_max_f32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x0b,0xd1,0x01,0xfd,0x00,0x00]

v_max_f32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x0b,0xd1,0x01,0xff,0x00,0x00]

v_max_f32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x0b,0xd1,0x01,0x01,0x01,0x00]

v_max_f32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x0b,0xd1,0x01,0x83,0x01,0x00]

v_max_f32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x0b,0xd1,0x01,0xe1,0x01,0x00]

v_max_f32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x0b,0xd1,0x01,0xef,0x01,0x00]

v_max_f32_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x0b,0xd1,0x01,0xf7,0x01,0x00]

v_max_f32_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x0b,0xd1,0x01,0xf9,0x01,0x00]

v_max_f32_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x0b,0xd1,0x01,0xfb,0x01,0x00]

v_max_f32_e64 v5, -v1, v2
// CHECK: [0x05,0x00,0x0b,0xd1,0x01,0x05,0x02,0x20]

v_max_f32_e64 v5, v1, -v2
// CHECK: [0x05,0x00,0x0b,0xd1,0x01,0x05,0x02,0x40]

v_max_f32_e64 v5, -v1, -v2
// CHECK: [0x05,0x00,0x0b,0xd1,0x01,0x05,0x02,0x60]

v_max_f32_e64 v5, |v1|, v2
// CHECK: [0x05,0x01,0x0b,0xd1,0x01,0x05,0x02,0x00]

v_max_f32_e64 v5, v1, |v2|
// CHECK: [0x05,0x02,0x0b,0xd1,0x01,0x05,0x02,0x00]

v_max_f32_e64 v5, |v1|, |v2|
// CHECK: [0x05,0x03,0x0b,0xd1,0x01,0x05,0x02,0x00]

v_max_f32_e64 v5, v1, v2 clamp
// CHECK: [0x05,0x80,0x0b,0xd1,0x01,0x05,0x02,0x00]

v_max_f32_e64 v5, v1, v2 mul:2
// CHECK: [0x05,0x00,0x0b,0xd1,0x01,0x05,0x02,0x08]

v_max_f32_e64 v5, v1, v2 mul:4
// CHECK: [0x05,0x00,0x0b,0xd1,0x01,0x05,0x02,0x10]

v_max_f32_e64 v5, v1, v2 div:2
// CHECK: [0x05,0x00,0x0b,0xd1,0x01,0x05,0x02,0x18]

v_min_i32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x0c,0xd1,0x01,0x05,0x02,0x00]

v_min_i32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x0c,0xd1,0x01,0x05,0x02,0x00]

v_min_i32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x0c,0xd1,0xff,0x05,0x02,0x00]

v_min_i32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x0c,0xd1,0x01,0x04,0x02,0x00]

v_min_i32_e64 v5, s101, v2
// CHECK: [0x05,0x00,0x0c,0xd1,0x65,0x04,0x02,0x00]

v_min_i32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x0c,0xd1,0x66,0x04,0x02,0x00]

v_min_i32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x0c,0xd1,0x67,0x04,0x02,0x00]

v_min_i32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x0c,0xd1,0x6a,0x04,0x02,0x00]

v_min_i32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x0c,0xd1,0x6b,0x04,0x02,0x00]

v_min_i32_e64 v5, ttmp15, v2
// CHECK: [0x05,0x00,0x0c,0xd1,0x7b,0x04,0x02,0x00]

v_min_i32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x0c,0xd1,0x7c,0x04,0x02,0x00]

v_min_i32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x0c,0xd1,0x7e,0x04,0x02,0x00]

v_min_i32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x0c,0xd1,0x7f,0x04,0x02,0x00]

v_min_i32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x0c,0xd1,0x80,0x04,0x02,0x00]

v_min_i32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x0c,0xd1,0xc1,0x04,0x02,0x00]

v_min_i32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x0c,0xd1,0xf0,0x04,0x02,0x00]

v_min_i32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x0c,0xd1,0xf7,0x04,0x02,0x00]

v_min_i32_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x0c,0xd1,0xfb,0x04,0x02,0x00]

v_min_i32_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x0c,0xd1,0xfc,0x04,0x02,0x00]

v_min_i32_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x0c,0xd1,0xfd,0x04,0x02,0x00]

v_min_i32_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x0c,0xd1,0xfe,0x04,0x02,0x00]

v_min_i32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x0c,0xd1,0x01,0xff,0x03,0x00]

v_min_i32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x0c,0xd1,0x01,0x05,0x00,0x00]

v_min_i32_e64 v5, v1, s101
// CHECK: [0x05,0x00,0x0c,0xd1,0x01,0xcb,0x00,0x00]

v_min_i32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x0c,0xd1,0x01,0xcd,0x00,0x00]

v_min_i32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x0c,0xd1,0x01,0xcf,0x00,0x00]

v_min_i32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x0c,0xd1,0x01,0xd5,0x00,0x00]

v_min_i32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x0c,0xd1,0x01,0xd7,0x00,0x00]

v_min_i32_e64 v5, v1, ttmp15
// CHECK: [0x05,0x00,0x0c,0xd1,0x01,0xf7,0x00,0x00]

v_min_i32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x0c,0xd1,0x01,0xf9,0x00,0x00]

v_min_i32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x0c,0xd1,0x01,0xfd,0x00,0x00]

v_min_i32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x0c,0xd1,0x01,0xff,0x00,0x00]

v_min_i32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x0c,0xd1,0x01,0x01,0x01,0x00]

v_min_i32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x0c,0xd1,0x01,0x83,0x01,0x00]

v_min_i32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x0c,0xd1,0x01,0xe1,0x01,0x00]

v_min_i32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x0c,0xd1,0x01,0xef,0x01,0x00]

v_min_i32_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x0c,0xd1,0x01,0xf7,0x01,0x00]

v_min_i32_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x0c,0xd1,0x01,0xf9,0x01,0x00]

v_min_i32_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x0c,0xd1,0x01,0xfb,0x01,0x00]

v_max_i32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x0d,0xd1,0x01,0x05,0x02,0x00]

v_max_i32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x0d,0xd1,0x01,0x05,0x02,0x00]

v_max_i32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x0d,0xd1,0xff,0x05,0x02,0x00]

v_max_i32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x0d,0xd1,0x01,0x04,0x02,0x00]

v_max_i32_e64 v5, s101, v2
// CHECK: [0x05,0x00,0x0d,0xd1,0x65,0x04,0x02,0x00]

v_max_i32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x0d,0xd1,0x66,0x04,0x02,0x00]

v_max_i32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x0d,0xd1,0x67,0x04,0x02,0x00]

v_max_i32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x0d,0xd1,0x6a,0x04,0x02,0x00]

v_max_i32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x0d,0xd1,0x6b,0x04,0x02,0x00]

v_max_i32_e64 v5, ttmp15, v2
// CHECK: [0x05,0x00,0x0d,0xd1,0x7b,0x04,0x02,0x00]

v_max_i32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x0d,0xd1,0x7c,0x04,0x02,0x00]

v_max_i32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x0d,0xd1,0x7e,0x04,0x02,0x00]

v_max_i32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x0d,0xd1,0x7f,0x04,0x02,0x00]

v_max_i32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x0d,0xd1,0x80,0x04,0x02,0x00]

v_max_i32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x0d,0xd1,0xc1,0x04,0x02,0x00]

v_max_i32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x0d,0xd1,0xf0,0x04,0x02,0x00]

v_max_i32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x0d,0xd1,0xf7,0x04,0x02,0x00]

v_max_i32_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x0d,0xd1,0xfb,0x04,0x02,0x00]

v_max_i32_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x0d,0xd1,0xfc,0x04,0x02,0x00]

v_max_i32_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x0d,0xd1,0xfd,0x04,0x02,0x00]

v_max_i32_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x0d,0xd1,0xfe,0x04,0x02,0x00]

v_max_i32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x0d,0xd1,0x01,0xff,0x03,0x00]

v_max_i32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x0d,0xd1,0x01,0x05,0x00,0x00]

v_max_i32_e64 v5, v1, s101
// CHECK: [0x05,0x00,0x0d,0xd1,0x01,0xcb,0x00,0x00]

v_max_i32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x0d,0xd1,0x01,0xcd,0x00,0x00]

v_max_i32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x0d,0xd1,0x01,0xcf,0x00,0x00]

v_max_i32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x0d,0xd1,0x01,0xd5,0x00,0x00]

v_max_i32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x0d,0xd1,0x01,0xd7,0x00,0x00]

v_max_i32_e64 v5, v1, ttmp15
// CHECK: [0x05,0x00,0x0d,0xd1,0x01,0xf7,0x00,0x00]

v_max_i32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x0d,0xd1,0x01,0xf9,0x00,0x00]

v_max_i32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x0d,0xd1,0x01,0xfd,0x00,0x00]

v_max_i32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x0d,0xd1,0x01,0xff,0x00,0x00]

v_max_i32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x0d,0xd1,0x01,0x01,0x01,0x00]

v_max_i32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x0d,0xd1,0x01,0x83,0x01,0x00]

v_max_i32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x0d,0xd1,0x01,0xe1,0x01,0x00]

v_max_i32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x0d,0xd1,0x01,0xef,0x01,0x00]

v_max_i32_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x0d,0xd1,0x01,0xf7,0x01,0x00]

v_max_i32_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x0d,0xd1,0x01,0xf9,0x01,0x00]

v_max_i32_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x0d,0xd1,0x01,0xfb,0x01,0x00]

v_min_u32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x0e,0xd1,0x01,0x05,0x02,0x00]

v_min_u32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x0e,0xd1,0x01,0x05,0x02,0x00]

v_min_u32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x0e,0xd1,0xff,0x05,0x02,0x00]

v_min_u32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x0e,0xd1,0x01,0x04,0x02,0x00]

v_min_u32_e64 v5, s101, v2
// CHECK: [0x05,0x00,0x0e,0xd1,0x65,0x04,0x02,0x00]

v_min_u32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x0e,0xd1,0x66,0x04,0x02,0x00]

v_min_u32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x0e,0xd1,0x67,0x04,0x02,0x00]

v_min_u32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x0e,0xd1,0x6a,0x04,0x02,0x00]

v_min_u32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x0e,0xd1,0x6b,0x04,0x02,0x00]

v_min_u32_e64 v5, ttmp15, v2
// CHECK: [0x05,0x00,0x0e,0xd1,0x7b,0x04,0x02,0x00]

v_min_u32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x0e,0xd1,0x7c,0x04,0x02,0x00]

v_min_u32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x0e,0xd1,0x7e,0x04,0x02,0x00]

v_min_u32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x0e,0xd1,0x7f,0x04,0x02,0x00]

v_min_u32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x0e,0xd1,0x80,0x04,0x02,0x00]

v_min_u32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x0e,0xd1,0xc1,0x04,0x02,0x00]

v_min_u32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x0e,0xd1,0xf0,0x04,0x02,0x00]

v_min_u32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x0e,0xd1,0xf7,0x04,0x02,0x00]

v_min_u32_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x0e,0xd1,0xfb,0x04,0x02,0x00]

v_min_u32_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x0e,0xd1,0xfc,0x04,0x02,0x00]

v_min_u32_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x0e,0xd1,0xfd,0x04,0x02,0x00]

v_min_u32_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x0e,0xd1,0xfe,0x04,0x02,0x00]

v_min_u32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x0e,0xd1,0x01,0xff,0x03,0x00]

v_min_u32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x0e,0xd1,0x01,0x05,0x00,0x00]

v_min_u32_e64 v5, v1, s101
// CHECK: [0x05,0x00,0x0e,0xd1,0x01,0xcb,0x00,0x00]

v_min_u32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x0e,0xd1,0x01,0xcd,0x00,0x00]

v_min_u32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x0e,0xd1,0x01,0xcf,0x00,0x00]

v_min_u32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x0e,0xd1,0x01,0xd5,0x00,0x00]

v_min_u32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x0e,0xd1,0x01,0xd7,0x00,0x00]

v_min_u32_e64 v5, v1, ttmp15
// CHECK: [0x05,0x00,0x0e,0xd1,0x01,0xf7,0x00,0x00]

v_min_u32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x0e,0xd1,0x01,0xf9,0x00,0x00]

v_min_u32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x0e,0xd1,0x01,0xfd,0x00,0x00]

v_min_u32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x0e,0xd1,0x01,0xff,0x00,0x00]

v_min_u32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x0e,0xd1,0x01,0x01,0x01,0x00]

v_min_u32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x0e,0xd1,0x01,0x83,0x01,0x00]

v_min_u32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x0e,0xd1,0x01,0xe1,0x01,0x00]

v_min_u32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x0e,0xd1,0x01,0xef,0x01,0x00]

v_min_u32_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x0e,0xd1,0x01,0xf7,0x01,0x00]

v_min_u32_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x0e,0xd1,0x01,0xf9,0x01,0x00]

v_min_u32_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x0e,0xd1,0x01,0xfb,0x01,0x00]

v_max_u32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x0f,0xd1,0x01,0x05,0x02,0x00]

v_max_u32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x0f,0xd1,0x01,0x05,0x02,0x00]

v_max_u32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x0f,0xd1,0xff,0x05,0x02,0x00]

v_max_u32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x0f,0xd1,0x01,0x04,0x02,0x00]

v_max_u32_e64 v5, s101, v2
// CHECK: [0x05,0x00,0x0f,0xd1,0x65,0x04,0x02,0x00]

v_max_u32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x0f,0xd1,0x66,0x04,0x02,0x00]

v_max_u32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x0f,0xd1,0x67,0x04,0x02,0x00]

v_max_u32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x0f,0xd1,0x6a,0x04,0x02,0x00]

v_max_u32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x0f,0xd1,0x6b,0x04,0x02,0x00]

v_max_u32_e64 v5, ttmp15, v2
// CHECK: [0x05,0x00,0x0f,0xd1,0x7b,0x04,0x02,0x00]

v_max_u32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x0f,0xd1,0x7c,0x04,0x02,0x00]

v_max_u32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x0f,0xd1,0x7e,0x04,0x02,0x00]

v_max_u32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x0f,0xd1,0x7f,0x04,0x02,0x00]

v_max_u32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x0f,0xd1,0x80,0x04,0x02,0x00]

v_max_u32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x0f,0xd1,0xc1,0x04,0x02,0x00]

v_max_u32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x0f,0xd1,0xf0,0x04,0x02,0x00]

v_max_u32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x0f,0xd1,0xf7,0x04,0x02,0x00]

v_max_u32_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x0f,0xd1,0xfb,0x04,0x02,0x00]

v_max_u32_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x0f,0xd1,0xfc,0x04,0x02,0x00]

v_max_u32_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x0f,0xd1,0xfd,0x04,0x02,0x00]

v_max_u32_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x0f,0xd1,0xfe,0x04,0x02,0x00]

v_max_u32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x0f,0xd1,0x01,0xff,0x03,0x00]

v_max_u32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x0f,0xd1,0x01,0x05,0x00,0x00]

v_max_u32_e64 v5, v1, s101
// CHECK: [0x05,0x00,0x0f,0xd1,0x01,0xcb,0x00,0x00]

v_max_u32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x0f,0xd1,0x01,0xcd,0x00,0x00]

v_max_u32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x0f,0xd1,0x01,0xcf,0x00,0x00]

v_max_u32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x0f,0xd1,0x01,0xd5,0x00,0x00]

v_max_u32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x0f,0xd1,0x01,0xd7,0x00,0x00]

v_max_u32_e64 v5, v1, ttmp15
// CHECK: [0x05,0x00,0x0f,0xd1,0x01,0xf7,0x00,0x00]

v_max_u32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x0f,0xd1,0x01,0xf9,0x00,0x00]

v_max_u32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x0f,0xd1,0x01,0xfd,0x00,0x00]

v_max_u32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x0f,0xd1,0x01,0xff,0x00,0x00]

v_max_u32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x0f,0xd1,0x01,0x01,0x01,0x00]

v_max_u32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x0f,0xd1,0x01,0x83,0x01,0x00]

v_max_u32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x0f,0xd1,0x01,0xe1,0x01,0x00]

v_max_u32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x0f,0xd1,0x01,0xef,0x01,0x00]

v_max_u32_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x0f,0xd1,0x01,0xf7,0x01,0x00]

v_max_u32_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x0f,0xd1,0x01,0xf9,0x01,0x00]

v_max_u32_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x0f,0xd1,0x01,0xfb,0x01,0x00]

v_lshrrev_b32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x10,0xd1,0x01,0x05,0x02,0x00]

v_lshrrev_b32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x10,0xd1,0x01,0x05,0x02,0x00]

v_lshrrev_b32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x10,0xd1,0xff,0x05,0x02,0x00]

v_lshrrev_b32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x10,0xd1,0x01,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, s101, v2
// CHECK: [0x05,0x00,0x10,0xd1,0x65,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x10,0xd1,0x66,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x10,0xd1,0x67,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x10,0xd1,0x6a,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x10,0xd1,0x6b,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, ttmp15, v2
// CHECK: [0x05,0x00,0x10,0xd1,0x7b,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x10,0xd1,0x7c,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x10,0xd1,0x7e,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x10,0xd1,0x7f,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x10,0xd1,0x80,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x10,0xd1,0xc1,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x10,0xd1,0xf0,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x10,0xd1,0xf7,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x10,0xd1,0xfb,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x10,0xd1,0xfc,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x10,0xd1,0xfd,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x10,0xd1,0x01,0xff,0x03,0x00]

v_lshrrev_b32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x10,0xd1,0x01,0x05,0x00,0x00]

v_lshrrev_b32_e64 v5, v1, s101
// CHECK: [0x05,0x00,0x10,0xd1,0x01,0xcb,0x00,0x00]

v_lshrrev_b32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x10,0xd1,0x01,0xcd,0x00,0x00]

v_lshrrev_b32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x10,0xd1,0x01,0xcf,0x00,0x00]

v_lshrrev_b32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x10,0xd1,0x01,0xd5,0x00,0x00]

v_lshrrev_b32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x10,0xd1,0x01,0xd7,0x00,0x00]

v_lshrrev_b32_e64 v5, v1, ttmp15
// CHECK: [0x05,0x00,0x10,0xd1,0x01,0xf7,0x00,0x00]

v_lshrrev_b32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x10,0xd1,0x01,0xf9,0x00,0x00]

v_lshrrev_b32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x10,0xd1,0x01,0xfd,0x00,0x00]

v_lshrrev_b32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x10,0xd1,0x01,0xff,0x00,0x00]

v_lshrrev_b32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x10,0xd1,0x01,0x01,0x01,0x00]

v_lshrrev_b32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x10,0xd1,0x01,0x83,0x01,0x00]

v_lshrrev_b32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x10,0xd1,0x01,0xe1,0x01,0x00]

v_lshrrev_b32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x10,0xd1,0x01,0xef,0x01,0x00]

v_lshrrev_b32_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x10,0xd1,0x01,0xf7,0x01,0x00]

v_lshrrev_b32_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x10,0xd1,0x01,0xf9,0x01,0x00]

v_lshrrev_b32_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x10,0xd1,0x01,0xfb,0x01,0x00]

v_ashrrev_i32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x11,0xd1,0x01,0x05,0x02,0x00]

v_ashrrev_i32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x11,0xd1,0x01,0x05,0x02,0x00]

v_ashrrev_i32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x11,0xd1,0xff,0x05,0x02,0x00]

v_ashrrev_i32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x11,0xd1,0x01,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, s101, v2
// CHECK: [0x05,0x00,0x11,0xd1,0x65,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x11,0xd1,0x66,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x11,0xd1,0x67,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x11,0xd1,0x6a,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x11,0xd1,0x6b,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, ttmp15, v2
// CHECK: [0x05,0x00,0x11,0xd1,0x7b,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x11,0xd1,0x7c,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x11,0xd1,0x7e,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x11,0xd1,0x7f,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x11,0xd1,0x80,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x11,0xd1,0xc1,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x11,0xd1,0xf0,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x11,0xd1,0xf7,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x11,0xd1,0xfb,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x11,0xd1,0xfc,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x11,0xd1,0xfd,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x11,0xd1,0x01,0xff,0x03,0x00]

v_ashrrev_i32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x11,0xd1,0x01,0x05,0x00,0x00]

v_ashrrev_i32_e64 v5, v1, s101
// CHECK: [0x05,0x00,0x11,0xd1,0x01,0xcb,0x00,0x00]

v_ashrrev_i32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x11,0xd1,0x01,0xcd,0x00,0x00]

v_ashrrev_i32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x11,0xd1,0x01,0xcf,0x00,0x00]

v_ashrrev_i32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x11,0xd1,0x01,0xd5,0x00,0x00]

v_ashrrev_i32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x11,0xd1,0x01,0xd7,0x00,0x00]

v_ashrrev_i32_e64 v5, v1, ttmp15
// CHECK: [0x05,0x00,0x11,0xd1,0x01,0xf7,0x00,0x00]

v_ashrrev_i32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x11,0xd1,0x01,0xf9,0x00,0x00]

v_ashrrev_i32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x11,0xd1,0x01,0xfd,0x00,0x00]

v_ashrrev_i32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x11,0xd1,0x01,0xff,0x00,0x00]

v_ashrrev_i32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x11,0xd1,0x01,0x01,0x01,0x00]

v_ashrrev_i32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x11,0xd1,0x01,0x83,0x01,0x00]

v_ashrrev_i32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x11,0xd1,0x01,0xe1,0x01,0x00]

v_ashrrev_i32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x11,0xd1,0x01,0xef,0x01,0x00]

v_ashrrev_i32_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x11,0xd1,0x01,0xf7,0x01,0x00]

v_ashrrev_i32_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x11,0xd1,0x01,0xf9,0x01,0x00]

v_ashrrev_i32_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x11,0xd1,0x01,0xfb,0x01,0x00]

v_lshlrev_b32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x12,0xd1,0x01,0x05,0x02,0x00]

v_lshlrev_b32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x12,0xd1,0x01,0x05,0x02,0x00]

v_lshlrev_b32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x12,0xd1,0xff,0x05,0x02,0x00]

v_lshlrev_b32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x12,0xd1,0x01,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, s101, v2
// CHECK: [0x05,0x00,0x12,0xd1,0x65,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x12,0xd1,0x66,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x12,0xd1,0x67,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x12,0xd1,0x6a,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x12,0xd1,0x6b,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, ttmp15, v2
// CHECK: [0x05,0x00,0x12,0xd1,0x7b,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x12,0xd1,0x7c,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x12,0xd1,0x7e,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x12,0xd1,0x7f,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x12,0xd1,0x80,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x12,0xd1,0xc1,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x12,0xd1,0xf0,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x12,0xd1,0xf7,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x12,0xd1,0xfb,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x12,0xd1,0xfc,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x12,0xd1,0xfd,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x12,0xd1,0x01,0xff,0x03,0x00]

v_lshlrev_b32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x12,0xd1,0x01,0x05,0x00,0x00]

v_lshlrev_b32_e64 v5, v1, s101
// CHECK: [0x05,0x00,0x12,0xd1,0x01,0xcb,0x00,0x00]

v_lshlrev_b32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x12,0xd1,0x01,0xcd,0x00,0x00]

v_lshlrev_b32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x12,0xd1,0x01,0xcf,0x00,0x00]

v_lshlrev_b32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x12,0xd1,0x01,0xd5,0x00,0x00]

v_lshlrev_b32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x12,0xd1,0x01,0xd7,0x00,0x00]

v_lshlrev_b32_e64 v5, v1, ttmp15
// CHECK: [0x05,0x00,0x12,0xd1,0x01,0xf7,0x00,0x00]

v_lshlrev_b32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x12,0xd1,0x01,0xf9,0x00,0x00]

v_lshlrev_b32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x12,0xd1,0x01,0xfd,0x00,0x00]

v_lshlrev_b32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x12,0xd1,0x01,0xff,0x00,0x00]

v_lshlrev_b32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x12,0xd1,0x01,0x01,0x01,0x00]

v_lshlrev_b32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x12,0xd1,0x01,0x83,0x01,0x00]

v_lshlrev_b32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x12,0xd1,0x01,0xe1,0x01,0x00]

v_lshlrev_b32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x12,0xd1,0x01,0xef,0x01,0x00]

v_lshlrev_b32_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x12,0xd1,0x01,0xf7,0x01,0x00]

v_lshlrev_b32_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x12,0xd1,0x01,0xf9,0x01,0x00]

v_lshlrev_b32_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x12,0xd1,0x01,0xfb,0x01,0x00]

v_and_b32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x13,0xd1,0x01,0x05,0x02,0x00]

v_and_b32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x13,0xd1,0x01,0x05,0x02,0x00]

v_and_b32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x13,0xd1,0xff,0x05,0x02,0x00]

v_and_b32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x13,0xd1,0x01,0x04,0x02,0x00]

v_and_b32_e64 v5, s101, v2
// CHECK: [0x05,0x00,0x13,0xd1,0x65,0x04,0x02,0x00]

v_and_b32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x13,0xd1,0x66,0x04,0x02,0x00]

v_and_b32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x13,0xd1,0x67,0x04,0x02,0x00]

v_and_b32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x13,0xd1,0x6a,0x04,0x02,0x00]

v_and_b32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x13,0xd1,0x6b,0x04,0x02,0x00]

v_and_b32_e64 v5, ttmp15, v2
// CHECK: [0x05,0x00,0x13,0xd1,0x7b,0x04,0x02,0x00]

v_and_b32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x13,0xd1,0x7c,0x04,0x02,0x00]

v_and_b32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x13,0xd1,0x7e,0x04,0x02,0x00]

v_and_b32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x13,0xd1,0x7f,0x04,0x02,0x00]

v_and_b32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x13,0xd1,0x80,0x04,0x02,0x00]

v_and_b32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x13,0xd1,0xc1,0x04,0x02,0x00]

v_and_b32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x13,0xd1,0xf0,0x04,0x02,0x00]

v_and_b32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x13,0xd1,0xf7,0x04,0x02,0x00]

v_and_b32_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x13,0xd1,0xfb,0x04,0x02,0x00]

v_and_b32_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x13,0xd1,0xfc,0x04,0x02,0x00]

v_and_b32_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x13,0xd1,0xfd,0x04,0x02,0x00]

v_and_b32_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x13,0xd1,0xfe,0x04,0x02,0x00]

v_and_b32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x13,0xd1,0x01,0xff,0x03,0x00]

v_and_b32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x13,0xd1,0x01,0x05,0x00,0x00]

v_and_b32_e64 v5, v1, s101
// CHECK: [0x05,0x00,0x13,0xd1,0x01,0xcb,0x00,0x00]

v_and_b32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x13,0xd1,0x01,0xcd,0x00,0x00]

v_and_b32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x13,0xd1,0x01,0xcf,0x00,0x00]

v_and_b32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x13,0xd1,0x01,0xd5,0x00,0x00]

v_and_b32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x13,0xd1,0x01,0xd7,0x00,0x00]

v_and_b32_e64 v5, v1, ttmp15
// CHECK: [0x05,0x00,0x13,0xd1,0x01,0xf7,0x00,0x00]

v_and_b32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x13,0xd1,0x01,0xf9,0x00,0x00]

v_and_b32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x13,0xd1,0x01,0xfd,0x00,0x00]

v_and_b32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x13,0xd1,0x01,0xff,0x00,0x00]

v_and_b32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x13,0xd1,0x01,0x01,0x01,0x00]

v_and_b32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x13,0xd1,0x01,0x83,0x01,0x00]

v_and_b32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x13,0xd1,0x01,0xe1,0x01,0x00]

v_and_b32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x13,0xd1,0x01,0xef,0x01,0x00]

v_and_b32_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x13,0xd1,0x01,0xf7,0x01,0x00]

v_and_b32_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x13,0xd1,0x01,0xf9,0x01,0x00]

v_and_b32_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x13,0xd1,0x01,0xfb,0x01,0x00]

v_or_b32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x14,0xd1,0x01,0x05,0x02,0x00]

v_or_b32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x14,0xd1,0x01,0x05,0x02,0x00]

v_or_b32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x14,0xd1,0xff,0x05,0x02,0x00]

v_or_b32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x14,0xd1,0x01,0x04,0x02,0x00]

v_or_b32_e64 v5, s101, v2
// CHECK: [0x05,0x00,0x14,0xd1,0x65,0x04,0x02,0x00]

v_or_b32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x14,0xd1,0x66,0x04,0x02,0x00]

v_or_b32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x14,0xd1,0x67,0x04,0x02,0x00]

v_or_b32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x14,0xd1,0x6a,0x04,0x02,0x00]

v_or_b32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x14,0xd1,0x6b,0x04,0x02,0x00]

v_or_b32_e64 v5, ttmp15, v2
// CHECK: [0x05,0x00,0x14,0xd1,0x7b,0x04,0x02,0x00]

v_or_b32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x14,0xd1,0x7c,0x04,0x02,0x00]

v_or_b32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x14,0xd1,0x7e,0x04,0x02,0x00]

v_or_b32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x14,0xd1,0x7f,0x04,0x02,0x00]

v_or_b32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x14,0xd1,0x80,0x04,0x02,0x00]

v_or_b32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x14,0xd1,0xc1,0x04,0x02,0x00]

v_or_b32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x14,0xd1,0xf0,0x04,0x02,0x00]

v_or_b32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x14,0xd1,0xf7,0x04,0x02,0x00]

v_or_b32_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x14,0xd1,0xfb,0x04,0x02,0x00]

v_or_b32_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x14,0xd1,0xfc,0x04,0x02,0x00]

v_or_b32_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x14,0xd1,0xfd,0x04,0x02,0x00]

v_or_b32_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x14,0xd1,0xfe,0x04,0x02,0x00]

v_or_b32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x14,0xd1,0x01,0xff,0x03,0x00]

v_or_b32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x14,0xd1,0x01,0x05,0x00,0x00]

v_or_b32_e64 v5, v1, s101
// CHECK: [0x05,0x00,0x14,0xd1,0x01,0xcb,0x00,0x00]

v_or_b32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x14,0xd1,0x01,0xcd,0x00,0x00]

v_or_b32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x14,0xd1,0x01,0xcf,0x00,0x00]

v_or_b32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x14,0xd1,0x01,0xd5,0x00,0x00]

v_or_b32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x14,0xd1,0x01,0xd7,0x00,0x00]

v_or_b32_e64 v5, v1, ttmp15
// CHECK: [0x05,0x00,0x14,0xd1,0x01,0xf7,0x00,0x00]

v_or_b32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x14,0xd1,0x01,0xf9,0x00,0x00]

v_or_b32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x14,0xd1,0x01,0xfd,0x00,0x00]

v_or_b32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x14,0xd1,0x01,0xff,0x00,0x00]

v_or_b32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x14,0xd1,0x01,0x01,0x01,0x00]

v_or_b32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x14,0xd1,0x01,0x83,0x01,0x00]

v_or_b32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x14,0xd1,0x01,0xe1,0x01,0x00]

v_or_b32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x14,0xd1,0x01,0xef,0x01,0x00]

v_or_b32_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x14,0xd1,0x01,0xf7,0x01,0x00]

v_or_b32_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x14,0xd1,0x01,0xf9,0x01,0x00]

v_or_b32_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x14,0xd1,0x01,0xfb,0x01,0x00]

v_xor_b32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x15,0xd1,0x01,0x05,0x02,0x00]

v_xor_b32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x15,0xd1,0x01,0x05,0x02,0x00]

v_xor_b32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x15,0xd1,0xff,0x05,0x02,0x00]

v_xor_b32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x15,0xd1,0x01,0x04,0x02,0x00]

v_xor_b32_e64 v5, s101, v2
// CHECK: [0x05,0x00,0x15,0xd1,0x65,0x04,0x02,0x00]

v_xor_b32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x15,0xd1,0x66,0x04,0x02,0x00]

v_xor_b32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x15,0xd1,0x67,0x04,0x02,0x00]

v_xor_b32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x15,0xd1,0x6a,0x04,0x02,0x00]

v_xor_b32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x15,0xd1,0x6b,0x04,0x02,0x00]

v_xor_b32_e64 v5, ttmp15, v2
// CHECK: [0x05,0x00,0x15,0xd1,0x7b,0x04,0x02,0x00]

v_xor_b32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x15,0xd1,0x7c,0x04,0x02,0x00]

v_xor_b32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x15,0xd1,0x7e,0x04,0x02,0x00]

v_xor_b32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x15,0xd1,0x7f,0x04,0x02,0x00]

v_xor_b32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x15,0xd1,0x80,0x04,0x02,0x00]

v_xor_b32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x15,0xd1,0xc1,0x04,0x02,0x00]

v_xor_b32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x15,0xd1,0xf0,0x04,0x02,0x00]

v_xor_b32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x15,0xd1,0xf7,0x04,0x02,0x00]

v_xor_b32_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x15,0xd1,0xfb,0x04,0x02,0x00]

v_xor_b32_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x15,0xd1,0xfc,0x04,0x02,0x00]

v_xor_b32_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x15,0xd1,0xfd,0x04,0x02,0x00]

v_xor_b32_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x15,0xd1,0xfe,0x04,0x02,0x00]

v_xor_b32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x15,0xd1,0x01,0xff,0x03,0x00]

v_xor_b32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x15,0xd1,0x01,0x05,0x00,0x00]

v_xor_b32_e64 v5, v1, s101
// CHECK: [0x05,0x00,0x15,0xd1,0x01,0xcb,0x00,0x00]

v_xor_b32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x15,0xd1,0x01,0xcd,0x00,0x00]

v_xor_b32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x15,0xd1,0x01,0xcf,0x00,0x00]

v_xor_b32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x15,0xd1,0x01,0xd5,0x00,0x00]

v_xor_b32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x15,0xd1,0x01,0xd7,0x00,0x00]

v_xor_b32_e64 v5, v1, ttmp15
// CHECK: [0x05,0x00,0x15,0xd1,0x01,0xf7,0x00,0x00]

v_xor_b32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x15,0xd1,0x01,0xf9,0x00,0x00]

v_xor_b32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x15,0xd1,0x01,0xfd,0x00,0x00]

v_xor_b32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x15,0xd1,0x01,0xff,0x00,0x00]

v_xor_b32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x15,0xd1,0x01,0x01,0x01,0x00]

v_xor_b32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x15,0xd1,0x01,0x83,0x01,0x00]

v_xor_b32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x15,0xd1,0x01,0xe1,0x01,0x00]

v_xor_b32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x15,0xd1,0x01,0xef,0x01,0x00]

v_xor_b32_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x15,0xd1,0x01,0xf7,0x01,0x00]

v_xor_b32_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x15,0xd1,0x01,0xf9,0x01,0x00]

v_xor_b32_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x15,0xd1,0x01,0xfb,0x01,0x00]

v_mac_f32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x16,0xd1,0x01,0x05,0x02,0x00]

v_mac_f32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x16,0xd1,0x01,0x05,0x02,0x00]

v_mac_f32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x16,0xd1,0xff,0x05,0x02,0x00]

v_mac_f32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x16,0xd1,0x01,0x04,0x02,0x00]

v_mac_f32_e64 v5, s101, v2
// CHECK: [0x05,0x00,0x16,0xd1,0x65,0x04,0x02,0x00]

v_mac_f32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x16,0xd1,0x66,0x04,0x02,0x00]

v_mac_f32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x16,0xd1,0x67,0x04,0x02,0x00]

v_mac_f32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x16,0xd1,0x6a,0x04,0x02,0x00]

v_mac_f32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x16,0xd1,0x6b,0x04,0x02,0x00]

v_mac_f32_e64 v5, ttmp15, v2
// CHECK: [0x05,0x00,0x16,0xd1,0x7b,0x04,0x02,0x00]

v_mac_f32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x16,0xd1,0x7c,0x04,0x02,0x00]

v_mac_f32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x16,0xd1,0x7e,0x04,0x02,0x00]

v_mac_f32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x16,0xd1,0x7f,0x04,0x02,0x00]

v_mac_f32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x16,0xd1,0x80,0x04,0x02,0x00]

v_mac_f32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x16,0xd1,0xc1,0x04,0x02,0x00]

v_mac_f32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x16,0xd1,0xf0,0x04,0x02,0x00]

v_mac_f32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x16,0xd1,0xf7,0x04,0x02,0x00]

v_mac_f32_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x16,0xd1,0xfb,0x04,0x02,0x00]

v_mac_f32_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x16,0xd1,0xfc,0x04,0x02,0x00]

v_mac_f32_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x16,0xd1,0xfd,0x04,0x02,0x00]

v_mac_f32_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x16,0xd1,0xfe,0x04,0x02,0x00]

v_mac_f32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x16,0xd1,0x01,0xff,0x03,0x00]

v_mac_f32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x16,0xd1,0x01,0x05,0x00,0x00]

v_mac_f32_e64 v5, v1, s101
// CHECK: [0x05,0x00,0x16,0xd1,0x01,0xcb,0x00,0x00]

v_mac_f32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x16,0xd1,0x01,0xcd,0x00,0x00]

v_mac_f32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x16,0xd1,0x01,0xcf,0x00,0x00]

v_mac_f32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x16,0xd1,0x01,0xd5,0x00,0x00]

v_mac_f32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x16,0xd1,0x01,0xd7,0x00,0x00]

v_mac_f32_e64 v5, v1, ttmp15
// CHECK: [0x05,0x00,0x16,0xd1,0x01,0xf7,0x00,0x00]

v_mac_f32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x16,0xd1,0x01,0xf9,0x00,0x00]

v_mac_f32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x16,0xd1,0x01,0xfd,0x00,0x00]

v_mac_f32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x16,0xd1,0x01,0xff,0x00,0x00]

v_mac_f32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x16,0xd1,0x01,0x01,0x01,0x00]

v_mac_f32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x16,0xd1,0x01,0x83,0x01,0x00]

v_mac_f32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x16,0xd1,0x01,0xe1,0x01,0x00]

v_mac_f32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x16,0xd1,0x01,0xef,0x01,0x00]

v_mac_f32_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x16,0xd1,0x01,0xf7,0x01,0x00]

v_mac_f32_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x16,0xd1,0x01,0xf9,0x01,0x00]

v_mac_f32_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x16,0xd1,0x01,0xfb,0x01,0x00]

v_mac_f32_e64 v5, -v1, v2
// CHECK: [0x05,0x00,0x16,0xd1,0x01,0x05,0x02,0x20]

v_mac_f32_e64 v5, v1, -v2
// CHECK: [0x05,0x00,0x16,0xd1,0x01,0x05,0x02,0x40]

v_mac_f32_e64 v5, -v1, -v2
// CHECK: [0x05,0x00,0x16,0xd1,0x01,0x05,0x02,0x60]

v_mac_f32_e64 v5, |v1|, v2
// CHECK: [0x05,0x01,0x16,0xd1,0x01,0x05,0x02,0x00]

v_mac_f32_e64 v5, v1, |v2|
// CHECK: [0x05,0x02,0x16,0xd1,0x01,0x05,0x02,0x00]

v_mac_f32_e64 v5, |v1|, |v2|
// CHECK: [0x05,0x03,0x16,0xd1,0x01,0x05,0x02,0x00]

v_mac_f32_e64 v5, v1, v2 clamp
// CHECK: [0x05,0x80,0x16,0xd1,0x01,0x05,0x02,0x00]

v_mac_f32_e64 v5, v1, v2 mul:2
// CHECK: [0x05,0x00,0x16,0xd1,0x01,0x05,0x02,0x08]

v_mac_f32_e64 v5, v1, v2 mul:4
// CHECK: [0x05,0x00,0x16,0xd1,0x01,0x05,0x02,0x10]

v_mac_f32_e64 v5, v1, v2 div:2
// CHECK: [0x05,0x00,0x16,0xd1,0x01,0x05,0x02,0x18]

v_add_co_u32_e64 v5, s[12:13], v1, v2
// CHECK: [0x05,0x0c,0x19,0xd1,0x01,0x05,0x02,0x00]

v_add_co_u32_e64 v255, s[12:13], v1, v2
// CHECK: [0xff,0x0c,0x19,0xd1,0x01,0x05,0x02,0x00]

v_add_co_u32_e64 v5, s[14:15], v1, v2
// CHECK: [0x05,0x0e,0x19,0xd1,0x01,0x05,0x02,0x00]

v_add_co_u32_e64 v5, s[100:101], v1, v2
// CHECK: [0x05,0x64,0x19,0xd1,0x01,0x05,0x02,0x00]

v_add_co_u32_e64 v5, flat_scratch, v1, v2
// CHECK: [0x05,0x66,0x19,0xd1,0x01,0x05,0x02,0x00]

v_add_co_u32_e64 v5, vcc, v1, v2
// CHECK: [0x05,0x6a,0x19,0xd1,0x01,0x05,0x02,0x00]

v_add_co_u32_e64 v5, ttmp[14:15], v1, v2
// CHECK: [0x05,0x7a,0x19,0xd1,0x01,0x05,0x02,0x00]

v_add_co_u32_e64 v5, s[12:13], v255, v2
// CHECK: [0x05,0x0c,0x19,0xd1,0xff,0x05,0x02,0x00]

v_add_co_u32_e64 v5, s[12:13], s1, v2
// CHECK: [0x05,0x0c,0x19,0xd1,0x01,0x04,0x02,0x00]

v_add_co_u32_e64 v5, s[12:13], s101, v2
// CHECK: [0x05,0x0c,0x19,0xd1,0x65,0x04,0x02,0x00]

v_add_co_u32_e64 v5, s[12:13], flat_scratch_lo, v2
// CHECK: [0x05,0x0c,0x19,0xd1,0x66,0x04,0x02,0x00]

v_add_co_u32_e64 v5, s[12:13], flat_scratch_hi, v2
// CHECK: [0x05,0x0c,0x19,0xd1,0x67,0x04,0x02,0x00]

v_add_co_u32_e64 v5, s[12:13], vcc_lo, v2
// CHECK: [0x05,0x0c,0x19,0xd1,0x6a,0x04,0x02,0x00]

v_add_co_u32_e64 v5, s[12:13], vcc_hi, v2
// CHECK: [0x05,0x0c,0x19,0xd1,0x6b,0x04,0x02,0x00]

v_add_co_u32_e64 v5, s[12:13], ttmp15, v2
// CHECK: [0x05,0x0c,0x19,0xd1,0x7b,0x04,0x02,0x00]

v_add_co_u32_e64 v5, s[12:13], m0, v2
// CHECK: [0x05,0x0c,0x19,0xd1,0x7c,0x04,0x02,0x00]

v_add_co_u32_e64 v5, s[12:13], exec_lo, v2
// CHECK: [0x05,0x0c,0x19,0xd1,0x7e,0x04,0x02,0x00]

v_add_co_u32_e64 v5, s[12:13], exec_hi, v2
// CHECK: [0x05,0x0c,0x19,0xd1,0x7f,0x04,0x02,0x00]

v_add_co_u32_e64 v5, s[12:13], 0, v2
// CHECK: [0x05,0x0c,0x19,0xd1,0x80,0x04,0x02,0x00]

v_add_co_u32_e64 v5, s[12:13], -1, v2
// CHECK: [0x05,0x0c,0x19,0xd1,0xc1,0x04,0x02,0x00]

v_add_co_u32_e64 v5, s[12:13], 0.5, v2
// CHECK: [0x05,0x0c,0x19,0xd1,0xf0,0x04,0x02,0x00]

v_add_co_u32_e64 v5, s[12:13], -4.0, v2
// CHECK: [0x05,0x0c,0x19,0xd1,0xf7,0x04,0x02,0x00]

v_add_co_u32_e64 v5, s[12:13], src_vccz, v2
// CHECK: [0x05,0x0c,0x19,0xd1,0xfb,0x04,0x02,0x00]

v_add_co_u32_e64 v5, s[12:13], src_execz, v2
// CHECK: [0x05,0x0c,0x19,0xd1,0xfc,0x04,0x02,0x00]

v_add_co_u32_e64 v5, s[12:13], src_scc, v2
// CHECK: [0x05,0x0c,0x19,0xd1,0xfd,0x04,0x02,0x00]

v_add_co_u32_e64 v5, s[12:13], src_lds_direct, v2
// CHECK: [0x05,0x0c,0x19,0xd1,0xfe,0x04,0x02,0x00]

v_add_co_u32_e64 v5, s[12:13], v1, v255
// CHECK: [0x05,0x0c,0x19,0xd1,0x01,0xff,0x03,0x00]

v_add_co_u32_e64 v5, s[12:13], v1, s2
// CHECK: [0x05,0x0c,0x19,0xd1,0x01,0x05,0x00,0x00]

v_add_co_u32_e64 v5, s[12:13], v1, s101
// CHECK: [0x05,0x0c,0x19,0xd1,0x01,0xcb,0x00,0x00]

v_add_co_u32_e64 v5, s[12:13], v1, flat_scratch_lo
// CHECK: [0x05,0x0c,0x19,0xd1,0x01,0xcd,0x00,0x00]

v_add_co_u32_e64 v5, s[12:13], v1, flat_scratch_hi
// CHECK: [0x05,0x0c,0x19,0xd1,0x01,0xcf,0x00,0x00]

v_add_co_u32_e64 v5, s[12:13], v1, vcc_lo
// CHECK: [0x05,0x0c,0x19,0xd1,0x01,0xd5,0x00,0x00]

v_add_co_u32_e64 v5, s[12:13], v1, vcc_hi
// CHECK: [0x05,0x0c,0x19,0xd1,0x01,0xd7,0x00,0x00]

v_add_co_u32_e64 v5, s[12:13], v1, ttmp15
// CHECK: [0x05,0x0c,0x19,0xd1,0x01,0xf7,0x00,0x00]

v_add_co_u32_e64 v5, s[12:13], v1, m0
// CHECK: [0x05,0x0c,0x19,0xd1,0x01,0xf9,0x00,0x00]

v_add_co_u32_e64 v5, s[12:13], v1, exec_lo
// CHECK: [0x05,0x0c,0x19,0xd1,0x01,0xfd,0x00,0x00]

v_add_co_u32_e64 v5, s[12:13], v1, exec_hi
// CHECK: [0x05,0x0c,0x19,0xd1,0x01,0xff,0x00,0x00]

v_add_co_u32_e64 v5, s[12:13], v1, 0
// CHECK: [0x05,0x0c,0x19,0xd1,0x01,0x01,0x01,0x00]

v_add_co_u32_e64 v5, s[12:13], v1, -1
// CHECK: [0x05,0x0c,0x19,0xd1,0x01,0x83,0x01,0x00]

v_add_co_u32_e64 v5, s[12:13], v1, 0.5
// CHECK: [0x05,0x0c,0x19,0xd1,0x01,0xe1,0x01,0x00]

v_add_co_u32_e64 v5, s[12:13], v1, -4.0
// CHECK: [0x05,0x0c,0x19,0xd1,0x01,0xef,0x01,0x00]

v_add_co_u32_e64 v5, s[12:13], v1, src_vccz
// CHECK: [0x05,0x0c,0x19,0xd1,0x01,0xf7,0x01,0x00]

v_add_co_u32_e64 v5, s[12:13], v1, src_execz
// CHECK: [0x05,0x0c,0x19,0xd1,0x01,0xf9,0x01,0x00]

v_add_co_u32_e64 v5, s[12:13], v1, src_scc
// CHECK: [0x05,0x0c,0x19,0xd1,0x01,0xfb,0x01,0x00]

v_add_co_u32_e64 v5, s[12:13], v1, v2 clamp
// CHECK: [0x05,0x8c,0x19,0xd1,0x01,0x05,0x02,0x00]

v_sub_co_u32_e64 v5, s[12:13], v1, v2
// CHECK: [0x05,0x0c,0x1a,0xd1,0x01,0x05,0x02,0x00]

v_sub_co_u32_e64 v255, s[12:13], v1, v2
// CHECK: [0xff,0x0c,0x1a,0xd1,0x01,0x05,0x02,0x00]

v_sub_co_u32_e64 v5, s[14:15], v1, v2
// CHECK: [0x05,0x0e,0x1a,0xd1,0x01,0x05,0x02,0x00]

v_sub_co_u32_e64 v5, s[100:101], v1, v2
// CHECK: [0x05,0x64,0x1a,0xd1,0x01,0x05,0x02,0x00]

v_sub_co_u32_e64 v5, flat_scratch, v1, v2
// CHECK: [0x05,0x66,0x1a,0xd1,0x01,0x05,0x02,0x00]

v_sub_co_u32_e64 v5, vcc, v1, v2
// CHECK: [0x05,0x6a,0x1a,0xd1,0x01,0x05,0x02,0x00]

v_sub_co_u32_e64 v5, ttmp[14:15], v1, v2
// CHECK: [0x05,0x7a,0x1a,0xd1,0x01,0x05,0x02,0x00]

v_sub_co_u32_e64 v5, s[12:13], v255, v2
// CHECK: [0x05,0x0c,0x1a,0xd1,0xff,0x05,0x02,0x00]

v_sub_co_u32_e64 v5, s[12:13], s1, v2
// CHECK: [0x05,0x0c,0x1a,0xd1,0x01,0x04,0x02,0x00]

v_sub_co_u32_e64 v5, s[12:13], s101, v2
// CHECK: [0x05,0x0c,0x1a,0xd1,0x65,0x04,0x02,0x00]

v_sub_co_u32_e64 v5, s[12:13], flat_scratch_lo, v2
// CHECK: [0x05,0x0c,0x1a,0xd1,0x66,0x04,0x02,0x00]

v_sub_co_u32_e64 v5, s[12:13], flat_scratch_hi, v2
// CHECK: [0x05,0x0c,0x1a,0xd1,0x67,0x04,0x02,0x00]

v_sub_co_u32_e64 v5, s[12:13], vcc_lo, v2
// CHECK: [0x05,0x0c,0x1a,0xd1,0x6a,0x04,0x02,0x00]

v_sub_co_u32_e64 v5, s[12:13], vcc_hi, v2
// CHECK: [0x05,0x0c,0x1a,0xd1,0x6b,0x04,0x02,0x00]

v_sub_co_u32_e64 v5, s[12:13], ttmp15, v2
// CHECK: [0x05,0x0c,0x1a,0xd1,0x7b,0x04,0x02,0x00]

v_sub_co_u32_e64 v5, s[12:13], m0, v2
// CHECK: [0x05,0x0c,0x1a,0xd1,0x7c,0x04,0x02,0x00]

v_sub_co_u32_e64 v5, s[12:13], exec_lo, v2
// CHECK: [0x05,0x0c,0x1a,0xd1,0x7e,0x04,0x02,0x00]

v_sub_co_u32_e64 v5, s[12:13], exec_hi, v2
// CHECK: [0x05,0x0c,0x1a,0xd1,0x7f,0x04,0x02,0x00]

v_sub_co_u32_e64 v5, s[12:13], 0, v2
// CHECK: [0x05,0x0c,0x1a,0xd1,0x80,0x04,0x02,0x00]

v_sub_co_u32_e64 v5, s[12:13], -1, v2
// CHECK: [0x05,0x0c,0x1a,0xd1,0xc1,0x04,0x02,0x00]

v_sub_co_u32_e64 v5, s[12:13], 0.5, v2
// CHECK: [0x05,0x0c,0x1a,0xd1,0xf0,0x04,0x02,0x00]

v_sub_co_u32_e64 v5, s[12:13], -4.0, v2
// CHECK: [0x05,0x0c,0x1a,0xd1,0xf7,0x04,0x02,0x00]

v_sub_co_u32_e64 v5, s[12:13], src_vccz, v2
// CHECK: [0x05,0x0c,0x1a,0xd1,0xfb,0x04,0x02,0x00]

v_sub_co_u32_e64 v5, s[12:13], src_execz, v2
// CHECK: [0x05,0x0c,0x1a,0xd1,0xfc,0x04,0x02,0x00]

v_sub_co_u32_e64 v5, s[12:13], src_scc, v2
// CHECK: [0x05,0x0c,0x1a,0xd1,0xfd,0x04,0x02,0x00]

v_sub_co_u32_e64 v5, s[12:13], src_lds_direct, v2
// CHECK: [0x05,0x0c,0x1a,0xd1,0xfe,0x04,0x02,0x00]

v_sub_co_u32_e64 v5, s[12:13], v1, v255
// CHECK: [0x05,0x0c,0x1a,0xd1,0x01,0xff,0x03,0x00]

v_sub_co_u32_e64 v5, s[12:13], v1, s2
// CHECK: [0x05,0x0c,0x1a,0xd1,0x01,0x05,0x00,0x00]

v_sub_co_u32_e64 v5, s[12:13], v1, s101
// CHECK: [0x05,0x0c,0x1a,0xd1,0x01,0xcb,0x00,0x00]

v_sub_co_u32_e64 v5, s[12:13], v1, flat_scratch_lo
// CHECK: [0x05,0x0c,0x1a,0xd1,0x01,0xcd,0x00,0x00]

v_sub_co_u32_e64 v5, s[12:13], v1, flat_scratch_hi
// CHECK: [0x05,0x0c,0x1a,0xd1,0x01,0xcf,0x00,0x00]

v_sub_co_u32_e64 v5, s[12:13], v1, vcc_lo
// CHECK: [0x05,0x0c,0x1a,0xd1,0x01,0xd5,0x00,0x00]

v_sub_co_u32_e64 v5, s[12:13], v1, vcc_hi
// CHECK: [0x05,0x0c,0x1a,0xd1,0x01,0xd7,0x00,0x00]

v_sub_co_u32_e64 v5, s[12:13], v1, ttmp15
// CHECK: [0x05,0x0c,0x1a,0xd1,0x01,0xf7,0x00,0x00]

v_sub_co_u32_e64 v5, s[12:13], v1, m0
// CHECK: [0x05,0x0c,0x1a,0xd1,0x01,0xf9,0x00,0x00]

v_sub_co_u32_e64 v5, s[12:13], v1, exec_lo
// CHECK: [0x05,0x0c,0x1a,0xd1,0x01,0xfd,0x00,0x00]

v_sub_co_u32_e64 v5, s[12:13], v1, exec_hi
// CHECK: [0x05,0x0c,0x1a,0xd1,0x01,0xff,0x00,0x00]

v_sub_co_u32_e64 v5, s[12:13], v1, 0
// CHECK: [0x05,0x0c,0x1a,0xd1,0x01,0x01,0x01,0x00]

v_sub_co_u32_e64 v5, s[12:13], v1, -1
// CHECK: [0x05,0x0c,0x1a,0xd1,0x01,0x83,0x01,0x00]

v_sub_co_u32_e64 v5, s[12:13], v1, 0.5
// CHECK: [0x05,0x0c,0x1a,0xd1,0x01,0xe1,0x01,0x00]

v_sub_co_u32_e64 v5, s[12:13], v1, -4.0
// CHECK: [0x05,0x0c,0x1a,0xd1,0x01,0xef,0x01,0x00]

v_sub_co_u32_e64 v5, s[12:13], v1, src_vccz
// CHECK: [0x05,0x0c,0x1a,0xd1,0x01,0xf7,0x01,0x00]

v_sub_co_u32_e64 v5, s[12:13], v1, src_execz
// CHECK: [0x05,0x0c,0x1a,0xd1,0x01,0xf9,0x01,0x00]

v_sub_co_u32_e64 v5, s[12:13], v1, src_scc
// CHECK: [0x05,0x0c,0x1a,0xd1,0x01,0xfb,0x01,0x00]

v_sub_co_u32_e64 v5, s[12:13], v1, v2 clamp
// CHECK: [0x05,0x8c,0x1a,0xd1,0x01,0x05,0x02,0x00]

v_subrev_co_u32_e64 v5, s[12:13], v1, v2
// CHECK: [0x05,0x0c,0x1b,0xd1,0x01,0x05,0x02,0x00]

v_subrev_co_u32_e64 v255, s[12:13], v1, v2
// CHECK: [0xff,0x0c,0x1b,0xd1,0x01,0x05,0x02,0x00]

v_subrev_co_u32_e64 v5, s[14:15], v1, v2
// CHECK: [0x05,0x0e,0x1b,0xd1,0x01,0x05,0x02,0x00]

v_subrev_co_u32_e64 v5, s[100:101], v1, v2
// CHECK: [0x05,0x64,0x1b,0xd1,0x01,0x05,0x02,0x00]

v_subrev_co_u32_e64 v5, flat_scratch, v1, v2
// CHECK: [0x05,0x66,0x1b,0xd1,0x01,0x05,0x02,0x00]

v_subrev_co_u32_e64 v5, vcc, v1, v2
// CHECK: [0x05,0x6a,0x1b,0xd1,0x01,0x05,0x02,0x00]

v_subrev_co_u32_e64 v5, ttmp[14:15], v1, v2
// CHECK: [0x05,0x7a,0x1b,0xd1,0x01,0x05,0x02,0x00]

v_subrev_co_u32_e64 v5, s[12:13], v255, v2
// CHECK: [0x05,0x0c,0x1b,0xd1,0xff,0x05,0x02,0x00]

v_subrev_co_u32_e64 v5, s[12:13], s1, v2
// CHECK: [0x05,0x0c,0x1b,0xd1,0x01,0x04,0x02,0x00]

v_subrev_co_u32_e64 v5, s[12:13], s101, v2
// CHECK: [0x05,0x0c,0x1b,0xd1,0x65,0x04,0x02,0x00]

v_subrev_co_u32_e64 v5, s[12:13], flat_scratch_lo, v2
// CHECK: [0x05,0x0c,0x1b,0xd1,0x66,0x04,0x02,0x00]

v_subrev_co_u32_e64 v5, s[12:13], flat_scratch_hi, v2
// CHECK: [0x05,0x0c,0x1b,0xd1,0x67,0x04,0x02,0x00]

v_subrev_co_u32_e64 v5, s[12:13], vcc_lo, v2
// CHECK: [0x05,0x0c,0x1b,0xd1,0x6a,0x04,0x02,0x00]

v_subrev_co_u32_e64 v5, s[12:13], vcc_hi, v2
// CHECK: [0x05,0x0c,0x1b,0xd1,0x6b,0x04,0x02,0x00]

v_subrev_co_u32_e64 v5, s[12:13], ttmp15, v2
// CHECK: [0x05,0x0c,0x1b,0xd1,0x7b,0x04,0x02,0x00]

v_subrev_co_u32_e64 v5, s[12:13], m0, v2
// CHECK: [0x05,0x0c,0x1b,0xd1,0x7c,0x04,0x02,0x00]

v_subrev_co_u32_e64 v5, s[12:13], exec_lo, v2
// CHECK: [0x05,0x0c,0x1b,0xd1,0x7e,0x04,0x02,0x00]

v_subrev_co_u32_e64 v5, s[12:13], exec_hi, v2
// CHECK: [0x05,0x0c,0x1b,0xd1,0x7f,0x04,0x02,0x00]

v_subrev_co_u32_e64 v5, s[12:13], 0, v2
// CHECK: [0x05,0x0c,0x1b,0xd1,0x80,0x04,0x02,0x00]

v_subrev_co_u32_e64 v5, s[12:13], -1, v2
// CHECK: [0x05,0x0c,0x1b,0xd1,0xc1,0x04,0x02,0x00]

v_subrev_co_u32_e64 v5, s[12:13], 0.5, v2
// CHECK: [0x05,0x0c,0x1b,0xd1,0xf0,0x04,0x02,0x00]

v_subrev_co_u32_e64 v5, s[12:13], -4.0, v2
// CHECK: [0x05,0x0c,0x1b,0xd1,0xf7,0x04,0x02,0x00]

v_subrev_co_u32_e64 v5, s[12:13], src_vccz, v2
// CHECK: [0x05,0x0c,0x1b,0xd1,0xfb,0x04,0x02,0x00]

v_subrev_co_u32_e64 v5, s[12:13], src_execz, v2
// CHECK: [0x05,0x0c,0x1b,0xd1,0xfc,0x04,0x02,0x00]

v_subrev_co_u32_e64 v5, s[12:13], src_scc, v2
// CHECK: [0x05,0x0c,0x1b,0xd1,0xfd,0x04,0x02,0x00]

v_subrev_co_u32_e64 v5, s[12:13], v1, v255
// CHECK: [0x05,0x0c,0x1b,0xd1,0x01,0xff,0x03,0x00]

v_subrev_co_u32_e64 v5, s[12:13], v1, s2
// CHECK: [0x05,0x0c,0x1b,0xd1,0x01,0x05,0x00,0x00]

v_subrev_co_u32_e64 v5, s[12:13], v1, s101
// CHECK: [0x05,0x0c,0x1b,0xd1,0x01,0xcb,0x00,0x00]

v_subrev_co_u32_e64 v5, s[12:13], v1, flat_scratch_lo
// CHECK: [0x05,0x0c,0x1b,0xd1,0x01,0xcd,0x00,0x00]

v_subrev_co_u32_e64 v5, s[12:13], v1, flat_scratch_hi
// CHECK: [0x05,0x0c,0x1b,0xd1,0x01,0xcf,0x00,0x00]

v_subrev_co_u32_e64 v5, s[12:13], v1, vcc_lo
// CHECK: [0x05,0x0c,0x1b,0xd1,0x01,0xd5,0x00,0x00]

v_subrev_co_u32_e64 v5, s[12:13], v1, vcc_hi
// CHECK: [0x05,0x0c,0x1b,0xd1,0x01,0xd7,0x00,0x00]

v_subrev_co_u32_e64 v5, s[12:13], v1, ttmp15
// CHECK: [0x05,0x0c,0x1b,0xd1,0x01,0xf7,0x00,0x00]

v_subrev_co_u32_e64 v5, s[12:13], v1, m0
// CHECK: [0x05,0x0c,0x1b,0xd1,0x01,0xf9,0x00,0x00]

v_subrev_co_u32_e64 v5, s[12:13], v1, exec_lo
// CHECK: [0x05,0x0c,0x1b,0xd1,0x01,0xfd,0x00,0x00]

v_subrev_co_u32_e64 v5, s[12:13], v1, exec_hi
// CHECK: [0x05,0x0c,0x1b,0xd1,0x01,0xff,0x00,0x00]

v_subrev_co_u32_e64 v5, s[12:13], v1, 0
// CHECK: [0x05,0x0c,0x1b,0xd1,0x01,0x01,0x01,0x00]

v_subrev_co_u32_e64 v5, s[12:13], v1, -1
// CHECK: [0x05,0x0c,0x1b,0xd1,0x01,0x83,0x01,0x00]

v_subrev_co_u32_e64 v5, s[12:13], v1, 0.5
// CHECK: [0x05,0x0c,0x1b,0xd1,0x01,0xe1,0x01,0x00]

v_subrev_co_u32_e64 v5, s[12:13], v1, -4.0
// CHECK: [0x05,0x0c,0x1b,0xd1,0x01,0xef,0x01,0x00]

v_subrev_co_u32_e64 v5, s[12:13], v1, src_vccz
// CHECK: [0x05,0x0c,0x1b,0xd1,0x01,0xf7,0x01,0x00]

v_subrev_co_u32_e64 v5, s[12:13], v1, src_execz
// CHECK: [0x05,0x0c,0x1b,0xd1,0x01,0xf9,0x01,0x00]

v_subrev_co_u32_e64 v5, s[12:13], v1, src_scc
// CHECK: [0x05,0x0c,0x1b,0xd1,0x01,0xfb,0x01,0x00]

v_subrev_co_u32_e64 v5, s[12:13], v1, v2 clamp
// CHECK: [0x05,0x8c,0x1b,0xd1,0x01,0x05,0x02,0x00]

v_addc_co_u32_e64 v5, s[12:13], v1, v2, s[6:7]
// CHECK: [0x05,0x0c,0x1c,0xd1,0x01,0x05,0x1a,0x00]

v_addc_co_u32_e64 v255, s[12:13], v1, v2, s[6:7]
// CHECK: [0xff,0x0c,0x1c,0xd1,0x01,0x05,0x1a,0x00]

v_addc_co_u32_e64 v5, s[14:15], v1, v2, s[6:7]
// CHECK: [0x05,0x0e,0x1c,0xd1,0x01,0x05,0x1a,0x00]

v_addc_co_u32_e64 v5, s[100:101], v1, v2, s[6:7]
// CHECK: [0x05,0x64,0x1c,0xd1,0x01,0x05,0x1a,0x00]

v_addc_co_u32_e64 v5, flat_scratch, v1, v2, s[6:7]
// CHECK: [0x05,0x66,0x1c,0xd1,0x01,0x05,0x1a,0x00]

v_addc_co_u32_e64 v5, vcc, v1, v2, s[6:7]
// CHECK: [0x05,0x6a,0x1c,0xd1,0x01,0x05,0x1a,0x00]

v_addc_co_u32_e64 v5, ttmp[14:15], v1, v2, s[6:7]
// CHECK: [0x05,0x7a,0x1c,0xd1,0x01,0x05,0x1a,0x00]

v_addc_co_u32_e64 v5, s[12:13], v255, v2, s[6:7]
// CHECK: [0x05,0x0c,0x1c,0xd1,0xff,0x05,0x1a,0x00]

v_addc_co_u32_e64 v5, s[12:13], 0, v2, s[6:7]
// CHECK: [0x05,0x0c,0x1c,0xd1,0x80,0x04,0x1a,0x00]

v_addc_co_u32_e64 v5, s[12:13], -1, v2, s[6:7]
// CHECK: [0x05,0x0c,0x1c,0xd1,0xc1,0x04,0x1a,0x00]

v_addc_co_u32_e64 v5, s[12:13], 0.5, v2, s[6:7]
// CHECK: [0x05,0x0c,0x1c,0xd1,0xf0,0x04,0x1a,0x00]

v_addc_co_u32_e64 v5, s[12:13], -4.0, v2, s[6:7]
// CHECK: [0x05,0x0c,0x1c,0xd1,0xf7,0x04,0x1a,0x00]

v_addc_co_u32_e64 v5, s[12:13], src_lds_direct, v2, s[6:7]
// CHECK: [0x05,0x0c,0x1c,0xd1,0xfe,0x04,0x1a,0x00]

v_addc_co_u32_e64 v5, s[12:13], v1, v255, s[6:7]
// CHECK: [0x05,0x0c,0x1c,0xd1,0x01,0xff,0x1b,0x00]

v_addc_co_u32_e64 v5, s[12:13], v1, 0, s[6:7]
// CHECK: [0x05,0x0c,0x1c,0xd1,0x01,0x01,0x19,0x00]

v_addc_co_u32_e64 v5, s[12:13], v1, -1, s[6:7]
// CHECK: [0x05,0x0c,0x1c,0xd1,0x01,0x83,0x19,0x00]

v_addc_co_u32_e64 v5, s[12:13], v1, 0.5, s[6:7]
// CHECK: [0x05,0x0c,0x1c,0xd1,0x01,0xe1,0x19,0x00]

v_addc_co_u32_e64 v5, s[12:13], v1, -4.0, s[6:7]
// CHECK: [0x05,0x0c,0x1c,0xd1,0x01,0xef,0x19,0x00]

v_addc_co_u32_e64 v5, s[12:13], v1, v2, s[8:9]
// CHECK: [0x05,0x0c,0x1c,0xd1,0x01,0x05,0x22,0x00]

v_addc_co_u32_e64 v5, s[12:13], v1, v2, s[100:101]
// CHECK: [0x05,0x0c,0x1c,0xd1,0x01,0x05,0x92,0x01]

v_addc_co_u32_e64 v5, s[12:13], v1, v2, flat_scratch
// CHECK: [0x05,0x0c,0x1c,0xd1,0x01,0x05,0x9a,0x01]

v_addc_co_u32_e64 v5, s[12:13], v1, v2, vcc
// CHECK: [0x05,0x0c,0x1c,0xd1,0x01,0x05,0xaa,0x01]

v_addc_co_u32_e64 v5, s[12:13], v1, v2, ttmp[14:15]
// CHECK: [0x05,0x0c,0x1c,0xd1,0x01,0x05,0xea,0x01]

v_addc_co_u32_e64 v5, s[12:13], v1, v2, s[6:7] clamp
// CHECK: [0x05,0x8c,0x1c,0xd1,0x01,0x05,0x1a,0x00]

v_subb_co_u32_e64 v5, s[12:13], v1, v2, s[6:7]
// CHECK: [0x05,0x0c,0x1d,0xd1,0x01,0x05,0x1a,0x00]

v_subb_co_u32_e64 v255, s[12:13], v1, v2, s[6:7]
// CHECK: [0xff,0x0c,0x1d,0xd1,0x01,0x05,0x1a,0x00]

v_subb_co_u32_e64 v5, s[14:15], v1, v2, s[6:7]
// CHECK: [0x05,0x0e,0x1d,0xd1,0x01,0x05,0x1a,0x00]

v_subb_co_u32_e64 v5, s[100:101], v1, v2, s[6:7]
// CHECK: [0x05,0x64,0x1d,0xd1,0x01,0x05,0x1a,0x00]

v_subb_co_u32_e64 v5, flat_scratch, v1, v2, s[6:7]
// CHECK: [0x05,0x66,0x1d,0xd1,0x01,0x05,0x1a,0x00]

v_subb_co_u32_e64 v5, vcc, v1, v2, s[6:7]
// CHECK: [0x05,0x6a,0x1d,0xd1,0x01,0x05,0x1a,0x00]

v_subb_co_u32_e64 v5, ttmp[14:15], v1, v2, s[6:7]
// CHECK: [0x05,0x7a,0x1d,0xd1,0x01,0x05,0x1a,0x00]

v_subb_co_u32_e64 v5, s[12:13], v255, v2, s[6:7]
// CHECK: [0x05,0x0c,0x1d,0xd1,0xff,0x05,0x1a,0x00]

v_subb_co_u32_e64 v5, s[12:13], 0, v2, s[6:7]
// CHECK: [0x05,0x0c,0x1d,0xd1,0x80,0x04,0x1a,0x00]

v_subb_co_u32_e64 v5, s[12:13], -1, v2, s[6:7]
// CHECK: [0x05,0x0c,0x1d,0xd1,0xc1,0x04,0x1a,0x00]

v_subb_co_u32_e64 v5, s[12:13], 0.5, v2, s[6:7]
// CHECK: [0x05,0x0c,0x1d,0xd1,0xf0,0x04,0x1a,0x00]

v_subb_co_u32_e64 v5, s[12:13], -4.0, v2, s[6:7]
// CHECK: [0x05,0x0c,0x1d,0xd1,0xf7,0x04,0x1a,0x00]

v_subb_co_u32_e64 v5, s[12:13], src_lds_direct, v2, s[6:7]
// CHECK: [0x05,0x0c,0x1d,0xd1,0xfe,0x04,0x1a,0x00]

v_subb_co_u32_e64 v5, s[12:13], v1, v255, s[6:7]
// CHECK: [0x05,0x0c,0x1d,0xd1,0x01,0xff,0x1b,0x00]

v_subb_co_u32_e64 v5, s[12:13], v1, 0, s[6:7]
// CHECK: [0x05,0x0c,0x1d,0xd1,0x01,0x01,0x19,0x00]

v_subb_co_u32_e64 v5, s[12:13], v1, -1, s[6:7]
// CHECK: [0x05,0x0c,0x1d,0xd1,0x01,0x83,0x19,0x00]

v_subb_co_u32_e64 v5, s[12:13], v1, 0.5, s[6:7]
// CHECK: [0x05,0x0c,0x1d,0xd1,0x01,0xe1,0x19,0x00]

v_subb_co_u32_e64 v5, s[12:13], v1, -4.0, s[6:7]
// CHECK: [0x05,0x0c,0x1d,0xd1,0x01,0xef,0x19,0x00]

v_subb_co_u32_e64 v5, s[12:13], v1, v2, s[8:9]
// CHECK: [0x05,0x0c,0x1d,0xd1,0x01,0x05,0x22,0x00]

v_subb_co_u32_e64 v5, s[12:13], v1, v2, s[100:101]
// CHECK: [0x05,0x0c,0x1d,0xd1,0x01,0x05,0x92,0x01]

v_subb_co_u32_e64 v5, s[12:13], v1, v2, flat_scratch
// CHECK: [0x05,0x0c,0x1d,0xd1,0x01,0x05,0x9a,0x01]

v_subb_co_u32_e64 v5, s[12:13], v1, v2, vcc
// CHECK: [0x05,0x0c,0x1d,0xd1,0x01,0x05,0xaa,0x01]

v_subb_co_u32_e64 v5, s[12:13], v1, v2, ttmp[14:15]
// CHECK: [0x05,0x0c,0x1d,0xd1,0x01,0x05,0xea,0x01]

v_subb_co_u32_e64 v5, s[12:13], v1, v2, s[6:7] clamp
// CHECK: [0x05,0x8c,0x1d,0xd1,0x01,0x05,0x1a,0x00]

v_subbrev_co_u32_e64 v5, s[12:13], v1, v2, s[6:7]
// CHECK: [0x05,0x0c,0x1e,0xd1,0x01,0x05,0x1a,0x00]

v_subbrev_co_u32_e64 v255, s[12:13], v1, v2, s[6:7]
// CHECK: [0xff,0x0c,0x1e,0xd1,0x01,0x05,0x1a,0x00]

v_subbrev_co_u32_e64 v5, s[14:15], v1, v2, s[6:7]
// CHECK: [0x05,0x0e,0x1e,0xd1,0x01,0x05,0x1a,0x00]

v_subbrev_co_u32_e64 v5, s[100:101], v1, v2, s[6:7]
// CHECK: [0x05,0x64,0x1e,0xd1,0x01,0x05,0x1a,0x00]

v_subbrev_co_u32_e64 v5, flat_scratch, v1, v2, s[6:7]
// CHECK: [0x05,0x66,0x1e,0xd1,0x01,0x05,0x1a,0x00]

v_subbrev_co_u32_e64 v5, vcc, v1, v2, s[6:7]
// CHECK: [0x05,0x6a,0x1e,0xd1,0x01,0x05,0x1a,0x00]

v_subbrev_co_u32_e64 v5, ttmp[14:15], v1, v2, s[6:7]
// CHECK: [0x05,0x7a,0x1e,0xd1,0x01,0x05,0x1a,0x00]

v_subbrev_co_u32_e64 v5, s[12:13], v255, v2, s[6:7]
// CHECK: [0x05,0x0c,0x1e,0xd1,0xff,0x05,0x1a,0x00]

v_subbrev_co_u32_e64 v5, s[12:13], 0, v2, s[6:7]
// CHECK: [0x05,0x0c,0x1e,0xd1,0x80,0x04,0x1a,0x00]

v_subbrev_co_u32_e64 v5, s[12:13], -1, v2, s[6:7]
// CHECK: [0x05,0x0c,0x1e,0xd1,0xc1,0x04,0x1a,0x00]

v_subbrev_co_u32_e64 v5, s[12:13], 0.5, v2, s[6:7]
// CHECK: [0x05,0x0c,0x1e,0xd1,0xf0,0x04,0x1a,0x00]

v_subbrev_co_u32_e64 v5, s[12:13], -4.0, v2, s[6:7]
// CHECK: [0x05,0x0c,0x1e,0xd1,0xf7,0x04,0x1a,0x00]

v_subbrev_co_u32_e64 v5, s[12:13], v1, v255, s[6:7]
// CHECK: [0x05,0x0c,0x1e,0xd1,0x01,0xff,0x1b,0x00]

v_subbrev_co_u32_e64 v5, s[12:13], v1, 0, s[6:7]
// CHECK: [0x05,0x0c,0x1e,0xd1,0x01,0x01,0x19,0x00]

v_subbrev_co_u32_e64 v5, s[12:13], v1, -1, s[6:7]
// CHECK: [0x05,0x0c,0x1e,0xd1,0x01,0x83,0x19,0x00]

v_subbrev_co_u32_e64 v5, s[12:13], v1, 0.5, s[6:7]
// CHECK: [0x05,0x0c,0x1e,0xd1,0x01,0xe1,0x19,0x00]

v_subbrev_co_u32_e64 v5, s[12:13], v1, -4.0, s[6:7]
// CHECK: [0x05,0x0c,0x1e,0xd1,0x01,0xef,0x19,0x00]

v_subbrev_co_u32_e64 v5, s[12:13], v1, v2, s[8:9]
// CHECK: [0x05,0x0c,0x1e,0xd1,0x01,0x05,0x22,0x00]

v_subbrev_co_u32_e64 v5, s[12:13], v1, v2, s[100:101]
// CHECK: [0x05,0x0c,0x1e,0xd1,0x01,0x05,0x92,0x01]

v_subbrev_co_u32_e64 v5, s[12:13], v1, v2, flat_scratch
// CHECK: [0x05,0x0c,0x1e,0xd1,0x01,0x05,0x9a,0x01]

v_subbrev_co_u32_e64 v5, s[12:13], v1, v2, vcc
// CHECK: [0x05,0x0c,0x1e,0xd1,0x01,0x05,0xaa,0x01]

v_subbrev_co_u32_e64 v5, s[12:13], v1, v2, ttmp[14:15]
// CHECK: [0x05,0x0c,0x1e,0xd1,0x01,0x05,0xea,0x01]

v_subbrev_co_u32_e64 v5, s[12:13], v1, v2, s[6:7] clamp
// CHECK: [0x05,0x8c,0x1e,0xd1,0x01,0x05,0x1a,0x00]

v_add_f16_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x1f,0xd1,0x01,0x05,0x02,0x00]

v_add_f16_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x1f,0xd1,0x01,0x05,0x02,0x00]

v_add_f16_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x1f,0xd1,0xff,0x05,0x02,0x00]

v_add_f16_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x1f,0xd1,0x01,0x04,0x02,0x00]

v_add_f16_e64 v5, s101, v2
// CHECK: [0x05,0x00,0x1f,0xd1,0x65,0x04,0x02,0x00]

v_add_f16_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x1f,0xd1,0x66,0x04,0x02,0x00]

v_add_f16_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x1f,0xd1,0x67,0x04,0x02,0x00]

v_add_f16_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x1f,0xd1,0x6a,0x04,0x02,0x00]

v_add_f16_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x1f,0xd1,0x6b,0x04,0x02,0x00]

v_add_f16_e64 v5, ttmp15, v2
// CHECK: [0x05,0x00,0x1f,0xd1,0x7b,0x04,0x02,0x00]

v_add_f16_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x1f,0xd1,0x7c,0x04,0x02,0x00]

v_add_f16_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x1f,0xd1,0x7e,0x04,0x02,0x00]

v_add_f16_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x1f,0xd1,0x7f,0x04,0x02,0x00]

v_add_f16_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x1f,0xd1,0x80,0x04,0x02,0x00]

v_add_f16_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x1f,0xd1,0xc1,0x04,0x02,0x00]

v_add_f16_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x1f,0xd1,0xf0,0x04,0x02,0x00]

v_add_f16_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x1f,0xd1,0xf7,0x04,0x02,0x00]

v_add_f16_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x1f,0xd1,0xfb,0x04,0x02,0x00]

v_add_f16_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x1f,0xd1,0xfc,0x04,0x02,0x00]

v_add_f16_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x1f,0xd1,0xfd,0x04,0x02,0x00]

v_add_f16_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x1f,0xd1,0xfe,0x04,0x02,0x00]

v_add_f16_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x1f,0xd1,0x01,0xff,0x03,0x00]

v_add_f16_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x1f,0xd1,0x01,0x05,0x00,0x00]

v_add_f16_e64 v5, v1, s101
// CHECK: [0x05,0x00,0x1f,0xd1,0x01,0xcb,0x00,0x00]

v_add_f16_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x1f,0xd1,0x01,0xcd,0x00,0x00]

v_add_f16_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x1f,0xd1,0x01,0xcf,0x00,0x00]

v_add_f16_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x1f,0xd1,0x01,0xd5,0x00,0x00]

v_add_f16_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x1f,0xd1,0x01,0xd7,0x00,0x00]

v_add_f16_e64 v5, v1, ttmp15
// CHECK: [0x05,0x00,0x1f,0xd1,0x01,0xf7,0x00,0x00]

v_add_f16_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x1f,0xd1,0x01,0xf9,0x00,0x00]

v_add_f16_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x1f,0xd1,0x01,0xfd,0x00,0x00]

v_add_f16_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x1f,0xd1,0x01,0xff,0x00,0x00]

v_add_f16_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x1f,0xd1,0x01,0x01,0x01,0x00]

v_add_f16_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x1f,0xd1,0x01,0x83,0x01,0x00]

v_add_f16_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x1f,0xd1,0x01,0xe1,0x01,0x00]

v_add_f16_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x1f,0xd1,0x01,0xef,0x01,0x00]

v_add_f16_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x1f,0xd1,0x01,0xf7,0x01,0x00]

v_add_f16_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x1f,0xd1,0x01,0xf9,0x01,0x00]

v_add_f16_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x1f,0xd1,0x01,0xfb,0x01,0x00]

v_add_f16_e64 v5, -v1, v2
// CHECK: [0x05,0x00,0x1f,0xd1,0x01,0x05,0x02,0x20]

v_add_f16_e64 v5, v1, -v2
// CHECK: [0x05,0x00,0x1f,0xd1,0x01,0x05,0x02,0x40]

v_add_f16_e64 v5, -v1, -v2
// CHECK: [0x05,0x00,0x1f,0xd1,0x01,0x05,0x02,0x60]

v_add_f16_e64 v5, |v1|, v2
// CHECK: [0x05,0x01,0x1f,0xd1,0x01,0x05,0x02,0x00]

v_add_f16_e64 v5, v1, |v2|
// CHECK: [0x05,0x02,0x1f,0xd1,0x01,0x05,0x02,0x00]

v_add_f16_e64 v5, |v1|, |v2|
// CHECK: [0x05,0x03,0x1f,0xd1,0x01,0x05,0x02,0x00]

v_add_f16_e64 v5, v1, v2 clamp
// CHECK: [0x05,0x80,0x1f,0xd1,0x01,0x05,0x02,0x00]

v_sub_f16_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x20,0xd1,0x01,0x05,0x02,0x00]

v_sub_f16_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x20,0xd1,0x01,0x05,0x02,0x00]

v_sub_f16_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x20,0xd1,0xff,0x05,0x02,0x00]

v_sub_f16_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x20,0xd1,0x01,0x04,0x02,0x00]

v_sub_f16_e64 v5, s101, v2
// CHECK: [0x05,0x00,0x20,0xd1,0x65,0x04,0x02,0x00]

v_sub_f16_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x20,0xd1,0x66,0x04,0x02,0x00]

v_sub_f16_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x20,0xd1,0x67,0x04,0x02,0x00]

v_sub_f16_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x20,0xd1,0x6a,0x04,0x02,0x00]

v_sub_f16_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x20,0xd1,0x6b,0x04,0x02,0x00]

v_sub_f16_e64 v5, ttmp15, v2
// CHECK: [0x05,0x00,0x20,0xd1,0x7b,0x04,0x02,0x00]

v_sub_f16_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x20,0xd1,0x7c,0x04,0x02,0x00]

v_sub_f16_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x20,0xd1,0x7e,0x04,0x02,0x00]

v_sub_f16_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x20,0xd1,0x7f,0x04,0x02,0x00]

v_sub_f16_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x20,0xd1,0x80,0x04,0x02,0x00]

v_sub_f16_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x20,0xd1,0xc1,0x04,0x02,0x00]

v_sub_f16_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x20,0xd1,0xf0,0x04,0x02,0x00]

v_sub_f16_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x20,0xd1,0xf7,0x04,0x02,0x00]

v_sub_f16_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x20,0xd1,0xfb,0x04,0x02,0x00]

v_sub_f16_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x20,0xd1,0xfc,0x04,0x02,0x00]

v_sub_f16_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x20,0xd1,0xfd,0x04,0x02,0x00]

v_sub_f16_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x20,0xd1,0xfe,0x04,0x02,0x00]

v_sub_f16_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x20,0xd1,0x01,0xff,0x03,0x00]

v_sub_f16_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x20,0xd1,0x01,0x05,0x00,0x00]

v_sub_f16_e64 v5, v1, s101
// CHECK: [0x05,0x00,0x20,0xd1,0x01,0xcb,0x00,0x00]

v_sub_f16_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x20,0xd1,0x01,0xcd,0x00,0x00]

v_sub_f16_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x20,0xd1,0x01,0xcf,0x00,0x00]

v_sub_f16_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x20,0xd1,0x01,0xd5,0x00,0x00]

v_sub_f16_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x20,0xd1,0x01,0xd7,0x00,0x00]

v_sub_f16_e64 v5, v1, ttmp15
// CHECK: [0x05,0x00,0x20,0xd1,0x01,0xf7,0x00,0x00]

v_sub_f16_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x20,0xd1,0x01,0xf9,0x00,0x00]

v_sub_f16_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x20,0xd1,0x01,0xfd,0x00,0x00]

v_sub_f16_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x20,0xd1,0x01,0xff,0x00,0x00]

v_sub_f16_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x20,0xd1,0x01,0x01,0x01,0x00]

v_sub_f16_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x20,0xd1,0x01,0x83,0x01,0x00]

v_sub_f16_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x20,0xd1,0x01,0xe1,0x01,0x00]

v_sub_f16_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x20,0xd1,0x01,0xef,0x01,0x00]

v_sub_f16_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x20,0xd1,0x01,0xf7,0x01,0x00]

v_sub_f16_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x20,0xd1,0x01,0xf9,0x01,0x00]

v_sub_f16_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x20,0xd1,0x01,0xfb,0x01,0x00]

v_sub_f16_e64 v5, -v1, v2
// CHECK: [0x05,0x00,0x20,0xd1,0x01,0x05,0x02,0x20]

v_sub_f16_e64 v5, v1, -v2
// CHECK: [0x05,0x00,0x20,0xd1,0x01,0x05,0x02,0x40]

v_sub_f16_e64 v5, -v1, -v2
// CHECK: [0x05,0x00,0x20,0xd1,0x01,0x05,0x02,0x60]

v_sub_f16_e64 v5, |v1|, v2
// CHECK: [0x05,0x01,0x20,0xd1,0x01,0x05,0x02,0x00]

v_sub_f16_e64 v5, v1, |v2|
// CHECK: [0x05,0x02,0x20,0xd1,0x01,0x05,0x02,0x00]

v_sub_f16_e64 v5, |v1|, |v2|
// CHECK: [0x05,0x03,0x20,0xd1,0x01,0x05,0x02,0x00]

v_sub_f16_e64 v5, v1, v2 clamp
// CHECK: [0x05,0x80,0x20,0xd1,0x01,0x05,0x02,0x00]

v_subrev_f16_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x21,0xd1,0x01,0x05,0x02,0x00]

v_subrev_f16_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x21,0xd1,0x01,0x05,0x02,0x00]

v_subrev_f16_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x21,0xd1,0xff,0x05,0x02,0x00]

v_subrev_f16_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x21,0xd1,0x01,0x04,0x02,0x00]

v_subrev_f16_e64 v5, s101, v2
// CHECK: [0x05,0x00,0x21,0xd1,0x65,0x04,0x02,0x00]

v_subrev_f16_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x21,0xd1,0x66,0x04,0x02,0x00]

v_subrev_f16_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x21,0xd1,0x67,0x04,0x02,0x00]

v_subrev_f16_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x21,0xd1,0x6a,0x04,0x02,0x00]

v_subrev_f16_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x21,0xd1,0x6b,0x04,0x02,0x00]

v_subrev_f16_e64 v5, ttmp15, v2
// CHECK: [0x05,0x00,0x21,0xd1,0x7b,0x04,0x02,0x00]

v_subrev_f16_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x21,0xd1,0x7c,0x04,0x02,0x00]

v_subrev_f16_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x21,0xd1,0x7e,0x04,0x02,0x00]

v_subrev_f16_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x21,0xd1,0x7f,0x04,0x02,0x00]

v_subrev_f16_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x21,0xd1,0x80,0x04,0x02,0x00]

v_subrev_f16_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x21,0xd1,0xc1,0x04,0x02,0x00]

v_subrev_f16_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x21,0xd1,0xf0,0x04,0x02,0x00]

v_subrev_f16_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x21,0xd1,0xf7,0x04,0x02,0x00]

v_subrev_f16_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x21,0xd1,0xfb,0x04,0x02,0x00]

v_subrev_f16_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x21,0xd1,0xfc,0x04,0x02,0x00]

v_subrev_f16_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x21,0xd1,0xfd,0x04,0x02,0x00]

v_subrev_f16_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x21,0xd1,0x01,0xff,0x03,0x00]

v_subrev_f16_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x21,0xd1,0x01,0x05,0x00,0x00]

v_subrev_f16_e64 v5, v1, s101
// CHECK: [0x05,0x00,0x21,0xd1,0x01,0xcb,0x00,0x00]

v_subrev_f16_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x21,0xd1,0x01,0xcd,0x00,0x00]

v_subrev_f16_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x21,0xd1,0x01,0xcf,0x00,0x00]

v_subrev_f16_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x21,0xd1,0x01,0xd5,0x00,0x00]

v_subrev_f16_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x21,0xd1,0x01,0xd7,0x00,0x00]

v_subrev_f16_e64 v5, v1, ttmp15
// CHECK: [0x05,0x00,0x21,0xd1,0x01,0xf7,0x00,0x00]

v_subrev_f16_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x21,0xd1,0x01,0xf9,0x00,0x00]

v_subrev_f16_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x21,0xd1,0x01,0xfd,0x00,0x00]

v_subrev_f16_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x21,0xd1,0x01,0xff,0x00,0x00]

v_subrev_f16_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x21,0xd1,0x01,0x01,0x01,0x00]

v_subrev_f16_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x21,0xd1,0x01,0x83,0x01,0x00]

v_subrev_f16_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x21,0xd1,0x01,0xe1,0x01,0x00]

v_subrev_f16_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x21,0xd1,0x01,0xef,0x01,0x00]

v_subrev_f16_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x21,0xd1,0x01,0xf7,0x01,0x00]

v_subrev_f16_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x21,0xd1,0x01,0xf9,0x01,0x00]

v_subrev_f16_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x21,0xd1,0x01,0xfb,0x01,0x00]

v_subrev_f16_e64 v5, -v1, v2
// CHECK: [0x05,0x00,0x21,0xd1,0x01,0x05,0x02,0x20]

v_subrev_f16_e64 v5, v1, -v2
// CHECK: [0x05,0x00,0x21,0xd1,0x01,0x05,0x02,0x40]

v_subrev_f16_e64 v5, -v1, -v2
// CHECK: [0x05,0x00,0x21,0xd1,0x01,0x05,0x02,0x60]

v_subrev_f16_e64 v5, |v1|, v2
// CHECK: [0x05,0x01,0x21,0xd1,0x01,0x05,0x02,0x00]

v_subrev_f16_e64 v5, v1, |v2|
// CHECK: [0x05,0x02,0x21,0xd1,0x01,0x05,0x02,0x00]

v_subrev_f16_e64 v5, |v1|, |v2|
// CHECK: [0x05,0x03,0x21,0xd1,0x01,0x05,0x02,0x00]

v_subrev_f16_e64 v5, v1, v2 clamp
// CHECK: [0x05,0x80,0x21,0xd1,0x01,0x05,0x02,0x00]

v_mul_f16_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x22,0xd1,0x01,0x05,0x02,0x00]

v_mul_f16_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x22,0xd1,0x01,0x05,0x02,0x00]

v_mul_f16_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x22,0xd1,0xff,0x05,0x02,0x00]

v_mul_f16_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x22,0xd1,0x01,0x04,0x02,0x00]

v_mul_f16_e64 v5, s101, v2
// CHECK: [0x05,0x00,0x22,0xd1,0x65,0x04,0x02,0x00]

v_mul_f16_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x22,0xd1,0x66,0x04,0x02,0x00]

v_mul_f16_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x22,0xd1,0x67,0x04,0x02,0x00]

v_mul_f16_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x22,0xd1,0x6a,0x04,0x02,0x00]

v_mul_f16_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x22,0xd1,0x6b,0x04,0x02,0x00]

v_mul_f16_e64 v5, ttmp15, v2
// CHECK: [0x05,0x00,0x22,0xd1,0x7b,0x04,0x02,0x00]

v_mul_f16_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x22,0xd1,0x7c,0x04,0x02,0x00]

v_mul_f16_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x22,0xd1,0x7e,0x04,0x02,0x00]

v_mul_f16_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x22,0xd1,0x7f,0x04,0x02,0x00]

v_mul_f16_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x22,0xd1,0x80,0x04,0x02,0x00]

v_mul_f16_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x22,0xd1,0xc1,0x04,0x02,0x00]

v_mul_f16_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x22,0xd1,0xf0,0x04,0x02,0x00]

v_mul_f16_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x22,0xd1,0xf7,0x04,0x02,0x00]

v_mul_f16_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x22,0xd1,0xfb,0x04,0x02,0x00]

v_mul_f16_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x22,0xd1,0xfc,0x04,0x02,0x00]

v_mul_f16_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x22,0xd1,0xfd,0x04,0x02,0x00]

v_mul_f16_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x22,0xd1,0xfe,0x04,0x02,0x00]

v_mul_f16_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x22,0xd1,0x01,0xff,0x03,0x00]

v_mul_f16_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x22,0xd1,0x01,0x05,0x00,0x00]

v_mul_f16_e64 v5, v1, s101
// CHECK: [0x05,0x00,0x22,0xd1,0x01,0xcb,0x00,0x00]

v_mul_f16_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x22,0xd1,0x01,0xcd,0x00,0x00]

v_mul_f16_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x22,0xd1,0x01,0xcf,0x00,0x00]

v_mul_f16_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x22,0xd1,0x01,0xd5,0x00,0x00]

v_mul_f16_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x22,0xd1,0x01,0xd7,0x00,0x00]

v_mul_f16_e64 v5, v1, ttmp15
// CHECK: [0x05,0x00,0x22,0xd1,0x01,0xf7,0x00,0x00]

v_mul_f16_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x22,0xd1,0x01,0xf9,0x00,0x00]

v_mul_f16_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x22,0xd1,0x01,0xfd,0x00,0x00]

v_mul_f16_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x22,0xd1,0x01,0xff,0x00,0x00]

v_mul_f16_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x22,0xd1,0x01,0x01,0x01,0x00]

v_mul_f16_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x22,0xd1,0x01,0x83,0x01,0x00]

v_mul_f16_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x22,0xd1,0x01,0xe1,0x01,0x00]

v_mul_f16_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x22,0xd1,0x01,0xef,0x01,0x00]

v_mul_f16_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x22,0xd1,0x01,0xf7,0x01,0x00]

v_mul_f16_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x22,0xd1,0x01,0xf9,0x01,0x00]

v_mul_f16_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x22,0xd1,0x01,0xfb,0x01,0x00]

v_mul_f16_e64 v5, -v1, v2
// CHECK: [0x05,0x00,0x22,0xd1,0x01,0x05,0x02,0x20]

v_mul_f16_e64 v5, v1, -v2
// CHECK: [0x05,0x00,0x22,0xd1,0x01,0x05,0x02,0x40]

v_mul_f16_e64 v5, -v1, -v2
// CHECK: [0x05,0x00,0x22,0xd1,0x01,0x05,0x02,0x60]

v_mul_f16_e64 v5, |v1|, v2
// CHECK: [0x05,0x01,0x22,0xd1,0x01,0x05,0x02,0x00]

v_mul_f16_e64 v5, v1, |v2|
// CHECK: [0x05,0x02,0x22,0xd1,0x01,0x05,0x02,0x00]

v_mul_f16_e64 v5, |v1|, |v2|
// CHECK: [0x05,0x03,0x22,0xd1,0x01,0x05,0x02,0x00]

v_mul_f16_e64 v5, v1, v2 clamp
// CHECK: [0x05,0x80,0x22,0xd1,0x01,0x05,0x02,0x00]

v_mac_f16_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x23,0xd1,0x01,0x05,0x02,0x00]

v_mac_f16_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x23,0xd1,0x01,0x05,0x02,0x00]

v_mac_f16_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x23,0xd1,0xff,0x05,0x02,0x00]

v_mac_f16_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x23,0xd1,0x01,0x04,0x02,0x00]

v_mac_f16_e64 v5, s101, v2
// CHECK: [0x05,0x00,0x23,0xd1,0x65,0x04,0x02,0x00]

v_mac_f16_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x23,0xd1,0x66,0x04,0x02,0x00]

v_mac_f16_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x23,0xd1,0x67,0x04,0x02,0x00]

v_mac_f16_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x23,0xd1,0x6a,0x04,0x02,0x00]

v_mac_f16_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x23,0xd1,0x6b,0x04,0x02,0x00]

v_mac_f16_e64 v5, ttmp15, v2
// CHECK: [0x05,0x00,0x23,0xd1,0x7b,0x04,0x02,0x00]

v_mac_f16_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x23,0xd1,0x7c,0x04,0x02,0x00]

v_mac_f16_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x23,0xd1,0x7e,0x04,0x02,0x00]

v_mac_f16_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x23,0xd1,0x7f,0x04,0x02,0x00]

v_mac_f16_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x23,0xd1,0x80,0x04,0x02,0x00]

v_mac_f16_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x23,0xd1,0xc1,0x04,0x02,0x00]

v_mac_f16_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x23,0xd1,0xf0,0x04,0x02,0x00]

v_mac_f16_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x23,0xd1,0xf7,0x04,0x02,0x00]

v_mac_f16_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x23,0xd1,0xfb,0x04,0x02,0x00]

v_mac_f16_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x23,0xd1,0xfc,0x04,0x02,0x00]

v_mac_f16_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x23,0xd1,0xfd,0x04,0x02,0x00]

v_mac_f16_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x23,0xd1,0xfe,0x04,0x02,0x00]

v_mac_f16_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x23,0xd1,0x01,0xff,0x03,0x00]

v_mac_f16_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x23,0xd1,0x01,0x05,0x00,0x00]

v_mac_f16_e64 v5, v1, s101
// CHECK: [0x05,0x00,0x23,0xd1,0x01,0xcb,0x00,0x00]

v_mac_f16_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x23,0xd1,0x01,0xcd,0x00,0x00]

v_mac_f16_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x23,0xd1,0x01,0xcf,0x00,0x00]

v_mac_f16_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x23,0xd1,0x01,0xd5,0x00,0x00]

v_mac_f16_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x23,0xd1,0x01,0xd7,0x00,0x00]

v_mac_f16_e64 v5, v1, ttmp15
// CHECK: [0x05,0x00,0x23,0xd1,0x01,0xf7,0x00,0x00]

v_mac_f16_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x23,0xd1,0x01,0xf9,0x00,0x00]

v_mac_f16_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x23,0xd1,0x01,0xfd,0x00,0x00]

v_mac_f16_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x23,0xd1,0x01,0xff,0x00,0x00]

v_mac_f16_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x23,0xd1,0x01,0x01,0x01,0x00]

v_mac_f16_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x23,0xd1,0x01,0x83,0x01,0x00]

v_mac_f16_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x23,0xd1,0x01,0xe1,0x01,0x00]

v_mac_f16_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x23,0xd1,0x01,0xef,0x01,0x00]

v_mac_f16_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x23,0xd1,0x01,0xf7,0x01,0x00]

v_mac_f16_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x23,0xd1,0x01,0xf9,0x01,0x00]

v_mac_f16_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x23,0xd1,0x01,0xfb,0x01,0x00]

v_mac_f16_e64 v5, -v1, v2
// CHECK: [0x05,0x00,0x23,0xd1,0x01,0x05,0x02,0x20]

v_mac_f16_e64 v5, v1, -v2
// CHECK: [0x05,0x00,0x23,0xd1,0x01,0x05,0x02,0x40]

v_mac_f16_e64 v5, -v1, -v2
// CHECK: [0x05,0x00,0x23,0xd1,0x01,0x05,0x02,0x60]

v_mac_f16_e64 v5, |v1|, v2
// CHECK: [0x05,0x01,0x23,0xd1,0x01,0x05,0x02,0x00]

v_mac_f16_e64 v5, v1, |v2|
// CHECK: [0x05,0x02,0x23,0xd1,0x01,0x05,0x02,0x00]

v_mac_f16_e64 v5, |v1|, |v2|
// CHECK: [0x05,0x03,0x23,0xd1,0x01,0x05,0x02,0x00]

v_mac_f16_e64 v5, v1, v2 clamp
// CHECK: [0x05,0x80,0x23,0xd1,0x01,0x05,0x02,0x00]

v_add_u16_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x26,0xd1,0x01,0x05,0x02,0x00]

v_add_u16_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x26,0xd1,0x01,0x05,0x02,0x00]

v_add_u16_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x26,0xd1,0xff,0x05,0x02,0x00]

v_add_u16_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x26,0xd1,0x01,0x04,0x02,0x00]

v_add_u16_e64 v5, s101, v2
// CHECK: [0x05,0x00,0x26,0xd1,0x65,0x04,0x02,0x00]

v_add_u16_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x26,0xd1,0x66,0x04,0x02,0x00]

v_add_u16_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x26,0xd1,0x67,0x04,0x02,0x00]

v_add_u16_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x26,0xd1,0x6a,0x04,0x02,0x00]

v_add_u16_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x26,0xd1,0x6b,0x04,0x02,0x00]

v_add_u16_e64 v5, ttmp15, v2
// CHECK: [0x05,0x00,0x26,0xd1,0x7b,0x04,0x02,0x00]

v_add_u16_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x26,0xd1,0x7c,0x04,0x02,0x00]

v_add_u16_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x26,0xd1,0x7e,0x04,0x02,0x00]

v_add_u16_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x26,0xd1,0x7f,0x04,0x02,0x00]

v_add_u16_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x26,0xd1,0x80,0x04,0x02,0x00]

v_add_u16_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x26,0xd1,0xc1,0x04,0x02,0x00]

v_add_u16_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x26,0xd1,0xfb,0x04,0x02,0x00]

v_add_u16_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x26,0xd1,0xfc,0x04,0x02,0x00]

v_add_u16_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x26,0xd1,0xfd,0x04,0x02,0x00]

v_add_u16_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x26,0xd1,0xfe,0x04,0x02,0x00]

v_add_u16_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x26,0xd1,0x01,0xff,0x03,0x00]

v_add_u16_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x26,0xd1,0x01,0x05,0x00,0x00]

v_add_u16_e64 v5, v1, s101
// CHECK: [0x05,0x00,0x26,0xd1,0x01,0xcb,0x00,0x00]

v_add_u16_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x26,0xd1,0x01,0xcd,0x00,0x00]

v_add_u16_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x26,0xd1,0x01,0xcf,0x00,0x00]

v_add_u16_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x26,0xd1,0x01,0xd5,0x00,0x00]

v_add_u16_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x26,0xd1,0x01,0xd7,0x00,0x00]

v_add_u16_e64 v5, v1, ttmp15
// CHECK: [0x05,0x00,0x26,0xd1,0x01,0xf7,0x00,0x00]

v_add_u16_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x26,0xd1,0x01,0xf9,0x00,0x00]

v_add_u16_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x26,0xd1,0x01,0xfd,0x00,0x00]

v_add_u16_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x26,0xd1,0x01,0xff,0x00,0x00]

v_add_u16_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x26,0xd1,0x01,0x01,0x01,0x00]

v_add_u16_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x26,0xd1,0x01,0x83,0x01,0x00]

v_add_u16_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x26,0xd1,0x01,0xf7,0x01,0x00]

v_add_u16_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x26,0xd1,0x01,0xf9,0x01,0x00]

v_add_u16_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x26,0xd1,0x01,0xfb,0x01,0x00]

v_add_u16_e64 v5, v1, v2 clamp
// CHECK: [0x05,0x80,0x26,0xd1,0x01,0x05,0x02,0x00]

v_sub_u16_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x27,0xd1,0x01,0x05,0x02,0x00]

v_sub_u16_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x27,0xd1,0x01,0x05,0x02,0x00]

v_sub_u16_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x27,0xd1,0xff,0x05,0x02,0x00]

v_sub_u16_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x27,0xd1,0x01,0x04,0x02,0x00]

v_sub_u16_e64 v5, s101, v2
// CHECK: [0x05,0x00,0x27,0xd1,0x65,0x04,0x02,0x00]

v_sub_u16_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x27,0xd1,0x66,0x04,0x02,0x00]

v_sub_u16_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x27,0xd1,0x67,0x04,0x02,0x00]

v_sub_u16_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x27,0xd1,0x6a,0x04,0x02,0x00]

v_sub_u16_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x27,0xd1,0x6b,0x04,0x02,0x00]

v_sub_u16_e64 v5, ttmp15, v2
// CHECK: [0x05,0x00,0x27,0xd1,0x7b,0x04,0x02,0x00]

v_sub_u16_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x27,0xd1,0x7c,0x04,0x02,0x00]

v_sub_u16_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x27,0xd1,0x7e,0x04,0x02,0x00]

v_sub_u16_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x27,0xd1,0x7f,0x04,0x02,0x00]

v_sub_u16_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x27,0xd1,0x80,0x04,0x02,0x00]

v_sub_u16_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x27,0xd1,0xc1,0x04,0x02,0x00]

v_sub_u16_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x27,0xd1,0xfb,0x04,0x02,0x00]

v_sub_u16_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x27,0xd1,0xfc,0x04,0x02,0x00]

v_sub_u16_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x27,0xd1,0xfd,0x04,0x02,0x00]

v_sub_u16_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x27,0xd1,0xfe,0x04,0x02,0x00]

v_sub_u16_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x27,0xd1,0x01,0xff,0x03,0x00]

v_sub_u16_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x27,0xd1,0x01,0x05,0x00,0x00]

v_sub_u16_e64 v5, v1, s101
// CHECK: [0x05,0x00,0x27,0xd1,0x01,0xcb,0x00,0x00]

v_sub_u16_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x27,0xd1,0x01,0xcd,0x00,0x00]

v_sub_u16_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x27,0xd1,0x01,0xcf,0x00,0x00]

v_sub_u16_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x27,0xd1,0x01,0xd5,0x00,0x00]

v_sub_u16_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x27,0xd1,0x01,0xd7,0x00,0x00]

v_sub_u16_e64 v5, v1, ttmp15
// CHECK: [0x05,0x00,0x27,0xd1,0x01,0xf7,0x00,0x00]

v_sub_u16_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x27,0xd1,0x01,0xf9,0x00,0x00]

v_sub_u16_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x27,0xd1,0x01,0xfd,0x00,0x00]

v_sub_u16_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x27,0xd1,0x01,0xff,0x00,0x00]

v_sub_u16_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x27,0xd1,0x01,0x01,0x01,0x00]

v_sub_u16_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x27,0xd1,0x01,0x83,0x01,0x00]

v_sub_u16_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x27,0xd1,0x01,0xf7,0x01,0x00]

v_sub_u16_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x27,0xd1,0x01,0xf9,0x01,0x00]

v_sub_u16_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x27,0xd1,0x01,0xfb,0x01,0x00]

v_sub_u16_e64 v5, v1, v2 clamp
// CHECK: [0x05,0x80,0x27,0xd1,0x01,0x05,0x02,0x00]

v_subrev_u16_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x28,0xd1,0x01,0x05,0x02,0x00]

v_subrev_u16_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x28,0xd1,0x01,0x05,0x02,0x00]

v_subrev_u16_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x28,0xd1,0xff,0x05,0x02,0x00]

v_subrev_u16_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x28,0xd1,0x01,0x04,0x02,0x00]

v_subrev_u16_e64 v5, s101, v2
// CHECK: [0x05,0x00,0x28,0xd1,0x65,0x04,0x02,0x00]

v_subrev_u16_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x28,0xd1,0x66,0x04,0x02,0x00]

v_subrev_u16_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x28,0xd1,0x67,0x04,0x02,0x00]

v_subrev_u16_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x28,0xd1,0x6a,0x04,0x02,0x00]

v_subrev_u16_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x28,0xd1,0x6b,0x04,0x02,0x00]

v_subrev_u16_e64 v5, ttmp15, v2
// CHECK: [0x05,0x00,0x28,0xd1,0x7b,0x04,0x02,0x00]

v_subrev_u16_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x28,0xd1,0x7c,0x04,0x02,0x00]

v_subrev_u16_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x28,0xd1,0x7e,0x04,0x02,0x00]

v_subrev_u16_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x28,0xd1,0x7f,0x04,0x02,0x00]

v_subrev_u16_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x28,0xd1,0x80,0x04,0x02,0x00]

v_subrev_u16_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x28,0xd1,0xc1,0x04,0x02,0x00]

v_subrev_u16_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x28,0xd1,0xfb,0x04,0x02,0x00]

v_subrev_u16_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x28,0xd1,0xfc,0x04,0x02,0x00]

v_subrev_u16_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x28,0xd1,0xfd,0x04,0x02,0x00]

v_subrev_u16_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x28,0xd1,0x01,0xff,0x03,0x00]

v_subrev_u16_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x28,0xd1,0x01,0x05,0x00,0x00]

v_subrev_u16_e64 v5, v1, s101
// CHECK: [0x05,0x00,0x28,0xd1,0x01,0xcb,0x00,0x00]

v_subrev_u16_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x28,0xd1,0x01,0xcd,0x00,0x00]

v_subrev_u16_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x28,0xd1,0x01,0xcf,0x00,0x00]

v_subrev_u16_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x28,0xd1,0x01,0xd5,0x00,0x00]

v_subrev_u16_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x28,0xd1,0x01,0xd7,0x00,0x00]

v_subrev_u16_e64 v5, v1, ttmp15
// CHECK: [0x05,0x00,0x28,0xd1,0x01,0xf7,0x00,0x00]

v_subrev_u16_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x28,0xd1,0x01,0xf9,0x00,0x00]

v_subrev_u16_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x28,0xd1,0x01,0xfd,0x00,0x00]

v_subrev_u16_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x28,0xd1,0x01,0xff,0x00,0x00]

v_subrev_u16_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x28,0xd1,0x01,0x01,0x01,0x00]

v_subrev_u16_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x28,0xd1,0x01,0x83,0x01,0x00]

v_subrev_u16_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x28,0xd1,0x01,0xf7,0x01,0x00]

v_subrev_u16_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x28,0xd1,0x01,0xf9,0x01,0x00]

v_subrev_u16_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x28,0xd1,0x01,0xfb,0x01,0x00]

v_subrev_u16_e64 v5, v1, v2 clamp
// CHECK: [0x05,0x80,0x28,0xd1,0x01,0x05,0x02,0x00]

v_mul_lo_u16_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x29,0xd1,0x01,0x05,0x02,0x00]

v_mul_lo_u16_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x29,0xd1,0x01,0x05,0x02,0x00]

v_mul_lo_u16_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x29,0xd1,0xff,0x05,0x02,0x00]

v_mul_lo_u16_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x29,0xd1,0x01,0x04,0x02,0x00]

v_mul_lo_u16_e64 v5, s101, v2
// CHECK: [0x05,0x00,0x29,0xd1,0x65,0x04,0x02,0x00]

v_mul_lo_u16_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x29,0xd1,0x66,0x04,0x02,0x00]

v_mul_lo_u16_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x29,0xd1,0x67,0x04,0x02,0x00]

v_mul_lo_u16_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x29,0xd1,0x6a,0x04,0x02,0x00]

v_mul_lo_u16_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x29,0xd1,0x6b,0x04,0x02,0x00]

v_mul_lo_u16_e64 v5, ttmp15, v2
// CHECK: [0x05,0x00,0x29,0xd1,0x7b,0x04,0x02,0x00]

v_mul_lo_u16_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x29,0xd1,0x7c,0x04,0x02,0x00]

v_mul_lo_u16_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x29,0xd1,0x7e,0x04,0x02,0x00]

v_mul_lo_u16_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x29,0xd1,0x7f,0x04,0x02,0x00]

v_mul_lo_u16_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x29,0xd1,0x80,0x04,0x02,0x00]

v_mul_lo_u16_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x29,0xd1,0xc1,0x04,0x02,0x00]

v_mul_lo_u16_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x29,0xd1,0xfb,0x04,0x02,0x00]

v_mul_lo_u16_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x29,0xd1,0xfc,0x04,0x02,0x00]

v_mul_lo_u16_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x29,0xd1,0xfd,0x04,0x02,0x00]

v_mul_lo_u16_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x29,0xd1,0xfe,0x04,0x02,0x00]

v_mul_lo_u16_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x29,0xd1,0x01,0xff,0x03,0x00]

v_mul_lo_u16_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x29,0xd1,0x01,0x05,0x00,0x00]

v_mul_lo_u16_e64 v5, v1, s101
// CHECK: [0x05,0x00,0x29,0xd1,0x01,0xcb,0x00,0x00]

v_mul_lo_u16_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x29,0xd1,0x01,0xcd,0x00,0x00]

v_mul_lo_u16_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x29,0xd1,0x01,0xcf,0x00,0x00]

v_mul_lo_u16_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x29,0xd1,0x01,0xd5,0x00,0x00]

v_mul_lo_u16_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x29,0xd1,0x01,0xd7,0x00,0x00]

v_mul_lo_u16_e64 v5, v1, ttmp15
// CHECK: [0x05,0x00,0x29,0xd1,0x01,0xf7,0x00,0x00]

v_mul_lo_u16_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x29,0xd1,0x01,0xf9,0x00,0x00]

v_mul_lo_u16_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x29,0xd1,0x01,0xfd,0x00,0x00]

v_mul_lo_u16_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x29,0xd1,0x01,0xff,0x00,0x00]

v_mul_lo_u16_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x29,0xd1,0x01,0x01,0x01,0x00]

v_mul_lo_u16_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x29,0xd1,0x01,0x83,0x01,0x00]

v_mul_lo_u16_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x29,0xd1,0x01,0xf7,0x01,0x00]

v_mul_lo_u16_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x29,0xd1,0x01,0xf9,0x01,0x00]

v_mul_lo_u16_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x29,0xd1,0x01,0xfb,0x01,0x00]

v_lshlrev_b16_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x2a,0xd1,0x01,0x05,0x02,0x00]

v_lshlrev_b16_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x2a,0xd1,0x01,0x05,0x02,0x00]

v_lshlrev_b16_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x2a,0xd1,0xff,0x05,0x02,0x00]

v_lshlrev_b16_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x2a,0xd1,0x01,0x04,0x02,0x00]

v_lshlrev_b16_e64 v5, s101, v2
// CHECK: [0x05,0x00,0x2a,0xd1,0x65,0x04,0x02,0x00]

v_lshlrev_b16_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x2a,0xd1,0x66,0x04,0x02,0x00]

v_lshlrev_b16_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x2a,0xd1,0x67,0x04,0x02,0x00]

v_lshlrev_b16_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x2a,0xd1,0x6a,0x04,0x02,0x00]

v_lshlrev_b16_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x2a,0xd1,0x6b,0x04,0x02,0x00]

v_lshlrev_b16_e64 v5, ttmp15, v2
// CHECK: [0x05,0x00,0x2a,0xd1,0x7b,0x04,0x02,0x00]

v_lshlrev_b16_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x2a,0xd1,0x7c,0x04,0x02,0x00]

v_lshlrev_b16_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x2a,0xd1,0x7e,0x04,0x02,0x00]

v_lshlrev_b16_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x2a,0xd1,0x7f,0x04,0x02,0x00]

v_lshlrev_b16_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x2a,0xd1,0x80,0x04,0x02,0x00]

v_lshlrev_b16_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x2a,0xd1,0xc1,0x04,0x02,0x00]

v_lshlrev_b16_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x2a,0xd1,0xfb,0x04,0x02,0x00]

v_lshlrev_b16_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x2a,0xd1,0xfc,0x04,0x02,0x00]

v_lshlrev_b16_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x2a,0xd1,0xfd,0x04,0x02,0x00]

v_lshlrev_b16_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x2a,0xd1,0x01,0xff,0x03,0x00]

v_lshlrev_b16_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x2a,0xd1,0x01,0x05,0x00,0x00]

v_lshlrev_b16_e64 v5, v1, s101
// CHECK: [0x05,0x00,0x2a,0xd1,0x01,0xcb,0x00,0x00]

v_lshlrev_b16_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x2a,0xd1,0x01,0xcd,0x00,0x00]

v_lshlrev_b16_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x2a,0xd1,0x01,0xcf,0x00,0x00]

v_lshlrev_b16_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x2a,0xd1,0x01,0xd5,0x00,0x00]

v_lshlrev_b16_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x2a,0xd1,0x01,0xd7,0x00,0x00]

v_lshlrev_b16_e64 v5, v1, ttmp15
// CHECK: [0x05,0x00,0x2a,0xd1,0x01,0xf7,0x00,0x00]

v_lshlrev_b16_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x2a,0xd1,0x01,0xf9,0x00,0x00]

v_lshlrev_b16_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x2a,0xd1,0x01,0xfd,0x00,0x00]

v_lshlrev_b16_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x2a,0xd1,0x01,0xff,0x00,0x00]

v_lshlrev_b16_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x2a,0xd1,0x01,0x01,0x01,0x00]

v_lshlrev_b16_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x2a,0xd1,0x01,0x83,0x01,0x00]

v_lshlrev_b16_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x2a,0xd1,0x01,0xf7,0x01,0x00]

v_lshlrev_b16_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x2a,0xd1,0x01,0xf9,0x01,0x00]

v_lshlrev_b16_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x2a,0xd1,0x01,0xfb,0x01,0x00]

v_lshrrev_b16_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x2b,0xd1,0x01,0x05,0x02,0x00]

v_lshrrev_b16_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x2b,0xd1,0x01,0x05,0x02,0x00]

v_lshrrev_b16_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x2b,0xd1,0xff,0x05,0x02,0x00]

v_lshrrev_b16_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x2b,0xd1,0x01,0x04,0x02,0x00]

v_lshrrev_b16_e64 v5, s101, v2
// CHECK: [0x05,0x00,0x2b,0xd1,0x65,0x04,0x02,0x00]

v_lshrrev_b16_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x2b,0xd1,0x66,0x04,0x02,0x00]

v_lshrrev_b16_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x2b,0xd1,0x67,0x04,0x02,0x00]

v_lshrrev_b16_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x2b,0xd1,0x6a,0x04,0x02,0x00]

v_lshrrev_b16_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x2b,0xd1,0x6b,0x04,0x02,0x00]

v_lshrrev_b16_e64 v5, ttmp15, v2
// CHECK: [0x05,0x00,0x2b,0xd1,0x7b,0x04,0x02,0x00]

v_lshrrev_b16_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x2b,0xd1,0x7c,0x04,0x02,0x00]

v_lshrrev_b16_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x2b,0xd1,0x7e,0x04,0x02,0x00]

v_lshrrev_b16_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x2b,0xd1,0x7f,0x04,0x02,0x00]

v_lshrrev_b16_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x2b,0xd1,0x80,0x04,0x02,0x00]

v_lshrrev_b16_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x2b,0xd1,0xc1,0x04,0x02,0x00]

v_lshrrev_b16_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x2b,0xd1,0xfb,0x04,0x02,0x00]

v_lshrrev_b16_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x2b,0xd1,0xfc,0x04,0x02,0x00]

v_lshrrev_b16_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x2b,0xd1,0xfd,0x04,0x02,0x00]

v_lshrrev_b16_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x2b,0xd1,0x01,0xff,0x03,0x00]

v_lshrrev_b16_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x2b,0xd1,0x01,0x05,0x00,0x00]

v_lshrrev_b16_e64 v5, v1, s101
// CHECK: [0x05,0x00,0x2b,0xd1,0x01,0xcb,0x00,0x00]

v_lshrrev_b16_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x2b,0xd1,0x01,0xcd,0x00,0x00]

v_lshrrev_b16_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x2b,0xd1,0x01,0xcf,0x00,0x00]

v_lshrrev_b16_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x2b,0xd1,0x01,0xd5,0x00,0x00]

v_lshrrev_b16_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x2b,0xd1,0x01,0xd7,0x00,0x00]

v_lshrrev_b16_e64 v5, v1, ttmp15
// CHECK: [0x05,0x00,0x2b,0xd1,0x01,0xf7,0x00,0x00]

v_lshrrev_b16_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x2b,0xd1,0x01,0xf9,0x00,0x00]

v_lshrrev_b16_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x2b,0xd1,0x01,0xfd,0x00,0x00]

v_lshrrev_b16_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x2b,0xd1,0x01,0xff,0x00,0x00]

v_lshrrev_b16_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x2b,0xd1,0x01,0x01,0x01,0x00]

v_lshrrev_b16_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x2b,0xd1,0x01,0x83,0x01,0x00]

v_lshrrev_b16_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x2b,0xd1,0x01,0xf7,0x01,0x00]

v_lshrrev_b16_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x2b,0xd1,0x01,0xf9,0x01,0x00]

v_lshrrev_b16_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x2b,0xd1,0x01,0xfb,0x01,0x00]

v_ashrrev_i16_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x2c,0xd1,0x01,0x05,0x02,0x00]

v_ashrrev_i16_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x2c,0xd1,0x01,0x05,0x02,0x00]

v_ashrrev_i16_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x2c,0xd1,0xff,0x05,0x02,0x00]

v_ashrrev_i16_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x2c,0xd1,0x01,0x04,0x02,0x00]

v_ashrrev_i16_e64 v5, s101, v2
// CHECK: [0x05,0x00,0x2c,0xd1,0x65,0x04,0x02,0x00]

v_ashrrev_i16_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x2c,0xd1,0x66,0x04,0x02,0x00]

v_ashrrev_i16_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x2c,0xd1,0x67,0x04,0x02,0x00]

v_ashrrev_i16_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x2c,0xd1,0x6a,0x04,0x02,0x00]

v_ashrrev_i16_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x2c,0xd1,0x6b,0x04,0x02,0x00]

v_ashrrev_i16_e64 v5, ttmp15, v2
// CHECK: [0x05,0x00,0x2c,0xd1,0x7b,0x04,0x02,0x00]

v_ashrrev_i16_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x2c,0xd1,0x7c,0x04,0x02,0x00]

v_ashrrev_i16_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x2c,0xd1,0x7e,0x04,0x02,0x00]

v_ashrrev_i16_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x2c,0xd1,0x7f,0x04,0x02,0x00]

v_ashrrev_i16_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x2c,0xd1,0x80,0x04,0x02,0x00]

v_ashrrev_i16_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x2c,0xd1,0xc1,0x04,0x02,0x00]

v_ashrrev_i16_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x2c,0xd1,0xfb,0x04,0x02,0x00]

v_ashrrev_i16_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x2c,0xd1,0xfc,0x04,0x02,0x00]

v_ashrrev_i16_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x2c,0xd1,0xfd,0x04,0x02,0x00]

v_ashrrev_i16_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x2c,0xd1,0x01,0xff,0x03,0x00]

v_ashrrev_i16_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x2c,0xd1,0x01,0x05,0x00,0x00]

v_ashrrev_i16_e64 v5, v1, s101
// CHECK: [0x05,0x00,0x2c,0xd1,0x01,0xcb,0x00,0x00]

v_ashrrev_i16_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x2c,0xd1,0x01,0xcd,0x00,0x00]

v_ashrrev_i16_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x2c,0xd1,0x01,0xcf,0x00,0x00]

v_ashrrev_i16_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x2c,0xd1,0x01,0xd5,0x00,0x00]

v_ashrrev_i16_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x2c,0xd1,0x01,0xd7,0x00,0x00]

v_ashrrev_i16_e64 v5, v1, ttmp15
// CHECK: [0x05,0x00,0x2c,0xd1,0x01,0xf7,0x00,0x00]

v_ashrrev_i16_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x2c,0xd1,0x01,0xf9,0x00,0x00]

v_ashrrev_i16_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x2c,0xd1,0x01,0xfd,0x00,0x00]

v_ashrrev_i16_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x2c,0xd1,0x01,0xff,0x00,0x00]

v_ashrrev_i16_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x2c,0xd1,0x01,0x01,0x01,0x00]

v_ashrrev_i16_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x2c,0xd1,0x01,0x83,0x01,0x00]

v_ashrrev_i16_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x2c,0xd1,0x01,0xf7,0x01,0x00]

v_ashrrev_i16_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x2c,0xd1,0x01,0xf9,0x01,0x00]

v_ashrrev_i16_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x2c,0xd1,0x01,0xfb,0x01,0x00]

v_max_f16_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x2d,0xd1,0x01,0x05,0x02,0x00]

v_max_f16_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x2d,0xd1,0x01,0x05,0x02,0x00]

v_max_f16_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x2d,0xd1,0xff,0x05,0x02,0x00]

v_max_f16_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x2d,0xd1,0x01,0x04,0x02,0x00]

v_max_f16_e64 v5, s101, v2
// CHECK: [0x05,0x00,0x2d,0xd1,0x65,0x04,0x02,0x00]

v_max_f16_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x2d,0xd1,0x66,0x04,0x02,0x00]

v_max_f16_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x2d,0xd1,0x67,0x04,0x02,0x00]

v_max_f16_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x2d,0xd1,0x6a,0x04,0x02,0x00]

v_max_f16_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x2d,0xd1,0x6b,0x04,0x02,0x00]

v_max_f16_e64 v5, ttmp15, v2
// CHECK: [0x05,0x00,0x2d,0xd1,0x7b,0x04,0x02,0x00]

v_max_f16_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x2d,0xd1,0x7c,0x04,0x02,0x00]

v_max_f16_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x2d,0xd1,0x7e,0x04,0x02,0x00]

v_max_f16_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x2d,0xd1,0x7f,0x04,0x02,0x00]

v_max_f16_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x2d,0xd1,0x80,0x04,0x02,0x00]

v_max_f16_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x2d,0xd1,0xc1,0x04,0x02,0x00]

v_max_f16_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x2d,0xd1,0xf0,0x04,0x02,0x00]

v_max_f16_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x2d,0xd1,0xf7,0x04,0x02,0x00]

v_max_f16_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x2d,0xd1,0xfb,0x04,0x02,0x00]

v_max_f16_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x2d,0xd1,0xfc,0x04,0x02,0x00]

v_max_f16_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x2d,0xd1,0xfd,0x04,0x02,0x00]

v_max_f16_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x2d,0xd1,0xfe,0x04,0x02,0x00]

v_max_f16_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x2d,0xd1,0x01,0xff,0x03,0x00]

v_max_f16_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x2d,0xd1,0x01,0x05,0x00,0x00]

v_max_f16_e64 v5, v1, s101
// CHECK: [0x05,0x00,0x2d,0xd1,0x01,0xcb,0x00,0x00]

v_max_f16_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x2d,0xd1,0x01,0xcd,0x00,0x00]

v_max_f16_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x2d,0xd1,0x01,0xcf,0x00,0x00]

v_max_f16_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x2d,0xd1,0x01,0xd5,0x00,0x00]

v_max_f16_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x2d,0xd1,0x01,0xd7,0x00,0x00]

v_max_f16_e64 v5, v1, ttmp15
// CHECK: [0x05,0x00,0x2d,0xd1,0x01,0xf7,0x00,0x00]

v_max_f16_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x2d,0xd1,0x01,0xf9,0x00,0x00]

v_max_f16_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x2d,0xd1,0x01,0xfd,0x00,0x00]

v_max_f16_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x2d,0xd1,0x01,0xff,0x00,0x00]

v_max_f16_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x2d,0xd1,0x01,0x01,0x01,0x00]

v_max_f16_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x2d,0xd1,0x01,0x83,0x01,0x00]

v_max_f16_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x2d,0xd1,0x01,0xe1,0x01,0x00]

v_max_f16_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x2d,0xd1,0x01,0xef,0x01,0x00]

v_max_f16_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x2d,0xd1,0x01,0xf7,0x01,0x00]

v_max_f16_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x2d,0xd1,0x01,0xf9,0x01,0x00]

v_max_f16_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x2d,0xd1,0x01,0xfb,0x01,0x00]

v_max_f16_e64 v5, -v1, v2
// CHECK: [0x05,0x00,0x2d,0xd1,0x01,0x05,0x02,0x20]

v_max_f16_e64 v5, v1, -v2
// CHECK: [0x05,0x00,0x2d,0xd1,0x01,0x05,0x02,0x40]

v_max_f16_e64 v5, -v1, -v2
// CHECK: [0x05,0x00,0x2d,0xd1,0x01,0x05,0x02,0x60]

v_max_f16_e64 v5, |v1|, v2
// CHECK: [0x05,0x01,0x2d,0xd1,0x01,0x05,0x02,0x00]

v_max_f16_e64 v5, v1, |v2|
// CHECK: [0x05,0x02,0x2d,0xd1,0x01,0x05,0x02,0x00]

v_max_f16_e64 v5, |v1|, |v2|
// CHECK: [0x05,0x03,0x2d,0xd1,0x01,0x05,0x02,0x00]

v_max_f16_e64 v5, v1, v2 clamp
// CHECK: [0x05,0x80,0x2d,0xd1,0x01,0x05,0x02,0x00]

v_min_f16_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x2e,0xd1,0x01,0x05,0x02,0x00]

v_min_f16_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x2e,0xd1,0x01,0x05,0x02,0x00]

v_min_f16_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x2e,0xd1,0xff,0x05,0x02,0x00]

v_min_f16_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x2e,0xd1,0x01,0x04,0x02,0x00]

v_min_f16_e64 v5, s101, v2
// CHECK: [0x05,0x00,0x2e,0xd1,0x65,0x04,0x02,0x00]

v_min_f16_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x2e,0xd1,0x66,0x04,0x02,0x00]

v_min_f16_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x2e,0xd1,0x67,0x04,0x02,0x00]

v_min_f16_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x2e,0xd1,0x6a,0x04,0x02,0x00]

v_min_f16_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x2e,0xd1,0x6b,0x04,0x02,0x00]

v_min_f16_e64 v5, ttmp15, v2
// CHECK: [0x05,0x00,0x2e,0xd1,0x7b,0x04,0x02,0x00]

v_min_f16_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x2e,0xd1,0x7c,0x04,0x02,0x00]

v_min_f16_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x2e,0xd1,0x7e,0x04,0x02,0x00]

v_min_f16_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x2e,0xd1,0x7f,0x04,0x02,0x00]

v_min_f16_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x2e,0xd1,0x80,0x04,0x02,0x00]

v_min_f16_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x2e,0xd1,0xc1,0x04,0x02,0x00]

v_min_f16_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x2e,0xd1,0xf0,0x04,0x02,0x00]

v_min_f16_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x2e,0xd1,0xf7,0x04,0x02,0x00]

v_min_f16_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x2e,0xd1,0xfb,0x04,0x02,0x00]

v_min_f16_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x2e,0xd1,0xfc,0x04,0x02,0x00]

v_min_f16_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x2e,0xd1,0xfd,0x04,0x02,0x00]

v_min_f16_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x2e,0xd1,0xfe,0x04,0x02,0x00]

v_min_f16_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x2e,0xd1,0x01,0xff,0x03,0x00]

v_min_f16_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x2e,0xd1,0x01,0x05,0x00,0x00]

v_min_f16_e64 v5, v1, s101
// CHECK: [0x05,0x00,0x2e,0xd1,0x01,0xcb,0x00,0x00]

v_min_f16_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x2e,0xd1,0x01,0xcd,0x00,0x00]

v_min_f16_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x2e,0xd1,0x01,0xcf,0x00,0x00]

v_min_f16_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x2e,0xd1,0x01,0xd5,0x00,0x00]

v_min_f16_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x2e,0xd1,0x01,0xd7,0x00,0x00]

v_min_f16_e64 v5, v1, ttmp15
// CHECK: [0x05,0x00,0x2e,0xd1,0x01,0xf7,0x00,0x00]

v_min_f16_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x2e,0xd1,0x01,0xf9,0x00,0x00]

v_min_f16_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x2e,0xd1,0x01,0xfd,0x00,0x00]

v_min_f16_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x2e,0xd1,0x01,0xff,0x00,0x00]

v_min_f16_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x2e,0xd1,0x01,0x01,0x01,0x00]

v_min_f16_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x2e,0xd1,0x01,0x83,0x01,0x00]

v_min_f16_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x2e,0xd1,0x01,0xe1,0x01,0x00]

v_min_f16_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x2e,0xd1,0x01,0xef,0x01,0x00]

v_min_f16_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x2e,0xd1,0x01,0xf7,0x01,0x00]

v_min_f16_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x2e,0xd1,0x01,0xf9,0x01,0x00]

v_min_f16_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x2e,0xd1,0x01,0xfb,0x01,0x00]

v_min_f16_e64 v5, -v1, v2
// CHECK: [0x05,0x00,0x2e,0xd1,0x01,0x05,0x02,0x20]

v_min_f16_e64 v5, v1, -v2
// CHECK: [0x05,0x00,0x2e,0xd1,0x01,0x05,0x02,0x40]

v_min_f16_e64 v5, -v1, -v2
// CHECK: [0x05,0x00,0x2e,0xd1,0x01,0x05,0x02,0x60]

v_min_f16_e64 v5, |v1|, v2
// CHECK: [0x05,0x01,0x2e,0xd1,0x01,0x05,0x02,0x00]

v_min_f16_e64 v5, v1, |v2|
// CHECK: [0x05,0x02,0x2e,0xd1,0x01,0x05,0x02,0x00]

v_min_f16_e64 v5, |v1|, |v2|
// CHECK: [0x05,0x03,0x2e,0xd1,0x01,0x05,0x02,0x00]

v_min_f16_e64 v5, v1, v2 clamp
// CHECK: [0x05,0x80,0x2e,0xd1,0x01,0x05,0x02,0x00]

v_max_u16_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x2f,0xd1,0x01,0x05,0x02,0x00]

v_max_u16_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x2f,0xd1,0x01,0x05,0x02,0x00]

v_max_u16_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x2f,0xd1,0xff,0x05,0x02,0x00]

v_max_u16_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x2f,0xd1,0x01,0x04,0x02,0x00]

v_max_u16_e64 v5, s101, v2
// CHECK: [0x05,0x00,0x2f,0xd1,0x65,0x04,0x02,0x00]

v_max_u16_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x2f,0xd1,0x66,0x04,0x02,0x00]

v_max_u16_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x2f,0xd1,0x67,0x04,0x02,0x00]

v_max_u16_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x2f,0xd1,0x6a,0x04,0x02,0x00]

v_max_u16_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x2f,0xd1,0x6b,0x04,0x02,0x00]

v_max_u16_e64 v5, ttmp15, v2
// CHECK: [0x05,0x00,0x2f,0xd1,0x7b,0x04,0x02,0x00]

v_max_u16_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x2f,0xd1,0x7c,0x04,0x02,0x00]

v_max_u16_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x2f,0xd1,0x7e,0x04,0x02,0x00]

v_max_u16_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x2f,0xd1,0x7f,0x04,0x02,0x00]

v_max_u16_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x2f,0xd1,0x80,0x04,0x02,0x00]

v_max_u16_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x2f,0xd1,0xc1,0x04,0x02,0x00]

v_max_u16_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x2f,0xd1,0xfb,0x04,0x02,0x00]

v_max_u16_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x2f,0xd1,0xfc,0x04,0x02,0x00]

v_max_u16_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x2f,0xd1,0xfd,0x04,0x02,0x00]

v_max_u16_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x2f,0xd1,0xfe,0x04,0x02,0x00]

v_max_u16_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x2f,0xd1,0x01,0xff,0x03,0x00]

v_max_u16_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x2f,0xd1,0x01,0x05,0x00,0x00]

v_max_u16_e64 v5, v1, s101
// CHECK: [0x05,0x00,0x2f,0xd1,0x01,0xcb,0x00,0x00]

v_max_u16_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x2f,0xd1,0x01,0xcd,0x00,0x00]

v_max_u16_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x2f,0xd1,0x01,0xcf,0x00,0x00]

v_max_u16_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x2f,0xd1,0x01,0xd5,0x00,0x00]

v_max_u16_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x2f,0xd1,0x01,0xd7,0x00,0x00]

v_max_u16_e64 v5, v1, ttmp15
// CHECK: [0x05,0x00,0x2f,0xd1,0x01,0xf7,0x00,0x00]

v_max_u16_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x2f,0xd1,0x01,0xf9,0x00,0x00]

v_max_u16_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x2f,0xd1,0x01,0xfd,0x00,0x00]

v_max_u16_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x2f,0xd1,0x01,0xff,0x00,0x00]

v_max_u16_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x2f,0xd1,0x01,0x01,0x01,0x00]

v_max_u16_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x2f,0xd1,0x01,0x83,0x01,0x00]

v_max_u16_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x2f,0xd1,0x01,0xf7,0x01,0x00]

v_max_u16_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x2f,0xd1,0x01,0xf9,0x01,0x00]

v_max_u16_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x2f,0xd1,0x01,0xfb,0x01,0x00]

v_max_i16_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x30,0xd1,0x01,0x05,0x02,0x00]

v_max_i16_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x30,0xd1,0x01,0x05,0x02,0x00]

v_max_i16_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x30,0xd1,0xff,0x05,0x02,0x00]

v_max_i16_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x30,0xd1,0x01,0x04,0x02,0x00]

v_max_i16_e64 v5, s101, v2
// CHECK: [0x05,0x00,0x30,0xd1,0x65,0x04,0x02,0x00]

v_max_i16_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x30,0xd1,0x66,0x04,0x02,0x00]

v_max_i16_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x30,0xd1,0x67,0x04,0x02,0x00]

v_max_i16_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x30,0xd1,0x6a,0x04,0x02,0x00]

v_max_i16_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x30,0xd1,0x6b,0x04,0x02,0x00]

v_max_i16_e64 v5, ttmp15, v2
// CHECK: [0x05,0x00,0x30,0xd1,0x7b,0x04,0x02,0x00]

v_max_i16_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x30,0xd1,0x7c,0x04,0x02,0x00]

v_max_i16_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x30,0xd1,0x7e,0x04,0x02,0x00]

v_max_i16_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x30,0xd1,0x7f,0x04,0x02,0x00]

v_max_i16_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x30,0xd1,0x80,0x04,0x02,0x00]

v_max_i16_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x30,0xd1,0xc1,0x04,0x02,0x00]

v_max_i16_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x30,0xd1,0xfb,0x04,0x02,0x00]

v_max_i16_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x30,0xd1,0xfc,0x04,0x02,0x00]

v_max_i16_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x30,0xd1,0xfd,0x04,0x02,0x00]

v_max_i16_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x30,0xd1,0xfe,0x04,0x02,0x00]

v_max_i16_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x30,0xd1,0x01,0xff,0x03,0x00]

v_max_i16_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x30,0xd1,0x01,0x05,0x00,0x00]

v_max_i16_e64 v5, v1, s101
// CHECK: [0x05,0x00,0x30,0xd1,0x01,0xcb,0x00,0x00]

v_max_i16_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x30,0xd1,0x01,0xcd,0x00,0x00]

v_max_i16_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x30,0xd1,0x01,0xcf,0x00,0x00]

v_max_i16_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x30,0xd1,0x01,0xd5,0x00,0x00]

v_max_i16_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x30,0xd1,0x01,0xd7,0x00,0x00]

v_max_i16_e64 v5, v1, ttmp15
// CHECK: [0x05,0x00,0x30,0xd1,0x01,0xf7,0x00,0x00]

v_max_i16_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x30,0xd1,0x01,0xf9,0x00,0x00]

v_max_i16_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x30,0xd1,0x01,0xfd,0x00,0x00]

v_max_i16_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x30,0xd1,0x01,0xff,0x00,0x00]

v_max_i16_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x30,0xd1,0x01,0x01,0x01,0x00]

v_max_i16_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x30,0xd1,0x01,0x83,0x01,0x00]

v_max_i16_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x30,0xd1,0x01,0xf7,0x01,0x00]

v_max_i16_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x30,0xd1,0x01,0xf9,0x01,0x00]

v_max_i16_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x30,0xd1,0x01,0xfb,0x01,0x00]

v_min_u16_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x31,0xd1,0x01,0x05,0x02,0x00]

v_min_u16_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x31,0xd1,0x01,0x05,0x02,0x00]

v_min_u16_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x31,0xd1,0xff,0x05,0x02,0x00]

v_min_u16_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x31,0xd1,0x01,0x04,0x02,0x00]

v_min_u16_e64 v5, s101, v2
// CHECK: [0x05,0x00,0x31,0xd1,0x65,0x04,0x02,0x00]

v_min_u16_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x31,0xd1,0x66,0x04,0x02,0x00]

v_min_u16_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x31,0xd1,0x67,0x04,0x02,0x00]

v_min_u16_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x31,0xd1,0x6a,0x04,0x02,0x00]

v_min_u16_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x31,0xd1,0x6b,0x04,0x02,0x00]

v_min_u16_e64 v5, ttmp15, v2
// CHECK: [0x05,0x00,0x31,0xd1,0x7b,0x04,0x02,0x00]

v_min_u16_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x31,0xd1,0x7c,0x04,0x02,0x00]

v_min_u16_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x31,0xd1,0x7e,0x04,0x02,0x00]

v_min_u16_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x31,0xd1,0x7f,0x04,0x02,0x00]

v_min_u16_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x31,0xd1,0x80,0x04,0x02,0x00]

v_min_u16_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x31,0xd1,0xc1,0x04,0x02,0x00]

v_min_u16_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x31,0xd1,0xfb,0x04,0x02,0x00]

v_min_u16_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x31,0xd1,0xfc,0x04,0x02,0x00]

v_min_u16_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x31,0xd1,0xfd,0x04,0x02,0x00]

v_min_u16_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x31,0xd1,0xfe,0x04,0x02,0x00]

v_min_u16_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x31,0xd1,0x01,0xff,0x03,0x00]

v_min_u16_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x31,0xd1,0x01,0x05,0x00,0x00]

v_min_u16_e64 v5, v1, s101
// CHECK: [0x05,0x00,0x31,0xd1,0x01,0xcb,0x00,0x00]

v_min_u16_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x31,0xd1,0x01,0xcd,0x00,0x00]

v_min_u16_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x31,0xd1,0x01,0xcf,0x00,0x00]

v_min_u16_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x31,0xd1,0x01,0xd5,0x00,0x00]

v_min_u16_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x31,0xd1,0x01,0xd7,0x00,0x00]

v_min_u16_e64 v5, v1, ttmp15
// CHECK: [0x05,0x00,0x31,0xd1,0x01,0xf7,0x00,0x00]

v_min_u16_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x31,0xd1,0x01,0xf9,0x00,0x00]

v_min_u16_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x31,0xd1,0x01,0xfd,0x00,0x00]

v_min_u16_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x31,0xd1,0x01,0xff,0x00,0x00]

v_min_u16_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x31,0xd1,0x01,0x01,0x01,0x00]

v_min_u16_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x31,0xd1,0x01,0x83,0x01,0x00]

v_min_u16_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x31,0xd1,0x01,0xf7,0x01,0x00]

v_min_u16_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x31,0xd1,0x01,0xf9,0x01,0x00]

v_min_u16_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x31,0xd1,0x01,0xfb,0x01,0x00]

v_min_i16_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x32,0xd1,0x01,0x05,0x02,0x00]

v_min_i16_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x32,0xd1,0x01,0x05,0x02,0x00]

v_min_i16_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x32,0xd1,0xff,0x05,0x02,0x00]

v_min_i16_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x32,0xd1,0x01,0x04,0x02,0x00]

v_min_i16_e64 v5, s101, v2
// CHECK: [0x05,0x00,0x32,0xd1,0x65,0x04,0x02,0x00]

v_min_i16_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x32,0xd1,0x66,0x04,0x02,0x00]

v_min_i16_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x32,0xd1,0x67,0x04,0x02,0x00]

v_min_i16_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x32,0xd1,0x6a,0x04,0x02,0x00]

v_min_i16_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x32,0xd1,0x6b,0x04,0x02,0x00]

v_min_i16_e64 v5, ttmp15, v2
// CHECK: [0x05,0x00,0x32,0xd1,0x7b,0x04,0x02,0x00]

v_min_i16_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x32,0xd1,0x7c,0x04,0x02,0x00]

v_min_i16_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x32,0xd1,0x7e,0x04,0x02,0x00]

v_min_i16_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x32,0xd1,0x7f,0x04,0x02,0x00]

v_min_i16_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x32,0xd1,0x80,0x04,0x02,0x00]

v_min_i16_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x32,0xd1,0xc1,0x04,0x02,0x00]

v_min_i16_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x32,0xd1,0xfb,0x04,0x02,0x00]

v_min_i16_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x32,0xd1,0xfc,0x04,0x02,0x00]

v_min_i16_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x32,0xd1,0xfd,0x04,0x02,0x00]

v_min_i16_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x32,0xd1,0xfe,0x04,0x02,0x00]

v_min_i16_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x32,0xd1,0x01,0xff,0x03,0x00]

v_min_i16_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x32,0xd1,0x01,0x05,0x00,0x00]

v_min_i16_e64 v5, v1, s101
// CHECK: [0x05,0x00,0x32,0xd1,0x01,0xcb,0x00,0x00]

v_min_i16_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x32,0xd1,0x01,0xcd,0x00,0x00]

v_min_i16_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x32,0xd1,0x01,0xcf,0x00,0x00]

v_min_i16_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x32,0xd1,0x01,0xd5,0x00,0x00]

v_min_i16_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x32,0xd1,0x01,0xd7,0x00,0x00]

v_min_i16_e64 v5, v1, ttmp15
// CHECK: [0x05,0x00,0x32,0xd1,0x01,0xf7,0x00,0x00]

v_min_i16_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x32,0xd1,0x01,0xf9,0x00,0x00]

v_min_i16_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x32,0xd1,0x01,0xfd,0x00,0x00]

v_min_i16_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x32,0xd1,0x01,0xff,0x00,0x00]

v_min_i16_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x32,0xd1,0x01,0x01,0x01,0x00]

v_min_i16_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x32,0xd1,0x01,0x83,0x01,0x00]

v_min_i16_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x32,0xd1,0x01,0xf7,0x01,0x00]

v_min_i16_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x32,0xd1,0x01,0xf9,0x01,0x00]

v_min_i16_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x32,0xd1,0x01,0xfb,0x01,0x00]

v_ldexp_f16_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x33,0xd1,0x01,0x05,0x02,0x00]

v_ldexp_f16_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x33,0xd1,0x01,0x05,0x02,0x00]

v_ldexp_f16_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x33,0xd1,0xff,0x05,0x02,0x00]

v_ldexp_f16_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x33,0xd1,0x01,0x04,0x02,0x00]

v_ldexp_f16_e64 v5, s101, v2
// CHECK: [0x05,0x00,0x33,0xd1,0x65,0x04,0x02,0x00]

v_ldexp_f16_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x33,0xd1,0x66,0x04,0x02,0x00]

v_ldexp_f16_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x33,0xd1,0x67,0x04,0x02,0x00]

v_ldexp_f16_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x33,0xd1,0x6a,0x04,0x02,0x00]

v_ldexp_f16_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x33,0xd1,0x6b,0x04,0x02,0x00]

v_ldexp_f16_e64 v5, ttmp15, v2
// CHECK: [0x05,0x00,0x33,0xd1,0x7b,0x04,0x02,0x00]

v_ldexp_f16_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x33,0xd1,0x7c,0x04,0x02,0x00]

v_ldexp_f16_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x33,0xd1,0x7e,0x04,0x02,0x00]

v_ldexp_f16_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x33,0xd1,0x7f,0x04,0x02,0x00]

v_ldexp_f16_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x33,0xd1,0x80,0x04,0x02,0x00]

v_ldexp_f16_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x33,0xd1,0xc1,0x04,0x02,0x00]

v_ldexp_f16_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x33,0xd1,0xf0,0x04,0x02,0x00]

v_ldexp_f16_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x33,0xd1,0xf7,0x04,0x02,0x00]

v_ldexp_f16_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x33,0xd1,0xfb,0x04,0x02,0x00]

v_ldexp_f16_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x33,0xd1,0xfc,0x04,0x02,0x00]

v_ldexp_f16_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x33,0xd1,0xfd,0x04,0x02,0x00]

v_ldexp_f16_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x33,0xd1,0xfe,0x04,0x02,0x00]

v_ldexp_f16_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x33,0xd1,0x01,0xff,0x03,0x00]

v_ldexp_f16_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x33,0xd1,0x01,0x05,0x00,0x00]

v_ldexp_f16_e64 v5, v1, s101
// CHECK: [0x05,0x00,0x33,0xd1,0x01,0xcb,0x00,0x00]

v_ldexp_f16_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x33,0xd1,0x01,0xcd,0x00,0x00]

v_ldexp_f16_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x33,0xd1,0x01,0xcf,0x00,0x00]

v_ldexp_f16_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x33,0xd1,0x01,0xd5,0x00,0x00]

v_ldexp_f16_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x33,0xd1,0x01,0xd7,0x00,0x00]

v_ldexp_f16_e64 v5, v1, ttmp15
// CHECK: [0x05,0x00,0x33,0xd1,0x01,0xf7,0x00,0x00]

v_ldexp_f16_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x33,0xd1,0x01,0xf9,0x00,0x00]

v_ldexp_f16_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x33,0xd1,0x01,0xfd,0x00,0x00]

v_ldexp_f16_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x33,0xd1,0x01,0xff,0x00,0x00]

v_ldexp_f16_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x33,0xd1,0x01,0x01,0x01,0x00]

v_ldexp_f16_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x33,0xd1,0x01,0x83,0x01,0x00]

v_ldexp_f16_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x33,0xd1,0x01,0xe1,0x01,0x00]

v_ldexp_f16_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x33,0xd1,0x01,0xef,0x01,0x00]

v_ldexp_f16_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x33,0xd1,0x01,0xf7,0x01,0x00]

v_ldexp_f16_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x33,0xd1,0x01,0xf9,0x01,0x00]

v_ldexp_f16_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x33,0xd1,0x01,0xfb,0x01,0x00]

v_ldexp_f16_e64 v5, -v1, v2
// CHECK: [0x05,0x00,0x33,0xd1,0x01,0x05,0x02,0x20]

v_ldexp_f16_e64 v5, |v1|, v2
// CHECK: [0x05,0x01,0x33,0xd1,0x01,0x05,0x02,0x00]

v_ldexp_f16_e64 v5, v1, v2 clamp
// CHECK: [0x05,0x80,0x33,0xd1,0x01,0x05,0x02,0x00]

v_add_u32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x34,0xd1,0x01,0x05,0x02,0x00]

v_add_u32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x34,0xd1,0x01,0x05,0x02,0x00]

v_add_u32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x34,0xd1,0xff,0x05,0x02,0x00]

v_add_u32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x34,0xd1,0x01,0x04,0x02,0x00]

v_add_u32_e64 v5, s101, v2
// CHECK: [0x05,0x00,0x34,0xd1,0x65,0x04,0x02,0x00]

v_add_u32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x34,0xd1,0x66,0x04,0x02,0x00]

v_add_u32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x34,0xd1,0x67,0x04,0x02,0x00]

v_add_u32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x34,0xd1,0x6a,0x04,0x02,0x00]

v_add_u32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x34,0xd1,0x6b,0x04,0x02,0x00]

v_add_u32_e64 v5, ttmp15, v2
// CHECK: [0x05,0x00,0x34,0xd1,0x7b,0x04,0x02,0x00]

v_add_u32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x34,0xd1,0x7c,0x04,0x02,0x00]

v_add_u32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x34,0xd1,0x7e,0x04,0x02,0x00]

v_add_u32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x34,0xd1,0x7f,0x04,0x02,0x00]

v_add_u32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x34,0xd1,0x80,0x04,0x02,0x00]

v_add_u32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x34,0xd1,0xc1,0x04,0x02,0x00]

v_add_u32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x34,0xd1,0xf0,0x04,0x02,0x00]

v_add_u32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x34,0xd1,0xf7,0x04,0x02,0x00]

v_add_u32_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x34,0xd1,0xfb,0x04,0x02,0x00]

v_add_u32_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x34,0xd1,0xfc,0x04,0x02,0x00]

v_add_u32_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x34,0xd1,0xfd,0x04,0x02,0x00]

v_add_u32_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x34,0xd1,0xfe,0x04,0x02,0x00]

v_add_u32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x34,0xd1,0x01,0xff,0x03,0x00]

v_add_u32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x34,0xd1,0x01,0x05,0x00,0x00]

v_add_u32_e64 v5, v1, s101
// CHECK: [0x05,0x00,0x34,0xd1,0x01,0xcb,0x00,0x00]

v_add_u32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x34,0xd1,0x01,0xcd,0x00,0x00]

v_add_u32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x34,0xd1,0x01,0xcf,0x00,0x00]

v_add_u32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x34,0xd1,0x01,0xd5,0x00,0x00]

v_add_u32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x34,0xd1,0x01,0xd7,0x00,0x00]

v_add_u32_e64 v5, v1, ttmp15
// CHECK: [0x05,0x00,0x34,0xd1,0x01,0xf7,0x00,0x00]

v_add_u32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x34,0xd1,0x01,0xf9,0x00,0x00]

v_add_u32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x34,0xd1,0x01,0xfd,0x00,0x00]

v_add_u32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x34,0xd1,0x01,0xff,0x00,0x00]

v_add_u32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x34,0xd1,0x01,0x01,0x01,0x00]

v_add_u32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x34,0xd1,0x01,0x83,0x01,0x00]

v_add_u32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x34,0xd1,0x01,0xe1,0x01,0x00]

v_add_u32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x34,0xd1,0x01,0xef,0x01,0x00]

v_add_u32_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x34,0xd1,0x01,0xf7,0x01,0x00]

v_add_u32_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x34,0xd1,0x01,0xf9,0x01,0x00]

v_add_u32_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x34,0xd1,0x01,0xfb,0x01,0x00]

v_add_u32_e64 v5, v1, v2 clamp
// CHECK: [0x05,0x80,0x34,0xd1,0x01,0x05,0x02,0x00]

v_sub_u32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x35,0xd1,0x01,0x05,0x02,0x00]

v_sub_u32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x35,0xd1,0x01,0x05,0x02,0x00]

v_sub_u32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x35,0xd1,0xff,0x05,0x02,0x00]

v_sub_u32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x35,0xd1,0x01,0x04,0x02,0x00]

v_sub_u32_e64 v5, s101, v2
// CHECK: [0x05,0x00,0x35,0xd1,0x65,0x04,0x02,0x00]

v_sub_u32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x35,0xd1,0x66,0x04,0x02,0x00]

v_sub_u32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x35,0xd1,0x67,0x04,0x02,0x00]

v_sub_u32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x35,0xd1,0x6a,0x04,0x02,0x00]

v_sub_u32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x35,0xd1,0x6b,0x04,0x02,0x00]

v_sub_u32_e64 v5, ttmp15, v2
// CHECK: [0x05,0x00,0x35,0xd1,0x7b,0x04,0x02,0x00]

v_sub_u32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x35,0xd1,0x7c,0x04,0x02,0x00]

v_sub_u32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x35,0xd1,0x7e,0x04,0x02,0x00]

v_sub_u32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x35,0xd1,0x7f,0x04,0x02,0x00]

v_sub_u32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x35,0xd1,0x80,0x04,0x02,0x00]

v_sub_u32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x35,0xd1,0xc1,0x04,0x02,0x00]

v_sub_u32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x35,0xd1,0xf0,0x04,0x02,0x00]

v_sub_u32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x35,0xd1,0xf7,0x04,0x02,0x00]

v_sub_u32_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x35,0xd1,0xfb,0x04,0x02,0x00]

v_sub_u32_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x35,0xd1,0xfc,0x04,0x02,0x00]

v_sub_u32_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x35,0xd1,0xfd,0x04,0x02,0x00]

v_sub_u32_e64 v5, src_lds_direct, v2
// CHECK: [0x05,0x00,0x35,0xd1,0xfe,0x04,0x02,0x00]

v_sub_u32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x35,0xd1,0x01,0xff,0x03,0x00]

v_sub_u32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x35,0xd1,0x01,0x05,0x00,0x00]

v_sub_u32_e64 v5, v1, s101
// CHECK: [0x05,0x00,0x35,0xd1,0x01,0xcb,0x00,0x00]

v_sub_u32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x35,0xd1,0x01,0xcd,0x00,0x00]

v_sub_u32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x35,0xd1,0x01,0xcf,0x00,0x00]

v_sub_u32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x35,0xd1,0x01,0xd5,0x00,0x00]

v_sub_u32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x35,0xd1,0x01,0xd7,0x00,0x00]

v_sub_u32_e64 v5, v1, ttmp15
// CHECK: [0x05,0x00,0x35,0xd1,0x01,0xf7,0x00,0x00]

v_sub_u32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x35,0xd1,0x01,0xf9,0x00,0x00]

v_sub_u32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x35,0xd1,0x01,0xfd,0x00,0x00]

v_sub_u32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x35,0xd1,0x01,0xff,0x00,0x00]

v_sub_u32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x35,0xd1,0x01,0x01,0x01,0x00]

v_sub_u32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x35,0xd1,0x01,0x83,0x01,0x00]

v_sub_u32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x35,0xd1,0x01,0xe1,0x01,0x00]

v_sub_u32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x35,0xd1,0x01,0xef,0x01,0x00]

v_sub_u32_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x35,0xd1,0x01,0xf7,0x01,0x00]

v_sub_u32_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x35,0xd1,0x01,0xf9,0x01,0x00]

v_sub_u32_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x35,0xd1,0x01,0xfb,0x01,0x00]

v_sub_u32_e64 v5, v1, v2 clamp
// CHECK: [0x05,0x80,0x35,0xd1,0x01,0x05,0x02,0x00]

v_subrev_u32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x36,0xd1,0x01,0x05,0x02,0x00]

v_subrev_u32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x36,0xd1,0x01,0x05,0x02,0x00]

v_subrev_u32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x36,0xd1,0xff,0x05,0x02,0x00]

v_subrev_u32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x36,0xd1,0x01,0x04,0x02,0x00]

v_subrev_u32_e64 v5, s101, v2
// CHECK: [0x05,0x00,0x36,0xd1,0x65,0x04,0x02,0x00]

v_subrev_u32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x36,0xd1,0x66,0x04,0x02,0x00]

v_subrev_u32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x36,0xd1,0x67,0x04,0x02,0x00]

v_subrev_u32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x36,0xd1,0x6a,0x04,0x02,0x00]

v_subrev_u32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x36,0xd1,0x6b,0x04,0x02,0x00]

v_subrev_u32_e64 v5, ttmp15, v2
// CHECK: [0x05,0x00,0x36,0xd1,0x7b,0x04,0x02,0x00]

v_subrev_u32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x36,0xd1,0x7c,0x04,0x02,0x00]

v_subrev_u32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x36,0xd1,0x7e,0x04,0x02,0x00]

v_subrev_u32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x36,0xd1,0x7f,0x04,0x02,0x00]

v_subrev_u32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x36,0xd1,0x80,0x04,0x02,0x00]

v_subrev_u32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x36,0xd1,0xc1,0x04,0x02,0x00]

v_subrev_u32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x36,0xd1,0xf0,0x04,0x02,0x00]

v_subrev_u32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x36,0xd1,0xf7,0x04,0x02,0x00]

v_subrev_u32_e64 v5, src_vccz, v2
// CHECK: [0x05,0x00,0x36,0xd1,0xfb,0x04,0x02,0x00]

v_subrev_u32_e64 v5, src_execz, v2
// CHECK: [0x05,0x00,0x36,0xd1,0xfc,0x04,0x02,0x00]

v_subrev_u32_e64 v5, src_scc, v2
// CHECK: [0x05,0x00,0x36,0xd1,0xfd,0x04,0x02,0x00]

v_subrev_u32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x36,0xd1,0x01,0xff,0x03,0x00]

v_subrev_u32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x36,0xd1,0x01,0x05,0x00,0x00]

v_subrev_u32_e64 v5, v1, s101
// CHECK: [0x05,0x00,0x36,0xd1,0x01,0xcb,0x00,0x00]

v_subrev_u32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x36,0xd1,0x01,0xcd,0x00,0x00]

v_subrev_u32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x36,0xd1,0x01,0xcf,0x00,0x00]

v_subrev_u32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x36,0xd1,0x01,0xd5,0x00,0x00]

v_subrev_u32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x36,0xd1,0x01,0xd7,0x00,0x00]

v_subrev_u32_e64 v5, v1, ttmp15
// CHECK: [0x05,0x00,0x36,0xd1,0x01,0xf7,0x00,0x00]

v_subrev_u32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x36,0xd1,0x01,0xf9,0x00,0x00]

v_subrev_u32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x36,0xd1,0x01,0xfd,0x00,0x00]

v_subrev_u32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x36,0xd1,0x01,0xff,0x00,0x00]

v_subrev_u32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x36,0xd1,0x01,0x01,0x01,0x00]

v_subrev_u32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x36,0xd1,0x01,0x83,0x01,0x00]

v_subrev_u32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x36,0xd1,0x01,0xe1,0x01,0x00]

v_subrev_u32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x36,0xd1,0x01,0xef,0x01,0x00]

v_subrev_u32_e64 v5, v1, src_vccz
// CHECK: [0x05,0x00,0x36,0xd1,0x01,0xf7,0x01,0x00]

v_subrev_u32_e64 v5, v1, src_execz
// CHECK: [0x05,0x00,0x36,0xd1,0x01,0xf9,0x01,0x00]

v_subrev_u32_e64 v5, v1, src_scc
// CHECK: [0x05,0x00,0x36,0xd1,0x01,0xfb,0x01,0x00]

v_subrev_u32_e64 v5, v1, v2 clamp
// CHECK: [0x05,0x80,0x36,0xd1,0x01,0x05,0x02,0x00]

v_cmp_class_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x10,0xd0,0x01,0x05,0x02,0x00]

v_cmp_class_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x10,0xd0,0x01,0x05,0x02,0x00]

v_cmp_class_f32_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x10,0xd0,0x01,0x05,0x02,0x00]

v_cmp_class_f32_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x10,0xd0,0x01,0x05,0x02,0x00]

v_cmp_class_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x10,0xd0,0x01,0x05,0x02,0x00]

v_cmp_class_f32_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x10,0xd0,0x01,0x05,0x02,0x00]

v_cmp_class_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x10,0xd0,0xff,0x05,0x02,0x00]

v_cmp_class_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x10,0xd0,0x01,0x04,0x02,0x00]

v_cmp_class_f32_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x10,0xd0,0x65,0x04,0x02,0x00]

v_cmp_class_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x10,0xd0,0x66,0x04,0x02,0x00]

v_cmp_class_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x10,0xd0,0x67,0x04,0x02,0x00]

v_cmp_class_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x10,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_class_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x10,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_class_f32_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x10,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_class_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x10,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_class_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x10,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_class_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x10,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_class_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x10,0xd0,0x80,0x04,0x02,0x00]

v_cmp_class_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x10,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_class_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x10,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_class_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x10,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_class_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x10,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_class_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x10,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_class_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x10,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_class_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x10,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_class_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x10,0xd0,0x01,0xff,0x03,0x00]

v_cmp_class_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x10,0xd0,0x01,0x05,0x00,0x00]

v_cmp_class_f32_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x10,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_class_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x10,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_class_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x10,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_class_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x10,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_class_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x10,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_class_f32_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x10,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_class_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x10,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_class_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x10,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_class_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x10,0xd0,0x01,0xff,0x00,0x00]

v_cmp_class_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x10,0xd0,0x01,0x01,0x01,0x00]

v_cmp_class_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x10,0xd0,0x01,0x83,0x01,0x00]

v_cmp_class_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x10,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_class_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x10,0xd0,0x01,0xef,0x01,0x00]

v_cmp_class_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x10,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_class_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x10,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_class_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x10,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_class_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x10,0xd0,0x01,0x05,0x02,0x20]

v_cmp_class_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x10,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_class_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x11,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_class_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x11,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_class_f32_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x11,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_class_f32_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x11,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_class_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x11,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_class_f32_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x11,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_class_f32_e64 exec, v1, v2
// CHECK: [0x7e,0x00,0x11,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_class_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x11,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_class_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x11,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_class_f32_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x11,0xd0,0x65,0x04,0x02,0x00]

v_cmpx_class_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x11,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_class_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x11,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_class_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x11,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_class_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x11,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_class_f32_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x11,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_class_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x11,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_class_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x11,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_class_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x11,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_class_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x11,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_class_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x11,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_class_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x11,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_class_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x11,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_class_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x11,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_class_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x11,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_class_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x11,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_class_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x11,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_class_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x11,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_class_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x11,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_class_f32_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x11,0xd0,0x01,0xcb,0x00,0x00]

v_cmpx_class_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x11,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_class_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x11,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_class_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x11,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_class_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x11,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_class_f32_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x11,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_class_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x11,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_class_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x11,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_class_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x11,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_class_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x11,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_class_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x11,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_class_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x11,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_class_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x11,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_class_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x11,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_class_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x11,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_class_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x11,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_class_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x11,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_class_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x11,0xd0,0x01,0x05,0x02,0x00]

v_cmp_class_f64_e64 s[10:11], v[1:2], v2
// CHECK: [0x0a,0x00,0x12,0xd0,0x01,0x05,0x02,0x00]

v_cmp_class_f64_e64 s[12:13], v[1:2], v2
// CHECK: [0x0c,0x00,0x12,0xd0,0x01,0x05,0x02,0x00]

v_cmp_class_f64_e64 s[100:101], v[1:2], v2
// CHECK: [0x64,0x00,0x12,0xd0,0x01,0x05,0x02,0x00]

v_cmp_class_f64_e64 flat_scratch, v[1:2], v2
// CHECK: [0x66,0x00,0x12,0xd0,0x01,0x05,0x02,0x00]

v_cmp_class_f64_e64 vcc, v[1:2], v2
// CHECK: [0x6a,0x00,0x12,0xd0,0x01,0x05,0x02,0x00]

v_cmp_class_f64_e64 ttmp[14:15], v[1:2], v2
// CHECK: [0x7a,0x00,0x12,0xd0,0x01,0x05,0x02,0x00]

v_cmp_class_f64_e64 s[10:11], v[254:255], v2
// CHECK: [0x0a,0x00,0x12,0xd0,0xfe,0x05,0x02,0x00]

v_cmp_class_f64_e64 s[10:11], s[2:3], v2
// CHECK: [0x0a,0x00,0x12,0xd0,0x02,0x04,0x02,0x00]

v_cmp_class_f64_e64 s[10:11], s[4:5], v2
// CHECK: [0x0a,0x00,0x12,0xd0,0x04,0x04,0x02,0x00]

v_cmp_class_f64_e64 s[10:11], s[100:101], v2
// CHECK: [0x0a,0x00,0x12,0xd0,0x64,0x04,0x02,0x00]

v_cmp_class_f64_e64 s[10:11], flat_scratch, v2
// CHECK: [0x0a,0x00,0x12,0xd0,0x66,0x04,0x02,0x00]

v_cmp_class_f64_e64 s[10:11], vcc, v2
// CHECK: [0x0a,0x00,0x12,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_class_f64_e64 s[10:11], ttmp[14:15], v2
// CHECK: [0x0a,0x00,0x12,0xd0,0x7a,0x04,0x02,0x00]

v_cmp_class_f64_e64 s[10:11], exec, v2
// CHECK: [0x0a,0x00,0x12,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_class_f64_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x12,0xd0,0x80,0x04,0x02,0x00]

v_cmp_class_f64_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x12,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_class_f64_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x12,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_class_f64_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x12,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_class_f64_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x12,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_class_f64_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x12,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_class_f64_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x12,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_class_f64_e64 s[10:11], v[1:2], v255
// CHECK: [0x0a,0x00,0x12,0xd0,0x01,0xff,0x03,0x00]

v_cmp_class_f64_e64 s[10:11], v[1:2], s2
// CHECK: [0x0a,0x00,0x12,0xd0,0x01,0x05,0x00,0x00]

v_cmp_class_f64_e64 s[10:11], v[1:2], s101
// CHECK: [0x0a,0x00,0x12,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_class_f64_e64 s[10:11], v[1:2], flat_scratch_lo
// CHECK: [0x0a,0x00,0x12,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_class_f64_e64 s[10:11], v[1:2], flat_scratch_hi
// CHECK: [0x0a,0x00,0x12,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_class_f64_e64 s[10:11], v[1:2], vcc_lo
// CHECK: [0x0a,0x00,0x12,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_class_f64_e64 s[10:11], v[1:2], vcc_hi
// CHECK: [0x0a,0x00,0x12,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_class_f64_e64 s[10:11], v[1:2], ttmp15
// CHECK: [0x0a,0x00,0x12,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_class_f64_e64 s[10:11], v[1:2], m0
// CHECK: [0x0a,0x00,0x12,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_class_f64_e64 s[10:11], v[1:2], exec_lo
// CHECK: [0x0a,0x00,0x12,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_class_f64_e64 s[10:11], v[1:2], exec_hi
// CHECK: [0x0a,0x00,0x12,0xd0,0x01,0xff,0x00,0x00]

v_cmp_class_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x12,0xd0,0x01,0x01,0x01,0x00]

v_cmp_class_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x12,0xd0,0x01,0x83,0x01,0x00]

v_cmp_class_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x12,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_class_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x12,0xd0,0x01,0xef,0x01,0x00]

v_cmp_class_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x12,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_class_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x12,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_class_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x12,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_class_f64_e64 s[10:11], -v[1:2], v2
// CHECK: [0x0a,0x00,0x12,0xd0,0x01,0x05,0x02,0x20]

v_cmp_class_f64_e64 s[10:11], |v[1:2]|, v2
// CHECK: [0x0a,0x01,0x12,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_class_f64_e64 s[10:11], v[1:2], v2
// CHECK: [0x0a,0x00,0x13,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_class_f64_e64 s[12:13], v[1:2], v2
// CHECK: [0x0c,0x00,0x13,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_class_f64_e64 s[100:101], v[1:2], v2
// CHECK: [0x64,0x00,0x13,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_class_f64_e64 flat_scratch, v[1:2], v2
// CHECK: [0x66,0x00,0x13,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_class_f64_e64 vcc, v[1:2], v2
// CHECK: [0x6a,0x00,0x13,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_class_f64_e64 ttmp[14:15], v[1:2], v2
// CHECK: [0x7a,0x00,0x13,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_class_f64_e64 exec, v[1:2], v2
// CHECK: [0x7e,0x00,0x13,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_class_f64_e64 s[10:11], v[254:255], v2
// CHECK: [0x0a,0x00,0x13,0xd0,0xfe,0x05,0x02,0x00]

v_cmpx_class_f64_e64 s[10:11], s[2:3], v2
// CHECK: [0x0a,0x00,0x13,0xd0,0x02,0x04,0x02,0x00]

v_cmpx_class_f64_e64 s[10:11], s[4:5], v2
// CHECK: [0x0a,0x00,0x13,0xd0,0x04,0x04,0x02,0x00]

v_cmpx_class_f64_e64 s[10:11], s[100:101], v2
// CHECK: [0x0a,0x00,0x13,0xd0,0x64,0x04,0x02,0x00]

v_cmpx_class_f64_e64 s[10:11], flat_scratch, v2
// CHECK: [0x0a,0x00,0x13,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_class_f64_e64 s[10:11], vcc, v2
// CHECK: [0x0a,0x00,0x13,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_class_f64_e64 s[10:11], ttmp[14:15], v2
// CHECK: [0x0a,0x00,0x13,0xd0,0x7a,0x04,0x02,0x00]

v_cmpx_class_f64_e64 s[10:11], exec, v2
// CHECK: [0x0a,0x00,0x13,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_class_f64_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x13,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_class_f64_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x13,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_class_f64_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x13,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_class_f64_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x13,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_class_f64_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x13,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_class_f64_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x13,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_class_f64_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x13,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_class_f64_e64 s[10:11], v[1:2], v255
// CHECK: [0x0a,0x00,0x13,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_class_f64_e64 s[10:11], v[1:2], s2
// CHECK: [0x0a,0x00,0x13,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_class_f64_e64 s[10:11], v[1:2], s101
// CHECK: [0x0a,0x00,0x13,0xd0,0x01,0xcb,0x00,0x00]

v_cmpx_class_f64_e64 s[10:11], v[1:2], flat_scratch_lo
// CHECK: [0x0a,0x00,0x13,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_class_f64_e64 s[10:11], v[1:2], flat_scratch_hi
// CHECK: [0x0a,0x00,0x13,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_class_f64_e64 s[10:11], v[1:2], vcc_lo
// CHECK: [0x0a,0x00,0x13,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_class_f64_e64 s[10:11], v[1:2], vcc_hi
// CHECK: [0x0a,0x00,0x13,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_class_f64_e64 s[10:11], v[1:2], ttmp15
// CHECK: [0x0a,0x00,0x13,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_class_f64_e64 s[10:11], v[1:2], m0
// CHECK: [0x0a,0x00,0x13,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_class_f64_e64 s[10:11], v[1:2], exec_lo
// CHECK: [0x0a,0x00,0x13,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_class_f64_e64 s[10:11], v[1:2], exec_hi
// CHECK: [0x0a,0x00,0x13,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_class_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x13,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_class_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x13,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_class_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x13,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_class_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x13,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_class_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x13,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_class_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x13,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_class_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x13,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_class_f64_e64 s[10:11], -v[1:2], v2
// CHECK: [0x0a,0x00,0x13,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_class_f64_e64 s[10:11], |v[1:2]|, v2
// CHECK: [0x0a,0x01,0x13,0xd0,0x01,0x05,0x02,0x00]

v_cmp_class_f16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x14,0xd0,0x01,0x05,0x02,0x00]

v_cmp_class_f16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x14,0xd0,0x01,0x05,0x02,0x00]

v_cmp_class_f16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x14,0xd0,0x01,0x05,0x02,0x00]

v_cmp_class_f16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x14,0xd0,0x01,0x05,0x02,0x00]

v_cmp_class_f16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x14,0xd0,0x01,0x05,0x02,0x00]

v_cmp_class_f16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x14,0xd0,0x01,0x05,0x02,0x00]

v_cmp_class_f16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x14,0xd0,0xff,0x05,0x02,0x00]

v_cmp_class_f16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x14,0xd0,0x01,0x04,0x02,0x00]

v_cmp_class_f16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x14,0xd0,0x65,0x04,0x02,0x00]

v_cmp_class_f16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x14,0xd0,0x66,0x04,0x02,0x00]

v_cmp_class_f16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x14,0xd0,0x67,0x04,0x02,0x00]

v_cmp_class_f16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x14,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_class_f16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x14,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_class_f16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x14,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_class_f16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x14,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_class_f16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x14,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_class_f16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x14,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_class_f16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x14,0xd0,0x80,0x04,0x02,0x00]

v_cmp_class_f16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x14,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_class_f16_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x14,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_class_f16_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x14,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_class_f16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x14,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_class_f16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x14,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_class_f16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x14,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_class_f16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x14,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_class_f16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x14,0xd0,0x01,0xff,0x03,0x00]

v_cmp_class_f16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x14,0xd0,0x01,0x05,0x00,0x00]

v_cmp_class_f16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x14,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_class_f16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x14,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_class_f16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x14,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_class_f16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x14,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_class_f16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x14,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_class_f16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x14,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_class_f16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x14,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_class_f16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x14,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_class_f16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x14,0xd0,0x01,0xff,0x00,0x00]

v_cmp_class_f16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x14,0xd0,0x01,0x01,0x01,0x00]

v_cmp_class_f16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x14,0xd0,0x01,0x83,0x01,0x00]

v_cmp_class_f16_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x14,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_class_f16_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x14,0xd0,0x01,0xef,0x01,0x00]

v_cmp_class_f16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x14,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_class_f16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x14,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_class_f16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x14,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_class_f16_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x14,0xd0,0x01,0x05,0x02,0x20]

v_cmp_class_f16_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x14,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_class_f16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x15,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_class_f16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x15,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_class_f16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x15,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_class_f16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x15,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_class_f16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x15,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_class_f16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x15,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_class_f16_e64 exec, v1, v2
// CHECK: [0x7e,0x00,0x15,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_class_f16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x15,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_class_f16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x15,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_class_f16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x15,0xd0,0x65,0x04,0x02,0x00]

v_cmpx_class_f16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x15,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_class_f16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x15,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_class_f16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x15,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_class_f16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x15,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_class_f16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x15,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_class_f16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x15,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_class_f16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x15,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_class_f16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x15,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_class_f16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x15,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_class_f16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x15,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_class_f16_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x15,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_class_f16_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x15,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_class_f16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x15,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_class_f16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x15,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_class_f16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x15,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_class_f16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x15,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_class_f16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x15,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_class_f16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x15,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_class_f16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x15,0xd0,0x01,0xcb,0x00,0x00]

v_cmpx_class_f16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x15,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_class_f16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x15,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_class_f16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x15,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_class_f16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x15,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_class_f16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x15,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_class_f16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x15,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_class_f16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x15,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_class_f16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x15,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_class_f16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x15,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_class_f16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x15,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_class_f16_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x15,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_class_f16_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x15,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_class_f16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x15,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_class_f16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x15,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_class_f16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x15,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_class_f16_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x15,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_class_f16_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x15,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_f16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x20,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_f16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x20,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_f16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x20,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_f16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x20,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_f16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x20,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_f16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x20,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_f16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x20,0xd0,0xff,0x05,0x02,0x00]

v_cmp_f_f16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x20,0xd0,0x01,0x04,0x02,0x00]

v_cmp_f_f16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x20,0xd0,0x65,0x04,0x02,0x00]

v_cmp_f_f16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x20,0xd0,0x66,0x04,0x02,0x00]

v_cmp_f_f16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x20,0xd0,0x67,0x04,0x02,0x00]

v_cmp_f_f16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x20,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_f_f16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x20,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_f_f16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x20,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_f_f16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x20,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_f_f16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x20,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_f_f16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x20,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_f_f16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x20,0xd0,0x80,0x04,0x02,0x00]

v_cmp_f_f16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x20,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_f_f16_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x20,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_f_f16_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x20,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_f_f16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x20,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_f_f16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x20,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_f_f16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x20,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_f_f16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x20,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_f_f16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x20,0xd0,0x01,0xff,0x03,0x00]

v_cmp_f_f16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x20,0xd0,0x01,0x05,0x00,0x00]

v_cmp_f_f16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x20,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_f_f16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x20,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_f_f16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x20,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_f_f16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x20,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_f_f16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x20,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_f_f16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x20,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_f_f16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x20,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_f_f16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x20,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_f_f16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x20,0xd0,0x01,0xff,0x00,0x00]

v_cmp_f_f16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x20,0xd0,0x01,0x01,0x01,0x00]

v_cmp_f_f16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x20,0xd0,0x01,0x83,0x01,0x00]

v_cmp_f_f16_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x20,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_f_f16_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x20,0xd0,0x01,0xef,0x01,0x00]

v_cmp_f_f16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x20,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_f_f16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x20,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_f_f16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x20,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_f_f16_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x20,0xd0,0x01,0x05,0x02,0x20]

v_cmp_f_f16_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x20,0xd0,0x01,0x05,0x02,0x40]

v_cmp_f_f16_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x20,0xd0,0x01,0x05,0x02,0x60]

v_cmp_f_f16_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x20,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_f16_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x20,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_f16_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x20,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_f16_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x20,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_f16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x21,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_f16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x21,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_f16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x21,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_f16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x21,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_f16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x21,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_f16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x21,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_f16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x21,0xd0,0xff,0x05,0x02,0x00]

v_cmp_lt_f16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x21,0xd0,0x01,0x04,0x02,0x00]

v_cmp_lt_f16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x21,0xd0,0x65,0x04,0x02,0x00]

v_cmp_lt_f16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x21,0xd0,0x66,0x04,0x02,0x00]

v_cmp_lt_f16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x21,0xd0,0x67,0x04,0x02,0x00]

v_cmp_lt_f16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x21,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_lt_f16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x21,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_lt_f16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x21,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_lt_f16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x21,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_lt_f16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x21,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_lt_f16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x21,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_lt_f16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x21,0xd0,0x80,0x04,0x02,0x00]

v_cmp_lt_f16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x21,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_lt_f16_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x21,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_lt_f16_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x21,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_lt_f16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x21,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_lt_f16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x21,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_lt_f16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x21,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_lt_f16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x21,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_lt_f16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x21,0xd0,0x01,0xff,0x03,0x00]

v_cmp_lt_f16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x21,0xd0,0x01,0x05,0x00,0x00]

v_cmp_lt_f16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x21,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_lt_f16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x21,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_lt_f16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x21,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_lt_f16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x21,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_lt_f16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x21,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_lt_f16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x21,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_lt_f16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x21,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_lt_f16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x21,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_lt_f16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x21,0xd0,0x01,0xff,0x00,0x00]

v_cmp_lt_f16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x21,0xd0,0x01,0x01,0x01,0x00]

v_cmp_lt_f16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x21,0xd0,0x01,0x83,0x01,0x00]

v_cmp_lt_f16_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x21,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_lt_f16_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x21,0xd0,0x01,0xef,0x01,0x00]

v_cmp_lt_f16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x21,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_lt_f16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x21,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_lt_f16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x21,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_lt_f16_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x21,0xd0,0x01,0x05,0x02,0x20]

v_cmp_lt_f16_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x21,0xd0,0x01,0x05,0x02,0x40]

v_cmp_lt_f16_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x21,0xd0,0x01,0x05,0x02,0x60]

v_cmp_lt_f16_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x21,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_f16_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x21,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_f16_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x21,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_f16_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x21,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_f16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x22,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_f16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x22,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_f16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x22,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_f16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x22,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_f16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x22,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_f16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x22,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_f16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x22,0xd0,0xff,0x05,0x02,0x00]

v_cmp_eq_f16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x22,0xd0,0x01,0x04,0x02,0x00]

v_cmp_eq_f16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x22,0xd0,0x65,0x04,0x02,0x00]

v_cmp_eq_f16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x22,0xd0,0x66,0x04,0x02,0x00]

v_cmp_eq_f16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x22,0xd0,0x67,0x04,0x02,0x00]

v_cmp_eq_f16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x22,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_eq_f16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x22,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_eq_f16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x22,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_eq_f16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x22,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_eq_f16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x22,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_eq_f16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x22,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_eq_f16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x22,0xd0,0x80,0x04,0x02,0x00]

v_cmp_eq_f16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x22,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_eq_f16_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x22,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_eq_f16_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x22,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_eq_f16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x22,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_eq_f16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x22,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_eq_f16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x22,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_eq_f16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x22,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_eq_f16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x22,0xd0,0x01,0xff,0x03,0x00]

v_cmp_eq_f16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x22,0xd0,0x01,0x05,0x00,0x00]

v_cmp_eq_f16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x22,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_eq_f16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x22,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_eq_f16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x22,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_eq_f16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x22,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_eq_f16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x22,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_eq_f16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x22,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_eq_f16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x22,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_eq_f16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x22,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_eq_f16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x22,0xd0,0x01,0xff,0x00,0x00]

v_cmp_eq_f16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x22,0xd0,0x01,0x01,0x01,0x00]

v_cmp_eq_f16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x22,0xd0,0x01,0x83,0x01,0x00]

v_cmp_eq_f16_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x22,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_eq_f16_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x22,0xd0,0x01,0xef,0x01,0x00]

v_cmp_eq_f16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x22,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_eq_f16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x22,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_eq_f16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x22,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_eq_f16_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x22,0xd0,0x01,0x05,0x02,0x20]

v_cmp_eq_f16_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x22,0xd0,0x01,0x05,0x02,0x40]

v_cmp_eq_f16_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x22,0xd0,0x01,0x05,0x02,0x60]

v_cmp_eq_f16_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x22,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_f16_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x22,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_f16_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x22,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_f16_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x22,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_f16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x23,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_f16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x23,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_f16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x23,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_f16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x23,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_f16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x23,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_f16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x23,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_f16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x23,0xd0,0xff,0x05,0x02,0x00]

v_cmp_le_f16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x23,0xd0,0x01,0x04,0x02,0x00]

v_cmp_le_f16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x23,0xd0,0x65,0x04,0x02,0x00]

v_cmp_le_f16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x23,0xd0,0x66,0x04,0x02,0x00]

v_cmp_le_f16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x23,0xd0,0x67,0x04,0x02,0x00]

v_cmp_le_f16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x23,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_le_f16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x23,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_le_f16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x23,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_le_f16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x23,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_le_f16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x23,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_le_f16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x23,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_le_f16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x23,0xd0,0x80,0x04,0x02,0x00]

v_cmp_le_f16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x23,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_le_f16_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x23,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_le_f16_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x23,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_le_f16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x23,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_le_f16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x23,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_le_f16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x23,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_le_f16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x23,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_le_f16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x23,0xd0,0x01,0xff,0x03,0x00]

v_cmp_le_f16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x23,0xd0,0x01,0x05,0x00,0x00]

v_cmp_le_f16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x23,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_le_f16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x23,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_le_f16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x23,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_le_f16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x23,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_le_f16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x23,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_le_f16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x23,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_le_f16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x23,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_le_f16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x23,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_le_f16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x23,0xd0,0x01,0xff,0x00,0x00]

v_cmp_le_f16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x23,0xd0,0x01,0x01,0x01,0x00]

v_cmp_le_f16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x23,0xd0,0x01,0x83,0x01,0x00]

v_cmp_le_f16_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x23,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_le_f16_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x23,0xd0,0x01,0xef,0x01,0x00]

v_cmp_le_f16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x23,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_le_f16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x23,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_le_f16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x23,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_le_f16_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x23,0xd0,0x01,0x05,0x02,0x20]

v_cmp_le_f16_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x23,0xd0,0x01,0x05,0x02,0x40]

v_cmp_le_f16_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x23,0xd0,0x01,0x05,0x02,0x60]

v_cmp_le_f16_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x23,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_f16_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x23,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_f16_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x23,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_f16_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x23,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_f16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x24,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_f16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x24,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_f16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x24,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_f16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x24,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_f16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x24,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_f16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x24,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_f16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x24,0xd0,0xff,0x05,0x02,0x00]

v_cmp_gt_f16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x24,0xd0,0x01,0x04,0x02,0x00]

v_cmp_gt_f16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x24,0xd0,0x65,0x04,0x02,0x00]

v_cmp_gt_f16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x24,0xd0,0x66,0x04,0x02,0x00]

v_cmp_gt_f16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x24,0xd0,0x67,0x04,0x02,0x00]

v_cmp_gt_f16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x24,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_gt_f16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x24,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_gt_f16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x24,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_gt_f16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x24,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_gt_f16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x24,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_gt_f16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x24,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_gt_f16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x24,0xd0,0x80,0x04,0x02,0x00]

v_cmp_gt_f16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x24,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_gt_f16_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x24,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_gt_f16_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x24,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_gt_f16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x24,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_gt_f16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x24,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_gt_f16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x24,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_gt_f16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x24,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_gt_f16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x24,0xd0,0x01,0xff,0x03,0x00]

v_cmp_gt_f16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x24,0xd0,0x01,0x05,0x00,0x00]

v_cmp_gt_f16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x24,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_gt_f16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x24,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_gt_f16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x24,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_gt_f16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x24,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_gt_f16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x24,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_gt_f16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x24,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_gt_f16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x24,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_gt_f16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x24,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_gt_f16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x24,0xd0,0x01,0xff,0x00,0x00]

v_cmp_gt_f16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x24,0xd0,0x01,0x01,0x01,0x00]

v_cmp_gt_f16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x24,0xd0,0x01,0x83,0x01,0x00]

v_cmp_gt_f16_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x24,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_gt_f16_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x24,0xd0,0x01,0xef,0x01,0x00]

v_cmp_gt_f16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x24,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_gt_f16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x24,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_gt_f16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x24,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_gt_f16_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x24,0xd0,0x01,0x05,0x02,0x20]

v_cmp_gt_f16_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x24,0xd0,0x01,0x05,0x02,0x40]

v_cmp_gt_f16_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x24,0xd0,0x01,0x05,0x02,0x60]

v_cmp_gt_f16_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x24,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_f16_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x24,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_f16_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x24,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_f16_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x24,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lg_f16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x25,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lg_f16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x25,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lg_f16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x25,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lg_f16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x25,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lg_f16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x25,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lg_f16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x25,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lg_f16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x25,0xd0,0xff,0x05,0x02,0x00]

v_cmp_lg_f16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x25,0xd0,0x01,0x04,0x02,0x00]

v_cmp_lg_f16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x25,0xd0,0x65,0x04,0x02,0x00]

v_cmp_lg_f16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x25,0xd0,0x66,0x04,0x02,0x00]

v_cmp_lg_f16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x25,0xd0,0x67,0x04,0x02,0x00]

v_cmp_lg_f16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x25,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_lg_f16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x25,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_lg_f16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x25,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_lg_f16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x25,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_lg_f16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x25,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_lg_f16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x25,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_lg_f16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x25,0xd0,0x80,0x04,0x02,0x00]

v_cmp_lg_f16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x25,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_lg_f16_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x25,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_lg_f16_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x25,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_lg_f16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x25,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_lg_f16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x25,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_lg_f16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x25,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_lg_f16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x25,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_lg_f16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x25,0xd0,0x01,0xff,0x03,0x00]

v_cmp_lg_f16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x25,0xd0,0x01,0x05,0x00,0x00]

v_cmp_lg_f16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x25,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_lg_f16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x25,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_lg_f16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x25,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_lg_f16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x25,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_lg_f16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x25,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_lg_f16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x25,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_lg_f16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x25,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_lg_f16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x25,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_lg_f16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x25,0xd0,0x01,0xff,0x00,0x00]

v_cmp_lg_f16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x25,0xd0,0x01,0x01,0x01,0x00]

v_cmp_lg_f16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x25,0xd0,0x01,0x83,0x01,0x00]

v_cmp_lg_f16_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x25,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_lg_f16_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x25,0xd0,0x01,0xef,0x01,0x00]

v_cmp_lg_f16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x25,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_lg_f16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x25,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_lg_f16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x25,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_lg_f16_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x25,0xd0,0x01,0x05,0x02,0x20]

v_cmp_lg_f16_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x25,0xd0,0x01,0x05,0x02,0x40]

v_cmp_lg_f16_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x25,0xd0,0x01,0x05,0x02,0x60]

v_cmp_lg_f16_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x25,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lg_f16_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x25,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lg_f16_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x25,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lg_f16_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x25,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_f16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x26,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_f16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x26,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_f16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x26,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_f16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x26,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_f16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x26,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_f16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x26,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_f16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x26,0xd0,0xff,0x05,0x02,0x00]

v_cmp_ge_f16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x26,0xd0,0x01,0x04,0x02,0x00]

v_cmp_ge_f16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x26,0xd0,0x65,0x04,0x02,0x00]

v_cmp_ge_f16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x26,0xd0,0x66,0x04,0x02,0x00]

v_cmp_ge_f16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x26,0xd0,0x67,0x04,0x02,0x00]

v_cmp_ge_f16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x26,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_ge_f16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x26,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_ge_f16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x26,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_ge_f16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x26,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_ge_f16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x26,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_ge_f16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x26,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_ge_f16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x26,0xd0,0x80,0x04,0x02,0x00]

v_cmp_ge_f16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x26,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_ge_f16_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x26,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_ge_f16_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x26,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_ge_f16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x26,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_ge_f16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x26,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_ge_f16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x26,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_ge_f16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x26,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_ge_f16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x26,0xd0,0x01,0xff,0x03,0x00]

v_cmp_ge_f16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x26,0xd0,0x01,0x05,0x00,0x00]

v_cmp_ge_f16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x26,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_ge_f16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x26,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_ge_f16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x26,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_ge_f16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x26,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_ge_f16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x26,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_ge_f16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x26,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_ge_f16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x26,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_ge_f16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x26,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_ge_f16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x26,0xd0,0x01,0xff,0x00,0x00]

v_cmp_ge_f16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x26,0xd0,0x01,0x01,0x01,0x00]

v_cmp_ge_f16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x26,0xd0,0x01,0x83,0x01,0x00]

v_cmp_ge_f16_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x26,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_ge_f16_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x26,0xd0,0x01,0xef,0x01,0x00]

v_cmp_ge_f16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x26,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_ge_f16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x26,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_ge_f16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x26,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_ge_f16_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x26,0xd0,0x01,0x05,0x02,0x20]

v_cmp_ge_f16_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x26,0xd0,0x01,0x05,0x02,0x40]

v_cmp_ge_f16_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x26,0xd0,0x01,0x05,0x02,0x60]

v_cmp_ge_f16_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x26,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_f16_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x26,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_f16_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x26,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_f16_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x26,0xd0,0x01,0x05,0x02,0x00]

v_cmp_o_f16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x27,0xd0,0x01,0x05,0x02,0x00]

v_cmp_o_f16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x27,0xd0,0x01,0x05,0x02,0x00]

v_cmp_o_f16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x27,0xd0,0x01,0x05,0x02,0x00]

v_cmp_o_f16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x27,0xd0,0x01,0x05,0x02,0x00]

v_cmp_o_f16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x27,0xd0,0x01,0x05,0x02,0x00]

v_cmp_o_f16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x27,0xd0,0x01,0x05,0x02,0x00]

v_cmp_o_f16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x27,0xd0,0xff,0x05,0x02,0x00]

v_cmp_o_f16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x27,0xd0,0x01,0x04,0x02,0x00]

v_cmp_o_f16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x27,0xd0,0x65,0x04,0x02,0x00]

v_cmp_o_f16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x27,0xd0,0x66,0x04,0x02,0x00]

v_cmp_o_f16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x27,0xd0,0x67,0x04,0x02,0x00]

v_cmp_o_f16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x27,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_o_f16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x27,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_o_f16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x27,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_o_f16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x27,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_o_f16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x27,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_o_f16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x27,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_o_f16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x27,0xd0,0x80,0x04,0x02,0x00]

v_cmp_o_f16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x27,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_o_f16_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x27,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_o_f16_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x27,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_o_f16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x27,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_o_f16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x27,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_o_f16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x27,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_o_f16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x27,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_o_f16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x27,0xd0,0x01,0xff,0x03,0x00]

v_cmp_o_f16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x27,0xd0,0x01,0x05,0x00,0x00]

v_cmp_o_f16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x27,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_o_f16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x27,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_o_f16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x27,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_o_f16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x27,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_o_f16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x27,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_o_f16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x27,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_o_f16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x27,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_o_f16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x27,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_o_f16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x27,0xd0,0x01,0xff,0x00,0x00]

v_cmp_o_f16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x27,0xd0,0x01,0x01,0x01,0x00]

v_cmp_o_f16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x27,0xd0,0x01,0x83,0x01,0x00]

v_cmp_o_f16_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x27,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_o_f16_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x27,0xd0,0x01,0xef,0x01,0x00]

v_cmp_o_f16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x27,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_o_f16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x27,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_o_f16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x27,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_o_f16_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x27,0xd0,0x01,0x05,0x02,0x20]

v_cmp_o_f16_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x27,0xd0,0x01,0x05,0x02,0x40]

v_cmp_o_f16_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x27,0xd0,0x01,0x05,0x02,0x60]

v_cmp_o_f16_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x27,0xd0,0x01,0x05,0x02,0x00]

v_cmp_o_f16_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x27,0xd0,0x01,0x05,0x02,0x00]

v_cmp_o_f16_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x27,0xd0,0x01,0x05,0x02,0x00]

v_cmp_o_f16_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x27,0xd0,0x01,0x05,0x02,0x00]

v_cmp_u_f16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x28,0xd0,0x01,0x05,0x02,0x00]

v_cmp_u_f16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x28,0xd0,0x01,0x05,0x02,0x00]

v_cmp_u_f16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x28,0xd0,0x01,0x05,0x02,0x00]

v_cmp_u_f16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x28,0xd0,0x01,0x05,0x02,0x00]

v_cmp_u_f16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x28,0xd0,0x01,0x05,0x02,0x00]

v_cmp_u_f16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x28,0xd0,0x01,0x05,0x02,0x00]

v_cmp_u_f16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x28,0xd0,0xff,0x05,0x02,0x00]

v_cmp_u_f16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x28,0xd0,0x01,0x04,0x02,0x00]

v_cmp_u_f16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x28,0xd0,0x65,0x04,0x02,0x00]

v_cmp_u_f16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x28,0xd0,0x66,0x04,0x02,0x00]

v_cmp_u_f16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x28,0xd0,0x67,0x04,0x02,0x00]

v_cmp_u_f16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x28,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_u_f16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x28,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_u_f16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x28,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_u_f16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x28,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_u_f16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x28,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_u_f16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x28,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_u_f16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x28,0xd0,0x80,0x04,0x02,0x00]

v_cmp_u_f16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x28,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_u_f16_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x28,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_u_f16_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x28,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_u_f16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x28,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_u_f16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x28,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_u_f16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x28,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_u_f16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x28,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_u_f16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x28,0xd0,0x01,0xff,0x03,0x00]

v_cmp_u_f16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x28,0xd0,0x01,0x05,0x00,0x00]

v_cmp_u_f16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x28,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_u_f16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x28,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_u_f16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x28,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_u_f16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x28,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_u_f16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x28,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_u_f16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x28,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_u_f16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x28,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_u_f16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x28,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_u_f16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x28,0xd0,0x01,0xff,0x00,0x00]

v_cmp_u_f16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x28,0xd0,0x01,0x01,0x01,0x00]

v_cmp_u_f16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x28,0xd0,0x01,0x83,0x01,0x00]

v_cmp_u_f16_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x28,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_u_f16_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x28,0xd0,0x01,0xef,0x01,0x00]

v_cmp_u_f16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x28,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_u_f16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x28,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_u_f16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x28,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_u_f16_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x28,0xd0,0x01,0x05,0x02,0x20]

v_cmp_u_f16_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x28,0xd0,0x01,0x05,0x02,0x40]

v_cmp_u_f16_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x28,0xd0,0x01,0x05,0x02,0x60]

v_cmp_u_f16_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x28,0xd0,0x01,0x05,0x02,0x00]

v_cmp_u_f16_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x28,0xd0,0x01,0x05,0x02,0x00]

v_cmp_u_f16_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x28,0xd0,0x01,0x05,0x02,0x00]

v_cmp_u_f16_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x28,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nge_f16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x29,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nge_f16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x29,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nge_f16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x29,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nge_f16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x29,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nge_f16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x29,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nge_f16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x29,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nge_f16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x29,0xd0,0xff,0x05,0x02,0x00]

v_cmp_nge_f16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x29,0xd0,0x01,0x04,0x02,0x00]

v_cmp_nge_f16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x29,0xd0,0x65,0x04,0x02,0x00]

v_cmp_nge_f16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x29,0xd0,0x66,0x04,0x02,0x00]

v_cmp_nge_f16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x29,0xd0,0x67,0x04,0x02,0x00]

v_cmp_nge_f16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x29,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_nge_f16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x29,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_nge_f16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x29,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_nge_f16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x29,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_nge_f16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x29,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_nge_f16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x29,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_nge_f16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x29,0xd0,0x80,0x04,0x02,0x00]

v_cmp_nge_f16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x29,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_nge_f16_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x29,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_nge_f16_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x29,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_nge_f16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x29,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_nge_f16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x29,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_nge_f16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x29,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_nge_f16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x29,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_nge_f16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x29,0xd0,0x01,0xff,0x03,0x00]

v_cmp_nge_f16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x29,0xd0,0x01,0x05,0x00,0x00]

v_cmp_nge_f16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x29,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_nge_f16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x29,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_nge_f16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x29,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_nge_f16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x29,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_nge_f16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x29,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_nge_f16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x29,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_nge_f16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x29,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_nge_f16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x29,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_nge_f16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x29,0xd0,0x01,0xff,0x00,0x00]

v_cmp_nge_f16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x29,0xd0,0x01,0x01,0x01,0x00]

v_cmp_nge_f16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x29,0xd0,0x01,0x83,0x01,0x00]

v_cmp_nge_f16_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x29,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_nge_f16_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x29,0xd0,0x01,0xef,0x01,0x00]

v_cmp_nge_f16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x29,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_nge_f16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x29,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_nge_f16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x29,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_nge_f16_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x29,0xd0,0x01,0x05,0x02,0x20]

v_cmp_nge_f16_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x29,0xd0,0x01,0x05,0x02,0x40]

v_cmp_nge_f16_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x29,0xd0,0x01,0x05,0x02,0x60]

v_cmp_nge_f16_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x29,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nge_f16_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x29,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nge_f16_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x29,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nge_f16_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x29,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlg_f16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x2a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlg_f16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x2a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlg_f16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x2a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlg_f16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x2a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlg_f16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x2a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlg_f16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x2a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlg_f16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x2a,0xd0,0xff,0x05,0x02,0x00]

v_cmp_nlg_f16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x2a,0xd0,0x01,0x04,0x02,0x00]

v_cmp_nlg_f16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x2a,0xd0,0x65,0x04,0x02,0x00]

v_cmp_nlg_f16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x2a,0xd0,0x66,0x04,0x02,0x00]

v_cmp_nlg_f16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x2a,0xd0,0x67,0x04,0x02,0x00]

v_cmp_nlg_f16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x2a,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_nlg_f16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x2a,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_nlg_f16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x2a,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_nlg_f16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x2a,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_nlg_f16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x2a,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_nlg_f16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x2a,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_nlg_f16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x2a,0xd0,0x80,0x04,0x02,0x00]

v_cmp_nlg_f16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x2a,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_nlg_f16_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x2a,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_nlg_f16_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x2a,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_nlg_f16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x2a,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_nlg_f16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x2a,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_nlg_f16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x2a,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_nlg_f16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x2a,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_nlg_f16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x2a,0xd0,0x01,0xff,0x03,0x00]

v_cmp_nlg_f16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x2a,0xd0,0x01,0x05,0x00,0x00]

v_cmp_nlg_f16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x2a,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_nlg_f16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x2a,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_nlg_f16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x2a,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_nlg_f16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x2a,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_nlg_f16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x2a,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_nlg_f16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x2a,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_nlg_f16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x2a,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_nlg_f16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x2a,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_nlg_f16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x2a,0xd0,0x01,0xff,0x00,0x00]

v_cmp_nlg_f16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x2a,0xd0,0x01,0x01,0x01,0x00]

v_cmp_nlg_f16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x2a,0xd0,0x01,0x83,0x01,0x00]

v_cmp_nlg_f16_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x2a,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_nlg_f16_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x2a,0xd0,0x01,0xef,0x01,0x00]

v_cmp_nlg_f16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x2a,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_nlg_f16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x2a,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_nlg_f16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x2a,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_nlg_f16_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x2a,0xd0,0x01,0x05,0x02,0x20]

v_cmp_nlg_f16_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x2a,0xd0,0x01,0x05,0x02,0x40]

v_cmp_nlg_f16_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x2a,0xd0,0x01,0x05,0x02,0x60]

v_cmp_nlg_f16_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x2a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlg_f16_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x2a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlg_f16_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x2a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlg_f16_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x2a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ngt_f16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x2b,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ngt_f16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x2b,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ngt_f16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x2b,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ngt_f16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x2b,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ngt_f16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x2b,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ngt_f16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x2b,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ngt_f16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x2b,0xd0,0xff,0x05,0x02,0x00]

v_cmp_ngt_f16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x2b,0xd0,0x01,0x04,0x02,0x00]

v_cmp_ngt_f16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x2b,0xd0,0x65,0x04,0x02,0x00]

v_cmp_ngt_f16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x2b,0xd0,0x66,0x04,0x02,0x00]

v_cmp_ngt_f16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x2b,0xd0,0x67,0x04,0x02,0x00]

v_cmp_ngt_f16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x2b,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_ngt_f16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x2b,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_ngt_f16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x2b,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_ngt_f16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x2b,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_ngt_f16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x2b,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_ngt_f16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x2b,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_ngt_f16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x2b,0xd0,0x80,0x04,0x02,0x00]

v_cmp_ngt_f16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x2b,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_ngt_f16_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x2b,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_ngt_f16_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x2b,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_ngt_f16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x2b,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_ngt_f16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x2b,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_ngt_f16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x2b,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_ngt_f16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x2b,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_ngt_f16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x2b,0xd0,0x01,0xff,0x03,0x00]

v_cmp_ngt_f16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x2b,0xd0,0x01,0x05,0x00,0x00]

v_cmp_ngt_f16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x2b,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_ngt_f16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x2b,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_ngt_f16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x2b,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_ngt_f16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x2b,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_ngt_f16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x2b,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_ngt_f16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x2b,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_ngt_f16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x2b,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_ngt_f16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x2b,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_ngt_f16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x2b,0xd0,0x01,0xff,0x00,0x00]

v_cmp_ngt_f16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x2b,0xd0,0x01,0x01,0x01,0x00]

v_cmp_ngt_f16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x2b,0xd0,0x01,0x83,0x01,0x00]

v_cmp_ngt_f16_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x2b,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_ngt_f16_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x2b,0xd0,0x01,0xef,0x01,0x00]

v_cmp_ngt_f16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x2b,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_ngt_f16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x2b,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_ngt_f16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x2b,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_ngt_f16_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x2b,0xd0,0x01,0x05,0x02,0x20]

v_cmp_ngt_f16_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x2b,0xd0,0x01,0x05,0x02,0x40]

v_cmp_ngt_f16_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x2b,0xd0,0x01,0x05,0x02,0x60]

v_cmp_ngt_f16_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x2b,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ngt_f16_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x2b,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ngt_f16_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x2b,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ngt_f16_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x2b,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nle_f16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x2c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nle_f16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x2c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nle_f16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x2c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nle_f16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x2c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nle_f16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x2c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nle_f16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x2c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nle_f16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x2c,0xd0,0xff,0x05,0x02,0x00]

v_cmp_nle_f16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x2c,0xd0,0x01,0x04,0x02,0x00]

v_cmp_nle_f16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x2c,0xd0,0x65,0x04,0x02,0x00]

v_cmp_nle_f16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x2c,0xd0,0x66,0x04,0x02,0x00]

v_cmp_nle_f16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x2c,0xd0,0x67,0x04,0x02,0x00]

v_cmp_nle_f16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x2c,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_nle_f16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x2c,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_nle_f16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x2c,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_nle_f16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x2c,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_nle_f16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x2c,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_nle_f16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x2c,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_nle_f16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x2c,0xd0,0x80,0x04,0x02,0x00]

v_cmp_nle_f16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x2c,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_nle_f16_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x2c,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_nle_f16_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x2c,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_nle_f16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x2c,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_nle_f16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x2c,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_nle_f16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x2c,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_nle_f16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x2c,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_nle_f16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x2c,0xd0,0x01,0xff,0x03,0x00]

v_cmp_nle_f16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x2c,0xd0,0x01,0x05,0x00,0x00]

v_cmp_nle_f16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x2c,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_nle_f16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x2c,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_nle_f16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x2c,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_nle_f16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x2c,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_nle_f16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x2c,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_nle_f16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x2c,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_nle_f16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x2c,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_nle_f16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x2c,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_nle_f16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x2c,0xd0,0x01,0xff,0x00,0x00]

v_cmp_nle_f16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x2c,0xd0,0x01,0x01,0x01,0x00]

v_cmp_nle_f16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x2c,0xd0,0x01,0x83,0x01,0x00]

v_cmp_nle_f16_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x2c,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_nle_f16_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x2c,0xd0,0x01,0xef,0x01,0x00]

v_cmp_nle_f16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x2c,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_nle_f16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x2c,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_nle_f16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x2c,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_nle_f16_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x2c,0xd0,0x01,0x05,0x02,0x20]

v_cmp_nle_f16_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x2c,0xd0,0x01,0x05,0x02,0x40]

v_cmp_nle_f16_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x2c,0xd0,0x01,0x05,0x02,0x60]

v_cmp_nle_f16_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x2c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nle_f16_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x2c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nle_f16_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x2c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nle_f16_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x2c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_neq_f16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x2d,0xd0,0x01,0x05,0x02,0x00]

v_cmp_neq_f16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x2d,0xd0,0x01,0x05,0x02,0x00]

v_cmp_neq_f16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x2d,0xd0,0x01,0x05,0x02,0x00]

v_cmp_neq_f16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x2d,0xd0,0x01,0x05,0x02,0x00]

v_cmp_neq_f16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x2d,0xd0,0x01,0x05,0x02,0x00]

v_cmp_neq_f16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x2d,0xd0,0x01,0x05,0x02,0x00]

v_cmp_neq_f16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x2d,0xd0,0xff,0x05,0x02,0x00]

v_cmp_neq_f16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x2d,0xd0,0x01,0x04,0x02,0x00]

v_cmp_neq_f16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x2d,0xd0,0x65,0x04,0x02,0x00]

v_cmp_neq_f16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x2d,0xd0,0x66,0x04,0x02,0x00]

v_cmp_neq_f16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x2d,0xd0,0x67,0x04,0x02,0x00]

v_cmp_neq_f16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x2d,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_neq_f16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x2d,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_neq_f16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x2d,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_neq_f16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x2d,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_neq_f16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x2d,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_neq_f16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x2d,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_neq_f16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x2d,0xd0,0x80,0x04,0x02,0x00]

v_cmp_neq_f16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x2d,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_neq_f16_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x2d,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_neq_f16_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x2d,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_neq_f16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x2d,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_neq_f16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x2d,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_neq_f16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x2d,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_neq_f16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x2d,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_neq_f16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x2d,0xd0,0x01,0xff,0x03,0x00]

v_cmp_neq_f16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x2d,0xd0,0x01,0x05,0x00,0x00]

v_cmp_neq_f16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x2d,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_neq_f16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x2d,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_neq_f16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x2d,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_neq_f16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x2d,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_neq_f16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x2d,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_neq_f16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x2d,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_neq_f16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x2d,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_neq_f16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x2d,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_neq_f16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x2d,0xd0,0x01,0xff,0x00,0x00]

v_cmp_neq_f16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x2d,0xd0,0x01,0x01,0x01,0x00]

v_cmp_neq_f16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x2d,0xd0,0x01,0x83,0x01,0x00]

v_cmp_neq_f16_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x2d,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_neq_f16_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x2d,0xd0,0x01,0xef,0x01,0x00]

v_cmp_neq_f16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x2d,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_neq_f16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x2d,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_neq_f16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x2d,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_neq_f16_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x2d,0xd0,0x01,0x05,0x02,0x20]

v_cmp_neq_f16_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x2d,0xd0,0x01,0x05,0x02,0x40]

v_cmp_neq_f16_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x2d,0xd0,0x01,0x05,0x02,0x60]

v_cmp_neq_f16_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x2d,0xd0,0x01,0x05,0x02,0x00]

v_cmp_neq_f16_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x2d,0xd0,0x01,0x05,0x02,0x00]

v_cmp_neq_f16_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x2d,0xd0,0x01,0x05,0x02,0x00]

v_cmp_neq_f16_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x2d,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlt_f16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x2e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlt_f16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x2e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlt_f16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x2e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlt_f16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x2e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlt_f16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x2e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlt_f16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x2e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlt_f16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x2e,0xd0,0xff,0x05,0x02,0x00]

v_cmp_nlt_f16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x2e,0xd0,0x01,0x04,0x02,0x00]

v_cmp_nlt_f16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x2e,0xd0,0x65,0x04,0x02,0x00]

v_cmp_nlt_f16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x2e,0xd0,0x66,0x04,0x02,0x00]

v_cmp_nlt_f16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x2e,0xd0,0x67,0x04,0x02,0x00]

v_cmp_nlt_f16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x2e,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_nlt_f16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x2e,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_nlt_f16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x2e,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_nlt_f16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x2e,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_nlt_f16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x2e,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_nlt_f16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x2e,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_nlt_f16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x2e,0xd0,0x80,0x04,0x02,0x00]

v_cmp_nlt_f16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x2e,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_nlt_f16_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x2e,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_nlt_f16_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x2e,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_nlt_f16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x2e,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_nlt_f16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x2e,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_nlt_f16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x2e,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_nlt_f16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x2e,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_nlt_f16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x2e,0xd0,0x01,0xff,0x03,0x00]

v_cmp_nlt_f16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x2e,0xd0,0x01,0x05,0x00,0x00]

v_cmp_nlt_f16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x2e,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_nlt_f16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x2e,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_nlt_f16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x2e,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_nlt_f16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x2e,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_nlt_f16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x2e,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_nlt_f16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x2e,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_nlt_f16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x2e,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_nlt_f16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x2e,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_nlt_f16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x2e,0xd0,0x01,0xff,0x00,0x00]

v_cmp_nlt_f16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x2e,0xd0,0x01,0x01,0x01,0x00]

v_cmp_nlt_f16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x2e,0xd0,0x01,0x83,0x01,0x00]

v_cmp_nlt_f16_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x2e,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_nlt_f16_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x2e,0xd0,0x01,0xef,0x01,0x00]

v_cmp_nlt_f16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x2e,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_nlt_f16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x2e,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_nlt_f16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x2e,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_nlt_f16_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x2e,0xd0,0x01,0x05,0x02,0x20]

v_cmp_nlt_f16_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x2e,0xd0,0x01,0x05,0x02,0x40]

v_cmp_nlt_f16_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x2e,0xd0,0x01,0x05,0x02,0x60]

v_cmp_nlt_f16_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x2e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlt_f16_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x2e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlt_f16_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x2e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlt_f16_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x2e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_tru_f16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x2f,0xd0,0x01,0x05,0x02,0x00]

v_cmp_tru_f16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x2f,0xd0,0x01,0x05,0x02,0x00]

v_cmp_tru_f16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x2f,0xd0,0x01,0x05,0x02,0x00]

v_cmp_tru_f16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x2f,0xd0,0x01,0x05,0x02,0x00]

v_cmp_tru_f16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x2f,0xd0,0x01,0x05,0x02,0x00]

v_cmp_tru_f16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x2f,0xd0,0x01,0x05,0x02,0x00]

v_cmp_tru_f16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x2f,0xd0,0xff,0x05,0x02,0x00]

v_cmp_tru_f16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x2f,0xd0,0x01,0x04,0x02,0x00]

v_cmp_tru_f16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x2f,0xd0,0x65,0x04,0x02,0x00]

v_cmp_tru_f16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x2f,0xd0,0x66,0x04,0x02,0x00]

v_cmp_tru_f16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x2f,0xd0,0x67,0x04,0x02,0x00]

v_cmp_tru_f16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x2f,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_tru_f16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x2f,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_tru_f16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x2f,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_tru_f16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x2f,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_tru_f16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x2f,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_tru_f16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x2f,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_tru_f16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x2f,0xd0,0x80,0x04,0x02,0x00]

v_cmp_tru_f16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x2f,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_tru_f16_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x2f,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_tru_f16_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x2f,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_tru_f16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x2f,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_tru_f16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x2f,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_tru_f16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x2f,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_tru_f16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x2f,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_tru_f16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x2f,0xd0,0x01,0xff,0x03,0x00]

v_cmp_tru_f16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x2f,0xd0,0x01,0x05,0x00,0x00]

v_cmp_tru_f16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x2f,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_tru_f16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x2f,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_tru_f16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x2f,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_tru_f16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x2f,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_tru_f16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x2f,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_tru_f16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x2f,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_tru_f16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x2f,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_tru_f16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x2f,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_tru_f16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x2f,0xd0,0x01,0xff,0x00,0x00]

v_cmp_tru_f16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x2f,0xd0,0x01,0x01,0x01,0x00]

v_cmp_tru_f16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x2f,0xd0,0x01,0x83,0x01,0x00]

v_cmp_tru_f16_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x2f,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_tru_f16_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x2f,0xd0,0x01,0xef,0x01,0x00]

v_cmp_tru_f16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x2f,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_tru_f16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x2f,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_tru_f16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x2f,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_tru_f16_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x2f,0xd0,0x01,0x05,0x02,0x20]

v_cmp_tru_f16_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x2f,0xd0,0x01,0x05,0x02,0x40]

v_cmp_tru_f16_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x2f,0xd0,0x01,0x05,0x02,0x60]

v_cmp_tru_f16_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x2f,0xd0,0x01,0x05,0x02,0x00]

v_cmp_tru_f16_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x2f,0xd0,0x01,0x05,0x02,0x00]

v_cmp_tru_f16_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x2f,0xd0,0x01,0x05,0x02,0x00]

v_cmp_tru_f16_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x2f,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_f16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x30,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_f16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x30,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_f16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x30,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_f16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x30,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_f16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x30,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_f16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x30,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_f16_e64 exec, v1, v2
// CHECK: [0x7e,0x00,0x30,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_f16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x30,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_f_f16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x30,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_f_f16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x30,0xd0,0x65,0x04,0x02,0x00]

v_cmpx_f_f16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x30,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_f_f16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x30,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_f_f16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x30,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_f_f16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x30,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_f_f16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x30,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_f_f16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x30,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_f_f16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x30,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_f_f16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x30,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_f_f16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x30,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_f_f16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x30,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_f_f16_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x30,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_f_f16_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x30,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_f_f16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x30,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_f_f16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x30,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_f_f16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x30,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_f_f16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x30,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_f_f16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x30,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_f_f16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x30,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_f_f16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x30,0xd0,0x01,0xcb,0x00,0x00]

v_cmpx_f_f16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x30,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_f_f16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x30,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_f_f16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x30,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_f_f16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x30,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_f_f16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x30,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_f_f16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x30,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_f_f16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x30,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_f_f16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x30,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_f_f16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x30,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_f_f16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x30,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_f_f16_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x30,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_f_f16_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x30,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_f_f16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x30,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_f_f16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x30,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_f_f16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x30,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_f_f16_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x30,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_f_f16_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x30,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_f_f16_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x30,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_f_f16_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x30,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_f16_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x30,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_f16_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x30,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_f16_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x30,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_f16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x31,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_f16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x31,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_f16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x31,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_f16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x31,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_f16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x31,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_f16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x31,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_f16_e64 exec, v1, v2
// CHECK: [0x7e,0x00,0x31,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_f16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x31,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_lt_f16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x31,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_lt_f16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x31,0xd0,0x65,0x04,0x02,0x00]

v_cmpx_lt_f16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x31,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_lt_f16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x31,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_lt_f16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x31,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_lt_f16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x31,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_lt_f16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x31,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_lt_f16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x31,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_lt_f16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x31,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_lt_f16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x31,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_lt_f16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x31,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_lt_f16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x31,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_lt_f16_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x31,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_lt_f16_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x31,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_lt_f16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x31,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_lt_f16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x31,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_lt_f16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x31,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_lt_f16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x31,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_lt_f16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x31,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_lt_f16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x31,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_lt_f16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x31,0xd0,0x01,0xcb,0x00,0x00]

v_cmpx_lt_f16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x31,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_lt_f16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x31,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_lt_f16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x31,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_lt_f16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x31,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_lt_f16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x31,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_lt_f16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x31,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_lt_f16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x31,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_lt_f16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x31,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_lt_f16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x31,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_lt_f16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x31,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_lt_f16_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x31,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_lt_f16_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x31,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_lt_f16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x31,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_lt_f16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x31,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_lt_f16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x31,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_lt_f16_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x31,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_lt_f16_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x31,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_lt_f16_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x31,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_lt_f16_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x31,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_f16_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x31,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_f16_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x31,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_f16_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x31,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_f16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x32,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_f16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x32,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_f16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x32,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_f16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x32,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_f16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x32,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_f16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x32,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_f16_e64 exec, v1, v2
// CHECK: [0x7e,0x00,0x32,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_f16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x32,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_eq_f16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x32,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_eq_f16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x32,0xd0,0x65,0x04,0x02,0x00]

v_cmpx_eq_f16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x32,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_eq_f16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x32,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_eq_f16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x32,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_eq_f16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x32,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_eq_f16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x32,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_eq_f16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x32,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_eq_f16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x32,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_eq_f16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x32,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_eq_f16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x32,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_eq_f16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x32,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_eq_f16_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x32,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_eq_f16_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x32,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_eq_f16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x32,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_eq_f16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x32,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_eq_f16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x32,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_eq_f16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x32,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_eq_f16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x32,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_eq_f16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x32,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_eq_f16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x32,0xd0,0x01,0xcb,0x00,0x00]

v_cmpx_eq_f16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x32,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_eq_f16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x32,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_eq_f16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x32,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_eq_f16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x32,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_eq_f16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x32,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_eq_f16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x32,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_eq_f16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x32,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_eq_f16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x32,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_eq_f16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x32,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_eq_f16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x32,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_eq_f16_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x32,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_eq_f16_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x32,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_eq_f16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x32,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_eq_f16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x32,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_eq_f16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x32,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_eq_f16_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x32,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_eq_f16_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x32,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_eq_f16_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x32,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_eq_f16_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x32,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_f16_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x32,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_f16_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x32,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_f16_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x32,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_f16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x33,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_f16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x33,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_f16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x33,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_f16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x33,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_f16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x33,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_f16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x33,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_f16_e64 exec, v1, v2
// CHECK: [0x7e,0x00,0x33,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_f16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x33,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_le_f16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x33,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_le_f16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x33,0xd0,0x65,0x04,0x02,0x00]

v_cmpx_le_f16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x33,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_le_f16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x33,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_le_f16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x33,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_le_f16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x33,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_le_f16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x33,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_le_f16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x33,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_le_f16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x33,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_le_f16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x33,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_le_f16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x33,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_le_f16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x33,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_le_f16_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x33,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_le_f16_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x33,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_le_f16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x33,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_le_f16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x33,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_le_f16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x33,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_le_f16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x33,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_le_f16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x33,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_le_f16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x33,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_le_f16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x33,0xd0,0x01,0xcb,0x00,0x00]

v_cmpx_le_f16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x33,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_le_f16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x33,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_le_f16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x33,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_le_f16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x33,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_le_f16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x33,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_le_f16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x33,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_le_f16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x33,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_le_f16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x33,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_le_f16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x33,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_le_f16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x33,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_le_f16_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x33,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_le_f16_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x33,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_le_f16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x33,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_le_f16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x33,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_le_f16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x33,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_le_f16_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x33,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_le_f16_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x33,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_le_f16_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x33,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_le_f16_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x33,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_f16_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x33,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_f16_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x33,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_f16_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x33,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_f16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x34,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_f16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x34,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_f16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x34,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_f16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x34,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_f16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x34,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_f16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x34,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_f16_e64 exec, v1, v2
// CHECK: [0x7e,0x00,0x34,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_f16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x34,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_gt_f16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x34,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_gt_f16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x34,0xd0,0x65,0x04,0x02,0x00]

v_cmpx_gt_f16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x34,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_gt_f16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x34,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_gt_f16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x34,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_gt_f16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x34,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_gt_f16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x34,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_gt_f16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x34,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_gt_f16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x34,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_gt_f16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x34,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_gt_f16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x34,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_gt_f16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x34,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_gt_f16_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x34,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_gt_f16_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x34,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_gt_f16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x34,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_gt_f16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x34,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_gt_f16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x34,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_gt_f16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x34,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_gt_f16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x34,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_gt_f16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x34,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_gt_f16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x34,0xd0,0x01,0xcb,0x00,0x00]

v_cmpx_gt_f16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x34,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_gt_f16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x34,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_gt_f16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x34,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_gt_f16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x34,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_gt_f16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x34,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_gt_f16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x34,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_gt_f16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x34,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_gt_f16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x34,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_gt_f16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x34,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_gt_f16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x34,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_gt_f16_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x34,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_gt_f16_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x34,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_gt_f16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x34,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_gt_f16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x34,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_gt_f16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x34,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_gt_f16_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x34,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_gt_f16_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x34,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_gt_f16_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x34,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_gt_f16_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x34,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_f16_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x34,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_f16_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x34,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_f16_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x34,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lg_f16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x35,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lg_f16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x35,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lg_f16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x35,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lg_f16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x35,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lg_f16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x35,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lg_f16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x35,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lg_f16_e64 exec, v1, v2
// CHECK: [0x7e,0x00,0x35,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lg_f16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x35,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_lg_f16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x35,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_lg_f16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x35,0xd0,0x65,0x04,0x02,0x00]

v_cmpx_lg_f16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x35,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_lg_f16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x35,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_lg_f16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x35,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_lg_f16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x35,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_lg_f16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x35,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_lg_f16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x35,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_lg_f16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x35,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_lg_f16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x35,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_lg_f16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x35,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_lg_f16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x35,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_lg_f16_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x35,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_lg_f16_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x35,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_lg_f16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x35,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_lg_f16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x35,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_lg_f16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x35,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_lg_f16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x35,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_lg_f16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x35,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_lg_f16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x35,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_lg_f16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x35,0xd0,0x01,0xcb,0x00,0x00]

v_cmpx_lg_f16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x35,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_lg_f16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x35,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_lg_f16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x35,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_lg_f16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x35,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_lg_f16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x35,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_lg_f16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x35,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_lg_f16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x35,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_lg_f16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x35,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_lg_f16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x35,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_lg_f16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x35,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_lg_f16_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x35,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_lg_f16_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x35,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_lg_f16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x35,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_lg_f16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x35,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_lg_f16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x35,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_lg_f16_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x35,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_lg_f16_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x35,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_lg_f16_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x35,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_lg_f16_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x35,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lg_f16_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x35,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lg_f16_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x35,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lg_f16_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x35,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_f16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x36,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_f16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x36,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_f16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x36,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_f16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x36,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_f16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x36,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_f16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x36,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_f16_e64 exec, v1, v2
// CHECK: [0x7e,0x00,0x36,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_f16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x36,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_ge_f16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x36,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_ge_f16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x36,0xd0,0x65,0x04,0x02,0x00]

v_cmpx_ge_f16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x36,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_ge_f16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x36,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_ge_f16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x36,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_ge_f16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x36,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_ge_f16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x36,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_ge_f16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x36,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_ge_f16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x36,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_ge_f16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x36,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_ge_f16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x36,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_ge_f16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x36,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_ge_f16_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x36,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_ge_f16_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x36,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_ge_f16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x36,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_ge_f16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x36,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_ge_f16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x36,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_ge_f16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x36,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_ge_f16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x36,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_ge_f16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x36,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_ge_f16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x36,0xd0,0x01,0xcb,0x00,0x00]

v_cmpx_ge_f16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x36,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_ge_f16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x36,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_ge_f16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x36,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_ge_f16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x36,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_ge_f16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x36,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_ge_f16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x36,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_ge_f16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x36,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_ge_f16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x36,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_ge_f16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x36,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_ge_f16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x36,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_ge_f16_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x36,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_ge_f16_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x36,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_ge_f16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x36,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_ge_f16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x36,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_ge_f16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x36,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_ge_f16_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x36,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_ge_f16_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x36,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_ge_f16_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x36,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_ge_f16_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x36,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_f16_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x36,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_f16_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x36,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_f16_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x36,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_o_f16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x37,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_o_f16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x37,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_o_f16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x37,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_o_f16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x37,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_o_f16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x37,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_o_f16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x37,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_o_f16_e64 exec, v1, v2
// CHECK: [0x7e,0x00,0x37,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_o_f16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x37,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_o_f16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x37,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_o_f16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x37,0xd0,0x65,0x04,0x02,0x00]

v_cmpx_o_f16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x37,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_o_f16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x37,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_o_f16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x37,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_o_f16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x37,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_o_f16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x37,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_o_f16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x37,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_o_f16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x37,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_o_f16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x37,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_o_f16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x37,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_o_f16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x37,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_o_f16_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x37,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_o_f16_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x37,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_o_f16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x37,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_o_f16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x37,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_o_f16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x37,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_o_f16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x37,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_o_f16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x37,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_o_f16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x37,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_o_f16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x37,0xd0,0x01,0xcb,0x00,0x00]

v_cmpx_o_f16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x37,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_o_f16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x37,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_o_f16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x37,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_o_f16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x37,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_o_f16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x37,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_o_f16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x37,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_o_f16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x37,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_o_f16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x37,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_o_f16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x37,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_o_f16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x37,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_o_f16_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x37,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_o_f16_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x37,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_o_f16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x37,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_o_f16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x37,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_o_f16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x37,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_o_f16_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x37,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_o_f16_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x37,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_o_f16_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x37,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_o_f16_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x37,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_o_f16_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x37,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_o_f16_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x37,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_o_f16_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x37,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_u_f16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x38,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_u_f16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x38,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_u_f16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x38,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_u_f16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x38,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_u_f16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x38,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_u_f16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x38,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_u_f16_e64 exec, v1, v2
// CHECK: [0x7e,0x00,0x38,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_u_f16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x38,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_u_f16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x38,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_u_f16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x38,0xd0,0x65,0x04,0x02,0x00]

v_cmpx_u_f16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x38,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_u_f16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x38,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_u_f16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x38,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_u_f16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x38,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_u_f16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x38,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_u_f16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x38,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_u_f16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x38,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_u_f16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x38,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_u_f16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x38,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_u_f16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x38,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_u_f16_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x38,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_u_f16_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x38,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_u_f16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x38,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_u_f16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x38,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_u_f16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x38,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_u_f16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x38,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_u_f16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x38,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_u_f16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x38,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_u_f16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x38,0xd0,0x01,0xcb,0x00,0x00]

v_cmpx_u_f16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x38,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_u_f16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x38,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_u_f16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x38,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_u_f16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x38,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_u_f16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x38,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_u_f16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x38,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_u_f16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x38,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_u_f16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x38,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_u_f16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x38,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_u_f16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x38,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_u_f16_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x38,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_u_f16_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x38,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_u_f16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x38,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_u_f16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x38,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_u_f16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x38,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_u_f16_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x38,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_u_f16_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x38,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_u_f16_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x38,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_u_f16_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x38,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_u_f16_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x38,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_u_f16_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x38,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_u_f16_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x38,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nge_f16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x39,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nge_f16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x39,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nge_f16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x39,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nge_f16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x39,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nge_f16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x39,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nge_f16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x39,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nge_f16_e64 exec, v1, v2
// CHECK: [0x7e,0x00,0x39,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nge_f16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x39,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_nge_f16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x39,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_nge_f16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x39,0xd0,0x65,0x04,0x02,0x00]

v_cmpx_nge_f16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x39,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_nge_f16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x39,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_nge_f16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x39,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_nge_f16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x39,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_nge_f16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x39,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_nge_f16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x39,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_nge_f16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x39,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_nge_f16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x39,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_nge_f16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x39,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_nge_f16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x39,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_nge_f16_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x39,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_nge_f16_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x39,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_nge_f16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x39,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_nge_f16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x39,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_nge_f16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x39,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_nge_f16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x39,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_nge_f16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x39,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_nge_f16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x39,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_nge_f16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x39,0xd0,0x01,0xcb,0x00,0x00]

v_cmpx_nge_f16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x39,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_nge_f16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x39,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_nge_f16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x39,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_nge_f16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x39,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_nge_f16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x39,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_nge_f16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x39,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_nge_f16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x39,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_nge_f16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x39,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_nge_f16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x39,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_nge_f16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x39,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_nge_f16_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x39,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_nge_f16_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x39,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_nge_f16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x39,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_nge_f16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x39,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_nge_f16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x39,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_nge_f16_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x39,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_nge_f16_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x39,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_nge_f16_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x39,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_nge_f16_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x39,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nge_f16_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x39,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nge_f16_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x39,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nge_f16_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x39,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlg_f16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x3a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlg_f16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x3a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlg_f16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x3a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlg_f16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x3a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlg_f16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x3a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlg_f16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x3a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlg_f16_e64 exec, v1, v2
// CHECK: [0x7e,0x00,0x3a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlg_f16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x3a,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_nlg_f16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x3a,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_nlg_f16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x3a,0xd0,0x65,0x04,0x02,0x00]

v_cmpx_nlg_f16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x3a,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_nlg_f16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x3a,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_nlg_f16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x3a,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_nlg_f16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x3a,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_nlg_f16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x3a,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_nlg_f16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x3a,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_nlg_f16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x3a,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_nlg_f16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x3a,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_nlg_f16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x3a,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_nlg_f16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x3a,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_nlg_f16_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x3a,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_nlg_f16_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x3a,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_nlg_f16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x3a,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_nlg_f16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x3a,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_nlg_f16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x3a,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_nlg_f16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x3a,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_nlg_f16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x3a,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_nlg_f16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x3a,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_nlg_f16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x3a,0xd0,0x01,0xcb,0x00,0x00]

v_cmpx_nlg_f16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x3a,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_nlg_f16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x3a,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_nlg_f16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x3a,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_nlg_f16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x3a,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_nlg_f16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x3a,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_nlg_f16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x3a,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_nlg_f16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x3a,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_nlg_f16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x3a,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_nlg_f16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x3a,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_nlg_f16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x3a,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_nlg_f16_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x3a,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_nlg_f16_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x3a,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_nlg_f16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x3a,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_nlg_f16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x3a,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_nlg_f16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x3a,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_nlg_f16_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x3a,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_nlg_f16_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x3a,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_nlg_f16_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x3a,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_nlg_f16_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x3a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlg_f16_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x3a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlg_f16_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x3a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlg_f16_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x3a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ngt_f16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x3b,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ngt_f16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x3b,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ngt_f16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x3b,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ngt_f16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x3b,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ngt_f16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x3b,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ngt_f16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x3b,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ngt_f16_e64 exec, v1, v2
// CHECK: [0x7e,0x00,0x3b,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ngt_f16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x3b,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_ngt_f16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x3b,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_ngt_f16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x3b,0xd0,0x65,0x04,0x02,0x00]

v_cmpx_ngt_f16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x3b,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_ngt_f16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x3b,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_ngt_f16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x3b,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_ngt_f16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x3b,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_ngt_f16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x3b,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_ngt_f16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x3b,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_ngt_f16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x3b,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_ngt_f16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x3b,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_ngt_f16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x3b,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_ngt_f16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x3b,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_ngt_f16_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x3b,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_ngt_f16_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x3b,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_ngt_f16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x3b,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_ngt_f16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x3b,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_ngt_f16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x3b,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_ngt_f16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x3b,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_ngt_f16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x3b,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_ngt_f16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x3b,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_ngt_f16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x3b,0xd0,0x01,0xcb,0x00,0x00]

v_cmpx_ngt_f16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x3b,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_ngt_f16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x3b,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_ngt_f16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x3b,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_ngt_f16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x3b,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_ngt_f16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x3b,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_ngt_f16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x3b,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_ngt_f16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x3b,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_ngt_f16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x3b,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_ngt_f16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x3b,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_ngt_f16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x3b,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_ngt_f16_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x3b,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_ngt_f16_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x3b,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_ngt_f16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x3b,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_ngt_f16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x3b,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_ngt_f16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x3b,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_ngt_f16_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x3b,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_ngt_f16_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x3b,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_ngt_f16_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x3b,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_ngt_f16_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x3b,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ngt_f16_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x3b,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ngt_f16_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x3b,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ngt_f16_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x3b,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nle_f16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x3c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nle_f16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x3c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nle_f16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x3c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nle_f16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x3c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nle_f16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x3c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nle_f16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x3c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nle_f16_e64 exec, v1, v2
// CHECK: [0x7e,0x00,0x3c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nle_f16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x3c,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_nle_f16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x3c,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_nle_f16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x3c,0xd0,0x65,0x04,0x02,0x00]

v_cmpx_nle_f16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x3c,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_nle_f16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x3c,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_nle_f16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x3c,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_nle_f16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x3c,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_nle_f16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x3c,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_nle_f16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x3c,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_nle_f16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x3c,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_nle_f16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x3c,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_nle_f16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x3c,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_nle_f16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x3c,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_nle_f16_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x3c,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_nle_f16_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x3c,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_nle_f16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x3c,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_nle_f16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x3c,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_nle_f16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x3c,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_nle_f16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x3c,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_nle_f16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x3c,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_nle_f16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x3c,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_nle_f16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x3c,0xd0,0x01,0xcb,0x00,0x00]

v_cmpx_nle_f16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x3c,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_nle_f16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x3c,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_nle_f16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x3c,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_nle_f16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x3c,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_nle_f16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x3c,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_nle_f16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x3c,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_nle_f16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x3c,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_nle_f16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x3c,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_nle_f16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x3c,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_nle_f16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x3c,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_nle_f16_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x3c,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_nle_f16_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x3c,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_nle_f16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x3c,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_nle_f16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x3c,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_nle_f16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x3c,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_nle_f16_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x3c,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_nle_f16_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x3c,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_nle_f16_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x3c,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_nle_f16_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x3c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nle_f16_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x3c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nle_f16_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x3c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nle_f16_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x3c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_neq_f16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x3d,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_neq_f16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x3d,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_neq_f16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x3d,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_neq_f16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x3d,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_neq_f16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x3d,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_neq_f16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x3d,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_neq_f16_e64 exec, v1, v2
// CHECK: [0x7e,0x00,0x3d,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_neq_f16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x3d,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_neq_f16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x3d,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_neq_f16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x3d,0xd0,0x65,0x04,0x02,0x00]

v_cmpx_neq_f16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x3d,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_neq_f16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x3d,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_neq_f16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x3d,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_neq_f16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x3d,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_neq_f16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x3d,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_neq_f16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x3d,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_neq_f16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x3d,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_neq_f16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x3d,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_neq_f16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x3d,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_neq_f16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x3d,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_neq_f16_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x3d,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_neq_f16_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x3d,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_neq_f16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x3d,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_neq_f16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x3d,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_neq_f16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x3d,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_neq_f16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x3d,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_neq_f16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x3d,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_neq_f16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x3d,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_neq_f16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x3d,0xd0,0x01,0xcb,0x00,0x00]

v_cmpx_neq_f16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x3d,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_neq_f16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x3d,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_neq_f16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x3d,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_neq_f16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x3d,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_neq_f16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x3d,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_neq_f16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x3d,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_neq_f16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x3d,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_neq_f16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x3d,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_neq_f16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x3d,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_neq_f16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x3d,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_neq_f16_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x3d,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_neq_f16_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x3d,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_neq_f16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x3d,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_neq_f16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x3d,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_neq_f16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x3d,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_neq_f16_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x3d,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_neq_f16_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x3d,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_neq_f16_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x3d,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_neq_f16_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x3d,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_neq_f16_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x3d,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_neq_f16_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x3d,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_neq_f16_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x3d,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlt_f16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x3e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlt_f16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x3e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlt_f16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x3e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlt_f16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x3e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlt_f16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x3e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlt_f16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x3e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlt_f16_e64 exec, v1, v2
// CHECK: [0x7e,0x00,0x3e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlt_f16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x3e,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_nlt_f16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x3e,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_nlt_f16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x3e,0xd0,0x65,0x04,0x02,0x00]

v_cmpx_nlt_f16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x3e,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_nlt_f16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x3e,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_nlt_f16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x3e,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_nlt_f16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x3e,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_nlt_f16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x3e,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_nlt_f16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x3e,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_nlt_f16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x3e,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_nlt_f16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x3e,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_nlt_f16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x3e,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_nlt_f16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x3e,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_nlt_f16_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x3e,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_nlt_f16_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x3e,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_nlt_f16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x3e,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_nlt_f16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x3e,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_nlt_f16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x3e,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_nlt_f16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x3e,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_nlt_f16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x3e,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_nlt_f16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x3e,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_nlt_f16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x3e,0xd0,0x01,0xcb,0x00,0x00]

v_cmpx_nlt_f16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x3e,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_nlt_f16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x3e,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_nlt_f16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x3e,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_nlt_f16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x3e,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_nlt_f16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x3e,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_nlt_f16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x3e,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_nlt_f16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x3e,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_nlt_f16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x3e,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_nlt_f16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x3e,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_nlt_f16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x3e,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_nlt_f16_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x3e,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_nlt_f16_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x3e,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_nlt_f16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x3e,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_nlt_f16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x3e,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_nlt_f16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x3e,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_nlt_f16_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x3e,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_nlt_f16_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x3e,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_nlt_f16_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x3e,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_nlt_f16_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x3e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlt_f16_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x3e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlt_f16_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x3e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlt_f16_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x3e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_tru_f16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x3f,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_tru_f16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x3f,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_tru_f16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x3f,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_tru_f16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x3f,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_tru_f16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x3f,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_tru_f16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x3f,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_tru_f16_e64 exec, v1, v2
// CHECK: [0x7e,0x00,0x3f,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_tru_f16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x3f,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_tru_f16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x3f,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_tru_f16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x3f,0xd0,0x65,0x04,0x02,0x00]

v_cmpx_tru_f16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x3f,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_tru_f16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x3f,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_tru_f16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x3f,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_tru_f16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x3f,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_tru_f16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x3f,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_tru_f16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x3f,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_tru_f16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x3f,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_tru_f16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x3f,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_tru_f16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x3f,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_tru_f16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x3f,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_tru_f16_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x3f,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_tru_f16_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x3f,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_tru_f16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x3f,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_tru_f16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x3f,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_tru_f16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x3f,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_tru_f16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x3f,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_tru_f16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x3f,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_tru_f16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x3f,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_tru_f16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x3f,0xd0,0x01,0xcb,0x00,0x00]

v_cmpx_tru_f16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x3f,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_tru_f16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x3f,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_tru_f16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x3f,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_tru_f16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x3f,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_tru_f16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x3f,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_tru_f16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x3f,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_tru_f16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x3f,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_tru_f16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x3f,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_tru_f16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x3f,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_tru_f16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x3f,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_tru_f16_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x3f,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_tru_f16_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x3f,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_tru_f16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x3f,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_tru_f16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x3f,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_tru_f16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x3f,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_tru_f16_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x3f,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_tru_f16_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x3f,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_tru_f16_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x3f,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_tru_f16_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x3f,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_tru_f16_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x3f,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_tru_f16_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x3f,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_tru_f16_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x3f,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x40,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x40,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_f32_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x40,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_f32_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x40,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x40,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_f32_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x40,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x40,0xd0,0xff,0x05,0x02,0x00]

v_cmp_f_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x40,0xd0,0x01,0x04,0x02,0x00]

v_cmp_f_f32_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x40,0xd0,0x65,0x04,0x02,0x00]

v_cmp_f_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x40,0xd0,0x66,0x04,0x02,0x00]

v_cmp_f_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x40,0xd0,0x67,0x04,0x02,0x00]

v_cmp_f_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x40,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_f_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x40,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_f_f32_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x40,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_f_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x40,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_f_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x40,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_f_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x40,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_f_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x40,0xd0,0x80,0x04,0x02,0x00]

v_cmp_f_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x40,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_f_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x40,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_f_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x40,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_f_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x40,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_f_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x40,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_f_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x40,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_f_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x40,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_f_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x40,0xd0,0x01,0xff,0x03,0x00]

v_cmp_f_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x40,0xd0,0x01,0x05,0x00,0x00]

v_cmp_f_f32_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x40,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_f_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x40,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_f_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x40,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_f_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x40,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_f_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x40,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_f_f32_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x40,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_f_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x40,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_f_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x40,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_f_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x40,0xd0,0x01,0xff,0x00,0x00]

v_cmp_f_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x40,0xd0,0x01,0x01,0x01,0x00]

v_cmp_f_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x40,0xd0,0x01,0x83,0x01,0x00]

v_cmp_f_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x40,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_f_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x40,0xd0,0x01,0xef,0x01,0x00]

v_cmp_f_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x40,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_f_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x40,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_f_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x40,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_f_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x40,0xd0,0x01,0x05,0x02,0x20]

v_cmp_f_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x40,0xd0,0x01,0x05,0x02,0x40]

v_cmp_f_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x40,0xd0,0x01,0x05,0x02,0x60]

v_cmp_f_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x40,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x40,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x40,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_f32_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x40,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x41,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x41,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_f32_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x41,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_f32_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x41,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x41,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_f32_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x41,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x41,0xd0,0xff,0x05,0x02,0x00]

v_cmp_lt_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x41,0xd0,0x01,0x04,0x02,0x00]

v_cmp_lt_f32_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x41,0xd0,0x65,0x04,0x02,0x00]

v_cmp_lt_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x41,0xd0,0x66,0x04,0x02,0x00]

v_cmp_lt_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x41,0xd0,0x67,0x04,0x02,0x00]

v_cmp_lt_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x41,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_lt_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x41,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_lt_f32_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x41,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_lt_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x41,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_lt_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x41,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_lt_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x41,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_lt_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x41,0xd0,0x80,0x04,0x02,0x00]

v_cmp_lt_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x41,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_lt_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x41,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_lt_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x41,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_lt_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x41,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_lt_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x41,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_lt_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x41,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_lt_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x41,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_lt_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x41,0xd0,0x01,0xff,0x03,0x00]

v_cmp_lt_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x41,0xd0,0x01,0x05,0x00,0x00]

v_cmp_lt_f32_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x41,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_lt_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x41,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_lt_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x41,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_lt_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x41,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_lt_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x41,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_lt_f32_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x41,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_lt_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x41,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_lt_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x41,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_lt_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x41,0xd0,0x01,0xff,0x00,0x00]

v_cmp_lt_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x41,0xd0,0x01,0x01,0x01,0x00]

v_cmp_lt_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x41,0xd0,0x01,0x83,0x01,0x00]

v_cmp_lt_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x41,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_lt_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x41,0xd0,0x01,0xef,0x01,0x00]

v_cmp_lt_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x41,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_lt_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x41,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_lt_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x41,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_lt_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x41,0xd0,0x01,0x05,0x02,0x20]

v_cmp_lt_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x41,0xd0,0x01,0x05,0x02,0x40]

v_cmp_lt_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x41,0xd0,0x01,0x05,0x02,0x60]

v_cmp_lt_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x41,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x41,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x41,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_f32_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x41,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x42,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x42,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_f32_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x42,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_f32_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x42,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x42,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_f32_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x42,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x42,0xd0,0xff,0x05,0x02,0x00]

v_cmp_eq_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x42,0xd0,0x01,0x04,0x02,0x00]

v_cmp_eq_f32_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x42,0xd0,0x65,0x04,0x02,0x00]

v_cmp_eq_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x42,0xd0,0x66,0x04,0x02,0x00]

v_cmp_eq_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x42,0xd0,0x67,0x04,0x02,0x00]

v_cmp_eq_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x42,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_eq_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x42,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_eq_f32_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x42,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_eq_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x42,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_eq_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x42,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_eq_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x42,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_eq_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x42,0xd0,0x80,0x04,0x02,0x00]

v_cmp_eq_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x42,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_eq_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x42,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_eq_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x42,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_eq_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x42,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_eq_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x42,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_eq_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x42,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_eq_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x42,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_eq_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x42,0xd0,0x01,0xff,0x03,0x00]

v_cmp_eq_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x42,0xd0,0x01,0x05,0x00,0x00]

v_cmp_eq_f32_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x42,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_eq_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x42,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_eq_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x42,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_eq_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x42,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_eq_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x42,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_eq_f32_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x42,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_eq_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x42,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_eq_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x42,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_eq_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x42,0xd0,0x01,0xff,0x00,0x00]

v_cmp_eq_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x42,0xd0,0x01,0x01,0x01,0x00]

v_cmp_eq_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x42,0xd0,0x01,0x83,0x01,0x00]

v_cmp_eq_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x42,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_eq_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x42,0xd0,0x01,0xef,0x01,0x00]

v_cmp_eq_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x42,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_eq_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x42,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_eq_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x42,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_eq_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x42,0xd0,0x01,0x05,0x02,0x20]

v_cmp_eq_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x42,0xd0,0x01,0x05,0x02,0x40]

v_cmp_eq_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x42,0xd0,0x01,0x05,0x02,0x60]

v_cmp_eq_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x42,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x42,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x42,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_f32_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x42,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x43,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x43,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_f32_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x43,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_f32_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x43,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x43,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_f32_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x43,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x43,0xd0,0xff,0x05,0x02,0x00]

v_cmp_le_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x43,0xd0,0x01,0x04,0x02,0x00]

v_cmp_le_f32_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x43,0xd0,0x65,0x04,0x02,0x00]

v_cmp_le_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x43,0xd0,0x66,0x04,0x02,0x00]

v_cmp_le_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x43,0xd0,0x67,0x04,0x02,0x00]

v_cmp_le_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x43,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_le_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x43,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_le_f32_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x43,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_le_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x43,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_le_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x43,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_le_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x43,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_le_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x43,0xd0,0x80,0x04,0x02,0x00]

v_cmp_le_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x43,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_le_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x43,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_le_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x43,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_le_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x43,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_le_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x43,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_le_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x43,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_le_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x43,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_le_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x43,0xd0,0x01,0xff,0x03,0x00]

v_cmp_le_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x43,0xd0,0x01,0x05,0x00,0x00]

v_cmp_le_f32_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x43,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_le_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x43,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_le_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x43,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_le_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x43,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_le_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x43,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_le_f32_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x43,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_le_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x43,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_le_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x43,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_le_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x43,0xd0,0x01,0xff,0x00,0x00]

v_cmp_le_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x43,0xd0,0x01,0x01,0x01,0x00]

v_cmp_le_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x43,0xd0,0x01,0x83,0x01,0x00]

v_cmp_le_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x43,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_le_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x43,0xd0,0x01,0xef,0x01,0x00]

v_cmp_le_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x43,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_le_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x43,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_le_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x43,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_le_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x43,0xd0,0x01,0x05,0x02,0x20]

v_cmp_le_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x43,0xd0,0x01,0x05,0x02,0x40]

v_cmp_le_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x43,0xd0,0x01,0x05,0x02,0x60]

v_cmp_le_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x43,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x43,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x43,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_f32_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x43,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x44,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x44,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_f32_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x44,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_f32_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x44,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x44,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_f32_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x44,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x44,0xd0,0xff,0x05,0x02,0x00]

v_cmp_gt_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x44,0xd0,0x01,0x04,0x02,0x00]

v_cmp_gt_f32_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x44,0xd0,0x65,0x04,0x02,0x00]

v_cmp_gt_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x44,0xd0,0x66,0x04,0x02,0x00]

v_cmp_gt_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x44,0xd0,0x67,0x04,0x02,0x00]

v_cmp_gt_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x44,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_gt_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x44,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_gt_f32_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x44,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_gt_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x44,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_gt_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x44,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_gt_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x44,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_gt_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x44,0xd0,0x80,0x04,0x02,0x00]

v_cmp_gt_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x44,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_gt_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x44,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_gt_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x44,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_gt_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x44,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_gt_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x44,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_gt_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x44,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_gt_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x44,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_gt_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x44,0xd0,0x01,0xff,0x03,0x00]

v_cmp_gt_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x44,0xd0,0x01,0x05,0x00,0x00]

v_cmp_gt_f32_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x44,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_gt_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x44,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_gt_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x44,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_gt_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x44,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_gt_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x44,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_gt_f32_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x44,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_gt_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x44,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_gt_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x44,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_gt_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x44,0xd0,0x01,0xff,0x00,0x00]

v_cmp_gt_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x44,0xd0,0x01,0x01,0x01,0x00]

v_cmp_gt_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x44,0xd0,0x01,0x83,0x01,0x00]

v_cmp_gt_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x44,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_gt_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x44,0xd0,0x01,0xef,0x01,0x00]

v_cmp_gt_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x44,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_gt_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x44,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_gt_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x44,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_gt_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x44,0xd0,0x01,0x05,0x02,0x20]

v_cmp_gt_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x44,0xd0,0x01,0x05,0x02,0x40]

v_cmp_gt_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x44,0xd0,0x01,0x05,0x02,0x60]

v_cmp_gt_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x44,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x44,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x44,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_f32_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x44,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lg_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x45,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lg_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x45,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lg_f32_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x45,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lg_f32_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x45,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lg_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x45,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lg_f32_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x45,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lg_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x45,0xd0,0xff,0x05,0x02,0x00]

v_cmp_lg_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x45,0xd0,0x01,0x04,0x02,0x00]

v_cmp_lg_f32_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x45,0xd0,0x65,0x04,0x02,0x00]

v_cmp_lg_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x45,0xd0,0x66,0x04,0x02,0x00]

v_cmp_lg_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x45,0xd0,0x67,0x04,0x02,0x00]

v_cmp_lg_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x45,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_lg_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x45,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_lg_f32_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x45,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_lg_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x45,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_lg_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x45,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_lg_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x45,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_lg_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x45,0xd0,0x80,0x04,0x02,0x00]

v_cmp_lg_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x45,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_lg_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x45,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_lg_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x45,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_lg_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x45,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_lg_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x45,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_lg_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x45,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_lg_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x45,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_lg_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x45,0xd0,0x01,0xff,0x03,0x00]

v_cmp_lg_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x45,0xd0,0x01,0x05,0x00,0x00]

v_cmp_lg_f32_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x45,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_lg_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x45,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_lg_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x45,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_lg_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x45,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_lg_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x45,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_lg_f32_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x45,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_lg_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x45,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_lg_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x45,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_lg_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x45,0xd0,0x01,0xff,0x00,0x00]

v_cmp_lg_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x45,0xd0,0x01,0x01,0x01,0x00]

v_cmp_lg_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x45,0xd0,0x01,0x83,0x01,0x00]

v_cmp_lg_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x45,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_lg_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x45,0xd0,0x01,0xef,0x01,0x00]

v_cmp_lg_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x45,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_lg_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x45,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_lg_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x45,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_lg_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x45,0xd0,0x01,0x05,0x02,0x20]

v_cmp_lg_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x45,0xd0,0x01,0x05,0x02,0x40]

v_cmp_lg_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x45,0xd0,0x01,0x05,0x02,0x60]

v_cmp_lg_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x45,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lg_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x45,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lg_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x45,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lg_f32_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x45,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x46,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x46,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_f32_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x46,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_f32_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x46,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x46,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_f32_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x46,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x46,0xd0,0xff,0x05,0x02,0x00]

v_cmp_ge_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x46,0xd0,0x01,0x04,0x02,0x00]

v_cmp_ge_f32_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x46,0xd0,0x65,0x04,0x02,0x00]

v_cmp_ge_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x46,0xd0,0x66,0x04,0x02,0x00]

v_cmp_ge_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x46,0xd0,0x67,0x04,0x02,0x00]

v_cmp_ge_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x46,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_ge_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x46,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_ge_f32_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x46,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_ge_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x46,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_ge_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x46,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_ge_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x46,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_ge_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x46,0xd0,0x80,0x04,0x02,0x00]

v_cmp_ge_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x46,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_ge_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x46,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_ge_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x46,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_ge_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x46,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_ge_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x46,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_ge_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x46,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_ge_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x46,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_ge_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x46,0xd0,0x01,0xff,0x03,0x00]

v_cmp_ge_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x46,0xd0,0x01,0x05,0x00,0x00]

v_cmp_ge_f32_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x46,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_ge_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x46,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_ge_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x46,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_ge_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x46,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_ge_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x46,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_ge_f32_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x46,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_ge_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x46,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_ge_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x46,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_ge_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x46,0xd0,0x01,0xff,0x00,0x00]

v_cmp_ge_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x46,0xd0,0x01,0x01,0x01,0x00]

v_cmp_ge_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x46,0xd0,0x01,0x83,0x01,0x00]

v_cmp_ge_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x46,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_ge_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x46,0xd0,0x01,0xef,0x01,0x00]

v_cmp_ge_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x46,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_ge_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x46,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_ge_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x46,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_ge_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x46,0xd0,0x01,0x05,0x02,0x20]

v_cmp_ge_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x46,0xd0,0x01,0x05,0x02,0x40]

v_cmp_ge_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x46,0xd0,0x01,0x05,0x02,0x60]

v_cmp_ge_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x46,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x46,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x46,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_f32_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x46,0xd0,0x01,0x05,0x02,0x00]

v_cmp_o_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x47,0xd0,0x01,0x05,0x02,0x00]

v_cmp_o_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x47,0xd0,0x01,0x05,0x02,0x00]

v_cmp_o_f32_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x47,0xd0,0x01,0x05,0x02,0x00]

v_cmp_o_f32_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x47,0xd0,0x01,0x05,0x02,0x00]

v_cmp_o_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x47,0xd0,0x01,0x05,0x02,0x00]

v_cmp_o_f32_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x47,0xd0,0x01,0x05,0x02,0x00]

v_cmp_o_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x47,0xd0,0xff,0x05,0x02,0x00]

v_cmp_o_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x47,0xd0,0x01,0x04,0x02,0x00]

v_cmp_o_f32_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x47,0xd0,0x65,0x04,0x02,0x00]

v_cmp_o_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x47,0xd0,0x66,0x04,0x02,0x00]

v_cmp_o_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x47,0xd0,0x67,0x04,0x02,0x00]

v_cmp_o_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x47,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_o_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x47,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_o_f32_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x47,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_o_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x47,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_o_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x47,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_o_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x47,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_o_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x47,0xd0,0x80,0x04,0x02,0x00]

v_cmp_o_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x47,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_o_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x47,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_o_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x47,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_o_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x47,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_o_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x47,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_o_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x47,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_o_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x47,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_o_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x47,0xd0,0x01,0xff,0x03,0x00]

v_cmp_o_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x47,0xd0,0x01,0x05,0x00,0x00]

v_cmp_o_f32_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x47,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_o_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x47,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_o_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x47,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_o_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x47,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_o_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x47,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_o_f32_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x47,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_o_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x47,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_o_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x47,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_o_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x47,0xd0,0x01,0xff,0x00,0x00]

v_cmp_o_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x47,0xd0,0x01,0x01,0x01,0x00]

v_cmp_o_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x47,0xd0,0x01,0x83,0x01,0x00]

v_cmp_o_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x47,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_o_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x47,0xd0,0x01,0xef,0x01,0x00]

v_cmp_o_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x47,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_o_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x47,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_o_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x47,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_o_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x47,0xd0,0x01,0x05,0x02,0x20]

v_cmp_o_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x47,0xd0,0x01,0x05,0x02,0x40]

v_cmp_o_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x47,0xd0,0x01,0x05,0x02,0x60]

v_cmp_o_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x47,0xd0,0x01,0x05,0x02,0x00]

v_cmp_o_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x47,0xd0,0x01,0x05,0x02,0x00]

v_cmp_o_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x47,0xd0,0x01,0x05,0x02,0x00]

v_cmp_o_f32_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x47,0xd0,0x01,0x05,0x02,0x00]

v_cmp_u_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x48,0xd0,0x01,0x05,0x02,0x00]

v_cmp_u_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x48,0xd0,0x01,0x05,0x02,0x00]

v_cmp_u_f32_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x48,0xd0,0x01,0x05,0x02,0x00]

v_cmp_u_f32_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x48,0xd0,0x01,0x05,0x02,0x00]

v_cmp_u_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x48,0xd0,0x01,0x05,0x02,0x00]

v_cmp_u_f32_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x48,0xd0,0x01,0x05,0x02,0x00]

v_cmp_u_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x48,0xd0,0xff,0x05,0x02,0x00]

v_cmp_u_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x48,0xd0,0x01,0x04,0x02,0x00]

v_cmp_u_f32_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x48,0xd0,0x65,0x04,0x02,0x00]

v_cmp_u_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x48,0xd0,0x66,0x04,0x02,0x00]

v_cmp_u_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x48,0xd0,0x67,0x04,0x02,0x00]

v_cmp_u_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x48,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_u_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x48,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_u_f32_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x48,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_u_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x48,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_u_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x48,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_u_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x48,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_u_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x48,0xd0,0x80,0x04,0x02,0x00]

v_cmp_u_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x48,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_u_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x48,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_u_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x48,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_u_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x48,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_u_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x48,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_u_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x48,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_u_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x48,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_u_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x48,0xd0,0x01,0xff,0x03,0x00]

v_cmp_u_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x48,0xd0,0x01,0x05,0x00,0x00]

v_cmp_u_f32_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x48,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_u_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x48,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_u_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x48,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_u_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x48,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_u_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x48,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_u_f32_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x48,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_u_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x48,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_u_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x48,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_u_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x48,0xd0,0x01,0xff,0x00,0x00]

v_cmp_u_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x48,0xd0,0x01,0x01,0x01,0x00]

v_cmp_u_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x48,0xd0,0x01,0x83,0x01,0x00]

v_cmp_u_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x48,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_u_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x48,0xd0,0x01,0xef,0x01,0x00]

v_cmp_u_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x48,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_u_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x48,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_u_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x48,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_u_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x48,0xd0,0x01,0x05,0x02,0x20]

v_cmp_u_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x48,0xd0,0x01,0x05,0x02,0x40]

v_cmp_u_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x48,0xd0,0x01,0x05,0x02,0x60]

v_cmp_u_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x48,0xd0,0x01,0x05,0x02,0x00]

v_cmp_u_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x48,0xd0,0x01,0x05,0x02,0x00]

v_cmp_u_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x48,0xd0,0x01,0x05,0x02,0x00]

v_cmp_u_f32_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x48,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nge_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x49,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nge_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x49,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nge_f32_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x49,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nge_f32_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x49,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nge_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x49,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nge_f32_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x49,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nge_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x49,0xd0,0xff,0x05,0x02,0x00]

v_cmp_nge_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x49,0xd0,0x01,0x04,0x02,0x00]

v_cmp_nge_f32_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x49,0xd0,0x65,0x04,0x02,0x00]

v_cmp_nge_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x49,0xd0,0x66,0x04,0x02,0x00]

v_cmp_nge_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x49,0xd0,0x67,0x04,0x02,0x00]

v_cmp_nge_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x49,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_nge_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x49,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_nge_f32_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x49,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_nge_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x49,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_nge_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x49,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_nge_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x49,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_nge_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x49,0xd0,0x80,0x04,0x02,0x00]

v_cmp_nge_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x49,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_nge_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x49,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_nge_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x49,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_nge_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x49,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_nge_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x49,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_nge_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x49,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_nge_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x49,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_nge_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x49,0xd0,0x01,0xff,0x03,0x00]

v_cmp_nge_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x49,0xd0,0x01,0x05,0x00,0x00]

v_cmp_nge_f32_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x49,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_nge_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x49,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_nge_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x49,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_nge_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x49,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_nge_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x49,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_nge_f32_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x49,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_nge_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x49,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_nge_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x49,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_nge_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x49,0xd0,0x01,0xff,0x00,0x00]

v_cmp_nge_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x49,0xd0,0x01,0x01,0x01,0x00]

v_cmp_nge_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x49,0xd0,0x01,0x83,0x01,0x00]

v_cmp_nge_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x49,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_nge_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x49,0xd0,0x01,0xef,0x01,0x00]

v_cmp_nge_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x49,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_nge_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x49,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_nge_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x49,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_nge_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x49,0xd0,0x01,0x05,0x02,0x20]

v_cmp_nge_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x49,0xd0,0x01,0x05,0x02,0x40]

v_cmp_nge_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x49,0xd0,0x01,0x05,0x02,0x60]

v_cmp_nge_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x49,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nge_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x49,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nge_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x49,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nge_f32_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x49,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlg_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x4a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlg_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x4a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlg_f32_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x4a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlg_f32_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x4a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlg_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x4a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlg_f32_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x4a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlg_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x4a,0xd0,0xff,0x05,0x02,0x00]

v_cmp_nlg_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x4a,0xd0,0x01,0x04,0x02,0x00]

v_cmp_nlg_f32_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x4a,0xd0,0x65,0x04,0x02,0x00]

v_cmp_nlg_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x4a,0xd0,0x66,0x04,0x02,0x00]

v_cmp_nlg_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x4a,0xd0,0x67,0x04,0x02,0x00]

v_cmp_nlg_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x4a,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_nlg_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x4a,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_nlg_f32_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x4a,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_nlg_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x4a,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_nlg_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x4a,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_nlg_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x4a,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_nlg_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x4a,0xd0,0x80,0x04,0x02,0x00]

v_cmp_nlg_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x4a,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_nlg_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x4a,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_nlg_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x4a,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_nlg_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x4a,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_nlg_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x4a,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_nlg_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x4a,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_nlg_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x4a,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_nlg_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x4a,0xd0,0x01,0xff,0x03,0x00]

v_cmp_nlg_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x4a,0xd0,0x01,0x05,0x00,0x00]

v_cmp_nlg_f32_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x4a,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_nlg_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x4a,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_nlg_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x4a,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_nlg_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x4a,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_nlg_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x4a,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_nlg_f32_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x4a,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_nlg_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x4a,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_nlg_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x4a,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_nlg_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x4a,0xd0,0x01,0xff,0x00,0x00]

v_cmp_nlg_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x4a,0xd0,0x01,0x01,0x01,0x00]

v_cmp_nlg_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x4a,0xd0,0x01,0x83,0x01,0x00]

v_cmp_nlg_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x4a,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_nlg_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x4a,0xd0,0x01,0xef,0x01,0x00]

v_cmp_nlg_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x4a,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_nlg_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x4a,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_nlg_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x4a,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_nlg_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x4a,0xd0,0x01,0x05,0x02,0x20]

v_cmp_nlg_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x4a,0xd0,0x01,0x05,0x02,0x40]

v_cmp_nlg_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x4a,0xd0,0x01,0x05,0x02,0x60]

v_cmp_nlg_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x4a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlg_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x4a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlg_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x4a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlg_f32_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x4a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ngt_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x4b,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ngt_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x4b,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ngt_f32_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x4b,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ngt_f32_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x4b,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ngt_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x4b,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ngt_f32_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x4b,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ngt_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x4b,0xd0,0xff,0x05,0x02,0x00]

v_cmp_ngt_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x4b,0xd0,0x01,0x04,0x02,0x00]

v_cmp_ngt_f32_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x4b,0xd0,0x65,0x04,0x02,0x00]

v_cmp_ngt_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x4b,0xd0,0x66,0x04,0x02,0x00]

v_cmp_ngt_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x4b,0xd0,0x67,0x04,0x02,0x00]

v_cmp_ngt_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x4b,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_ngt_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x4b,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_ngt_f32_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x4b,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_ngt_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x4b,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_ngt_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x4b,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_ngt_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x4b,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_ngt_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x4b,0xd0,0x80,0x04,0x02,0x00]

v_cmp_ngt_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x4b,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_ngt_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x4b,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_ngt_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x4b,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_ngt_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x4b,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_ngt_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x4b,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_ngt_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x4b,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_ngt_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x4b,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_ngt_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x4b,0xd0,0x01,0xff,0x03,0x00]

v_cmp_ngt_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x4b,0xd0,0x01,0x05,0x00,0x00]

v_cmp_ngt_f32_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x4b,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_ngt_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x4b,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_ngt_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x4b,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_ngt_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x4b,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_ngt_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x4b,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_ngt_f32_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x4b,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_ngt_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x4b,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_ngt_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x4b,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_ngt_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x4b,0xd0,0x01,0xff,0x00,0x00]

v_cmp_ngt_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x4b,0xd0,0x01,0x01,0x01,0x00]

v_cmp_ngt_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x4b,0xd0,0x01,0x83,0x01,0x00]

v_cmp_ngt_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x4b,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_ngt_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x4b,0xd0,0x01,0xef,0x01,0x00]

v_cmp_ngt_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x4b,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_ngt_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x4b,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_ngt_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x4b,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_ngt_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x4b,0xd0,0x01,0x05,0x02,0x20]

v_cmp_ngt_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x4b,0xd0,0x01,0x05,0x02,0x40]

v_cmp_ngt_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x4b,0xd0,0x01,0x05,0x02,0x60]

v_cmp_ngt_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x4b,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ngt_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x4b,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ngt_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x4b,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ngt_f32_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x4b,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nle_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x4c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nle_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x4c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nle_f32_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x4c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nle_f32_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x4c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nle_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x4c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nle_f32_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x4c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nle_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x4c,0xd0,0xff,0x05,0x02,0x00]

v_cmp_nle_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x4c,0xd0,0x01,0x04,0x02,0x00]

v_cmp_nle_f32_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x4c,0xd0,0x65,0x04,0x02,0x00]

v_cmp_nle_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x4c,0xd0,0x66,0x04,0x02,0x00]

v_cmp_nle_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x4c,0xd0,0x67,0x04,0x02,0x00]

v_cmp_nle_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x4c,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_nle_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x4c,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_nle_f32_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x4c,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_nle_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x4c,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_nle_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x4c,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_nle_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x4c,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_nle_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x4c,0xd0,0x80,0x04,0x02,0x00]

v_cmp_nle_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x4c,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_nle_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x4c,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_nle_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x4c,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_nle_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x4c,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_nle_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x4c,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_nle_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x4c,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_nle_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x4c,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_nle_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x4c,0xd0,0x01,0xff,0x03,0x00]

v_cmp_nle_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x4c,0xd0,0x01,0x05,0x00,0x00]

v_cmp_nle_f32_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x4c,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_nle_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x4c,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_nle_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x4c,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_nle_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x4c,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_nle_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x4c,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_nle_f32_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x4c,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_nle_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x4c,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_nle_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x4c,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_nle_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x4c,0xd0,0x01,0xff,0x00,0x00]

v_cmp_nle_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x4c,0xd0,0x01,0x01,0x01,0x00]

v_cmp_nle_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x4c,0xd0,0x01,0x83,0x01,0x00]

v_cmp_nle_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x4c,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_nle_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x4c,0xd0,0x01,0xef,0x01,0x00]

v_cmp_nle_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x4c,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_nle_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x4c,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_nle_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x4c,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_nle_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x4c,0xd0,0x01,0x05,0x02,0x20]

v_cmp_nle_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x4c,0xd0,0x01,0x05,0x02,0x40]

v_cmp_nle_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x4c,0xd0,0x01,0x05,0x02,0x60]

v_cmp_nle_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x4c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nle_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x4c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nle_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x4c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nle_f32_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x4c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_neq_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x4d,0xd0,0x01,0x05,0x02,0x00]

v_cmp_neq_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x4d,0xd0,0x01,0x05,0x02,0x00]

v_cmp_neq_f32_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x4d,0xd0,0x01,0x05,0x02,0x00]

v_cmp_neq_f32_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x4d,0xd0,0x01,0x05,0x02,0x00]

v_cmp_neq_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x4d,0xd0,0x01,0x05,0x02,0x00]

v_cmp_neq_f32_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x4d,0xd0,0x01,0x05,0x02,0x00]

v_cmp_neq_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x4d,0xd0,0xff,0x05,0x02,0x00]

v_cmp_neq_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x4d,0xd0,0x01,0x04,0x02,0x00]

v_cmp_neq_f32_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x4d,0xd0,0x65,0x04,0x02,0x00]

v_cmp_neq_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x4d,0xd0,0x66,0x04,0x02,0x00]

v_cmp_neq_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x4d,0xd0,0x67,0x04,0x02,0x00]

v_cmp_neq_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x4d,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_neq_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x4d,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_neq_f32_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x4d,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_neq_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x4d,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_neq_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x4d,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_neq_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x4d,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_neq_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x4d,0xd0,0x80,0x04,0x02,0x00]

v_cmp_neq_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x4d,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_neq_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x4d,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_neq_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x4d,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_neq_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x4d,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_neq_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x4d,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_neq_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x4d,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_neq_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x4d,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_neq_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x4d,0xd0,0x01,0xff,0x03,0x00]

v_cmp_neq_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x4d,0xd0,0x01,0x05,0x00,0x00]

v_cmp_neq_f32_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x4d,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_neq_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x4d,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_neq_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x4d,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_neq_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x4d,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_neq_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x4d,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_neq_f32_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x4d,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_neq_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x4d,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_neq_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x4d,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_neq_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x4d,0xd0,0x01,0xff,0x00,0x00]

v_cmp_neq_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x4d,0xd0,0x01,0x01,0x01,0x00]

v_cmp_neq_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x4d,0xd0,0x01,0x83,0x01,0x00]

v_cmp_neq_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x4d,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_neq_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x4d,0xd0,0x01,0xef,0x01,0x00]

v_cmp_neq_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x4d,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_neq_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x4d,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_neq_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x4d,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_neq_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x4d,0xd0,0x01,0x05,0x02,0x20]

v_cmp_neq_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x4d,0xd0,0x01,0x05,0x02,0x40]

v_cmp_neq_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x4d,0xd0,0x01,0x05,0x02,0x60]

v_cmp_neq_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x4d,0xd0,0x01,0x05,0x02,0x00]

v_cmp_neq_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x4d,0xd0,0x01,0x05,0x02,0x00]

v_cmp_neq_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x4d,0xd0,0x01,0x05,0x02,0x00]

v_cmp_neq_f32_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x4d,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlt_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x4e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlt_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x4e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlt_f32_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x4e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlt_f32_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x4e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlt_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x4e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlt_f32_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x4e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlt_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x4e,0xd0,0xff,0x05,0x02,0x00]

v_cmp_nlt_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x4e,0xd0,0x01,0x04,0x02,0x00]

v_cmp_nlt_f32_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x4e,0xd0,0x65,0x04,0x02,0x00]

v_cmp_nlt_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x4e,0xd0,0x66,0x04,0x02,0x00]

v_cmp_nlt_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x4e,0xd0,0x67,0x04,0x02,0x00]

v_cmp_nlt_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x4e,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_nlt_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x4e,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_nlt_f32_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x4e,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_nlt_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x4e,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_nlt_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x4e,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_nlt_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x4e,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_nlt_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x4e,0xd0,0x80,0x04,0x02,0x00]

v_cmp_nlt_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x4e,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_nlt_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x4e,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_nlt_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x4e,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_nlt_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x4e,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_nlt_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x4e,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_nlt_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x4e,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_nlt_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x4e,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_nlt_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x4e,0xd0,0x01,0xff,0x03,0x00]

v_cmp_nlt_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x4e,0xd0,0x01,0x05,0x00,0x00]

v_cmp_nlt_f32_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x4e,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_nlt_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x4e,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_nlt_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x4e,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_nlt_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x4e,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_nlt_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x4e,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_nlt_f32_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x4e,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_nlt_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x4e,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_nlt_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x4e,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_nlt_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x4e,0xd0,0x01,0xff,0x00,0x00]

v_cmp_nlt_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x4e,0xd0,0x01,0x01,0x01,0x00]

v_cmp_nlt_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x4e,0xd0,0x01,0x83,0x01,0x00]

v_cmp_nlt_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x4e,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_nlt_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x4e,0xd0,0x01,0xef,0x01,0x00]

v_cmp_nlt_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x4e,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_nlt_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x4e,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_nlt_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x4e,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_nlt_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x4e,0xd0,0x01,0x05,0x02,0x20]

v_cmp_nlt_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x4e,0xd0,0x01,0x05,0x02,0x40]

v_cmp_nlt_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x4e,0xd0,0x01,0x05,0x02,0x60]

v_cmp_nlt_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x4e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlt_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x4e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlt_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x4e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlt_f32_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x4e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_tru_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x4f,0xd0,0x01,0x05,0x02,0x00]

v_cmp_tru_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x4f,0xd0,0x01,0x05,0x02,0x00]

v_cmp_tru_f32_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x4f,0xd0,0x01,0x05,0x02,0x00]

v_cmp_tru_f32_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x4f,0xd0,0x01,0x05,0x02,0x00]

v_cmp_tru_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x4f,0xd0,0x01,0x05,0x02,0x00]

v_cmp_tru_f32_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x4f,0xd0,0x01,0x05,0x02,0x00]

v_cmp_tru_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x4f,0xd0,0xff,0x05,0x02,0x00]

v_cmp_tru_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x4f,0xd0,0x01,0x04,0x02,0x00]

v_cmp_tru_f32_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x4f,0xd0,0x65,0x04,0x02,0x00]

v_cmp_tru_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x4f,0xd0,0x66,0x04,0x02,0x00]

v_cmp_tru_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x4f,0xd0,0x67,0x04,0x02,0x00]

v_cmp_tru_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x4f,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_tru_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x4f,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_tru_f32_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x4f,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_tru_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x4f,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_tru_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x4f,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_tru_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x4f,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_tru_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x4f,0xd0,0x80,0x04,0x02,0x00]

v_cmp_tru_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x4f,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_tru_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x4f,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_tru_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x4f,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_tru_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x4f,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_tru_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x4f,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_tru_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x4f,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_tru_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x4f,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_tru_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x4f,0xd0,0x01,0xff,0x03,0x00]

v_cmp_tru_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x4f,0xd0,0x01,0x05,0x00,0x00]

v_cmp_tru_f32_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x4f,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_tru_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x4f,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_tru_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x4f,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_tru_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x4f,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_tru_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x4f,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_tru_f32_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x4f,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_tru_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x4f,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_tru_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x4f,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_tru_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x4f,0xd0,0x01,0xff,0x00,0x00]

v_cmp_tru_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x4f,0xd0,0x01,0x01,0x01,0x00]

v_cmp_tru_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x4f,0xd0,0x01,0x83,0x01,0x00]

v_cmp_tru_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x4f,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_tru_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x4f,0xd0,0x01,0xef,0x01,0x00]

v_cmp_tru_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x4f,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_tru_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x4f,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_tru_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x4f,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_tru_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x4f,0xd0,0x01,0x05,0x02,0x20]

v_cmp_tru_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x4f,0xd0,0x01,0x05,0x02,0x40]

v_cmp_tru_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x4f,0xd0,0x01,0x05,0x02,0x60]

v_cmp_tru_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x4f,0xd0,0x01,0x05,0x02,0x00]

v_cmp_tru_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x4f,0xd0,0x01,0x05,0x02,0x00]

v_cmp_tru_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x4f,0xd0,0x01,0x05,0x02,0x00]

v_cmp_tru_f32_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x4f,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x50,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x50,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_f32_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x50,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_f32_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x50,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x50,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_f32_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x50,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_f32_e64 exec, v1, v2
// CHECK: [0x7e,0x00,0x50,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x50,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_f_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x50,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_f_f32_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x50,0xd0,0x65,0x04,0x02,0x00]

v_cmpx_f_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x50,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_f_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x50,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_f_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x50,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_f_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x50,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_f_f32_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x50,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_f_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x50,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_f_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x50,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_f_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x50,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_f_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x50,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_f_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x50,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_f_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x50,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_f_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x50,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_f_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x50,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_f_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x50,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_f_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x50,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_f_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x50,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_f_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x50,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_f_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x50,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_f_f32_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x50,0xd0,0x01,0xcb,0x00,0x00]

v_cmpx_f_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x50,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_f_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x50,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_f_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x50,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_f_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x50,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_f_f32_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x50,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_f_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x50,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_f_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x50,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_f_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x50,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_f_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x50,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_f_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x50,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_f_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x50,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_f_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x50,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_f_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x50,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_f_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x50,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_f_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x50,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_f_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x50,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_f_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x50,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_f_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x50,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_f_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x50,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x50,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x50,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_f32_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x50,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x51,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x51,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_f32_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x51,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_f32_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x51,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x51,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_f32_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x51,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_f32_e64 exec, v1, v2
// CHECK: [0x7e,0x00,0x51,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x51,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_lt_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x51,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_lt_f32_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x51,0xd0,0x65,0x04,0x02,0x00]

v_cmpx_lt_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x51,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_lt_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x51,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_lt_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x51,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_lt_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x51,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_lt_f32_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x51,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_lt_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x51,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_lt_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x51,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_lt_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x51,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_lt_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x51,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_lt_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x51,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_lt_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x51,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_lt_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x51,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_lt_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x51,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_lt_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x51,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_lt_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x51,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_lt_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x51,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_lt_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x51,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_lt_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x51,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_lt_f32_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x51,0xd0,0x01,0xcb,0x00,0x00]

v_cmpx_lt_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x51,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_lt_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x51,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_lt_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x51,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_lt_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x51,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_lt_f32_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x51,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_lt_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x51,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_lt_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x51,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_lt_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x51,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_lt_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x51,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_lt_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x51,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_lt_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x51,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_lt_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x51,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_lt_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x51,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_lt_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x51,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_lt_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x51,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_lt_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x51,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_lt_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x51,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_lt_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x51,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_lt_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x51,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x51,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x51,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_f32_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x51,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x52,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x52,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_f32_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x52,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_f32_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x52,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x52,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_f32_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x52,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_f32_e64 exec, v1, v2
// CHECK: [0x7e,0x00,0x52,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x52,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_eq_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x52,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_eq_f32_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x52,0xd0,0x65,0x04,0x02,0x00]

v_cmpx_eq_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x52,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_eq_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x52,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_eq_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x52,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_eq_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x52,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_eq_f32_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x52,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_eq_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x52,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_eq_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x52,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_eq_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x52,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_eq_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x52,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_eq_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x52,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_eq_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x52,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_eq_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x52,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_eq_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x52,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_eq_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x52,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_eq_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x52,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_eq_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x52,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_eq_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x52,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_eq_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x52,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_eq_f32_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x52,0xd0,0x01,0xcb,0x00,0x00]

v_cmpx_eq_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x52,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_eq_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x52,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_eq_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x52,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_eq_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x52,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_eq_f32_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x52,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_eq_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x52,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_eq_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x52,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_eq_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x52,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_eq_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x52,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_eq_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x52,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_eq_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x52,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_eq_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x52,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_eq_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x52,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_eq_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x52,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_eq_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x52,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_eq_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x52,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_eq_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x52,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_eq_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x52,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_eq_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x52,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x52,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x52,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_f32_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x52,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x53,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x53,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_f32_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x53,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_f32_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x53,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x53,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_f32_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x53,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_f32_e64 exec, v1, v2
// CHECK: [0x7e,0x00,0x53,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x53,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_le_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x53,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_le_f32_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x53,0xd0,0x65,0x04,0x02,0x00]

v_cmpx_le_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x53,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_le_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x53,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_le_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x53,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_le_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x53,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_le_f32_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x53,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_le_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x53,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_le_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x53,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_le_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x53,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_le_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x53,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_le_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x53,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_le_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x53,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_le_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x53,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_le_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x53,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_le_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x53,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_le_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x53,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_le_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x53,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_le_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x53,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_le_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x53,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_le_f32_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x53,0xd0,0x01,0xcb,0x00,0x00]

v_cmpx_le_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x53,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_le_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x53,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_le_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x53,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_le_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x53,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_le_f32_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x53,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_le_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x53,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_le_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x53,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_le_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x53,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_le_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x53,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_le_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x53,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_le_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x53,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_le_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x53,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_le_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x53,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_le_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x53,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_le_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x53,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_le_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x53,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_le_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x53,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_le_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x53,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_le_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x53,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x53,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x53,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_f32_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x53,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x54,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x54,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_f32_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x54,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_f32_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x54,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x54,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_f32_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x54,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_f32_e64 exec, v1, v2
// CHECK: [0x7e,0x00,0x54,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x54,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_gt_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x54,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_gt_f32_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x54,0xd0,0x65,0x04,0x02,0x00]

v_cmpx_gt_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x54,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_gt_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x54,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_gt_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x54,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_gt_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x54,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_gt_f32_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x54,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_gt_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x54,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_gt_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x54,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_gt_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x54,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_gt_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x54,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_gt_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x54,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_gt_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x54,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_gt_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x54,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_gt_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x54,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_gt_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x54,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_gt_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x54,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_gt_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x54,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_gt_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x54,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_gt_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x54,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_gt_f32_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x54,0xd0,0x01,0xcb,0x00,0x00]

v_cmpx_gt_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x54,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_gt_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x54,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_gt_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x54,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_gt_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x54,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_gt_f32_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x54,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_gt_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x54,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_gt_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x54,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_gt_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x54,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_gt_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x54,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_gt_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x54,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_gt_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x54,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_gt_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x54,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_gt_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x54,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_gt_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x54,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_gt_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x54,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_gt_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x54,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_gt_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x54,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_gt_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x54,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_gt_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x54,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x54,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x54,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_f32_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x54,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lg_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x55,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lg_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x55,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lg_f32_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x55,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lg_f32_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x55,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lg_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x55,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lg_f32_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x55,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lg_f32_e64 exec, v1, v2
// CHECK: [0x7e,0x00,0x55,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lg_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x55,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_lg_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x55,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_lg_f32_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x55,0xd0,0x65,0x04,0x02,0x00]

v_cmpx_lg_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x55,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_lg_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x55,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_lg_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x55,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_lg_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x55,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_lg_f32_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x55,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_lg_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x55,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_lg_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x55,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_lg_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x55,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_lg_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x55,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_lg_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x55,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_lg_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x55,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_lg_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x55,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_lg_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x55,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_lg_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x55,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_lg_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x55,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_lg_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x55,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_lg_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x55,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_lg_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x55,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_lg_f32_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x55,0xd0,0x01,0xcb,0x00,0x00]

v_cmpx_lg_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x55,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_lg_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x55,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_lg_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x55,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_lg_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x55,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_lg_f32_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x55,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_lg_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x55,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_lg_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x55,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_lg_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x55,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_lg_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x55,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_lg_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x55,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_lg_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x55,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_lg_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x55,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_lg_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x55,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_lg_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x55,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_lg_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x55,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_lg_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x55,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_lg_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x55,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_lg_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x55,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_lg_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x55,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lg_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x55,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lg_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x55,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lg_f32_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x55,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x56,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x56,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_f32_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x56,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_f32_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x56,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x56,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_f32_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x56,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_f32_e64 exec, v1, v2
// CHECK: [0x7e,0x00,0x56,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x56,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_ge_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x56,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_ge_f32_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x56,0xd0,0x65,0x04,0x02,0x00]

v_cmpx_ge_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x56,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_ge_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x56,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_ge_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x56,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_ge_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x56,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_ge_f32_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x56,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_ge_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x56,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_ge_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x56,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_ge_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x56,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_ge_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x56,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_ge_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x56,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_ge_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x56,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_ge_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x56,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_ge_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x56,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_ge_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x56,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_ge_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x56,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_ge_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x56,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_ge_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x56,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_ge_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x56,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_ge_f32_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x56,0xd0,0x01,0xcb,0x00,0x00]

v_cmpx_ge_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x56,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_ge_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x56,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_ge_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x56,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_ge_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x56,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_ge_f32_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x56,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_ge_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x56,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_ge_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x56,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_ge_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x56,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_ge_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x56,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_ge_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x56,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_ge_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x56,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_ge_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x56,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_ge_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x56,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_ge_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x56,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_ge_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x56,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_ge_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x56,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_ge_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x56,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_ge_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x56,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_ge_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x56,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x56,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x56,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_f32_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x56,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_o_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x57,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_o_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x57,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_o_f32_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x57,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_o_f32_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x57,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_o_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x57,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_o_f32_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x57,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_o_f32_e64 exec, v1, v2
// CHECK: [0x7e,0x00,0x57,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_o_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x57,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_o_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x57,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_o_f32_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x57,0xd0,0x65,0x04,0x02,0x00]

v_cmpx_o_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x57,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_o_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x57,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_o_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x57,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_o_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x57,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_o_f32_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x57,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_o_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x57,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_o_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x57,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_o_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x57,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_o_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x57,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_o_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x57,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_o_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x57,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_o_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x57,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_o_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x57,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_o_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x57,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_o_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x57,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_o_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x57,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_o_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x57,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_o_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x57,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_o_f32_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x57,0xd0,0x01,0xcb,0x00,0x00]

v_cmpx_o_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x57,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_o_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x57,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_o_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x57,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_o_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x57,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_o_f32_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x57,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_o_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x57,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_o_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x57,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_o_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x57,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_o_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x57,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_o_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x57,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_o_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x57,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_o_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x57,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_o_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x57,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_o_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x57,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_o_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x57,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_o_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x57,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_o_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x57,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_o_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x57,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_o_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x57,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_o_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x57,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_o_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x57,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_o_f32_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x57,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_u_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x58,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_u_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x58,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_u_f32_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x58,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_u_f32_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x58,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_u_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x58,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_u_f32_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x58,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_u_f32_e64 exec, v1, v2
// CHECK: [0x7e,0x00,0x58,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_u_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x58,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_u_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x58,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_u_f32_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x58,0xd0,0x65,0x04,0x02,0x00]

v_cmpx_u_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x58,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_u_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x58,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_u_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x58,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_u_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x58,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_u_f32_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x58,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_u_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x58,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_u_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x58,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_u_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x58,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_u_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x58,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_u_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x58,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_u_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x58,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_u_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x58,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_u_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x58,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_u_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x58,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_u_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x58,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_u_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x58,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_u_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x58,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_u_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x58,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_u_f32_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x58,0xd0,0x01,0xcb,0x00,0x00]

v_cmpx_u_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x58,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_u_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x58,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_u_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x58,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_u_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x58,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_u_f32_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x58,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_u_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x58,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_u_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x58,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_u_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x58,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_u_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x58,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_u_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x58,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_u_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x58,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_u_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x58,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_u_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x58,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_u_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x58,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_u_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x58,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_u_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x58,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_u_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x58,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_u_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x58,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_u_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x58,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_u_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x58,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_u_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x58,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_u_f32_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x58,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nge_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x59,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nge_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x59,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nge_f32_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x59,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nge_f32_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x59,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nge_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x59,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nge_f32_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x59,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nge_f32_e64 exec, v1, v2
// CHECK: [0x7e,0x00,0x59,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nge_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x59,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_nge_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x59,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_nge_f32_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x59,0xd0,0x65,0x04,0x02,0x00]

v_cmpx_nge_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x59,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_nge_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x59,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_nge_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x59,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_nge_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x59,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_nge_f32_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x59,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_nge_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x59,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_nge_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x59,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_nge_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x59,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_nge_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x59,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_nge_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x59,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_nge_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x59,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_nge_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x59,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_nge_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x59,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_nge_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x59,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_nge_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x59,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_nge_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x59,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_nge_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x59,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_nge_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x59,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_nge_f32_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x59,0xd0,0x01,0xcb,0x00,0x00]

v_cmpx_nge_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x59,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_nge_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x59,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_nge_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x59,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_nge_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x59,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_nge_f32_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x59,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_nge_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x59,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_nge_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x59,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_nge_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x59,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_nge_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x59,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_nge_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x59,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_nge_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x59,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_nge_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x59,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_nge_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x59,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_nge_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x59,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_nge_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x59,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_nge_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x59,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_nge_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x59,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_nge_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x59,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_nge_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x59,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nge_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x59,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nge_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x59,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nge_f32_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x59,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlg_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x5a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlg_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x5a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlg_f32_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x5a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlg_f32_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x5a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlg_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x5a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlg_f32_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x5a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlg_f32_e64 exec, v1, v2
// CHECK: [0x7e,0x00,0x5a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlg_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x5a,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_nlg_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x5a,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_nlg_f32_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x5a,0xd0,0x65,0x04,0x02,0x00]

v_cmpx_nlg_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x5a,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_nlg_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x5a,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_nlg_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x5a,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_nlg_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x5a,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_nlg_f32_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x5a,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_nlg_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x5a,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_nlg_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x5a,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_nlg_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x5a,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_nlg_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x5a,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_nlg_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x5a,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_nlg_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x5a,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_nlg_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x5a,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_nlg_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x5a,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_nlg_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x5a,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_nlg_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x5a,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_nlg_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x5a,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_nlg_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x5a,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_nlg_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x5a,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_nlg_f32_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x5a,0xd0,0x01,0xcb,0x00,0x00]

v_cmpx_nlg_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x5a,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_nlg_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x5a,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_nlg_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x5a,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_nlg_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x5a,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_nlg_f32_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x5a,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_nlg_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x5a,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_nlg_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x5a,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_nlg_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x5a,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_nlg_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x5a,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_nlg_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x5a,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_nlg_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x5a,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_nlg_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x5a,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_nlg_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x5a,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_nlg_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x5a,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_nlg_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x5a,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_nlg_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x5a,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_nlg_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x5a,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_nlg_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x5a,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_nlg_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x5a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlg_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x5a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlg_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x5a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlg_f32_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x5a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ngt_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x5b,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ngt_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x5b,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ngt_f32_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x5b,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ngt_f32_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x5b,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ngt_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x5b,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ngt_f32_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x5b,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ngt_f32_e64 exec, v1, v2
// CHECK: [0x7e,0x00,0x5b,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ngt_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x5b,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_ngt_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x5b,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_ngt_f32_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x5b,0xd0,0x65,0x04,0x02,0x00]

v_cmpx_ngt_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x5b,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_ngt_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x5b,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_ngt_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x5b,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_ngt_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x5b,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_ngt_f32_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x5b,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_ngt_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x5b,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_ngt_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x5b,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_ngt_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x5b,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_ngt_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x5b,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_ngt_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x5b,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_ngt_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x5b,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_ngt_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x5b,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_ngt_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x5b,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_ngt_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x5b,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_ngt_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x5b,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_ngt_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x5b,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_ngt_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x5b,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_ngt_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x5b,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_ngt_f32_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x5b,0xd0,0x01,0xcb,0x00,0x00]

v_cmpx_ngt_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x5b,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_ngt_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x5b,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_ngt_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x5b,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_ngt_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x5b,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_ngt_f32_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x5b,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_ngt_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x5b,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_ngt_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x5b,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_ngt_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x5b,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_ngt_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x5b,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_ngt_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x5b,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_ngt_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x5b,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_ngt_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x5b,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_ngt_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x5b,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_ngt_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x5b,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_ngt_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x5b,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_ngt_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x5b,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_ngt_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x5b,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_ngt_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x5b,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_ngt_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x5b,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ngt_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x5b,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ngt_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x5b,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ngt_f32_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x5b,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nle_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x5c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nle_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x5c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nle_f32_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x5c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nle_f32_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x5c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nle_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x5c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nle_f32_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x5c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nle_f32_e64 exec, v1, v2
// CHECK: [0x7e,0x00,0x5c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nle_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x5c,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_nle_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x5c,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_nle_f32_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x5c,0xd0,0x65,0x04,0x02,0x00]

v_cmpx_nle_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x5c,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_nle_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x5c,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_nle_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x5c,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_nle_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x5c,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_nle_f32_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x5c,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_nle_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x5c,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_nle_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x5c,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_nle_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x5c,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_nle_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x5c,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_nle_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x5c,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_nle_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x5c,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_nle_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x5c,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_nle_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x5c,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_nle_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x5c,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_nle_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x5c,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_nle_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x5c,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_nle_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x5c,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_nle_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x5c,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_nle_f32_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x5c,0xd0,0x01,0xcb,0x00,0x00]

v_cmpx_nle_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x5c,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_nle_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x5c,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_nle_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x5c,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_nle_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x5c,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_nle_f32_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x5c,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_nle_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x5c,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_nle_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x5c,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_nle_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x5c,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_nle_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x5c,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_nle_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x5c,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_nle_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x5c,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_nle_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x5c,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_nle_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x5c,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_nle_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x5c,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_nle_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x5c,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_nle_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x5c,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_nle_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x5c,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_nle_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x5c,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_nle_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x5c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nle_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x5c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nle_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x5c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nle_f32_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x5c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_neq_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x5d,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_neq_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x5d,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_neq_f32_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x5d,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_neq_f32_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x5d,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_neq_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x5d,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_neq_f32_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x5d,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_neq_f32_e64 exec, v1, v2
// CHECK: [0x7e,0x00,0x5d,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_neq_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x5d,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_neq_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x5d,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_neq_f32_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x5d,0xd0,0x65,0x04,0x02,0x00]

v_cmpx_neq_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x5d,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_neq_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x5d,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_neq_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x5d,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_neq_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x5d,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_neq_f32_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x5d,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_neq_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x5d,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_neq_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x5d,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_neq_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x5d,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_neq_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x5d,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_neq_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x5d,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_neq_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x5d,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_neq_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x5d,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_neq_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x5d,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_neq_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x5d,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_neq_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x5d,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_neq_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x5d,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_neq_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x5d,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_neq_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x5d,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_neq_f32_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x5d,0xd0,0x01,0xcb,0x00,0x00]

v_cmpx_neq_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x5d,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_neq_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x5d,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_neq_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x5d,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_neq_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x5d,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_neq_f32_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x5d,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_neq_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x5d,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_neq_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x5d,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_neq_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x5d,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_neq_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x5d,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_neq_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x5d,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_neq_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x5d,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_neq_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x5d,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_neq_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x5d,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_neq_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x5d,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_neq_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x5d,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_neq_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x5d,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_neq_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x5d,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_neq_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x5d,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_neq_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x5d,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_neq_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x5d,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_neq_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x5d,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_neq_f32_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x5d,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlt_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x5e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlt_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x5e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlt_f32_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x5e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlt_f32_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x5e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlt_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x5e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlt_f32_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x5e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlt_f32_e64 exec, v1, v2
// CHECK: [0x7e,0x00,0x5e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlt_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x5e,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_nlt_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x5e,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_nlt_f32_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x5e,0xd0,0x65,0x04,0x02,0x00]

v_cmpx_nlt_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x5e,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_nlt_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x5e,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_nlt_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x5e,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_nlt_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x5e,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_nlt_f32_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x5e,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_nlt_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x5e,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_nlt_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x5e,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_nlt_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x5e,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_nlt_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x5e,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_nlt_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x5e,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_nlt_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x5e,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_nlt_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x5e,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_nlt_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x5e,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_nlt_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x5e,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_nlt_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x5e,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_nlt_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x5e,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_nlt_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x5e,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_nlt_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x5e,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_nlt_f32_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x5e,0xd0,0x01,0xcb,0x00,0x00]

v_cmpx_nlt_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x5e,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_nlt_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x5e,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_nlt_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x5e,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_nlt_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x5e,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_nlt_f32_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x5e,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_nlt_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x5e,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_nlt_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x5e,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_nlt_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x5e,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_nlt_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x5e,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_nlt_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x5e,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_nlt_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x5e,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_nlt_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x5e,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_nlt_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x5e,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_nlt_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x5e,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_nlt_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x5e,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_nlt_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x5e,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_nlt_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x5e,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_nlt_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x5e,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_nlt_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x5e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlt_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x5e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlt_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x5e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlt_f32_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x5e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_tru_f32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0x5f,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_tru_f32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0x5f,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_tru_f32_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0x5f,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_tru_f32_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0x5f,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_tru_f32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0x5f,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_tru_f32_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0x5f,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_tru_f32_e64 exec, v1, v2
// CHECK: [0x7e,0x00,0x5f,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_tru_f32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0x5f,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_tru_f32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0x5f,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_tru_f32_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0x5f,0xd0,0x65,0x04,0x02,0x00]

v_cmpx_tru_f32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0x5f,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_tru_f32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0x5f,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_tru_f32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0x5f,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_tru_f32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0x5f,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_tru_f32_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0x5f,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_tru_f32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0x5f,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_tru_f32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0x5f,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_tru_f32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0x5f,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_tru_f32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0x5f,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_tru_f32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0x5f,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_tru_f32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0x5f,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_tru_f32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0x5f,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_tru_f32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0x5f,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_tru_f32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0x5f,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_tru_f32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0x5f,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_tru_f32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0x5f,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_tru_f32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0x5f,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_tru_f32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0x5f,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_tru_f32_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0x5f,0xd0,0x01,0xcb,0x00,0x00]

v_cmpx_tru_f32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0x5f,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_tru_f32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0x5f,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_tru_f32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0x5f,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_tru_f32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0x5f,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_tru_f32_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0x5f,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_tru_f32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0x5f,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_tru_f32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0x5f,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_tru_f32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0x5f,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_tru_f32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0x5f,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_tru_f32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0x5f,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_tru_f32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0x5f,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_tru_f32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0x5f,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_tru_f32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0x5f,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_tru_f32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0x5f,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_tru_f32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0x5f,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_tru_f32_e64 s[10:11], -v1, v2
// CHECK: [0x0a,0x00,0x5f,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_tru_f32_e64 s[10:11], v1, -v2
// CHECK: [0x0a,0x00,0x5f,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_tru_f32_e64 s[10:11], -v1, -v2
// CHECK: [0x0a,0x00,0x5f,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_tru_f32_e64 s[10:11], |v1|, v2
// CHECK: [0x0a,0x01,0x5f,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_tru_f32_e64 s[10:11], v1, |v2|
// CHECK: [0x0a,0x02,0x5f,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_tru_f32_e64 s[10:11], |v1|, |v2|
// CHECK: [0x0a,0x03,0x5f,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_tru_f32_e64 s[10:11], v1, v2 clamp
// CHECK: [0x0a,0x80,0x5f,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x60,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x60,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_f64_e64 s[100:101], v[1:2], v[2:3]
// CHECK: [0x64,0x00,0x60,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x60,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x60,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_f64_e64 ttmp[14:15], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x60,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x60,0xd0,0xfe,0x05,0x02,0x00]

v_cmp_f_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x60,0xd0,0x02,0x04,0x02,0x00]

v_cmp_f_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x60,0xd0,0x04,0x04,0x02,0x00]

v_cmp_f_f64_e64 s[10:11], s[100:101], v[2:3]
// CHECK: [0x0a,0x00,0x60,0xd0,0x64,0x04,0x02,0x00]

v_cmp_f_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x60,0xd0,0x66,0x04,0x02,0x00]

v_cmp_f_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x60,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_f_f64_e64 s[10:11], ttmp[14:15], v[2:3]
// CHECK: [0x0a,0x00,0x60,0xd0,0x7a,0x04,0x02,0x00]

v_cmp_f_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x60,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_f_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x60,0xd0,0x80,0x04,0x02,0x00]

v_cmp_f_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x60,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_f_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x60,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_f_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x60,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_f_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x60,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_f_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x60,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_f_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x60,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_f_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x60,0xd0,0x01,0xfd,0x03,0x00]

v_cmp_f_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x60,0xd0,0x01,0x09,0x00,0x00]

v_cmp_f_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x60,0xd0,0x01,0x0d,0x00,0x00]

v_cmp_f_f64_e64 s[10:11], v[1:2], s[100:101]
// CHECK: [0x0a,0x00,0x60,0xd0,0x01,0xc9,0x00,0x00]

v_cmp_f_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x60,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_f_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x60,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_f_f64_e64 s[10:11], v[1:2], ttmp[14:15]
// CHECK: [0x0a,0x00,0x60,0xd0,0x01,0xf5,0x00,0x00]

v_cmp_f_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x60,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_f_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x60,0xd0,0x01,0x01,0x01,0x00]

v_cmp_f_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x60,0xd0,0x01,0x83,0x01,0x00]

v_cmp_f_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x60,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_f_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x60,0xd0,0x01,0xef,0x01,0x00]

v_cmp_f_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x60,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_f_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x60,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_f_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x60,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_f_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x60,0xd0,0x01,0x05,0x02,0x20]

v_cmp_f_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x60,0xd0,0x01,0x05,0x02,0x40]

v_cmp_f_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x60,0xd0,0x01,0x05,0x02,0x60]

v_cmp_f_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x60,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x60,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x60,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_f64_e64 s[10:11], v[1:2], v[2:3] clamp
// CHECK: [0x0a,0x80,0x60,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x61,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x61,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_f64_e64 s[100:101], v[1:2], v[2:3]
// CHECK: [0x64,0x00,0x61,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x61,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x61,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_f64_e64 ttmp[14:15], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x61,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x61,0xd0,0xfe,0x05,0x02,0x00]

v_cmp_lt_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x61,0xd0,0x02,0x04,0x02,0x00]

v_cmp_lt_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x61,0xd0,0x04,0x04,0x02,0x00]

v_cmp_lt_f64_e64 s[10:11], s[100:101], v[2:3]
// CHECK: [0x0a,0x00,0x61,0xd0,0x64,0x04,0x02,0x00]

v_cmp_lt_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x61,0xd0,0x66,0x04,0x02,0x00]

v_cmp_lt_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x61,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_lt_f64_e64 s[10:11], ttmp[14:15], v[2:3]
// CHECK: [0x0a,0x00,0x61,0xd0,0x7a,0x04,0x02,0x00]

v_cmp_lt_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x61,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_lt_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x61,0xd0,0x80,0x04,0x02,0x00]

v_cmp_lt_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x61,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_lt_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x61,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_lt_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x61,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_lt_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x61,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_lt_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x61,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_lt_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x61,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_lt_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x61,0xd0,0x01,0xfd,0x03,0x00]

v_cmp_lt_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x61,0xd0,0x01,0x09,0x00,0x00]

v_cmp_lt_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x61,0xd0,0x01,0x0d,0x00,0x00]

v_cmp_lt_f64_e64 s[10:11], v[1:2], s[100:101]
// CHECK: [0x0a,0x00,0x61,0xd0,0x01,0xc9,0x00,0x00]

v_cmp_lt_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x61,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_lt_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x61,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_lt_f64_e64 s[10:11], v[1:2], ttmp[14:15]
// CHECK: [0x0a,0x00,0x61,0xd0,0x01,0xf5,0x00,0x00]

v_cmp_lt_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x61,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_lt_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x61,0xd0,0x01,0x01,0x01,0x00]

v_cmp_lt_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x61,0xd0,0x01,0x83,0x01,0x00]

v_cmp_lt_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x61,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_lt_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x61,0xd0,0x01,0xef,0x01,0x00]

v_cmp_lt_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x61,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_lt_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x61,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_lt_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x61,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_lt_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x61,0xd0,0x01,0x05,0x02,0x20]

v_cmp_lt_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x61,0xd0,0x01,0x05,0x02,0x40]

v_cmp_lt_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x61,0xd0,0x01,0x05,0x02,0x60]

v_cmp_lt_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x61,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x61,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x61,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_f64_e64 s[10:11], v[1:2], v[2:3] clamp
// CHECK: [0x0a,0x80,0x61,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x62,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x62,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_f64_e64 s[100:101], v[1:2], v[2:3]
// CHECK: [0x64,0x00,0x62,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x62,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x62,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_f64_e64 ttmp[14:15], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x62,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x62,0xd0,0xfe,0x05,0x02,0x00]

v_cmp_eq_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x62,0xd0,0x02,0x04,0x02,0x00]

v_cmp_eq_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x62,0xd0,0x04,0x04,0x02,0x00]

v_cmp_eq_f64_e64 s[10:11], s[100:101], v[2:3]
// CHECK: [0x0a,0x00,0x62,0xd0,0x64,0x04,0x02,0x00]

v_cmp_eq_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x62,0xd0,0x66,0x04,0x02,0x00]

v_cmp_eq_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x62,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_eq_f64_e64 s[10:11], ttmp[14:15], v[2:3]
// CHECK: [0x0a,0x00,0x62,0xd0,0x7a,0x04,0x02,0x00]

v_cmp_eq_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x62,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_eq_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x62,0xd0,0x80,0x04,0x02,0x00]

v_cmp_eq_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x62,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_eq_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x62,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_eq_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x62,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_eq_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x62,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_eq_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x62,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_eq_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x62,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_eq_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x62,0xd0,0x01,0xfd,0x03,0x00]

v_cmp_eq_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x62,0xd0,0x01,0x09,0x00,0x00]

v_cmp_eq_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x62,0xd0,0x01,0x0d,0x00,0x00]

v_cmp_eq_f64_e64 s[10:11], v[1:2], s[100:101]
// CHECK: [0x0a,0x00,0x62,0xd0,0x01,0xc9,0x00,0x00]

v_cmp_eq_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x62,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_eq_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x62,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_eq_f64_e64 s[10:11], v[1:2], ttmp[14:15]
// CHECK: [0x0a,0x00,0x62,0xd0,0x01,0xf5,0x00,0x00]

v_cmp_eq_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x62,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_eq_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x62,0xd0,0x01,0x01,0x01,0x00]

v_cmp_eq_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x62,0xd0,0x01,0x83,0x01,0x00]

v_cmp_eq_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x62,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_eq_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x62,0xd0,0x01,0xef,0x01,0x00]

v_cmp_eq_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x62,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_eq_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x62,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_eq_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x62,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_eq_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x62,0xd0,0x01,0x05,0x02,0x20]

v_cmp_eq_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x62,0xd0,0x01,0x05,0x02,0x40]

v_cmp_eq_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x62,0xd0,0x01,0x05,0x02,0x60]

v_cmp_eq_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x62,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x62,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x62,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_f64_e64 s[10:11], v[1:2], v[2:3] clamp
// CHECK: [0x0a,0x80,0x62,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x63,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x63,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_f64_e64 s[100:101], v[1:2], v[2:3]
// CHECK: [0x64,0x00,0x63,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x63,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x63,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_f64_e64 ttmp[14:15], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x63,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x63,0xd0,0xfe,0x05,0x02,0x00]

v_cmp_le_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x63,0xd0,0x02,0x04,0x02,0x00]

v_cmp_le_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x63,0xd0,0x04,0x04,0x02,0x00]

v_cmp_le_f64_e64 s[10:11], s[100:101], v[2:3]
// CHECK: [0x0a,0x00,0x63,0xd0,0x64,0x04,0x02,0x00]

v_cmp_le_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x63,0xd0,0x66,0x04,0x02,0x00]

v_cmp_le_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x63,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_le_f64_e64 s[10:11], ttmp[14:15], v[2:3]
// CHECK: [0x0a,0x00,0x63,0xd0,0x7a,0x04,0x02,0x00]

v_cmp_le_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x63,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_le_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x63,0xd0,0x80,0x04,0x02,0x00]

v_cmp_le_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x63,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_le_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x63,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_le_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x63,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_le_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x63,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_le_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x63,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_le_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x63,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_le_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x63,0xd0,0x01,0xfd,0x03,0x00]

v_cmp_le_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x63,0xd0,0x01,0x09,0x00,0x00]

v_cmp_le_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x63,0xd0,0x01,0x0d,0x00,0x00]

v_cmp_le_f64_e64 s[10:11], v[1:2], s[100:101]
// CHECK: [0x0a,0x00,0x63,0xd0,0x01,0xc9,0x00,0x00]

v_cmp_le_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x63,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_le_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x63,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_le_f64_e64 s[10:11], v[1:2], ttmp[14:15]
// CHECK: [0x0a,0x00,0x63,0xd0,0x01,0xf5,0x00,0x00]

v_cmp_le_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x63,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_le_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x63,0xd0,0x01,0x01,0x01,0x00]

v_cmp_le_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x63,0xd0,0x01,0x83,0x01,0x00]

v_cmp_le_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x63,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_le_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x63,0xd0,0x01,0xef,0x01,0x00]

v_cmp_le_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x63,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_le_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x63,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_le_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x63,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_le_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x63,0xd0,0x01,0x05,0x02,0x20]

v_cmp_le_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x63,0xd0,0x01,0x05,0x02,0x40]

v_cmp_le_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x63,0xd0,0x01,0x05,0x02,0x60]

v_cmp_le_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x63,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x63,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x63,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_f64_e64 s[10:11], v[1:2], v[2:3] clamp
// CHECK: [0x0a,0x80,0x63,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x64,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x64,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_f64_e64 s[100:101], v[1:2], v[2:3]
// CHECK: [0x64,0x00,0x64,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x64,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x64,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_f64_e64 ttmp[14:15], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x64,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x64,0xd0,0xfe,0x05,0x02,0x00]

v_cmp_gt_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x64,0xd0,0x02,0x04,0x02,0x00]

v_cmp_gt_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x64,0xd0,0x04,0x04,0x02,0x00]

v_cmp_gt_f64_e64 s[10:11], s[100:101], v[2:3]
// CHECK: [0x0a,0x00,0x64,0xd0,0x64,0x04,0x02,0x00]

v_cmp_gt_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x64,0xd0,0x66,0x04,0x02,0x00]

v_cmp_gt_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x64,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_gt_f64_e64 s[10:11], ttmp[14:15], v[2:3]
// CHECK: [0x0a,0x00,0x64,0xd0,0x7a,0x04,0x02,0x00]

v_cmp_gt_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x64,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_gt_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x64,0xd0,0x80,0x04,0x02,0x00]

v_cmp_gt_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x64,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_gt_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x64,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_gt_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x64,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_gt_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x64,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_gt_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x64,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_gt_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x64,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_gt_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x64,0xd0,0x01,0xfd,0x03,0x00]

v_cmp_gt_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x64,0xd0,0x01,0x09,0x00,0x00]

v_cmp_gt_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x64,0xd0,0x01,0x0d,0x00,0x00]

v_cmp_gt_f64_e64 s[10:11], v[1:2], s[100:101]
// CHECK: [0x0a,0x00,0x64,0xd0,0x01,0xc9,0x00,0x00]

v_cmp_gt_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x64,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_gt_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x64,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_gt_f64_e64 s[10:11], v[1:2], ttmp[14:15]
// CHECK: [0x0a,0x00,0x64,0xd0,0x01,0xf5,0x00,0x00]

v_cmp_gt_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x64,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_gt_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x64,0xd0,0x01,0x01,0x01,0x00]

v_cmp_gt_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x64,0xd0,0x01,0x83,0x01,0x00]

v_cmp_gt_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x64,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_gt_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x64,0xd0,0x01,0xef,0x01,0x00]

v_cmp_gt_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x64,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_gt_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x64,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_gt_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x64,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_gt_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x64,0xd0,0x01,0x05,0x02,0x20]

v_cmp_gt_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x64,0xd0,0x01,0x05,0x02,0x40]

v_cmp_gt_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x64,0xd0,0x01,0x05,0x02,0x60]

v_cmp_gt_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x64,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x64,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x64,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_f64_e64 s[10:11], v[1:2], v[2:3] clamp
// CHECK: [0x0a,0x80,0x64,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lg_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x65,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lg_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x65,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lg_f64_e64 s[100:101], v[1:2], v[2:3]
// CHECK: [0x64,0x00,0x65,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lg_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x65,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lg_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x65,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lg_f64_e64 ttmp[14:15], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x65,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lg_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x65,0xd0,0xfe,0x05,0x02,0x00]

v_cmp_lg_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x65,0xd0,0x02,0x04,0x02,0x00]

v_cmp_lg_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x65,0xd0,0x04,0x04,0x02,0x00]

v_cmp_lg_f64_e64 s[10:11], s[100:101], v[2:3]
// CHECK: [0x0a,0x00,0x65,0xd0,0x64,0x04,0x02,0x00]

v_cmp_lg_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x65,0xd0,0x66,0x04,0x02,0x00]

v_cmp_lg_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x65,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_lg_f64_e64 s[10:11], ttmp[14:15], v[2:3]
// CHECK: [0x0a,0x00,0x65,0xd0,0x7a,0x04,0x02,0x00]

v_cmp_lg_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x65,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_lg_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x65,0xd0,0x80,0x04,0x02,0x00]

v_cmp_lg_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x65,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_lg_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x65,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_lg_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x65,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_lg_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x65,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_lg_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x65,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_lg_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x65,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_lg_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x65,0xd0,0x01,0xfd,0x03,0x00]

v_cmp_lg_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x65,0xd0,0x01,0x09,0x00,0x00]

v_cmp_lg_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x65,0xd0,0x01,0x0d,0x00,0x00]

v_cmp_lg_f64_e64 s[10:11], v[1:2], s[100:101]
// CHECK: [0x0a,0x00,0x65,0xd0,0x01,0xc9,0x00,0x00]

v_cmp_lg_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x65,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_lg_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x65,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_lg_f64_e64 s[10:11], v[1:2], ttmp[14:15]
// CHECK: [0x0a,0x00,0x65,0xd0,0x01,0xf5,0x00,0x00]

v_cmp_lg_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x65,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_lg_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x65,0xd0,0x01,0x01,0x01,0x00]

v_cmp_lg_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x65,0xd0,0x01,0x83,0x01,0x00]

v_cmp_lg_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x65,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_lg_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x65,0xd0,0x01,0xef,0x01,0x00]

v_cmp_lg_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x65,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_lg_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x65,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_lg_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x65,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_lg_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x65,0xd0,0x01,0x05,0x02,0x20]

v_cmp_lg_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x65,0xd0,0x01,0x05,0x02,0x40]

v_cmp_lg_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x65,0xd0,0x01,0x05,0x02,0x60]

v_cmp_lg_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x65,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lg_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x65,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lg_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x65,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lg_f64_e64 s[10:11], v[1:2], v[2:3] clamp
// CHECK: [0x0a,0x80,0x65,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x66,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x66,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_f64_e64 s[100:101], v[1:2], v[2:3]
// CHECK: [0x64,0x00,0x66,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x66,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x66,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_f64_e64 ttmp[14:15], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x66,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x66,0xd0,0xfe,0x05,0x02,0x00]

v_cmp_ge_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x66,0xd0,0x02,0x04,0x02,0x00]

v_cmp_ge_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x66,0xd0,0x04,0x04,0x02,0x00]

v_cmp_ge_f64_e64 s[10:11], s[100:101], v[2:3]
// CHECK: [0x0a,0x00,0x66,0xd0,0x64,0x04,0x02,0x00]

v_cmp_ge_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x66,0xd0,0x66,0x04,0x02,0x00]

v_cmp_ge_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x66,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_ge_f64_e64 s[10:11], ttmp[14:15], v[2:3]
// CHECK: [0x0a,0x00,0x66,0xd0,0x7a,0x04,0x02,0x00]

v_cmp_ge_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x66,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_ge_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x66,0xd0,0x80,0x04,0x02,0x00]

v_cmp_ge_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x66,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_ge_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x66,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_ge_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x66,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_ge_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x66,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_ge_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x66,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_ge_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x66,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_ge_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x66,0xd0,0x01,0xfd,0x03,0x00]

v_cmp_ge_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x66,0xd0,0x01,0x09,0x00,0x00]

v_cmp_ge_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x66,0xd0,0x01,0x0d,0x00,0x00]

v_cmp_ge_f64_e64 s[10:11], v[1:2], s[100:101]
// CHECK: [0x0a,0x00,0x66,0xd0,0x01,0xc9,0x00,0x00]

v_cmp_ge_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x66,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_ge_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x66,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_ge_f64_e64 s[10:11], v[1:2], ttmp[14:15]
// CHECK: [0x0a,0x00,0x66,0xd0,0x01,0xf5,0x00,0x00]

v_cmp_ge_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x66,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_ge_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x66,0xd0,0x01,0x01,0x01,0x00]

v_cmp_ge_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x66,0xd0,0x01,0x83,0x01,0x00]

v_cmp_ge_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x66,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_ge_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x66,0xd0,0x01,0xef,0x01,0x00]

v_cmp_ge_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x66,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_ge_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x66,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_ge_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x66,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_ge_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x66,0xd0,0x01,0x05,0x02,0x20]

v_cmp_ge_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x66,0xd0,0x01,0x05,0x02,0x40]

v_cmp_ge_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x66,0xd0,0x01,0x05,0x02,0x60]

v_cmp_ge_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x66,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x66,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x66,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_f64_e64 s[10:11], v[1:2], v[2:3] clamp
// CHECK: [0x0a,0x80,0x66,0xd0,0x01,0x05,0x02,0x00]

v_cmp_o_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x67,0xd0,0x01,0x05,0x02,0x00]

v_cmp_o_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x67,0xd0,0x01,0x05,0x02,0x00]

v_cmp_o_f64_e64 s[100:101], v[1:2], v[2:3]
// CHECK: [0x64,0x00,0x67,0xd0,0x01,0x05,0x02,0x00]

v_cmp_o_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x67,0xd0,0x01,0x05,0x02,0x00]

v_cmp_o_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x67,0xd0,0x01,0x05,0x02,0x00]

v_cmp_o_f64_e64 ttmp[14:15], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x67,0xd0,0x01,0x05,0x02,0x00]

v_cmp_o_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x67,0xd0,0xfe,0x05,0x02,0x00]

v_cmp_o_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x67,0xd0,0x02,0x04,0x02,0x00]

v_cmp_o_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x67,0xd0,0x04,0x04,0x02,0x00]

v_cmp_o_f64_e64 s[10:11], s[100:101], v[2:3]
// CHECK: [0x0a,0x00,0x67,0xd0,0x64,0x04,0x02,0x00]

v_cmp_o_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x67,0xd0,0x66,0x04,0x02,0x00]

v_cmp_o_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x67,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_o_f64_e64 s[10:11], ttmp[14:15], v[2:3]
// CHECK: [0x0a,0x00,0x67,0xd0,0x7a,0x04,0x02,0x00]

v_cmp_o_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x67,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_o_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x67,0xd0,0x80,0x04,0x02,0x00]

v_cmp_o_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x67,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_o_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x67,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_o_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x67,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_o_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x67,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_o_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x67,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_o_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x67,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_o_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x67,0xd0,0x01,0xfd,0x03,0x00]

v_cmp_o_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x67,0xd0,0x01,0x09,0x00,0x00]

v_cmp_o_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x67,0xd0,0x01,0x0d,0x00,0x00]

v_cmp_o_f64_e64 s[10:11], v[1:2], s[100:101]
// CHECK: [0x0a,0x00,0x67,0xd0,0x01,0xc9,0x00,0x00]

v_cmp_o_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x67,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_o_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x67,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_o_f64_e64 s[10:11], v[1:2], ttmp[14:15]
// CHECK: [0x0a,0x00,0x67,0xd0,0x01,0xf5,0x00,0x00]

v_cmp_o_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x67,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_o_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x67,0xd0,0x01,0x01,0x01,0x00]

v_cmp_o_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x67,0xd0,0x01,0x83,0x01,0x00]

v_cmp_o_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x67,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_o_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x67,0xd0,0x01,0xef,0x01,0x00]

v_cmp_o_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x67,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_o_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x67,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_o_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x67,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_o_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x67,0xd0,0x01,0x05,0x02,0x20]

v_cmp_o_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x67,0xd0,0x01,0x05,0x02,0x40]

v_cmp_o_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x67,0xd0,0x01,0x05,0x02,0x60]

v_cmp_o_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x67,0xd0,0x01,0x05,0x02,0x00]

v_cmp_o_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x67,0xd0,0x01,0x05,0x02,0x00]

v_cmp_o_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x67,0xd0,0x01,0x05,0x02,0x00]

v_cmp_o_f64_e64 s[10:11], v[1:2], v[2:3] clamp
// CHECK: [0x0a,0x80,0x67,0xd0,0x01,0x05,0x02,0x00]

v_cmp_u_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x68,0xd0,0x01,0x05,0x02,0x00]

v_cmp_u_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x68,0xd0,0x01,0x05,0x02,0x00]

v_cmp_u_f64_e64 s[100:101], v[1:2], v[2:3]
// CHECK: [0x64,0x00,0x68,0xd0,0x01,0x05,0x02,0x00]

v_cmp_u_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x68,0xd0,0x01,0x05,0x02,0x00]

v_cmp_u_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x68,0xd0,0x01,0x05,0x02,0x00]

v_cmp_u_f64_e64 ttmp[14:15], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x68,0xd0,0x01,0x05,0x02,0x00]

v_cmp_u_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x68,0xd0,0xfe,0x05,0x02,0x00]

v_cmp_u_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x68,0xd0,0x02,0x04,0x02,0x00]

v_cmp_u_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x68,0xd0,0x04,0x04,0x02,0x00]

v_cmp_u_f64_e64 s[10:11], s[100:101], v[2:3]
// CHECK: [0x0a,0x00,0x68,0xd0,0x64,0x04,0x02,0x00]

v_cmp_u_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x68,0xd0,0x66,0x04,0x02,0x00]

v_cmp_u_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x68,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_u_f64_e64 s[10:11], ttmp[14:15], v[2:3]
// CHECK: [0x0a,0x00,0x68,0xd0,0x7a,0x04,0x02,0x00]

v_cmp_u_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x68,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_u_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x68,0xd0,0x80,0x04,0x02,0x00]

v_cmp_u_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x68,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_u_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x68,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_u_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x68,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_u_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x68,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_u_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x68,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_u_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x68,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_u_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x68,0xd0,0x01,0xfd,0x03,0x00]

v_cmp_u_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x68,0xd0,0x01,0x09,0x00,0x00]

v_cmp_u_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x68,0xd0,0x01,0x0d,0x00,0x00]

v_cmp_u_f64_e64 s[10:11], v[1:2], s[100:101]
// CHECK: [0x0a,0x00,0x68,0xd0,0x01,0xc9,0x00,0x00]

v_cmp_u_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x68,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_u_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x68,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_u_f64_e64 s[10:11], v[1:2], ttmp[14:15]
// CHECK: [0x0a,0x00,0x68,0xd0,0x01,0xf5,0x00,0x00]

v_cmp_u_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x68,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_u_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x68,0xd0,0x01,0x01,0x01,0x00]

v_cmp_u_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x68,0xd0,0x01,0x83,0x01,0x00]

v_cmp_u_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x68,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_u_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x68,0xd0,0x01,0xef,0x01,0x00]

v_cmp_u_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x68,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_u_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x68,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_u_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x68,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_u_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x68,0xd0,0x01,0x05,0x02,0x20]

v_cmp_u_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x68,0xd0,0x01,0x05,0x02,0x40]

v_cmp_u_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x68,0xd0,0x01,0x05,0x02,0x60]

v_cmp_u_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x68,0xd0,0x01,0x05,0x02,0x00]

v_cmp_u_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x68,0xd0,0x01,0x05,0x02,0x00]

v_cmp_u_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x68,0xd0,0x01,0x05,0x02,0x00]

v_cmp_u_f64_e64 s[10:11], v[1:2], v[2:3] clamp
// CHECK: [0x0a,0x80,0x68,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nge_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x69,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nge_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x69,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nge_f64_e64 s[100:101], v[1:2], v[2:3]
// CHECK: [0x64,0x00,0x69,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nge_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x69,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nge_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x69,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nge_f64_e64 ttmp[14:15], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x69,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nge_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x69,0xd0,0xfe,0x05,0x02,0x00]

v_cmp_nge_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x69,0xd0,0x02,0x04,0x02,0x00]

v_cmp_nge_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x69,0xd0,0x04,0x04,0x02,0x00]

v_cmp_nge_f64_e64 s[10:11], s[100:101], v[2:3]
// CHECK: [0x0a,0x00,0x69,0xd0,0x64,0x04,0x02,0x00]

v_cmp_nge_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x69,0xd0,0x66,0x04,0x02,0x00]

v_cmp_nge_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x69,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_nge_f64_e64 s[10:11], ttmp[14:15], v[2:3]
// CHECK: [0x0a,0x00,0x69,0xd0,0x7a,0x04,0x02,0x00]

v_cmp_nge_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x69,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_nge_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x69,0xd0,0x80,0x04,0x02,0x00]

v_cmp_nge_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x69,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_nge_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x69,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_nge_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x69,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_nge_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x69,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_nge_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x69,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_nge_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x69,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_nge_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x69,0xd0,0x01,0xfd,0x03,0x00]

v_cmp_nge_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x69,0xd0,0x01,0x09,0x00,0x00]

v_cmp_nge_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x69,0xd0,0x01,0x0d,0x00,0x00]

v_cmp_nge_f64_e64 s[10:11], v[1:2], s[100:101]
// CHECK: [0x0a,0x00,0x69,0xd0,0x01,0xc9,0x00,0x00]

v_cmp_nge_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x69,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_nge_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x69,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_nge_f64_e64 s[10:11], v[1:2], ttmp[14:15]
// CHECK: [0x0a,0x00,0x69,0xd0,0x01,0xf5,0x00,0x00]

v_cmp_nge_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x69,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_nge_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x69,0xd0,0x01,0x01,0x01,0x00]

v_cmp_nge_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x69,0xd0,0x01,0x83,0x01,0x00]

v_cmp_nge_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x69,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_nge_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x69,0xd0,0x01,0xef,0x01,0x00]

v_cmp_nge_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x69,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_nge_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x69,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_nge_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x69,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_nge_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x69,0xd0,0x01,0x05,0x02,0x20]

v_cmp_nge_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x69,0xd0,0x01,0x05,0x02,0x40]

v_cmp_nge_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x69,0xd0,0x01,0x05,0x02,0x60]

v_cmp_nge_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x69,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nge_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x69,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nge_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x69,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nge_f64_e64 s[10:11], v[1:2], v[2:3] clamp
// CHECK: [0x0a,0x80,0x69,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlg_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x6a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlg_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x6a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlg_f64_e64 s[100:101], v[1:2], v[2:3]
// CHECK: [0x64,0x00,0x6a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlg_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x6a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlg_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x6a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlg_f64_e64 ttmp[14:15], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x6a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlg_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x6a,0xd0,0xfe,0x05,0x02,0x00]

v_cmp_nlg_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x6a,0xd0,0x02,0x04,0x02,0x00]

v_cmp_nlg_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x6a,0xd0,0x04,0x04,0x02,0x00]

v_cmp_nlg_f64_e64 s[10:11], s[100:101], v[2:3]
// CHECK: [0x0a,0x00,0x6a,0xd0,0x64,0x04,0x02,0x00]

v_cmp_nlg_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x6a,0xd0,0x66,0x04,0x02,0x00]

v_cmp_nlg_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x6a,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_nlg_f64_e64 s[10:11], ttmp[14:15], v[2:3]
// CHECK: [0x0a,0x00,0x6a,0xd0,0x7a,0x04,0x02,0x00]

v_cmp_nlg_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x6a,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_nlg_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x6a,0xd0,0x80,0x04,0x02,0x00]

v_cmp_nlg_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x6a,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_nlg_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x6a,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_nlg_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x6a,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_nlg_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x6a,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_nlg_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x6a,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_nlg_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x6a,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_nlg_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x6a,0xd0,0x01,0xfd,0x03,0x00]

v_cmp_nlg_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x6a,0xd0,0x01,0x09,0x00,0x00]

v_cmp_nlg_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x6a,0xd0,0x01,0x0d,0x00,0x00]

v_cmp_nlg_f64_e64 s[10:11], v[1:2], s[100:101]
// CHECK: [0x0a,0x00,0x6a,0xd0,0x01,0xc9,0x00,0x00]

v_cmp_nlg_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x6a,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_nlg_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x6a,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_nlg_f64_e64 s[10:11], v[1:2], ttmp[14:15]
// CHECK: [0x0a,0x00,0x6a,0xd0,0x01,0xf5,0x00,0x00]

v_cmp_nlg_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x6a,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_nlg_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x6a,0xd0,0x01,0x01,0x01,0x00]

v_cmp_nlg_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x6a,0xd0,0x01,0x83,0x01,0x00]

v_cmp_nlg_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x6a,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_nlg_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x6a,0xd0,0x01,0xef,0x01,0x00]

v_cmp_nlg_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x6a,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_nlg_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x6a,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_nlg_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x6a,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_nlg_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x6a,0xd0,0x01,0x05,0x02,0x20]

v_cmp_nlg_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x6a,0xd0,0x01,0x05,0x02,0x40]

v_cmp_nlg_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x6a,0xd0,0x01,0x05,0x02,0x60]

v_cmp_nlg_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x6a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlg_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x6a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlg_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x6a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlg_f64_e64 s[10:11], v[1:2], v[2:3] clamp
// CHECK: [0x0a,0x80,0x6a,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ngt_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x6b,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ngt_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x6b,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ngt_f64_e64 s[100:101], v[1:2], v[2:3]
// CHECK: [0x64,0x00,0x6b,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ngt_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x6b,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ngt_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x6b,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ngt_f64_e64 ttmp[14:15], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x6b,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ngt_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x6b,0xd0,0xfe,0x05,0x02,0x00]

v_cmp_ngt_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x6b,0xd0,0x02,0x04,0x02,0x00]

v_cmp_ngt_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x6b,0xd0,0x04,0x04,0x02,0x00]

v_cmp_ngt_f64_e64 s[10:11], s[100:101], v[2:3]
// CHECK: [0x0a,0x00,0x6b,0xd0,0x64,0x04,0x02,0x00]

v_cmp_ngt_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x6b,0xd0,0x66,0x04,0x02,0x00]

v_cmp_ngt_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x6b,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_ngt_f64_e64 s[10:11], ttmp[14:15], v[2:3]
// CHECK: [0x0a,0x00,0x6b,0xd0,0x7a,0x04,0x02,0x00]

v_cmp_ngt_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x6b,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_ngt_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x6b,0xd0,0x80,0x04,0x02,0x00]

v_cmp_ngt_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x6b,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_ngt_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x6b,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_ngt_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x6b,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_ngt_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x6b,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_ngt_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x6b,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_ngt_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x6b,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_ngt_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x6b,0xd0,0x01,0xfd,0x03,0x00]

v_cmp_ngt_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x6b,0xd0,0x01,0x09,0x00,0x00]

v_cmp_ngt_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x6b,0xd0,0x01,0x0d,0x00,0x00]

v_cmp_ngt_f64_e64 s[10:11], v[1:2], s[100:101]
// CHECK: [0x0a,0x00,0x6b,0xd0,0x01,0xc9,0x00,0x00]

v_cmp_ngt_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x6b,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_ngt_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x6b,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_ngt_f64_e64 s[10:11], v[1:2], ttmp[14:15]
// CHECK: [0x0a,0x00,0x6b,0xd0,0x01,0xf5,0x00,0x00]

v_cmp_ngt_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x6b,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_ngt_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x6b,0xd0,0x01,0x01,0x01,0x00]

v_cmp_ngt_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x6b,0xd0,0x01,0x83,0x01,0x00]

v_cmp_ngt_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x6b,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_ngt_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x6b,0xd0,0x01,0xef,0x01,0x00]

v_cmp_ngt_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x6b,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_ngt_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x6b,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_ngt_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x6b,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_ngt_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x6b,0xd0,0x01,0x05,0x02,0x20]

v_cmp_ngt_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x6b,0xd0,0x01,0x05,0x02,0x40]

v_cmp_ngt_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x6b,0xd0,0x01,0x05,0x02,0x60]

v_cmp_ngt_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x6b,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ngt_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x6b,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ngt_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x6b,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ngt_f64_e64 s[10:11], v[1:2], v[2:3] clamp
// CHECK: [0x0a,0x80,0x6b,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nle_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x6c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nle_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x6c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nle_f64_e64 s[100:101], v[1:2], v[2:3]
// CHECK: [0x64,0x00,0x6c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nle_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x6c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nle_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x6c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nle_f64_e64 ttmp[14:15], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x6c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nle_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x6c,0xd0,0xfe,0x05,0x02,0x00]

v_cmp_nle_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x6c,0xd0,0x02,0x04,0x02,0x00]

v_cmp_nle_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x6c,0xd0,0x04,0x04,0x02,0x00]

v_cmp_nle_f64_e64 s[10:11], s[100:101], v[2:3]
// CHECK: [0x0a,0x00,0x6c,0xd0,0x64,0x04,0x02,0x00]

v_cmp_nle_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x6c,0xd0,0x66,0x04,0x02,0x00]

v_cmp_nle_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x6c,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_nle_f64_e64 s[10:11], ttmp[14:15], v[2:3]
// CHECK: [0x0a,0x00,0x6c,0xd0,0x7a,0x04,0x02,0x00]

v_cmp_nle_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x6c,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_nle_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x6c,0xd0,0x80,0x04,0x02,0x00]

v_cmp_nle_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x6c,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_nle_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x6c,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_nle_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x6c,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_nle_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x6c,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_nle_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x6c,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_nle_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x6c,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_nle_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x6c,0xd0,0x01,0xfd,0x03,0x00]

v_cmp_nle_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x6c,0xd0,0x01,0x09,0x00,0x00]

v_cmp_nle_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x6c,0xd0,0x01,0x0d,0x00,0x00]

v_cmp_nle_f64_e64 s[10:11], v[1:2], s[100:101]
// CHECK: [0x0a,0x00,0x6c,0xd0,0x01,0xc9,0x00,0x00]

v_cmp_nle_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x6c,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_nle_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x6c,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_nle_f64_e64 s[10:11], v[1:2], ttmp[14:15]
// CHECK: [0x0a,0x00,0x6c,0xd0,0x01,0xf5,0x00,0x00]

v_cmp_nle_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x6c,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_nle_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x6c,0xd0,0x01,0x01,0x01,0x00]

v_cmp_nle_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x6c,0xd0,0x01,0x83,0x01,0x00]

v_cmp_nle_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x6c,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_nle_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x6c,0xd0,0x01,0xef,0x01,0x00]

v_cmp_nle_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x6c,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_nle_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x6c,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_nle_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x6c,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_nle_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x6c,0xd0,0x01,0x05,0x02,0x20]

v_cmp_nle_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x6c,0xd0,0x01,0x05,0x02,0x40]

v_cmp_nle_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x6c,0xd0,0x01,0x05,0x02,0x60]

v_cmp_nle_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x6c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nle_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x6c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nle_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x6c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nle_f64_e64 s[10:11], v[1:2], v[2:3] clamp
// CHECK: [0x0a,0x80,0x6c,0xd0,0x01,0x05,0x02,0x00]

v_cmp_neq_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x6d,0xd0,0x01,0x05,0x02,0x00]

v_cmp_neq_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x6d,0xd0,0x01,0x05,0x02,0x00]

v_cmp_neq_f64_e64 s[100:101], v[1:2], v[2:3]
// CHECK: [0x64,0x00,0x6d,0xd0,0x01,0x05,0x02,0x00]

v_cmp_neq_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x6d,0xd0,0x01,0x05,0x02,0x00]

v_cmp_neq_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x6d,0xd0,0x01,0x05,0x02,0x00]

v_cmp_neq_f64_e64 ttmp[14:15], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x6d,0xd0,0x01,0x05,0x02,0x00]

v_cmp_neq_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x6d,0xd0,0xfe,0x05,0x02,0x00]

v_cmp_neq_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x6d,0xd0,0x02,0x04,0x02,0x00]

v_cmp_neq_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x6d,0xd0,0x04,0x04,0x02,0x00]

v_cmp_neq_f64_e64 s[10:11], s[100:101], v[2:3]
// CHECK: [0x0a,0x00,0x6d,0xd0,0x64,0x04,0x02,0x00]

v_cmp_neq_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x6d,0xd0,0x66,0x04,0x02,0x00]

v_cmp_neq_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x6d,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_neq_f64_e64 s[10:11], ttmp[14:15], v[2:3]
// CHECK: [0x0a,0x00,0x6d,0xd0,0x7a,0x04,0x02,0x00]

v_cmp_neq_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x6d,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_neq_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x6d,0xd0,0x80,0x04,0x02,0x00]

v_cmp_neq_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x6d,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_neq_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x6d,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_neq_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x6d,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_neq_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x6d,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_neq_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x6d,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_neq_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x6d,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_neq_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x6d,0xd0,0x01,0xfd,0x03,0x00]

v_cmp_neq_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x6d,0xd0,0x01,0x09,0x00,0x00]

v_cmp_neq_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x6d,0xd0,0x01,0x0d,0x00,0x00]

v_cmp_neq_f64_e64 s[10:11], v[1:2], s[100:101]
// CHECK: [0x0a,0x00,0x6d,0xd0,0x01,0xc9,0x00,0x00]

v_cmp_neq_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x6d,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_neq_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x6d,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_neq_f64_e64 s[10:11], v[1:2], ttmp[14:15]
// CHECK: [0x0a,0x00,0x6d,0xd0,0x01,0xf5,0x00,0x00]

v_cmp_neq_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x6d,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_neq_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x6d,0xd0,0x01,0x01,0x01,0x00]

v_cmp_neq_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x6d,0xd0,0x01,0x83,0x01,0x00]

v_cmp_neq_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x6d,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_neq_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x6d,0xd0,0x01,0xef,0x01,0x00]

v_cmp_neq_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x6d,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_neq_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x6d,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_neq_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x6d,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_neq_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x6d,0xd0,0x01,0x05,0x02,0x20]

v_cmp_neq_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x6d,0xd0,0x01,0x05,0x02,0x40]

v_cmp_neq_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x6d,0xd0,0x01,0x05,0x02,0x60]

v_cmp_neq_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x6d,0xd0,0x01,0x05,0x02,0x00]

v_cmp_neq_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x6d,0xd0,0x01,0x05,0x02,0x00]

v_cmp_neq_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x6d,0xd0,0x01,0x05,0x02,0x00]

v_cmp_neq_f64_e64 s[10:11], v[1:2], v[2:3] clamp
// CHECK: [0x0a,0x80,0x6d,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlt_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x6e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlt_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x6e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlt_f64_e64 s[100:101], v[1:2], v[2:3]
// CHECK: [0x64,0x00,0x6e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlt_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x6e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlt_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x6e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlt_f64_e64 ttmp[14:15], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x6e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlt_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x6e,0xd0,0xfe,0x05,0x02,0x00]

v_cmp_nlt_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x6e,0xd0,0x02,0x04,0x02,0x00]

v_cmp_nlt_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x6e,0xd0,0x04,0x04,0x02,0x00]

v_cmp_nlt_f64_e64 s[10:11], s[100:101], v[2:3]
// CHECK: [0x0a,0x00,0x6e,0xd0,0x64,0x04,0x02,0x00]

v_cmp_nlt_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x6e,0xd0,0x66,0x04,0x02,0x00]

v_cmp_nlt_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x6e,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_nlt_f64_e64 s[10:11], ttmp[14:15], v[2:3]
// CHECK: [0x0a,0x00,0x6e,0xd0,0x7a,0x04,0x02,0x00]

v_cmp_nlt_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x6e,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_nlt_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x6e,0xd0,0x80,0x04,0x02,0x00]

v_cmp_nlt_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x6e,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_nlt_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x6e,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_nlt_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x6e,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_nlt_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x6e,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_nlt_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x6e,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_nlt_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x6e,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_nlt_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x6e,0xd0,0x01,0xfd,0x03,0x00]

v_cmp_nlt_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x6e,0xd0,0x01,0x09,0x00,0x00]

v_cmp_nlt_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x6e,0xd0,0x01,0x0d,0x00,0x00]

v_cmp_nlt_f64_e64 s[10:11], v[1:2], s[100:101]
// CHECK: [0x0a,0x00,0x6e,0xd0,0x01,0xc9,0x00,0x00]

v_cmp_nlt_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x6e,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_nlt_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x6e,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_nlt_f64_e64 s[10:11], v[1:2], ttmp[14:15]
// CHECK: [0x0a,0x00,0x6e,0xd0,0x01,0xf5,0x00,0x00]

v_cmp_nlt_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x6e,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_nlt_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x6e,0xd0,0x01,0x01,0x01,0x00]

v_cmp_nlt_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x6e,0xd0,0x01,0x83,0x01,0x00]

v_cmp_nlt_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x6e,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_nlt_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x6e,0xd0,0x01,0xef,0x01,0x00]

v_cmp_nlt_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x6e,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_nlt_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x6e,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_nlt_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x6e,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_nlt_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x6e,0xd0,0x01,0x05,0x02,0x20]

v_cmp_nlt_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x6e,0xd0,0x01,0x05,0x02,0x40]

v_cmp_nlt_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x6e,0xd0,0x01,0x05,0x02,0x60]

v_cmp_nlt_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x6e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlt_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x6e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlt_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x6e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_nlt_f64_e64 s[10:11], v[1:2], v[2:3] clamp
// CHECK: [0x0a,0x80,0x6e,0xd0,0x01,0x05,0x02,0x00]

v_cmp_tru_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x6f,0xd0,0x01,0x05,0x02,0x00]

v_cmp_tru_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x6f,0xd0,0x01,0x05,0x02,0x00]

v_cmp_tru_f64_e64 s[100:101], v[1:2], v[2:3]
// CHECK: [0x64,0x00,0x6f,0xd0,0x01,0x05,0x02,0x00]

v_cmp_tru_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x6f,0xd0,0x01,0x05,0x02,0x00]

v_cmp_tru_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x6f,0xd0,0x01,0x05,0x02,0x00]

v_cmp_tru_f64_e64 ttmp[14:15], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x6f,0xd0,0x01,0x05,0x02,0x00]

v_cmp_tru_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x6f,0xd0,0xfe,0x05,0x02,0x00]

v_cmp_tru_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x6f,0xd0,0x02,0x04,0x02,0x00]

v_cmp_tru_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x6f,0xd0,0x04,0x04,0x02,0x00]

v_cmp_tru_f64_e64 s[10:11], s[100:101], v[2:3]
// CHECK: [0x0a,0x00,0x6f,0xd0,0x64,0x04,0x02,0x00]

v_cmp_tru_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x6f,0xd0,0x66,0x04,0x02,0x00]

v_cmp_tru_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x6f,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_tru_f64_e64 s[10:11], ttmp[14:15], v[2:3]
// CHECK: [0x0a,0x00,0x6f,0xd0,0x7a,0x04,0x02,0x00]

v_cmp_tru_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x6f,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_tru_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x6f,0xd0,0x80,0x04,0x02,0x00]

v_cmp_tru_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x6f,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_tru_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x6f,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_tru_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x6f,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_tru_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x6f,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_tru_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x6f,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_tru_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x6f,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_tru_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x6f,0xd0,0x01,0xfd,0x03,0x00]

v_cmp_tru_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x6f,0xd0,0x01,0x09,0x00,0x00]

v_cmp_tru_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x6f,0xd0,0x01,0x0d,0x00,0x00]

v_cmp_tru_f64_e64 s[10:11], v[1:2], s[100:101]
// CHECK: [0x0a,0x00,0x6f,0xd0,0x01,0xc9,0x00,0x00]

v_cmp_tru_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x6f,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_tru_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x6f,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_tru_f64_e64 s[10:11], v[1:2], ttmp[14:15]
// CHECK: [0x0a,0x00,0x6f,0xd0,0x01,0xf5,0x00,0x00]

v_cmp_tru_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x6f,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_tru_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x6f,0xd0,0x01,0x01,0x01,0x00]

v_cmp_tru_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x6f,0xd0,0x01,0x83,0x01,0x00]

v_cmp_tru_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x6f,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_tru_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x6f,0xd0,0x01,0xef,0x01,0x00]

v_cmp_tru_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x6f,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_tru_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x6f,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_tru_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x6f,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_tru_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x6f,0xd0,0x01,0x05,0x02,0x20]

v_cmp_tru_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x6f,0xd0,0x01,0x05,0x02,0x40]

v_cmp_tru_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x6f,0xd0,0x01,0x05,0x02,0x60]

v_cmp_tru_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x6f,0xd0,0x01,0x05,0x02,0x00]

v_cmp_tru_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x6f,0xd0,0x01,0x05,0x02,0x00]

v_cmp_tru_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x6f,0xd0,0x01,0x05,0x02,0x00]

v_cmp_tru_f64_e64 s[10:11], v[1:2], v[2:3] clamp
// CHECK: [0x0a,0x80,0x6f,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x70,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x70,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_f64_e64 s[100:101], v[1:2], v[2:3]
// CHECK: [0x64,0x00,0x70,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x70,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x70,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_f64_e64 ttmp[14:15], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x70,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_f64_e64 exec, v[1:2], v[2:3]
// CHECK: [0x7e,0x00,0x70,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x70,0xd0,0xfe,0x05,0x02,0x00]

v_cmpx_f_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x70,0xd0,0x02,0x04,0x02,0x00]

v_cmpx_f_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x70,0xd0,0x04,0x04,0x02,0x00]

v_cmpx_f_f64_e64 s[10:11], s[100:101], v[2:3]
// CHECK: [0x0a,0x00,0x70,0xd0,0x64,0x04,0x02,0x00]

v_cmpx_f_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x70,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_f_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x70,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_f_f64_e64 s[10:11], ttmp[14:15], v[2:3]
// CHECK: [0x0a,0x00,0x70,0xd0,0x7a,0x04,0x02,0x00]

v_cmpx_f_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x70,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_f_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x70,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_f_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x70,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_f_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x70,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_f_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x70,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_f_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x70,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_f_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x70,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_f_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x70,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_f_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x70,0xd0,0x01,0xfd,0x03,0x00]

v_cmpx_f_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x70,0xd0,0x01,0x09,0x00,0x00]

v_cmpx_f_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x70,0xd0,0x01,0x0d,0x00,0x00]

v_cmpx_f_f64_e64 s[10:11], v[1:2], s[100:101]
// CHECK: [0x0a,0x00,0x70,0xd0,0x01,0xc9,0x00,0x00]

v_cmpx_f_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x70,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_f_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x70,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_f_f64_e64 s[10:11], v[1:2], ttmp[14:15]
// CHECK: [0x0a,0x00,0x70,0xd0,0x01,0xf5,0x00,0x00]

v_cmpx_f_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x70,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_f_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x70,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_f_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x70,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_f_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x70,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_f_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x70,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_f_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x70,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_f_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x70,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_f_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x70,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_f_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x70,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_f_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x70,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_f_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x70,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_f_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x70,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x70,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x70,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_f64_e64 s[10:11], v[1:2], v[2:3] clamp
// CHECK: [0x0a,0x80,0x70,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x71,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x71,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_f64_e64 s[100:101], v[1:2], v[2:3]
// CHECK: [0x64,0x00,0x71,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x71,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x71,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_f64_e64 ttmp[14:15], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x71,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_f64_e64 exec, v[1:2], v[2:3]
// CHECK: [0x7e,0x00,0x71,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x71,0xd0,0xfe,0x05,0x02,0x00]

v_cmpx_lt_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x71,0xd0,0x02,0x04,0x02,0x00]

v_cmpx_lt_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x71,0xd0,0x04,0x04,0x02,0x00]

v_cmpx_lt_f64_e64 s[10:11], s[100:101], v[2:3]
// CHECK: [0x0a,0x00,0x71,0xd0,0x64,0x04,0x02,0x00]

v_cmpx_lt_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x71,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_lt_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x71,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_lt_f64_e64 s[10:11], ttmp[14:15], v[2:3]
// CHECK: [0x0a,0x00,0x71,0xd0,0x7a,0x04,0x02,0x00]

v_cmpx_lt_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x71,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_lt_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x71,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_lt_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x71,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_lt_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x71,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_lt_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x71,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_lt_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x71,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_lt_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x71,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_lt_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x71,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_lt_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x71,0xd0,0x01,0xfd,0x03,0x00]

v_cmpx_lt_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x71,0xd0,0x01,0x09,0x00,0x00]

v_cmpx_lt_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x71,0xd0,0x01,0x0d,0x00,0x00]

v_cmpx_lt_f64_e64 s[10:11], v[1:2], s[100:101]
// CHECK: [0x0a,0x00,0x71,0xd0,0x01,0xc9,0x00,0x00]

v_cmpx_lt_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x71,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_lt_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x71,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_lt_f64_e64 s[10:11], v[1:2], ttmp[14:15]
// CHECK: [0x0a,0x00,0x71,0xd0,0x01,0xf5,0x00,0x00]

v_cmpx_lt_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x71,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_lt_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x71,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_lt_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x71,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_lt_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x71,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_lt_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x71,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_lt_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x71,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_lt_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x71,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_lt_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x71,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_lt_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x71,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_lt_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x71,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_lt_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x71,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_lt_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x71,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x71,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x71,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_f64_e64 s[10:11], v[1:2], v[2:3] clamp
// CHECK: [0x0a,0x80,0x71,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x72,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x72,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_f64_e64 s[100:101], v[1:2], v[2:3]
// CHECK: [0x64,0x00,0x72,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x72,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x72,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_f64_e64 ttmp[14:15], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x72,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_f64_e64 exec, v[1:2], v[2:3]
// CHECK: [0x7e,0x00,0x72,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x72,0xd0,0xfe,0x05,0x02,0x00]

v_cmpx_eq_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x72,0xd0,0x02,0x04,0x02,0x00]

v_cmpx_eq_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x72,0xd0,0x04,0x04,0x02,0x00]

v_cmpx_eq_f64_e64 s[10:11], s[100:101], v[2:3]
// CHECK: [0x0a,0x00,0x72,0xd0,0x64,0x04,0x02,0x00]

v_cmpx_eq_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x72,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_eq_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x72,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_eq_f64_e64 s[10:11], ttmp[14:15], v[2:3]
// CHECK: [0x0a,0x00,0x72,0xd0,0x7a,0x04,0x02,0x00]

v_cmpx_eq_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x72,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_eq_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x72,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_eq_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x72,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_eq_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x72,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_eq_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x72,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_eq_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x72,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_eq_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x72,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_eq_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x72,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_eq_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x72,0xd0,0x01,0xfd,0x03,0x00]

v_cmpx_eq_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x72,0xd0,0x01,0x09,0x00,0x00]

v_cmpx_eq_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x72,0xd0,0x01,0x0d,0x00,0x00]

v_cmpx_eq_f64_e64 s[10:11], v[1:2], s[100:101]
// CHECK: [0x0a,0x00,0x72,0xd0,0x01,0xc9,0x00,0x00]

v_cmpx_eq_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x72,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_eq_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x72,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_eq_f64_e64 s[10:11], v[1:2], ttmp[14:15]
// CHECK: [0x0a,0x00,0x72,0xd0,0x01,0xf5,0x00,0x00]

v_cmpx_eq_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x72,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_eq_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x72,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_eq_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x72,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_eq_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x72,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_eq_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x72,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_eq_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x72,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_eq_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x72,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_eq_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x72,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_eq_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x72,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_eq_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x72,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_eq_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x72,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_eq_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x72,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x72,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x72,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_f64_e64 s[10:11], v[1:2], v[2:3] clamp
// CHECK: [0x0a,0x80,0x72,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x73,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x73,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_f64_e64 s[100:101], v[1:2], v[2:3]
// CHECK: [0x64,0x00,0x73,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x73,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x73,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_f64_e64 ttmp[14:15], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x73,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_f64_e64 exec, v[1:2], v[2:3]
// CHECK: [0x7e,0x00,0x73,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x73,0xd0,0xfe,0x05,0x02,0x00]

v_cmpx_le_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x73,0xd0,0x02,0x04,0x02,0x00]

v_cmpx_le_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x73,0xd0,0x04,0x04,0x02,0x00]

v_cmpx_le_f64_e64 s[10:11], s[100:101], v[2:3]
// CHECK: [0x0a,0x00,0x73,0xd0,0x64,0x04,0x02,0x00]

v_cmpx_le_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x73,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_le_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x73,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_le_f64_e64 s[10:11], ttmp[14:15], v[2:3]
// CHECK: [0x0a,0x00,0x73,0xd0,0x7a,0x04,0x02,0x00]

v_cmpx_le_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x73,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_le_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x73,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_le_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x73,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_le_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x73,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_le_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x73,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_le_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x73,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_le_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x73,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_le_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x73,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_le_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x73,0xd0,0x01,0xfd,0x03,0x00]

v_cmpx_le_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x73,0xd0,0x01,0x09,0x00,0x00]

v_cmpx_le_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x73,0xd0,0x01,0x0d,0x00,0x00]

v_cmpx_le_f64_e64 s[10:11], v[1:2], s[100:101]
// CHECK: [0x0a,0x00,0x73,0xd0,0x01,0xc9,0x00,0x00]

v_cmpx_le_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x73,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_le_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x73,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_le_f64_e64 s[10:11], v[1:2], ttmp[14:15]
// CHECK: [0x0a,0x00,0x73,0xd0,0x01,0xf5,0x00,0x00]

v_cmpx_le_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x73,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_le_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x73,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_le_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x73,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_le_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x73,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_le_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x73,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_le_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x73,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_le_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x73,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_le_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x73,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_le_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x73,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_le_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x73,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_le_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x73,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_le_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x73,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x73,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x73,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_f64_e64 s[10:11], v[1:2], v[2:3] clamp
// CHECK: [0x0a,0x80,0x73,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x74,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x74,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_f64_e64 s[100:101], v[1:2], v[2:3]
// CHECK: [0x64,0x00,0x74,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x74,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x74,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_f64_e64 ttmp[14:15], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x74,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_f64_e64 exec, v[1:2], v[2:3]
// CHECK: [0x7e,0x00,0x74,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x74,0xd0,0xfe,0x05,0x02,0x00]

v_cmpx_gt_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x74,0xd0,0x02,0x04,0x02,0x00]

v_cmpx_gt_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x74,0xd0,0x04,0x04,0x02,0x00]

v_cmpx_gt_f64_e64 s[10:11], s[100:101], v[2:3]
// CHECK: [0x0a,0x00,0x74,0xd0,0x64,0x04,0x02,0x00]

v_cmpx_gt_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x74,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_gt_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x74,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_gt_f64_e64 s[10:11], ttmp[14:15], v[2:3]
// CHECK: [0x0a,0x00,0x74,0xd0,0x7a,0x04,0x02,0x00]

v_cmpx_gt_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x74,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_gt_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x74,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_gt_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x74,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_gt_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x74,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_gt_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x74,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_gt_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x74,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_gt_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x74,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_gt_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x74,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_gt_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x74,0xd0,0x01,0xfd,0x03,0x00]

v_cmpx_gt_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x74,0xd0,0x01,0x09,0x00,0x00]

v_cmpx_gt_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x74,0xd0,0x01,0x0d,0x00,0x00]

v_cmpx_gt_f64_e64 s[10:11], v[1:2], s[100:101]
// CHECK: [0x0a,0x00,0x74,0xd0,0x01,0xc9,0x00,0x00]

v_cmpx_gt_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x74,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_gt_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x74,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_gt_f64_e64 s[10:11], v[1:2], ttmp[14:15]
// CHECK: [0x0a,0x00,0x74,0xd0,0x01,0xf5,0x00,0x00]

v_cmpx_gt_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x74,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_gt_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x74,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_gt_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x74,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_gt_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x74,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_gt_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x74,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_gt_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x74,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_gt_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x74,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_gt_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x74,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_gt_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x74,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_gt_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x74,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_gt_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x74,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_gt_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x74,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x74,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x74,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_f64_e64 s[10:11], v[1:2], v[2:3] clamp
// CHECK: [0x0a,0x80,0x74,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lg_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x75,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lg_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x75,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lg_f64_e64 s[100:101], v[1:2], v[2:3]
// CHECK: [0x64,0x00,0x75,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lg_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x75,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lg_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x75,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lg_f64_e64 ttmp[14:15], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x75,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lg_f64_e64 exec, v[1:2], v[2:3]
// CHECK: [0x7e,0x00,0x75,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lg_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x75,0xd0,0xfe,0x05,0x02,0x00]

v_cmpx_lg_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x75,0xd0,0x02,0x04,0x02,0x00]

v_cmpx_lg_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x75,0xd0,0x04,0x04,0x02,0x00]

v_cmpx_lg_f64_e64 s[10:11], s[100:101], v[2:3]
// CHECK: [0x0a,0x00,0x75,0xd0,0x64,0x04,0x02,0x00]

v_cmpx_lg_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x75,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_lg_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x75,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_lg_f64_e64 s[10:11], ttmp[14:15], v[2:3]
// CHECK: [0x0a,0x00,0x75,0xd0,0x7a,0x04,0x02,0x00]

v_cmpx_lg_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x75,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_lg_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x75,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_lg_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x75,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_lg_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x75,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_lg_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x75,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_lg_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x75,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_lg_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x75,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_lg_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x75,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_lg_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x75,0xd0,0x01,0xfd,0x03,0x00]

v_cmpx_lg_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x75,0xd0,0x01,0x09,0x00,0x00]

v_cmpx_lg_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x75,0xd0,0x01,0x0d,0x00,0x00]

v_cmpx_lg_f64_e64 s[10:11], v[1:2], s[100:101]
// CHECK: [0x0a,0x00,0x75,0xd0,0x01,0xc9,0x00,0x00]

v_cmpx_lg_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x75,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_lg_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x75,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_lg_f64_e64 s[10:11], v[1:2], ttmp[14:15]
// CHECK: [0x0a,0x00,0x75,0xd0,0x01,0xf5,0x00,0x00]

v_cmpx_lg_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x75,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_lg_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x75,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_lg_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x75,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_lg_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x75,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_lg_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x75,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_lg_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x75,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_lg_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x75,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_lg_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x75,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_lg_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x75,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_lg_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x75,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_lg_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x75,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_lg_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x75,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lg_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x75,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lg_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x75,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lg_f64_e64 s[10:11], v[1:2], v[2:3] clamp
// CHECK: [0x0a,0x80,0x75,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x76,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x76,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_f64_e64 s[100:101], v[1:2], v[2:3]
// CHECK: [0x64,0x00,0x76,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x76,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x76,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_f64_e64 ttmp[14:15], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x76,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_f64_e64 exec, v[1:2], v[2:3]
// CHECK: [0x7e,0x00,0x76,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x76,0xd0,0xfe,0x05,0x02,0x00]

v_cmpx_ge_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x76,0xd0,0x02,0x04,0x02,0x00]

v_cmpx_ge_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x76,0xd0,0x04,0x04,0x02,0x00]

v_cmpx_ge_f64_e64 s[10:11], s[100:101], v[2:3]
// CHECK: [0x0a,0x00,0x76,0xd0,0x64,0x04,0x02,0x00]

v_cmpx_ge_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x76,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_ge_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x76,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_ge_f64_e64 s[10:11], ttmp[14:15], v[2:3]
// CHECK: [0x0a,0x00,0x76,0xd0,0x7a,0x04,0x02,0x00]

v_cmpx_ge_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x76,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_ge_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x76,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_ge_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x76,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_ge_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x76,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_ge_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x76,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_ge_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x76,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_ge_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x76,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_ge_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x76,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_ge_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x76,0xd0,0x01,0xfd,0x03,0x00]

v_cmpx_ge_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x76,0xd0,0x01,0x09,0x00,0x00]

v_cmpx_ge_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x76,0xd0,0x01,0x0d,0x00,0x00]

v_cmpx_ge_f64_e64 s[10:11], v[1:2], s[100:101]
// CHECK: [0x0a,0x00,0x76,0xd0,0x01,0xc9,0x00,0x00]

v_cmpx_ge_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x76,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_ge_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x76,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_ge_f64_e64 s[10:11], v[1:2], ttmp[14:15]
// CHECK: [0x0a,0x00,0x76,0xd0,0x01,0xf5,0x00,0x00]

v_cmpx_ge_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x76,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_ge_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x76,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_ge_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x76,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_ge_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x76,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_ge_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x76,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_ge_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x76,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_ge_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x76,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_ge_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x76,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_ge_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x76,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_ge_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x76,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_ge_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x76,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_ge_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x76,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x76,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x76,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_f64_e64 s[10:11], v[1:2], v[2:3] clamp
// CHECK: [0x0a,0x80,0x76,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_o_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x77,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_o_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x77,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_o_f64_e64 s[100:101], v[1:2], v[2:3]
// CHECK: [0x64,0x00,0x77,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_o_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x77,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_o_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x77,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_o_f64_e64 ttmp[14:15], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x77,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_o_f64_e64 exec, v[1:2], v[2:3]
// CHECK: [0x7e,0x00,0x77,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_o_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x77,0xd0,0xfe,0x05,0x02,0x00]

v_cmpx_o_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x77,0xd0,0x02,0x04,0x02,0x00]

v_cmpx_o_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x77,0xd0,0x04,0x04,0x02,0x00]

v_cmpx_o_f64_e64 s[10:11], s[100:101], v[2:3]
// CHECK: [0x0a,0x00,0x77,0xd0,0x64,0x04,0x02,0x00]

v_cmpx_o_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x77,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_o_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x77,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_o_f64_e64 s[10:11], ttmp[14:15], v[2:3]
// CHECK: [0x0a,0x00,0x77,0xd0,0x7a,0x04,0x02,0x00]

v_cmpx_o_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x77,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_o_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x77,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_o_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x77,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_o_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x77,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_o_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x77,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_o_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x77,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_o_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x77,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_o_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x77,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_o_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x77,0xd0,0x01,0xfd,0x03,0x00]

v_cmpx_o_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x77,0xd0,0x01,0x09,0x00,0x00]

v_cmpx_o_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x77,0xd0,0x01,0x0d,0x00,0x00]

v_cmpx_o_f64_e64 s[10:11], v[1:2], s[100:101]
// CHECK: [0x0a,0x00,0x77,0xd0,0x01,0xc9,0x00,0x00]

v_cmpx_o_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x77,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_o_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x77,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_o_f64_e64 s[10:11], v[1:2], ttmp[14:15]
// CHECK: [0x0a,0x00,0x77,0xd0,0x01,0xf5,0x00,0x00]

v_cmpx_o_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x77,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_o_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x77,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_o_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x77,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_o_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x77,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_o_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x77,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_o_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x77,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_o_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x77,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_o_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x77,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_o_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x77,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_o_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x77,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_o_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x77,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_o_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x77,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_o_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x77,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_o_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x77,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_o_f64_e64 s[10:11], v[1:2], v[2:3] clamp
// CHECK: [0x0a,0x80,0x77,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_u_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x78,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_u_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x78,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_u_f64_e64 s[100:101], v[1:2], v[2:3]
// CHECK: [0x64,0x00,0x78,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_u_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x78,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_u_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x78,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_u_f64_e64 ttmp[14:15], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x78,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_u_f64_e64 exec, v[1:2], v[2:3]
// CHECK: [0x7e,0x00,0x78,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_u_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x78,0xd0,0xfe,0x05,0x02,0x00]

v_cmpx_u_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x78,0xd0,0x02,0x04,0x02,0x00]

v_cmpx_u_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x78,0xd0,0x04,0x04,0x02,0x00]

v_cmpx_u_f64_e64 s[10:11], s[100:101], v[2:3]
// CHECK: [0x0a,0x00,0x78,0xd0,0x64,0x04,0x02,0x00]

v_cmpx_u_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x78,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_u_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x78,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_u_f64_e64 s[10:11], ttmp[14:15], v[2:3]
// CHECK: [0x0a,0x00,0x78,0xd0,0x7a,0x04,0x02,0x00]

v_cmpx_u_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x78,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_u_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x78,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_u_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x78,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_u_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x78,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_u_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x78,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_u_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x78,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_u_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x78,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_u_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x78,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_u_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x78,0xd0,0x01,0xfd,0x03,0x00]

v_cmpx_u_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x78,0xd0,0x01,0x09,0x00,0x00]

v_cmpx_u_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x78,0xd0,0x01,0x0d,0x00,0x00]

v_cmpx_u_f64_e64 s[10:11], v[1:2], s[100:101]
// CHECK: [0x0a,0x00,0x78,0xd0,0x01,0xc9,0x00,0x00]

v_cmpx_u_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x78,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_u_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x78,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_u_f64_e64 s[10:11], v[1:2], ttmp[14:15]
// CHECK: [0x0a,0x00,0x78,0xd0,0x01,0xf5,0x00,0x00]

v_cmpx_u_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x78,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_u_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x78,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_u_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x78,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_u_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x78,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_u_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x78,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_u_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x78,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_u_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x78,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_u_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x78,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_u_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x78,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_u_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x78,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_u_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x78,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_u_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x78,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_u_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x78,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_u_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x78,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_u_f64_e64 s[10:11], v[1:2], v[2:3] clamp
// CHECK: [0x0a,0x80,0x78,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nge_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x79,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nge_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x79,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nge_f64_e64 s[100:101], v[1:2], v[2:3]
// CHECK: [0x64,0x00,0x79,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nge_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x79,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nge_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x79,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nge_f64_e64 ttmp[14:15], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x79,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nge_f64_e64 exec, v[1:2], v[2:3]
// CHECK: [0x7e,0x00,0x79,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nge_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x79,0xd0,0xfe,0x05,0x02,0x00]

v_cmpx_nge_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x79,0xd0,0x02,0x04,0x02,0x00]

v_cmpx_nge_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x79,0xd0,0x04,0x04,0x02,0x00]

v_cmpx_nge_f64_e64 s[10:11], s[100:101], v[2:3]
// CHECK: [0x0a,0x00,0x79,0xd0,0x64,0x04,0x02,0x00]

v_cmpx_nge_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x79,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_nge_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x79,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_nge_f64_e64 s[10:11], ttmp[14:15], v[2:3]
// CHECK: [0x0a,0x00,0x79,0xd0,0x7a,0x04,0x02,0x00]

v_cmpx_nge_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x79,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_nge_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x79,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_nge_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x79,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_nge_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x79,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_nge_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x79,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_nge_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x79,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_nge_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x79,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_nge_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x79,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_nge_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x79,0xd0,0x01,0xfd,0x03,0x00]

v_cmpx_nge_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x79,0xd0,0x01,0x09,0x00,0x00]

v_cmpx_nge_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x79,0xd0,0x01,0x0d,0x00,0x00]

v_cmpx_nge_f64_e64 s[10:11], v[1:2], s[100:101]
// CHECK: [0x0a,0x00,0x79,0xd0,0x01,0xc9,0x00,0x00]

v_cmpx_nge_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x79,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_nge_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x79,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_nge_f64_e64 s[10:11], v[1:2], ttmp[14:15]
// CHECK: [0x0a,0x00,0x79,0xd0,0x01,0xf5,0x00,0x00]

v_cmpx_nge_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x79,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_nge_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x79,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_nge_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x79,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_nge_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x79,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_nge_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x79,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_nge_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x79,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_nge_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x79,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_nge_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x79,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_nge_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x79,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_nge_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x79,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_nge_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x79,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_nge_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x79,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nge_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x79,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nge_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x79,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nge_f64_e64 s[10:11], v[1:2], v[2:3] clamp
// CHECK: [0x0a,0x80,0x79,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlg_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x7a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlg_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x7a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlg_f64_e64 s[100:101], v[1:2], v[2:3]
// CHECK: [0x64,0x00,0x7a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlg_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x7a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlg_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x7a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlg_f64_e64 ttmp[14:15], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x7a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlg_f64_e64 exec, v[1:2], v[2:3]
// CHECK: [0x7e,0x00,0x7a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlg_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x7a,0xd0,0xfe,0x05,0x02,0x00]

v_cmpx_nlg_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x7a,0xd0,0x02,0x04,0x02,0x00]

v_cmpx_nlg_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x7a,0xd0,0x04,0x04,0x02,0x00]

v_cmpx_nlg_f64_e64 s[10:11], s[100:101], v[2:3]
// CHECK: [0x0a,0x00,0x7a,0xd0,0x64,0x04,0x02,0x00]

v_cmpx_nlg_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x7a,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_nlg_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x7a,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_nlg_f64_e64 s[10:11], ttmp[14:15], v[2:3]
// CHECK: [0x0a,0x00,0x7a,0xd0,0x7a,0x04,0x02,0x00]

v_cmpx_nlg_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x7a,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_nlg_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x7a,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_nlg_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x7a,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_nlg_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x7a,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_nlg_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x7a,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_nlg_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x7a,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_nlg_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x7a,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_nlg_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x7a,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_nlg_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x7a,0xd0,0x01,0xfd,0x03,0x00]

v_cmpx_nlg_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x7a,0xd0,0x01,0x09,0x00,0x00]

v_cmpx_nlg_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x7a,0xd0,0x01,0x0d,0x00,0x00]

v_cmpx_nlg_f64_e64 s[10:11], v[1:2], s[100:101]
// CHECK: [0x0a,0x00,0x7a,0xd0,0x01,0xc9,0x00,0x00]

v_cmpx_nlg_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x7a,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_nlg_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x7a,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_nlg_f64_e64 s[10:11], v[1:2], ttmp[14:15]
// CHECK: [0x0a,0x00,0x7a,0xd0,0x01,0xf5,0x00,0x00]

v_cmpx_nlg_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x7a,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_nlg_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x7a,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_nlg_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x7a,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_nlg_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x7a,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_nlg_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x7a,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_nlg_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x7a,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_nlg_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x7a,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_nlg_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x7a,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_nlg_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x7a,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_nlg_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x7a,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_nlg_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x7a,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_nlg_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x7a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlg_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x7a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlg_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x7a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlg_f64_e64 s[10:11], v[1:2], v[2:3] clamp
// CHECK: [0x0a,0x80,0x7a,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ngt_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x7b,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ngt_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x7b,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ngt_f64_e64 s[100:101], v[1:2], v[2:3]
// CHECK: [0x64,0x00,0x7b,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ngt_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x7b,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ngt_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x7b,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ngt_f64_e64 ttmp[14:15], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x7b,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ngt_f64_e64 exec, v[1:2], v[2:3]
// CHECK: [0x7e,0x00,0x7b,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ngt_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x7b,0xd0,0xfe,0x05,0x02,0x00]

v_cmpx_ngt_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x7b,0xd0,0x02,0x04,0x02,0x00]

v_cmpx_ngt_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x7b,0xd0,0x04,0x04,0x02,0x00]

v_cmpx_ngt_f64_e64 s[10:11], s[100:101], v[2:3]
// CHECK: [0x0a,0x00,0x7b,0xd0,0x64,0x04,0x02,0x00]

v_cmpx_ngt_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x7b,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_ngt_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x7b,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_ngt_f64_e64 s[10:11], ttmp[14:15], v[2:3]
// CHECK: [0x0a,0x00,0x7b,0xd0,0x7a,0x04,0x02,0x00]

v_cmpx_ngt_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x7b,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_ngt_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x7b,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_ngt_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x7b,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_ngt_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x7b,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_ngt_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x7b,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_ngt_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x7b,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_ngt_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x7b,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_ngt_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x7b,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_ngt_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x7b,0xd0,0x01,0xfd,0x03,0x00]

v_cmpx_ngt_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x7b,0xd0,0x01,0x09,0x00,0x00]

v_cmpx_ngt_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x7b,0xd0,0x01,0x0d,0x00,0x00]

v_cmpx_ngt_f64_e64 s[10:11], v[1:2], s[100:101]
// CHECK: [0x0a,0x00,0x7b,0xd0,0x01,0xc9,0x00,0x00]

v_cmpx_ngt_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x7b,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_ngt_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x7b,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_ngt_f64_e64 s[10:11], v[1:2], ttmp[14:15]
// CHECK: [0x0a,0x00,0x7b,0xd0,0x01,0xf5,0x00,0x00]

v_cmpx_ngt_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x7b,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_ngt_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x7b,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_ngt_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x7b,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_ngt_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x7b,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_ngt_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x7b,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_ngt_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x7b,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_ngt_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x7b,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_ngt_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x7b,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_ngt_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x7b,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_ngt_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x7b,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_ngt_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x7b,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_ngt_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x7b,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ngt_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x7b,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ngt_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x7b,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ngt_f64_e64 s[10:11], v[1:2], v[2:3] clamp
// CHECK: [0x0a,0x80,0x7b,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nle_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x7c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nle_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x7c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nle_f64_e64 s[100:101], v[1:2], v[2:3]
// CHECK: [0x64,0x00,0x7c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nle_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x7c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nle_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x7c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nle_f64_e64 ttmp[14:15], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x7c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nle_f64_e64 exec, v[1:2], v[2:3]
// CHECK: [0x7e,0x00,0x7c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nle_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x7c,0xd0,0xfe,0x05,0x02,0x00]

v_cmpx_nle_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x7c,0xd0,0x02,0x04,0x02,0x00]

v_cmpx_nle_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x7c,0xd0,0x04,0x04,0x02,0x00]

v_cmpx_nle_f64_e64 s[10:11], s[100:101], v[2:3]
// CHECK: [0x0a,0x00,0x7c,0xd0,0x64,0x04,0x02,0x00]

v_cmpx_nle_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x7c,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_nle_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x7c,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_nle_f64_e64 s[10:11], ttmp[14:15], v[2:3]
// CHECK: [0x0a,0x00,0x7c,0xd0,0x7a,0x04,0x02,0x00]

v_cmpx_nle_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x7c,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_nle_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x7c,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_nle_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x7c,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_nle_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x7c,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_nle_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x7c,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_nle_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x7c,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_nle_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x7c,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_nle_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x7c,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_nle_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x7c,0xd0,0x01,0xfd,0x03,0x00]

v_cmpx_nle_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x7c,0xd0,0x01,0x09,0x00,0x00]

v_cmpx_nle_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x7c,0xd0,0x01,0x0d,0x00,0x00]

v_cmpx_nle_f64_e64 s[10:11], v[1:2], s[100:101]
// CHECK: [0x0a,0x00,0x7c,0xd0,0x01,0xc9,0x00,0x00]

v_cmpx_nle_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x7c,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_nle_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x7c,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_nle_f64_e64 s[10:11], v[1:2], ttmp[14:15]
// CHECK: [0x0a,0x00,0x7c,0xd0,0x01,0xf5,0x00,0x00]

v_cmpx_nle_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x7c,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_nle_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x7c,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_nle_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x7c,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_nle_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x7c,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_nle_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x7c,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_nle_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x7c,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_nle_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x7c,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_nle_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x7c,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_nle_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x7c,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_nle_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x7c,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_nle_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x7c,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_nle_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x7c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nle_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x7c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nle_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x7c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nle_f64_e64 s[10:11], v[1:2], v[2:3] clamp
// CHECK: [0x0a,0x80,0x7c,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_neq_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x7d,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_neq_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x7d,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_neq_f64_e64 s[100:101], v[1:2], v[2:3]
// CHECK: [0x64,0x00,0x7d,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_neq_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x7d,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_neq_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x7d,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_neq_f64_e64 ttmp[14:15], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x7d,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_neq_f64_e64 exec, v[1:2], v[2:3]
// CHECK: [0x7e,0x00,0x7d,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_neq_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x7d,0xd0,0xfe,0x05,0x02,0x00]

v_cmpx_neq_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x7d,0xd0,0x02,0x04,0x02,0x00]

v_cmpx_neq_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x7d,0xd0,0x04,0x04,0x02,0x00]

v_cmpx_neq_f64_e64 s[10:11], s[100:101], v[2:3]
// CHECK: [0x0a,0x00,0x7d,0xd0,0x64,0x04,0x02,0x00]

v_cmpx_neq_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x7d,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_neq_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x7d,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_neq_f64_e64 s[10:11], ttmp[14:15], v[2:3]
// CHECK: [0x0a,0x00,0x7d,0xd0,0x7a,0x04,0x02,0x00]

v_cmpx_neq_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x7d,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_neq_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x7d,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_neq_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x7d,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_neq_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x7d,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_neq_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x7d,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_neq_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x7d,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_neq_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x7d,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_neq_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x7d,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_neq_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x7d,0xd0,0x01,0xfd,0x03,0x00]

v_cmpx_neq_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x7d,0xd0,0x01,0x09,0x00,0x00]

v_cmpx_neq_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x7d,0xd0,0x01,0x0d,0x00,0x00]

v_cmpx_neq_f64_e64 s[10:11], v[1:2], s[100:101]
// CHECK: [0x0a,0x00,0x7d,0xd0,0x01,0xc9,0x00,0x00]

v_cmpx_neq_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x7d,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_neq_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x7d,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_neq_f64_e64 s[10:11], v[1:2], ttmp[14:15]
// CHECK: [0x0a,0x00,0x7d,0xd0,0x01,0xf5,0x00,0x00]

v_cmpx_neq_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x7d,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_neq_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x7d,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_neq_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x7d,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_neq_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x7d,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_neq_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x7d,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_neq_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x7d,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_neq_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x7d,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_neq_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x7d,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_neq_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x7d,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_neq_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x7d,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_neq_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x7d,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_neq_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x7d,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_neq_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x7d,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_neq_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x7d,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_neq_f64_e64 s[10:11], v[1:2], v[2:3] clamp
// CHECK: [0x0a,0x80,0x7d,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlt_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x7e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlt_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x7e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlt_f64_e64 s[100:101], v[1:2], v[2:3]
// CHECK: [0x64,0x00,0x7e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlt_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x7e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlt_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x7e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlt_f64_e64 ttmp[14:15], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x7e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlt_f64_e64 exec, v[1:2], v[2:3]
// CHECK: [0x7e,0x00,0x7e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlt_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x7e,0xd0,0xfe,0x05,0x02,0x00]

v_cmpx_nlt_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x7e,0xd0,0x02,0x04,0x02,0x00]

v_cmpx_nlt_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x7e,0xd0,0x04,0x04,0x02,0x00]

v_cmpx_nlt_f64_e64 s[10:11], s[100:101], v[2:3]
// CHECK: [0x0a,0x00,0x7e,0xd0,0x64,0x04,0x02,0x00]

v_cmpx_nlt_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x7e,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_nlt_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x7e,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_nlt_f64_e64 s[10:11], ttmp[14:15], v[2:3]
// CHECK: [0x0a,0x00,0x7e,0xd0,0x7a,0x04,0x02,0x00]

v_cmpx_nlt_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x7e,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_nlt_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x7e,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_nlt_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x7e,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_nlt_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x7e,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_nlt_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x7e,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_nlt_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x7e,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_nlt_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x7e,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_nlt_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x7e,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_nlt_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x7e,0xd0,0x01,0xfd,0x03,0x00]

v_cmpx_nlt_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x7e,0xd0,0x01,0x09,0x00,0x00]

v_cmpx_nlt_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x7e,0xd0,0x01,0x0d,0x00,0x00]

v_cmpx_nlt_f64_e64 s[10:11], v[1:2], s[100:101]
// CHECK: [0x0a,0x00,0x7e,0xd0,0x01,0xc9,0x00,0x00]

v_cmpx_nlt_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x7e,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_nlt_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x7e,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_nlt_f64_e64 s[10:11], v[1:2], ttmp[14:15]
// CHECK: [0x0a,0x00,0x7e,0xd0,0x01,0xf5,0x00,0x00]

v_cmpx_nlt_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x7e,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_nlt_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x7e,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_nlt_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x7e,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_nlt_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x7e,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_nlt_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x7e,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_nlt_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x7e,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_nlt_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x7e,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_nlt_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x7e,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_nlt_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x7e,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_nlt_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x7e,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_nlt_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x7e,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_nlt_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x7e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlt_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x7e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlt_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x7e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_nlt_f64_e64 s[10:11], v[1:2], v[2:3] clamp
// CHECK: [0x0a,0x80,0x7e,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_tru_f64_e64 s[10:11], v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x7f,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_tru_f64_e64 s[12:13], v[1:2], v[2:3]
// CHECK: [0x0c,0x00,0x7f,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_tru_f64_e64 s[100:101], v[1:2], v[2:3]
// CHECK: [0x64,0x00,0x7f,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_tru_f64_e64 flat_scratch, v[1:2], v[2:3]
// CHECK: [0x66,0x00,0x7f,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_tru_f64_e64 vcc, v[1:2], v[2:3]
// CHECK: [0x6a,0x00,0x7f,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_tru_f64_e64 ttmp[14:15], v[1:2], v[2:3]
// CHECK: [0x7a,0x00,0x7f,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_tru_f64_e64 exec, v[1:2], v[2:3]
// CHECK: [0x7e,0x00,0x7f,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_tru_f64_e64 s[10:11], v[254:255], v[2:3]
// CHECK: [0x0a,0x00,0x7f,0xd0,0xfe,0x05,0x02,0x00]

v_cmpx_tru_f64_e64 s[10:11], s[2:3], v[2:3]
// CHECK: [0x0a,0x00,0x7f,0xd0,0x02,0x04,0x02,0x00]

v_cmpx_tru_f64_e64 s[10:11], s[4:5], v[2:3]
// CHECK: [0x0a,0x00,0x7f,0xd0,0x04,0x04,0x02,0x00]

v_cmpx_tru_f64_e64 s[10:11], s[100:101], v[2:3]
// CHECK: [0x0a,0x00,0x7f,0xd0,0x64,0x04,0x02,0x00]

v_cmpx_tru_f64_e64 s[10:11], flat_scratch, v[2:3]
// CHECK: [0x0a,0x00,0x7f,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_tru_f64_e64 s[10:11], vcc, v[2:3]
// CHECK: [0x0a,0x00,0x7f,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_tru_f64_e64 s[10:11], ttmp[14:15], v[2:3]
// CHECK: [0x0a,0x00,0x7f,0xd0,0x7a,0x04,0x02,0x00]

v_cmpx_tru_f64_e64 s[10:11], exec, v[2:3]
// CHECK: [0x0a,0x00,0x7f,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_tru_f64_e64 s[10:11], 0, v[2:3]
// CHECK: [0x0a,0x00,0x7f,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_tru_f64_e64 s[10:11], -1, v[2:3]
// CHECK: [0x0a,0x00,0x7f,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_tru_f64_e64 s[10:11], 0.5, v[2:3]
// CHECK: [0x0a,0x00,0x7f,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_tru_f64_e64 s[10:11], -4.0, v[2:3]
// CHECK: [0x0a,0x00,0x7f,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_tru_f64_e64 s[10:11], src_vccz, v[2:3]
// CHECK: [0x0a,0x00,0x7f,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_tru_f64_e64 s[10:11], src_execz, v[2:3]
// CHECK: [0x0a,0x00,0x7f,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_tru_f64_e64 s[10:11], src_scc, v[2:3]
// CHECK: [0x0a,0x00,0x7f,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_tru_f64_e64 s[10:11], v[1:2], v[254:255]
// CHECK: [0x0a,0x00,0x7f,0xd0,0x01,0xfd,0x03,0x00]

v_cmpx_tru_f64_e64 s[10:11], v[1:2], s[4:5]
// CHECK: [0x0a,0x00,0x7f,0xd0,0x01,0x09,0x00,0x00]

v_cmpx_tru_f64_e64 s[10:11], v[1:2], s[6:7]
// CHECK: [0x0a,0x00,0x7f,0xd0,0x01,0x0d,0x00,0x00]

v_cmpx_tru_f64_e64 s[10:11], v[1:2], s[100:101]
// CHECK: [0x0a,0x00,0x7f,0xd0,0x01,0xc9,0x00,0x00]

v_cmpx_tru_f64_e64 s[10:11], v[1:2], flat_scratch
// CHECK: [0x0a,0x00,0x7f,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_tru_f64_e64 s[10:11], v[1:2], vcc
// CHECK: [0x0a,0x00,0x7f,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_tru_f64_e64 s[10:11], v[1:2], ttmp[14:15]
// CHECK: [0x0a,0x00,0x7f,0xd0,0x01,0xf5,0x00,0x00]

v_cmpx_tru_f64_e64 s[10:11], v[1:2], exec
// CHECK: [0x0a,0x00,0x7f,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_tru_f64_e64 s[10:11], v[1:2], 0
// CHECK: [0x0a,0x00,0x7f,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_tru_f64_e64 s[10:11], v[1:2], -1
// CHECK: [0x0a,0x00,0x7f,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_tru_f64_e64 s[10:11], v[1:2], 0.5
// CHECK: [0x0a,0x00,0x7f,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_tru_f64_e64 s[10:11], v[1:2], -4.0
// CHECK: [0x0a,0x00,0x7f,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_tru_f64_e64 s[10:11], v[1:2], src_vccz
// CHECK: [0x0a,0x00,0x7f,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_tru_f64_e64 s[10:11], v[1:2], src_execz
// CHECK: [0x0a,0x00,0x7f,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_tru_f64_e64 s[10:11], v[1:2], src_scc
// CHECK: [0x0a,0x00,0x7f,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_tru_f64_e64 s[10:11], -v[1:2], v[2:3]
// CHECK: [0x0a,0x00,0x7f,0xd0,0x01,0x05,0x02,0x20]

v_cmpx_tru_f64_e64 s[10:11], v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x7f,0xd0,0x01,0x05,0x02,0x40]

v_cmpx_tru_f64_e64 s[10:11], -v[1:2], -v[2:3]
// CHECK: [0x0a,0x00,0x7f,0xd0,0x01,0x05,0x02,0x60]

v_cmpx_tru_f64_e64 s[10:11], |v[1:2]|, v[2:3]
// CHECK: [0x0a,0x01,0x7f,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_tru_f64_e64 s[10:11], v[1:2], |v[2:3]|
// CHECK: [0x0a,0x02,0x7f,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_tru_f64_e64 s[10:11], |v[1:2]|, |v[2:3]|
// CHECK: [0x0a,0x03,0x7f,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_tru_f64_e64 s[10:11], v[1:2], v[2:3] clamp
// CHECK: [0x0a,0x80,0x7f,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_i16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xa0,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_i16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xa0,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_i16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0xa0,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_i16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0xa0,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_i16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xa0,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_i16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0xa0,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_i16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xa0,0xd0,0xff,0x05,0x02,0x00]

v_cmp_f_i16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xa0,0xd0,0x01,0x04,0x02,0x00]

v_cmp_f_i16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0xa0,0xd0,0x65,0x04,0x02,0x00]

v_cmp_f_i16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xa0,0xd0,0x66,0x04,0x02,0x00]

v_cmp_f_i16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xa0,0xd0,0x67,0x04,0x02,0x00]

v_cmp_f_i16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xa0,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_f_i16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xa0,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_f_i16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0xa0,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_f_i16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xa0,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_f_i16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xa0,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_f_i16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xa0,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_f_i16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xa0,0xd0,0x80,0x04,0x02,0x00]

v_cmp_f_i16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xa0,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_f_i16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xa0,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_f_i16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xa0,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_f_i16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xa0,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_f_i16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xa0,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_f_i16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xa0,0xd0,0x01,0xff,0x03,0x00]

v_cmp_f_i16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xa0,0xd0,0x01,0x05,0x00,0x00]

v_cmp_f_i16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0xa0,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_f_i16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xa0,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_f_i16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xa0,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_f_i16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xa0,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_f_i16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xa0,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_f_i16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0xa0,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_f_i16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xa0,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_f_i16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xa0,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_f_i16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xa0,0xd0,0x01,0xff,0x00,0x00]

v_cmp_f_i16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xa0,0xd0,0x01,0x01,0x01,0x00]

v_cmp_f_i16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xa0,0xd0,0x01,0x83,0x01,0x00]

v_cmp_f_i16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xa0,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_f_i16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xa0,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_f_i16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xa0,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_lt_i16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xa1,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_i16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xa1,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_i16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0xa1,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_i16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0xa1,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_i16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xa1,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_i16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0xa1,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_i16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xa1,0xd0,0xff,0x05,0x02,0x00]

v_cmp_lt_i16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xa1,0xd0,0x01,0x04,0x02,0x00]

v_cmp_lt_i16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0xa1,0xd0,0x65,0x04,0x02,0x00]

v_cmp_lt_i16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xa1,0xd0,0x66,0x04,0x02,0x00]

v_cmp_lt_i16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xa1,0xd0,0x67,0x04,0x02,0x00]

v_cmp_lt_i16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xa1,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_lt_i16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xa1,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_lt_i16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0xa1,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_lt_i16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xa1,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_lt_i16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xa1,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_lt_i16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xa1,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_lt_i16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xa1,0xd0,0x80,0x04,0x02,0x00]

v_cmp_lt_i16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xa1,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_lt_i16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xa1,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_lt_i16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xa1,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_lt_i16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xa1,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_lt_i16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xa1,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_lt_i16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xa1,0xd0,0x01,0xff,0x03,0x00]

v_cmp_lt_i16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xa1,0xd0,0x01,0x05,0x00,0x00]

v_cmp_lt_i16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0xa1,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_lt_i16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xa1,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_lt_i16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xa1,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_lt_i16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xa1,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_lt_i16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xa1,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_lt_i16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0xa1,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_lt_i16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xa1,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_lt_i16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xa1,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_lt_i16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xa1,0xd0,0x01,0xff,0x00,0x00]

v_cmp_lt_i16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xa1,0xd0,0x01,0x01,0x01,0x00]

v_cmp_lt_i16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xa1,0xd0,0x01,0x83,0x01,0x00]

v_cmp_lt_i16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xa1,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_lt_i16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xa1,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_lt_i16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xa1,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_eq_i16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xa2,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_i16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xa2,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_i16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0xa2,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_i16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0xa2,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_i16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xa2,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_i16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0xa2,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_i16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xa2,0xd0,0xff,0x05,0x02,0x00]

v_cmp_eq_i16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xa2,0xd0,0x01,0x04,0x02,0x00]

v_cmp_eq_i16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0xa2,0xd0,0x65,0x04,0x02,0x00]

v_cmp_eq_i16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xa2,0xd0,0x66,0x04,0x02,0x00]

v_cmp_eq_i16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xa2,0xd0,0x67,0x04,0x02,0x00]

v_cmp_eq_i16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xa2,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_eq_i16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xa2,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_eq_i16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0xa2,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_eq_i16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xa2,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_eq_i16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xa2,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_eq_i16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xa2,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_eq_i16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xa2,0xd0,0x80,0x04,0x02,0x00]

v_cmp_eq_i16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xa2,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_eq_i16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xa2,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_eq_i16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xa2,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_eq_i16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xa2,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_eq_i16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xa2,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_eq_i16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xa2,0xd0,0x01,0xff,0x03,0x00]

v_cmp_eq_i16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xa2,0xd0,0x01,0x05,0x00,0x00]

v_cmp_eq_i16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0xa2,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_eq_i16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xa2,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_eq_i16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xa2,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_eq_i16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xa2,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_eq_i16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xa2,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_eq_i16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0xa2,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_eq_i16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xa2,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_eq_i16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xa2,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_eq_i16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xa2,0xd0,0x01,0xff,0x00,0x00]

v_cmp_eq_i16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xa2,0xd0,0x01,0x01,0x01,0x00]

v_cmp_eq_i16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xa2,0xd0,0x01,0x83,0x01,0x00]

v_cmp_eq_i16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xa2,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_eq_i16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xa2,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_eq_i16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xa2,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_le_i16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xa3,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_i16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xa3,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_i16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0xa3,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_i16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0xa3,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_i16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xa3,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_i16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0xa3,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_i16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xa3,0xd0,0xff,0x05,0x02,0x00]

v_cmp_le_i16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xa3,0xd0,0x01,0x04,0x02,0x00]

v_cmp_le_i16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0xa3,0xd0,0x65,0x04,0x02,0x00]

v_cmp_le_i16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xa3,0xd0,0x66,0x04,0x02,0x00]

v_cmp_le_i16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xa3,0xd0,0x67,0x04,0x02,0x00]

v_cmp_le_i16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xa3,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_le_i16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xa3,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_le_i16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0xa3,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_le_i16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xa3,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_le_i16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xa3,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_le_i16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xa3,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_le_i16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xa3,0xd0,0x80,0x04,0x02,0x00]

v_cmp_le_i16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xa3,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_le_i16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xa3,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_le_i16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xa3,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_le_i16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xa3,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_le_i16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xa3,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_le_i16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xa3,0xd0,0x01,0xff,0x03,0x00]

v_cmp_le_i16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xa3,0xd0,0x01,0x05,0x00,0x00]

v_cmp_le_i16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0xa3,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_le_i16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xa3,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_le_i16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xa3,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_le_i16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xa3,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_le_i16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xa3,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_le_i16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0xa3,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_le_i16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xa3,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_le_i16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xa3,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_le_i16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xa3,0xd0,0x01,0xff,0x00,0x00]

v_cmp_le_i16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xa3,0xd0,0x01,0x01,0x01,0x00]

v_cmp_le_i16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xa3,0xd0,0x01,0x83,0x01,0x00]

v_cmp_le_i16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xa3,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_le_i16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xa3,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_le_i16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xa3,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_gt_i16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xa4,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_i16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xa4,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_i16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0xa4,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_i16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0xa4,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_i16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xa4,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_i16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0xa4,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_i16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xa4,0xd0,0xff,0x05,0x02,0x00]

v_cmp_gt_i16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xa4,0xd0,0x01,0x04,0x02,0x00]

v_cmp_gt_i16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0xa4,0xd0,0x65,0x04,0x02,0x00]

v_cmp_gt_i16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xa4,0xd0,0x66,0x04,0x02,0x00]

v_cmp_gt_i16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xa4,0xd0,0x67,0x04,0x02,0x00]

v_cmp_gt_i16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xa4,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_gt_i16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xa4,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_gt_i16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0xa4,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_gt_i16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xa4,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_gt_i16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xa4,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_gt_i16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xa4,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_gt_i16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xa4,0xd0,0x80,0x04,0x02,0x00]

v_cmp_gt_i16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xa4,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_gt_i16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xa4,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_gt_i16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xa4,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_gt_i16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xa4,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_gt_i16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xa4,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_gt_i16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xa4,0xd0,0x01,0xff,0x03,0x00]

v_cmp_gt_i16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xa4,0xd0,0x01,0x05,0x00,0x00]

v_cmp_gt_i16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0xa4,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_gt_i16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xa4,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_gt_i16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xa4,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_gt_i16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xa4,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_gt_i16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xa4,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_gt_i16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0xa4,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_gt_i16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xa4,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_gt_i16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xa4,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_gt_i16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xa4,0xd0,0x01,0xff,0x00,0x00]

v_cmp_gt_i16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xa4,0xd0,0x01,0x01,0x01,0x00]

v_cmp_gt_i16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xa4,0xd0,0x01,0x83,0x01,0x00]

v_cmp_gt_i16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xa4,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_gt_i16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xa4,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_gt_i16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xa4,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_ne_i16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xa5,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ne_i16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xa5,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ne_i16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0xa5,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ne_i16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0xa5,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ne_i16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xa5,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ne_i16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0xa5,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ne_i16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xa5,0xd0,0xff,0x05,0x02,0x00]

v_cmp_ne_i16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xa5,0xd0,0x01,0x04,0x02,0x00]

v_cmp_ne_i16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0xa5,0xd0,0x65,0x04,0x02,0x00]

v_cmp_ne_i16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xa5,0xd0,0x66,0x04,0x02,0x00]

v_cmp_ne_i16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xa5,0xd0,0x67,0x04,0x02,0x00]

v_cmp_ne_i16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xa5,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_ne_i16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xa5,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_ne_i16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0xa5,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_ne_i16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xa5,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_ne_i16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xa5,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_ne_i16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xa5,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_ne_i16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xa5,0xd0,0x80,0x04,0x02,0x00]

v_cmp_ne_i16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xa5,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_ne_i16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xa5,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_ne_i16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xa5,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_ne_i16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xa5,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_ne_i16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xa5,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_ne_i16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xa5,0xd0,0x01,0xff,0x03,0x00]

v_cmp_ne_i16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xa5,0xd0,0x01,0x05,0x00,0x00]

v_cmp_ne_i16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0xa5,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_ne_i16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xa5,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_ne_i16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xa5,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_ne_i16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xa5,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_ne_i16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xa5,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_ne_i16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0xa5,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_ne_i16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xa5,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_ne_i16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xa5,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_ne_i16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xa5,0xd0,0x01,0xff,0x00,0x00]

v_cmp_ne_i16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xa5,0xd0,0x01,0x01,0x01,0x00]

v_cmp_ne_i16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xa5,0xd0,0x01,0x83,0x01,0x00]

v_cmp_ne_i16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xa5,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_ne_i16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xa5,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_ne_i16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xa5,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_ge_i16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xa6,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_i16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xa6,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_i16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0xa6,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_i16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0xa6,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_i16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xa6,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_i16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0xa6,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_i16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xa6,0xd0,0xff,0x05,0x02,0x00]

v_cmp_ge_i16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xa6,0xd0,0x01,0x04,0x02,0x00]

v_cmp_ge_i16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0xa6,0xd0,0x65,0x04,0x02,0x00]

v_cmp_ge_i16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xa6,0xd0,0x66,0x04,0x02,0x00]

v_cmp_ge_i16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xa6,0xd0,0x67,0x04,0x02,0x00]

v_cmp_ge_i16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xa6,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_ge_i16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xa6,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_ge_i16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0xa6,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_ge_i16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xa6,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_ge_i16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xa6,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_ge_i16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xa6,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_ge_i16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xa6,0xd0,0x80,0x04,0x02,0x00]

v_cmp_ge_i16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xa6,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_ge_i16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xa6,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_ge_i16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xa6,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_ge_i16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xa6,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_ge_i16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xa6,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_ge_i16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xa6,0xd0,0x01,0xff,0x03,0x00]

v_cmp_ge_i16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xa6,0xd0,0x01,0x05,0x00,0x00]

v_cmp_ge_i16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0xa6,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_ge_i16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xa6,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_ge_i16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xa6,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_ge_i16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xa6,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_ge_i16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xa6,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_ge_i16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0xa6,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_ge_i16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xa6,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_ge_i16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xa6,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_ge_i16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xa6,0xd0,0x01,0xff,0x00,0x00]

v_cmp_ge_i16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xa6,0xd0,0x01,0x01,0x01,0x00]

v_cmp_ge_i16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xa6,0xd0,0x01,0x83,0x01,0x00]

v_cmp_ge_i16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xa6,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_ge_i16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xa6,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_ge_i16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xa6,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_t_i16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xa7,0xd0,0x01,0x05,0x02,0x00]

v_cmp_t_i16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xa7,0xd0,0x01,0x05,0x02,0x00]

v_cmp_t_i16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0xa7,0xd0,0x01,0x05,0x02,0x00]

v_cmp_t_i16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0xa7,0xd0,0x01,0x05,0x02,0x00]

v_cmp_t_i16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xa7,0xd0,0x01,0x05,0x02,0x00]

v_cmp_t_i16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0xa7,0xd0,0x01,0x05,0x02,0x00]

v_cmp_t_i16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xa7,0xd0,0xff,0x05,0x02,0x00]

v_cmp_t_i16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xa7,0xd0,0x01,0x04,0x02,0x00]

v_cmp_t_i16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0xa7,0xd0,0x65,0x04,0x02,0x00]

v_cmp_t_i16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xa7,0xd0,0x66,0x04,0x02,0x00]

v_cmp_t_i16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xa7,0xd0,0x67,0x04,0x02,0x00]

v_cmp_t_i16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xa7,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_t_i16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xa7,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_t_i16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0xa7,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_t_i16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xa7,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_t_i16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xa7,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_t_i16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xa7,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_t_i16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xa7,0xd0,0x80,0x04,0x02,0x00]

v_cmp_t_i16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xa7,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_t_i16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xa7,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_t_i16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xa7,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_t_i16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xa7,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_t_i16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xa7,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_t_i16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xa7,0xd0,0x01,0xff,0x03,0x00]

v_cmp_t_i16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xa7,0xd0,0x01,0x05,0x00,0x00]

v_cmp_t_i16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0xa7,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_t_i16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xa7,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_t_i16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xa7,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_t_i16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xa7,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_t_i16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xa7,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_t_i16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0xa7,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_t_i16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xa7,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_t_i16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xa7,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_t_i16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xa7,0xd0,0x01,0xff,0x00,0x00]

v_cmp_t_i16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xa7,0xd0,0x01,0x01,0x01,0x00]

v_cmp_t_i16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xa7,0xd0,0x01,0x83,0x01,0x00]

v_cmp_t_i16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xa7,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_t_i16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xa7,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_t_i16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xa7,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_f_u16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xa8,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_u16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xa8,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_u16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0xa8,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_u16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0xa8,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_u16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xa8,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_u16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0xa8,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_u16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xa8,0xd0,0xff,0x05,0x02,0x00]

v_cmp_f_u16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xa8,0xd0,0x01,0x04,0x02,0x00]

v_cmp_f_u16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0xa8,0xd0,0x65,0x04,0x02,0x00]

v_cmp_f_u16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xa8,0xd0,0x66,0x04,0x02,0x00]

v_cmp_f_u16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xa8,0xd0,0x67,0x04,0x02,0x00]

v_cmp_f_u16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xa8,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_f_u16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xa8,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_f_u16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0xa8,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_f_u16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xa8,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_f_u16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xa8,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_f_u16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xa8,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_f_u16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xa8,0xd0,0x80,0x04,0x02,0x00]

v_cmp_f_u16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xa8,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_f_u16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xa8,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_f_u16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xa8,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_f_u16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xa8,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_f_u16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xa8,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_f_u16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xa8,0xd0,0x01,0xff,0x03,0x00]

v_cmp_f_u16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xa8,0xd0,0x01,0x05,0x00,0x00]

v_cmp_f_u16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0xa8,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_f_u16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xa8,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_f_u16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xa8,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_f_u16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xa8,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_f_u16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xa8,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_f_u16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0xa8,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_f_u16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xa8,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_f_u16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xa8,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_f_u16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xa8,0xd0,0x01,0xff,0x00,0x00]

v_cmp_f_u16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xa8,0xd0,0x01,0x01,0x01,0x00]

v_cmp_f_u16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xa8,0xd0,0x01,0x83,0x01,0x00]

v_cmp_f_u16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xa8,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_f_u16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xa8,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_f_u16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xa8,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_lt_u16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xa9,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_u16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xa9,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_u16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0xa9,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_u16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0xa9,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_u16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xa9,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_u16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0xa9,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_u16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xa9,0xd0,0xff,0x05,0x02,0x00]

v_cmp_lt_u16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xa9,0xd0,0x01,0x04,0x02,0x00]

v_cmp_lt_u16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0xa9,0xd0,0x65,0x04,0x02,0x00]

v_cmp_lt_u16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xa9,0xd0,0x66,0x04,0x02,0x00]

v_cmp_lt_u16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xa9,0xd0,0x67,0x04,0x02,0x00]

v_cmp_lt_u16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xa9,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_lt_u16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xa9,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_lt_u16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0xa9,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_lt_u16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xa9,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_lt_u16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xa9,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_lt_u16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xa9,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_lt_u16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xa9,0xd0,0x80,0x04,0x02,0x00]

v_cmp_lt_u16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xa9,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_lt_u16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xa9,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_lt_u16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xa9,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_lt_u16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xa9,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_lt_u16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xa9,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_lt_u16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xa9,0xd0,0x01,0xff,0x03,0x00]

v_cmp_lt_u16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xa9,0xd0,0x01,0x05,0x00,0x00]

v_cmp_lt_u16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0xa9,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_lt_u16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xa9,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_lt_u16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xa9,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_lt_u16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xa9,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_lt_u16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xa9,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_lt_u16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0xa9,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_lt_u16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xa9,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_lt_u16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xa9,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_lt_u16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xa9,0xd0,0x01,0xff,0x00,0x00]

v_cmp_lt_u16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xa9,0xd0,0x01,0x01,0x01,0x00]

v_cmp_lt_u16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xa9,0xd0,0x01,0x83,0x01,0x00]

v_cmp_lt_u16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xa9,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_lt_u16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xa9,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_lt_u16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xa9,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_eq_u16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xaa,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_u16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xaa,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_u16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0xaa,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_u16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0xaa,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_u16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xaa,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_u16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0xaa,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_u16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xaa,0xd0,0xff,0x05,0x02,0x00]

v_cmp_eq_u16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xaa,0xd0,0x01,0x04,0x02,0x00]

v_cmp_eq_u16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0xaa,0xd0,0x65,0x04,0x02,0x00]

v_cmp_eq_u16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xaa,0xd0,0x66,0x04,0x02,0x00]

v_cmp_eq_u16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xaa,0xd0,0x67,0x04,0x02,0x00]

v_cmp_eq_u16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xaa,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_eq_u16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xaa,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_eq_u16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0xaa,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_eq_u16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xaa,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_eq_u16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xaa,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_eq_u16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xaa,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_eq_u16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xaa,0xd0,0x80,0x04,0x02,0x00]

v_cmp_eq_u16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xaa,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_eq_u16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xaa,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_eq_u16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xaa,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_eq_u16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xaa,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_eq_u16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xaa,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_eq_u16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xaa,0xd0,0x01,0xff,0x03,0x00]

v_cmp_eq_u16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xaa,0xd0,0x01,0x05,0x00,0x00]

v_cmp_eq_u16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0xaa,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_eq_u16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xaa,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_eq_u16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xaa,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_eq_u16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xaa,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_eq_u16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xaa,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_eq_u16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0xaa,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_eq_u16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xaa,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_eq_u16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xaa,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_eq_u16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xaa,0xd0,0x01,0xff,0x00,0x00]

v_cmp_eq_u16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xaa,0xd0,0x01,0x01,0x01,0x00]

v_cmp_eq_u16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xaa,0xd0,0x01,0x83,0x01,0x00]

v_cmp_eq_u16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xaa,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_eq_u16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xaa,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_eq_u16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xaa,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_le_u16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xab,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_u16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xab,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_u16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0xab,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_u16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0xab,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_u16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xab,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_u16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0xab,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_u16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xab,0xd0,0xff,0x05,0x02,0x00]

v_cmp_le_u16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xab,0xd0,0x01,0x04,0x02,0x00]

v_cmp_le_u16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0xab,0xd0,0x65,0x04,0x02,0x00]

v_cmp_le_u16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xab,0xd0,0x66,0x04,0x02,0x00]

v_cmp_le_u16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xab,0xd0,0x67,0x04,0x02,0x00]

v_cmp_le_u16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xab,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_le_u16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xab,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_le_u16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0xab,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_le_u16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xab,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_le_u16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xab,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_le_u16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xab,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_le_u16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xab,0xd0,0x80,0x04,0x02,0x00]

v_cmp_le_u16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xab,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_le_u16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xab,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_le_u16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xab,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_le_u16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xab,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_le_u16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xab,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_le_u16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xab,0xd0,0x01,0xff,0x03,0x00]

v_cmp_le_u16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xab,0xd0,0x01,0x05,0x00,0x00]

v_cmp_le_u16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0xab,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_le_u16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xab,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_le_u16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xab,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_le_u16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xab,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_le_u16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xab,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_le_u16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0xab,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_le_u16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xab,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_le_u16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xab,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_le_u16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xab,0xd0,0x01,0xff,0x00,0x00]

v_cmp_le_u16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xab,0xd0,0x01,0x01,0x01,0x00]

v_cmp_le_u16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xab,0xd0,0x01,0x83,0x01,0x00]

v_cmp_le_u16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xab,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_le_u16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xab,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_le_u16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xab,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_gt_u16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xac,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_u16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xac,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_u16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0xac,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_u16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0xac,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_u16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xac,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_u16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0xac,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_u16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xac,0xd0,0xff,0x05,0x02,0x00]

v_cmp_gt_u16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xac,0xd0,0x01,0x04,0x02,0x00]

v_cmp_gt_u16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0xac,0xd0,0x65,0x04,0x02,0x00]

v_cmp_gt_u16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xac,0xd0,0x66,0x04,0x02,0x00]

v_cmp_gt_u16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xac,0xd0,0x67,0x04,0x02,0x00]

v_cmp_gt_u16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xac,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_gt_u16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xac,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_gt_u16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0xac,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_gt_u16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xac,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_gt_u16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xac,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_gt_u16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xac,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_gt_u16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xac,0xd0,0x80,0x04,0x02,0x00]

v_cmp_gt_u16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xac,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_gt_u16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xac,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_gt_u16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xac,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_gt_u16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xac,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_gt_u16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xac,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_gt_u16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xac,0xd0,0x01,0xff,0x03,0x00]

v_cmp_gt_u16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xac,0xd0,0x01,0x05,0x00,0x00]

v_cmp_gt_u16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0xac,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_gt_u16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xac,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_gt_u16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xac,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_gt_u16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xac,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_gt_u16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xac,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_gt_u16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0xac,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_gt_u16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xac,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_gt_u16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xac,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_gt_u16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xac,0xd0,0x01,0xff,0x00,0x00]

v_cmp_gt_u16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xac,0xd0,0x01,0x01,0x01,0x00]

v_cmp_gt_u16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xac,0xd0,0x01,0x83,0x01,0x00]

v_cmp_gt_u16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xac,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_gt_u16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xac,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_gt_u16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xac,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_ne_u16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xad,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ne_u16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xad,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ne_u16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0xad,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ne_u16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0xad,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ne_u16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xad,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ne_u16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0xad,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ne_u16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xad,0xd0,0xff,0x05,0x02,0x00]

v_cmp_ne_u16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xad,0xd0,0x01,0x04,0x02,0x00]

v_cmp_ne_u16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0xad,0xd0,0x65,0x04,0x02,0x00]

v_cmp_ne_u16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xad,0xd0,0x66,0x04,0x02,0x00]

v_cmp_ne_u16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xad,0xd0,0x67,0x04,0x02,0x00]

v_cmp_ne_u16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xad,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_ne_u16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xad,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_ne_u16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0xad,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_ne_u16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xad,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_ne_u16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xad,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_ne_u16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xad,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_ne_u16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xad,0xd0,0x80,0x04,0x02,0x00]

v_cmp_ne_u16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xad,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_ne_u16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xad,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_ne_u16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xad,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_ne_u16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xad,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_ne_u16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xad,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_ne_u16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xad,0xd0,0x01,0xff,0x03,0x00]

v_cmp_ne_u16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xad,0xd0,0x01,0x05,0x00,0x00]

v_cmp_ne_u16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0xad,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_ne_u16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xad,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_ne_u16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xad,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_ne_u16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xad,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_ne_u16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xad,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_ne_u16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0xad,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_ne_u16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xad,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_ne_u16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xad,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_ne_u16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xad,0xd0,0x01,0xff,0x00,0x00]

v_cmp_ne_u16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xad,0xd0,0x01,0x01,0x01,0x00]

v_cmp_ne_u16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xad,0xd0,0x01,0x83,0x01,0x00]

v_cmp_ne_u16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xad,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_ne_u16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xad,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_ne_u16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xad,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_ge_u16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xae,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_u16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xae,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_u16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0xae,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_u16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0xae,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_u16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xae,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_u16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0xae,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_u16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xae,0xd0,0xff,0x05,0x02,0x00]

v_cmp_ge_u16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xae,0xd0,0x01,0x04,0x02,0x00]

v_cmp_ge_u16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0xae,0xd0,0x65,0x04,0x02,0x00]

v_cmp_ge_u16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xae,0xd0,0x66,0x04,0x02,0x00]

v_cmp_ge_u16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xae,0xd0,0x67,0x04,0x02,0x00]

v_cmp_ge_u16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xae,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_ge_u16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xae,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_ge_u16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0xae,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_ge_u16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xae,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_ge_u16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xae,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_ge_u16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xae,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_ge_u16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xae,0xd0,0x80,0x04,0x02,0x00]

v_cmp_ge_u16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xae,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_ge_u16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xae,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_ge_u16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xae,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_ge_u16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xae,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_ge_u16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xae,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_ge_u16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xae,0xd0,0x01,0xff,0x03,0x00]

v_cmp_ge_u16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xae,0xd0,0x01,0x05,0x00,0x00]

v_cmp_ge_u16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0xae,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_ge_u16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xae,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_ge_u16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xae,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_ge_u16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xae,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_ge_u16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xae,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_ge_u16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0xae,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_ge_u16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xae,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_ge_u16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xae,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_ge_u16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xae,0xd0,0x01,0xff,0x00,0x00]

v_cmp_ge_u16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xae,0xd0,0x01,0x01,0x01,0x00]

v_cmp_ge_u16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xae,0xd0,0x01,0x83,0x01,0x00]

v_cmp_ge_u16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xae,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_ge_u16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xae,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_ge_u16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xae,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_t_u16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xaf,0xd0,0x01,0x05,0x02,0x00]

v_cmp_t_u16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xaf,0xd0,0x01,0x05,0x02,0x00]

v_cmp_t_u16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0xaf,0xd0,0x01,0x05,0x02,0x00]

v_cmp_t_u16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0xaf,0xd0,0x01,0x05,0x02,0x00]

v_cmp_t_u16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xaf,0xd0,0x01,0x05,0x02,0x00]

v_cmp_t_u16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0xaf,0xd0,0x01,0x05,0x02,0x00]

v_cmp_t_u16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xaf,0xd0,0xff,0x05,0x02,0x00]

v_cmp_t_u16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xaf,0xd0,0x01,0x04,0x02,0x00]

v_cmp_t_u16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0xaf,0xd0,0x65,0x04,0x02,0x00]

v_cmp_t_u16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xaf,0xd0,0x66,0x04,0x02,0x00]

v_cmp_t_u16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xaf,0xd0,0x67,0x04,0x02,0x00]

v_cmp_t_u16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xaf,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_t_u16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xaf,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_t_u16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0xaf,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_t_u16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xaf,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_t_u16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xaf,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_t_u16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xaf,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_t_u16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xaf,0xd0,0x80,0x04,0x02,0x00]

v_cmp_t_u16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xaf,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_t_u16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xaf,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_t_u16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xaf,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_t_u16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xaf,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_t_u16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xaf,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_t_u16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xaf,0xd0,0x01,0xff,0x03,0x00]

v_cmp_t_u16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xaf,0xd0,0x01,0x05,0x00,0x00]

v_cmp_t_u16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0xaf,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_t_u16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xaf,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_t_u16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xaf,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_t_u16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xaf,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_t_u16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xaf,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_t_u16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0xaf,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_t_u16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xaf,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_t_u16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xaf,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_t_u16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xaf,0xd0,0x01,0xff,0x00,0x00]

v_cmp_t_u16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xaf,0xd0,0x01,0x01,0x01,0x00]

v_cmp_t_u16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xaf,0xd0,0x01,0x83,0x01,0x00]

v_cmp_t_u16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xaf,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_t_u16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xaf,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_t_u16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xaf,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_f_i16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xb0,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_i16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xb0,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_i16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0xb0,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_i16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0xb0,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_i16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xb0,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_i16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0xb0,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_i16_e64 exec, v1, v2
// CHECK: [0x7e,0x00,0xb0,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_i16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xb0,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_f_i16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xb0,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_f_i16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0xb0,0xd0,0x65,0x04,0x02,0x00]

v_cmpx_f_i16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xb0,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_f_i16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xb0,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_f_i16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xb0,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_f_i16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xb0,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_f_i16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0xb0,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_f_i16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xb0,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_f_i16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xb0,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_f_i16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xb0,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_f_i16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xb0,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_f_i16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xb0,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_f_i16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xb0,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_f_i16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xb0,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_f_i16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xb0,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_f_i16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xb0,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_f_i16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xb0,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_f_i16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xb0,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_f_i16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0xb0,0xd0,0x01,0xcb,0x00,0x00]

v_cmpx_f_i16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xb0,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_f_i16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xb0,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_f_i16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xb0,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_f_i16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xb0,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_f_i16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0xb0,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_f_i16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xb0,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_f_i16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xb0,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_f_i16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xb0,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_f_i16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xb0,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_f_i16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xb0,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_f_i16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xb0,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_f_i16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xb0,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_f_i16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xb0,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_lt_i16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xb1,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_i16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xb1,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_i16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0xb1,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_i16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0xb1,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_i16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xb1,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_i16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0xb1,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_i16_e64 exec, v1, v2
// CHECK: [0x7e,0x00,0xb1,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_i16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xb1,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_lt_i16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xb1,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_lt_i16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0xb1,0xd0,0x65,0x04,0x02,0x00]

v_cmpx_lt_i16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xb1,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_lt_i16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xb1,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_lt_i16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xb1,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_lt_i16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xb1,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_lt_i16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0xb1,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_lt_i16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xb1,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_lt_i16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xb1,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_lt_i16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xb1,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_lt_i16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xb1,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_lt_i16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xb1,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_lt_i16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xb1,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_lt_i16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xb1,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_lt_i16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xb1,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_lt_i16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xb1,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_lt_i16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xb1,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_lt_i16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xb1,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_lt_i16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0xb1,0xd0,0x01,0xcb,0x00,0x00]

v_cmpx_lt_i16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xb1,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_lt_i16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xb1,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_lt_i16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xb1,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_lt_i16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xb1,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_lt_i16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0xb1,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_lt_i16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xb1,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_lt_i16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xb1,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_lt_i16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xb1,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_lt_i16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xb1,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_lt_i16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xb1,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_lt_i16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xb1,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_lt_i16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xb1,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_lt_i16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xb1,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_eq_i16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xb2,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_i16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xb2,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_i16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0xb2,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_i16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0xb2,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_i16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xb2,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_i16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0xb2,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_i16_e64 exec, v1, v2
// CHECK: [0x7e,0x00,0xb2,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_i16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xb2,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_eq_i16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xb2,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_eq_i16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0xb2,0xd0,0x65,0x04,0x02,0x00]

v_cmpx_eq_i16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xb2,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_eq_i16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xb2,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_eq_i16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xb2,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_eq_i16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xb2,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_eq_i16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0xb2,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_eq_i16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xb2,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_eq_i16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xb2,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_eq_i16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xb2,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_eq_i16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xb2,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_eq_i16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xb2,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_eq_i16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xb2,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_eq_i16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xb2,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_eq_i16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xb2,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_eq_i16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xb2,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_eq_i16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xb2,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_eq_i16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xb2,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_eq_i16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0xb2,0xd0,0x01,0xcb,0x00,0x00]

v_cmpx_eq_i16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xb2,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_eq_i16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xb2,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_eq_i16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xb2,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_eq_i16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xb2,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_eq_i16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0xb2,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_eq_i16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xb2,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_eq_i16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xb2,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_eq_i16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xb2,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_eq_i16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xb2,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_eq_i16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xb2,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_eq_i16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xb2,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_eq_i16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xb2,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_eq_i16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xb2,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_le_i16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xb3,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_i16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xb3,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_i16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0xb3,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_i16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0xb3,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_i16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xb3,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_i16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0xb3,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_i16_e64 exec, v1, v2
// CHECK: [0x7e,0x00,0xb3,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_i16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xb3,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_le_i16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xb3,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_le_i16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0xb3,0xd0,0x65,0x04,0x02,0x00]

v_cmpx_le_i16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xb3,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_le_i16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xb3,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_le_i16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xb3,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_le_i16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xb3,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_le_i16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0xb3,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_le_i16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xb3,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_le_i16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xb3,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_le_i16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xb3,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_le_i16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xb3,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_le_i16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xb3,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_le_i16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xb3,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_le_i16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xb3,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_le_i16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xb3,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_le_i16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xb3,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_le_i16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xb3,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_le_i16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xb3,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_le_i16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0xb3,0xd0,0x01,0xcb,0x00,0x00]

v_cmpx_le_i16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xb3,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_le_i16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xb3,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_le_i16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xb3,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_le_i16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xb3,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_le_i16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0xb3,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_le_i16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xb3,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_le_i16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xb3,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_le_i16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xb3,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_le_i16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xb3,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_le_i16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xb3,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_le_i16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xb3,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_le_i16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xb3,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_le_i16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xb3,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_gt_i16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xb4,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_i16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xb4,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_i16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0xb4,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_i16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0xb4,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_i16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xb4,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_i16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0xb4,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_i16_e64 exec, v1, v2
// CHECK: [0x7e,0x00,0xb4,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_i16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xb4,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_gt_i16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xb4,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_gt_i16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0xb4,0xd0,0x65,0x04,0x02,0x00]

v_cmpx_gt_i16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xb4,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_gt_i16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xb4,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_gt_i16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xb4,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_gt_i16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xb4,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_gt_i16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0xb4,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_gt_i16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xb4,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_gt_i16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xb4,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_gt_i16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xb4,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_gt_i16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xb4,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_gt_i16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xb4,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_gt_i16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xb4,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_gt_i16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xb4,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_gt_i16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xb4,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_gt_i16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xb4,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_gt_i16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xb4,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_gt_i16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xb4,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_gt_i16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0xb4,0xd0,0x01,0xcb,0x00,0x00]

v_cmpx_gt_i16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xb4,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_gt_i16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xb4,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_gt_i16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xb4,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_gt_i16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xb4,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_gt_i16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0xb4,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_gt_i16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xb4,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_gt_i16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xb4,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_gt_i16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xb4,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_gt_i16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xb4,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_gt_i16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xb4,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_gt_i16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xb4,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_gt_i16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xb4,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_gt_i16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xb4,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_ne_i16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xb5,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ne_i16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xb5,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ne_i16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0xb5,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ne_i16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0xb5,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ne_i16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xb5,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ne_i16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0xb5,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ne_i16_e64 exec, v1, v2
// CHECK: [0x7e,0x00,0xb5,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ne_i16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xb5,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_ne_i16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xb5,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_ne_i16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0xb5,0xd0,0x65,0x04,0x02,0x00]

v_cmpx_ne_i16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xb5,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_ne_i16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xb5,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_ne_i16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xb5,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_ne_i16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xb5,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_ne_i16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0xb5,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_ne_i16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xb5,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_ne_i16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xb5,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_ne_i16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xb5,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_ne_i16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xb5,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_ne_i16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xb5,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_ne_i16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xb5,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_ne_i16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xb5,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_ne_i16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xb5,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_ne_i16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xb5,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_ne_i16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xb5,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_ne_i16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xb5,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_ne_i16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0xb5,0xd0,0x01,0xcb,0x00,0x00]

v_cmpx_ne_i16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xb5,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_ne_i16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xb5,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_ne_i16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xb5,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_ne_i16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xb5,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_ne_i16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0xb5,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_ne_i16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xb5,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_ne_i16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xb5,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_ne_i16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xb5,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_ne_i16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xb5,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_ne_i16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xb5,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_ne_i16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xb5,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_ne_i16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xb5,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_ne_i16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xb5,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_ge_i16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xb6,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_i16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xb6,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_i16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0xb6,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_i16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0xb6,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_i16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xb6,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_i16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0xb6,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_i16_e64 exec, v1, v2
// CHECK: [0x7e,0x00,0xb6,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_i16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xb6,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_ge_i16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xb6,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_ge_i16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0xb6,0xd0,0x65,0x04,0x02,0x00]

v_cmpx_ge_i16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xb6,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_ge_i16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xb6,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_ge_i16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xb6,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_ge_i16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xb6,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_ge_i16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0xb6,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_ge_i16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xb6,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_ge_i16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xb6,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_ge_i16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xb6,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_ge_i16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xb6,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_ge_i16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xb6,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_ge_i16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xb6,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_ge_i16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xb6,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_ge_i16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xb6,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_ge_i16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xb6,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_ge_i16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xb6,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_ge_i16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xb6,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_ge_i16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0xb6,0xd0,0x01,0xcb,0x00,0x00]

v_cmpx_ge_i16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xb6,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_ge_i16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xb6,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_ge_i16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xb6,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_ge_i16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xb6,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_ge_i16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0xb6,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_ge_i16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xb6,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_ge_i16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xb6,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_ge_i16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xb6,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_ge_i16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xb6,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_ge_i16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xb6,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_ge_i16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xb6,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_ge_i16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xb6,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_ge_i16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xb6,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_t_i16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xb7,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_t_i16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xb7,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_t_i16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0xb7,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_t_i16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0xb7,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_t_i16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xb7,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_t_i16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0xb7,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_t_i16_e64 exec, v1, v2
// CHECK: [0x7e,0x00,0xb7,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_t_i16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xb7,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_t_i16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xb7,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_t_i16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0xb7,0xd0,0x65,0x04,0x02,0x00]

v_cmpx_t_i16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xb7,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_t_i16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xb7,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_t_i16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xb7,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_t_i16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xb7,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_t_i16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0xb7,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_t_i16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xb7,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_t_i16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xb7,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_t_i16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xb7,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_t_i16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xb7,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_t_i16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xb7,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_t_i16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xb7,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_t_i16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xb7,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_t_i16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xb7,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_t_i16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xb7,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_t_i16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xb7,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_t_i16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xb7,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_t_i16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0xb7,0xd0,0x01,0xcb,0x00,0x00]

v_cmpx_t_i16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xb7,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_t_i16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xb7,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_t_i16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xb7,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_t_i16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xb7,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_t_i16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0xb7,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_t_i16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xb7,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_t_i16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xb7,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_t_i16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xb7,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_t_i16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xb7,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_t_i16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xb7,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_t_i16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xb7,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_t_i16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xb7,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_t_i16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xb7,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_f_u16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xb8,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_u16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xb8,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_u16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0xb8,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_u16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0xb8,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_u16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xb8,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_u16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0xb8,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_u16_e64 exec, v1, v2
// CHECK: [0x7e,0x00,0xb8,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_u16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xb8,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_f_u16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xb8,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_f_u16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0xb8,0xd0,0x65,0x04,0x02,0x00]

v_cmpx_f_u16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xb8,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_f_u16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xb8,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_f_u16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xb8,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_f_u16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xb8,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_f_u16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0xb8,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_f_u16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xb8,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_f_u16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xb8,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_f_u16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xb8,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_f_u16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xb8,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_f_u16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xb8,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_f_u16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xb8,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_f_u16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xb8,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_f_u16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xb8,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_f_u16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xb8,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_f_u16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xb8,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_f_u16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xb8,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_f_u16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0xb8,0xd0,0x01,0xcb,0x00,0x00]

v_cmpx_f_u16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xb8,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_f_u16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xb8,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_f_u16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xb8,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_f_u16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xb8,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_f_u16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0xb8,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_f_u16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xb8,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_f_u16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xb8,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_f_u16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xb8,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_f_u16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xb8,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_f_u16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xb8,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_f_u16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xb8,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_f_u16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xb8,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_f_u16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xb8,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_lt_u16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xb9,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_u16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xb9,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_u16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0xb9,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_u16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0xb9,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_u16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xb9,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_u16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0xb9,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_u16_e64 exec, v1, v2
// CHECK: [0x7e,0x00,0xb9,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_u16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xb9,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_lt_u16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xb9,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_lt_u16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0xb9,0xd0,0x65,0x04,0x02,0x00]

v_cmpx_lt_u16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xb9,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_lt_u16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xb9,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_lt_u16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xb9,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_lt_u16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xb9,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_lt_u16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0xb9,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_lt_u16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xb9,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_lt_u16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xb9,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_lt_u16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xb9,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_lt_u16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xb9,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_lt_u16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xb9,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_lt_u16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xb9,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_lt_u16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xb9,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_lt_u16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xb9,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_lt_u16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xb9,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_lt_u16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xb9,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_lt_u16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xb9,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_lt_u16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0xb9,0xd0,0x01,0xcb,0x00,0x00]

v_cmpx_lt_u16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xb9,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_lt_u16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xb9,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_lt_u16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xb9,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_lt_u16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xb9,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_lt_u16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0xb9,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_lt_u16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xb9,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_lt_u16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xb9,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_lt_u16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xb9,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_lt_u16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xb9,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_lt_u16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xb9,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_lt_u16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xb9,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_lt_u16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xb9,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_lt_u16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xb9,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_eq_u16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xba,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_u16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xba,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_u16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0xba,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_u16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0xba,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_u16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xba,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_u16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0xba,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_u16_e64 exec, v1, v2
// CHECK: [0x7e,0x00,0xba,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_u16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xba,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_eq_u16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xba,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_eq_u16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0xba,0xd0,0x65,0x04,0x02,0x00]

v_cmpx_eq_u16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xba,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_eq_u16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xba,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_eq_u16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xba,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_eq_u16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xba,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_eq_u16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0xba,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_eq_u16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xba,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_eq_u16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xba,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_eq_u16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xba,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_eq_u16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xba,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_eq_u16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xba,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_eq_u16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xba,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_eq_u16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xba,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_eq_u16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xba,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_eq_u16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xba,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_eq_u16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xba,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_eq_u16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xba,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_eq_u16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0xba,0xd0,0x01,0xcb,0x00,0x00]

v_cmpx_eq_u16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xba,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_eq_u16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xba,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_eq_u16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xba,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_eq_u16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xba,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_eq_u16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0xba,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_eq_u16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xba,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_eq_u16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xba,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_eq_u16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xba,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_eq_u16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xba,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_eq_u16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xba,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_eq_u16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xba,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_eq_u16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xba,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_eq_u16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xba,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_le_u16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xbb,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_u16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xbb,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_u16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0xbb,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_u16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0xbb,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_u16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xbb,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_u16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0xbb,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_u16_e64 exec, v1, v2
// CHECK: [0x7e,0x00,0xbb,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_u16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xbb,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_le_u16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xbb,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_le_u16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0xbb,0xd0,0x65,0x04,0x02,0x00]

v_cmpx_le_u16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xbb,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_le_u16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xbb,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_le_u16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xbb,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_le_u16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xbb,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_le_u16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0xbb,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_le_u16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xbb,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_le_u16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xbb,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_le_u16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xbb,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_le_u16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xbb,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_le_u16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xbb,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_le_u16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xbb,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_le_u16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xbb,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_le_u16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xbb,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_le_u16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xbb,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_le_u16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xbb,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_le_u16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xbb,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_le_u16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0xbb,0xd0,0x01,0xcb,0x00,0x00]

v_cmpx_le_u16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xbb,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_le_u16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xbb,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_le_u16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xbb,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_le_u16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xbb,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_le_u16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0xbb,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_le_u16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xbb,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_le_u16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xbb,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_le_u16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xbb,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_le_u16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xbb,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_le_u16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xbb,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_le_u16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xbb,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_le_u16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xbb,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_le_u16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xbb,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_gt_u16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xbc,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_u16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xbc,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_u16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0xbc,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_u16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0xbc,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_u16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xbc,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_u16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0xbc,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_u16_e64 exec, v1, v2
// CHECK: [0x7e,0x00,0xbc,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_u16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xbc,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_gt_u16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xbc,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_gt_u16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0xbc,0xd0,0x65,0x04,0x02,0x00]

v_cmpx_gt_u16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xbc,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_gt_u16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xbc,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_gt_u16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xbc,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_gt_u16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xbc,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_gt_u16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0xbc,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_gt_u16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xbc,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_gt_u16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xbc,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_gt_u16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xbc,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_gt_u16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xbc,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_gt_u16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xbc,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_gt_u16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xbc,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_gt_u16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xbc,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_gt_u16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xbc,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_gt_u16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xbc,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_gt_u16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xbc,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_gt_u16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xbc,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_gt_u16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0xbc,0xd0,0x01,0xcb,0x00,0x00]

v_cmpx_gt_u16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xbc,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_gt_u16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xbc,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_gt_u16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xbc,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_gt_u16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xbc,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_gt_u16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0xbc,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_gt_u16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xbc,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_gt_u16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xbc,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_gt_u16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xbc,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_gt_u16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xbc,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_gt_u16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xbc,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_gt_u16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xbc,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_gt_u16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xbc,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_gt_u16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xbc,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_ne_u16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xbd,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ne_u16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xbd,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ne_u16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0xbd,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ne_u16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0xbd,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ne_u16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xbd,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ne_u16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0xbd,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ne_u16_e64 exec, v1, v2
// CHECK: [0x7e,0x00,0xbd,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ne_u16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xbd,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_ne_u16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xbd,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_ne_u16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0xbd,0xd0,0x65,0x04,0x02,0x00]

v_cmpx_ne_u16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xbd,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_ne_u16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xbd,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_ne_u16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xbd,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_ne_u16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xbd,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_ne_u16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0xbd,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_ne_u16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xbd,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_ne_u16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xbd,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_ne_u16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xbd,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_ne_u16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xbd,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_ne_u16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xbd,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_ne_u16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xbd,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_ne_u16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xbd,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_ne_u16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xbd,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_ne_u16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xbd,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_ne_u16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xbd,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_ne_u16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xbd,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_ne_u16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0xbd,0xd0,0x01,0xcb,0x00,0x00]

v_cmpx_ne_u16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xbd,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_ne_u16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xbd,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_ne_u16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xbd,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_ne_u16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xbd,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_ne_u16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0xbd,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_ne_u16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xbd,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_ne_u16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xbd,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_ne_u16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xbd,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_ne_u16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xbd,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_ne_u16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xbd,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_ne_u16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xbd,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_ne_u16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xbd,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_ne_u16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xbd,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_ge_u16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xbe,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_u16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xbe,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_u16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0xbe,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_u16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0xbe,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_u16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xbe,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_u16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0xbe,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_u16_e64 exec, v1, v2
// CHECK: [0x7e,0x00,0xbe,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_u16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xbe,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_ge_u16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xbe,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_ge_u16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0xbe,0xd0,0x65,0x04,0x02,0x00]

v_cmpx_ge_u16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xbe,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_ge_u16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xbe,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_ge_u16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xbe,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_ge_u16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xbe,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_ge_u16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0xbe,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_ge_u16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xbe,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_ge_u16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xbe,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_ge_u16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xbe,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_ge_u16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xbe,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_ge_u16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xbe,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_ge_u16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xbe,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_ge_u16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xbe,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_ge_u16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xbe,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_ge_u16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xbe,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_ge_u16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xbe,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_ge_u16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xbe,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_ge_u16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0xbe,0xd0,0x01,0xcb,0x00,0x00]

v_cmpx_ge_u16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xbe,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_ge_u16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xbe,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_ge_u16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xbe,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_ge_u16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xbe,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_ge_u16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0xbe,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_ge_u16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xbe,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_ge_u16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xbe,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_ge_u16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xbe,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_ge_u16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xbe,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_ge_u16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xbe,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_ge_u16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xbe,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_ge_u16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xbe,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_ge_u16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xbe,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_t_u16_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xbf,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_t_u16_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xbf,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_t_u16_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0xbf,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_t_u16_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0xbf,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_t_u16_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xbf,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_t_u16_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0xbf,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_t_u16_e64 exec, v1, v2
// CHECK: [0x7e,0x00,0xbf,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_t_u16_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xbf,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_t_u16_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xbf,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_t_u16_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0xbf,0xd0,0x65,0x04,0x02,0x00]

v_cmpx_t_u16_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xbf,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_t_u16_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xbf,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_t_u16_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xbf,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_t_u16_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xbf,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_t_u16_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0xbf,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_t_u16_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xbf,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_t_u16_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xbf,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_t_u16_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xbf,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_t_u16_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xbf,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_t_u16_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xbf,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_t_u16_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xbf,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_t_u16_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xbf,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_t_u16_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xbf,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_t_u16_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xbf,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_t_u16_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xbf,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_t_u16_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xbf,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_t_u16_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0xbf,0xd0,0x01,0xcb,0x00,0x00]

v_cmpx_t_u16_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xbf,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_t_u16_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xbf,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_t_u16_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xbf,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_t_u16_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xbf,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_t_u16_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0xbf,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_t_u16_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xbf,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_t_u16_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xbf,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_t_u16_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xbf,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_t_u16_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xbf,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_t_u16_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xbf,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_t_u16_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xbf,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_t_u16_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xbf,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_t_u16_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xbf,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_f_i32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xc0,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_i32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xc0,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_i32_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0xc0,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_i32_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0xc0,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_i32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xc0,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_i32_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0xc0,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_i32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xc0,0xd0,0xff,0x05,0x02,0x00]

v_cmp_f_i32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xc0,0xd0,0x01,0x04,0x02,0x00]

v_cmp_f_i32_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0xc0,0xd0,0x65,0x04,0x02,0x00]

v_cmp_f_i32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xc0,0xd0,0x66,0x04,0x02,0x00]

v_cmp_f_i32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xc0,0xd0,0x67,0x04,0x02,0x00]

v_cmp_f_i32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xc0,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_f_i32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xc0,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_f_i32_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0xc0,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_f_i32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xc0,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_f_i32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xc0,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_f_i32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xc0,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_f_i32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xc0,0xd0,0x80,0x04,0x02,0x00]

v_cmp_f_i32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xc0,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_f_i32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0xc0,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_f_i32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0xc0,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_f_i32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xc0,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_f_i32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xc0,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_f_i32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xc0,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_f_i32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xc0,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_f_i32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xc0,0xd0,0x01,0xff,0x03,0x00]

v_cmp_f_i32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xc0,0xd0,0x01,0x05,0x00,0x00]

v_cmp_f_i32_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0xc0,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_f_i32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xc0,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_f_i32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xc0,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_f_i32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xc0,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_f_i32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xc0,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_f_i32_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0xc0,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_f_i32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xc0,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_f_i32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xc0,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_f_i32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xc0,0xd0,0x01,0xff,0x00,0x00]

v_cmp_f_i32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xc0,0xd0,0x01,0x01,0x01,0x00]

v_cmp_f_i32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xc0,0xd0,0x01,0x83,0x01,0x00]

v_cmp_f_i32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0xc0,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_f_i32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0xc0,0xd0,0x01,0xef,0x01,0x00]

v_cmp_f_i32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xc0,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_f_i32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xc0,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_f_i32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xc0,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_lt_i32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xc1,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_i32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xc1,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_i32_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0xc1,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_i32_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0xc1,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_i32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xc1,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_i32_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0xc1,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_i32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xc1,0xd0,0xff,0x05,0x02,0x00]

v_cmp_lt_i32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xc1,0xd0,0x01,0x04,0x02,0x00]

v_cmp_lt_i32_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0xc1,0xd0,0x65,0x04,0x02,0x00]

v_cmp_lt_i32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xc1,0xd0,0x66,0x04,0x02,0x00]

v_cmp_lt_i32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xc1,0xd0,0x67,0x04,0x02,0x00]

v_cmp_lt_i32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xc1,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_lt_i32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xc1,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_lt_i32_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0xc1,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_lt_i32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xc1,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_lt_i32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xc1,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_lt_i32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xc1,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_lt_i32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xc1,0xd0,0x80,0x04,0x02,0x00]

v_cmp_lt_i32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xc1,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_lt_i32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0xc1,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_lt_i32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0xc1,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_lt_i32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xc1,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_lt_i32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xc1,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_lt_i32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xc1,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_lt_i32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xc1,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_lt_i32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xc1,0xd0,0x01,0xff,0x03,0x00]

v_cmp_lt_i32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xc1,0xd0,0x01,0x05,0x00,0x00]

v_cmp_lt_i32_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0xc1,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_lt_i32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xc1,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_lt_i32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xc1,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_lt_i32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xc1,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_lt_i32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xc1,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_lt_i32_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0xc1,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_lt_i32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xc1,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_lt_i32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xc1,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_lt_i32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xc1,0xd0,0x01,0xff,0x00,0x00]

v_cmp_lt_i32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xc1,0xd0,0x01,0x01,0x01,0x00]

v_cmp_lt_i32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xc1,0xd0,0x01,0x83,0x01,0x00]

v_cmp_lt_i32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0xc1,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_lt_i32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0xc1,0xd0,0x01,0xef,0x01,0x00]

v_cmp_lt_i32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xc1,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_lt_i32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xc1,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_lt_i32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xc1,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_eq_i32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xc2,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_i32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xc2,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_i32_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0xc2,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_i32_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0xc2,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_i32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xc2,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_i32_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0xc2,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_i32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xc2,0xd0,0xff,0x05,0x02,0x00]

v_cmp_eq_i32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xc2,0xd0,0x01,0x04,0x02,0x00]

v_cmp_eq_i32_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0xc2,0xd0,0x65,0x04,0x02,0x00]

v_cmp_eq_i32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xc2,0xd0,0x66,0x04,0x02,0x00]

v_cmp_eq_i32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xc2,0xd0,0x67,0x04,0x02,0x00]

v_cmp_eq_i32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xc2,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_eq_i32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xc2,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_eq_i32_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0xc2,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_eq_i32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xc2,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_eq_i32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xc2,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_eq_i32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xc2,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_eq_i32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xc2,0xd0,0x80,0x04,0x02,0x00]

v_cmp_eq_i32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xc2,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_eq_i32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0xc2,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_eq_i32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0xc2,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_eq_i32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xc2,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_eq_i32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xc2,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_eq_i32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xc2,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_eq_i32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xc2,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_eq_i32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xc2,0xd0,0x01,0xff,0x03,0x00]

v_cmp_eq_i32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xc2,0xd0,0x01,0x05,0x00,0x00]

v_cmp_eq_i32_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0xc2,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_eq_i32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xc2,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_eq_i32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xc2,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_eq_i32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xc2,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_eq_i32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xc2,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_eq_i32_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0xc2,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_eq_i32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xc2,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_eq_i32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xc2,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_eq_i32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xc2,0xd0,0x01,0xff,0x00,0x00]

v_cmp_eq_i32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xc2,0xd0,0x01,0x01,0x01,0x00]

v_cmp_eq_i32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xc2,0xd0,0x01,0x83,0x01,0x00]

v_cmp_eq_i32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0xc2,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_eq_i32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0xc2,0xd0,0x01,0xef,0x01,0x00]

v_cmp_eq_i32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xc2,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_eq_i32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xc2,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_eq_i32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xc2,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_le_i32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xc3,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_i32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xc3,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_i32_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0xc3,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_i32_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0xc3,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_i32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xc3,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_i32_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0xc3,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_i32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xc3,0xd0,0xff,0x05,0x02,0x00]

v_cmp_le_i32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xc3,0xd0,0x01,0x04,0x02,0x00]

v_cmp_le_i32_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0xc3,0xd0,0x65,0x04,0x02,0x00]

v_cmp_le_i32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xc3,0xd0,0x66,0x04,0x02,0x00]

v_cmp_le_i32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xc3,0xd0,0x67,0x04,0x02,0x00]

v_cmp_le_i32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xc3,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_le_i32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xc3,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_le_i32_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0xc3,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_le_i32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xc3,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_le_i32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xc3,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_le_i32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xc3,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_le_i32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xc3,0xd0,0x80,0x04,0x02,0x00]

v_cmp_le_i32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xc3,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_le_i32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0xc3,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_le_i32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0xc3,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_le_i32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xc3,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_le_i32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xc3,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_le_i32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xc3,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_le_i32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xc3,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_le_i32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xc3,0xd0,0x01,0xff,0x03,0x00]

v_cmp_le_i32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xc3,0xd0,0x01,0x05,0x00,0x00]

v_cmp_le_i32_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0xc3,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_le_i32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xc3,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_le_i32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xc3,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_le_i32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xc3,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_le_i32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xc3,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_le_i32_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0xc3,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_le_i32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xc3,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_le_i32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xc3,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_le_i32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xc3,0xd0,0x01,0xff,0x00,0x00]

v_cmp_le_i32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xc3,0xd0,0x01,0x01,0x01,0x00]

v_cmp_le_i32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xc3,0xd0,0x01,0x83,0x01,0x00]

v_cmp_le_i32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0xc3,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_le_i32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0xc3,0xd0,0x01,0xef,0x01,0x00]

v_cmp_le_i32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xc3,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_le_i32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xc3,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_le_i32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xc3,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_gt_i32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xc4,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_i32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xc4,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_i32_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0xc4,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_i32_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0xc4,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_i32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xc4,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_i32_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0xc4,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_i32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xc4,0xd0,0xff,0x05,0x02,0x00]

v_cmp_gt_i32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xc4,0xd0,0x01,0x04,0x02,0x00]

v_cmp_gt_i32_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0xc4,0xd0,0x65,0x04,0x02,0x00]

v_cmp_gt_i32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xc4,0xd0,0x66,0x04,0x02,0x00]

v_cmp_gt_i32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xc4,0xd0,0x67,0x04,0x02,0x00]

v_cmp_gt_i32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xc4,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_gt_i32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xc4,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_gt_i32_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0xc4,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_gt_i32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xc4,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_gt_i32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xc4,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_gt_i32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xc4,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_gt_i32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xc4,0xd0,0x80,0x04,0x02,0x00]

v_cmp_gt_i32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xc4,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_gt_i32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0xc4,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_gt_i32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0xc4,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_gt_i32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xc4,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_gt_i32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xc4,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_gt_i32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xc4,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_gt_i32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xc4,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_gt_i32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xc4,0xd0,0x01,0xff,0x03,0x00]

v_cmp_gt_i32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xc4,0xd0,0x01,0x05,0x00,0x00]

v_cmp_gt_i32_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0xc4,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_gt_i32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xc4,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_gt_i32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xc4,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_gt_i32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xc4,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_gt_i32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xc4,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_gt_i32_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0xc4,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_gt_i32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xc4,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_gt_i32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xc4,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_gt_i32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xc4,0xd0,0x01,0xff,0x00,0x00]

v_cmp_gt_i32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xc4,0xd0,0x01,0x01,0x01,0x00]

v_cmp_gt_i32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xc4,0xd0,0x01,0x83,0x01,0x00]

v_cmp_gt_i32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0xc4,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_gt_i32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0xc4,0xd0,0x01,0xef,0x01,0x00]

v_cmp_gt_i32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xc4,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_gt_i32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xc4,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_gt_i32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xc4,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_ne_i32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xc5,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ne_i32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xc5,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ne_i32_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0xc5,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ne_i32_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0xc5,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ne_i32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xc5,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ne_i32_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0xc5,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ne_i32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xc5,0xd0,0xff,0x05,0x02,0x00]

v_cmp_ne_i32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xc5,0xd0,0x01,0x04,0x02,0x00]

v_cmp_ne_i32_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0xc5,0xd0,0x65,0x04,0x02,0x00]

v_cmp_ne_i32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xc5,0xd0,0x66,0x04,0x02,0x00]

v_cmp_ne_i32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xc5,0xd0,0x67,0x04,0x02,0x00]

v_cmp_ne_i32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xc5,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_ne_i32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xc5,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_ne_i32_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0xc5,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_ne_i32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xc5,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_ne_i32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xc5,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_ne_i32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xc5,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_ne_i32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xc5,0xd0,0x80,0x04,0x02,0x00]

v_cmp_ne_i32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xc5,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_ne_i32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0xc5,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_ne_i32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0xc5,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_ne_i32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xc5,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_ne_i32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xc5,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_ne_i32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xc5,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_ne_i32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xc5,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_ne_i32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xc5,0xd0,0x01,0xff,0x03,0x00]

v_cmp_ne_i32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xc5,0xd0,0x01,0x05,0x00,0x00]

v_cmp_ne_i32_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0xc5,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_ne_i32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xc5,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_ne_i32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xc5,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_ne_i32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xc5,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_ne_i32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xc5,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_ne_i32_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0xc5,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_ne_i32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xc5,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_ne_i32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xc5,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_ne_i32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xc5,0xd0,0x01,0xff,0x00,0x00]

v_cmp_ne_i32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xc5,0xd0,0x01,0x01,0x01,0x00]

v_cmp_ne_i32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xc5,0xd0,0x01,0x83,0x01,0x00]

v_cmp_ne_i32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0xc5,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_ne_i32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0xc5,0xd0,0x01,0xef,0x01,0x00]

v_cmp_ne_i32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xc5,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_ne_i32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xc5,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_ne_i32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xc5,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_ge_i32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xc6,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_i32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xc6,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_i32_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0xc6,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_i32_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0xc6,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_i32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xc6,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_i32_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0xc6,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_i32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xc6,0xd0,0xff,0x05,0x02,0x00]

v_cmp_ge_i32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xc6,0xd0,0x01,0x04,0x02,0x00]

v_cmp_ge_i32_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0xc6,0xd0,0x65,0x04,0x02,0x00]

v_cmp_ge_i32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xc6,0xd0,0x66,0x04,0x02,0x00]

v_cmp_ge_i32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xc6,0xd0,0x67,0x04,0x02,0x00]

v_cmp_ge_i32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xc6,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_ge_i32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xc6,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_ge_i32_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0xc6,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_ge_i32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xc6,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_ge_i32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xc6,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_ge_i32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xc6,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_ge_i32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xc6,0xd0,0x80,0x04,0x02,0x00]

v_cmp_ge_i32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xc6,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_ge_i32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0xc6,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_ge_i32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0xc6,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_ge_i32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xc6,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_ge_i32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xc6,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_ge_i32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xc6,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_ge_i32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xc6,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_ge_i32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xc6,0xd0,0x01,0xff,0x03,0x00]

v_cmp_ge_i32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xc6,0xd0,0x01,0x05,0x00,0x00]

v_cmp_ge_i32_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0xc6,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_ge_i32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xc6,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_ge_i32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xc6,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_ge_i32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xc6,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_ge_i32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xc6,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_ge_i32_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0xc6,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_ge_i32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xc6,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_ge_i32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xc6,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_ge_i32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xc6,0xd0,0x01,0xff,0x00,0x00]

v_cmp_ge_i32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xc6,0xd0,0x01,0x01,0x01,0x00]

v_cmp_ge_i32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xc6,0xd0,0x01,0x83,0x01,0x00]

v_cmp_ge_i32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0xc6,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_ge_i32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0xc6,0xd0,0x01,0xef,0x01,0x00]

v_cmp_ge_i32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xc6,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_ge_i32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xc6,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_ge_i32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xc6,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_t_i32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xc7,0xd0,0x01,0x05,0x02,0x00]

v_cmp_t_i32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xc7,0xd0,0x01,0x05,0x02,0x00]

v_cmp_t_i32_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0xc7,0xd0,0x01,0x05,0x02,0x00]

v_cmp_t_i32_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0xc7,0xd0,0x01,0x05,0x02,0x00]

v_cmp_t_i32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xc7,0xd0,0x01,0x05,0x02,0x00]

v_cmp_t_i32_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0xc7,0xd0,0x01,0x05,0x02,0x00]

v_cmp_t_i32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xc7,0xd0,0xff,0x05,0x02,0x00]

v_cmp_t_i32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xc7,0xd0,0x01,0x04,0x02,0x00]

v_cmp_t_i32_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0xc7,0xd0,0x65,0x04,0x02,0x00]

v_cmp_t_i32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xc7,0xd0,0x66,0x04,0x02,0x00]

v_cmp_t_i32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xc7,0xd0,0x67,0x04,0x02,0x00]

v_cmp_t_i32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xc7,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_t_i32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xc7,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_t_i32_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0xc7,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_t_i32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xc7,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_t_i32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xc7,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_t_i32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xc7,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_t_i32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xc7,0xd0,0x80,0x04,0x02,0x00]

v_cmp_t_i32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xc7,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_t_i32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0xc7,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_t_i32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0xc7,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_t_i32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xc7,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_t_i32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xc7,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_t_i32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xc7,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_t_i32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xc7,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_t_i32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xc7,0xd0,0x01,0xff,0x03,0x00]

v_cmp_t_i32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xc7,0xd0,0x01,0x05,0x00,0x00]

v_cmp_t_i32_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0xc7,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_t_i32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xc7,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_t_i32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xc7,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_t_i32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xc7,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_t_i32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xc7,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_t_i32_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0xc7,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_t_i32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xc7,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_t_i32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xc7,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_t_i32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xc7,0xd0,0x01,0xff,0x00,0x00]

v_cmp_t_i32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xc7,0xd0,0x01,0x01,0x01,0x00]

v_cmp_t_i32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xc7,0xd0,0x01,0x83,0x01,0x00]

v_cmp_t_i32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0xc7,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_t_i32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0xc7,0xd0,0x01,0xef,0x01,0x00]

v_cmp_t_i32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xc7,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_t_i32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xc7,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_t_i32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xc7,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_f_u32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xc8,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_u32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xc8,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_u32_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0xc8,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_u32_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0xc8,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_u32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xc8,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_u32_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0xc8,0xd0,0x01,0x05,0x02,0x00]

v_cmp_f_u32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xc8,0xd0,0xff,0x05,0x02,0x00]

v_cmp_f_u32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xc8,0xd0,0x01,0x04,0x02,0x00]

v_cmp_f_u32_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0xc8,0xd0,0x65,0x04,0x02,0x00]

v_cmp_f_u32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xc8,0xd0,0x66,0x04,0x02,0x00]

v_cmp_f_u32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xc8,0xd0,0x67,0x04,0x02,0x00]

v_cmp_f_u32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xc8,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_f_u32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xc8,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_f_u32_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0xc8,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_f_u32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xc8,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_f_u32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xc8,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_f_u32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xc8,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_f_u32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xc8,0xd0,0x80,0x04,0x02,0x00]

v_cmp_f_u32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xc8,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_f_u32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0xc8,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_f_u32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0xc8,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_f_u32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xc8,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_f_u32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xc8,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_f_u32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xc8,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_f_u32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xc8,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_f_u32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xc8,0xd0,0x01,0xff,0x03,0x00]

v_cmp_f_u32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xc8,0xd0,0x01,0x05,0x00,0x00]

v_cmp_f_u32_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0xc8,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_f_u32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xc8,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_f_u32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xc8,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_f_u32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xc8,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_f_u32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xc8,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_f_u32_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0xc8,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_f_u32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xc8,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_f_u32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xc8,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_f_u32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xc8,0xd0,0x01,0xff,0x00,0x00]

v_cmp_f_u32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xc8,0xd0,0x01,0x01,0x01,0x00]

v_cmp_f_u32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xc8,0xd0,0x01,0x83,0x01,0x00]

v_cmp_f_u32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0xc8,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_f_u32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0xc8,0xd0,0x01,0xef,0x01,0x00]

v_cmp_f_u32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xc8,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_f_u32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xc8,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_f_u32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xc8,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_lt_u32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xc9,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_u32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xc9,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_u32_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0xc9,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_u32_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0xc9,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_u32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xc9,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_u32_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0xc9,0xd0,0x01,0x05,0x02,0x00]

v_cmp_lt_u32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xc9,0xd0,0xff,0x05,0x02,0x00]

v_cmp_lt_u32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xc9,0xd0,0x01,0x04,0x02,0x00]

v_cmp_lt_u32_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0xc9,0xd0,0x65,0x04,0x02,0x00]

v_cmp_lt_u32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xc9,0xd0,0x66,0x04,0x02,0x00]

v_cmp_lt_u32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xc9,0xd0,0x67,0x04,0x02,0x00]

v_cmp_lt_u32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xc9,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_lt_u32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xc9,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_lt_u32_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0xc9,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_lt_u32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xc9,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_lt_u32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xc9,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_lt_u32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xc9,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_lt_u32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xc9,0xd0,0x80,0x04,0x02,0x00]

v_cmp_lt_u32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xc9,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_lt_u32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0xc9,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_lt_u32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0xc9,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_lt_u32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xc9,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_lt_u32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xc9,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_lt_u32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xc9,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_lt_u32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xc9,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_lt_u32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xc9,0xd0,0x01,0xff,0x03,0x00]

v_cmp_lt_u32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xc9,0xd0,0x01,0x05,0x00,0x00]

v_cmp_lt_u32_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0xc9,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_lt_u32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xc9,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_lt_u32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xc9,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_lt_u32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xc9,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_lt_u32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xc9,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_lt_u32_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0xc9,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_lt_u32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xc9,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_lt_u32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xc9,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_lt_u32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xc9,0xd0,0x01,0xff,0x00,0x00]

v_cmp_lt_u32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xc9,0xd0,0x01,0x01,0x01,0x00]

v_cmp_lt_u32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xc9,0xd0,0x01,0x83,0x01,0x00]

v_cmp_lt_u32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0xc9,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_lt_u32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0xc9,0xd0,0x01,0xef,0x01,0x00]

v_cmp_lt_u32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xc9,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_lt_u32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xc9,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_lt_u32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xc9,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_eq_u32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xca,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_u32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xca,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_u32_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0xca,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_u32_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0xca,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_u32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xca,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_u32_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0xca,0xd0,0x01,0x05,0x02,0x00]

v_cmp_eq_u32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xca,0xd0,0xff,0x05,0x02,0x00]

v_cmp_eq_u32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xca,0xd0,0x01,0x04,0x02,0x00]

v_cmp_eq_u32_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0xca,0xd0,0x65,0x04,0x02,0x00]

v_cmp_eq_u32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xca,0xd0,0x66,0x04,0x02,0x00]

v_cmp_eq_u32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xca,0xd0,0x67,0x04,0x02,0x00]

v_cmp_eq_u32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xca,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_eq_u32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xca,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_eq_u32_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0xca,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_eq_u32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xca,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_eq_u32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xca,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_eq_u32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xca,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_eq_u32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xca,0xd0,0x80,0x04,0x02,0x00]

v_cmp_eq_u32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xca,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_eq_u32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0xca,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_eq_u32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0xca,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_eq_u32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xca,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_eq_u32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xca,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_eq_u32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xca,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_eq_u32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xca,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_eq_u32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xca,0xd0,0x01,0xff,0x03,0x00]

v_cmp_eq_u32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xca,0xd0,0x01,0x05,0x00,0x00]

v_cmp_eq_u32_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0xca,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_eq_u32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xca,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_eq_u32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xca,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_eq_u32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xca,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_eq_u32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xca,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_eq_u32_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0xca,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_eq_u32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xca,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_eq_u32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xca,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_eq_u32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xca,0xd0,0x01,0xff,0x00,0x00]

v_cmp_eq_u32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xca,0xd0,0x01,0x01,0x01,0x00]

v_cmp_eq_u32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xca,0xd0,0x01,0x83,0x01,0x00]

v_cmp_eq_u32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0xca,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_eq_u32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0xca,0xd0,0x01,0xef,0x01,0x00]

v_cmp_eq_u32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xca,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_eq_u32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xca,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_eq_u32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xca,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_le_u32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xcb,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_u32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xcb,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_u32_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0xcb,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_u32_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0xcb,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_u32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xcb,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_u32_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0xcb,0xd0,0x01,0x05,0x02,0x00]

v_cmp_le_u32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xcb,0xd0,0xff,0x05,0x02,0x00]

v_cmp_le_u32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xcb,0xd0,0x01,0x04,0x02,0x00]

v_cmp_le_u32_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0xcb,0xd0,0x65,0x04,0x02,0x00]

v_cmp_le_u32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xcb,0xd0,0x66,0x04,0x02,0x00]

v_cmp_le_u32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xcb,0xd0,0x67,0x04,0x02,0x00]

v_cmp_le_u32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xcb,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_le_u32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xcb,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_le_u32_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0xcb,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_le_u32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xcb,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_le_u32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xcb,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_le_u32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xcb,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_le_u32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xcb,0xd0,0x80,0x04,0x02,0x00]

v_cmp_le_u32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xcb,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_le_u32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0xcb,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_le_u32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0xcb,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_le_u32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xcb,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_le_u32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xcb,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_le_u32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xcb,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_le_u32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xcb,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_le_u32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xcb,0xd0,0x01,0xff,0x03,0x00]

v_cmp_le_u32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xcb,0xd0,0x01,0x05,0x00,0x00]

v_cmp_le_u32_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0xcb,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_le_u32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xcb,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_le_u32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xcb,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_le_u32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xcb,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_le_u32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xcb,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_le_u32_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0xcb,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_le_u32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xcb,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_le_u32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xcb,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_le_u32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xcb,0xd0,0x01,0xff,0x00,0x00]

v_cmp_le_u32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xcb,0xd0,0x01,0x01,0x01,0x00]

v_cmp_le_u32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xcb,0xd0,0x01,0x83,0x01,0x00]

v_cmp_le_u32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0xcb,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_le_u32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0xcb,0xd0,0x01,0xef,0x01,0x00]

v_cmp_le_u32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xcb,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_le_u32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xcb,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_le_u32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xcb,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_gt_u32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xcc,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_u32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xcc,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_u32_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0xcc,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_u32_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0xcc,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_u32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xcc,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_u32_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0xcc,0xd0,0x01,0x05,0x02,0x00]

v_cmp_gt_u32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xcc,0xd0,0xff,0x05,0x02,0x00]

v_cmp_gt_u32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xcc,0xd0,0x01,0x04,0x02,0x00]

v_cmp_gt_u32_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0xcc,0xd0,0x65,0x04,0x02,0x00]

v_cmp_gt_u32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xcc,0xd0,0x66,0x04,0x02,0x00]

v_cmp_gt_u32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xcc,0xd0,0x67,0x04,0x02,0x00]

v_cmp_gt_u32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xcc,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_gt_u32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xcc,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_gt_u32_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0xcc,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_gt_u32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xcc,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_gt_u32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xcc,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_gt_u32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xcc,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_gt_u32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xcc,0xd0,0x80,0x04,0x02,0x00]

v_cmp_gt_u32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xcc,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_gt_u32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0xcc,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_gt_u32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0xcc,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_gt_u32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xcc,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_gt_u32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xcc,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_gt_u32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xcc,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_gt_u32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xcc,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_gt_u32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xcc,0xd0,0x01,0xff,0x03,0x00]

v_cmp_gt_u32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xcc,0xd0,0x01,0x05,0x00,0x00]

v_cmp_gt_u32_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0xcc,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_gt_u32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xcc,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_gt_u32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xcc,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_gt_u32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xcc,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_gt_u32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xcc,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_gt_u32_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0xcc,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_gt_u32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xcc,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_gt_u32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xcc,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_gt_u32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xcc,0xd0,0x01,0xff,0x00,0x00]

v_cmp_gt_u32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xcc,0xd0,0x01,0x01,0x01,0x00]

v_cmp_gt_u32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xcc,0xd0,0x01,0x83,0x01,0x00]

v_cmp_gt_u32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0xcc,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_gt_u32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0xcc,0xd0,0x01,0xef,0x01,0x00]

v_cmp_gt_u32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xcc,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_gt_u32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xcc,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_gt_u32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xcc,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_ne_u32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xcd,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ne_u32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xcd,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ne_u32_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0xcd,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ne_u32_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0xcd,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ne_u32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xcd,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ne_u32_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0xcd,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ne_u32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xcd,0xd0,0xff,0x05,0x02,0x00]

v_cmp_ne_u32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xcd,0xd0,0x01,0x04,0x02,0x00]

v_cmp_ne_u32_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0xcd,0xd0,0x65,0x04,0x02,0x00]

v_cmp_ne_u32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xcd,0xd0,0x66,0x04,0x02,0x00]

v_cmp_ne_u32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xcd,0xd0,0x67,0x04,0x02,0x00]

v_cmp_ne_u32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xcd,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_ne_u32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xcd,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_ne_u32_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0xcd,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_ne_u32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xcd,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_ne_u32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xcd,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_ne_u32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xcd,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_ne_u32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xcd,0xd0,0x80,0x04,0x02,0x00]

v_cmp_ne_u32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xcd,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_ne_u32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0xcd,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_ne_u32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0xcd,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_ne_u32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xcd,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_ne_u32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xcd,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_ne_u32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xcd,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_ne_u32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xcd,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_ne_u32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xcd,0xd0,0x01,0xff,0x03,0x00]

v_cmp_ne_u32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xcd,0xd0,0x01,0x05,0x00,0x00]

v_cmp_ne_u32_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0xcd,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_ne_u32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xcd,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_ne_u32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xcd,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_ne_u32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xcd,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_ne_u32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xcd,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_ne_u32_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0xcd,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_ne_u32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xcd,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_ne_u32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xcd,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_ne_u32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xcd,0xd0,0x01,0xff,0x00,0x00]

v_cmp_ne_u32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xcd,0xd0,0x01,0x01,0x01,0x00]

v_cmp_ne_u32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xcd,0xd0,0x01,0x83,0x01,0x00]

v_cmp_ne_u32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0xcd,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_ne_u32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0xcd,0xd0,0x01,0xef,0x01,0x00]

v_cmp_ne_u32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xcd,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_ne_u32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xcd,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_ne_u32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xcd,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_ge_u32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xce,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_u32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xce,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_u32_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0xce,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_u32_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0xce,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_u32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xce,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_u32_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0xce,0xd0,0x01,0x05,0x02,0x00]

v_cmp_ge_u32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xce,0xd0,0xff,0x05,0x02,0x00]

v_cmp_ge_u32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xce,0xd0,0x01,0x04,0x02,0x00]

v_cmp_ge_u32_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0xce,0xd0,0x65,0x04,0x02,0x00]

v_cmp_ge_u32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xce,0xd0,0x66,0x04,0x02,0x00]

v_cmp_ge_u32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xce,0xd0,0x67,0x04,0x02,0x00]

v_cmp_ge_u32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xce,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_ge_u32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xce,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_ge_u32_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0xce,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_ge_u32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xce,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_ge_u32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xce,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_ge_u32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xce,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_ge_u32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xce,0xd0,0x80,0x04,0x02,0x00]

v_cmp_ge_u32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xce,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_ge_u32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0xce,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_ge_u32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0xce,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_ge_u32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xce,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_ge_u32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xce,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_ge_u32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xce,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_ge_u32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xce,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_ge_u32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xce,0xd0,0x01,0xff,0x03,0x00]

v_cmp_ge_u32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xce,0xd0,0x01,0x05,0x00,0x00]

v_cmp_ge_u32_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0xce,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_ge_u32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xce,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_ge_u32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xce,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_ge_u32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xce,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_ge_u32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xce,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_ge_u32_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0xce,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_ge_u32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xce,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_ge_u32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xce,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_ge_u32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xce,0xd0,0x01,0xff,0x00,0x00]

v_cmp_ge_u32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xce,0xd0,0x01,0x01,0x01,0x00]

v_cmp_ge_u32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xce,0xd0,0x01,0x83,0x01,0x00]

v_cmp_ge_u32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0xce,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_ge_u32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0xce,0xd0,0x01,0xef,0x01,0x00]

v_cmp_ge_u32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xce,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_ge_u32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xce,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_ge_u32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xce,0xd0,0x01,0xfb,0x01,0x00]

v_cmp_t_u32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xcf,0xd0,0x01,0x05,0x02,0x00]

v_cmp_t_u32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xcf,0xd0,0x01,0x05,0x02,0x00]

v_cmp_t_u32_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0xcf,0xd0,0x01,0x05,0x02,0x00]

v_cmp_t_u32_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0xcf,0xd0,0x01,0x05,0x02,0x00]

v_cmp_t_u32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xcf,0xd0,0x01,0x05,0x02,0x00]

v_cmp_t_u32_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0xcf,0xd0,0x01,0x05,0x02,0x00]

v_cmp_t_u32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xcf,0xd0,0xff,0x05,0x02,0x00]

v_cmp_t_u32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xcf,0xd0,0x01,0x04,0x02,0x00]

v_cmp_t_u32_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0xcf,0xd0,0x65,0x04,0x02,0x00]

v_cmp_t_u32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xcf,0xd0,0x66,0x04,0x02,0x00]

v_cmp_t_u32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xcf,0xd0,0x67,0x04,0x02,0x00]

v_cmp_t_u32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xcf,0xd0,0x6a,0x04,0x02,0x00]

v_cmp_t_u32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xcf,0xd0,0x6b,0x04,0x02,0x00]

v_cmp_t_u32_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0xcf,0xd0,0x7b,0x04,0x02,0x00]

v_cmp_t_u32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xcf,0xd0,0x7c,0x04,0x02,0x00]

v_cmp_t_u32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xcf,0xd0,0x7e,0x04,0x02,0x00]

v_cmp_t_u32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xcf,0xd0,0x7f,0x04,0x02,0x00]

v_cmp_t_u32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xcf,0xd0,0x80,0x04,0x02,0x00]

v_cmp_t_u32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xcf,0xd0,0xc1,0x04,0x02,0x00]

v_cmp_t_u32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0xcf,0xd0,0xf0,0x04,0x02,0x00]

v_cmp_t_u32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0xcf,0xd0,0xf7,0x04,0x02,0x00]

v_cmp_t_u32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xcf,0xd0,0xfb,0x04,0x02,0x00]

v_cmp_t_u32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xcf,0xd0,0xfc,0x04,0x02,0x00]

v_cmp_t_u32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xcf,0xd0,0xfd,0x04,0x02,0x00]

v_cmp_t_u32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xcf,0xd0,0xfe,0x04,0x02,0x00]

v_cmp_t_u32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xcf,0xd0,0x01,0xff,0x03,0x00]

v_cmp_t_u32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xcf,0xd0,0x01,0x05,0x00,0x00]

v_cmp_t_u32_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0xcf,0xd0,0x01,0xcb,0x00,0x00]

v_cmp_t_u32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xcf,0xd0,0x01,0xcd,0x00,0x00]

v_cmp_t_u32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xcf,0xd0,0x01,0xcf,0x00,0x00]

v_cmp_t_u32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xcf,0xd0,0x01,0xd5,0x00,0x00]

v_cmp_t_u32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xcf,0xd0,0x01,0xd7,0x00,0x00]

v_cmp_t_u32_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0xcf,0xd0,0x01,0xf7,0x00,0x00]

v_cmp_t_u32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xcf,0xd0,0x01,0xf9,0x00,0x00]

v_cmp_t_u32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xcf,0xd0,0x01,0xfd,0x00,0x00]

v_cmp_t_u32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xcf,0xd0,0x01,0xff,0x00,0x00]

v_cmp_t_u32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xcf,0xd0,0x01,0x01,0x01,0x00]

v_cmp_t_u32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xcf,0xd0,0x01,0x83,0x01,0x00]

v_cmp_t_u32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0xcf,0xd0,0x01,0xe1,0x01,0x00]

v_cmp_t_u32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0xcf,0xd0,0x01,0xef,0x01,0x00]

v_cmp_t_u32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xcf,0xd0,0x01,0xf7,0x01,0x00]

v_cmp_t_u32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xcf,0xd0,0x01,0xf9,0x01,0x00]

v_cmp_t_u32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xcf,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_f_i32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xd0,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_i32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xd0,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_i32_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0xd0,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_i32_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0xd0,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_i32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xd0,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_i32_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0xd0,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_i32_e64 exec, v1, v2
// CHECK: [0x7e,0x00,0xd0,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_i32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xd0,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_f_i32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xd0,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_f_i32_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0xd0,0xd0,0x65,0x04,0x02,0x00]

v_cmpx_f_i32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xd0,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_f_i32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xd0,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_f_i32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xd0,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_f_i32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xd0,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_f_i32_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0xd0,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_f_i32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xd0,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_f_i32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xd0,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_f_i32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xd0,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_f_i32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xd0,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_f_i32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xd0,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_f_i32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0xd0,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_f_i32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0xd0,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_f_i32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xd0,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_f_i32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xd0,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_f_i32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xd0,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_f_i32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xd0,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_f_i32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xd0,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_f_i32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xd0,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_f_i32_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0xd0,0xd0,0x01,0xcb,0x00,0x00]

v_cmpx_f_i32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xd0,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_f_i32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xd0,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_f_i32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xd0,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_f_i32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xd0,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_f_i32_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0xd0,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_f_i32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xd0,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_f_i32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xd0,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_f_i32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xd0,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_f_i32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xd0,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_f_i32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xd0,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_f_i32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0xd0,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_f_i32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0xd0,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_f_i32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xd0,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_f_i32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xd0,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_f_i32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xd0,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_lt_i32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xd1,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_i32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xd1,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_i32_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0xd1,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_i32_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0xd1,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_i32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xd1,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_i32_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0xd1,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_i32_e64 exec, v1, v2
// CHECK: [0x7e,0x00,0xd1,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_i32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xd1,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_lt_i32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xd1,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_lt_i32_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0xd1,0xd0,0x65,0x04,0x02,0x00]

v_cmpx_lt_i32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xd1,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_lt_i32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xd1,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_lt_i32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xd1,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_lt_i32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xd1,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_lt_i32_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0xd1,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_lt_i32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xd1,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_lt_i32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xd1,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_lt_i32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xd1,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_lt_i32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xd1,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_lt_i32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xd1,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_lt_i32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0xd1,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_lt_i32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0xd1,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_lt_i32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xd1,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_lt_i32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xd1,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_lt_i32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xd1,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_lt_i32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xd1,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_lt_i32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xd1,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_lt_i32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xd1,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_lt_i32_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0xd1,0xd0,0x01,0xcb,0x00,0x00]

v_cmpx_lt_i32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xd1,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_lt_i32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xd1,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_lt_i32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xd1,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_lt_i32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xd1,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_lt_i32_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0xd1,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_lt_i32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xd1,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_lt_i32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xd1,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_lt_i32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xd1,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_lt_i32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xd1,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_lt_i32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xd1,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_lt_i32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0xd1,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_lt_i32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0xd1,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_lt_i32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xd1,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_lt_i32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xd1,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_lt_i32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xd1,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_eq_i32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xd2,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_i32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xd2,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_i32_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0xd2,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_i32_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0xd2,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_i32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xd2,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_i32_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0xd2,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_i32_e64 exec, v1, v2
// CHECK: [0x7e,0x00,0xd2,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_i32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xd2,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_eq_i32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xd2,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_eq_i32_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0xd2,0xd0,0x65,0x04,0x02,0x00]

v_cmpx_eq_i32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xd2,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_eq_i32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xd2,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_eq_i32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xd2,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_eq_i32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xd2,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_eq_i32_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0xd2,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_eq_i32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xd2,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_eq_i32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xd2,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_eq_i32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xd2,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_eq_i32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xd2,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_eq_i32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xd2,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_eq_i32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0xd2,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_eq_i32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0xd2,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_eq_i32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xd2,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_eq_i32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xd2,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_eq_i32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xd2,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_eq_i32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xd2,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_eq_i32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xd2,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_eq_i32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xd2,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_eq_i32_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0xd2,0xd0,0x01,0xcb,0x00,0x00]

v_cmpx_eq_i32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xd2,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_eq_i32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xd2,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_eq_i32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xd2,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_eq_i32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xd2,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_eq_i32_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0xd2,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_eq_i32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xd2,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_eq_i32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xd2,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_eq_i32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xd2,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_eq_i32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xd2,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_eq_i32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xd2,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_eq_i32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0xd2,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_eq_i32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0xd2,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_eq_i32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xd2,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_eq_i32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xd2,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_eq_i32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xd2,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_le_i32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xd3,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_i32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xd3,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_i32_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0xd3,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_i32_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0xd3,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_i32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xd3,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_i32_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0xd3,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_i32_e64 exec, v1, v2
// CHECK: [0x7e,0x00,0xd3,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_i32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xd3,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_le_i32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xd3,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_le_i32_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0xd3,0xd0,0x65,0x04,0x02,0x00]

v_cmpx_le_i32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xd3,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_le_i32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xd3,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_le_i32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xd3,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_le_i32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xd3,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_le_i32_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0xd3,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_le_i32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xd3,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_le_i32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xd3,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_le_i32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xd3,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_le_i32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xd3,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_le_i32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xd3,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_le_i32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0xd3,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_le_i32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0xd3,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_le_i32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xd3,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_le_i32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xd3,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_le_i32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xd3,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_le_i32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xd3,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_le_i32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xd3,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_le_i32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xd3,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_le_i32_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0xd3,0xd0,0x01,0xcb,0x00,0x00]

v_cmpx_le_i32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xd3,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_le_i32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xd3,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_le_i32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xd3,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_le_i32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xd3,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_le_i32_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0xd3,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_le_i32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xd3,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_le_i32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xd3,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_le_i32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xd3,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_le_i32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xd3,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_le_i32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xd3,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_le_i32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0xd3,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_le_i32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0xd3,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_le_i32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xd3,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_le_i32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xd3,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_le_i32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xd3,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_gt_i32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xd4,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_i32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xd4,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_i32_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0xd4,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_i32_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0xd4,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_i32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xd4,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_i32_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0xd4,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_i32_e64 exec, v1, v2
// CHECK: [0x7e,0x00,0xd4,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_gt_i32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xd4,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_gt_i32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xd4,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_gt_i32_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0xd4,0xd0,0x65,0x04,0x02,0x00]

v_cmpx_gt_i32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xd4,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_gt_i32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xd4,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_gt_i32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xd4,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_gt_i32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xd4,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_gt_i32_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0xd4,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_gt_i32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xd4,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_gt_i32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xd4,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_gt_i32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xd4,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_gt_i32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xd4,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_gt_i32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xd4,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_gt_i32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0xd4,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_gt_i32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0xd4,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_gt_i32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xd4,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_gt_i32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xd4,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_gt_i32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xd4,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_gt_i32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xd4,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_gt_i32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xd4,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_gt_i32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xd4,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_gt_i32_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0xd4,0xd0,0x01,0xcb,0x00,0x00]

v_cmpx_gt_i32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xd4,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_gt_i32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xd4,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_gt_i32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xd4,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_gt_i32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xd4,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_gt_i32_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0xd4,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_gt_i32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xd4,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_gt_i32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xd4,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_gt_i32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xd4,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_gt_i32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xd4,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_gt_i32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xd4,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_gt_i32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0xd4,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_gt_i32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0xd4,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_gt_i32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xd4,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_gt_i32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xd4,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_gt_i32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xd4,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_ne_i32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xd5,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ne_i32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xd5,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ne_i32_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0xd5,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ne_i32_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0xd5,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ne_i32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xd5,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ne_i32_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0xd5,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ne_i32_e64 exec, v1, v2
// CHECK: [0x7e,0x00,0xd5,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ne_i32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xd5,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_ne_i32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xd5,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_ne_i32_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0xd5,0xd0,0x65,0x04,0x02,0x00]

v_cmpx_ne_i32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xd5,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_ne_i32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xd5,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_ne_i32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xd5,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_ne_i32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xd5,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_ne_i32_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0xd5,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_ne_i32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xd5,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_ne_i32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xd5,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_ne_i32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xd5,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_ne_i32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xd5,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_ne_i32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xd5,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_ne_i32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0xd5,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_ne_i32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0xd5,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_ne_i32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xd5,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_ne_i32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xd5,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_ne_i32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xd5,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_ne_i32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xd5,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_ne_i32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xd5,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_ne_i32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xd5,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_ne_i32_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0xd5,0xd0,0x01,0xcb,0x00,0x00]

v_cmpx_ne_i32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xd5,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_ne_i32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xd5,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_ne_i32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xd5,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_ne_i32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xd5,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_ne_i32_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0xd5,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_ne_i32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xd5,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_ne_i32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xd5,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_ne_i32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xd5,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_ne_i32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xd5,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_ne_i32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xd5,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_ne_i32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0xd5,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_ne_i32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0xd5,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_ne_i32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xd5,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_ne_i32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xd5,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_ne_i32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xd5,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_ge_i32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xd6,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_i32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xd6,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_i32_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0xd6,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_i32_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0xd6,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_i32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xd6,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_i32_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0xd6,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_i32_e64 exec, v1, v2
// CHECK: [0x7e,0x00,0xd6,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_ge_i32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xd6,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_ge_i32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xd6,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_ge_i32_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0xd6,0xd0,0x65,0x04,0x02,0x00]

v_cmpx_ge_i32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xd6,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_ge_i32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xd6,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_ge_i32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xd6,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_ge_i32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xd6,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_ge_i32_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0xd6,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_ge_i32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xd6,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_ge_i32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xd6,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_ge_i32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xd6,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_ge_i32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xd6,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_ge_i32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xd6,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_ge_i32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0xd6,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_ge_i32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0xd6,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_ge_i32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xd6,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_ge_i32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xd6,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_ge_i32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xd6,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_ge_i32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xd6,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_ge_i32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xd6,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_ge_i32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xd6,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_ge_i32_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0xd6,0xd0,0x01,0xcb,0x00,0x00]

v_cmpx_ge_i32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xd6,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_ge_i32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xd6,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_ge_i32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xd6,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_ge_i32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xd6,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_ge_i32_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0xd6,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_ge_i32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xd6,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_ge_i32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xd6,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_ge_i32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xd6,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_ge_i32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xd6,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_ge_i32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xd6,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_ge_i32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0xd6,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_ge_i32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0xd6,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_ge_i32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xd6,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_ge_i32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xd6,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_ge_i32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xd6,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_t_i32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xd7,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_t_i32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xd7,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_t_i32_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0xd7,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_t_i32_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0xd7,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_t_i32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xd7,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_t_i32_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0xd7,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_t_i32_e64 exec, v1, v2
// CHECK: [0x7e,0x00,0xd7,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_t_i32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xd7,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_t_i32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xd7,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_t_i32_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0xd7,0xd0,0x65,0x04,0x02,0x00]

v_cmpx_t_i32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xd7,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_t_i32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xd7,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_t_i32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xd7,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_t_i32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xd7,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_t_i32_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0xd7,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_t_i32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xd7,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_t_i32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xd7,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_t_i32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xd7,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_t_i32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xd7,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_t_i32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xd7,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_t_i32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0xd7,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_t_i32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0xd7,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_t_i32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xd7,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_t_i32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xd7,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_t_i32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xd7,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_t_i32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xd7,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_t_i32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xd7,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_t_i32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xd7,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_t_i32_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0xd7,0xd0,0x01,0xcb,0x00,0x00]

v_cmpx_t_i32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xd7,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_t_i32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xd7,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_t_i32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xd7,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_t_i32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xd7,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_t_i32_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0xd7,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_t_i32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xd7,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_t_i32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xd7,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_t_i32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xd7,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_t_i32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xd7,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_t_i32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xd7,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_t_i32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0xd7,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_t_i32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0xd7,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_t_i32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xd7,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_t_i32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xd7,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_t_i32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xd7,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_f_u32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xd8,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_u32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xd8,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_u32_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0xd8,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_u32_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0xd8,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_u32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xd8,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_u32_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0xd8,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_u32_e64 exec, v1, v2
// CHECK: [0x7e,0x00,0xd8,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_f_u32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xd8,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_f_u32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xd8,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_f_u32_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0xd8,0xd0,0x65,0x04,0x02,0x00]

v_cmpx_f_u32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xd8,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_f_u32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xd8,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_f_u32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xd8,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_f_u32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xd8,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_f_u32_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0xd8,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_f_u32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xd8,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_f_u32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xd8,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_f_u32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xd8,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_f_u32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xd8,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_f_u32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xd8,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_f_u32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0xd8,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_f_u32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0xd8,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_f_u32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xd8,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_f_u32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xd8,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_f_u32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xd8,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_f_u32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xd8,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_f_u32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xd8,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_f_u32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xd8,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_f_u32_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0xd8,0xd0,0x01,0xcb,0x00,0x00]

v_cmpx_f_u32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xd8,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_f_u32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xd8,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_f_u32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xd8,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_f_u32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xd8,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_f_u32_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0xd8,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_f_u32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xd8,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_f_u32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xd8,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_f_u32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xd8,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_f_u32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xd8,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_f_u32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xd8,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_f_u32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0xd8,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_f_u32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0xd8,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_f_u32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xd8,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_f_u32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xd8,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_f_u32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xd8,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_lt_u32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xd9,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_u32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xd9,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_u32_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0xd9,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_u32_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0xd9,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_u32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xd9,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_u32_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0xd9,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_u32_e64 exec, v1, v2
// CHECK: [0x7e,0x00,0xd9,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_lt_u32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xd9,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_lt_u32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xd9,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_lt_u32_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0xd9,0xd0,0x65,0x04,0x02,0x00]

v_cmpx_lt_u32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xd9,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_lt_u32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xd9,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_lt_u32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xd9,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_lt_u32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xd9,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_lt_u32_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0xd9,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_lt_u32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xd9,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_lt_u32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xd9,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_lt_u32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xd9,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_lt_u32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xd9,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_lt_u32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xd9,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_lt_u32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0xd9,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_lt_u32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0xd9,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_lt_u32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xd9,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_lt_u32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xd9,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_lt_u32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xd9,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_lt_u32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xd9,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_lt_u32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xd9,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_lt_u32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xd9,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_lt_u32_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0xd9,0xd0,0x01,0xcb,0x00,0x00]

v_cmpx_lt_u32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xd9,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_lt_u32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xd9,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_lt_u32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xd9,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_lt_u32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xd9,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_lt_u32_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0xd9,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_lt_u32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xd9,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_lt_u32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xd9,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_lt_u32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xd9,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_lt_u32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xd9,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_lt_u32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xd9,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_lt_u32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0xd9,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_lt_u32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0xd9,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_lt_u32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xd9,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_lt_u32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xd9,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_lt_u32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xd9,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_eq_u32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xda,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_u32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xda,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_u32_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0xda,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_u32_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0xda,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_u32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xda,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_u32_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0xda,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_u32_e64 exec, v1, v2
// CHECK: [0x7e,0x00,0xda,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_eq_u32_e64 s[10:11], v255, v2
// CHECK: [0x0a,0x00,0xda,0xd0,0xff,0x05,0x02,0x00]

v_cmpx_eq_u32_e64 s[10:11], s1, v2
// CHECK: [0x0a,0x00,0xda,0xd0,0x01,0x04,0x02,0x00]

v_cmpx_eq_u32_e64 s[10:11], s101, v2
// CHECK: [0x0a,0x00,0xda,0xd0,0x65,0x04,0x02,0x00]

v_cmpx_eq_u32_e64 s[10:11], flat_scratch_lo, v2
// CHECK: [0x0a,0x00,0xda,0xd0,0x66,0x04,0x02,0x00]

v_cmpx_eq_u32_e64 s[10:11], flat_scratch_hi, v2
// CHECK: [0x0a,0x00,0xda,0xd0,0x67,0x04,0x02,0x00]

v_cmpx_eq_u32_e64 s[10:11], vcc_lo, v2
// CHECK: [0x0a,0x00,0xda,0xd0,0x6a,0x04,0x02,0x00]

v_cmpx_eq_u32_e64 s[10:11], vcc_hi, v2
// CHECK: [0x0a,0x00,0xda,0xd0,0x6b,0x04,0x02,0x00]

v_cmpx_eq_u32_e64 s[10:11], ttmp15, v2
// CHECK: [0x0a,0x00,0xda,0xd0,0x7b,0x04,0x02,0x00]

v_cmpx_eq_u32_e64 s[10:11], m0, v2
// CHECK: [0x0a,0x00,0xda,0xd0,0x7c,0x04,0x02,0x00]

v_cmpx_eq_u32_e64 s[10:11], exec_lo, v2
// CHECK: [0x0a,0x00,0xda,0xd0,0x7e,0x04,0x02,0x00]

v_cmpx_eq_u32_e64 s[10:11], exec_hi, v2
// CHECK: [0x0a,0x00,0xda,0xd0,0x7f,0x04,0x02,0x00]

v_cmpx_eq_u32_e64 s[10:11], 0, v2
// CHECK: [0x0a,0x00,0xda,0xd0,0x80,0x04,0x02,0x00]

v_cmpx_eq_u32_e64 s[10:11], -1, v2
// CHECK: [0x0a,0x00,0xda,0xd0,0xc1,0x04,0x02,0x00]

v_cmpx_eq_u32_e64 s[10:11], 0.5, v2
// CHECK: [0x0a,0x00,0xda,0xd0,0xf0,0x04,0x02,0x00]

v_cmpx_eq_u32_e64 s[10:11], -4.0, v2
// CHECK: [0x0a,0x00,0xda,0xd0,0xf7,0x04,0x02,0x00]

v_cmpx_eq_u32_e64 s[10:11], src_vccz, v2
// CHECK: [0x0a,0x00,0xda,0xd0,0xfb,0x04,0x02,0x00]

v_cmpx_eq_u32_e64 s[10:11], src_execz, v2
// CHECK: [0x0a,0x00,0xda,0xd0,0xfc,0x04,0x02,0x00]

v_cmpx_eq_u32_e64 s[10:11], src_scc, v2
// CHECK: [0x0a,0x00,0xda,0xd0,0xfd,0x04,0x02,0x00]

v_cmpx_eq_u32_e64 s[10:11], src_lds_direct, v2
// CHECK: [0x0a,0x00,0xda,0xd0,0xfe,0x04,0x02,0x00]

v_cmpx_eq_u32_e64 s[10:11], v1, v255
// CHECK: [0x0a,0x00,0xda,0xd0,0x01,0xff,0x03,0x00]

v_cmpx_eq_u32_e64 s[10:11], v1, s2
// CHECK: [0x0a,0x00,0xda,0xd0,0x01,0x05,0x00,0x00]

v_cmpx_eq_u32_e64 s[10:11], v1, s101
// CHECK: [0x0a,0x00,0xda,0xd0,0x01,0xcb,0x00,0x00]

v_cmpx_eq_u32_e64 s[10:11], v1, flat_scratch_lo
// CHECK: [0x0a,0x00,0xda,0xd0,0x01,0xcd,0x00,0x00]

v_cmpx_eq_u32_e64 s[10:11], v1, flat_scratch_hi
// CHECK: [0x0a,0x00,0xda,0xd0,0x01,0xcf,0x00,0x00]

v_cmpx_eq_u32_e64 s[10:11], v1, vcc_lo
// CHECK: [0x0a,0x00,0xda,0xd0,0x01,0xd5,0x00,0x00]

v_cmpx_eq_u32_e64 s[10:11], v1, vcc_hi
// CHECK: [0x0a,0x00,0xda,0xd0,0x01,0xd7,0x00,0x00]

v_cmpx_eq_u32_e64 s[10:11], v1, ttmp15
// CHECK: [0x0a,0x00,0xda,0xd0,0x01,0xf7,0x00,0x00]

v_cmpx_eq_u32_e64 s[10:11], v1, m0
// CHECK: [0x0a,0x00,0xda,0xd0,0x01,0xf9,0x00,0x00]

v_cmpx_eq_u32_e64 s[10:11], v1, exec_lo
// CHECK: [0x0a,0x00,0xda,0xd0,0x01,0xfd,0x00,0x00]

v_cmpx_eq_u32_e64 s[10:11], v1, exec_hi
// CHECK: [0x0a,0x00,0xda,0xd0,0x01,0xff,0x00,0x00]

v_cmpx_eq_u32_e64 s[10:11], v1, 0
// CHECK: [0x0a,0x00,0xda,0xd0,0x01,0x01,0x01,0x00]

v_cmpx_eq_u32_e64 s[10:11], v1, -1
// CHECK: [0x0a,0x00,0xda,0xd0,0x01,0x83,0x01,0x00]

v_cmpx_eq_u32_e64 s[10:11], v1, 0.5
// CHECK: [0x0a,0x00,0xda,0xd0,0x01,0xe1,0x01,0x00]

v_cmpx_eq_u32_e64 s[10:11], v1, -4.0
// CHECK: [0x0a,0x00,0xda,0xd0,0x01,0xef,0x01,0x00]

v_cmpx_eq_u32_e64 s[10:11], v1, src_vccz
// CHECK: [0x0a,0x00,0xda,0xd0,0x01,0xf7,0x01,0x00]

v_cmpx_eq_u32_e64 s[10:11], v1, src_execz
// CHECK: [0x0a,0x00,0xda,0xd0,0x01,0xf9,0x01,0x00]

v_cmpx_eq_u32_e64 s[10:11], v1, src_scc
// CHECK: [0x0a,0x00,0xda,0xd0,0x01,0xfb,0x01,0x00]

v_cmpx_le_u32_e64 s[10:11], v1, v2
// CHECK: [0x0a,0x00,0xdb,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_u32_e64 s[12:13], v1, v2
// CHECK: [0x0c,0x00,0xdb,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_u32_e64 s[100:101], v1, v2
// CHECK: [0x64,0x00,0xdb,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_u32_e64 flat_scratch, v1, v2
// CHECK: [0x66,0x00,0xdb,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_u32_e64 vcc, v1, v2
// CHECK: [0x6a,0x00,0xdb,0xd0,0x01,0x05,0x02,0x00]

v_cmpx_le_u32_e64 ttmp[14:15], v1, v2
// CHECK: [0x7a,0x00,0xdb,0xd0,0x01,0x05,0x02,