; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 3
; RUN: opt < %s -loop-reduce -S | FileCheck %s

target datalayout = "e-m:e-p:32:32-i64:64-v128:64:128-a:0:32-n32-S64"
target triple = "thumbv6m-arm-none-eabi"

; These are regression tests for
;  https://bugs.llvm.org/show_bug.cgi?id=34106
;    "ARMTargetLowering::isLegalAddressingMode can accept incorrect
;    addressing modes for Thumb1 target"
;  https://reviews.llvm.org/D34583
;    "[LSR] Narrow search space by filtering non-optimal formulae with the
;    same ScaledReg and Scale."
;
; Due to a bug in ARMTargetLowering::isLegalAddressingMode LSR got
; 4*reg({0,+,-1}) and -4*reg({0,+,-1}) had the same cost for the Thumb1 target.
; Another issue was that LSR got that -1*reg was free for the Thumb1 target.

; Test case 01: -1*reg is not free for the Thumb1 target.
define ptr @negativeOneCase(ptr returned %a, ptr nocapture readonly %b, i32 %n) nounwind {
; CHECK-LABEL: define ptr @negativeOneCase
; CHECK-SAME: (ptr returned [[A:%.*]], ptr nocapture readonly [[B:%.*]], i32 [[N:%.*]]) #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADD_PTR:%.*]] = getelementptr inbounds i8, ptr [[A]], i32 -1
; CHECK-NEXT:    br label [[WHILE_COND:%.*]]
; CHECK:       while.cond:
; CHECK-NEXT:    [[P_0:%.*]] = phi ptr [ [[ADD_PTR]], [[ENTRY:%.*]] ], [ [[INCDEC_PTR:%.*]], [[WHILE_COND]] ]
; CHECK-NEXT:    [[INCDEC_PTR]] = getelementptr inbounds i8, ptr [[P_0]], i32 1
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[INCDEC_PTR]], align 1
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i8 [[TMP0]], 0
; CHECK-NEXT:    br i1 [[CMP]], label [[WHILE_COND2_PREHEADER:%.*]], label [[WHILE_COND]]
; CHECK:       while.cond2.preheader:
; CHECK-NEXT:    br label [[WHILE_COND2:%.*]]
; CHECK:       while.cond2:
; CHECK-NEXT:    [[LSR_IV:%.*]] = phi i32 [ [[LSR_IV_NEXT:%.*]], [[WHILE_BODY5:%.*]] ], [ 0, [[WHILE_COND2_PREHEADER]] ]
; CHECK-NEXT:    [[SCEVGEP1:%.*]] = getelementptr i8, ptr [[B]], i32 [[LSR_IV]]
; CHECK-NEXT:    [[SCEVGEP2:%.*]] = getelementptr i8, ptr [[INCDEC_PTR]], i32 [[LSR_IV]]
; CHECK-NEXT:    [[CMP3:%.*]] = icmp eq i32 [[N]], [[LSR_IV]]
; CHECK-NEXT:    br i1 [[CMP3]], label [[WHILE_END8:%.*]], label [[WHILE_BODY5]]
; CHECK:       while.body5:
; CHECK-NEXT:    [[TMP1:%.*]] = load i8, ptr [[SCEVGEP1]], align 1
; CHECK-NEXT:    store i8 [[TMP1]], ptr [[SCEVGEP2]], align 1
; CHECK-NEXT:    [[LSR_IV_NEXT]] = add i32 [[LSR_IV]], 1
; CHECK-NEXT:    br label [[WHILE_COND2]]
; CHECK:       while.end8:
; CHECK-NEXT:    [[SCEVGEP:%.*]] = getelementptr i8, ptr [[INCDEC_PTR]], i32 [[N]]
; CHECK-NEXT:    store i8 0, ptr [[SCEVGEP]], align 1
; CHECK-NEXT:    ret ptr [[A]]
;
entry:
  %add.ptr = getelementptr inbounds i8, ptr %a, i32 -1
  br label %while.cond

while.cond:                                       ; preds = %while.cond, %entry
  %p.0 = phi ptr [ %add.ptr, %entry ], [ %incdec.ptr, %while.cond ]
  %incdec.ptr = getelementptr inbounds i8, ptr %p.0, i32 1
  %0 = load i8, ptr %incdec.ptr, align 1
  %cmp = icmp eq i8 %0, 0
  br i1 %cmp, label %while.cond2.preheader, label %while.cond

while.cond2.preheader:                            ; preds = %while.cond
  br label %while.cond2

while.cond2:                                      ; preds = %while.cond2.preheader, %while.body5
  %b.addr.0 = phi ptr [ %incdec.ptr6, %while.body5 ], [ %b, %while.cond2.preheader ]
  %n.addr.0 = phi i32 [ %dec, %while.body5 ], [ %n, %while.cond2.preheader ]
  %p.1 = phi ptr [ %incdec.ptr7, %while.body5 ], [ %incdec.ptr, %while.cond2.preheader ]
  %cmp3 = icmp eq i32 %n.addr.0, 0
  br i1 %cmp3, label %while.end8, label %while.body5

while.body5:                                      ; preds = %while.cond2
  %dec = add i32 %n.addr.0, -1
  %incdec.ptr6 = getelementptr inbounds i8, ptr %b.addr.0, i32 1
  %1 = load i8, ptr %b.addr.0, align 1
  %incdec.ptr7 = getelementptr inbounds i8, ptr %p.1, i32 1
  store i8 %1, ptr %p.1, align 1
  br label %while.cond2

while.end8:                                       ; preds = %while.cond2
  %scevgep = getelementptr i8, ptr %incdec.ptr, i32 %n
  store i8 0, ptr %scevgep, align 1
  ret ptr %a
}

; Test case 02: 4*reg({0,+,-1}) and -4*reg({0,+,-1}) are not supported for
;               the Thumb1 target.
define void @negativeFourCase(ptr %ptr1, ptr %ptr2) nounwind {
; CHECK-LABEL: define void @negativeFourCase
; CHECK-SAME: (ptr [[PTR1:%.*]], ptr [[PTR2:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[FOR_COND6_PREHEADER_US_I_I:%.*]]
; CHECK:       for.cond6.preheader.us.i.i:
; CHECK-NEXT:    [[ADDR_0108_US_I_I:%.*]] = phi ptr [ [[SCEVGEP_I_I:%.*]], [[IF_END48_US_I_I:%.*]] ], [ [[PTR1]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[INC49_US_I_I:%.*]] = phi i32 [ [[INC50_US_I_I:%.*]], [[IF_END48_US_I_I]] ], [ 0, [[ENTRY]] ]
; CHECK-NEXT:    [[C1_0104_US_I_I:%.*]] = phi ptr [ [[C0_0103_US_I_I:%.*]], [[IF_END48_US_I_I]] ], [ [[PTR2]], [[ENTRY]] ]
; CHECK-NEXT:    [[C0_0103_US_I_I]] = phi ptr [ [[C1_0104_US_I_I]], [[IF_END48_US_I_I]] ], [ [[PTR2]], [[ENTRY]] ]
; CHECK-NEXT:    [[SCEVGEP1:%.*]] = getelementptr i8, ptr [[C1_0104_US_I_I]], i32 -4
; CHECK-NEXT:    br label [[FOR_BODY8_US_I_I:%.*]]
; CHECK:       if.end48.us.i.i:
; CHECK-NEXT:    [[SCEVGEP_I_I]] = getelementptr i8, ptr [[ADDR_0108_US_I_I]], i32 256
; CHECK-NEXT:    [[INC50_US_I_I]] = add nuw nsw i32 [[INC49_US_I_I]], 1
; CHECK-NEXT:    [[EXITCOND110_I_I:%.*]] = icmp eq i32 [[INC50_US_I_I]], 256
; CHECK-NEXT:    br i1 [[EXITCOND110_I_I]], label [[EXIT_I:%.*]], label [[FOR_COND6_PREHEADER_US_I_I]]
; CHECK:       for.body8.us.i.i:
; CHECK-NEXT:    [[LSR_IV:%.*]] = phi i32 [ [[LSR_IV_NEXT:%.*]], [[FOR_INC_US_I_I:%.*]] ], [ 0, [[FOR_COND6_PREHEADER_US_I_I]] ]
; CHECK-NEXT:    [[ADDR_198_US_I_I:%.*]] = phi ptr [ [[ADDR_0108_US_I_I]], [[FOR_COND6_PREHEADER_US_I_I]] ], [ [[INCDEC_PTR_US_I_I:%.*]], [[FOR_INC_US_I_I]] ]
; CHECK-NEXT:    [[INC_196_US_I_I:%.*]] = phi i32 [ 0, [[FOR_COND6_PREHEADER_US_I_I]] ], [ [[INC_2_US_I_I:%.*]], [[FOR_INC_US_I_I]] ]
; CHECK-NEXT:    [[INCDEC_PTR_US_I_I]] = getelementptr inbounds i8, ptr [[ADDR_198_US_I_I]], i32 1
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[ADDR_198_US_I_I]], align 1
; CHECK-NEXT:    [[CMP9_US_I_I:%.*]] = icmp eq i8 [[TMP0]], -1
; CHECK-NEXT:    br i1 [[CMP9_US_I_I]], label [[IF_END37_US_I_I:%.*]], label [[IF_ELSE_US_I_I:%.*]]
; CHECK:       if.else.us.i.i:
; CHECK-NEXT:    [[SCEVGEP4:%.*]] = getelementptr i8, ptr [[C1_0104_US_I_I]], i32 [[LSR_IV]]
; CHECK-NEXT:    [[SCEVGEP5:%.*]] = getelementptr i8, ptr [[SCEVGEP4]], i32 4
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[SCEVGEP5]], align 4
; CHECK-NEXT:    [[SCEVGEP3:%.*]] = getelementptr i8, ptr [[C1_0104_US_I_I]], i32 [[LSR_IV]]
; CHECK-NEXT:    [[TMP2:%.*]] = load i32, ptr [[SCEVGEP3]], align 4
; CHECK-NEXT:    [[SCEVGEP2:%.*]] = getelementptr i8, ptr [[SCEVGEP1]], i32 [[LSR_IV]]
; CHECK-NEXT:    [[TMP3:%.*]] = load i32, ptr [[SCEVGEP2]], align 4
; CHECK-NEXT:    br label [[IF_END37_US_I_I]]
; CHECK:       if.end37.us.i.i:
; CHECK-NEXT:    [[TMP4:%.*]] = phi i32 [ [[TMP3]], [[IF_ELSE_US_I_I]] ], [ 0, [[FOR_BODY8_US_I_I]] ]
; CHECK-NEXT:    [[SCEVGEP:%.*]] = getelementptr i8, ptr [[C0_0103_US_I_I]], i32 [[LSR_IV]]
; CHECK-NEXT:    store i32 [[TMP4]], ptr [[SCEVGEP]], align 4
; CHECK-NEXT:    [[INC_US_I_I:%.*]] = add nsw i32 [[INC_196_US_I_I]], 1
; CHECK-NEXT:    [[CMP38_US_I_I:%.*]] = icmp sgt i32 [[INC_196_US_I_I]], 6
; CHECK-NEXT:    br i1 [[CMP38_US_I_I]], label [[IF_THEN40_US_I_I:%.*]], label [[FOR_INC_US_I_I]]
; CHECK:       if.then40.us.i.i:
; CHECK-NEXT:    br label [[FOR_INC_US_I_I]]
; CHECK:       for.inc.us.i.i:
; CHECK-NEXT:    [[INC_2_US_I_I]] = phi i32 [ 0, [[IF_THEN40_US_I_I]] ], [ [[INC_US_I_I]], [[IF_END37_US_I_I]] ]
; CHECK-NEXT:    [[LSR_IV_NEXT]] = add nuw nsw i32 [[LSR_IV]], 4
; CHECK-NEXT:    [[EXITCOND_I_I:%.*]] = icmp eq i32 1024, [[LSR_IV_NEXT]]
; CHECK-NEXT:    br i1 [[EXITCOND_I_I]], label [[IF_END48_US_I_I]], label [[FOR_BODY8_US_I_I]]
; CHECK:       exit.i:
; CHECK-NEXT:    ret void
;
entry:
  br label %for.cond6.preheader.us.i.i

for.cond6.preheader.us.i.i:                       ; preds = %if.end48.us.i.i, %entry
  %addr.0108.us.i.i = phi ptr [ %scevgep.i.i, %if.end48.us.i.i ], [ %ptr1, %entry ]
  %inc49.us.i.i = phi i32 [ %inc50.us.i.i, %if.end48.us.i.i ], [ 0, %entry ]
  %c1.0104.us.i.i = phi ptr [ %c0.0103.us.i.i, %if.end48.us.i.i ], [ %ptr2, %entry ]
  %c0.0103.us.i.i = phi ptr [ %c1.0104.us.i.i, %if.end48.us.i.i ], [ %ptr2, %entry ]
  br label %for.body8.us.i.i

if.end48.us.i.i:                                  ; preds = %for.inc.us.i.i
  %scevgep.i.i = getelementptr i8, ptr %addr.0108.us.i.i, i32 256
  %inc50.us.i.i = add nuw nsw i32 %inc49.us.i.i, 1
  %exitcond110.i.i = icmp eq i32 %inc50.us.i.i, 256
  br i1 %exitcond110.i.i, label %exit.i, label %for.cond6.preheader.us.i.i

for.body8.us.i.i:                                 ; preds = %for.inc.us.i.i, %for.cond6.preheader.us.i.i
  %addr.198.us.i.i = phi ptr [ %addr.0108.us.i.i, %for.cond6.preheader.us.i.i ], [ %incdec.ptr.us.i.i, %for.inc.us.i.i ]
  %inc.196.us.i.i = phi i32 [ 0, %for.cond6.preheader.us.i.i ], [ %inc.2.us.i.i, %for.inc.us.i.i ]
  %c.093.us.i.i = phi i32 [ 0, %for.cond6.preheader.us.i.i ], [ %inc43.us.i.i, %for.inc.us.i.i ]
  %incdec.ptr.us.i.i = getelementptr inbounds i8, ptr %addr.198.us.i.i, i32 1
  %0 = load i8, ptr %addr.198.us.i.i, align 1
  %cmp9.us.i.i = icmp eq i8 %0, -1
  br i1 %cmp9.us.i.i, label %if.end37.us.i.i, label %if.else.us.i.i

if.else.us.i.i:                                   ; preds = %for.body8.us.i.i
  %add12.us.i.i = add nuw nsw i32 %c.093.us.i.i, 1
  %arrayidx13.us.i.i = getelementptr inbounds i32, ptr %c1.0104.us.i.i, i32 %add12.us.i.i
  %1 = load i32, ptr %arrayidx13.us.i.i, align 4
  %arrayidx16.us.i.i = getelementptr inbounds i32, ptr %c1.0104.us.i.i, i32 %c.093.us.i.i
  %2 = load i32, ptr %arrayidx16.us.i.i, align 4
  %sub19.us.i.i = add nsw i32 %c.093.us.i.i, -1
  %arrayidx20.us.i.i = getelementptr inbounds i32, ptr %c1.0104.us.i.i, i32 %sub19.us.i.i
  %3 = load i32, ptr %arrayidx20.us.i.i, align 4
  br label %if.end37.us.i.i

if.end37.us.i.i:                                  ; preds = %if.else.us.i.i, %for.body8.us.i.i
  %4 = phi i32 [ %3, %if.else.us.i.i ], [ 0, %for.body8.us.i.i ]
  %arrayidx36.us.i.i = getelementptr inbounds i32, ptr %c0.0103.us.i.i, i32 %c.093.us.i.i
  store i32 %4, ptr %arrayidx36.us.i.i, align 4
  %inc.us.i.i = add nsw i32 %inc.196.us.i.i, 1
  %cmp38.us.i.i = icmp sgt i32 %inc.196.us.i.i, 6
  br i1 %cmp38.us.i.i, label %if.then40.us.i.i, label %for.inc.us.i.i

if.then40.us.i.i:                                 ; preds = %if.end37.us.i.i
  br label %for.inc.us.i.i

for.inc.us.i.i:                                   ; preds = %if.then40.us.i.i, %if.end37.us.i.i
  %inc.2.us.i.i = phi i32 [ 0, %if.then40.us.i.i ], [ %inc.us.i.i, %if.end37.us.i.i ]
  %inc43.us.i.i = add nuw nsw i32 %c.093.us.i.i, 1
  %exitcond.i.i = icmp eq i32 %inc43.us.i.i, 256
  br i1 %exitcond.i.i, label %if.end48.us.i.i, label %for.body8.us.i.i

exit.i:                               ; preds = %if.end48.us.i.i
  ret void
}

