# Bytecode Alliance Organizational Code of Conduct (OCoC)

*Note*: this Code of Conduct pertains to organizations' behavior. Please also see the [Individual Code of Conduct](CODE_OF_CONDUCT.md).

## Preamble

The Bytecode Alliance (BA) welcomes involvement from organizations,
including commercial organizations.  This document is an
*organizational* code of conduct, intended particularly to provide
guidance to commercial organizations.  It is distinct from the
[Individual Code of Conduct (ICoC)](CODE_OF_CONDUCT.md), and does not 
replace the ICoC. This OCoC applies to any group of people acting in 
concert as a BA member or as a participant in BA activities, whether 
or not that group is formally incorporated in some jurisdiction.

The code of conduct described below is not a set of rigid rules, and
we did not write it to encompass every conceivable scenario that might
arise.  For example, it is theoretically possible there would be times
when asserting patents is in the best interest of the BA community as
a whole.  In such instances, consult with the BA, strive for
consensus, and interpret these rules with an intent that is generous
to the community the BA serves.

While we may revise these guidelines from time to time based on
real-world experience, overall they are based on a simple principle:

*Bytecode Alliance members should observe the distinction between
 public community functions and private functions — especially
 commercial ones — and should ensure that the latter support, or at
 least do not harm, the former.*

## Guidelines

 * **Do not cause confusion about Wasm standards or interoperability.** 
 
   Having an interoperable WebAssembly core is a high priority for
   the BA, and members should strive to preserve that core.  It is fine
   to develop additional non-standard features or APIs, but they
   should always be clearly distinguished from the core interoperable
   Wasm.
 
   Treat the WebAssembly name and any BA-associated names with
   respect, and follow BA trademark and branding guidelines.  If you
   distribute a customized version of software originally produced by
   the BA, or if you build a product or service using BA-derived
   software, use names that clearly distinguish your work from the
   original.  (You should still provide proper attribution to the
   original, of course, wherever such attribution would normally be
   given.)
     
   Further, do not use the WebAssembly name or BA-associated names in
   other public namespaces in ways that could cause confusion, e.g.,
   in company names, names of commercial service offerings, domain
   names, publicly-visible social media accounts or online service
   accounts, etc.  It may sometimes be reasonable, however, to
   register such a name in a new namespace and then immediately donate
   control of that account to the BA, because that would help the project
   maintain its identity.

   For further guidance, see the BA Trademark and Branding Policy
   [TODO: create policy, then insert link].
     
 * **Do not restrict contributors.** If your company requires
   employees or contractors to sign non-compete agreements, those
   agreements must not prevent people from participating in the BA or
   contributing to related projects.

   This does not mean that all non-compete agreements are incompatible
   with this code of conduct.  For example, a company may restrict an
   employee's ability to solicit the company's customers.  However, an
   agreement must not block any form of technical or social
   participation in BA activities, including but not limited to the
   implementation of particular features.

   The accumulation of experience and expertise in individual persons,
   who are ultimately free to direct their energy and attention as
   they decide, is one of the most important drivers of progress in
   open source projects.  A company that limits this freedom may hinder
   the success of the BA's efforts.

 * **Do not use patents as offensive weapons.** If any BA participant
   prevents the adoption or development of BA technologies by
   asserting its patents, that undermines the purpose of the
   coalition.  The collaboration fostered by the BA cannot include
   members who act to undermine its work.
 
 * **Practice responsible disclosure** for security vulnerabilities.
   Use designated, non-public reporting channels to disclose technical
   vulnerabilities, and give the project a reasonable period to
   respond, remediate, and patch.  [TODO: optionally include the
   security vulnerability reporting URL here.]

   Vulnerability reporters may patch their company's own offerings, as
   long as that patching does not significantly delay the reporting of
   the vulnerability.  Vulnerability information should never be used
   for unilateral commercial advantage.  Vendors may legitimately
   compete on the speed and reliability with which they deploy
   security fixes, but withholding vulnerability information damages
   everyone in the long run by risking harm to the BA project's
   reputation and to the security of all users.

 * **Respect the letter and spirit of open source practice.** While
     there is not space to list here all possible aspects of standard
     open source practice, some examples will help show what we mean:

   * Abide by all applicable open source license terms.  Do not engage
     in copyright violation or misattribution of any kind.

   * Do not claim others' ideas or designs as your own.

   * When others engage in publicly visible work (e.g., an upcoming
     demo that is coordinated in a public issue tracker), do not
     unilaterally announce early releases or early demonstrations of
     that work ahead of their schedule in order to secure private
     advantage (such as marketplace advantage) for yourself.

   The BA reserves the right to determine what constitutes good open
   source practices and to take action as it deems appropriate to
   encourage, and if necessary enforce, such practices.

## Enforcement

Instances of organizational behavior in violation of the OCoC may 
be reported by contacting the Bytecode Alliance CoC team at 
[report@bytecodealliance.org](mailto:report@bytecodealliance.org). The 
CoC team will review and investigate all complaints, and will respond 
in a way that it deems appropriate to the circumstances. The CoC team 
is obligated to maintain confidentiality with regard to the reporter of 
an incident. Further details of specific enforcement policies may be 
posted separately.

When the BA deems an organization in violation of this OCoC, the BA
will, at its sole discretion, determine what action to take.  The BA
will decide what type, degree, and duration of corrective action is
needed, if any, before a violating organization can be considered for
membership (if it was not already a member) or can have its membership
reinstated (if it was a member and the BA canceled its membership due
to the violation).

In practice, the BA's first approach will be to start a conversation,
with punitive enforcement used only as a last resort.  Violations
often turn out to be unintentional and swiftly correctable with all
parties acting in good faith.
