//
// Copyright 2014 Google Inc. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Created by postproc-cld2 4.0 on 2014-01-31 09:56:39
// From command line:
//  --nearby_probs=1.8 --cld2 --cc --just_read_raw --quad --standard
//  --minchars=2 --mincount=2 --max_items_per_langscript=6000 --flatmap
//  --rr_alloc --freq_alloc --boostcloseweakerpercent=00 --indirectbits=16
//  --thresh=224 --v25 --kentries=256 --tablename=QuadChrome0122_2
//  --remap=xxx-Latn=>ut-Latn tw-Latn=>ak-Latn nd-Latn=>nr-Latn
//  blu-Latn=>hmn-Latn nn-Latn=>no-Latn  --include=af-Latn ar-Arab be-Cyrl
//  bg-Cyrl bs-Latn ca-Latn cs-Latn cy-Latn    da-Latn de-Latn el-Grek
//  en-Latn es-Latn et-Latn fa-Arab fi-Latn fr-Latn    ga-Latn gd-Latn
//  hi-Deva hr-Latn hu-Latn id-Latn is-Latn it-Latn iw-Hebr    ja-Hani
//  ko-Hani lg-Latn lt-Latn lv-Latn mk-Cyrl ms-Latn nl-Latn no-Latn
//  pl-Latn pt-Latn ro-Latn ro-Cyrl ru-Cyrl rw-Latn sh-Cyrl sh-Latn sk-Latn
//  sl-Latn sr-Cyrl    sv-Latn sw-Latn th-Thai tl-Latn tr-Latn uk-Cyrl
//  vi-Latn yi-Hebr    zh-Hani zh-TW zhT-Hani    sq-Latn az-Latn eu-Latn
//  bn-Beng gl-Latn ht-Latn mt-Latn sr-Latn ur-Arab    bh-Deva mr-Deva
//  ne-Deva lg-Latn rw-Latn gd-Latn    ut-Latn ut-Deva    ceb-Latn blu-Latn
//  hmn-Latn jw-Latn    so-Latn ig-Latn ha-Latn yo-Latn zu-Latn --ko_english
//  --force_to_lang_soft --nosoft_cram2 --nomsidlevel --shapeflatprob
//  --langpriorpercent=10 --skipnuc --noshapeforcetop --noshapeeventop
//  --noshapesteep2 --langcounts --writebin --list_items=120
//  --max_langs_per_item=3 /hdb1/cld2/probs/p90_raw_quadgrams_2014.utf8
//
// CLD2_pslangs
//
// See compact_lang_det.cc for usage
//
#include "cld2tablesummary.h"
namespace CLD2 {

// For this build date, looking up 'qpdbmrmxyzptlkuuddlrlrbas' gives AZERBAIJANI
static const uint32 kQuadChrome0122_2BuildDate = 20140131;    // yyyymmdd


// Of 390154 offered items into 262144 table entries:
// 244373 filled (62%), 733 merged (0%), 145048 dropped (37%)

// Nil-grams: 19 languages
//     GREEK MALAYALAM TELUGU TAMIL GUJARATI THAI KANNADA PUNJABI
//     GEORGIAN SINHALESE ARMENIAN LAOTHIAN KHMER DHIVEHI CHEROKEE
//     SYRIAC LIMBU ORIYA INUKTITUT

// Uni-grams: 4 languages
//     Japanese Korean Chinese ChineseT

// Words/Quads: 67 languages in range ENGLISH..HMONG:
//     ENGLISH DANISH DUTCH FINNISH FRENCH GERMAN HEBREW ITALIAN
//     NORWEGIAN POLISH PORTUGUESE RUSSIAN SPANISH SWEDISH CZECH
//     ICELANDIC LATVIAN LITHUANIAN ROMANIAN HUNGARIAN ESTONIAN
//     BULGARIAN CROATIAN SERBIAN IRISH GALICIAN TAGALOG TURKISH
//     UKRAINIAN HINDI MACEDONIAN BENGALI INDONESIAN MALAY WELSH
//     NEPALI ALBANIAN BELARUSIAN JAVANESE URDU BIHARI ARABIC CATALAN
//     BASQUE SCOTS_GAELIC SWAHILI SLOVENIAN MARATHI MALTESE
//     VIETNAMESE SLOVAK AZERBAIJANI PERSIAN BOSNIAN ZULU YIDDISH
//     SOMALI MONGOLIAN AFRIKAANS YORUBA HAUSA HAITIAN_CREOLE
//     KINYARWANDA GANDA IGBO CEBUANO HMONG

// TopLanguage  TokenCount
//  ENGLISH 3592
//  DANISH 3571
//  DUTCH 3548
//  FINNISH 3676
//  FRENCH 3623
//  GERMAN 3561
//  HEBREW 3599
//  ITALIAN 2792
//  NORWEGIAN 3625
//  POLISH 3641
//  PORTUGUESE 3676
//  RUSSIAN 3614
//  SPANISH 3235
//  SWEDISH 3698
//  CZECH 7353
//  ICELANDIC 3583
//  LATVIAN 3687
//  LITHUANIAN 3594
//  ROMANIAN 7301
//  HUNGARIAN 3703
//  ESTONIAN 3575
//  BULGARIAN 3615
//  CROATIAN 3694
//  SERBIAN 6847
//  IRISH 3682
//  GALICIAN 3214
//  TAGALOG 2558
//  TURKISH 3635
//  UKRAINIAN 3624
//  HINDI 7171
//  MACEDONIAN 3608
//  BENGALI 3637
//  INDONESIAN 3892
//  MALAY 2642
//  WELSH 3586
//  NEPALI 3604
//  ALBANIAN 3614
//  BELARUSIAN 3628
//  JAVANESE 3598
//  URDU 3691
//  BIHARI 4003
//  ARABIC 3640
//  CATALAN 3576
//  BASQUE 3571
//  SCOTS_GAELIC 3632
//  SWAHILI 3617
//  SLOVENIAN 3650
//  MARATHI 3551
//  MALTESE 3642
//  VIETNAMESE 3632
//  SLOVAK 3619
//  AZERBAIJANI 3684
//  PERSIAN 3676
//  BOSNIAN 2635
//  ZULU 3517
//  YIDDISH 3573
//  SOMALI 3570
//  MONGOLIAN 15
//  AFRIKAANS 3607
//  YORUBA 3503
//  HAUSA 3008
//  HAITIAN_CREOLE 3618
//  KINYARWANDA 3479
//  GANDA 3632
//  IGBO 3170
//  CEBUANO 2298
//  HMONG 2201



// Recognized language-script combinations [69]:
static const char* const kQuadChrome0122_2RecognizedLangScripts =
  "af-Latn ar-Arab az-Latn be-Cyrl bg-Cyrl bh-Deva bn-Beng bs-Latn "
  "ca-Latn ceb-Latn cs-Latn cy-Latn da-Latn de-Latn en-Latn es-Latn "
  "et-Latn eu-Latn fa-Arab fi-Latn fr-Latn ga-Latn gd-Latn gl-Latn "
  "ha-Latn hi-Deva hmn-Latn hr-Latn ht-Latn hu-Latn id-Latn ig-Latn "
  "is-Latn it-Latn iw-Hebr jw-Latn lg-Latn lt-Latn lv-Latn mk-Cyrl "
  "mn-Latn mr-Deva ms-Latn mt-Latn ne-Deva nl-Latn no-Latn pl-Latn "
  "pt-Latn ro-Cyrl ro-Latn ru-Cyrl rw-Latn sk-Latn sl-Latn so-Latn "
  "sq-Latn sr-Cyrl sr-Latn sv-Latn sw-Latn tl-Latn tr-Latn uk-Cyrl "
  "ur-Arab vi-Latn yi-Hebr yo-Latn zu-Latn ";

static const uint32 kQuadChrome0122_2Size = 65536;    // Bucket count
static const uint32 kQuadChrome0122_2KeyMask = 0xffff0000;    // Mask hash key

static const IndirectProbBucket4 kQuadChrome0122_2[kQuadChrome0122_2Size] = {
  // hash_indirect[4], tokens[4] in UTF-8
   {{0xe9da0002,0x7c2e0003,0x65630004,0x20070005}},	// [000] вка_, ssbr, kenh, _huni_,
   {{0x20070006,0x64430007,0xbddb0008,0x63bb0009}},	//   _kuni_, kuni, stèr, hiun,
   {{0xddc4000a,0x6563000b,0x52e2000c,0x02e2000d}},	//   _križ, denh, _पर्स, _पर्न,
   {{0x6443000e,0x4916000f,0x63bb0010,0x20070011}},	//   duni, _प्रो_, jiun, _muni_,
   {{0x20070012,0x27ed0013,0x63a90014,0x63bb0015}},	//   _luni_, _dhen_, dhen, diun,
   {{0x65630016,0x64430017,0xef1f0018,0x24510019}},	//   genh, funi, tjük_, _bơm_,
   {{0x6443001a,0x24510019,0x2007001b,0x2816001c}},	//   guni, _cơm_, _nuni_, _خوزس,
   {{0x63bb001d,0xef1f0018,0x63a9001e,0xdb0d001f}},	//   giun, rjük_, ghen, riaç,
   {{0x36670020,0x65630021,0x20070022,0x21270023}},	//   _като_, benh, _auni_, _benh_,
   {{0x64430024,0x20070025,0x27ed0026,0x6f040027}},	//   buni, _buni_, _zhen_, _agic,
   {{0x2b9c0028,0x75280029,0x6aad002a,0x63bb002b}},	//   _tích_, _iedz, zzaf, biun,
   {{0x63a9002c,0x63bb002d,0x4ea7002e,0x2007002f}},	//   chen, ciun, арга, _duni_,
   {{0x69dc0030,0x75280031,0x229c0032,0xc6080033}},	//   _okre, _kedz, _dákú_, রীরা_,
   {{0x75280034,0x6e240035,0x20070036,0x71730037}},	//   _jedz, _dwib, _funi_, _وهنا,
   {{0x75280038,0xddc40039,0x212c0013,0x2007003a}},	//   _medz, _friž, madh_, _guni_,
   {{0x212c003b,0x6563003c,0x69c5003d,0x6d41003e}},	//   ladh_, zenh, wnhe, ólab,
   {{0xafb8003f,0x6b8d0040,0x64430041,0x69d70042}},	// [010] _خطوط_, rjag, zuni, toxe,
   {{0x212c003b,0x63bb002d,0x64430043,0x20070044}},	//   nadh_, ziun, yuni, _yuni_,
   {{0x69d70045,0x65630046,0x27ed0047,0x69c50048}},	//   roxe, venh, _phen_, rnhe,
   {{0x212c0049,0x69dc004a,0xa804004b,0xc7c4004c}},	//   hadh_, _ekre, ізіл, осчи,
   {{0x75280034,0x63a9004d,0x672b004e,0xd6ab0037}},	//   _bedz, vhen, ragj, خدام_,
   {{0x27ed004f,0x64430050,0x26df0051,0x672b0052}},	//   _when_, tuni, _vyuo_, sagj,
   {{0x63bb0012,0x65630053,0x27ed0054,0x212c0055}},	//   tiun, renh, _then_, dadh_,
   {{0x65630056,0x20070057,0xb3850058,0x7e6d0059}},	//   senh, _runi_, слил, _osap,
   {{0x63a9005a,0x6443005b,0x7bdd005c,0x212c0037}},	//   rhen, suni, _mksu, fadh_,
   {{0x212c003b,0x63bb005d,0x63a9005e,0x2007005f}},	//   gadh_, siun, shen, _puni_,
   {{0x63a90060,0xddc40061,0x7e6d0062,0x2ee00063}},	//   phen, _priž, _asap, _syif_,
   {{0x66010064,0xd5430065,0x6fdd002b,0x66090066}},	//   _hilk, _fẹ̀f, xéct, _kuek,
   {{0x66010067,0x7e6d0068,0x67290069,0x212c006a}},	//   _kilk, _csap, _meej, badh_,
   {{0x212c006b,0x6729006c,0x2007006d,0xb276006e}},	//   cadh_, _leej, _tuni_, _לענג_,
   {{0x1015006f,0xfce60070,0x7e6d0071,0x6fdd0072}},	//   _ابتد, сово, _esap, téct,
   {{0x69dc0073,0xee3f0074,0x260a0006,0x67290075}},	//   _skre, brý_, ादमी_, _neej,
   {{0x6d410076,0x0aea0077,0xddc40078,0x6e240079}},	// [020] ólac, удай_, _kriż, _uwib,
   {{0x46db007a,0x6601007b,0x7995007c,0x00000000}},	//   _बड़ह, _nilk, _cozw, --,
   {{0xaad8007d,0x75280029,0xdceb007e,0x7995007f}},	//   _भुरक, _redz, _ćiće, _dozw,
   {{0xbb860080,0xa3e7000f,0x06d10081,0xf7460082}},	//   _الحي, _मील_, ়েছি, седо,
   {{0x66010083,0x65940084,0x66090085,0x16340086}},	//   _bilk, жалу, _cuek, целя,
   {{0x69dc0087,0xdb160088,0x8e570089,0x5d7a006e}},	//   _ukre, ábær, מינג_, ראַק,
   {{0x6601008a,0xe644008b,0xb8960037,0x6729008c}},	//   _dilk, ğlığ, _الزع, _feej,
   {{0x5214008d,0xe644008e,0x5398008f,0xddc40090}},	//   одит, şlığ, рвия_, _ariż,
   {{0x212c0091,0x6fc80092,0x66010093,0x00000000}},	//   tadh_, rıcl, _filk, --,
   {{0xddcd0094,0x20090095,0x26f60096,0xb0340097}},	//   _krať, _čair_, ेशीर_, онош,
   {{0x212c003b,0x67290098,0xdb0d003e,0x7413001c}},	//   radh_, _yeej, knað, _فولا,
   {{0x212c0099,0x6601009a,0x7f9f0052,0xee3f0094}},	//   sadh_, _zilk, _këqi, trý_,
   {{0x4ad8007d,0x212c009b,0xeabf009c,0x27fc0031}},	//   _भुलव, padh_, _ceùl_, ívny_,
   {{0x6601008a,0xa2c5009d,0xddc4009e,0x491a009f}},	//   _xilk, ापर्, _griż, मुमो_,
   {{0x79950067,0x5ba700a0,0x71bb00a1,0x31bb00a1}},	//   _rozw, браз, _תצוג, _תזונ,
   {{0xdb0d0088,0x2d8c00a2,0x48ef00a3,0x09d100a4}},	//   gnað, öder_, _अरबो_, तक्य,
   {{0x799500a5,0x7e6d00a6,0x681500a7,0x74df00a8}},	// [030] _pozw, _usap, _işdə, _पुनः,
   {{0x5a3400a9,0x672900aa,0xaa7b0094,0x00000000}},	//   янут, _seej, _ozýv, --,
   {{0xe71900ab,0x672900ac,0x98b800ad,0x9b9500ae}},	//   ليات_, _peej, _barı_, _динц,
   {{0xe00b00af,0x00000000,0x00000000,0x00000000}},	//   _संसद_, --, --, --,
   {{0x660100b0,0xd24600b1,0x442500b2,0xbddb00b3}},	//   _pilk, _تن_, _swl_, crèc,
   {{0xcfcf0081,0x441500b4,0x00000000,0x00000000}},	//   রতিন, офит, --, --,
   {{0x660100b5,0x70d700b6,0x672900b7,0xddc4009e}},	//   _vilk, _डडेल, _teej, _rriż,
   {{0x36d500b8,0x57a400ae,0xe3b100b9,0x130900ba}},	//   _добр, _ешуа, برت_, шний_,
   {{0x660100bb,0x660900bc,0xddc400bd,0x00000000}},	//   _tilk, _uuek, _priż, --,
   {{0x11d60037,0x869800be,0x00000000,0x00000000}},	//   يوية_, _укус_, --, --,
   {{0xe2a800bf,0xfbd900c0,0x98b8008b,0x00000000}},	//   لاین_, भकाम, _yarı_, --,
   {{0x14d600c1,0x225900c2,0x63b90027,0x00000000}},	//   _וועל_, _виды_, _umwn, --,
   {{0xc8e600c3,0xddc400c4,0x00000000,0x00000000}},	//   _कर्म_, _asiš, --, --,
   {{0xa0a500c5,0x853c00c6,0x00000000,0x00000000}},	//   _малд, _alėj, --, --,
   {{0x09c400c7,0x8b9600c8,0x3b9600c9,0xdb0d003e}},	//   ্তমা, орач, ојат, tnað,
   {{0xc05200ca,0x7c3a00cb,0x00000000,0x00000000}},	//   _חזה_, štro, --, --,
   {{0x7c2900cc,0xdb0d003e,0x00000000,0x00000000}},	// [040] ćera, rnað, --, --,
   {{0x2b5800cd,0x98b8008b,0xed5a00ce,0xbc6600cf}},	//   _گیرد_, _sarı_, _тоо_, _двок,
   {{0xc8ca00d0,0xd90d00d1,0x00000000,0x00000000}},	//   جوان_, ایف_, --, --,
   {{0xddcd00d2,0x00000000,0x00000000,0x00000000}},	//   _vrať, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xe5a300d3,0xddcd00d4,0x00000000,0x00000000}},	//   мичи, _trať, --, --,
   {{0x07a600d5,0x00000000,0x00000000,0x00000000}},	//   _давн, --, --, --,
   {{0x81e70081,0xd32600d6,0x68b700d7,0xaa7b00d8}},	//   _মূল_, цьки, _וללא_, _vzýv,
   {{0xdcfe00d9,0x9f4000da,0x00000000,0x00000000}},	//   _kopē, _fhiú_, --, --,
   {{0x27e600db,0x2a6200dc,0xa69700ca,0xdb230076}},	//   llon_, _mpkb_, _וכמה_, árúc,
   {{0x201800dd,0xdb060018,0x261000de,0x6ac600df}},	//   ëri_, _elké, _hào_, लपुर,
   {{0x27e600e0,0x75ed00e1,0x45220033,0x28bd00e2}},	//   nlon_, púzc, _নাটক_, ्पति,
   {{0xd25000e3,0xa2d6001c,0x201800e4,0x5f9400e5}},	//   _أنت_, _بيشت, ūri_, фият,
   {{0x27e600e6,0x2a7f00e7,0x26100023,0xdcfe00e8}},	//   hlon_, _šubo_, _mào_, _nopē,
   {{0x27e600e9,0x261000de,0x2ca500ea,0x6f1600eb}},	//   klon_, _lào_, áld_, _ffyc,
   {{0x2a6200ec,0x764200ed,0xdb1f0052,0x248e00ee}},	//   _bpkb_, kroy, miqë, ixfm_,
   {{0x261000ef,0x291c00a7,0x27e600f0,0x672200f1}},	// [050] _nào_, ıvan_, dlon_, dboj,
   {{0xceb2006e,0x3ea400f2,0x290700f3,0x764200f4}},	//   _ניי_, ømte_, øna_, droy,
   {{0x984b00e5,0x00000000,0x00000000,0x00000000}},	//   ряза_, --, --, --,
   {{0xf09300f5,0x261000de,0x27e600f0,0x201e00c6}},	//   ונע_, _bào_, glon_, ipti_,
   {{0x26100023,0xff7c006e,0x79a700f6,0x680500c6}},	//   _cào_, יטאמ, _дрве, _pėds,
   {{0x5a3400f7,0x996400f8,0xbafa00ca,0x27e600f9}},	//   _інст, _отсл, _להרש, alon_,
   {{0x27e600fa,0x00000000,0x00000000,0x00000000}},	//   blon_, --, --, --,
   {{0xd90e00fb,0x9f40009c,0x764200fc,0x00000000}},	//   _لیے_, _fhiù_, broy, --,
   {{0x764200fd,0x261000fe,0x35b500d3,0x00000000}},	//   croy, _gào_, _ебар, --,
   {{0x661b00ff,0xd6c60100,0x14190037,0x00000000}},	//   _ituk, _عملی, _هيئة_, --,
   {{0x3cdb0101,0xc8bd00b6,0x00000000,0x00000000}},	//   _खुले_, ्पिट, --, --,
   {{0x6d410102,0xe3b30103,0x00000000,0x00000000}},	//   ólan, _غرض_, --, --,
   {{0xa3ca0104,0x26100023,0xb2c70103,0x64df00a4}},	//   ोवर_, _xào_, _بغاو, _पुतळ,
   {{0xdd9200bf,0x427a0105,0x67220039,0x7c290106}},	//   روز_, _לאנג, zboj, ćern,
   {{0x27e60107,0xa0a50108,0x0c790109,0x661b010a}},	//   ylon_, _хайд, осты_, _ltuk,
   {{0x6443010b,0x661b010c,0x5f76010d,0xbebb0052}},	//   irni, _otuk, _رابر, mbën,
   {{0xeb97010e,0x6722010f,0xa9a60110,0x661b0111}},	// [060] чит_, vboj, пиад, _ntuk,
   {{0x261000de,0x7e640112,0x673b0113,0xfa490037}},	//   _rào_, _ipip, _aduj, تشفى_,
   {{0xfce60114,0x661b0115,0x261000fe,0x6d5c0116}},	//   _хоно, _atuk, _sào_, mfra,
   {{0x2d9a00a1,0x64430117,0xa2dc0096,0x76420118}},	//   _hope_, drni, _पडल्, troy,
   {{0x672200d9,0x6d5c0036,0x64430119,0xa613004d}},	//   rboj, ofra, erni, еміч,
   {{0x6d4e011a,0x2610011b,0x6d5c011c,0x27e6011d}},	//   ngba, _vào_, nfra, slon_,
   {{0x27e6011e,0x661b011f,0x29180120,0x290a0121}},	//   plon_, _etuk, _ifra_, _igba_,
   {{0x69de0122,0x7e6400cc,0x76420123,0x9734001c}},	//   lope, _opip, proy, _آکاا,
   {{0x321f0124,0x04fe0033,0x6d5c0125,0x00000000}},	//   gpuy_, ুরের_, kfra, --,
   {{0x6d4e0126,0x69de0127,0x64430128,0x5637006e}},	//   jgba, nope, brni, _מאמע_,
   {{0x290a0129,0xe8df00de,0x7ae6012a,0xf99300ca}},	//   _mgba_, _trục_, _lykt, תרת_,
   {{0xd36f012b,0x69de012c,0x644a012d,0xbddb0113}},	//   _مهم_, hope, mufi, grèn,
   {{0x6d5c012e,0x69de012f,0xe3b30130,0x2d9a0131}},	//   ffra, kope, _אױף_, _bope_,
   {{0x72eb0132,0x2d9a0133,0x00000000,0x00000000}},	//   _פֿאַ, _cope_, --, --,
   {{0xd5c800ef,0x7c290106,0xab1a0134,0x644a0135}},	//   yền_, ćero, _ọlụs, nufi,
   {{0x290a0136,0x6d4e0137,0xc1780138,0x61420139}},	//   _agba_, agba, ldė_, _fílà,
   {{0xb999013a,0x61420139,0x6d5c013b,0xdcfd013c}},	// [070] овах_, _gílà, bfra, ızıs,
   {{0x5c07013d,0x644a013e,0xc178013f,0x7ae6004d}},	//   _няма, kufi, ndė_, _dykt,
   {{0x3ea60029,0x661b0140,0x75ed00d4,0x661c0141}},	//   _ļoti_, _stuk, fúzn, _črka,
   {{0x64430087,0x290a0065,0x2d9a0062,0xdc360142}},	//   vrni, _egba_, _zope_, _קארט_,
   {{0x7bdf0143,0x4b7a00ca,0xc17800c6,0xb5fd0144}},	//   moqu, _וארו, kdė_, _apša,
   {{0x7bdf0145,0xddd60146,0x64430147,0x7bcd0148}},	//   loqu, _kryš, trni, lnau,
   {{0x64580149,0x200e0044,0x6443014a,0xbddb014b}},	//   gtvi, _nufi_, urni, yrèn,
   {{0x7bcd014c,0x2215014d,0x260a014e,0x6443014f}},	//   nnau, мфор, ादशी_, rrni,
   {{0x6d5c0150,0x661b0151,0xd24e0076,0x42540152}},	//   yfra, _utuk, لني_, нтэт,
   {{0x7bcd0153,0x23c30154,0x6d410155,0x10a50156}},	//   hnau, _bèjè_, ólal, дион,
   {{0x54550157,0x2d9a0158,0x00000000,0x00000000}},	//   _цвет, _rope_, --, --,
   {{0xd24e0159,0xe291015a,0x69de015b,0x7c3a015c}},	//   دنی_, _لذت_, zope, štrk,
   {{0x6d5c015d,0x69de0051,0x7bcd00fc,0xbddb015e}},	//   tfra, yope, dnau, rrèn,
   {{0x90c5015f,0x7ae60160,0x69de0161,0x3f890162}},	//   _обле, _rykt, xope, _enau_,
   {{0xfce30163,0x6d5c0164,0x7bdf0165,0x764b0124}},	//   воро, rfra, foqu, hugy,
   {{0x8ffa00cd,0x764b0166,0x320f0167,0x7bcd0168}},	//   _برتر_, kugy, _kugy_, gnau,
   {{0x2fc00169,0x32070079,0x00000000,0x00000000}},	// [080] _imig_, _kiny_, --, --,
   {{0x320f0113,0x7ae600c6,0x00000000,0x00000000}},	//   _mugy_, _vykt, --, --,
   {{0xeb9a016a,0x69de016b,0x8b26016c,0x7bdf016d}},	//   _дин_, rope, _одне, boqu,
   {{0xfaa600c6,0x46ea016e,0x7bdf016f,0x7ae60170}},	//   _жамо, оден_, coqu, _tykt,
   {{0x69de0171,0x764b0172,0x00000000,0x00000000}},	//   pope, gugy, --, --,
   {{0x64580173,0x290a0174,0x644a0175,0x28d90176}},	//   ttvi, _ugba_, tufi, _बुकि,
   {{0xd90d0177,0x64580120,0x799c0178,0x00000000}},	//   _ایم_, utvi, _iorw, --,
   {{0x28bd0179,0x6458017a,0x02a6017b,0x200e017c}},	//   ्परि, rtvi, дром, _rufi_,
   {{0x200e017d,0x96180081,0x6f090146,0x6aa4017e}},	//   _sufi_, _ডটকম_, žeck, nyif,
   {{0xb5aa0037,0xc17800c6,0x00000000,0x00000000}},	//   _بارك_, udė_, --, --,
   {{0x26ee017f,0x799c0178,0x61e80180,0xc17800c6}},	//   _जरुर_, _morw, rldl, rdė_,
   {{0xdce50181,0x73360182,0x33830183,0x2d9e0184}},	//   _pohľ, _آرائ, _аушв, öten_,
   {{0x799c0185,0x7bdf0186,0xa3e70187,0x69cb0103}},	//   _oorw, voqu, _मीट_, égek,
   {{0x2907013f,0x66080188,0x320700b3,0x799c0189}},	//   žnai_, _jidk, _giny_, _norw,
   {{0x7bdf00c9,0x6608008a,0xd139018a,0x00000000}},	//   toqu, _midk, _ххі_, --,
   {{0x26ee018b,0x6282018c,0x53de009d,0x6608018d}},	//   _जरूर_, _kroo, मविश, _lidk,
   {{0x7bcd018e,0x799c018f,0xdee70190,0x6f0d0191}},	// [090] rnau, _borw, _تأثي, _igac,
   {{0xaca30134,0xf9930192,0x6e2d0193,0xdb0d00fd}},	//   _arụg, خبر_, _iwab, chaî,
   {{0x20090194,0x7bdf0131,0x00000000,0x00000000}},	//   _kiai_, poqu, --, --,
   {{0x6e2d0195,0xa635004d,0x68e70146,0x764b0196}},	//   _kwab, енді, _vyjd, tugy,
   {{0x62820197,0x6e2d0167,0x799c00ca,0x68e7007f}},	//   _nroo, _jwab, _forw, _wyjd,
   {{0xba430138,0x6e2d0198,0x6b9d0199,0x799c00f0}},	//   žįst, _mwab, _hosg, _gorw,
   {{0x76590150,0x6282019a,0x6e2d019b,0x764b019c}},	//   stwy, _aroo, _lwab, sugy,
   {{0x6f0d019d,0x6282019e,0xe64b00a7,0x6e2d019f}},	//   _ngac, _broo, şdığ, _owab,
   {{0x020501a0,0x09c40033,0x62820133,0x6b9d01a1}},	//   нзин, ্তরা, _croo, _mosg,
   {{0x628201a2,0x6b9d01a3,0x6f0d0193,0x7c3a015c}},	//   _droo, _losg, _agac, štri,
   {{0x6e2d01a4,0x628201a5,0x853c0138,0x320700d4}},	//   _awab, _eroo, _plėv, _viny_,
   {{0x6e2d01a6,0x69c501a7,0xa3e700a4,0x6b9d01a8}},	//   _bwab, hihe, _मीच_, _nosg,
   {{0xee3701a9,0x628201aa,0x63a901ab,0x320700d7}},	//   ння_, _groo, mken, _tiny_,
   {{0x7c2201ac,0x236d01ad,0x4cc10033,0x69c501ae}},	//   _čorb, leej_, _শুধু, jihe,
   {{0x69c501af,0x6b9d01b0,0x61e101b1,0x6e2d01b2}},	//   dihe, _bosg, moll, _ewab,
   {{0xddcd01b3,0x63a901b4,0x20090019,0x6b9d01b5}},	//   _graž, nken, _giai_, _cosg,
   {{0x6b6301b6,0x799c01b7,0x63a901b8,0x6b9d01b9}},	// [0a0] ыкта, _porw, iken, _dosg,
   {{0x61e101ba,0x236d01bb,0x63a901bc,0x69c501bd}},	//   noll, heej_, hken, gihe,
   {{0x63a901be,0x799c01bf,0x6b9d01b5,0x7c960037}},	//   kken, _vorw, _fosg, _أشخا,
   {{0x63a901c0,0x61e101c1,0x236d01c2,0x1bba01c3}},	//   jken, holl, jeej_, _راجع_,
   {{0x61e101c4,0x63a901c5,0x9980013f,0x69c501c6}},	//   koll, dken, usių_, bihe,
   {{0x63a901c7,0x224d01c8,0x998000c6,0x00000000}},	//   eken, duek_, rsių_, --,
   {{0x186701c9,0x316c0181,0x61e101ca,0x63a901cb}},	//   _пари_, vedz_, doll, fken,
   {{0x628201cc,0x645c00bc,0x6f0900c4,0x00000000}},	//   _proo, _ärim, žeci, --,
   {{0x6d4101cd,0x224d0062,0x660801ce,0xd2570012}},	//   ólak, guek_, _tidk, нцэ_,
   {{0xbddb01cf,0x6e2d0193,0x628201d0,0x7abb00ca}},	//   trèm, _rwab, _vroo, פציו,
   {{0xddcd01d1,0x6e2d01d2,0x316c01d3,0x20090063}},	//   _praž, _swab, redz_, _piai_,
   {{0x645a01d4,0x63a901d5,0x657a01d6,0xd46900e3}},	//   _iqti, cken, _hath, _تحكم_,
   {{0x657a01d7,0x61e101d8,0xddcd01d9,0x69c501da}},	//   _kath, boll, _vraž, yihe,
   {{0x61e101db,0xd12f00bf,0x657a01dc,0x40940037}},	//   coll, _همه_, _jath, _للتر,
   {{0xddcd01dd,0x6b9d01de,0x628001df,0x657a01e0}},	//   _traž, _posg, lvmo, _math,
   {{0x657a01e1,0x6e2d01e2,0x6f0d01e3,0x25dc01e4}},	//   _lath, _twab, _ugac, मकुण,
   {{0x245a01e5,0x3df5013d,0xef64008f,0x6b9d01e6}},	// [0b0] hëm_, _изис, _също, _vosg,
   {{0x657a01e7,0xdb0d00e3,0x3eb301e8,0x63a901e9}},	//   _nath, mhaí, ıntı_, zken,
   {{0x69c501ea,0x63a901eb,0x6b9d01ec,0x00000000}},	//   rihe, yken, _tosg, --,
   {{0x69c501ed,0x657a01ee,0x00000000,0x00000000}},	//   sihe, _aath, --, --,
   {{0xe61800f3,0x8b9a00a1,0x8a1801ef,0x657a01f0}},	//   еді_, _חברת, _пояс_, _bath,
   {{0x657a01f1,0x61e101f2,0x6594004d,0x1a6801f3}},	//   _cath, xoll, лачу, _سیمی_,
   {{0x61e101f4,0x657a01f5,0x69d501c0,0x63a901f6}},	//   voll, _dath, _ijze, tken,
   {{0xc178013f,0x657a01f7,0x68e301bf,0x224d01e9}},	//   klės_, _eath, ündu, tuek_,
   {{0x61e101f8,0x853c0138,0xddcd0078,0x7d0801f9}},	//   toll, _plėt, _braż, _kérü,
   {{0x926400e3,0x236d01fa,0x777b01e9,0x657a01fb}},	//   اديم, seej_, _haux, _gath,
   {{0x63a901fc,0x224d01c8,0x00000000,0x00000000}},	//   pken, suek_, --, --,
   {{0x61e101fd,0x657a01fe,0x224d01ff,0x00000000}},	//   soll, _zath, puek_, --,
   {{0x61e10200,0x657a0201,0xddcd009e,0x00000000}},	//   poll, _yath, _fraż, --,
   {{0x61450202,0x777b00fe,0x61e10203,0x7e7600d8}},	//   _река, _laux, qoll, _vsyp,
   {{0xb02400ef,0xfce60070,0x1fb60204,0x2b3a00ae}},	//   _trườ, тово, _аспр, дязэ_,
   {{0x1e860205,0xf4130081,0x8e4a0037,0x9f420206}},	//   _алим, _সবার_, _قلبك_, blká_,
   {{0xc332004f,0x245a00dd,0xdcfe01d3,0x7eb80139}},	// [0c0] יון_, zëm_, _kopī, _dúpé,
   {{0xe9d70207,0x9f4000b3,0x2d950208,0xa923002d}},	//   вку_, _thió_, _брюс, идул,
   {{0x657a0209,0xdd05020a,0x777b020b,0x00000000}},	//   _rath, ăsăt, _baux, --,
   {{0x657a020c,0x7bda020d,0xe3b8020e,0xb09a006e}},	//   _sath, étud, _atın_, ויער,
   {{0xeb97020f,0x657a0210,0x49910103,0x00000000}},	//   _рия_, _path, _گیلر, --,
   {{0x245a01e5,0x7c3a0211,0x645c00bc,0xceb30142}},	//   tëm_, štru, _ärik, סיג_,
   {{0x629d0212,0x02ca0213,0x74140214,0x657a01fc}},	//   äson, ाप्न, دوبا, _vath,
   {{0x657a0060,0x07a30215,0x245a0216,0xc7a30217}},	//   _wath, _касн, rëm_, _киск,
   {{0xe737007e,0xa6650192,0x245a0052,0x7c290218}},	//   _шет_, _مطلو, sëm_, ćeri,
   {{0x657a00e3,0x601e00d9,0xd5fb020b,0x00000000}},	//   _uath, _līme, _trú, --,
   {{0x7f590219,0x9f35021a,0x8f35021b,0x255a0154}},	//   нанс_, лені, ленц, _vņlč_,
   {{0xdb0d00e3,0x1fa7021c,0x67f800b6,0xddcd0034}},	//   thaí, трог, bíje, _wraż,
   {{0xecdb000f,0x7c220031,0x798e0154,0xddcd009e}},	//   _मुजफ, _čora, _onbw, _traż,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xa3d600c3,0xc17800c6,0x443c0072,0x3ead021d}},	//   _सदा_, slės_, nsv_, šet_,
   {{0x644a0037,0x7d080103,0x547b021e,0xbddb014b}},	//   irfi, _sérü, וטלו, guèr,
   {{0x62840138,0x777b021f,0x443c0095,0x443e020b}},	// [0d0] _šioj, _raux, hsv_, _lvt_,
   {{0x23b10220,0x395801b9,0x4c950221,0x70010134}},	//   _mája_, _ccrs_, _биос, _ịcha,
   {{0x29070222,0x98140037,0x4cc10033,0x443e0223}},	//   äna_, لبنا, _শুরু, _nvt_,
   {{0x9b9500d3,0x2cac0120,0xdb0d01ff,0x00000000}},	//   _симц, ødde_, piañ, --,
   {{0xadc40139,0x75ed0224,0x9f44020d,0x7bda020d}},	//   _arẹw, lúzi, ômé_, étue,
   {{0x6d550225,0x248500ec,0x2b5900e7,0xf48300cd}},	//   ngza, _prlm_, _hcsc_, لاعی,
   {{0xe8940226,0x69d80096,0x00000000,0x00000000}},	//   _карь, _मदती, --, --,
   {{0xaca30174,0x290700c6,0x443e0227,0x00000000}},	//   _abịd, žnas_, _dvt_, --,
   {{0x443e0228,0x36d5002d,0xddcf0206,0x00000000}},	//   _evt_, _соар, pucň, --,
   {{0xdb040037,0x2bc50134,0x67f80206,0x00000000}},	//   thiú, ịcha_, ríje, --,
   {{0xcea90130,0x8fa60229,0x443e0131,0x90c5022a}},	//   _צי_, гане, _gvt_, убне,
   {{0x261900fe,0xc5fb01c2,0xdb0f014b,0x3c18022b}},	//   _kèo_, ɓɓai_, _ulcè, _sčvo_,
   {{0xe1ee022c,0x2bc6022d,0x00000000,0x00000000}},	//   _гг_, रोफा, --, --,
   {{0x237d022e,0x261900de,0x5fc600aa,0x00000000}},	//   _hawj_, _mèo_, _लगवल, --,
   {{0xbb46022f,0x225f0230,0x2619020b,0x00000000}},	//   левк, ltuk_, _lèo_, --,
   {{0xc0520054,0x3a220167,0x6d5501cb,0x7c3c0231}},	//   _הזה_, _ptkp_, agza, rsrr,
   {{0x225f0232,0xdd040233,0x00000000,0x00000000}},	// [0e0] ntuk_, ırıs, --, --,
   {{0x237d01fa,0x6e2401e8,0x7c3e0234,0x44270167}},	//   _lawj_, _itib, _tvpr, kpn_,
   {{0xdca60235,0x601e00e8,0x00000000,0x00000000}},	//   _сани, _tīme, --, --,
   {{0x237d022e,0x26190023,0xfaff0052,0x6e24009e}},	//   _nawj_, _bèo_, _ibën_, _ktib,
   {{0x569400ae,0x443e0149,0xe5a60236,0xe5c60237}},	//   ралт, _svt_, лиди, лско,
   {{0x443e0238,0x281600cd,0x6e240239,0x644a0095}},	//   _pvt_, _موسس, _mtib, trfi,
   {{0xdd32013c,0x8cca023a,0x00000000,0x00000000}},	//   zəşt, _हेमो, --, --,
   {{0x7f44023b,0x9f42023c,0x644a023d,0xbebb0216}},	//   _ndiq, boké_, rrfi, mbëv,
   {{0x237d023e,0x6e24023f,0x27e60240,0x8556006f}},	//   _dawj_, _ntib, moon_, _مخاط,
   {{0xd6cf0241,0x27e60242,0x104a0243,0x237f007e}},	//   _عقل_, loon_, нями_, aduj_,
   {{0xb6030244,0x94260245,0x44a60246,0x2a6000aa}},	//   íšen, _смее, _حماق, htib_,
   {{0x27e60247,0x2a600248,0x23660141,0x00000000}},	//   noon_, ktib_, _uboj_, --,
   {{0x623400d3,0x44ce00a7,0x261900fe,0x6e2400d8}},	//   _телу, _hə_, _xèo_, _ctib,
   {{0x27e60249,0x63a2007a,0x2a790169,0x7bc6024a}},	//   hoon_, _hoon, _rssb_, _amku,
   {{0x63a2024b,0x27e6024c,0x6e240092,0x6d5501cb}},	//   _koon, koon_, _etib, rgza,
   {{0x764b0178,0x63a2024d,0x27e6024e,0x44ce00a7}},	//   yrgy, _joon, joon_, _mə_,
   {{0x27e60188,0x38c90018,0x44ce00a7,0x63a2024f}},	// [0f0] doon_, ھائی_, _lə_, _moon,
   {{0x63a20250,0x26180251,0x2bc60252,0x60d300d9}},	//   _loon, _पढ़ी_, रोबा, ņemš,
   {{0x44ce0253,0x27e60254,0x6d450255,0x26190154}},	//   _nə_, foon_, _idha, _sèo_,
   {{0x63a20256,0xbddb0257,0x27e60258,0x68ee01df}},	//   _noon, ssèd, goon_, _dybd,
   {{0x69cb0103,0x00000000,0x00000000,0x00000000}},	//   éges, --, --, --,
   {{0x9f420146,0xce3800ca,0x3a2900dc,0x7e6d012d}},	//   roké_, נאות_, mpap_, _mpap,
   {{0x63a20259,0x2905025a,0x9f42025b,0x27e60188}},	//   _boon, _àla_, soké_, boon_,
   {{0x44ce025c,0xc245025d,0x225f0103,0x261900fe}},	//   _də_, аник, ttuk_, _tèo_,
   {{0x63a2025e,0x6d45025f,0x7e6d00f9,0xa3d60096}},	//   _doon, _odha, _npap, _सदर_,
   {{0xb5fd00e9,0xaca30139,0x6d45001c,0xf4850260}},	//   _opši, _abọd, _ndha, _پائی,
   {{0x7e6d0261,0x63a20262,0x225f0263,0x237d006c}},	//   _apap, _foon, stuk_, _tawj_,
   {{0x6d450264,0x8e860265,0x63a20188,0xc49a0266}},	//   _adha, агме, _goon, _בשעת,
   {{0x7c250267,0x69c70268,0x44250095,0x20020095}},	//   _athr, _omje, _htl_, rmki_,
   {{0x63a20269,0x44ce00a7,0x291f026a,0x27e6026b}},	//   _zoon, _yə_, _şuan_, zoon_,
   {{0x63a2026c,0x417400cd,0x3079006e,0x27e6026d}},	//   _yoon, _دانس, _יאַנ, yoon_,
   {{0xaca3026e,0x63a2026f,0x23b10139,0x00000000}},	//   _gbọd, _xoon, _májo_, --,
   {{0x3f920270,0x6a8300d3,0x98b1022b,0x44250271}},	// [100] _inyu_, олта, _dezč_, _ltl_,
   {{0x27e60272,0x2a600273,0xd9460274,0x644100b6}},	//   woon_, rtib_, режи, _ovli,
   {{0xe73a0275,0x27e60276,0xb60700d9,0xa3c600c3}},	//   вее_, toon_, _mašī, _उगल_,
   {{0xd62a0277,0xc6a60131,0xb6cb0018,0xbebb0052}},	//   воде_, ирли, ھانے_, rbëv,
   {{0x27e60278,0x63a20279,0x6441027a,0x2bc6027b}},	//   roon_, _roon, _avli, रोणा,
   {{0xbebb01e5,0x27e6027c,0x4425027d,0x224d00aa}},	//   mbët, soon_, _btl_, drek_,
   {{0x4425027e,0x63a2027f,0x27e60280,0x88840281}},	//   _ctl_, _poon, poon_, _دیان,
   {{0x44ce0282,0x7bd60283,0x67f80220,0x660301fa}},	//   _və_, nnyu, bíja, amnk,
   {{0x6441008b,0xe57a0284,0x0ec50285,0xf6690286}},	//   _evli, _иза_, _लेंड, _محله_,
   {{0x63a20272,0x2bc60287,0xd5aa00aa,0x2ade007a}},	//   _woon, रोता, _कविज, _कुछु_,
   {{0x63a20288,0x09f70289,0x7e6d028a,0x00000000}},	//   _toon, שמים_, _spap, --,
   {{0xc4770054,0x224d028b,0x3f80001f,0x9f530233}},	//   _כתבו_, brek_, _caiu_, _ödül_,
   {{0x539b028c,0x4425028d,0x6d450085,0xef1f028e}},	//   _שידו, _ztl_, _pdha, rcü_,
   {{0xdb0d0161,0x4425026a,0x3f92010a,0x3f82028f}},	//   lhaç, _ytl_, _enyu_, adku_,
   {{0x8bc70290,0xab950291,0xd138007f,0x00000000}},	//   асад, бављ, ając_, --,
   {{0x69c70292,0x5b150293,0xdb0d016d,0xaca40294}},	//   _smje, смат, nhaç, chọi,
   {{0x2fc901f7,0x6d410088,0x7e6d0295,0x2bc60296}},	// [110] _imag_, ólas, _upap, रोधा,
   {{0x6d450297,0x67f80031,0x7bd6010a,0x61e80298}},	//   _udha, víja, anyu, nodl,
   {{0x4dda00ca,0x00000000,0x00000000,0x00000000}},	//   _תחתו, --, --, --,
   {{0x44250299,0x61e80074,0x93bc020a,0x224d0233}},	//   _rtl_, hodl, _stăn, yrek_,
   {{0x7bcd013f,0x2d81007a,0x2d83029a,0xbebb0052}},	//   miau, _kahe_, odje_, mbës,
   {{0x69c7029b,0x2d83029c,0x7bcd01b3,0x2d81029d}},	//   _umje, ndje_, liau, _jahe_,
   {{0xf773029e,0x2d81029f,0x58d402a0,0x776902a1}},	//   _وار_, _mahe_, _дорт, _tbex,
   {{0x224d02a2,0x7bcd013f,0x2d8100aa,0xe3b102a3}},	//   trek_, niau, _lahe_, ثرت_,
   {{0x6aad02a4,0x27ed02a5,0x27ff02a6,0x113900c6}},	//   nyaf, _iken_, _ihun_, ляны_,
   {{0x224d02a7,0x3f8002a8,0x2d830126,0x61e802a9}},	//   rrek_, _saiu_, jdje_, godl,
   {{0x600a02aa,0x7bcd02ab,0x25a5009c,0x27ed02ac}},	//   лном_, kiau, _ioll_, _kken_,
   {{0x25a502ad,0x224d02ae,0xdb0d0161,0x2d83029a}},	//   _holl_, prek_, chaç, edje_,
   {{0x216902af,0x25a50149,0x4ac702b0,0x7bcd02b1}},	//   _били_, _koll_, _रेलव, diau,
   {{0x2d830292,0x63bb02b2,0x2fc900ae,0x412602b3}},	//   gdje_, lhun, _emag_, _лошо_,
   {{0x27ff02b4,0x27ed02b5,0x2d8101c2,0x70550103}},	//   _ohun_, _oken_, _dahe_, _انعا,
   {{0x7bcd013f,0x3f9200ec,0x2d83029a,0x69d70072}},	//   giau, _unyu_, adje_, enxe,
   {{0xdb1d02b6,0xe9da02b7,0x63bb02b8,0xdb0f0131}},	// [120] _omsæ, гка_, ihun, _alcâ,
   {{0x645c02b9,0x27ff0139,0x25a502ba,0x27ed02bb}},	//   _årig, _ahun_, _noll_, _aken_,
   {{0x6c860080,0x27ff02bc,0x63bb0060,0x7bcd013f}},	//   _الجم, _bhun_, khun, biau,
   {{0x27ff02bd,0x7bcd02be,0x628b02bf,0xb73a00e3}},	//   _chun_, ciau, _orgo, اثاء_,
   {{0x63bb02c0,0x95ca02c1,0x27ff01f7,0x25a502c2}},	//   dhun, лука_, _dhun_, _boll_,
   {{0x6b8402c3,0x27ff02c4,0x27ed02c5,0x7a4102c6}},	//   ldig, _ehun_, _eken_, sátý,
   {{0x31cd00c7,0x628b02c7,0x61e802c8,0x6d5e01ff}},	//   রকাশ, _argo, vodl, _mcpa,
   {{0x63bb02c9,0xd5440139,0x2d8302ca,0x61e802cb}},	//   ghun, _bẹ̀w, zdje_, wodl,
   {{0xd13000e3,0x1a9a00c1,0x6b8402cc,0x25a502cd}},	//   ومة_, ריִע, idig, _foll_,
   {{0x361b00a1,0x2fc902ce,0x154302cf,0x25a500f0}},	//   _עובד, _smag_, _неум, _goll_,
   {{0x63bb02d0,0x2d8300e7,0x20120027,0x741602d1}},	//   bhun, vdje_, _biyi_, _اوصا,
   {{0x63bb02d2,0x753a0126,0xf8b300a1,0x61e802d3}},	//   chun, _hetz, פשר_, sodl,
   {{0x6b8402d4,0xa3e502d5,0xddc40220,0x2d810167}},	//   ddig, पकर_, _spiš, _pahe_,
   {{0x753a02d6,0x6b8402d7,0x6d5e00b3,0x0dc802d8}},	//   _jetz, edig, _ccpa, буси_,
   {{0x7bcd02d9,0x2d8302da,0x6b840188,0x753a02db}},	//   tiau, rdje_, fdig, _metz,
   {{0x753a02dc,0xddc402dd,0x5c0702de,0x2fc902df}},	//   _letz, _vpiš, сяга, _umag_,
   {{0x7bcd01b3,0x6e3602e0,0x0dcb02e1,0x6eff0139}},	// [130] riau, _gwyb, _буни_, _dàbí,
   {{0x753a02e2,0x213e01f7,0x7bcd02e3,0x6b8402e4}},	//   _netz, nath_, siau, adig,
   {{0x63bb02e5,0xddc402e6,0x6aad02e7,0x27ff00de}},	//   yhun, _upiš, syaf, _phun_,
   {{0x25a502dc,0x64c302e8,0x63bb02e9,0x00000000}},	//   _soll_, _वेगळ, xhun, --,
   {{0xb5fd02ea,0x25a502eb,0x959902ec,0x1c1f02ed}},	//   _opšt, _poll_, итку_, _मंडल_,
   {{0x7afd02ee,0x7dc902ef,0x59dd02f0,0x3c1802f1}},	//   _izst, džsk, _मदिर, _sčvi_,
   {{0x63bb0060,0x25a501bf,0x27ff02f2,0x799501bf}},	//   thun, _voll_, _thun_, _inzw,
   {{0x27ed004d,0x628b0218,0x753a01cb,0xb22502f3}},	//   _uken_, _prgo, _eetz, омил,
   {{0x25a502f4,0x7d000065,0x753a02f5,0x00000000}},	//   _toll_, _kárí, _fetz, --,
   {{0x63bb02f6,0x628b02f7,0xdb1d01cd,0x6b8400ad}},	//   shun, _vrgo, _umsæ, zdig,
   {{0xc95202f8,0x6b8402f9,0x63bb019f,0x673b02fa}},	//   ומי_, ydig, phun, _keuj,
   {{0x628b02fb,0xe3b302fc,0x661b02fd,0x644302fe}},	//   _trgo, _عرض_, _kuuk, msni,
   {{0x614502ff,0x333f025a,0x64430300,0x661b00aa}},	//   _дела, maux_, lsni, _juuk,
   {{0x6d410301,0x661b0302,0x00000000,0x00000000}},	//   ólap, _muuk, --, --,
   {{0x8fa60303,0x64430304,0xdb1d0149,0x70520037}},	//   _маке, nsni, _omsä, _قنوا,
   {{0x6b840305,0x333f0257,0xbebb023b,0x64430306}},	//   udig, naux_, rbër, isni,
   {{0x49ca0307,0x7d000065,0x37cf0033,0xba290308}},	// [140] алан_, _bárí, িকার, مسلم_,
   {{0x6b840309,0x23b801dc,0xf7830090,0x63b9030a}},	//   sdig, _méja_, _leħħ_, _llwn,
   {{0xdb06023b,0xa2cb030b,0x3e64030c,0x6443030d}},	//   _kokë, _तेस्, löt_, jsni,
   {{0x6d5c030e,0x753a030f,0xbddb0310,0x68400139}},	//   lgra, _setz, nsèn, _aádá,
   {{0x25e6007d,0x3e640311,0x2b400312,0x7c2e0313}},	//   टवली_, nöt_, maic_, lpbr,
   {{0x27380028,0x67220314,0xc7b90103,0xd639004d}},	//   ẩn_, scoj, _elő_, сяці_,
   {{0xe73a0315,0x263600a5,0x68300065,0x6d5c0316}},	//   _веб_, sło_, _dòdò, igra,
   {{0x66e60317,0x938a0318,0x2b400037,0x6d5c0319}},	//   _доба, рска_, naic_, hgra,
   {{0x386d031a,0x00000000,0x00000000,0x00000000}},	//   _ćeri_, --, --, --,
   {{0x23b800fd,0x6d5c031b,0x68300139,0x628400c6}},	//   _déja_, jgra, _gòdò, _šios,
   {{0x213e031c,0x6d5c031d,0xc486031e,0x661b0172}},	//   rath_, dgra, _флек, _zuuk,
   {{0xa2cb02e8,0x333f0257,0x442e031f,0x64580320}},	//   _तेव्, caux_, mpf_, muvi,
   {{0xdefb00c6,0x64580321,0x2294008f,0xdcfe0322}},	//   рын_, luvi, _хиля, _dapč,
   {{0x6d5c0323,0xe2a9015a,0x29180324,0xdce50325}},	//   ggra, _دامن_, _ngra_, _abhā,
   {{0x5ba70326,0xe0d400c1,0x602101d3,0x3b280294}},	//   ораз, _מײַ_, _tēma, _ọyị_,
   {{0x6d5c0080,0xc0530327,0xdb0f0328,0x2d9e0212}},	//   agra, _חזק_, _alcá, öter_,
   {{0x2bbc007d,0x201c00aa,0x64580329,0x7c2e02ac}},	// [150] _ईतरा, _huvi_, huvi, apbr,
   {{0x644302fe,0x6458032a,0x661b032b,0xdce7007f}},	//   ysni, kuvi, _ruuk, zeję,
   {{0xe7190037,0x333f00fd,0xf8b10281,0x7d7a00ca}},	//   ميات_, yaux_, رکس_, _הנתו,
   {{0x6c7a00c1,0x661b032c,0x5c7a006e,0x2cac0212}},	//   _פארפ, _puuk, _פארה, ädde_,
   {{0x333f025a,0x7afd00d9,0xcb9a00a1,0xa5f9032d}},	//   vaux_, _uzst, _הסרט, беду_,
   {{0x6443032e,0x201c001f,0xdb040042,0x3d19007f}},	//   tsni, _ouvi_, chiñ, _दलों_,
   {{0x201c02e5,0x333f0257,0x2246032f,0x64580330}},	//   _nuvi_, taux_, _avok_, guvi,
   {{0x64430331,0x3a390332,0x661b0333,0x3e64007b}},	//   rsni, _kwsp_, _tuuk, yöt_,
   {{0x64430222,0x6d5c0334,0x333f0257,0xdb060113}},	//   ssni, ygra, raux_, _cokè,
   {{0x644301b3,0x201c0172,0x2b40020a,0x23b10206}},	//   psni, _buvi_, zaic_, _máji_,
   {{0x6d5c0335,0x645c007a,0x333f00fd,0x6458020a}},	//   vgra, _ärip, paux_, cuvi,
   {{0xbebb023b,0x201c002b,0x3e6400c2,0xb4fa00ca}},	//   rcën, _duvi_, töt_, _הפעי,
   {{0x3fc9001c,0xcaea0336,0x6d5c0337,0xbddb00b3}},	//   تگوی_, _झुंड_, tgra, trèp,
   {{0xda1f0251,0x6d5c0338,0x3e640339,0x00000000}},	//   _बढ़त_, ugra, röt_, --,
   {{0x9f92033a,0xdb06023b,0x2246033b,0x3156006e}},	//   lší_, _tokë, _zvok_, _זיצן_,
   {{0x65610124,0x9f420094,0x3a2b033c,0x00000000}},	//   _lclh, boká_, _btcp_, --,
   {{0x6e4600e3,0x9f92033d,0x6d5c033e,0x2b40033f}},	// [160] _عندم, nší_, pgra, raic_,
   {{0x2b400340,0x64580027,0x00000000,0x00000000}},	//   saic_, yuvi, --, --,
   {{0x9d1b00c1,0x9f920031,0x00000000,0x00000000}},	//   _לויט, hší_, --, --,
   {{0xdc9b0341,0x6b5a00ae,0x2cbe0342,0x00000000}},	//   _היטל, _ушор_, ıydı_, --,
   {{0x9f920343,0x7f8d006e,0x656d0344,0x256f0345}},	//   jší_, ינאַ, đahn, kılı_,
   {{0x64580346,0x8afb00a1,0x9f92033d,0x00000000}},	//   tuvi, _להכי, dší_, --,
   {{0x80d000c7,0x69ce0347,0xdd57006e,0x00000000}},	//   _সুন্, _imbe, לבסט_, --,
   {{0x64580348,0xdb060036,0x7d070349,0xc8db00d7}},	//   ruvi, _pokè, léré, _הקלט,
   {{0x201c034a,0x6b86034b,0xd046013c,0x00000000}},	//   _suvi_, _makg, əmək, --,
   {{0x7d0700fd,0x9f4200d4,0x00000000,0x00000000}},	//   néré, voká_, --, --,
   {{0x69ce005c,0x2615034c,0xf99300ca,0x00000000}},	//   _mmbe, _फूटी_, גרת_, --,
   {{0x09b9034d,0x6028030b,0x78fb006e,0x57da0034}},	//   _इत्य, _něme, מפיו, _भदोह,
   {{0x69ce034e,0x9f4b034f,0x00000000,0x00000000}},	//   _ombe, nocé_, --, --,
   {{0x9f420146,0x442c0350,0x00000000,0x00000000}},	//   roká_, _ktd_, --, --,
   {{0x9f42025b,0x6b860351,0x7d070352,0x00000000}},	//   soká_, _bakg, déré, --,
   {{0x69ce0353,0x23cf0354,0x23b80139,0x00000000}},	//   _ambe, तोपद, _méjo_, --,
   {{0x3edf0129,0xdcf200d9,0x6b860355,0x442c00ca}},	// [170] _kpọọ_, īgāk, _dakg, _ltd_,
   {{0x6e2d0356,0xceb200c1,0xaca30134,0x64480357}},	//   _itab, _סיי_, _asụg, _ovdi,
   {{0xa3be0034,0xd7fb0358,0xf1b3006e,0x442c0227}},	//   ीफा_, буд_, עסע_, _ntd_,
   {{0x69ce0359,0x256f008b,0x68f50146,0x6282035a}},	//   _embe, zılı_, _vyzd, _osoo,
   {{0xd2460068,0x6448035b,0x442c035c,0x256f01e8}},	//   _جن_, _avdi, _atd_, yılı_,
   {{0xcb120054,0x9f92035d,0x68f50220,0x93b50023}},	//   _שלך_, vší_, _tyzd, _cũn,
   {{0x6282035e,0x2409035f,0xa5060360,0x00000000}},	//   _asoo, онки_, меша_, --,
   {{0x9f92030b,0x6e2d0361,0xdcfe01d3,0xc2e60033}},	//   tší_, _otab, _japā, খেছি_,
   {{0x6e2d023f,0x2a690362,0xd7660103,0x672902a1}},	//   _ntab, ntab_, _تنقی, _ifej,
   {{0x9f920363,0xab5b0364,0x442c0365,0xdcfe00e8}},	//   rší_, _flüg, _ftd_, _lapā,
   {{0xd37100e3,0x6e2d0366,0x256f0367,0xe7c402d5}},	//   _لها_, _atab, rılı_, लोकप,
   {{0x9f920368,0x2a690369,0x672902a1,0x256f0233}},	//   pší_, ktab_, _jfej, sılı_,
   {{0xee37036a,0x6e2d009c,0x63ab036b,0xa294036c}},	//   мня_, _ctab, _iogn, _паці,
   {{0x79870067,0x6e2d0037,0x6b86036d,0x00000000}},	//   _najw, _dtab, _sakg, --,
   {{0x6e2d036e,0x2c8700b6,0x98ba0325,0x7f4d0090}},	//   _etab, vídá_, kapā_, _fdaq,
   {{0xeb97036f,0x67290090,0x00000000,0x00000000}},	//   мис_, _nfej, --, --,
   {{0x63ab0370,0x63a60222,0xf1e1023a,0x6b860371}},	// [180] _mogn, ökni, _पदान, _vakg,
   {{0x63ab01ab,0x7bcf0372,0x00000000,0x00000000}},	//   _logn, _emcu, --, --,
   {{0x7649020d,0x6b860113,0x2d9a0231,0xe78602e1}},	//   _avey, _takg, _inpe_, дуло,
   {{0x442c0373,0x2a69023e,0xb7be0033,0x61aa0374}},	//   _rtd_, btab_, েক্ট, _चक्ष,
   {{0x4cd30081,0x442c0375,0x4733004d,0x7d07020d}},	//   _দুপু, _std_, тніс, péré,
   {{0x69ce0376,0x442c0332,0x63ab009c,0x56930095}},	//   _umbe, _ptd_, _aogn, ташт,
   {{0x442c016d,0x644d01d3,0x76490154,0x6282010a}},	//   _qtd_, ņain, _evey, _ssoo,
   {{0x63ab0377,0xae1e0285,0x00000000,0x00000000}},	//   _cogn, पदान_, --, --,
   {{0xe7bd0378,0x52140379,0x2d9a037a,0x63ab037b}},	//   ्फरप, ндит, _onpe_, _dogn,
   {{0x442c0167,0x602802c6,0x6e2d0090,0x2d8a0141}},	//   _ttd_, _němc, _rtab, jdbe_,
   {{0x39570054,0x63ab037c,0x195700ca,0x00000000}},	//   ושים_, _fogn, וביל_, --,
   {{0x62820197,0xe29a01b3,0x26c6023e,0x63ab0036}},	//   _tsoo, _мае_, ozoo_, _gogn,
   {{0xdde2037d,0x26c6037a,0x31c6037e,0x00000000}},	//   _šušk, nzoo_, _оскв, --,
   {{0xe0cf037f,0x63ab0380,0x69de0381,0x00000000}},	//   ازی_, _zogn, jnpe, --,
   {{0xdb060018,0x7987022b,0x00000000,0x00000000}},	//   _elkü, _rajw, --, --,
   {{0x2a690382,0x2cac0212,0x3eae0052,0x2d9a0383}},	//   ttab_, ädda_, ëjtë_, _enpe_,
   {{0x6e2d0384,0x27ef01df,0xef1f0367,0x26c601fa}},	// [190] _utab, vogn_, ndüm_, jzoo_,
   {{0x2a690385,0x67290090,0x3df4007b,0x00000000}},	//   rtab_, _sfej, _изыс, --,
   {{0x2a690006,0x917b0023,0x2251007f,0x998f01f9}},	//   stab_, _hệ_, ązki_, égű_,
   {{0x2a690383,0xaad00386,0x7bcf019f,0x00000000}},	//   ptab_, _सेवक, _umcu, --,
   {{0xcb360054,0x79870387,0x63ab0388,0x1fc10033}},	//   _ראשי_, _tajw, _rogn, _উদাস,
   {{0x63ab0389,0x6594038a,0x05790076,0x00000000}},	//   _sogn, качу, سمعة_, --,
   {{0x672902a1,0x917b020b,0x00000000,0x00000000}},	//   _tfej, _lệ_, --, --,
   {{0x26c601fa,0x7c2a0231,0x00000000,0x00000000}},	//   bzoo_, _éfre, --, --,
   {{0x645c038b,0x63ab038c,0xd24e0190,0x00000000}},	//   _årin, _vogn, مني_, --,
   {{0x63ab0381,0x00000000,0x00000000,0x00000000}},	//   _wogn, --, --, --,
   {{0x6724038d,0x63ab038e,0xddcb0233,0xe0d600ae}},	//   žije, _togn, _şişe, евэ_,
   {{0x8fa600b4,0x00000000,0x00000000,0x00000000}},	//   хаме, --, --, --,
   {{0xf1a800d1,0xe299038f,0x00000000,0x00000000}},	//   سایه_, _хал_, --, --,
   {{0x92c10390,0xdd920391,0xc0e50392,0x7bdf0393}},	//   ığın, دوس_, _полк, enqu,
   {{0xfce30394,0xddcd00d3,0x61e60103,0xeb9a0395}},	//   горо, _spaţ, ékle, пив_,
   {{0xa2d4007d,0x7a16022b,0xfaa601b6,0x00000000}},	//   _बेड्, _pņto, набо, --,
   {{0xf41200c1,0xdb060383,0x39560396,0xfbd1030b}},	// [1a0] רפן_, _alkò, ењет, _सगरम,
   {{0xac860396,0x26c6023e,0x6f040201,0xdcfe00ae}},	//   _згол, vzoo_, _izic, _capă,
   {{0xa81a0397,0x2fc001ff,0xc17200ca,0x00000000}},	//   ستار_, _klig_, רחב_, --,
   {{0xfaa60398,0xe6660399,0x00000000,0x00000000}},	//   _замо, етко, --, --,
   {{0x98ac0092,0x91b40034,0x7bd6039a,0x25ac00d8}},	//   ğlıq_, ेसमै, miyu, _podl_,
   {{0xe5a3039b,0x7bd6039c,0x98ac0092,0x2fc000ee}},	//   личи, liyu, şlıq_, _llig_,
   {{0xdbe30032,0x26c6023e,0xa3cc039d,0x3c3e02c6}},	//   _béèn, szoo_, रफल_, nův_,
   {{0x7bd6039e,0x6f04039f,0x00000000,0x00000000}},	//   niyu, _ozic, --, --,
   {{0x66e303a0,0x60c401c2,0x6aa40072,0x6f040169}},	//   _бота, _ƙimo, nxif, _nzic,
   {{0x64a603a1,0xb5ca0068,0xbbad03a2,0xef1f03a3}},	//   _паза, _عوام_, _टक्क, rdüm_,
   {{0xdb120088,0x3f8903a4,0x6f0403a5,0x7f5903a6}},	//   _ágæt, _paau_, _azic, манс_,
   {{0x64580218,0x00000000,0x00000000,0x00000000}},	//   mrvi, --, --, --,
   {{0x661a03a7,0x644a0324,0x2e2603a8,0x7bc403a9}},	//   _kitk, lsfi, _côf_, dhiu,
   {{0x661a03aa,0x9f4b030b,0x917b00fe,0x00000000}},	//   _jitk, mocí_, _vệ_, --,
   {{0x317e03ab,0x661a03ac,0xb3a400df,0x7bd60167}},	//   metz_, _mitk, _खचाख, fiyu,
   {{0x7bc403ad,0x7bdf00e5,0xd1380138,0x317e03ae}},	//   ghiu, unqu, lbą_, letz_,
   {{0x66d30068,0x9f4b0314,0x443e0085,0x6d5a0076}},	// [1b0] _műkö, nocí_, _lwt_, ótac,
   {{0x661a03af,0xd8e703b0,0x317e0364,0x644a03b1}},	//   _nitk, нцеп, netz_, ksfi,
   {{0x6d4703b2,0x20090028,0xa3c003b3,0x201b014b}},	//   maja, _khai_, ँसा_, _épis_,
   {{0x6d4703b4,0x2009023e,0x7bc403b5,0x661a03b6}},	//   laja, _jhai_, chiu, _aitk,
   {{0x661a03b7,0x6b9d03b8,0x6b8d03b9,0x46a4004d}},	//   _bitk, _insg, mdag, лаїв,
   {{0x6d4703ba,0xb90700c7,0x443e03bb,0xab5b0364}},	//   naja, _পর_, _bwt_, _flüc,
   {{0xab5b02e2,0x80d00081,0x443e03bc,0x644a03bd}},	//   _glüc, _সুস্, _cwt_, gsfi,
   {{0x6d4702dd,0x69d703be,0xe65d01e8,0xe29903bf}},	//   haja, lixe, ştığ, даи_,
   {{0xdb0f015e,0x24850063,0x6b8d02ac,0x661a00d8}},	//   _alcú, _wslm_, idag, _fitk,
   {{0x6d4703c0,0x27fd00f0,0x93bc020a,0x2fc0009c}},	//   jaja, llwn_, _stăt, _slig_,
   {{0x6d4703c1,0x2fc001bb,0xf99203c2,0x443e03c3}},	//   daja, _plig_, ברי_, _gwt_,
   {{0x200903c4,0x6b8d01c0,0xc3cb03c5,0x661a0381}},	//   _chai_, jdag, _عظام_, _zitk,
   {{0x63a9029b,0x93b60054,0x6b8d032e,0xddcd03c6}},	//   mjen, _שלנו_, ddag, _spaš,
   {{0x6d4703c7,0x7bd60193,0x65630023,0xfce603c8}},	//   gaja, wiyu, ngnh, вого,
   {{0x22510034,0x7bd60169,0x69d70072,0x2009009c}},	//   ązku_, tiyu, dixe, _fhai_,
   {{0x63a903c9,0x63bb03ca,0x6b8d03cb,0x1621030b}},	//   njen, nkun, gdag, मदार_,
   {{0x6d4703cc,0x395100e7,0x4b2300d6,0x63bb03cd}},	// [1c0] baja, _bdzs_, рмув, ikun,
   {{0x6d4703ce,0x63a903cf,0x2bc60034,0x76590150}},	//   caja, hjen, रोजा, drwy,
   {{0x63bb03d0,0x63a903d1,0x661a03d2,0x6e2403d3}},	//   kkun, kjen, _ritk, _huib,
   {{0x6e240051,0x7bd6005c,0x63a903d4,0x661a03d5}},	//   _kuib, qiyu, jjen, _sitk,
   {{0x63a903d6,0x661a02fd,0x443e03d7,0x765902ad}},	//   djen, _pitk, _swt_, grwy,
   {{0x69c503d8,0xd49a03d9,0x98660103,0x645803da}},	//   chhe, дри_, _لیئے_, trvi,
   {{0x2cb8009c,0x18a303db,0x98a30231,0x6e2403dc}},	//   nyrd_, _карм, _кире, _luib,
   {{0x63a903dd,0x63bb03de,0x6d4703df,0xef1f03e0}},	//   gjen, gkun, zaja, rdük_,
   {{0xfbd30054,0x200902ad,0x6d4703e1,0x661a03e2}},	//   יתה_, _rhai_, yaja, _titk,
   {{0xa3f5000d,0x661a0305,0x200903e3,0x8af000a7}},	//   ější_, _uitk, _shai_, lgəs,
   {{0x6d4703e4,0x63a903e5,0xd138013f,0x200900de}},	//   vaja, bjen, rbą_, _phai_,
   {{0x317e01bf,0x63bb02e2,0x6d4703e6,0x63a903e7}},	//   setz_, ckun, waja, cjen,
   {{0x6d4703e8,0x6e2403e9,0x00000000,0x00000000}},	//   taja, _cuib, --, --,
   {{0x6e2403ea,0x69d703eb,0xbf9b02ac,0x00000000}},	//   _duib, xixe, dlêe, --,
   {{0x6d4703ec,0x80a303ed,0x6b8d03ee,0x7640022e}},	//   raja, _نمون, tdag, _lwmy,
   {{0x5f7703ef,0x20090051,0x6d4703f0,0x8bc4004b}},	//   _شاعر, _uhai_, saja, асуд,
   {{0x6d4703f1,0xf96b03f2,0xfaff0216,0x6e2400fc}},	// [1d0] paja, дрей_, _ecën_, _guib,
   {{0x63bb03f3,0x6b8d032e,0x68fc03f4,0x7e6d0372}},	//   zkun, sdag, _byrd, _iqap,
   {{0x3eb903f5,0x69d703f6,0xa2d4014e,0x6b8d004d}},	//   lyst_, rixe, _बेस्, pdag,
   {{0x765902ad,0x69c50052,0xe115006e,0x7c2a0113}},	//   trwy, shhe, אַנז_, _éfra,
   {{0x6d4503f7,0xe78403f8,0x63a903f9,0x61e100f0}},	//   _keha, рухо, vjen, ynll,
   {{0x6d4503fa,0xa93403fb,0xa50903fc,0x63bb029a}},	//   _jeha, _верш, нела_, wkun,
   {{0x63a903fd,0x7afd03fe,0x63bb03ff,0x69d50090}},	//   tjen, _hyst, tkun, _imze,
   {{0x7afd0400,0x93bc00ae,0x9f420031,0x6d450401}},	//   _kyst, _stăr, sokú_, _leha,
   {{0x63a90402,0x59b70403,0x00000000,0x00000000}},	//   rjen, _आकार, --, --,
   {{0x63bb0404,0x6d450405,0x63a90406,0x004701f9}},	//   skun, _neha, sjen, نیتي_,
   {{0x7afd0407,0x04670408,0x1c1f0409,0x63a902a1}},	//   _lyst, _штам, _मंगल_, pjen,
   {{0xdb0f0396,0xc43a040a,0x442500d3,0xdb06040b}},	//   _você, _נתני, _iul_, _loká,
   {{0x4425040c,0x6d45040d,0x69d5040e,0x7afd040f}},	//   _hul_, _beha, _omze, _nyst,
   {{0x44250410,0x61450396,0x4ed5004d,0x42520411}},	//   _kul_, _сека, рюют, _انور,
   {{0x224d0412,0x44250413,0x6d450414,0x7e6d0415}},	//   lsek_, _jul_, _deha, _eqap,
   {{0x7afd0094,0x44250006,0x2d8c0416,0x7dd40092}},	//   _byst, _mul_, žde_, _müsə,
   {{0x7afd0150,0xdcfc025b,0x44250417,0xa95a00b9}},	// [1e0] _cyst, merč, _lul_, فجار_,
   {{0x6d450418,0x7afd0419,0x3f82041a,0xd5b10023}},	//   _geha, _dyst, leku_, _nó_,
   {{0xdb060074,0x7afd041b,0x31ba00c1,0x9f4b016d}},	//   _doká, _eyst, עזענ, locá_,
   {{0x6d4502a7,0x224d01e8,0x3f8200aa,0x46ea001f}},	//   _zeha, ksek_, neku_, нден_,
   {{0x7f3b00c1,0x7afd0150,0x68fc00f0,0x6441041c}},	//   גענו, _gyst, _wyrd, _awli,
   {{0x4425041d,0xd5b10019,0x6594041e,0x7434041f}},	//   _bul_, _có_, раку, анкф,
   {{0x44250420,0xe56f0214,0xd4670291,0x88840421}},	//   _cul_, سطو_, гије_, _خیان,
   {{0x44250422,0x3f8203c6,0x53980423,0x93b40424}},	//   _dul_, jeku_, твия_, рбиц,
   {{0xbebb023b,0x224d00f9,0xdb060103,0x798e0425}},	//   ncët, gsek_, _elkö, _kabw,
   {{0xc05a0426,0x602100d9,0x44250427,0xdb0f0428}},	//   нім_, _lēmu, _ful_, _docè,
   {{0x44250429,0x798e042a,0x09f70289,0x224d0062}},	//   _gul_, _mabw, רמים_, asek_,
   {{0x6d45042b,0xddc40090,0x6d5a0301,0x7c25042c}},	//   _seha, _epiż, ótan, _ruhr,
   {{0x6d45042d,0x4425042e,0x00000000,0x00000000}},	//   _peha, _zul_, --, --,
   {{0xbb1b025a,0x4425042f,0x7afd0430,0x798e0198}},	//   _maît, _yul_, _ryst, _nabw,
   {{0x6d450431,0x44250432,0x3ebf0433,0x48bf0033}},	//   _veha, _xul_, šut_, _আশ্র,
   {{0xc4c40434,0x7afd0084,0x246e0092,0x798e010a}},	//   _ہے_, _pyst, _cəmi_, _aabw,
   {{0x6d45007a,0x798e0435,0x2d85020d,0x79d5004d}},	// [1f0] _teha, _babw, ôles_, ажає,
   {{0x7afd0436,0xdcf501d3,0x2b490072,0x00000000}},	//   _vyst, udzē, saac_, --,
   {{0x7afd0067,0x2d83023f,0xd7c8001c,0xdb060437}},	//   _wyst, meje_, گونه_, _voká,
   {{0x31e10438,0x2d830439,0x7afd043a,0xe71900e3}},	//   _पद्ध, leje_, _tyst, نيات_,
   {{0x4425043b,0xa2d4000c,0x98aa01d3,0xd7c80286}},	//   _sul_, _बेल्, ējām_, دونه_,
   {{0x44250092,0x2d83043c,0xf4830260,0xa3d2030b}},	//   _pul_, neje_, ماعی, होस_,
   {{0x4425043d,0x00000000,0x00000000,0x00000000}},	//   _qul_, --, --, --,
   {{0x4425043e,0xddc4043f,0xdb1d0088,0x2d830440}},	//   _vul_, _spiż, _umsó, heje_,
   {{0x6b8f0441,0x290c00e3,0xae150442,0x2d830443}},	//   _macg, _údar_, णगान_, keje_,
   {{0x2d830444,0x44250445,0x224d0446,0x41b5008f}},	//   jeje_, _tul_, rsek_, рсит,
   {{0x2d830447,0x66ca0018,0x44250188,0x00000000}},	//   deje_, _töké, _uul_, --,
   {{0xe0d60448,0x224d0449,0xbddb03a9,0x52d9007b}},	//   рвю_, psek_, ksès, _имею_,
   {{0x2bc900b7,0x00000000,0x00000000,0x00000000}},	//   रसना, --, --, --,
   {{0x3f82044a,0x2d8302a4,0x628b0188,0xdce50154}},	//   seku_, geje_, _isgo, _echč,
   {{0xdd0e026a,0x8c46044b,0x93bc044c,0x798e0154}},	//   _dışa, ребе, _ouăl, _rabw,
   {{0xc05200a1,0x798e044d,0xb7b00033,0x00000000}},	//   _וזה_, _sabw, _কষ্ট, --,
   {{0xeab7044e,0x09c10033,0x2d83044f,0x00000000}},	// [200] айт_, োচনা, beje_, --,
   {{0xf0a90065,0xdebb021e,0x00000000,0x00000000}},	//   _gbàà_, _סמיל, --, --,
   {{0xdca60450,0x6e220451,0xc8ca0452,0x798e010a}},	//   _тани, _èobb, خوان_, _vabw,
   {{0x6e93010d,0x628b00f0,0x798e0453,0x00000000}},	//   _الیا, _osgo, _wabw, --,
   {{0xb8fd0454,0x23a90455,0x6b840456,0xe5340457}},	//   _ते_, कानद, meig, бель,
   {{0xb8660018,0x6b840458,0x00000000,0x00000000}},	//   _پاسو, leig, --, --,
   {{0x92e200c7,0x29270220,0x03c60459,0x628b01ee}},	//   _ধরে_, ávať_, исим, _asgo,
   {{0x0fc10081,0x6b84045a,0x290a045b,0x87f900ae}},	//   _উদ্ধ, neig, _izba_, _бэут_,
   {{0x27e60009,0x2d83045c,0xc1a600f6,0xa3c70409}},	//   mnon_, yeje_, ајни, _उतर_,
   {{0x6b84045d,0x2259045e,0xda16045f,0x629900eb}},	//   heig, áska_, थगित_, _drwo,
   {{0x628b0460,0x60cd03e3,0xc9530327,0x5f9500ae}},	//   _esgo, _ƙama, חמת_, бинт,
   {{0x27e60461,0xa3d20409,0x6b840462,0x2d830463}},	//   nnon_, होश_, jeig, weje_,
   {{0x63a20464,0x5f940465,0x2d830466,0x91e60467}},	//   _inon, цият, teje_, _коде,
   {{0x7bc60468,0xa3d20469,0x27e60063,0x63a20031}},	//   _alku, होर_, hnon_, _hnon,
   {{0x2d83046a,0xf2e80081,0x7054046b,0x63a20154}},	//   reje_, _পরিণ, _انبا, _knon,
   {{0x628b02e0,0xe45700c1,0x2ba4001f,0xf45700d7}},	//   _ysgo, יילט_, ојув, יילר_,
   {{0x2905046c,0x27e6019c,0x290a0154,0x2b1a02d5}},	// [210] _šla_, dnon_, _azba_, _मृदु_,
   {{0x3947046d,0x780f046e,0x2d830052,0x00000000}},	//   úns_, िष्क_, qeje_, --,
   {{0x63a2046f,0x6b8401d3,0xbef80470,0x6d5700a7}},	//   _onon, beig, _مریض_, _idxa,
   {{0x27e60471,0x20140472,0xdc9a006e,0x63a20361}},	//   gnon_, _èxit_, _עירל, _nnon,
   {{0xc987002d,0x6e220231,0x1ade0473,0x00000000}},	//   _куви, _éobt, _नेपथ, --,
   {{0x63a20474,0x27e60475,0x683302a1,0xdcfe00b6}},	//   _anon, anon_, _aħde, _napě,
   {{0x057400cd,0x97a70476,0x27e60124,0x2905034f}},	//   تاند, _крал, bnon_, _ála_,
   {{0x69c70477,0xdcfc01d3,0xc245004d,0xab5b00aa}},	//   _hlje, nerā, бник, _olüm,
   {{0xe1f90478,0xdd2c013f,0xe7300018,0x248c0479}},	//   лги_, vėži, _آصف_, _esdm_,
   {{0x6b8402dc,0x63a2047a,0xbec400c6,0x00000000}},	//   zeig, _enon, šūki, --,
   {{0x69c70268,0x7dc20220,0xf0760018,0x6e3601cb}},	//   _mlje, _dôsl, میوں_, _styb,
   {{0x7dc20181,0x6d57047b,0x9f420094,0x6299047c}},	//   _pôso, _adxa, boký_, _trwo,
   {{0x69c7047d,0x6fc60037,0xdcfc01d3,0x62990169}},	//   _olje, _cóca, derā, _urwo,
   {{0x6b84013b,0xb6da006e,0x6feb007f,0x225f047e}},	//   weig, אַלט, ręca, mruk_,
   {{0x6b84047f,0xdb1d00b3,0x7d0902c6,0xacea00ae}},	//   teig, _alsà, řesn, умва_,
   {{0xfd690134,0xdcfe0031,0x6fc60076,0x00000000}},	//   _kepụ, _topľ, _fóca, --,
   {{0x69c70480,0xfaa3044b,0x6b840481,0x7f3b006e}},	// [220] _blje, пато, reig, _געפו,
   {{0x6b840482,0x5d8600e3,0x3f920483,0xfd690129}},	//   seig, _الدل, _hayu_, _mepụ,
   {{0x3f920484,0x6d4e0485,0x291c0486,0x6fc60487}},	//   _kayu_, maba, äva_, _zóca,
   {{0x6d4e0488,0x7bc60489,0x78a302c3,0xd62a022f}},	//   laba, _ulku, ånva, годе_,
   {{0xa3ab048a,0x2b40048b,0x3f920044,0x248c0063}},	//   खान_, mbic_, _mayu_, _ssdm_,
   {{0x6d4e048c,0x225f048d,0x3f92048e,0xe1e7048f}},	//   naba, druk_, _layu_, _رس_,
   {{0x2bbf0490,0xef1f0491,0x6d4e0072,0x00000000}},	//   _एकमा, ndür_, iaba, --,
   {{0x69de0492,0x6d4e0493,0xa85700a1,0x69c700e7}},	//   lipe, haba, _לילה_, _zlje,
   {{0x6d4e0494,0x7dcb008e,0xaade0096,0xdbdc0139}},	//   kaba, _hüse, _नेमक, _báún,
   {{0x69de0495,0x6d4e0496,0x8c000081,0xfd690134}},	//   nipe, jaba, ্দিন_, _depụ,
   {{0x64a30497,0x672d00cb,0x3f920498,0x9f420146}},	//   _нафа, žaje, _bayu_, soký_,
   {{0x69de00d3,0x225f0499,0x63a2049a,0x00000000}},	//   hipe, bruk_, _unon, --,
   {{0x69de049b,0x394a049c,0x3f920085,0x2bbf049d}},	//   kipe, _oebs_, _dayu_, _एकबा,
   {{0x6d4e049e,0x30a6049f,0x3fc900cd,0xea010023}},	//   gaba, _грив, ادگی_, _đắp_,
   {{0x61fa00b3,0x69de04a0,0x3f9203e3,0xc05a04a1}},	//   motl, dipe, _fayu_, _сіл_,
   {{0x69c70292,0x61fa0342,0x224603a9,0xa3ab00bc}},	//   _slje, lotl, _kwok_, खाय_,
   {{0x6d4e04a2,0x69c704a3,0x8d8700ae,0x2a6004a4}},	// [230] baba, _plje, _лунд, grib_,
   {{0x6d4e0060,0x6f0d04a5,0x61fa04a6,0x7f4f028d}},	//   caba, _izac, notl, lacq,
   {{0x2fc904a7,0x66030094,0x6d4104a8,0x3f9200d1}},	//   _klag_, vlnk, ılad, _yayu_,
   {{0x1da704a9,0x61fa04aa,0x7f4f0036,0x6e220131}},	//   खावत, hotl, nacq, _éobr,
   {{0x7bdf04ab,0x7bcd04ac,0x61fa04ad,0x00000000}},	//   miqu, mhau, kotl, --,
   {{0x7bdf04ae,0x69de04af,0x7bcd04b0,0x99c70103}},	//   liqu, cipe, lhau, _اُسے_,
   {{0xddcc01b3,0x224600dc,0x6b5f0139,0x996502c6}},	//   _žiūr, _awok_, _gàgà, _kůži_,
   {{0x7bdf04b1,0x6d4e04b2,0xe3b904b3,0x7bcd04b4}},	//   niqu, zaba, рби_, nhau,
   {{0x66030181,0x6d4e04b5,0x27ff04b6,0x3f9204b7}},	//   plnk, yaba, _ikun_, _rayu_,
   {{0x2fc90124,0x6d4e04b8,0x3f9204b9,0x7bdf00fd}},	//   _alag_, xaba, _sayu_, hiqu,
   {{0x2fc904ba,0x6f0d04bb,0x7bdf03a9,0x3f9204bc}},	//   _blag_, _azac, kiqu, _payu_,
   {{0x6d4e04bd,0x27ff03e5,0x69de04be,0x2fc904bf}},	//   waba, _jkun_, zipe, _clag_,
   {{0x6d4e04c0,0x7bdf04c1,0xf8a6009d,0x7bcd04c2}},	//   taba, diqu, _गप्प, dhau,
   {{0xdb0f002b,0x2b4b04c3,0x3f920113,0x112b0120}},	//   _cocí, _aecc_, _wayu_, _сюди_,
   {{0x6d4e04c4,0x7bdf04c5,0x7f4f0451,0xcfaa04c6}},	//   raba, fiqu, bacq, _ناظم_,
   {{0x7bdf04c7,0x6d4104c8,0x7e660129,0x2fc901b9}},	//   giqu, ðlar, pukp, _glag_,
   {{0xe9da04c9,0x6d4e04ca,0x2b4004cb,0x2d9304cc}},	// [240] ака_, paba, rbic_, _faxe_,
   {{0x27ff04cd,0x6d4e04ce,0x27ed0063,0xdcf50367}},	//   _akun_, qaba, _ajen_, _çağr,
   {{0x69de04cf,0x7bcd04d0,0x088a00ae,0x320504d1}},	//   ripe, bhau, рбей_, illy_,
   {{0xeb9a04d2,0x394a04d3,0x7bdf04d4,0x7bcd04d5}},	//   _тим_, _webs_, ciqu, chau,
   {{0x61fa04d6,0xacf6001c,0x2bbf04d7,0xdcfc044c}},	//   yotl, _دسکت, _एकता, beră,
   {{0x69de01e5,0x27ed0332,0xfe9b0089,0x75d30037}},	//   qipe, _ejen_, יינמ, وينا,
   {{0x69dc00e3,0x6fc60072,0xab5b042c,0x602802c6}},	//   _imre, _nóco, _blüh, _těmi,
   {{0x78a104d8,0xa3ba00e3,0x27ed023b,0x7bc404d9}},	//   _álva, شاعر_, _gjen_, nkiu,
   {{0x6f0404da,0xa3db009f,0x69dc0085,0x61fa04db}},	//   _nyic, _डगर_, _kmre, totl,
   {{0x2fc904dc,0x61e801bf,0x7bdf0372,0x00000000}},	//   _slag_, undl, ziqu, --,
   {{0xeb0704dd,0x2fc904de,0x61fa00b3,0xf1d904df}},	//   _शर्त_, _plag_, rotl, योधन,
   {{0x932500bf,0x320500a1,0xea0100de,0x7bdf04e0}},	//   _فرهن, ally_, _đập_, xiqu,
   {{0x442c0429,0x69dc04e1,0x6b960150,0x2fc904e2}},	//   _hud_, _omre, ddyg, _vlag_,
   {{0x72e900c1,0x2000010a,0x6e3d04e3,0x7a410139}},	//   _פֿײַ, _ekii_, rpsb, _látò,
   {{0x7bdf04e4,0x442c00ae,0x7bcd04e5,0x3a23029a}},	//   tiqu, _jud_, thau, _rijp_,
   {{0x5a3504e6,0x69dc04e7,0x7bcd04e8,0x3a3904e9}},	//   знат, _amre, uhau, _ptsp_,
   {{0x7bdf04ea,0x442c04eb,0x7bcd04ec,0x2d9304ed}},	// [250] riqu, _lud_, rhau, _taxe_,
   {{0x7bdf04c7,0x442c04ee,0x7bcd04ef,0xaca30134}},	//   siqu, _oud_, shau, _apụg,
   {{0x6e2d01fa,0x7bdf04f0,0x20ca04f1,0x442c04f2}},	//   _huab, piqu, ानिध, _nud_,
   {{0x6e2d04f3,0x62820113,0x69dc0233,0xdb060032}},	//   _kuab, _opoo, _emre, _lokù,
   {{0xf77004f4,0x27ed00dd,0xd6db04f5,0x6282023e}},	//   ضان_, _vjen_, јте_, _npoo,
   {{0x442c04f6,0x6e2d04f7,0x644800eb,0x20ca04f8}},	//   _bud_, _muab, _bwdi, ानाध,
   {{0x27ff04f9,0xd838004b,0xddcd04fa,0x62820172}},	//   _tkun_, _мэт_, _opaž, _apoo,
   {{0x442c02a1,0x27ff04fb,0x799504fc,0xc24504fd}},	//   _dud_, _ukun_, _hazw, пник,
   {{0x64480090,0x79950201,0x442c04fe,0x672904ff}},	//   _ewdi, _kazw, _eud_, _igej,
   {{0x442c00e3,0x69c50500,0xdb060031,0x6f040169}},	//   _fud_, nkhe, _pokú, _ryic,
   {{0x442c0501,0x2a690197,0x6e2d009c,0x7bc40138}},	//   _gud_, huab_, _auab, ykiu,
   {{0x76490502,0x6033044c,0x6e2d0503,0x00000000}},	//   _kwey, _căma, _buab, --,
   {{0x6e2d00b3,0x69c50103,0xd1bb0504,0x67290350}},	//   _cuab, kkhe, _پاشا_, _mgej,
   {{0x69c50505,0x79950067,0x6e2d0167,0x442c0506}},	//   jkhe, _nazw, _duab, _yud_,
   {{0x61e10507,0xdca30508,0x76490361,0x63b90509}},	//   mill, нари, _lwey, _kown,
   {{0x61e1050a,0x6729050b,0x69dc050c,0x6724050d}},	//   lill, _ngej, _smre, žiji,
   {{0x61e1050e,0x37e10081,0x629b00c2,0x7995050f}},	// [260] oill, যকার, nvuo, _bazw,
   {{0x3ea00510,0x6d410511,0xa96a0037,0x67290512}},	//   _irit_, ılac, إمام_, _agej,
   {{0x7649008c,0x7995042c,0x61e10513,0x00000000}},	//   _awey, _dazw, iill, --,
   {{0x442c0514,0x2d980515,0x2d8a0516,0x76490517}},	//   _rud_, ldre_, lebe_, _bwey,
   {{0x61e10518,0xc61500c7,0x2a69022e,0x3f800239}},	//   kill, াদনা_, cuab_, _mbiu_,
   {{0x2d980519,0x61e1051a,0x95f6007f,0x7649030a}},	//   ndre_, jill, इवेट_, _dwey,
   {{0xf746051b,0x6282051c,0xb4c6000d,0x7c260051}},	//   _нево, _spoo, उने_, _kikr,
   {{0x7dcb051d,0x2d8a051e,0x9f590257,0x61e1007b}},	//   _müsa, hebe_, posé_, eill,
   {{0x63b9051f,0x61e10520,0x603300d3,0x2bbf0521}},	//   _down, fill, _răma, _एकसा,
   {{0x442c0522,0x61e10523,0x7c260524,0x7a290138}},	//   _tud_, gill, _likr, _užte,
   {{0x2d8a0525,0xdcf500d9,0x442c0526,0x03260231}},	//   debe_, rdzī, _uud_, _еден,
   {{0x61e10527,0x7c260090,0x00000000,0x00000000}},	//   aill, _nikr, --, --,
   {{0x71a60528,0x1ee70260,0x539b00ca,0x2b52037a}},	//   _надз, سوسی_, _ליאו, dayc_,
   {{0x61e10529,0x4426052a,0x2d8a052b,0x57b9052c}},	//   cill, _hio_, gebe_, _आव्ह,
   {{0x4426052d,0x3ea00154,0x48dc009d,0x7c26052e}},	//   _kio_, _erit_, _गेलो_, _bikr,
   {{0xcf2700e3,0x3ea0052f,0x2d980530,0x6e2d0531}},	//   _عربي, _frit_, adre_, _tuab,
   {{0x44260532,0x61eb0018,0x7c260533,0x2d8a0534}},	// [270] _mio_, _állí, _dikr, bebe_,
   {{0x2d8a0535,0x44260536,0xeb9f0537,0xdb0f00b3}},	//   cebe_, _lio_, _skød_, _vocà,
   {{0x7c260538,0x69c50539,0x2a69006c,0xc1780138}},	//   _fikr, rkhe, suab_, lnės_,
   {{0x61e1053a,0xb8d502d5,0x4426053b,0xf6f5001c}},	//   zill, _जप_, _nio_, وزشگ,
   {{0xcb9a00a1,0x63b9053c,0x61e1053d,0x920c009f}},	//   _וסרט, _rown, yill, हताज_,
   {{0xd1260080,0x06f400cd,0x00000000,0x00000000}},	//   _لم_, رسنج, --, --,
   {{0x442603ce,0xdb0602f1,0x6fc60076,0x63b901cb}},	//   _bio_, _ankè, _sócm, _pown,
   {{0x4426053e,0x3f8b053f,0x29110540,0x67290169}},	//   _cio_, jecu_, _izza_, _ugej,
   {{0x44260541,0x3f8b0542,0x2d8a0543,0x24890206}},	//   _dio_, decu_, yebe_, ňam_,
   {{0x61e10257,0x555500cd,0x3ea00052,0x63b90085}},	//   uill, _آپار, _rrit_, _wown,
   {{0x61e10544,0x7dd00084,0x4426001f,0x629b007b}},	//   rill, _jäse, _fio_, svuo,
   {{0x61e10545,0x44260546,0xdee60547,0x3ea00548}},	//   sill, _gio_, доми, _prit_,
   {{0x7dd00149,0x2d8a0549,0x7c26054a,0x6fc6002b}},	//   _läse, tebe_, _rikr, _hóck,
   {{0x7c26054b,0x61e1054c,0x4426054d,0x3e7602b6}},	//   _sikr, qill, _zio_, ræt_,
   {{0x2d98054e,0x3e76052f,0x2d8a0193,0x3b960396}},	//   rdre_, sæt_, rebe_, мјат,
   {{0x6ff6054f,0x3ea00550,0xea010019,0x2d8a0551}},	//   _تستط, _trit_, _đạp_, sebe_,
   {{0x3b07013d,0x7c260552,0x2bbf0553,0x29110554}},	// [280] дето_, _vikr, _एकरा, _azza_,
   {{0xc9860037,0x7dcb0555,0x7c2603a9,0x602802c6}},	//   بشري, _hüsn, _wikr, _těmt,
   {{0x7c260556,0x8cb50557,0xdb0f0558,0x19b9004d}},	//   _tikr, _उपयो, _vocá, чуть_,
   {{0x672d0559,0xb0b6006e,0xf0b60142,0x00000000}},	//   žajn, ופעס_, ולער_, --,
   {{0x442600c9,0x12e80033,0x2911055a,0xdb0f0143}},	//   _rio_, _পর্দ, _ezza_, _tocá,
   {{0x44260010,0xe5a300d3,0x3f8b015c,0x645e0131}},	//   _sio_, кичи, zecu_, ápio,
   {{0xd497055b,0x52b8055c,0x69ce055d,0x9f820503}},	//   дры_, ेन्स, _ilbe, _dóú_,
   {{0xc17800c6,0x2918007f,0x7c2a0231,0xddcd0090}},	//   ynės_, ągać_, _éfru, _spaż,
   {{0x8cb5055e,0x4426055f,0x24850027,0xd16600e5}},	//   _उपभो, _vio_, _eplm_, мъни,
   {{0x7c3e02e6,0x76420560,0xe29f0088,0x00000000}},	//   _otpr, mpoy, æða_, --,
   {{0x44260561,0xf99300ca,0x3f8b00e7,0x91d40034}},	//   _tio_, דרת_, tecu_, योगै,
   {{0x443e0068,0x72c60562,0xdb0d003e,0x44260563}},	//   _itt_, _обез, kkað, _uio_,
   {{0x441b0130,0x69ce02e5,0xa3ab0251,0x64580407}},	//   _וואס, _olbe, खार_, lsvi,
   {{0x443e0564,0x9f5900b3,0x6fc60503,0x00000000}},	//   _ktt_, mosí_, _lóch, --,
   {{0xc1780138,0xc04f0565,0x443e024a,0xac190566}},	//   snės_, _ші_, _jtt_, зову_,
   {{0x69ce0567,0xcbcd0081,0x5f9500e5,0xd0110568}},	//   _albe, রচ্ছ, _чиит, _حلب_,
   {{0x6feb0067,0xbbbf0569,0x9f42023b,0xda78044e}},	// [290] jęci, _एकीक, zikë_, дях_,
   {{0x443e056a,0x6458056b,0x62770327,0x00000000}},	//   _ott_, ksvi, וגמא_, --,
   {{0x443e056c,0x6d47056d,0xab5b0364,0x2907056e}},	//   _ntt_, mbja, _blüt, æna_,
   {{0x69ce056f,0x64580570,0x7dd00212,0x6d470571}},	//   _elbe, dsvi, _väse, lbja,
   {{0x443e0572,0xb906048a,0x6fc600e3,0x6b8d0573}},	//   _att_, _बे_, _dóch, meag,
   {{0x6d550574,0x9f4200dd,0x443e0575,0xdcee0138}},	//   naza, tikë_, _btt_, gebė,
   {{0x26c902e6,0x64580576,0x443e0231,0x83db007f}},	//   šao_, gsvi, _ctt_, यफलआ,
   {{0x6d550577,0x443e0036,0x9f420052,0xa3d9007f}},	//   haza, _dtt_, rikë_, डों_,
   {{0x443e0578,0x60160579,0x644e003d,0x6458057a}},	//   _ett_, náme, _ħbie, asvi,
   {{0xf1b100e3,0x765b0079,0x6b8d057b,0x00000000}},	//   اءة_, _ivuy, heag, --,
   {{0x443e03e3,0x6d55057c,0x9f42057d,0x672400b6}},	//   _gtt_, daza, liké_, žijt,
   {{0x649a0054,0x6443057e,0x14d80096,0x00000000}},	//   _מסעד, mpni, _भेटण, --,
   {{0xe1ee013d,0x6d550060,0x6d410511,0x3f9e02c6}},	//   _бг_, faza, ılan, ětu_,
   {{0x7bcf0465,0x6d55057f,0x200b0580,0x68330090}},	//   _alcu, gaza, alci_, _aħdm,
   {{0xafe60581,0xb0420019,0xdb860582,0x9f420113}},	//   _покл, _trưở, нгви, hiké_,
   {{0x6b8d0583,0x00000000,0x00000000,0x00000000}},	//   geag, --, --, --,
   {{0x6d550584,0xada602d8,0x20020585,0x7dd002c3}},	// [2a0] baza, _запл, moki_, _väsb,
   {{0xdb0d0102,0x20020586,0x673b010a,0x7bcf037a}},	//   rkað, loki_, _afuj, _elcu,
   {{0x7dcb0587,0x6b8d0588,0x765b02a4,0xdb0d01cd}},	//   _müsl, beag, _avuy, skað,
   {{0x48c30081,0x2d9a0589,0x2ca5052f,0x6016058a}},	//   ্পূর, _hape_, ælde_, lámb,
   {{0x2d9a058b,0x443e058c,0x69d100e8,0x569400c6}},	//   _kape_, _stt_, _ūdeņ, талт,
   {{0x63ab058d,0x6458058e,0xab5b01bf,0x2002058f}},	//   _angn, tsvi, _flüs, hoki_,
   {{0x20020590,0x2d9a0591,0xa3ab00bc,0xb0de0592}},	//   koki_, _mape_, खां_, _फेंग,
   {{0x6458032e,0x443e0593,0x2d9a0594,0x9f590487}},	//   rsvi, _vtt_, _lape_, tosí_,
   {{0x6d550595,0x64580596,0x20020597,0x46b70034}},	//   yaza, ssvi, doki_, _आपयह,
   {{0x27e60598,0x2d9a0599,0x6b8d01e9,0x6458059a}},	//   lion_, _nape_, zeag, psvi,
   {{0xc057059b,0x443e00d9,0x6d55059c,0x30a300e5}},	//   нія_, _utt_, vaza, гряв,
   {{0x6d55059d,0x27e6059e,0x2002059f,0x63060076}},	//   waza, nion_, goki_, _كوال,
   {{0x26c605a0,0x6d5505a1,0x2d9a05a2,0xf8ad0403}},	//   nyoo_, taza, _bape_, _टप्प,
   {{0x7d0305a3,0xbbc905a4,0x2bc905a5,0x27e600f0}},	//   _ønsk, रस्क, रस्थ, hion_,
   {{0x6d5505a6,0x26ec05a7,0x5ff5013d,0x27e605a8}},	//   raza, जपुर_, _изку, kion_,
   {{0x6d5a05a9,0x27e605aa,0x6d5505ab,0xfc300037}},	//   ótar, jion_, saza, صحف_,
   {{0x27e605ac,0x6b8d05ad,0x6d5505ae,0x497505af}},	// [2b0] dion_, reag, paza, клас,
   {{0x601605b0,0x6b8d05b1,0x644300f3,0x00000000}},	//   ráme, seag, ypni, --,
   {{0x6fc60161,0x27e60150,0x2ac70065,0x7e7d05b2}},	//   _sóci, fion_, _bíbú_, ltsp,
   {{0x27e605b3,0x765900f0,0x2d9a05b4,0xb8d900bc}},	//   gion_, tswy, _zape_, _अऊ_,
   {{0xa3b40386,0x7e7d05b5,0x2b4900ae,0x9f4b034f}},	//   ञान_, ntsp, mbac_, locó_,
   {{0xd5bb05b6,0x7e7d05b7,0xa50905b8,0xeabf00fe}},	//   ясе_, itsp, мела_, _ngùi_,
   {{0x27e60150,0x02c900d2,0x7640010a,0xa8020345}},	//   bion_, िन्न, _etmy, ğıra,
   {{0x27e605b9,0x644305ba,0x25ac002b,0x7e7d05bb}},	//   cion_, rpni, _endl_, ktsp,
   {{0x7dd00222,0x2a690069,0xa28305bc,0x765b05bd}},	//   _läsa, nrab_, ایتو, _uvuy,
   {{0x644305be,0x7e7d05bf,0x00000000,0x00000000}},	//   ppni, dtsp, --, --,
   {{0x660305c0,0x200205c1,0x7dd00212,0x7e7d05c2}},	//   monk, toki_, _näsa, etsp,
   {{0xb4bf007d,0x66030201,0x2d9a05c3,0x7e7d05c4}},	//   ुनी_, lonk, _sape_, ftsp,
   {{0x200205c5,0x3f9b0090,0x7e7d05c6,0xbddb00ee}},	//   roki_, _daqu_, gtsp, rpèn,
   {{0x008505c7,0x27e605c8,0xd65600ca,0x2a690537}},	//   _алко, zion_, כישת_, drab_,
   {{0x7e7d05c9,0x200205ca,0x1d0705cb,0x8d760504}},	//   atsp, poki_, вери_, _یادا,
   {{0x27e6025a,0x660305cc,0x225900d4,0x2d9a024a}},	//   xion_, honk, šsku_, _wape_,
   {{0x3ae800bf,0xf1b505cd,0x501b00a1,0x7e7d05ce}},	// [2c0] ربری_, _अचान, _קופו, ctsp,
   {{0xdcfc00d9,0x2616034c,0xd94605cf,0x2492007f}},	//   ndrī, _पीढी_, тежи, łymi_,
   {{0x27e605d0,0x8e3a05d1,0xdb060034,0xdcfc01d3}},	//   tion_, _عسکر_, _pokó, idrī,
   {{0x81ca0033,0x7e6905d2,0x00000000,0x00000000}},	//   রোপ_, šepe, --, --,
   {{0x27e605d3,0xa3ab05d4,0x644105d5,0xb4aa05d6}},	//   rion_, खाई_, _atli, खम्_,
   {{0x27e605d7,0xd94305d8,0xe4e3030b,0xdb060034}},	//   sion_, _вери, _केहि_, _wokó,
   {{0x27e605d9,0x09e305da,0x9f590103,0x644105db}},	//   pion_, _торн, őzés_, _ctli,
   {{0x7bd605dc,0x799c05dd,0xdb1d0113,0xdcfc00e8}},	//   nhyu, _harw, _bosè, edrī,
   {{0x644105de,0x877b00c1,0x660305df,0x76260360}},	//   _etli, _קאמי, bonk, _амаз,
   {{0x660305e0,0xf1a605e1,0x2fc001b9,0xdb1d0113}},	//   conk, трин, _aoig_, _dosè,
   {{0x799c05e2,0x7bd605e3,0x2fc0015e,0xc60e05e4}},	//   _marw, khyu, _boig_, ितीय_,
   {{0x7e7d05e5,0x9f4b05e6,0x6d41008b,0x2fc001f7}},	//   ttsp, vocó_, ılam, _coig_,
   {{0xdbdc003e,0x00000000,0x00000000,0x00000000}},	//   _ráðn, --, --, --,
   {{0xdd11025b,0x2d850146,0x799c05bd,0x644102c3}},	//   _výži, ýle_, _narw, _ytli,
   {{0x61e805e7,0xf41400c1,0x2fd205e8,0x7e7d02db}},	//   midl, ָפּ_, _flyg_, stsp,
   {{0xef67013d,0x660305e9,0x61e805ea,0xdb1d01dc}},	//   _ръко, zonk, lidl, _hosé,
   {{0x799c05eb,0x20090113,0x660305ec,0x5b1505ed}},	// [2d0] _barw, _ikai_, yonk, умат,
   {{0x799c05ee,0xdb1d05ef,0xc27b0327,0x6f0d05f0}},	//   _carw, _josé, ורמי, _iyac,
   {{0x2d910193,0x48c30081,0xd246010d,0x601605f1}},	//   meze_, ্প্র, _گن_, láma,
   {{0x2d9105f2,0x660305f3,0x61e805f4,0x6f0d010a}},	//   leze_, wonk, hidl, _kyac,
   {{0xd2460068,0x799c00f0,0x660305f5,0x6b9d01b5}},	//   _دن_, _farw, tonk, _iasg,
   {{0x2d9105f6,0x799c05f7,0x09ad0033,0x7dd005f8}},	//   neze_, _garw, _গতকা, _läsn,
   {{0x660305f9,0xfd500129,0x6b9d0124,0xb4bf05fa}},	//   ronk, _aghụ, _kasg, ुने_,
   {{0x660305fb,0x7bcd05fc,0x2d9105fd,0x799c0079}},	//   sonk, nkau, heze_, _zarw,
   {{0x66030087,0x2fc005fe,0x6b9d05ff,0x2d910600}},	//   ponk, _roig_, _masg, keze_,
   {{0x20090044,0x61e80601,0xe5730602,0x2d910603}},	//   _akai_, gidl, _خطر_, jeze_,
   {{0x7bcd02fd,0x80ad0455,0x43750604,0x64410605}},	//   kkau, टमें, _مهار, _utli,
   {{0xeb9f052f,0x52750606,0x7bcd023e,0x6f0d02a4}},	//   _skøn_, _буку, jkau, _byac,
   {{0x6f0d0193,0x61e80607,0x6033020a,0xee3700e5}},	//   _cyac, bidl, _mămi, лня_,
   {{0x63bb0608,0x40950609,0x2d91023f,0xfce60408}},	//   ljun, _брит, geze_, гого,
   {{0x6b9d060a,0x8fa6060b,0x6f0d060c,0x32050103}},	//   _basg, _байе, _eyac, moly_,
   {{0x63bb060d,0x7bcd060e,0x6b9d0150,0x799c060f}},	//   njun, gkau, _casg, _sarw,
   {{0xc33202f8,0x60160610,0x799c03a9,0xe7f700c3}},	// [2e0] מון_, cáma, _parw, ंचना_,
   {{0x7bd6023f,0xfd4a004d,0x6b9d036b,0x62990611}},	//   shyu, _язок_, _easg, _mswo,
   {{0x63bb003e,0x6b9d0612,0x07a60613,0x7d7b021e}},	//   kjun, _fasg, лажн, _אריג,
   {{0x61e80614,0x799c0615,0x6b9d00f0,0x8b9600c2}},	//   zidl, _warw, _gasg, _сроч,
   {{0x799c0616,0x63bb0617,0x00000000,0x00000000}},	//   _tarw, djun, --, --,
   {{0x7dd00031,0x9f820139,0x00000000,0x00000000}},	//   _mäso, _kóó_, --, --,
   {{0x61e80618,0x395a01af,0x629905c2,0xdb1d00fc}},	//   vidl, maps_, _aswo, _rosé,
   {{0x2d910619,0x6f090034,0x291803e3,0x63bb061a}},	//   zeze_, żeci, _izra_, gjun,
   {{0xd13000e3,0x46a3061b,0xdb1d04c1,0xdb0f020d}},	//   يمة_, _латв, _posé, _ancê,
   {{0x6f0d05bd,0x2d91044c,0x7a7b0142,0x00000000}},	//   _ryac, xeze_, עריס, --,
   {{0x63bb061c,0x2009061d,0x62990154,0x61e8061e}},	//   bjun, _pkai_, _eswo, ridl,
   {{0x09c1009d,0x2d91061f,0x61e80620,0xddcd010a}},	//   _शक्य, weze_, sidl, _twaŋ,
   {{0x61e80621,0x2d910622,0x6b9d0623,0x320505f1}},	//   pidl, teze_, _rasg, boly_,
   {{0x7dcb0006,0x23270624,0x6aa90335,0x6f0d02a4}},	//   _küsi, _сочи_, _šefo, _vyac,
   {{0x2d910625,0x6b840626,0x6b9d0627,0xd13f00a5}},	//   reze_, ffig, _pasg, łącz_,
   {{0x672d050d,0x2d910628,0x62800629,0x6b8401f9}},	//   žaji, seze_, otmo, gfig,
   {{0x9955062a,0x7bcd062b,0xf96b062c,0x2918062d}},	// [2f0] икац, rkau, ерей_, _azra_,
   {{0x7bcd062e,0x6b9d062f,0x995400ae,0x62800381}},	//   skau, _wasg, йкуц, itmo,
   {{0x6b9d0013,0x3ea90094,0x63bb0630,0x00000000}},	//   _tasg, _hrat_, yjun, --,
   {{0x3ea90631,0x6b9d0076,0xb1130294,0x6d570632}},	//   _krat_, _uasg, nụar, _hexa,
   {{0x29180633,0x248c00dc,0x6d570634,0x395a00ee}},	//   _ezra_, _apdm_, _kexa, baps_,
   {{0x4ade0635,0xb5fd00b6,0x5e58006e,0x7c2f0555}},	//   _नेटव, _ovše, ריגע_, _hicr,
   {{0x23d50636,0xdb060018,0x6d5700a7,0x63bb0637}},	//   ицир, _inká, _mexa, tjun,
   {{0xea0100ef,0x62650638,0xd26500e5,0x00000000}},	//   _đẹp_, авиа, акий, --,
   {{0xe3b604d9,0xd7f80138,0x00000000,0x00000000}},	//   рбы_, _сур_, --, --,
   {{0x6ff201d3,0x98a10555,0x7c2f0639,0xbbd2063a}},	//   māci, lahı_, _licr, _सत्क,
   {{0x7dd00222,0xf99200a1,0x6ff200d9,0x3ea9063b}},	//   _säso, חרי_, lāci, _arat_,
   {{0xf1d9063c,0x7c2f01b9,0x629901c2,0x6d57033c}},	//   योजन, _nicr, _tswo, _aexa,
   {{0x6ff200d9,0x442f01c0,0x6d57063d,0x2bbf063e}},	//   nāci, _iig_, _bexa, _एकजा,
   {{0x3ea90167,0x442f0565,0x7c2f0503,0xc5f2006e}},	//   _drat_, _hig_, _aicr, ַדן_,
   {{0x3ea9063f,0xa3cc0640,0x2d9e0220,0x442f0641}},	//   _erat_, _रकम_, ľte_, _kig_,
   {{0x6ff200d9,0x2d9e0618,0x0b460642,0x442f0643}},	//   kāci, žte_, рнан, _jig_,
   {{0x442f0644,0x7c2f0645,0x3d1c0065,0x3e7f00ae}},	// [300] _mig_, _dicr, _báwí_, cît_,
   {{0x442f0646,0xe9d70647,0x7c2f01b9,0x6ff200e8}},	//   _lig_, аку_, _eicr, dāci,
   {{0xd91000d0,0x60160072,0x6fcd020d,0x442f036b}},	//   سیر_, námo, _bûch, _oig_,
   {{0xc60e0336,0x442f0032,0x7afd0167,0x225f0009}},	//   ित्य_, _nig_, _fxst, ksuk_,
   {{0x7c240648,0x9f820649,0x7ae90559,0xeb97008f}},	//   mmir, _yóò_, _žetv, _тия_,
   {{0x6d5c064a,0x442f064b,0x7c240092,0x0466064c}},	//   nara, _aig_, lmir, атим,
   {{0x442f064d,0x601d025a,0x2bdd009d,0xdb0f03a9}},	//   _big_, léme, नोका, _ancè,
   {{0x442f064e,0x938a064f,0x60160042,0x62800650}},	//   _cig_, тска_, dámo, ttmo,
   {{0x442f0651,0x6d5c0652,0x3c3c0653,0x601d0654}},	//   _dig_, kara, _lív_, néme,
   {{0x6d5c0655,0x442f0656,0x6033020a,0x00000000}},	//   jara, _eig_, _lămu, --,
   {{0x39580657,0x62800658,0x442f00a1,0xdb0f00ee}},	//   _mers_, stmo, _fig_, _encè,
   {{0x41a6007d,0x6d570659,0x3ea9065a,0x6fc6065b}},	//   _कोरस, _sexa, _prat_, _sócr,
   {{0xdefb065c,0x6d5c065d,0x7c240559,0x7c2f00e5}},	//   тын_, fara, dmir, _ricr,
   {{0x6d5c065e,0x442f065f,0x7c2f02ad,0x3ea90660}},	//   gara, _zig_, _sicr, _vrat_,
   {{0x442f006c,0x6ff20029,0x6d570661,0x61ef00fd}},	//   _yig_, zāci, _vexa, ècle,
   {{0x7c240662,0x3ea9042c,0x6d4e01ee,0xc17800c6}},	//   gmir, _trat_, abba, lgė_,
   {{0x6d5c0663,0x8d87007e,0x69d5030b,0xba550037}},	// [310] bara, _кунд, _plze, صناع,
   {{0xe29f0102,0xc178013f,0x6ff201d3,0x39580664}},	//   æði_, ngė_, vāci, _cers_,
   {{0x3958026a,0x00000000,0x00000000,0x00000000}},	//   _ders_, --, --, --,
   {{0x39580665,0x22460666,0x6ff200d9,0x7c2400ae}},	//   _eers_, _otok_, tāci, cmir,
   {{0x9f420146,0x60160018,0x3958014b,0xdb1d00d8}},	//   niká_, zámo, _fers_, _kosí,
   {{0x442f0667,0x6ff20029,0xaca30294,0x39580668}},	//   _sig_, rāci, _ndịd, _gers_,
   {{0xe3b100e3,0x2246061d,0x60160042,0x98aa00bd}},	//   كرة_, _atok_, xámo, _rebħ_,
   {{0x442f01fa,0xb7bd020a,0x60160669,0x98aa00bd}},	//   _qig_, _piţu, vámo, _sebħ_,
   {{0xdcfe01d3,0x36d4004d,0x442f066a,0x2b5905db}},	//   _papī, _дотр, _vig_, _mesc_,
   {{0x6d5c066b,0x7c2401d3,0xdb1d0094,0x39410519}},	//   xara, zmir, _nosí, nchs_,
   {{0x2ed0007d,0x442f066c,0x1bf904dd,0x224603a9}},	//   हन्त, _tig_, ्काल_, _etok_,
   {{0x6d5c066d,0xcdc90054,0x6016066e,0xdb0f066f}},	//   wara, _אך_, rámo, _encé,
   {{0x6d5c0670,0x539a00a1,0xdb2403e0,0x6016002b}},	//   tara, _תינו, üsün, sámo,
   {{0x32b80037,0xddd40031,0x60160042,0x7dd0007b}},	//   _خدمة_, ťažo, pámo, _täsm,
   {{0xc88500a7,0x7c240671,0x8c46001f,0xdcfc00c4}},	//   naşı_, tmir, себе, terđ,
   {{0x9f820088,0x2b590672,0x7dd00673,0xa3ca02d5}},	//   _góð_, _cesc_, _käsk, रॉप_,
   {{0x2b40031a,0x09360674,0x00000000,0x00000000}},	// [320] rcic_, مراج, --, --,
   {{0x6d5c0675,0x2a600676,0x601d0677,0x2b590090}},	//   qara, rsib_, réme, _eesc_,
   {{0xfbd20678,0x39580679,0x2a60067a,0x601d00fd}},	//   _فتح_, _vers_, ssib_, séme,
   {{0xc8850491,0x9f4b0052,0x3958067b,0x00000000}},	//   daşı_, vicë_, _wers_, --,
   {{0xe5c6067c,0x39580233,0x7bc6010a,0xada90281}},	//   йско, _ters_, _ioku, _صدیق_,
   {{0x6b96026d,0x00000000,0x00000000,0x00000000}},	//   leyg, --, --, --,
   {{0x7bc6067d,0x2246067e,0xe9d7067f,0x66d101f9}},	//   _koku, _stok_, _укр_, tókö,
   {{0x6b960680,0x644a0036,0x2b5900b3,0x7bc60681}},	//   neyg, rpfi, _xesc_, _joku,
   {{0x7ae90682,0x7bc60683,0x7dcb0684,0x60290034}},	//   _þett, _moku, _küst, _uśmi,
   {{0x7bc60685,0x104a0686,0x7f440063,0x6aa900e7}},	//   _loku, лями_, _afiq, _šefk,
   {{0x7dcb0687,0xe4520688,0x442400dc,0x9f4b034f}},	//   _xüsu, _رضا_, pmm_, licé_,
   {{0x7bc6067d,0xdb1d0072,0x9f420206,0x94260689}},	//   _noku, _sosí, tiká_, _умее,
   {{0x7f5d002b,0xdb1d068a,0x2246019c,0xba3b00b3}},	//   rasq, _posí, _utok_, _trïi,
   {{0x270700ef,0x63a2068b,0xe9df0328,0xdb1100fd}},	//   ống_, _haon, _atún_, _âgée,
   {{0x7bc60201,0x7a290138,0x7f5d0036,0x63a2068c}},	//   _boku, _užti, pasq, _kaon,
   {{0x6b96008c,0xdb1d0231,0x1b020033,0x660a02ac}},	//   geyg, _rosâ, লেছে_, hofk,
   {{0x63a2068d,0x200b068e,0x394100fd,0x2b5900b3}},	// [330] _maon, moci_, tchs_, _vesc_,
   {{0x2ba904a9,0x200b068f,0x63a20690,0x394102db}},	//   _चोरा, loci_, _laon, uchs_,
   {{0x39410691,0x7dcb0692,0x998200c6,0x00000000}},	//   rchs_, _düst, _aukų_, --,
   {{0x61c50693,0x63a20051,0x39410365,0xc885020e}},	//   _लक्ष, _naon, schs_, vaşı_,
   {{0x25ed02e8,0xb5fd0146,0x961d05aa,0x7dcb01f9}},	//   _अगदी_, _avša, _opņt, _füst,
   {{0x7bc6067d,0xdcfc01d3,0x3e5c006e,0x00000000}},	//   _zoku, cerē, נדוס, --,
   {{0x7bc6067d,0x62820694,0xdb060212,0x6d45009c}},	//   _yoku, _aqoo, _enkä, _mfha,
   {{0x69c70695,0x7dcb0696,0x77d70076,0x63a20697}},	//   _hoje, _küss, _اغسط, _caon,
   {{0x69c702e6,0x644801d4,0x200b04a3,0x85b90698}},	//   _koje, _etdi, doci_, _клас_,
   {{0x7dcb02dc,0x7dd00149,0x672d02ef,0x80650699}},	//   _müss, _väsk, žajs, овож,
   {{0x69c7069a,0x645e0220,0x7e640088,0xcea90327}},	//   _moje, špir, _svip, _שי_,
   {{0x6d45069b,0x200b05fe,0x246501d3,0xd00a069c}},	//   _afha, goci_, mēm_, реме_,
   {{0xa29400f7,0xd9fb009d,0x6d45036b,0x246501d3}},	//   _наці, ्वात_, _bfha, lēm_,
   {{0x7dd0069d,0x7bc6067d,0x224d069e,0x69c70201}},	//   _käsi, _soku, mpek_, _noje,
   {{0x7bc6069f,0x63a206a0,0x7dcb06a1,0x246501d3}},	//   _poku, _yaon, _rüst, nēm_,
   {{0xb06800d0,0x7dcb007a,0x200b06a2,0x7649010a}},	//   _اصول_, _süst, coci_, _otey,
   {{0x7dcb00aa,0x19c60358,0xed360152,0x224d0095}},	// [340] _püst, обам, _мэнэ, npek_,
   {{0x7bc6067d,0x3ea006a3,0x7dcb01bf,0x69c706a4}},	//   _woku, _isit_, _düss, _coje,
   {{0x69c7011d,0x7bc606a5,0x5faf009d,0x601d06a6}},	//   _doje, _toku, _जोडल, léma,
   {{0x2d9806a7,0x510c0130,0x224d06a8,0x246501d3}},	//   lere_, נהאַ, kpek_, dēm_,
   {{0xd5ba0084,0x63a206a9,0x601d06aa,0x7a230129}},	//   иск_, _raon, néma, ọtar,
   {{0x2d9806ab,0x69c706ac,0xe4520037,0x63a206ad}},	//   nere_, _goje, وضع_, _saon,
   {{0xb4d406ae,0x2d9806af,0x63a20036,0x764906b0}},	//   हने_, iere_, _paon, _etey,
   {{0x2d9806b1,0x326606b2,0x9faf030b,0x6aa90106}},	//   here_, отов, tří_, _šefi,
   {{0x2d9806b3,0xdb1d0018,0x200b06b4,0x00000000}},	//   kere_, _kosá, voci_, --,
   {{0x2d9806b5,0x63a20051,0x601d020d,0x3f800138}},	//   jere_, _waon, déma, _aciu_,
   {{0x2d9806b6,0x63a20256,0x200b006d,0x246501d3}},	//   dere_, _taon, toci_, cēm_,
   {{0x2d980172,0x7a2900c6,0x00000000,0x00000000}},	//   eere_, _užtv, --, --,
   {{0x2d9806b7,0x200b06b8,0x00000000,0x00000000}},	//   fere_, roci_, --, --,
   {{0x2d9806b9,0xddcf00ae,0x61ea00ae,0x2b5f00c4}},	//   gere_, ducţ, _umfl, _žuc_,
   {{0xfbd30080,0xa1770054,0x69c706ba,0xc05a00f3}},	//   وتر_, _ועוד_, _roje, _тіл_,
   {{0x69c70117,0xdb1d00b3,0x7dcb00bc,0x80d70179}},	//   _soje, _posà, _püss, मनरे,
   {{0x2d9806bb,0x69c706bc,0x246501d3,0x3f9906bd}},	// [350] bere_, _poje, zēm_, mesu_,
   {{0x2d9806be,0x3f9906bf,0xdb1d0076,0xdb0f00b3}},	//   cere_, lesu_, _cosá, _socó,
   {{0xe7f7007d,0x2d8106c0,0x69c7025b,0x764906c1}},	//   ंचला_, _iche_, _voje, _stey,
   {{0x320c06c2,0x69c700a5,0x4c9a040a,0x798e0172}},	//   hody_, _woje, _פברו, _ebbw,
   {{0x320c007f,0x00000000,0x00000000,0x00000000}},	//   kody_, --, --, --,
   {{0x27ef00d7,0x246500d9,0x69de06c3,0x64a506c4}},	//   sign_, tēm_, chpe, зака,
   {{0x63600134,0x3f9903e3,0x2d81024a,0x00000000}},	//   _ịnab, kesu_, _mche_, --,
   {{0x3cfc0105,0x2d980193,0x3f990060,0x61fa06c5}},	//   ילונ, zere_, jesu_, entl,
   {{0x27ed06c6,0x2d9806c7,0x2d810129,0x37da006e}},	//   _imen_, yere_, _oche_, _פֿלע,
   {{0x2d810129,0x320c0034,0x2d9806c8,0x246500e8}},	//   _nche_, gody_, xere_, pēm_,
   {{0x2d9806c9,0x224d06ca,0x601606cb,0x2fc901ec}},	//   vere_, spek_, lámi, _boag_,
   {{0x2d9806c0,0x2fc9002b,0xd8d600ca,0x601d001c}},	//   were_, _coag_, פורט_, téma,
   {{0x2d9806cc,0x25a506cd,0x320c06ce,0xc3290037}},	//   tere_, _kall_, body_, _اكشن_,
   {{0x7dd002c3,0xd1bb06cf,0x27ff06d0,0x7bcb003e}},	//   _läsv, _خاصا_, _ljun_, ögun,
   {{0x2d9806d1,0x27ed06d2,0xdb1d06d3,0x6b8f0169}},	//   rere_, _omen_, _rosá, _bbcg,
   {{0x2d9806d4,0x4a4606d5,0x2d8100ac,0x27ed00f9}},	//   sere_, знав, _eche_, _nmen_,
   {{0x2d9806d6,0x6d4106d7,0xe9da06d8,0xdb1d0146}},	// [360] pere_, ılar, бка_, _posá,
   {{0xdb0406d9,0xddcf020a,0x8af000a7,0x25a501b5}},	//   ndié, rucţ, vbəd, _nall_,
   {{0x6d5e00d9,0x6d3b00ca,0x63760555,0xbddb015e}},	//   _iepa, _לתינ, nünü, rpèt,
   {{0xf1ba0023,0x291d01c2,0x69de0216,0x25a506da}},	//   _nhơn_, ƙwan_, shpe, _aall_,
   {{0x6d5e06db,0xb4e4009f,0x27ff009e,0x25a506dc}},	//   _kepa, _पेड़_, _djun_, _ball_,
   {{0x6d5e06dd,0x25a506de,0x7c3e06df,0x3f9901e9}},	//   _jepa, _call_, _kupr, zesu_,
   {{0x25a50465,0x320c0363,0x20000129,0x3f9906e0}},	//   _dall_, vody_, _ojii_, yesu_,
   {{0x6d5e06e1,0x7bd606e2,0x320c0034,0x7c3e06e3}},	//   _lepa, nkyu, wody_, _mupr,
   {{0x320c06e4,0x25a506e5,0xdb0400fd,0x3f9906e6}},	//   tody_, _fall_, udiè, vesu_,
   {{0x64a606e7,0x200303ce,0x6d5e06e8,0x67200292}},	//   _наза, čkim_, _nepa, _izmj,
   {{0x320c06e9,0x93160103,0x6376020e,0x9f9906ea}},	//   rody_, _کوشش, günü, овну_,
   {{0x2d8102db,0x443e020d,0x672006eb,0x27ed020b}},	//   _sche_, _iut_, _बराक_, _xmen_,
   {{0x6d5e04ee,0xe80d06ec,0xb80d06ed,0x7c3e0257}},	//   _bepa, िकता_, िकतम_, _aupr,
   {{0x6d5e06ee,0x443e06ef,0x224b0220,0x3f9900f0}},	//   _cepa, _kut_, ícke_, sesu_,
   {{0x7c3e002d,0x3f990329,0x443e06f0,0x9f4b02c6}},	//   _cupr, pesu_, _jut_, licí_,
   {{0x443e06f1,0x69dc06f2,0xd117006e,0x6d5e00f9}},	//   _mut_, _alre, _מקוה_, _eepa,
   {{0x5a35016e,0x443e06f3,0x601d06f4,0x69dc009c}},	// [370] днат, _lut_, lémo, _blre,
   {{0x443e004f,0x6d5e0418,0x2d8100ac,0x7bdf0188}},	//   _out_, _gepa, _uche_, shqu,
   {{0x7c3e03a9,0x69dc01b9,0x7ae4010a,0x443e06f5}},	//   _gupr, _dlre, azit, _nut_,
   {{0x69dc0103,0x60160072,0x00000000,0x00000000}},	//   _elre, támi, --, --,
   {{0xf77006f6,0x443e06f7,0x81bc00d9,0x7bdd06f8}},	//   طان_, _aut_, rmēj, _ilsu,
   {{0x443e004f,0x601606f9,0xf65006fa,0x6d470034}},	//   _but_, rámi, ائن_, ncja,
   {{0x25a505fe,0x98170037,0x443e00ca,0x27ed0085}},	//   _vall_, _فبرا, _cut_, _tmen_,
   {{0x7dd006fb,0x443e02a7,0x601d06fc,0x25a506fd}},	//   _häst, _dut_, démo, _wall_,
   {{0x644906fe,0x91e506ff,0x443e00fd,0x6d47007f}},	//   _žlič, допе, _eut_, kcja,
   {{0x443e0700,0x5ef1030b,0xdb040364,0x6376020e}},	//   _fut_, ँछन्_, heiß, tünü,
   {{0x65630701,0x7bdd0702,0x443e0703,0x7dd00149}},	//   manh, _olsu, _gut_, _mäst,
   {{0x7dd00704,0x637603a3,0x5ec60081,0x65630705}},	//   _läst, rünü, _লেগে, lanh,
   {{0x6d5e0706,0x7c3e0707,0x63a90708,0x6376020e}},	//   _pepa, _supr, mden, sünü,
   {{0x63a90709,0x7dd0070a,0x5187065c,0x2be000b6}},	//   lden, _näst, _худа, नसभा,
   {{0x6289070b,0x601d0042,0x6b8d070c,0x673b0361}},	//   lteo, cémo, ffag, _oguj,
   {{0x7ae401e9,0x673b070d,0x6d5e070e,0x6563070f}},	//   tzit, _nguj, _wepa, hanh,
   {{0x7dd0070a,0x6d5e0710,0x62890711,0x65630712}},	// [380] _bäst, _tepa, nteo, kanh,
   {{0x673b0487,0x63a900c2,0x22590146,0x62890037}},	//   _aguj, hden, ásky_, iteo,
   {{0xdb0f0428,0xd910001c,0x765b0713,0x59c40714}},	//   _encà, ایز_, _awuy, लॉगर,
   {{0x63a90715,0x443e0716,0x3eb20146,0xdb1d02c3}},	//   jden, _rut_, _kryt_, _bosä,
   {{0x443e02ad,0xd76500cd,0x7dd00149,0x65630131}},	//   _sut_, رنوی, _fäst, fanh,
   {{0x7dd00717,0x63a90718,0x443e0719,0x6563071a}},	//   _gäst, eden, _put_, ganh,
   {{0x7845013f,0x7dd0071b,0xf772071c,0x6feb0034}},	//   _tėva, _häss, _لاء_, ręcz,
   {{0xd7640018,0x6008071d,0x63a9071e,0x7a2900c6}},	//   _سنئی, nımd, gden, _užtr,
   {{0xa80203a3,0x2918071f,0x65630720,0x443e0721}},	//   ğıda, _hyra_, banh, _wut_,
   {{0x443e0722,0x7abb00a1,0x7dd00723,0x63a90724}},	//   _tut_, קציו, _mäss, aden,
   {{0x7dd002e2,0x443e007a,0xc0570426,0xf1a30204}},	//   _läss, _uut_, мія_, трын,
   {{0x601d0725,0x76400726,0x291801ce,0x3eb20727}},	//   rémo, _kumy, _myra_, _bryt_,
   {{0x44260728,0x62890729,0x7dd0072a,0xa3080103}},	//   _iho_, cteo, _näss, _عرصے_,
   {{0x7640072b,0xdb04042c,0x00000000,0x00000000}},	//   _mumy, weiß, --, --,
   {{0x4426072c,0x2bbb0037,0x3b4c0174,0x9e3400ae}},	//   _kho_, يارة_, _ọdịk, терч,
   {{0x2ba9072d,0xdb0601dc,0x00000000,0x00000000}},	//   _चोखा, _kakè, --, --,
   {{0x656302c9,0xa3d60378,0x6b8d072e,0x442601b9}},	// [390] yanh, _हवन_, rfag, _mho_,
   {{0x4426072f,0x63a90730,0x7e7d0329,0x49740731}},	//   _lho_, zden, musp, клус,
   {{0x7dd00222,0x63a90732,0xaca30134,0x44260733}},	//   _väst, yden, _mpịg, _oho_,
   {{0x44260734,0xdb0f0042,0xddcd0146,0x76400735}},	//   _nho_, _encá, _staň, _bumy,
   {{0x200303ce,0x7c2d0572,0x65630736,0x7dd002fd}},	//   čkih_, mmar, tanh, _täst,
   {{0x44260737,0x29180222,0x00000000,0x00000000}},	//   _aho_, _fyra_, --, --,
   {{0x44260049,0x65630738,0xd5fb0174,0xfc460220}},	//   _bho_, ranh, _asụ, žíva_,
   {{0x44260739,0x7c2d073a,0x7e7d073b,0x6563073c}},	//   _cho_, nmar, kusp, sanh,
   {{0x66f30714,0x6563073d,0x2a69073e,0x4426073f}},	//   _अधिक_, panh, nsab_, _dho_,
   {{0x60080740,0x62890741,0x7c2d0742,0x60e90743}},	//   zımd, rteo, hmar, змом_,
   {{0x62890744,0x7c2d0745,0xdb06023b,0x9f4b00ee}},	//   steo, kmar, _pakë, ficà_,
   {{0x64410012,0x6561017a,0x2a6900aa,0x78ba0103}},	//   _iuli, _helh, ksab_, _átve,
   {{0x442d0746,0x81d50747,0x64410748,0x201e00d9}},	//   mme_, _подх, _huli, ēti_,
   {{0x64410749,0x7c26074a,0x3f84003d,0x270e00de}},	//   _kuli, _shkr, żmu_, ộng_,
   {{0x65610303,0xfce6074b,0xa3b4074c,0x6441074d}},	//   _melh, хово, _छोड_, _juli,
   {{0x442d074e,0x6441074f,0x7c2d0750,0xf062008f}},	//   nme_, _muli, gmar, _скъп,
   {{0x291e03ce,0x160f0751,0xe9da0752,0x64410753}},	// [3a0] _šta_, िवार_, пка_, _luli,
   {{0x442d0754,0x7c2d0755,0xdb06030b,0x3d11009d}},	//   hme_, amar, _jaké, _दुवे_,
   {{0x64410756,0x442d0757,0xdb0603a9,0x2ca50537}},	//   _nuli, kme_, _maké, ældt_,
   {{0x442d0758,0x7dd002fd,0x3f820759,0xe85300cd}},	//   jme_, _täss, ngku_, انند,
   {{0x4426075a,0x442d075b,0x6561075c,0x9f4b0131}},	//   _rho_, dme_, _belh, nicá_,
   {{0x6441075d,0x442d075e,0xe4a6075f,0xa4f801f3}},	//   _buli, eme_, ерио, وکار_,
   {{0x64410760,0xd4970761,0xdcfc00d9,0x442d01cb}},	//   _culi, еры_, derī, fme_,
   {{0x442601bb,0x64410762,0x69ce02a7,0xdb0602f1}},	//   _qho_, _duli, _hobe, _pakè,
   {{0x65610068,0x69ce0763,0x64410764,0xf5ea00ae}},	//   _felh, _kobe, _euli, _емал_,
   {{0x44260054,0x442d0765,0x6441008a,0xef1f0766}},	//   _who_, ame_, _fuli, ngüe_,
   {{0x64410767,0x33d602ec,0x91a60174,0x44260768}},	//   _guli, _підт, _atọ_, _tho_,
   {{0x7e7d03cf,0xa2e60769,0x7c2d008a,0x442d076a}},	//   tusp, _поед, xmar, cme_,
   {{0x0cc90386,0x6441076b,0x9f4b05fe,0xa3d50006}},	//   रह्म, _zuli, ricà_, _सकत_,
   {{0x6441076c,0x7c2d076d,0x7afb0106,0x2d85076e}},	//   _yuli, wmar, _žuto, üle_,
   {{0x7e7d076f,0x64410770,0xac190771,0x00000000}},	//   susp, _xuli, дову_, --,
   {{0x7e7d0772,0x00000000,0x00000000,0x00000000}},	//   pusp, --, --, --,
   {{0x7f4d0090,0x7f49034f,0x99630206,0xda78002e}},	// [3b0] _ifaq, ñequ, ríži_, еях_,
   {{0x9f590076,0x7e6d0062,0x00000000,0x00000000}},	//   insí_, _ivap, --, --,
   {{0xd36601dc,0x69ce0773,0xaca30294,0xe3c30233}},	//   _په_, _dobe, _kpọg, ngıç_,
   {{0x7e6d0774,0x2d8300f3,0x7f4d02a1,0x656102c6}},	//   _kvap, lgje_, _jfaq, _selh,
   {{0xe7e20775,0x65610776,0x442d0777,0x85b800d1}},	//   _खतरा_, _pelh, vme_, کانس_,
   {{0x69ce0778,0x64410779,0x2d83077a,0x88820103}},	//   _gobe, _puli, ngje_, _چیلن,
   {{0x442d077b,0x6561077c,0x644100a7,0xb4db077d}},	//   tme_, _velh, _quli, डने_,
   {{0x7bcf0012,0x6441077e,0xdb0603a9,0x7f4d0090}},	//   _jocu, _vuli, _saké, _nfaq,
   {{0x130902ec,0x9f4200dd,0x6561077f,0x69d80018}},	//   ьний_, shkë_, _telh, öveg,
   {{0x7bcf0012,0x64410780,0xb6350781,0x00000000}},	//   _locu, _tuli, _شفاع, --,
   {{0xf8e10782,0xdb1d00e3,0x442d0783,0x64410784}},	//   पनिय, _cosú, pme_, _uuli,
   {{0x13a700cd,0x2d8301cb,0x9f4b0231,0x00000000}},	//   _سنتی_, egje_, ticá_, --,
   {{0x69c4046e,0x3f8c00a5,0xdb060220,0x15e500c0}},	//   रामी, ędu_, _také, _कतार_,
   {{0x827600c1,0x7e6d0106,0x63ab003e,0xd24e071c}},	//   _יענע_, _dvap, _hagn, _بنو_,
   {{0x69ce0785,0xa3d5007f,0xa0a5004d,0x228b00f3}},	//   _robe, _सका_, _райд, løk_,
   {{0x63ab0786,0xeb9700d3,0x2d8301c0,0xd00f0037}},	//   _jagn, кис_, agje_, _ولو_,
   {{0x69ce0787,0x7bcf0788,0xe7f70789,0xdb1d0139}},	// [3c0] _pobe, _docu, ूचना_, _kosù,
   {{0xdb0d003e,0x63ab078a,0x00000000,0x00000000}},	//   rjað, _lagn, --, --,
   {{0x1d0a078b,0x7bcf078c,0x69ce078d,0xddc4078e}},	//   _цени_, _focu, _vobe, _eviţ,
   {{0x69ce078f,0x63ab0790,0x78b500e7,0x27e00037}},	//   _wobe, _nagn, _drzv, óin_,
   {{0xe7f300a5,0xe7370791,0x34da00b6,0x00000000}},	//   _आगरा_, вец_, बन्द, --,
   {{0x55730792,0x6b840793,0x6aa405bd,0xa613013f}},	//   агшт, lgig, mwif, аміч,
   {{0x63ab013d,0x629906a3,0xbf000034,0x44a30076}},	//   _bagn, _apwo, ैथुन_, لموق,
   {{0x63ab0794,0x798201c2,0x00000000,0x00000000}},	//   _cagn, ɗowa, --, --,
   {{0x63ab0795,0x6f09007f,0x8c1b0796,0x00000000}},	//   _dagn, żecz, ווקי, --,
   {{0xdb1d0797,0x27e60798,0xf1ba0023,0x7d090233}},	//   _posú, lhon_, _khơi_, şesi,
   {{0x601d0799,0x25be079a,0xb97b00a1,0x7e6d028d}},	//   lémi, _intl_, וניי, _svap,
   {{0x63ab079b,0xb4c0007d,0x7ec900dd,0x27e602c9}},	//   _gagn, ुही_, _nëpë, nhon_,
   {{0xd25000e3,0xf8bf0557,0xa194079c,0x00000000}},	//   _انت_, _एप्प, _балч, --,
   {{0x63ab00f1,0x7bcf020a,0x628000e8,0x2002079d}},	//   _zagn, _socu, mumo, anki_,
   {{0xa3d603a2,0x6280079e,0x2d83079f,0x7bcf07a0}},	//   _हवा_, lumo, rgje_, _pocu,
   {{0x6008026a,0x63a000f3,0x6b8407a1,0x00000000}},	//   rımc, nemn, ggig, --,
   {{0x27e607a2,0x628001af,0x41a9074c,0x683a00d2}},	// [3d0] dhon_, numo, _कसमस, _půdn,
   {{0x601d07a3,0x3ea907a4,0x9f400428,0x3f8901b9}},	//   démi, _isat_, _aliè_, _hcau_,
   {{0xf1ba00ef,0x628007a5,0xf775036c,0x7bcf020a}},	//   _chơi_, humo, гулю, _tocu,
   {{0xf09307a6,0x628007a7,0x63a007a8,0x1a650068}},	//   ינע_, kumo, jemn, _میری_,
   {{0x63ab07a9,0x628000d9,0x600807aa,0x8af000a7}},	//   _ragn, jumo, nıma, nbəl,
   {{0x63ab07ab,0x27e607ac,0x2e24003e,0x69c407ad}},	//   _sagn, ahon_, höfn_, राणी,
   {{0x63ab07ae,0x20020034,0x7dcb01f9,0x25ac0178}},	//   _pagn, ynki_, _büsz, _dadl_,
   {{0x27e607af,0x3f8901fa,0x3d3c040a,0x2496001c}},	//   chon_, _ncau_, וגוס, انيد_,
   {{0x23c50789,0x63ab07b0,0x67d400d3,0x628007b1}},	//   वाबद, _vagn, _тоту, gumo,
   {{0x79850085,0x228b0120,0x3f8900eb,0xb0ae07b2}},	//   nghw, røk_, _acau_, टिंग,
   {{0x545507b3,0x63ab07b4,0x69c4009d,0x228b00d6}},	//   _свет, _tagn, राती, søk_,
   {{0x92b50192,0x63a00167,0x7c3d0078,0x628007b5}},	//   _محتا, cemn, _nisr, bumo,
   {{0x3ea907b6,0x62c70076,0xfeba00d1,0x00000000}},	//   _csat_, _جزاك, راحت_, --,
   {{0x7c3d009c,0xc33200ca,0x200200e7,0x27e607b7}},	//   _aisr, _הוד_, snki_, zhon_,
   {{0xfce307b8,0x3ea907b9,0xd1b80018,0x81bc01d3}},	//   боро, _esat_, _جانا_, rmēt,
   {{0xfaa607ba,0x81bc01d3,0xd0120037,0x60dc00f3}},	//   лабо, smēt, _دلع_, ørme,
   {{0xfe7200d0,0xdb060383,0x6b8407bb,0x2fc007bc}},	// [3e0] _ادب_, _ankò, rgig, _inig_,
   {{0x63a007bd,0xf1ba0023,0x7a220031,0xd6c4001c}},	//   zemn, _phơi_, rôto, یمای,
   {{0x81bc0029,0x27e607be,0x443d010a,0xcb6a07bf}},	//   slēg, thon_, _oiw_, _пане_,
   {{0x4b55008f,0xdb1d022b,0x443d0231,0x601d00fc}},	//   _върт, _onsè, _niw_, témi,
   {{0x6d5c07c0,0xcc3b00c1,0xdb0605aa,0xddc4033b}},	//   obra, _רעכט, _enkò, _zviš,
   {{0xe9df00e3,0x601d07c1,0x27e607c2,0xb8660246}},	//   _dtús_, rémi, shon_, _مارو,
   {{0xe0c707c3,0xdb1d02f1,0x63a007c4,0x601d07c5}},	//   _از_, _ansè, temn, sémi,
   {{0x02a607c6,0xb27407c7,0xc27407c8,0x6e3e07c9}},	//   гром, алиш, алиј, _lipb,
   {{0x060a07ca,0x248e01af,0x443d02f1,0x370607cb}},	//   _знак_, stfm_, _diw_, _спаг,
   {{0x63a007cc,0x628007cd,0xf1a607ce,0x6d5c01cb}},	//   semn, rumo, урин, jbra,
   {{0x438600d0,0x628007cf,0xb97b00c1,0x6d5c07d0}},	//   _ملاق, sumo, ענטי, dbra,
   {{0x273a07d1,0x9f59023b,0x752801d3,0x62800143}},	//   _günü_, misë_, _izdz, pumo,
   {{0x9f59023b,0x98b80078,0x244a00fe,0x645802ac}},	//   lisë_, _ferħ_, _hùm_, lpvi,
   {{0x2fc007d2,0x6d5c07d3,0x60080555,0xc3330142}},	//   _enig_, gbra, rıma, _פוס_,
   {{0x9f5900dd,0xfaff00dd,0xdb1d07d4,0xa2ac07d5}},	//   nisë_, _ndër_, _insé, जिक्,
   {{0x61fa07d6,0x81bc00d9,0x6d5c036b,0xdb0f0072}},	//   litl, slēd, abra, _incú,
   {{0x6d5c013d,0x3ea9015e,0x9f49026a,0xe51b0336}},	// [3f0] bbra, _usat_, _amaç_, _पुनि_,
   {{0x6d5c009c,0x61fa07d7,0x9f59023b,0xdcfc01d3}},	//   cbra, nitl, kisë_, sgrā,
   {{0xa3d50006,0x9f59023b,0xdb040143,0xf9880037}},	//   _सकल_, jisë_, rdiá, انمي_,
   {{0x9f590052,0x7e7d000b,0x61fa07d8,0xa802071d}},	//   disë_, orsp, hitl, şına,
   {{0xd90f07d9,0x61fa00ad,0x224605aa,0x645802ac}},	//   _کیا_, kitl, _nuok_, epvi,
   {{0x443d07da,0xaaa8008f,0x9f590052,0xab5b042c}},	//   _siw_, _съюз_, fisë_, _unüb,
   {{0x7aed00e5,0x244a07db,0x61fa00a7,0x8235010d}},	//   lzat, _cùm_, ditl, یرخا,
   {{0x7bcd07dc,0x22460124,0x6d5c07dd,0x244a00de}},	//   njau, _buok_, zbra, _dùm_,
   {{0x7aed07de,0x11e507df,0x6d5c07e0,0xd1b9001c}},	//   nzat, ижим, ybra, نادا_,
   {{0x437500bf,0x61fa00f9,0x8467013d,0x200907e1}},	//   _چهار, gitl, _бъде, _ajai_,
   {{0x23c507e2,0x53c50789,0x9f5900dd,0x7e7d05c9}},	//   वादद, वादश, cisë_, ersp,
   {{0x229507e3,0x6d5c07e4,0xb4b107e5,0xdb1d037a}},	//   _видя, wbra, टटी_, _ensé,
   {{0x6d5c07e6,0x61fa07e7,0xda1500a4,0xceb4013c}},	//   tbra, bitl, तकात_, _azər_,
   {{0x20090063,0xdb04016d,0x7bcd00c6,0x425207e8}},	//   _ejai_, ldiç, ejau, _بنور,
   {{0x6d5c07e9,0x6f0d07ea,0x7f7607eb,0xdca607ec}},	//   rbra, _exac, _купц, шави,
   {{0x35c7000f,0xdb0400c9,0x2fc002ad,0x78ba0220}},	//   लाड़, ndiç, _unig_, _štvo,

   {{0x896607ed,0x9f590052,0x68e100bc,0x31670383}},	// [400] икаж, zisë_, _üldj, _kenz_,
   {{0x48b6008f,0x27e4009c,0x7d1e07ee,0x00000000}},	//   ищет, _slmn_, _typs, --,
   {{0x18a607ef,0xac0a07f0,0x987402c6,0x320500ca}},	//   раем, _анна_, _týče_, inly_,
   {{0x7bdf07f1,0x244a0013,0x7e64050f,0x9f590052}},	//   ckqu, _rùm_, _kwip, visë_,
   {{0xe5c607f2,0x7e640350,0xdcfe0206,0x7aed007f}},	//   иско, _jwip, _napĺ, czat,
   {{0xd49a07f3,0x5d7a0130,0x672901d3,0x9f590052}},	//   ври_, דאַק, _dzej, tisë_,
   {{0x53e607f4,0x672907f5,0x00000000,0x00000000}},	//   ициа, _ezej, --, --,
   {{0x9f59074a,0x7afb0335,0x7f44019f,0x7a2b047e}},	//   risë_, _žuti, _ngiq, rüte,
   {{0x9f5900dd,0x66e307f6,0x67290090,0x61fa07f7}},	//   sisë_, _дота, _gzej, titl,
   {{0x9f5907f8,0x244a00fe,0xeb0400aa,0x645807f9}},	//   pisë_, _tùm_, _रखैत_, ppvi,
   {{0x7aed07fa,0x9f5907fb,0x31670174,0x61fa07fc}},	//   zzat, lisé_, _denz_, ritl,
   {{0x61fa07fd,0x656807fe,0x66180146,0x7aed07ff}},	//   sitl, _hedh, lovk, yzat,
   {{0x61fa0800,0x64480801,0x9f590802,0x656800cd}},	//   pitl, _hudi, nisé_, _kedh,
   {{0x64480803,0x656803a9,0x752d030b,0x249e0804}},	//   _kudi, _jedh, řaze, _kptm_,
   {{0x315700a1,0x40350805,0x65680806,0x7b670084}},	//   _דיון_, _лекс, _medh, итае,
   {{0x81e800c7,0x64480807,0x2cba0808,0x7aed0809}},	//   _যদি_, _mudi, _drpd_, tzat,
   {{0x6e95054f,0x7bcd02fd,0x5e9500e3,0x15f8063c}},	// [410] _الخا, rjau, _الخط, ्चार_,
   {{0x2019080a,0x7bcd080b,0xa8020367,0x6448080c}},	//   losi_, sjau, şıla, _oudi,
   {{0x6618025b,0x6d45080d,0x6008026a,0xe4fb030b}},	//   dovk, _igha, kıml, एपछि_,
   {{0x65680172,0xdce7080e,0xb8ff080f,0x00000000}},	//   _aedh, najč, _तथ_, --,
   {{0xef1f07aa,0x6568001c,0x6008013c,0x00000000}},	//   zgün_, _bedh, dıml, --,
   {{0x20190810,0xbb3a00ca,0x6568001c,0xe618004d}},	//   hosi_, _תעשי, _cedh, аді_,
   {{0x20190811,0x6d450812,0x64480813,0x656801dc}},	//   kosi_, _mgha, _cudi, _dedh,
   {{0xd7740814,0x31670451,0x20190815,0xdce705db}},	//   _واقع, _senz_, josi_, jajč,
   {{0x6568068d,0x69d50816,0x20190817,0xd7f80818}},	//   _fedh, _koze, dosi_, _тур_,
   {{0x6d450819,0x656800bf,0x69d5081a,0x6448081b}},	//   _ngha, _gedh, _joze, _fudi,
   {{0x273300ef,0x7e64081c,0x201900e5,0x6448081d}},	//   _ảnh_, _swip, fosi_, _gudi,
   {{0x6d45081e,0xdb06081f,0xfaff057a,0x20190820}},	//   _agha, _laká, _reën_, gosi_,
   {{0x6d450090,0xfaff057a,0xdb1d0103,0x6008013c}},	//   _bgha, _seën_, _mosó, sımo,
   {{0xc5f20130,0x9f590084,0x64480821,0x2be0030b}},	//   ִדן_, ensä_, _yudi, नस्थ,
   {{0x76410822,0xdcf701d4,0x64480823,0x20190824}},	//   _mily, _baxı, _xudi, bosi_,
   {{0x6618025b,0x77690825,0x20190826,0x2d8c007f}},	//   zovk, _neex, cosi_, żde_,
   {{0x69d50827,0xef1f0828,0xdd110094,0x4a430161}},	// [420] _boze, ngül_, _výši, знув,
   {{0x3ea00270,0x0d76001c,0x9f59020d,0xe9d70829}},	//   _ipit_, _دیسک_, visé_, бку_,
   {{0x6568082a,0x442f082b,0x600807aa,0xb865082c}},	//   _redh, _ohg_, yıml, قانو,
   {{0x6448082d,0x7649037a,0x9f59020d,0x263d0031}},	//   _rudi, _buey, tisé_, _dňom_,
   {{0x644800e9,0x7641082e,0x66180146,0xa6fa0037}},	//   _sudi, _bily, tovk, دعاء_,
   {{0x6448082f,0x20190129,0x9f59025a,0x2d8a0830}},	//   _pudi, zosi_, risé_, ngbe_,
   {{0xdcf701d4,0x6618025b,0x764102ad,0xd4670831}},	//   _yaxı, rovk, _dily, бије_,
   {{0xdb060074,0x656800bf,0x32540832,0x69d50833}},	//   _zaká, _wedh, овир, _zoze,
   {{0x316c0710,0x60080367,0x20190834,0xaac80835}},	//   tadz_, rıml, vosi_, रमिक,
   {{0xc05a0836,0x64480479,0x76410150,0x31c600c2}},	//   лім_, _tudi, _gily, ссив,
   {{0x64480837,0x20190838,0x3ea00533,0xe80d00a4}},	//   _uudi, tosi_, _apit_, िकचा_,
   {{0x442f00f9,0x7c29003d,0x1ac8030b,0x201900c6}},	//   _ghg_, ċerk, रमाथ, uosi_,
   {{0x20190839,0x2d98083a,0x44240063,0x8af000a7}},	//   rosi_, ffre_, mlm_, ncəd,
   {{0x6d480039,0xddcd00a5,0x10f90018,0xa158004d}},	//   ždan, _stał, ابیں_, _таку_,
   {{0x69d5083b,0xd12f083c,0x7c240090,0x3ea00154}},	//   _roze, _хх_, flir, _epit_,
   {{0x68e1007a,0xdb0f034f,0x00000000,0x00000000}},	//   _üldi, _hacé, --, --,
   {{0x69d5083d,0xdd9100e3,0x4424007a,0x3a7500d3}},	// [430] _poze, _قوة_, ilm_, юлар,
   {{0x44240212,0x77690188,0x6d450239,0x7c24083e}},	//   hlm_, _seex, _ugha, alir,
   {{0x7c24083f,0x69d50840,0xdb1d0841,0xdcf700a7}},	//   blir, _voze, _insí, _taxı,
   {{0x76410842,0x77690188,0x76490843,0xe76b001c}},	//   _sily, _qeex, _puey, احان_,
   {{0x4424005c,0xdb23001c,0xdb060844,0xdce50117}},	//   dlm_, _روسی, _taká, _mehč,
   {{0x27fd0150,0x442f0479,0x4efc0327,0xdce502c6}},	//   siwn_, _shg_, נהגו, _lehč,
   {{0x64420845,0x36230018,0x628005c2,0x00000000}},	//   _bioi, _ہورہ, ermo, --,
   {{0x84360037,0xd79400e5,0x00000000,0x00000000}},	//   يكور_, _нисъ, --, --,
   {{0x6442002b,0xf34e0174,0x00000000,0x00000000}},	//   _dioi, _rụtụ_, --, --,
   {{0xfaff057a,0xbb3c006e,0xe1f90846,0xef1f0847}},	//   _reël_, נעזי, рго_, rgül_,
   {{0x600a0848,0x3ea00849,0x628001ec,0xe5c40109}},	//   ином_, _spit_, armo, _эсто,
   {{0xd9a6084a,0x6442008f,0x7a300149,0xdb1d0143}},	//   _ऑस्ट, _gioi, mäte, _ansí,
   {{0xdb0f084b,0x8db6004d,0x11d5084c,0x51f50286}},	//   _facé, осві, _мікр, _وستر,
   {{0x2cb800c4,0x00000000,0x00000000,0x00000000}},	//   tvrd_, --, --, --,
   {{0x7a30084d,0x00000000,0x00000000,0x00000000}},	//   näte, --, --, --,
   {{0xf34e00ac,0xdb0d0037,0xfaff084e,0xec1600d1}},	//   _hụrụ_, adaí, _teël_, آورد,
   {{0x53360130,0x3ea0084f,0xf34e0134,0x2d980850}},	// [440] ַנען_, _upit_, _kụrụ_, pfre_,
   {{0xf34e0294,0xa2b10851,0xa2cc0852,0x7a300853}},	//   _jụrụ_, _अनन्, _तपस्, käte,
   {{0x7c240854,0xf34e0129,0xeb9a00d3,0xa17a006e}},	//   plir, _mụrụ_, _кин_, שטעט,
   {{0xf34e0294,0xdb040076,0x7a3000c2,0xb09a006e}},	//   _lụrụ_, idiú, däte, ייער,
   {{0x7bc60855,0xdce701d3,0x00000000,0x00000000}},	//   _inku, majā, --, --,
   {{0x78af00c2,0xf34e0294,0xdce700e8,0x00000000}},	//   äivä, _nụrụ_, lajā, --,
   {{0x37e600d6,0xa6d80033,0x00000000,0x00000000}},	//   _довг, _দেশট, --, --,
   {{0x68e30856,0x7dd000c2,0xdce701d3,0x00000000}},	//   ønde, _väsy, najā, --,
   {{0xf34e0857,0x77620858,0xc1a60859,0x62800381}},	//   _bụrụ_, mbox, ојни, urmo,
   {{0x64a6085a,0x68e900b6,0x2be10034,0x776207ee}},	//   _маза, _ředi, _नवभा, lbox,
   {{0x7bc6085b,0xc95300a1,0xdce701d3,0x3d1a0096}},	//   _onku, ומת_, kajā, _मुले_,
   {{0x645a085c,0x6831085d,0x7762085e,0x03a6085f}},	//   _itti, rådg, nbox, _фидо,
   {{0xf77300a1,0xf1a900d1,0x00000000,0x00000000}},	//   וקר_, _گانه_, --, --,
   {{0xf34e0294,0x7bc60860,0x00000000,0x00000000}},	//   _gụrụ_, _anku, --, --,
   {{0xdb6b0275,0xf1a901c3,0xc31c0033,0xdb0d0076}},	//   ирал_, _دانه_, দেশি_, rdaí,
   {{0x3eb00084,0xf34e0294,0x3d1a0096,0xdce700e8}},	//   ältä_, _zụrụ_, _मुळे_, gajā,
   {{0x161a0861,0x2aab0215,0x00000000,0x00000000}},	// [450] धवार_, штво_, --, --,
   {{0x645a0862,0x7bc60863,0x200b01c2,0x39470430}},	//   _otti, _enku, lnci_, øns_,
   {{0x6d550034,0x00000000,0x00000000,0x00000000}},	//   mcza, --, --, --,
   {{0x59c9030b,0x27e90103,0x99980138,0x6d55007f}},	//   राहर, óan_, _virš_, lcza,
   {{0x645a0864,0xf1bc007d,0x68e3052f,0xc21a00c3}},	//   _atti, ्ञान, øndb, नकाब_,
   {{0x7a3001bf,0xeabf0139,0x6b8d0865,0x00000000}},	//   täte, _irù_, lgag, --,
   {{0x69c70866,0xf34e0129,0x69cd0096,0x7d180120}},	//   _inje, _rụrụ_, साठी, _øvst,
   {{0xf7730867,0x7a300868,0x59c900a4,0x6aad024a}},	//   _زار_, räte, रावर, owaf,
   {{0x645a0869,0xdb0f0328,0xc7b20327,0x35f5086a}},	//   _etti, _incó, _אבן_, _епар,
   {{0x24840174,0x765b086b,0x200b007f,0x7a30086c}},	//   _ịmee_, _ituy, enci_, päte,
   {{0x6d5500a5,0xc617086d,0x60410134,0x69c70786}},	//   dcza, दकीय_, _ịmaa, _mnje,
   {{0xdb040076,0x2477020a,0x6d55007f,0x6aad086e}},	//   rdiú, măm_, ecza, kwaf,
   {{0x63a9086f,0xf34e0129,0xa3b4007a,0x33f406cf}},	//   meen, _tụrụ_, _छोट_, _تسلس,
   {{0x63a90313,0x225f0498,0xed570870,0x6b8d010a}},	//   leen, mpuk_, зор_, egag,
   {{0x8af00092,0xdce701d3,0x200b01c2,0xdb0f037a}},	//   hbət, tajā, bnci_, _oncó,
   {{0x24510871,0x69c70872,0x63a90873,0x60dc0874}},	//   _mám_, _anje, neen, ärme,
   {{0x765b0875,0x20020876,0xca8600d3,0xdce70877}},	// [460] _ntuy, miki_, ягай, rajā,
   {{0x14bd06e4,0x63a90878,0xe9d70879,0x4efb00ca}},	//   ्माण, heen, пку_, _להפו,
   {{0x2451087a,0x63a9087b,0x02a8087c,0x7a2b0364}},	//   _nám_, keen, _कन्न, mütl,
   {{0x2002087d,0x7bc6067d,0x63a9087e,0x3ce500f3}},	//   niki_, _unku, jeen, ølve_,
   {{0x63a9087f,0xdb060212,0xa3cf0409,0x569404e6}},	//   deen, _bakå, शान_, фалт,
   {{0xf1d00019,0x9f590146,0xdb0f0042,0x69c70880}},	//   _mạch_, visí_, _encó, _gnje,
   {{0x24510019,0x247700d3,0x18a30881,0x765b06b0}},	//   _cám_, găm_, _парм, _etuy,
   {{0x63a9008a,0x24510882,0xa6d30081,0x6d5500a5}},	//   geen, _dám_, _দেওয়, zcza,
   {{0x20020883,0x36670884,0x6d5500a5,0xdce501d3}},	//   diki_, _нато_, ycza, _mehā,
   {{0x683102fe,0x2b460206,0xdce7044c,0x2477044c}},	//   råde, ľoch_, najă, băm_,
   {{0x20020885,0x80df00c7,0x63a90886,0xf1af0037}},	//   fiki_, _ফেব্, been, اءً_,
   {{0xf1d00019,0x27e60887,0x6d550034,0x63a90888}},	//   _bạch_, nkon_, wcza, ceen,
   {{0x27e60889,0xf19400c2,0xf1d0020b,0x00000000}},	//   ikon_, _жиль, _cạch_, --,
   {{0xdb0f00b3,0x7a2b0233,0x27e6088a,0x752402c6}},	//   _oncò, gütl, hkon_, řizu,
   {{0x2002088b,0x6d550034,0x24510023,0x1b5a0174}},	//   biki_, rcza, _xám_, _ọnụm,
   {{0x69c70268,0x1bd4088c,0xe50d0179,0x394a042c}},	//   _snje, нося, िपति_, _agbs_,
   {{0xf1d000de,0x2477020a,0x00000000,0x00000000}},	// [470] _gạch_, zăm_, --, --,
   {{0x2fc901fa,0x8af00092,0x20b0088d,0xceb40327}},	//   _hnag_, vbət, _जनाध, _טיפ_,
   {{0x63a9088e,0x67d5088f,0x4ddc00ca,0x765b0381}},	//   yeen, можу, _לחזו, _stuy,
   {{0xdb0f0890,0x321e0891,0x2a60023e,0x27e60892}},	//   _hací, hoty_, bpib_, gkon_,
   {{0x2451025b,0x63a90893,0x9f4b034f,0xa26300fe}},	//   _sám_, veen, licó_, _chố,
   {{0x20020894,0x63a9008a,0x27e602b1,0x247700ae}},	//   ziki_, ween, akon_, tăm_,
   {{0x58840895,0x63a90896,0xd5fb0174,0xdb0f0143}},	//   _пыта, teen, _apụ, _mací,
   {{0x24510897,0x7a300898,0x247700ae,0xf8b200ca}},	//   _vám_, mäta, răm_, _בשל_,
   {{0x27ff0899,0x63a9089a,0x765b0193,0x2002089b}},	//   _imun_, reen, _utuy, viki_,
   {{0x130602fd,0x81bc00d9,0x24510019,0x68e1007a}},	//   ьный_, blēm, _tám_, _ülds,
   {{0x2002089c,0x6603089d,0xf1d00019,0x2fc901ec}},	//   tiki_, mink, _sạch_, _bnag_,
   {{0x9f4b058a,0x2fc9089e,0x351a006e,0x00000000}},	//   dicó_, _cnag_, _ווענ, --,
   {{0x2002089f,0x628908a0,0xddcd084f,0x8af001d4}},	//   riki_, queo, _svaš, hbər,
   {{0x660308a1,0x200208a2,0xc33200a1,0x9f4b058a}},	//   nink, siki_, _סוג_, ficó_,
   {{0x27ed08a3,0x801608a4,0x81bc00d9,0x200208a5}},	//   _olen_, _офиц, klēj, piki_,
   {{0x2d8401e8,0x660308a6,0xbf9b0131,0x00000000}},	//   şme_, hink, liên, --,
   {{0x660308a7,0xdb0f08a8,0x78a908a9,0x224708aa}},	// [480] kink, _fací, _ćeva, _kink_,
   {{0xceb40253,0x660308ab,0x27ed0559,0x27ff01c2}},	//   _isə_, jink, _alen_, _amun_,
   {{0x660308ac,0x2fc9005c,0xe4f4030b,0x27e608ad}},	//   dink, _ynag_, ेपछि_, tkon_,
   {{0xbf9b0023,0xfbdf0023,0x9f4b028d,0xeabf0139}},	//   hiên, _hiên_, licò_, _iyùn_,
   {{0x27e608ae,0x660308af,0x224708b0,0xfbdf00de}},	//   rkon_, fink, _oink_, _kiên_,
   {{0x27e608b1,0x27ed08b2,0x27ff01c8,0x7ae40169}},	//   skon_, _elen_, _emun_, myit,
   {{0xdcfe01e8,0xbf9b001f,0xfbdf0023,0x321e0094}},	//   _kapı, diên, _miên_, voty_,
   {{0xfbdf00ef,0x69dc08b3,0xbf9b00fd,0x21e9037a}},	//   _liên_, _hore, nnêt, _búho_,
   {{0x518608b4,0x12be0033,0x7ae408b5,0x23270291}},	//   муна, েন্দ, nyit, моћи_,
   {{0xfbdf0019,0x660308b6,0x70c90179,0xbf9b016d}},	//   _niên_, cink, िमूल, giên,
   {{0x69dc08b7,0x22470665,0x9f4b028d,0x27ed00c2}},	//   _more, _dink_, dicò_, _ylen_,
   {{0xe36308b8,0x69dc08b9,0xd01108ba,0xdce7007f}},	//   _акци, _lore, الح_, nają,
   {{0xe81f000c,0x3f8508bb,0x224708bc,0xfbdf0019}},	//   यकता_, ğlu_, _fink_, _biên_,
   {{0xbf9b001f,0x69dc00f3,0x06e10081,0x9f4b034f}},	//   ciên, _nore, _মেডি, ticó_,
   {{0x628608bd,0xdb0f0890,0x764808be,0xdce70034}},	//   škod, _vací, _midy, kają,
   {{0x660308bf,0xdb0d001f,0x1bb80037,0xe80008c0}},	//   zink, ndaç, واقع_, लोमा_,
   {{0x660308c1,0x63a208c2,0xdce700a5,0x5a3508c3}},	// [490] yink, _mbon, dają, енат,
   {{0x69dc08c4,0x7e6d0051,0xddc408c5,0x27ff0113}},	//   _core, _iwap, _zviž, _smun_,
   {{0x660308c6,0x69dc08c7,0x27ed06a3,0x3d100096}},	//   vink, _dore, _plen_, णपणे_,
   {{0xdd0d00a5,0x660308c8,0xdce70034,0x7e6d08c9}},	//   półp, wink, gają, _kwap,
   {{0x69dc08ca,0x660301b3,0x366908cb,0xf7700602}},	//   _fore, tink, чало_, شان_,
   {{0x7e6d08cc,0xfbdf00fe,0x04b500e5,0x00000000}},	//   _mwap, _xiên_, есия, --,
   {{0xdcfe074e,0xa3e3007a,0x7bdd08cd,0xb7d50065}},	//   _yapı, _नकद_, _kosu, _aṣeh,
   {{0x660308ce,0x7f4d08cf,0x69dc08d0,0xdb060220}},	//   sink, _ngaq, _zore, _rakú,
   {{0x69c40336,0x3d0604a9,0x7bdd02c9,0xc24508d1}},	//   राची, _हेने_, _mosu, нник,
   {{0xdb1d0149,0x69dc0188,0x7bdd08d2,0xddc400d4}},	//   _insä, _xore, _losu, _sviž,
   {{0xbf9b0396,0x67290085,0x80c902d5,0x91d00081}},	//   riên, _hyej, िमें, িসংখ,
   {{0x6e2508d3,0x34bd08d4,0x60dc0212,0x7e6d08d5}},	//   _akhb, ्मीद, ärma, _bwap,
   {{0x63bb08d6,0xdb060032,0x6264004d,0xbf9b0231}},	//   mdun, _fakù, _авіа, piên,
   {{0x63bb08d7,0xf1d00019,0x409508d8,0x63b9003d}},	//   ldun, _hạnh_, _зрит, _hawn,
   {{0xdca308d9,0xfbdf00ef,0x320508da,0xa3e3009d}},	//   лари, _viên_, mily_, _नका_,
   {{0x63bb08db,0xc4d20130,0x7bdd00d3,0x6724003d}},	//   ndun, נגן_, _cosu, żiji,
   {{0x69dc00e9,0x629b0895,0xfbdf0028,0xf1d00028}},	// [4a0] _pore, ntuo, _tiên_, _mạnh_,
   {{0xf1d00028,0x81e10081,0x7ae40079,0xdce70034}},	//   _lạnh_, নোর_, ryit, wają,
   {{0x69dc08dc,0xdcfe0740,0xdce70034,0x672908dd}},	//   _vore, _tapı, tają, _ayej,
   {{0x76480124,0x629b0138,0x67290172,0xdbcd0139}},	//   _sidy, ktuo, _byej, _dóós,
   {{0x69dc08de,0xdce70034,0x7c2600bd,0x63bb08df}},	//   _tore, rają, _ikkr, ddun,
   {{0xb90600c7,0x629b0124,0x63bb08e0,0x7bdd08e1}},	//   _বই_, dtuo, edun, _zosu,
   {{0x7bdd08e2,0x06d80081,0x68e100aa,0x764808e3}},	//   _yosu, _দেখি, _üldp, _vidy,
   {{0xf1d00019,0x764808e4,0x63bb0009,0x326608e5}},	//   _cạnh_, _widy, gdun, нтов,
   {{0x63b908e6,0x32050146,0x76480154,0x629b02c9}},	//   _dawn, fily_, _tidy, gtuo,
   {{0xa2b108e7,0x75280034,0x26c40062,0x7e6d0027}},	//   _अनर्, _tydz, _irmo_, _rwap,
   {{0x681500a5,0x63b908e8,0xdb1d0212,0xdb0f0076}},	//   ląda, _fawn, _inså, _macá,
   {{0x63a208e9,0x20d500c6,0x26c40141,0x7e6d0154}},	//   _ubon, džią_, _krmo_, _pwap,
   {{0x91e608ea,0x442608eb,0x2d8508ec,0x3205025b}},	//   _поде, _iko_, óleo_, bily_,
   {{0x92f203a3,0x7bdd08ed,0x00000000,0x00000000}},	//   ığım, _sosu, --, --,
   {{0xe57100c1,0x23c40179,0x442608ee,0x31bb00ca}},	//   יַן_, _वफाद, _kko_, _מזגנ,
   {{0x442605db,0x7e6d08ef,0x7f4d039f,0x00000000}},	//   _jko_, _twap, _ugaq, --,
   {{0xbbe10557,0x7e6d08f0,0x442608f1,0xafdb02b6}},	// [4b0] _नवीक, _uwap, _mko_, rmød,
   {{0x99990138,0xafdb02b6,0x3ea90113,0xd6d100d1}},	//   _rusų_, smød, _ipat_, یقا_,
   {{0x78ba0181,0xa77508f2,0x7bdd08f3,0xef200034}},	//   _štvr, влеч, _tosu, ążek_,
   {{0x442608f4,0x6b6700fd,0xfbdf0023,0xdb1d0212}},	//   _nko_, _dégâ, _kiêm_, _anså,
   {{0x7c2d08f5,0x212b00de,0x69c108f6,0x8af000a7}},	//   mlar, ́ch_, _óleo, ncəl,
   {{0x442608f7,0x7c2d08f8,0xeb9f02ec,0xe5a508f9}},	//   _ako_, llar, _gjør_, тики,
   {{0x34bd08fa,0x320508fb,0xfbdf0023,0x7c2d08fc}},	//   ्मेद, vily_, _liêm_, olar,
   {{0x7c2d08fd,0x629b08fe,0xd6d80081,0xe7950018}},	//   nlar, ttuo, _দেওয, _جاسک,
   {{0x63bb08ff,0x44260900,0x7c2d01e9,0xfbdf0023}},	//   rdun, _dko_, ilar, _niêm_,
   {{0x3d1a0067,0x7c2d07aa,0x44260901,0x229200bf}},	//   _मुझे_, hlar, _eko_, گلیس,
   {{0x7c2d0902,0x629b0903,0x23e700d6,0xc952040a}},	//   klar, stuo, _підв, ימי_,
   {{0x7c2d0587,0x2d810113,0x32050904,0xdee60905}},	//   jlar, _adhe_, sily_, воми,
   {{0x443f0906,0x7c2d0907,0x442d0908,0x644b00f9}},	//   mmu_, dlar, mle_, _iigi,
   {{0x644b0909,0x3ea9090a,0x7c2d090b,0x600b00c2}},	//   _higi, _dpat_, elar, tömä,
   {{0x442d090c,0x644b090d,0x7c2d090e,0xed57090f}},	//   ole_, _kigi, flar, тос_,
   {{0x2d810910,0x442d0911,0x7c2d0912,0x443f0913}},	//   _edhe_, nle_, glar, nmu_,
   {{0x442d03ea,0x443f0914,0xdb0f00e3,0x8c430915}},	// [4c0] ile_, imu_, _pacá, рете,
   {{0x644b0916,0x442d0917,0x443f0918,0xfaa302f3}},	//   _ligi, hle_, hmu_, рафо,
   {{0x7c2d0919,0x443f0706,0x442d091a,0x81c30033}},	//   blar, kmu_, kle_, _একা_,
   {{0x443f023c,0x442d091b,0x644b05bd,0x1867091c}},	//   jmu_, jle_, _nigi, таци_,
   {{0x442d091d,0x443f091e,0x9696013d,0x6d5c009c}},	//   dle_, dmu_, треш, ocra,
   {{0x442d091f,0x442600bb,0x443f0920,0x7c240921}},	//   ele_, _sko_, emu_, loir,
   {{0x69ce0922,0x644b0193,0xeb9f00d6,0x44260923}},	//   _inbe, _bigi, _kjøp_, _pko_,
   {{0x68e30924,0x644b0925,0xe4e300d6,0x26c405db}},	//   ände, _cigi, рішн, _trmo_,
   {{0x644b0926,0xf7430927,0x44260928,0x26c400bc}},	//   _digi, _вето, _vko_, _urmo_,
   {{0x442d0929,0x7c2d08bb,0x644b092a,0x443f092b}},	//   ale_, zlar, _eigi, amu_,
   {{0x442d092c,0x4426092d,0x7c2d092e,0xf99300a1}},	//   ble_, _tko_, ylar, ברת_,
   {{0x4426092f,0x442d0930,0x644b0931,0x62890932}},	//   _uko_, cle_, _gigi, breo,
   {{0x7c240933,0x69ce0934,0x7c2d0935,0x68380072}},	//   doir, _onbe, vlar, cíde,
   {{0x44240936,0x82770130,0x644b0937,0xfbdf0019}},	//   lom_, _יעדע_, _zigi, _viêm_,
   {{0x7c2d06d7,0x644b02a4,0x2d580938,0x7c2400e3}},	//   tlar, _yigi, тись_, foir,
   {{0x69ce0939,0xfbdf00de,0x0a6b07ed,0x6c6a0018}},	//   _anbe, _tiêm_, држи_, علقہ_,
   {{0x7c2d093a,0x3b5400d3,0x644000c2,0x3ea902c9}},	// [4d0] rlar, ркур, immi, _upat_,
   {{0x4424093b,0x7c2d093c,0x442d093d,0x7e7d093e}},	//   hom_, slar, zle_, mssp,
   {{0x442d093f,0x7c2d03a3,0x443f0940,0xa3e3009f}},	//   yle_, plar, ymu_, _नकल_,
   {{0x7c2d0253,0x44240941,0xb8db0942,0x69ce0943}},	//   qlar, jom_, _अन_, _enbe,
   {{0x442d032e,0xc1780138,0x644b0944,0x6d4800c4}},	//   vle_, nkės_, _rigi, ždat,
   {{0x68380945,0x69d80018,0xdb0600b6,0x1a6800cd}},	//   víde, övet, _jaký, _شیمی_,
   {{0x442d0946,0x18b80084,0x443f0947,0x644b0948}},	//   tle_, _игры_, tmu_, _pigi,
   {{0x442402e6,0x442d0949,0x6289094a,0x443f094b}},	//   gom_, ule_, treo, umu_,
   {{0x442d094c,0x644b094d,0x11d900e3,0x395105db}},	//   rle_, _vigi, فوظة_, _kgzs_,
   {{0x442d094e,0x443f094f,0xe0d90950,0x62890951}},	//   sle_, smu_, ево_, rreo,
   {{0x442d0952,0x443f0498,0x644b0953,0x33950018}},	//   ple_, pmu_, _tigi, _ملاز,
   {{0x44240954,0x644b0955,0x68380956,0x7c2401ff}},	//   com_, _uigi, píde, xoir,
   {{0x7c240257,0x7e7d0957,0x3f9e0034,0x00000000}},	//   voir, gssp, ętu_, --,
   {{0x7bcf0958,0x645c016d,0xdb040959,0x8635006e}},	//   _ancu, _éric, leiç, טאָג_,
   {{0x7c24025a,0x0c79055b,0x2019095a,0x6d5c095b}},	//   toir, ксты_, éric_, rcra,
   {{0x6d5c095c,0xf09200ca,0x00000000,0x00000000}},	//   scra, _הנה_, --, --,
   {{0x7c24095d,0x00000000,0x00000000,0x00000000}},	// [4e0] roir, --, --, --,
   {{0x7bcf095e,0x7c24095f,0x7a2b00bc,0x00000000}},	//   _encu, soir, kütu, --,
   {{0x2fd700bf,0xdb040960,0x7c24020d,0x6fd80096}},	//   _شوید_, rdiñ, poir, यापू,
   {{0x78800074,0x27e00102,0x61e00961,0x44240962}},	//   _návš, ðin_, _पक्ष, xom_,
   {{0x4a750963,0x44240964,0x2bd10965,0xfbd10966}},	//   _выст, vom_, हारा, हारम,
   {{0x69ce02e2,0x442402c9,0x00000000,0x00000000}},	//   _unbe, wom_, --, --,
   {{0xdb040161,0xa3cf0285,0xb4ce00b7,0x54a60076}},	//   feiç, शां_, शमे_, احتف,
   {{0xd90d00bf,0x644000e7,0x3a2a0967,0x7e640968}},	//   _تیم_, ummi, _hkbp_, _otip,
   {{0x81bc0029,0x64400969,0x6596096a,0x00000000}},	//   klēt, rmmi, _مجار, --,
   {{0x683800b6,0x2458096b,0xdd1f0206,0x7a30007b}},	//   bídc, _tém_, _líši, dätk,
   {{0x7e64096c,0x4424096d,0xf99300a1,0xddcd096e}},	//   _atip, pom_, זרת_, _ataş,
   {{0x4424096f,0x7e7d0970,0x1e1d0971,0x660a0972}},	//   qom_, tssp, पक्ष_, lifk,
   {{0xbb1b044c,0x81e30033,0x00000000,0x00000000}},	//   _adîn, _নগর_, --, --,
   {{0xdb070018,0xdb060103,0x7e7d0973,0x52830037}},	//   ámít, _lakó, rssp, _الوك,
   {{0x40350974,0x9f520154,0x70940975,0x00000000}},	//   _кекс, _olyè_, _тайф, --,
   {{0xf1d20976,0x7a300220,0x3a2a0085,0xdb06008b}},	//   तावन, bätk, _akbp_, _fakü,
   {{0x200b0977,0x49750978,0xdb060220,0x7a570037}},	// [4f0] mici_, илас, _taký, اضرا,
   {{0xdd910979,0xd91b00c2,0x2c51007f,0x00000000}},	//   _بود_, нье_, _sądu_, --,
   {{0x87e70927,0xd7e7097a,0x00000000,0x00000000}},	//   люде, лідо, --, --,
   {{0x200b08a9,0x69d8097b,0x3dcd03e3,0xf3f100fe}},	//   nici_, över, ɓewa_, _mục_,
   {{0x7c3a00fd,0xb5fd0138,0xdb1d0052,0x6fa7097c}},	//   ître, _atša, _masë, ट्यू,
   {{0x4877097d,0xdb0e0088,0x7bd70138,0x200b097e}},	//   _مدرس, _þjál, šbuč, hici_,
   {{0x200b097f,0xdb1d052f,0x25b60037,0x00000000}},	//   kici_, _ansø, شهيد_, --,
   {{0x73e508d8,0x69c90980,0x28e200bc,0xe4c80981}},	//   роиз, _होती, पहरि, ابون_,
   {{0x200b0982,0x22150983,0x45d500ae,0x62860984}},	//   dici_, ифор, _коас, škon,
   {{0xe1250508,0x9f59028d,0x7a3000c2,0xdb060154}},	//   импи, misù_, vätk, _kakò,
   {{0x200b0985,0x7e640986,0xdb0602f1,0x26e30294}},	//   fici_, _stip, _jakò, ̣rọ_,
   {{0x200b0987,0x764300a4,0xf3f100fe,0xdb060383}},	//   gici_, lmny, _dục_, _makò,
   {{0x32630018,0xdb0602f1,0x32670202,0xd343001c}},	//   _انتہ, _lakò, _стев, _افشی,
   {{0x61450231,0x7e64025b,0x3f8c00a7,0x00000000}},	//   _кела, _vtip, şdu_, --,
   {{0x443d006c,0x76430167,0x61e30988,0x00000000}},	//   _khw_, imny, _ionl, --,
   {{0x200b0989,0x61e30018,0xab66098a,0x784500c6}},	//   cici_, _honl, рвал, _tėvy,
   {{0x395600c9,0x61e3098b,0x7a2b0018,0xda650037}},	// [500] ањет, _konl, yütt, مالي,
   {{0x61e30113,0x2fc000ee,0xdb060154,0xdb1d098c}},	//   _jonl, _haig_, _bakò, _masè,
   {{0x61e3098d,0xdb1d022b,0x443d0381,0xd826098e}},	//   _monl, _lasè, _ohw_, аджи,
   {{0xb8ce05d4,0xe666098f,0x443d02ad,0xb8fe074c}},	//   _कह_, атко, _nhw_, _तप_,
   {{0x2fc00990,0xddd6025b,0xb8660103,0x660a0991}},	//   _maig_, _zvyš, _چارو, tifk,
   {{0x2d980992,0x200b030b,0x2fc00993,0x645e0161}},	//   ngre_, zici_, _laig_, ípio,
   {{0x443d005c,0x200b0367,0x9f4200c2,0x3ea00090}},	//   _bhw_, yici_, lkkä_, _lqit_,
   {{0xe8d700a1,0x25a90106,0x76430994,0x25a000b6}},	//   _דולר_, đala_, amny, řil_,
   {{0x9f4902a5,0x78af0995,0x61e300c4,0x68380072}},	//   _ilaç_, čivš, _bonl, cída,
   {{0x61e30996,0xc05a01b3,0x00000000,0x00000000}},	//   _conl, кім_, --, --,
   {{0x61e30997,0x3a3700a1,0x2fc00998,0x39570327}},	//   _donl, שרים_, _baig_, ישים_,
   {{0x2fc0023e,0xdb1d0154,0xf42700ae,0x00000000}},	//   _caig_, _fasè, _кохл_, --,
   {{0x200b0999,0x2fc0099a,0x00000000,0x00000000}},	//   rici_, _daig_, --, --,
   {{0x6282099b,0x9f49099c,0x2d85020d,0xf3f100fe}},	//   _ivoo, _llaç_, ûle_, _tục_,
   {{0x52b6099d,0x6e27099e,0x200b099f,0x02b607d5}},	//   _अनुस, rojb, pici_, _अनुन,
   {{0x3b55083c,0xd0f700ca,0x2fc000b3,0x61e3029a}},	//   скар, _כמות_, _gaig_, _zonl,
   {{0xa3a809a0,0xdb1d00d1,0x61fa09a1,0x00000000}},	// [510] ख्य_, _kasé, ohtl, --,
   {{0xf9930602,0x6838030b,0x98c709a2,0x8af000a7}},	//   تبر_, vída, исел, nbəy,
   {{0x2fc001fa,0xdb1d0763,0xb9c40037,0x00000000}},	//   _yaig_, _masé, تقلي, --,
   {{0x200901c2,0x628009a3,0x2a6909a1,0x00000000}},	//   _jmai_, ksmo, ppab_, --,
   {{0x6fd8009d,0x27e4020a,0xf9930037,0x00000000}},	//   यातू, _domn_, _وبس_, --,
   {{0x7aed010a,0x764309a4,0x96210285,0x00000000}},	//   myat, umny, यवेट_, --,
   {{0xfc3f0028,0x7aed09a5,0x76430085,0x00000000}},	//   _khí_, lyat, rmny, --,
   {{0x248909a6,0x81c30081,0x61e309a7,0x1d1800ca}},	//   čam_, _একই_, _sonl, יקור_,
   {{0xfc3f00e3,0x645c0018,0xf1d2009d,0x628009a8}},	//   _mhí_, _érin, तांन, gsmo,
   {{0x201909a9,0x200909aa,0x7a3009ab,0x673b09ac}},	//   érin_, _amai_, täti, _izuj,
   {{0x7aed0167,0x62800313,0x61e309ad,0x443d02db}},	//   hyat, asmo, _vonl, _thw_,
   {{0xfc3f00de,0xfbdf0023,0x7a3009ae,0xafdb09af}},	//   _nhí_, _kiêu_, räti, smøn,
   {{0x2fc00472,0x7a300084,0x0cd009b0,0x61e30847}},	//   _vaig_, säti, हम्म, _tonl,
   {{0x61fa09b1,0x7aed09b2,0xfc3f09b3,0x3edf0294}},	//   chtl, dyat, _ahí_, _gwọọ_,
   {{0x4095054f,0xfc3f054f,0x2fc001fa,0xfbdf0023}},	//   _العر, _bhí_, _taig_, _liêu_,
   {{0xfc3f0028,0x7ff609b4,0x3ce50222,0x79870383}},	//   _chí_, _دستا, älva_, _adjw,
   {{0x68e309b5,0x44c700fe,0x7aed01f9,0x27e4009c}},	// [520] ändn, _lđ_, gyat, _romn_,
   {{0xc3320054,0x200e00a5,0x27e400ae,0xddcd0146}},	//   לון_, ślić_, _somn_, _zvaž,
   {{0x224b0220,0x44c70023,0xe93a07ed,0x9f4900ee}},	//   ícky_, _nđ_, учај_, _plaç_,
   {{0x628009b6,0x8b96004d,0x7aed09b7,0x60dc02c3}},	//   ysmo, _уроч, byat, ärmi,
   {{0x673b0034,0x7aed0079,0x683800b6,0x661a0167}},	//   _czuj, cyat, bídn, _pjtk,
   {{0x99d60241,0x600f05aa,0xd49a09b8,0xfbdf00fe}},	//   _اتحا, _kòmè, гри_, _diêu_,
   {{0x320c022b,0x44c700de,0x7589004d,0xdb1d020d}},	//   vidy_, _cđ_, рсів_, _rasé,
   {{0xc7a309b9,0x628609ba,0x628009bb,0x07a300f3}},	//   _ниск, škom, tsmo, _насн,
   {{0x6aa409bc,0x6d430146,0x200900dc,0xdb1d09bd}},	//   ntif, _únav, _rmai_, _pasé,
   {{0x60ca0085,0x20090063,0x628009be,0xaac900b6}},	//   _prfm, _smai_, rsmo, रितक,
   {{0x2019001f,0x320c0094,0x44c700fe,0xe7bc0179}},	//   ério_, ridy_, _gđ_, _ईसाप,
   {{0x7aed09bf,0x6aa4048e,0xf53700a1,0x91a70174}},	//   yyat, ktif, _פנאי_, _piṇ_,
   {{0x733600cd,0x657a001c,0x645a09c0,0xfbdf00fe}},	//   _ارائ, _keth, _huti, _xiêu_,
   {{0x329b09c1,0x7aed09c2,0xe7cf09c3,0xa2b709c4}},	//   _עבוד, vyat, _सोनप, ्टर्,
   {{0xf1a900bf,0xfc3f0028,0x657a09c5,0x317e00e7}},	//   _خانه_, _phí_, _meth, matz_,
   {{0x645a09c6,0x657a09c7,0x317e01bf,0x20090063}},	//   _muti, _leth, latz_, _umai_,
   {{0x645a09c8,0x1a5b00e3,0xed4e0103,0x7c3a014b}},	// [530] _luti, اشرة_, ٹھی_, îtra,
   {{0x645a025a,0x7aed09c9,0xa3a80557,0x9f4b02c6}},	//   _outi, ryat, ख्त_, nkcí_,
   {{0xe8e0011b,0x2bc409ca,0xfbdf0023,0x317800a5}},	//   ười_, _लोका, _siêu_, órzy_,
   {{0x317e09cb,0x657a0178,0x4735001f,0x00000000}},	//   hatz_, _aeth, онес, --,
   {{0x657a09cc,0x6aa409cd,0xe70b00cd,0x3f890239}},	//   _beth, ctif, دتان_, _mdau_,
   {{0x645a09ce,0x25a90106,0x657a001c,0x63ab0063}},	//   _buti, đalo_, _ceth, _sbgn,
   {{0x69d509cf,0x645a002d,0x8ccc09d0,0x44290019}},	//   _inze, _cuti, हियो, _ưa_,
   {{0xfbdf0028,0x69c509d1,0x657a01cb,0x61f801cb}},	//   _tiêu_, ldhe, _eeth, _alvl,
   {{0x6fdd009d,0x657a09d2,0xdb1d09d3,0xb5a70002}},	//   यानं, _feth, _insó, _грей,
   {{0x69c509d4,0x657a09d5,0x645a09d6,0x317e09d7}},	//   ndhe, _geth, _futi, gatz_,
   {{0xf99209c1,0x69c50049,0x645a09d8,0x7a300084}},	//   ורי_, idhe, _guti, mätt,
   {{0x7a3009d9,0x777b0257,0x81bc00d9,0x657a0201}},	//   lätt, _jeux, slēp, _zeth,
   {{0x3f890150,0x69d509da,0x657a0060,0x645a0827}},	//   _ddau_, _onze, _yeth, _zuti,
   {{0x317e0350,0x201909db,0x2d9e09dc,0x3f8900eb}},	//   catz_, ansi_, üte_, _edau_,
   {{0x69c503a8,0x68e30364,0xb147001c,0x271509dd}},	//   ddhe, ändl, _دیدم_, तपुर_,
   {{0x69d502dc,0x7bc402e5,0x6aa409de,0x7a3009df}},	//   _anze, udiu, ttif, hätt,
   {{0xb4b6033a,0xfaa309e0,0x7bc409e1,0x6aa409e2}},	// [540] _छन्_, мато, rdiu, utif,
   {{0x69c509e3,0xe9d709e4,0x8eb30018,0x99630094}},	//   gdhe, оку_, _کمیش, _píšu_,
   {{0x02b6022d,0xd91009e5,0x657a09e6,0x20dc0220}},	//   _अन्न, ریر_, _reth, pšiť_,
   {{0x657a09e7,0x5fdd009d,0x26cd0072,0x69d509e8}},	//   _seth, यायल, _breo_, _enze,
   {{0x26cd09e9,0x645a09ea,0x777b0257,0x657a09eb}},	//   _creo_, _suti, _deux, _peth,
   {{0x7c36003e,0x63a909ec,0x76410178,0x7aeb042c}},	//   llyr, efen, _chly, ägte,
   {{0x63a909ed,0x5fca0976,0x6fca0296,0x788002c6}},	//   ffen, ियाल, ियां, _dává,
   {{0x657a09ee,0x63a90150,0x26cd002b,0x442f0063}},	//   _weth, gfen, _freo_, _ckg_,
   {{0x26cd0124,0x442f09ef,0x645a09f0,0x7a3007ee}},	//   _greo_, _dkg_, _wuti, bätt,
   {{0x645a09f1,0x914a09f2,0x238c0138,0x1546002d}},	//   _tuti, ична_, dėjų_, _дезм,
   {{0x645a02fd,0x425400cd,0x96c20789,0x69db009d}},	//   _uuti, _کنتر, लिकॉ, नाती,
   {{0x317e01bf,0x765b010a,0x00000000,0x00000000}},	//   satz_, _yuuy, --, --,
   {{0x238c00c6,0x531600d1,0x69c509f3,0x386a033c}},	//   gėjų_, _بذار, ydhe, _ltbr_,
   {{0x81f809f4,0xc693021e,0x69c50188,0x3f8401cd}},	//   _دفتر_, ואש_, xdhe, ómur_,
   {{0x644209f5,0x271c0028,0x71260037,0x1bd500e5}},	//   _khoi, ỉnh_, _برشل, повя,
   {{0x60240291,0xdfd10037,0x929d007f,0x00000000}},	//   _одја, _أية_, szłe, --,
   {{0x34b709f6,0x644209f7,0xdb1d022b,0x8af000a7}},	// [550] _आन्द, _mhoi, _ansò, dcəs,
   {{0x78a50102,0x69c501cb,0x59d204d7,0x00000000}},	//   tthv, udhe, सागर, --,
   {{0x69c509f8,0x26cd08a9,0x62860094,0xd75909f9}},	//   rdhe, _sreo_, škoh, ملات_,
   {{0x76410052,0x69c50052,0x78a501ab,0x00000000}},	//   _shly, sdhe, rthv, --,
   {{0x2bc4007d,0x7c2d09fa,0x7bda00a1,0x7a3009ab}},	//   _लोटा, moar, _הקרו, tätt,
   {{0x7c2d09fb,0x26cd00d3,0x1dcb0438,0x29070037}},	//   loar, _vreo_, ायित, únas_,
   {{0x7a3009fc,0x644202bc,0x6ab90092,0xdb1d09fd}},	//   rätt, _bhoi, şafı, _masí,
   {{0x7a3009fc,0x57b409fe,0x644209ff,0x7c2d0a00}},	//   sätt, _обст, _choi, noar,
   {{0xd5bb0a01,0x64420a02,0x63a90a03,0x7c2d01c8}},	//   _все_, _dhoi, rfen, ioar,
   {{0x63a90a04,0x7c2d0a05,0xdb0d0a06,0x1306007b}},	//   sfen, hoar, ndañ, яный_,
   {{0xf99207a6,0x64420514,0x7c2d02a7,0x3eb20a07}},	//   ערט_, _fhoi, koar, _spyt_,
   {{0xb4d70a08,0xa3bb0a09,0x644209f7,0x442f0a0a}},	//   ामी_, _خاطر_, _ghoi, _ukg_,
   {{0x7c2d0a0b,0x64490a0c,0x317c05db,0x00000000}},	//   doar, mmei, _fevz_, --,
   {{0x64490a0d,0xfce60a0e,0x238c00c6,0x8b08007f}},	//   lmei, пого, rėjų_, nięż,
   {{0x1fb6036f,0xe6b804f8,0x7c2d0a0f,0x238c00c6}},	//   _еспр, _इन्ज, foar, sėjų_,
   {{0x644901b5,0x7c2d0a10,0x1e860a11,0xb91a0129}},	//   nmei, goar, _елим, anyị_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [560] --, --, --, --,
   {{0x3f82042b,0x64490a12,0xdcfc0a13,0x2d9c00f2}},	//   laku_, hmei, larč, _øve_,
   {{0x23bd034d,0x6e2e0a14,0x53bd0592,0x9f590314}},	//   ्याद, mobb, ्याश, cisó_,
   {{0x3f820a15,0x7a3001bf,0xdb1d00b6,0x7c2d020a}},	//   naku_, täts, _zasí, coar,
   {{0x5fdd009d,0x442d0a16,0x644900aa,0xfbb900b6}},	//   यातल, doe_, dmei, उजरम,
   {{0x7bc60a17,0x64420a02,0xe5340a18,0x3f820a19}},	//   _haku, _shoi, мель, haku_,
   {{0x7bc60a1a,0x64420a1b,0x3f82023b,0x75fd05aa}},	//   _kaku, _phoi, kaku_, _bèzb,
   {{0x293700c1,0x7bc601ce,0x00000000,0x00000000}},	//   _זאלן_, _jaku, --, --,
   {{0x7bc60a1c,0x3f820a1d,0xdb0d003e,0x64a000c4}},	//   _maku, daku_, ndað, dšiš,
   {{0x7bc6048e,0x7c2d0a1e,0x6e2e0a1f,0x64420a20}},	//   _laku, zoar, jobb, _whoi,
   {{0x64420a21,0x5f950a22,0x6e2e0a23,0x3f820a24}},	//   _thoi, минт, dobb, faku_,
   {{0x3f820a25,0x04db00a1,0x7c2d0a00,0xdcfc007e}},	//   gaku_, _לקבל, xoar, garč,
   {{0x7c2d00d3,0x63a20133,0xdb0d016d,0xdb1d0a26}},	//   voar, _icon, meaç, _pasí,
   {{0x91e30a27,0x61140a28,0x7bc60270,0x9f590076}},	//   _поче, _одлу, _aaku, mhsí_,
   {{0x7c2d0a29,0x7bc60a2a,0x6fa50096,0x00000000}},	//   toar, _baku, _कापू, --,
   {{0x7bc60a2b,0x2c0d009d,0x61ea0a2c,0x00000000}},	//   _caku, _सगळं_, _hofl, --,
   {{0x7c2d0a00,0x4a550a2d,0x7bc60a2e,0x645c0036}},	// [570] roar, дкас, _daku, _èrif,
   {{0x7c2d0a2f,0x6838000d,0xa2bf0a30,0x7e6d0a31}},	//   soar, bídk, _वनस्, _itap,
   {{0x7bc60a32,0x2d830a33,0x7c2d0a34,0x41ae0a35}},	//   _faku, maje_, poar, ज्यस,
   {{0x2d9c070a,0x27e90682,0x2d830a36,0x7bc60a37}},	//   _över_, ðan_, laje_, _gaku,
   {{0x6fa50a38,0x7e6900d3,0x442d0a39,0x76ab0a3a}},	//   _कानू, _împă, voe_, стев_,
   {{0x7bc60a3b,0x2d830a3c,0xdcfc033b,0x7e6d0a3d}},	//   _zaku, naje_, zarč, _mtap,
   {{0x7bc60a3e,0xb4d7074c,0x442d0a3f,0x3f820a40}},	//   _yaku, ामे_, toe_, yaku_,
   {{0x683101df,0x3cfc0a41,0x2d830a42,0x1ae40a43}},	//   råds, מלונ, haje_, _নেয়া,
   {{0x69c70a44,0x64490a45,0x442d0996,0x26cb06aa}},	//   _kaje, rmei, roe_, _éco_,
   {{0x63a20a46,0x64490a47,0x442d00b7,0xa879006e}},	//   _econ, smei, soe_, ֿאָר,
   {{0x3f820a48,0x7e6d0a49,0x61ea0a4a,0x93270018}},	//   taku_, _atap, _dofl, _کران,
   {{0x69c700bf,0x63a20037,0x683802c6,0x00000000}},	//   _laje, _gcon, vídk, --,
   {{0x63bb0a4b,0xb5fd00e4,0xcb0c0285,0x00000000}},	//   meun, _atši, _सेंड_, --,
   {{0x69c70a4c,0x2d830a4d,0x3f820a4e,0x63bb0a4f}},	//   _naje, gaje_, saku_, leun,
   {{0x7bc60a50,0xed570a51,0x62860146,0xdca30a52}},	//   _paku, дор_, ákov, кари,
   {{0xaac90789,0x6e2e0a53,0x8c430a54,0x60c30139}},	//   रिंक, sobb, весе, _isnm,
   {{0x69c70a55,0x7bc60a56,0xf41200a1,0x2d830a57}},	// [580] _baje, _vaku, דפן_, baje_,
   {{0x7c2903ce,0x7bc60a58,0x69c70a59,0x68380a5a}},	//   čera, _waku, _caje, mídi,
   {{0xb4d700b7,0x1c460307,0x00000000,0x00000000}},	//   ामो_, _оном, --, --,
   {{0x63bb0a5b,0x00000000,0x00000000,0x00000000}},	//   jeun, --, --, --,
   {{0xa3e105cd,0x6b840a5c,0x56940095,0x69c70a5d}},	//   दान_, maig, халт, _faje,
   {{0x6b840a1b,0x69c70a5e,0x63a20a5f,0x00000000}},	//   laig, _gaje, _scon, --,
   {{0xe9a303a6,0x61ea0a60,0xdb0f00fc,0x628f0a61}},	//   _шарп, _rofl, _abcè, ácon,
   {{0x69c703ce,0x6b840a62,0x2d830a63,0xd9430a64}},	//   _zaje, naig, zaje_, _реси,
   {{0x27e60113,0x752d0511,0x83fc09ac,0x69c70350}},	//   mjon_, ğaza, _nuđe, _yaje,
   {{0x27e60a65,0x6b840a66,0x24f60a67,0x68380072}},	//   ljon_, haig, _очер, dídi,
   {{0xdb1d025b,0x2d830a68,0x6b840a69,0xdbcd0139}},	//   _masá, vaje_, kaig, _bóìs,
   {{0x68e30a6a,0x63bb0072,0x83fc0106,0x2d830a6b}},	//   ändi, ceun, _buđe, waje_,
   {{0x6b840a6c,0xfe6e0103,0xe46a01cd,0x00000000}},	//   daig, یگی_, blöð_, --,
   {{0x61ac0081,0xdb1d0094,0x26c40131,0x00000000}},	//   _কোরআ, _nasá, _msmo_, --,
   {{0x2d830a6d,0x69c70a6e,0x6b840037,0x7c8400d3}},	//   raje_, _raje, faig, куте,
   {{0x2d830a6f,0x69c70a70,0x25a90335,0xa00800e3}},	//   saje_, _saje, đali_, _يقول_,
   {{0x79a70a71,0x7e6d0a72,0x68380161,0xdb1d034f}},	// [590] дрее, _utap, cídi, _basá,
   {{0x2fc90a73,0x1e1400d3,0xdb1d03a8,0x00000000}},	//   _haag_, _амья, _casá, --,
   {{0x6b84013f,0x61e70149,0x69c70a74,0x26c40634}},	//   baig, öjli, _vaje, _asmo_,
   {{0x69c70a75,0x6b840a76,0x2fc90313,0x27e60a77}},	//   _waje, caig, _jaag_, gjon_,
   {{0xb4d70a78,0xdb1d0a79,0x2fc90a7a,0x69c70a7b}},	//   ाम्_, _ansö, _maag_, _taje,
   {{0x2fc903ee,0x7a2b02e2,0xa594008f,0x69c70a4b}},	//   _laag_, hütz, връщ, _uaje,
   {{0x63bb04ee,0x97a70a7c,0x6fa5009d,0xdb0f0a7d}},	//   teun, _орал, _काढू, _tacó,
   {{0xee3f0220,0x2d810a7e,0x75fd022b,0x321e0a7f}},	//   dtým_, _lehe_, _dèza, enty_,
   {{0xc6a40a80,0x63bb0a81,0xb06500c2,0x17f80037}},	//   _архи, reun, kyää, _غرفة_,
   {{0xddc400e9,0xdb040a82,0x63bb0a83,0x2d810134}},	//   _otiš, nfiá, seun, _nehe_,
   {{0x83fc00e9,0xdcfc0a84,0x27ff05db,0x93240a85}},	//   _suđe, karā, _klun_, فرین,
   {{0x2fc90a86,0xb5fd0a87,0xaad200b6,0x79850169}},	//   _caag_, _duše, सिमक, hahw,
   {{0x2fc90a88,0x7985061d,0x2d810634,0x27ed00f3}},	//   _daag_, kahw, _behe_, _moen_,
   {{0x27ff0150,0x20020a89,0x11d90037,0x27ed0a8a}},	//   _llun_, shki_, _روعة_, _loen_,
   {{0x62860a8b,0xb5fd0995,0x6b840a8c,0x7c29037d}},	//   škot, _guše, taig, čern,
   {{0x27ed0a8d,0x8b950a8e,0x83fc00cc,0x64590113}},	//   _noen_, круч, _tuđe, _jiwi,
   {{0x64590a8f,0xdb1d0a90,0x499600ae,0x6b840a91}},	// [5a0] _miwi, _pasá, ешет, raig,
   {{0x6b840099,0x27ff0a92,0x2d8102e2,0x62890a93}},	//   saig, _alun_, _gehe_, iseo,
   {{0x7d7b00a1,0xdb1d0018,0x6d5e02c9,0x6b840a94}},	//   _מניו, _vasá, _igpa, paig,
   {{0xc6a60a95,0x64590a96,0x25a500eb,0x27ff00eb}},	//   ерки, _niwi, _acll_, _clun_,
   {{0x27ed01aa,0x79850193,0x27e60a97,0x75fd022b}},	//   _doen_, bahw, rjon_, _sèza,
   {{0x27e60a8d,0x6d5e0131,0x2d810062,0x3e6600fe}},	//   sjon_, _jgpa, _xehe_, _môt_,
   {{0x69dc0a98,0xd9430a99,0x8cd308fa,0xb4bc00c3}},	//   _inre, _бери, डियो, ेटे_,
   {{0xb4b0007a,0x27ff0a9a,0x64590a9b,0x7f440372}},	//   _ओही_, _glun_, _ciwi, _oziq,
   {{0x7ae408a8,0x64590a9c,0xaac9030b,0xf1db0096}},	//   nxit, _diwi, रिएक, बांन,
   {{0xb5fd042d,0x44ce00a5,0x645901c0,0x2fc90a9d}},	//   _puše, _tę_, _eiwi, _saag_,
   {{0x7a2b02e2,0x98b30a9e,0x200001ec,0x7f440372}},	//   tütz, čeće_, _blii_, _aziq,
   {{0x2d8101bf,0x6d5e00f9,0x200001b9,0x7af6007b}},	//   _sehe_, _agpa, _clii_, kyyt,
   {{0x2d810139,0x69dc0a9f,0xee3f0146,0xddc40995}},	//   _pehe_, _onre, stým_, _stiš,
   {{0x84e402d5,0xb5fd0aa0,0x2ee10aa1,0x2fc90a88}},	//   _कपाट_, _tuše, _पपीत, _waag_,
   {{0x765a0aa2,0x7f44019f,0x2fc90aa3,0x27470139}},	//   _mity, _eziq, _taag_, _kìní_,
   {{0x69dc0aa4,0x765a0aa5,0xd7cf0aa6,0xc1780138}},	//   _anre, _lity, _सोंच, lbė_,
   {{0x5a35016e,0x27ed0aa7,0x3b550aa8,0x2d810aa9}},	// [5b0] внат, _roen_, ткар, _tehe_,
   {{0x27ed0aaa,0x61fa0aab,0xb4b000aa,0xfe700076}},	//   _soen_, nktl, _ओहू_, _ادي_,
   {{0xdcfc01d3,0x27ed0aac,0xe6110103,0x2e360537}},	//   parā, _poen_, یشت_, ræft_,
   {{0x69dc04c7,0x87e40aad,0xe71900e3,0x6d450aae}},	//   _enre, люче, ويات_, _izha,
   {{0xf7700391,0xe5a50aaf,0x7bdd0ab0,0x765a0ab1}},	//   صان_, вили, _insu, _bity,
   {{0x0c7400bf,0x6aad0239,0xdb04003e,0x27e001d3}},	//   _جدید, mtaf, meið, ķina_,
   {{0xdb040088,0x27ed0ab2,0x765a00d1,0x00000000}},	//   leið, _toen_, _dity, --,
   {{0x19580ab3,0xc4470018,0x765a00c6,0x00000000}},	//   _часы_, ریشن_, _eity, --,
   {{0x248003ce,0x7c3a0257,0x64590239,0x7bcd0ab4}},	//   ćima_, îtri, _viwi, idau,
   {{0x62890ab5,0x645900bf,0x765a0ab6,0x7bdd0124}},	//   rseo, _wiwi, _gity, _lnsu,
   {{0x7bdd0ab7,0x62890ab8,0x3494065c,0x67290090}},	//   _onsu, sseo, _бахр, _hxej,
   {{0xdb04003e,0x765a0ab9,0xbbe0023a,0xb4bd00aa}},	//   keið, _zity, _पचेक, इबी_,
   {{0x6d450aba,0x76480084,0x7bcd0abb,0x67290090}},	//   _azha, _yhdy, ddau, _jxej,
   {{0x7bdd0abc,0x645c028d,0x51870396,0x7af6007b}},	//   _ansu, _èric, _чуда, vyyt,
   {{0x6e3c0abd,0x15f40abe,0x75fd022b,0x6aad0abf}},	//   rlrb, _अवसर_, _lèzo, etaf,
   {{0x3e660ac0,0x7ae401e9,0x7bcd019c,0x6aad01ab}},	//   _tôt_, txit, gdau, ftaf,
   {{0xdfd20068,0xafdb00f3,0x6aad0ac1,0x00000000}},	// [5c0] _ميں_, rmøt, gtaf, --,
   {{0xfe9b040a,0x6d5e0124,0x7bdd0ac2,0xafdb004d}},	//   _קיימ, _ugpa, _ensu, smøt,
   {{0x7e640084,0x7af600c2,0x83fc0ac3,0xeb9f02b6}},	//   _huip, syyt, _luđa, _blød_,
   {{0xdb0401cd,0x59e0000d,0x7e640ac4,0x765a02f1}},	//   beið, नाहर, _kuip, _sity,
   {{0x779100d0,0x765a0ac5,0xc178013f,0xc7a30ac6}},	//   صیلا, _pity, ybė_, ричк,
   {{0x68380161,0x7d0203e3,0x69dc0ac7,0x07120134}},	//   vídu, _ƙosh, _unre, tụbọ,
   {{0x38630113,0x7e640a88,0x765a0ac8,0x00000000}},	//   _gujr_, _luip, _vity, --,
   {{0x83fc0a39,0x765a05aa,0xeb9f0ac9,0xb0d500aa}},	//   _buđa, _wity, _glød_, धिनग,
   {{0x2a660076,0x765a0172,0xd4030aca,0xfe13023a}},	//   íobh_, _tity, рящи, _डगलस_,
   {{0x320500ca,0x2cba02a1,0x765a05aa,0x7bcd004b}},	//   ghly_, _oppd_, _uity, zdau,
   {{0x68380161,0xa99b00c1,0xbb1b00ae,0x61fa0acb}},	//   sídu, וביר, _neîn, rktl,
   {{0xc05801b3,0x80a30acc,0xeb9f00f2,0x66180a87}},	//   кія_, _कमरे, _kløe_, livk,
   {{0x44260acd,0x7e640113,0x66010216,0x00000000}},	//   _ijo_, _cuip, _yllk, --,
   {{0x27310028,0xb5fd037d,0xdb04003e,0x32050ace}},	//   ỡng_, _kuša, veið, chly_,
   {{0x4426074a,0xab950acf,0x5e5800d3,0xe6bf077d}},	//   _kjo_, ливі, тиря_, _एन्ज,
   {{0x6aad0ad0,0x44260361,0xa4b700ca,0xb5fd0ad1}},	//   ttaf, _jjo_, כללה_, _muša,
   {{0x20190ad2,0xab840ad3,0x7e640a06,0x7bcd0ad4}},	// [5d0] misi_, руск, _guip, rdau,
   {{0x20190ad5,0xdb040088,0x7bcd0ad6,0x66180117}},	//   lisi_, reið, sdau, jivk,
   {{0x44260ad7,0x99640ad8,0x7e6401cb,0x661800d4}},	//   _ojo_, ртул, _zuip, divk,
   {{0x20190ad9,0x44260ada,0x6e35031a,0xba770adb}},	//   nisi_, _njo_, lozb, _لاست,
   {{0x4b7a09c1,0xa3e102d5,0x3a840109,0x7cfc00ce}},	//   _ראשו, दास_, _высв, pärö,
   {{0xd1260adc,0x44260add,0xa2b800c0,0x20190ade}},	//   _هم_, _ajo_, ्बन्, hisi_,
   {{0x20190adf,0x2baa00d2,0x44260ae0,0xb4bd00aa}},	//   kisi_, ङ्का, _bjo_, इबे_,
   {{0x20190ae1,0x6e350062,0x00000000,0x00000000}},	//   jisi_, hozb, --, --,
   {{0x20190ae2,0x4426022b,0xe3b60ae3,0x55a50103}},	//   disi_, _djo_, убы_, _مجاہ,
   {{0x44260ae4,0x6e35042d,0xb5fd05db,0xb7d60065}},	//   _ejo_, jozb, _fuša, _iṣay,
   {{0x201906a3,0x7c290087,0x7e64036b,0x00000000}},	//   fisi_, čerj, _suip, --,
   {{0xc50c006e,0xbb1b00ae,0x20190ae5,0x7e640503}},	//   _קלאָ, _reîn, gisi_, _puip,
   {{0x443f0ae6,0xd24e00cd,0x00000000,0x00000000}},	//   mlu_, تنی_, --, --,
   {{0x443f0ae7,0xdca60a0e,0x831a00c1,0x229200e3}},	//   llu_, лаги, _אונז, _الوس,
   {{0x443f0ae8,0xafdb00f2,0x00000000,0x00000000}},	//   olu_, rmør, --, --,
   {{0xeb9f038c,0x443f008b,0x20190ae9,0x6618042d}},	//   _smør_, nlu_, cisi_, zivk,
   {{0x443f0aea,0x9e5a0aeb,0x2baa00b6,0x8c430aec}},	// [5e0] ilu_, _проф_, ङ्गा, сете,
   {{0x443f0aed,0xd8390154,0x7a300364,0x00000000}},	//   hlu_, _akō_, lätz, --,
   {{0x443f0aee,0x3ea20aef,0xb7d60af0,0x3ce502c3}},	//   klu_, lukt_, _aṣay, älvt_,
   {{0x2bab0af1,0x2d8a0283,0xdc9b0327,0x2a69023e}},	//   _छाया, labe_, _איטל, bqab_,
   {{0xa3d70336,0x443f0af2,0x60060af3,0x68e30212}},	//   ायन_, dlu_, _góme, ändr,
   {{0x7c2400d3,0x7a3001bf,0xb5fd0106,0x443f0af4}},	//   lnir, hätz, _puša, elu_,
   {{0x20190af5,0x5faa009d,0x2955013d,0x443f0af6}},	//   yisi_, _काढल, _вътр, flu_,
   {{0x69ce0af7,0x2d8a0af8,0x68e3085d,0x7c240af9}},	//   _habe, habe_, ånde, nnir,
   {{0x69ce0afa,0x6b86007e,0xf74300d3,0x629b00c6}},	//   _kabe, _mekg, _гето, gruo,
   {{0x69ce0a00,0x32b700e3,0x6b86039f,0x20190afb}},	//   _jabe, ادية_, _lekg, wisi_,
   {{0x69ce0afc,0x443f0afd,0x2d8a0afe,0xaca30134}},	//   _mabe, blu_, dabe_, _kwụg,
   {{0x44260aff,0x7c240039,0x443f0b00,0x69ce0b01}},	//   _ujo_, jnir, clu_, _labe,
   {{0xa3e10693,0x26c60085,0x4ea700d3,0x00000000}},	//   दार_, nwoo_, ырна, --,
   {{0x2d8a0b02,0x20190b03,0x69ce0b04,0xd2500b05}},	//   gabe_, sisi_, _nabe, _بنت_,
   {{0x021700a1,0xafdb02b6,0x2a690b06,0x6b860313}},	//   _תחום_, rløb, wqab_, _bekg,
   {{0xfbdf00ef,0x69a70006,0x62820b07,0x6b860063}},	//   _thêm_, _चाही, _kwoo, _cekg,
   {{0x3f8b0b08,0x2d8a0b09,0x7a3000c2,0x3d950b0a}},	// [5f0] macu_, babe_, läty, _кипр,
   {{0x69ce0b0b,0x3b540b0c,0x443f0b0d,0xd9990182}},	//   _cabe, скур, zlu_, ئنات_,
   {{0x69ce0b0e,0x443f0b0f,0x7a3000c2,0xf7730286}},	//   _dabe, ylu_, näty, ماش_,
   {{0x8d7400cd,0x3f8b0b10,0x6006037a,0x443f00a7}},	//   _پایا, nacu_, _tóme, xlu_,
   {{0x66e50b11,0x443f0b12,0x68e30ac9,0x00000000}},	//   рола, vlu_, åndb, --,
   {{0x69ce0b13,0x3f8b0b14,0x7bcf0169,0x00000000}},	//   _gabe, hacu_, _hacu, --,
   {{0x62820694,0x7bcf0b15,0x3dd70081,0x2aaf0092}},	//   _awoo, _kacu, _সকাল, lüb_,
   {{0x69ce0b16,0x629b0b17,0xaca30174,0x3f8b0b18}},	//   _zabe, truo, _gwụg, jacu_,
   {{0x443f0b19,0x4919009d,0x69ce0b1a,0x02050b1b}},	//   rlu_, _येतो_, _yabe, изин,
   {{0x443f01cd,0xd24e00ab,0x7bcf0b1c,0x91f500d3}},	//   slu_, وني_, _lacu, рчич,
   {{0x443f0b1d,0x61450b1e,0x6faa0096,0x62820b1f}},	//   plu_, рена, _कादं, _ewoo,
   {{0x20040b20,0xdcfe01d3,0x7bcf0027,0x8fa60b21}},	//   ómi_, _nepā, _nacu, шаме,
   {{0x91e50b22,0xf38c006e,0x2d8a0b23,0x62820b24}},	//   _воле, _טראָ, tabe_, _gwoo,
   {{0x44d50b25,0x7a3002e2,0xee370b26,0x2166007e}},	//   _kā_, sätz, иня_, _киши_,
   {{0x2d8a0b27,0x7bcf0b28,0x44d500d9,0x69ce0b29}},	//   rabe_, _bacu, _jā_, _rabe,
   {{0x44d50a84,0x2d8a0b2a,0x31c50b2b,0x3f8b0231}},	//   _mā_, sabe_, _वसुध, cacu_,
   {{0xfaa60b2c,0x69ce0b2d,0xcb0000a5,0x25db00aa}},	// [600] разо, _pabe, लैंड_, _गोभी_,
   {{0x69ce03e5,0x2d960b2e,0x0b590b2f,0x7e76039f}},	//   _qabe, _трис, урсы_, _ityp,
   {{0x44d50325,0x44c70018,0x7bcf0b30,0xfce60b31}},	//   _nā_, _nő_, _facu, _тоно,
   {{0x69ce0b32,0x7bcf0b33,0xfaa60b34,0xb5fd0995}},	//   _wabe, _gacu, _камо, _bušo,
   {{0x7bc400ae,0x41a602d5,0x671601e4,0x00000000}},	//   meiu, _खालस, _देशक_, --,
   {{0xa61300d6,0x28880260,0x7bc40b35,0x00000000}},	//   оміч, _مصری_, leiu, --,
   {{0x291e0222,0x7bcf0079,0x64aa00a7,0xb5fd0357}},	//   _äta_, _yacu, _rəis, _tušn,
   {{0x3edf0134,0x07a30b36,0x68220174,0x75f400ee}},	//   _stọọ_, _масн, ọdba, _vàzq,
   {{0xe5a60b37,0xb5fd00e7,0x521400c2,0x3f8b042d}},	//   _визи, _kušl, йдит, vacu_,
   {{0x44c70018,0x7c290b38,0x216600d3,0x83fc0995}},	//   _fő_, čeri, штиг, _tuđo,
   {{0x7e760b39,0x6aa401c0,0xf99300ca,0x69d9006e}},	//   _atyp, huif, חרת_, אַרו,
   {{0xa3d7074c,0xb5fc00bd,0xdb1d0103,0xa2b80b3a}},	//   ायण_, _diġe, _vasú, ्बद्,
   {{0xc7b30054,0x69a7018b,0x3f8b0a39,0x7bc40b3b}},	//   חבר_, _चाली, racu_, deiu,
   {{0x27230019,0x7bcf0b3c,0x3f8b0b18,0x00000000}},	//   ằng_, _sacu, sacu_, --,
   {{0x40940b3d,0x7bcf0b3e,0x3f8b005c,0x6adf00a3}},	//   _البر, _pacu, pacu_, नम्र,
   {{0x3ced0039,0x41a60b3f,0x95fe0033,0x27230031}},	//   ćev_, _खाँस, ্চিম_, nčnú_,
   {{0x99670b40,0x7bcf0b41,0x798700ec,0xa3d70b42}},	// [610] ател, _vacu, _pejw, ायत_,
   {{0x2aaf00a7,0x7bcf0b43,0x2b8500fe,0xd357021e}},	//   rüb_, _wacu, ặc_, שימי_,
   {{0x7bcf0b44,0xdcfc0234,0x60060b45,0x00000000}},	//   _tacu, varć, _hóma, --,
   {{0x44d50325,0x7bc400ae,0xf7f4001c,0x3ddf01c2}},	//   _rā_, ceiu, يسند, ɓuwa_,
   {{0xa3ea0b2b,0xd6d900a5,0x6b8d0b46,0x09cf0081}},	//   मान_, _była_, maag, রাবা,
   {{0x44d50325,0x6b8d0b47,0x80af0081,0x3f890027}},	//   _pā_, laag, য়িত্, _leau_,
   {{0x69c50b48,0xcd9800ca,0x00000000,0x00000000}},	//   mehe, בדות_, --, --,
   {{0x6b8d0b49,0x69c50b4a,0x53c902aa,0x44d50a84}},	//   naag, lehe, угим_, _vā_,
   {{0x659500ae,0x60060328,0xe5c70002,0x00000000}},	//   _газу, _nóma, _всео, --,
   {{0x44d50b4b,0xa2050b4c,0x26cd028d,0x69c50b4d}},	//   _tā_, спод, _iseo_, nehe,
   {{0x3f890b4e,0x6b8d0b4f,0x629d0146,0x7e76007f}},	//   _beau_, kaag, ásob, _styp,
   {{0x69c50b50,0x76430b51,0x6b8d0b52,0xdb040076}},	//   hehe, llny, jaag, rfiú,
   {{0x69c50b53,0xaac60251,0x6b8d0b54,0x60060072}},	//   kehe, _रैंक, daag, _cóma,
   {{0x63a90b55,0x6006003e,0x3f9e01e8,0x69c5023b}},	//   lgen, _dóma, ştu_, jehe,
   {{0x61e30b56,0xeb9a0b57,0x63a90b58,0x61fc0b59}},	//   _innl, лив_, ogen, örle,
   {{0x63a90b5a,0x6b8d0b5b,0x60dc01df,0x78a503d6}},	//   ngen, gaag, ærme, duhv,
   {{0x63a90b5c,0xfe720037,0x60060b5d,0xb5fd05db}},	// [620] igen, _عدة_, _góma, _pušl,
   {{0x69c50b5e,0xb5fd00e7,0x443d0364,0x2002007b}},	//   gehe, _bušm, _lkw_, lkki_,
   {{0xa3d70b5f,0x395c0149,0x26cd05e6,0xdcfe00ae}},	//   ाया_, ävs_, _aseo_, _depă,
   {{0x6b8d008c,0x20020084,0x63a90b60,0xb5fd0880}},	//   caag, nkki_, jgen, _dušm,
   {{0xadec0b61,0xa3e105d4,0x69c50b62,0xb4e00285}},	//   ञापन_, दाई_, behe, दम्_,
   {{0x443d0294,0x63a90b63,0x25db07e5,0x78a50a39}},	//   _akw_, egen, _गोदी_, buhv,
   {{0x63a90b64,0x7c290146,0x7d7b006e,0x18a30138}},	//   fgen, červ, אנצו, _нарм,
   {{0x68150067,0x63a90b65,0x83fc005f,0x3a3a0149}},	//   ządz, ggen, _tuđm, lopp_,
   {{0x645c028d,0xfbd300d7,0x00000000,0x00000000}},	//   _èrim, לתה_, --, --,
   {{0x60060b66,0xd9cf0081,0x3a3a0b67,0xddcd007e}},	//   _róma, রাথম, nopp_, _otaš,
   {{0x3f890257,0xb5fc009e,0x45460076,0x00000000}},	//   _peau_, _tiġb, _اناق, --,
   {{0x82a605e1,0x3a3a05e8,0x63a90b68,0xc4d300d7}},	//   _гадж, hopp_, cgen, _מגע_,
   {{0x3f89020d,0x69c50b69,0x3a3a0b6a,0x00000000}},	//   _veau_, yehe, kopp_, --,
   {{0xddcd00a5,0x6b8d0b6b,0x3878009c,0x00000000}},	//   _uważ, waag, _otrr_, --,
   {{0x6b8d0b6c,0x69c501f9,0x00000000,0x00000000}},	//   taag, vehe, --, --,
   {{0x321e0b6d,0x69c50113,0x27e400f9,0x6006003e}},	//   lity_, wehe, _nnmn_, _tóma,
   {{0x69c502e2,0x6b8d0b6e,0xfaff023b,0x15fa00b6}},	// [630] tehe, raag, _afër_, ्सार_,
   {{0x321e0b6f,0xddab0b70,0x6b8d0b71,0x7e7d0b72}},	//   nity_, _стил_, saag, mpsp,
   {{0x094b0b73,0x6b8d0b74,0x69c50b75,0x237f007f}},	//   учаи_, paag, rehe, ybuj_,
   {{0x69c502dc,0xb8f10b76,0xad1a00a1,0x8cc60096}},	//   sehe, _वन_, _כותר, ाबरो,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x20090150,0xb5fd0117,0x443d084e,0x00000000}},	//   _llai_, _tušm, _skw_, --,
   {{0x63a90b77,0xb5fd00cc,0x443d0b78,0x2002003e}},	//   tgen, _hušk, _pkw_, ykki_,
   {{0x5fd90b79,0x66830068,0xdb0d0a43,0x07350b7a}},	//   _बोलल, _فیصل, leañ, _дебю,
   {{0x23290b7b,0x66f400d3,0x320700d4,0x00000000}},	//   ропи_, _епту, _plny_, --,
   {{0xb5fd00e9,0x63a90b7c,0x312500c2,0x20090b7d}},	//   _mušk, sgen, ждог, _alai_,
   {{0x443d0479,0x32070146,0xafdb00f2,0x20090b7e}},	//   _tkw_, _vlny_, rløn, _blai_,
   {{0xa3ea00d2,0xb4d50b7f,0x443d0b80,0xafdb0b81}},	//   माण_, िटी_, _ukw_, sløn,
   {{0x20020084,0xe2da0018,0xb5fd05db,0x00000000}},	//   rkki_, _پانچ_, _nušk, --,
   {{0x27380028,0x321e0b82,0x27e001d3,0x20090b83}},	//   ứng_, city_, ķini_, _elai_,
   {{0xed5a0b40,0xdbc70088,0x7f4d0372,0x00000000}},	//   ров_, töðu, _ezaq, --,
   {{0xb5fd0b14,0xc4d20327,0x200400e8,0x2009030a}},	//   _bušk, וגל_, ījis_, _glai_,
   {{0xa3ea009d,0x3a3a0b84,0x00000000,0x00000000}},	// [640] मात_, topp_, --, --,
   {{0xb5fd031a,0xc18c006e,0x7f440372,0x00000000}},	//   _dušk, ָטאָ, _iyiq, --,
   {{0xd6d90067,0x3a3a0b85,0x00000000,0x00000000}},	//   _było_, ropp_, --, --,
   {{0x8c46002d,0x321e0094,0x386d00d4,0x3a3a00f3}},	//   _феме, zity_, _čert_, sopp_,
   {{0x628600b6,0xa3cd00aa,0x00000000,0x00000000}},	//   škoz, शजन_, --, --,
   {{0xd49a08c3,0x2ba80b86,0x321e0b87,0x00000000}},	//   ари_, गलवा, xity_, --,
   {{0x25a00b88,0x1db20b89,0x321e0b8a,0xd5ad0018}},	//   ğil_, _जानत, vity_, اہم_,
   {{0x25a0026a,0xaa7b00b6,0x321e007f,0x18670161}},	//   şil_, _frýd, wity_, _фати_,
   {{0x2489084f,0x6ab60034,0x6e3c0b8b,0x1dca00a4}},	//   ćama_, ntyf, korb, ाजात,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xa3b5007d,0x321e0054,0x600604d8,0x104b0084}},	//   _चॉक_, rity_, _cómo, иями_,
   {{0xdb210146,0xf1ae00b7,0x320c0b8c,0x7d0300a7}},	//   _štíh, ज्जन, shdy_, _ünsi,
   {{0x6e3c0b8d,0xa3d70386,0x185b0142,0x00000000}},	//   forb, ायर_, יכטע, --,
   {{0x60060072,0xf2870018,0x7e7d0b8e,0x6e3c0062}},	//   _fómo, _بھٹو_, rpsp, gorb,
   {{0x48c500c7,0x3f82005c,0x7f440372,0x00000000}},	//   _এপ্র, bbku_, _eyiq, --,
   {{0x7aed0b8f,0x7bd60124,0x7e7d0b90,0x83fc007e}},	//   txat, gdyu, ppsp, _buđi,
   {{0xf96b0b91,0x7f4d00a7,0x09cf0033,0x671f00a3}},	// [650] арей_, _uzaq, রাসা, _मेढक_,
   {{0x527b0130,0x600d014b,0x7aed00b3,0x00000000}},	//   ינמא, _dûme, rxat, --,
   {{0x2d910b92,0x2d83023b,0x81bc01d3,0x603201d3}},	//   maze_, mbje_, tnēj, sāme,
   {{0x2d910106,0x61f801df,0x7c290146,0x80c40033}},	//   laze_, _lovl, čers, ষিপ্,
   {{0xeb7600c1,0x76c701c3,0xb5fc0078,0x00000000}},	//   _מערץ_, تغال, _siġa, --,
   {{0xe61800d6,0x2d910b93,0xb5fc0090,0x00000000}},	//   оді_, naze_, _piġa, --,
   {{0xa3d70b94,0x7e6d0085,0xb5fd00c4,0xf505013f}},	//   ायल_, _luap, _juši, язко,
   {{0xb5fd050d,0x25db0b95,0xfbdf00de,0x60060031}},	//   _muši, _गोरी_, _thêu_, _rómo,
   {{0x2d910b96,0x26d90143,0x38b50b97,0x29ff007f}},	//   kaze_, _éso_, lår_, ałań_,
   {{0xddc400e9,0x69d50b98,0x11d50037,0x10a50b99}},	//   _stiž, _jaze, ستخد, пион,
   {{0x6d450b9a,0x61f80b9b,0xb5fd0b9c,0x29010103}},	//   _nyha, _dovl, _nuši, nyha_,
   {{0x69d50b9d,0x6e3c0364,0x00000000,0x00000000}},	//   _laze, worb, --, --,
   {{0x63bb05e7,0xa2e50b9e,0xdb1d0143,0x93270b9f}},	//   mfun, _холд, _masó, _بران,
   {{0x2d8c0ba0,0x63bb0ba1,0x2d910ba2,0x7e6d0167}},	//   úde_, lfun, gaze_, _duap,
   {{0xe16600bf,0x61420ba3,0x59df00c3,0x63bb0175}},	//   _عضوی, _пеша, _नफ़र, ofun,
   {{0xc4d207a6,0xbc630ba4,0x6e3c0ba5,0x80b10081}},	//   עגן_, евск, sorb, _জনপ্,
   {{0x2fc00256,0x7e6d0ba6,0x2d910ba7,0x63bb0ba8}},	// [660] _ibig_, _guap, baze_, ifun,
   {{0xa3e200e2,0x25db099d,0x4a430ba9,0x2d910baa}},	//   _फोन_, _गोली_, енув, caze_,
   {{0x38b50bab,0x26df0174,0xdb1d0bac,0x63bb0bad}},	//   går_, _aruo_, _basó, kfun,
   {{0xdb1d0bae,0xde6d0019,0x83fc08a9,0x69d50036}},	//   _obsè, _hươn, _tuđi, _eaze,
   {{0x69d50303,0x6b840baf,0x63bb0090,0x6d40008b}},	//   _faze, mbig, dfun, şmad,
   {{0x69d50bb0,0x6b840bb1,0x281605bc,0x7c3b0b18}},	//   _gaze, lbig, _کورس, čure,
   {{0xdb0f025a,0x63bb0bb2,0xdb1d0bb3,0x2d850103}},	//   _accè, ffun, _absè, űleg_,
   {{0xde6d0019,0x320502b6,0x69d5063d,0x02a60bb4}},	//   _lươn, ekly_, _zaze, пром,
   {{0xa3e10bb5,0x6b840bb6,0x81d50033,0x798e0172}},	//   दाज_, ibig, হান_, _kebw,
   {{0xdb0d001f,0xde6d00de,0x8afb0266,0x6faa097c}},	//   sfaç, _nươn, צהיי, _काउं,
   {{0x6aa40bb7,0x7e6d08d3,0x403505c7,0xd2500018}},	//   hrif, _suap, денс, ٹنگ_,
   {{0x6aa40bb8,0xe45a0bb9,0xa3d70bba,0x2ee00150}},	//   krif, _уже_, ायः_, _brif_,
   {{0xf2060020,0x7e6d0381,0xeb9f0537,0xe2da0103}},	//   _няко, _quap, _fløj_, _دباؤ_,
   {{0x6aa402ec,0xde6d00de,0x9c830220,0x32050bbb}},	//   drif, _cươn, účov, ckly_,
   {{0xde6d0028,0x69d50bbc,0xc1bb00a1,0x38a000ae}},	//   _dươn, _raze, _המוש, nără_,
   {{0x6aa402ad,0x6b8400a6,0x2d910bbd,0x6d450094}},	//   frif, gbig, saze_, _vyha,
   {{0x6aa40bbe,0x2ee00bbf,0xb0380341,0x8f9c00a1}},	// [670] grif, _grif_, _מנהג_, _היחי,
   {{0x38b509ce,0xde6d0019,0x3ea40206,0x6b840bc0}},	//   tår_, _gươn, ámte_, abig,
   {{0x29070bc1,0x6b840bc2,0xee78010d,0x798e05aa}},	//   ána_, bbig, _وصیت_, _debw,
   {{0x290703e5,0x6aa40bc3,0x69d50bc4,0x76410138}},	//   ġna_, brif, _waze, _skly,
   {{0xdb1d0921,0x7c2d0bc5,0x38b50bc6,0x603201d3}},	//   _obsé, mnar, sår_, nāma,
   {{0xde6d0019,0x68e10103,0x7c2d0bc7,0x38b50212}},	//   _xươn, _áldo, lnar, pår_,
   {{0x2489005f,0x442f005c,0xd7fb00ae,0x29070120}},	//   ćamo_, _pjg_, _луа_, ønad_,
   {{0x7c2d0bc8,0xdb0f0bc9,0x67d40070,0x130900a9}},	//   nnar, _accé, _посу, жний_,
   {{0x63bb0bca,0x7c2d0bcb,0x98b800c6,0x25f50285}},	//   rfun, inar, _vyrą_, _एचपी_,
   {{0x3eab0bcc,0x644201e9,0xb5fd0aa8,0x7c2d0bcd}},	//   duct_, _ekoi, _aušv, hnar,
   {{0x63bb0bce,0x7c2d0088,0x32050849,0xc6090521}},	//   pfun, knar, rkly_, वसीय_,
   {{0x2ee002ad,0x81b50081,0xe3b00037,0xde6d00de}},	//   _prif_, _চোখ_, _مره_, _sươn,
   {{0xa3ea0751,0x7c2d02dd,0x443f0bcf,0xe28e0bd0}},	//   मार_, dnar, mou_, _ша_,
   {{0x64490bd1,0x7c2d0bd2,0x645b0bd3,0x3f82007f}},	//   llei, enar, lmui, dłuż_,
   {{0x442d0020,0xe1f00bd4,0x3eb90505,0x9d430bd5}},	//   one_, _حسن_, atst_, верд,
   {{0x443f0bd6,0x7c2d0bd7,0x64490bd8,0xa3b10bd9}},	//   nou_, gnar, nlei, ञ्च_,
   {{0x442d0bda,0xde6d0028,0x644901f7,0x7c290146}},	// [680] ine_, _tươn, ilei, čerp,
   {{0x6aa40bdb,0x443f0bdc,0x2b8c0028,0x6b840694}},	//   rrif, hou_, ếc_, sbig,
   {{0x443f0bdd,0x442d01ce,0x851c0251,0x64490bde}},	//   kou_, kne_, _भेंट_, klei,
   {{0x442d0bdf,0x798e01a2,0x443f0be0,0xc3140081}},	//   jne_, _webw, jou_, াপতি_,
   {{0x442d0031,0x443f0be1,0xb865015a,0x64490be2}},	//   dne_, dou_, رامو, dlei,
   {{0x64490b7c,0x44ce02c6,0x3e7402c3,0xafdb00f3}},	//   elei, _př_, _mät_, tløk,
   {{0x443f0be3,0xa3ea0be4,0x3e740212,0x1dc00be5}},	//   fou_, माल_, _lät_, श्यत,
   {{0x442d0be6,0x443f0ba0,0x68e301c5,0x64490be7}},	//   gne_, gou_, ænde, glei,
   {{0x3e740212,0x9ad30134,0x00000000,0x00000000}},	//   _nät_, tịim, --, --,
   {{0x442d0be8,0x7c240be9,0x6449007b,0x00000000}},	//   ane_, hiir, alei, --,
   {{0x443f0bea,0x850603ed,0x442d0beb,0x25eb04f8}},	//   bou_, _توان, bne_, चारी_,
   {{0x443f0bec,0x62800bed,0x603200e8,0x64490bee}},	//   cou_, ppmo, tāma, clei,
   {{0x64400bef,0x2bdf0789,0x6b9d009c,0x7c240bf0}},	//   momi, _पोषा, _rdsg, diir,
   {{0x64400bf1,0x603201d3,0xddc400e8,0x14c20096}},	//   lomi, rāma, _puiš, _शहाण,
   {{0x7c240bf2,0x6233007e,0x7c2d0bf3,0xb5fc009e}},	//   fiir, _шешу, tnar, _riġl,
   {{0xfc300bf4,0x80c40033,0x2bdf0bf5,0x7c240bf6}},	//   لحق_, ষিদ্, _पोशा, giir,
   {{0xa3b604dd,0xcd0400b6,0x645c028d,0xb5fd0433}},	// [690] _जान_, vněž_, _èriu, _kušt,
   {{0x442d0bf7,0x443f0bf8,0x64400bf9,0x7c2d0bfa}},	//   zne_, zou_, homi, snar,
   {{0x442d0bfb,0x6440019f,0x7c240bfc,0xdb040103}},	//   yne_, komi, biir, rgiá,
   {{0x442403ce,0x27e90bfd,0x443f0bfe,0x64400bff}},	//   jim_, ñan_, xou_, jomi,
   {{0x442d0c00,0x443f0c01,0x6449057a,0x7bcd0c02}},	//   vne_, vou_, vlei, meau,
   {{0x442d0067,0x443f0383,0x7bcd014b,0x6aad0063}},	//   wne_, wou_, leau, muaf,
   {{0x443f0c03,0x442d0c00,0x60060080,0x44240c04}},	//   tou_, tne_, _fómh, fim_,
   {{0x442d0012,0x61ea0c05,0x64400c06,0x7bcd0c07}},	//   une_, _anfl, gomi, neau,
   {{0x442d0c08,0x64490c09,0x63a60c0a,0x9635075f}},	//   rne_, rlei, ókna, _знац,
   {{0x442d0c0b,0x443f0042,0xe1f10080,0x7c240c0c}},	//   sne_, sou_, اسة_, ziir,
   {{0x60260c0d,0x64490c0e,0x443f0c0f,0x65940c10}},	//   една, plei, pou_, _раху,
   {{0x64400c11,0x61ea0c12,0xa3b60c13,0x44240c0b}},	//   comi, _enfl, _जाय_, cim_,
   {{0x7bcd0c14,0x7c240c15,0x2ac301d3,0x00000000}},	//   deau, viir, nībā_, --,
   {{0xa3d70c16,0xb5fd0480,0x2d9e00fd,0x2c75052f}},	//   ायक_, _gušt, ûte_, _båd_,
   {{0x1b1d0081,0xd00a0291,0xa3b60c17,0x7c240c18}},	//   _ভুলে_, _неке_, _जाम_, tiir,
   {{0x7bcd0113,0x3e740c19,0xb5fc00bd,0x00000000}},	//   geau, _tät_, _riġm, --,
   {{0x7c240c1a,0xf41200c1,0x60060c1b,0x1f66004d}},	// [6a0] riir, אפן_, _nómi, _яким,
   {{0x44240c1c,0xe9d70c1d,0x7c240694,0x7c3b0307}},	//   zim_, нку_, siir, čura,
   {{0x7c240c1e,0x44240c1f,0x1bea02b3,0x7bcd0c20}},	//   piir, yim_, _едни_, beau,
   {{0x44240c21,0x95fa0c22,0x7bcd00fc,0x929d007f}},	//   xim_, ्स्ट_, ceau, zyła,
   {{0xa3b604a9,0x6440065c,0x600604d8,0x6b960c23}},	//   _जाब_, vomi, _cómi, mayg,
   {{0x44240c24,0x6b960c25,0x600604c8,0x64400c26}},	//   wim_, layg, _dómi, womi,
   {{0x046608d9,0x7c2f00e3,0x39e70219,0xb5fd0094}},	//   нтим, _áirí, _ядро_, _rušt,
   {{0xb5fd0c27,0xccf3040a,0xd9430c28,0xd4670831}},	//   _sušt, רכה_, _сеси, није_,
   {{0x44240c29,0xb5fd02e6,0x64400c2a,0x2ac300d9}},	//   rim_, _pušt, romi, cībā_,
   {{0x64400c2b,0x6b96008c,0x00000000,0x00000000}},	//   somi, hayg, --, --,
   {{0x64400c2c,0x64a30c2d,0x2a6a0036,0x91f1034c}},	//   pomi, _баха, _mibb_, _अचरज_,
   {{0x2c750c2e,0x929d0034,0x44240c2f,0x64400415}},	//   _råd_, syła, qim_, qomi,
   {{0x7bcd0c30,0x93fb00ca,0x6b96008c,0xb5fd00c6}},	//   veau, _מלאי, dayg, _tušt,
   {{0x61ea0154,0x81bc00e8,0xa3b600a4,0x00000000}},	//   _unfl, gnēt, _जाड_, --,
   {{0x7bcd0c31,0x645c028d,0x71f70103,0xa4a50139}},	//   teau, _èris, _سروس_, _ibòí,
   {{0x59c60789,0x6b960188,0x2c750537,0x00000000}},	//   _रॉबर, gayg, _våd_, --,
   {{0x7bcd0c32,0x7b7400e3,0xb5fd0b14,0xab380c33}},	// [6b0] reau, اطفا, _mušr, епту_,
   {{0x7bcd0c34,0x2bcf0034,0x13d90033,0x49d800ba}},	//   seau, हजहा, থায়, ндую_,
   {{0x6b960188,0x7bcd0c35,0x48ab0c36,0x5d550c37}},	//   bayg, peau, ятам_, _шкот,
   {{0xfbab0084,0x629d0103,0x9f490113,0x200b00b6}},	//   _этой_, ások, _anaé_, nkci_,
   {{0x6aad028d,0x79a70859,0xc66b00c2,0xa3ea02f0}},	//   quaf, _прве, чшее_, माई_,
   {{0x60060165,0x2ac301d3,0xd54900ae,0xb5fd00c6}},	//   _vómi, rībā_, мпле_, _aušr,
   {{0xda34055b,0x2d93016d,0x2ac301d3,0x70af049d}},	//   _серы, _mexe_, sībā_, _झमेल,
   {{0xa3b600a4,0x00000000,0x00000000,0x00000000}},	//   _जाण_, --, --, --,
   {{0x69c10c38,0x961d00e8,0x42550231,0x00000000}},	//   र्थी, _atņe, ктот, --,
   {{0x85b80c39,0x27ff022b,0x2d9300ee,0x00000000}},	//   _плус_, _houn_, _nexe_, --,
   {{0x76430c3a,0x3f9200b3,0x27ff0c3b,0x00000000}},	//   mony, _peyu_, _koun_, --,
   {{0x27ff0154,0x69c10c3c,0xe1f10504,0x7d07007f}},	//   _joun_, र्ती, اسک_, dyjs,
   {{0xa3b60c3d,0x27ff0c3e,0x20190052,0x76430a4b}},	//   _जात_, _moun_, ëria_, oony,
   {{0xed5a0c3f,0xaae000b6,0x76430c40,0x00000000}},	//   дог_, निसक, nony, --,
   {{0x7997025e,0xdcfc00d9,0x27ed0c41,0x629b0138}},	//   daxw, varē, _onen_, lsuo,
   {{0x7ae9005f,0x76430c42,0x20d3044c,0x2a6a009c}},	//   _šeta, hony, _iţi_, _sibb_,
   {{0xee3a0c43,0xab2702af,0x76430c44,0xe9da05af}},	// [6c0] _они_, вота_, kony, мка_,
   {{0x20000113,0x27ed0052,0x7d01042c,0x00000000}},	//   _hoii_, _anen_, älsc, --,
   {{0x76430c45,0x27ff0154,0x940c00a7,0x00000000}},	//   dony, _boun_, _evdə_, --,
   {{0x2d980c46,0x629b0138,0x09cf0033,0x661d0138}},	//   lare_, ksuo, রাগা, _įska,
   {{0x76430c47,0x2a6a00a7,0x27ff01ff,0x2d98044c}},	//   fony, _tibb_, _doun_, oare_,
   {{0x2d980c48,0x76430c49,0xe5340c4a,0xe4b801b6}},	//   nare_, gony, лель, елкі_,
   {{0x69dc0062,0xb5fc003d,0x00000000,0x00000000}},	//   _iare, _jiġi, --, --,
   {{0x64590c4b,0x2d980c4c,0x69dc0c4d,0x34c2000f}},	//   _chwi, hare_, _hare, _शहीद,
   {{0x2d980c4e,0x69dc0c4f,0x51860077,0x76430c50}},	//   kare_, _kare, куна, bony,
   {{0x69dc0c51,0x2d980c52,0x69de0c53,0xa3e20c54}},	//   _jare, jare_, ndpe, _फोर_,
   {{0x69dc0c55,0x25db007d,0x2d980b6a,0x27ff0c56}},	//   _mare, _गोटी_, dare_, _youn_,
   {{0x2d930c57,0x03260c58,0xaa7b00b6,0x03a30c59}},	//   _sexe_, _иден, _brýl, _вицо,
   {{0x2d98028d,0x63a20c5a,0xdcf500d9,0x40340c5b}},	//   fare_, _idon, pazī, реяс,
   {{0x69dc0c5c,0x2d980572,0x62820c5d,0xc0aa037f}},	//   _nare, gare_, _itoo, _قابل_,
   {{0x6d40090e,0x20d30c5e,0xdd940c5f,0x6e2701cb}},	//   şman, _نتيج, расы, rijb,
   {{0x76430c60,0xec3403f8,0xaca30129,0xb5fc0078}},	//   zony, ансь, _ntụg, _diġi,
   {{0x2d980c61,0x81d500c7,0x76430c62,0x5a350c63}},	// [6d0] bare_, হার_, yony, гнат,
   {{0x2d980c64,0xaca30129,0x69dc0c65,0x25e2000d}},	//   care_, _atụg, _care, _टोली_,
   {{0x69dc0c66,0x99670450,0x27ff0383,0x76430027}},	//   _dare, ттал, _poun_, vony,
   {{0x63a20c67,0x3f990c68,0xac1900d6,0x76430c69}},	//   _ndon, nasu_, _чому_, wony,
   {{0x501c0c6a,0xf7700602,0x1dc00789,0x6282006c}},	//   וואו, زان_, श्वत, _ntoo,
   {{0x69dc0c6b,0x63a20c6c,0x627200a5,0x7bdd0c6d}},	//   _gare, _adon, _młod, _hasu,
   {{0x7bdd0c6e,0x27ff0139,0x25a903a3,0x5e5800c1}},	//   _kasu, _toun_, ğal_, דיגע_,
   {{0x2d980012,0x69dc0c6f,0xa3ea000f,0x27ed0c70}},	//   zare_, _zare, माग_, _unen_,
   {{0x7bdd0c71,0x69dc0c72,0x76430c73,0x611300a7}},	//   _masu, _yare, pony, mələ,
   {{0x386d0c74,0x611301d4,0x63a20c75,0x2d980c76}},	//   _hier_, lələ, _edon, xare_,
   {{0x2d980c77,0x62820c78,0x629b0c79,0x7f4d0c7a}},	//   vare_, _etoo, ssuo, _ayaq,
   {{0x7bdd0c7b,0x660100b6,0x3f990218,0x645c0036}},	//   _nasu, _holk, gasu_, _èrip,
   {{0x66010c7c,0x7ae9005f,0x386d0c7d,0x765a007b}},	//   _kolk, _šetn, _mier_, _yhty,
   {{0x61130092,0xddcd0c7e,0xee3f0146,0x386d0c7f}},	//   hələ, _etaž, brým_, _lier_,
   {{0x2d980c48,0x611301d4,0x69dc0c80,0x3f990c81}},	//   rare_, kələ, _rare, basu_,
   {{0x69dc0c82,0x2d980c83,0x44e30b88,0x66010c84}},	//   _sare, sare_, _mı_, _lolk,
   {{0x79950c85,0x2d980c86,0x7bdd0c87,0x61130092}},	// [6e0] _bezw, pare_, _dasu, dələ,
   {{0x7bdd033c,0x2d980052,0x69dc0c88,0xafdb0c89}},	//   _easu, qare_, _qare, bløs,
   {{0x69dc0c8a,0x386d0c8b,0x61130092,0x3ea0004d}},	//   _vare, _bier_, fələ, _hvit_,
   {{0xe73a02fd,0x765a00dd,0xb8dc0c8c,0x69dc0c8d}},	//   нее_, _shty, _आम_, _ware,
   {{0x69dc0c8e,0x386d0c8f,0xc7a30a7c,0xb5fd0141}},	//   _tare, _dier_, сичк, _pušp,
   {{0x38bc0c90,0x3f990c91,0x386d0c92,0x7ae401df}},	//   pír_, zasu_, _eier_, mvit,
   {{0x386d0c93,0x7bdd0198,0x7ae40c94,0x44e30092}},	//   _fier_, _yasu, lvit, _cı_,
   {{0x79950c95,0x611301d4,0x7bdd008a,0x386d0034}},	//   _zezw, cələ, _xasu, _gier_,
   {{0x66010c96,0x7ae40c97,0x52140a71,0xe7370036}},	//   _folk, nvit, идит, _бет_,
   {{0xddcd0c98,0xa3b60006,0x66010c99,0x40860c9a}},	//   _staž, _जाव_, _golk, лумб,
   {{0x7c260c9b,0x59c60c9c,0x7f4d005c,0x3f9900aa}},	//   _omkr, र्यर, _syaq, tasu_,
   {{0x63a20c9d,0x66010063,0x7e7602ac,0x628206b0}},	//   _udon, _zolk, _buyp, _ttoo,
   {{0x44260c9e,0x7bdd0c9f,0x6d4003a3,0x3ea000c4}},	//   _imo_, _rasu, şmal, _cvit_,
   {{0x44260197,0x7bdd0ca0,0x27310019,0x3f9902a4}},	//   _hmo_, _sasu, ạng_, sasu_,
   {{0x7bdd0ca1,0x3f990ca2,0x317b00f5,0x3ea00ca3}},	//   _pasu, pasu_, _ארומ, _evit_,
   {{0x6006003e,0xafdb01df,0x4426024a,0x79950415}},	//   _dóms, rløs, _jmo_, _sezw,
   {{0x59c60557,0xafdb01df,0x7bdf0ca4,0x7bdd0ca5}},	// [6f0] र्भर, sløs, rdqu, _vasu,
   {{0x386d02ec,0x7bdd0ca6,0xafdb09af,0xe29f003e}},	//   _sier_, _wasu, pløs, áði_,
   {{0x44260649,0x7bdd0006,0xc7950077,0x61130092}},	//   _omo_, _tasu, арлы, tələ,
   {{0x79950c95,0x20da0ca7,0x2ee90332,0x66010ca8}},	//   _wezw, mšić_, _kraf_, _solk,
   {{0x6b8d0ca9,0x386d0418,0x2d940181,0x66010caa}},	//   mbag, _vier_, ždeň_, _polk,
   {{0x6b8d0cab,0x611301d4,0x69c70477,0x386d01cb}},	//   lbag, sələ, _ubje, _wier_,
   {{0x66010b7c,0xb605026e,0x22450313,0xf8c90336}},	//   _volk, _aláì, volk_, _रहिय,
   {{0x66010cac,0x61130092,0x22450cad,0x6b8d0cae}},	//   _wolk, qələ, wolk_, nbag,
   {{0x2bc7009d,0xa3b60caf,0x21f5004d,0x95d90cb0}},	//   ऱ्या, _जार_, аїнс, _идат_,
   {{0x20da0106,0x20c5004d,0x69c50076,0x42250cb1}},	//   kšić_, айом, nfhe, рдов,
   {{0x3ea00cb2,0x2ee90178,0x6aad0503,0x00000000}},	//   _svit_, _araf_, hraf, --,
   {{0x44260cb3,0xa4fa00c1,0x6aad0cb4,0x2ee900f0}},	//   _gmo_, _בלעט, kraf, _braf_,
   {{0x636b03a3,0x1f56055b,0xc7d600ca,0x7d010212}},	//   _dönü, ртнё, בורי_, älsn,
   {{0x91fc0b4b,0x6aad0cb5,0x62890cb6,0x2ee90cb7}},	//   rmāc, draf, mpeo, _draf_,
   {{0x3b960cb8,0x2ee90cb9,0x8b960cba,0x6aad05c2}},	//   ијат, _eraf_, ирач, eraf,
   {{0x6b8d0cbb,0xafdb038c,0xe8e00019,0x636b026a}},	//   gbag, slør, _hiệp_, _gönü,
   {{0xa3d606ed,0xada6061b,0x3a2601b6,0x6da60b36}},	// [700] ाजत_, _капл, амаг, _кипа,
   {{0x7ae40cbc,0xac76001c,0x6b8d083e,0x600601cd}},	//   rvit, _پادش, abag, _tóms,
   {{0xdb0d0146,0x7ae40cbd,0x68460cbe,0x636b008b}},	//   čkác, svit, анжа, _yönü,
   {{0x7c260cbf,0xbc7b00a1,0xdb200103,0xebe60cc0}},	//   _umkr, _שנכת, ítóg, _томп,
   {{0x2bdf0096,0xdcfc00c6,0x9f40033c,0x68e5009c}},	//   _पोटा, tarė, _aniú_, avhd,
   {{0x7aeb052f,0xe4a60cc1,0x25a5030a,0x69c50cc2}},	//   ægte, арио, _cdll_, cfhe,
   {{0xd49701b3,0x18a30cc3,0x44260cc4,0x2f380174}},	//   ары_, _марм, _pmo_, ọgh_,
   {{0xa6860cc5,0x7c360150,0xddcd007f,0xf2c60cc6}},	//   _влад, nnyr, _staż, асон,
   {{0x20190052,0x75fd0154,0xb5fc0090,0x00000000}},	//   ërim_, _lèzy, _siġu, --,
   {{0x1db2009d,0x3878023b,0x4426029a,0x64a60cc7}},	//   _जागत, _kurr_, _wmo_, _важа,
   {{0xe3ba0476,0xe8e00023,0x80270cc8,0x2ee9007e}},	//   _абе_, _diệp_, لرحم, _sraf_,
   {{0x7c3b0cc9,0x2ee900d3,0x6f1d0cca,0x20da00cc}},	//   čurk, _praf_, tzsc, všić_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xa3b60ccb,0x6aad028d,0x6f1d042c,0x9f490231}},	//   _जाँ_, vraf, rzsc, _unaí_,
   {{0x6b8d0ccc,0x61fc02c3,0x245100fe,0xdde101f9}},	//   tbag, örlu, _sơmi_, ítői,
   {{0x6aad0ccd,0xa3b60cce,0x2ee90ccf,0x20da0357}},	//   traf, जलि_, _traf_, ršić_,
   {{0x6b8d0cd0,0xf9930037,0xda780cd1,0x00000000}},	// [710] rbag, قبض_, аях_, --,
   {{0xd9990cd2,0x6aad0cd3,0x80da08fa,0x3da70058}},	//   انات_, rraf, _बनाइ, _триб,
   {{0x290700ae,0xa3d602d5,0x69c50076,0xa3b60965}},	//   âna_, ाजा_, rfhe, जला_,
   {{0x6aad002d,0x628901af,0x24850875,0x7d0802c3}},	//   praf, ypeo, _rtlm_, ädse,
   {{0x7c2d0cd4,0xadc40065,0x66e50077,0x6aad00a7}},	//   miar, _atẹw, сола, qraf,
   {{0x929d00a5,0x4aac0cd5,0xb0b602d5,0x59c60285}},	//   syłk, _चितव, _अमंग, र्दर,
   {{0x610a013c,0x7c2d0062,0x00000000,0x00000000}},	//   nəld, oiar, --, --,
   {{0xf77f08bb,0xa954004d,0x7c2d0cd6,0x2a71066a}},	//   _üç_, _єкті, niar, _hizb_,
   {{0x26cd0239,0xa3d60cce,0xaae000b6,0xa3c800aa}},	//   _upeo_, ाज़_, निएक, _लउर_,
   {{0xe1f90cd7,0x7c2d0cd8,0xe613006f,0x00000000}},	//   уго_, hiar, _بشر_, --,
   {{0x7c2d0a00,0xd24e00cd,0x7c360cd9,0x6272007f}},	//   kiar, رچه_, ynyr, _płoc,
   {{0x60060cda,0x9f060037,0x6d40026a,0xc50c006e}},	//   _cómp, موجو, şmak, _שלאָ,
   {{0x91e507f3,0x7c2d0cdb,0x201e01b3,0x528500e3}},	//   _голе, diar, ėti_, _التك,
   {{0x442d0cdc,0x64490cdd,0xe29f003e,0x62720034}},	//   lie_, loei, áðu_, _włoc,
   {{0x442d0a88,0x7c2d0cde,0x0c7900c2,0x00000000}},	//   oie_, fiar, исты_, --,
   {{0x442d0cdf,0x7c2d0ce0,0xb5fc0078,0x75fd0154}},	//   nie_, giar, _jiġr, _vèzy,
   {{0x63a60ce1,0x7c360138,0x442d0ce2,0xb5fc0090}},	// [720] ókni, rnyr, iie_, _miġr,
   {{0x442d06c0,0xc3010081,0x3ea20ce3,0x644901cb}},	//   hie_, এনপি_, mskt_, hoei,
   {{0x442d0ce4,0x8c460ce5,0x7c2d0ce6,0x3ea20ce7}},	//   kie_, _гене, biar, lskt_,
   {{0x442d0ce8,0x2d9a0ce9,0x6e2e0cea,0x6449016d}},	//   jie_, _hepe_, libb, joei,
   {{0x442d0ceb,0x3ea20cec,0xdcfc00d9,0xddc401d3}},	//   die_, nskt_, karī, _muiž,
   {{0x6e2e03e5,0x27e00ced,0x9e7b006e,0x2d9a0cee}},	//   nibb, žin_, אנספ, _jepe_,
   {{0xdcfc00d9,0x291e004d,0x344a0b21,0x2d9a03a9}},	//   darī, _åta_, лчин_, _mepe_,
   {{0x442d0cef,0x2d9a0cf0,0x6449002b,0x6e2e0cf1}},	//   gie_, _lepe_, goei, hibb,
   {{0x38660149,0x610a00a7,0xe73a001f,0x6e2e010a}},	//   mmor_, zəld, _сеа_, kibb,
   {{0x7c2d0cf2,0x442d0cf3,0x2d9a0383,0x3f82007f}},	//   ziar, aie_, _nepe_, ecku_,
   {{0x442d0cf4,0xa1580cf5,0xa3b60cf6,0xf99300ca}},	//   bie_, рану_, _जाऊ_, הרת_,
   {{0x442d0cf7,0x395700a1,0x7c2d0cf8,0x15f00285}},	//   cie_, משים_, xiar, चाकर_,
   {{0x7c2d0cf9,0x799e0cfa,0x6e2e0036,0xa2b200a4}},	//   viar, kapw, fibb, _आमट्,
   {{0xdb0d001f,0x6e2e0172,0x7c2d007f,0x2d9a044c}},	//   lgaç, gibb, wiar, _cepe_,
   {{0x7c2d0cfb,0x2d9a0085,0x6c850037,0x6a690138}},	//   tiar, _depe_, تلزم, _užfi,
   {{0x388101b3,0x2d9a0139,0xc5f401c2,0x7bd60113}},	//   _nėra_, _eepe_, ɓɓe_, geyu,
   {{0x7c2d02a7,0xa3b605a7,0x99990cfc,0x6e2e0cfd}},	// [730] riar, _जाई_, икат_, bibb,
   {{0x442d0cfe,0x6fb5037f,0x7c2d0cff,0xff1800ca}},	//   zie_, _امکا, siar, _לקחת_,
   {{0x9f520383,0x3c5900d3,0x7bd60027,0x00000000}},	//   _anyè_, _винэ_, beyu, --,
   {{0x28ba0336,0x38660d00,0x64490072,0x00000000}},	//   _उमरि, gmor_, xoei, --,
   {{0x442d0d01,0xc9870d02,0xb6c70ae3,0x64490131}},	//   vie_, _губи, ссей, voei,
   {{0x442d0d03,0xd9fd04dd,0xa3b60d04,0x853c013f}},	//   wie_, _उचित_, _जाउ_, _idėj,
   {{0x442d0d05,0x69d7002b,0x64490231,0x00000000}},	//   tie_, mexe, toei, --,
   {{0x52a90d06,0x3ea20324,0x69d70d07,0x00000000}},	//   авим_, yskt_, lexe, --,
   {{0x28e1007d,0x2d8300a5,0x644904e2,0x59c60c38}},	//   फिकि, kcje_, roei, र्वर,
   {{0x442d0d08,0x69d7014b,0x7d080b81,0x00000000}},	//   sie_, nexe, ødsk, --,
   {{0x442d0d09,0x7bd60d0a,0xdbc600bc,0xb5fc009e}},	//   pie_, yeyu, mööd, _tiġr,
   {{0xa3b60d0b,0xa2b202e8,0x62860031,0x245800ae}},	//   _जाए_, _आमच्, íkoc, _лахь_,
   {{0xe299007e,0xb7da00ca,0x6d5802c6,0xbb1b020a}},	//   _тал_, בקרי, _úvaz, _sfîn,
   {{0x63bb0d0c,0x5fdc0d0d,0x3ea20d0e,0xdcf5007f}},	//   lgun, _बसवल, rskt_, zczą,
   {{0xc5f200a1,0xfce30d0f,0x7c3a0d10,0x38660178}},	//   ודם_, моро, étro, ymor_,
   {{0x63bb0d11,0x3ead0d12,0x6e2e0d13,0x26df007e}},	//   ngun, šeta_, sibb, _osuo_,
   {{0x61e30d14,0x81dc0081,0x32070d15,0x799e0d16}},	// [740] _kanl, ডার_, _kony_, tapw,
   {{0x63bb0d17,0x00000000,0x00000000,0x00000000}},	//   hgun, --, --, --,
   {{0x61e30d18,0x63bb0d19,0x5fc10d1a,0x00000000}},	//   _manl, kgun, ष्कल, --,
   {{0xb8f20d1b,0x61e30d1c,0x46ea0d1d,0x6d5e0d1e}},	//   _वह_, _lanl, иден_, _izpa,
   {{0x38660bc6,0x4e0e0b42,0x66da00c2,0x63bb02ac}},	//   rmor_, _हवाई_, рьер_, dgun,
   {{0xb0a90455,0x61e30d1f,0x63bb0d20,0x6aa40239}},	//   _किंग, _nanl, egun, msif,
   {{0xa3d6009f,0x69ce0d21,0x9f4500b6,0xf8b00103}},	//   ाजल_, _ibbe, ělé_, _سکا_,
   {{0x61e301a2,0x2fc00197,0x63bb0d22,0x799c0d23}},	//   _aanl, _ncig_, ggun, _herw,
   {{0x61e30d24,0x2d830034,0x69c10966,0x6272007f}},	//   _banl, ycje_, र्की, _dłon,
   {{0x61e30d25,0x32180067,0x799c01c2,0x320700ee}},	//   _canl, óry_, _jerw, _cony_,
   {{0x61e30d26,0x63bb0a00,0x2ee00d27,0xb97b040a}},	//   _danl, bgun, _asif_, יניי,
   {{0x68e301c5,0x27e60d28,0x69ca0d29,0x61ed0d2a}},	//   ændi, ndon_, स्ती, _ɗali,
   {{0x91e608a4,0x26c60d2b,0x73360018,0x2ee00072}},	//   _моде, ntoo_, _برائ, _csif_,
   {{0xd34400bf,0x63a00d2c,0x61e30150,0x32070072}},	//   _ویژه_, lamn, _ganl, _gony_,
   {{0x27e60124,0x64b802d5,0x0b270033,0x2cb80d2d}},	//   kdon_, _इमोश, _মডেল_, gurd_,
   {{0x27e40572,0xe3ac0081,0x228002f1,0x799c03a8}},	//   _namn_, ক্রব, _kòk_, _aerw,
   {{0x799c0d2e,0xa3cc022d,0x61e303a3,0x69d703be}},	// [750] _berw, श्य_, _yanl, texe,
   {{0x3eb90d2f,0x63bb0d30,0xaaac0442,0x63a00d31}},	//   must_, zgun, _चिरक, hamn,
   {{0x3eb9007a,0x799c0d32,0x69d703eb,0x63a00d33}},	//   lust_, _derw, rexe, kamn,
   {{0x69d70d34,0x69ce0d35,0x6b84028d,0x661a0d36}},	//   sexe, _ebbe, ccig, _altk,
   {{0xd6db0205,0x799c0d37,0x69d70d38,0x3eb900aa}},	//   рте_, _ferw, pexe, nust_,
   {{0x6608008a,0x62720034,0x20090023,0xd5b10037}},	//   _codk, _słon, _loai_, رفع_,
   {{0x1c0f0d39,0x32070154,0x91fc00d9,0x27e40d3a}},	//   _सवाल_, _rony_, rmāl, _famn_,
   {{0xd7c900cd,0x61e30d3b,0x3eb9007a,0x6d3c00ca}},	//   _دوره_, _sanl, kust_, יתונ,
   {{0x63bb0d3c,0x61e30d3d,0x799c0172,0x00000000}},	//   rgun, _panl, _yerw, --,
   {{0x2ea806ed,0x66080d3e,0x3eb90d2f,0x63bb0d3f}},	//   _कटौत, _godk, dust_, sgun,
   {{0x61e30d40,0xa3bb010d,0x610a00a7,0x7985042c}},	//   _vanl, _ناشر_, vəlc, ichw,
   {{0xb4e70455,0x22800c56,0x5437010d,0x63a00d41}},	//   यटी_, _fòk_, _برطر, camn,
   {{0x61e30d42,0xe8030d43,0x3eb90d44,0x2f560d45}},	//   _tanl, _रचना_, gust_, ятос,
   {{0x321e0d46,0xfc3f034f,0x273800fe,0xc4bf00b6}},	//   chty_, _ají_, ẩng_, _एमाओ,
   {{0xed5a0d47,0x27e60d48,0xdbd90088,0xa06a0b99}},	//   сов_, ydon_, tæðu, _лака_,
   {{0x799c0d1b,0x6b9d0d49,0x6aa40d4a,0x3eb90d4b}},	//   _serw, _cesg, tsif, bust_,
   {{0x799c0d4c,0xdbd90088,0x6b84008a,0x3eb90d4d}},	// [760] _perw, ræðu, rcig, cust_,
   {{0x6aa4005a,0x6b840d4e,0x09e30d4f,0x63a0013c}},	//   rsif, scig, ноун, zamn,
   {{0x799c0d50,0x1b040081,0x6b9d002b,0x6aa40d51}},	//   _verw, _রেখে_, _fesg, ssif,
   {{0xdcf500a5,0x79850d52,0x799c0d53,0x26c60d54}},	//   jczę, achw, _werw, ttoo_,
   {{0x799c0d55,0x66080c6f,0x27e60d56,0xe3c30033}},	//   _terw, _podk, rdon_, ্যাব,
   {{0x26c60084,0xd49a08c3,0x98a60d57,0x27e4010a}},	//   rtoo_, бри_, _ниге, _wamn_,
   {{0x26c6008a,0x628b00f0,0x27e60d58,0x80da0034}},	//   stoo_, _atgo, pdon_, _बनें,
   {{0xb60300d9,0xa3b60101,0x04630204,0x22800154}},	//   īšan, _जाओ_, нтым, _pòk_,
   {{0x27f7000d,0x2bce009d,0xd70700ae,0x85760d59}},	//   šení_, ह्या, _енте_, _فدائ,
   {{0x59cf009d,0xe8e000de,0x3eb9007a,0x63a00088}},	//   स्पर, _nhịp_, vust_, samn,
   {{0x69c10c38,0x3eb90126,0x00000000,0x00000000}},	//   र्टी, wust_, --, --,
   {{0x3eb90006,0x5ed60033,0x8fa40c37,0xa3b606eb}},	//   tust_, দিনে, наџе, _जाट_,
   {{0x6b9d0d5a,0x798500f0,0x24490d5b,0x00000000}},	//   _resg, ychw, _بجلي_, --,
   {{0x99ce00c7,0x6b9d0143,0x3eb90d5c,0x00000000}},	//   রযুক, _sesg, rust_, --,
   {{0x61f80305,0x3eb9007a,0x248c0036,0xddde0103}},	//   _invl, sust_, _jtdm_, _cipő,
   {{0x3eb90d5d,0x5c740d5e,0x315700ca,0x25fe055c}},	//   pust_, елст, _מיון_, लाडी_,
   {{0x3eb90d5f,0x3a7502a0,0x00000000,0x00000000}},	// [770] qust_, длар, --, --,
   {{0xdce701e8,0xa3cc0251,0xdcf50034,0x996700d3}},	//   sajı, श्त_, zczę, птел,
   {{0x02d9033a,0x79850d60,0x52d900b6,0x201900c6}},	//   _भन्न, rchw, _भन्स, ūriu_,
   {{0x798502e2,0x69c8026a,0x69c10d61,0x6d45063d}},	//   schw, _öden, र्जी, _ixha,
   {{0x601f00dd,0x61f802ac,0x00000000,0x00000000}},	//   _këmb, _onvl, --, --,
   {{0x7bcd0d62,0x8afa00ca,0x7e770090,0xafdb0537}},	//   lfau, _והשי, _jixp, lnød,
   {{0x20f0077e,0x7aed0d63,0x7e7700d8,0xd90f05bc}},	//   nđić_, lvat, _mixp, _حیا_,
   {{0x3ea90d64,0xfcaa07a6,0x61f805aa,0x3e640212}},	//   _ovat_, קיפּ, _anvl, möte_,
   {{0x7aed0d65,0x661201f9,0x00000000,0x00000000}},	//   nvat, ükkö, --, --,
   {{0xbebb023b,0xf0a90d66,0x7aed0d67,0x6d450d68}},	//   tzën, окол_, ivat, _oxha,
   {{0x7aed08a9,0x6d45023e,0xa3c80789,0xa06a0d69}},	//   hvat, _nxha, _लॉक_, жана_,
   {{0x7aed00cc,0xead20649,0xe4d40018,0x00000000}},	//   kvat, fẹ́_, _ستمب, --,
   {{0x6d49020a,0x7aed09ac,0x6d450d6a,0x00000000}},	//   şeal, jvat, _axha, --,
   {{0x7a200018,0x59cf0be4,0x7aed0d6b,0x00000000}},	//   _köte, स्मर, dvat, --,
   {{0x442f008a,0x42520018,0x7bcd0d6c,0x7aed0d6d}},	//   _kmg_, _جنور, ffau, evat,
   {{0xc17200a1,0x7a200149,0x2019023b,0x442f0d6e}},	//   _בחו_, _möte, ërit_, _jmg_,
   {{0xfaa30d6f,0x442f0d70,0x2eff0364,0x6d450d71}},	// [780] като, _mmg_, äuft_, _exha,
   {{0xe9d70d72,0x601f023b,0x00000000,0x00000000}},	//   мку_, _vëme, --, --,
   {{0xb4ac009f,0xd7e6004d,0x6d4007e7,0x3dfb00ca}},	//   _कटे_, діло, ğmas, _וליד,
   {{0x9f400d73,0x6d4008bb,0xafdb09af,0x00000000}},	//   _unió_, şmas, rnøg, --,
   {{0xa3c800a5,0xc7a30a28,0xd6d00d74,0x7aed00ae}},	//   _लॉग_, тичк, اقت_, cvat,
   {{0x7a200212,0x3eaf02b6,0x6b960429,0xe8df0023}},	//   _böte, _ægte_, lbyg, _luộc_,
   {{0x68e302b6,0xf8d20d75,0xa5c4007f,0x00000000}},	//   ændt, _सहिय, _राठौ, --,
   {{0x6b9600d6,0xd4670284,0x00000000,0x00000000}},	//   nbyg, мије_, --, --,
   {{0x42740d76,0x00000000,0x00000000,0x00000000}},	//   нгис, --, --, --,
   {{0x61e80abd,0xf8d20d77,0xdb1500fd,0x00000000}},	//   uddl, _सहाय, ébéc, --,
   {{0xd130054f,0x7a200222,0x7aed084f,0xe8df0019}},	//   امج_, _göte, zvat, _buộc_,
   {{0xe8df0028,0x7aed025b,0x442f0036,0x4de7074c}},	//   _cuộc_, yvat, _gmg_, _छोड़े_,
   {{0xd6d900a5,0x6b960d78,0x2ef200f0,0x00000000}},	//   _były_, dbyg, _cryf_, --,
   {{0xead20d79,0x7aed0565,0x2ef20313,0x6ab60313}},	//   rẹ́_, vvat, _dryf_, dryf,
   {{0x1bd5013d,0x645c01d3,0xfe2400c2,0x00000000}},	//   новя, _īrij, тьян, --,
   {{0x5fc602d5,0x91ca0d7a,0x6b960a1f,0xec68036c}},	//   _वायल, त्रै, gbyg, друк_,
   {{0x2ef20d7b,0x20190d7c,0xafdb0c89,0x7e7702a1}},	// [790] _gryf_, ūris_, rnød, _tixp,
   {{0x6d450d7d,0xe9d30037,0x69ca0d7e,0x9e670d7f}},	//   _txha, ضغط_, स्ली, _تابن,
   {{0x7aed0d80,0x5884055b,0x5c750d81,0x47c70033}},	//   svat, выча, _плот, _রোগী,
   {{0x20190d82,0x39580ac9,0x00000000,0x00000000}},	//   nksi_, _dyrs_, --, --,
   {{0x201900c2,0x59c70c8c,0x97350d83,0x00000000}},	//   iksi_, _लापर, رکرا, --,
   {{0x68e3052f,0x644200c2,0x2ba70096,0xafdb0120}},	//   ænds, _ajoi, गणका, rløy,
   {{0xafdb0120,0x00000000,0x00000000,0x00000000}},	//   sløy, --, --, --,
   {{0xe73900f0,0x1309004d,0x58d4021a,0xafdb00f3}},	//   _ddŵr_, зний_, _шост, pløy,
   {{0x7c3a0396,0x9f9d0088,0xf6b50018,0x95cb0d84}},	//   étri, væði_, _سماج, _мужа_,
   {{0x20190084,0x56940d85,0x41050d86,0x7a200364}},	//   eksi_, _рафт, езов, _töte,
   {{0x6e3504a3,0x442f0d87,0x69c2007f,0xf8df00b7}},	//   dizb, _tmg_, _लासी, नबिय,
   {{0xcdc90054,0x80a000a5,0x59cf0d88,0x3cf900c3}},	//   _לך_, _खबरे, स्तर, _उपजे_,
   {{0xef170d89,0x9f9d0088,0x6e3503ab,0x00000000}},	//   емя_, ræði_, fizb, --,
   {{0xfce60848,0x645b0d8a,0xc692006e,0x201900c2}},	//   ного, llui, ראם_, aksi_,
   {{0x443f0d8b,0xa3cc0851,0x81c80081,0x6b960727}},	//   onu_, श्व_, _লোক_, tbyg,
   {{0x443f0d8c,0x645b0d8d,0x0eaa00ae,0xfbdf084e}},	//   nnu_, nlui, _екий_, _skêr_,
   {{0x34dc039d,0x6b960d8e,0x7ae90146,0x443f0d8f}},	// [7a0] _मन्द, rbyg, _šetr, inu_,
   {{0x6b960d90,0x8e9700ca,0x443f0d91,0x6d40013c}},	//   sbyg, _רדיו_, hnu_, şmaq,
   {{0x2d980d92,0xf1c20d93,0x69c801e8,0x6b9604c8}},	//   mbre_, _शासन, _ödem, pbyg,
   {{0x443f0d94,0x7afb09ac,0xcfb20033,0x41cf00a4}},	//   jnu_, _šute, ট্রন, त्तस,
   {{0x443f0d95,0xc8790367,0x68e30537,0x2caa00b3}},	//   dnu_, _diş_, ændr, lsbd_,
   {{0x443f0d96,0xa3c802d5,0x45d40d97,0x9f4000b3}},	//   enu_, _लॉज_, токс, _maià_,
   {{0x443f0d98,0x5fc6009d,0x69de0239,0x1dd20bf5}},	//   fnu_, _वाढल, mepe, द्यत,
   {{0x66e60d99,0x6b7b00c1,0x25fe009d,0x645b0d9a}},	//   _поба, ּרינ, लाही_, glui,
   {{0xe7d503a3,0x3edf0294,0xf7430d9b,0x00000000}},	//   lığı, _kwụọ_, _бето, --,
   {{0x443f0d9c,0x9fd00081,0x69de0d9d,0xe8df020b}},	//   anu_, িযোগ, nepe, _nuớc_,
   {{0x7c240d9e,0x443f0d94,0x3a3700ca,0x610a00a7}},	//   khir, bnu_, תרים_, cəll,
   {{0x645b0d9f,0x69de0da0,0x351b00a1,0x2d98037a}},	//   clui, hepe, _מובנ, ebre_,
   {{0x69de0da1,0x20190da2,0x6e35042c,0x442400b3}},	//   kepe, rksi_, tizb, mhm_,
   {{0xa3cc0336,0x93250103,0x3edf0134,0x63a20d6e}},	//   श्र_, _جرمن, _nwụọ_, _heon,
   {{0x63a20da3,0x69de0da4,0x62820113,0xc0e30da5}},	//   _keon, depe, _huoo, _бојк,
   {{0xe7d50702,0x7c240da6,0x63a20da7,0x61ea0da8}},	//   dığı, ghir, _jeon, _hafl,
   {{0xf1a40da9,0x63a20167,0x61ea0ce1,0x610a00a7}},	// [7b0] _खजान, _meon, _kafl, zəll,
   {{0x63a20daa,0x443f0dab,0x69de0dac,0x7c240239}},	//   _leon, znu_, gepe, ahir,
   {{0x443f0dad,0x7c240dae,0x47bc0033,0xdb1601f9}},	//   ynu_, bhir, োজনী, rgyá,
   {{0x7c240daf,0x61ea0db0,0x610a00a7,0xf77301c3}},	//   chir, _lafl, vəll, هاش_,
   {{0x443f02e6,0x44240080,0x69de0db1,0x66e50db2}},	//   vnu_, dhm_, bepe, тола,
   {{0x27e900e9,0xe6180120,0x69de0db3,0x7bdf0db4}},	//   žan_, нді_, cepe, lequ,
   {{0x443f0106,0x645b0db5,0x6e200052,0x3eb9042c}},	//   tnu_, tlui, ëmbi, hrst_,
   {{0x7bdf016d,0x00000000,0x00000000,0x00000000}},	//   nequ, --, --, --,
   {{0x63a20db6,0x645b0db7,0x045600e3,0x1db10bb5}},	//   _deon, rlui, خلية_, _जयंत,
   {{0x443f08a9,0x645b0db8,0xd24e00ab,0x7bdf0db9}},	//   snu_, slui, يني_, hequ,
   {{0x25fe0dba,0x61ea00f0,0x645b0dbb,0x3eb90dbc}},	//   लारी_, _dafl, plui, erst_,
   {{0x69de0dbd,0x7a2002c3,0x6d5a09a1,0x00000000}},	//   zepe, _möta, ütam, --,
   {{0x69c70292,0x69de0dbe,0xdb060094,0x69c200b6}},	//   _ocje, yepe, _odká, _लाली,
   {{0xdd92003f,0x61ea0dbf,0x69de01ff,0x00000000}},	//   شور_, _gafl, xepe, --,
   {{0xed57064f,0xada30dc0,0x7c240dc1,0x63a20dc2}},	//   вор_, расл, thir, _yeon,
   {{0x1c430dc3,0x60d60796,0x63a20042,0x8c43001f}},	//   ансм, _יוצא_, _xeon, аесе,
   {{0xeab10068,0x7c2403a8,0xc1e50dc4,0x32cb0120}},	// [7c0] یعے_, rhir, _कसाब_, nøy_,
   {{0x7c240dc5,0xceb9000d,0x68f5025b,0x61ea008a}},	//   shir, áře_, _brzd, _xafl,
   {{0x291c0c01,0x69de0dc6,0x7bdf0dc7,0x00000000}},	//   áva_, repe, bequ, --,
   {{0x7bc600e7,0x7ae600f9,0xe73a0204,0x3ea002f1}},	//   _ucku, _tskt, мее_, _kwit_,
   {{0x63a200e7,0x627200a5,0xa6fa00e3,0x69de0dc8}},	//   _reon, _głow, بعاء_, pepe,
   {{0xaa460dc9,0x4a750084,0x63a20dca,0x7ae40384}},	//   _регл, _быст, _seon, mwit,
   {{0x63a20dcb,0x98a30dcc,0x7a200212,0x7ae40313}},	//   _peon, _висе, _göta, lwit,
   {{0x61ea02ad,0x7bc40dcd,0xa78500e3,0xaca40134}},	//   _safl, ngiu, _مشكو, _nhọt,
   {{0x7c23002d,0x59cf000c,0x7ae402a1,0xa6ca0dce}},	//   _înre, स्वर, nwit, _زوال_,
   {{0xaca40134,0x610a0092,0x05c90034,0x7aeb02b6}},	//   _ahọt, səlm, _रायब, ægti,
   {{0x859b028c,0x9f4e025b,0x3ea00dcf,0x85060dd0}},	//   _חשבו, čným_, _awit_, _جوان,
   {{0xc9530054,0xaca40129,0x7ae40dd1,0xe7b400aa}},	//   ימת_, _chọt, kwit, ुलिप,
   {{0xd5c9007a,0x05c90bd9,0x61ea0dd2,0x81d40161}},	//   _रामज, _रामब, _tafl, _болх,
   {{0x6e940084,0x7bc400bc,0x00000000,0x00000000}},	//   риру, egiu, --, --,
   {{0x62720067,0x7bdf0dd3,0x1dd205a5,0xc27b0341}},	//   _słow, tequ, द्धत, _קרוי,
   {{0xd10f0336,0x7bc4013d,0xaca40129,0xa17700ca}},	//   ाहरण_, ggiu, _ghọt, _בעוד_,
   {{0xdb1d05aa,0x41cf0213,0x94bf0285,0x7a2002c3}},	// [7d0] _absò, त्वस, _एम्आ, _söta,
   {{0xf7f400bf,0x200b042d,0x2ee90dd4,0x4d99004d}},	//   یسند, ljci_, _isaf_, _якою_,
   {{0x2d810dd5,0xac190566,0x3ea0022b,0x6d410dd6}},	//   _ighe_, _зону_, _zwit_, úlad,
   {{0x787a030b,0x7ae40dd7,0xc8640dd8,0x3ea00154}},	//   _důvo, bwit, атчи, _ywit_,
   {{0xdb0d00bc,0x601f0216,0x00000000,0x00000000}},	//   ngaü, _lëmo, --, --,
   {{0x69c70dd9,0x6b8d0dda,0x26360034,0x6aad0ddb}},	//   _ucje, lcag, słon_, msaf,
   {{0x6aad0ddc,0x00000000,0x00000000,0x00000000}},	//   lsaf, --, --, --,
   {{0x2fc9023e,0x69c50ddd,0x32cb00d6,0xd4660dde}},	//   _ncag_, lghe, tøy_, лище_,
   {{0x2bd50ddf,0x2d810134,0x69ca07ad,0x27ff0139}},	//   ड्या, _oghe_, स्की, _inun_,
   {{0x2d810028,0x27ed0de0,0x32cb004d,0x95d8007b}},	//   _nghe_, _haen_, røy_, _идут_,
   {{0xe4cb0de1,0x69c50091,0x1acf0081,0x2ee90de2}},	//   _زبان_, ighe, রিয়া, _asaf_,
   {{0x27ed0de3,0xf3f00037,0x24850036,0x76430167}},	//   _jaen_, _وأن_, _iulm_, lnny,
   {{0x25a50de4,0x27ed0de5,0x63a90de6,0xdcee0491}},	//   _kell_, _maen_, maen, vabı,
   {{0x27ed0de7,0x63a90de8,0x3d28001c,0x6aad0de9}},	//   _laen_, laen, نتزی_, dsaf,
   {{0x27ff0dea,0x03e600c7,0xdcee07aa,0x2ee90134}},	//   _onun_, কারী_, tabı, _esaf_,
   {{0x6b8d063d,0x61e10deb,0x63a90dec,0xf1cf0ded}},	//   gcag, lell, naen, त्रन,
   {{0xab660dee,0x7643005c,0x6aad0def,0x3ea003a9}},	// [7e0] увал, knny, gsaf, _uwit_,
   {{0x25a50465,0xdcee07aa,0x787a030b,0x7ae40df0}},	//   _nell_, sabı, _půvo, rwit,
   {{0x7ae40df1,0x61e1008f,0x610a0092,0x20120044}},	//   swit, iell, vəlk, _koyi_,
   {{0x61e10df2,0x6b8d0df3,0x27ed0df4,0x63a90df5}},	//   hell, ccag, _caen_, jaen,
   {{0x61e10df6,0x7e7e0df7,0x63a90df8,0x25a500d7}},	//   kell, _kipp, daen, _bell_,
   {{0x7e7e03e5,0x61e10df9,0x25a50dfa,0x645902a4}},	//   _jipp, jell, _cell_, _akwi,
   {{0x61e10dfb,0x25a50dfc,0x83fd0018,0x63a900b3}},	//   dell, _dell_, klőd, faen,
   {{0x764306ee,0x6d5e0dfd,0x44220018,0x3a3a0dfe}},	//   anny, _mypa, ók_, lipp_,
   {{0x61e10dff,0x57460d86,0x610a0092,0xe3af0e00}},	//   fell, _снаб, məli, سري_,
   {{0x61e10e01,0x64590e02,0xf1c6030b,0x200000d3}},	//   gell, _ekwi, _část_, _anii_,
   {{0x63a90bb6,0x20120b58,0x2bd50285,0xca570142}},	//   baen, _boyi_, ड्डा, רייז_,
   {{0x0eeb0084,0x25a50e03,0x69c5044c,0x00000000}},	//   ньги_, _zell_, zghe, --,
   {{0xe2960396,0x69c502b6,0x6fc60714,0x6272007f}},	//   _среќ, yghe, _वारं, _błot,
   {{0x61e10e04,0x7e7e028d,0x25a500b3,0x60c10113}},	//   cell, _cipp, _xell_, bulm,
   {{0x23b800aa,0x224b0206,0x00000000,0x00000000}},	//   _इयाद, écke_, --, --,
   {{0x60df0068,0x20120d2a,0x2ee903e3,0x7c840e05}},	//   őzmé, _goyi_, _tsaf_, суре,
   {{0x5a350e06,0x765a0092,0x76430e07,0xc88000a7}},	// [7f0] анат, _okty, ynny, əşir_,
   {{0x27ed03be,0x321e00a5,0x6b8d0e08,0x6aad0e09}},	//   _saen_, nkty_, scag, rsaf,
   {{0xa3e50251,0x69c50e0a,0x6aad0e0b,0x99670d86}},	//   _फसल_, rghe, ssaf, утал,
   {{0x61e10e0c,0x765a0e0d,0x627200a5,0x67d50e0e}},	//   zell, _akty, _złot, роду,
   {{0x25a50e0f,0x60c10e10,0x76430167,0x24850052}},	//   _pell_, zulm, tnny, _sulm_,
   {{0xf7700e11,0x64590e12,0x61e109cd,0x7643005c}},	//   سان_, _skwi, xell, unny,
   {{0x61e10e13,0x25a50e14,0x63a90e15,0x76430167}},	//   vell, _vell_, taen, rnny,
   {{0x25a50054,0x61e10e16,0x76430167,0xb6c90103}},	//   _well_, well, snny, _لائے_,
   {{0x61e10e17,0xcb1200c1,0x25a500a1,0xd347001c}},	//   tell, ַלט_, _tell_, دیشه_,
   {{0x63a90479,0x60c10511,0x22150e18,0x7769039f}},	//   saen, tulm, рфир, _izex,
   {{0xc5fa00c1,0xb5fa00c1,0x63a90131,0x69ca0e19}},	//   _שפעט, _שלעכ, paen, स्टी,
   {{0x61e10e1a,0x43750e1b,0x60c108bb,0x64590193}},	//   sell, _култ, rulm, _ukwi,
   {{0x60c10e1c,0x7e7e0e1d,0x6d5e0e1e,0xe7d70e1f}},	//   sulm, _pipp, _sypa, ण्यप,
   {{0x51870e20,0x387f0808,0x6da30e21,0x60c10e22}},	//   _суда, _liur_, жира, pulm,
   {{0xed5a0e23,0xe816007d,0x6286025b,0xdca6036f}},	//   тов_, _थकला_, íkov, раби,
   {{0x1e860114,0x200007cc,0x6d5e0363,0x387f009c}},	//   _клим, _unii_, _vypa, _niur_,

   {{0x7e7e0e24,0x627200a5,0x6d5e00a5,0xb0690e25}},	// [800] _tipp, _głos, _wypa, _حصول_,
   {{0x6d4100e3,0x3c3f00c2,0x386d0167,0x3ead003d}},	//   úlac, tävä_, _aher_, ġett_,
   {{0x78a200e7,0x6e3c0e26,0x6fd30287,0x387f007f}},	//   ćovo, mirb, ध्वं, _biur_,
   {{0x386d025a,0xe8df00fe,0xd90d0e27,0x6fc60e28}},	//   _cher_, _cuốc_, ریق_, वलिं,
   {{0x66f40e29,0x386d0e2a,0x387f0e2b,0x7bd60022}},	//   сплу, _dher_, _diur_, mfyu,
   {{0x386d02e2,0xfaa300e5,0xdb060052,0xc8960e2c}},	//   _eher_, _фаро, _lekë, _врањ,
   {{0x29070212,0xd9430e2d,0x7589004d,0x00000000}},	//   änat_, _дери, усів_, --,
   {{0x6a6b0364,0x247e0174,0x68e2007f,0x986a00ae}},	//   rüfe, _ọmba_, łods, _рибб_,
   {{0xf5ea0476,0xdb0d003e,0x63bd0e2e,0x53340e2f}},	//   _имал_, ngað, ósna, септ,
   {{0x387f0634,0xe80400a4,0xd4d601b3,0x00000000}},	//   _ziur_, ळावा_, _відэ, --,
   {{0x6e3c0e30,0x7416001c,0x92d60033,0x60190138}},	//   dirb, _پوشا, াটে_, гоня_,
   {{0x76580e31,0x7d1c0e32,0x91fc00e8,0xdb060216}},	//   lovy, dyrs, flāc, _cekë,
   {{0x22940e33,0x44260e34,0x329400e3,0xd0420092}},	//   _التس, _ilo_, _التأ, ntlə,
   {{0x4426006c,0x7c260172,0x63560065,0x765800d4}},	//   _hlo_, _alkr, _e̟nì, novy,
   {{0x44260e35,0xda05000f,0x627200a5,0x2ba70a28}},	//   _klo_, रासत_, _włos, ијав,
   {{0xf21c0251,0x5bb80084,0x717b00a1,0xd04200a7}},	//   _पकड़_, ился_, _בנוס, ktlə,
   {{0xb06600aa,0x32d00023,0x44260239,0x3cfa00b3}},	// [810] svää, này_, _mlo_, _erpv_,
   {{0x44260e36,0xeb9f0537,0x7c260e37,0x00000000}},	//   _llo_, _snød_, _elkr, --,
   {{0xda780e38,0x4f5809b4,0x6f1d0154,0x44260e39}},	//   рят_, _مجید_, lysc, _olo_,
   {{0xe8df00ef,0xd12600fb,0x44260af0,0xa7750e3a}},	//   _quốc_, _ہم_, _nlo_, блеч,
   {{0x6eaa0cce,0x6f1d0e3b,0x610a013c,0x8b670568}},	//   जीपु, nysc, məlu, _خادم,
   {{0xe5a20e3c,0xcb120327,0x2d910e3d,0x00000000}},	//   пиши, _צלם_, ncze_, --,
   {{0x44260087,0x29070e3e,0xb4e10096,0x00000000}},	//   _blo_, ånad_, धबे_, --,
   {{0x43690e3f,0x44260e40,0xd5c902d5,0xd4e40120}},	//   лайн_, _clo_, _रावज, юючи,
   {{0x44260c56,0x00000000,0x00000000,0x00000000}},	//   _dlo_, --, --, --,
   {{0x44260e41,0xaac80285,0x786a00d4,0x00000000}},	//   _elo_, िंतक, mýva, --,
   {{0x44260e42,0x6d4003e0,0x1b1b0033,0x786a0e43}},	//   _flo_, şmaz, _নেমে_, lýva,
   {{0x44260e44,0xdee60e45,0x92d60033,0x6e3c042c}},	//   _glo_, боми, ায়ে_, wirb,
   {{0x28c902d5,0x2bcb0e46,0x00000000,0x00000000}},	//   ांडि, िलना, --, --,
   {{0xe29c00c1,0x7d1c0052,0x51950037,0x23740206}},	//   _ישׂר, tyrs, _الغذ, ňajú_,
   {{0x82340e47,0x1d1902ec,0x6fc10096,0x50db08c0}},	//   _برنا, ають_, _वाचू, _बहिष,
   {{0x61b7009d,0xc5f403e3,0x3b860e48,0x6f1d0e49}},	//   _आयुष, ɓɓu_, слаг, bysc,
   {{0xe9da0e4a,0xc05300a1,0x3b0702b3,0x6272007f}},	// [820] лка_, _מזה_, бето_, _kłop,
   {{0xdb0d01cd,0x7dea007b,0xf9c40d7f,0x00000000}},	//   rgað, _смог_, تحری, --,
   {{0xe8040096,0xd23a006e,0x76580e4b,0x00000000}},	//   ळाला_, נגעל, vovy, --,
   {{0xa96700e5,0xa2aa0e4c,0x00000000,0x00000000}},	//   щиха_, _फ़िल्, --, --,
   {{0x29070149,0x628f0e4d,0x442600c4,0x765800d4}},	//   änar_, ícol, _rlo_, tovy,
   {{0x44260e4e,0xd0420092,0xe4a60e4f,0x644b00b3}},	//   _slo_, rtlə, брио, _ajgi,
   {{0x26190e50,0xd0420092,0x6f1d0034,0xd497013f}},	//   _बकरी_, stlə, zysc, бры_,
   {{0x290500cb,0x786a0e51,0x941800c2,0x3c2700bc}},	//   _šlag_, býva, ржит_, _kõva_,
   {{0x59cf0e52,0x6a700212,0x69c80e53,0x7a2002c3}},	//   स्कर, räff, _ödes, _nötk,
   {{0x6d4003a3,0x20f700ae,0x09e60033,0x00000000}},	//   şmay, _băi_, নাকা, --,
   {{0x69dc0e54,0x44260106,0x69ce0154,0x20f7020a}},	//   _mbre, _tlo_, _mcbe, _căi_,
   {{0x44260e55,0x438600e3,0x2d9100a5,0x442000de}},	//   _ulo_, _الإق, wcze_, _ôi_,
   {{0x69dc0e56,0x00000000,0x00000000,0x00000000}},	//   _obre, --, --, --,
   {{0x44f800de,0x2d850120,0x25fe0285,0x13ad0033}},	//   _kĩ_, øle_, लाटी_, _গায়,
   {{0x786a035d,0x2d910034,0xb425007f,0xceb400a7}},	//   zýva, rcze_, łżeń, _evə_,
   {{0xa3cc0e57,0x44f80023,0x649502a1,0x00000000}},	//   श्च_, _mĩ_, _wġig, --,
   {{0x7b670e58,0x69dc0090,0x649502a1,0x00000000}},	// [830] стве, _bbre, _iġie, --,
   {{0x69dc009c,0x64950078,0x00000000,0x00000000}},	//   _cbre, _uġig, --, --,
   {{0xf96b00c6,0xdd920421,0x7c23020a,0xa3e800b7}},	//   урай_, _توپ_, _înro, मजा_,
   {{0x69dc0e59,0x7c670e5a,0x7aee00c2,0x7d1a0e5b}},	//   _ebre, _داخل, äntä, ätse,
   {{0x7c2d0e5c,0xdcf503e0,0x649500bd,0x00000000}},	//   mhar, mazı, _mġie, --,
   {{0x7c2d0e5d,0x69d80e5e,0x786a0146,0x7afd0450}},	//   lhar, न्दी, rýva, _irst,
   {{0x2409014d,0xafdb052f,0x25fe0e5f,0x27e60e60}},	//   инки_, rnøj, लाजी_, beon_,
   {{0x7c2d0e61,0x7afd0542,0x601f01e5,0x44f800de}},	//   nhar, _krst, _fëmi, _dĩ_,
   {{0xc7b90018,0x20f700ae,0x7afb04e9,0x20d1037a}},	//   _idő_, _săi_, _šutj, wái_,
   {{0xaca30e62,0x1ddb07d5,0xdcf50e63,0x82350e00}},	//   _atọg, म्मत, hazı, تربا,
   {{0x7c2d0e64,0x21690e65,0x7bcf0e66,0x629b007b}},	//   khar, рини_, _occu, spuo,
   {{0xe8e000fe,0x20d10e67,0x7afd0e68,0x00000000}},	//   _chộp_, rái_, _orst, --,
   {{0x7c2d0e69,0x442d006b,0x6d410e6a,0xc7d600ca}},	//   dhar, mhe_, úlan, חורי_,
   {{0x443f0e6b,0x442d0396,0x7bcf0e6c,0x628b0e6d}},	//   liu_, lhe_, _accu, _iugo,
   {{0x27e605dc,0x7afd0e6e,0x62830d16,0x64950090}},	//   yeon_, _arst, _iino, _fġie,
   {{0x443f0e6f,0x7c2d0e70,0x64490e71,0x442d0396}},	//   niu_, ghar, nnei, nhe_,
   {{0xda050e72,0x63ab0018,0x64490e73,0x6a700e74}},	// [840] रांत_, _megn, inei, häfe,
   {{0x63ab0e75,0x442d0e76,0x64490e77,0x628b01e2}},	//   _legn, hhe_, hnei, _mugo,
   {{0x7afd0e78,0x7c2d0e79,0x442d0e7a,0x443f013f}},	//   _erst, bhar, khe_, kiu_,
   {{0x62830e7b,0x7c2d0e7c,0x62990034,0x645b00fd}},	//   _lino, char, _otwo, joui,
   {{0x442d0e7d,0x443f0e7e,0x44f80028,0x27e60e7f}},	//   dhe_, diu_, _sĩ_, reon_,
   {{0x8c1f00c7,0x7c24007a,0x27e60e80,0xdb040072}},	//   নোদন_, lkir, seon_, caiá,
   {{0x7a2001bf,0x291c00aa,0x443f0e81,0x628b01d3}},	//   _nöti, ävad_, fiu_, _augo,
   {{0x442d0e82,0x443f0e83,0x62830084,0x628b0e84}},	//   ghe_, giu_, _aino, _bugo,
   {{0x63ab0e85,0x628b00c4,0x63b9030a,0x6495009e}},	//   _degn, _cugo, _ddwn, _rġie,
   {{0x38660e86,0x628b02e6,0x63b703e3,0x64490e87}},	//   llor_, _dugo, _ɗanɗ, anei,
   {{0xf9930054,0x443f0e88,0x69fb00f5,0x7c240a15}},	//   ורת_, biu_, בליק, kkir,
   {{0x443f0e89,0x63ab0e8a,0xe3b2010d,0x64490e8b}},	//   ciu_, _gegn, _آرا_, cnei,
   {{0xe1ef0e8c,0xc7b30054,0x386600d3,0x62830e8d}},	//   رسی_, ובר_, ilor_, _fino,
   {{0x7c2d0e8e,0x62830e8f,0x64400e90,0x7c240e91}},	//   whar, _gino, limi, ekir,
   {{0x7c2d0e92,0x61e80bc6,0x7c24009e,0xfe6e015a}},	//   thar, medl, fkir, دگي_,
   {{0x62830e93,0x60c80270,0x38660e94,0x69d80d7e}},	//   _zino, mudm, jlor_, न्सी,
   {{0x7c2d0e95,0xdceb03a3,0x8d870e96,0x628b0072}},	// [850] rhar, ınız, _мунд, _xugo,
   {{0x7c2d0e97,0x61e802ad,0x64400e98,0x443f0e99}},	//   shar, nedl, himi, ziu_,
   {{0x64400e9a,0x7c2d0e9b,0xf8b10260,0xa5c40034}},	//   kimi, phar, عکس_, _राजौ,
   {{0xdce50028,0x443f0e9c,0x64400e9d,0x7afd0e9e}},	//   _nghĩ, xiu_, jimi, _trst,
   {{0x63ab0e9f,0x66050ea0,0x443f0ea1,0xe8e000de}},	//   _regn, зпла, viu_, _khớp_,
   {{0x63ab0465,0x628b0ea2,0x61e80ea3,0x7aed0ea4}},	//   _segn, _rugo, jedl, mwat,
   {{0x442d0ea5,0x443f0ea6,0x64400ea7,0x628b0ea8}},	//   the_, tiu_, fimi, _sugo,
   {{0x64400ea9,0x3f890eaa,0x7bcd0eab,0x628b0eac}},	//   gimi, _ngau_, ngau, _pugo,
   {{0x443f0ead,0x63ab0102,0x62830eae,0x442d0eaf}},	//   riu_, _vegn, _pino, rhe_,
   {{0x442d0eb0,0x443f0eb1,0x7c240eb2,0x63ab0eb3}},	//   she_, siu_, zkir, _wegn,
   {{0x442d0eb4,0x63ab0eb5,0x64400eb6,0x443f0eb7}},	//   phe_, _tegn, bimi, piu_,
   {{0x64400eb8,0x7aed0a15,0xe8df06c0,0x628b0eb9}},	//   cimi, kwat, _ahịa_, _tugo,
   {{0x62830eba,0x62990034,0xd5d200b7,0x78a2007e}},	//   _tino, _utwo, _सामज, ćovi,
   {{0x7aed0ebb,0xe8df0134,0x3ea906a3,0xe802009f}},	//   dwat, _chịa_, _dwat_, _रोना_,
   {{0x32070034,0x7c240ebc,0x00000000,0x00000000}},	//   _inny_, tkir, --, --,
   {{0x5fc602e8,0x7bcd0044,0xdddc0146,0x3ebf0ebd}},	//   _वाटल, ggau, zorň, šuta_,
   {{0x7c240ebe,0x6e460ebf,0x6fa2055e,0x7aed0ec0}},	// [860] rkir, _неиз, _क्यू, gwat,
   {{0x7c240903,0x64400ec1,0x4efb006e,0x1efb006e}},	//   skir, zimi, _פליג, _פליע,
   {{0x64400ec2,0xae1b00c1,0x7aed0167,0xa3ae0ec3}},	//   yimi, _הויכ, awat, करम_,
   {{0x7aed083e,0x61e80ec4,0x00000000,0x00000000}},	//   bwat, zedl, --, --,
   {{0x64400ec5,0xa2bd034d,0x38660ec6,0x9f520065}},	//   vimi, _शिष्, rlor_, _bayé_,
   {{0x1603009f,0x442400dc,0x64400027,0x00000000}},	//   लागर_, wkm_, wimi, --,
   {{0xf8e0007d,0x443d0ec7,0x61e80ec8,0x64400bb0}},	//   _नहिय, _bmw_, vedl, timi,
   {{0x7afb01ac,0x60c80ec9,0x61e80eca,0x3298001f}},	//   _šuti, vudm, wedl, овиќ_,
   {{0x6ab60ecb,0x5fc60096,0x61e80158,0x00000000}},	//   nsyf, _वाजल, tedl, --,
   {{0x80c00abe,0xa2bd0d88,0x248c00dc,0xf8e00336}},	//   _विदे, _शिर्, _tudm_, _नहाय,
   {{0x660801c5,0x64a30ecc,0x859b00a1,0xb38600ae}},	//   _indk, _заха, _השבו, _елел,
   {{0x7aed0067,0x35d20251,0x61e80ecd,0x32070ece}},	//   ywat, _साड़, sedl, _enny_,
   {{0x82fa010d,0x661a0ecf,0xd5b1020b,0x00000000}},	//   _دراز_, _kotk, _món_, --,
   {{0x661a02fd,0xe3b00470,0xf2c501ce,0x00000000}},	//   _jotk, _سرچ_, _ісін, --,
   {{0x601f00dd,0x61db028c,0x5fc6009d,0x7aed030a}},	//   _sëmu, _הקוד, _वाचल, wwat,
   {{0x7aed0ed0,0x7bcd00c6,0x00000000,0x00000000}},	//   twat, ugau, --, --,
   {{0x3b540ed1,0xa3de022d,0x7bcd0ed2,0x35d20ed3}},	// [870] ектр, द्य_, rgau, _साढ़,
   {{0x24860080,0x91fc0029,0x661a0088,0x7c870012}},	//   _liom_, klām, _notk, _нуме,
   {{0xf9880037,0x3e64003e,0x9f52014b,0xac190ed4}},	//   أنمي_, götu_, _rayé_, _дону_,
   {{0xa2bd0ed5,0x3e830139,0x660800bc,0x6fad02d5}},	//   _शिल्, _fétì_, _andk, चरिं,
   {{0xd6db0ed6,0x2366023e,0x9f5200fd,0xfc3f0065}},	//   сте_, _nyoj_, _payé_, _imí_,
   {{0x443d0167,0x992b0ed7,0x59c700c3,0x95cb0ed8}},	//   _smw_, _люба_, _लाटर, суда_,
   {{0x661a0ed9,0xf8ae00d1,0x80db00a3,0xcd980eda}},	//   _dotk, _نکن_, _बहें, הדות_,
   {{0x3e6401f9,0x00000000,0x00000000,0x00000000}},	//   lött_, --, --, --,
   {{0x661a0edb,0xe1f20103,0x00000000,0x00000000}},	//   _fotk, چسپ_, --, --,
   {{0x20090edc,0x80d9004d,0x7a2001cd,0x00000000}},	//   _anai_, оєму_, _fötu, --,
   {{0x76430edd,0x2486028d,0xb7bd00ae,0x7a20003e}},	//   miny, _fiom_, _alţi, _götu,
   {{0xa3ae0861,0x76430ede,0x59dd0edf,0xeb0d0ee0}},	//   करण_, liny, न्तर, _सपूत_,
   {{0xd09201d4,0x7a200ee1,0xdb060328,0x3e640ee2}},	//   _müəy, _kött, _pekí, kött_,
   {{0xfce600d6,0x3e640103,0x7a2001f9,0x00000000}},	//   мого, jött_, _jött, --,
   {{0x91fc00d9,0x7a200ee3,0x3e640103,0x00000000}},	//   klāj, _mött, dött_, --,
   {{0x601f023b,0x00000000,0x00000000,0x00000000}},	//   _dëms, --, --, --,
   {{0x76430ee4,0xcb670ee5,0xdd8f0068,0xbb430ee6}},	// [880] kiny, дате_, اوہ_, ветк,
   {{0x76430ee7,0x67220239,0x3e640103,0x6ab60ee8}},	//   jiny, vyoj, gött_, rsyf,
   {{0x76430ee9,0x6ab60324,0x00000000,0x00000000}},	//   diny, ssyf, --, --,
   {{0x3209006d,0x3b0a0eea,0x27e001ab,0x50c50eeb}},	//   _ɗaya_, _демо_, ýin_, _विनष,
   {{0x76430201,0x248606ad,0x00000000,0x00000000}},	//   finy, _riom_, --, --,
   {{0xd49a0eec,0x59dd09dd,0x9d450018,0xceb902c6}},	//   ори_, न्दर, _آئین, áři_,
   {{0xf9830eed,0xa96700c2,0x7a2002c3,0x00000000}},	//   _агро, _жира_, _dött, --,
   {{0xa803013d,0xb7fb030b,0x00000000,0x00000000}},	//   _изсл, _एफएम_, --, --,
   {{0x76430eee,0x7a200149,0x02a300ae,0x00000000}},	//   biny, _fött, крэм, --,
   {{0x7a200eef,0x764304ff,0x20090ef0,0x00000000}},	//   _gött, ciny, _snai_, --,
   {{0x248601b9,0x00000000,0x00000000,0x00000000}},	//   _tiom_, --, --, --,
   {{0x3e640068,0x534608d8,0xdb0f0231,0x03260ef1}},	//   zött_, _охла, _decê, _оден,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xdb04014b,0x00000000,0x00000000,0x00000000}},	//   mbiè, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x76430ef2,0x61f80ef3,0x20090ef4,0x2d9800b3}},	//   ziny, _havl, _unai_, acre_,
   {{0x76430ef5,0x61f80ef6,0x3a750ef7,0x0c84004b}},	// [890] yiny, _kavl, елар, тырм,
   {{0x61f803ce,0x61fa00f2,0x998700d2,0x4a540e4f}},	//   _javl, ndtl, ónů_, вкус,
   {{0xa3ae0006,0x64dd0ef8,0x76430201,0x7a20071b}},	//   करा_, _महेश, viny, _rött,
   {{0x2c2702ec,0xfc3f00b6,0x6d5702a1,0x76430ef9}},	//   _цьог, _umí_, _ixxa, winy,
   {{0x76430efa,0x6b9a00ca,0x787102c3,0x6568041c}},	//   tiny, _משרד, gåva, _aydh,
   {{0xf770037f,0x321c0146,0x60da010a,0x00000000}},	//   جام_, _novy_, kttm, --,
   {{0x76430808,0x80c00efb,0x9f4e02c6,0x69d5039f}},	//   riny, _विषे, čném_, _icze,
   {{0x76430efc,0xc7c400ae,0x9f4b0231,0x00000000}},	//   siny, _асфи, recê_, --,
   {{0xa3de0efd,0x76430efe,0x61f80eff,0xe8df00de}},	//   द्ध_, piny, _bavl, _khỏa_,
   {{0x80c00961,0x3eb9004d,0xf52700ae,0x00000000}},	//   _विशे, dsst_, _офен, --,
   {{0x61f8062d,0xe0460f00,0x9046001c,0x64450f01}},	//   _davl, енни, فنده, éhis,
   {{0x44f108a1,0xdb060181,0xb4fa00ca,0xa3de0f02}},	//   _iš_, _leká, _מפעי, द्द_,
   {{0xc2c80241,0x9327046b,0x442f0042,0xd12e0f03}},	//   _قبول_, _تران, _ilg_, لمی_,
   {{0x2d8c0f04,0x61f80f05,0x29030f06,0x00000000}},	//   øde_, _gavl, _orja_, --,
   {{0xdb040f07,0x1d070f08,0xb4ad0006,0x32d906a3}},	//   mbié, нери_, _कबो_, lèy_,
   {{0x44f10146,0x3c2e0031,0xdb0f0113,0x59dd00a8}},	//   _mš_, _býva_, _kecè, न्सर,
   {{0x2903003d,0x442f0f09,0x44f10d62,0x6d5702ac}},	// [8a0] _arja_, _mlg_, _lš_, _exxa,
   {{0x4a430f0a,0xdb0f0113,0x6f040f0b,0x2d9a0231}},	//   гнув, _mecè, _iric, _ufpe_,
   {{0x4c860f0c,0xd8260f0d,0x7769063d,0xdb060437}},	//   _плов, нджи, _ayex, _deká,
   {{0x6f040f0e,0xa01b0f0f,0x69d50f10,0xdc9b006e}},	//   _kric, rmög, _ecze, _מיטל,
   {{0xdcfc01d4,0x44f101b3,0x45d40f11,0xa01b0364}},	//   marı, _aš_, волс, smög,
   {{0xdcfc08fd,0xceb30341,0x6f0401dc,0x26c601ee}},	//   ları, ריג_, _mric, rroo_,
   {{0x442f0f12,0xdb1d0154,0x6e200052,0x00000000}},	//   _blg_, _adsè, ëmby, --,
   {{0x6f040012,0x61f80f13,0xdcfc071d,0x442f0076}},	//   _oric, _savl, narı, _clg_,
   {{0x44f102ef,0x533400d3,0x996100e8,0xe7370c58}},	//   _eš_, тепт, _cīņa_, _зет_,
   {{0x2d8c035d,0xdb0f00b3,0x442f0f14,0x44f105db}},	//   ždej_, _decè, _elg_, _fš_,
   {{0xdcfc01e8,0x6f040f15,0x40350f16,0x3a3700a1}},	//   karı, _aric, венс, גרים_,
   {{0x6f040b87,0x32d9022b,0x00000000,0x00000000}},	//   _bric, bèy_, --, --,
   {{0x44f10146,0x61f80f17,0x6d480610,0xdcfc008b}},	//   _zš_, _tavl, údan, darı,
   {{0x6f040149,0xbe8800c2,0x00000000,0x00000000}},	//   _dric, ессе_, --, --,
   {{0xf1b30054,0xcfb00033,0x2d850f18,0xd12f004d}},	//   _עסק_, _কারন, äle_, _сх_,
   {{0x6f040f19,0x3ea003e5,0xbbcb030b,0xac180284}},	//   _fric, _ftit_, िलेक, носу_,
   {{0x06e80081,0xf9c70f1a,0xdb060146,0x649502a1}},	// [8b0] পিডি, ещен, _peká, _aġil,
   {{0xddde007e,0x8b0800d2,0x00000000,0x00000000}},	//   _tipš, _spřá, --, --,
   {{0xe802007d,0x628a0f1b,0xdcfc03e0,0x23c70139}},	//   _रोहा_, _mifo, barı, _jìjà_,
   {{0x69d500a5,0x996400d3,0xdcfc00a7,0x628a0178}},	//   _wcze, утул, carı, _lifo,
   {{0xe8df0019,0x799c0150,0x44f10f1c,0x8038006e}},	//   _thỏa_, _ffrw, _sš_, ענדע_,
   {{0x628a0f1d,0x69d500a5,0xb5c20f1e,0x442f002b}},	//   _nifo, _ucze, айшл, _slg_,
   {{0x442f0f1f,0x2245033b,0xaa540b36,0x00000000}},	//   _plg_, vilk_, _сврш, --,
   {{0x130908d1,0xd13800a5,0x628a0f20,0x44f10094}},	//   дний_, dzą_, _aifo, _vš_,
   {{0x628a0149,0x5695008f,0x95d9001f,0x35f50f21}},	//   _bifo, _разт, _одат_, _ипар,
   {{0xdcfc008e,0x32d906a3,0x644201e9,0x27ef01c2}},	//   zarı, rèy_, _emoi, legn_,
   {{0xa2bd06e4,0x442f0f22,0xf99200a1,0x26cf0f23}},	//   _शिक्, _tlg_, ירי_, lugo_,
   {{0x6f040f24,0xdcfc0092,0x23c70139,0x3ea00f25}},	//   _pric, xarı, _dìjà_, _ptit_,
   {{0xe1ee0870,0x539a028c,0x628a0065,0xdcfc008b}},	//   _кг_, _חינו, _fifo, varı,
   {{0x63a90f26,0x6fa209c4,0x23c70139,0x628a0f27}},	//   lben, _क्रू, _fìjà_, _gifo,
   {{0xdcfc0f28,0xd1380034,0x2ee900b3,0xd7b30e5f}},	//   tarı, czą_, _epaf_, ुणाच,
   {{0x5184013a,0x21880130,0x63a90f29,0x26cf0f2a}},	//   _суча, _אָפּ, nben, kugo_,
   {{0x787800c9,0x27fd02ad,0x3b86004b,0xa3c4009f}},	// [8c0] níve, ddwn_, тлаг, ौलत_,
   {{0xdcfc01e8,0x00000000,0x00000000,0x00000000}},	//   sarı, --, --, --,
   {{0x63a90f2b,0xd7fa0f2c,0x28c90b94,0xdcfc071d}},	//   kben, дул_, ांगि, parı,
   {{0x26cf0051,0x63a90dd9,0x3ead020a,0xb6a6016d}},	//   fugo_, jben, ţete_, видл,
   {{0x63a9011d,0xfaa600f6,0x00000000,0x00000000}},	//   dben, _јаго, --, --,
   {{0x63a90f2d,0x787800b6,0xaca40129,0xa4d80f2e}},	//   eben, díve, _nkịt, едку_,
   {{0x628a0f2f,0xd9460f30,0xdb0f0f31,0x49910103}},	//   _rifo, _реви, _recé, _ایمر,
   {{0xd7060f32,0xaca40174,0x7c3602ad,0x63a90f33}},	//   _изби, _akịt, nhyr, gben,
   {{0x26dd00a5,0x97ea0092,0xa6860f34,0x9f4b0487}},	//   ctwo_, ışdı, _алад, pecé_,
   {{0x6206004d,0x00000000,0x00000000,0x00000000}},	//   тчиз, --, --, --,
   {{0xc4c50adb,0x1be20f35,0x64570143,0x00000000}},	//   _متنو, खभाल_, éxic, --,
   {{0x23ba0f36,0x9f520139,0x14d70327,0x7878016d}},	//   _آداب_, _bayà_, _יובל_, bíve,
   {{0xd13800a5,0x628a0f37,0x78780131,0x00000000}},	//   szą_, _tifo, cíve, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x69c80233,0x00000000,0x00000000,0x00000000}},	//   _ödey, --, --, --,
   {{0xc61f0f38,0xdb0f020a,0x00000000,0x00000000}},	//   _भव्य_, _decî, --, --,
   {{0x06d70033,0xeb0d00b6,0x26cf0956,0x00000000}},	// [8d0] _দৈনি, समेत_, xugo_, --,
   {{0x63a90f39,0x394b00cd,0x26cf0193,0x6abd0120}},	//   zben, وشاپ_, vugo_, _vvsf,
   {{0x27ef01df,0x656d03e3,0x98480847,0x00000000}},	//   tegn_, ƙahi, _ağı_, --,
   {{0xdb060f3a,0xdcb1020b,0x26cf0027,0x00000000}},	//   _bekä, ẩu_, tugo_, --,
   {{0x7c2d0f3b,0x78780161,0x27ef0f3c,0x63a907ee}},	//   mkar, xíve, regn_, vben,
   {{0xd77400e3,0x26cf0f3d,0x78780161,0xbb3a006e}},	//   جامع, rugo_, víve, _טערי,
   {{0xd4690f3e,0x26dd0034,0x5edf0033,0x245a01d3}},	//   нике_, stwo_, মিটে, zīme_,
   {{0x78780f3f,0x63a90f40,0xa3e302d5,0xc6a700d3}},	//   tíve, uben, _पॉश_, _аржи,
   {{0xc7b200a1,0x7c2d0f41,0x069b0470,0x1dd30f42}},	//   _לבן_, ikar, _آخرت_, _तांत,
   {{0x96f80f43,0x63a90f44,0x7c2d0f45,0x78780db4}},	//   _جعفر_, sben, hkar, ríve,
   {{0x7c2d0f46,0x78780161,0x9f4e030b,0x9f5b0052}},	//   kkar, síve, čním_, _faqë_,
   {{0xddd5030b,0xdb0a0146,0x7c2d0f47,0x2ba5088d}},	//   mozř, šnéh, jkar, गुमा,
   {{0x91e50f48,0x442d0f49,0x7c2d0f4a,0x9f520065}},	//   _боле, mke_, dkar, _bayá_,
   {{0x442d0f4b,0xdd920cd2,0xf776006e,0x7c2d0dd8}},	//   lke_, صور_, טערי_, ekar,
   {{0x442d0f4c,0x7c360f4d,0x09b20081,0xed570c2d}},	//   oke_, thyr, _চালা, гор_,
   {{0x442d0f4e,0x7c2d0f4f,0x8c430f50,0x09cc0096}},	//   nke_, gkar, бесе, ाल्य,
   {{0x442d0f51,0x9b9300e3,0x7c360f52,0x69da0233}},	// [8e0] ike_, إلكت, rhyr, _ötek,
   {{0xe9d70303,0x05d20f53,0x3b830f54,0x442d0f55}},	//   лку_, _साइब, слуг, hke_,
   {{0x442d0f56,0x7c2d00a7,0xf4be0033,0x8c460f57}},	//   kke_, bkar, _আহ্ব, _бене,
   {{0x442d0f58,0x7c2d0f59,0xdbd70364,0x3eb20f5a}},	//   jke_, ckar, mäßi, _kwyt_,
   {{0x442d0f5b,0x6449030a,0xd707007b,0x00000000}},	//   dke_, diei, лнце_, --,
   {{0x442d0934,0x9f5b0052,0x00000000,0x00000000}},	//   eke_, _saqë_, --, --,
   {{0x442d006d,0x04660ac6,0x64490150,0x7af600f0}},	//   fke_, лтим, fiei, lwyt,
   {{0x25f000a5,0x7bd60f5c,0x442d0f5d,0xaca40174}},	//   _इसकी_, ngyu, gke_, _nkọt,
   {{0xa6ca0814,0x91fc00d9,0xd5d60018,0x3866084e}},	//   _سوال_, klāt, _متاث, moor_,
   {{0xd6cf0cd2,0xe29f0102,0x7c2d02a7,0xdb160c56}},	//   _رقم_, íða_, zkar, rayè,
   {{0xf5930080,0xa1580f5e,0x05560f5f,0x7af6007f}},	//   _المج, тану_, _стая, hwyt,
   {{0x764a0f60,0x557700c1,0x38660185,0x64490f61}},	//   lify, _געבן_, noor_, ciei,
   {{0x09cc00c7,0x80c00f62,0xe80b09c3,0x7c2d0f63}},	//   র্যা, _विके, _सोफा_, vkar,
   {{0xe80b000f,0x38660185,0x7c2d0f64,0xb80b0f65}},	//   _सोना_, hoor_, wkar, _सोनम_,
   {{0x16d10f66,0x7c2d0f67,0x38660f68,0x00000000}},	//   _सम्ब, tkar, koor_, --,
   {{0x09cc00c7,0x386601d0,0xa3e709c4,0x00000000}},	//   র্মা, joor_, म्प_, --,
   {{0x38660f69,0x5b150f6a,0xead50f6b,0x00000000}},	// [8f0] door_, шмат, розь, --,
   {{0x7c2d03f3,0x442d0f6c,0x7f3c006e,0x6d410f6d}},	//   skar, zke_, _רעזו, úlas,
   {{0x764a0f6e,0x442d0f6f,0x1c000d88,0x2abb0d79}},	//   dify, yke_, _लोकल_, _bàbá_,
   {{0x38660313,0x9c130129,0x00000000,0x00000000}},	//   goor_, bọal, --, --,
   {{0x64490f70,0x6f1b0364,0x76ab0291,0x00000000}},	//   viei, äuch, хтев_, --,
   {{0x09cc0f71,0x80aa0f71,0xa3e70976,0x1994004d}},	//   র্বা, _কিন্, म्न_, _гаря,
   {{0x442d0f72,0x3d080f73,0x64490072,0x38660f74}},	//   tke_, हिये_, tiei, boor_,
   {{0x442d0f75,0x6a6b0364,0x14250f76,0x5fd40f77}},	//   uke_, rüfu, рдим, _थाइल,
   {{0x7cec0103,0xe80b0f78,0x00000000,0x00000000}},	//   _körö, _सोया_, --, --,
   {{0x442d0f79,0x69d70201,0xdb0f0094,0x9f400131}},	//   ske_, ngxe, _necí, _maiô_,
   {{0x69dd0782,0xc32300c7,0x78780314,0x62810f7a}},	//   _पानी, _বেশি_, líva, rmlo,
   {{0xdb0f001f,0xd71c0081,0x27ff0f7b,0x660d0022}},	//   _mecâ, _দেয়া_, _jaun_, ɓaka,
   {{0x92b70080,0x93940867,0x27ff0dd8,0x38bc0032}},	//   _إحصا, _اجما, _maun_, _kárá_,
   {{0x63bb0f7c,0xdb0f0f7d,0xed5a0831,0xd35600ca}},	//   laun, _cecí, вог_, _דיני_,
   {{0x61420f7e,0xdb0f04d8,0xa01b007b,0x32f6007f}},	//   _меша, _decí, mmön, _zły_,
   {{0x63bb0f7f,0x27ff01ff,0xbb7600e5,0x3ead020a}},	//   naun, _naun_, аузъ, ţeta_,
   {{0xe9da0f80,0x38660126,0x6d410032,0xeb97002d}},	// [900] кка_, voor_, úlar, риу_,
   {{0x63bb019c,0x7af60150,0x787800b6,0xab5b0f81}},	//   haun, rwyt, díva, _idül,
   {{0xf1dd0557,0x41dd0f82,0x63bb0f83,0x261908fa}},	//   _मानन, _मानस, kaun, पानी_,
   {{0xa3e7000d,0xdb0f002d,0x63bb00d9,0xc6a60f84}},	//   म्म_, _decâ, jaun, арки,
   {{0x27ff048e,0x764a0f85,0x46f60f86,0x38660f87}},	//   _daun_, tify, рчет, roor_,
   {{0x69dd007d,0x20c502d5,0x7cec0103,0xb8dc0033}},	//   _पायी, _विंध, _görö, _আম_,
   {{0x01bb0f71,0x764a0f88,0x38660f89,0x26df0f8a}},	//   ংলাদ, rify, poor_, _equo_,
   {{0x27ff0f8b,0x63bb0f8c,0x290a0113,0x00000000}},	//   _gaun_, gaun, _irba_, --,
   {{0xd3770f8d,0x38bc0032,0x38ac0139,0x09cc0033}},	//   ичь_, _fárá_, _fòrò_, র্ণা,
   {{0x201200ac,0x27e60f8e,0xa3e70f8f,0x27ff042c}},	//   _anyi_, lfon_, म्ब_, _zaun_,
   {{0x7bc60f90,0x9f4b037a,0x64a30f91,0x27ff01ff}},	//   _odku, recí_, _даха, _yaun_,
   {{0x78a10103,0x920201d3,0x27e600f0,0x2000020a}},	//   _élve, _šāda, nfon_, _caii_,
   {{0x63a20f92,0xdb0f0072,0x200500b6,0xdb060065}},	//   _ifon, _pecí, ěli_, _eekú,
   {{0x20050067,0x20120f93,0x7a32052f,0xdb060139}},	//   śli_, _enyi_, _sætn, _fekú,
   {{0x9c47065c,0x00000000,0x00000000,0x00000000}},	//   ахал, --, --, --,
   {{0x8f470f94,0x705500cd,0x1dd30251,0x44f800de}},	//   _вход, _دنبا, _ताकत, _mũ_,
   {{0x290a01b3,0xaa7b0220,0xfb870b91,0x44f800de}},	// [910] _arba_, _opýt, рывн, _lũ_,
   {{0x63bb006d,0x39a70f95,0x27ff0f96,0x7a380f97}},	//   zaun, ршав, _saun_, апур_,
   {{0x27ff08c4,0x7cec0103,0x69dd0096,0xa3e702d5}},	//   _paun_, _vörö, _पाठी, म्ड_,
   {{0xdd1c00b6,0x765a023b,0x63a200b3,0xd7c80f98}},	//   _nářa, _ajty, _nfon, لومه_,
   {{0xe5a50f99,0x290a0f9a,0xd6db0275,0x8c1a00a1}},	//   били, _erba_, тте_, _עושי,
   {{0x63a20f9b,0x63bb0239,0x69dc0076,0xd6ce00da}},	//   _afon, waun, _gcre, رقى_,
   {{0x27ff0979,0x44f80028,0x63bb0f9c,0x69c70113}},	//   _taun_, _cũ_, taun, _idje,
   {{0xed5800a1,0x80c00f82,0x6d480037,0x61ea042c}},	//   יבור_, _विजे, údai, _abfl,
   {{0x86980c0d,0x63bb0f9d,0x386d0f9e,0xdb060f9f}},	//   _вкус_, raun, _iker_, _sekú,
   {{0x629b025a,0xe4e702ec,0xdb0f0428,0xb06300c2}},	//   rquo, _відн, _mecà, äänt,
   {{0x92d700c7,0x9f5e000d,0x26190d39,0x63bb0fa0}},	//   াবে_, ětí_, पाठी_, paun,
   {{0x66010fa1,0x44e10fa2,0xaac70be4,0x6e25009c}},	//   _halk, mó_, _लिंक, _aohb,
   {{0x69c70fa3,0x44e10fa4,0x539a00a1,0x43850037}},	//   _odje, ló_, _עיסו, _الشق,
   {{0x69c701e5,0x6da30fa5,0x66010084,0x7bdd0072}},	//   _ndje, зира, _jalk, _acsu,
   {{0x44e10fa6,0x2d8c0212,0x386d0634,0xdca600d3}},	//   nó_, äde_, _oker_, саби,
   {{0x69dc0fa7,0x62990fa8,0x7aef0fa9,0x20120134}},	//   _scre, _kuwo, _bpct, _unyi_,
   {{0x290a00e9,0xa3df0251,0x63b90150,0x69c70357}},	// [920] _srba_, _तान_, _mewn, _bdje,
   {{0xbf9b0396,0xdb0f015e,0xa2cf00b6,0x387f01ff}},	//   ndên, _decà, _दिन्, _ahur_,
   {{0x44e10faa,0x31ba0130,0x93f9009d,0x387f03dc}},	//   jó_, רזענ, ्याच_, _bhur_,
   {{0x387f0fab,0x44e10fac,0xe73a02fd,0x44f800de}},	//   _chur_, dó_, лее_, _rũ_,
   {{0x27e60fad,0x44e10072,0x629903a9,0x387f0fae}},	//   rfon_, eó_, _nuwo, _dhur_,
   {{0x63a20faf,0xceb30341,0xfaa30fb0,0x290a007e}},	//   _sfon, ליד_, _харо, _trba_,
   {{0x6601025e,0x44e10fb1,0x96c40034,0x7c260fb2}},	//   _dalk, gó_, _रिकॉ, _kokr,
   {{0x44f80028,0x62990fb3,0x69c70fb4,0x7c260090}},	//   _vũ_, _buwo, _zdje, _jokr,
   {{0x8c1b004f,0x66010fb5,0x32660448,0x85060281}},	//   רופי, _falk, йтов, _گوان,
   {{0x41dd02e8,0x8afb00c1,0x66010188,0x11d800e3}},	//   _माणस, נהיי, _galk, جودة_,
   {{0x04960080,0x44e10890,0xdb0f0fb6,0xdfd10fb7}},	//   _الصح, có_, _mecá, ويد_,
   {{0x6e2501e8,0x7ae40fb8,0x7c2600f3,0x78780220}},	//   _sohb, ktit, _nokr, zívn,
   {{0x447b0130,0xdb1d0146,0x62990361,0xbf9b0231}},	//   _ענדע, _odsá, _guwo, bdên,
   {{0x7ae40fb9,0x63b900a5,0x6601008c,0xdb0f015e}},	//   dtit, _zewn, _xalk, _recà,
   {{0x90a60fba,0x7ae4084e,0x8bc700ae,0x00000000}},	//   _احتم, etit, йсад, --,
   {{0x44260fbb,0x7c260449,0x62990167,0x318e013c}},	//   _joo_, _cokr, _yuwo, məz_,
   {{0x2fc90fbc,0x44260197,0x44e10068,0x78780038}},	// [930] _idag_, _moo_, zó_, tívn,
   {{0x4426025e,0x386d02b9,0x6f0d0fbd,0x98b808bb}},	//   _loo_, _sker_, _irac, _ayrı_,
   {{0xda780fbe,0x6f0d025b,0x7d080fbf,0xdb0f0328}},	//   сят_, _hrac, ådst, _decá,
   {{0x6f0d0fc0,0x44260fc1,0x44e10fc2,0x66010fc3}},	//   _krac, _noo_, vó_, _salk,
   {{0x66010fc4,0xe6100260,0x7d030fc5,0xfaff01d3}},	//   _palk, کشن_, bírá, šību_,
   {{0x44e100fb,0xd126012b,0x2ba500b6,0x442601ee}},	//   tó_, _قم_, गुरा, _aoo_,
   {{0x63b90067,0xe3b10080,0x66010fc6,0x62990fc7}},	//   _pewn, ورة_, _valk, _suwo,
   {{0x44e10fc8,0x386d00d6,0x66010fc9,0x6f0d0fca}},	//   ró_, _uker_, _walk, _orac,
   {{0x44e10fcb,0xe816009d,0x27ed0800,0x6f0d0174}},	//   só_, णारा_, _iben_, _nrac,
   {{0x2fc90fcc,0x44e10fcd,0x63b900a5,0x317c037d}},	//   _adag_, pó_, _wewn, _bzvz_,
   {{0x3ea9002d,0x6f0d0fce,0x7a3b00fd,0x27ed0fcf}},	//   _atat_, _arac, _gîte, _kben_,
   {{0x44c501d3,0x68e500f0,0x62990fd0,0x44260fd1}},	//   mē_, ithd, _tuwo, _goo_,
   {{0x44c500d9,0x6f0d0fd2,0x64950078,0x644b02a1}},	//   lē_, _crac, _eġit, _imgi,
   {{0x7ae40e37,0x5bb2009f,0x64a300c4,0x44260fd3}},	//   vtit, जर्व, _gđic, _zoo_,
   {{0x44260649,0x27ed02dc,0x8c0100c7,0x3ea90fd4}},	//   _yoo_, _oben_, _একজন_, _etat_,
   {{0x6a7002e2,0x4426023e,0x5baa0fd5,0xeb970fd6}},	//   häft, _xoo_, ркам_, жит_,
   {{0x3b07016e,0x6f0d0fd7,0x7ae4034f,0x3a260fd8}},	// [940] оето_, _grac, utit, омаг,
   {{0x7ae40d63,0x78780fd9,0x320500d7,0x2b40078e}},	//   rtit, tívo, ndly_, rzic_,
   {{0x7ae40fda,0x644b02fe,0xe816009d,0x7c260087}},	//   stit, _omgi, णाला_, _tokr,
   {{0x7ae40fdb,0x44c501d3,0x6bd60246,0xdb240103}},	//   ptit, dē_, _بتدر, _فوجی,
   {{0xaac7030b,0xdb0f037a,0x6f0d0231,0xdb0401ff}},	//   _लिएक, _tecá, _xrac, paiñ,
   {{0x2d4e01e9,0x44260fdc,0xa3e70fdd,0x27ed0fde}},	//   _eнee_, _soo_, म्स_, _eben_,
   {{0xd4970fdf,0x44260fe0,0xd0b100a7,0xd5b907bf}},	//   оры_, _poo_, _təəs, ссі_,
   {{0x68e30428,0x44260085,0xa3df00a4,0x46d2023a}},	//   ànde, _qoo_, _ताण_, _सिपह,
   {{0x44260fe1,0x69da0233,0x00000000,0x00000000}},	//   _voo_, _ötes, --, --,
   {{0x81d200c7,0x26c000c6,0x6f0d0052,0x00000000}},	//   হ্ন_, šios_, _rrac, --,
   {{0x4a7b0130,0x442600a1,0x649500b6,0xa3e70d75}},	//   שריב, _too_, _všic, म्ह_,
   {{0x6f0d0ed9,0x35e000c3,0x4034007b,0x00000000}},	//   _prac, _नाड़, деюс, --,
   {{0xa3e302d5,0x649505db,0xe67b020b,0x00000000}},	//   _पॉट_, _išia, _hưở, --,
   {{0xafdb0537,0xa2f80285,0xdef801b3,0x00000000}},	//   tiøs, ्टीज_, цыю_, --,
   {{0xdd9400c6,0x6f0d0fe2,0x6ce4004d,0x40350fe3}},	//   дары, _wrac, міте, _некс,
   {{0x6f0d0fe4,0xafdb038c,0x261100a5,0x69dd0096}},	//   _trac, riøs, _धोनी_, _पाही,
   {{0x6f0d0fe5,0x44c501d3,0x97ea0367,0x5a350fe6}},	// [950] _urac, zē_, ışlı, пнат,
   {{0x78a301f9,0x00000000,0x00000000,0x00000000}},	//   ínvo, --, --, --,
   {{0xa3da00bc,0x00000000,0x00000000,0x00000000}},	//   ़ला_, --, --, --,
   {{0xdb1f023b,0xae190034,0xa8020233,0x68e50fe7}},	//   naqë, दावन_, _çılg, rthd,
   {{0x8c1a00a1,0x00000000,0x00000000,0x00000000}},	//   _הורי, --, --, --,
   {{0xafdb00d6,0x59e20096,0x3866007e,0x44c500e8}},	//   rnøy, _पायर, čora_, tē_,
   {{0x6a700fe8,0x19580fe9,0x7af90342,0x25ec00aa}},	//   räft, _дары_, şatı, _आउरी_,
   {{0x44390fea,0x44c501d3,0x57f400f6,0xa01b02c3}},	//   ós_, rē_, _опст, smöj,
   {{0xf7490080,0x44c501d3,0x051b0033,0x45d5002d}},	//   _الذي_, sē_, তনের_, _ноас,
   {{0x363700bf,0xc2420879,0x2905037a,0xd5b1020b}},	//   _بررس, еньк, _álas_, _góp_,
   {{0x21690feb,0xdb1d02b6,0xd00a0fec,0x86220281}},	//   сини_, _udsæ, бене_, _سکول,
   {{0x293600c1,0x644b0fed,0xc2f30033,0x3e7601cd}},	//   פארן_, _umgi, জিবি_, mæti_,
   {{0x20040038,0x443f01c2,0x3e7601cd,0x00000000}},	//   ľmi_, mhu_, læti_, --,
   {{0x443f006d,0x3d080cf6,0xf3f9044c,0x20040fee}},	//   lhu_, हिले_, leţ_, žmi_,
   {{0xc69200a1,0x91ba00ca,0xafdb09af,0xed520103}},	//   תאם_, _המצי, riør, رپر_,
   {{0xaac700a5,0x4ac70fef,0x645b0ff0,0x00000000}},	//   _लिखक, _लिखव, nnui, --,
   {{0x6b630ff1,0x443f0ff2,0xf09300d7,0x00000000}},	// [960] екта, ihu_, _אנה_, --,
   {{0x499a0b2f,0xd042013c,0x00000000,0x00000000}},	//   стая_, vrlə, --, --,
   {{0x443f067d,0xa96a0037,0x290e003e,0xd88a0103}},	//   khu_, حمام_, ífa_, مپئن_,
   {{0xfc3200e3,0xdb040126,0x2611074c,0x7a32003e}},	//   _أحد_, ncië, _धोबी_, _mæti,
   {{0xfbd30054,0xf3f900ae,0x4cb10033,0x7c360b85}},	//   _אתר_, deţ_, _জয়পু, mkyr,
   {{0xe8df0028,0x4b7b00ca,0xdb0f016d,0xd6a9001c}},	//   _giữa_, _לאכו, _secç, زدهم_,
   {{0xb5090096,0x5fbe00b6,0x645b0ff3,0x9f590f5a}},	//   विषय_, ्णाल, fnui, gesê_,
   {{0x7c240ff4,0x443f003d,0x43940ff5,0xb3c60971}},	//   njir, ghu_, майс, रृंख,
   {{0xdb060103,0x6fd600a4,0x7a33047e,0x261900a4}},	//   _nekü, _भाजू, _fıtı, पाशी_,
   {{0x628303ea,0x443f0ff6,0x7a32003e,0x31340ff7}},	//   _chno, ahu_, _bæti, деор,
   {{0x443f019f,0xf1dd08d4,0x6495007e,0x00000000}},	//   bhu_, _मारन, _išin, --,
   {{0xc4860ff8,0x395700a1,0x7c24083e,0xdb060103}},	//   _элек, לשים_, jjir, _bekü,
   {{0xee8700c2,0x26c60ff9,0x4ea7065c,0x00000000}},	//   зыво, nsoo_, ярна, --,
   {{0xd2500470,0x62830441,0x6ca70927,0xdb06007f}},	//   _جنت_, _ghno, зраж, _lekó,
   {{0xa1570ffa,0xe9ff00de,0x61fa0ffb,0xc27b00ca}},	//   _нашу_, _ngạc_, metl, _הרגי,
   {{0x31c6030b,0x61fa0ffc,0x415b00ca,0x249e01c2}},	//   bízí_, letl, _לדוג, _mutm_,
   {{0xdb040257,0x60da005c,0xa3df009d,0xdb060364}},	// [970] nciè, lutm, _तास_, _gekü,
   {{0x61fa0ffd,0x7c240a4b,0xe29f003e,0x02d400c0}},	//   netl, ajir, íði_, _दिनभ,
   {{0x6ca40ffe,0x24890031,0x7c380328,0xa3bc00aa}},	//   _пряж, ňami_, ñará, अरा_,
   {{0xf77000cd,0x61fa0fff,0xdb0d0143,0x9f590052}},	//   گام_, hetl, lbaí, jesë_,
   {{0x26191000,0x61fa1001,0x644000e3,0x7c3a020d}},	//   पाली_, ketl, dhmi, être,
   {{0xf7700602,0x61fa0292,0xa3df009f,0xf3f9020a}},	//   دام_, jetl, _ताह_, inţe_,
   {{0x443f1002,0x26c60188,0x00000000,0x00000000}},	//   thu_, asoo_, --, --,
   {{0xc9520054,0x7bdf1003,0xdb1d023b,0x9f59023b}},	//   _סמן_, ngqu, _nesë, gesë_,
   {{0x13060084,0x645b1004,0x61fa026a,0xf3f9020a}},	//   дный_, rnui, fetl, reţ_,
   {{0x443f1005,0xa3df1006,0x645b00d3,0x68e10212}},	//   shu_, _ताव_, snui, _älds,
   {{0x443f1007,0xa2cf0e19,0x3de30033,0xdb1d0052}},	//   phu_, _दिव्, য়াল, _besë,
   {{0xcdc90054,0x6440078f,0x78a91008,0x291100e7}},	//   _כך_, chmi, _čevl, _mrza_,
   {{0xdb060c56,0xdb0401c0,0x09d50081,0x43741009}},	//   _lekò, rcië, স্যা, _пушт,
   {{0x2911100a,0x443d00bd,0xa2940120,0x999800d8}},	//   _orza_, _hlw_, _зачі, _smrž_,
   {{0x1d0709f2,0x443d100b,0x6da30307,0xfce3100c}},	//   мери_, _klw_, тиса, коро,
   {{0x6e21003e,0xdb1d100d,0x00000000,0x00000000}},	//   ölbr, _kesè, --, --,
   {{0x2903100e,0xfaff00d9,0x1a06100f,0x32070027}},	// [980] _asja_, šīnu_, мпам, _kany_,
   {{0x29111010,0x6f040201,0x7c36013f,0x64850037}},	//   _brza_, _isic, skyr, lóid,
   {{0xeb9a1011,0x32070054,0xae1b00c1,0x8c461012}},	//   _мин_, _many_, _וויכ, _жене,
   {{0x3ea01013,0x61fa1014,0x9f5906a3,0x64851015}},	//   _kuit_, zetl, fesè_, nóid,
   {{0x61fa1016,0x41dd034d,0x78780231,0x00000000}},	//   yetl, _मांस, nívi, --,
   {{0x28db0557,0x6f040051,0x09d50033,0x443d00f0}},	//   मूहि, _msic, স্বা, _alw_,
   {{0x61fa1017,0x5e570130,0x64401018,0x9f59023b}},	//   vetl, ויסע_, thmi, tesë_,
   {{0x7bc41019,0xdb1d0113,0x672d0052,0x61fa0313}},	//   naiu, _besè, ënjë, wetl,
   {{0xa3df07e5,0x68e10222,0x3ea0025a,0x61fa101a}},	//   _तार_, _äldr, _nuit_, tetl,
   {{0x6440023b,0xa683101b,0x2fc000b3,0xdb1d101c}},	//   shmi, _алуд, _aeig_, _desè,
   {{0x61fa101d,0x6f04101e,0xae220fef,0x443d0131}},	//   retl, _asic, मानन_, _flw_,
   {{0x68e10222,0x61fa101f,0xf99300a1,0x3ea01020}},	//   _ålde, setl, כרת_, _buit_,
   {{0x69ce0181,0x32070da7,0x27e40063,0x3ead0313}},	//   _odbe, _fany_, _mcmn_, ëet_,
   {{0x3ea01021,0x32070154,0x683a00b3,0x00000000}},	//   _duit_, _gany_, _oïdo, --,
   {{0xd30800ef,0x2486022e,0x2bd00006,0x6e940127}},	//   _hệ_, _khom_, तृभा, тиру,
   {{0x3ea01022,0x69ce0a69,0xdb0606a3,0xd30800de}},	//   _fuit_, _adbe, _rekò, _kệ_,
   {{0x661a0a9f,0x62981023,0xae0c0c22,0xb4bb00c3}},	// [990] _ontk, _kivo, िएशन_, _अब्_,
   {{0x20090a88,0x24860090,0xdb060154,0x2fc0042c}},	//   _haai_, _lhom_, _pekò, _zeig_,
   {{0xd3080019,0xa3df0c9c,0xdb1d0103,0x7a32003e}},	//   _lệ_, _ताल_, _mesé, _nætu,
   {{0xa2cf1024,0xec350130,0x62981025,0x315700c1}},	//   _दिल्, _נאָר_, _livo, ויבן_,
   {{0x66081026,0x2ee90063,0x20090f5a,0x99580206}},	//   _badk, _jqaf_, _maai_, háňa_,
   {{0x62981027,0x2009057a,0xdb1d1028,0xfb16006e}},	//   _nivo, _laai_, _odsú, _אַלט_,
   {{0x6608025e,0x6d4703e5,0x69c51029,0x9f5906a3}},	//   _dadk, nzja, mahe, sesè_,
   {{0xcd9809c1,0x2486102a,0x69c5102b,0x588702e3}},	//   ודות_, _chom_, lahe, _цыга,
   {{0x6298102c,0x443d0161,0xfe0f102d,0x320700ee}},	//   _bivo, _vlw_, ायास_, _pany_,
   {{0x6608102e,0x69c5102f,0x3ea01030,0x649500c6}},	//   _gadk, nahe, _ruit_, _išim,
   {{0x09d500c7,0xd00a1031,0xdb1d002b,0xdb041032}},	//   স্থা, пене_, _desé, rcié,
   {{0x7a320102,0x7878025b,0x23600146,0x7643005c}},	//   _hætt, tívi, _žije_, lhny,
   {{0x69c5101e,0x20090185,0x64851033,0x2fc005fe}},	//   kahe, _daai_, róid, _veig_,
   {{0x09d50f71,0xfc3f0933,0x63a91034,0x3ea005fe}},	//   স্তা, _alí_, lcen, _vuit_,
   {{0x75f3008e,0x7a320088,0x69c51035,0x6aa40188}},	//   mızı, _mætt, dahe, wqif,
   {{0x3ea007e4,0x98a700b6,0x200902ac,0xfc3f033c}},	//   _tuit_, šně_, _gaai_, _clí_,
   {{0x1e960097,0xfc3f00e3,0xab661036,0x2be1030b}},	// [9a0] _прор, _dlí_, хвал, _फारा,
   {{0x75f30587,0xd9461037,0x69c51038,0x7a320537}},	//   nızı, нези, gahe, _nætt,
   {{0xa3df1039,0xba3b0428,0x6608103a,0x7dbb0327}},	//   तला_, _suïc, _radk, _מציצ,
   {{0x63a9103b,0xc18c00c1,0xe786004d,0x248d103c}},	//   jcen, קטאָ, нуло, jmem_,
   {{0xe737103d,0x69c5103e,0x2ca100e7,0x26dd0449}},	//   нец_, bahe, _zuhd_, guwo_,
   {{0x63a9103f,0x69ce052f,0x69c50167,0x200b0094}},	//   ecen, _udbe, cahe, zdci_,
   {{0x62981040,0x2486006c,0xdb1d1041,0x64950218}},	//   _rivo, _phom_, _resé, _išij,
   {{0xdb0f0072,0x764302fa,0x63a91042,0x0463022a}},	//   _recú, ahny, gcen, лтым,
   {{0xa01b0088,0x6d47003d,0xdb08020d,0x20090313}},	//   llög, zzja, élèv, _raai_,
   {{0xd3080028,0x63a91043,0x20091044,0xddc7033b}},	//   _vệ_, acen, _saai_, kojš,
   {{0xa3e8018b,0x63a91045,0xb7bd00d3,0x2009084e}},	//   _बाप_, bcen, _soţi, _paai_,
   {{0x23660d7d,0x63a91046,0x44cc030b,0xd30800de}},	//   _txoj_, ccen, mě_, _tệ_,
   {{0x69c51047,0x00000000,0x00000000,0x00000000}},	//   yahe, --, --, --,
   {{0x61460257,0x2009057a,0xfc3f0037,0x28d100b7}},	//   _célé, _waai_, _slí_, _हिलि,
   {{0x69c50006,0x44cc030b,0xbd681048,0x614600fd}},	//   vahe, ně_, ерте_, _délé,
   {{0x9f520a43,0x69c51049,0xb7bd020a,0x657a0632}},	//   _cayó_, wahe, _toţi, _myth,
   {{0x69c50bd9,0x3a750231,0x657a0178,0x6146104a}},	// [9b0] tahe, влар, _lyth, _félé,
   {{0xddc7104b,0xbbeb00cd,0x9967104c,0x6146104d}},	//   bojš, _کردم_, нтел, _gélé,
   {{0x7a3201ab,0xe61f0019,0x657a104e,0x63a9104f}},	//   _rætt, _đô_, _nyth, ycen,
   {{0x7a321050,0x44cc000d,0x69c51051,0xd75908ba}},	//   _sætt, dě_, sahe, ولات_,
   {{0xd90f00fb,0x7643005c,0xab841052,0x00000000}},	//   _گیا_, thny, _бурк, --,
   {{0x7aed0018,0x657a1053,0x64951054,0x46d200b6}},	//   mtat, _byth, _všim, _सिरह,
   {{0xd90f00fb,0xd4691055,0x657a0178,0xf3f9020a}},	//   _دیا_, мике_, _cyth, enţa_,
   {{0x7aed028d,0x6d581056,0x76430085,0x00000000}},	//   otat, _žvak, shny, --,
   {{0xc8641057,0x248d1058,0x7a3202b6,0x4864008f}},	//   _стри, rmem_, _tætt, _сърб,
   {{0x63a91059,0x7aed105a,0x7c2f028d,0x44cc02c6}},	//   scen, itat, _locr, bě_,
   {{0xa06a105b,0x7aed023b,0xe8160096,0x63a907ee}},	//   дана_, htat, णाचा_, pcen,
   {{0x7c2f03a9,0xa3e80714,0x6146014b,0x00000000}},	//   _nocr, _बाय_, _sélé, --,
   {{0xe28e105c,0x09cc0081,0x442f041c,0x00000000}},	//   _ва_, র্টা, _iog_, --,
   {{0xc0a80979,0xda11007d,0x7aed105d,0x2d9e004d}},	//   بایل_, _डोलत_, dtat, øte_,
   {{0x1fb6105e,0x442f0d62,0x7aed105f,0x217500c1}},	//   _испр, _kog_, etat, _בײַם_,
   {{0x442f1060,0xe8df00de,0xbc631061,0x9f520139}},	//   _jog_, _nhựa_, авск, _dayò_,
   {{0x614604ea,0x442f01fa,0x7aed0256,0x649500e7}},	// [9c0] _télé, _mog_, gtat, _ašik,
   {{0x4a431062,0x442f00a1,0xd5e00557,0xa01b0212}},	//   анув, _log_, _नाइज, smöt,
   {{0x442f0305,0x2dd900c1,0x4dd900c1,0x77690072}},	//   _oog_, _אַרב, _אַרױ, _axex,
   {{0x44cc000d,0x442f1063,0x76411064,0x657a0257}},	//   vě_, _nog_, _ally, _ryth,
   {{0x7aed1065,0xb8650dce,0x657a1066,0x4af900ae}},	//   ctat, دالو, _syth, _пэря_,
   {{0x09cc00c7,0x649500cc,0x44cc030b,0x98a700d3}},	//   র্জা, _ušij, tě_, ână_,
   {{0xe97600cd,0x77690072,0xa2bf0034,0x04661067}},	//   _شهرد, _exex, लीस्, ктим,
   {{0x442f0197,0x00000000,0x00000000,0x00000000}},	//   _cog_, --, --, --,
   {{0x657a02ad,0x65c61068,0x442f00ca,0x4274016d}},	//   _wyth, _абза, _dog_, лгис,
   {{0x44cc02c6,0x442f030a,0xb355001c,0x00000000}},	//   pě_, _eog_, دیها_, --,
   {{0x7aed1069,0x442f106a,0xd48f106b,0xd3e400cd}},	//   ztat, _fog_, _вр_, _مقای,
   {{0x320a0897,0x76580010,0xe53700c1,0x6f16106c}},	//   žby_, livy, _שטאט_, _bryc,
   {{0x6442106d,0xdb0d0131,0x6f16106e,0xdd3b078e}},	//   _iloi, mbaç, _cryc, _băşt,
   {{0x442f01bb,0x7c2f106f,0x6f161070,0xa3e800bc}},	//   _zog_, _socr, _dryc, _बाड_,
   {{0x442f1071,0x16df099d,0x2d8501df,0xe29b00ca}},	//   _yog_, _नम्ब, åle_, _קשור,
   {{0x7aed1072,0x3d0802e8,0x46d21073,0x09cb009d}},	//   ttat, हिजे_, _सिंह, ाण्य,
   {{0x7aed1074,0x5b15065c,0x4c9400c2,0xc4c40103}},	// [9d0] utat, ымат, ритс, _ڈے_,
   {{0x7aed1075,0x5fb60034,0x9f590143,0x850200b6}},	//   rtat, ूरथल, nesí_, लबाट_,
   {{0x7aed1076,0xda780e38,0x26cd015c,0x6f161077}},	//   stat, тят_, _sveo_, _zryc,
   {{0x7aed1078,0xdb1d0072,0x00000000,0x00000000}},	//   ptat, _hesí, --, --,
   {{0x442f1079,0x44210019,0x64850131,0xf6e7107a}},	//   _rog_, _đh_, jóia, тцен,
   {{0x644202fd,0x6d58013f,0x69dd009d,0x442f107b}},	//   _aloi, _žvai, _पाटी, _sog_,
   {{0x442f107c,0x6442107d,0xb7bd00ae,0xdb1d0143}},	//   _pog_, _bloi, _soţu, _mesí,
   {{0x442f022e,0x1309107e,0x6442107f,0x845800c2}},	//   _qog_, ений_, _cloi, крыт_,
   {{0x628a0080,0x442f1080,0x97ea0b88,0x26cd0335}},	//   _bhfo, _vog_, ıştı, _uveo_,
   {{0x42250ff7,0x64421081,0x442f1082,0x478800ae}},	//   удов, _eloi, _wog_, _рссм_,
   {{0xa2cf05cd,0x56940131,0xe4e4004d,0x6442033c}},	//   _दिक्, _тафт, _вічн, _floi,
   {{0x64421083,0x00000000,0x00000000,0x00000000}},	//   _gloi, --, --, --,
   {{0x63bb1084,0xa3e81085,0xba3b1086,0x60da029a}},	//   mbun, _बात_, _ruïn, artm,
   {{0xa2d8097c,0xfce61087,0x63bb0c19,0x7e750634}},	//   _मित्, лого, lbun, gozp,
   {{0xdb1d00b6,0x2720007f,0x63bb0350,0xa01b1088}},	//   _desí, _मप्र_, obun, rmör,
   {{0x6f161089,0x6e3c108a,0x2a78108b,0x63bb108c}},	//   _tryc, skrb, _skrb_, nbun,
   {{0x63bb02e2,0xc05300ca,0x200207f5,0x3a3100d4}},	// [9e0] ibun, _לזה_, meki_, _bozp_,
   {{0x200209e7,0x01d50033,0xd9ae0285,0x00000000}},	//   leki_, ত্রদ, टडेट, --,
   {{0x291e0e94,0x38cb010d,0x46c602d5,0x9c66001c}},	//   _štab_, فانی_, रीनह, _مهدو,
   {{0x6495009e,0xdb1d108d,0xa3df0d75,0x81760142}},	//   _eġiz, _desâ, _ताग_, אגעס_,
   {{0xa2cf0e19,0x601b007b,0x63bb108e,0xa01b042c}},	//   _दिग्, _hämä, dbun, llöc,
   {{0x64420527,0x7bc6023b,0xa5f8108f,0x63bb1090}},	//   _sloi, _heku, теку_, ebun,
   {{0xa3e81091,0x7bc60496,0x644200d3,0x765802f1}},	//   _बाद_, _keku, _ploi, rivy,
   {{0x20020510,0x63bb1092,0x76581093,0x7bc60350}},	//   jeki_, gbun, sivy, _jeku,
   {{0x38550465,0x200201e8,0x05240081,0xdb041094}},	//   _търс, deki_, বনের_, mbió,
   {{0x7bc61095,0x27e61096,0x64a600d6,0x00000000}},	//   _leku, lgon_, _бажа, --,
   {{0xdb1d1097,0x63bb01c2,0x601b007b,0x00000000}},	//   _resí, bbun, _nämä, --,
   {{0x27e61098,0x7bc61099,0x64850674,0x71f70068}},	//   ngon_, _neku, lóin, پریس_,
   {{0xa85700ca,0x27e600fe,0x00000000,0x00000000}},	//   ריכה_, igon_, --, --,
   {{0x539b0105,0x291801b5,0xdb1d016d,0xc694006e}},	//   _ניגו, _orra_, _lesã, יאָ_,
   {{0x7bc6109a,0xdb1d002b,0x7e75109b,0x2002109c}},	//   _beku, _vesí, rozp, beki_,
   {{0x200201e8,0x63a20231,0xade900b6,0x00000000}},	//   ceki_, _jgon, ञ्जन_, --,
   {{0x29180018,0x63a20051,0x320e01c2,0xba550215}},	// [9f0] _arra_, _mgon, _kafy_, авај,
   {{0x63bb00ae,0x00000000,0x00000000,0x00000000}},	//   zbun, --, --, --,
   {{0x6485109d,0x3eb900e8,0x63bb007f,0x00000000}},	//   dóin, lpst_, ybun, --,
   {{0x63a2109e,0x7bc6109f,0xf8c90139,0x64b101d3}},	//   _ngon, _geku, _aréè_, _jāie,
   {{0x291810a0,0x61f8033b,0x65c50131,0x7c2d10a1}},	//   _erra_, _obvl, абла, mjar,
   {{0xe6180565,0x63a210a2,0x200210a3,0x27e910a4}},	//   лді_, _agon, zeki_, żan_,
   {{0xce3800a1,0x7bc60092,0x290500e5,0x63bb0a2c}},	//   ראות_, _yeku, _èla_, tbun,
   {{0x7afd0124,0xa3df0179,0xafdb0537,0x00000000}},	//   _kpst, _ताओ_, shøj, --,
   {{0x63bb10a5,0xc24510a6,0xa3b40336,0xf9a90032}},	//   rbun, иник, झड़_, _gbèè_,
   {{0x69c710a7,0xdb0410a8,0x63a20a00,0x63bb10a9}},	//   _jeje, nciá, _egon, sbun,
   {{0x69c710aa,0x216910ab,0x7c2d10ac,0xafdb052f}},	//   _meje, тини_, kjar, dkøb,
   {{0x7afd10ad,0x69c710ae,0x20560a71,0xdd2f00b6}},	//   _opst, _leje, ртор, _běže,
   {{0x387e10af,0x7c2d10b0,0x200210b1,0x442d10b2}},	//   _être_, djar, reki_, mje_,
   {{0x7bc610b3,0x443f10b4,0x644910b5,0x69c7030b}},	//   _seku, lku_, lhei, _neje,
   {{0x7afd0029,0x442d013f,0x7c2d0088,0xdd920e25}},	//   _apst, oje_, fjar, زور_,
   {{0x644910b6,0x660310b7,0x44f10019,0xef1a10b8}},	//   nhei, henk, _mơ_, _ами_,
   {{0x69c70068,0x207b00c1,0x443f10b9,0x644910ba}},	// [a00] _beje, _באקא, iku_, ihei,
   {{0xba2310bb,0x601b02fd,0x442d10bc,0x7bc610bd}},	//   одук, _tämä, hje_, _weku,
   {{0x443f0329,0x442d00f3,0x64490665,0x69c710be}},	//   kku_, kje_, khei, _deje,
   {{0x1ae60d64,0x443f00e9,0x64490126,0x442d10bf}},	//   _комм, jku_, jhei, jje_,
   {{0x442d10c0,0x27e610c1,0x644910c2,0x69c710c3}},	//   dje_, rgon_, dhei, _feje,
   {{0x443f0029,0x660304aa,0x442d00a5,0x69c70d12}},	//   eku_, genk, eje_, _geje,
   {{0x44f100ef,0x7ae410c4,0x644900e3,0xdb1d001f}},	//   _cơ_, luit, fhei, _tesã,
   {{0x644910c5,0x442d10c6,0x628110c7,0x443f00dc}},	//   ghei, gje_, ello, gku_,
   {{0x660310c8,0x32660cf5,0x23380084,0x779400cd}},	//   benk, итов, уппы_, _ایشا,
   {{0x442d10c9,0x443f10ca,0x7c2d10cb,0xe5a300d3}},	//   aje_, aku_, zjar, _дифи,
   {{0x850603ed,0x443f10cc,0x442d02dd,0x64490441}},	//   _خوان, bku_, bje_, bhei,
   {{0x644910cd,0x442d0d1b,0x443f068e,0x386610ce}},	//   chei, cje_, cku_, nnor_,
   {{0xfe2210cf,0x7c2d10d0,0xfe7f0428,0xd372001c}},	//   मांस_, vjar, juïc_, _بهش_,
   {{0x7ae410d1,0x30a60ce5,0x6e950aec,0x78a0039f}},	//   duit, _крив, сигу, _limv,
   {{0x69c710d2,0x0ed30096,0x44f10023,0xfda70285}},	//   _reje, _तिकड, _xơ_, _खलीफ,
   {{0xe51704dd,0x69c710d3,0x660310d4,0x644010d5}},	//   थिति_, _seje, zenk, nkmi,
   {{0x7ae410d6,0x7c2d10d7,0x66fa00d9,0xdb0f10d8}},	// [a10] guit, rjar, nākā, _recó,
   {{0x443f0618,0xdb1d10d9,0x442d10da,0x656d0092}},	//   zku_, _cesá, zje_, şahi,
   {{0x442d10db,0x69c710dc,0x64490185,0x3ea900dc}},	//   yje_, _veje, yhei, _huat_,
   {{0x3ea910dd,0x7ae410de,0x38660451,0x660310df}},	//   _kuat_, buit, gnor_, wenk,
   {{0x660310e0,0x443f10e1,0x44f10028,0x442d10e2}},	//   tenk, vku_, _sơ_, vje_,
   {{0x3ea910e3,0x2fc910e4,0x6f0d0350,0xba450103}},	//   _muat_, _leag_, _msac, _انسٹ,
   {{0x442d10e5,0x3ea910e6,0x644910e7,0x58d410e8}},	//   tje_, _luat_, thei, _морт,
   {{0xa2d810e9,0x442d01b3,0x660310ea,0x443f10eb}},	//   _मिश्, uje_, senk, uku_,
   {{0x644910ec,0xa3e810ed,0x660308ac,0x6f0d0174}},	//   rhei, _बार_, penk, _nsac,
   {{0x442d10ee,0x644910ef,0xa2d809b0,0x44f10023}},	//   sje_, shei, _मिर्, _tơ_,
   {{0x2fc910f0,0x442d10f1,0x6f0d10f2,0x8467013d}},	//   _beag_, pje_, _asac, _къде,
   {{0x3ea910f3,0x644010f4,0x442d023b,0x66fa00e8}},	//   _buat_, ckmi, qje_, bākā,
   {{0x02a70a8e,0x147400e3,0x6f630109,0x9e660037}},	//   _трем, _بالج, звяз, ماسن,
   {{0xed5a10f5,0x6d4e0364,0x7ae410f6,0x00000000}},	//   гог_, tzba, vuit, --,
   {{0x50b510f7,0x386610f8,0x27ed10f9,0x6efd0212}},	//   _услу, ynor_, _ocen_, _påbö,
   {{0x7ae410fa,0xb6030618,0x68e50124,0x27ed01dc}},	//   tuit, _hráč, duhd, _ncen_,
   {{0xab2710fb,0x9ce80033,0xb6030094,0x7ae40131}},	// [a20] бота_, খবেন_, _kráč, uuit,
   {{0x78a90b14,0x78a010fc,0x239b0138,0x20120415}},	//   _čevr, _simv, mąjį_, _hayi_,
   {{0xa3e80b7f,0x7ae410fd,0x20120d2a,0x6459029a}},	//   _बाल_, suit, _kayi_, _omwi,
   {{0xa2d8000c,0x32050103,0x201210fe,0x69c60ff9}},	//   _मिल्, hely_, _jayi_, िरही,
   {{0x386610ff,0x78bb1100,0x6ecb1101,0x66e31102}},	//   rnor_, _čuve, तीपु, зоча,
   {{0x20120044,0xdb1d02b6,0x64591103,0x91fc00e8}},	//   _layi_, _besæ, _amwi, gnāl,
   {{0x48e31104,0x78a01105,0x32051106,0x186a0284}},	//   _норв, _timv, dely_, _бави_,
   {{0xe8e00019,0xa2b41107,0x66fa01d3,0xa3e80096}},	//   _chụp_, обич, tākā, _बाळ_,
   {{0x64400088,0x661100c2,0x2fc90036,0x239b00c6}},	//   rkmi, ökkä, _reag_, jąjį_,
   {{0x6440007a,0x66fa01d3,0xc50a1108,0x60cd007f}},	//   skmi, rākā, _متصل_, _łama,
   {{0x20121109,0x5316110a,0x09d50033,0x3ea9110b}},	//   _bayi_, _گذار, স্কা, _suat_,
   {{0x9f99110c,0x6f0d0354,0x3ea90113,0xfe7f00ee}},	//   ивну_, _psac, _puat_, duïa_,
   {{0x32050a7f,0x3ea900fe,0x28af110d,0x6495110e}},	//   bely_, _quat_, _जूनि, _všit,
   {{0x6d14110f,0xfbdf03a8,0x32050d54,0x00000000}},	//   डिंग_, _clên_, cely_, --,
   {{0x40351110,0x64a3015c,0x20120027,0x2fc901b9}},	//   _мекс, _uđit, _fayi_, _teag_,
   {{0x0ca81111,0x201201c2,0x649500d4,0x00000000}},	//   стри_, _gayi_, _ušit, --,
   {{0x5a351112,0xe7cc0034,0x6f0d039f,0x6a350291}},	// [a30] онат, ारनप, _usac, онађ,
   {{0x27ed1113,0x6aad0052,0xfe7f00b3,0xfbdf03a8}},	//   _scen_, rqaf, buïa_, _glên_,
   {{0x20121114,0xa3e81115,0x27ed00f3,0x00000000}},	//   _yayi_, बला_, _pcen_, --,
   {{0xac191116,0xb901034d,0xc0b20023,0x765a063d}},	//   _тому_, _दि_, _sưởi_, _amty,
   {{0xd6db0cfc,0x6675001c,0xb06600c2,0x1dbf1117}},	//   уте_, يدتر, ltää, ्रपत,
   {{0xf7700a09,0x00000000,0x00000000,0x00000000}},	//   ران_, --, --, --,
   {{0xb0660084,0x32051118,0x91fc00d9,0x27ed0036}},	//   ntää, vely_, rnāl, _tcen_,
   {{0x99540fe9,0x00000000,0x00000000,0x00000000}},	//   _эксц, --, --, --,
   {{0x52a61119,0x32050b82,0xe7330dd0,0x2012111a}},	//   овым_, tely_, _عصر_, _rayi_,
   {{0x2012111b,0x5f1d05d6,0xe4e70120,0x00000000}},	//   _sayi_, मिन्_, _гідн, --,
   {{0x386d0b27,0x69d80396,0xe3b30602,0x320500ca}},	//   _kjer_, óvei, _فرش_, rely_,
   {{0xdb1d02fd,0x7643038c,0x64590193,0x60dc111c}},	//   _kesä, lkny, _umwi, árma,
   {{0x32050146,0x44f3016d,0x76430167,0x2d85111d}},	//   pely_, lã_, okny, ülen_,
   {{0x7643111e,0x2012111f,0xe8df00fe,0xa01b1120}},	//   nkny, _wayi_, _chừa_, llöl,
   {{0x2d8c02fe,0x6da31121,0xf3f900d3,0x20121122}},	//   åde_, дира, enţi_, _tayi_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xe7ff08fa,0x7643005c,0xd0420092,0xa09b0266}},	// [a40] ोजना_, kkny, xslə, _דיקט,
   {{0x25fb099d,0x386d1123,0x387f1124,0x5e570037}},	//   ल्मी_, _ajer_, _akur_, _وليس_,
   {{0xda1b0251,0x291c1125,0xafdb0565,0x7e7c1126}},	//   _नफरत_, íva_, rhøv, morp,
   {{0x6b830174,0xdb1d0c19,0xfe7f00ee,0x77861127}},	//   ọgas, _besä, nuïn_, олез,
   {{0x7c261128,0x386d03a9,0x00000000,0x00000000}},	//   _inkr, _djer_, --, --,
   {{0x386d01c5,0xd04200a7,0x1dbf0213,0x6b8b1129}},	//   _ejer_, rslə, ्रयत, ügge,
   {{0x344a00a9,0x3af40324,0xd04200a7,0xdb07003e}},	//   ичин_, läp_, sslə, élög,
   {{0x386d00f3,0x7e7c112a,0x76430167,0x9cd700ca}},	//   _gjer_, horp, akny, קופה_,
   {{0x7e7c112b,0x1666013d,0x213e0150,0x3a380078}},	//   korp, _двам, wyth_, _korp_,
   {{0x7af601b3,0x7643112c,0xb06600c2,0x00000000}},	//   ityt, ckny, ytää, --,
   {{0x7c26112d,0x6e37112e,0x7e7c112f,0x3a380063}},	//   _onkr, _roxb, dorp, _morp_,
   {{0x8cb100a4,0x00000000,0x00000000,0x00000000}},	//   _आंबो, --, --, --,
   {{0x09d50081,0x44261130,0xdefb00c6,0x289b006e}},	//   স্টা, _ino_, шын_, ייטא,
   {{0x44261131,0x3f850029,0x7c261132,0xb06600c2}},	//   _hno_, ālu_, _ankr, ttää,
   {{0x25b900a7,0xf3f9044c,0x91bb00d7,0x00000000}},	//   _əsl_, liţa_, _דמוי, --,
   {{0x8cdc0f35,0x44260167,0x1bbb0037,0xb06600ce}},	//   _फिरो, _jno_, شارع_, rtää,
   {{0xa3e81133,0xb0660084,0x44261134,0xe8df0019}},	// [a50] _बाई_, stää, _mno_, _thừa_,
   {{0x7c2602dd,0x09e30081,0x387f1135,0x9f5902b6}},	//   _enkr, ন্না, _skur_, geså_,
   {{0x3a380305,0x999102c6,0x386d1136,0x00000000}},	//   _dorp_, _vozů_, _pjer_, --,
   {{0x44260517,0x67000134,0x3a3801b9,0xdb1d007b}},	//   _nno_, _ịkag, _eorp_, _pesä,
   {{0x8707001c,0x2b52007f,0x6d5a1137,0xaae200c3}},	//   تبال, czyc_, útav, _पियक,
   {{0x44261138,0xd12600e3,0x58d500c2,0xc1780138}},	//   _ano_, _كم_, _ногт, ngės_,
   {{0xe5a20b21,0x76431139,0x0445083c,0x386d0216}},	//   ниши, rkny, зейн, _tjer_,
   {{0x387f113a,0x442601b9,0x76430167,0x44f30231}},	//   _ukur_, _cno_, skny, rã_,
   {{0x27ff0124,0xa01b02c3,0x28af00a3,0x44f30231}},	//   _ibun_, glöm, _जूति, sã_,
   {{0x4426113b,0x00000000,0x00000000,0x00000000}},	//   _eno_, --, --, --,
   {{0xf8cb009f,0x05190076,0x44260565,0xfe7f00b3}},	//   ाठिय, _دياب_, _fno_, tuïn_,
   {{0x44d7002d,0xe8df0019,0xbbaa06eb,0xafdb09af}},	//   mă_, _chứa_, _कलेक, skøn,
   {{0x7d1e113c,0x644b113d,0x44d7002d,0x09e30081}},	//   _srps, _ilgi, lă_, ন্যা,
   {{0x629d030b,0x00000000,0x00000000,0x00000000}},	//   ůsob, --, --, --,
   {{0x44d70012,0x44260150,0x00000000,0x00000000}},	//   nă_, _yno_, --, --,
   {{0x09e30081,0x5baa113e,0x7af601ce,0x00000000}},	//   ন্মা, скам_, ttyt, --,
   {{0x78bb00e9,0xe9da0e4a,0xaca40134,0xeb97113f}},	// [a60] _čuva, йка_, _nhụt, зит_,
   {{0x27ff0044,0x3af402c3,0x6f04039f,0x6a8300d3}},	//   _abun_, räp_, _ipic, елуа,
   {{0xe8fa0f48,0x7af61140,0xaca40294,0x44d700d3}},	//   сле_, styt, _ahụt, jă_,
   {{0xa3ea000c,0xafdb0856,0x44d700d3,0xfaa61141}},	//   _टाइप_, lhør, dă_, _намо,
   {{0x7bc41142,0x442605db,0xf7431143,0x3a38032e}},	//   mbiu, _rno_, нецо, _torp_,
   {{0x644b0138,0x27ff0af0,0x44260973,0x7ae41144}},	//   _algi, _ebun_, _sno_, mrit,
   {{0x44d700d3,0x69dc00d6,0x290c028d,0xf8e00034}},	//   gă_, _idre, _èda_, _पटिय,
   {{0xb6030029,0x68e30fb6,0x69ce1145,0x6f040f1c}},	//   ēšan, ánde, _hebe, _opic,
   {{0x69ce03b4,0x7ae401ab,0x66e31146,0x22861147}},	//   _kebe, nrit, _пота, зунг,
   {{0x64aa000d,0x69ce0880,0x25fb0789,0xf3f900ae}},	//   _přid, _jebe, ल्दी_, riţa_,
   {{0x69ce1148,0x44d70012,0x7ae402e2,0x55bb00ca}},	//   _mebe, că_, hrit, _המבו,
   {{0x44261149,0x69ce114a,0x6f0400da,0x00000000}},	//   _uno_, _lebe, _bpic, --,
   {{0x69dc03ce,0xa8570327,0x69ce0113,0x00000000}},	//   _odre, ליטה_, _oebe, --,
   {{0x8cb10e72,0x69ce114b,0x6266114c,0xbeed114d}},	//   _आंदो, _nebe, _عاشق, _जमीन_,
   {{0x7ae4007a,0xd7cc009d,0x09e30081,0x01fb00ca}},	//   erit, ाराच, ন্ডা, _הפול,
   {{0x69dc114e,0x7ae4114f,0x69ce01e9,0xdb0d1150}},	//   _adre, frit, _aebe, scaí,
   {{0x69ce1151,0x44d70012,0x6fc31152,0x91fc01d3}},	// [a70] _bebe, ză_, _व्यं, ciāc,
   {{0x19ab001f,0x6d590022,0x200b1153,0x69ce1154}},	//   стап_, _ƙwad, leci_, _cebe,
   {{0x69ce1155,0x39471156,0x7ae4028d,0x5eed00c3}},	//   _debe, áns_, arit, _जमुई_,
   {{0x44d700d3,0x9cd600ca,0xf9900037,0x200b1157}},	//   vă_, _קורה_, ابك_, neci_,
   {{0xa2d80285,0x00000000,0x00000000,0x00000000}},	//   _मिग्, --, --, --,
   {{0x69ce1158,0x44d70012,0x1dbf0c9c,0x3cf80504}},	//   _gebe, tă_, ्रित, _بعید_,
   {{0x7bcf0496,0x78a2025b,0x200b0220,0xdb1d0220}},	//   _kecu, ňova, keci_, _nesú,
   {{0x44d70012,0x200b0ea3,0x27ff02e7,0xa01b0149}},	//   ră_, jeci_, _ubun_, slöj,
   {{0x44d7002d,0x1dbf009d,0x7bcf1159,0xd5b100de}},	//   să_, ्रात, _mecu, _các_,
   {{0xe0d9115a,0x44d700d3,0x69ce00a7,0x6ed7115b}},	//   ово_, pă_, _xebe, _बिजु,
   {{0x69c501b5,0x7ae40181,0x7bcf0381,0x741200d1}},	//   ibhe, zrit, _oecu, رویا,
   {{0xb92200ac,0x7bcf00d3,0x7ae400c2,0x6aa7029a}},	//   _akpọ_, _necu, yrit, _lijf,
   {{0x998300c6,0x00000000,0x00000000,0x00000000}},	//   _kojų_, --, --, --,
   {{0x09e30081,0x7ae4115c,0x3d0a0179,0xfe7f00ee}},	//   ন্তা, vrit, ाबले_, buïm_,
   {{0x7bcf115d,0xbea3115e,0xafdb00f2,0x200b115f}},	//   _becu, тарк, rhør, beci_,
   {{0x69ce1160,0xd9f01161,0xdd8f0c5e,0xb5fc02a1}},	//   _sebe, _चाहत_, شوق_, _imġe,
   {{0x78ae1162,0x7bcf1163,0xd910110a,0x69ce052f}},	// [a80] _subv, _decu, گیز_, _pebe,
   {{0x7ae41164,0x1cba003f,0xe8df0019,0x6aa70126}},	//   rrit, _واجب_, _chữa_, _cijf,
   {{0xfbc61165,0xdb1d03be,0x7bcf04c3,0x2d961166}},	//   _обно, _xesú, _fecu, _юрис,
   {{0xab2a1167,0x31360130,0x7bcf1168,0x6d620d2a}},	//   _дома_, ונעם_, _gecu, _ƙwaƙ,
   {{0x69ce1169,0x09e30081,0x394601d3,0xe737116a}},	//   _tebe, ন্ধা, ņos_, мец_,
   {{0x69dc116b,0x659400ae,0x69ce0364,0x200b116c}},	//   _udre, налу, _uebe, zeci_,
   {{0x693502c6,0xdb060537,0x00000000,0x00000000}},	//   _přeš, _afkø, --, --,
   {{0x64aa030b,0xdb1d0610,0x09e30033,0xd7060e2c}},	//   _přib, _resú, ন্দা, _озби,
   {{0x41e6116d,0x25fb116e,0x200b116f,0x64aa02c6}},	//   міна, ल्ही_, veci_, _břic,
   {{0xd2501170,0xd6260190,0x51f8004d,0xf5e700d3}},	//   اند_, _تعري, чною_, _омул_,
   {{0xa01b00c2,0x62830350,0x693502c6,0x63b900eb}},	//   llöi, _dkno, _třeš, _ffwn,
   {{0xa3e8000d,0xc32a00e3,0xd5b100fe,0x00000000}},	//   _बाट_, _وكان_, _tác_, --,
   {{0xa2d80251,0x7bcf1171,0x200b1172,0x67000285}},	//   _मिट्, _recu, reci_, ोबिक_,
   {{0x200b03ce,0x7bcf1173,0x00000000,0x00000000}},	//   seci_, _secu, --, --,
   {{0x38b704f9,0x6d550036,0x320c1174,0x200b1175}},	//   _oħra_, uzza, medy_, peci_,
   {{0xfc150077,0x28d81176,0x320c1177,0xa3c31178}},	//   эмбэ, _डिजि, ledy_, ्रय_,
   {{0x7bcf00d9,0x7b670b1b,0xfe1a1179,0x00000000}},	// [a90] _vecu, фтве, _फोकस_, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xa3c30961,0x1bd5117a,0x69c5117b,0x6aa70126}},	//   ्रम_, _поня, rbhe, _vijf,
   {{0x3f89006d,0x78a20031,0x6aa701cb,0x00000000}},	//   _kyau_, ňovn, _wijf, --,
   {{0x320c0181,0xa3e80caf,0x7d020542,0x7c3d033f}},	//   kedy_, _बाज_, _ćosi, _iosr,
   {{0x24510618,0x7aed0332,0x46e000aa,0xf1c70e43}},	//   _máme_, muat, _निरह, ďáky_,
   {{0x7aed09bc,0x82b80134,0xc984117c,0x7c3d02ac}},	//   luat, _rịịl_, _аути, _kosr,
   {{0xe7f9000d,0xdb1d0939,0xe8cb0096,0x00000000}},	//   _एउटा_, _besø, ाठीच, --,
   {{0x25a900cd,0x64aa00b6,0x3f890350,0x7c3d0216}},	//   _فضای_, _přic, _nyau_, _mosr,
   {{0x291e0138,0x4ae200b7,0x00000000,0x00000000}},	//   _štai_, _पिसव, --, --,
   {{0x7aed117d,0x3f890022,0x7c3d084e,0x00000000}},	//   huat, _ayau_, _oosr, --,
   {{0x7aed117e,0xdee6117f,0x1b060033,0x00000000}},	//   kuat, номи, রিতে_, --,
   {{0xe80102e8,0x7aed1180,0x64490364,0xd9f00096}},	//   ळ्या_, juat, mkei, _चालत_,
   {{0x443d0054,0x78a91181,0x644900c2,0x24510146}},	//   _how_, _liev, lkei, _dáme_,
   {{0x62811182,0xda020efb,0x7c3d1183,0x443d1184}},	//   molo, र्फत_, _bosr, _kow_,
   {{0x7aed068d,0x62811185,0x78a91186,0x64491187}},	//   fuat, lolo, _niev, nkei,
   {{0x3b070465,0xfe720068,0x7aed1188,0xadee009d}},	// [aa0] нето_, _مدد_, guat, _जाऊन_,
   {{0x9b9300e3,0x443d00a1,0x7c360120,0x09e30033}},	//   الكت, _low_, sjyr, ন্সা,
   {{0x64491189,0xd943004c,0xeabf01b9,0xef1800e8}},	//   kkei, лефи, _crùb_, āļu_,
   {{0x443d0054,0x7aed0808,0x78a90031,0x3eb204d6}},	//   _now_, buat, _ciev, _kuyt_,
   {{0x78a9118a,0x91fc00d9,0x7bd6118b,0x7aed118c}},	//   _diev, onāt, mayu, cuat,
   {{0x25fb0d0b,0x6281118d,0x7bd6118e,0x443d118f}},	//   ल्ली_, jolo, layu, _aow_,
   {{0x291e01cd,0x7c3d061d,0x3eb20f5a,0x443d1190}},	//   _éta_, _yosr, _luyt_, _bow_,
   {{0x644902dc,0x98a31191,0x78a91192,0x7bd61193}},	//   gkei, _бисе, _giev, nayu,
   {{0x0edc0ed3,0x57cc030b,0xa3b70037,0x68e10212}},	//   _बिगड, ारीह, راير_, _åldr,
   {{0x62811194,0x7bd61195,0xa68305da,0x00000000}},	//   golo, hayu, _блуд, --,
   {{0xa3b3030b,0x320c0206,0x75d30076,0x00000000}},	//   जुङ_, redy_, _إيما, --,
   {{0x44fa074a,0x661a00e7,0xa3c30efb,0x38661196}},	//   më_, _hatk, ्रण_, nior_,
   {{0x62811197,0xff041198,0x44fa00dd,0x661a1199}},	//   bolo, лярн, lë_, _katk,
   {{0x661a02fd,0x7c3d0479,0x386605bd,0x7bc2002b}},	//   _jatk, _sosr, hior_, ñoun,
   {{0x44fa074a,0x661a119a,0x7c3d011d,0x5ce403a0}},	//   në_, _matk, _posr, люта,
   {{0x7aed119b,0x7bd6119c,0x661a119d,0x6485119e}},	//   tuat, gayu, _latk, lóir,
   {{0x44fa00dd,0x78a9119f,0xeab30037,0x4ea711a0}},	// [ab0] hë_, _riev, اعر_, _проа,
   {{0x78a90029,0x44fa00dd,0xda7811a1,0x83fd0018}},	//   _siev, kë_, нях_, lnőt,
   {{0xdd9111a2,0x78a90029,0x7aed06ee,0x44fa01e5}},	//   _خود_, _piev, suat, jë_,
   {{0x648500e3,0x7aed11a3,0x44fa0052,0x7d01020a}},	//   hóir, puat, dë_, gârţ,
   {{0x628111a4,0x661a02ef,0xdb070084,0x44fa0185}},	//   yolo, _batk, ämäs, eë_,
   {{0x628111a5,0x99d4012b,0x443d11a6,0xa50900c9}},	//   xolo, _متفا, _sow_, дека_,
   {{0x628111a7,0x648500e3,0x44fa00dd,0x443d11a8}},	//   volo, dóir, gë_, _pow_,
   {{0x628111a9,0x386600d3,0xed640094,0x00000000}},	//   wolo, cior_, loží_, --,
   {{0x644911aa,0x661a023b,0x248603a9,0xf7730037}},	//   rkei, _fatk, _dkom_, _صار_,
   {{0x644911ab,0x69d708a8,0x648500e3,0x7bd60051}},	//   skei, naxe, góir, zayu,
   {{0xa3c300c3,0x7bd601af,0x44fa0052,0x03e30033}},	//   ्रद_, yayu, cë_, ক্ষী_,
   {{0x20040871,0xa3d20be4,0x628111ac,0xd5640528}},	//   ými_, वरण_, solo, _ступ,
   {{0x628111ad,0x249f11ae,0x6e3e007e,0x60c4033b}},	//   polo, mmum_, _popb, _čime,
   {{0x248d11af,0x63bb013d,0xfce611b0,0x9f610103}},	//   llem_, lcun, кого, ását_,
   {{0x7bd611b1,0xfc3f11b2,0x6d4711b3,0x8d6311b4}},	//   tayu, _boí_, gyja, авре,
   {{0xa3c311b5,0x00000000,0x00000000,0x00000000}},	//   ्रि_, --, --, --,
   {{0xdca311b6,0xcb6711b7,0x0b431102,0x7bd611b8}},	// [ac0] рати, вате_, антн, rayu,
   {{0x7bd611b9,0xbea611ba,0x6fa711bb,0x248d11bc}},	//   sayu, _шапк, _गणतं, hlem_,
   {{0x661a0084,0xfe3700a1,0xa3c305cd,0x7bd611bd}},	//   _ratk, _סרטי_, ्रा_, payu,
   {{0x44fa023b,0x076a0dce,0x5ee900c3,0xd5b10023}},	//   vë_, وماً_, _जिम्_, _báo_,
   {{0x248d11be,0x69ca003e,0x386611bf,0xd5b10023}},	//   dlem_, ðfes, rior_, _cáo_,
   {{0x44fa074a,0x629d1030,0x2ca000aa,0x00000000}},	//   të_, ïsol, lmid_, --,
   {{0x81d70081,0x38660212,0x661a00ce,0x00000000}},	//   িলা_, pior_, _vatk, --,
   {{0x44fa074a,0x29181114,0x439411c0,0xe4e30557}},	//   rë_, _isra_, лайс, _गिरि_,
   {{0x44fa074a,0x661a02e7,0x6d4700a5,0x648500e3}},	//   së_, _tatk, zyja, tóir,
   {{0x91fc0029,0x44fa023b,0x60c411c1,0xd05d0092}},	//   ciāl, pë_, _čimb, əyəc,
   {{0x672211c2,0x248d11c3,0x648500e3,0xb6a300ae}},	//   lvoj, blem_, róir, _тифл,
   {{0xdb0411c4,0x64850037,0x60da11c5,0x6d4708ac}},	//   nció, sóir, rstm, vyja,
   {{0x73360391,0xf09f0428,0xdb040328,0x657a009c}},	//   _جرائ, rmà_, ició, _hxth,
   {{0x52d700a1,0x201b005c,0x2ca000aa,0xc694006e}},	//   _יודע_, _waqi_, emid_, טאָ_,
   {{0x4fc70752,0x201b0161,0xdb040018,0x7e67029a}},	//   _испа, _taqi_, kció, rijp,
   {{0x57cc11c6,0x09cb11c7,0x5c740e3a,0x3f8500a7}},	//   ारोह, िर्य, алст, ğlub_,
   {{0x3a7500ae,0x6e450076,0x00000000,0x00000000}},	// [ad0] глар, _منظم, --, --,
   {{0x672202e6,0x68e30fb6,0x99d50dce,0x2ca011c8}},	//   dvoj, ándo, اقات, amid_,
   {{0xa3d2007d,0x248d055c,0x69d711c9,0x8af000a7}},	//   वरा_, ylem_, raxe, lzəl,
   {{0x69d711ca,0x69ca0088,0xa01b00a2,0x00000000}},	//   saxe, ðfer, mlös, --,
   {{0x7c2f11cb,0x64aa030b,0xd6db11cc,0xa01b11cd}},	//   _incr, _přin, фте_, llös,
   {{0xe29a00ef,0xdb0411ce,0xf3f900ae,0x45190927}},	//   _như_, ació, miţi_, еция_,
   {{0x91fc0029,0x58d411cf,0xa01b11d0,0xf3f9020a}},	//   riāl, _вост, nlös, liţi_,
   {{0xdb0411d1,0x69d511d2,0x332611d3,0xafdb00f2}},	//   cció, _heze, _brox_, ljøf,
   {{0x69d50068,0x248d11d4,0xa3e4030b,0xf3f900ae}},	//   _keze, rlem_, _भएर_, niţi_,
   {{0x69d511d5,0x63bb11d6,0xa3c311d7,0x248d11d8}},	//   _jeze, scun, ्रह_, slem_,
   {{0x10a611d9,0x69d511da,0xa06a11db,0x248d11dc}},	//   лион, _meze, еана_, plem_,
   {{0xcea907a6,0x69d511dd,0xf992040a,0x6d5903e3}},	//   _זי_, _leze, מרי_, _ƙwan,
   {{0x442f07c3,0xe28e11de,0x643a00ca,0xdb1d0143}},	//   _ing_, _га_, _רעננ, _mesó,
   {{0x69d511df,0xa01b01bf,0x7c2f11e0,0x764102ac}},	//   _neze, flös, _ancr, _joly,
   {{0x2d8c01c5,0xed5a0b99,0x442f1193,0x1d0702d8}},	//   æde_, хов_, _kng_, лери_,
   {{0x442f11e1,0xfe7f0428,0x09cd0033,0x61f1020a}},	//   _jng_, duïu_, _লাগা, şelă,
   {{0x69d511e2,0x2ca000aa,0x442f11e3,0x705301c3}},	// [ae0] _beze, rmid_, _mng_, _دنيا,
   {{0x442f0bb6,0x2ca011e4,0x00000000,0x00000000}},	//   _lng_, smid_, --, --,
   {{0x442f11e5,0x69d511e6,0x9d4611e7,0x499611e8}},	//   _ong_, _deze, _сенд, ушат,
   {{0x442f010a,0xf3f9020a,0xd7f7007e,0x00000000}},	//   _nng_, biţi_, гуш_, --,
   {{0xdb0409e9,0x69d511e9,0xdb1d037a,0x764111ea}},	//   rció, _feze, _desó, _boly,
   {{0x442f11eb,0x69d511ec,0x20d1031a,0x672211ed}},	//   _ang_, _geze, kši_, rvoj,
   {{0xdb0411ce,0x442f0933,0x20d10b27,0x672211ee}},	//   pció, _bng_, jši_, svoj,
   {{0x332611ef,0x44de003d,0x69d511f0,0x26c611f1}},	//   _prox_, rċ_, _zeze, ppoo_,
   {{0x76410068,0x442f11f2,0x3254002d,0x78a20036}},	//   _foly, _dng_, ивир, mmov,
   {{0x764102ad,0x78a211f3,0xdb040042,0xda14007f}},	//   _goly, lmov, nciñ, ड़ित_,
   {{0xd48f11f4,0x2d8c00a5,0x741300cd,0x6244009c}},	//   _гр_, żdej_, _گونا, _bòor,
   {{0xd0e5000c,0x78a20328,0x442f00f9,0x4254001c}},	//   _किरण_, nmov, _gng_, انگر,
   {{0xe29a0028,0xdd2500d9,0x78a2016d,0x9f59037a}},	//   _thư_, dīša, imov, vesó_,
   {{0x98bc030b,0x64421183,0x20d1033b,0xdddc020a}},	//   ávě_, _hooi, bši_, vorţ,
   {{0x442f02e0,0x78a202dd,0xfe7f05fe,0x6442029a}},	//   _yng_, kmov, duït_, _kooi,
   {{0x78a200cb,0xf3f900ae,0x69d511f5,0xda02009f}},	//   jmov, tiţi_, _seze, र्सत_,
   {{0x64420272,0x90980a09,0xa01b0f3a,0x69d501e9}},	// [af0] _mooi, _حضور_, slös, _peze,
   {{0xf3f900d3,0xdb1d015e,0xa01b0212,0x9f400364}},	//   riţi_, _besò, plös, _heiß_,
   {{0x69d511f6,0x391511f7,0x985100a5,0x57b511f8}},	//   _veze, рмер, nąć_, абет,
   {{0x64420db8,0x69d511f9,0x6f0d0294,0xdddc00ae}},	//   _nooi, _weze, _kpac, porţ,
   {{0x7bda03c2,0xfe7f0428,0x2d9c0031,0xf6e70aec}},	//   _בקרו, buït_, _úver_, уцен,
   {{0x7aed11fa,0xf62511fb,0x7bcd11fc,0xc8d700b9}},	//   mrat, рдко, lbau, _مزرع,
   {{0xe3b1054f,0x7a4100b6,0x764111fd,0x98510034}},	//   يرة_, _vítě, _voly, jąć_,
   {{0x20d100e9,0x130902ec,0x7bcd11fe,0x7aed11ff}},	//   vši_, вний_, nbau, orat,
   {{0x64421200,0x442f1201,0x7aed1202,0x2bb81203}},	//   _dooi, _vng_, nrat, _अलसा,
   {{0x248000e9,0x7aed1204,0x6aae01fa,0x212709a4}},	//   čima_, irat, _xibf, _prnh_,
   {{0x27e0003e,0x29011205,0xdddc0542,0x7aed1206}},	//   ðing_, ntha_, jorš, hrat,
   {{0x442f1207,0x20d11208,0x67291209,0x644201c0}},	//   _ung_, rši_, _krej, _gooi,
   {{0x7aed00e7,0x99980117,0xe3ae120a,0x00000000}},	//   jrat, _morš_, _фб_, --,
   {{0x8cb10034,0x78a20094,0x6729120b,0x644201cb}},	//   _आंखो, zmov, _mrej, _zooi,
   {{0xada6120c,0xdb120682,0x6da610ab,0xdd2500d9}},	//   равл, _ágús, рива, tīša,
   {{0x3b000078,0x6729120d,0x7bcd120e,0xdb1d022b}},	//   ttiq_, _orej, gbau, _resò,
   {{0xfe7f05fe,0x7aed120f,0xdd2500d9,0x2d851210}},	// [b00] tuït_, grat, rīša, üler_,
   {{0x2bb8007d,0x09e61211,0xdd2501d3,0x99580206}},	//   _अलवा, рожн, sīša, ráža_,
   {{0x290100e3,0x7aed1212,0xaa7b00b6,0x78a21213}},	//   gtha_, arat, _svýc, tmov,
   {{0x67291214,0x64aa02c6,0xafdb0537,0x00000000}},	//   _brej, _přim, lkør, --,
   {{0x2bd3110f,0x78a2025b,0x29010091,0x64421215}},	//   तररा, rmov, atha_, _rooi,
   {{0x6729074a,0x29011216,0x64421217,0x2458014b}},	//   _drej, btha_, _sooi, _méme_,
   {{0x25080177,0xafdb038c,0x29010037,0xa3c300ec}},	//   ارتی_, ljøe, ctha_, ्रं_,
   {{0x67291135,0x249d030a,0x916800fe,0x68e3044c}},	//   _frej, _chwm_, _lực_, ânde,
   {{0x67291218,0xa2b300c2,0xd1ca1219,0x00000000}},	//   _grej, обыч, кунд_, --,
   {{0x1663121a,0x32540a3a,0x6f0d01b9,0x26c0044c}},	//   _двум, свор, _rpac, ţios_,
   {{0x6f0d121b,0x67290220,0x91a900de,0x7bcd0138}},	//   _spac, _zrej, _đã_, ybau,
   {{0xa3c30be5,0x7aed0077,0x5067121c,0x00000000}},	//   ्रः_, yrat, ртоа, --,
   {{0xfe7f015e,0x00000000,0x00000000,0x00000000}},	//   duïr_, --, --, --,
   {{0x7aed02c8,0x9f4002e2,0x2d8401e8,0x69d80088}},	//   vrat, _weiß_, ğmen_, ðvel,
   {{0x25fb121d,0x7aed00bd,0xa3bd06ec,0x7bcd042c}},	//   ल्टी_, wrat, _आलम_, tbau,
   {{0x7aed121e,0x20090063,0x228b0120,0x00000000}},	//   trat, _ubai_, søkt_, --,
   {{0x7bcd121f,0x6f0d1084,0x64aa030b,0x451c0081}},	// [b10] rbau, _upac, _přij, থমিক_,
   {{0x62880150,0xe9ab0688,0x29010063,0xab841220}},	//   nodo, ندان_, ttha_, цуск,
   {{0x6729007e,0x3947020a,0x00000000,0x00000000}},	//   _srej, âns_, --, --,
   {{0x67291221,0x62881222,0x7aed1223,0x29011224}},	//   _prej, hodo, prat, rtha_,
   {{0x29011225,0xdc360266,0x32051226,0xdd2800e8}},	//   stha_, _הארט_, yfly_, mēša,
   {{0xb6071227,0xdd2800d9,0x62880167,0x29010037}},	//   рядк, lēša, jodo, ptha_,
   {{0x62881228,0xd4691229,0x48ab01b6,0x67290090}},	//   dodo, лике_, _атам_, _wrej,
   {{0x6729122a,0xfd550134,0xdd2801d3,0x00000000}},	//   _trej, _slaị, nēša, --,
   {{0x672902dd,0x9f4407aa,0x62880150,0x3205122b}},	//   _urej, ümü_, fodo, tfly_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xf5950080,0x00000000,0x00000000,0x00000000}},	//   _الاج, --, --, --,
   {{0x20560109,0x237d022e,0xb7bd078e,0x00000000}},	//   стор, _txwj_, _faţe, --,
   {{0x6288122c,0x443f122d,0x645b0527,0xdd2801d3}},	//   bodo, mju_, mhui, dēša,
   {{0xb6cc03e0,0x645b122e,0x00000000,0x00000000}},	//   _şükü, lhui, --, --,
   {{0xc6920341,0x443f0138,0xdd920602,0xafdb00f2}},	//   פאל_, oju_, سور_, rkør,
   {{0x645b122f,0x78a30a9f,0xd5b10023,0x24580031}},	//   nhui, ïnvl, _cái_, _téme_,
   {{0xbbb8009d,0x8c431230,0x09e600d3,0x645b084e}},	// [b20] _अलीक, чете, йоан, ihui,
   {{0x443f007a,0x3f920d2a,0x64aa00b6,0xe9d71231}},	//   hju_, _iyyu_, _přik, йку_,
   {{0x645b0371,0x09060d86,0x395f01c2,0x499a0109}},	//   khui, спен, _ƙusa_, утая_,
   {{0x443f1232,0xdd2801d3,0xb8eb0018,0xd5b100fe}},	//   jju_, cēša, ابلے_, _gái_,
   {{0x443f1233,0xf3ff0081,0x645b1234,0xb9210294}},	//   dju_, ্যার_, dhui, _kasị_,
   {{0x7c241235,0x443f1236,0x645b1237,0x64aa00d2}},	//   ldir, eju_, ehui, _třik,
   {{0x62880941,0xb9210134,0x69de1238,0x645b1239}},	//   vodo, _masị_, mape, fhui,
   {{0x7c241151,0xa3a900c0,0x628800a5,0x24800128}},	//   ndir, _गृह_, wodo, čimo_,
   {{0x35fa0391,0x98a300ae,0x938a065c,0x55e6123a}},	//   _مراد_, _хите, ыска_, _гозб,
   {{0x443f0af0,0x69de123b,0xdd2801d3,0x05070033}},	//   aju_, nape, zēša, লয়ের_,
   {{0x443f123c,0x7c240345,0x81b00033,0x00000000}},	//   bju_, kdir, টুন_, --,
   {{0x443f0580,0x645b123d,0x69de123e,0x320200b6}},	//   cju_, chui, hape, řky_,
   {{0x6288123f,0x69de1240,0x7c241241,0x09e30081}},	//   podo, kape, ddir, ন্টা,
   {{0x3dd900c7,0xdce50220,0x69de1242,0x5eb80033}},	//   _তাহল, _vzhľ, jape, _অবশে,
   {{0x69de1243,0x64aa000d,0x26001244,0xd12f11cf}},	//   dape, _přih, _रानी_, _эх_,
   {{0x7c241245,0x60c700b6,0x67ef0139,0x00000000}},	//   gdir, íjme, _mòjà, --,
   {{0xdd2800d9,0x7d1e0124,0xeabf00de,0xf3fa0033}},	// [b30] rēša, _esps, _trùm_, _আসার_,
   {{0x443f03e5,0x7b7400e3,0xb92100ac,0x69de1246}},	//   zju_, أطفا, _gasị_, gape,
   {{0x7c241247,0x984b1248,0xdd2800e8,0x6d4e0027}},	//   bdir, ляда_, pēša, cyba,
   {{0x19a81249,0x987c02c6,0x00000000,0x00000000}},	//   ступ_, bíč_, --, --,
   {{0x443f124a,0x69de124b,0xe739124c,0x00000000}},	//   vju_, bape, рел_, --,
   {{0xdb1d070a,0x7bdf124d,0xd629124e,0x1b060033}},	//   _besö, laqu, роке_, রিখে_,
   {{0x443f124f,0xf53200c9,0x845900d3,0x3eb31250}},	//   tju_, дејќ, ирит_, _mixt_,
   {{0x7bdf1251,0x443f0d7c,0x94790284,0x00000000}},	//   naqu, uju_, јску_, --,
   {{0x443f1252,0x645b03ee,0xa5f90291,0x727900ae}},	//   rju_, rhui, _везу_, исос_,
   {{0x443f1253,0x645b1254,0xdd1c0146,0x7c241255}},	//   sju_, shui, váže, zdir,
   {{0x443f1256,0x9327015a,0x614510f5,0x7c240342}},	//   pju_, _گران, цена, ydir,
   {{0x69de1257,0x1faa04e6,0x60cd02ef,0x80b80033}},	//   zape, икни_, _čamd, _আবশ্,
   {{0x7bdf1258,0x93270281,0x645902a1,0x69de024a}},	//   daqu, _دران, _ilwi, yape,
   {{0xda0b0251,0x6d4e1259,0xdd1c1054,0x02a700d3}},	//   स्मत_, tyba, ráže, _урем,
   {{0xa3bd02e8,0x7bdf023b,0x69de125a,0x7c240abd}},	//   _आला_, faqu, vape, tdir,
   {{0x69de125b,0xdb1d016d,0x7c240036,0x6d4e00c6}},	//   wape, _lesõ, udir, ryba,
   {{0xe9da125c,0x7c24125d,0x200501d4,0xf412028c}},	// [b40] ика_, rdir, əli_, ופן_,
   {{0x22470313,0x7c24125e,0x4996125f,0xee0a00ae}},	//   _jonk_, sdir, ошет, _теол_,
   {{0x69de1260,0x6da6123a,0x8c461261,0xdd0f01e8}},	//   rape, _фина, _дене, mışt,
   {{0xdd0f01e8,0x7c2400a7,0x9f4800de,0x7bdf0db4}},	//   lışt, qdir, _điêu_, caqu,
   {{0xcfbc0081,0x64aa02c6,0xfaa61262,0xd5b1020b}},	//   _অজান, _křiv, _мамо, _máu_,
   {{0x7ae40037,0x645902a1,0x2bb80174,0xdd0f0233}},	//   msit, _alwi, _ọch_, nışt,
   {{0xd90d0177,0x7ae400e3,0x81cf0081,0x261b030b}},	//   _میل_, lsit, ষণা_, _यसरी_,
   {{0x7bc41263,0xfd530af0,0x7ae41264,0xdb1d00b7}},	//   nciu, _aifọ, osit, _eesõ,
   {{0x69dc0281,0x7ae41265,0x22471266,0xdd0f0233}},	//   _kere, nsit, _bonk_, kışt,
   {{0x24510037,0x2000009c,0x7ae41267,0x64590178}},	//   _lámh_, _acii_, isit, _elwi,
   {{0x69dc1268,0x22471269,0x7bdf126a,0xd25708a1}},	//   _mere, _donk_, yaqu, іць_,
   {{0x69dc126b,0x7ae4126c,0xe0cf0688,0x6618126d}},	//   _lere, ksit, کزی_, levk,
   {{0x76480167,0xfd530065,0x2005007f,0xf4870a85}},	//   _kody, _fifọ, ęli_, _بالی,
   {{0x24890220,0x7bc6126e,0x76480383,0x00000000}},	//   čame_, _afku, _jody, --,
   {{0x7bdf0257,0x2bc80294,0x7648126f,0x7ae41270}},	//   taqu, _ọjị_, _mody, esit,
   {{0x69dc008f,0x3ced1271,0x67200fa3,0x6ca41272}},	//   _aere, čev_, _osmj, друж,
   {{0x69dc1273,0x20191274,0x7ae407ac,0x7bdf1275}},	// [b50] _bere, mesi_, gsit, raqu,
   {{0x20191276,0x69dc1173,0x66180ebd,0x7bc40451}},	//   lesi_, _cere, jevk, aciu,
   {{0x69dc0170,0x7bdf1277,0x48151278,0x78bc1279}},	//   _dere, paqu, змес, _curv,
   {{0x765a127a,0x2019127b,0x78bc127c,0x7ae4127d}},	//   _alty, nesi_, _durv, bsit,
   {{0x2ca9127e,0x27e00088,0x69dc127f,0x7bdd01ff}},	//   mmad_, ðina_, _fere, _iesu,
   {{0x69dc1280,0x7bdd1281,0x2ca91282,0xc9870408}},	//   _gere, _hesu, lmad_, _дуби,
   {{0x69c51283,0x7bdd06e1,0x6e2502a1,0x20191284}},	//   mche, _kesu, _mahb, kesi_,
   {{0x69c51285,0x7bdd1286,0x7d7c00c1,0x69dc1287}},	//   lche, _jesu, ינוו, _zere,
   {{0x2bdc007d,0x7bdd1288,0x69dc1289,0x76d500e3}},	//   बरता, _mesu, _yere, _رياض,
   {{0x69dc128a,0x69c5128b,0x7bdd128c,0x09af0081}},	//   _xere, nche, _lesu, _চ্যা,
   {{0x69c5128d,0x2019128e,0x224701d0,0x386d0113}},	//   iche, fesi_, _vonk_, _kmer_,
   {{0x2458128f,0x7bdd01b3,0x20191290,0x69c51291}},	//   _téma_, _nesu, gesi_, hche,
   {{0x24511292,0x64aa00b6,0x69c51293,0x271d0154}},	//   _námi_, _přiv, kche, _jňn_,
   {{0x6e251294,0x69c51295,0x248d0629,0x68e70344}},	//   _cahb, jche, loem_, _ovjd,
   {{0x61e102fd,0x20191296,0x7bdd1297,0xdca603fc}},	//   mall, besi_, _besu, зави,
   {{0x7ae41298,0x20191299,0x61e1129a,0x248d0185}},	//   tsit, cesi_, lall, noem_,
   {{0x69dc129b,0x7bdd052f,0x7bc40018,0x2d9e025b}},	// [b60] _pere, _desu, rciu, ťte_,
   {{0x7bc4013d,0xba23129c,0x78bc129d,0xada6129e}},	//   sciu, ндук, _purv, _напл,
   {{0x7ae4129f,0x7648013f,0xda020be4,0x7bc412a0}},	//   ssit, _rody, र्गत_, pciu,
   {{0x69dc12a1,0x61e112a2,0x7bdd12a3,0x7ae412a4}},	//   _were, hall, _gesu, psit,
   {{0x61e10e1d,0x387f0149,0x69c512a5,0x764812a6}},	//   kall, _djur_, bche, _pody,
   {{0x69c5013d,0x78bc0d80,0x61e112a7,0x7bdd07f5}},	//   cche, _turv, jall, _zesu,
   {{0x201912a8,0x20c100ef,0x7bdd12a9,0x7c2612aa}},	//   yesi_, _nói_, _yesu, _kakr,
   {{0xadc30065,0x7bdd0042,0x6d4100c2,0x066601f3}},	//   _diẹd, _xesu, älai, _کارپ,
   {{0x66180038,0x61e112ab,0x201912ac,0x67200ea3}},	//   pevk, fall, vesi_, _usmj,
   {{0x201912ad,0x61e112ae,0x20c10023,0x3f850233}},	//   wesi_, gall, _bói_, şluk_,
   {{0x201912af,0x60cd08a9,0x6e2512b0,0x69c30087}},	//   tesi_, _čamc, _rahb, žneg,
   {{0x7c2612b1,0xe3a70018,0xb6060146,0x20c1016d}},	//   _nakr, _کشمی, _dráž, _dói_,
   {{0x61e112b2,0x201912b3,0xaa7b00b6,0x6d4802c3}},	//   ball, resi_, _svým, ädan,
   {{0x7bdd03b4,0x442612b4,0x61e112b5,0x8ca20034}},	//   _sesu, _hao_, call, _कीबो,
   {{0x442602e6,0x20c10019,0x7bdd0fc4,0x201912b6}},	//   _kao_, _gói_, _pesu, pesi_,
   {{0x7c2612b7,0x6e250063,0x6abd12b8,0x201912b9}},	//   _cakr, _wahb, _pusf, qesi_,
   {{0xd6d70f71,0x442612ba,0x69c512bb,0x2ca912bc}},	// [b70] _সম্প, _mao_, tche, rmad_,
   {{0x442612bd,0x27e00102,0x69c512be,0x386d12bf}},	//   _lao_, ðinn_, uche, _smer_,
   {{0x69c505d7,0x7bdd12c0,0x29190397,0xfaa80037}},	//   rche, _tesu, تقاد_, أهلي_,
   {{0x69c512c1,0x442612c2,0xd75900e3,0x61e112c3}},	//   sche, _nao_, يلات_, zall,
   {{0x69c512c4,0x61e100ad,0x68e50063,0x79950034}},	//   pche, yall, sshd, _wyzw,
   {{0x7c2612c5,0x61e112c6,0xf1ba0023,0x660d015c}},	//   _zakr, xall, _ngơ_, đako,
   {{0x44260028,0x7c3a0076,0x387f12c7,0x00000000}},	//   _bao_, _úcrá, _tjur_, --,
   {{0x442600ef,0x61e112c8,0x2458020d,0x45180120}},	//   _cao_, wall, _démo_, яція_,
   {{0x61e112c9,0x27ed12ca,0x20c10023,0x248d12cb}},	//   tall, _iden_, _sói_, roem_,
   {{0x81bc01d3,0x25a002c6,0x442612cc,0x7ea012cd}},	//   ldēj, řila_, _eao_, köpa,
   {{0x26cd0284,0x61e112ce,0x355506fa,0x64aa00b6}},	//   _hteo_, rall, _تناز, _přit,
   {{0x61e112cf,0xd36e00bf,0x81bc00e8,0x20e70559}},	//   sall, اهی_, ndēj, rđi_,
   {{0x61e112d0,0xe28e12d1,0x7c2612d2,0x00000000}},	//   pall, _аа_, _rakr, --,
   {{0x4426068d,0x6da612d3,0xafdb00f2,0x61e112d4}},	//   _zao_, дига, ljøl, qall,
   {{0x4426068d,0x7c26013f,0x644b0044,0xb6060094}},	//   _yao_, _pakr, _kogi, _uráž,
   {{0x26cd0542,0x442600de,0x8af000a7,0x27ed0233}},	//   _oteo_, _xao_, yyəd, _nden_,
   {{0x1e860508,0x644b12d5,0xeb9712d6,0x7c26004d}},	// [b80] _олим, _mogi, дит_, _vakr,
   {{0x7c260051,0x27ed12d7,0x2480033b,0x6d590022}},	//   _wakr, _aden_, čimi_, _ƙwat,
   {{0x7c2612d8,0xa3bd009d,0xafdb0120,0xf3e80033}},	//   _takr, _आलं_, kjøl, ক্টর_,
   {{0x644b12d9,0xd7ef0037,0xdb0d00d4,0x00000000}},	//   _nogi, لكم_, škán, --,
   {{0x44260028,0xdd8f001c,0xdb1d02b6,0x47360037}},	//   _rao_, _موی_, _afsæ, براز,
   {{0x442612da,0x27ed12db,0xdd1d033d,0x644b009c}},	//   _sao_, _eden_, lášt, _aogi,
   {{0x7af612dc,0x22990113,0x00000000,0x00000000}},	//   lryt, mèkh_, --, --,
   {{0xe9a312dd,0x644b12de,0x7af60034,0xfc3f00fe}},	//   _расп, _cogi, oryt, _khía_,
   {{0x442612df,0x60cd0335,0x84ea0abe,0x644b05bd}},	//   _vao_, _čama, _टिकट_, _dogi,
   {{0x4426068d,0x2489005f,0x64aa030b,0x65790037}},	//   _wao_, čama_, _přis, ábhá,
   {{0x442612e0,0x09f70054,0xd48f0012,0x9f4203a9}},	//   _tao_, ומים_, _ар_, lakè_,
   {{0xdbd603cf,0x644b00eb,0x00000000,0x00000000}},	//   _jääd, _gogi, --, --,
   {{0xfe73012b,0x00000000,0x00000000,0x00000000}},	//   ندس_, --, --, --,
   {{0x63a212e1,0x7af612e2,0x245100d4,0x00000000}},	//   _izon, dryt, _dámu_, --,
   {{0xdd9401b3,0xafdb01df,0xdc14020e,0x00000000}},	//   вары, ljøm, _ağız, --,
   {{0xaa7b025b,0x7af6023b,0x7bd6084e,0x9f4201dc}},	//   _zvýh, fryt, gbyu, kakè_,
   {{0xf09400a1,0x5a35008f,0x78c40129,0xfc3f034f}},	// [b90] _בנק_, ннат, _ịkpọ_, _chía_,
   {{0x3b090090,0x00000000,0x00000000,0x00000000}},	//   rtaq_, --, --, --,
   {{0x80e00081,0xdb0d0143,0x0fe3007f,0x3b0912e3}},	//   পূর্, rcañ, परपढ, staq_,
   {{0x7af612e4,0xc19b00ca,0xdb0d037a,0x00000000}},	//   bryt, חשבי, scañ, --,
   {{0x6d550103,0xa3c212e5,0x81bc00e8,0x63a212e6}},	//   lyza, ंशन_, rdēj, _nzon,
   {{0xe5a512e7,0x00000000,0x00000000,0x00000000}},	//   нили, --, --, --,
   {{0x63a20068,0x629a12e8,0x00000000,0x00000000}},	//   _azon, dlto, --, --,
   {{0x032512e9,0x27ed0021,0x63a20078,0x629a12ea}},	//   един, _uden_, _bzon, elto,
   {{0xe61012eb,0x64aa00b6,0x59b90034,0x200c0103}},	//   _چشم_, _přir, ेडकर, ődik_,
   {{0x63a212ec,0x60c70220,0x64b101d3,0x24510094}},	//   _dzon, íjmo, _jāiz, _rámu_,
   {{0x9f42001c,0x644b0172,0x63a212ed,0x00000000}},	//   maké_, _togi, _ezon, --,
   {{0xe7300068,0x644b00c6,0x2cb901b9,0x200412ee}},	//   _حصہ_, _uogi, _nisd_, ümi_,
   {{0x63880052,0x00000000,0x00000000,0x00000000}},	//   rënë, --, --, --,
   {{0x2cb901b9,0x60c40117,0x22990113,0x00000000}},	//   _aisd_, _čimv, kèki_, --,
   {{0x40960562,0xdd92046b,0x9f4203a9,0x00000000}},	//   _прит, اوز_, iaké_, --,
   {{0xfc3f0019,0x9f4200bf,0x6d590044,0x7af612ef}},	//   _phía_, haké_, _ƙwar, tryt,
   {{0x9f420979,0x7bd600f9,0x63a212f0,0x00000000}},	// [ba0] kaké_, rbyu, _xzon, --,
   {{0x9f42025b,0xdbd600c2,0xcfb700ca,0x2cb901ec}},	//   jaké_, _sääd, _אלפי_, _eisd_,
   {{0xdbd612f1,0x9f4200d1,0x69a512f2,0x00000000}},	//   _pääd, daké_, _करणी, --,
   {{0x27e012f3,0x20020991,0xe3a70391,0xfc3f00fe}},	//   úin_, ngki_, _مر_, _thía_,
   {{0x81d60033,0xb9070285,0x9f4200d1,0x00000000}},	//   িণত_, _मौ_, faké_, --,
   {{0xae040096,0x9f42001c,0x00000000,0x00000000}},	//   श्चन_, gaké_, --, --,
   {{0xa9a3007e,0x245101cd,0x22990113,0xfc3f00da}},	//   _бирд, _náms_, cèki_, _mhín_,
   {{0x25a000b6,0x2bd3030b,0x69a512f4,0x2ba709a1}},	//   řilo_, धुपा, _करती, _खरमा,
   {{0x087700c1,0xb5fc009e,0x27e612f5,0x68fe01b6}},	//   _נעמט_, _alġe, maon_, lupd,
   {{0x27e612f6,0x3eba12f7,0x9f4203a9,0x00000000}},	//   laon_, _nipt_, caké_, --,
   {{0xd5a40b94,0x64a612f8,0x00000000,0x00000000}},	//   _ओरिज, _зажа, --, --,
   {{0x27e612f9,0x25a1042c,0x63a20350,0x8386007b}},	//   naon_, ühle_, _tzon, _пыле,
   {{0x3ce30096,0xf1d100b6,0x2cb90027,0xafdb00f2}},	//   टीने_, _द्वन, _risd_, ljøk,
   {{0xfc3f00de,0x6d550034,0x27e6019c,0x291800bd}},	//   _chín_, tyza, haon_, _opra_,
   {{0x321e109b,0x27e6019c,0x7e7512fa,0x00000000}},	//   mety_, kaon_, rizp, --,
   {{0x6d5500a5,0x321e12fb,0xfc3f0032,0x2d9a00f3}},	//   ryza, lety_, _ehín_, _dype_,
   {{0x200c01d4,0x29180036,0x00000000,0x00000000}},	// [bb0] ədi_, _apra_, --, --,
   {{0x9e670037,0x321e12fc,0xafdb00f3,0x6d4100ce}},	//   _ساخن, nety_, kjøk, älas,
   {{0xa3e00ccb,0xa3c2046e,0x23c70065,0xfe7f00b3}},	//   थरा_, ्डा_, _jíjó_, duïx_,
   {{0x29180167,0xab5b0956,0x69d801cd,0x00000000}},	//   _dpra_, _agüe, ðver, --,
   {{0x321e025b,0x7c2d12fd,0x58b80037,0xe758004d}},	//   kety_, mdar, رامج_, ниці_,
   {{0x7c2d12fe,0xf6d400d1,0x00000000,0x00000000}},	//   ldar, ازند, --, --,
   {{0x64aa000d,0xc9840752,0x27e612ff,0x9f4200cd}},	//   _přip, _бути, baon_, raké_,
   {{0x248906b8,0x3d19007f,0x00000000,0x00000000}},	//   čamo_, _पहने_, --, --,
   {{0x9f4200cd,0x130600c2,0xfd620139,0x321e00a1}},	//   paké_, вный_, _buwọ, fety_,
   {{0xa7741300,0x7c2d1301,0x64aa0022,0x68e102b6}},	//   _случ, hdar, _aƙid, _ælds,
   {{0x320b00a5,0x7c2d1302,0x00000000,0x00000000}},	//   ęcy_, kdar, --, --,
   {{0x7c2d1303,0x26df0129,0x00000000,0x00000000}},	//   jdar, _kwuo_, --, --,
   {{0x7c2d1304,0x442d0902,0xf8b20130,0xe813009d}},	//   ddar, mde_, ישט_, ण्या_,
   {{0x64491305,0x2d9a0f5a,0x443d0381,0x00000000}},	//   ljei, _pype_, _hnw_, --,
   {{0x1d070b1e,0xfc3f0072,0x2d9a1306,0x67220034}},	//   кери_, _chío_, _qype_, zwoj,
   {{0x7c2d0bb6,0x61e31307,0x645b00c2,0x644911e9}},	//   gdar, _henl, nkui, njei,
   {{0xc05300a1,0x62810449,0x3eba01cb,0x61e30227}},	// [bc0] _כזה_, onlo, _tipt_, _kenl,
   {{0x442d02fd,0x60c31308,0x7c2d1309,0x6281130a}},	//   hde_, _kunm, adar, nnlo,
   {{0x27e60d3d,0x442d130b,0x7c2d130c,0xbf9b016d}},	//   taon_, kde_, bdar, ngên,
   {{0x442d130d,0x38600080,0x68fe0085,0x61e3130e}},	//   jde_, óir_, rupd, _lenl,
   {{0x442d130f,0xe1e703ed,0x27e61310,0xf11e00c0}},	//   dde_, _پس_, raon_, _बन्द_,
   {{0x442d1311,0x27e6019c,0x443d0381,0x645b084e}},	//   ede_, saon_, _anw_, ekui,
   {{0x442d0db8,0xa8061312,0x60c30364,0x321e00d4}},	//   fde_, _извл, _nunm, vety_,
   {{0x78bb078e,0x6abb0072,0x24580139,0x443d00fc}},	//   _giuv, _éufr, _kémi_, _cnw_,
   {{0x68e101c5,0x26df0174,0xd70700d3,0x799c0150}},	//   _ældr, _gwuo_, _инте_, _hyrw,
   {{0x386600c9,0x7c2d1313,0x443d02ad,0x61e31314}},	//   lhor_, zdar, _enw_, _cenl,
   {{0x26c41315,0x442d01df,0x7c2d1316,0xa5d81317}},	//   _humo_, bde_, ydar, _न्यौ,
   {{0xf9930054,0x3866001f,0x68e312c0,0x78a90052}},	//   ירת_, nhor_, ândi, _xhev,
   {{0x26090789,0x321e12fb,0x61e31318,0x69ce003e}},	//   _सामी_, pety_, _fenl, _ofbe,
   {{0xdce50038,0x27e4002d,0x61e31319,0x60c30139}},	//   _vyhľ, _lemn_, _genl, _funm,
   {{0x61e8131a,0xac19131b,0xa3e6009f,0x40350f80}},	//   madl, нову_, _बजा_, _бейс,
   {{0xfbd303ed,0x69ce0ab2,0x7c2d10d3,0x24580139}},	//   شتر_, _afbe, udar, _bémi_,
   {{0x3866131c,0x6d4a01b9,0x00000000,0x00000000}},	// [bd0] dhor_, _àfan, --, --,
   {{0x442d131d,0xf09f0472,0xa2c30179,0x78bb0138}},	//   zde_, llà_, रदत्, _siuv,
   {{0x442d131e,0x9f4e0018,0x6abc131f,0x7c2d0325}},	//   yde_, önöm_, _dirf, pdar,
   {{0x61e81320,0x2486084f,0x7c2d1321,0x26c40344}},	//   hadl, _njom_, qdar, _bumo_,
   {{0x442d1322,0x61e81323,0xdbd100aa,0x3707004c}},	//   vde_, kadl, _müüd, тчев,
   {{0x442d1324,0x6abc0090,0x26c401ee,0x6a6001cd}},	//   wde_, _girf, _dumo_, _höfn,
   {{0x2609009d,0x61e81325,0x442d1326,0x26c400b3}},	//   _साठी_, dadl, tde_, _eumo_,
   {{0x6281051f,0x61e31327,0x29011328,0x26c41329}},	//   wnlo, _senl, muha_, _fumo_,
   {{0x442d132a,0x60c3132b,0x7aed0e78,0x645b132c}},	//   rde_, _sunm, nsat, rkui,
   {{0x442d132d,0xb7bd002d,0x6729132e,0x645b132f}},	//   sde_, _naţi, _isej, skui,
   {{0x61e31330,0x29011331,0x442d1332,0x26c41333}},	//   _venl, nuha_, pde_, _zumo_,
   {{0x44e101b3,0xbf9b0396,0x83350fba,0x26c40a4b}},	//   mų_, rgên, _مرتض, _yumo_,
   {{0x44e1013f,0x27e001ab,0x61e81334,0x6b9d01df}},	//   lų_, ðini_, badl, _nysg,
   {{0x249f1335,0x29011336,0x7aed1337,0x3f9e00d9}},	//   llum_, kuha_, dsat, ātu_,
   {{0x44e101b3,0x7aed01ee,0x00000000,0x00000000}},	//   nų_, esat, --, --,
   {{0xa3e60251,0x29011338,0xc0061339,0xf09f00b3}},	//   _बड़ा_, duha_, _спик, clà_,
   {{0xfc3f0074,0x7aed133a,0xcb67133b,0x06d80033}},	// [be0] _dní_, gsat, гате_, _সিভি,
   {{0x44e101b3,0xfeba0241,0x6b9d02ad,0x27e400ae}},	//   kų_, _ثابت_, _dysg, _semn_,
   {{0x44e101b3,0x249f133c,0x3e660257,0x386600a1}},	//   jų_, klum_, _côte_, thor_,
   {{0x8c46133d,0x44e1013f,0x6abc133e,0x7aed0188}},	//   _семе, dų_, _wirf, bsat,
   {{0x09e80081,0x7aed0fcc,0x6b9d0178,0x81bc01d3}},	//   _পাঠা, csat, _gysg, ldēt,
   {{0x2ca0133f,0x29011340,0xfc3f02c6,0x38661341}},	//   llid_, buha_, _zní_, shor_,
   {{0x38661342,0x61e81343,0x44e1013f,0x2ca000bc}},	//   phor_, vadl, gų_, olid_,
   {{0x26091344,0x26c41345,0x54541346,0x955300e3}},	//   _साथी_, _tumo_, рвит, إخوا,
   {{0x61e81347,0x41e60426,0x18670284,0x2ca009a1}},	//   tadl, ліна, _сати_, ilid_,
   {{0x471b00c1,0xdbd1007a,0x44e10138,0x171b006e}},	//   _אומג, _süüd, bų_, _אומע,
   {{0x3de21348,0x26091349,0x2ca0007a,0x249f134a}},	//   _বাংল, _साती_, klid_, blum_,
   {{0x7aed0694,0xfc3f0019,0x61e8134b,0xc0ab0452}},	//   ysat, _phím_, sadl, عادل_,
   {{0x543b0130,0x61e8134c,0xd9e40789,0x087700c1}},	//   _רעדא, padl, गरात_, רעכט_,
   {{0x6a60003e,0x29010169,0x00000000,0x00000000}},	//   _söfn, yuha_, --, --,
   {{0x6d4a0231,0xf09f015e,0x00000000,0x00000000}},	//   _àfal, plà_, --, --,
   {{0x7aed134d,0x2ca000aa,0xfc3f0023,0x6b9d00f0}},	//   tsat, glid_, _thím_, _pysg,
   {{0x3a750cc0,0x0ca800c2,0x998c0a39,0x7aed00b7}},	// [bf0] алар, утри_, _ćoše_, usat,
   {{0x7ed40080,0x7bcd134e,0x2901134f,0x2ca01350}},	//   _ازيا, scau, tuha_, alid_,
   {{0x7aed1351,0x667500bf,0xc9841352,0x2ca01353}},	//   ssat, یدتر, буци, blid_,
   {{0x29011354,0x2c2702ec,0x2ca01355,0x7aed1356}},	//   ruha_, _сьог, clid_, psat,
   {{0xf7451357,0x26001358,0x29011359,0xd6db008f}},	//   рело, _राखी_, suha_, хте_,
   {{0x44e101b3,0x09df0081,0xa2c303a2,0x29010169}},	//   tų_, _ঢাকা, रदस्, puha_,
   {{0x58d41167,0x249f135a,0x7c2f0483,0xafdb09af}},	//   _гост, tlum_, _kacr, ljøu,
   {{0x99840080,0x44e1013f,0x60c4135b,0x68e3135c}},	//   _الفو, rų_, _čimp, ându,
   {{0x09e80081,0xc864135d,0x6729135e,0x44e10138}},	//   _পাতা, _утри, _usej, sų_,
   {{0x7c2f0f99,0xaa7b135f,0x81ae0081,0x42551360}},	//   _lacr, _zvýr, কশন_, ртит,
   {{0xa06a1361,0xc4f800ab,0x249f0b12,0xe046008d}},	//   вана_, _معنا_, plum_, анни,
   {{0xb4c11362,0x54a71363,0x7c2f005f,0xcea9040a}},	//   ंदी_, _صحاف, _nacr, _חי_,
   {{0x2ca01364,0x00000000,0x00000000,0x00000000}},	//   vlid_, --, --, --,
   {{0x442f1365,0x3ebe081f,0x2ca01366,0x00000000}},	//   _hag_, ött_, wlid_, --,
   {{0x442f1367,0xfce600ba,0x7c2f041c,0x00000000}},	//   _kag_, робо, _bacr, --,
   {{0x442f1368,0xbc631369,0xa3ac03a2,0x2fdf01cd}},	//   _jag_, овск, _गरम_, ðugt_,

   {{0x91fc00d9,0x6b850037,0x2ca0136a,0xb4c1136b}},	// [c00] bkād, مشكل, rlid_, ंदु_,
   {{0xe9d7136c,0x442f136d,0x7ea00149,0xd0e60470}},	//   ику_, _lag_, köpi, _حکیم_,
   {{0xa926136e,0x7e7c02ef,0x7c2f009c,0x442f0027}},	//   рдел, mirp, _facr, _oag_,
   {{0x442f136f,0x7e7c0063,0x4907007a,0x6d5c1370}},	//   _nag_, lirp, _हमरो_, myra,
   {{0x7c241371,0xd7071372,0x6d5c1373,0x28131374}},	//   meir, инце_, lyra, تونس,
   {{0x7c241375,0xb4c11376,0x7c2f0106,0x80db0033}},	//   leir, ंदू_, _zacr, _ভিন্,
   {{0x39470222,0x6d5c1377,0x442f1378,0x2bd30336}},	//   änst_, nyra, _bag_, धुवा,
   {{0x7c241379,0x442f137a,0x8af00092,0x7791001c}},	//   neir, _cag_, yyəl, _کیها,
   {{0x27e00088,0xd5b100de,0x6d5c00f0,0x7e7c0109}},	//   ðinu_, _máy_, hyra, kirp,
   {{0x80ca03a2,0x7d1e02ec,0x7c24137b,0x442f036b}},	//   _संदे, _opps, heir, _eag_,
   {{0x3a370054,0x442f137c,0xd57500d6,0x5186137d}},	//   ברים_, _fag_, _луць, рупа,
   {{0x442f137e,0x7c24137f,0x1b1d0033,0x78a21380}},	//   _gag_, jeir, নিতে_, nlov,
   {{0x7c241381,0x44241382,0x236d00a5,0x78a2025b}},	//   deir, mem_, czej_, ilov,
   {{0xa2c3009f,0x442f1383,0x78a20146,0xbe88007b}},	//   रदर्, _zag_, hlov, ассе_,
   {{0x7c2402ad,0x78a20146,0x6d5c1384,0xd08700c2}},	//   feir, klov, gyra, _выпи,
   {{0x44241385,0x78a21386,0x7c241387,0x26161388}},	//   nem_, jlov, geir, प्ती_,
   {{0x78a21389,0x4424138a,0xf9c7117a,0x80ca00b7}},	// [c10] dlov, iem_, ащен, _सूते,
   {{0x4424138b,0x2489138c,0x753a0634,0xae1600aa}},	//   hem_, čami_, _ortz, द्दन_,
   {{0x4424138d,0x7c24138e,0x78a200d4,0x7c2f138f}},	//   kem_, beir, flov, _tacr,
   {{0x7c241390,0x00000000,0x00000000,0x00000000}},	//   ceir, --, --, --,
   {{0x44241391,0x442f1392,0x2b470077,0x753a01e9}},	//   dem_, _rag_, _тэнг, _artz,
   {{0x6442054f,0x442f1393,0x78a21394,0x00000000}},	//   _anoi, _sag_, alov, --,
   {{0x442f1395,0x78a20e94,0xb4c10980,0x5bb702d5}},	//   _pag_, blov, ंदे_, _अणुव,
   {{0x44241396,0x442f01fa,0x628a0e94,0x644200da}},	//   gem_, _qag_, _ajfo, _cnoi,
   {{0x442f1397,0x753a0a00,0xe2990231,0xd8b60018}},	//   _vag_, _ertz, лаи_, _اگلا_,
   {{0x442f1398,0x7c24001f,0x9f421054,0x236d007f}},	//   _wag_, zeir, jaká_, rzej_,
   {{0x236d0067,0x442f1399,0x4424139a,0x291301e9}},	//   szej_, _tag_, bem_, ntxa_,
   {{0x4424139b,0x7c241390,0x442f023e,0x673b0052}},	//   cem_, xeir, _uag_, _kruj,
   {{0x7c240bfe,0x4374139c,0x6d41057e,0x6d5c00f0}},	//   veir, _мушт, ålan, wyra,
   {{0xda0304a9,0x6d5c139d,0x1d0a139e,0x539a00ca}},	//   _लागत_, tyra, леги_, _גינו,
   {{0x7c24139f,0x78a213a0,0x98a702c6,0x3ce300b6}},	//   teir, ylov, íně_, टीले_,
   {{0x3fe607ed,0x673b13a1,0xeb9a007b,0xab2a13a2}},	//   _ужив, _oruj, гиб_, лоба_,
   {{0x7c2413a3,0x387d0150,0x64aa00b6,0x5baa13a4}},	// [c20] reir, diwr_, _přiz, укам_,
   {{0x7c2413a5,0x09e80081,0x0f3700ca,0x00000000}},	//   seir, _পাহা, _פריט_, --,
   {{0x7d1e13a6,0xed5a13a7,0xe8fa13a8,0x7c2413a9}},	//   _upps, _сон_, уле_, peir,
   {{0x442413aa,0x673b0a59,0x16050006,0xafdb00f2}},	//   xem_, _bruj, _राउर_, ljør,
   {{0x442413ab,0x78a213ac,0x7bc60124,0x673b034f}},	//   vem_, rlov, _igku, _cruj,
   {{0x78a213ad,0x442400a5,0x13e002d5,0xd9460d86}},	//   slov, wem_, नर्भ, _леги,
   {{0x260913ae,0x7bc60124,0x9ac3003d,0xe3e800d1}},	//   _सारी_, _kgku, ċċes, لکشن_,
   {{0x6d5903e3,0xafdb00f2,0x442413af,0x00000000}},	//   _ƙwaz, hjør, uem_, --,
   {{0xe73702fd,0x533413b0,0x673b13b1,0x66e313b2}},	//   _лет_, цепт, _gruj, _нота,
   {{0x442413b3,0x3d190d1b,0x6f0604f8,0x00000000}},	//   sem_, _पहले_, dukc, --,
   {{0x442406f7,0x3a3700a1,0x1a9b00c1,0xe6930781}},	//   pem_, זרים_, רייע, _علمد,
   {{0x5edd0033,0xc95300ca,0x9f4b020d,0x20050138}},	//   _বিবে, למת_, lacé_, ėlio_,
   {{0xa3bc13b4,0xa3ac00b6,0xafdb00f3,0xa01b01f9}},	//   _आणि_, _गरि_, fjør, lnök,
   {{0x63a213b5,0xafdb00d6,0x9f4000ee,0x161b0ff9}},	//   _iyon, gjør, _deià_, प्पर_,
   {{0x865b13b6,0x63a20167,0xdd3a00ae,0x00000000}},	//   נדלי, _hyon, văţa, --,
   {{0x63a20283,0x4fc700d3,0x00000000,0x00000000}},	//   _kyon, _уска, --, --,
   {{0x628813b7,0x260913b8,0x61ea003e,0xafdb13b9}},	// [c30] ondo, _साली_, _kefl, bjør,
   {{0x628813ba,0x80db0081,0xe9ab00d1,0x00000000}},	//   nndo, _ভিত্, هدان_, --,
   {{0x63a213bb,0x628805c2,0x09e80033,0xc98400d3}},	//   _lyon, indo, _পাশা, пуци,
   {{0x629a13bc,0xf77000d0,0x6e2713bd,0x27e906cb}},	//   hoto, کام_, lejb, úan_,
   {{0x61f813be,0x65c511a0,0x387d00f0,0x9f4b014b}},	//   _odvl, обла, riwr_, facé_,
   {{0xe6180565,0x34b30f35,0x673b007e,0xddc502c6}},	//   йді_, ुद्द, _vruj, _pohř,
   {{0x69c702ec,0x63a213bf,0x6d590d2a,0xa01b02c3}},	//   _igje, _ayon, _ƙway, rnöj,
   {{0x06d80081,0x63a20a15,0xe45913c0,0x6e2700d8}},	//   _সিরি, _byon, ржи_, hejb,
   {{0x60ca01bf,0x63a202a4,0x27ef01cd,0x6e2700d4}},	//   _aufm, _cyon, magn_, kejb,
   {{0x629a13c1,0x63a205aa,0x60d800b3,0xbbc60285}},	//   goto, _dyon, _btvm, _वल्क,
   {{0x602604d9,0x63a213c2,0xdddc0138,0x63f913c3}},	//   одна, _eyon, sirū, _نفاس_,
   {{0x27ef005c,0x628813c4,0x99580220,0xe45f00aa}},	//   nagn_, ando, náša_, ööd_,
   {{0x63a20517,0x62351146,0xe1ee0221,0x69c30206}},	//   _gyon, _меду, _ог_, žneh,
   {{0x61ea13c5,0x629a13c6,0x68f50094,0x69c70052}},	//   _gefl, coto, _ovzd, _ngje,
   {{0xdd920867,0x8c7a008f,0x2c6700bc,0xbea30d85}},	//   ذور_, ащат_, _sõda_, фарк,
   {{0x69c700dd,0x69d501c0,0x9f4000ee,0x8c4313c7}},	//   _agje, _afze, _teià_, месе,
   {{0x20e70103,0xfc3f00fe,0x2ea70103,0x00000000}},	// [c40] lői_, _nhíu_, _ڈپٹی_, --,
   {{0xafdb13c8,0xa01b01f9,0x00000000,0x00000000}},	//   ljøp, ynök, --, --,
   {{0x38cb00d0,0xc7c613c9,0x60c413ca,0xc92a00e5}},	//   لانی_, осли, _kiim, роеж_,
   {{0xdca613cb,0x69da13cc,0x629a0051,0x09aa0096}},	//   _фами, _प्री, zoto, _करीय,
   {{0x41c9000c,0x629a0010,0x3ced0039,0xc5f30081}},	//   रशास, yoto, ćeve_, চ্ছা_,
   {{0x473302ec,0xa3dc0096,0x7c3613cd,0x60c413ce}},	//   ьніс, तुन_, ldyr, _liim,
   {{0x629a13cf,0x63a213d0,0xafdb0120,0x00000000}},	//   voto, _syon, kjøp, --,
   {{0x69c701e5,0x7c3613d1,0x629a13d2,0x60c413d3}},	//   _zgje, ndyr, woto, _niim,
   {{0x629a0256,0x00000000,0x00000000,0x00000000}},	//   toto, --, --, --,
   {{0xd25a11d9,0x62880131,0x63a20169,0x7ae9047e}},	//   рци_, undo, _vyon, _çete,
   {{0xaca40134,0x62880429,0x403513d4,0xfc3f00fe}},	//   _alọt, rndo, пенс, _khít_,
   {{0x63a213d5,0x7ea00212,0x629a13d6,0x60c4041c}},	//   _tyon, köps, soto, _ciim,
   {{0x629a0a4b,0x60c413d7,0x628f020d,0x06cc0033}},	//   poto, _diim, écoc, রীরি,
   {{0x5edd0081,0xf8ca00b7,0x69da087c,0x00000000}},	//   _বিদে, िदाय, _प्ली, --,
   {{0x60c413d8,0xa6e900fe,0x00000000,0x00000000}},	//   _fiim, _giươ, --, --,
   {{0x60c413d9,0x3f8c0233,0x00000000,0x00000000}},	//   _giim, ğdur_, --, --,
   {{0x3f8c0092,0x27ef13da,0x69c7037a,0x00000000}},	// [c50] şdur_, vagn_, _pgje, --,
   {{0xe80d04a9,0x0b8800d6,0x24510146,0xea0000fe}},	//   _हाहा_, істи_, _dámy_, _đản_,
   {{0xf7d80294,0x47d80134,0x00000000,0x00000000}},	//   _ịrụp, _ịzụk, --, --,
   {{0xb8f313db,0x2ee903e3,0xfc3f0023,0x245100d8}},	//   _हं_, _kwaf_, _chít_, _fámy_,
   {{0xe73913dc,0x87270037,0x209b0134,0x490706eb}},	//   сел_, تعام, ụkwụ_, _हमको_,
   {{0x27ef00f2,0xb9010033,0x9605023a,0xd62913dd}},	//   sagn_, _দি_, रलेट_, соке_,
   {{0x224913de,0x2fc900f9,0xb06600c2,0x3b090063}},	//   _đak_, _ogag_, nsää, luaq_,
   {{0x2fc90009,0x20e70103,0xd7f00076,0x929d007f}},	//   _ngag_, vői_, _لكِ_, tuło,
   {{0xeda8030b,0x66f413df,0x00000000,0x00000000}},	//   _गर्छ, _опту, --, --,
   {{0x27ed03ee,0xcb1203c2,0x2fc913e0,0x20e70103}},	//   _heen_, עלי_, _agag_, tői_,
   {{0x60c413e1,0xa0a6028d,0x2d840233,0x27ed13e2}},	//   _piim, занд, şmez_, _keen_,
   {{0x26c5068d,0xc4d200a1,0x60c4008a,0x2489037a}},	//   _hilo_, _נגד_, _qiim, _ñam_,
   {{0x60c413e3,0x27ed13e4,0x7c360b81,0x25a513e5}},	//   _viim, _meen_, vdyr, _hyll_,
   {{0xd356040a,0x27ed13e6,0x645913e7,0xdbf602d5}},	//   _מיני_, _leen_, _howi, ेल्ड_,
   {{0x2fcd13e8,0x60c413e9,0x7c3613ea,0x00000000}},	//   žega_, _tiim, tdyr, --,
   {{0x26c5026e,0x628113eb,0x27ed029a,0x3eb809ac}},	//   _lilo_, lilo, _neen_, smrt_,
   {{0x2ee903e3,0x201205bd,0x2d85020d,0x26c50062}},	// [c60] _gwaf_, _icyi_, ûler_, _oilo_,
   {{0x628113ec,0x26c50d79,0xee3700ae,0x6a6002c3}},	//   nilo, _nilo_, _ень_, _löfv,
   {{0x27ed13ed,0x2f1601c5,0x7c3601ce,0x7c2a0077}},	//   _been_, læg_, pdyr, _лонг_,
   {{0xc18c00c1,0x628113ee,0x645913ef,0xa3ac074c}},	//   סטאָ, hilo, _nowi, _गरल_,
   {{0x628113f0,0x16340423,0xb8f31024,0xd7ef0037}},	//   kilo, деля, _हू_, اكه_,
   {{0x6b890682,0x98ac07aa,0x26c500c4,0xfe1f11c6}},	//   _þega, ılır_, _cilo_, म्पस_,
   {{0x628113f1,0x26c513f2,0x645913f3,0x1fb90852}},	//   dilo, _dilo_, _bowi, _इण्ड,
   {{0x27ed13f4,0x18a313f5,0x7bd60027,0x00000000}},	//   _geen_, _засм, ncyu, --,
   {{0x645900a5,0x26c513f6,0x00000000,0x00000000}},	//   _dowi, _filo_, --, --,
   {{0x628113f7,0x25a513f8,0x26c503a9,0xa3dc097c}},	//   gilo, _fyll_, _gilo_, _त्र_,
   {{0x764813f9,0xfc3f0037,0xa15800ae,0x2ee90383}},	//   _indy, _mhír_, цану_, _swaf_,
   {{0xa3e6000f,0x386613fa,0x7af600c2,0x764401c2}},	//   _बजट_, nkor_, ksyt, ɓiya,
   {{0x6a600102,0x765a13fb,0x533402b3,0xe29a13fc}},	//   _höfu, _koty, _целт, _лад_,
   {{0x628113fd,0x644701d3,0x645913fe,0x4b120033}},	//   cilo, ējie, _zowi, হবাগ_,
   {{0x765a13ff,0x6e940231,0x38661400,0x9f4b02c6}},	//   _moty, хиру, kkor_, mací_,
   {{0xea0000de,0x9f4b033d,0x765a1401,0x4fc71402}},	//   _đạn_, lací_, _loty, _эска,
   {{0x5a351403,0xb0660084,0xfbd000e3,0x27ed0313}},	// [c70] мнат, ssää, اتف_, _reen_,
   {{0x32d20019,0x765a1404,0x27ed00a1,0x9f4b02c6}},	//   _mây_, _noty, _seen_, nací_,
   {{0x80a403ed,0x26c50124,0x32d20023,0x6dc30090}},	//   _زمین, _rilo_, _lây_, _qċaċ,
   {{0x2c0900bf,0x9f4b1405,0x00000000,0x00000000}},	//   _بعدی_, hací_, --, --,
   {{0x2ca91406,0xcc5603c2,0x9f4b00b6,0x27ed0629}},	//   mlad_, _חברי_, kací_, _veen_,
   {{0xe5a51407,0x64591408,0x2ca91409,0x62810a00}},	//   мили, _sowi, llad_, xilo,
   {{0x64590d1b,0x765a140a,0x27ed140b,0x6281140c}},	//   _powi, _doty, _teen_, vilo,
   {{0x38660222,0x61e40291,0x32d20019,0x7648140d}},	//   ckor_, _đila, _bây_, _endy,
   {{0x6281140e,0x32d20028,0x26c503e3,0x2ca90150}},	//   tilo, _cây_, _tilo_, ilad_,
   {{0x32d20019,0x2ca9140f,0x2f161410,0x00000000}},	//   _dây_, hlad_, væg_, --,
   {{0x62810a29,0x2ca91411,0x356b1412,0x386d0120}},	//   rilo, klad_, _уран_, _kler_,
   {{0x1de60f8f,0x62790146,0x23720034,0x6a6013da}},	//   कर्ष_, jňov, _żyje_, _höft,
   {{0x32d20028,0x2ca91413,0x62790146,0xd3d80037}},	//   _gây_, dlad_, dňov, _ربنا_,
   {{0x5edd00c7,0x248d1414,0x7cd5013f,0x38661415}},	//   _বিশে, lnem_, _sąra, zkor_,
   {{0x248d1416,0x6da30cd7,0x2ca90188,0xdca60a99}},	//   onem_, вира, flad_, дави,
   {{0x248d1417,0x4e1f0c8c,0x2ca91418,0xae1f09dd}},	//   nnem_, म्बई_, glad_, म्बन_,
   {{0xa5a404dd,0x32d20028,0x3ced1419,0xdca3141a}},	// [c80] _चुनौ, _xây_, ćeva_, тати,
   {{0x386d00b3,0x1e83141b,0x2ca9019a,0x7af6141c}},	//   _aler_, _альм, alad_, rsyt,
   {{0x2ca9141d,0x9f420031,0x386d141e,0x249f014b}},	//   blad_, jakú_, _bler_, koum_,
   {{0x20d30028,0x248d141f,0x9f4b00b6,0x315600c1}},	//   _mãi_, jnem_, zací_, ויען_,
   {{0x248d1420,0x20d300de,0x38661421,0xfc3f0076}},	//   dnem_, _lãi_, rkor_, _thír_,
   {{0x38661422,0x2ca01423,0xa3c106eb,0xd04200a7}},	//   skor_, loid_, ंधन_, rqlə,
   {{0x386d1424,0x9f4b0343,0xceb30130,0x656300f0}},	//   _fler_, vací_, דיג_, gynh,
   {{0x38b50bab,0x60cd00e7,0x628f00fd,0x684311cc}},	//   gård_, _čamp, écon, _инса,
   {{0x27e61425,0xd62600e3,0x765a1426,0x41c90abe}},	//   mbon_, _يعطي, _toty, रशंस,
   {{0x20d300de,0x27e601e9,0x518601ef,0x32d20023}},	//   _bãi_, lbon_, дума, _vây_,
   {{0x248d1427,0x9f4b033d,0x20d300de,0x1bee0285}},	//   bnem_, rací_, _cãi_, जराल_,
   {{0x32d20028,0x27e61428,0x20d300fe,0x9f4b00d4}},	//   _tây_, nbon_, _dãi_, sací_,
   {{0x80ca0693,0x2ca91429,0x44fa01d3,0x62791054}},	//   _संके, vlad_, lī_, vňov,
   {{0x2ca9142a,0x20050511,0x8d6b001f,0x91f2074c}},	//   wlad_, şli_, ојба_, _आजिज_,
   {{0x62790146,0x44fa01d3,0x20d300fe,0x00000000}},	//   tňov, nī_, _gãi_, --,
   {{0x8af00253,0x6e370694,0x2ca000f9,0xa3b500c3}},	//   yyət, _waxb, goid_, छेक_,
   {{0x7b1800c2,0x2918003d,0x2d9e142b,0x62790094}},	// [c90] мотр_, _aqra_, üter_, rňov,
   {{0xd5a400fb,0x248d142c,0x62790094,0x249f01c2}},	//   _نہ_, znem_, sňov, zoum_,
   {{0x6279025b,0x25a903e3,0x386d0113,0xfbd00103}},	//   pňov, ƙali_, _pler_, اتہ_,
   {{0x2ca0142d,0x59df142e,0x765e007b,0x00000000}},	//   coid_, _प्रर, öpyn, --,
   {{0xf625142f,0x248d02dd,0x7c2d1430,0x38b50149}},	//   едло, vnem_, mear, vård_,
   {{0x7c2d1431,0x8cb91432,0xb0cf0be4,0xe61000a7}},	//   lear, ्दको, _संलग, rüşə,
   {{0x248d02dd,0xe5a200d6,0x79a40097,0x64a51433}},	//   tnem_, лиши, _арте, нака,
   {{0x7c2d1434,0x387f1084,0x20d300de,0x386d1435}},	//   near, _umur_, _rãi_, _uler_,
   {{0x248d1436,0x6d43007e,0x00000000,0x00000000}},	//   rnem_, _šnal, --, --,
   {{0x7c2d0099,0x248d0660,0x00000000,0x00000000}},	//   hear, snem_, --, --,
   {{0x7c2d0634,0x00860237,0x248d1437,0x2c0f00b7}},	//   kear, елно, pnem_, िलां_,
   {{0x20d30023,0x7c2d1438,0x00000000,0x00000000}},	//   _vãi_, jear, --, --,
   {{0xe28e1439,0x442d143a,0x7c2d143b,0x270d009d}},	//   _ба_, mee_, dear, _समोर_,
   {{0x442d143c,0x877a0796,0x82350281,0xed5a0b0a}},	//   lee_, לארי, _سرتا, пог_,
   {{0x6fa0143d,0x27ff0d79,0x26170f53,0x8af00092}},	//   _गुरू, _odun_, _नानी_, yyəs,
   {{0x442d143e,0x7c2d143f,0xdca607b3,0xdca31440}},	//   nee_, gear, хаби, гаси,
   {{0x644b005c,0xdb1c00a7,0xab271441,0x20000af0}},	// [ca0] _mngi, _özüm, нота_, _idii_,
   {{0x442d1442,0x27ff049e,0x7f441443,0x00000000}},	//   hee_, _adun_, _iriq, --,
   {{0x442d1444,0x7c2d1445,0x644b11f0,0x26df0231}},	//   kee_, bear, _ongi, _atuo_,
   {{0x7c2d1446,0x442d1447,0x27e6029a,0xb05b058f}},	//   cear, jee_, ubon_, rmäg,
   {{0x442d1448,0x3a38013f,0x7d0e1449,0x27e6144a}},	//   dee_, _tarp_, lubs, rbon_,
   {{0x644b144b,0x27ff144c,0x27e6144d,0x6e2e144e}},	//   _angi, _edun_, sbon_, nebb,
   {{0x442d0129,0x7ae4144f,0x69ce0d79,0x69dc1450}},	//   fee_, lpit, _igbe, _ifre,
   {{0x442d1451,0x7ae40051,0x6e2e1452,0x44fa0877}},	//   gee_, opit, hebb, rī_,
   {{0x7ae41453,0x96ba1454,0x760a00ae,0xb05b007b}},	//   npit, _فائز_, _неаг_, nmäe,
   {{0x644b1455,0x7c2d0a00,0xda100d77,0x75d60037}},	//   _engi, zear, ालित_, _أيضا,
   {{0xd48f1456,0x69ce0294,0x06d80033,0x7c2d1457}},	//   _бр_, _mgbe, _সিটি, year,
   {{0x7ae41458,0x442d1459,0x7f44145a,0x7c2d0634}},	//   kpit, cee_, _briq, xear,
   {{0x69dc11ce,0x7c2d145b,0xbfab1402,0x7f44145c}},	//   _ofre, vear, ятое_, _criq,
   {{0x2b400117,0x6e2e0103,0x78a200bc,0x9f4b00ee}},	//   dvic_, gebb, hoov, racà_,
   {{0x7c2d145d,0x3ced0335,0xdd9400c6,0xac1907bf}},	//   tear, ćevo_, гары, мову_,
   {{0x69dc145e,0x69ce0d79,0xa01b0212,0x7f4400b3}},	//   _afre, _agbe, rnös, _friq,
   {{0x7c2d145f,0xddc50220,0x7ae40d1f,0x9f53007f}},	// [cb0] rear, _dlhš, gpit, ędów_,
   {{0x7c2d1460,0x442d1461,0x6f0f028d,0x1dd51462}},	//   sear, zee_, mucc, _दलित,
   {{0x442d1463,0x6f0f1464,0x7c2d1465,0x6f1d0364}},	//   yee_, lucc, pear, ltsc,
   {{0x69ce0af0,0xdddc013f,0x6f1d01c0,0x69dc1466}},	//   _egbe, mirš, otsc, _efre,
   {{0xd3661467,0x6f1d1468,0xb8d80251,0xab871469}},	//   _ئه_, ntsc, _घी_, _чунк,
   {{0x442d146a,0x6d4a00e3,0x6f1d0364,0x70030294}},	//   wee_, _áfac, itsc, ọchi,
   {{0x442d146b,0x78a200e7,0x6f1d11c5,0x628f014b}},	//   tee_, boov, htsc, écom,
   {{0xa8a4146c,0x442d00f9,0x69ce00c4,0xc3250033}},	//   _брук, uee_, _zgbe, বিসি_,
   {{0x2ba704dd,0x36d502ec,0x442d0054,0x9f4b146d}},	//   _कुमा, _розр, ree_, yacá_,
   {{0x6f0f146e,0x442d146f,0xcb1400c1,0x20001470}},	//   ducc, see_, אלץ_, _sdii_,
   {{0x442d1471,0x35550241,0x6d4501fa,0xd00a1472}},	//   pee_, _جناز, _nrha, мене_,
   {{0x644b1473,0x6e2e0361,0x6f1d02db,0x60dc002b}},	//   _ungi, webb, ftsc, írma,
   {{0xa3a8009d,0x6e2e1474,0x547a00ca,0x6f0f0036}},	//   _खुप_, tebb, _קטנו, gucc,
   {{0x6d45005c,0xdee30058,0x8cd60285,0x3b09010a}},	//   _brha, рори, _मंदो, draq_,
   {{0x6e2e0465,0x7afd1475,0x6da60097,0xada61476}},	//   rebb, _avst, тива, тавл,
   {{0x7f441477,0x6e2e1478,0x69dc1479,0x6f0f147a}},	//   _triq, sebb, _sfre, bucc,
   {{0x7d0e147b,0x6d4502e2,0x7d1c02dd,0x6b63147c}},	// [cc0] subs, _erha, strs, акта,
   {{0x63ab00f9,0x7ae4147d,0x2b4005db,0x7bcf0372}},	//   _mygn, rpit, rvic_, _egcu,
   {{0x2ba7007d,0x7ae4147e,0x6729026e,0xa3a8147f}},	//   _कुठा, spit, _apej, _खुन_,
   {{0x66e61480,0xe78600d3,0x7ae41481,0xe3a71482}},	//   вода, куло, ppit, _نر_,
   {{0x62830031,0x78a2058f,0x00000000,0x00000000}},	//   _omno, roov, --, --,
   {{0xb7d20081,0x20ee00b6,0x78a200aa,0x69dc1483}},	//   ারেট, yři_, soov, _ufre,
   {{0x6f0f0036,0xd3e90033,0x91fc01d3,0x00000000}},	//   zucc, _গাড়ি_, skāk, --,
   {{0x63ab1484,0x394702b6,0x62831485,0x00000000}},	//   _bygn, ænse_, _amno, --,
   {{0x63ab02e5,0xa7a71486,0x87251487,0x7eb200f3}},	//   _cygn, _акта_, _معلم, væpn,
   {{0x63ab0149,0x20ee00d2,0x00000000,0x00000000}},	//   _dygn, tři_, --, --,
   {{0x26171488,0x7c26103b,0x26cc008c,0x2b460206}},	//   _नाती_, _obkr, _iido_, ťoch_,
   {{0x6f0f0451,0xdddc0138,0x6f1d1489,0x62830372}},	//   tucc, virš, ttsc, _emno,
   {{0x4426148a,0x6f1d0364,0xd36f1374,0x2d9a01ff}},	//   _ibo_, utsc, _وهم_, _axpe_,
   {{0x6f1d148b,0x6f0f04d3,0x2c7501c5,0x6d450117}},	//   rtsc, rucc, _måde_, _prha,
   {{0x26cc148c,0x6f1d148d,0x2bc5148e,0x7c260062}},	//   _mido_, stsc, लेना, _bbkr,
   {{0x200500c6,0x6f1d042c,0x91f200aa,0x6d4500d4}},	//   ėlis_, ptsc, _आजुओ_, _vrha,
   {{0x201e0253,0x4426148f,0x09bd0966,0x9cc801b6}},	// [cd0] əti_, _mbo_, ्ख्य, тыра_,
   {{0x62881490,0x99671491,0x160e1492,0x2ba71493}},	//   nido, ктел, _सागर_, _कुणा,
   {{0x44261494,0x60cd1495,0x67291496,0x7ac41497}},	//   _obo_, _kiam, _spej, рсте,
   {{0x2c750c2e,0x24580181,0x44261498,0x60cd1499}},	//   _både_, _témy_, _nbo_, _jiam,
   {{0x60cd149a,0x26cc0129,0x160e009d,0xb8fa149b}},	//   _miam, _bido_, _साखर_, _डू_,
   {{0x4426149c,0x98b308bb,0x7c3d149d,0xa3e509c3}},	//   _abo_, ıdır_, _hasr, बुन_,
   {{0x62880b0b,0x6ed506ed,0x63ab149e,0x4426083e}},	//   dido, _यूसु, _sygn, _bbo_,
   {{0x60cd149f,0x26cc03be,0x7c3d0063,0x9f52022b}},	//   _niam, _eido_, _jasr, _feyè_,
   {{0x7c3d14a0,0x78a9039f,0x42c9007e,0x00000000}},	//   _masr, _ikev, нгин_, --,
   {{0x628814a1,0x442614a2,0x78a214a3,0xe3b6004b}},	//   gido, _ebo_, čove, ыбы_,
   {{0x78bb023e,0x60cd0154,0x64150037,0x00000000}},	//   _khuv, _biam, _مواط, --,
   {{0x60cd01b5,0x44260d79,0xdee614a4,0x205600d3}},	//   _ciam, _gbo_, ломи, утор,
   {{0x60cd14a5,0xb4c10d77,0x00000000,0x00000000}},	//   _diam, ूदी_, --, --,
   {{0x6288132d,0x443f14a6,0x443d14a7,0x628314a8}},	//   cido, ldu_, _haw_, _umno,
   {{0x443d14a9,0x443f14aa,0xff140081,0x60cd14ab}},	//   _kaw_, odu_, িবেশ_, _fiam,
   {{0x60cd14ac,0x7c3d0188,0x645b14ad,0x00000000}},	//   _giam, _casr, njui, --,
   {{0x4bd914ae,0x443d0150,0x3b070476,0x443f14af}},	// [ce0] ться_, _maw_, лето_, idu_,
   {{0x443d00a1,0xfaaa001c,0x443f14b0,0x2c7500f2}},	//   _law_, رهاي_, hdu_, _råde_,
   {{0x9f5214b1,0x09060f2e,0x26cc14b2,0xae1b006e}},	//   _seyè_, упен, _rido_, _אויכ,
   {{0x26cc14b3,0x38600102,0x78bb0bfe,0x443f0146}},	//   _sido_, ðir_, _chuv, jdu_,
   {{0x443f14b4,0x26cc14b5,0x5fc700b6,0x4b5500e5}},	//   ddu_, _pido_, रेपल, _кърт,
   {{0x0f370054,0x62880042,0x443f14b6,0xda720018}},	//   טרנט_, xido, edu_, _اُس_,
   {{0x443d14b7,0xaad80096,0x00000000,0x00000000}},	//   _baw_, _भूतक, --, --,
   {{0xdd0401b3,0x443d006c,0x7c2414b8,0x26cb0036}},	//   ūrėt, _caw_, nfir, _ècon_,
   {{0x6288132d,0x443d14b9,0xf7430f7e,0xb2740396}},	//   tido, _daw_, _лето, илиш,
   {{0x60cd14ba,0x59b80b94,0x443f14bb,0x7c2402e5}},	//   _siam, _अरार, adu_, hfir,
   {{0x7c2414bc,0x443f009e,0x1da40f78,0x443d14bd}},	//   kfir, bdu_, _खुलत, _faw_,
   {{0xf5370054,0x628814be,0x443d14bf,0x60cd061d}},	//   _תנאי_, sido, _gaw_, _qiam,
   {{0x7c3d14c0,0x44240063,0x9f590216,0x00000000}},	//   _rasr, mfm_, masë_, --,
   {{0x35a9009f,0x644014c1,0x6e3e14c2,0x7c3d03a9}},	//   _चुड़, ldmi, _capb, _sasr,
   {{0x60cd006c,0x61fa01d4,0x7c2414c3,0x7c3d14c4}},	//   _tiam, matl, ffir, _pasr,
   {{0x61fa14c5,0x644014c6,0x443d01ad,0x7c3d026d}},	//   latl, ndmi, _xaw_, _qasr,
   {{0x50b8006f,0x6e9500d6,0x99900335,0x3b550284}},	// [cf0] _حدود_, _випу, _čaša_, шкар,
   {{0x61fa14c7,0x443f14c8,0xda780457,0xdb2401f9}},	//   natl, zdu_, лях_, ásán,
   {{0x394714c9,0x443f14ca,0x7c3d14cb,0x628f00fd}},	//   íns_, ydu_, _tasr, écoi,
   {{0x261713b4,0x61fa04a8,0x443f1321,0x9f590216}},	//   _नाही_, hatl, xdu_, jasë_,
   {{0xe73914cc,0x443f14cd,0x61fa14ce,0x07a507c8}},	//   тел_, vdu_, katl, јалн,
   {{0xa5091402,0x61fa14cf,0x443d00ca,0x00000000}},	//   века_, jatl, _saw_, --,
   {{0x443d14d0,0x61fa14d1,0x3e7400aa,0x443f00a7}},	//   _paw_, datl, _jäta_, tdu_,
   {{0x443f14d2,0xc6060081,0x3e7414d3,0x7cdc05db}},	//   udu_, ল্লা_, _mäta_, _očrn,
   {{0xa3a805d4,0x443f14d4,0xfc3f0682,0xe456004b}},	//   _खुद_, rdu_, _maí_, ржы_,
   {{0xc6a714d5,0x61fa14d6,0x161c0789,0x2ef200f0}},	//   _срби, gatl, _नायर_, _rwyf_,
   {{0x443d14d7,0x7c24003e,0x6e3e0085,0xf8c90139}},	//   _taw_, yfir, _rapb, _gbéé_,
   {{0x443f14d8,0x44f300ae,0x239e0134,0x3f6a0284}},	//   qdu_, mţ_, ịja_, вимо_,
   {{0x61fa07e7,0x6e3e14d9,0xa3c100a4,0x3cdb00aa}},	//   batl, _papb, ंधळ_, _खूबे_,
   {{0x200c0092,0x614514da,0x673b0350,0x00000000}},	//   şdi_, _века, _msuj, --,
   {{0x44f300d3,0x8d630508,0xa3dc14db,0xb05b007b}},	//   nţ_, овре, तुक_, mmän,
   {{0xb05b14dc,0x673b09ac,0xfc3f0850,0xebe600d3}},	//   lmän, _osuj, _caí_, роап,
   {{0x7c2414dd,0xfc3f0161,0x638801d3,0x673b06b0}},	// [d00] rfir, _daí_, cīnī, _nsuj,
   {{0xab2714de,0x7bdf0451,0x00000000,0x00000000}},	//   рофа_, acqu, --, --,
   {{0xd00f14df,0x7c2402a4,0x19b901b3,0x6d4305db}},	//   _علی_, pfir, гуць_, _šnav,
   {{0x8c4614e0,0xa01b007b,0x61fa14e1,0x07ba0076}},	//   _теме, tiöi, zatl, نهضة_,
   {{0x61fa03a3,0x27e914e2,0xbb4300d6,0xeb97020f}},	//   yatl, ñana_, _деяк, _вия_,
   {{0xa01b00c2,0x2913002b,0xbb43001f,0x248602ac}},	//   riöi, buxa_, _ќерк, _smom_,
   {{0x61fa14e3,0xd49a14e4,0x261714e5,0x442414e6}},	//   vatl, кри_, _नारी_, tfm_,
   {{0x61fa005c,0x98a314e7,0x493b00d7,0x00000000}},	//   watl, _дисе, _בגלו, --,
   {{0xc178013f,0x61fa101a,0x3ced0a9e,0x66e314e8}},	//   ybės_, tatl, ćevi_, _мота,
   {{0x09ca0081,0x672214e9,0xdd1c0031,0xa6ca14ea}},	//   _ল্যা, mtoj, _záťa, _شوال_,
   {{0x61fa14eb,0x272002f1,0x672214ec,0xd25702e3}},	//   ratl, lòn_, ltoj, рцы_,
   {{0x6722013f,0x61fa14ed,0x224903e3,0x44320023}},	//   otoj, satl, _ɗaki_, _úy_,
   {{0x672211c2,0x61fa14ee,0x2cb214ef,0xfc3f0231}},	//   ntoj, patl, dlyd_, _raí_,
   {{0xea0000ef,0x61fa00a7,0xfc3f016d,0x67220109}},	//   _đến_, qatl, _saí_, itoj,
   {{0xb2bb0054,0xbd680012,0x672214f0,0xfc3f037a}},	//   _שמור, арте_, htoj, _paí_,
   {{0x2c750222,0x672214f1,0xdb0f0143,0x5c7414f2}},	//   _båda_, ktoj, _azcá, олст,
   {{0x3a750095,0x6722023b,0xa9e70037,0x9f590113}},	// [d10] блар, jtoj, لثان, kasé_,
   {{0x29130072,0x6d4314f3,0xdbd81405,0x3e7402c3}},	//   tuxa_, _šnau, rťák, _täta_,
   {{0x2ba7000d,0xdd9114f4,0x61f814f5,0x672214f6}},	//   _कुरा, _روح_, _mevl, etoj,
   {{0x31570130,0x201914f7,0x272006a3,0x6722023b}},	//   ייבן_, ngsi_, fòn_, ftoj,
   {{0xf74514f8,0x272014f9,0x60d800b3,0x9f5903a9}},	//   село, gòn_, _luvm, fasé_,
   {{0x2ca9051f,0x78a20074,0xbb3a00c1,0x29130072}},	//   load_, čova, _געשי, puxa_,
   {{0xfbdb007d,0x28f814fa,0x199414fb,0x499300d1}},	//   _भलाम, _весь_, _даря, _بیار,
   {{0x29010051,0x6722023e,0x4adb14fc,0xe7870686}},	//   msha_, btoj, _बढाव, _кузо,
   {{0x290114fd,0x61f814fe,0x4e1700b6,0x9f5903a9}},	//   lsha_, _bevl, तलाई_, basé_,
   {{0x38bc14ff,0x29010255,0x61f81500,0x6e350357}},	//   ríre_, osha_, _cevl, jezb,
   {{0x61f81501,0xa06a1502,0x29011503,0xb05b1504}},	//   _devl, гана_, nsha_, rmän,
   {{0xf99200a1,0xb1130294,0x76410188,0x29011505}},	//   לרי_, _kụzu, _haly, isha_,
   {{0x248d0b4b,0x76411506,0x720500cd,0x889a0341}},	//   miem_, _kaly, _هوشم, רברי,
   {{0x248d00d9,0x61f81507,0xb05b00c2,0x27fd00f0}},	//   liem_, _gevl, lmäl, hawn_,
   {{0x76430167,0x01c50033,0xfce61508,0x628f020d}},	//   idny, _শ্রদ, собо, écou,
   {{0x248d1509,0x672201b3,0xb05b0149,0x6d4a0072}},	//   niem_, ytoj, nmäl, _áfam,
   {{0xf1bf00b6,0xd5b10023,0x6e350095,0x61f8013c}},	// [d20] řád_, _lý_, bezb, _yevl,
   {{0x6f04150a,0x248d150b,0x764106b0,0x2901150c}},	//   _ivic, hiem_, _naly, fsha_,
   {{0xfe370054,0x248d150d,0x2b4b01c2,0x00000000}},	//   _פרטי_, kiem_, _ercc_, --,
   {{0x248d0b4b,0x91fc00d9,0x17fa00e3,0x672200c2}},	//   jiem_, nkār, اراة_, ttoj,
   {{0x248d0029,0x501b09c1,0x7641150e,0x672202e3}},	//   diem_, רונו, _baly, utoj,
   {{0x6722150f,0x1ae31510,0xe8140179,0xa01b007b}},	//   rtoj, _хорм, _डाका_, liöt,
   {{0x672206bc,0x764101b3,0x394a00b3,0x490f00c3}},	//   stoj, _daly, _urbs_, _डियो_,
   {{0x248d1511,0x7c361512,0x6722023b,0xb1760019}},	//   giem_, neyr, ptoj, _ngượ,
   {{0xa3a80101,0x00000000,0x00000000,0x00000000}},	//   _खुश_, --, --, --,
   {{0x066500cd,0x76411513,0xda7b006e,0x7d150350}},	//   _والپ, _galy, ָנטר, yuzs,
   {{0xd0110604,0x248d00e8,0x959a00d3,0xa3a800b7}},	//   ولد_, biem_, _стау_, _खुर_,
   {{0x248d1514,0x7641010a,0x00000000,0x00000000}},	//   ciem_, _zaly, --, --,
   {{0x5f94008f,0x3e970037,0x9f4001ff,0x6f041515}},	//   зият, مؤسس, _beiñ_, _cvic,
   {{0x6f0402ef,0x6442033f,0x2901008c,0x539b00ca}},	//   _dvic, _haoi, ysha_, _גידו,
   {{0x90e61516,0x7c36003e,0xb5fc0090,0x2ca91517}},	//   _استن, feyr, _loġo, toad_,
   {{0x81df0033,0x76431518,0x00000000,0x00000000}},	//   তরণ_, zdny, --, --,
   {{0x64421519,0x5eb80081,0x29010188,0xd9f90183}},	// [d30] _maoi, _ইংরে, wsha_, инац_,
   {{0x7f4d151a,0x29010060,0x64420a02,0x248d151b}},	//   _iraq, tsha_, _laoi, ziem_,
   {{0x6f04023b,0xb05b00c2,0x20090063,0xd9990037}},	//   _zvic, ymäl, _kdai_, جنات_,
   {{0x6d400029,0xdb0f0257,0x2901151c,0x6442151d}},	//   āmat, _lycé, rsha_, _naoi,
   {{0x248d151e,0x3ced08a9,0xa3a80251,0x7641013f}},	//   viem_, ćevu_, _खुल_, _paly,
   {{0xf1c8099d,0x248d0034,0x00000000,0x00000000}},	//   रधान, wiem_, --, --,
   {{0x248d0029,0x9f400088,0x7641151f,0x7aed1520}},	//   tiem_, _leið_, _valy, lpat,
   {{0x13091521,0x644202bc,0x7b080088,0x76430167}},	//   аний_, _caoi, _ástæ, sdny,
   {{0x6442003b,0x248d151e,0x7aed1522,0xb7bd00d3}},	//   _daoi, riem_, npat, _obţi,
   {{0x248d0029,0x20090051,0x38bc0094,0x2f10003e}},	//   siem_, _adai_, míra_, _lögð_,
   {{0x6442006b,0x6f041523,0x7f4d1524,0x645d01bf}},	//   _faoi, _svic, _araq, ösis,
   {{0x43751525,0x644209f7,0x2bbe02d5,0x9fca02b3}},	//   _мулт, _gaoi, ्धमा, игна_,
   {{0x99980335,0xe28e1526,0x7f4d1527,0x200903a9}},	//   _marš_, _жа_, _craq, _ddai_,
   {{0x7aed055c,0xa3e500bc,0x91fc00e8,0xc5f90142}},	//   dpat, बुर_, skār, יפֿט,
   {{0xa3c10455,0x7aed1528,0xa01b0e74,0x00000000}},	//   ंधक_, epat, giös, --,
   {{0x7f4d1529,0x6f04022b,0x00000000,0x00000000}},	//   _fraq, _tvic, --, --,
   {{0x7aed152a,0x7c360088,0x68e9033b,0x8eba00d3}},	// [d40] gpat, reyr, _čeda, _вынт_,
   {{0xf221009f,0x63b6004d,0x6d5a007b,0x7c36152b}},	//   _माफ़_, _øyne, ätas, seyr,
   {{0x649700d9,0xed5a0605,0x6ee5015a,0x05a9152c}},	//   rģij, _тон_, _وسیل, _चुलब,
   {{0xd7ef0037,0x78a20094,0x6ef70294,0xcfad0033}},	//   نكم_, čovo, ụbeg, _গণতন,
   {{0xa6ca007e,0x64420441,0xa01b152d,0x8af0013c}},	//   алда_, _raoi, shög, yyəy,
   {{0x64420099,0x2c7c0139,0x00000000,0x00000000}},	//   _saoi, _díde_, --, --,
   {{0x385a0bd5,0x69230cb0,0xd8390154,0x00000000}},	//   _краю_, _омра, _djōb_, --,
   {{0xe8140c54,0xa3e51073,0x00000000,0x00000000}},	//   _डाटा_, बुल_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x026a00d6,0x3f82152e,0xa50a0f6b,0x00000000}},	//   рший_, dzku_, _вежа_, --,
   {{0x3a3703c2,0x6442152f,0x8cd60469,0x7aed007f}},	//   חרים_, _taoi, _मंगो, zpat,
   {{0xb05b007b,0x00000000,0x00000000,0x00000000}},	//   mmäk, --, --, --,
   {{0xe29a0831,0xb05b007b,0x00000000,0x00000000}},	//   _кад_, lmäk, --, --,
   {{0x29070018,0x628a0201,0x63a201ff,0x9f5b0216}},	//   ának_, _umfo, _ixon, _heqë_,
   {{0xb05b007b,0xafdb0565,0x00000000,0x00000000}},	//   nmäk, ldøm, --, --,
   {{0xa01b1530,0xe57100c1,0x9b890037,0x69d80138}},	//   riös, ײַל_, منزل_, žvel,
   {{0x3a750095,0x6d5a1531,0x629a026d,0x9f5b0052}},	// [d50] плар, ätar, onto, _meqë_,
   {{0x68e303be,0x00000000,0x00000000,0x00000000}},	//   índo, --, --, --,
   {{0x05a90455,0x629a00c2,0xa3ca0096,0x7aed1532}},	//   _चुंब, into, ळेत_, spat,
   {{0x7aed1533,0x63a20167,0x7c590037,0x6d5800d4}},	//   ppat, _oxon, _الحر_, _švag,
   {{0x78ab1534,0xfc5a00d7,0x8cba007f,0x00000000}},	//   rogv, _הכרמ, ्षरो, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x2d830034,0x00000000,0x00000000,0x00000000}},	//   nzje_, --, --, --,
   {{0x629a1535,0x00000000,0x00000000,0x00000000}},	//   ento, --, --, --,
   {{0x38341536,0x00000000,0x00000000,0x00000000}},	//   _інфр, --, --, --,
   {{0x629a0b81,0xb05b1537,0xaabd0d7e,0x00000000}},	//   gnto, lmäh, ्गिक, --,
   {{0x27e003f1,0x850500d0,0x91fc00d9,0xe45f00bc}},	//   žine_, _روشن, rkāp, öös_,
   {{0x629a14a7,0x8fa61538,0x55ba00ca,0x61ee00a7}},	//   anto, заме, _המעו, ıbla,
   {{0xc31900c7,0xe80c0096,0x442f1539,0xaabd00a8}},	//   _তৈরি_, हणता_, _ibg_, ्गाक,
   {{0x68e9153a,0x00000000,0x00000000,0x00000000}},	//   _čedn, --, --, --,
   {{0xdd92153b,0xbea3147c,0x3f82153c,0x00000000}},	//   رور_, харк, szku_, --,
   {{0x442f0ca7,0xda1e0096,0xaf06153d,0x00000000}},	//   _jbg_, _पाहत_, _епил, --,
   {{0x2002153e,0x3aeb0018,0x60c4153f,0x207b006e}},	// [d60] maki_, مبلی_, _ihim, _לאקא,
   {{0x20021540,0xdb060034,0xa6e90023,0x2fc0039f}},	//   laki_, _szkó, _khươ, _izig_,
   {{0xceb31541,0x4ddb00ca,0xe853001c,0x442f0131}},	//   _איז_, _לחיו, کنند, _obg_,
   {{0x20021542,0x38cb037f,0xc6040455,0xdca61543}},	//   naki_, مانی_, रण्य_, _хами,
   {{0x629a1544,0x60c40a1c,0x00000000,0x00000000}},	//   ynto, _mhim, --, --,
   {{0x442f063f,0x20021545,0xd6d900d6,0x00000000}},	//   _abg_, haki_, іті_, --,
   {{0x20020044,0xe9a31546,0x442f1547,0x00000000}},	//   kaki_, _зарп, _bbg_, --,
   {{0x20021548,0x399b00a1,0x2bc300c3,0x291a0270}},	//   jaki_, _הילד, _शरमा, mupa_,
   {{0x20020b88,0x6b841549,0x98a300d3,0x2fc0010a}},	//   daki_, nzig, _чите, _nzig_,
   {{0x2a6a154a,0xb05b02fd,0x27e6154b,0x877b0327}},	//   _jobb_, mmäi, lcon_, _האמי,
   {{0x2bb906ae,0xa6e90028,0x249700bf,0xbbb9143d}},	//   _आर्थ, _chươ, _کنند_, _आर्क,
   {{0x60c4154c,0x442f02c3,0x2a6a02a1,0x63a201c8}},	//   _chim, _gbg_, _lobb_, _txon,
   {{0x60c4154d,0x6b840ab2,0x291a0270,0x60d6030a}},	//   _dhim, jzig, hupa_, _diym,
   {{0x291a154e,0x60c40154,0xd35700ca,0xf8dc0285}},	//   kupa_, _ehim, _מידי_, यदाय,
   {{0x2002154f,0x68e90095,0x60c400bd,0x3a3a1550}},	//   baki_, _čedo, _fhim, depp_,
   {{0x60c400ae,0x30a401b3,0x60d60233,0x2002007f}},	//   _ghim, _прыв, _giym, caki_,
   {{0x3f9e01e8,0xcb3400e5,0x7c2f1551,0x27e60565}},	// [d70] ştur_, нетъ, _vbcr, dcon_,
   {{0x291a0239,0x6d41003e,0x60c401c2,0x1ab400d3}},	//   fupa_, ælas, _zhim, ебуя,
   {{0x2907030b,0x291a003a,0x6b840172,0xf8b101f3}},	//   éna_, gupa_, azig, نکر_,
   {{0x38690682,0x6a730367,0x9f0400d1,0x00000000}},	//   ðar_, _sıfı, _تویو, --,
   {{0x7c2d1552,0x649700ae,0x36691553,0x00000000}},	//   mfar, nţie, жало_, --,
   {{0x442f1554,0x20021555,0x7c2d1556,0x00000000}},	//   _sbg_, zaki_, lfar, --,
   {{0xa9341557,0x20021558,0x291a1559,0xa3ca0096}},	//   _перш, yaki_, cupa_, ळेस_,
   {{0x7c2d155a,0x2002155b,0x00000000,0x00000000}},	//   nfar, xaki_, --, --,
   {{0x2002155c,0x7c2d0ba1,0x00000000,0x00000000}},	//   vaki_, ifar, --, --,
   {{0x60c4155d,0xa6e90028,0x2002155e,0x00000000}},	//   _shim, _phươ, waki_, --,
   {{0x2002155f,0x66031560,0xa0a6007e,0x60c400de}},	//   taki_, mank, данд, _phim,
   {{0x60d601d4,0x27ff1561,0x3943037a,0xf4b600d1}},	//   _qiym, _jeun_, _msjs_, _قشنگ,
   {{0x20021562,0x644902ad,0x442d1563,0x7c2d1564}},	//   raki_, mdei, mfe_, dfar,
   {{0x442d02dc,0xa6e900ef,0x20021565,0xa2da0096}},	//   lfe_, _thươ, saki_, नदर्,
   {{0x20021566,0x6d58015c,0x2a6a1567,0x60c41568}},	//   paki_, _švab, _robb_, _thim,
   {{0x64491569,0x6b84156a,0x442d156b,0x7c2d156c}},	//   ndei, tzig, nfe_, gfar,
   {{0x6603156d,0xfc3f0139,0x649700d3,0x3e7400aa}},	// [d80] kank, _akís_, cţie, _läti_,
   {{0x62810060,0x291a156e,0x7f440201,0xfbd1071c}},	//   nhlo, tupa_, _isiq, اتِ_,
   {{0x6603156f,0x224702f1,0x6e3c01cb,0x64591570}},	//   dank, _mank_, merb, _onwi,
   {{0x291a1571,0x22471572,0x7d1c1573,0xccf30327}},	//   rupa_, _lank_, murs, _שכר_,
   {{0x073a1574,0xc6f70426,0x44e3037a,0x6603041c}},	//   تساب_, дніх_, _añ_, fank,
   {{0x26c50a9a,0x66031575,0x44fa0a84,0xea000023}},	//   _chlo_, gank, tū_, _đặn_,
   {{0x442d1576,0x69dc0bfe,0x7d1c1577,0x644901cd}},	//   ffe_, _igre, nurs, fdei,
   {{0x3ae40222,0x6e3c1578,0x27ff1579,0x442201f9}},	//   _köp_, herb, _geun_, ük_,
   {{0x2247157a,0x7ae20076,0xb5fc009e,0x68fc03a8}},	//   _bank_, íoth, _loġi, _hwrd,
   {{0x6603157b,0x64490fe1,0x22470027,0x290a084e}},	//   cank, adei, _cank_, _kvba_,
   {{0x2247157c,0x765a157d,0x7c2d0150,0x018a00c2}},	//   _dank_, _inty, yfar, ющий_,
   {{0x7d1c157e,0x1c1d04f8,0x386600d1,0x7648041c}},	//   durs, _फाइल_, njor_, _hady,
   {{0x69dc157f,0x6e3c1580,0x76481581,0x2247007e}},	//   _ogre, ferb, _kady, _fank_,
   {{0x62811582,0x69dc1583,0x7e7e0154,0x2ee01570}},	//   chlo, _ngre, _clpp, _duif_,
   {{0xf1aa00cd,0x76481584,0x7d1c1585,0xc34800de}},	//   _باشه_, _mady, gurs, _hổ_,
   {{0x66031586,0x69dc1587,0x6e3c028d,0x6497020a}},	//   zank, _agre, aerb, pţie,
   {{0x3ec71588,0x7ae40372,0x7c2d1556,0x765a084e}},	// [d90] _особ, gqit, rfar, _onty,
   {{0x27ff0185,0x76480ece,0x68fc0150,0xc34800de}},	//   _seun_, _nady, _bwrd, _mổ_,
   {{0x6f1d002b,0x48151589,0x644900f0,0x6e25158a}},	//   lusc, емес, ydei, _ichb,
   {{0x6d4508f0,0x6603158b,0x765a158c,0x38660052}},	//   _isha, wank, _anty, gjor_,
   {{0x764812ff,0xc34800de,0x7bdd02c9,0x785e00ae}},	//   _bady, _nổ_, _igsu, _săvâ,
   {{0x68fc00f0,0x6459009c,0x7648041c,0x00000000}},	//   _fwrd, _snwi, _cady, --,
   {{0x7648008c,0x27ff01cb,0x224700ca,0x644909ad}},	//   _dady, _teun_, _rank_, tdei,
   {{0x9345158d,0xc3480019,0x61ea158e,0x6d45158f}},	//   ение, _bổ_, _affl, _msha,
   {{0x442d1590,0xc3480028,0xa3ca009d,0x7d1c1591}},	//   rfe_, _cổ_, ळेल_, zurs,
   {{0x27290fb6,0x764802f1,0x6603008a,0xda0f1592}},	//   mún_, _gady, qank, ाणित_,
   {{0x6d451593,0x27290037,0x386d00aa,0x442d1594}},	//   _nsha, lún_, _koer_, pfe_,
   {{0x6e3c02e2,0x386d034f,0xf09f00b3,0x6f1d0036}},	//   werb, _joer_, gnà_, fusc,
   {{0x66011595,0x6d451596,0xda0f009d,0x386d0abf}},	//   _kelk, _asha, ाणात_, _moer_,
   {{0x7d1c01ab,0x386d057a,0x249f003e,0x6e3c1597}},	//   turs, _loer_, lnum_, uerb,
   {{0x387f0702,0x66011598,0x7afd1599,0xed57159a}},	//   _olur_, _melk, _awst, нор_,
   {{0x249f0102,0x6e3c159b,0x66010018,0x7f44005c}},	//   nnum_, serb, _lelk, _tsiq,
   {{0x6d45159c,0xc34800de,0x249f003e,0xb09b0796}},	// [da0] _esha, _xổ_, inum_, _מיקר,
   {{0x6d4500dd,0x387f159d,0x32051177,0x2d8c037a}},	//   _fsha, _alur_, naly_, údes_,
   {{0x387f02e5,0x7648159e,0x386d159f,0x249f0088}},	//   _blur_, _rady, _boer_, knum_,
   {{0xd7060636,0x76480bb6,0x3ae40653,0xa2c10285}},	//   езди, _sady, _töp_, _रीस्,
   {{0x272915a0,0x61360068,0x660115a1,0x386d15a2}},	//   gún_, _külö, _belk, _doer_,
   {{0x66010871,0xc3480023,0x69dc15a3,0x387f15a4}},	//   _celk, _rổ_, _ugre, _elur_,
   {{0xc3480019,0x2ca015a5,0x249f0088,0xfaa315a6}},	//   _sổ_, onid_, fnum_, _саро,
   {{0x249f0088,0x545415a7,0x660100aa,0x95530adb}},	//   gnum_, твит, _eelk, اخوا,
   {{0x660115a8,0xc7a315a9,0xb05b0149,0x764807ac}},	//   _felk, _битк, lläg, _tady,
   {{0x2c7c0610,0x2ca00076,0x386d0381,0x717806e7}},	//   _oído_, hnid_, _zoer_, дбор_,
   {{0xb05b0222,0x2b910220,0xbbbe0eeb,0x5a17006e}},	//   nläg, môcť_, ्धुक, עקטן_,
   {{0xc3480028,0xbebb023b,0x6f1d15aa,0x69c30034}},	//   _tổ_, ntëv, tusc, żneg,
   {{0x442615ab,0xb05b01bf,0xfebb0037,0x320515ac}},	//   _ico_, hläg, كاست_, baly_,
   {{0x6f1d15ad,0xa01b0364,0xb05b02c3,0xddde00d2}},	//   rusc, chön, kläg, _kopř,
   {{0xac9500ba,0x8d7715ae,0x00000000,0x00000000}},	//   вавш, راسا, --, --,
   {{0xdcb80465,0x6f1d1163,0xb05b02c3,0x6d450381}},	//   ещу_, pusc, dläg, _vsha,
   {{0x649700d3,0x386d000b,0xfaf015af,0x00d80103}},	// [db0] nţia, _roer_, مثل_, _ثبوت_,
   {{0x6d450d7d,0x3b0915b0,0x6f0d15b1,0xdb26001c}},	//   _tsha, rsaq_, _ivac, ئولی,
   {{0x3b09009e,0x6d4515b2,0x44260042,0x98b3033b}},	//   ssaq_, _usha, _oco_, žeča_,
   {{0x442601bb,0x6f0d015c,0x66010084,0xb06600c2}},	//   _nco_, _kvac, _selk, mpää,
   {{0xf74515b3,0x66010084,0x386d0305,0xb05b15b4}},	//   тело, _pelk, _voer_, lmäs,
   {{0x272915b5,0xe9d30421,0x386d02ac,0x2a7a0231}},	//   rún_, _مغز_, _woer_, ckpb_,
   {{0x660115b6,0x320515b7,0x386d057a,0x272915b8}},	//   _velk, valy_, _toer_, sún_,
   {{0x660115b9,0x6f0d042d,0x3e74042c,0x387f023b}},	//   _welk, _ovac, _hätt_, _ulur_,
   {{0x249f0088,0x320515ba,0xd84202c6,0x69c80094}},	//   rnum_, taly_, áčů_, _úder,
   {{0xdeab0022,0x249f15bb,0xb05b02c3,0x442615bc}},	//   ƙiƙa, snum_, kmäs, _eco_,
   {{0xb05b15bd,0x6f0d15be,0x320515bf,0x3e740212}},	//   kläd, _avac, raly_, _mätt_,
   {{0x3e740222,0x320515c0,0xdee60613,0x649700e8}},	//   _lätt_, saly_, коми, rģis,
   {{0x443f15c1,0xab5b0103,0x10a315c2,0x320500d4}},	//   meu_, _szün, риян, paly_,
   {{0x6da615c3,0x443f15c4,0x644b15c5,0xaca40129}},	//   вига, leu_, _hagi, _mmụt,
   {{0x644b15c6,0x6f0d15c7,0x27ed042c,0x2907020a}},	//   _kagi, _evac, _ofen_, ânal_,
   {{0x443f0472,0x7f8600e3,0x7cdc009c,0x6f960037}},	//   neu_, _للبن, _cōra, _للعض,
   {{0x644b15c8,0x443f15c9,0x7c2b0013,0xeb9715ca}},	// [dc0] _magi, ieu_, ògra, вит_,
   {{0x644b15cb,0xaa7b003e,0x443f15cc,0xb05b15cd}},	//   _lagi, _stýr, heu_, smät,
   {{0xaca40129,0x6f0d028a,0xb05b00ce,0x00000000}},	//   _amụt, _zvac, mmär, --,
   {{0x644b15ce,0x63a40088,0xb05b15cf,0x7f56023b}},	//   _nagi, _þing, rläg, _kryq,
   {{0x443f15d0,0x27e015d1,0xb05b0212,0xbebb0052}},	//   deu_, žino_, släg, rtëv,
   {{0x7bc60b27,0x7c24013f,0xbebb023b,0xca760109}},	//   _izku, lgir, stëv, _румы,
   {{0x644b15d2,0x92de00c7,0xc5d500c7,0x443f15d3}},	//   _bagi, _তবে_, _স্বপ, feu_,
   {{0x7c24149c,0x38c803ed,0x443f0472,0x00000000}},	//   ngir, _سازی_, geu_, --,
   {{0x442615d4,0xb05b15d5,0xf2c615d6,0x225c01c8}},	//   _vco_, kmär, ксон, _pnvk_,
   {{0x78a215d7,0x649700ae,0x644b15d8,0x6f0d0344}},	//   lnov, rţia, _eagi, _rvac,
   {{0x443f15d9,0x644b15da,0x518615db,0x44260324}},	//   beu_, _fagi, тупа, _tco_,
   {{0x443f15dc,0x78a215dd,0x044615de,0x61f5008b}},	//   ceu_, nnov, _једн, ızla,
   {{0x6440026a,0x623415df,0x9f5902c3,0xadc40139}},	//   memi, _белу, kaså_, _ijẹu,
   {{0x644015e0,0x644b15e1,0x6497002d,0x7c240062}},	//   lemi, _zagi, nţin, egir,
   {{0x3e74070a,0x644b0ab1,0x7bc60634,0x7c3f013c}},	//   _rätt_, _yagi, _azku, teqr,
   {{0x644015e2,0x3e74070a,0x7c2415e3,0x6abd15e4}},	//   nemi, _sätt_, ggir, ्ग्र,
   {{0x4ea715e5,0x5a350fa5,0xb05b15e6,0xbebb023b}},	// [dd0] _арна, лнат, smäs, ftët,
   {{0x443f15e7,0x644015e8,0xdce70034,0x9b440018}},	//   zeu_, hemi, zyję, ؤنلو,
   {{0x391515e9,0x7bc601e9,0x83fd0103,0x443f15ea}},	//   умер, _ezku, rkőz, yeu_,
   {{0x2bae0f53,0x443f0428,0x78a215eb,0x28f8002d}},	//   _झुका, xeu_, gnov, тець_,
   {{0x644b15ec,0x443f15ed,0x291a028d,0x3e740212}},	//   _ragi, veu_, arpa_, _tätt_,
   {{0x644b15ee,0xe5a515ef,0x00000000,0x00000000}},	//   _sagi, лили, --, --,
   {{0x644b15f0,0x443f15f1,0x78a215f2,0x27ee02c6}},	//   _pagi, teu_, bnov, émní_,
   {{0x644015f3,0x69c715f4,0x332d03e5,0xfd5e0294}},	//   gemi, _izje, ttex_, _anyị,
   {{0x443f15f5,0xbebb023b,0x2cb90167,0x67d4002d}},	//   reu_, ntës, _mksd_, _воту,
   {{0x443f15f6,0x644b15f7,0xb63415f8,0x6d5700a7}},	//   seu_, _wagi, _نعمت, _orxa,
   {{0xab5b0068,0x644b15f9,0xe4e702ec,0x443f15fa}},	//   _szül, _tagi, _різн, peu_,
   {{0xa3550f43,0xc87900ae,0xbebb0052,0xa3ea0285}},	//   _مختص, _fişe_, ktës, _मलय_,
   {{0xbebb00dd,0x6d5715fb,0x6d41026a,0x9975007f}},	//   jtës, _arxa, çlan, nęła_,
   {{0x78a21271,0x539a0341,0xdee30b3b,0x00000000}},	//   znov, _אינו, сори, --,
   {{0x78a215fc,0x649700d3,0x7c2415fd,0x25eb00aa}},	//   ynov, nţio, tgir, _चलनी_,
   {{0xb05b007a,0xdd8f0037,0xb5fc009e,0xbebb0052}},	//   smär, سوق_, _inġe, ftës,
   {{0x78a215fe,0xb05b0149,0x69c700bd,0x5f46001c}},	// [de0] vnov, pmär, _azje, _صندل,
   {{0xddb60190,0x644015ff,0x7c241600,0x78a200d4}},	//   _محجب, zemi, sgir, wnov,
   {{0x64401601,0x7c24015e,0xdce801d3,0xaf36001c}},	//   yemi, pgir, ēlēt, _شرکت,
   {{0xe3a700bf,0x644001ff,0xd70a1602,0x66e61603}},	//   _هر_, xemi, енде_, года,
   {{0x78a2110e,0xb8eb048a,0x2bba00e3,0x7bc61604}},	//   rnov, _री_, _ساحة_, _uzku,
   {{0x09e30752,0xbebb0216,0x00000000,0x00000000}},	//   _горн, ltër, --, --,
   {{0x64400b88,0xafdb038c,0x3a2a02ef,0x649700ae}},	//   temi, ndør, _icbp_, rţin,
   {{0x649700d3,0x78a20146,0x00000000,0x00000000}},	//   sţin, čovs, --, --,
   {{0xb5fc0090,0xf2061605,0x6d580b18,0x88b300d1}},	//   _anġe, ляно, _šval, _اینچ,
   {{0x7ae61606,0x86c60037,0x67220138,0x64401607}},	//   _mukt, _صيان, muoj, semi,
   {{0x27e902dd,0x64401608,0x3cf80220,0x649700d3}},	//   žane_, pemi, jprv_, cţio,
   {{0xf993040a,0x649700d3,0x1fdf02d5,0x44ea01ec}},	//   מרת_, nţil, नखेड, _iù_,
   {{0x44ea1609,0x6722013f,0xf4870068,0x26de160a}},	//   _hù_, nuoj, _حالی, _kito_,
   {{0xc7b3028c,0x81d4160b,0xb05b160c,0x660a13d7}},	//   מבר_, _колх, fläc, nafk,
   {{0x629a160d,0x7ae6160e,0x44ea0649,0x6ca7160f}},	//   mito, _aukt, _jù_, граж,
   {{0x44ea1610,0x7ae6113a,0x26de1611,0x1f751612}},	//   _mù_, _bukt, _lito_, _влия,
   {{0x44ea0af0,0x26de0bfe,0x3a381613,0x60cd1614}},	// [df0] _lù_, _oito_, _bbrp_, _iham,
   {{0x44ea04ea,0x26de13b5,0x19591119,0x7ae61615}},	//   _où_, _nito_, казы_, _dukt,
   {{0x60cd1616,0x81b60081,0xbebb0052,0x660a008c}},	//   _kham, চের_, stës, dafk,
   {{0x26de1617,0x89340080,0xa56500cd,0x200b1618}},	//   _aito_, إعلا, یگان, naci_,
   {{0x629a1619,0xe758004d,0x67220138,0x26de0512}},	//   kito, лиці_, guoj, _bito_,
   {{0x44ea1610,0x629a161a,0x87040084,0x26de161b}},	//   _bù_, jito, сяце, _cito_,
   {{0x26de0256,0x200b161c,0x44ea161d,0x6f1d01bf}},	//   _dito_, kaci_, _cù_, hrsc,
   {{0x44ea161e,0x200b161f,0x7ae60113,0x26de0072}},	//   _dù_, jaci_, _yukt, _eito_,
   {{0x200b00e9,0x26de1114,0x6b8d1620,0x6283025b}},	//   daci_, _fito_, nzag, _plno,
   {{0x68e700dd,0x60cd1621,0x65950f2c,0x44ea1622}},	//   _kujd, _aham, _казу, _fù_,
   {{0x76431623,0x60cd009c,0x6f1d1624,0x649700ae}},	//   meny, _bham, ersc, lţim,
   {{0x60cd1625,0x200b1626,0x229b0139,0x236002ef}},	//   _cham, gaci_, _bákè_, _šije_,
   {{0x60cd1627,0xdee61628,0x6b8d015c,0xe3b31629}},	//   _dham, роги, jzag, _ارض_,
   {{0x76430517,0x78a90480,0x6288162a,0xe299162b}},	//   neny, _ljev, chdo, _шал_,
   {{0x7c96162c,0x7523162d,0x78bb0a15,0x6722013f}},	//   арац, nunz, _okuv, zuoj,
   {{0x7643162e,0x200b162f,0x60cd1630,0x32070167}},	//   heny, caci_, _gham, _heny_,
   {{0x76431631,0x4e1a0084,0x60d70341,0xbebb023b}},	// [e00] keny, _июня_, _דוקא_, rtër,
   {{0x75231632,0xef1f0103,0x61e300dc,0xda79004d}},	//   kunz, zzük_, _jgnl, ляє_,
   {{0x2bb80251,0x26de00a6,0xfe3700c1,0x76431633}},	//   _आडवा, _rito_, _דריי_, deny,
   {{0x26de0465,0x60cd1634,0x628801e5,0x629a1635}},	//   _sito_, _xham, zhdo, zito,
   {{0x78a90292,0x26de1636,0x44ea1637,0x629a1638}},	//   _djev, _pito_, _sù_, yito,
   {{0x75231639,0x7643163a,0x6722013f,0x629a0072}},	//   funz, geny, ruoj, xito,
   {{0x6d58163b,0x629a163c,0x321800a5,0x6722163d}},	//   _švaj, vito, órym_, suoj,
   {{0x7c360653,0x26de0051,0x629a163e,0x98a60a54}},	//   nfyr, _wito_, wito, _тибе,
   {{0x629a163f,0x76431640,0x26de1641,0x32071642}},	//   tito, beny, _tito_, _beny_,
   {{0x32071643,0x60cd1644,0xab5b0068,0x3eb802fe}},	//   _ceny_, _sham, _szük, jort_,
   {{0x60cd0060,0x68e0008e,0x6b8d1645,0x200b1646}},	//   _pham, _kimd, zzag, taci_,
   {{0x629a1647,0x66080044,0x859b00ca,0x6f0402a4}},	//   sito, _hedk, _בשבו, _bwic,
   {{0x3eb81648,0x2d9e1649,0x4fc70077,0x6f1d01cb}},	//   fort_, úten_, рсна, ursc,
   {{0x6f1d164a,0x61e3010a,0x660805db,0x92b30076}},	//   rrsc, _ggnl, _jedk, _وحوا,
   {{0xa3ea0454,0x60cd164b,0x200b164c,0xbc07164d}},	//   _मला_, _tham, paci_, ичай,
   {{0x60cd164e,0x320c06c2,0x3d180ccb,0x6b8d01e9}},	//   _uham, lady_, _फिरे_, tzag,
   {{0x2486022e,0xa3ca009d,0x7643164f,0x6f041650}},	// [e10] _mlom_, ळेच_, yeny, _gwic,
   {{0x78a90ea3,0x78bb12e8,0x6286023b,0x76430201}},	//   _sjev, _skuv, ëkoh, xeny,
   {{0x78a903c6,0xbebb00dd,0x27e40085,0x99670d69}},	//   _pjev, rrëd, _bgmn_, штал,
   {{0x76431651,0x320c0094,0x660801ff,0x254701f9}},	//   weny, hady_, _aedk, _ről_,
   {{0x62981030,0xa01b0364,0x78a904e9,0x7f4d02a1}},	//   _omvo, rhöh, _vjev, _jsaq,
   {{0x75231652,0x7bda00a1,0x24861653,0xa01b042c}},	//   tunz, _תקשו, _alom_, shöh,
   {{0x24861654,0x3207022b,0x76431655,0x66081656}},	//   _blom_, _reny_, reny, _dedk,
   {{0x76431657,0x68e0013f,0x78bb1658,0x75230875}},	//   seny, _gimd, _ukuv, runz,
   {{0x75231659,0x7643165a,0xb3d200c3,0x3207165b}},	//   sunz, peny, देलख, _peny_,
   {{0xf67400e3,0x75230193,0x25470103,0x6f040169}},	//   _والخ, punz, _től_, _rwic,
   {{0x3eb8165c,0xd00a165d,0x7f4d039f,0xb80b00aa}},	//   vort_, лене_, _asaq, _हजाम_,
   {{0x3eb802e2,0xb7bd002d,0x200900ae,0xb5fc00bd}},	//   wort_, _acţi, _ceai_, _inġa,
   {{0xd12e03ed,0x42d500d6,0x32070d5b,0x3eb8165e}},	//   ومی_, _ліку, _teny_, tort_,
   {{0x201e165f,0x2009009c,0x24861660,0x00000000}},	//   şti_, _eeai_, _zlom_, --,
   {{0x22451661,0x62811662,0x80f50037,0x3eb81663}},	//   melk_, mklo, _استض, rort_,
   {{0x27e00660,0xb05b1664,0x3eb81665,0x6f041666}},	//   žini_, llän, sort_, _twic,
   {{0x3eb81667,0x7c361668,0xcb671669,0x6f040079}},	// [e20] port_, rfyr, бате_, _uwic,
   {{0x34d300a5,0xb05b00a2,0xa96a166a,0x68e0166b}},	//   दगुद, nlän, лиза_, _simd,
   {{0x66080087,0x2b490188,0xb05b11d0,0x6281166c}},	//   _redk, awac_, ilän, iklo,
   {{0x0aea0037,0x00000000,0x00000000,0x00000000}},	//   _مرسي_, --, --, --,
   {{0x68fb166d,0xb05b02c3,0x628100f3,0x00000000}},	//   _čude, klän, kklo, --,
   {{0xfd650028,0x24860995,0x6281007e,0x00000000}},	//   _nguồ, _slom_, jklo, --,
   {{0x9986054f,0x27e902e6,0x5d7a00c1,0x660801df}},	//   _الأو, žana_, טאַק, _vedk,
   {{0x6608166e,0xa2f4166f,0x00000000,0x00000000}},	//   _wedk, опич, --, --,
   {{0xc44500cd,0xf3ef0037,0xd20a01b6,0x77860284}},	//   زیون_, رأي_, лэнд_, _улаз,
   {{0x273200d3,0xbae50033,0x9f52034f,0xcfce0033}},	//   mân_, _পৌঁছ, _leyó_, রখান,
   {{0x273200eb,0x320c1670,0x3abb0341,0xaabb006e}},	//   lân_, rady_, רמינ, רזיכ,
   {{0x320c1671,0x629d00fd,0x628105c2,0x00000000}},	//   sady_, ésor, aklo, --,
   {{0x320c1672,0x937a1673,0xdb0f0131,0x00000000}},	//   pady_, _حصار_, _excê, --,
   {{0x62811674,0xacf91675,0xddde022b,0x00000000}},	//   cklo, ингу_, _enpō, --,
   {{0x40350d47,0x273200f0,0x00000000,0x00000000}},	//   _дейс, hân_, --, --,
   {{0xce3300bf,0xa0a400c9,0xd0110068,0x7f4d005c}},	//   _کودک, _најд, _کلک_, _tsaq,
   {{0x3a75117c,0xf09f0428,0x00000000,0x00000000}},	// [e30] олар, mià_, --, --,
   {{0x9e071676,0xf09f05fe,0x2eb4007a,0x7aed01ee}},	//   _учил, lià_, ंकृत, rqat,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x50c91677,0xb0c91678,0x17fb0037,0xf09f015e}},	//   रतिष, रतिग, ارضة_, nià_,
   {{0x7aed0090,0x2ca91679,0x6281167a,0x00000000}},	//   qqat, mnad_, yklo, --,
   {{0x4519167b,0xf09f0036,0x2ca9167c,0x00000000}},	//   ация_, hià_, lnad_, --,
   {{0x20c9009d,0x224500e8,0x00000000,0x00000000}},	//   रताध, velk_, --, --,
   {{0x2ca9167d,0x236002ef,0x8339001f,0xf1c302c6}},	//   nnad_, _šija_, ачот_, _liší_,
   {{0xf09f0428,0x2d8c167e,0x649700ae,0xfdfb167f}},	//   dià_, údez_, nţii, ्रास_,
   {{0x2ca90150,0xe2990291,0x00000000,0x00000000}},	//   hnad_, рао_, --, --,
   {{0xb05b1680,0xe0461681,0x62811682,0xc66800c9}},	//   rlän, онни, rklo, _уште_,
   {{0x61fc07aa,0xb05b1683,0x7e65020b,0x00000000}},	//   ırla, slän, _anhp, --,
   {{0x3f841684,0x443d010a,0xb05b1489,0x2ca90b85}},	//   ámu_, _ibw_, plän, dnad_,
   {{0x7c2f1685,0x3f8c0034,0x248d1686,0x2eb41687}},	//   _accr, ądu_, lhem_, ंकेत,
   {{0xe7fc030b,0x3f840031,0xf09f00b3,0x1d0a0da5}},	//   उँमा_, šmu_, bià_, реби_,
   {{0x90c30d47,0x248d1688,0x9f5206a3,0xf09f0428}},	//   _обще, nhem_, _deyò_, cià_,
   {{0xdca303bf,0x8af70092,0xab2a1689,0x2d910036}},	// [e40] фати, _şəra, роза_, azze_,
   {{0xa01b168a,0x443d168b,0x4a430161,0x00000000}},	//   nkön, _lbw_, мнув, --,
   {{0x443d0283,0xdb060212,0x249f0063,0x3dcd03e3}},	//   _obw_, _nykö, kium_, ƙewa_,
   {{0x442f0042,0xab2a168c,0xd7f00076,0xa01b00ce}},	//   _ncg_, _кома_, ركت_, hkön,
   {{0x05260081,0x249f168d,0x649700ae,0xa01b168e}},	//   _মনের_, dium_, cţii, kkön,
   {{0x05760391,0x63a401b3,0x442f01b9,0x6d5e166d}},	//   قاعد, _žino, _acg_, _krpa,
   {{0x443d168f,0x442f0172,0x2907020a,0x38cb00d1}},	//   _bbw_, _bcg_, ânat_, _چاقی_,
   {{0x69ce1690,0x442f1691,0x7d7b006e,0x443d1692}},	//   _izbe, _ccg_, ינצו, _cbw_,
   {{0x926a1693,0xd7ef0037,0xb6a61694,0xe3af0018}},	//   арна_, _شكل_, _диал, ہری_,
   {{0xa5f70291,0x2ca00188,0xb5fc0090,0xdeb403e3}},	//   _међу_, hiid_, _inġo, ƙaƙa,
   {{0x2b420063,0xe3af015a,0xdb0f1695,0xf09f00b3}},	//   _lpkc_, فری_, _excè, tià_,
   {{0x248d1696,0x27e0005f,0x6e3e0063,0x442f0167}},	//   chem_, žinu_, _abpb, _gcg_,
   {{0x98b30995,0xf09f05fe,0x2ca00188,0x2ca905e8}},	//   žeća_, rià_, diid_, vnad_,
   {{0x69ce01c2,0x6d5e0167,0x626313c7,0x9f52022b}},	//   _ozbe, _brpa, _овча, _peyò_,
   {{0x2d850618,0x66cd0181,0xb05b09df,0x628a00ae}},	//   ále_, núka, lläm, _ilfo,
   {{0xbca50037,0x6d5e00c4,0x67221697,0x9f61020a}},	//   أمري, _drpa, kroj, ăpân_,
   {{0x2d850335,0x7de704a1,0x6d5e0270,0x2a781698}},	// [e50] šle_, _мінд, _erpa, _borb_,
   {{0x249f1699,0x6722169a,0x2a78169b,0x248d0a39}},	//   zium_, droj, _corb_, zhem_,
   {{0xdcef01d3,0x37f80134,0x5f74001c,0x2ca9169c}},	//   ēdēt, _ịkụz, _فایر, pnad_,
   {{0x2ca0008a,0x63ad003e,0x6497044c,0x22890206}},	//   ciid_, _þang, pţii, _múka_,
   {{0x69ce169d,0xae1f0abe,0xfc3f0032,0x648e01ec}},	//   _ezbe, _बयान_, _ibí_, _mùid,
   {{0x7bda00a1,0x442f169e,0x5b7a00d7,0x00000000}},	//   _לקרו, _scg_, _הרשא, --,
   {{0x442f0072,0xa8a7169f,0x20020034,0xb5fc0090}},	//   _pcg_, _драк, ybki_, _inġl,
   {{0x672203ce,0xddc70031,0x00000000,0x00000000}},	//   broj, rejň, --, --,
   {{0x248d0e53,0xf5590281,0xec7900fe,0x7c2d16a0}},	//   rhem_, _گلاب_, _độc_, igar,
   {{0x248d00dd,0x7c2d0150,0xc879026a,0x8af000a7}},	//   shem_, hgar, _hoş_, dvəl,
   {{0x63ad16a1,0x648e009c,0x7c2d0381,0x6b89007f}},	//   _žand, _bùid, kgar, _żegl,
   {{0x2eb60af1,0x628a0018,0xdb0f054e,0x443d02a4}},	//   ृत्त, _elfo, _excé, _ubw_,
   {{0xe28e08c3,0x44f100c9,0xb4b7009d,0x6d5e16a2}},	//   _за_, _há_, चकी_, _srpa,
   {{0x442d13c8,0x44f10d79,0x7c2d16a3,0xfc3f0065}},	//   lge_, _ká_, egar, _abí_,
   {{0x44f116a4,0x2ca001ff,0x648e01b9,0x442d041c}},	//   _já_, tiid_, _fùid, oge_,
   {{0x7c2d16a5,0x768f004d,0xb5fc0078,0x672216a6}},	//   ggar, _høyd, _anġl, yroj,
   {{0x44f116a7,0x442d16a8,0x20d200e3,0x2ca016a9}},	// [e60] _lá_, ige_, ráid_, riid_,
   {{0x7c2d01b5,0x39430085,0x20d20037,0x6d5e16aa}},	//   agar, _bpjs_, sáid_, _trpa,
   {{0x44f116ab,0xd7fa044b,0xc8790511,0x8e7b00ca}},	//   _ná_, бул_, _boş_, _הניה,
   {{0x672216ac,0xc87916ad,0x9f59037a,0x26c705db}},	//   troj, _coş_, casó_, elno_,
   {{0x27e00084,0x442d00a1,0x44f116ae,0x6d5c16af}},	//   äin_, dge_, _aá_, lvra,
   {{0x44f102b4,0x672216b0,0xa96a0114,0x442d16b1}},	//   _bá_, rroj, _лига_, ege_,
   {{0xd94316b2,0x44f116b3,0x6d5c16b4,0x9c831271}},	//   _пери, _cá_, nvra, ščev,
   {{0x44f116b5,0x442d16b6,0x7bc6010a,0xb4c806eb}},	//   _dá_, gge_, _kyku, ोगे_,
   {{0x68ee01ee,0x00000000,0x00000000,0x00000000}},	//   _hubd, --, --, --,
   {{0xaabe16b7,0x44f116b8,0x442d16b9,0x7c2d16ba}},	//   ्तिक, _fá_, age_, zgar,
   {{0x44f116bb,0x7c2d16bc,0x044616bd,0x442d0d2a}},	//   _gá_, ygar, _нежн, bge_,
   {{0x66cd0220,0x7c2d0188,0xc87900a7,0x78a200d4}},	//   núkn, xgar, _xoş_, niov,
   {{0xaabe11c6,0xb05b00c2,0xa01b042c,0x623416be}},	//   ्ताक, lläk, fhör, _желу,
   {{0x68fc00d9,0x1df80109,0x2ee50364,0xddc502c6}},	//   _otrd, зеры_, ölf_, _zahř,
   {{0x291c0068,0xd23b00a1,0xdb1d00b6,0x44f10023}},	//   ával_, _הגול, _vysí, _xá_,
   {{0x7c2d16bf,0xd13800c6,0xb4fb0266,0x5d5416c0}},	//   ugar, mtą_, מפלי, экст,
   {{0x7c2d16c1,0x649700ae,0x768f00d6,0x2918028d}},	// [e70] rgar, cţiu, _høye, _avra_,
   {{0x7c2d16c2,0x6ce700d6,0x1eea001c,0xd13816c3}},	//   sgar, _німе, _گویی_, otą_,
   {{0xd138013f,0x442d00f2,0xa01b00ce,0x00000000}},	//   ntą_, yge_, hköm, --,
   {{0x44f116c4,0x78a2028d,0xd1380138,0x6d450201}},	//   _rá_, giov, itą_, _ipha,
   {{0x29180831,0x2d8301b3,0xb8f4009f,0x44f116c5}},	//   _evra_, lyje_, _सी_, _sá_,
   {{0x44f116c6,0xd138013f,0x61ea0113,0xb05b16c7}},	//   _pá_, ktą_, _ngfl, rmäy,
   {{0x442d16c8,0x2d83013f,0xe61000b9,0x3f8216c9}},	//   tge_, nyje_, اشه_, zyku_,
   {{0x44f116ca,0x442d16cb,0x78a20244,0xb4b7058f}},	//   _vá_, uge_, ciov, चके_,
   {{0x44f10649,0x26c70146,0x68ee03e3,0xe78400ae}},	//   _wá_, plno_, _zubd, _пуфо,
   {{0x44f116cc,0x6d4516cd,0x442d01b5,0x7d1a0220}},	//   _tá_, _opha, sge_, átsk,
   {{0x6d45022e,0xbebb0052,0x7ae716ce,0x442d02c3}},	//   _npha, trën, _mijt, pge_,
   {{0xbe250081,0x6724015c,0x8fa600ae,0x7afd00bc}},	//   ম্মদ_, šije, даме, _otst,
   {{0x6d45019f,0x3ea312f7,0x7afd16cf,0x00000000}},	//   _apha, fijt_, _ntst, --,
   {{0xdd92015a,0xafdb00f2,0x6497020a,0x6d5c01fc}},	//   پور_, dfød, rţiu, tvra,
   {{0xdee316d0,0x7afd16d1,0xe810000d,0xed570636}},	//   тори, _atst, ारमा_, мор_,
   {{0x69da0396,0x68ee01c2,0x291c0031,0x25fd0096}},	//   _útei, _rubd, ávam_, रुती_,
   {{0x60c416d2,0x7ae716d3,0x6d450201,0xab5b0103}},	// [e80] _ikim, _bijt, _epha, _szür,
   {{0x7bc616d4,0xab5b0018,0x68ee16d5,0x00000000}},	//   _vyku, _gyüm, _pubd, --,
   {{0xceb30130,0xbebb023b,0x994a08ba,0x6abe042c}},	//   _ביז_, ytëz, تلال_, ropf,
   {{0x7aef020a,0x672b150c,0xb4b700b6,0xcb6a02e1}},	//   _fuct, fugj, चको_, _даме_,
   {{0x78a216d6,0x3b040139,0x7bc6026a,0x60c40a4b}},	//   riov, _dépò_, _uyku, _mkim,
   {{0xd13816d7,0xa92616d8,0x6b840027,0x6eeb02a1}},	//   ytą_, _одгл, myig, _użbe,
   {{0x98a616d9,0x25070103,0x68fc0117,0x60c40361}},	//   _живе, ورٹی_, _utrd, _okim,
   {{0x3d110336,0x60c416da,0x399b00ca,0xb05b02c3}},	//   _तबसे_, _nkim, _וילד, rläk,
   {{0x6b8416db,0x752a01c2,0xa2ac0285,0xb05b02c3}},	//   nyig, sufz, ीकल्, släk,
   {{0x60c416dc,0x325416dd,0xa01b042c,0x32050f5a}},	//   _akim, хвор, rköm, gbly_,
   {{0xaca40174,0x60f8097a,0xb05b007b,0x403516de}},	//   _anọt, яння_, lläi, ненс,
   {{0xd13816df,0x60d602ad,0x2d8300c6,0xeb9f00f3}},	//   rtą_, _chym, vyje_, _edøy_,
   {{0xd13816e0,0x6497044c,0x00000000,0x00000000}},	//   stą_, rţit, --, --,
   {{0x60c416e1,0x2bd516e2,0x2d83013f,0xd1380138}},	//   _ekim, _दरबा, tyje_, ptą_,
   {{0x7aef16e3,0x68fb15f4,0x6d5816e4,0x7ae701c0}},	//   _suct, _čudo, _švar, _rijt,
   {{0x96140081,0x2d83013f,0xbf35004d,0x8f3500d3}},	//   সলিম_, ryje_, _знищ, _зеиц,
   {{0x3f4f03e5,0x7ebf00b6,0x3ea3029a,0x92c20033}},	// [e90] _użu_, tápě, pijt_, ্দী_,
   {{0xdddc00cc,0x2d830138,0x6f0d0193,0x2fc900f9}},	//   skrš, pyje_, _iwac, _iyag_,
   {{0x6d450201,0x6b8406b0,0xb05b007b,0x00000000}},	//   _upha, ayig, eläi, --,
   {{0xc8790702,0x386911ce,0x6f0d16e5,0x80d10081}},	//   _kişi_, ñar_, _kwac, _সূত্,
   {{0x59d41349,0x7afd0578,0xfc3f0103,0x366916e6}},	//   _थरथर, _utst, _amíg_, зало_,
   {{0x644216e7,0xaa450084,0x6288029a,0x6f0d08cc}},	//   _aboi, ävää_, jkdo, _mwac,
   {{0xaabe15e4,0xa2c200aa,0xafdb0120,0x00000000}},	//   ्तरक, रकन्, rdøy, --,
   {{0xa3ba09d0,0x3ea100fe,0xf9920327,0x6f0d16e8}},	//   _आँख_, _lmht_, _ערן_, _owac,
   {{0x27ed16e9,0x6f0d01c2,0x6442009c,0x60d616ea}},	//   _igen_, _nwac, _dboi, _rhym,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x68e90067,0x21690636,0x320516eb,0x6442009c}},	//   _kied, чини_, rbly_, _fboi,
   {{0x2280022b,0x6f0d02a4,0x64420139,0xc8790233}},	//   _bòks_, _bwac, _gboi, _bişi_,
   {{0x68e916ec,0x6f0d010a,0x443f16ed,0x6497020a}},	//   _mied, _cwac, mfu_, bţir,
   {{0x52390130,0x443f16ee,0x68e916ef,0x6459008a}},	//   _זײַנ, lfu_, _lied, _hawi,
   {{0xfaff01e5,0x645916f0,0x27ed0126,0x7bcb01bf}},	//   _atë_, _kawi, _ogen_, ügun,
   {{0x68e916f1,0x63a4013f,0x60c40010,0xfa090033}},	//   _nied, _žini, _ukim, _লাগল_,
   {{0x6d410b88,0x64590010,0xfc3f0065,0x443f0051}},	// [ea0] çlar, _mawi, _ajís_, ifu_,
   {{0x27ed048e,0x6b840169,0x248f030a,0x00000000}},	//   _agen_, ryig, _llgm_, --,
   {{0x68e916f2,0x35c4009f,0xdb1d0146,0xd7fa002d}},	//   _bied, _लुढ़, _vysá, пул_,
   {{0x7e7e057e,0x645900a5,0xb5fc0078,0x645b044c}},	//   _hopp, _nawi, _inġi, jdui,
   {{0x7e7e16f3,0x175400c2,0xe7c00033,0xd7071102}},	//   _kopp, твля, েশ্য, енче_,
   {{0x20120065,0x27ed16f4,0x443f061f,0x7e7e16f5}},	//   _leyi_, _egen_, efu_, _jopp,
   {{0x80d100c7,0x443f16f6,0x7e7e16f7,0x6abe16f8}},	//   _সংস্, ffu_, _mopp, ्तीर,
   {{0x7e7e16f9,0xd49716fa,0x63ad16fb,0x68e916fc}},	//   _lopp, ерь_, _žana, _gied,
   {{0x645916fd,0x82a60ae3,0x7e7e16fe,0x2b52020b}},	//   _dawi, ешне, _oopp, nwyc_,
   {{0x68e900d9,0x20120139,0x443f16ff,0x07a30d9b}},	//   _zied, _aeyi_, afu_, _саун,
   {{0x7d0900e7,0x13ea00ae,0x3ce10096,0x644201b9}},	//   ćesk, _емей_, _कळले_, _tboi,
   {{0x64590256,0x765a0063,0x6abe0d7e,0x6f0d0154}},	//   _gawi, _haty, ्तुर, _pwac,
   {{0x765a1700,0x6d58007e,0x768f004d,0x00000000}},	//   _katy, _švap, _høya, --,
   {{0x64590067,0xa6e700de,0x7e7e0dfc,0xdc030e43}},	//   _zawi, _nhữ, _copp, rčík,
   {{0xb810110f,0x7e7e1701,0x765a1702,0x20d20037}},	//   ाराम_, _dopp, _maty, máin_,
   {{0x765a0ee8,0x20d20037,0x6ca41703,0x6f0d0079}},	//   _laty, láin_, груж, _twac,
   {{0x68e91704,0xfaf30018,0x7e7e1705,0x5a350e3a}},	// [eb0] _ried, اثر_, _fopp, кнат,
   {{0x765a1706,0x68e91707,0x645b00ae,0x20d20037}},	//   _naty, _sied, zdui, náin_,
   {{0x68e91708,0x394705fe,0x48151612,0x5e9c00ca}},	//   _pied, ïns_, вмес, _מבזק,
   {{0x20d2054f,0x26c5025b,0xe0df1709,0x7e7e028d}},	//   háin_, _sklo_, nmò_, _zopp,
   {{0x6459170a,0x68e9170b,0x765a170c,0x20d90037}},	//   _rawi, _vied, _baty, méid_,
   {{0x68e9170d,0x6459170e,0x945d00a5,0x20d90037}},	//   _wied, _sawi, końc, léid_,
   {{0x68e902fd,0x6459170f,0x443f1710,0x20d20037}},	//   _tied, _pawi, tfu_, dáin_,
   {{0x67241711,0x27ed052f,0x20d90076,0x929d007f}},	//   šija, _ugen_, néid_, dpła,
   {{0x645b1712,0xe2990aa8,0x443f1713,0x23db00c3}},	//   rdui, дап_, rfu_, मेंद,
   {{0x64590010,0x09e50081,0x765a1714,0x645b1715}},	//   _wawi, _প্যা, _gaty, sdui,
   {{0x81c90f71,0x20120c3e,0x64591716,0x443f0193}},	//   লেন_, _peyi_, _tawi, pfu_,
   {{0x387f04ea,0x7e0a007d,0x7e7e1717,0xa3ba152c}},	//   _jour_, वर्ग_, _sopp, _आँच_,
   {{0xa4d402ec,0x80d10081,0x087600c1,0x6d570188}},	//   _соці, _সংশ্, דערט_, _asxa,
   {{0x9f9e0396,0x20d2109d,0xe0df028d,0x387f022b}},	//   _ação_, cáin_, amò_, _lour_,
   {{0x2d8c1718,0x71640037,0x00000000,0x00000000}},	//   áde_, _مايك, --, --,
   {{0x09b00081,0xeaed055c,0x6495033c,0x00000000}},	//   _করলা, जदूत_, _dáig, --,
   {{0x7e7e0b97,0xf4120130,0xfce31719,0x69d5171a}},	// [ec0] _topp, יפן_, рото, _azze,
   {{0x386d01df,0xdee6171b,0x3ceb0027,0x8a03171c}},	//   _aner_, _шопи, _eicv_, изуе,
   {{0x386d171d,0xceb902c6,0x64950e43,0x00000000}},	//   _bner_, éře_, _káid, --,
   {{0x387f0257,0x765a171e,0x20d90076,0xb05b02db}},	//   _cour_, _saty, céid_, bläu,
   {{0x765a013f,0x69d50018,0x387f171f,0x929d0034}},	//   _paty, _ezze, _dour_, zpła,
   {{0x6f020b88,0x649500e3,0x648e01b9,0x96341720}},	//   _çocu, _láid, _cùin, ункц,
   {{0x64b300d3,0xc60b0081,0x387f1721,0xfaa31722}},	//   răin, _রাখা_, _four_, _таро,
   {{0xb4cc009d,0x00000000,0x00000000,0x00000000}},	//   ळते_, --, --, --,
   {{0x20d20037,0xd2500037,0x00000000,0x00000000}},	//   táin_, منة_, --, --,
   {{0x7c2900d9,0x38bc00d4,0x69da00d4,0x42740c3f}},	//   _ķerm, víry_, _útes, угос,
   {{0x387f1723,0x63ad0102,0x20d20037,0xe13400c6}},	//   _your_, _þann, ráin_, ынны,
   {{0x20d20080,0x63a401b3,0x2ebd0f62,0x66181724}},	//   sáin_, _žinu, ोत्त, lavk,
   {{0xe0df0451,0x20d20076,0x909800e5,0x6495033c}},	//   rmò_, máil_, твят_, _dáid,
   {{0x44f80d79,0x395802ef,0x6fe901d3,0x20d20076}},	//   _ké_, _osrs_, _rīcī, láil_,
   {{0x44f80649,0x395800e7,0x9c830094,0x3ead00c4}},	//   _jé_, _nsrs_, áčov, đet_,
   {{0x44f81725,0x273b00ef,0x80d10033,0x23661726}},	//   _mé_, yên_, _সূর্, _kroj_,
   {{0x44f802b4,0x20191727,0x1af41728,0x661800d8}},	// [ed0] _lé_, masi_, иптя, kavk,
   {{0x20d20080,0x7e5500d6,0x44f80037,0xb05b0364}},	//   háil_, _своє, _oé_, rläu,
   {{0x387f1729,0x6618025b,0x20d900e3,0x69c80856}},	//   _pour_, davk, péid_, _ødel,
   {{0xdb1d00c2,0xb4cc0096,0x5c0400e5,0x00000000}},	//   _pysä, ळतो_, _вяра, --,
   {{0xfeb8172a,0x9cd60c6a,0x20d200e3,0x2366022e}},	//   _سایت_, _תורה_, dáil_, _nroj_,
   {{0x44f8172b,0x2ca902ad,0x2019172c,0x25570092}},	//   _bé_, liad_, hasi_, _hələ_,
   {{0x2019172d,0x44f80080,0x888300bf,0x387f172e}},	//   kasi_, _cé_, _پیشن, _tour_,
   {{0x236600e9,0x44f8172f,0x20d20080,0x2ca902ad}},	//   _broj_, _dé_, gáil_, niad_,
   {{0x66181100,0x69da00b6,0xb5fc02a1,0x44f80af0}},	//   bavk, _úter, _anġu, _eé_,
   {{0x44f80649,0x2019002d,0x2ca900f0,0x6f1d1730}},	//   _fé_, easi_, hiad_, dssc,
   {{0x2019068d,0x44f80649,0xa29f0006,0x23660078}},	//   fasi_, _gé_, गोष्, _eroj_,
   {{0x20191731,0x20d200e3,0x68f51732,0x27e909ac}},	//   gasi_, cáil_, _muzd, žanu_,
   {{0x32450636,0x2ca902e0,0x44f80161,0x23661733}},	//   _белг, diad_, _zé_, _groj_,
   {{0xed5a15de,0x248d030b,0x44f8026e,0xf2070686}},	//   ног_, lkem_, _yé_, _рядо,
   {{0x2ca902ad,0x20191734,0x68f500cc,0x2b4b00b3}},	//   fiad_, basi_, _nuzd, _apcc_,
   {{0x6abe0c38,0x2ca902ad,0x7d1c0161,0x20191735}},	//   ्त्र, giad_, rsrs, casi_,
   {{0xab661736,0xab270818,0xb05b0212,0xceb60dce}},	// [ee0] ывал, лота_, rlät, _محدث,
   {{0x248d0006,0x68f51737,0xed5a11cc,0xb8650d7f}},	//   hkem_, _buzd, _зоо_, یانو,
   {{0xb05b01bf,0x248d1738,0x648e009c,0xdca6079c}},	//   plät, kkem_, _bùil, _бани,
   {{0x44f81739,0xb05b173a,0x648e01b9,0x3958033b}},	//   _ré_, llär, _cùil, _vsrs_,
   {{0x44f8173b,0x248d00b6,0x76430167,0x648e01ec}},	//   _sé_, dkem_, ffny, _dùil,
   {{0x44f802b4,0x4ab8000c,0x248d01c0,0x2019173c}},	//   _pé_, _आदिव, ekem_, zasi_,
   {{0x20190f28,0x20d20080,0x2b40173d,0x60c603a9}},	//   yasi_, táil_, ltic_, kokm,
   {{0x6f040ca7,0x44f80019,0x2366173e,0x768f00f3}},	//   _otic, _vé_, _proj_, _høyl,
   {{0x36360241,0x20190498,0xe80a02e8,0x20d20080}},	//   _مراس, vasi_, _ह्या_, ráil_,
   {{0x44f8173f,0x20191740,0xfaff023b,0x20d200e3}},	//   _té_, wasi_, _orën_, sáil_,
   {{0xe3af09e5,0x6f041741,0x44f8016d,0x32630138}},	//   قری_, _atic, _ué_, стыв,
   {{0x68e21742,0x6f1d1743,0x6f040036,0x248d1744}},	//   nmod, tssc, _btic, ckem_,
   {{0xb4c005d4,0xb4c202e8,0x2366023b,0x6f1d042c}},	//   ंकी_, ृती_, _uroj_, ussc,
   {{0x20191745,0x25630b88,0x2ca9053c,0x3eaa0364}},	//   sasi_, _yıl_, wiad_, gibt_,
   {{0x6f040977,0x20190da3,0xdd940077,0x69ce0073}},	//   _etic, pasi_, бары, _nybe,
   {{0xb05b160c,0x2b4000e7,0x201911bc,0x2b4b015e}},	//   rläs, ftic_, qasi_, _ppcc_,
   {{0x2ca91746,0x68f51747,0xddde0154,0xb05b03bd}},	// [ef0] riad_, _suzd, _lapň, släs,
   {{0x69ce0665,0x2ca90150,0x8f9c00c1,0x68f50031}},	//   _bybe, siad_, _ריזי, _puzd,
   {{0x81e60033,0xb9b50cc8,0x2ca91748,0x7aee01ee}},	//   যুর_, جماع, piad_, _dibt,
   {{0x69ce02b6,0x2137006e,0x76481749,0x00000000}},	//   _dybe, רטאל_, _abdy, --,
   {{0x6568174a,0x2b40174b,0xdc360130,0x648e009c}},	//   _ardh, ctic_, _דארט_, _cùim,
   {{0x7aee01bf,0x83fd0018,0x68f5174c,0xab6601d3}},	//   _gibt, zdőd, _tuzd, _daļē,
   {{0x248d174d,0xd6180037,0x291c00b6,0x68e20131}},	//   tkem_, اتها_, ávat_, bmod,
   {{0x032508c3,0x06b102c6,0x693400d3,0xc485174e}},	//   адин, _řídí_, _ынсу, рлик,
   {{0x656800dd,0xc6140081,0x67d4004d,0x248d174f}},	//   _erdh, _সারা_, _готу, rkem_,
   {{0x78ab038c,0x248d1750,0x64870314,0x2d9c01f9}},	//   ligv, skem_, _añit, _üveg_,
   {{0xe0da1751,0x26c71752,0x39411753,0x6f041754}},	//   кво_, mono_, nths_, _stic,
   {{0xaca30134,0x6e250013,0x26c71755,0x78ab1570}},	//   _brọd, _adhb, lono_, nigv,
   {{0xe28e1756,0xa3e91757,0x7d050037,0xa85600ca}},	//   _да_, _मणि_, _aths, בירה_,
   {{0x91e51758,0x26c70517,0x539a00a1,0x11670103}},	//   _коле, nono_, _בינו, _ملتی_,
   {{0xb05b07ee,0x26c700e5,0x5fd80096,0x68e200eb}},	//   rlär, iono_, _ठरवल, ymod,
   {{0xdd8f0bf4,0x62831759,0x26c7019f,0x69ce0ecb}},	//   ذوق_, _hono, hono_, _rybe,
   {{0x26c7175a,0x6f04175b,0x78ab02b6,0x68e2175c}},	// [f00] kono_, _utic, digv, vmod,
   {{0x26c7013f,0x2b40175d,0xa01b175e,0x6283175f}},	//   jono_, rtic_, sköt, _jono,
   {{0x2b401760,0x6283028d,0xd83a01b6,0x26c7008f}},	//   stic_, _mono, вэл_, dono_,
   {{0x2b401761,0x69ce0074,0x7e030174,0xa01b1762}},	//   ptic_, _vybe, ọstu, lkör,
   {{0x26c71763,0xbebb00dd,0x76940139,0x62830167}},	//   fono_, rrëv, _aàya, _oono,
   {{0x62831764,0x68e20429,0x69ce1765,0xafdb01df}},	//   _nono, smod, _tybe, dføl,
   {{0xa3e302d5,0x68e21766,0xa01b0212,0x768f00f3}},	//   फेस_, pmod, ljöe, _gøym,
   {{0xd7061612,0x260604f1,0x776901ff,0x6283033c}},	//   _взаи, _स्री_, _frex, _aono,
   {{0xf74900cd,0xa2c2009d,0x26c70201,0x389b0796}},	//   _مجله_, रकल्, bono_, _סימנ,
   {{0x62831767,0x26c71768,0x20d90231,0x00000000}},	//   _cono, cono_, déia_, --,
   {{0x62831769,0x7c26176a,0xd48f176b,0x99f70054}},	//   _dono, _odkr, _др_, יזיה_,
   {{0xdcee013f,0x75d3001c,0xb97b00ca,0xdb1d0206}},	//   mybė, _بيما, דנטי, _vysú,
   {{0x4426176c,0x6283176d,0xe3b20241,0xbfa8176e}},	//   _ido_, _fono, _برا_, атре_,
   {{0x6283176f,0x00000000,0x00000000,0x00000000}},	//   _gono, --, --, --,
   {{0x44261770,0xdcee0138,0x57d30085,0xb5fc00bd}},	//   _kdo_, nybė, _तर्ह, _gaġe,
   {{0x30150161,0x26c71771,0x80d10081,0x27e00146}},	//   _удир, zono_, _সংক্, žiny_,
   {{0x60cd1772,0x26c70510,0x44260a4b,0x6d480233}},	// [f10] _ikam, yono_, _mdo_, çdar,
   {{0x99671773,0xdcee0138,0x3b0900a7,0x44260231}},	//   ител, kybė, rpaq_, _ldo_,
   {{0xd366172a,0x44261774,0x161a0067,0x26c7013d}},	//   _که_, _odo_, _नज़र_, vono_,
   {{0x776908a8,0xa3cc0179,0x44261775,0xb4c0030b}},	//   _prex, _शुभ_, _ndo_, ंको_,
   {{0x26c71776,0x60cd0239,0xc7b901f9,0xcc761777}},	//   tono_, _mkam, _idők_, _הערה_,
   {{0xc9871778,0x6b8d1779,0x2bb40176,0x00000000}},	//   _куби, myag, ंपरा, --,
   {{0x09e50f71,0x99850080,0x1a6800bf,0x60cd025b}},	//   _প্রা, _الزو, _خیلی_, _okam,
   {{0x442600dd,0xa8a4013a,0xe570177a,0x26c7177b}},	//   _cdo_, _друк, بطه_, sono_,
   {{0x6b8d177c,0x26c7177d,0x4426177e,0x78a9177f}},	//   nyag, pono_, _ddo_, _imev,
   {{0x60cd1652,0x44261780,0x81c200c7,0xafdb038c}},	//   _akam, _edo_, ্ধন_, rføl,
   {{0x62831781,0xb5a71782,0xa01b02c3,0x00000000}},	//   _vono, _трай, vkör, --,
   {{0x656e054f,0x62831783,0x160b1784,0xafdb004d}},	//   _ábha, _wono, _स्तर_, pføl,
   {{0xafdb01c5,0x80d10081,0x23291785,0x443d0167}},	//   lføj, _সংখ্, _соли_, _icw_,
   {{0x629a1786,0xb05b0212,0xe3b000b9,0x60cd019f}},	//   chto, släp, _ترم_, _ekam,
   {{0x7c961787,0x753c01bf,0x69a700af,0xa01b1788}},	//   брац, _ärzt, _टेली, rkör,
   {{0xa9240220,0x20d91789,0xa01b178a,0xa5c3007f}},	//   _úžit, péia_, skör, ciół,
   {{0xc9f600e3,0x09e50081,0xa01b0ee2,0x6b8d178b}},	// [f20] مساع, _প্লা, pkör, gyag,
   {{0xe810178c,0x2bac0096,0x78a90a58,0x7810178d}},	//   ार्थ_, _घेणा, _amev, ार्क_,
   {{0x81c90f71,0x443d178e,0x997c00e8,0x6b8d06b0}},	//   লের_, _ocw_, sāža_, ayag,
   {{0xa01b0149,0x443d178f,0xdcee0138,0xe81a1790}},	//   nköp, _ncw_, vybė, ازات_,
   {{0x20020d62,0x649c0076,0xb8650452,0x442605db}},	//   icki_, _héig, تالو, _rdo_,
   {{0xa01b02fd,0xdcee013f,0xb4c200aa,0x44261791}},	//   hköp, tybė, ृत्_, _sdo_,
   {{0x2bac0096,0xeae40c8c,0x25e31792,0xdcfc00c6}},	//   _घेता, कगीत_, टेली_, tyrę,
   {{0x69dc1793,0x44261794,0xdcee0138,0x836607e8}},	//   _izre, _qdo_, rybė, مدخل,
   {{0x442604de,0x57fb00f5,0x649c00e3,0xa01b0212}},	//   _vdo_, _תלמו, _léig, dköp,
   {{0x60cd1795,0x6d5e1796,0x32180181,0xe810030b}},	//   _skam, _ospa, úry_, ारका_,
   {{0x44261797,0x672201d3,0xa055004d,0x38cb0103}},	//   _tdo_, lsoj, овні, _شاہی_,
   {{0x55770130,0x44261798,0x661a0d80,0x629a00dd}},	//   _לעבן_, _udo_, _hetk, shto,
   {{0x2d8c0430,0x661a007b,0x09c50096,0x7cef0065}},	//   øden_, _ketk, _वड्य, _lòrì,
   {{0x2486022e,0x69dc015c,0x2002052f,0x768f004d}},	//   _hoom_, _ozre, acki_, _røyk,
   {{0x248601bb,0x321e1799,0xdd94004b,0x64950076}},	//   _koom_, maty_, пары, _máin,
   {{0x60cd179a,0x6b8d179b,0x6722179c,0x661a179d}},	//   _ukam, tyag, ksoj, _letk,
   {{0x6d5e179e,0xfbd3012b,0x69dc00dc,0x6f1600f0}},	// [f30] _espa, ستر_, _azre, _gwyc,
   {{0x661a179f,0xbebb023b,0x6b8d0079,0x321e007f}},	//   _netk, rrës, ryag, naty_,
   {{0x6f160034,0x2bd50fef,0x2907023b,0x625e02a1}},	//   _zwyc, _दरका, ëna_, _għoż,
   {{0x2486022e,0x290701d3,0x7cef0139,0x66cd04c8}},	//   _noom_, īna_, _dòrì, júkr,
   {{0xf1cf0251,0x41cf030b,0x201b0167,0x321e0034}},	//   _सुनन, _सुनस, _meqi_, katy_,
   {{0x661a00cc,0x443d008a,0x57a90096,0x7bdd17a0}},	//   _cetk, _scw_, _कधीह, _izsu,
   {{0x78bb05e8,0x7d020031,0xe8100096,0x24860d63}},	//   _tjuv, _čosk, ारखा_, _boom_,
   {{0x6298038c,0x6722023e,0x661a1030,0x649c033c}},	//   _alvo, bsoj, _eetk, _néid,
   {{0x254e00a7,0x64950037,0x20d917a1,0x248617a2}},	//   _cəlb_, _fáin, téin_, _doom_,
   {{0x52a900c2,0x81bd0033,0x31250095,0x321e17a3}},	//   рвом_, _আরব_, одог, gaty_,
   {{0x2486006c,0x649c033c,0x00000000,0x00000000}},	//   _foom_, _béid, --, --,
   {{0x649c0076,0xa9110789,0x7de00065,0x248600fc}},	//   _réig, डीएफ_, _lásí, _goom_,
   {{0x661a0587,0x321e17a4,0x649c036b,0x2d8517a5}},	//   _yetk, baty_, _déid, älen_,
   {{0x216917a6,0x644917a7,0xfc3f0428,0xddde00ae}},	//   _вики_, lfei, _ací_, _nopţ,
   {{0x649c054f,0x6724003d,0xed5a17a8,0xf8c90c22}},	//   _féid, ġiji, шов_, िकाय,
   {{0x248617a9,0x2fc001fa,0x644910f4,0x672400cc}},	//   _xoom_, _txig_, nfei, šiji,
   {{0x6d5e00a5,0xbb4317aa,0x4aaa169f,0xbbb400a4}},	// [f40] _wspa, метк, акан_, ंपेक,
   {{0x649c00e3,0x1ae317ab,0x00000000,0x00000000}},	//   _téig, доум, --, --,
   {{0x661a17ac,0x7de00065,0xa01b0212,0xa96700e5}},	//   _retk, _dásí, ljöa, жиха_,
   {{0x50ca00a5,0x661a17ad,0x20ca030b,0x672200c2}},	//   रविष, _setk, रविध, tsoj,
   {{0x661a03f1,0x248600a1,0xe8e00023,0x6756046b}},	//   _petk, _room_, hiệt_, تخار,
   {{0x248617ae,0x2a6302ef,0x6d5c01ee,0x6b8b0212}},	//   _soom_, _gajb_, owra, ägge,
   {{0xd49a11d9,0x248617af,0x661a17b0,0x69dc01d3}},	//   ири_, _poom_, _vetk, _uzre,
   {{0xb19800de,0x734a00d3,0x672d17b1,0xe9d7004d}},	//   _ngưỡ, ачов_, šaja, _єкт_,
   {{0x68fc17b2,0x61ef0092,0x649c0037,0x160b09c4}},	//   _hurd, əklə, _réid, _स्वर_,
   {{0x68fc17b3,0x386617b4,0x649500da,0x00000000}},	//   _kurd, ldor_, _háil, --,
   {{0xe45a02ec,0x2486022e,0x321e17b5,0x7f4417b6}},	//   _вже_, _toom_, raty_, _aqiq,
   {{0x68fc17b7,0x92ca0081,0x765817b8,0x290a02ef}},	//   _murd, লগে_, levy, _mtba_,
   {{0x610100d9,0x91ca02d5,0x270c0033,0x321e12b1}},	//   _vēla, _सुरै, _হয়তো_, paty_,
   {{0x81c90081,0x76580051,0x809f0034,0xbbb40096}},	//   লেই_, nevy, खोजे, ंपैक,
   {{0xbd6817b9,0x009500ae,0x00000000,0x00000000}},	//   орте_, _никэ, --, --,
   {{0x90c407c8,0x90e7001c,0x64950231,0x76580027}},	//   _обје, _بستن, _náil, hevy,
   {{0x1eab00e3,0x7bc10034,0x386617ba,0xe0d00d7f}},	// [f50] _نادي_, _ślub, ddor_, _جزو_,
   {{0x1b040033,0x68fc17bb,0x291803a8,0x00000000}},	//   _লিখে_, _burd, _bwra_, --,
   {{0xad2700cd,0xa907015a,0x68fc17bc,0xe9f8004d}},	//   _برخو, زبان, _curd, інці_,
   {{0xe8f8059b,0x649500e3,0x68fc17bd,0x6d45019f}},	//   ілі_, _cáil, _durd, _iqha,
   {{0xb902007d,0xcb4400c9,0x6d4717be,0x7d0200e7}},	//   _नी_, _охри, ltja, _čosi,
   {{0x7afd17bf,0x8afa00ca,0x24670023,0x68fc17c0}},	//   _iust, _להשי, _ốm_, _furd,
   {{0xceb40130,0x6d4717c1,0x855700d0,0x649500e3}},	//   ויס_, ntja, تیار_, _fáil,
   {{0x7af50a00,0x81c20033,0x00000000,0x00000000}},	//   _hizt, ্ধা_, --, --,
   {{0x644917c2,0xe3b100e3,0x68fc1186,0x26060285}},	//   rfei, عرب_, _zurd, _स्की_,
   {{0x644917c3,0x68fc03e0,0x6d5c17c4,0xe2990291}},	//   sfei, _yurd, ywra, сао_,
   {{0x68fc08a8,0xa06a17c5,0x76b20034,0xc692021e}},	//   _xurd, бана_, słyc, _ראב_,
   {{0x7b090031,0x7af501c8,0x69d50216,0x00000000}},	//   _kľud, _lizt, _myze, --,
   {{0x7afd01b3,0xb4c9009d,0x3f8f003d,0xbf9b016d}},	//   _nust, ोती_, _żgur_, scên,
   {{0x91fc01d3,0x649c0503,0x00000000,0x00000000}},	//   ndāl, _géib, --, --,
   {{0x7c96013a,0x649500e3,0xfce60f94,0xe7eb09c4}},	//   прац, _láim, зово, जेता_,
   {{0x249f00c9,0x7afd17c6,0xa3e2007a,0x7af500d9}},	//   nhum_, _bust, _धरम_, _aizt,
   {{0x7af517c7,0x7afd17c8,0x649c033c,0x7d1b02ef}},	// [f60] _bizt, _cust, _héic, ćusa,
   {{0x7afd17c9,0x5cf600ae,0x00000000,0x00000000}},	//   _dust, _няму, --, --,
   {{0x7afd01e9,0x68fc00a7,0x7af501ff,0x3ddf01c2}},	//   _eust, _qurd, _dizt, ƙuwa_,
   {{0x7afd17ca,0x68fc13c8,0x20d217cb,0x69d517cc}},	//   _fust, _vurd, máis_, _dyze,
   {{0x7afd17cd,0x68fc02d6,0x672d0106,0x386617ce}},	//   _gust, _wurd, šajn, rdor_,
   {{0x68fc17cf,0x648e009c,0x2d87015e,0x442017d0}},	//   _turd, _lùit, _ànec_, _ži_,
   {{0x7afd17d1,0x64950037,0x321c17d2,0xddc7007f}},	//   _zust, _táil, _revy_, dejś,
   {{0x2ca006a8,0x7de70018,0xf7461602,0x957c0034}},	//   nhid_, lésé, _небо, _rząd,
   {{0x7afd0933,0xa78607e8,0x00000000,0x00000000}},	//   _xust, _عشرو, --, --,
   {{0xcb1300ca,0x610100e8,0x7de701f9,0x649c0503}},	//   עלת_, _cēlo, nésé, _béic,
   {{0xa3cc007d,0x40350606,0xfbc40081,0x59be17d3}},	//   _शुर_, менс, ্ধিত, ्थिर,
   {{0x7bc300ae,0x249f17d4,0x92ac0033,0x20d217d5}},	//   şnui, chum_, ককে_, dáis_,
   {{0xcb1b02d5,0x8143001c,0xbd020134,0x00000000}},	//   _पौंड_, ونین, _ọkpọ, --,
   {{0x7afd17d6,0x6d4717d7,0x6f0f0313,0x7afb0131}},	//   _rust, ttja, rpcc, _éuti,
   {{0x71f7012b,0x7de70018,0x7afd17d8,0x20d2034f}},	//   _عروس_, désé, _sust, gáis_,
   {{0x6d4717d9,0x768f004d,0x9f400062,0x628a07ee}},	//   rtja, _høyt, _egiñ_, _hofo,
   {{0x6d4703d0,0x628a17da,0xc6220081,0x7af501e9}},	// [f70] stja, _kofo, _নানা_, _pizt,
   {{0x6f0d17db,0x8f9c00ca,0xbd02037a,0x628a01f9}},	//   _itac, _ליחי, ñéca, _jofo,
   {{0xb5fc03e5,0xe80a0294,0x68220134,0x20d217dc}},	//   _paġn, _ịbịa, _ọdab, cáis_,
   {{0xddde175b,0x69d50181,0x2ca017dd,0x20d20037}},	//   _uopš, _vyze, chid_, láir_,
   {{0xf74517de,0x7afd09a1,0x26ce0350,0x00000000}},	//   фело, _uust, fofo_, --,
   {{0x628a01d3,0x20d200e3,0x6442002b,0x768f0120}},	//   _nofo, náir_, _acoi, _nøyt,
   {{0x249f030a,0x24e90208,0x00000000,0x00000000}},	//   thum_, омки_, --, --,
   {{0x649500e3,0x9f650220,0xc21f009f,0x130917df}},	//   _táim, _štýl_, _मजहब_, оний_,
   {{0x6f0d17e0,0x80c90081,0x320517e1,0x20d2002b}},	//   _ntac, রগঞ্, tcly_, záis_,
   {{0xd0480092,0x20d2034f,0xaabf08c0,0xe3b610e0}},	//   əməy, yáis_, ्विक, ьбы_,
   {{0x648e01b5,0x610101d3,0x249f039f,0x5bba00a8}},	//   _cùis, _vēlo, phum_, _इश्व,
   {{0x644200e3,0x7de70018,0xf485010d,0x648e01ec}},	//   _gcoi, zésé, _تائی, _dùis,
   {{0x628a17e2,0x10a317e3,0xe3ae07ef,0x4abf087c}},	//   _fofo, тиян, _рб_, ्वाव,
   {{0x12fa00a1,0x443f17e4,0xa3e217e5,0x20d205e6}},	//   _והסב, lgu_, _धरत_, táis_,
   {{0x2ca00013,0x768f004d,0x2c0b0129,0x443f17e6}},	//   thid_, _høys, _ụjọ_, ogu_,
   {{0x443f17e7,0x20d200e3,0x2ca0005c,0x67290487}},	//   ngu_, ráis_, uhid_, _ovej,
   {{0x7de70018,0x236d052f,0x9f440084,0xaec617ab}},	// [f80] tésé, nvej_, ämä_, _обил,
   {{0x2ca017e8,0xed5a17e9,0x6b8b0212,0x629d0052}},	//   shid_, _доо_, ägga, ësoh,
   {{0x443f08d3,0xfe14030b,0x610800b6,0x768f00f3}},	//   kgu_, _त्यस_, _těle, _løys,
   {{0x648e01ec,0x00000000,0x00000000,0x00000000}},	//   _lùir, --, --, --,
   {{0x7c2417ea,0x2b4917eb,0xaca40134,0x6729007e}},	//   mair, ctac_, _laịt, _cvej,
   {{0x7c2417ec,0x64420080,0x443f17ed,0x24580019}},	//   lair, _scoi, egu_, _ẩm_,
   {{0x26ce17ee,0xa01b0088,0x3d12009d,0xaca40134}},	//   rofo_, fjöl, धीचे_, _naịt,
   {{0x7c2417ef,0x628a02e2,0x443f17f0,0xa01b003e}},	//   nair, _sofo, ggu_, gjöl,
   {{0x648e01f7,0x63ad17f1,0x644200fe,0x00000000}},	//   _bùir, _žanr, _vcoi, --,
   {{0x7c2417f2,0x648e0441,0x443f17f3,0x628a17f4}},	//   hair, _cùir, agu_, _qofo,
   {{0x3a3717f5,0x7c2417f6,0x60cf00d3,0x6f0d17f7}},	//   ורים_, kair, tocm, _stac,
   {{0x78a217f8,0x645b17f9,0x249d03a8,0x6f0d055c}},	//   nhov, ceui, _glwm_, _ptac,
   {{0x7c2417fa,0x23e2116e,0x628a0f20,0xb4ca0efb}},	//   dair, _परिद, _tofo, लकी_,
   {{0x442417fb,0x768f02ec,0x78a2019f,0x00000000}},	//   lam_, _høyr, hhov, --,
   {{0xa2cb06ed,0x20c709b9,0x7c2417fc,0x78a2039f}},	//   सकर्, _осиг, fair, khov,
   {{0x442417fd,0x644017fe,0x7c240a1b,0xa3e217ff}},	//   nam_, ngmi, gair, _धरा_,
   {{0x44241800,0x7b090031,0x6f0d1801,0xfbd00076}},	// [f90] iam_, _sľub, _utac, لتك_,
   {{0x44241802,0x5a341803,0x81c90081,0x2b491804}},	//   ham_, кнут, লেও_, rtac_,
   {{0x44240ad4,0x67290995,0x443f1805,0x38350d0f}},	//   kam_, _svej, ygu_, енер,
   {{0x7c241806,0xdbd9003e,0xd0f9006e,0xe8c90096}},	//   cair, _fæði, פּער, िकेच,
   {{0xfe700103,0x00000000,0x00000000,0x00000000}},	//   _صدی_, --, --, --,
   {{0x81c90081,0x45191807,0xa01b0103,0xb4c90285}},	//   লেট_, пция_, gköz, ोत्_,
   {{0x44241808,0xddde0034,0x645b1809,0x7ae701c2}},	//   fam_, _zapł, teui, _ihjt,
   {{0x78a20897,0xfdf800a1,0x443f129d,0x69c70090}},	//   chov, וצות_, ugu_, _ixje,
   {{0x610100d9,0x254e0092,0xaca400ac,0x645b180a}},	//   _vēlm, _həll_, _saịt, reui,
   {{0x443f02ad,0x236d052f,0xf1bf0031,0xf3f9020a}},	//   sgu_, rvej_, ášok_, deţe_,
   {{0x236d052f,0xa06a180b,0x00000000,0x00000000}},	//   svej_, пана_, --, --,
   {{0x20050034,0x236d02b6,0xd11b0285,0xf3f9044c}},	//   ślin_, pvej_, भीषण_, feţe_,
   {{0x9f4c07aa,0x442f180c,0x7c2400d9,0x47d10033}},	//   _ölüm_, _idg_, vair, _তৃতী,
   {{0x78a2025b,0x7c24180d,0xade400bc,0xa3b80037}},	//   zhov, wair, _गरदन_, _تامر_,
   {{0x7c24180e,0xc69200f5,0x649c033c,0x69c700dd}},	//   tair, נאל_, _méin, _nxje,
   {{0x23ce000d,0x649c00e3,0xa01b0018,0x442f180f}},	//   _हुँद, _léin, zköz, _jdg_,
   {{0x7c241810,0xfa360781,0x69cb026a,0x60c40090}},	// [fa0] rair, فراد, şgel, _ijim,
   {{0x7c241811,0x4a430832,0xd00f001c,0x00000000}},	//   sair, лнув, _پلی_, --,
   {{0x44241812,0x442f1813,0xf296006e,0x7c241814}},	//   yam_, _odg_, עכער_, pair,
   {{0xafdb1484,0x44241815,0xb05b0364,0x60c4010a}},	//   mfør, xam_, mnäc, _jjim,
   {{0xa01b0018,0x78a21816,0xafdb0856,0x69c7037a}},	//   tköz, rhov, lfør, _exje,
   {{0x78a21817,0x60c4007e,0x44241818,0xfaff0216}},	//   shov, _ljim, wam_, _erës_,
   {{0xb7bd002d,0x78a20149,0x442f1819,0xafdb181a}},	//   _reţe, phov, _bdg_, nfør,
   {{0x442f04d4,0xb4ca048a,0x2a6a0090,0x00000000}},	//   _cdg_, लके_, _habb_, --,
   {{0x64400006,0xe737064f,0x649c0037,0x98a3001f}},	//   rgmi, _пет_, _féin, _сите,
   {{0x4424181b,0x649c00da,0x92940291,0xafdb00f3}},	//   sam_, _géin, таоц, kfør,
   {{0xa2a609c4,0x648e009c,0xf3f9020a,0x00000000}},	//   टोग्, _fùip, veţe_, --,
   {{0x4424181c,0xafdb0939,0x39580483,0x442f03a8}},	//   qam_, dfør, _mprs_, _gdg_,
   {{0x6108030b,0x60c4181d,0x2d8c0e74,0xa01b02c3}},	//   _děla, _djim, äden_, ljök,
   {{0x60c4181e,0x6234002d,0xd36f001c,0xd491020b}},	//   _ejim, _реку, _دهه_, _rùi_,
   {{0xafdb181f,0x7c2f0027,0x6ee002c3,0xf3f9020a}},	//   gfør, _pdcr, möbl, reţe_,
   {{0x11db0054,0x629a1820,0x768f004d,0x225e0124}},	//   _מחוב, lkto, _løyp, letk_,
   {{0x213e1821,0x6fb9004d,0x00000000,0x00000000}},	// [fb0] luth_, _ігор_, --, --,
   {{0x629a1822,0x60dd0973,0xa9c70a11,0x2efa02ac}},	//   nkto, llsm, нсек, _gipf_,
   {{0x649c00fd,0xb8120033,0x2bd100b7,0x69c10147}},	//   _réin, _হয়ত_, _थुरा, _žleb,
   {{0xb4ca033a,0x89341823,0x4c951824,0x00000000}},	//   लको_, اعلا, _римс, --,
   {{0x3669090f,0x649c0037,0x442f1825,0x00000000}},	//   дало_, _péin, _rdg_, --,
   {{0x442f1826,0x6e2704e9,0xd1380138,0x629a0381}},	//   _sdg_, najb, krą_, jkto,
   {{0x6abf1827,0x56920b1b,0x64a51828,0x442f1829}},	//   ्वीर, рајт, кака, _pdg_,
   {{0x629a182a,0x29110062,0x25ba182b,0xd138182c}},	//   ekto, _itza_, úpla_, drą_,
   {{0x290301ae,0x27ff0032,0x200502c6,0x032200c6}},	//   _huja_, _igun_, ělil_, адын,
   {{0x29030010,0x442f0174,0x60d602c3,0x649c0076}},	//   _kuja_, _wdg_, _skym, _héil,
   {{0x10a600d6,0x29030216,0xbbde00a8,0x68fb09a1}},	//   винн, _juja_, _मर्क, _kiud,
   {{0x92c300c7,0x442f182d,0x2efa00e7,0x4096182e}},	//   ্ষে_, _udg_, _sipf_, трот,
   {{0x68fb13a9,0x68e9182f,0x6f63013f,0x00000000}},	//   _miud, _mhed, авяз, --,
   {{0x764303b4,0xed5a1830,0x68fb0138,0x200b028d}},	//   ngny, мог_, _liud, acci_,
   {{0x2a6a1831,0x27ff0d79,0xdc0f00ac,0x63a91832}},	//   _rabb_, _ogun_, _ụmụa, lzen,
   {{0xafdb0856,0x6fb60037,0x39580169,0xe7f600b6}},	//   rfør, _لمعا, _rprs_, ेशमा_,
   {{0x63a91833,0xafdb13c8,0xab271834,0x2a6a0090}},	// [fc0] nzen, sfør, кота_, _pabb_,
   {{0x68e91835,0x63a901c0,0xafdb004d,0x27ff0113}},	//   _ahed, izen, pfør, _agun_,
   {{0x68e9009c,0x29030161,0x68fb0138,0x649c0076}},	//   _bhed, _cuja_, _biud, _béil,
   {{0x68fb1836,0x779400cd,0x649c0037,0x6f040239}},	//   _ciud, هیزا, _céil, _kuic,
   {{0x63a901c0,0x649c0037,0x2d980103,0x68e91837}},	//   jzen, _déil, lyre_, _dhed,
   {{0x63a91838,0x27ff03f3,0x6d4e02ac,0x29030131}},	//   dzen, _egun_, otba, _fuja_,
   {{0xd9e604a9,0x68461839,0x649c00e3,0x2d98183a}},	//   _करित_, _инва, _féil, nyre_,
   {{0x68fb013d,0x68e9183b,0x7afc183c,0x3eb80076}},	//   _giud, _ghed, _hirt, hirt_,
   {{0x69dc0149,0x7afc183d,0xbebb0052,0x6d4e0dbc}},	//   _hyre, _kirt, rrëz, htba,
   {{0x7afc0694,0xd1380138,0xd9e609c3,0x6d4e183e}},	//   _jirt, trą_, _करात_, ktba,
   {{0x2d980052,0x63a901ff,0x7afc183f,0x00000000}},	//   jyre_, azen, _mirt, --,
   {{0x6f0400e3,0x213e1840,0x23661841,0x69dc1842}},	//   _buic, ruth_, _tsoj_, _myre,
   {{0x63a90d1b,0x7afc0a02,0xb4be1843,0x6d4e0629}},	//   czen, _oirt, ँची_, etba,
   {{0x6f041844,0x717400d1,0xf77300d7,0x00000000}},	//   _duic, _مهتا, בקש_, --,
   {{0x5c071845,0x69dc0073,0xb5fc003d,0xddde0154}},	//   вяза, _nyre, _baġi, _lapņ,
   {{0x7afc0080,0x3eb80091,0x672d00d9,0x2fc9023e}},	//   _airt, airt_, šaji, _txag_,
   {{0x649c00e3,0x68e90150,0x7afc1846,0x68fb0428}},	// [fd0] _réil, _rhed, _birt, _riud,
   {{0x68e91847,0x29031848,0x1a5b0037,0x64950037}},	//   _shed, _puja_, بشرة_, _háit,
   {{0x2d8c01df,0x69dc1849,0x68e90178,0x3f9900f0}},	//   ødet_, _cyre, _phed, lysu_,
   {{0x69dc184a,0xf8d100c7,0x7afc184b,0x20d9184c}},	//   _dyre, িষ্ঠ, _eirt, méis_,
   {{0xab84184d,0x3a23184e,0x649c0037,0x68fb184f}},	//   _курк, _tejp_, _céim, _viud,
   {{0xf7701850,0x64950080,0x4aa71317,0x69dc038c}},	//   غان_, _láit, _गतिव, _fyre,
   {{0x68e91851,0x20d91852,0x6fd502d5,0xb8120033}},	//   _thed, néis_, _युसू, _হযরত_,
   {{0x63a91853,0x200500a5,0x7d051854,0x7bdd0031}},	//   tzen, ślij_, _muhs, _kysu,
   {{0xe8941855,0x610802c6,0x659302c6,0x69dc0216}},	//   _тать, _bělo, _běhá, _zyre,
   {{0x63a91856,0x45451857,0x7afc0188,0x69080103}},	//   rzen, _منطق, _xirt, _ördö,
   {{0x63a91858,0xaca30139,0x7f4d0036,0x20d9037a}},	//   szen, _asọd, _aqaq, jéis_,
   {{0x20d91859,0x2375071c,0x7f4d0090,0x386d02ac}},	//   déis_, _ماتح, _bqaq, _jaer_,
   {{0x6f0400a1,0x386d185a,0x7d050231,0x649500da}},	//   _quic, _maer_, _auhs, _dáit,
   {{0x2d9800dd,0x66e3009d,0x386d057a,0x6d4e185b}},	//   tyre_, गतिक_, _laer_, ttba,
   {{0x09be00c7,0xada30231,0x6da3185c,0x2d9e185d}},	//   _অর্থ, барл, бира, áte_,
   {{0x7afc185e,0x09e20033,0x7d0503a9,0x6f04185f}},	//   _sirt, _বললা, _duhs, _tuic,
   {{0x2d9e0206,0x09be1860,0x7afc1861,0x3eb8023b}},	// [fe0] šte_, ्थ्य, _pirt, pirt_,
   {{0x649c00e3,0x0e661862,0x20d91863,0x9a6a0308}},	//   _réim, _скон, béis_, عمال_,
   {{0x386d02e5,0x7afc1864,0x20d90a43,0xddde01d3}},	//   _baer_, _virt, céis_, _sapņ,
   {{0x7afc1865,0x386d1866,0x20d90037,0x69dc1867}},	//   _wirt, _caer_, léir_, _vyre,
   {{0x386d1868,0x7afc1869,0x3ce0004d,0x7c2600e8}},	//   _daer_, _tirt, mliv_, _iekr,
   {{0x7afc0037,0x20d90037,0xe9440d7f,0x3ce0186a}},	//   _uirt, néir_, _پرسی, lliv_,
   {{0x2aa40068,0x64950080,0x7c260449,0x7769063d}},	//   _több_, _náis, _kekr, _esex,
   {{0xa01b186b,0x386d0178,0xb4de0096,0xb97b1777}},	//   ljöv, _gaer_, णते_, _אנלי,
   {{0x649500e3,0x7c26186c,0x5c37006e,0x00000000}},	//   _ráit, _mekr, ארפן_, --,
   {{0x4154186d,0x59b80b42,0x326610e8,0xa5da0037}},	//   авос, _आधार, утив, _كبار_,
   {{0x6e2501e8,0xdd1200a7,0x7c261044,0xba57006e}},	//   _rehb, _rüşv, _oekr, נסטו_,
   {{0x7c2602e6,0x629d023b,0x7d05026a,0x764403e3}},	//   _nekr, ësor, _ruhs, ɗiya,
   {{0xe29a01b3,0xe0df028d,0x91fc01d3,0x610802c6}},	//   _пад_, rlò_, edāt, _tělo,
   {{0x20d9186e,0x442600de,0x4ea7186f,0x7bdd0034}},	//   téis_, _heo_, урма, _rysu,
   {{0x44261870,0x254e00a7,0x6e251871,0x00000000}},	//   _keo_, _bəli_, _vehb, --,
   {{0x442608a9,0x649500e3,0x20d91872,0x2fc60117}},	//   _jeo_, _háir, réis_, _žoge_,
   {{0x7c261873,0x2d8c052f,0x442600fe,0x20d91874}},	// [ff0] _dekr, øder_, _meo_, séis_,
   {{0x44261875,0x20d91876,0x7bdd0094,0x39a7002d}},	//   _leo_, péis_, _vysu, лшев,
   {{0x64950037,0x386d00b3,0xb5fc02a1,0xca480286}},	//   _máir, _paer_, _kaġu, المه_,
   {{0x44260049,0x7c2601a2,0xb4c0000d,0xddde030b}},	//   _neo_, _gekr, ूको_, _např,
   {{0xd36607c3,0xddd701d4,0x2ca900e3,0x00000000}},	//   _به_, _yaxş, mhad_, --,
   {{0xca4900cd,0xd1260190,0x64950076,0x9a8707bf}},	//   _جلسه_, _وم_, _náir, _сумл,
   {{0x44261877,0x1ddb0789,0x00000000,0x00000000}},	//   _beo_, _मुमत, --, --,
   {{0x44260158,0xa4230033,0xf1cf1878,0x387f009e}},	//   _ceo_, ফল্য_, _सुगन, _unur_,
   {{0x44261879,0xd05d0092,0x64950076,0x73050c37}},	//   _deo_, _üzər, _báir, јпоз,
   {{0x649500da,0x81b901c2,0xe2990284,0x7eab042c}},	//   _páis, _haɓɗ, тао_, _hüpf,
   {{0x00860ac6,0x44260487,0x332d187a,0x91e50a18}},	//   ално, _feo_, ssex_, роне,
   {{0x672d1197,0x4426187b,0x64950072,0x2c150176}},	//   šaju, _geo_, _váis, _फ्लू_,
   {{0x81bd00c7,0x249f01af,0x20d90076,0x64590079}},	//   _আরও_, mkum_, téir_, _ibwi,
   {{0xe296187c,0x64950037,0x249f187d,0x3cde0285}},	//   _ваш_, _gáir, lkum_, _कीजे_,
   {{0x20d900e3,0x3ce01842,0xb60600d4,0x7c2605db}},	//   réir_, tliv_, _uváž, _pekr,
   {{0x4426187e,0x64ba03e5,0x2ca9187f,0x249f003e}},	//   _xeo_, nċip, ghad_, nkum_,

   {{0x3b071880,0x644b1881,0x3b86100f,0x3d1c0139}},	// [1000] ието_, _mcgi, шлаг, _bàwò_,
   {{0x3ce01882,0x248d01df,0x249f07e7,0x7c26084e}},	//   sliv_, hjem_, hkum_, _wekr,
   {{0x249f003e,0x64591883,0x7c2601e8,0x186a0114}},	//   kkum_, _obwi, _tekr, кажи_,
   {{0x315600c1,0x6d5e003d,0x2ca90013,0x248d03e5}},	//   ייען_, _ippa, chad_, jjem_,
   {{0x91fc00d9,0x3d1c0139,0x00000000,0x00000000}},	//   ndār, _fàwò_, --, --,
   {{0x44261884,0x64591885,0xfaa61121,0x1dbc02d5}},	//   _seo_, _abwi, _таго, ोपपत,
   {{0x442600b7,0xfc3f0206,0x26c00357,0x00000000}},	//   _peo_, _ulíc_, đio_, --,
   {{0xd7660068,0x2ca01886,0x291a007b,0x248d0216}},	//   _پارٹ, nkid_, mppa_, gjem_,
   {{0x64950080,0x44261887,0xb5fc003d,0x2ca000f9}},	//   _páir, _veo_, _raġu, ikid_,
   {{0x6d5e1888,0x68e21889,0xd2570120,0x00000000}},	//   _oppa, llod, ацю_, --,
   {{0x4426188a,0x64a6188b,0x6913009e,0x248d0117}},	//   _teo_, _кажа, _għed, bjem_,
   {{0xd83f033d,0x644b0124,0xd1300103,0x00000000}},	//   _účtu_, _gcgi, _ہمت_, --,
   {{0x6d5e188c,0x64950080,0xb05b007b,0x58f70142}},	//   _appa, _táir, snäo, ימטע_,
   {{0xd0650092,0x291a0167,0x539b00ca,0x3ea50103}},	//   _əsər, kppa_, _בידו, ólt_,
   {{0x3cf3009d,0x2ca901b5,0x611300ae,0xfc3f037a}},	//   ंगले_, thad_, _căld, _alía_,
   {{0x76b2007f,0x20d20072,0xbd440076,0x0ca8188d}},	//   pływ, záiz_, تنفي, атуи_,
   {{0x2ca9188e,0x5a35008f,0x90a70018,0xb6030146}},	// [1010] rhad_, йнат, _محکم, áško,
   {{0xda780084,0x2ca9188f,0x657a1890,0x249f02c6}},	//   иях_, shad_, _orth, zkum_,
   {{0xceb20132,0x83fd0018,0x249f1891,0xfc3f037a}},	//   _זיי_, ndőr, ykum_, _elía_,
   {{0x68e21892,0x00000000,0x00000000,0x00000000}},	//   glod, --, --, --,
   {{0x7c2d1893,0x69ce0113,0x291a1894,0x7aee009c}},	//   maar, _exbe, appa_, _fhbt,
   {{0x7c2d1895,0x7b3d078e,0x00000000,0x00000000}},	//   laar, _căuş, --, --,
   {{0x248d0087,0xd57501ef,0x6d9e0078,0x637211bc}},	//   tjem_, суль, _għaġ, yınç,
   {{0x58d41896,0x7c2d1897,0xc4850b36,0x64950076}},	//   _дост, naar, слик, _cáip,
   {{0xf77303ed,0x248d1898,0x657a02ad,0x249f003e}},	//   _باز_, rjem_, _erth, rkum_,
   {{0x249f1899,0x7c2d189a,0xd5bb00ae,0x777b01ff}},	//   skum_, haar, _исе_, _irux,
   {{0x6f16189b,0x00000000,0x00000000,0x00000000}},	//   _styc, --, --, --,
   {{0x7c2d189c,0x6459023f,0x6f1601ff,0x00000000}},	//   jaar, _ubwi, _ptyc, --,
   {{0x442d189d,0x7c2d189e,0xe28e002d,0x83fd0103}},	//   mae_, daar, _еа_, rdős,
   {{0x442d189f,0x644918a0,0xc7d60089,0xd8390154}},	//   lae_, lgei, מורי_, _blōk_,
   {{0xf1cf063c,0x628318a1,0x7c2d0188,0xada318a2}},	//   _सुचन, _inno, faar, парл,
   {{0x7c2d18a3,0x644918a4,0xdd8f1363,0x442d0239}},	//   gaar, ngei, روق_, nae_,
   {{0x09b500c7,0xbebb00dd,0x7e9a03ef,0x2ca000dc}},	// [1020] _জুলা, rsër, _منظر_, rkid_,
   {{0x442d18a5,0xe3a70068,0x2ca018a6,0xe7db00a3}},	//   hae_, _ہر_, skid_, _बड़प,
   {{0x7c2d18a7,0x9e7b00c1,0x6e2e18a8,0x442d0749}},	//   baar, _ענטפ, mabb, kae_,
   {{0x6c8618a9,0x6e2e18aa,0x777b18ab,0x7c2d008a}},	//   _الحم, labb, _brux, caar,
   {{0x442d18ac,0x628304e2,0xddd502c6,0xb8d0049d}},	//   dae_, _onno, dezř, _ओत_,
   {{0xcd290814,0x6e2e18ad,0x56931469,0xa01b0212}},	//   _حسین_, nabb, зашт, njör,
   {{0x64950037,0x2b4018ae,0xb9960037,0x00000000}},	//   _páip, lric_, _الزب, --,
   {{0x628318af,0x6e2e18b0,0x5fc8030b,0x290a0124}},	//   _anno, habb, रपाल, _iuba_,
   {{0xdc9b0130,0x213e02ad,0x78a20146,0x657a0150}},	//   טיקל, wrth_, mkov, _wrth,
   {{0x290a18b1,0x78a218b2,0x6e2e18b3,0x2d7818b4}},	//   _kuba_, lkov, jabb, _oče_,
   {{0x7c2d0694,0x290a18b5,0xd48f18b6,0x442d0256}},	//   yaar, _juba_, _ер_, bae_,
   {{0x7d1c0146,0x6283083e,0x290a18b7,0x232a0a7c}},	//   dprs, _enno, _muba_, _боди_,
   {{0x7c2d18b8,0x2bd80e50,0x439418b9,0x6e2e18ba}},	//   vaar, _भुला, _фалс, fabb,
   {{0x291818bb,0x7c2d0254,0xae1404f1,0x6e2e18bc}},	//   _otra_, waar, तुलन_, gabb,
   {{0x7c2d18bd,0x8af001d4,0x6ca718be,0xb05b0084}},	//   taar, ktəb, браж, nnäk,
   {{0xfc3f01cd,0x00000000,0x00000000,0x00000000}},	//   _elín_, --, --, --,
   {{0x7c2d18bf,0x78a2025b,0x6e2e18c0,0x60cd023f}},	// [1030] raar, dkov, babb, _ijam,
   {{0x7c2d18c1,0xff500037,0x442d18c2,0x290a18c3}},	//   saar, _أخي_, zae_, _buba_,
   {{0x290a18c4,0x78a218c5,0x291805b4,0x6d41109d}},	//   _cuba_, fkov, _ctra_, álad,
   {{0x290a1114,0x6d471124,0xec6b1612,0xfc3f02c6}},	//   _duba_, muja, _срок_, _zlín_,
   {{0x6d47026e,0x6d5503f3,0x442d024a,0x660518c6}},	//   luja, ltza, vae_, опла,
   {{0x442d18c7,0x290718c8,0x2bc6030b,0x6d5518c9}},	//   wae_, ínas_, लपरा, otza,
   {{0x6d5503f3,0x290a18ca,0x6d470087,0x78a20146}},	//   ntza, _guba_, nuja, bkov,
   {{0x6e2e18cb,0x78a218cc,0x6d550a00,0x60cd18cd}},	//   zabb, ckov, itza, _njam,
   {{0x442d18ce,0x290a18cf,0x98680068,0x6d4718d0}},	//   rae_, _zuba_, _دینے_, huja,
   {{0xadf9000f,0x6d4718d1,0x27ed0a00,0x644918d2}},	//   ंधान_, kuja, _izen_, sgei,
   {{0x6e2e18d3,0x208a008f,0x6113020a,0x71b5007b}},	//   vabb, айни_, _sălb, ющих,
   {{0x25d607a6,0x6d470181,0x3eba0167,0x349418d4}},	//   _ווען_, duja, _smpt_, _нахр,
   {{0x6e2e18d5,0x78a918d6,0x60cd18d7,0xa85600ca}},	//   tabb, _mlev, _djam, חירה_,
   {{0x78a918d8,0x78a2025b,0x9c130129,0x6113020a}},	//   _llev, zkov, _kọwa, _călc,
   {{0x6e2e18d9,0x78a9069d,0xde0302ec,0xfc3f0072}},	//   rabb, _olev, дпри, _clío_,
   {{0x290a18da,0x8b260c79,0x6e2e18db,0x2b4018dc}},	//   _ruba_, ждае, sabb, tric_,
   {{0x78a218dd,0x290a18de,0x3eba0808,0x7eab01e8}},	// [1040] vkov, _suba_, _tmpt_, _süpe,
   {{0x78a918df,0x61e3003e,0x78bb18e0,0xa01b0212}},	//   _alev, _kynl, _amuv, ljöp,
   {{0x78a210e1,0x78a90021,0x386618e1,0x656101fa}},	//   tkov, _blev, teor_, _nplh,
   {{0x290a0193,0x7a400af0,0x8037006e,0x6f000139}},	//   _vuba_, _bátà, ַנצע_, _fábì,
   {{0x78a210e1,0x61e302b6,0x8af000a7,0x236f0350}},	//   rkov, _lynl, rtəb, _nsgj_,
   {{0x290a18e2,0x649c00e3,0x7b0903da,0x78bb0201}},	//   _tuba_, _léit, _džud, _emuv,
   {{0x78a204ad,0x27ed18e3,0x98a618e4,0x78a918e5}},	//   pkov, _ezen_, _диве, _flev,
   {{0x78a900ee,0xd91b0327,0x00000000,0x00000000}},	//   _glev, _כולל, --, --,
   {{0xccf3028c,0xf366004d,0x2904026d,0x00000000}},	//   וכה_, ітин, _iima_, --,
   {{0x29040350,0x60cd18e6,0x78a902c6,0xc17800c6}},	//   _hima_, _sjam, _zlev, tvė_,
   {{0x61e302e0,0x290418e7,0x649c0076,0x52aa074c}},	//   _cynl, _kima_, _béit, _छतीस,
   {{0x290418e8,0x649c033c,0x61e303a8,0x00000000}},	//   _jima_, _céit, _dynl, --,
   {{0x248618e9,0x290418ea,0x9c130294,0x78fb0266}},	//   _inom_, _mima_, _kọva, יפטו,
   {{0x26dc0335,0x6d4718eb,0x6f1d01cb,0x00000000}},	//   novo_, tuja, rpsc, --,
   {{0xdcbb18ec,0x61e30150,0x361b006e,0x7afb0036}},	//   аща_, _gynl, שולד, _èuti,
   {{0x290402dd,0x629818ed,0x5b1518ee,0x6d5502a7}},	//   _nima_, _hovo, змат, rtza,
   {{0x629816d4,0x2486005f,0x63a00e43,0x6d5518ef}},	// [1050] _kovo, _mnom_, nymn, stza,
   {{0x78a9000d,0x29040139,0x60dd18f0,0x78bb0095}},	//   _slev, _aima_, losm, _smuv,
   {{0x248604a3,0x290418f1,0x89d900e3,0x26dc18f2}},	//   _onom_, _bima_, حوار_, dovo_,
   {{0xf771054f,0x29040e3a,0x6f0d0010,0x629818f3}},	//   فات_, _cima_, _kuac, _lovo,
   {{0x7c2204d8,0xf21b0034,0x78a902c6,0x62980090}},	//   ñore, पुड़_, _vlev, _oovo,
   {{0xd6db18f4,0x248618f5,0x6f0d00de,0x290401ff}},	//   ште_, _anom_, _muac, _eima_,
   {{0x6f0d0099,0x290403e3,0x78a900e7,0xa954004d}},	//   _luac, _fima_, _tlev, _окрі,
   {{0x78bb0193,0x290418f6,0x78a918f7,0x27ed0634}},	//   _umuv, _gima_, _ulev, _tzen_,
   {{0x6f0d0080,0x649c00e3,0x61e302fe,0xf7700182}},	//   _nuac, _réit, _synl, _لال_,
   {{0xd2a90084,0x629818f8,0xf3f900d3,0x649c0a7d}},	//   ское_, _covo, neţi_, _béis,
   {{0x629818f9,0x216918fa,0x672900bd,0x6113020a}},	//   _dovo, щини_, _hwej, _băla,
   {{0x2009002b,0x6f0d152f,0x92cb0081,0x672918fb}},	//   _cgai_, _buac, লতে_, _kwej,
   {{0x61fe0074,0x7ea20257,0x09b80bf5,0x2d850b97}},	//   _úpln, _hôpi, _आध्य, ålen_,
   {{0xe3b009b4,0x523900c1,0x6f0d0332,0x59bd00df}},	//   _جرم_, _הײַנ, _duac, ्पार,
   {{0xb7bd00d3,0xf3f900d3,0x10a60a54,0x6729063d}},	//   _deţi, deţi_, _никн, _lwej,
   {{0x649c00e3,0x6ab4009f,0x5f7602a3,0x2cb20065}},	//   _héir, ंफ्र, _فاخر, _bímọ_,
   {{0x6b630805,0x69c3002b,0x62980154,0x00000000}},	// [1060] нкта, únen, _yovo, --,
   {{0x6d410080,0x0f7b021e,0x2cab01dc,0x290418fc}},	//   álac, _פריל, _elcd_, _sima_,
   {{0xfe9b00c1,0x290418fd,0x5e9b00ca,0x7e9b00ca}},	//   _היימ, _pima_, _הביק, _הסיו,
   {{0x649c0080,0x672918fe,0x2904009e,0xa2bb18ff}},	//   _léir, _bwej, _qima_, षोत्,
   {{0x7c241900,0x66e61901,0xc7a3037e,0x7eab09a1}},	//   mbir, пода, ницк, _hüpa,
   {{0xb6030146,0x7c2401af,0xf3f900d3,0x672900bd}},	//   _otáč, lbir, ceţi_, _dwej,
   {{0x2904042d,0x6298015c,0x7d061902,0x00000000}},	//   _tima_, _rovo, _kiks, --,
   {{0x26dc0542,0x7c241903,0x649c036b,0x62980141}},	//   sovo_, nbir, _réis, _sovo,
   {{0x62981904,0x7d061905,0xe6461906,0xf7431907}},	//   _povo, _miks, _неап, _пето,
   {{0x2cfa04f1,0x7d061908,0x9c130174,0x649c1909}},	//   ्दुल_, _liks, _họta, _céir,
   {{0xb7bd00d3,0x9c130174,0x62980231,0x649c00da}},	//   _reţi, _kọta, _vovo, _déir,
   {{0x7d06190a,0x2486019c,0x75d30037,0x6298042c}},	//   _niks, _unom_, _ثيما, _wovo,
   {{0x7c24190b,0x62980087,0xdfdb008f,0x6f0d142d}},	//   dbir, _tovo, сън_, _quac,
   {{0xd24f00ab,0x7c24190c,0x9c130174,0xdb230018}},	//   _منه_, ebir, _lọta, ہوری,
   {{0x7d0600e8,0xa2d906e4,0x51860131,0xf3f9044c}},	//   _biks, नकर्, _хула, veţi_,
   {{0x7c24190d,0x6f0d190e,0x2a7f0233,0x2b4901ff}},	//   gbir, _tuac, _şub_, tuac_,
   {{0x2d8c190f,0x7d061910,0xf3f9002d,0xddde00a7}},	// [1070] äder_, _diks, teţi_, _tapş,
   {{0x7c24083e,0x0dcb1911,0xa5771912,0x67291913}},	//   abir, _гуми_, ščić, _rwej,
   {{0x7c241914,0xa9071915,0xf3f9020a,0xa3de00a4}},	//   bbir, سبان, reţi_, _दुस_,
   {{0xe9f8004d,0x6ef202b6,0x00000000,0x00000000}},	//   їнці_, ræbe, --, --,
   {{0x3b640020,0x9c130134,0x6913009e,0x2d571916}},	//   _първ, _dọta, _għen, lçe_,
   {{0x6447013f,0x4519098e,0x00000000,0x00000000}},	//   ėjim, оция_, --, --,
   {{0x672400d9,0x2d571917,0x7c2f01dc,0x00000000}},	//   ģija, nçe_, _kecr, --,
   {{0xc95200a1,0x67290172,0x8af0013c,0x00000000}},	//   _שמן_, _twej, ntən, --,
   {{0x2d5701e8,0x649c0076,0x7eb0007b,0xb60300d4}},	//   hçe_, _péir, _häpe, _stáč,
   {{0x2d57026a,0x999105db,0x957c007f,0x00000000}},	//   kçe_, _zdzš_, _cząs, --,
   {{0x3ce902f1,0x904600cd,0xa06a00ae,0x00000000}},	//   klav_, ونده, оана_, --,
   {{0xcea91541,0x7c24013c,0x764d03e3,0xb6030206}},	//   _די_, xbir, ɗaya, _vtáč,
   {{0x7d061918,0x00000000,0x00000000,0x00000000}},	//   _riks, --, --, --,
   {{0x7d061919,0xc3320266,0x442f191a,0x1d0a0e06}},	//   _siks, _יוד_, _heg_, жеви_,
   {{0xfce6191b,0x7d0600bf,0x8af0013c,0x00000000}},	//   дово, _piks, ftən, --,
   {{0x442f191c,0x3ce9191d,0x7c2f191e,0x2cfa074c}},	//   _jeg_, glav_, _cecr, ्देल_,
   {{0x442f191f,0x7c241920,0x7c2f1921,0x46dd167f}},	// [1080] _meg_, rbir, _decr, यवाह,
   {{0x7c2410f8,0x7d060383,0x4a430396,0xda660037}},	//   sbir, _wiks, кнув, باري,
   {{0xa96a0391,0x7d061922,0xd910001c,0x00000000}},	//   تمام_, _tiks, ایر_, --,
   {{0x442f06a3,0x53ad0557,0x7c2f1923,0x3ce91924}},	//   _neg_, टनाश, _gecr, clav_,
   {{0x69d51925,0xafdb0537,0x291c004b,0x00000000}},	//   _exze, lgør, ūva_, --,
   {{0x442f0006,0x9c130134,0x7c2f010a,0x64d61926}},	//   _aeg_, _wọta, _zecr, डक्श,
   {{0x442f1927,0xafdb0c08,0x443d0090,0x9856007e}},	//   _beg_, ngør, _bdw_, _оташ,
   {{0x442f006c,0xb05b007b,0x00000000,0x00000000}},	//   _ceg_, nnät, --, --,
   {{0x442f1928,0x9c130174,0xfc3f003e,0x443d030a}},	//   _deg_, _kọra, _slík_, _ddw_,
   {{0x3958023e,0x672201b6,0x00000000,0x00000000}},	//   _kqrs_, mpoj, --, --,
   {{0x67220029,0x44241929,0x691302a1,0x442f0324}},	//   lpoj, pbm_, _nħel, _feg_,
   {{0x3cfa0034,0x3f86192a,0x442f192b,0x2a780113}},	//   ्दों_, _šoua_, _geg_, _larb_,
   {{0xceeb16c4,0x7c2f192c,0x26ce0451,0x5f94008f}},	//   قرآن_, _recr, onfo_, вият,
   {{0x442f0126,0x7c2f192d,0x2d570233,0x2d8105db}},	//   _zeg_, _secr, tçe_, _prhe_,
   {{0x26ce192e,0xafdb052f,0x9d18192f,0x443d00f0}},	//   info_, ggør, дост_, _ydw_,
   {{0x9f5500d6,0x2cb20150,0x2d571930,0x00000000}},	//   _звич, ghyd_, rçe_, --,
   {{0x7c220610,0x7c2f01d3,0xd13800c6,0x7e770158}},	// [1090] ñora, _vecr, lsą_, _taxp,
   {{0x8af0013c,0xe9ab0076,0x48be0033,0x201901f9}},	//   stən, يدان_, ইকোর, lcsi_,
   {{0x7c2f01e8,0x2a781931,0x3d250154,0x69130078}},	//   _tecr, _darb_, _dèwò_, _għel,
   {{0x2cb202ad,0x628a0124,0x20190103,0x2d1b0174}},	//   chyd_, _lnfo, ncsi_, _ụgwụ_,
   {{0x442f1932,0xb8d70251,0x2366022e,0xe76b006f}},	//   _reg_, _छत_, _npoj_, تحان_,
   {{0x442f0a8d,0x9c130174,0x99670927,0xd13800c6}},	//   _seg_, _tọsa, _отбл, ksą_,
   {{0x26c901ac,0xb05b16f9,0x00000000,0x00000000}},	//   đao_, nnäs, --, --,
   {{0x628a1933,0x2ca902c3,0x00000000,0x00000000}},	//   _anfo, nkad_, --, --,
   {{0x442f1934,0xe3b10037,0x29111935,0xd13800c6}},	//   _veg_, طرة_, _huza_, esą_,
   {{0x442f1936,0x29111937,0x3125007e,0x00000000}},	//   _weg_, _kuza_, ндог, --,
   {{0x442f1938,0x2a630063,0x2f140212,0xc87903e0}},	//   _teg_, _mbjb_, _säg_, _kaş_,
   {{0x8cc100a3,0x6e3e00e7,0x628a1939,0x442f00b3}},	//   रोमो, _sdpb, _enfo, _ueg_,
   {{0xc00000c7,0xe3ae0457,0x6d41193a,0x2ca907ac}},	//   ূর্ণ_, _сб_, álan, dkad_,
   {{0x539a193b,0x2f140222,0xafdb02b6,0x2911022b}},	//   _מינו, _väg_, tgør, _ouza_,
   {{0x98a700b6,0x29110169,0x9f6302c6,0xd24e0076}},	//   éně_, _nuza_, ěvák_, _انى_,
   {{0xfce3007e,0xfce60450,0xfe7800c6,0xafdb0537}},	//   госо, хобо, žį_, rgør,
   {{0x60c6193c,0xcb67193d,0xca860077,0x60d700ca}},	// [10a0] mikm, нате_, нгай, _רופא_,
   {{0x2911193e,0x60c6193f,0x691300bd,0xafdb0537}},	//   _buza_, likm, _iħej, pgør,
   {{0xc8790253,0xdca61940,0xc8661941,0x98a61942}},	//   _baş_, _зани, етли, ниже,
   {{0x60c606ee,0x2ca90149,0x6d4e1943,0x48be0033}},	//   nikm, ckad_, muba, ইক্র,
   {{0x6d4e1944,0xb05b1945,0x7c3601af,0xc87900a7}},	//   luba, onär, mayr, _daş_,
   {{0x26ce1946,0x7e7c02ef,0xb05b1947,0x691300bd}},	//   unfo_, ndrp, nnär, _mħej,
   {{0x23660559,0x29110995,0x550600ae,0x00000000}},	//   _spoj_, _guza_, нчиа, --,
   {{0x6d5c1948,0x672200c2,0x39470072,0xb05b042c}},	//   itra, ppoj, ánse_, hnär,
   {{0x6d4e1949,0x68e2194a,0x29110ec4,0x60c60167}},	//   huba, mood, _zuza_, dikm,
   {{0x6d4e194b,0x8af00092,0x6d4701cd,0x2911010a}},	//   kuba, xtəl, yrja, _yuza_,
   {{0xe3af03ed,0x6d5c042d,0xc87903a3,0xd46a194c}},	//   لری_, jtra, _yaş_, _ниже_,
   {{0xe61f0028,0x6d4e194d,0x6d5c194e,0xd1380138}},	//   _đôi_, duba, dtra, rsą_,
   {{0xb4be194f,0xdefb0084,0x6d5c0bd3,0xd4370a41}},	//   ुची_, зыв_, etra, _טראק_,
   {{0x68e2008a,0x6d5c1950,0x628a00ca,0xb8160033}},	//   hood, ftra, _unfo, ারিত_,
   {{0x6d5c1951,0x68e20be9,0x6e3507c0,0xc27b00a1}},	//   gtra, kood, razb, _מרגי,
   {{0xdef803e5,0x8af00092,0x29111952,0x68e21953}},	//   ċċa_, stəl, _ruza_, jood,
   {{0x68e20694,0x6d5c1954,0x2911005f,0x2ca91955}},	// [10b0] dood, atra, _suza_, rkad_,
   {{0x6d4e1956,0x2ca91957,0x6f070065,0x9b44001c}},	//   buba, skad_, _débì, انلو,
   {{0x7c361958,0xc98407c7,0x67200113,0x6d4e1959}},	//   bayr, луци, _atmj, cuba,
   {{0x68e2008a,0xcd9600ca,0x61ea0154,0x7afe0f5a}},	//   good, _סדרת_, _myfl, ampt,
   {{0x4c9a040a,0xd763001c,0x00000000,0x00000000}},	//   _חברו, انتی, --, --,
   {{0x07a21787,0x6446195a,0xc6680291,0x2911195b}},	//   рашн, ókin, ешће_, _tuza_,
   {{0xc879026a,0x68e2195c,0x20e1097c,0x00000000}},	//   _taş_, bood, नवाध, --,
   {{0xc485007e,0x68e20188,0x00000000,0x00000000}},	//   тлик, cood, --, --,
   {{0xa3de0251,0x6d4e195d,0x77550c79,0x6d5c195e}},	//   _दुआ_, zuba, _шкаф, ztra,
   {{0x6d4e195f,0x6d5c1960,0x8cc1007f,0x00000000}},	//   yuba, ytra, रोतो, --,
   {{0x26c71961,0x61ea02e0,0x60c61962,0x7c3600f9}},	//   mino_, _cyfl, tikm, yayr,
   {{0xf4850068,0x6d5c1963,0x3cf902ac,0x2b491964}},	//   _جائی, vtra, _nhsv_, krac_,
   {{0x7fd60565,0x3f84030b,0x6d5c182f,0xb05b0212}},	//   тіні, ímu_, wtra, tnär,
   {{0x6d5c1965,0x26c71966,0x2b491967,0x6d4e1968}},	//   ttra, nino_, drac_, tuba,
   {{0xed571969,0x61ea02ad,0x68e2008a,0xb05b02c3}},	//   кор_, _gyfl, yood, rnär,
   {{0x6d4e196a,0x26c7196b,0x6d5c196c,0xf8db0285}},	//   ruba, hino_, rtra, यकोप,
   {{0x26c7196d,0x6d4e196e,0x387d00f0,0x8af000a7}},	// [10c0] kino_, suba, ddwr_, stəm,
   {{0x68e2196f,0x26c71970,0x7c360e8e,0x0f37006e}},	//   wood, jino_, sayr, _שריט_,
   {{0xa3de000d,0x68e21971,0xda650037,0x80c600c0}},	//   _दुई_, tood, طالي, _लगाइ,
   {{0xd3080023,0xdca60ef1,0x2b491972,0x00000000}},	//   _hệt_, _рами, brac_, --,
   {{0x68e21973,0x60c40350,0x00000000,0x00000000}},	//   rood, _mmim, --, --,
   {{0x26c71974,0x65680063,0x68e21975,0xb05b09ab}},	//   gino_, _ppdh, sood, hnäp,
   {{0xceb30054,0xd30800de,0x60c40129,0xd5af0190}},	//   שיו_, _mệt_, _omim, يفه_,
   {{0x98a31121,0xb4be1006,0x68e2008c,0x00000000}},	//   _кисе, ुचे_, qood, --,
   {{0x26c71976,0x6ef202b6,0x98a31977,0x00000000}},	//   bino_, væbn, _тите, --,
   {{0x26c71978,0x00000000,0x00000000,0x00000000}},	//   cino_, --, --, --,
   {{0x40351979,0xa3e702d5,0x3a3700ca,0xaa37006e}},	//   ленс, _मुठ_, כרים_, כטיק_,
   {{0x30a7197a,0x9346197b,0x6abf0557,0x60c4023b}},	//   тров, _анде, _एग्र, _cmim,
   {{0x2d8c0bab,0x644201c8,0x2d9e197c,0xd30800fe}},	//   åden_, _idoi, äten_, _bệt_,
   {{0x41dd1362,0x60c4083e,0x78a0197d,0x00000000}},	//   _नुकस, _emim, _lomv, --,
   {{0x7b09197e,0xd3080023,0x2d850a93,0xeda4197f}},	//   _džul, _dệt_, íle_, ашто,
   {{0x629a0542,0xf0470152,0x60d60052,0x28c41980}},	//   ljto, _рэко, _gjym, लोमि,
   {{0x09bd05a5,0x1be300a3,0x59d51981,0x0bf51982}},	// [10d0] ्प्य, _कुशल_, _दशहर, упаю,
   {{0xdd03008b,0x6d481983,0x26c71984,0x629a0216}},	//   ırıc, ádac, xino_, njto,
   {{0x26c71985,0x81e40081,0x78a01986,0x6cd50e5a}},	//   vino_, পের_, _bomv, _مقدا,
   {{0x26c71987,0x64420076,0x3cf600a4,0x00000000}},	//   wino_, _ndoi, ्षणे_, --,
   {{0x3ea1007a,0x78a0080e,0x7b090138,0x386f00c4}},	//   _koht_, _domv, _užuo, regr_,
   {{0x644208a8,0x00000000,0x00000000,0x00000000}},	//   _adoi, --, --, --,
   {{0x26c71988,0xfc3f033c,0x00000000,0x00000000}},	//   rino_, _flít_, --, --,
   {{0xf77301f9,0xe6f2020b,0x00000000,0x00000000}},	//   _پار_, _vườ, --, --,
   {{0x26c71989,0x68e90032,0x13090938,0xdce500d9}},	//   pino_, _iked, нний_, _arhī,
   {{0xd7f8198a,0x6b6701d3,0x68fb0172,0x27ed0032}},	//   _рус_, mīgā, _hhud, _iyen_,
   {{0x2455006f,0x27fa00a5,0xa0a6198b,0x68fb0188}},	//   _مناس, ępne_, ганд, _khud,
   {{0x5fc500aa,0xd30800fe,0x00000000,0x00000000}},	//   _लेहल, _sệt_, --, --,
   {{0x7ae5198c,0x27ed0154,0x68fb0a4b,0x6b6700e8}},	//   koht, _jyen_, _mhud, nīgā,
   {{0x7ae500c2,0x63bb198d,0x63a9198e,0x68fb009e}},	//   joht, mzun, myen, _lhud,
   {{0x27ed14b1,0x270f00c0,0xc87901e8,0x8af00092}},	//   _lyen_, ादुर_, _ekşi_, stək,
   {{0x60c4198f,0x7b091528,0x27ed037a,0x63bb024a}},	//   _umim, _džum, _oyen_, ozun,
   {{0x63a91990,0x63bb1991,0x27ed0027,0xf412006e}},	// [10e0] nyen, nzun, _nyen_, מפן_,
   {{0xfeba00bf,0x290d0d2a,0x68e91992,0x63bb1993}},	//   _ساخت_, _aiea_, _aked, izun,
   {{0x6da61994,0x27ed05aa,0x09f61278,0x8cc1023a}},	//   _сина, _ayen_, учая, रोहो,
   {{0x270f007d,0xd7fa1995,0x68fb1996,0x7e7e1997}},	//   ादूर_, нул_, _chud, _happ,
   {{0x7e7e1998,0x96ea0bd5,0xddc71515,0x3d1a0caf}},	//   _kapp, нька_, mejš, _मंडे_,
   {{0x7e7e03e5,0xddc71999,0x68e90134,0x68fb039f}},	//   _japp, lejš, _eked, _ehud,
   {{0x7e7e199a,0x7b0916a2,0x9f45199b,0xd639004d}},	//   _mapp, _ožuj, ́là_, тячі_,
   {{0xddc7199c,0x3a3a199d,0x63bb042c,0x6b8409a1}},	//   nejš, lapp_, fzun, ovig,
   {{0xa3de04dd,0x63a9199e,0x6b6701d3,0x6b84059a}},	//   _दुख_, gyen, cīgā, nvig,
   {{0x7e7e199f,0xf12619a0,0x22580342,0xe3130037}},	//   _napp, льмо, ürk_, حبيب,
   {{0x23ba0032,0xc6100179,0x6b8400bc,0x63a902ac}},	//   _bàjé_, ाशीय_, hvig, ayen,
   {{0x657a0113,0x7e7e19a1,0x63a919a2,0x6f16033c}},	//   _isth, _aapp, byen, _buyc,
   {{0xdb0419a3,0x7e7e0085,0x3a3a19a4,0x4fc719a5}},	//   nzió, _bapp, kapp_, усна,
   {{0x7e7e19a6,0x00000000,0x00000000,0x00000000}},	//   _capp, --, --, --,
   {{0x7e7e19a7,0xccfb0831,0x291c0094,0x7eb000bc}},	//   _dapp, ећа_, íval_, _täpn,
   {{0x61f519a8,0x00000000,0x00000000,0x00000000}},	//   üzle, --, --, --,
   {{0x5a3519a9,0x7afc009c,0x00000000,0x00000000}},	// [10f0] инат, _bhrt, --, --,
   {{0x68fb0022,0x68e919aa,0x6113020a,0x6b6700e8}},	//   _shud, _sked, _săli, vīgā,
   {{0x657a01fa,0x7ae519ab,0x2d9e004d,0x7dd20103}},	//   _nsth, roht, øtet_, rűsé,
   {{0xf77104f4,0x7e7e19ac,0xddc719ad,0x6b6700e8}},	//   قات_, _zapp, cejš, tīgā,
   {{0x7c2d19ae,0x69dc05b4,0x2ab60537,0x4e1919af}},	//   mbar, _exre, _sæbe_, _दलाई_,
   {{0x6b6700d9,0xe4630555,0x89370281,0x63bb013c}},	//   rīgā, şmüş, _معرا, vzun,
   {{0x7d0f0068,0x5e5800c1,0x68fb19b0,0x00000000}},	//   _kics, טיגע_, _thud, --,
   {{0x63bb19b1,0x58d500d6,0x68fb00e7,0x3f8900f0}},	//   tzun, _тобт, _uhud, _orau_,
   {{0x3f89023e,0x7c2d19b2,0x27ed00fe,0x63bb19b3}},	//   _nrau_, ibar, _uyen_, uzun,
   {{0x52a919b4,0x63a919b5,0x7c2d19b6,0x387f0a00}},	//   твом_, ryen, hbar, _haur_,
   {{0x63a919b7,0x7c2d19b8,0x7e7e19b9,0x3f8901e9}},	//   syen, kbar, _rapp, _arau_,
   {{0x7e7e19ba,0x7c2d00a5,0x3f8919bb,0xf8b50336}},	//   _sapp, jbar, _brau_, ंसिय,
   {{0x442d19bc,0x7e7e19bd,0xddc719be,0x387f19bf}},	//   mbe_, _papp, vejš, _maur_,
   {{0x442d19c0,0x6b840451,0x7b09007e,0x387f19c1}},	//   lbe_, vvig, _džuk, _laur_,
   {{0x3f89002d,0x3c420018,0xddc70211,0x7c2d19c2}},	//   _erau_, _lévő_, tejš, fbar,
   {{0x0c2619c3,0x7c2d19c4,0x442d19c5,0x3f89030f}},	//   рман, gbar, nbe_, _frau_,
   {{0x442d19c6,0x3f8919c7,0x7e7e19c8,0xddc702dd}},	// [1100] ibe_, _grau_, _tapp, rejš,
   {{0x6b8419c9,0x628119ca,0xaa4619cb,0x7d1701ee}},	//   rvig, ndlo, режл, _fuxs,
   {{0x6e3c02fe,0x7c2d19cc,0x2d850c2e,0x7d0f0527}},	//   marb, bbar, ålet_, _fics,
   {{0x442d19cd,0x6e3c19ce,0x9c1400ac,0x387f01d3}},	//   jbe_, larb, _kọmp, _caur_,
   {{0x7d0419cf,0x442d19d0,0xdddc0018,0x387f0194}},	//   mmis, dbe_, merő, _daur_,
   {{0x7d0419d1,0x6b8b01c5,0x442d19d2,0x6e3c19d3}},	//   lmis, ægge, ebe_, narb,
   {{0x3856008f,0xd94319d4,0x387f078e,0x00000000}},	//   _възс, _мери, _faur_, --,
   {{0x442d0649,0x387f02a7,0xa3e70251,0x6e3c19d5}},	//   gbe_, _gaur_, _मुह_, harb,
   {{0x7d0419d6,0x291819d7,0x386619d8,0x649c0072}},	//   imis, _hura_, mfor_, _méix,
   {{0x291819d9,0x6d4117b1,0x442d0361,0x7d0419da}},	//   _kura_, šlai, abe_, hmis,
   {{0x6e3c19db,0x442d19dc,0x7b0900e7,0x657a063d}},	//   darb, bbe_, _džuh, _usth,
   {{0x386619dd,0x291819de,0x7c2d008a,0xd57700a1}},	//   nfor_, _mura_, xbar, _כתבה_,
   {{0x291819df,0x7d04007a,0x4ea719e0,0x6e3c19e1}},	//   _lura_, dmis, арва, farb,
   {{0x6e3c19e2,0xa15805b6,0x7d0419e3,0x3f890052}},	//   garb, _баку_, emis, _vrau_,
   {{0x291819e4,0x7d0f19e5,0x02fb0796,0x7d040ac1}},	//   _nura_, _pics, _שלומ, fmis,
   {{0x7d0419e6,0x7c2d19e7,0xb03519e8,0xdddc0103}},	//   gmis, ubar, _униш, gerő,
   {{0x7c2d19e9,0x291819ea,0x5c07013d,0x2fcf0149}},	// [1110] rbar, _aura_, рява, _ägg_,
   {{0x7c2d19eb,0x442d19ec,0x7d040084,0x291819ed}},	//   sbar, zbe_, amis, _bura_,
   {{0x291819ee,0x442d19ef,0x3a3819f0,0x7d0419f1}},	//   _cura_, ybe_, _derp_, bmis,
   {{0x38690653,0x7c9500e3,0x6d5519f2,0x620500a7}},	//   ýar_, _الحص, muza, ürlə,
   {{0x3cf404a9,0x29180fa3,0x7bd801e8,0x442d19f3}},	//   ंतरे_, _eura_, şvur, vbe_,
   {{0x291819f4,0x1fd90033,0x69c3002b,0x00000000}},	//   _fura_, _সরাস, únes, --,
   {{0x20d20038,0x291819f5,0x27fa00a5,0x6a220068}},	//   lšie_, _gura_, ępna_, _رہنم,
   {{0x442d01bf,0x9dd800ca,0x6e3c19f6,0x3a3800c4}},	//   ube_, יווק_, zarb, _zerp_,
   {{0x6d5519f7,0x291819f8,0x7c220610,0x6e3c026a}},	//   huza, _zura_, ñori, yarb,
   {{0x442d19f9,0x29180085,0x6d5519fa,0x628100f9}},	//   sbe_, _yura_, kuza, udlo,
   {{0x628119fb,0x7d0419fc,0x20d20220,0xe5f50037}},	//   rdlo, ymis, hšie_, _اكاد,
   {{0x9c140174,0x6d5519fd,0x00000000,0x00000000}},	//   _pọmp, duza, --, --,
   {{0x20d20038,0x6e3c19fe,0xfbc70179,0xdfd20190}},	//   jšie_, tarb, _रेलम, سيس_,
   {{0xed5a19ff,0x249f1a00,0x6d551a01,0xd5430139}},	//   лог_, ljum_, fuza, _gẹ̀g,
   {{0x7d040006,0x6e3c1a02,0x6d551a03,0xa0a60db2}},	//   tmis, rarb, guza, _гайд,
   {{0x6e3c1a04,0x3a38061c,0xceb400a7,0x998305db}},	//   sarb, _serp_, _atət_, _bejž_,
   {{0x7e751643,0x29180b8c,0x6a160b05,0x2247061d}},	// [1120] bezp, _sura_, مبار, _kdnk_,
   {{0x3f8f0396,0x6d551a05,0x7d041a06,0x2b40044c}},	//   _água_, buza, smis, rsic_,
   {{0x8fc500cd,0x5d8600e3,0x249f003e,0xd23a006e}},	//   _هزین, _الجل, kjum_, רגעל,
   {{0x3a380a88,0xb4c6074c,0x29181a07,0x20d20206}},	//   _werp_, _उगे_, _vura_, bšie_,
   {{0x38661a08,0xdd8f0421,0x6da50022,0xa3e71a09}},	//   rfor_, _قوی_, nɗan, _मुल_,
   {{0x29181114,0x6da503e3,0xe9440281,0x00000000}},	//   _tura_, iɗan, _ورزی, --,
   {{0x058600d3,0xaadd009d,0x237d00dc,0x249f01cd}},	//   сулм, _मदतक, _aswj_, fjum_,
   {{0x249f01cd,0x00000000,0x00000000,0x00000000}},	//   gjum_, --, --, --,
   {{0x6d551a0a,0x644f1a0b,0x00000000,0x00000000}},	//   zuza, ócia, --, --,
   {{0x25610068,0xe6431a0c,0x224701ff,0x29060062}},	//   ból_, _неуп, _cdnk_, lmoa_,
   {{0xf09f0472,0x764802ad,0xd6cf13c3,0x6a9b006e}},	//   tjà_, _iddy, _ثقل_, אשינ,
   {{0x9c140174,0x2ca01a0d,0x26ce1314,0x64a31a0e}},	//   _dọkp, jjid_, lifo_, _наха,
   {{0x33f60fba,0x2ca0042f,0xc7b4006e,0x6d551a0f}},	//   _اساس, djid_, קבֿ_, wuza,
   {{0x20d20181,0x6d551a10,0x3d1100c3,0x3d9500c2}},	//   všie_, tuza, _दूजे_, оигр,
   {{0x3b110090,0x00000000,0x00000000,0x00000000}},	//   _rizq_, --, --, --,
   {{0x6d551a11,0x26ce1a12,0x8cf50c10,0x853b00c1}},	//   ruza, hifo_, ізац, טגלי,
   {{0xab87013d,0x764817a4,0x7b141940,0xa4b700ca}},	// [1130] щувк, _oddy, здух, צלמה_,
   {{0x20d20220,0x705504c6,0x6d5505bd,0x249f0034}},	//   ršie_, _انکا, puza, zjum_,
   {{0xceb20796,0x69c80559,0x2d870381,0x249f01cd}},	//   _חיי_, _žder, _éne_, yjum_,
   {{0x764802ad,0x20d20181,0x515b0341,0x8af0013c}},	//   _addy, pšie_, רכאו, ftəs,
   {{0xf74500d3,0x291e0072,0x752800e8,0x656103a9}},	//   цело, _étan_, _atdz, _sqlh,
   {{0x25610068,0x79820034,0xf7701a13,0x7f3c006e}},	//   tól_, łowa, عان_, נעוו,
   {{0x04590037,0x00000000,0x00000000,0x00000000}},	//   للغة_, --, --, --,
   {{0xc3251a14,0x25610068,0x03251a15,0x7eab00aa}},	//   омик, ról_, один, _küps,
   {{0x249f0088,0x7b0900e7,0x386d00b3,0xd299004d}},	//   rjum_, _džuv, _iber_, атні_,
   {{0x02c502ec,0x68eb1a16,0x69130078,0xb1451a17}},	//   ійно, logd, _għer, онол,
   {{0xe0da1a18,0xd4e702ec,0x2bd004f8,0x21691a19}},	//   иво_, _люди, _सेना, шини_,
   {{0x237d0197,0xd00a060b,0x60cf014b,0x672900bd}},	//   _tswj_, иене_, gicm, _ktej,
   {{0x443f1a1a,0x03a50848,0x6d45169c,0xe2991a1b}},	//   mau_, _фило, _avha, _вал_,
   {{0x443f1a1c,0x645b1a1d,0x67291a1e,0x99830090}},	//   lau_, lgui, _mtej, _bejż_,
   {{0x2d8c1a1f,0x386d1a20,0xa0a61a21,0x6283078e}},	//   íde_, _ober_, _макд, _iano,
   {{0x443f1a22,0x645b1a23,0x3f86007e,0xe29a020b}},	//   nau_, ngui, _šouu_, _thưc_,
   {{0x62831a24,0x5aca055b,0x67291a25,0xeab20018}},	// [1140] _kano, алам_, _ntej, وٹر_,
   {{0x386d02d6,0x443f1a26,0x2ca01a27,0x63a60120}},	//   _aber_, hau_, sjid_, økni,
   {{0x443f1a28,0xdca61a29,0x67291a2a,0x6d410018}},	//   kau_, _дани, _atej, álat,
   {{0x186a1a2b,0x443f1a2c,0x62831a2d,0xd7240139}},	//   ради_, jau_, _lano, _aṣọg,
   {{0x443f1a2e,0x27e01a2f,0xd70a1942,0x4733004d}},	//   dau_, çin_, анде_, дніс,
   {{0x29060a00,0x9f610018,0x27e0003d,0xddde022b}},	//   smoa_, ését_, ħin_, _japů,
   {{0x68eb1a30,0x443f0150,0x67290134,0xe1e71850}},	//   bogd, fau_, _etej, _آس_,
   {{0x7c241a31,0x443f02ad,0x20050092,0x26ce019f}},	//   ncir, gau_, əlif_, sifo_,
   {{0x62831a32,0x69130090,0x8af000a7,0x7c2400c4}},	//   _bano, _għeq, qtəs, icir,
   {{0x6283030a,0x78a2049c,0x645b0d5a,0x386d0031}},	//   _cano, ljov, agui, _zber_,
   {{0x443f1a33,0xe29a00ef,0x60cf008a,0x69c11a34}},	//   bau_, _chưa_, ticm, _žlez,
   {{0x78a2007e,0x00000000,0x00000000,0x00000000}},	//   njov, --, --, --,
   {{0x442600ac,0x64401a35,0x62831a36,0xe3b21a37}},	//   _ifo_, mami, _fano, _ترا_,
   {{0x62831a38,0x7c261a39,0xfbdf030a,0x00000000}},	//   _gano, _afkr, _ddêl_, --,
   {{0xeca707ed,0x9c8300b6,0x64400239,0x4426010a}},	//   ојан, íčov, oami, _kfo_,
   {{0x6aaa01bf,0x4c9400c2,0x00000000,0x00000000}},	//   öffn, мисс, --, --,
   {{0x628310b1,0xdfd102fc,0x26cc1a3a,0x4426063d}},	// [1150] _yano, _سيد_, _omdo_, _mfo_,
   {{0x64401a3b,0x44240019,0x443f1a3c,0x6d411a3d}},	//   hami, hcm_, zau_, álas,
   {{0xceb207a6,0x6440005e,0x6729000d,0xe2a60102}},	//   _ניט_, kami, _stej, _áður_,
   {{0x5d7a00c1,0x2d811a3e,0x443f022e,0x7c2418f6}},	//   _פארק, _ishe_, xau_, ccir,
   {{0x64401a3f,0x443f013f,0x7b640c79,0x60cd06b0}},	//   dami, vau_, _отре, _mmam,
   {{0x8af001d4,0x44261a40,0x443f1a41,0xcf5800a1}},	//   stər, _afo_, wau_, קבות_,
   {{0x443f1a42,0x60cd1a43,0x7c3d1a44,0x20d20031}},	//   tau_, _omam, _kesr, hšia_,
   {{0x64401a45,0x628302fd,0x44261a46,0x16190034}},	//   gami, _sano, _cfo_, दशहर_,
   {{0x443f02e0,0x7c3d1a47,0x20d20220,0x4426039f}},	//   rau_, _mesr, jšia_, _dfo_,
   {{0x60cd1a48,0x443f1a49,0x78a904ee,0x62831a4a}},	//   _amam, sau_, _hoev, _qano,
   {{0x62831a4b,0x443f1a4c,0x64401a4d,0x78a91a4e}},	//   _vano, pau_, bami, _koev,
   {{0x62831a4f,0x44240239,0x00000000,0x00000000}},	//   _wano, ccm_, --, --,
   {{0x62830256,0x2d811a50,0xa29500d6,0x78bb030b}},	//   _tano, _ashe_, _наді, _mluv,
   {{0x78bb0890,0xe29a00de,0x2bef00aa,0x78a90bd3}},	//   _lluv, _thưa_, _आड़ू_, _loev,
   {{0xde031a51,0x6da61a52,0x443d02f1,0x78bb0283}},	//   епри, чива, _kew_, _oluv,
   {{0xdca31a53,0x61fc01e8,0x8b261855,0xc5f200ca}},	//   наси, ürle, здае, גדל_,
   {{0xeb971a54,0x6d4101cd,0x945d007f,0x5f461454}},	// [1160] пит_, álar, lińs, _عندل,
   {{0x09e61121,0x7c241a55,0x443d14b7,0x7c3d09a1}},	//   позн, scir, _lew_, _eesr,
   {{0x6440149c,0x78a2037a,0x78a901cb,0x00000000}},	//   yami, tjov, _boev, --,
   {{0x443d004f,0x7eab00aa,0x64401a56,0xfce61a57}},	//   _new_, _hüpp, xami, _хомо,
   {{0x64401a58,0x8af00092,0x7d1e1a59,0x6b8900c4}},	//   vami, stəq, _hups, _šegv,
   {{0xab270465,0xd9460c37,0x64401a5a,0x442613b9}},	//   _хора_, _неги, wami, _sfo_,
   {{0x64401a5b,0x78a20138,0x44240072,0x09e31a5c}},	//   tami, pjov, tcm_, _зорн,
   {{0x443d0167,0x78bb1a5d,0x89db00ca,0x00000000}},	//   _cew_, _gluv, _החלי, --,
   {{0x64401a5e,0xe73702fd,0x68e30328,0x00000000}},	//   rami, _нет_, énde, --,
   {{0x64401a5f,0xbebb0052,0x6e3e0381,0x78a90381}},	//   sami, hpër, _nepb, _zoev,
   {{0x443d00a1,0x705500b9,0x2000039f,0x7d1e09a1}},	//   _few_, وندا, _azii_, _nups,
   {{0x443d1a60,0x64400372,0x69c100bc,0xdfd5013f}},	//   _gew_, qami, _ülee, домы,
   {{0x2d8c02b6,0xdcb10023,0x00000000,0x00000000}},	//   æden_, ểm_, --, --,
   {{0x7bc416d7,0x20d21a61,0x7c3d1a62,0x00000000}},	//   dziu, ršia_, _sesr, --,
   {{0x443d1a63,0xdd940138,0x7eb000aa,0x290400c4}},	//   _yew_, нары, _näpu, _ohma_,
   {{0x60cd1a64,0x20d20031,0x62881a65,0x7d1e1a66}},	//   _umam, pšia_, lddo, _dups,
   {{0x2bc70a30,0x5b151a67,0xfbd30452,0x00000000}},	// [1170] _रेखा, дмат, رتر_, --,
   {{0x7b090542,0x62881a68,0x2d81022e,0x6da501c2}},	//   _ažur, nddo, _tshe_, nɗak,
   {{0x2d8c0501,0x2d811a69,0x60dd1a6a,0x7bc4078e}},	//   ådet_, _ushe_, onsm, aziu,
   {{0x6d550a9e,0xcfd20af0,0x2904009c,0x3157006e}},	//   mrza, _apẹẹ, _chma_, ליבן_,
   {{0x629803ee,0x7b0900e7,0x2bc819c3,0x9be4004d}},	//   _onvo, _džur, _еуро_, _зірк,
   {{0x443d003d,0x6b8d02a4,0x6d551a6b,0x00000000}},	//   _sew_, mvag, orza, --,
   {{0x78a9043e,0x58d502ec,0x6f17037a,0x6d471a6c}},	//   _toev, _жовт, _mixc, nsja,
   {{0xe3b91a6d,0x6add02d5,0x62881a6e,0x6d480076}},	//   жби_, _मदुर, eddo, ádai,
   {{0xa3e70782,0xf770003f,0x27ff08bb,0x62881a6f}},	//   _मुख_, _مال_, _uzun_, fddo,
   {{0x25e802b0,0xfc3f1a70,0x04fd0033,0x6d4700bc}},	//   _चुकी_, _leí_, ঁদের_, ksja,
   {{0x76431a71,0x6d550034,0x41b4083c,0xc0e6001f}},	//   many, jrza, есят, донк,
   {{0x62981a72,0x6d551197,0x644b01c5,0x76431a73}},	//   _envo, drza, _udgi, lany,
   {{0x7d1e0039,0x6d55007f,0x945d007f,0x00000000}},	//   _sups, erza, sińs, --,
   {{0x76431a74,0xe299002d,0x7bc40052,0xa3d3058f}},	//   nany, _фак_, vziu, _हेय_,
   {{0x9fa00629,0x76430172,0x00000000,0x00000000}},	//   _méér_, iany, --, --,
   {{0x76431a75,0xc10600e3,0x7bc401ff,0x00000000}},	//   hany, _توبي, tziu, --,
   {{0x76431a76,0xcb671a77,0xbebb023b,0x6d4700aa}},	// [1180] kany, мате_, rpër, asja,
   {{0x76431a78,0x0f5700ca,0xae220179,0xbebb0216}},	//   jany, _קיים_, _मलिन_, spër,
   {{0x76431a79,0x7e7c1a7a,0x673b1a7b,0x5e9b00ca}},	//   dany, merp, _awuj, _וביק,
   {{0x6d5c1a7c,0x673b0169,0x395a1a7d,0xbebb0216}},	//   mura, _bwuj, rups_, qpër,
   {{0x76431a7e,0x6d5c0706,0x628802e0,0xb9060971}},	//   fany, lura, yddo, _पद_,
   {{0x395a1a7f,0x76431a80,0x3ced042d,0x7c360727}},	//   pups_, gany, čeve_, lbyr,
   {{0x6d5c1a81,0xf9831a82,0x673b039f,0x7e7c02ac}},	//   nura, _игро, _ewuj, ierp,
   {{0x2ebb0714,0x7e7c1a83,0x7b0914f3,0x7643010a}},	//   _उत्त, herp, _užur, aany,
   {{0x76431a84,0x00000000,0x00000000,0x00000000}},	//   bany, --, --, --,
   {{0xd25000bf,0x7643023f,0xeb9100c1,0x7e7c0120}},	//   دند_, cany, אָט_, jerp,
   {{0x628802ad,0x7e7c1a85,0x20d20344,0xf1aa001c}},	//   rddo, derp, ršin_, زاده_,
   {{0x6d5c1a86,0x67201a87,0x04930037,0x9fa001cb}},	//   dura, _kumj, _للمح, _zéér_,
   {{0x6f170167,0xfc3f037a,0x60dd1a88,0x20d2007e}},	//   _pixc, _reí_, rnsm, pšin_,
   {{0x6d5c0010,0x7e7c1a89,0x62980364,0x6d471a8a}},	//   fura, gerp, _unvo, tsja,
   {{0xf1a202d5,0x9f9902ac,0x6d5501cb,0x00000000}},	//   _ओपिन, _dáár_, urza, --,
   {{0x76431a8b,0x6d471a8c,0x20c20037,0x7c361a8d}},	//   zany, rsja, _cóid_, gbyr,
   {{0x76431a8e,0x2d9e02e2,0x2d8c038c,0x6d471a8f}},	// [1190] yany, äter_, åder_, ssja,
   {{0x6d5c1a8e,0x9af500e3,0x32c00139,0xf38800fe}},	//   bura, ركات, _fòye_, _mợ_,
   {{0x76431a90,0x6d5c1a91,0x6b8d1a92,0xc98400d3}},	//   vany, cura, svag, куци,
   {{0x76431a93,0x2bd01a94,0xe0df0451,0x69c502db}},	//   wany, _सेवा, nnò_, rzhe,
   {{0x76431a95,0x7d0d1a96,0xf3880019,0xd62905da}},	//   tany, mmas, _nợ_, поле_,
   {{0x7d0d1a97,0xddde1a98,0x00000000,0x00000000}},	//   lmas, _hapš, --, --,
   {{0x76431a99,0x00000000,0x00000000,0x00000000}},	//   rany, --, --, --,
   {{0x7d0d1a9a,0x76431a9b,0xb3851a9c,0x9fa001cb}},	//   nmas, sany, елил, _wéér_,
   {{0x76431a9d,0x7d0d1a9e,0x3755001c,0x76751a9f}},	//   pany, imas, _سپاس, _плаф,
   {{0x130602fd,0x6d5c1aa0,0x7d0d1aa1,0x261902d5}},	//   нный_, yura, hmas, _पलटी_,
   {{0xd12e0159,0xe4a7002d,0x7d0d026a,0x6d5c01e9}},	//   یمی_, _ордо, kmas, xura,
   {{0x764100fb,0xf9920130,0x2ec81244,0x3cfb0034}},	//   _hely, ארט_, रफ्त, ्षों_,
   {{0xe8df00ac,0x42cd0081,0x6d5c1aa2,0x76410138}},	//   _abịa_, রকৌশ, wura, _kely,
   {{0x91e50e58,0x6d5c1aa3,0xe0df0036,0x7521010a}},	//   _поле, tura, anò_, _kulz,
   {{0x76411aa4,0xa3d302d5,0xc5f2006e,0x41b200d1}},	//   _mely, _हेत_, ָדן_, _ممور,
   {{0x7d0d1aa5,0x76411aa6,0x7af5010a,0x7f5d00fc}},	//   gmas, _lely, _akzt, busq,
   {{0x245a026a,0x75210052,0x6b8914f3,0x7c361aa7}},	// [11a0] lümü_, _lulz, _šegr, rbyr,
   {{0x6d5c1aa8,0x160f07d5,0xb05b160c,0x7d0d1aa9}},	//   pura, ाधार_, nhän, amas,
   {{0x8c460c28,0x6d5c13d7,0x245a03e0,0xcee91aaa}},	//   _пене, qura, nümü_, _ترين_,
   {{0x7eb0007a,0x22451aab,0x20d2042d,0x00000000}},	//   _täps, halk_, kšim_, --,
   {{0x20d20087,0xa2b4030b,0x2b49020a,0x22451aac}},	//   jšim_, ेसम्, csac_, kalk_,
   {{0x09bf0033,0x7641030a,0x0cc30033,0xf388020b}},	//   _আশরা, _cely, ্কৃত, _rợ_,
   {{0xf3880019,0xceb300ca,0x76410178,0x00000000}},	//   _sợ_, ריו_, _dely, --,
   {{0x752100e1,0xd3a61aad,0x69c100bc,0x67200350}},	//   _dulz, ероп, _ülea, _tumj,
   {{0x22450524,0xb05b042c,0x76411aae,0x00000000}},	//   falk_, fhän, _fely, --,
   {{0xf3880028,0x76411aaf,0x6aae02b6,0x7d0d071d}},	//   _vợ_, _gely, _jobf, zmas,
   {{0x1dcf0251,0x6d1f0378,0x7d0d1ab0,0x3ce0032e}},	//   _हेंत, _मूंग_, ymas, kniv_,
   {{0x254c00b6,0x7d0d00a7,0x6add1ab1,0x61f80e43}},	//   měl_, xmas, _मद्र, _vyvl,
   {{0xe29a1ab2,0xb05b01bf,0xe0df0451,0x22451ab3}},	//   _над_, bhän, rnò_, balk_,
   {{0x6442036b,0x245a0233,0xb60600d8,0x00000000}},	//   _heoi, bümü_, _etáž, --,
   {{0x7d0d1ab4,0x20c2033c,0x00000000,0x00000000}},	//   tmas, _dóib_, --, --,
   {{0xdc88002d,0xccf80291,0x628a0178,0x00000000}},	//   нсул_, ећу_, _hafo, --,
   {{0x7d0d06e1,0x628a1ab5,0xddde00c4,0x64421909}},	// [11b0] rmas, _kafo, _vapš, _meoi,
   {{0x64421ab6,0x00000000,0x00000000,0x00000000}},	//   _leoi, --, --, --,
   {{0x76411ab7,0xd99900e3,0x628a1ab8,0x7d0d1ab9}},	//   _rely, بنات_, _mafo, pmas,
   {{0x76411aba,0x6442036b,0x628a1abb,0x254c00b6}},	//   _sely, _neoi, _lafo, děl_,
   {{0x81bc01d3,0x245a020e,0x7eb01abc,0x752102db}},	//   ucēj, zümü_, _käpp, _sulz,
   {{0x75211abd,0x69d5009d,0x20d2042d,0xf6530068}},	//   _pulz, _येथी, všim_, ائش_,
   {{0x644200e3,0x764100c6,0x22451abe,0xb5c2004d}},	//   _beoi, _vely, valk_, ийшл,
   {{0xe7d21abf,0x64420037,0x7eb005f8,0x69cc0031}},	//   _देवप, _ceoi, _läpp, ôlež,
   {{0xe3b100e3,0x628a1ac0,0x13091aad,0x69d50096}},	//   شرة_, _bafo, мний_, _येती,
   {{0x628a0150,0x7eb0032c,0xb6060094,0x2ca91ac1}},	//   _cafo, _näpp, _stáž, hjad_,
   {{0x628a1ac2,0xb05b0e74,0x64421ac3,0x2258007f}},	//   _dafo, rhän, _feoi, órka_,
   {{0x64420cc2,0xe3b0110a,0xe5080037,0x20d20995}},	//   _geoi, _گرم_, _كيلو_, pšim_,
   {{0xb05b0222,0x2ca91ac4,0x22451ac5,0x999302c6}},	//   mhäl, djad_, palk_, čeře_,
   {{0x798200a5,0x628a0150,0x00000000,0x00000000}},	//   łowi, _gafo, --, --,
   {{0x20040220,0xbea307ed,0x8af000a7,0x20c2033c}},	//   ťmi_, шарк, frən, _cóic_,
   {{0x248d1ac6,0xa3e51073,0x1fb61ac7,0x1d071ac8}},	//   ndem_, _नशा_, _асор, веси_,
   {{0x2c070285,0x236d006c,0x248d04f8,0x628a04ff}},	// [11c0] _शरणं_, ntej_, idem_, _yafo,
   {{0x3ce0023e,0x63a60212,0xa2d40179,0x628a00ee}},	//   sniv_, äkni, योप्, _xafo,
   {{0xae5700ca,0xc96605b6,0x41c10285,0x00000000}},	//   _בסיס_, твей, शनिस, --,
   {{0x799500a5,0x38cb1ac9,0x290f0124,0x248d1aca}},	//   _drzw, وانی_, gmga_, jdem_,
   {{0x6d5a013f,0xf0930089,0xe7d20096,0x23d00034}},	//   štad, ינא_, _देशप, _तेंद,
   {{0x248d003d,0x254c00b6,0x64420076,0x7ccc013c}},	//   edem_, těl_, _seoi, rşru,
   {{0xe9a31acb,0x628a003e,0x64421acc,0xa01b01f9}},	//   _карп, _rafo, _peoi, ldöt,
   {{0xb86609b4,0x628a02ad,0x00000000,0x00000000}},	//   _جاسو, _safo, --, --,
   {{0x2c6d0018,0xaa82003e,0x69e7020a,0xd62a02a0}},	//   lódó_, _þýsk, ăreţ, _жозе_,
   {{0x68e21acd,0x00000000,0x00000000,0x00000000}},	//   lnod, --, --, --,
   {{0x9f4f0088,0x64421ace,0xe3af0281,0xc8b600aa}},	//   _ágú_, _teoi, مری_, _अकाट,
   {{0x9f351acf,0xe3ba032d,0x68e200f0,0x6b8402a4}},	//   лемі, _обе_, nnod, kwig,
   {{0x35a8000f,0x628a0178,0x2ca9033b,0x68e20072}},	//   _कपड़, _tafo, vjad_, inod,
   {{0x6b841ad0,0x7a4801d3,0x00000000,0x00000000}},	//   dwig, nūtē, --, --,
   {{0x1df81ad1,0x2ca900aa,0x51f3001c,0x20d209ac}},	//   веры_, tjad_, _پسور, kših_,
   {{0x20d202dd,0x2d1b0134,0xa3d609a1,0x2d9c00d8}},	//   jših_, _ụgbụ_, _सधा_, _švec_,
   {{0x68e20074,0x3a751ad2,0x2ca91ad3,0x7eb01ad4}},	// [11d0] dnod, ллар, rjad_, _täpp,
   {{0x5a341ad5,0x3f8900e7,0x68e2033c,0x248d1ad6}},	//   инут, _isau_, enod, zdem_,
   {{0x68e30fb6,0x68e202ad,0xceb2040a,0xe7030023}},	//   éndo, fnod, _היי_, _nướ,
   {{0x68e20178,0x6b840079,0x00000000,0x00000000}},	//   gnod, bwig, --, --,
   {{0xe9ff00de,0x20c2016d,0xdcb10023,0x27e91ad7}},	//   _trắc_, _jóia_, ểu_, çan_,
   {{0x7d1d0dea,0x7c2d1ad8,0xfbdf03a8,0xe70300fe}},	//   _hiss, lcar, _ddêt_, _bướ,
   {{0x68e21ad9,0xc9841ada,0x45191adb,0xb05b01bf}},	//   bnod, _кути, нция_, thäl,
   {{0x7c2d1adc,0x7d1d003d,0xdb1e0146,0xc48500ae}},	//   ncar, _jiss, _švéd, улик,
   {{0x7d1d1add,0x248d1ade,0xb05b160c,0x38930065}},	//   _miss, rdem_, rhäl, _e̟rú_,
   {{0x248d0479,0x236d1adf,0x27e00037,0x66150094}},	//   sdem_, rtej_, úine_, _úzko,
   {{0x291e025a,0x236d1ae0,0x3f8900eb,0x50460077}},	//   _état_, stej_, _asau_, ленб,
   {{0x7c2d1ae1,0xd5ba00c1,0x6b840313,0x20c20131}},	//   jcar, _אזעל, ywig, _bóia_,
   {{0xe28e1ae2,0x7c2d1ae3,0xb05b042c,0x00000000}},	//   _ла_, dcar, chäm, --,
   {{0x442d1ae4,0x7d1d1ae5,0x35d8009f,0x66f51ae6}},	//   lce_, _aiss, _भेड़, ेतिक_,
   {{0x62811ae7,0x7d1d1ae8,0x3f891ae9,0x68e20150}},	//   melo, _biss, _esau_, ynod,
   {{0x442d1aea,0x62811aeb,0x7d1d1aec,0x777b002b}},	//   nce_, lelo, _ciss, _opux,
   {{0x68e20995,0x60c41aed,0x20d2042d,0x442f1aee}},	// [11e0] vnod, _ilim, vših_, _mfg_,
   {{0xc3320054,0x62811aef,0x7bc001d4,0xdd040491}},	//   צוב_, nelo, _ümum, ırır,
   {{0x442d000d,0x2d9614d5,0x7d1d1af0,0x68e21af1}},	//   kce_, _српс, _fiss, tnod,
   {{0xdca61af2,0x7c2d1af3,0x68461491,0x442d1af4}},	//   _сами, ccar, унда, jce_,
   {{0x442d1af5,0x62811af6,0x6d4e1af7,0x60c40051}},	//   dce_, kelo, lsba, _mlim,
   {{0x56941af8,0x62811af9,0x6d5c1afa,0x60c41afb}},	//   ракт, jelo, orra, _llim,
   {{0x62811afc,0xf1a70037,0x6da501c2,0x7aeb01f9}},	//   delo, _اء_, lɗar, égte,
   {{0x442f1afd,0x6f1e00a5,0x6d4e0b77,0x6d5c026d}},	//   _cfg_, _lipc, isba, irra,
   {{0xb4e405cd,0x62811afe,0x6d5c01bf,0x8af000a7}},	//   _नदी_, felo, hrra, hrəm,
   {{0x62811aff,0x442d1b00,0x26c7030b,0x38660150}},	//   gelo, ace_, chno_, lgor_,
   {{0x60c41a3a,0x442d030b,0xb9090294,0x645d0143}},	//   _blim, bce_, _nchọ_, ósic,
   {{0x442d1b01,0x38661b02,0x2bef0081,0x6d5c0052}},	//   cce_, ngor_, চেয়ে_, drra,
   {{0xb90900ac,0xb4c00490,0x2d9e0ec9,0x6d5c1b03}},	//   _achọ_, ँसी_, åten_, erra,
   {{0x7d1d0006,0x62341b04,0x38660178,0x2f04003e}},	//   _siss, _теку, hgor_, sögn_,
   {{0x60c403e5,0x7c2d1b05,0x403503a0,0xd12f0fe9}},	//   _flim, tcar, _кейс, _ых_,
   {{0x60c41b06,0x3f89022e,0xd13816d7,0x3ced07c0}},	//   _glim, _tsau_, mpą_, čevo_,
   {{0x7d1d1b07,0x6d5c1b08,0x6d4e1b09,0xafdb02b6}},	// [11f0] _viss, arra, asba, dbøg,
   {{0x7d1d1b0a,0x442d1b0b,0x7c2d0fca,0xdea10d7f}},	//   _wiss, zce_, scar, _بیسی,
   {{0x7d1d1b0c,0x442d1b0d,0x60c400c2,0x7c2d1b0e}},	//   _tiss, yce_, _ylim, pcar,
   {{0x62811b0f,0x69c1007a,0x6d5a0095,0x60c4028d}},	//   zelo, _ülem, štac, _xlim,
   {{0x442d01d9,0x07a51b10,0x36690b22,0xa3d31b11}},	//   vce_, ралн, вало_, _हें_,
   {{0x38691b12,0x0555008f,0x442d0034,0x62811b13}},	//   żar_, атия, wce_, xelo,
   {{0x62811b14,0x442d045f,0x49930d83,0x3eb30090}},	//   velo, tce_, _دیار, _moxt_,
   {{0xed64025b,0x473518fa,0x442d1b15,0x62811b16}},	//   leží_, _внас, uce_, welo,
   {{0x628100ae,0x442d1b17,0xe730046b,0x64491b18}},	//   telo, rce_, _فصل_, raei,
   {{0x442d1b19,0x60c41b1a,0x27ff1b1b,0xd7f8002d}},	//   sce_, _slim, _iyun_, _сус_,
   {{0x62811b1c,0x442d0d95,0x60c41b1d,0x68e9004d}},	//   relo, pce_, _plim, _kjed,
   {{0x6281004c,0x65630161,0x272b052f,0x8af000a7}},	//   selo, munh, _køn_, stəx,
   {{0x7bcd1b1e,0x68e9023b,0x20c20076,0x5f0611db}},	//   jzau, _mjed, _fóin_, изма,
   {{0xed5a15de,0x6d4e1b1f,0x59b510e9,0x272b0537}},	//   ког_, tsba, ंहार, _møn_,
   {{0x68fb1b20,0x63bb1b21,0x272b0c08,0x6d5c1b22}},	//   _okud, lyun, _løn_, urra,
   {{0xdcfc03ce,0x27ff1b23,0x60c41b24,0x22470629}},	//   tvrđ, _oyun_, _ulim, _henk_,
   {{0x63bb1b25,0x63a91b26,0x26c503be,0x9c130294}},	// [1200] nyun, nxen, _ollo_, _fọma,
   {{0xc87901d4,0xed4614fa,0x63a91b27,0x68e90314}},	//   _abş_, _кноп, ixen, _ajed,
   {{0x27ff1b28,0x63bb0479,0x212700b3,0x290d00c4}},	//   _ayun_, hyun, _junh_, _bhea_,
   {{0x290d03be,0x26c5013d,0xe73a1b29,0x63bb1b2a}},	//   _chea_, _allo_, вед_, kyun,
   {{0x1634013d,0x68e90268,0x38661b2b,0x290d0503}},	//   беля, _djed, rgor_, _dhea_,
   {{0x68e91b2c,0x68fb019f,0x22470113,0xd707075f}},	//   _ejed, _ekud, _nenk_, анче_,
   {{0x65630933,0x09e30231,0x20d20031,0x27ff0065}},	//   gunh, _дорн, lšiu_, _eyun_,
   {{0x26c514e2,0x5fa6009d,0xd4971b2d,0xb4c0121d}},	//   _ello_, खमाल, арь_, ँसे_,
   {{0x63bb0018,0x63a90201,0x22471b2e,0x20d20206}},	//   gyun, gxen, _benk_, nšiu_,
   {{0x291f002d,0xb273055b,0x23bc0af0,0x9f4f020d}},	//   _ziua_, ольш, _aájú_, _âgé_,
   {{0x22471b2f,0x26dc1b30,0xfd530174,0x2ef801bf}},	//   _denk_, mivo_, _dofọ, dorf_,
   {{0x64a31b31,0x26dc1b32,0xddc500b6,0x63bb0079}},	//   _маха, livo_, _schů, byun,
   {{0x7528005c,0x76481b33,0x20d20220,0xdc2e0092}},	//   _hudz, _kedy, jšiu_, _sığo,
   {{0x764800a5,0x22471b34,0x24841b35,0x7b100364}},	//   _jedy, _genk_, lemm_, läuf,
   {{0xe3e80f71,0x75281b36,0x20000139,0xec6b016d}},	//   _পরিব, _judz, _eyii_, крак_,
   {{0x752802ef,0xc05b02ec,0x7bcd1b37,0x26dc1b38}},	//   _mudz, _рік_, tzau, hivo_,
   {{0x75280067,0x2bba0034,0x2d9a0381,0x7f44039f}},	// [1210] _ludz, jącą_, _erpe_, _gwiq,
   {{0x68e91b39,0x68fb1b3a,0x69c100aa,0x764800d1}},	//   _sjed, _skud, _ülek, _nedy,
   {{0x272b038c,0x2484003d,0xc8ab013d,0x63a4002b}},	//   _søn_, kemm_, къде_, _áinf,
   {{0xf77116cc,0x9c130174,0x00000000,0x00000000}},	//   كات_, _jọka, --, --,
   {{0x2bde1000,0x752800d9,0x68e900dd,0x76480178}},	//   _नेपा, _audz, _vjed, _bedy,
   {{0x65631b3b,0x75281b3c,0xdc3c02a1,0x20d2007e}},	//   tunh, _budz, _iġġo, lšit_,
   {{0x68e90292,0xa8a71b3d,0x785712eb,0x75281b3e}},	//   _tjed, _крак, _نیاز_, _cudz,
   {{0x68e903ce,0x65631b3f,0x224706a3,0x68fb0060}},	//   _ujed, runh, _senk_, _ukud,
   {{0x764800eb,0x00000000,0x00000000,0x00000000}},	//   _fedy, --, --, --,
   {{0x63a908a8,0x65631b40,0x26c503e3,0x68f91b41}},	//   rxen, punh, _ullo_, lowd,
   {{0x63bb1281,0x386d0357,0x95c81b42,0x2247022b}},	//   syun, _kcer_, _куца_, _venk_,
   {{0x297a0105,0x67211b43,0x397a00a1,0x60dd1b44}},	//   נטרא, _hilj, נטרנ, gism,
   {{0x443f1b45,0x6d450124,0x20050092,0x22471b46}},	//   mbu_, _awha, əlik_, _tenk_,
   {{0x443f1b47,0x6d4500f9,0x7d1801f9,0x6601007b}},	//   lbu_, _bwha, _évsz, _kylk,
   {{0xdca61b48,0x2d950ce5,0x01351b49,0x719600cd}},	//   бави, ортс, _اعتد, _هنوز_,
   {{0x443f1b4a,0x67211088,0x0c261b4b,0xfc260033}},	//   nbu_, _lilj, сман, বর্ষ_,
   {{0x443f1b4c,0x1d071b4d,0x63a41b4e,0x2d840094}},	// [1220] ibu_, сети_, _àint, ňme_,
   {{0x443f0090,0x2d9a1197,0x8e860037,0x9e661b4f}},	//   hbu_, _trpe_, _الده, _увод,
   {{0x499a1ad1,0x76481b50,0xef17002d,0x6d4503a8}},	//   ытая_, _redy, _ымь_, _gwha,
   {{0x443f0078,0x76481b51,0x75281b52,0x20d21a61}},	//   jbu_, _sedy, _rudz, pšiu_,
   {{0x7d041b53,0x75281b54,0x4b55008f,0xc053006e}},	//   mlis, _sudz, _мърт, לזא_,
   {{0x7d041b55,0xf1ca000d,0x60dd1b56,0x386d005c}},	//   llis, ानमन, zism, _ecer_,
   {{0x26dc1b57,0x67211b58,0x2d981b59,0x60dd1b5a}},	//   rivo_, _dilj, nvre_, yism,
   {{0x7d041b5b,0x60dd1b5c,0x76480150,0x2d9800fd}},	//   nlis, xism, _wedy, ivre_,
   {{0x47c600c9,0x7d041b5d,0x26dc1b5e,0xf7430a7c}},	//   _убав, ilis, pivo_, _нето,
   {{0x7d041b5f,0x660102ec,0x41541b60,0x60dd0167}},	//   hlis, _fylk, овос, wism,
   {{0x443f1b61,0x8afb00c1,0x63a41b62,0x8af000a7}},	//   bbu_, רהיי, _šind, msəd,
   {{0x7d041b63,0x00000000,0x00000000,0x00000000}},	//   jlis, --, --, --,
   {{0xe6c40102,0x44261b64,0x7d040181,0x9e4b002d}},	//   _þjóð, _igo_, dlis, ţămâ,
   {{0x7d160220,0xf1a6159a,0x60dd01ce,0x7d041b65}},	//   emys, _грин, sism, elis,
   {{0x6d5a00e9,0x7d041b66,0x91fc01d3,0xb6bb006e}},	//   štan, flis, zgāj, נצלי,
   {{0xd9041b67,0x7d041b68,0xa2d408c0,0x00000000}},	//   _سی_, glis, योर्, --,
   {{0x2d8c01c5,0x88bd0034,0x63a40072,0x4426020b}},	// [1230] æder_, _liśc, _áind, _mgo_,
   {{0x7d041b69,0x443f1b6a,0x2d98014b,0x61ff01f9}},	//   alis, zbu_, bvre_, _ízlé,
   {{0x7d041b6b,0x44261b6c,0x443f1b6d,0x6ab500de}},	//   blis, _ogo_, ybu_, _vozf,
   {{0x44261b6e,0x67211b6f,0x77991b70,0x20d20095}},	//   _ngo_, _silj, икер_, lšir_,
   {{0xd3661b71,0x67290890,0x443f025b,0xdbe30072}},	//   _ته_, _quej, vbu_, _téño,
   {{0x3ce900ae,0x91fc01d3,0xa3be0b3f,0xe80f0034}},	//   lnav_, rgāj, ीनन_, ़ेगा_,
   {{0x67211b72,0x442600f9,0x5fe002d5,0x0319001c}},	//   _vilj, _bgo_, _पेनल, یتخت_,
   {{0x4426033c,0x443f1b73,0x00000000,0x00000000}},	//   _cgo_, ubu_, --, --,
   {{0x443f1b74,0x7b1001bf,0xb05b0364,0x75220634}},	//   rbu_, bäud, nhäu, _dioz,
   {{0x44260857,0x66010d1b,0x443f1b75,0x7d161b76}},	//   _ego_, _tylk, sbu_, zmys,
   {{0x00861b77,0x7d041b78,0xd04f00a7,0x00000000}},	//   олно, ylis, licə, --,
   {{0x2eb41b79,0xc9520089,0x9c130134,0x7d0401ee}},	//   ुस्त, ומט_, _tọha, xlis,
   {{0xfc460181,0xbebb023b,0x7d040233,0x2d81039f}},	//   šíka_, jqës, vlis, _aphe_,
   {{0x61451b7a,0x7d041b7b,0x644b05bd,0x75220062}},	//   _дека, wlis, _hegi, _zioz,
   {{0x644b1b7c,0x7d040973,0xdddc09ac,0x2d980668}},	//   _kegi, tlis, ferš, uvre_,
   {{0x0ce80081,0xdca31543,0xb05b1531,0x7d041b7d}},	//   পত্ত, маси, lkän, ulis,
   {{0x7d041b7e,0xeb970084,0x644b1b7f,0x8b2600d6}},	// [1240] rlis, оит_, _megi, ідже,
   {{0xda6600e3,0x7d1602c6,0xda650037,0xb05b1b80}},	//   تاري, smys, كامي, nkän,
   {{0x7d041b81,0x645900a5,0x1d0a1b82,0xdddc1726}},	//   plis, _odwi, _вени_, berš,
   {{0xb17a006e,0xe8fa0b36,0xa8a30215,0xa17a006e}},	//   יטער, шле_, дршк, יטעט,
   {{0xb05b02c3,0x442600fc,0x00000000,0x00000000}},	//   phäv, _rgo_, --, --,
   {{0x8f9b1b83,0xe0df0451,0xd946007e,0xbf9b0142}},	//   ייני, ziò_, _меги, יינש,
   {{0x2bde06ec,0xb05b0149,0xe5a30284,0x91fc00e8}},	//   _नेता, dkän, дији, rgāk,
   {{0x644b1765,0x18671a19,0x8af0013c,0x00000000}},	//   _cegi, _маси_, ssəd, --,
   {{0x644b1b84,0xe0df0036,0xfd4e0294,0x00000000}},	//   _degi, viò_, takị, --,
   {{0x64591b85,0x3ce0007a,0x8af00092,0x64570022}},	//   _edwi, hiiv_, qsəd, _ɗaiɗ,
   {{0x27301b86,0x644b1b87,0x75220131,0x75d60076}},	//   _hàn_, _fegi, _tioz, _بيضا,
   {{0x6ab70bd9,0x44261b88,0xbebb023b,0x644b1b89}},	//   _आक्र, _ugo_, yqës, _gegi,
   {{0x6d5a0941,0x69c1007a,0x3ce9033b,0x290601ff}},	//   štal, _ülev, vnav_, iloa_,
   {{0x20050029,0x27300028,0xdefb0ab3,0x2bd5030b}},	//   āli_, _màn_, рым_, _ठेगा,
   {{0x27301b8a,0x62881b8b,0xc8bc152c,0x853c0138}},	//   _làn_, medo, ्घाट, _drėg,
   {{0x62881b8c,0x5ce70120,0x00000000,0x00000000}},	//   ledo, іюва, --, --,
   {{0x60c01b8d,0x27300023,0x3ce91b8e,0x00000000}},	// [1250] ömme, _nàn_, rnav_, --,
   {{0x62881b8f,0xb4c706eb,0x7f84015a,0x77621b90}},	//   nedo, _उत्_, _کلین, drox,
   {{0xdc3f025b,0xb05b02db,0x00000000,0x00000000}},	//   líčk, shäu, --, --,
   {{0xd04f01d4,0x27301b91,0x62880134,0x26f51b92}},	//   ticə, _bàn_, hedo, ेत्र_,
   {{0xf7451339,0xdc3f0579,0x6d550103,0x23d90104}},	//   чело, níčk, lsza, _बेंद,
   {{0x27301b93,0x644b1b94,0x62880fa3,0x6b8d1b95}},	//   _dàn_, _segi, jedo, mwag,
   {{0x62881b96,0x6b8d0ab2,0xb05b02c3,0x00000000}},	//   dedo, lwag, vkän, --,
   {{0x28f8004d,0x00000000,0x00000000,0x00000000}},	//   _десь_, --, --, --,
   {{0x6b8d1b97,0x644b003e,0xf41f0084,0xdc3f0146}},	//   nwag, _vegi, ää_, jíčk,
   {{0x62881b98,0x644b1b99,0x04fd0081,0x2cb9009c}},	//   gedo, _wegi, ুদের_, _losd_,
   {{0x644b1b9a,0x6b8d1b9b,0xb05b1531,0x68eb00fe}},	//   _tegi, hwag, rkän, ongd,
   {{0x6b8d1651,0xb05b02c3,0x69c109a1,0x00000000}},	//   kwag, skän, _üleu, --,
   {{0xa3d3009d,0x62881b9c,0xe2991b9d,0x20040088}},	//   _हेच_, bedo, _гал_, æmi_,
   {{0x6d5a077e,0x2cb901b9,0x62881b9e,0xb05b1b9f}},	//   štam, _aosd_, cedo, lkäl,
   {{0x2d9e0074,0x6da31b4d,0x7643005c,0x6d550018}},	//   íte_, нира, ibny, gsza,
   {{0xd7bd0096,0x2cb901b9,0xb05b16f9,0xdc3f0094}},	//   ्नाच, _cosd_, nkäl, bíčk,
   {{0x673b022e,0x6b8d1ba0,0xab660f5f,0x00000000}},	// [1260] _ntuj, gwag, явал, --,
   {{0x0e660084,0x3f921ba1,0xcff700ca,0x80aa0e1f}},	//   _экон, _isyu_, _מצפה_, टावे,
   {{0x27301ba2,0x3ebb00a1,0x98b00335,0xdebb00a1}},	//   _sàn_, _הציב, šači_, _המיל,
   {{0x77621ba3,0x6b8d1ba4,0xeb9f01df,0x186a1ba5}},	//   trox, bwag, _frø_, сади_,
   {{0xfc3f1ba6,0x65630364,0x47331ba7,0x6b8d05bd}},	//   _unía_, ernh, еніс, cwag,
   {{0x62881ba8,0x996400b6,0x2b401ba9,0x273000fe}},	//   xedo, může_, mpic_, _vàn_,
   {{0xb0cc0bf5,0x38a50174,0x673b007b,0xdc3f00d4}},	//   ासाग, ịram_, _etuj, zíčk,
   {{0x628802ad,0x27301baa,0x77621bab,0x6f020076}},	//   wedo, _tàn_, prox, _íocf,
   {{0x764301f9,0x6563009c,0x00000000,0x00000000}},	//   bbny, arnh, --, --,
   {{0xb6c80068,0x7afe1bac,0x68e21bad,0x86ea0037}},	//   _بارے_, nopt, liod, _اعرف_,
   {{0x6d5a00e9,0x6b8d1bae,0x69c100aa,0xe3af0421}},	//   štaj, zwag, _ület, نری_,
   {{0xeafa055e,0x68e21baf,0x2347001c,0xdc3f0094}},	//   ्तुत_, niod, _کلوپ_, tíčk,
   {{0x62881bb0,0x98a70106,0xa4b700ca,0x3eba00b3}},	//   pedo, šići_, _מלאה_, _bopt_,
   {{0x628800dd,0x6d551bb1,0x3eba00ae,0xddeb0076}},	//   qedo, tsza, _copt_, مرأه_,
   {{0xf29703c2,0x3ebe13da,0x200c00a7,0x6b8d1bb2}},	//   _זכור_, ötta_, ədim_, wwag,
   {{0x6d551bb3,0x6b8d1bb4,0xfbde009d,0x1cbb0037}},	//   rsza, twag, _नेहम, حاسب_,
   {{0x6d550068,0x68e21bb5,0xa3be00b7,0xaca30174}},	// [1270] ssza, diod, ीनि_, _nsụd,
   {{0x6b8d1bb6,0x60cd1bb7,0x88bd0034,0xb05b0364}},	//   rwag, _hlam, _ciśn, chär,
   {{0xc178013f,0x673b005c,0x2cb901b9,0xceb20142}},	//   ntė_, _stuj, _tosd_, _סיט_,
   {{0xa3be05d4,0xc178013f,0x2ee30126,0xec6b1bb8}},	//   ीना_, itė_, lijf_, _урок_,
   {{0x3a380169,0x60cd001c,0x66cf00f3,0x69d81bb9}},	//   _ffrp_, _mlam, _løke, úver,
   {{0x60cd1bba,0x25de000d,0x7afe1bbb,0x255700ae}},	//   _llam, _केही_, copt, tăl_,
   {{0xf650012b,0x68e20139,0x60cd026a,0xb05b00c2}},	//   ائه_, biod, _olam, tkäl,
   {{0x68e2002d,0x2ee301c0,0x387f0194,0x26cc1bbc}},	//   ciod, hijf_, _ubur_, _eldo_,
   {{0xc1780138,0x673b1bbd,0x78a91bbe,0x00000000}},	//   etė_, _utuj, _inev, --,
   {{0x78bb1bbf,0x69c1007a,0x66cf00d6,0x130600c2}},	//   _houv, _üles, _bøke, мный_,
   {{0x78bb1bc0,0x208a1bc1,0x60cd1bc2,0x78a901cb}},	//   _kouv, ойни_, _blam, _knev,
   {{0xafe602ec,0x15e31bc3,0xd00a001f,0x78bb1022}},	//   домл, _केयर_, жеме_, _jouv,
   {{0x78bb1bc4,0x60cd1bc5,0x92b50037,0x00000000}},	//   _mouv, _dlam, _يحتا, --,
   {{0x78bb1bc6,0x60cd1bc7,0xafdb0170,0x00000000}},	//   _louv, _elam, mbøl, --,
   {{0x60cd1bc8,0x9998007e,0x78a918ef,0x00000000}},	//   _flam, _serž_, _onev, --,
   {{0x78bb1bc9,0x7afe022b,0x68e2002b,0xb05b1bca}},	//   _nouv, wopt, xiod, shär,
   {{0xb05b01bf,0x3207030a,0xa2d40635,0x00000000}},	// [1280] phär, _hyny_, योक्, --,
   {{0x273b00ae,0x78a9078e,0x2b401a4a,0x00000000}},	//   _mână_, _anev, rpic_, --,
   {{0x2d9c0018,0xdce9026a,0x78bb1bcb,0x2b400141}},	//   _éve_, _çoğu, _bouv, spic_,
   {{0x78bb025a,0x5883055b,0x60cd0063,0x88bd007f}},	//   _couv, выша, _xlam, _wiśn,
   {{0x78bb02f1,0xd5af001c,0x711b006e,0xba56008f}},	//   _douv, یفه_, קונפ, _отвъ,
   {{0x68e21bcc,0xc1780138,0x78a91bcd,0x46a31bce}},	//   siod, ytė_, _enev, качв,
   {{0x06c20033,0xdddc00d4,0x26190d75,0x00000000}},	//   ্চলি, berť, येली_, --,
   {{0x78bb1bcf,0x6abc0088,0x23c90096,0x78a9049c}},	//   _gouv, _horf, िनंद, _gnev,
   {{0x66cf00d6,0x69c100bc,0x60cd01f7,0x00000000}},	//   _søke, _üler, _rlam, --,
   {{0x60cd1bd0,0xf7431bd1,0xf7d70089,0xc17a004d}},	//   _slam, _рефо, _חומש_, оїм_,
   {{0xa50a00d3,0xb05b17a5,0xa2d41bd2,0x00000000}},	//   _дежа_, skäm, योग्, --,
   {{0xc178013f,0x2249077e,0x30a70a01,0xd4c60037}},	//   rtė_, _đake_, фров, _تغطي,
   {{0x351b00c1,0xc178013f,0x60cd04e2,0x60c00212}},	//   _וואנ, stė_, _vlam, ömma,
   {{0x32070150,0x63a21bd3,0x213c0023,0x00000000}},	//   _fyny_, _iron, _ttvh_, --,
   {{0x63a21bd4,0x67281bd5,0x27fa00a5,0x2ee3029a}},	//   _hron, _midj, ępny_, rijf_,
   {{0x60cd1bd6,0x629a1bd7,0x6ee900cb,0x66080113}},	//   _ulam, ldto, džbe, _mydk,
   {{0x5b151bd8,0x63a200bf,0x62981bd9,0x6abc1bda}},	// [1290] емат, _jron, _kavo, _borf,
   {{0x78bb1bdb,0x6abc0150,0x29041bdc,0x672802ef}},	//   _souv, _corf, _akma_, _nidj,
   {{0x78bb1bdd,0x25de02e8,0x78a90087,0xae1b0034}},	//   _pouv, _केली_, _pnev, फेशन_,
   {{0x62980020,0x63a21bde,0x7d0903e5,0x20091bdf}},	//   _lavo, _oron, ċess, _kyai_,
   {{0x6abc1be0,0x21290063,0x672802f1,0x7f4d009e}},	//   _forf, _miah_, _bidj, _jwaq,
   {{0x6abc02ad,0x7f4d009e,0xda7e0206,0x2d87014b}},	//   _gorf, _mwaq, íďte_, _ânes_,
   {{0x63a21be1,0xd5b11b49,0x7f4d0372,0x2d910169}},	//   _aron, افع_, _lwaq, nwze_,
   {{0x273b002d,0x21290063,0x629a0ed0,0xe3b905cb}},	//   _până_, _niah_, edto, зби_,
   {{0x65930092,0x2009060f,0x03251be2,0xf7701a37}},	//   _məhə, _nyai_, ндин, _نال_,
   {{0x7dee0018,0x629800e5,0x3f4d1be3,0x672800bd}},	//   nősé, _cavo, džu_, _gidj,
   {{0x62981be4,0x69c50a1f,0x21290063,0x7f4d063d}},	//   _davo, nyhe, _biah_, _awaq,
   {{0x0ef80455,0xf9da00c1,0x629a1be5,0x6593013c}},	//   ंक्स_, פֿיל, adto, _nəhə,
   {{0x63a21be6,0x212902e7,0xafdb0537,0xe81700c3}},	//   _gron, _diah_, lbøj, _तरफा_,
   {{0x248d04de,0xe3b000d0,0x62981be7,0x6d42007e}},	//   leem_, _خرم_, _gavo, _čoab,
   {{0x57bd033a,0xdd921be8,0x7f4d039f,0x00000000}},	//   ्नुह, دوز_, _ewaq, --,
   {{0x248d0665,0x91fc01d3,0x659300a7,0xeafa00aa}},	//   neem_, rgāt, _cəhə, ्त्त_,
   {{0xc4d200c1,0x6abc1be9,0x2cab037a,0x62980027}},	// [12a0] אגן_, _porf, _dncd_, _yavo,
   {{0x248d006c,0x00000000,0x00000000,0x00000000}},	//   heem_, --, --, --,
   {{0xa84a0037,0x67280580,0x6abc1bea,0x2cab022b}},	//   كلام_, _ridj, _vorf, _fncd_,
   {{0x67281beb,0x00000000,0x00000000,0x00000000}},	//   _sidj, --, --, --,
   {{0x66e61bec,0x1c1c1bed,0x6abc1bee,0x248d1bef}},	//   нода, पेशल_, _torf, deem_,
   {{0x69c51bf0,0x659300a7,0x6d411bf1,0xb05b007b}},	//   byhe, _zəhə, ílag, tkäk,
   {{0x67281bf2,0x248d023e,0xa2c30d77,0x691102c3}},	//   _vidj, feem_, ाउन्, måen,
   {{0x62981bf3,0x67281bf4,0x692c020a,0x62831bf5}},	//   _savo, _widj, _eşec, _abno,
   {{0x62981bf6,0xe3b20190,0x60430294,0x21290f5a}},	//   _pavo, ارع_, ọmkw, _riah_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x2009005c,0x21290063,0x63a200ca,0x20c21bf7}},	//   _syai_, _piah_, _wron, _nóis_,
   {{0x63a2011b,0x3cfa0034,0x00000000,0x00000000}},	//   _tron, ंवों_, --, --,
   {{0x09dd0961,0xbfa81995,0x62981bf8,0xd8db00ca}},	//   _मध्य, нтре_, _tavo, לקטר,
   {{0x61eb0018,0x63ad031a,0xb3e90037,0x659300a7}},	//   állá, _šang, _تعمل_, _səhə,
   {{0xe29b00c1,0x7ae50117,0xe297125f,0x00000000}},	//   _זשור, viht, _чај_, --,
   {{0xb05b00c2,0x2f1602b6,0xfd1307e8,0x7f4d003d}},	//   kkäi, væge_, اجس_, _twaq,
   {{0x3a751bf9,0x7dee0068,0xe7e00ed3,0x2d9e0e3e}},	// [12b0] клар, tősé, _खेला_, åter_,
   {{0x69111bfa,0x63bd038c,0x257a0052,0x248d1bfb}},	//   gåen, øsni, kël_, zeem_,
   {{0x1df90084,0x7ae51bfc,0x291d0027,0xb05b00ce}},	//   _цены_, riht, tmwa_, tkäh,
   {{0xf7711a13,0xa90703ef,0x248d01fa,0x69c50313}},	//   لات_, ربان, xeem_, ryhe,
   {{0x7d0d1bfd,0x57bd00b6,0xadfc0034,0x257a0313}},	//   mlas, ्नेह, _एडऑन_, eël_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x6d5a03ce,0x257a00dd,0x1af41bfe,0x8aa4008f}},	//   štav, gël_, _спря, _сряд,
   {{0x7d0d1bff,0x262501c2,0xa3be00a4,0x00000000}},	//   nlas, rɓo_, ीनं_, --,
   {{0x3f890197,0x07351c00,0x248d1c01,0x8af000a7}},	//   _npau_, _резю, reem_, ksəl,
   {{0x7d0d0614,0x248d1c02,0xc3c800e3,0x257a0052}},	//   hlas, seem_, عظيم_, bël_,
   {{0x3de100c7,0xa06a1c03,0x7d0d1c04,0x860200cd}},	//   _মুসল, мана_, klas, _پژوه,
   {{0xa2a11c05,0x34950da5,0xf99200ca,0x00000000}},	//   _कोर्, _јадр, ברט_, --,
   {{0xe28e1c06,0x64491c07,0x7d0d1c08,0x2d8c003d}},	//   _ка_, mbei, dlas, ħdem_,
   {{0x64491c09,0xa3da1c0a,0x200c01d3,0x20c20037}},	//   lbei, _डेट_, ādi_, _cóir_,
   {{0xfc3f0031,0x64490062,0x443d1c0b,0x628101ab}},	//   _kníh_, obei, _kfw_, mflo,
   {{0x64491c0c,0x753c0018,0x443d0167,0x98b801d3}},	//   nbei, _érze, _jfw_, _otrā_,
   {{0x69111c0d,0x1d071c0e,0x442f0167,0x0c261c0f}},	// [12c0] tåen, тети_, _mgg_, тман,
   {{0x62810078,0x4a43135d,0x7d0d00aa,0x692c044c}},	//   nflo, инув, alas, _aşea,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xf7461312,0x2d3e00ac,0x442f0483,0x8af0013c}},	//   ведо, _ọgwụ_, _ngg_, msəm,
   {{0xd7ef0080,0x7d041c10,0x09290037,0xb8650018}},	//   يكم_, mois, رسمي_, طانو,
   {{0x7d041c11,0xa2a11c12,0x6d5a0181,0x442f0626}},	//   lois, _कोल्, štau, _agg_,
   {{0x6d5c03bd,0x1ae30c79,0xb05b00bc,0x09e61c13}},	//   nsra, _торм, skäi, _ровн,
   {{0x7d041c14,0x6d5c1c15,0x69c300c2,0x2249077e}},	//   nois, isra, änee, _đaka_,
   {{0x613e00d9,0x628107ee,0x62341c16,0x00000000}},	//   _mīle, fflo, лепу, --,
   {{0x02a61c17,0x7d0d1c18,0x7d041c19,0x442f1c1a}},	//   трим, zlas, hois, _egg_,
   {{0xf48400bf,0x7d0402fd,0xd48f1c1b,0x7d0d1c1c}},	//   _ماشی, kois, _кр_, ylas,
   {{0x6d5c1c1d,0x63ad007e,0x7d04007b,0x6ee90357}},	//   dsra, _šane, jois, džba,
   {{0x248603e3,0x7d041c1e,0xb4c00ded,0xfbdf02ac}},	//   _ibom_, dois, ुसी_, _leêr_,
   {{0x752b002b,0x76580010,0x69c10231,0x00000000}},	//   _zigz, navy, _àleg, --,
   {{0x2fcd00e9,0x7d0d1c1f,0x3cff1c20,0x6d5c0324}},	//   šeg_, tlas, लवले_, gsra,
   {{0x656a0037,0x48bd0081,0x8c3b0364,0x9d181c21}},	//   irfh, _আগ্র, _maßg, вост_,
   {{0x7d0d1c22,0xe7bd0081,0x20c200e3,0x5c07013d}},	// [12d0] rlas, _অধ্য, _tóir_, тява,
   {{0x7d0d1c23,0x76581c24,0xf09f015e,0x00000000}},	//   slas, javy, ldà_, --,
   {{0x7d0d1c25,0x7d041c26,0x6f0200e3,0x7658004b}},	//   plas, bois, _íoca, davy,
   {{0xf09f1c27,0x7d0d1a4a,0x48e10081,0x658a00a7}},	//   ndà_, qlas, যক্র, _məhd,
   {{0x973500d0,0x62811c28,0xfc3f0139,0xf0940142}},	//   اکرا, yflo, _ifí_, ינף_,
   {{0xfc3f02c6,0x00000000,0x00000000,0x00000000}},	//   _sníh_, --, --, --,
   {{0xceb4193b,0x940d00a7,0x24860131,0x00000000}},	//   ייס_, ənən_, _bbom_, --,
   {{0x26190e4c,0x3946007e,0x00000000,0x00000000}},	//   येगी_, ćost_, --, --,
   {{0x64491c29,0x27e000e3,0x57f51c2a,0x76580051}},	//   rbei, úint_, _спат, bavy,
   {{0x3ce901bb,0xf09f0428,0x64491c2b,0x7d04024a}},	//   hiav_, edà_, sbei, zois,
   {{0x62811c2c,0x7d040239,0xfad60327,0x693700c4}},	//   rflo, yois, רותך_, _oćem,
   {{0x6281003e,0x20c20037,0x27391c2d,0xe7b70096}},	//   sflo, _cóip_, _kèn_, _आपाप,
   {{0x7d041c1e,0x273906a3,0x6e290092,0xa2c302d5}},	//   vois, _jèn_, əmbə, ाउद्,
   {{0x249f1c2e,0xe29607c8,0x249d0197,0xfc3f00ee}},	//   ldum_, _баш_, _hawm_, _afí_,
   {{0xa0a6067f,0x7d040084,0x249d01bb,0x691102fe}},	//   _байд, tois, _kawm_, tåel,
   {{0x249f0102,0x7b1001bf,0x6d5c1c2f,0x72420018}},	//   ndum_, räum, rsra, _پھیل,
   {{0xcb671c30,0x237f1c31,0x8fa61c32,0x6d5c0116}},	// [12e0] лате_, ntuj_, _сапе, ssra,
   {{0xda650080,0x249d0d7d,0x8f9b00a1,0x6d5a08a8}},	//   لامي, _lawm_, _טיפי, átas,
   {{0x7d041c33,0xbebb0052,0x15e30285,0x00000000}},	//   pois, yqëz, _केलर_, --,
   {{0x249d023e,0x237f1799,0x27391c34,0x7658024a}},	//   _nawm_, ktuj_, _bèn_, wavy,
   {{0x76581c35,0x249f1c36,0x4b5500e5,0x00000000}},	//   tavy, ddum_, _въст, --,
   {{0xb8cb1c37,0x2ca0007a,0x3b0a0084,0x4e7a00c1}},	//   _को_, ldid_, _чего_, גאַצ,
   {{0x2ca000bc,0x45d40110,0xa2d700a4,0x76581c38}},	//   odid_, ройс, यसन्, ravy,
   {{0x2ca01c39,0x249d006c,0x76581c3a,0x2ed11c3b}},	//   ndid_, _cawm_, savy, _हत्त,
   {{0xc6760e25,0xe6461c3c,0x667600b1,0x249d01fa}},	//   _مطاب, _безп, _مدار, _dawm_,
   {{0x63ad025b,0x4b7b006e,0x5b7b006e,0x2d9a01c8}},	//   _šanc, עטיג, עריא, _ospe_,
   {{0x249d023e,0x7f441c3d,0xf0b51c3e,0xdb060216}},	//   _fawm_, _atiq, айнь, _arkë,
   {{0x249d023e,0x273900bf,0x2ca000dc,0x00000000}},	//   _gawm_, _yèn_, jdid_, --,
   {{0xf09f0472,0x2d9a0154,0x9f350120,0x2ca01c3f}},	//   rdà_, _aspe_, регі, ddid_,
   {{0x11d6003f,0x539b040a,0x249d023e,0x8c3b042c}},	//   _متعد, _ניוו, _zawm_, _maße,
   {{0x7f441c40,0x249d006c,0x02b10096,0x5637006e}},	//   _etiq, _yawm_, जारभ, ראלע_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x4a551a6d,0x6d471c41,0xba5500f6,0x2d9a0565}},	// [12f0] икас, spja, ивај, _espe_,
   {{0xb05b01bf,0x3ce9023e,0x27391c42,0x2ca000aa}},	//   rkäu, siav_, _rèn_, adid_,
   {{0x6d5a1c43,0x249f020e,0x273902f1,0x66cf0537}},	//   štar, ydum_, _sèn_, _søko,
   {{0x6d451c44,0x237f0034,0x5c0700e5,0x27391c45}},	//   _itha, ytuj_, _бяга, _pèn_,
   {{0x249d01fa,0xb05b00c2,0x0a6b1c46,0xa2d700b6}},	//   _rawm_, lkäs, _први_, यसम्,
   {{0x249d022e,0xb6a5037e,0xe7361c47,0x00000000}},	//   _sawm_, рикл, шеш_, --,
   {{0xa56400e3,0xb05b00c2,0x249f00a7,0xb9250076}},	//   مدين, nkäs, tdum_, _نفسي,
   {{0x386000e3,0xdb060113,0xe7950421,0x6d451c48}},	//   óirt_, _arkè, _پارک, _mtha,
   {{0x249f0587,0x6d450124,0x7d1d0113,0xb05b1c49}},	//   rdum_, _ltha, _mhss, hkäs,
   {{0x237f00a5,0x6d451c4a,0x68eb1c4b,0xdddc00c6}},	//   rtuj_, _otha, ligd, verž,
   {{0x249d01bb,0x6d4501fa,0x2a7600a1,0x25b90604}},	//   _tawm_, _ntha, בעתך_, _جهاد_,
   {{0x68eb0a9f,0x25de00b6,0x60261c4c,0xa01b09a8}},	//   nigd, _केटी_, идна, rfön,
   {{0x6d451c4d,0x60dd023b,0x443f1c4e,0x00000000}},	//   _atha, ërma, mcu_, --,
   {{0x443f1c4f,0x7d1d01b9,0x68eb0009,0x995402c6}},	//   lcu_, _ahss, higd, _rýže_,
   {{0xa01b0018,0x50460036,0xddc31c50,0x68eb0009}},	//   lföl, _кейб, обри, kigd,
   {{0x1c460204,0x6d4501b9,0x645b042c,0x00000000}},	//   рнам, _dtha, naui, --,
   {{0x6d451c51,0x6f07015c,0x68eb1c52,0x2ca0007a}},	// [1300] _etha, bojc, digd, rdid_,
   {{0x60c41c53,0x645b0231,0xc3320327,0xb05b09a1}},	//   _hoim, haui, קוב_, skät,
   {{0x2d9a1c54,0xf0aa0032,0x29060350,0x00000000}},	//   _uspe_, _gbàá_, tooa_, --,
   {{0x270e0a30,0xa9670293,0x200c0092,0xdca60c3f}},	//   ित्र_, рица_, ədir_, _тами,
   {{0x443f1c55,0x02b500c3,0x3f8200d4,0x613e00e8}},	//   dcu_, _अचंभ, ntku_, _mīla,
   {{0x658a01d4,0x236d1c56,0x66d40139,0x3f8200dc}},	//   _rəhb, drej_, _bàka, itku_,
   {{0x6d4501b9,0x29060350,0x00000000,0x00000000}},	//   _xtha, pooa_, --, --,
   {{0x399b0105,0x798e0113,0x386400ae,0x63ad1c57}},	//   _בילד, _ipbw, _udmr_, _šana,
   {{0xf7431c58,0xdb0603a9,0x236d1c59,0x764100eb}},	//   _мето, _arké, grej_, _ffly,
   {{0x78a21c5a,0xdce7007f,0x443f1206,0xb05b007b}},	//   ldov, mują, acu_, ykäs,
   {{0x3a370054,0x6f070039,0x60c41c5b,0x443f0a32}},	//   ירים_, vojc, _boim, bcu_,
   {{0x60c40a21,0x69de01e9,0x236d1c5c,0x60d60178}},	//   _coim, izpe, brej_, _clym,
   {{0x77f41926,0x60c41c5d,0x6d450090,0xdce70034}},	//   _अशोक_, _doim, _stha, nują,
   {{0x0eeb00a9,0x28dd00aa,0xb05b007b,0x6ee900d4}},	//   тьми_, _मतभि, tkäs, ržbo,
   {{0x3f821c5e,0xeda400d6,0xd2f80018,0xdef801b3}},	//   atku_, ошто, _لکھا_, рыя_,
   {{0xdce700a5,0x78a21c5f,0x60d61c60,0xb05b1c61}},	//   kują, jdov, _glym, rkäs,
   {{0x78a20451,0xab38110c,0x68eb1c62,0x69de01ff}},	// [1310] ddov, ипту_, vigd, ezpe,
   {{0x6e950080,0x443f1c63,0xdce70034,0x00000000}},	//   _الدا, zcu_, dują, --,
   {{0x6d450060,0x68eb1030,0x2b49020d,0x78a01c64}},	//   _utha, tigd, spac_, _bamv,
   {{0xa3c71c65,0x271f00df,0xcd3405bc,0x00000000}},	//   _उथल_, यग्र_, _گریب, --,
   {{0x443f0335,0x2d830126,0x07a51c66,0xdce7007f}},	//   vcu_, ltje_, салн, gują,
   {{0x6b9d002b,0x98bc01d3,0x2d83029a,0x3ea11c67}},	//   _issg, īvā_, otje_, _jaht_,
   {{0x2d831c68,0x443f1c69,0x645b0b6a,0x3ea100bc}},	//   ntje_, tcu_, taui, _maht_,
   {{0xfdf800a1,0x66cf01c5,0x2d83029a,0x9479018a}},	//   ימוש_, _køkk, itje_, уску_,
   {{0x60c4006b,0x68e91c6a,0x443f1c6b,0xe3e900cd}},	//   _roim, _imed, rcu_, دکان_,
   {{0x443f0012,0x236d1c6c,0xa01b1c6d,0x60d61849}},	//   scu_, rrej_, rföl, _slym,
   {{0x66cf01c5,0x60d61c6e,0x2d831c6f,0x60c41c70}},	//   _løkk, _plym, jtje_, _poim,
   {{0x236d02dd,0xfd1f0023,0xa01b0212,0x2d830381}},	//   prej_, _nhì_, pföl, dtje_,
   {{0x60c40084,0x66cf00d6,0x6f1e0072,0x2d83029a}},	//   _voim, _nøkk, _phpc, etje_,
   {{0x78a21b32,0x291f023e,0x3f821c71,0x64591c72}},	//   zdov, _lhua_, rtku_, _hewi,
   {{0x60c41c73,0x64590da3,0x3f821c74,0x68e90212}},	//   _toim, _kewi, stku_, _omed,
   {{0xeb9a0565,0x26c51c75,0xb05b097b,0xcd2a1c76}},	//   либ_, _lolo_, skär, ужбе_,
   {{0x63bb0933,0x2d830126,0x2120028d,0xfc3f0575}},	// [1320] nxun, atje_, _ihih_, _anís_,
   {{0x68fb1c77,0x64591c78,0xf412193b,0x78a004c8}},	//   _ajud, _lewi, לפן_, _samv,
   {{0x68fb0149,0x27220019,0xdb041c79,0xfe9b00ca}},	//   _bjud, _hưng_, nvié, _גיימ,
   {{0x645902ad,0x291f1c7a,0xd7fa0a29,0xdce7007f}},	//   _newi, _chua_, лул_, tują,
   {{0x26c50038,0x96ea1068,0x68fb03a9,0x00000000}},	//   _bolo_, лька_, _djud, --,
   {{0xdce70034,0x68fb1c7b,0x8f9b0289,0x96f80161}},	//   rują, _ejud, טיני, јект_,
   {{0x6b841c7c,0x64591c7d,0x27220019,0xdce70034}},	//   ltig, _bewi, _lưng_, sują,
   {{0x63ab0085,0xdce70034,0xd4971b2d,0x26c50036}},	//   _brgn, pują, брь_, _eolo_,
   {{0x68e300dd,0xd2500080,0x645902ad,0xdddd007f}},	//   ënde, ونة_, _dewi, _łyże,
   {{0x6b841c7e,0x68e9033b,0x63ab1c7f,0x00000000}},	//   itig, _zmed, _drgn, --,
   {{0x201201c2,0x6b841c80,0xd9fa00b6,0xd3d700d1}},	//   _ayyi_, htig, ्थित_, لبیا_,
   {{0x64591c81,0x6b841c82,0x2ed109c3,0x63bb002b}},	//   _gewi, ktig, हस्त, bxun,
   {{0xdfd8013d,0x765a023b,0x272200de,0x6b840381}},	//   бър_, _kety, _cưng_, jtig,
   {{0xd9fa1c83,0x27220023,0x66cf01ce,0x8c000033}},	//   ्थात_, _dưng_, _røkk, ্ধান_,
   {{0x765a1c84,0x6b8404e2,0x69180487,0xfd1f0023}},	//   _mety, etig, víen, _phì_,
   {{0x2d830ab2,0x628801d0,0x753a0027,0xd05d00a7}},	//   rtje_, lfdo, _mutz, yisə,
   {{0x6b841c85,0x2d831c86,0x3ea11c87,0x753a1c88}},	// [1330] gtig, stje_, _taht_, _lutz,
   {{0x68e91c89,0x765a1c8a,0xf41a0033,0x433b006e}},	//   _smed, _nety, _ডলার_, טעמב,
   {{0xfd1f00ef,0x753a02dc,0x6b841c8b,0x291f01fa}},	//   _thì_, _nutz, atig, _phua_,
   {{0x26c51c8c,0x291f006c,0x481515e5,0xa3b800b6}},	//   _solo_, _qhua_, омес, ङमा_,
   {{0x660407d1,0x765a0d3e,0x6c7a00c1,0x26c51c8d}},	//   şikl, _bety, _דארפ, _polo_,
   {{0x26c50188,0x35c9022f,0x321c00d8,0x64591c8e}},	//   _qolo_, игло_, _ozvy_, _sewi,
   {{0x765a01e5,0x26c51c8f,0x291f1c90,0xd05d0092}},	//   _dety, _volo_, _thua_, sisə,
   {{0x93451c91,0xf9920796,0x68e91c92,0x68fb1c93}},	//   оние, _קרן_, _umed, _ujud,
   {{0xdcfc00d9,0x03a51c94,0x76b900d3,0x26c51c95}},	//   ntrā, ципо, _клар_, _tolo_,
   {{0xdddc0018,0x21201c96,0x765a01d0,0x272200fe}},	//   zerű, _shih_, _gety, _rưng_,
   {{0x27220023,0x63bb0072,0x00000000,0x00000000}},	//   _sưng_, sxun, --, --,
   {{0x297a00c1,0x79850150,0x7b100364,0x673b0a4b}},	//   סטרא, ithw, läut, _kuuj,
   {{0xa3bb110a,0x9405001c,0x63ab0036,0x79500154}},	//   _حاضر_, _بوشه, _urgn, _kòwò,
   {{0x673b008a,0x63a91c97,0x161d178d,0x217500ae}},	//   _muuj, mven, _फरार_, _дуир,
   {{0x63a91c98,0x6da31c99,0xed5a0e2f,0x00000000}},	//   lven, мира, роб_, --,
   {{0x63a91c9a,0x161e00c3,0x272200de,0xb4c702d5}},	//   oven, येटर_, _tưng_, _ईको_,
   {{0x0aea1c9b,0xab6600d6,0x6b841c9c,0x63a41c9d}},	// [1340] адай_, ювал, utig, _áint,
   {{0x6b841c9e,0x63a91c9f,0xaca40065,0x00000000}},	//   rtig, iven, _idọt, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x765a1ca0,0xac760018,0x6d4e13ea,0x274a0c37}},	//   _sety, _بادش, mpba, ачко_,
   {{0x765a1ca1,0x63a90126,0x6b84008a,0x7cf3003d}},	//   _pety, jven, qtig, għru,
   {{0x63a91ca2,0x645d0088,0x356a1a67,0x2d8505fe}},	//   dven, ðsin, арин_, àleg_,
   {{0xd54700c9,0xa9671ca3,0xe6da0251,0x63a91ca4}},	//   опје_, _мира_, _भतीज, even,
   {{0x387f0037,0x7d1600f2,0x94aa05af,0xf3661ca5}},	//   _gcur_, nlys, ртка_, отон,
   {{0xaca40134,0xdb0400b3,0x63a91ca6,0x00000000}},	//   _ndọt, nviï, gven, --,
   {{0x63a41ca7,0x7d1600f0,0x6f020076,0xd56400d3}},	//   _šins, hlys, _íoch, _еӂип,
   {{0xaca40294,0xdb040072,0x7d161ca8,0x6d4e01cb}},	//   _adọt, nxiñ, klys, jpba,
   {{0x63a91162,0x4035022a,0x00000000,0x00000000}},	//   bven, яемс, --, --,
   {{0x63a9002d,0x4ea71ca9,0x75220079,0x66cf00f3}},	//   cven, орва, _ihoz, _søki,
   {{0xe2971caa,0xe7f200c3,0x7d1616cf,0x00000000}},	//   _мач_, _आइना_, elys, --,
   {{0x78170bd9,0x7b1001bf,0xddc50233,0x75221c48}},	//   _तर्क_, häus, _dehş, _khoz,
   {{0xd5a407d9,0xdcee01d3,0x69c300aa,0x63a40072}},	//   _یہ_, tubā, änem, _áins,
   {{0x28ab152c,0x6d4e1cab,0x00000000,0x00000000}},	// [1350] _घोषि, apba, --, --,
   {{0x7e990018,0x387f1cac,0x395803a8,0x00000000}},	//   _اندر_, _scur_, _bwrs_, --,
   {{0xdcfc0029,0x39580150,0x0e9a00ca,0x658a00a7}},	//   strā, _cwrs_, _השתל, _səhn,
   {{0x236603ce,0x79851cad,0x6ee91cae,0x63a91caf}},	//   _ovoj_, rthw, džbi, yven,
   {{0x7d0d002d,0xba7700e3,0x66dd1cb0,0xf68000d2}},	//   moas, _واست, _lèke, ěžně_,
   {{0x7d0d1cb1,0x60dd023b,0x63a91cb2,0x752201e9}},	//   loas, ërmj, vven, _ahoz,
   {{0x39580150,0x00000000,0x00000000,0x00000000}},	//   _gwrs_, --, --, --,
   {{0x7d0d16fa,0x2ec81117,0xb4d500bc,0x75221cb3}},	//   noas, _रक्त, हसे_, _choz,
   {{0x63a90257,0xf3f900ae,0x225c05db,0x7d0d044c}},	//   uven, faţa_, _bevk_, ioas,
   {{0x67211cb4,0x225c05db,0x23660e4b,0x2b4b020b}},	//   _uhlj, _cevk_, _dvoj_, _mtcc_,
   {{0xa0a6007e,0x66dd0113,0x7d0d007b,0x00000000}},	//   панд, _cèke, koas, --,
   {{0x21060a30,0x75221cb5,0x2b4b0124,0x7d0d00ae}},	//   रवेश_, _ghoz, _otcc_, joas,
   {{0x087600c1,0xe45600c1,0xdfd20190,0x2d9c002b}},	//   הערט_, _זינט_, ريس_, _ávez_,
   {{0x75291cb6,0x00000000,0x00000000,0x00000000}},	//   lmez, --, --, --,
   {{0x2cf917ff,0x7d0d020a,0x412a00e5,0x7d1601ce}},	//   ्कूल_, foas, _локо_, tlys,
   {{0x0b460467,0x201e01d4,0x2b5902a1,0x225c0233}},	//   знан, ətin_, _bwsc_, _zevk_,
   {{0x7d160429,0xfc030360,0x2b5903a8,0x00000000}},	// [1360] rlys, епто, _cwsc_, --,
   {{0x7d161cb7,0x6d4e0aab,0xdb0401ff,0x00000000}},	//   slys, ppba, txiñ, --,
   {{0x7d160f3c,0x2d930072,0xbe3b00ca,0xdb040072}},	//   plys, _gpxe_, _לעית, uxiñ,
   {{0x7d0d1cb8,0x6f0e0094,0x684311c0,0xc18c006e}},	//   coas, lobc, енца, שטאָ,
   {{0xdc370130,0x68e31cb9,0x00000000,0x00000000}},	//   _מאכט_, ënda, --, --,
   {{0x7b100364,0x66e3097a,0x658a013c,0x75221cba}},	//   räus, ноча, _fəhl, _shoz,
   {{0x23660c0b,0x8af00092,0xceb300ca,0x39e700e5}},	//   _svoj_, ssəs, תיו_, _едро_,
   {{0x68130034,0x63610134,0x18a30219,0x225c0233}},	//   _będą, _ịnar, _пасм, _sevk_,
   {{0x6f0e01c2,0x66dd03a9,0x225c05db,0x20050233}},	//   kobc, _sèke, _pevk_, ğlik_,
   {{0xfc3f0072,0x2005020e,0x66dd0113,0xe5a61cbb}},	//   _maía_, şlik_, _pèke, _низи,
   {{0x741601f3,0xb4e20174,0x7d0d024a,0x00000000}},	//   _کوشا, áàsh, yoas, --,
   {{0x23661cbc,0x693703c6,0x09f700ca,0x55bb00ca}},	//   _tvoj_, _kćer, למים_, _למבו,
   {{0xa3cd13ae,0x7d0d1cbd,0xdfd800e5,0xbff803a0}},	//   रहण_, voas, пър_, зеях_,
   {{0x63a21cbe,0xdefb0450,0x9f4e01ab,0x00000000}},	//   _ison, сым_, ðnám_, --,
   {{0x7d0d1cbf,0x629a1cc0,0xbbc50213,0x00000000}},	//   toas, meto, लङ्क, --,
   {{0x7aee01c0,0xc8ab009f,0xfc3f0558,0x51fb00ca}},	//   _ambt, _घोंट, _baía_, _להוצ,
   {{0x7d0d002d,0xfc3f0165,0x3f9d01dc,0x00000000}},	// [1370] roas, _caía_, _èwu_, --,
   {{0x7f4d1cc1,0x63a20239,0x752902c6,0x7d0d1cc2}},	//   _itaq, _mson, zmez, soas,
   {{0x63a20085,0x7d0d1cc3,0x75290216,0x69da09a1}},	//   _lson, poas, ymez, _ütel,
   {{0x3ce01cc4,0x63a21cc5,0x629a1cc6,0x00000000}},	//   chiv_, _oson, heto, --,
   {{0x6d4a00dd,0xdcfc00d3,0x63a21cc7,0xd3661cc8}},	//   _çfar, stră, _nson, _جه_,
   {{0x629a1cc9,0x658a01d4,0x2ca91cca,0x7b10042c}},	//   jeto, _təhl, ldad_, säur,
   {{0x63a21ccb,0x7f4d009e,0x75290233,0x20ef02c6}},	//   _ason, _ltaq, tmez, třil_,
   {{0x2ca91ccc,0x7f4d0092,0xddde0154,0x00000000}},	//   ndad_, _otaq, _depň, --,
   {{0x290f06ee,0x752903e5,0xb05b0222,0x2ca90487}},	//   moga_, rmez, tjän, idad_,
   {{0x2bdf030b,0x658a00a7,0xe3ca037a,0x69c80231}},	//   पैया, _zəhm, _soñó_, _àdec,
   {{0x7f4d0b0b,0x63a21ccd,0x2ca901c2,0x93ca0103}},	//   _ataq, _eson, kdad_, مایہ_,
   {{0x290f1cce,0x386d0113,0xb40e0174,0x6aa705db}},	//   noga_, _jder_, ịpịa_, _lajf,
   {{0x2ca91ccf,0xb9150139,0x290f00b3,0x03a500d3}},	//   ddad_, _bibẹ_, ioga_, _цило,
   {{0x2ca9037a,0x629a1cd0,0x290f1cd1,0x853c0138}},	//   edad_, ceto, hoga_, _grės,
   {{0x386d02d6,0x6f0e0074,0x290f0106,0x3ce0023e}},	//   _oder_, robc, koga_, thiv_,
   {{0x386d023b,0x7f4d0090,0x290f01c2,0xb05b007b}},	//   _nder_, _ftaq, joga_, njäl,
   {{0x6aa7007e,0x394d033b,0x658a00a7,0xdb0600d4}},	// [1380] _bajf, _česa_, _rəhm, _arká,
   {{0x386d00dc,0x63a61cd2,0x7d09033b,0xb05b173a}},	//   _ader_, ækni, česa, hjäl,
   {{0xe820007d,0x88860848,0x290f1cd3,0x6283037a}},	//   _बरहा_, длеж, foga_, _mcno,
   {{0xa3bf009f,0xa3cd1cd4,0x61ee0072,0xddde022b}},	//   ीहा_, रहा_, úbli, _repň,
   {{0x8cdb0789,0x629a1cd5,0x60dd0052,0x98a402c6}},	//   नसरो, yeto, ërmi, _zimě_,
   {{0x386d1cd6,0x473300d6,0x629a0072,0xb5fc02a1}},	//   _eder_, вніс, xeto, _leġe,
   {{0xe820007d,0x290f1cd7,0x69d8181f,0x63a206b0}},	//   _बरवा_, boga_, øved, _sson,
   {{0x629a1cd8,0x3eba0063,0x66cf0120,0x290f0027}},	//   weto, _lnpt_, _søkt, coga_,
   {{0xd90d172a,0x629a1cd9,0xa6861cda,0x22490233}},	//   _این_, teto, _олад, _şaka_,
   {{0xb6cb00fb,0x68e200d4,0xd62a1cdb,0x00000000}},	//   _والے_, lhod, _дозе_, --,
   {{0x629a1cdc,0x658a01d4,0xe3af001c,0xfa7700ca}},	//   reto, _məhk, هری_, ועית_,
   {{0x75490018,0x386d00dc,0x68e20131,0x3d08007f}},	//   őszö, _xder_, nhod, वकों_,
   {{0x27e6006d,0x63a21cdd,0x9f590649,0x26cc1cde}},	//   nzon_, _uson, ìyàn_, _kodo_,
   {{0xe1ef11a2,0x7ce30006,0x3eba0072,0x2cb91cdf}},	//   اسی_, _kõrg, _cnpt_, _snsd_,
   {{0x9f3402ec,0xdc3a0b88,0xc32700e3,0x290f1ce0}},	//   тері, _açık, _تكون_, yoga_,
   {{0x26cc0032,0xe7ab0220,0x66dd0113,0x68e200d4}},	//   _lodo_, _ďaľš, _mèka, jhod,
   {{0x2ca91ce1,0x68e203f1,0x290f0880,0x7f4d01ee}},	// [1390] rdad_, dhod, voga_, _utaq,
   {{0x26cc1ce2,0xcf270190,0x60cd020b,0x00000000}},	//   _nodo_, _تربي, _hoam, --,
   {{0x290f1ce3,0x2ca900f9,0x7ce300aa,0xb05b007b}},	//   toga_, pdad_, _nõrg, yjäl,
   {{0xf8690037,0x2fe4026a,0x00000000,0x00000000}},	//   سمتي_, _örgü_, --, --,
   {{0x26cc0b27,0x6aa71ce4,0x60cd1ce5,0xf7f401f3}},	//   _bodo_, _tajf, _moam, پسند,
   {{0x290f1ce6,0x26cc0328,0x6f020076,0xdb0602b6}},	//   soga_, _codo_, _íoct, _arkæ,
   {{0x26cc1ce7,0x04451ce8,0x68e2019f,0x6283022b}},	//   _dodo_, нейн, bhod, _rcno,
   {{0x68e21643,0x27e6026a,0x2f16003e,0xce381777}},	//   chod, bzon_, lægt_, ואות_,
   {{0xe3b10c5e,0x248d0559,0x7d03002b,0x5884004b}},	//   ارب_, rfem_, _ínsu, _шыра,
   {{0x26cc1ce9,0xb05b1cea,0x248d09c2,0x56270103}},	//   _godo_, själ, sfem_, _قرآ,
   {{0x78a900aa,0xcb120327,0x67380206,0x80a90a43}},	//   _kaev, רלי_, žajú, গান্,
   {{0x26c702e6,0x98b800d9,0xfc3f002b,0x6adc00d2}},	//   ljno_, _kurā_, _saín_, _यत्र,
   {{0x952200fb,0x60cd002d,0xb05b00c2,0x26cc1ceb}},	//   _حکوم, _doam, nkäy, _yodo_,
   {{0x68e20871,0x78a91cec,0xd36e1ced,0x00000000}},	//   zhod, _laev, _اهو_, --,
   {{0x7d0908a9,0x60cd1cee,0x3eba0023,0x27e60103}},	//   česn, _foam, _vnpt_, zzon_,
   {{0xdca31cef,0x76930511,0x64491cf0,0x62811cf1}},	//   ласи, lıyı, ncei, lglo,
   {{0xac071cf2,0x68e21cf3,0xeb970205,0x683601e8}},	// [13a0] ента_, vhod, нит_, _müdü,
   {{0x62811cf4,0x4e1100b6,0x76930555,0x09e602f3}},	//   nglo, _दुवै_, nıyı, нозн,
   {{0xae5b0054,0xd9100068,0x68e21cf5,0x26cc1cf6}},	//   _מכיר, لیس_, thod, _rodo_,
   {{0x38600080,0xa01b0222,0x26cc1cf7,0x443d1cf8}},	//   úir_, mför, _sodo_, _ngw_,
   {{0x26cc1cf9,0xa01b0149,0xfd650134,0x68e20563}},	//   _podo_, lför, kasị, rhod,
   {{0x27e61cfa,0x644b052f,0x56941cfb,0x7ce300bc}},	//   rzon_, _afgi, такт, _põrg,
   {{0x68e20c27,0x26cc02dd,0xa01b1cfc,0xb9060033}},	//   phod, _vodo_, nför, _পদ_,
   {{0x7ce300aa,0x69340e27,0x7cfb007b,0x6281004b}},	//   _võrg, _شکار, märä, eglo,
   {{0x26cc0d9f,0x29041cfd,0x7bd601c2,0x00000000}},	//   _todo_, _ijma_, nyyu, --,
   {{0x60cd11ca,0x026a0084,0xa01b0149,0x443d010a}},	//   _soam, чший_, kför, _egw_,
   {{0xb5fc02a1,0x00000000,0x00000000,0x00000000}},	//   _weġb, --, --, --,
   {{0x73e61cfe,0xa01b0149,0xfbe0009f,0x6449015e}},	//   _поез, dför, फनाम, ccei,
   {{0x6d5e0139,0xddcc00b6,0x4e161cff,0xb4dc0096}},	//   _awpa, _čišt, _दुबई_, डसी_,
   {{0x661a1d00,0x673a00bd,0x00000000,0x00000000}},	//   _kytk, _jitj, --, --,
   {{0xdd94004b,0x673a0990,0x60cd002d,0xa01b0212}},	//   лары, _mitj, _toam, gför,
   {{0x51830f97,0x673a039f,0x00000000,0x00000000}},	//   _суша, _litj, --, --,
   {{0x2f1602b6,0x317e01c2,0xb05b007b,0x00000000}},	// [13b0] tægt_, lutz_, hjäk, --,
   {{0xff500037,0x78a900b7,0x673a1d01,0x00000000}},	//   _اخي_, _saev, _nitj, --,
   {{0x317e1d02,0x661a007b,0x78a91d03,0x6d5e00eb}},	//   nutz_, _nytk, _paev, _gwpa,
   {{0x6ee20220,0x00000000,0x00000000,0x00000000}},	//   _vôbe, --, --, --,
   {{0x07a50cd7,0x317e01bf,0x7ce3007a,0x78a900aa}},	//   талн, hutz_, _võrd, _vaev,
   {{0xcf9400c1,0x7e6704e9,0x6b8d1d04,0x212903a9}},	//   רטס_, najp, mtag, _lhah_,
   {{0x6b8d04f6,0xceb4040a,0x24861d05,0x673a1d06}},	//   ltag, טיס_, _bcom_, _ditj,
   {{0xdb060704,0x62811d07,0x248601b9,0x673a029a}},	//   _erkä, wglo, _ccom_, _eitj,
   {{0x6b8d120f,0x4794110a,0x644917c8,0x47351d08}},	//   ntag, _مجلس, rcei, _анас,
   {{0x64491d09,0xd90d0103,0x6b8d1d0a,0x57f41d0b}},	//   scei, _ایچ_, itag, _спут,
   {{0x05740100,0x69c50052,0xc0e6022a,0x76930345}},	//   _ماند, nxhe, вонк, rıyı,
   {{0x63ad0b14,0xa01b0212,0x6b8d1d0c,0x6281030a}},	//   _šanu, vför, ktag, sglo,
   {{0xa85600a1,0x66040587,0x332701cb,0x21291d0d}},	//   כירה_, şikt, _thnx_, _dhah_,
   {{0xe1f10979,0x6b8d1d0e,0x658a01d4,0x249f1a85}},	//   _پست_, dtag, _səhi, leum_,
   {{0x213b1d0f,0x8d630831,0x92580037,0x6b8d0172}},	//   _fiqh_, ивре, _أشهر_, etag,
   {{0xa01b1d10,0x00000000,0x00000000,0x00000000}},	//   rför, --, --, --,
   {{0x6b8d1d11,0xa01b0222,0xcb671d12,0xaa46061b}},	// [13c0] gtag, sför, кате_, везл,
   {{0x249f1d13,0xd0f20065,0xa01b0212,0x00000000}},	//   heum_, _faṣẹ, pför, --,
   {{0xfaa31440,0xef1f0103,0x673a1d14,0xa01b003e}},	//   рахо, ztük_, _ritj, ngön,
   {{0x673a1d15,0x080a001c,0x00000000,0x00000000}},	//   _sitj, وزشي_, --, --,
   {{0x673a1d16,0x2ca0007a,0x27290220,0x249f0113}},	//   _pitj, meid_, kúnd_, deum_,
   {{0x2ca01d17,0x98b80113,0x66dd0154,0xc1780138}},	//   leid_, _bură_, _dèko, yrė_,
   {{0x5fa9000f,0x888412eb,0x4420013f,0xb0e20789}},	//   _चैनल, _میان, _ši_, _पतंग,
   {{0x44200019,0x2ca000aa,0xef1f0103,0x661a00d4}},	//   _ơi_, neid_, ttük_, _vytk,
   {{0xccf30054,0x2b4600e3,0xf7461d18,0x673a003d}},	//   יכה_, íoch_, _резо, _titj,
   {{0x2ca01d19,0x21291d1a,0x2d9a038c,0x673a1183}},	//   heid_, _shah_, _oppe_, _uitj,
   {{0x60f91d1b,0xc4861d1c,0x2ca01d1d,0x6b8d0634}},	//   ення_, _алек, keid_, ztag,
   {{0x6b8d1d1e,0xdb0400c2,0x249f1d1f,0x85f700ca}},	//   ytag, lviä, ceum_, _בצבע_,
   {{0x442000de,0x2ca000aa,0x996200b6,0xddde0154}},	//   _ái_, deid_, _níže_, _depō,
   {{0x4426023f,0x2d471d20,0x6b8d1d21,0x6d4303a9}},	//   _izo_, _põe_, vtag, _énak,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x6b8d1d22,0x2009023e,0x2ca000b7,0x00000000}},	//   ttag, _txai_, geid_, --,
   {{0xbab90265,0x6b8d1d23,0x00000000,0x00000000}},	// [13d0] нгах_, utag, --, --,
   {{0x6b8d1d24,0x7a40025b,0xbb1900e3,0x249f1d25}},	//   rtag, vští, رياض_, zeum_,
   {{0x6b8d1d26,0x2ca01d27,0x249f0167,0x00000000}},	//   stag, beid_, yeum_, --,
   {{0xf7711d28,0x442600ac,0x2ca0009c,0x98ad00a5}},	//   مات_, _ozo_, ceid_, _mieć_,
   {{0x6d451d29,0xb05b1537,0x44260b58,0xb5fc0090}},	//   _huha, rjäh, _nzo_, _reġa,
   {{0x6d451d2a,0x6f151d2b,0xd6db0686,0x0684004d}},	//   _kuha, nozc, ьте_, игін,
   {{0x44261d2c,0x6d451d2d,0x29881d2e,0xa8a71d2f}},	//   _azo_, _juha, _исто_, _ирак,
   {{0xf3f900d3,0x60dd029a,0xd92800ae,0x66dd05aa}},	//   laţi_, jksm, _ацул_, _zèkl,
   {{0xe796010d,0xf4950421,0xddde022b,0x00000000}},	//   _مالک, نشکد, _repō, --,
   {{0xdb0400c9,0x63ad00e9,0x2fd902ad,0xf3f900ae}},	//   rviç, _šans, dysg_, naţi_,
   {{0x44261d30,0xe8df0134,0x658a00a7,0xf8c70442}},	//   _ezo_, _ndịa_, _səhv, _रचाय,
   {{0xcea909c1,0x455a00ca,0xf48719e8,0x61fc0076}},	//   _מי_, _נכנס, _јужн, úrla,
   {{0x645b1d31,0x7f441d32,0x7760023e,0xe2a8001c}},	//   mbui, _quiq, _xwmx, راین_,
   {{0x6d451d33,0x201e00d9,0xf3f900ae,0x645b0f10}},	//   _buha, āti_, jaţi_, lbui,
   {{0xfce6192f,0x2ca0007a,0xe296013d,0xf3f900ae}},	//   гово, teid_, _сащ_, daţi_,
   {{0x6d451d34,0xee3700d3,0x645b1d35,0x61d61777}},	//   _duha, унс_, nbui, _תוקף_,
   {{0x2ca01d36,0x0c261cdb,0x6d451d37,0xa3e309a1}},	// [13e0] reid_, уман, _euha, ननि_,
   {{0x2ca00006,0xf3f900ae,0xb6020131,0x7c260206}},	//   seid_, gaţi_, _àágu, _vzkr,
   {{0x3f821d38,0x6d45023f,0x2ca01d39,0x2d9a0149}},	//   luku_, _guha, peid_, _uppe_,
   {{0x7d7b0105,0xa3e300a5,0x645b0381,0x00000000}},	//   _אנטו, नना_, jbui, --,
   {{0x7d041d3a,0x6d451d3b,0x3f821d3c,0x7c2601d3}},	//   mnis, _zuha, nuku_, _uzkr,
   {{0xf3f9002d,0x7d041d3d,0x236d0031,0x645b02ac}},	//   caţi_, lnis, dsej_, ebui,
   {{0x3f821d3e,0x224e01ff,0xe510023a,0xb9240065}},	//   huku_, _rffk_, ावलि_, _musẹ_,
   {{0x33741d3f,0x7d040fda,0x3f821d40,0x44260357}},	//   агир, nnis, kuku_, _pzo_,
   {{0x7d041d41,0xd70a01c9,0x3f821d42,0x78a21d43}},	//   inis, _знае_, juku_, meov,
   {{0x7d041d44,0x3f821d45,0x78a20357,0x92b60037}},	//   hnis, duku_, leov, احظا,
   {{0x7d041d46,0x6f150094,0xe3b20281,0x645b010a}},	//   knis, vozc, _گرا_, bbui,
   {{0x3386188d,0x6d451d47,0x2ba51d48,0x3f821c35}},	//   _букв, _ruha, _ऑनला, fuku_,
   {{0x442600ac,0x6d451d49,0x60dd1d4a,0x644202c9}},	//   _uzo_, _suha, rksm, _igoi,
   {{0x6d451d4b,0x7d041d4c,0x02a300e5,0xf1a61d4d}},	//   _puha, enis, _гръм, _брин,
   {{0x59a40067,0x7d041d4e,0xf3f9020a,0x6f151d4f}},	//   _गैलर, fnis, vaţi_, rozc,
   {{0x3f82077e,0xd9041ac9,0x6d451d50,0x7d160188}},	//   buku_, _ری_, _vuha, goys,
   {{0xf3f900d3,0x6d451d51,0x78a21d52,0xdbc601bf}},	// [13f0] taţi_, _wuha, deov, röße,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x7d0402e2,0x658a0092,0xad270260,0xf3f900d3}},	//   bnis, _məhs, _مرحو, raţi_,
   {{0x3ea31abd,0x64421d53,0xe82000aa,0xf3f900ae}},	//   lejt_, _ngoi, _बरखा_, saţi_,
   {{0x6298134c,0x2d910a00,0xd5b80325,0x96651d54}},	//   _obvo, ltze_, _arā_, акле,
   {{0x4b7a006e,0x64421d55,0x2d910062,0x00000000}},	//   _באשו, _agoi, otze_, --,
   {{0x2d8312fb,0x2d9101e9,0x645b18f0,0x3f821d56}},	//   nuje_, ntze_, tbui, zuku_,
   {{0x09e11827,0x67d51d57,0x2d9101c8,0x3f8218fe}},	//   पनीय, _кобу, itze_, yuku_,
   {{0x2d8309cf,0xb4d509d0,0xe7871d58,0x645b1d59}},	//   huje_, _सकी_, _љубо, rbui,
   {{0x3ae40222,0x64421d5a,0x3f820335,0x645b1d5b}},	//   _köpa_, _egoi, vuku_, sbui,
   {{0x41061d5c,0x7d041d5d,0x00000000,0x00000000}},	//   изов, ynis, --, --,
   {{0x3f821d5e,0xf5300037,0xdddc05db,0x00000000}},	//   tuku_, _فإن_, jgrš, --,
   {{0x7d040ca7,0x8c3b042c,0x00000000,0x00000000}},	//   vnis, _maßs, --, --,
   {{0x3f8202e6,0x2d830dd1,0xc8e20034,0xef1700d3}},	//   ruku_, fuje_, _खत्म_, имя_,
   {{0x7d041d5f,0x3f821d60,0x6da614fa,0xacf619e8}},	//   tnis, suku_, шива, ачај,
   {{0x3f821d61,0x7ce300aa,0xdb0f00b3,0x26f2049d}},	//   puku_, _põra, _arcà, _अग्र_,

   {{0x7d040e13,0x2d9101ff,0x8fa61d62,0x60cb0154}},	// [1400] rnis, atze_, _тапе, _ògma,
   {{0x2d831d63,0x658a00a7,0xf1c90032,0xeb971272}},	//   buje_, _məhr, _gbáà_, риф_,
   {{0x7e7b00a1,0xc8661d64,0xed5a0231,0xb5fc0090}},	//   _באיז, атли, _шон_, _reġo,
   {{0xd7fa0086,0x7c9601b6,0x256c0065,0x00000000}},	//   кул_, _троц, _lólá_, --,
   {{0x27e0054f,0xc60e0179,0x78a200d7,0xb8ce05cd}},	//   áin_, िथ्य_, reov, _कस_,
   {{0x78a21d65,0x64420049,0x6b841d66,0x00000000}},	//   seov, _sgoi, muig, --,
   {{0x3567004b,0x5f090789,0x6b84009c,0x27e01d67}},	//   арын_, _सदस्_, luig, šin_,
   {{0xd9431d68,0x63b9030a,0x658a00a7,0x00000000}},	//   _фети, _brwn, _bəhr, --,
   {{0x667600bf,0xb4d6009d,0x256c0065,0x26161ab1}},	//   _ندار, _हवी_, _bólá_, _पुरी_,
   {{0x4ac91d69,0x2d830169,0x00000000,0x00000000}},	//   रायव, yuje_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x2d830074,0xd5fb00ca,0x63b903a8,0x6b840350}},	//   vuje_, _בפבר, _frwn, kuig,
   {{0x658a01d4,0x893700c1,0x61ff0092,0x2d830034}},	//   _təhs, ירטע_, _əylə, wuje_,
   {{0xdefb01b3,0x539b0327,0x6b841d6a,0x00000000}},	//   тым_, _סיוו, duig, --,
   {{0x27290037,0x3ea3023b,0x69d801df,0xcf8e001c}},	//   núna_, rejt_, øvel, وژی_,
   {{0x3ea31d6b,0x2d9101e9,0x00000000,0x00000000}},	//   sejt_, rtze_, --, --,
   {{0x3ea300dd,0x6f950037,0x6b84014b,0xdb0f1d6c}},	// [1410] pejt_, _الخض, guig, _arcá,
   {{0x3ce9006c,0x62881d6d,0xdd8700d3,0xed4e0103}},	//   shav_, ngdo, _кымп, بھی_,
   {{0xf9f90037,0x3ce9004d,0x00000000,0x00000000}},	//   دفاع_, phav_, --, --,
   {{0xb4d50971,0x6d5701e9,0x3ebf03e3,0x6b8401d0}},	//   _सके_, _itxa, ɓuta_, buig,
   {{0x395a00f9,0x6d480146,0xb05b007b,0x00000000}},	//   apps_, ídav, ljäs, --,
   {{0x9a8419e8,0x290601ff,0x00000000,0x00000000}},	//   _мусл, anoa_, --, --,
   {{0x7ae70063,0x25ac00fe,0x00000000,0x00000000}},	//   _iljt, _csdl_, --, --,
   {{0xe91900d6,0x79850b58,0x00000000,0x00000000}},	//   _собі_, muhw, --, --,
   {{0x658a00a7,0xa8250421,0xdd0204e9,0xdb0f02c6}},	//   _qəhr, _اکان, šuću, _zrcá,
   {{0x6d570634,0x00000000,0x00000000,0x00000000}},	//   _otxa, --, --, --,
   {{0xa06a1d6e,0x6d570197,0x6b8401c0,0xd9f91073}},	//   лана_, _ntxa, zuig, ्पित_,
   {{0x628801d0,0x658a013c,0x00000000,0x00000000}},	//   agdo, _təhr, --, --,
   {{0x6d570634,0xe2991d6f,0x5eb10033,0x63b90169}},	//   _atxa, _бал_, ঞানে, _urwn,
   {{0x63a91d70,0xd9f91926,0x00000000,0x00000000}},	//   mwen, ्पात_, --, --,
   {{0x63a90060,0x8db5004d,0x80b00033,0x00000000}},	//   lwen, ості, টাব্, --,
   {{0x6b841d71,0xb4d51d72,0x307a0037,0x79850027}},	//   tuig, _सको_, _صحبة_, duhw,
   {{0x60c41d73,0x63a91d74,0x3ce0017a,0x6d5701e9}},	// [1420] _inim, nwen, rkiv_, _etxa,
   {{0xfd690294,0x20ef01c2,0xff260012,0x4bd9007b}},	//   _jupụ, nƙin_, _ымпо, шься_,
   {{0x63a91d75,0xbed700c1,0x60d6026a,0x00000000}},	//   hwen, _הויז_, _koym, --,
   {{0xb4d60b79,0x6d5c0a82,0x63a91d76,0xe89400d6}},	//   _हवे_, mpra, kwen, іаль,
   {{0x29061d77,0xbcb700ca,0x628802b6,0xa77307bf}},	//   rnoa_, _הפכו_, ygdo, зліч,
   {{0x6ffc00d9,0xef1f01e8,0x63a91d78,0xfd690134}},	//   mācī, ltür_, dwen, _nupụ,
   {{0x6d5c0c56,0x6d430231,0xc7af0103,0x63a91d79}},	//   npra, _énat, وڑے_, ewen,
   {{0xdbdd0220,0x98bc01d3,0x63a91d7a,0x60c4083e}},	//   zšír, īvē_, fwen, _nnim,
   {{0x96961d7b,0xfd690174,0x63a91d7c,0x7e6e01d3}},	//   _греш, _bupụ, gwen, kabp,
   {{0x68e20018,0x59dc1d7d,0x6eeb1d7e,0x69c10072}},	//   lkod, _यथार, _kübe, _álec,
   {{0xba9b006e,0x658a00a7,0x5a9b006e,0x62881d7f}},	//   נסטי, _təhq, נשטא, rgdo,
   {{0x6d5c1d80,0x63a91d81,0x68e21d82,0x7afe026a}},	//   dpra, bwen, nkod, hipt,
   {{0x7afe0102,0x5f94060b,0x53a30f2e,0x6eeb1d83}},	//   kipt, пият, _нацб, _lübe,
   {{0xb5fc03e5,0x60c41d84,0x7afe023b,0x39581d85}},	//   _reġj, _enim, jipt, _otrs_,
   {{0x6d5c19e6,0x68e21d86,0xab5b1d87,0x8af0013c}},	//   gpra, kkod, _krüg, rpəl,
   {{0x99860067,0x657c13c8,0x2d730b18,0x25e00336}},	//   łoś_, _århu, rće_, _कथनी_,
   {{0x8b580037,0x09e10096,0x2d73007e,0x2a6a030a}},	// [1430] مجلس_, पन्य, sće_, _bebb_,
   {{0x2d731d88,0x7afe0076,0x2efa02ac,0x00000000}},	//   pće_, gipt, _gmpf_, --,
   {{0x7f3c00c1,0x69de0d5b,0x63a90201,0x6d481d89}},	//   _געזו, gype, zwen, ídat,
   {{0xad27037f,0x38690102,0x9bc7022c,0xfc3f03be}},	//   _درخو, úar_, _лёгк, _saíu_,
   {{0x395800b3,0x00000000,0x00000000,0x00000000}},	//   _etrs_, --, --, --,
   {{0x7afe0496,0xab5b02e2,0xe7391d8a,0xb5791b60}},	//   cipt, _prüf, шел_, ащих_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x63a91d8b,0x68e21d8c,0x280400b6,0x00000000}},	//   twen, ckod, ásná_, --,
   {{0x68e91d8d,0x63a90ab2,0x25a0020a,0x68fb0af0}},	//   _iled, uwen, ăila_, _imud,
   {{0x60c400e9,0x81d400c7,0x68e9000d,0x63a91d8e}},	//   _snim, _সেই_, _hled, rwen,
   {{0x68e91d8f,0x63a90060,0x545502b3,0x68fb0085}},	//   _kled, swen, _двет, _kmud,
   {{0x6d5c0087,0x60d60092,0x68e90113,0x00000000}},	//   vpra, _qoym, _jled, --,
   {{0xb05b0149,0xfc3f1d90,0x2b591d91,0x7afe0103}},	//   tjär, _maís_, _ntsc_, yipt,
   {{0x6d5c1d92,0x68e21d93,0x539a0327,0x68e900f0}},	//   tpra, zkod, _כינו, _lled,
   {{0x823709b4,0x290d002b,0x98a40138,0xe3b90103}},	//   _ارشا, _ojea_, _gimė_, lvű_,
   {{0xb05b1d94,0x39581d95,0x2a6a00dc,0x6eeb0364}},	//   sjär, _rtrs_, _sebb_, _rübe,
   {{0xa11300e3,0x2a780167,0xa2cd1d96,0x394a1d97}},	// [1440] _تويت, _pdrb_, ताप्, _subs_,
   {{0x6d5c1d98,0x68fb1d99,0x68e90143,0x290d01ff}},	//   ppra, _amud, _aled, _ajea_,
   {{0x7afe1d9a,0x8c460457,0x6f1c1d9b,0xdcfc00ae}},	//   ript, _мене, morc, gură,
   {{0x69de1d9c,0x319a006e,0xc7c600c2,0xab5b0364}},	//   rype, יבענ, жски, _brüd,
   {{0x7d090559,0x68e90113,0x69de0094,0x26c50503}},	//   čest, _dled, sype, _bnlo_,
   {{0x7afe074a,0x68e21d9d,0x68e91d9e,0x6f1c1d9f}},	//   qipt, skod, _eled, norc,
   {{0xbb4308d1,0xc4480177,0xa2cd0d7a,0xab5b00aa}},	//   _церк, میان_, तान्, _prüg,
   {{0xd4970012,0x151700e3,0xd250001c,0x00000000}},	//   орь_, يزية_, کند_, --,
   {{0x394400ec,0x6b961da0,0x00000000,0x00000000}},	//   _iims_, ntyg, --, --,
   {{0xb5fc003d,0xa314007f,0x00000000,0x00000000}},	//   _leġi, डवेज_, --, --,
   {{0x7ce300aa,0x3f821da1,0x610401f9,0xdcfc00e8}},	//   _sõrm, erku_, zőle, ntrē,
   {{0x69c8014b,0x00000000,0x00000000,0x00000000}},	//   _àdeu, --, --, --,
   {{0x6f1c1da2,0x7afc05db,0x00000000,0x00000000}},	//   forc, _omrt, --, --,
   {{0x6f1c0039,0x63a20139,0x3cfd0285,0x00000000}},	//   gorc, _ipon, रोने_, --,
   {{0x3eb30092,0x2b4b0451,0x273200ae,0xdb0d016d}},	//   _vaxt_, _succ_, mând_, lvaç,
   {{0x1fa71da3,0x8b670037,0x9f6b0291,0x201600fd}},	//   _дрог, قائم, _кроз_, écié_,
   {{0x200c01d4,0x6f1c1da4,0x2d68044c,0x00000000}},	// [1450] şdir_, borc, aşe_, --,
   {{0x68fb1da5,0x6f1c1da6,0xf43b00a1,0x273200d3}},	//   _smud, corc, שתמש, nând_,
   {{0xaca30134,0xdcf50034,0xa2b200b6,0x7f45039f}},	//   _ahụb, erzą, _असन्, _iihq,
   {{0x63a21da7,0x3944015e,0xaac91da8,0xc23700ca}},	//   _opon, _cims_, राहक, קראו_,
   {{0x995400b6,0x37ab1da9,0xdcfc044c,0x6568041c}},	//   _výše_, ртен_, sură, _awdh,
   {{0x2ca91daa,0x26e30081,0xb345016d,0x68e900f0}},	//   lead_, কোনো_, _liçã, _wled,
   {{0x63a21dab,0x68e90449,0x3944022b,0xfc3f0131}},	//   _apon, _tled, _fims_, _taís_,
   {{0x68fb1dac,0x2ca91dad,0xaac91dae,0x3f82166e}},	//   _umud, nead_, रावक, yrku_,
   {{0x291d1daf,0x629a010a,0x39951842,0x6f1c037a}},	//   mowa_, ffto, lås_, yorc,
   {{0x2ca91db0,0x386d09e3,0x291d1db1,0x273200ae}},	//   head_, _heer_, lowa_, gând_,
   {{0x386d1db2,0x63a21db3,0xaca30134,0x7d080146}},	//   _keer_, _epon, _awọd, édsk,
   {{0x386d008a,0x23751a37,0x7cf10073,0x291d1db4}},	//   _jeer_, _فاتح, _hårf, nowa_,
   {{0x386d1db5,0xb5fc03e5,0x7ce300bc,0x2d831db6}},	//   _meer_, _reġi, _tõrj, erje_,
   {{0x386d1db7,0x273200d3,0x248d1db8,0x442f1db9}},	//   _leer_, când_, lgem_, _izg_,
   {{0xa928025b,0x291d1dba,0x63bb003e,0x2ca90037}},	//   ližš, kowa_, lvun, fead_,
   {{0x2ca901b9,0x7afc00d2,0x386d0305,0x273200d3}},	//   gead_, _smrt, _neer_, mâne_,
   {{0xfc3f08a8,0x291d1dbb,0x2d831dbc,0x3b8600c6}},	// [1460] _saír_, dowa_, arje_, ялаг,
   {{0xe81f0b89,0x6b960149,0x8b2300c2,0x7cea003e}},	//   _बड़ा_, rtyg, едуе, _dýra,
   {{0x3995040f,0x6edb00ca,0x66dd0113,0x386d1dbd}},	//   gås_, _החיפ, _lèks, _beer_,
   {{0x2fc0017a,0x3eaa0364,0x273200ae,0x3e5700b6}},	//   _krig_, lebt_, zând_, pětí_,
   {{0x4cbb0054,0xdcfc0029,0x2d981dbe,0x2d8a1dbf}},	//   _הזכו, strē, ltre_, lube_,
   {{0x6d461dc0,0xb4b40251,0x6b841dc1,0x7997023e}},	//   _hika, _छोड़_, mrig, btxw,
   {{0x2d981dc2,0x6d461dc3,0x291d1dc4,0x2d8a1dc5}},	//   ntre_, _kika, bowa_, nube_,
   {{0x6eeb01d4,0x94aa1dc6,0x6d46127e,0x2d981dc7}},	//   _müba, стка_, _jika, itre_,
   {{0x6d461dc8,0x6b841dc9,0x2fc0006c,0x273200ae}},	//   _mika, nrig, _nrig_, tând_,
   {{0x6d461dca,0x386d0ab2,0x61e11dcb,0x248d001f}},	//   _lika, _zeer_, fyll, agem_,
   {{0x6b8402e2,0x273200d3,0x64a61dcc,0x9f4e0031}},	//   hrig, rând_, _нажа, ľným_,
   {{0xc05807bf,0x2fc002ad,0x6b840bc6,0x9f4e0146}},	//   зір_, _brig_, krig, žným_,
   {{0x613f0029,0x3869003e,0x273200d3,0x63a21dcd}},	//   _jūli, ðari_, pând_, _upon,
   {{0x44261dce,0x6d461dcf,0x6136003e,0x61e11175}},	//   _iyo_, _aika, jálf, byll,
   {{0x6d461dd0,0x44261dd1,0x06fd030b,0x6b841dd2}},	//   _bika, _hyo_, _říká_, erig,
   {{0x6d461dd3,0x44260517,0x2d8300dd,0x2fc01dd4}},	//   _cika, _kyo_, rrje_, _frig_,
   {{0x2d9c1424,0x6d460496,0x386d0694,0x57c6009d}},	// [1470] _även_, _dika, _reer_, लमोह,
   {{0x7cea0074,0x291d1dd5,0x39950fbc,0x386d057a}},	//   _výra, wowa_, tås_, _seer_,
   {{0x291d1dd6,0x75221dd7,0x6d461dd8,0xab5b0364}},	//   towa_, _okoz, _fika, _brüc,
   {{0xf77104f4,0xddde030b,0x39950222,0x44261dd9}},	//   نات_, _nepř, rås_, _oyo_,
   {{0x44261dda,0x611200d9,0x3f8b01e8,0xab5b01bf}},	//   _nyo_, nāla, nucu_, _drüc,
   {{0x386d01aa,0x291d1ddb,0x6d461ddc,0xd24600e3}},	//   _weer_, sowa_, _zika, _لن_,
   {{0x44261ddd,0xc9841dde,0x672102dd,0x752200e7}},	//   _ayo_, _пути, _vklj, _bkoz,
   {{0x7d0d1ddf,0x44260b92,0x611200e8,0x61e1007b}},	//   nnas, _byo_, kāla, vyll,
   {{0x248d1de0,0x4426023f,0x61e10150,0xdb1d1de1}},	//   rgem_, _cyo_, wyll, _arsé,
   {{0x672100e9,0x7cf11de2,0x7d0d02ad,0x61e11de3}},	//   _uklj, _hård, hnas, tyll,
   {{0x3dc1023e,0x44261dd9,0x7d0d1de4,0x614703a9}},	//   _nrhw_, _eyo_, knas, dèlè,
   {{0x61e11de5,0x7d0d00e7,0x63a4020a,0x6b8401ee}},	//   ryll, jnas, _ţine, yrig,
   {{0x61e102e0,0x6d461de6,0xdb0f1de7,0x4426083e}},	//   syll, _rika, _escé, _gyo_,
   {{0x2d981de8,0x75291de9,0x6d4610b3,0x2d8a1dea}},	//   ttre_, llez, _sika, tube_,
   {{0x31161612,0x6b841deb,0x7d0d003e,0x7c370022}},	//   _офис, wrig, fnas, ɓarɓ,
   {{0xd1321dec,0x2d981ded,0x7d0d0088,0x2d8a02a4}},	//   _جمع_, rtre_, gnas, rube_,
   {{0xeb971dee,0xddc71def,0x4426023e,0x0b4600d6}},	// [1480] мит_, rajš, _xyo_, днан,
   {{0x6d4600a6,0xa01b1df0,0x7c260146,0x7d0d01b9}},	//   _wika, rgöt, _vykr, anas,
   {{0x6d460b4b,0x644b0451,0x8102009f,0x7c260034}},	//   _tika, _oggi, _लगाओ_, _wykr,
   {{0x6b841df1,0xa3bf030b,0x644b00cd,0x18670291}},	//   prig, ुमा_, _nggi, даци_,
   {{0x7d041df2,0x75290b18,0xa01b02c3,0x753b01cb}},	//   miis, dlez, lgör, dmuz,
   {{0x644b0465,0x7d041df3,0x752202dd,0x75290010}},	//   _aggi, liis, _skoz, elez,
   {{0x7ae30084,0xa01b1df4,0x44260270,0xdcf50034}},	//   önte, ngör, _syo_, erzę,
   {{0x75291df5,0x29020149,0x7cf11bfa,0x44261df6}},	//   glez, _öka_, _gård, _pyo_,
   {{0x38661df7,0xddde02c6,0xdb04002b,0x60cb009c}},	//   mbor_, _vepř, lviñ, _ògmi,
   {{0x6d5e02e6,0x7d04008a,0x65c6013d,0x644b1df8}},	//   _otpa, hiis, _обза, _eggi,
   {{0x7d041df9,0x7cf10d3e,0xe8df00de,0x75291dfa}},	//   kiis, _håre, _hiền_, blez,
   {{0x44261dfb,0x7cf10f3c,0xf503008f,0x75290036}},	//   _tyo_, _kåre, _изхо, clez,
   {{0x7d040694,0x6d5e1dfc,0x7ce3007a,0x44261dfd}},	//   diis, _atpa, _kõrv, _uyo_,
   {{0xe8df0019,0x3f991dfe,0x3f8b0367,0x611201d3}},	//   _miền_, rtsu_, rucu_, rāla,
   {{0xc3480028,0xe8df0019,0x7d0d1dff,0x7d04008a}},	//   _nổi_, _liền_, tnas, fiis,
   {{0x7d040784,0x30a70a28,0x40351e00,0x201e00ae}},	//   giis, _цркв, _пейс, ştia_,
   {{0xfd44013f,0x00000000,0x00000000,0x00000000}},	// [1490] тэрн, --, --, --,
   {{0x7d0d1e01,0x4ac9000f,0x0dcb013d,0x19eb0037}},	//   snas, राइव, _думи_, يراً_,
   {{0x7d041e02,0xceb200c1,0x61ed0022,0x212b00f0}},	//   biis, _גיי_, _ƙali, olch_,
   {{0x7d040188,0xa81500ae,0x7aee1e03,0x7cf100f2}},	//   ciis, ндеш, _elbt, _båre,
   {{0x7cf10222,0xc7ab15f8,0x78ab0313,0x14bf0d7e}},	//   _vård, تدال_, regv, _शोषण,
   {{0x6d5800fd,0x6b8d0239,0x6d4a028d,0x7e750062}},	//   _évac, muag, _èfac, nazp,
   {{0x752901cb,0x260200c3,0x69d800f2,0xa2cd1e04}},	//   tlez, _वेदी_, øvet, तास्,
   {{0x7cf10f05,0x7e7501ff,0x672a18f0,0x00000000}},	//   _hårb, hazp, alfj, --,
   {{0x61360146,0x7529029a,0x68e400c2,0x387f00bd}},	//   nále, rlez, öide, _idur_,
   {{0x752902c6,0xaad21e05,0xdbdb0139,0x00000000}},	//   slez, सायक, _mààm, --,
   {{0x290f0027,0x753b1e06,0x00000000,0x00000000}},	//   onga_, pmuz, --, --,
   {{0x290f01af,0x387f00bd,0x68f9020e,0x2732020a}},	//   nnga_, _jdur_, _çadı, mâna_,
   {{0x7d041e07,0x13a700cd,0x290f004d,0x6b8d034f}},	//   viis, _آنتی_, inga_, juag,
   {{0x6136025b,0x7e750634,0x7d040188,0x386600d4}},	//   dále, gazp, wiis, zbor_,
   {{0x7d041e08,0x6da311b7,0x290f0124,0x387f07e7}},	//   tiis, лира, knga_, _odur_,
   {{0x7cea0871,0xe05800cd,0xdbdb0139,0xa2cd1792}},	//   _výro, _زیست_, _bààm, ताव्,
   {{0x7d041e09,0x61361e0a,0x6b8d028d,0xbb4a0260}},	// [14a0] riis, ráld, guag, سلان_,
   {{0x7d041e0b,0x2cb90072,0xdbdb0032,0x387f1e0c}},	//   siis, _easd_, _dààm, _adur_,
   {{0x7cf11e0d,0x88861e0e,0x7d040302,0x6d5e0565}},	//   _såre, ележ, piis, _utpa,
   {{0xdd2f030b,0x395100c4,0x2cb901ec,0xdb04002b}},	//   pěšn, _duzs_, _gasd_, rviñ,
   {{0x3c7700ca,0x387f182f,0x3eba0313,0x5fc30442}},	//   _אתכם_, _ddur_, _kapt_, शियल,
   {{0x290f1e0f,0x7cf113f8,0xa82400cd,0xe8df0023}},	//   anga_, _våre, _یکشن, _viền_,
   {{0x212b0150,0x77620072,0x940a00a7,0x290f1e10}},	//   ylch_, spox, əbə_, bnga_,
   {{0xe8df00ef,0x7cf101df,0xd9431e11,0xf3660c3f}},	//   _tiền_, _tåre, _беси, нтон,
   {{0x7ce300bc,0x290601c8,0x00000000,0x00000000}},	//   _tõrv, mioa_, --, --,
   {{0x13f300c2,0xdb9700c1,0x290601e9,0x877b0327}},	//   узья, עדיט_, lioa_, _מאמי,
   {{0x61360146,0xb05b02c3,0x6d5a0174,0xc17800c6}},	//   zále, ndäg, ̣tar, usė_,
   {{0x26de0044,0x6b8d0167,0x29061e12,0x00000000}},	//   _hoto_, yuag, nioa_, --,
   {{0xa30b00fb,0xa2e61e13,0xe8df0019,0x6d5a1e14}},	//   _کرنے_, _подд, _hiển_, ítan,
   {{0x26de0051,0x9f35004d,0x61361e15,0x29060062}},	//   _joto_, тегі, vále, hioa_,
   {{0x3eba1e16,0x7e751e17,0xf1a300d3,0xa2cd1e18}},	//   _dapt_, razp, _брын, तार्,
   {{0x6b8d1e19,0x0ccf0081,0x7cf10073,0x61360094}},	//   tuag, রস্ত, _sårb, tále,
   {{0x60cd023f,0x3eba002d,0x26cc1e1a,0x27e606a3}},	// [14b0] _inam, _fapt_, _ondo_, jyon_,
   {{0x26de1e1b,0x6b8d1e1c,0x3ce90117,0x28c6023a}},	//   _noto_, ruag, skav_, _रोबि,
   {{0xab5b02e2,0x290f019c,0x7b0b01d3,0x6b8d1e1d}},	//   _grün, tnga_, kļuv, suag,
   {{0xa95400d6,0x6c7900c1,0x290f0239,0x61360146}},	//   укці, _קאָפ, unga_, pále,
   {{0x27e60068,0x60cd0051,0x26de1e1e,0x69d813b9}},	//   gyon_, _mnam, _boto_, øver,
   {{0xe8df0028,0x8698008f,0x26de0328,0xd6db1e1f}},	//   _biển_, етът_, _coto_, яте_,
   {{0xa8a71e20,0x60cd019f,0x5b1407c8,0x27e606a8}},	//   _прак, _onam, _смрт, ayon_,
   {{0x81c80033,0x27e603e3,0x60cd0517,0x387f1e21}},	//   োনা_, byon_, _nnam, _udur_,
   {{0x249f1e22,0xf6990831,0x1fcb0096,0xe7841e23}},	//   rfum_, _овај_, ामोड, _бухо,
   {{0x60cd1e24,0x78bb1e25,0xa2e50231,0x26de0133}},	//   _anam, _hauv, тоод, _goto_,
   {{0x67230078,0xe4e7004d,0x60cd037a,0x9f4402c6}},	//   monj, _підн, _bnam, ámí_,
   {{0x67231e26,0x60cd009c,0xd00a001f,0x3eba020a}},	//   lonj, _cnam, деме_, _sapt_,
   {{0x78bb0257,0x3ae40149,0xe299001f,0x60df01ee}},	//   _mauv, _köpt_, _жал_, _doqm,
   {{0x290603f3,0x60cd1e27,0x67231e28,0x78bb1e29}},	//   zioa_, _enam, nonj, _lauv,
   {{0x27e61e2a,0x7c961031,0xc6920089,0x61ed0d2a}},	//   zyon_, крац, יאם_, _ƙalu,
   {{0xfbe700de,0x645b1e2b,0x67231e2c,0x78bb1e2d}},	//   _thể_, ncui, honj, _nauv,
   {{0x3eba1e2e,0x1c461e2f,0x00000000,0x00000000}},	// [14c0] _tapt_, тнам, --, --,
   {{0x67230dd7,0x00000000,0x00000000,0x00000000}},	//   jonj, --, --, --,
   {{0x26de1e30,0x67231e31,0xd9460582,0x78bb042c}},	//   _roto_, donj, вежи, _bauv,
   {{0x26de1e32,0xa9671e33,0x27e602f1,0xe78601b3}},	//   _soto_, тица_, tyon_, вуко,
   {{0xa2b202e8,0x26de1e34,0x29060a00,0x27e60009}},	//   _असल्, _poto_, rioa_, uyon_,
   {{0x67231e35,0x7bc60078,0x29060a00,0x27e61e36}},	//   gonj, _irku, sioa_, ryon_,
   {{0x27e61e37,0x66e30396,0x290601e9,0x78bb014b}},	//   syon_, роја, pioa_, _fauv,
   {{0x399c05fe,0x6abc1e38,0x7539022b,0x44b40c37}},	//   mís_, _harf, _chwz, убис,
   {{0x26de0074,0x6abc1114,0x290403e5,0x78a2031a}},	//   _toto_, _karf, _imma_, mfov,
   {{0x78bb005f,0x60cd1e39,0x78a21e3a,0x672300ae}},	//   _zauv, _snam, lfov, conj,
   {{0x399c1e3b,0x6abc1e3c,0x68e01e3d,0x6d5a003e}},	//   nís_, _marf, _komd, ítal,
   {{0x7bc61e3e,0x645b1e3f,0xab5b1e40,0x6abc03a8}},	//   _orku, ccui, _brül, _larf,
   {{0x399c00e3,0x7bd6023e,0x53b61462,0x23b60179}},	//   hís_, jxyu, _अनिश, _अनिद,
   {{0x3d951cbd,0x28a402d5,0x68e00372,0xdb1d00d4}},	//   лигр, _गॉसि, _lomd, _prsí,
   {{0x5e5802ec,0x7bc61e41,0x29041e42,0x2c580e62}},	//   тися_, _arku, _omma_, _ọda_,
   {{0x518313a4,0x60cd1e43,0x399c1e44,0x8c64002d}},	//   _туша, _unam, dís_, итуд,
   {{0x6abc1e45,0x6d58020d,0x5b151e46,0x7bc605db}},	// [14d0] _barf, _évan, гмат, _crku,
   {{0x29041e47,0x78bb025a,0xe8df0028,0x61360102}},	//   _amma_, _sauv, _miễn_, mála,
   {{0x6abc1e48,0xce331e49,0xd366001c,0x61360018}},	//   _darf, _خودک, _گه_, lála,
   {{0xfc640465,0xfc3f058a,0x2d911e4a,0x68e00503}},	//   _върн, _maíz_, muze_, _comd,
   {{0xd366012b,0x6abc1e4b,0x61360018,0x78bb02fd}},	//   _ده_, _farf, nála, _vauv,
   {{0x6abc1e4c,0xddce1e4d,0xb05b007b,0xa5b90284}},	//   _garf, labš, rjäy, ећих_,
   {{0x613600e3,0x399c1e4e,0x212903e3,0x67231e4f}},	//   hála, cís_, _okah_, ronj,
   {{0x2602009d,0xe3b911e7,0x69c70167,0x38c20103}},	//   _वेळी_, еби_, _irje, térő_,
   {{0x67231e50,0x032501a0,0xecc50033,0x6abc01c2}},	//   ponj, лдин, _একাড, _yarf,
   {{0xe8df00ef,0x61e802ad,0x645b1e51,0x2d911e52}},	//   _diễn_, fydl, scui, kuze_,
   {{0x04951e53,0x394d0934,0x13a70281,0xb1461e54}},	//   _ملاح, _kies_, رنگی_, лнол,
   {{0xa6e20102,0x2d910201,0x201e026a,0x00000000}},	//   _öðru, duze_, ştim_, --,
   {{0x394d1e55,0x61361e56,0xdcfc01d3,0x2d910381}},	//   _mies_, gála, strī, euze_,
   {{0x69c71e57,0x272903be,0xe2991e58,0xe8d014e5}},	//   _orje, múns_, _чак_, _सच्च,
   {{0x52390130,0xd33600ca,0x2d911e59,0x26ca0072}},	//   _אײַנ, _גרסה_, guze_, _óboe_,
   {{0x394d03e5,0x399c1e5a,0xa3b7152c,0x6abc1e5b}},	//   _nies_, vís_, _चना_, _sarf,
   {{0x69c71e5c,0x2d8a00e7,0x00000000,0x00000000}},	// [14e0] _arje, srbe_, --, --,
   {{0x80a004dd,0xa3d40067,0x2d911a0f,0x7cf10149}},	//   ग्रे, हमत_, buze_, _våra,
   {{0x6abc1e5d,0x8cbf00a3,0x7ce3007a,0x80d80096}},	//   _varf, _लोको, _võrr, यापे,
   {{0x399c1c27,0xdb0f0428,0x394d00b3,0x7cf10212}},	//   rís_, _escà, _cies_, _tåra,
   {{0xb8dc1e5e,0x394d1e5f,0x66e60f80,0x7bc61e60}},	//   _अस_, _dies_, лода, _urku,
   {{0xd5ba1e61,0x394d00f3,0x399c1e62,0x00000000}},	//   еси_, _eies_, pís_, --,
   {{0x69c704e9,0xdb230103,0xc7b901f9,0x7bc41e63}},	//   _grje, _óráj, _eső_, lviu,
   {{0x29041e64,0x62830150,0xc44800cd,0xfc3f04d8}},	//   _umma_, _adno, نیان_, _raíz_,
   {{0xd2500080,0x27290933,0x12e60077,0x9cd700ca}},	//   ينة_, gúns_, гінг, רופה_,
   {{0x7cf808a8,0xe8df0019,0x61e80149,0x61360018}},	//   _fírg, _viễn_, tydl, vála,
   {{0x7cf800b3,0x62340307,0x80b00033,0x546a1e65}},	//   _gírg, рену, য়ান্, _заем_,
   {{0x2d91023f,0x61361e66,0xe8df00de,0x6283022b}},	//   vuze_, tála, _tiễn_, _edno,
   {{0x8cbf0067,0xe47b006e,0x41b000b7,0x4432020b}},	//   _लोगो, _טראכ, _जनकस, _áy_,
   {{0x43831823,0x613600e3,0xef1f0491,0xb3bb00ca}},	//   _الوق, rála, mrük_, _נמוכ,
   {{0x61361e67,0x6d58025a,0x51860077,0x9f4402c6}},	//   máln, _éval, _сула, ámá_,
   {{0x69c700dd,0x557700c1,0x61360103,0xf1930103}},	//   _rrje, טעלן_, láln, _اُٹھ,
   {{0xe8df00ef,0x3a7500d3,0x1bd4008f,0xa3e40d75}},	// [14f0] _hiện_, илар, ботя, नहि_,
   {{0x6136128f,0xe8df0028,0x394d0120,0x69c70357}},	//   náln, _kiện_, _sies_, _prje,
   {{0xc3330054,0x28c60e28,0xfc3f0032,0x0855007b}},	//   צוע_, _रोहि, _gbín_, авею,
   {{0x2fc90185,0x80d809c3,0x69c71e68,0xd7f10037}},	//   _krag_, याये, _vrje, يكا_,
   {{0x394d1e69,0xdb0f04d8,0x61361e6a,0x960d0557}},	//   _vies_, _escá, káln, िप्ट_,
   {{0x6b8d181f,0x6d4f1e6b,0x394d02db,0x2fc9009c}},	//   mrag, _hica, _wies_, _mrag_,
   {{0x4519167b,0x6d4f0da3,0x25ac0124,0xf773001c}},	//   кция_, _kica, _cpdl_, _گاز_,
   {{0x2bc90f53,0x6d57008a,0x7cf81e6c,0xb3851e6d}},	//   रिपा, _muxa, _vírg, алил,
   {{0x2fc9023e,0x28f800c2,0xe69500ae,0x613600d4}},	//   _nrag_, _сеть_, _визы, fáln,
   {{0x6d4f0197,0x42551e6e,0x61361e6f,0xe8df00de}},	//   _lica, штит, gáln, _biện_,
   {{0x7cf80068,0x6b8d072f,0xa06a1693,0x2fc90188}},	//   _híre, hrag, кана_, _arag_,
   {{0xe8df0028,0xe0461e70,0x6b8d1e71,0x2fc91e72}},	//   _diện_, инни, krag, _brag_,
   {{0xf3670870,0x6136045e,0x611201d3,0x2fc9009c}},	//   _стен, báln, nāli, _crag_,
   {{0xfc3f0032,0x7cf80037,0x7d0600dc,0x2fc91e73}},	//   _abío_, _míre, _smks, _drag_,
   {{0x6d4f0ee4,0x2d9e0257,0x6d570042,0x6b8d1e74}},	//   _bica, îte_, _cuxa, erag,
   {{0x6b8d1e75,0xb4e3009d,0xa2cd009d,0x2fc91e76}},	//   frag, _नको_, ताक्, _frag_,
   {{0x6d4f1e77,0x61360018,0xec4a1e78,0x7cf10f3c}},	// [1500] _dica, lálo, тзал_, _tårn,
   {{0xff7b00c1,0x7bc400ae,0x6d57002b,0x78a90372}},	//   _שטימ, rviu, _fuxa, _abev,
   {{0x6d4f00c9,0x613610a8,0x442f0138,0xdca61e79}},	//   _fica, nálo, _lyg_, _кани,
   {{0xdbdc0074,0x3ead0039,0x2c5c00a5,0x6b8d1e7a}},	//   lšíc, đete_, _bądź_, brag,
   {{0xc7a30aec,0x78b000c6,0x6b8d020d,0x263500fe}},	//   жичк, _įkvė, crag, _áo_,
   {{0x7cf80080,0x7e7c04c8,0x6d441e7b,0x613d0018}},	//   _díre, narp, lmia, méle,
   {{0x442f0167,0x7cf80076,0x6d4f050f,0xd5b00037}},	//   _ayg_, _tírd, _yica, سفة_,
   {{0x442f052f,0x7d161e7c,0x6d43028d,0x7e7c1e7d}},	//   _byg_, nnys, _ènat, harp,
   {{0x2bc90469,0x61360074,0xfbc902c6,0x00000000}},	//   रिया, táln, रियम, --,
   {{0xdbdc025b,0x39581e7e,0xa2cd023a,0x6eeb1e7f}},	//   jšíc, _kurs_, ताग्, _tübi,
   {{0x61361e80,0x7e770063,0xdbdc0094,0x7e7c1e81}},	//   ráln, _rexp, dšíc, darp,
   {{0xb3560814,0x03a60636,0xab5b02e2,0xe8df0028}},	//   _پیدا_, _видо, _früh, _viện_,
   {{0x6d4f168c,0x7cf10939,0x6d44007f,0x00000000}},	//   _rica, _dårl, dmia, --,
   {{0xe8df0028,0x6d4f1e82,0x6b8d1e83,0x6d571097}},	//   _tiện_, _sica, vrag, _puxa,
   {{0x13b61117,0xab5b1e84,0x395801b9,0x61361e85}},	//   _अनुभ, _trük, _nurs_, cálo,
   {{0x61360103,0x00000000,0x00000000,0x00000000}},	//   náll, --, --, --,
   {{0xa2cb0096,0xdd2f02c6,0xdbdc00d4,0x113c00ca}},	// [1510] _थोड्, _těžb, bšíc, _בתהל,
   {{0x6b8d1e86,0xf9c70938,0x6d4f1e87,0x39580233}},	//   rrag, ищен, _wica, _burs_,
   {{0x39581e88,0x6d4f1e89,0x6b8d1e8a,0x7cf80503}},	//   _curs_, _tica, srag, _dírb,
   {{0x39581e8b,0x611201d3,0x69c100e8,0x00000000}},	//   _durs_, tāli, _šles, --,
   {{0x7d0d00a5,0x2366022e,0x00000000,0x00000000}},	//   mias, _ntoj_, --, --,
   {{0x39581e8c,0x442f1e8d,0x7cf80076,0x611201d3}},	//   _furs_, _ryg_, _víre, rāli,
   {{0xa5090396,0x442f1e8e,0x39580141,0xfc3f0503}},	//   лека_, _syg_, _gurs_, _mbím_,
   {{0x7d0d004b,0x61360103,0x201e00d3,0x92c30033}},	//   nias, gáll, ştii_, _একে_,
   {{0x57f5001f,0xe3b10037,0x24860117,0x44391e8f}},	//   _упат, سرة_, _ddom_, ås_,
   {{0x81e200c7,0x7d0d1e90,0x61360b0b,0x6d4400a5}},	//   _নেই_, hias, tálo, zmia,
   {{0x7e7c0088,0x6d440150,0xdbdc0031,0x2b5900b3}},	//   varp, ymia, všíc, _lusc_,
   {{0x5f05033a,0x6136045e,0x387d0150,0x3f6a0291}},	//   होस्_, rálo, nawr_, лимо_,
   {{0x7e7c1e91,0x320b0034,0x442f0a60,0xdbdc0a7f}},	//   tarp, ńcy_, _uyg_, tšíc,
   {{0x613d1e92,0x7529029a,0x3f5d00fe,0xc8f41e93}},	//   véle, loez, _dìu_, _आत्म_,
   {{0x61461e94,0xdbdc025b,0x7e7c1e95,0x51950037}},	//   _лека, ršíc, rarp, _العذ,
   {{0x3d08009d,0x7d0d1e96,0x2b59002b,0x2a781e97}},	//   _सगळे_, gias, _busc_, _serb_,
   {{0x6d441e98,0xdbdc025b,0x4aaa1a6d,0x39580141}},	// [1520] rmia, pšíc, лкан_, _surs_,
   {{0x3f8204a3,0x6d441e99,0x61360103,0xaad2045f}},	//   msku_, smia, záll, साइक,
   {{0x7cf808ec,0x7d0d1e9a,0xc87907aa,0x2b590090}},	//   _círc, bias, _beş_, _eusc_,
   {{0x273200d3,0x2b59028d,0x6f0e01c2,0x7c961e9b}},	//   mâni_, _fusc_, libc, _уроц,
   {{0x3f821e9c,0x09e00081,0x6136111c,0x02b70296}},	//   nsku_, _যেখা, váll, _असून,
   {{0xb8ef0d0b,0x3ce00128,0xe3e80018,0x3f821e9d}},	//   _वो_, ljiv_, یکشن_, isku_,
   {{0xceb300a1,0x9f4f004d,0x3958029a,0x61360103}},	//   פיה_, _ågå_, _uurs_, táll,
   {{0xdb1d0149,0x18a31e9e,0x3ce00995,0x4d7b0142}},	//   _ersä, _насм, njiv_, ארקע,
   {{0x3f8203ce,0x2418055b,0xe73a0396,0xbee80096}},	//   jsku_, ропы_, _беа_, _ऐकून_,
   {{0x3f82005f,0x3f5d00de,0x27f9007a,0x2bc90d61}},	//   dsku_, _rìu_, _üsna_, रिता,
   {{0xd2500a09,0x7529010a,0x00000000,0x00000000}},	//   بند_, boez, --, --,
   {{0x3a370054,0x463b00c1,0x61360103,0xca3700ca}},	//   מרים_, _געבע, lálj, מניה_,
   {{0x39460623,0x00000000,0x00000000,0x00000000}},	//   imos_, --, --, --,
   {{0x61360018,0xdb1d0161,0x28cf1e9f,0x2b5900ee}},	//   nálj, _essê, _सोनि, _rusc_,
   {{0xc27b07a6,0x2b5900e7,0x7d0d1ea0,0x00000000}},	//   _גרוי, _susc_, tias, --,
   {{0xdb060018,0x3f821ea1,0xe21700d7,0x00000000}},	//   _eskü, bsku_, _לקוח_, --,
   {{0x212b1ea2,0x6eeb00a7,0xa2cd0096,0xdcf500e8}},	// [1530] moch_, _sübu, ताच्, luzī,
   {{0x629a1ea3,0x7d0d1ea4,0xda670080,0x39461ea5}},	//   ngto, sias, صائي, emos_,
   {{0xb9b51ea6,0x9962025b,0x7d0d1ea7,0xa2c0039d}},	//   تماع, _píše_, pias, _वसन्,
   {{0x38351ea8,0x212b1ea9,0x319b0142,0x63a20415}},	//   онер, noch_, רבאנ, _oqon,
   {{0x656800dd,0x7d1d01c0,0x6fc90285,0x00000000}},	//   _atdh, _ijss, िटिं, --,
   {{0x212b1eaa,0x3cef0096,0x85b90037,0x52b70285}},	//   hoch_, _इकडे_, لابس_, _असेस,
   {{0x2d831eab,0x212b0181,0x057900e3,0x19941eac}},	//   nsje_, koch_, جمعة_, _наря,
   {{0x3f820188,0x2d8301c0,0x212b0031,0x6ab7016d}},	//   ysku_, isje_, joch_, lexf,
   {{0x212b1ead,0x290f1eae,0x75291eaf,0x7ae7023e}},	//   doch_, miga_, roez, _kojt,
   {{0x290f018d,0xf6f50159,0x13090084,0xdb1d0149}},	//   liga_, _بزرگ, рной_, _ursä,
   {{0xf7480080,0x7ae70559,0x2d83029a,0x63a20415}},	//   _اللي_, _mojt, jsje_, _eqon,
   {{0x3f8202e6,0x290f1eb0,0xa4f700cd,0x7ae7023b}},	//   tsku_, niga_, _دکتر_, _lojt,
   {{0x3f840343,0x61360018,0x2d83029a,0x6ef000bc}},	//   ému_, lálk, esje_, _häbi,
   {{0x3f821eb1,0x290f1eb2,0x68f801d3,0x7cea003e}},	//   rsku_, higa_, īvdi, _nýrr,
   {{0xdd920241,0x290f1eb3,0xddc30012,0x212b0031}},	//   ظور_, kiga_, мбри, boch_,
   {{0x3f821419,0x4c6a0b3b,0x212b1eb4,0x611201d3}},	//   psku_, риан_, coch_, tālu,
   {{0x290f1eb5,0x6ef0007a,0x63bb1eb6,0x2d83029a}},	// [1540] diga_, _läbi, nwun, asje_,
   {{0x2d9100a5,0xdcfc00d9,0x80d8009d,0x60c41eb7}},	//   brze_, turē, यावे, _haim,
   {{0x60c41eb8,0xfce61eb9,0x3eb81eba,0x409300cd}},	//   _kaim, _доно, mert_, _علیر,
   {{0x63bb00ac,0xeb9a1824,0x2d981ebb,0x290f1ebc}},	//   kwun, _ким_, mure_, giga_,
   {{0x39461ebd,0x60c41ebe,0xdb0404e2,0x394000d9}},	//   rmos_, _maim, ntië, ķis_,
   {{0x3946132d,0x60c41ebf,0x6b841ec0,0x3eb81ec1}},	//   smos_, _laim, msig, nert_,
   {{0x2d981ec2,0x290f1ec3,0x6b841ec4,0x77691ec5}},	//   nure_, biga_, lsig, _etex,
   {{0x443d02e2,0x3eb801bf,0x290f1ec6,0x60d6010a}},	//   _bzw_, hert_, ciga_, _nnym,
   {{0x3eb81ec7,0x6b841ec8,0xa6860318,0x14a60af1}},	//   kert_, nsig, _млад, क्षण,
   {{0x61360018,0x2d981ec9,0x212b01bf,0xe73a1eca}},	//   lálh, kure_, woch_, _тез_,
   {{0xd62a0084,0x3eb81ecb,0x60c41ecc,0x629a0abf}},	//   _тоже_, dert_, _baim, rgto,
   {{0x60c40441,0x613d0088,0x61360018,0xdb1d0428}},	//   _caim, féla, nálh, _essè,
   {{0x60c41ecd,0x3eb81ece,0x6b841197,0x212b1ecf}},	//   _daim, fert_, jsig, roch_,
   {{0x6b841ed0,0x290f0198,0x2d83029a,0x3eb801b4}},	//   dsig, ziga_, tsje_, gert_,
   {{0x290f1ed1,0x7ae71ed2,0x2d981ed3,0x2d851ed4}},	//   yiga_, _rojt, gure_, éle_,
   {{0x290f1ed5,0x6b84008c,0x2d831ed6,0x7cf100f2}},	//   xiga_, fsig, rsje_, _kåri,
   {{0x20020067,0x69de1ed7,0x290f1ed8,0x6b841ed9}},	// [1550] czki_, expe, viga_, gsig,
   {{0x3eb800ee,0xdb0400fd,0x2d9805bd,0x80a709c4}},	//   cert_, ntiè, bure_, ट्रे,
   {{0x7ae71eda,0x80b000c7,0x6b841edb,0x6d351edc}},	//   _vojt, য়ার্, asig, _неоф,
   {{0x52b71edd,0x6b84008a,0x63670220,0x02b709a1}},	//   _अस्स, bsig, nčný, _अस्न,
   {{0x290f1ede,0x3f991edf,0x69ce1ee0,0x6b84008a}},	//   riga_, nusu_, _erbe, csig,
   {{0x290f1ee1,0xb05b1ee2,0x00000000,0x00000000}},	//   siga_, ddäm, --, --,
   {{0x3f991ee3,0x290f068d,0x2bc90c9c,0x7cf800b6}},	//   husu_, piga_, रिवा, _mírn,
   {{0xd5ae00e3,0x61360146,0x3f991ee4,0x7bcf007e}},	//   افي_, rálk, kusu_, _krcu,
   {{0x2d981ee5,0x48fa00c1,0x3ea10037,0xdb1d1ee6}},	//   zure_, _פּלא, _ocht_, _assé,
   {{0x61361ee7,0x60c41ee8,0x613d1ee9,0x68e91eea}},	//   máli, _saim, véla, _hoed,
   {{0x3eb81eeb,0x60c41eec,0x80d8030b,0x68fb1eed}},	//   vert_, _paim, याले, _klud,
   {{0x3ea11eee,0x3eb802e2,0x6b841eef,0x443d0034}},	//   _acht_, wert_, ysig, _tzw_,
   {{0x68e91570,0x26c502e8,0xe28e1ef0,0x3eb81ef1}},	//   _moed, _kalo_, _па_, tert_,
   {{0x2d981ef2,0x26c50889,0x60c41ef3,0x3eb80364}},	//   ture_, _jalo_, _waim, uert_,
   {{0x26c50954,0x62811ef4,0x60c41ef5,0x57b800a5}},	//   _malo_, malo, _taim, _इन्ह,
   {{0x3ea11ef6,0x3eb802ec,0xab6604d9,0x26c50256}},	//   _echt_, sert_, звал, _lalo_,
   {{0x2d981ef7,0x2fc01ef8,0x3f9903e0,0x212001dc}},	// [1560] sure_, _usig_, cusu_, _ijih_,
   {{0x2d98013d,0x6b841ef9,0x26c503e1,0xfd1f0065}},	//   pure_, rsig, _nalo_, _ejì_,
   {{0x68fb1efa,0x68e902ae,0x14bd1efb,0xdb04037a}},	//   _blud, _boed, ्याण, ntié,
   {{0x7e7e1efc,0x68e91efd,0x68fb00f0,0x26c50188}},	//   _hepp, _coed, _clud, _aalo_,
   {{0x7e7e0088,0x26c51efe,0x68e2003d,0x68e90150}},	//   _kepp, _balo_, rjod, _doed,
   {{0x6d5e1eff,0x6281042d,0xf1db00a8,0x26c51f00}},	//   _kupa, jalo, यमान, _calo_,
   {{0x62811f01,0xbb431f02,0x69da0220,0x7e7e1f03}},	//   dalo, _черк, _štef, _mepp,
   {{0x68e91f04,0x7e7e1f05,0x6d5e1f06,0x68fb1f07}},	//   _goed, _lepp, _mupa, _glud,
   {{0x6d5e1f08,0x26c51f09,0x6136124d,0x38660072}},	//   _lupa, _falo_, cáli, mcor_,
   {{0x62811f0a,0xe3af1f0b,0x26c51f0c,0x98b8013f}},	//   galo, اري_, _galo_, _kurį_,
   {{0xd48f1f0d,0xb5ca1673,0xdceb0a9e,0xa50a1f0d}},	//   _пр_, _دوام_, _žiča, _лежа_,
   {{0x26c51f0e,0x3f991f0f,0x64a6004b,0x63a400ae}},	//   _zalo_, tusu_, _хада, _ţinu,
   {{0x6d5e1f10,0x7e7e0451,0xe5051f11,0x255501d3}},	//   _aupa, _bepp, _تبلي, _tālr_,
   {{0x628a01c5,0x6d5e1f12,0x7e7e1f13,0x3f991f14}},	//   _udfo, _bupa, _cepp, rusu_,
   {{0xa2a1009d,0x3f991f15,0x7e7e1f16,0x1df80109}},	//   _खात्, susu_, _depp, перы_,
   {{0x291c1f17,0x5d541bd1,0x6d5e00d8,0x00000000}},	//   éval_, екст, _dupa, --,
   {{0x68e902e0,0x201e0b88,0xd0080831,0xb05b007b}},	// [1570] _roed, ştir_, _неће_, hdäk,
   {{0x68fb00d9,0x7cf80018,0x79850201,0x7e7e0036}},	//   _slud, _hírl, tshw, _gepp,
   {{0x68fb1f18,0x68e91f19,0x6d5e1f1a,0x26c50131}},	//   _plud, _poed, _gupa, _ralo_,
   {{0x26c51114,0xf99000b1,0x61361f1b,0x7e7e1f1c}},	//   _salo_, ابل_, táli, _zepp,
   {{0x2b9314df,0x68e904ee,0x37ab1e54,0x7e7e0412}},	//   _سیاس, _voed, стен_, _yepp,
   {{0x68e90a9f,0x61361f1d,0x62810072,0x657a00eb}},	//   _woed, ráli, xalo, _bwth,
   {{0x68e91f1e,0x273200ae,0x61361f1f,0x7cf8037a}},	//   _toed, vânt_, sáli, _oírl,
   {{0x68fb026a,0x61361f20,0x6d4a028d,0x26c51f21}},	//   _ulud, páli, _èfat, _walo_,
   {{0x26c51f22,0xa2a1022d,0x7f5f003d,0x25a701c0}},	//   _talo_, _खाद्, _nuqq, stnl_,
   {{0x21cc02c6,0x7bcd1f23,0x657a00eb,0x613601f9}},	//   _běh_, ivau, _fwth, nálv,
   {{0x387f000b,0x68430032,0x63a4020a,0x7e7e0dd8}},	//   _keur_, _fìdí, _ţint, _repp,
   {{0x62811f24,0x6d5e1f1a,0xdb0405e6,0x7e7e1f25}},	//   salo, _rupa, rtié, _sepp,
   {{0x6d5e1f26,0x387f1f27,0xe8df0023,0x73e4004d}},	//   _supa, _meur_, _nhọn_, _поїз,
   {{0x387f04ea,0x6281041c,0x56b50142,0x00000000}},	//   _leur_, qalo, ופֿן_, --,
   {{0x63a91f28,0x6da30aec,0x00000000,0x00000000}},	//   lten, кира, --, --,
   {{0x249f0102,0x20561b70,0x7cf81f29,0x387f1f2a}},	//   ngum_, _отпр, _víro, _neur_,
   {{0xe8df00ef,0x7e7e1f2b,0x3ceb00b3,0x38c600c6}},	// [1580] _chọn_, _tepp, _docv_, _jūrų_,
   {{0x63a91f2c,0x6d5e1f2d,0xc31f0033,0xf1b10179}},	//   iten, _tupa, _নীতি_, _जहान,
   {{0x63a91f2e,0x80a50442,0x996500f3,0x6d5e0270}},	//   hten, _कामे, етіл, _uupa,
   {{0x63a91f2f,0x00000000,0x00000000,0x00000000}},	//   kten, --, --, --,
   {{0x387f1f30,0x38661f31,0x2ca00124,0x6d4600bc}},	//   _deur_, rcor_, mgid_, _ihka,
   {{0x38661f32,0x61360088,0xdcfc0138,0x291d010a}},	//   scor_, málu, turė, anwa_,
   {{0x63a9002d,0x941801d4,0xceb300a1,0x28cf0789}},	//   eten, ərə_, דיו_, _सोवि,
   {{0x387f1f33,0x2ca01f34,0x63a91f35,0x6128008b}},	//   _geur_, ngid_, ften, nıld,
   {{0x63a91f36,0x77910281,0x2ca000aa,0x69e300ae}},	//   gten, _مینا, igid_, ăteş,
   {{0x69c80072,0x7cf11842,0x2732020a,0x387f0381}},	//   _ádes, _hårt, râns_, _zeur_,
   {{0x6128026a,0x61151f37,0x2b581f38,0x00000000}},	//   kıld, едну, _mirc_, --,
   {{0x63a91f39,0x160700a8,0x00000000,0x00000000}},	//   bten, _वेटर_, --, --,
   {{0x63a91f3a,0xa2940c10,0x7cf10212,0x6128013c}},	//   cten, _залі, _mårt, dıld,
   {{0x44261f3b,0x2fd21e8f,0x7cf80503,0x6d461f3c}},	//   _ixo_, _dryg_, _dírm, _ahka,
   {{0x6d460167,0x9e341689,0x929b00ca,0x5e5800ae}},	//   _bhka, верч, _ויות, диря_,
   {{0x2b581f3d,0xa2d6009f,0x2ca00a4b,0x25df0285}},	//   _airc_, बाक्, ggid_, कमती_,
   {{0x2b5800c4,0x8aa71f3e,0x2fd203a8,0xf09f00ee}},	// [1590] _birc_, дред, _gryg_, siàs_,
   {{0x2d85058a,0x7bcd032c,0xab94004d,0x00000000}},	//   áles_, rvau, тифі, --,
   {{0x63a91f3f,0x387f0257,0x7bcd007b,0xed6400d4}},	//   zten, _peur_, svau, raží_,
   {{0x63a91f40,0xf77100ab,0x09b10081,0x2b580124}},	//   yten, هات_, ছিলা, _eirc_,
   {{0x6d4d1f41,0x2b580072,0x387f0381,0x00000000}},	//   mmaa, _firc_, _veur_, --,
   {{0xd2461f42,0x6d4d1f43,0x61360018,0xc87900ae}},	//   _من_, lmaa, lált, _roşu_,
   {{0x44260131,0x6d4d1f44,0xa8a71d8a,0x00000000}},	//   _axo_, omaa, _орак, --,
   {{0x6d4d1f45,0x61360018,0xe3c80023,0xc9841f46}},	//   nmaa, nált, _bự_, _јури,
   {{0x38341f47,0x249f1f48,0x752200e7,0xe3c80023}},	//   _антр, rgum_, _djoz, _cự_,
   {{0xe3c80028,0x8af00092,0x644200e7,0x6d4d0188}},	//   _dự_, qqət, _dzoi, hmaa,
   {{0x44260da7,0x6d4d1183,0x612803e0,0xa0a60036}},	//   _exo_, kmaa, yıld, нанд,
   {{0xcea9004f,0x248400b3,0x6128013c,0x00000000}},	//   _לי_, camm_, xıld, --,
   {{0x6d4d1f49,0x6136109d,0xdb1d1f4a,0x251a0142}},	//   dmaa, dált, _assí, _צונא,
   {{0x6d4601e5,0x65611f4b,0x6d4d112f,0x201e020a}},	//   _shka, _kulh, emaa, ăti_,
   {{0x65610396,0xe81600a5,0x61280587,0x61360850}},	//   _julh, _देना_, tıld, fált,
   {{0x656100c9,0x6d4d1f4c,0x6b961f4d,0x2fd202b6}},	//   _mulh, gmaa, tryg, _tryg_,
   {{0x612807aa,0xf1c90019,0x2ca01f4e,0xe7bf0179}},	// [15a0] rıld, _hạ_, rgid_, _शैलप,
   {{0x6d4d1f4f,0x6b960537,0x20ac06eb,0x61280233}},	//   amaa, rryg, ट्रध, sıld,
   {{0x753b025b,0x61280587,0x499a1c32,0x91fc00e8}},	//   kluz, pıld, ятая_, ecāj,
   {{0x6d4d008a,0x6d4600c2,0xf1c90023,0x57a608f9}},	//   cmaa, _uhka, _mạ_, ешка,
   {{0xf1c90019,0xe73a1c4c,0x753b1f50,0x69c302b6}},	//   _lạ_, пед_, dluz, æner,
   {{0x8f9b00c1,0xe5c61ada,0x65611f51,0x7d041f52}},	//   פיצי, есио, _bulh, lhis,
   {{0xe3c800ef,0xaa4308d9,0x7cf1040f,0xf1c900de}},	//   _sự_, _берл, _tårt, _nạ_,
   {{0x2d9804c3,0x656103a9,0xe8b503e0,0x273b0023}},	//   irre_, _dulh, mışı, hênh_,
   {{0xd90d037f,0xe8b508bb,0x24841f53,0x00000000}},	//   _بین_, lışı, ramm_, --,
   {{0xf1c900de,0x55e6004d,0x78a21f54,0x23d209a1}},	//   _bạ_, _позб, lgov, तिबद,
   {{0xe8b50740,0x7d040201,0x61361ee7,0x9f4400b6}},	//   nışı, khis, jáls, ámý_,
   {{0xe3c800ef,0x78a20618,0x7d041f55,0xf1c900de}},	//   _tự_, ngov, jhis, _dạ_,
   {{0x66f4007d,0x04570080,0x7d041f56,0x65611f57}},	//   _अवाक_, _كلمة_, dhis, _zulh,
   {{0x3ea50018,0x1ee700cd,0xe8b5026a,0x6abe0027}},	//   ült_, روزی_, kışı, jepf,
   {{0x7bc600dd,0x6d4d1f58,0xf1c900fe,0x6abe0113}},	//   _asku, tmaa, _gạ_, depf,
   {{0x7d041f59,0x23b71362,0x6d4d1f5a,0xd904001c}},	//   ghis, _अहमद, umaa, _طی_,
   {{0x6d4d1f5b,0x61361823,0x628e0034,0x00000000}},	// [15b0] rmaa, rált, óbow, --,
   {{0x6d4d1f5c,0x0a681f5d,0xadf501b3,0xab18004d}},	//   smaa, ерци_, _апош, нієї_,
   {{0x7bc603f3,0x7d041f5e,0xf1c900de,0x6d4d1044}},	//   _esku, bhis, _xạ_, pmaa,
   {{0x7d041f5f,0x38c90018,0x6d4d0188,0x7cf11f60}},	//   chis, بائی_, qmaa, _vårs,
   {{0x65611f61,0xa2a1052c,0x00000000,0x00000000}},	//   _sulh, _खाल्, --, --,
   {{0x7aee1f62,0x00000000,0x00000000,0x00000000}},	//   _gobt, --, --, --,
   {{0x50b10e50,0x656100dc,0x2bc90386,0x00000000}},	//   जभाष, _qulh, रिका, --,
   {{0x69c71f63,0x78a200e7,0x09e70033,0x00000000}},	//   _isje, cgov, পনদা, --,
   {{0x3f8b00a5,0xd4680037,0x753b1f64,0x00000000}},	//   jscu_, رحيم_, rluz, --,
   {{0x466b1f65,0x77900018,0xdcfc01d3,0x69d50034}},	//   _храм_, _ایوا, turī, _krze,
   {{0x3f8b1f66,0x7d041f67,0x76440022,0x65940077}},	//   escu_, yhis, ƙiya, _баху,
   {{0x69d50d12,0xdddc0095,0x7d041f68,0xf1c900fe}},	//   _mrze, jarš, xhis, _vạ_,
   {{0xaca30134,0xc95200c1,0x03a500d3,0xdddc0141}},	//   _chọb, ימט_, _рило, darš,
   {{0x69c7029b,0x78a202e6,0x69d50034,0xf1c900de}},	//   _osje, zgov, _orze, _tạ_,
   {{0x7d041f69,0x2d8c1f6a,0x386d1f6b,0x98ad0090}},	//   this, éde_, _ofer_, _gieħ_,
   {{0x62831f6c,0x7aee0428,0xbddc0065,0x6ef9009c}},	//   _heno, _sobt, _aṣòf, _lìbh,
   {{0x628303a9,0x7aee01fa,0x7d040c2e,0x69c71f6d}},	// [15c0] _keno, _pobt, rhis, _asje,
   {{0x7d041f6e,0x62831f6f,0x386d1f70,0x799e0239}},	//   shis, _jeno, _afer_, tupw,
   {{0x62831535,0x7d041f71,0x1d0a01c9,0x7cf81f72}},	//   _meno, phis, _жени_, _líri,
   {{0xe8b508bb,0x69d50034,0x2900016d,0x00000000}},	//   rışı, _drze, óia_, --,
   {{0x7bc61f73,0x98a31612,0x69d51f74,0x66e61f75}},	//   _usku, риче, _erze, кода,
   {{0x62831f76,0xa3d51f77,0x47330426,0x799e0350}},	//   _neno, हिन_, аніс, pupw,
   {{0x27e0002d,0x69d500a5,0x69d802b6,0x09e316bd}},	//   ţin_, _grze, æved, _корн,
   {{0x3f4f02a1,0xaae000b6,0x00000000,0x00000000}},	//   _jżur_, नावक, --, --,
   {{0x62831f78,0x7d0300d3,0x7cf80131,0x00000000}},	//   _beno, _înse, _círi, --,
   {{0x7cf80037,0xe6c50037,0x80a50006,0x9af00022}},	//   _díri, _متمي, _काहे, _ƙaƙa_,
   {{0x26de1f79,0xe8161362,0x31c3008f,0x320901c2}},	//   _into_, _देता_, асяв, _ƙaya_,
   {{0x29061f7a,0x26cc1f7b,0x7cf80037,0x62831f7c}},	//   nhoa_, _hado_, _fíri, _eeno,
   {{0x26cc1f7d,0x4394168c,0x29061f7e,0xef1f173c}},	//   _kado_, _салс, ihoa_, ssüm_,
   {{0x62831f7f,0x044308c3,0xe5710103,0x80a5077d}},	//   _geno, _течн, _خطے_, _कावे,
   {{0x62881f80,0x26cc1f81,0xdddc025b,0x8233110a}},	//   mado, _mado_, tarš, _پروا,
   {{0x26cc0b0b,0x6d580036,0x3ead00d2,0x00000000}},	//   _lado_, _èval, řet_, --,
   {{0x63a00808,0x7c841f82,0x2b4a0013,0x26de00ca}},	// [15d0] numn, русе, _bhbc_, _onto_,
   {{0x69d51f83,0x62881f84,0x26cc08a8,0x613d0257}},	//   _prze, nado, _nado_, déli,
   {{0x612807aa,0x60cd1f85,0xf9c7008f,0x63a00580}},	//   lıla, _kaam, ъщан, humn,
   {{0x63a01f86,0x60cd1f87,0xf1b300c1,0xa3d51f88}},	//   kumn, _jaam, יסע_, हिम_,
   {{0x60cd1f89,0xb8cb0e50,0x26cc068d,0x61281f8a}},	//   _maam, _खा_, _bado_, nıla,
   {{0x69d50067,0x62881f8b,0xa3d6152c,0x6d5d1f8c}},	//   _trze, jado, ाटन_, _hisa,
   {{0x26cc0d9f,0x7cf81f8d,0xdb04016d,0x69c704e9}},	//   _dado_, _síri, stiã, _usje,
   {{0x23ab01c5,0x62831f8e,0x29061f8f,0x6d5d0051}},	//   tøj_, _seno, choa_, _jisa,
   {{0x6b8d0303,0x62831a49,0x26cc1f90,0x63a01f91}},	//   nsag, _peno, _fado_, gumn,
   {{0x6d5d05a7,0x6128008e,0x26cc1f92,0x7cf81f93}},	//   _lisa, dıla, _gado_, _víri,
   {{0x60cd1f94,0x62830220,0x05960260,0x5ed20033}},	//   _baam, _veno, _مانگ, _সকলে,
   {{0x6d5d08c5,0x63a0019f,0x60cd1f95,0xd5fa006e}},	//   _nisa, bumn, _caam, _אפער,
   {{0xe2991b60,0x61280233,0x60cd1f96,0x80a506eb}},	//   _зал_, gıla, _daam, _कारे,
   {{0x62881f97,0x6d5d0af0,0x6da60012,0x339200e3}},	//   cado, _aisa, лига, _الوز,
   {{0x6d5d1098,0x60cd1f98,0x78a900cc,0xb17600de}},	//   _bisa, _faam, _ocev, _trượ,
   {{0x6d5d1f99,0x60cd1f9a,0x6128071d,0x6b8d01cd}},	//   _cisa, _gaam, bıla, fsag,
   {{0x61281f8a,0x6d5d14a5,0x6b8d1f9b,0xeb971e79}},	// [15e0] cıla, _disa, gsag, лит_,
   {{0x78a90328,0x2bc91388,0x4e361f9c,0x999105db}},	//   _acev, रिजा, _معجز, _dzzž_,
   {{0x6d5d1f9d,0x2d95020f,0x60cd1f9e,0x443d03a8}},	//   _fisa, _кряс, _yaam, _lyw_,
   {{0x613d1f9f,0x6d5d1fa0,0xfce6188d,0x26cc1fa1}},	//   téli, _gisa, _сомо, _sado_,
   {{0x62881fa2,0xbcfb1fa3,0x0137006e,0x443d0172}},	//   yado, _diéd, אָגט_, _nyw_,
   {{0x62881fa4,0x613d1fa5,0x6d5d1fa6,0x36d41e46}},	//   xado, réli, _zisa, рокр,
   {{0xe1e71fa7,0x61280702,0x7d03002d,0x26cc0448}},	//   _اس_, zıla, _însc, _vado_,
   {{0x62881fa8,0x80d40775,0x443d02ad,0x6d5d008a}},	//   wado, _बोले, _byw_, _xisa,
   {{0x62880b0b,0x29041fa9,0x60cd0837,0x28e11317}},	//   tado, _ilma_, _raam, फारि,
   {{0xc8790491,0x443d00f0,0xadf600c3,0xf2c60231}},	//   _inşa_, _dyw_, ीनान_, усин,
   {{0x63a00995,0x22581faa,0x60cd1fab,0x38690542}},	//   sumn, ärk_, _paam, žare_,
   {{0x612803a3,0x6b8d1fac,0x60cd026d,0x443d0150}},	//   tıla, ysag, _qaam, _fyw_,
   {{0x62880979,0x60cd1fad,0x33f615af,0x6b4b042c}},	//   pado, _vaam, _حساس, lüge,
   {{0x612807d1,0x6d5d0efd,0x60cd1fae,0x6b8d00d6}},	//   rıla, _sisa, _waam, vsag,
   {{0x60cd1faf,0xbcfb0257,0x69da1206,0x6b4b01bf}},	//   _taam, _liée, _šten, nüge,
   {{0x61280b88,0x2fc9023e,0x6b8d1fb0,0x6d5d1fb1}},	//   pıla, _tsag_, tsag, _qisa,
   {{0x6d5d1fb2,0x5b151fb3,0x443d023e,0x212903a9}},	// [15f0] _visa, амат, _xyw_, _ijah_,
   {{0xa3d51fb4,0x6d5d1fb5,0x6b8d1fb6,0x78a90036}},	//   हित_, _wisa, rsag, _scev,
   {{0x6b8d1fb7,0x6d5d1fb8,0x06cd0081,0x64b40096}},	//   ssag, _tisa, লামি, ंभाळ,
   {{0xc9130081,0x6b8d1fb9,0xd7d5001f,0xe8160ff9}},	//   িক্ত_, psag, ижењ, _देहा_,
   {{0xdb0409d3,0x21290381,0x75dc044c,0x00000000}},	//   stiá, _mjah_, _lăză, --,
   {{0x6b4b02e2,0x443d00f0,0x29041fba,0x00000000}},	//   füge, _ryw_, _elma_, --,
   {{0x6ead000d,0xba740068,0x256a0441,0x5a4408a1}},	//   _जानु, _چاہت, _cùl_, _гэта,
   {{0x2d9e192a,0xe8161fbb,0xdff700c3,0xf8c91981}},	//   šteg_, _देवा_, ुनाद_, _रसिय,
   {{0xf77000bf,0xab5b00aa,0x320c0031,0x67d400ae}},	//   _فال_, _psüh, ezdy_, _лоту,
   {{0x212900a4,0x98140867,0x82f5129c,0x57f40284}},	//   _ajah_, _طبقا, рчиц, _упут,
   {{0x394d022e,0xf8c909c4,0x75dc078e,0x00000000}},	//   _khes_, _रसाय, _căză, --,
   {{0x33d50426,0x2486028d,0xa3d50034,0x628e11e9}},	//   _вікт, _geom_, हिद_, óbor,
   {{0x95541e49,0x212902ef,0xa93600ca,0x320c0034}},	//   _اخلا, _djah_, שטרה_, azdy_,
   {{0xe299075f,0xa85600a1,0x394d1097,0x23d203b3}},	//   _рак_, יירה_, _lhes_, तिरद,
   {{0x2cb901b9,0x21a50036,0x764e0094,0x00000000}},	//   _bbsd_, _тийм, _úbyt, --,
   {{0x25ed0b5f,0xa3c90034,0x395f1fbc,0xe80800b6}},	//   _अपनी_, _ऊना_, _nius_, वनमा_,
   {{0xed571fbd,0x81cc0081,0xcb6700d3,0x6b4b1fbe}},	// [1600] рот_, রমণ_, иате_, züge,
   {{0x316710f4,0x0d86182e,0x1e961fbf,0x00000000}},	//   _kunz_, _клон, _трир, --,
   {{0x395f02e7,0x6f1c1fc0,0xfc3f0032,0x7e9b00ca}},	//   _bius_, mirc, _eyí_, _בסיו,
   {{0x613d0a61,0x6f1c0036,0x394d030a,0x00000000}},	//   bélu, lirc, _ches_, --,
   {{0x395f0428,0x67d407c7,0x394d0113,0xb8160442}},	//   _dius_, солу, _dhes_, _देशम_,
   {{0x7cf81fc1,0x6f1c1fc2,0x971304a1,0xb8fd0285}},	//   _víru, nirc, оміц, _थो_,
   {{0x4420002d,0x395f1fc3,0x95ca1fc4,0x55060012}},	//   _ţi_, _fius_, тула_, ичиа,
   {{0x395f0036,0xc44800d1,0x00000000,0x00000000}},	//   _gius_, هیان_, --, --,
   {{0x6f1c1fc5,0xdcef0995,0x14a700c3,0x00000000}},	//   kirc, žeće, _गारण, --,
   {{0x6f1c0022,0x21291fc6,0x00000000,0x00000000}},	//   jirc, _sjah_, --, --,
   {{0x8ad9006e,0xd62700c2,0x98af01d3,0x7ad90142}},	//   אַרפ, _кофе_, logā_, אַרה,
   {{0x67381fc7,0x25be0a4b,0x656801ec,0x236600c6}},	//   lovj, _iptl_, _iudh, _tuoj_,
   {{0x65681fc8,0x6f1c0d2a,0x9f59014b,0x85350103}},	//   _hudh, firc, lysé_, _اونچ,
   {{0x65681fc9,0x31670036,0xe7f90287,0x00000000}},	//   _kudh, _funz_, ्नता_, --,
   {{0x51860ff1,0xe2970291,0x656800cd,0x31670227}},	//   _тула, _тај_, _judh, _gunz_,
   {{0x65681fca,0x6f1c036b,0x21290372,0x00000000}},	//   _mudh, airc, _ujah_, --,
   {{0x2d5814fa,0x395f0428,0x656801b9,0x67381fcb}},	// [1610] рить_, _rius_, _ludh, kovj,
   {{0x67380fa3,0x21390052,0x65681183,0xaaac09c4}},	//   jovj, losh_, _oudh, _चाणक,
   {{0x656801dc,0x67381fcc,0x9c830141,0x7c2911dc}},	//   _nudh, dovj, _ščuk, _žerd,
   {{0xa3d605cd,0xbcfb0113,0x21390052,0x00000000}},	//   ाटा_, _diéc, nosh_, --,
   {{0x395f0428,0xb0aa0034,0x2d910034,0x2ca901d3}},	//   _vius_, _कासग, lsze_, mgad_,
   {{0x65681fcd,0x16a91346,0x67381fce,0xa3d510e9}},	//   _budh, увки_, govj, हिस_,
   {{0x394d1fcf,0x2139023b,0xc5d5097a,0xdcfb152c}},	//   _thes_, kosh_, сіль, _एकाध_,
   {{0x2ca91fd0,0x28cf121d,0x7af51fd1,0xb9250037}},	//   ngad_, _सोचि, _hozt, _افري,
   {{0x291d1ee3,0x261700b6,0x21391fd2,0x6f1c0233}},	//   miwa_, _भेरी_, dosh_, yirc,
   {{0x291d1ee3,0xddde1b32,0x73051057,0x6568005c}},	//   liwa_, _lepš, споз, _fudh,
   {{0xdb04001f,0x65681fd3,0x7af51fd4,0x2d910034}},	//   stiç, _gudh, _mozt, jsze_,
   {{0x291d0051,0x21391fd5,0x14ca00d1,0x00000000}},	//   niwa_, gosh_, _مهمی_, --,
   {{0xc50c00c1,0x9fd60033,0xb05b007b,0xa2d20f8f}},	//   _בלאָ, সঙ্গ, seän, _भोक्,
   {{0x65681783,0x291d1fd6,0x644b1fd7,0x84e5009f}},	//   _yudh, hiwa_, _izgi, कावट_,
   {{0x291d1ee3,0x6b50070a,0x78bb1fd8,0x7d0600d9}},	//   kiwa_, lägg, _obuv, _plks,
   {{0x291d0010,0x2ca90149,0x3c6601b3,0x3860007e}},	//   jiwa_, ggad_, скаг, žiri_,
   {{0x09b2110f,0x61281f8a,0x291d0010,0x6d4f1fd9}},	// [1620] ीब्य, nılm, diwa_, _dhca,
   {{0x2ca900f9,0x78bb04ff,0xbcfb020d,0x60c601f9}},	//   agad_, _abuv, _piéc, lekm,
   {{0x8db600d6,0x291d0051,0x6d4f009c,0x7af501ff}},	//   _успі, fiwa_, _fhca, _dozt,
   {{0x98a60a8e,0x6128026a,0x291d1fda,0x6d4f01b9}},	//   сиде, kılm, giwa_, _ghca,
   {{0x65681837,0x31b10018,0xc7a31fdb,0x6d441fdc}},	//   _sudh, ház_, зичк, mlia,
   {{0x61280092,0x6d441fdd,0x05d30096,0x78bb083e}},	//   dılm, llia, थिंब, _ebuv,
   {{0x386904a3,0x6d4402ad,0x291d1fde,0x67381fdf}},	//   žara_, olia, biwa_, rovj,
   {{0x53981031,0x69ce0188,0x291d1fe0,0x6d440076}},	//   авия_, _isbe, ciwa_, nlia,
   {{0x65680da3,0x2d850fb6,0x67380268,0x6d441fe1}},	//   _wudh, ález_, povj, ilia,
   {{0x6d441fe2,0x65681fe3,0x00000000,0x00000000}},	//   hlia, _tudh, --, --,
   {{0xe3af1b67,0x6d44013f,0x69da0087,0x21391fe4}},	//   وری_, klia, _štej, tosh_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x2d910067,0xb0aa000f,0x6d440150,0x2139023b}},	//   wsze_, _कारग, dlia, rosh_,
   {{0x291d1fe5,0xa3d51fe6,0x69dc1fe7,0x64420113}},	//   ziwa_, हिर_, _orre, _iyoi,
   {{0x7af51fe8,0x8cda009d,0x291d1fe9,0x2d851fea}},	//   _rozt, _पोहो, yiwa_, èle_,
   {{0x6d440465,0x2d911feb,0x656201c2,0x50671469}},	//   glia, rsze_, _jioh, _утка,
   {{0x69dc1fec,0x7af51fed,0x2ca91fee,0x69d802b6}},	// [1630] _arre, _pozt, rgad_, æven,
   {{0x2d9100a5,0x6d441fef,0x69dc1ff0,0xaa671ff1}},	//   psze_, alia, _brre, стак,
   {{0x291d0010,0x612803a3,0x7d0300ae,0xd8790037}},	//   tiwa_, zılm, _înso, لمات_,
   {{0x612807aa,0x628a0103,0x6ca700ba,0xe894004d}},	//   yılm, _lefo, _урож, заць,
   {{0x69dc1ff2,0x62981ff3,0x291d1ff4,0x7d0d1ff5}},	//   _erre, _odvo, riwa_, mhas,
   {{0x7d0d0068,0x291d1ff6,0xab5b0018,0xdb0d0037}},	//   lhas, siwa_, _csüt, otaí,
   {{0x24e90465,0xceb4040a,0xdb0d0037,0x442f0042}},	//   имки_, פיק_, ntaí, _sxg_,
   {{0x61280587,0x6562009c,0x78bb02a4,0x7d0d1ff7}},	//   tılm, _cioh, _ubuv, nhas,
   {{0x628a1ff8,0x1309049f,0x248d0131,0x00000000}},	//   _befo, иний_, raem_, --,
   {{0x612807d1,0x42251ff9,0xe2990859,0x56941ffa}},	//   rılm, ждов, јан_, _наут,
   {{0x90c602fd,0x7d0d1ffb,0x60c600d9,0x6d440150}},	//   обне, khas, tekm, ylia,
   {{0xf9920054,0x61281001,0x7bcf1ffc,0x320b00a5}},	//   ורט_, pılm, _oscu, ący_,
   {{0x7529002d,0x7d0d1ffd,0x6b500704,0x60c6026a}},	//   mnez, dhas, läge, rekm,
   {{0x26c70010,0xa3d60d39,0x628a1ffe,0x753b1fff}},	//   neno_, ाटर_, _gefo, louz,
   {{0x62812000,0x7bcf002d,0x6d442001,0x75292002}},	//   mblo, _ascu, tlia, onez,
   {{0x7d0d2003,0x62812004,0x26c72005,0x6d442006}},	//   ghas, lblo, heno_, ulia,
   {{0x8c432007,0x6d562008,0x6d442009,0x8eba00d3}},	// [1640] дете, rmya, rlia, _кынт_,
   {{0xb0aa14db,0x7bcf037a,0x98ad0031,0x753b0022}},	//   _काँग, _dscu, _cieľ_, houz,
   {{0x7d0d200a,0x26c7200b,0x764401c2,0x49ca0b21}},	//   bhas, deno_, ƙiyi, рлен_,
   {{0x7d0d00ac,0xdb0400e3,0x31ba00c1,0xd7fa002d}},	//   chas, ntiú, יזענ, иул_,
   {{0x765f01d4,0x7529200c,0x6281200d,0x6562200e}},	//   əyyə, dnez, kblo, _rioh,
   {{0x7d040084,0x26c7028d,0x7529200f,0x00000000}},	//   lkis, geno_, enez, --,
   {{0xb0aa2010,0x69dc2011,0xaa432012,0x20aa049d}},	//   _कांग, _urre, _жерл, _कांध,
   {{0x7d042013,0xa3d52014,0x00000000,0x00000000}},	//   nkis, हिं_, --, --,
   {{0x39462015,0x26c72016,0x628a0154,0x25e600c3}},	//   mlos_, beno_, _pefo, _झपकी_,
   {{0x394611ce,0x26c72017,0x20d70023,0x7d040e22}},	//   llos_, ceno_, _ủi_, hkis,
   {{0xd48f2018,0x7d042019,0xdb04034f,0xb5ca00d1}},	//   _ор_, kkis, guié, _خوام_,
   {{0x394602e2,0x657a0103,0x7d0d019f,0x3860031a}},	//   nlos_, _itth, xhas, žiru_,
   {{0x6281201a,0x00000000,0x00000000,0x00000000}},	//   bblo, --, --, --,
   {{0x62980106,0x6281201b,0xdb04201c,0xbcfb0143}},	//   _udvo, cblo, quiè, _cién,
   {{0x7d0d201d,0xf27b0054,0x394601b3,0xbcfb01dc}},	//   thas, _דרוש, klos_, _dién,
   {{0xdb0400e3,0x26c711d5,0x3946023e,0x80a5201e}},	//   ctiú, zeno_, jlos_, _काटे,
   {{0x7d0d201f,0x3946082b,0xdb0d00e3,0x00000000}},	// [1650] rhas, dlos_, staí, --,
   {{0x7d0d2020,0x657a0018,0x26c70042,0x394605e6}},	//   shas, _otth, xeno_, elos_,
   {{0xceb2193b,0x7d0401ad,0x7d0d2021,0xaaac00b6}},	//   _איי_, bkis, phas, _चारक,
   {{0x6b500149,0x39462022,0x7d042023,0xcdda00c1}},	//   väge, glos_, ckis, _פֿיר,
   {{0x26c72024,0x657a061d,0x60dc00c1,0x66e51c66}},	//   teno_, _atth, יקאנ, зола,
   {{0x628101c5,0x39460072,0xff7c006e,0x00000000}},	//   xblo, alos_, סטומ, --,
   {{0x26c70106,0x80ac02e8,0x39462025,0x7bcd2026}},	//   reno_, _झाले, blos_, lwau,
   {{0x61360068,0x39462027,0x6b5001bf,0x62810381}},	//   bály, clos_, räge, wblo,
   {{0x62812028,0x26c72029,0x753b0072,0x7529044c}},	//   tblo, peno_, rouz, rnez,
   {{0x13090ab3,0x753b02c6,0xcfd10033,0x77f900c3}},	//   сной_, souz, ামান, ्नीक_,
   {{0x7d040501,0x753b0995,0xbcfb037a,0xcb1200ca}},	//   ykis, pouz, _rién, גלי_,
   {{0x7bcd01c2,0xbcfb034f,0x00000000,0x00000000}},	//   kwau, _sién, --, --,
   {{0xb4d702d5,0x4aac0096,0x14ca001c,0xaaac0469}},	//   ायी_, _चालव, _دهنی_, _चालक,
   {{0x3f9e025b,0x657a0314,0xe7f31c65,0x63a90a4b}},	//   čtu_, _ytth, _आपना_, muen,
   {{0x7d04202a,0xdb0400fd,0xbcfb034f,0xc27a0327}},	//   tkis, quié, _vién, _פרקי,
   {{0x25710088,0x61fc02c3,0x41b20037,0xa01b01cd}},	//   _mál_, ärle, _أمير, mbön,
   {{0x7d04202b,0xfbdf0131,0x3f89030a,0x63a9202c}},	// [1660] rkis, _crê_, _gwau_, nuen,
   {{0x7d04202d,0xa3dc06ae,0x60d6202e,0xe8160034}},	//   skis, डित_, _haym, _देगा_,
   {{0x9d461da3,0x60d6202f,0x2c750174,0x63a90174}},	//   _неод, _kaym, _ụde_, huen,
   {{0x63a92030,0x7ae7023b,0x61360103,0xaa570076}},	//   kuen, _enjt, tály, سلنا_,
   {{0x39462031,0xe8160c8c,0x2efa01bf,0xdcf700ae}},	//   rlos_, _देखा_, _kopf_, şcăr,
   {{0x61360103,0x39462032,0x4e7a006e,0x00000000}},	//   rály, slos_, זאַצ, --,
   {{0x39462033,0x25710072,0x00000000,0x00000000}},	//   plos_, _cál_, --, --,
   {{0x399b00a1,0x2571030b,0x63a904c3,0x2907023b}},	//   _לילד, _dál_, fuen, ënat_,
   {{0x63a92034,0x2a6a0167,0x07a3001f,0x6b962035}},	//   guen, _kgbb_, _патн, nsyg,
   {{0xa3ab0067,0x877b0341,0x957c007f,0x257100da}},	//   गढ़_, _לאמי, _prąd, _fál_,
   {{0x29062036,0xa3b8023a,0xbcfb014b,0x00000000}},	//   okoa_, _चहक_, _biél, --,
   {{0x63a92037,0x29061d77,0x60d62038,0x644e00a7}},	//   buen, nkoa_, _caym, əbin,
   {{0x63a911c4,0x5f94013d,0xb9090134,0x60d62039}},	//   cuen, ният, _aghọ_, _daym,
   {{0x290f0216,0x957c007f,0x7d1d0206,0x00000000}},	//   zhga_, _trąd, _smss, --,
   {{0x2d9e02e6,0x29060084,0xb2bb00ca,0x00000000}},	//   šten_, kkoa_, _המור, --,
   {{0x6144001f,0x00000000,0x00000000,0x00000000}},	//   _пеја, --, --, --,
   {{0xa3d50067,0xe8df00fe,0x3c5800d3,0x00000000}},	// [1670] हिए_, _chờn_, зитэ_, --,
   {{0x290601ff,0x00000000,0x00000000,0x00000000}},	//   ekoa_, --, --, --,
   {{0x63a90634,0x60d60555,0x30a60103,0x00000000}},	//   zuen, _yaym, _علیہ, --,
   {{0x25e0048a,0x5fb1034c,0xdbcc0139,0x00000000}},	//   किनी_, _जमाल, _kòìp, --,
   {{0x2571203a,0x61360072,0x333e0062,0x63a901c8}},	//   _sál_, rálx, kotx_, xuen,
   {{0x290f11bc,0xb904203b,0x8579007b,0x29060062}},	//   shga_, _भो_, осит_, akoa_,
   {{0x69da0b27,0x20020034,0x00000000,0x00000000}},	//   _štev, zyki_, --, --,
   {{0x58d4203c,0x63a90a00,0xb4d70b89,0x6b4b01bf}},	//   _пост, tuen, ाये_, zügl,
   {{0x2be00c9c,0x68e9203d,0x29070138,0x195800c6}},	//   निया, _ined, ūnas_, _хаты_,
   {{0x68fb203e,0x63a9203f,0x68e90220,0x60d62040}},	//   _houd, ruen, _hned, _saym,
   {{0x68fb2041,0x80d70081,0x60d62042,0x68e92043}},	//   _koud, ধান্, _paym, _kned,
   {{0x200200a5,0x68fb2044,0x63a9037a,0x00000000}},	//   tyki_, _joud, puen, --,
   {{0x212218c4,0x63a92045,0xe2992046,0x68fb2047}},	//   rikh_, quen, _дал_, _moud,
   {{0x67232048,0x290602a7,0xbcfb0113,0x2002007f}},	//   ninj, zkoa_, _diém, ryki_,
   {{0xdd1c025b,0x68e92049,0x644f015c,0x60d6204a}},	//   _vážn, _oned, škić, _taym,
   {{0xdb0d01bf,0x68fb204b,0x2d840094,0x68e90172}},	//   traß, _noud, ďme_, _nned,
   {{0xab66083c,0x2efa042c,0xe3b90103,0x00000000}},	// [1680] двал, _topf_, ntű_, --,
   {{0x290d204c,0x68e9204d,0x6723083e,0x68fb0090}},	//   _alea_, _aned, jinj, _aoud,
   {{0x68fb1b59,0x68e90078,0x3ebe00bc,0x6b960537}},	//   _boud, _bned, õttu_, ssyg,
   {{0xc7c6204e,0x660300a5,0x68fb00fd,0xb4d7030b}},	//   дски, dynk, _coud, ायो_,
   {{0x68fb204f,0x29062050,0x4c3601b3,0x7b0901f9}},	//   _doud, rkoa_, _цэнт, ástó,
   {{0x290601e9,0x291f0063,0x68e92051,0xdddc007f}},	//   skoa_, _emua_, _ened, karż,
   {{0x68fb020d,0x7afc01ff,0xdd1d00d4,0x00000000}},	//   _foud, _iort, lášs, --,
   {{0x25a02052,0x7afc2053,0x68fb2054,0xe81f0b94}},	//   čil_, _hort, _goud, _मेवा_,
   {{0x67232055,0x68430ff5,0x644e0034,0x248f01ee}},	//   binj, _анта, ębio, _degm_,
   {{0x672304a3,0x68fb0ab2,0x7bc60174,0x00000000}},	//   cinj, _zoud, _mpku, --,
   {{0x36060604,0xbcfb0113,0x2d9e02c6,0x66e30b36}},	//   _تواف, _diéj, átel_, _јоха,
   {{0x7afc02a7,0x249d0350,0x7bc60381,0x26170961}},	//   _lort, _gdwm_, _opku, _भेटी_,
   {{0x7afc0185,0x2d9e02df,0x00000000,0x00000000}},	//   _oort, štel_, --, --,
   {{0x7afc1c8d,0x05c202d5,0x15f21073,0x00000000}},	//   _nort, _शहाब, _अपार_, --,
   {{0xa3d60e72,0x7bc601d3,0x6455007f,0xdb0d0131}},	//   ाटक_, _apku, ęzie, ltaç,
   {{0x506708c3,0x6ca42056,0x6b500212,0xa115001c}},	//   _отпа, круж, väga, _سوخت,
   {{0xdb0d0396,0x7afc0572,0x3b550012,0x68fb2057}},	// [1690] ntaç, _bort, екар, _roud,
   {{0x68fb2047,0x291f2058,0xdb0d0161,0x68e92059}},	//   _soud, _smua_, itaç, _sned,
   {{0x68fb205a,0x7afc205b,0x8c420233,0x00000000}},	//   _poud, _dort, öğre, --,
   {{0x2d8301c0,0xe7f3007f,0x3835205c,0x67230079}},	//   mpje_, _आपदा_, ннер, winj,
   {{0x672303ce,0x69da00e9,0x68fb0257,0x31b80103}},	//   tinj, _štet, _voud, héz_,
   {{0x7afc205d,0xe73300b1,0x68fb1030,0x764800eb}},	//   _gort, خصص_, _woud, _bydy,
   {{0x67230b27,0xe81f205e,0x2367023b,0x68fb0383}},	//   rinj, _मेरा_, _rinj_, _toud,
   {{0x6723205f,0x67d52060,0x68e90150,0x7afc0a00}},	//   sinj, _побу, _uned, _zort,
   {{0x386d2061,0x77680072,0x75d300a7,0x00000000}},	//   _iger_, _fidx, _məzə, --,
   {{0xcb1200c1,0x7afc2062,0xfbd200a1,0x21200063}},	//   ָלט_, _xort, נתי_, _smih_,
   {{0x76482063,0x7d0f0018,0xe1262064,0x64da0096}},	//   _gydy, _olcs, емни, _मोकळ,
   {{0x75d301d4,0x70aa2065,0xbcfb03a9,0xe8df0023}},	//   _nəzə, कलेल, _diék, _khốn_,
   {{0xa3d5007d,0x31692066,0x2d83029a,0x13f4008f}},	//   हिओ_, _diaz_, epje_, _изця,
   {{0x2d9e005f,0x63bb2067,0x69c704e9,0x00000000}},	//   štem_, mtun, _opje, --,
   {{0x63bb2068,0x2f140222,0x2d8c2069,0xed5a0aad}},	//   ltun, _lägg_, ède_, зов_,
   {{0x7afc206a,0xc5f200c1,0x40410129,0x629c00d4}},	//   _sort, נדן_, ụmịh, órov,
   {{0x63bb113a,0x60c40193,0xe81f206b,0xa3d5206c}},	// [16a0] ntun, _ibim, _मेला_, हिट_,
   {{0x7afc206d,0x63bb206e,0x386d206f,0x2c760065}},	//   _qort, itun, _ager_, _bùdó_,
   {{0x63bb2070,0x7afc0e78,0xfbdf0023,0x39440113}},	//   htun, _vort, _uyên_, _pkms_,
   {{0x764802ad,0x7afc2071,0x61fc0ac9,0x22a60af0}},	//   _rydy, _wort, ørli, _kíkà_,
   {{0x6d462072,0x7afc0d54,0x60c42073,0xe8df0023}},	//   _ikka, _tort, _mbim, _chốn_,
   {{0x6b842074,0x386d2075,0x98c500e8,0x63bb2076}},	//   mpig, _eger_, ītās_, dtun,
   {{0x60c42077,0xceb300c1,0x63bb2078,0xdb04020d}},	//   _obim, טיג_, etun, vriè,
   {{0x63bb2079,0x75d30092,0xa3dc0b86,0x6b84024a}},	//   ftun, _xəzə, डिल_, opig,
   {{0x63bb207a,0xd4e30084,0xdb0400fd,0x00000000}},	//   gtun, ующи, triè, --,
   {{0xdb0d207b,0x0bb700ca,0x2d830052,0x6b84207c}},	//   rtaç, עלים_, ypje_, ipig,
   {{0x6d46207d,0xdb04025a,0xdb0d001f,0x95ca207e}},	//   _okka, rriè, staç, _хлеб_,
   {{0xdb0d0161,0x26ce207f,0x6d4600f9,0xdcdf034c}},	//   ptaç, lefo_, _nkka, _पोंछ,
   {{0xa3e4000d,0xdb040072,0x63bb0227,0x00000000}},	//   _पछि_, ntió, ctun, --,
   {{0x545302ec,0x6d462080,0x60c40517,0x320502c6}},	//   _світ, _akka, _ebim, byly_,
   {{0x0dc810fb,0x7c870284,0x72030103,0xac951eb9}},	//   нути_, еузе, _مووم, кавш,
   {{0x2b582081,0x2d83029a,0x60c40065,0x75d300a7}},	//   _ahrc_, rpje_, _gbim, _qəzə,
   {{0x8aa72082,0x69c72083,0xfaa70423,0x6b8406a8}},	// [16b0] еред, _spje, ешен, gpig,
   {{0x60dd2084,0x2fc912f5,0x6d460517,0x69d5007f}},	//   ldsm, _ipag_, _ekka, _psze,
   {{0xf9930678,0x63bb1f3f,0x27e40113,0x7dc40018}},	//   ابط_, ztun, _armn_, _یقین,
   {{0x60dd2085,0x2fc90270,0x2d812086,0x63bb06da}},	//   ndsm, _kpag_, _ithe_, ytun,
   {{0xb8c92087,0x69d500a5,0x60dd2088,0x9e67001c}},	//   _गए_, _wsze, idsm, _تاکن,
   {{0x6d4d2089,0x752206b0,0xd246208a,0x2f140212}},	//   llaa, _amoz, _نن_, _vägg_,
   {{0xa3b3009d,0x6d46003e,0x98c7208b,0x6d4d014a}},	//   जून_, _ykka, _псал, olaa,
   {{0x63bb208c,0x386d01c5,0x60dd052f,0x6d4d208d}},	//   ttun, _uger_, jdsm, nlaa,
   {{0x63bb0084,0x7d0300ae,0x7c290117,0xdb040231}},	//   utun, _însu, _žerj, quiã,
   {{0x613d0068,0x63bb02f4,0x7522208e,0x2d9e00b6}},	//   mély, rtun, _emoz, átek_,
   {{0x63bb208f,0x6d4d2090,0x3f80002d,0x2d8101fa}},	//   stun, klaa, _stiu_, _nthe_,
   {{0xbcfb016d,0x2d9e2091,0xdb042092,0x6d4d01cb}},	//   _fiéi, štek_, rrié, jlaa,
   {{0x889a00a1,0x2f140149,0x6d4d0188,0x2d810372}},	//   וברי, _läge_, dlaa, _athe_,
   {{0xdb04025a,0x4ed52093,0x656b2094,0x63a92095}},	//   prié, люст, _high, mren,
   {{0x63a92096,0x656b2097,0x60c4009c,0x6d4d2098}},	//   lren, _kigh, _tbim, flaa,
   {{0x6d4d2099,0x63a9209a,0x656b0174,0x657c0103}},	//   glaa, oren, _jigh, _érhe,
   {{0x656b00a1,0x2d81209b,0x26c50036,0x63a9209c}},	// [16c0] _migh, _ethe_, _oblo_, nren,
   {{0x656b209d,0x613d0018,0x6d4d209e,0x6b84209f}},	//   _ligh, dély, alaa, rpig,
   {{0x2be0007d,0x63a920a0,0x644b013f,0x656b09f7}},	//   निहा, hren, _lygi, _oigh,
   {{0x63a908a9,0x656b20a1,0xfbab17ff,0x6b842096}},	//   kren, _nigh, _चमचम, ppig,
   {{0x68430109,0x613d01f9,0x63a920a2,0x6d4420a3}},	//   анца, gély, jren, moia,
   {{0x656b02bc,0x6d4420a4,0xd09a00a7,0xdb0400ee}},	//   _aigh, loia, rçək, quià,
   {{0xdb0411ce,0x63a920a5,0x28dd0f35,0x2be009c4}},	//   stió, eren, _नोकि, निवा,
   {{0x6d4420a6,0x7d03020a,0x644b03a8,0x00000000}},	//   noia, _înst, _bygi, --,
   {{0xa76620a7,0x63a920a8,0x656b20a9,0xdb040072}},	//   _акад, gren, _digh, ltiñ,
   {{0x86ea0037,0xbcfb0072,0x14ae0096,0xd2500470}},	//   _تعرف_, _viéi, _टाकण, ینک_,
   {{0xdb0408a8,0x63a920aa,0x656b00ca,0x64c60037}},	//   ntiñ, aren, _figh, _ليال,
   {{0x94260084,0x6913026a,0x6d440131,0xdb040072}},	//   _имее, _içec, joia, itiñ,
   {{0x60dd20ab,0x6d4420ac,0x63a920ad,0x00000000}},	//   rdsm, doia, cren, --,
   {{0x656b0134,0xdb2501f9,0x00000000,0x00000000}},	//   _zigh, épül, --, --,
   {{0x7e28116d,0x6d4d20ae,0x6e941a53,0x6b5020af}},	//   віта_, tlaa, рису, rägl,
   {{0xe7f3009d,0x6d4420b0,0x1bd500e5,0x00000000}},	//   _आपला_, goia, лобя, --,
   {{0xdc550303,0x6d4d1f49,0x2d7800e7,0x69da20b1}},	// [16d0] увањ, rlaa, _učen_, _štep,
   {{0x6d4d0934,0xf1b616f8,0x2004042c,0xb05b007b}},	//   slaa, _अमान, ämie_, seäs,
   {{0x6d4d20b2,0x63a920b3,0x2d810060,0x257801f9}},	//   plaa, zren, _uthe_, _nél_,
   {{0xe0df20b4,0x7d160146,0x2be00285,0xa3d2007a}},	//   ndò_, chys, निशा, _हईं_,
   {{0x656b0054,0xfd5613b6,0x49930103,0x00000000}},	//   _righ, _תשרי_, _چیئر, --,
   {{0x656b20b5,0xe8df00fe,0x00000000,0x00000000}},	//   _sigh, _phồn_, --, --,
   {{0x99670aa8,0xdb042027,0x656b20b6,0xbcfb03a9}},	//   _атал, quiá, _pigh, _diév,
   {{0x7d0d20b7,0x693c077e,0x25780103,0x00000000}},	//   nkas, včeg, _dél_, --,
   {{0x63a920b8,0xe2990036,0x7d0d20b9,0x38351538}},	//   uren, нап_, ikas, _снар,
   {{0xe1f902fd,0x63a920ba,0x656b20bb,0x25780018}},	//   его_, rren, _wigh, _fél_,
   {{0x7d0d20bc,0xaca30065,0xaaab0557,0x25780844}},	//   kkas, _akọb, _चयनक, _gél_,
   {{0x38690580,0x64550092,0x656b20bd,0x6d440062}},	//   žaru_, əzin, _uigh, xoia,
   {{0x03a5021c,0x53a50231,0x7d0d20be,0x6d440cc0}},	//   _сило, _салб, dkas, voia,
   {{0x752920bf,0xfd6500fe,0x00000000,0x00000000}},	//   liez, _truồ, --, --,
   {{0xdca61b77,0xc0e620c0,0xdd1d00b6,0xdb040161}},	//   лави, _бойк, lářs, luiç,
   {{0x7d0d20c1,0x7e7c034f,0x752920c2,0x9f4000b3}},	//   gkas, scrp, niez, _triï_,
   {{0x0aea1689,0x6eac00a5,0x6d4420c3,0xdb040161}},	// [16e0] ндай_, _जयपु, roia, nuiç,
   {{0x7d0d0084,0x6d4420c4,0x8a3a00c2,0x945d0034}},	//   akas, soia, няет_, leńs,
   {{0x8886013d,0x6d4420c5,0x752920c6,0x7d1620c7}},	//   глеж, poia, kiez, phys,
   {{0xdb0403be,0x25aa004d,0x7aeb00e8,0xc95501b6}},	//   rtiñ, _åbli_, ēgta, атчы,
   {{0xa3d21f83,0xdb0420c8,0x6ac90081,0x257803a9}},	//   _हैं_, stiñ, রয়ো, _sél_,
   {{0xdd1d00b6,0xaa461787,0x3ce020c9,0x00000000}},	//   dářs, _бегл, ldiv_, --,
   {{0x645d0102,0xceb300a1,0xe5c61ffa,0xbcfb00d1}},	//   ýsin, ציה_, усло, _dhéf,
   {{0x75290634,0x257801cd,0x7c2920ca,0x00000000}},	//   giez, _vél_, _žeri, --,
   {{0x28dd000f,0xdb040161,0x46b60602,0x257801c0}},	//   _नोटि, guiç, _محاس, _wél_,
   {{0x394620cb,0x257820cc,0x9bbb00c1,0x2bac00b6}},	//   loos_, _tél_, עציפ, _चिना,
   {{0xaac620cd,0x80de00c7,0xd25000bf,0x7d0d2012}},	//   र्यक, যান্, تند_, ykas,
   {{0xdb04001f,0xaca30134,0x26de05bd,0x752920ce}},	//   buiç, _kwụd, _hato_, ciez,
   {{0xa3b305d4,0x26de20cf,0x7d0d20d0,0xe0df0451}},	//   जूद_, _kato_, vkas, rdò_,
   {{0x26de0131,0xaca30174,0x527600d3,0x1ee7001c}},	//   _jato_, _mwụd, _суду, دوسی_,
   {{0xc27b07a6,0x7d0d20d1,0x627b040a,0x00000000}},	//   _ארוי, tkas, _אנונ, --,
   {{0x629a20d2,0xf1a900a5,0x26de20d3,0x257100cc}},	//   lato, _कितन, _lato_, _ušle_,
   {{0x394620d4,0x00000000,0x00000000,0x00000000}},	// [16f0] doos_, --, --, --,
   {{0x212b02d6,0x7d0d20d5,0x6eb2007f,0x00000000}},	//   lich_, skas, _जाएँ, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x629a20d6,0x212b01b5,0x26de01ee,0x00000000}},	//   hato, nich_, _aato_, --,
   {{0x26de20d7,0xbcfb20d8,0x752920d9,0xab5b00ee}},	//   _bato_, _diét, viez, _aqüe,
   {{0x7ceb070a,0x66e520da,0x212b20db,0x945d00a5}},	//   _förä, рока, hich_, zeńs,
   {{0x212b0067,0x26de20dc,0x629a20a8,0xbcfb0042}},	//   kich_, _dato_, dato, _chég,
   {{0x212b0897,0xdb040396,0x7790010d,0x81cd0033}},	//   jich_, tuiç, _کیوا, রিম_,
   {{0x212b01f7,0x26de001f,0x80de0081,0x752920dd}},	//   dich_, _fato_, যাম্, riez,
   {{0x26de20de,0x13090084,0x032516dd,0xdb0420df}},	//   _gato_, тной_, рдон, ruiç,
   {{0x752920e0,0xcb1400a1,0xdce600e8,0xe1f6002d}},	//   piez, מלץ_, _likā, агэ_,
   {{0x212b20e1,0x95670465,0x75ca01d4,0x61461824}},	//   gich_, _създ, _qəze, рема,
   {{0x26de0af0,0x248d001f,0x5edf0081,0x2fdb0090}},	//   _yato_, mbem_, মানে, _csqg_,
   {{0x629a20e2,0x26de00b3,0xb05b0e74,0x6d5d20e3}},	//   cato, _xato_, pfän, _ahsa,
   {{0xde031f0d,0x212b022b,0x78bb03d6,0xb05b0364}},	//   опри, bich_, _ocuv, lfäl,
   {{0x212b0181,0xac8610a6,0x3946023e,0x4fea0c58}},	//   cich_, ргал, xoos_, _амин_,
   {{0x998d20e4,0x8b261ad1,0xb05b0fe8,0xbea60cba}},	// [1700] _ćeš_, адае, nfäl, _капк,
   {{0x6d5d20e5,0xfaa620e6,0xdb04007b,0x6459039f}},	//   _ehsa, ражо, htiö, _mzwi,
   {{0xa2bd00c0,0xbcfb020d,0x6b5000bc,0x693c0141}},	//   _शान्, _piét, nägi, jčec,
   {{0x629a20e7,0x26de20e8,0xfce61894,0xbcfb17dc}},	//   zato, _sato_, _томо, _diés,
   {{0x26de20e9,0x629a20ea,0x394620eb,0xbcfb0113}},	//   _pato_, yato, roos_, _dhéd,
   {{0xadc30065,0x3946023e,0x212b1786,0xb5a6166f}},	//   _atẹg, soos_, zich_, арий,
   {{0xfaa320ec,0x26de0141,0x64590027,0x80d70096}},	//   _фасо, _vato_, _azwi, _बसले,
   {{0x629a00bf,0x26de1114,0x44f4194c,0xbcfb20ed}},	//   wato, _wato_, спис, _hiér,
   {{0x26de030b,0x2fc001fa,0x629a20ee,0xaac609c4}},	//   _tato_, _nqig_, tato, र्थक,
   {{0x68e020ef,0x68e219e4,0x29040239,0x69dc007e}},	//   _hamd, ldod, _homa_, _ksre,
   {{0x290420f0,0xbcfb20f1,0x68e020f2,0x212b20f3}},	//   _koma_, _miér, _kamd, tich_,
   {{0x68e220f4,0x29040877,0x644600bc,0x61b6007f}},	//   ndod, _joma_, ükis, _अमीष,
   {{0x212b20f5,0x2f140222,0xa3dc0af1,0x68e20036}},	//   rich_, _säga_, डिओ_, idod,
   {{0x212b01b5,0x69dc0087,0x69ce20f6,0x290420f7}},	//   sich_, _osre, _opbe, _loma_,
   {{0x2d8504ee,0x4d27001f,0x709520f8,0x68e2084e}},	//   ële_, аќаа, _лайф, kdod,
   {{0x2f140006,0x2904067d,0x5c7520f9,0xfc3f002b}},	//   _väga_, _noma_, слат, _adía_,
   {{0x212902fa,0x68e202ad,0x69dc20fa,0x645c00a7}},	// [1710] _imah_, ddod, _asre, əric,
   {{0xf1da0067,0x21290113,0x4ea71e11,0x2d780117}},	//   _बनान, _hmah_, _триа, _očeh_,
   {{0x2904155e,0x257100c4,0x68e00372,0xceb2006e}},	//   _boma_, _ošla_, _bamd, _ציט_,
   {{0x290420fb,0xc879008e,0x68e00150,0xdb160018}},	//   _coma_, _başa_, _camd, rtyá,
   {{0x27e920fc,0x68e000a6,0xe0df015e,0x00000000}},	//   ían_, _damd, llòs_, --,
   {{0x629820fd,0x81cd00c7,0x7bdd0054,0xc724004d}},	//   _nevo, রিত_, _issu, одій,
   {{0x63a220fe,0xe7f30067,0x212900cd,0xdb0400c2}},	//   _avon, _आपका_, _omah_, ttiö,
   {{0xce3809c1,0x290420ff,0x25a92100,0xd5b8009f}},	//   יאות_, _goma_, čal_, _इमरज,
   {{0x629810ec,0xe7842101,0xa3d20251,0x443d0113}},	//   _bevo, _духо, हौल_, _qxw_,
   {{0xf7700080,0xc2e90068,0x62982102,0x63a20a13}},	//   _قال_, اعظم_, _cevo, _dvon,
   {{0x7c3b0102,0x395f023e,0x62982103,0xb05b2104}},	//   _þurf, _khus_, _devo, sfäl,
   {{0xa3d20ed3,0x443d023e,0x628e0088,0xc8790555}},	//   _हैक_, _txw_, ðbor, _yaşa_,
   {{0xe28e1121,0x4385054f,0xa2e52105,0x63850284}},	//   _на_, _التق, _голд, _угла,
   {{0x62981db2,0xe7fa009d,0x68e22106,0x00000000}},	//   _gevo, ्हता_, zdod, --,
   {{0x63a20d94,0x7bdd2107,0xa3b31b11,0x2c850174}},	//   _zvon, _assu, जूर_, _ụmị_,
   {{0x31a30702,0x61430ea0,0x2bac0285,0x62812108}},	//   mız_, _неща, _चिदा, lclo,
   {{0x29042109,0x68e0210a,0xed5700c9,0x3f5602b6}},	// [1720] _roma_, _ramd, сот_, læum_,
   {{0x2904210b,0x6281210c,0x394d0113,0x68e0210d}},	//   _soma_, nclo, _akes_, _samd,
   {{0x31a3210e,0x7bdd0a15,0x58860138,0x2904210f}},	//   nız_, _essu, была, _poma_,
   {{0x395f2110,0x75ca0092,0x61fc09b5,0xc879020e}},	//   _chus_, _nəza, ärli, _paşa_,
   {{0xe1e70814,0x68e22111,0x765a153c,0xc7960fe9}},	//   _کس_, rdod, _szty, ёрды,
   {{0x2904039f,0x9976004c,0xdb040143,0x612f05aa}},	//   _woma_, _гуаш, briá, _kòlè,
   {{0x63a20102,0x6d410102,0x69dc084f,0x3ce20580}},	//   _svon, élag, _usre, _kakv_,
   {{0x75ca0092,0x186a0881,0x7644026a,0x7d060eaf}},	//   _cəza, _баби_, şiyo, _joks,
   {{0x7d0601b3,0xa3b30336,0x68fd01b9,0x00000000}},	//   _moks, जूल_, _òsda, --,
   {{0x62812112,0x7d062113,0xaab3030b,0xfc3f0143}},	//   gclo, _loks, ुभएक, _odín_,
   {{0x60f92114,0x14ca0084,0x8afb0089,0x2d9e020d}},	//   ання_, _были_, אליז, âtel_,
   {{0x63a20085,0x7d062115,0x657a01b9,0xeb050285}},	//   _tvon, _noks, _iuth, _शक्त_,
   {{0x2571005f,0x62982116,0x321e0034,0x4ad80336}},	//   _ušla_, _tevo, szty_, ड़ाव,
   {{0x657a2117,0x543b00c1,0x612f05aa,0x31a3047e}},	//   _kuth, _געדא, _bòlè, bız_,
   {{0x91860dd0,0x3ce202ac,0x37be0033,0x98bd007f}},	//   _اجتم, _bakv_, _ইনফর, lową_,
   {{0x21292118,0x5d55036c,0x40350077,0x00000000}},	//   _umah_, ікат, _мейс, --,
   {{0x2d582082,0x60cd2119,0x657a211a,0xba99004d}},	// [1730] сить_, _ibam, _luth, иває_,
   {{0x3f890161,0x2dd516de,0x657a0324,0x9f53007f}},	//   _itau_, _джор, _outh, ądów_,
   {{0x395f023e,0x657a03a9,0x5edf0033,0x2d9e211b}},	//   _phus_, _nuth, মাদে, šter_,
   {{0x7644026a,0xfbd00103,0x26cc00fc,0x98bd007f}},	//   ğiyl, بتہ_, _abdo_, kową_,
   {{0x7bc4211c,0x2b931e49,0x657a0054,0x6281211d}},	//   ctiu, _ریاس, _auth, yclo,
   {{0x6b8d211e,0x31a3008b,0xdb231531,0x657a211f}},	//   mpag, yız_, örän, _buth,
   {{0x45192120,0x6b8d2121,0x7d0601e8,0x657a2122}},	//   иция_, lpag, _yoks, _cuth,
   {{0x69c52123,0x75ca0092,0xb3852124,0x657a0441}},	//   mthe, _qəza, олил, _duth,
   {{0x31d10b94,0x3f890d7d,0x4ac62125,0x69c52126}},	//   तब्ध, _ntau_, र्वव, lthe,
   {{0x657a0e7a,0x693c134c,0x60cd2127,0x69c52128}},	//   _futh, nčen, _abam, othe,
   {{0x3f892129,0x657a212a,0x69c5212b,0xc5d9212c}},	//   _atau_, _guth, nthe, _خواص_,
   {{0xe56e02ec,0x69c50a62,0x291d1df6,0x27ed212d}},	//   _із_, ithe, nhwa_, _kren_,
   {{0x31a303a3,0xb05b042c,0x505a061b,0x6283212e}},	//   sız_, nfäh, ршня_, _tfno,
   {{0x6b8d0c45,0xe3b0212f,0x69c52130,0x693c0244}},	//   dpag, _سره_, kthe, jčen,
   {{0x693c0146,0x78a92131,0xec9a1009,0x7d062132}},	//   dčen, _odev, итај_, _poks,
   {{0x27ed2133,0x2d78015c,0xa01b2134,0x60cd0065}},	//   _oren_, _očev_, rbör, _gbam,
   {{0x7d060939,0x6b8d1ba1,0xdee62135,0x8e76002d}},	// [1740] _voks, gpag, _допи, _мунч,
   {{0x78a90012,0x249f0197,0x7bc42136,0xab5b0364}},	//   _adev, haum_, rtiu, _spür,
   {{0x7bc42137,0xe9da2138,0xed5a2139,0xaac6063c}},	//   stiu, рке_, _вон_, र्षक,
   {{0x6b8d213a,0x777b008a,0x7bc415d3,0x27ed213b}},	//   bpag, _buux, ptiu, _bren_,
   {{0x2ca0213c,0x657a213d,0x27ed213e,0x3f89061d}},	//   maid_, _suth, _cren_, _xtau_,
   {{0xfdfe1349,0x6d56213f,0x657a2140,0x69c50d87}},	//   _उपास_, llya, _puth, bthe,
   {{0x27ed2141,0xd5b000e3,0x657a2142,0x69c52143}},	//   _eren_, رفة_, _quth, cthe,
   {{0x291d2144,0x4ac600a5,0x2ca02145,0x98bd0034}},	//   chwa_, र्रव, naid_, tową_,
   {{0x27ed2146,0xdddc01ac,0x2be00096,0x777b008c}},	//   _gren_, jbrž, निटा, _guux,
   {{0xbcfb00e3,0xdb0d0072,0x98bd007f,0x28c8023a}},	//   _mhéa, traé, rową_, रभवि,
   {{0x3f8900d3,0xdcfc0138,0x2ca000aa,0x249f0696}},	//   _stau_, sprę, kaid_, baum_,
   {{0x645c0253,0x2ca0007a,0x249f0231,0x00000000}},	//   ərin, jaid_, caum_, --,
   {{0xb4d617ff,0xc05b01ce,0xb4b60f73,0xdb040161}},	//   ाजी_, рін_, जली_, criç,
   {{0xa3d704dd,0xf6510068,0xc4440504,0x764d013c}},	//   ाबर_, _آئے_, _ویژن_, şaye,
   {{0x6b8d2147,0x69c501ec,0xf1c300b6,0x693c0fee}},	//   wpag, xthe, _vaší_, včen,
   {{0xbcfb00e3,0x2ca02148,0x81cd0033,0x60cd2149}},	//   _bhéa, gaid_, রিশ_, _ubam,
   {{0xbcfb0080,0x0ca8008f,0x7c3b0995,0x693c02c6}},	// [1750] _chéa, ютри_, _žurb, tčen,
   {{0xbcfb054f,0x6b8d214a,0x81cd0081,0x249f214b}},	//   _dhéa, rpag, রির_, zaum_,
   {{0xa2bd10e9,0x291d0060,0x13d30081,0x6b8d214c}},	//   _शास्, thwa_, ়িয়, spag,
   {{0xa2ca1efb,0xbcfb0080,0x2ca0214d,0x69c5214e}},	//   त्त्, _fhéa, caid_, rthe,
   {{0x6cfa00ca,0xbcfb0076,0x693c1206,0x00000000}},	//   _הפרס, _ghéa, pčen, --,
   {{0x291d214f,0x69c52150,0x65620169,0xb05b042c}},	//   shwa_, pthe, _ahoh, rfäh,
   {{0x6ecd000c,0xb05b0364,0x249f0131,0xa8a70cc6}},	//   द्यु, sfäh, taum_, _мрак,
   {{0x27ed2151,0xd4d902ec,0x6562009c,0xdb042152}},	//   _tren_, ські_, _choh, triç,
   {{0x27ed2153,0x249f0e78,0xe3b10037,0x66180a39}},	//   _uren_, raum_, ررة_, _čakš,
   {{0x249f01fa,0xdb040231,0x00000000,0x00000000}},	//   saum_, rriç, --, --,
   {{0xdb0d0fb6,0x6562009c,0x0676006e,0x00000000}},	//   ntañ, _fhoh, _זײער_, --,
   {{0xdb0d1044,0x24840072,0xfbac0442,0x00000000}},	//   kraï, ccmm_, _चिलम, --,
   {{0x2ca00006,0x656900f2,0x205600ba,0x645d00bc}},	//   vaid_, mmeh, ятор, üsid,
   {{0x65620063,0x65692154,0xd3430103,0x00000000}},	//   _zhoh, lmeh, _تفتی, --,
   {{0xdb0d0257,0x551f0640,0xbcfb0037,0x12fa00ca}},	//   traî, _बताए_, _shéa, _להסב,
   {{0xec7a2155,0x753b028d,0x65691537,0x3b860e18}},	//   спа_, nnuz, nmeh, злаг,
   {{0x1d072156,0x6d560270,0x25dd0034,0x2ca02157}},	// [1760] чети_, rlya, _कैसी_, raid_,
   {{0x2ca02158,0x6b500149,0x63a62159,0x7c3b215a}},	//   said_, vägs, ákni, _žurc,
   {{0x2ca0215b,0x6d5600f9,0x49ca153d,0x8e7b00ca}},	//   paid_, plya, слен_, _לניה,
   {{0xbcfb00e3,0x00000000,0x00000000,0x00000000}},	//   _théa, --, --, --,
   {{0xdb04057a,0x24c30033,0x80ce0961,0x00000000}},	//   nsië, ্যাহ, ध्ये, --,
   {{0x656200dd,0x45d4215c,0xa9a6215d,0xdbc700aa}},	//   _shoh, докс, _нигд, tööt,
   {{0xc1da000f,0xdb040149,0x7c2400d3,0x9f400313}},	//   _बनेग, rriä, lzir, _asië_,
   {{0xdce4215e,0x48e3215f,0xb4d61006,0x7d042160}},	//   kmič, _посв, ाजे_, njis,
   {{0xd9430318,0x7c242161,0xa2bd1376,0x00000000}},	//   _чети, nzir, _शाश्, --,
   {{0x645c01d4,0xdce41efa,0x98bd0034,0xdb0d003e}},	//   əril, dmič, dowę_, ntað,
   {{0x65622162,0x867501b3,0x00000000,0x00000000}},	//   _thoh, _жыцц, --, --,
   {{0x2d5701e8,0x78a20a4b,0x3a3700ca,0x7aeb00e8}},	//   rçek_, naov, לרים_, ēgti,
   {{0x50640831,0x75ca0092,0x2d7805db,0xdb0d01cd}},	//   етра, _məzm, _očes_, ktað,
   {{0x7c242163,0x70770260,0x69c10120,0x941e0342}},	//   dzir, _کاغذ, _åleg, ığıy,
   {{0x78a208ac,0x97570796,0x9f4402c6,0xbcfb2164}},	//   kaov, פילו_, ímá_, _dhén,
   {{0xd23b004f,0x7d0401e5,0x91bb00d7,0x9ce400ae}},	//   _לגול, gjis, _המהי, нцул,
   {{0x2b5102ef,0x6f010103,0xdb0d016d,0x00000000}},	// [1770] _pkzc_, ölcs, nuaç, --,
   {{0x501c00ca,0x44242165,0xdb0d00ee,0x00000000}},	//   _לוחו, izm_, rraï, --,
   {{0xceb207a6,0xdb040257,0x99d902a3,0x89d90281}},	//   _ביי_, isiè, تواء_, توار_,
   {{0x7c2409ac,0xa3ac0096,0xb4d600a3,0xdb0d0076}},	//   bzir, गळा_, ाजो_, mraí,
   {{0xdb0d0c1b,0xc6152166,0x66e52167,0xa8780037}},	//   stañ, तन्य_, дола, أحمر_,
   {{0x8ae402ec,0x3ea32168,0xdb0d0161,0x3ce900aa}},	//   _післ, najt_, duaç, ldav_,
   {{0xdb0d0037,0x65692169,0x2d860357,0x2d781e4d}},	//   nraí, tmeh, _čoek_, _hčer_,
   {{0xfdf800a1,0x7ae7216a,0xa2ca0b76,0x3ce900aa}},	//   לצות_, _hajt, त्स्, ndav_,
   {{0x04770068,0x7ae70087,0x6569216b,0xdb0d216c}},	//   _ہلاک_, _kajt, rmeh, hraí,
   {{0x394f00d9,0x6569216d,0xdb16037a,0x00000000}},	//   logs_, smeh, tuyé, --,
   {{0x7ae7216e,0x645c0092,0x7d1d216f,0x7c240451}},	//   _majt, ərim, _olss, zzir,
   {{0xcea9004f,0x7ae72170,0x8fa6085f,0x6fb2009f}},	//   _כי_, _lajt, маме, _जिदं,
   {{0xd9aa0179,0xbcfb0257,0xe7f02171,0xb4e92172}},	//   _चट्ट, _phén, चिया_, मयी_,
   {{0x69d50126,0xdce40aa0,0xdb040313,0xdb16014b}},	//   _opze, rmič, rsië, puyé,
   {{0xdb0d0080,0xc10600e3,0x63bb2173,0xdce42174}},	//   graí, _يوتي, luun, smič,
   {{0x7c2401e9,0x2f1400bc,0x7c3b2175,0x00000000}},	//   tzir, _mägi_, _žura, --,
   {{0x3ce60038,0x7d042176,0x63bb2177,0x7d1600d4}},	// [1780] ľov_, rjis, nuun, rkys,
   {{0x3ce60220,0xd9101ac9,0x7d162178,0x7ae70141}},	//   žov_, گیر_, skys, _cajt,
   {{0x3ce912ba,0x7ae72179,0x6e460d86,0x78a213ea}},	//   bdav_, _dajt, _ценз, taov,
   {{0xdb0d0088,0x3cf90072,0x693c0031,0x63bb217a}},	//   stað, _gnsv_, mček, kuun,
   {{0x98a307df,0x87da16c4,0xdb0400e3,0x97da0e5a}},	//   тиче, تباس_, iriú, تظار_,
   {{0x63bb008a,0x758a004d,0x66e30284,0x00000000}},	//   duun, осив_, воља, --,
   {{0x60c408a9,0x693c0031,0x16150285,0x6b84026d}},	//   _ocim, nček, तनगर_, lqig,
   {{0xdb0d0396,0x7ae71def,0x63bb217b,0x38ca0103}},	//   tuaç, _zajt, fuun, _گاڑی_,
   {{0x7ae7023e,0x693c02c6,0x63bb1f9e,0x33740b36}},	//   _yajt, yčej, guun, нгир,
   {{0x60c40396,0x764d07d1,0x59d21784,0x78a00212}},	//   _acim, şaya, _सहार, _hemv,
   {{0xe135217c,0xdb04217d,0x81d60033,0x26dc0036}},	//   енны, friú, সিভ_, mevo_,
   {{0x26dc217e,0xdb0400fd,0x92be0081,0x63bb1f9a}},	//   levo_, ssiè, ঁজে_, buun,
   {{0x78a0171d,0xc1780138,0xdb0d016d,0x3f80044c}},	//   _memv, tvės_, quaç, _cuiu_,
   {{0xdef80450,0xdb0d217f,0x26dc028d,0x78a02180}},	//   мыс_, traí, nevo_, _lemv,
   {{0x7ae70018,0x3ea32181,0x7d1d00f9,0xdb040037}},	//   _rajt, rajt_, _plss, briú,
   {{0x7ae72182,0xa2ca2183,0x3ea32184,0x78a02185}},	//   _sajt, त्र्, sajt_, _nemv,
   {{0x7ae72186,0x60dd084e,0xc1790138,0x3f6700c2}},	// [1790] _pajt, mesm, svės_, _отоб,
   {{0x60dd2187,0x26dc2188,0xbcfb0257,0xc87900d3}},	//   lesm, jevo_, _théo, _iaşi_,
   {{0x7ae72189,0x26dc218a,0x7ac4008f,0x63bb0174}},	//   _vajt, devo_, ъсте, zuun,
   {{0x25f4218b,0x60dd218c,0x2561003e,0xbb1b044c}},	//   ्मनी_, nesm, kóla_, _atît,
   {{0x63bb008a,0x7ae7218d,0x06e80033,0x394f218e}},	//   xuun, _tajt, পানি, rogs_,
   {{0x2b000557,0x7c200233,0x00000000,0x00000000}},	//   राणु_, _ümra, --, --,
   {{0x60dd218f,0x9f40009c,0x6aa52190,0x2d812191}},	//   kesm, _criù_, mahf, _juhe_,
   {{0x63bb2192,0x3ea12193,0xfba3218b,0x6aa50063}},	//   tuun, _leht_, _ओबाम, lahf,
   {{0x2fc9023e,0x2d8500b6,0xf77802a1,0x36d50f21}},	//   _nqag_, ílej_, _fiħ_, _поар,
   {{0x291f022e,0x26dc00e5,0x60c42194,0xa2052195}},	//   _hlua_, cevo_, _scim, епод,
   {{0x68e918c4,0x68fb2196,0x63bb2197,0x00000000}},	//   _kaed, _knud, suun, --,
   {{0xaacf1efb,0x4acf05a5,0x9f490065,0x628a2198}},	//   स्तक, स्तव, _araà_, _effo,
   {{0x7c3b2199,0x653a00c1,0x63bb026d,0xbcfb0031}},	//   _žurn, _צענד, quun, _chém,
   {{0x63a9219a,0xbcfb03a9,0xfd1f0036,0x2d811ee5}},	//   msen, _dhém, _alì_, _buhe_,
   {{0x63a917d2,0x5239006e,0x60dd219b,0x6fb20096}},	//   lsen, _מײַנ, besm, _जिवं,
   {{0xfce3014d,0x693c0181,0x2d81219c,0xe8e00174}},	//   лосо, rček, _duhe_, raịt_,
   {{0x63a90d63,0x6b4b0103,0xab66219d,0x78a001cb}},	// [17a0] nsen, lügy, евал, _remv,
   {{0x3ea102dc,0x63a9219e,0x68fb219f,0x291f0062}},	//   _geht_, isen, _anud, _alua_,
   {{0x81cd0081,0x26dc21a0,0x291f0113,0x2571007e}},	//   রিক_, vevo_, _blua_, _ešli_,
   {{0xc7c621a1,0x63a921a2,0x80de0081,0x291f00b3}},	//   ески, ksen, যাক্, _clua_,
   {{0x26dc21a3,0xb05b0212,0x63a921a4,0x64590a4b}},	//   tevo_, lfär, jsen, _nywi,
   {{0x63a913cd,0x290d0154,0x36d40d9b,0x60dd21a5}},	//   dsen, _eoea_, токр, zesm,
   {{0xd91014df,0x26dc077e,0x68e908d3,0x78a00087}},	//   _پیش_, revo_, _faed, _temv,
   {{0x628a00e7,0xd90d05bc,0x26dc02ef,0x44f40215}},	//   _sffo, _ویل_, sevo_, тпис,
   {{0x645921a6,0x26dc00e5,0x63a921a7,0x00000000}},	//   _cywi, pevo_, gsen, --,
   {{0x212014f7,0x6d1c030b,0x290d024a,0x9f40009c}},	//   _alih_, नसँग_, _zoea_, _triù_,
   {{0x225801c5,0x75d30190,0x63a921a8,0x7d0b02c3}},	//   ærk_, _ميلا, asen, ögsk,
   {{0x2d8121a9,0x3ea1042c,0x64590178,0xb05b02c3}},	//   _ruhe_, _seht_, _fywi, dfär,
   {{0x60dd21aa,0x2d8121ab,0x64590150,0xc879020a}},	//   resm, _suhe_, _gywi, _paşi_,
   {{0xb05b09b5,0x60dd21ac,0x2d8100ce,0x00000000}},	//   ffär, sesm, _puhe_, --,
   {{0xa01b0018,0x2ca20154,0x1df8163d,0x777a0634}},	//   nböz, _bekd_, неры_, _mitx,
   {{0x81cd00c7,0xbcfb0257,0x2120033b,0x2d8c065b}},	//   রিখ_, _thém, _glih_, ídea_,
   {{0x7ff70037,0x80de0033,0x2d810027,0x5c7500e5}},	// [17b0] _أسعا, যাখ্, _wuhe_, тлат,
   {{0x68fb21ad,0x79a713a2,0x291f0076,0x21200995}},	//   _snud, ерде, _slua_, _zlih_,
   {{0xc33300a1,0xaca30294,0x291f01fa,0x290d07ac}},	//   נוע_, _amụb, _plua_, _poea_,
   {{0x9f5205aa,0x777a0062,0x75ca013c,0x61fe014b}},	//   _aryè_, _aitx, _gəzi, _àplu,
   {{0x672300dd,0x25710106,0x777a0a00,0x7afc009c}},	//   thnj, _ušli_, _bitx, _fnrt,
   {{0x45d50e3a,0x6126003e,0x63a913ea,0x7bcd21ae}},	//   вцит, _gólf, vsen, mtau,
   {{0x7d0f0103,0xb8950037,0x66180031,0x777a01c8}},	//   _kocs, _للأع, _čaká, _ditx,
   {{0x63a921af,0x6723023b,0x68fb00a7,0x7d0f21b0}},	//   tsen, shnj, _unud, _jocs,
   {{0x777a21b1,0x25a00106,0xab5b00ee,0x2d570052}},	//   _fitx, ćila_, _aqüi, lçes_,
   {{0x765a00dd,0x777a0634,0x00000000,0x00000000}},	//   _fyty, _gitx, --, --,
   {{0x63a921b2,0x7bcd00c2,0x64590034,0x6fa400aa}},	//   ssen, htau, _wywi, _कबहू,
   {{0x63a91538,0xbcfb01dc,0xa2bd0835,0x7bcd02db}},	//   psen, _dhék, _शाक्, ktau,
   {{0xa3e51000,0x61e10150,0xab5b0231,0x74290076}},	//   _पनि_, swll, _eqüi, _تكشف_,
   {{0x81bc01d3,0xb464004d,0x539a00ca,0xdb2400f3}},	//   izēj, _скіл, _חיסו, _åsøk,
   {{0x7d0f21b3,0xed5a21b4,0x2d9e21b5,0xdca603d9}},	//   _bocs, дов_, ète_, кави,
   {{0xed4321b6,0xb05b09b5,0x693c0128,0x316900bd}},	//   ансп, rfär, lčev, _ghaz_,
   {{0x75ca01d4,0xed570303,0x7d0f01b9,0x7bcd21b7}},	// [17c0] _vəzi, тот_, _docs, gtau,
   {{0x693c21b8,0x81bc00d9,0x387f01e9,0x27f80117}},	//   nčev, dzēj, _agur_, _črn_,
   {{0x18a621b9,0x7d0f21ba,0xb05b09ab,0x99f5004d}},	//   ваем, _focs, ngän, ляці,
   {{0x672121bb,0xdcfe21bc,0xe995001c,0x00000000}},	//   _allj, _kupč, اهنگ, --,
   {{0x2ba908d4,0x765a00c2,0x693c007e,0xc0ad006e}},	//   _चौपा, _syty, kčev, ליאָ,
   {{0xcf9300c1,0x387f01c8,0x80de0033,0xdcef044c}},	//   סטו_, _egur_, যাট্, _tică,
   {{0x644e0092,0x19b900c2,0xdb0403be,0xe9a30291}},	//   əbiy, _путь_, quiñ, _васп,
   {{0x291c01d3,0xaa4321bd,0x765a00d4,0x254500e8}},	//   īvas_, _тесл, _vyty, tēla_,
   {{0xf36621be,0x765a007f,0x00000000,0x00000000}},	//   ктон, _wyty, --, --,
   {{0x518621bf,0xd76400cd,0x764d0103,0x81d60033}},	//   кума, _صنای, ényé, সিস_,
   {{0x69130b88,0xaad40976,0x6d4614f3,0x54c600ae}},	//   _içer, ठ्यक, _ojka, _абеб,
   {{0x7bcd0138,0x00000000,0x00000000,0x00000000}},	//   ytau, --, --, --,
   {{0x69c402d5,0xc058004d,0x7d0f078e,0x693c0141}},	//   ांडी, вір_, _rocs, bčev,
   {{0x82330260,0x7f941b9d,0xdb23026a,0x81cd0033}},	//   اریا, рарх, örün, রিজ_,
   {{0x5faf007d,0xd37b0266,0x752221c0,0x00000000}},	//   _झटकल, _קרוט, _kloz, --,
   {{0x7bcd21c1,0xaac60d61,0xdb21026a,0x00000000}},	//   ttau, र्घक, ştür, --,
   {{0x2d5802fd,0x8aa70950,0x213921c2,0x75220350}},	// [17d0] тить_, вред, mish_, _mloz,
   {{0xd5a407d9,0x7bcd21c3,0xdd1100d9,0xbcfb0037}},	//   _وہ_, rtau, _kļūd, _mhéi,
   {{0x7bcd21c4,0x9f4901e8,0xdcfe00cb,0x7d0f21c5}},	//   stau, _araç_, _zupč, _tocs,
   {{0xb7d50032,0x213900ca,0x9f49015e,0x7bcd21c6}},	//   _aṣaw, nish_, _braç_, ptau,
   {{0x2ca921c7,0x75ca00a7,0x00000000,0x00000000}},	//   maad_, _məzu, --, --,
   {{0x2ca9008a,0xd2460190,0x7522010a,0x3669079c}},	//   laad_, _هن_, _aloz, нало_,
   {{0xa49309b4,0x44290220,0x693c0128,0x752216ce}},	//   لیات, _ťa_, včev, _bloz,
   {{0x13e9004c,0xdb0d016d,0x29f30095,0x752221c8}},	//   емий_, fraç, _ića_, _cloz,
   {{0xbcfb0080,0xdb0d001f,0x291d21c9,0xef1f00a7}},	//   _chéi, graç, mkwa_, vqün_,
   {{0x213900f9,0x20191a61,0x2ca9008c,0x693c03f1}},	//   eish_, dysi_, haad_, učev,
   {{0xc6920130,0xa0a6090f,0x693c0660,0xbbd0030b}},	//   _האב_, ланд, rčev, _सङ्क,
   {{0xbcfb00e3,0xa2d30789,0xdb0d0161,0xb05b0364}},	//   _fhéi, _बॉर्, braç, rgän,
   {{0x2ca9008a,0xf5390031,0xb4df0caf,0x693c0141}},	//   daad_, miť_, दजी_, pčev,
   {{0x248d21ca,0xf5390181,0x752221cb,0x2d8c0956}},	//   lcem_, liť_, _zloz, ídeo_,
   {{0x63bb00d9,0x2f140212,0x2ca9008c,0xa30a0103}},	//   lrun, _sägs_, faad_, _سروے_,
   {{0xf5390181,0x248d200b,0x67380dd9,0x693c0d94}},	//   niť_, ncem_, zivj, nčet,
   {{0xb7be00c7,0xa2ca0285,0x2d9301e9,0x61260165}},	// [17e0] _ইন্ট, त्क्, _etxe_, _cóle,
   {{0x81d60081,0x5eae0033,0xaca40065,0x291d21cc}},	//   সির_, ঞ্জে, _ikọs, ekwa_,
   {{0x63bb02dc,0x2ca9008a,0x248f0072,0x09f60fe9}},	//   hrun, baad_, _ofgm_, ычая,
   {{0xf5390220,0xb95a0037,0x2ca90188,0x63a40555}},	//   jiť_, رجاء_, caad_, _çing,
   {{0xf5390181,0x6d4421cd,0xb8dc0efd,0x645d00aa}},	//   diť_, mnia, _आय_, üsil,
   {{0x6d4416df,0x6d5601ee,0x63bb21ce,0x21390052}},	//   lnia, loya, drun, zish_,
   {{0x63bb02e2,0x25a008a9,0x6ed60789,0x6d4400bc}},	//   erun, ćilo_, म्यु, onia,
   {{0x6d4421cf,0xdb0d0161,0x7aee1b2b,0x3eaa01bf}},	//   nnia, traç, _habt, habt_,
   {{0x63bb21d0,0xd90d0068,0x6d4421d1,0x7aee21d2}},	//   grun, _تین_, inia, _kabt,
   {{0x6d5621d3,0x7c3b21d4,0x6d4408d3,0xdb0d0161}},	//   hoya, _žurk, hnia, rraç,
   {{0xf5390181,0x6d561cd8,0x2ca9008a,0x2d9821d5}},	//   biť_, koya, yaad_, jpre_,
   {{0x6d44006c,0x2ca90694,0x7aee21d6,0x46130d5b}},	//   jnia, xaad_, _labt, _دومر,
   {{0x21391bc8,0x6d4421d7,0x63bb21d8,0x2937006e}},	//   rish_, dnia, crun, ראכן_,
   {{0x69dc21d9,0x7aee01fa,0x2ca9008a,0x6d4421da}},	//   _opre, _nabt, waad_, enia,
   {{0x693c21db,0x6d440150,0x65600037,0x2d8500fd}},	//   nčes, fnia, olmh, êle_,
   {{0x6d5621dc,0x63a221dd,0x5c07008f,0x6ed600b6}},	//   goya, _kwon, ляза, म्बु,
   {{0x2ca918a7,0x69ce0078,0x9f40037a,0x81c60033}},	// [17f0] raad_, _aqbe, _crió_, _উনি_,
   {{0x61f80995,0xf5390038,0x63a221de,0x2ca921df}},	//   _krvl, ziť_, _mwon, saad_,
   {{0x6d4421e0,0x7aee0197,0x69dc21e1,0x6d5621e2}},	//   bnia, _dabt, _cpre, boya,
   {{0x57f50b21,0x2ba9121d,0x9f40037a,0x6d440034}},	//   ипет, _चौथा, _frió_, cnia,
   {{0x69dc21e3,0xf5390038,0x6b860113,0x7d0d21e4}},	//   _epre, viť_, _gukg, mjas,
   {{0x7d0d21e5,0xc5f900c7,0xbcfb1ba6,0xf7960037}},	//   ljas, _অথবা_, _chév, جنوب_,
   {{0xf5390181,0x2ba9000d,0x7c2d21e6,0x63a221e7}},	//   tiť_, _चौता, lzar, _awon,
   {{0xdb0421e8,0x63a221e9,0x7d0d21ea,0x7aee03e3}},	//   brió, _bwon, njas, _zabt,
   {{0x7c2d21eb,0xf5390181,0xf57600e3,0x693c007e}},	//   nzar, riť_, جميع_, rčet,
   {{0xadf716e2,0x63bb21ec,0x6d4421ed,0xc6a40396}},	//   ुमान_, rrun, znia, _грци,
   {{0x6d4402ad,0xf5390181,0x248d21ee,0x6d5621ef}},	//   ynia, piť_, pcem_, yoya,
   {{0x63bb21f0,0x61f8015c,0x81d60081,0x25f202d5}},	//   prun, _drvl, সিং_, ंटरी_,
   {{0xe28e03fc,0x53a50290,0x6d4421f1,0x6d5621f2}},	//   _ма_, _талб, vnia, voya,
   {{0x6d4421cd,0x26c721f3,0x823500cd,0x0876006e}},	//   wnia, ngno_, _پرتا, יערט_,
   {{0xada621f4,0x7aee21f5,0x442d21f6,0x7bdd21f7}},	//   рабл, _rabt, lze_, _apsu,
   {{0x7aee21f8,0x06af0081,0xef86185c,0x7d0d21f9}},	//   _sabt, চ্চি, _клип, gjas,

   {{0x69dc21fa,0x2d9821fb,0x6d4421fc,0xafe621fd}},	// [1800] _spre, spre_, rnia, _топл,
   {{0x7aee0694,0x2561003e,0x6aa700e7,0x442d21fe}},	//   _qabt, fólk_, _cejf, ize_,
   {{0x09e60423,0x6d5621ff,0x2d8500b6,0xfc3f0487}},	//   роен, poya, ílet_, _veía_,
   {{0x442d06c2,0xdb0406cb,0x29002200,0xe3a704f4}},	//   kze_, trió, ñia_, _ور_,
   {{0x7aee2201,0x442d2202,0x06af0081,0x7c2d0034}},	//   _tabt, jze_, চ্ছি, czar,
   {{0x442d2203,0x6996004d,0x63a205bd,0xdb04167e}},	//   dze_, _врах, _rwon, rrió,
   {{0xe1e72204,0x69dc0220,0x6136015c,0x693c00e7}},	//   _بس_, _upre, ršlj, učes,
   {{0x7c3b08a9,0x62832205,0x75292206,0xa96a02d8}},	//   _žuri, _agno, ghez, _риба_,
   {{0x39460fb6,0x4306004d,0x00000000,0x00000000}},	//   mnos_, аїна, --, --,
   {{0xfd4a199b,0xdb040072,0x39462207,0xf3660da5}},	//   talọ, oriñ, lnos_, јтин,
   {{0x79802208,0x442d0172,0x7c2d0a5f,0xd48f0c3f}},	//   _kimw, aze_, zzar, _мр_,
   {{0x7529068d,0x39462209,0x63a2220a,0x628300bd}},	//   chez, nnos_, _twon, _egno,
   {{0x442d0d1b,0x63a2220b,0x3946220c,0x50670c2b}},	//   cze_, _uwon, inos_, ртна,
   {{0xdced025b,0x6d48220d,0x394600f0,0x63bd1515}},	//   rmač, édan, hnos_, ásne,
   {{0xa69700a1,0xeca707c8,0x28d7220e,0x62330131}},	//   שכלה_, ијан, ण्डि, _мешу,
   {{0x7c2d220f,0x80c1009d,0x39460018,0xc27b00c1}},	//   tzar, _वाटे, jnos_, _ברוי,
   {{0x29e8002d,0x67da01d3,0x7bc42210,0x957c007f}},	// [1810] _aşa_, nājā, guiu, _brąz,
   {{0x7d0d2211,0x39462212,0xa91d00c4,0x6aa70052}},	//   sjas, enos_, _miže, _qejf,
   {{0x442d2213,0x7c2d2214,0x79800193,0xdb042215}},	//   zze_, szar, _bimw, griñ,
   {{0x39462216,0x645d00aa,0x442d2217,0x798003a8}},	//   gnos_, üsik, yze_, _cimw,
   {{0x61260088,0x6d5d0a69,0xa91d00cb,0x7980022b}},	//   _jóla, _iksa, _niže, _dimw,
   {{0x66e51787,0x39462218,0x6d5d0124,0xdb040042}},	//   сока, anos_, _hksa, briñ,
   {{0x7afa003e,0xa3a91cff,0x2d68042c,0x3f89078e}},	//   _ótta, गीन_, ißen_, _luau_,
   {{0x442d2219,0x7ae50fc4,0x69c5221a,0x22490234}},	//   tze_, leht, muhe, _ćak_,
   {{0x3d08007d,0xc95209c1,0x442d221b,0xf79401b3}},	//   हाते_, _זמן_, uze_, _матэ,
   {{0x442d08fa,0x78a9221c,0x27ed0407,0x798002a4}},	//   rze_, _heev, _isen_, _zimw,
   {{0x442d221d,0x75290060,0x568c00c1,0x78a900bc}},	//   sze_, phez, _סטאַ, _keev,
   {{0x2d6802e2,0xf09f0649,0x6126221e,0x7ae5023b}},	//   eßen_, gbà_, _bóla, heht,
   {{0x249f0131,0x78a9221f,0x3f810027,0x69c52220}},	//   mbum_, _meev, _bihu_, huhe,
   {{0x6d5d2221,0x539a0054,0x249f2222,0x612614b3}},	//   _aksa, _עיצו, lbum_, _dóla,
   {{0xe16400cd,0x394600c6,0x853c00c6,0xfbdf0131}},	//   _وضعی, ynos_, _kvėp, _apê_,
   {{0x2ba9000f,0x4c862223,0x61362224,0x61fc056b}},	//   _चौहा, слав, kšli, ærle,
   {{0x79800193,0xf38800de,0xdb0420df,0x394602ef}},	// [1820] _rimw, _lợn_, nsiç, vnos_,
   {{0x6ac600e3,0x6d5d2225,0xdb042226,0xf1db1e93}},	//   إقام, _eksa, isiç, _बहान,
   {{0x1efb00c1,0x27ed05aa,0x78a92227,0x69c52228}},	//   _עלטע, _asen_, _beev, guhe,
   {{0x78a9022e,0xdb042229,0x1d0a222a,0x984a061b}},	//   _ceev, rriñ, _семи_, ляла_,
   {{0x3946222b,0xaab809b4,0x7bc4222c,0x2ca000bc}},	//   rnos_, _نگار_, quiu, mbid_,
   {{0x3946222d,0x96f8002d,0xe9aa001c,0x254c00b6}},	//   snos_, рект_, _مدرن_, děla_,
   {{0x2d82222e,0x78a9222f,0x29e8020a,0xa91d00e8}},	//   _kike_, _feev, _uşa_, _siže,
   {{0xf8b000cd,0x77860084,0x2ca00313,0x2d822230}},	//   _آکا_, _глаз, nbid_, _jike_,
   {{0x4acf2231,0x2d8200ca,0xccf30327,0x44220103}},	//   स्कव, _mike_, לכה_, ák_,
   {{0x2d822232,0xaaa80569,0x78a9029a,0x60cd2233}},	//   _like_, गरिक, _zeev, _scam,
   {{0xd5b902ec,0x712700e3,0x23a9009f,0xe7f0086d}},	//   _всі_, مرحل, चीबद, चिका_,
   {{0x59c92234,0x81bc0029,0xc5f300a1,0x78a901fa}},	//   ांतर, dzēt, _מדע_, _xeev,
   {{0xa2d32235,0xd8d7006e,0xf09f00ee,0x00000000}},	//   _बॉक्, זוכט_, rbà_, --,
   {{0x437400bf,0x4ac70789,0x2d820d2a,0x2d680364}},	//   _بهتر, _लाइव, _aike_, ußen_,
   {{0xd0470092,0xe18900de,0x2d8206dc,0xddc500d2}},	//   _əməl, _hẳn_, _bike_, _vzhů,
   {{0x2d820044,0xbcfb0139,0x60cd063d,0x00000000}},	//   _cike_, _ahér, _ucam, --,
   {{0x2d822236,0x78a92237,0xe509009f,0x7ae52238}},	// [1830] _dike_, _reev, वाति_, teht,
   {{0x9a8705b6,0xbcfb2239,0x2d82223a,0x78a9223b}},	//   суал, _chér, _eike_, _seev,
   {{0x78a901fa,0x2ba90251,0xd91b1e20,0x81d60081}},	//   _peev, _चौरा, льд_, সিক_,
   {{0x69c5223c,0x248601c2,0x5c07223d,0xf3880023}},	//   ruhe, _ngom_, _ляга, _rợn_,
   {{0xf771223e,0x21291a3a,0x78a9223f,0xb8820031}},	//   وات_, _mlah_, _veev, _šíri,
   {{0xb6a52240,0x69c500c2,0x25a500f0,0x21292241}},	//   цикл, puhe, _pwll_, _llah_,
   {{0x21290496,0x78a92242,0xf5920cc8,0x69c50052}},	//   _olah_, _teev, ولوج, quhe,
   {{0x58d412e7,0x254c00b6,0xe3b905cb,0x321e0034}},	//   _ност, těla_, аби_, dyty_,
   {{0x981700bf,0x395f0a00,0x27ed2243,0x00000000}},	//   _ابزا, _ikus_, _usen_, --,
   {{0xdb160084,0xaacc00b6,0x15ab00e5,0xf38800fe}},	//   styö, ालयक, _бъди_, _tợn_,
   {{0x9f4901bf,0x81bc01d3,0x21290133,0x00000000}},	//   _spaß_, dzēs, _blah_, --,
   {{0x6f0500fe,0x2cab039f,0x00000000,0x00000000}},	//   _anhc, _necd_, --, --,
   {{0x2d822244,0x28d10469,0x394d2245,0xd24e001c}},	//   _rike_, _हानि, _mjes_, فنی_,
   {{0xe2992246,0x321e2247,0x21290167,0xd5dd136b}},	//   _так_, byty_, _elah_, _महाज,
   {{0x395f2248,0xad3a004d,0x2ca0033c,0x8e832249}},	//   _okus_, ачає_, tbid_, дгре,
   {{0xc5f200ca,0x4d66224a,0x2cab0503,0x644a0234}},	//   ודל_, ікав, _cecd_, šmiš,
   {{0x6f17224b,0x25a008c5,0x2ca008aa,0xcb050034}},	// [1840] _foxc, ćili_, rbid_, रांड_,
   {{0x5ec10081,0x98a600c4,0x395f058f,0x00000000}},	//   শ্বে, rhoč_, _akus_, --,
   {{0xa3a90b7f,0x80b100a5,0x2d82224c,0x7f5c00fd}},	//   गीत_, _अजमे, _tike_, morq,
   {{0x6d4100fd,0x7f5c0036,0xdd0f0233,0x61fc224d}},	//   élat, lorq, mışs, årli,
   {{0x394d00e7,0xbcfb00fd,0x7d0600c6,0x321e007f}},	//   _djes_, _thér, _inks, zyty_,
   {{0xd5ba03d9,0x394d224e,0x27e90428,0xab2a0831}},	//   аси_, _ejes_, çana_, _тога_,
   {{0x386d224f,0x76a900d6,0x7f5c0072,0xe18900fe}},	//   _ezer_, стів_, iorq, _sẳn_,
   {{0xb6030031,0x00000000,0x00000000,0x00000000}},	//   úšal, --, --, --,
   {{0x73fa0081,0x25a9005f,0x78a22250,0x7bd61d1e}},	//   েন্ট_, ćala_, mbov, ntyu,
   {{0x21290ddc,0x1fd00033,0x63bd0103,0xd3700190}},	//   _slah_, িবাস, ásna, عهد_,
   {{0x92582251,0xaacf00df,0x28d10557,0x61260231}},	//   сант_, स्टक, _हामि, _cólo,
   {{0x69c3033b,0x7bd607ac,0x321e12c5,0x254c02c6}},	//   šneg, ktyu, ryty_, mělo_,
   {{0xb97b0105,0xf8b30327,0x212900e7,0x35730103}},	//   ינטי, ושר_, _vlah_, _تھوڑ,
   {{0x7d06013f,0x321e0031,0x254500e8,0x00000000}},	//   _anks, pyty_, vēli_, --,
   {{0x2129100b,0x61261125,0xdef801b3,0x03572252}},	//   _tlah_, _gólo, цыя_, _ויגש_,
   {{0x21292253,0x4add0285,0x254501d3,0x69c100f3}},	//   _ulah_, न्नव, tēli_, _ålei,
   {{0xb7c50081,0x61260072,0xbcfb03a9,0xa91d0117}},	// [1850] _এন্ট, _móll, _dhép, _niža,
   {{0x6f05102f,0x395f1515,0xdea10103,0x99d70037}},	//   _unhc, _skus_, _سیری, قتصا,
   {{0x386d07ff,0xb7d50065,0x394d0216,0x4c9500ae}},	//   _szer_, _iṣiw, _pjes_, _нинс,
   {{0xdb0d0037,0x254c00d2,0x00000000,0x00000000}},	//   msaí, dělo_, --, --,
   {{0x3d08000f,0x07a510b8,0x8cd8007a,0x395f00d4}},	//   हारे_, чалн, मभरो, _vkus_,
   {{0x3eba00dc,0x3707007b,0x00000000,0x00000000}},	//   _xdpt_, ючев, --, --,
   {{0x7af501ff,0x394d01cb,0xf6251aad,0x00000000}},	//   _iazt, _tjes_, ядко, --,
   {{0x395f0039,0x7af52254,0x6126002b,0x00000000}},	//   _ukus_, _hazt, _cóll, --,
   {{0x61262255,0x7f5c034f,0x59c90096,0x69d70062}},	//   _sólo, yorq, ांवर, ltxe,
   {{0x27ff2256,0xfbd2040a,0x61262257,0x395d00ca}},	//   _irun_, עתי_, _pólo, lows_,
   {{0x644d01b3,0x69d70634,0x7af52258,0xeccb007f}},	//   _žaid, ntxe, _mazt, िलाफ,
   {{0x70c6009d,0xb7d50032,0x7af501c8,0x69d701ff}},	//   वलेल, _aṣiw, _lazt, itxe,
   {{0x7f5c00fc,0xd12f2259,0x00000000,0x00000000}},	//   torq, امُ_, --, --,
   {{0x2d96225a,0xe7e30490,0x395d225b,0x78a20206}},	//   зрас, _गहना_, hows_, zbov,
   {{0x80ab0f71,0x78bb005f,0x69d701fa,0x78a20094}},	//   _কার্, _oduv, jtxe, ybov,
   {{0x80da0081,0x7af501ff,0x61e30139,0xc5f20266}},	//   _বোর্, _aazt, _ipnl, עדן_,
   {{0xc1db0789,0x7af50a00,0xe8df00de,0x3b18225c}},	// [1860] _बहुग, _bazt, _ngựa_, _porq_,
   {{0x59d000c3,0x6136007e,0xd9e00033,0xa91d05db}},	//   _हमदर, ršlu, ণিসম, _riža,
   {{0x273000ef,0xe9da225d,0x27ff0af0,0xdb0d0076}},	//   _hàng_, ске_, _arun_, csaí,
   {{0xd9100260,0xa91d225e,0xdb040076,0x78a202c6}},	//   خیر_, _piža, nsiú, ubov,
   {{0x78a2225f,0x27ff01ec,0xdb040076,0xa09b0266}},	//   rbov, _crun_, isiú, ציסט,
   {{0x7af503f3,0x273000de,0x28d1009f,0x7bc40428}},	//   _gazt, _màng_, _हाथि, mriu,
   {{0x09e306b2,0x27300019,0x98a61012,0xa5d70037}},	//   _порн, _làng_, _ниве, كبير_,
   {{0x53982260,0x2cb20188,0x27ff02c3,0x00000000}},	//   овия_, nayd_, _frun_, --,
   {{0x27300028,0x7af5010a,0x27ff2261,0x83f80231}},	//   _nàng_, _yazt, _grun_, цепс_,
   {{0x59d00067,0xaacc2262,0x798e2263,0x96661807}},	//   _हमार, ालिक, _kubw, _екзе,
   {{0xc4862264,0x20002265,0x00000000,0x00000000}},	//   _елек, _arii_, --, --,
   {{0x27300023,0x798e0435,0xa91d00c4,0xbb1b014b}},	//   _bàng_, _mubw, _ližn, _huît,
   {{0xc05b00c6,0x27300028,0xb4e8007a,0x61260094}},	//   сін_, _càng_, मजी_, _gólm,
   {{0x27300019,0x7bc40138,0xa91d2266,0x00000000}},	//   _dàng_, driu, _nižn, --,
   {{0x7bc4007a,0x7af50087,0x798e0193,0x00000000}},	//   eriu, _razt, _nubw, --,
   {{0x7bc40036,0x8d740452,0x00000000,0x00000000}},	//   friu, فاقا, --, --,
   {{0x6c542267,0xc1580054,0x31ae0081,0x705500cd}},	// [1870] екту, _משהו_, _কমিশ, _زندا,
   {{0x798e0361,0x60dd0571,0x00000000,0x00000000}},	//   _bubw, lfsm, --, --,
   {{0x79a41278,0xa2cf1179,0x69c80120,0x6562039f}},	//   ерче, _दास्, _ådel, _okoh,
   {{0xba742268,0x63742269,0x656203a5,0x7bc4226a}},	//   رالت, lànd, _nkoh, briu,
   {{0x7bc40472,0x6d4d00aa,0x6cfa00ca,0x637400b3}},	//   criu, mnaa, _ופרס, càng,
   {{0x6d4d226b,0x65620169,0x0f1b0096,0x00000000}},	//   lnaa, _akoh, _नकोस_, --,
   {{0x25a908a9,0x6d4d226c,0x798e010a,0xc5d507bf}},	//   ćalo_, onaa, _gubw, філь,
   {{0x6d4d226d,0x27ff00e7,0x63bd0146,0x6298226e}},	//   nnaa, _trun_, ásno, _afvo,
   {{0x47d50080,0x6ece009d,0x68eb0d62,0x27ff2221}},	//   _زيار, _तालु, megd, _urun_,
   {{0x273000de,0x68eb226f,0x798e0169,0x20fa00fe}},	//   _ràng_, legd, _yubw, _ỏi_,
   {{0x69c50150,0x27300023,0x6d4d2270,0x60dd2271}},	//   nrhe, _sàng_, knaa, ffsm,
   {{0xd7d12272,0x254500d9,0xe7d10179,0x7bc40138}},	//   _समाच, tēlu_, _समाप, yriu,
   {{0x69c501bf,0x6d4d0188,0x65692273,0x316c00e8}},	//   hrhe, dnaa, mleh, ēdz_,
   {{0x27300028,0x6d4d2274,0x65690170,0x2cb2008c}},	//   _vàng_, enaa, lleh, wayd_,
   {{0x4ac70789,0xa91d09ac,0xa3a91cff,0x00000000}},	//   _लाजव, _nižo, गीर_, --,
   {{0x6d4d2275,0x273000de,0x798e0079,0x65692276}},	//   gnaa, _tàng_, _rubw, nleh,
   {{0x3b860451,0x6b870126,0x8c432277,0x5fd21bc3}},	// [1880] длаг, _bijg, вете, _तमिल,
   {{0xdcfd00d9,0x6569019f,0x6d4d2278,0xfaa300ae}},	//   _visā, hleh, anaa, вафо,
   {{0x2eaa009d,0xfe720037,0x200501d3,0x6d4d0188}},	//   करीत, _جدة_, ālie_, bnaa,
   {{0xeb9f038c,0x7bc40152,0x2d57003d,0x6d4d008c}},	//   _brød_, priu, għed_, cnaa,
   {{0x69c503ee,0x9f4900ee,0x6d440a4b,0x798e0027}},	//   arhe, _graó_, miia, _wubw,
   {{0xa91d033b,0x6aae0052,0x81e40033,0x6d442279}},	//   _fižo, _uebf, নিত_, liia,
   {{0xdce40146,0x80cf030b,0xa3b0014e,0xb05b227a}},	//   hlič, _थाले, टीन_, ngär,
   {{0xdce40087,0x6ba50149,0x6569227b,0xf38800fe}},	//   klič, _åtgä, gleh, _hợi_,
   {{0xf863227c,0x7c24227d,0xd8d70130,0xa3a90096}},	//   _авто, nyir, _קומט_, गील_,
   {{0x61260102,0xdce40146,0x52140c79,0x00000000}},	//   _fólk, dlič, едот, --,
   {{0x656901af,0xa2cf0640,0x7c240193,0x6d4d0188}},	//   bleh, _दार्, hyir, ynaa,
   {{0xf3880028,0x65620027,0x60dd042c,0x03a6037e}},	//   _lợi_, _ukoh, ufsm, _жидо,
   {{0xdce4025b,0x60dd0088,0x28d10971,0x6374227e}},	//   glič, rfsm, _हासि, tànd,
   {{0x442400a5,0x636f038c,0x272b004d,0x68eb029a}},	//   mym_, lønn, _lønn_, zegd,
   {{0x1df81119,0x4424227f,0x6d4d2280,0x200d00d3}},	//   меры_, lym_, tnaa, ţei_,
   {{0xdce42102,0xa91d2281,0x65602282,0xc445001c}},	//   blič, _rižo, nomh, _آیین_,
   {{0x44242283,0x4ea72284,0x6d4d2285,0x00000000}},	// [1890] nym_, _орна, rnaa, --,
   {{0xdb1606a3,0x65600037,0x6d4d2286,0xb05b0212}},	//   nsyè, homh, snaa, sgäs,
   {{0x6d4d1cab,0x442400d8,0x637400ee,0x65692287}},	//   pnaa, hym_, càne, yleh,
   {{0x7c240193,0x636f00d6,0x4424035d,0x6b9d0124}},	//   byir, jønn, kym_, _ttsg,
   {{0x68eb2288,0x6b8701c0,0x25ac00eb,0xa7fd01f9}},	//   regd, _tijg, _awdl_, _gyűl,
   {{0x442402ad,0x7d1d0018,0x00000000,0x00000000}},	//   dym_, _hoss, --, --,
   {{0xf3880019,0x7d1d2289,0x3cf900bc,0xacbb020d}},	//   _gợi_, _koss, _kasv_, _flût,
   {{0x7d1d02fd,0x00000000,0x00000000,0x00000000}},	//   _joss, --, --, --,
   {{0x7d1d228a,0x657b00dc,0xa3c10fef,0x6569228b}},	//   _moss, rmuh, ौंध_, rleh,
   {{0x6569228c,0x69c1004d,0xdce4228d,0x657b06a8}},	//   sleh, _åles, vlič, smuh,
   {{0xcb12040a,0x216a228e,0x7bcd016d,0x798918f0}},	//   אלי_, зини_, huau, _kiew,
   {{0x7d1d0303,0xdce40087,0x44240fe2,0x00000000}},	//   _noss, tlič, bym_, --,
   {{0xb4271850,0x442400a5,0x394f228f,0xdce40335}},	//   _تعاو, cym_, ings_, ulič,
   {{0x75290018,0x79890185,0xdce410e1,0x7bcd00bc}},	//   lkez, _liew, rlič, duau,
   {{0xdd920241,0xfce60070,0x6e9315af,0x61462290}},	//   اور_, ново, الفا, _пека,
   {{0x798900a5,0x7d1d2291,0xdce418c5,0x5ec10033}},	//   _niew, _coss, plič, শ্লে,
   {{0x7d1d2292,0xf38800de,0x7d1602b6,0x7ff60037}},	// [18a0] _doss, _sợi_, rjys, _أسبا,
   {{0x272b0120,0x637400ee,0x00000000,0x00000000}},	//   _sønn_, mànc, --, --,
   {{0x7d1d0eec,0x3f920010,0x3cfb0ff9,0x7c242293}},	//   _foss, _huyu_, _लोके_, syir,
   {{0x69c304d8,0x59d2086d,0x6126061a,0x6f1e03a8}},	//   ánea, दंबर, _bóli, _hopc,
   {{0x6f1e2294,0xa7fd0103,0x6126065b,0x79892295}},	//   _kopc, _szűr, _cóli, _diew,
   {{0xa8472296,0x44240094,0x57f30291,0x254c02c6}},	//   علوم_, vym_, упшт, měli_,
   {{0x44240067,0x61262297,0x65602298,0x00000000}},	//   wym_, _eóli, tomh, --,
   {{0x61262299,0x7d1d03be,0x4424229a,0x75290103}},	//   _fóli, _xoss, tym_, gkez,
   {{0x3946229b,0x849700e3,0x636f0120,0x3f920169}},	//   mios_, رئيس_, rønn, _nuyu_,
   {{0x656005a3,0x394600c6,0xa91d02dd,0x2eaa009d}},	//   somh, lios_, _nižj, करोत,
   {{0x041e0081,0x6ed7203b,0x442402cb,0xd9430012}},	//   _বেশী_, _बाबु, sym_, _реӂи,
   {{0x3946229c,0x63740428,0x2a6a229d,0x7529229e}},	//   nios_, fànc, _mybb_, ckez,
   {{0x7d1d229f,0xb80322a0,0x5f9400e5,0x3cfb00c3}},	//   _ross, लियम_, лият, _लोगे_,
   {{0x254c00b6,0x539b0341,0x6f1e22a1,0x3cf902ac}},	//   děli_, _ציוו, _copc, _sasv_,
   {{0x7d1d22a2,0x3946013f,0x80a222a3,0x28d100e2}},	//   _poss, kios_, _क्वे, _हालि,
   {{0x9d180cd7,0x3f9203e3,0xe7f10096,0xe8031e05}},	//   ност_, _fuyu_, _आईला_, लिमा_,
   {{0x394622a4,0xeb93029e,0xdb0d001f,0x70bf074c}},	// [18b0] dios_, اظر_, nsaç, ्लील,
   {{0x798922a5,0xdb0d22a6,0x7bcd0063,0xa91d0141}},	//   _siew, trañ, ruau, _vižm,
   {{0xa2d80961,0xa7fd0018,0x394622a7,0xa3b00096}},	//   _मान्, _gyűj, fios_, टीत_,
   {{0x394622a8,0x6126003e,0x3f9222a9,0x26040966}},	//   gios_, _póli, _yuyu_, विनी_,
   {{0x79890054,0x2ca91895,0x7c6722aa,0x00000000}},	//   _view, mbad_, _ساحل, --,
   {{0x2d8b0033,0x2ca9019c,0x36691a54,0xcf940266}},	//   _hice_, lbad_, мало_, אטס_,
   {{0x75290068,0xc6a41c16,0x56920c37,0x00000000}},	//   tkez, урчи, шајт, --,
   {{0x39460d9f,0x2ca922ab,0x00000000,0x00000000}},	//   cios_, nbad_, --, --,
   {{0x80a20852,0x752922ac,0x2d9322ad,0x442b22ae}},	//   _क्षे, rkez, _luxe_, ác_,
   {{0x2d8b00e9,0x3eb322af,0x69ca001f,0xdce50090}},	//   _lice_, _next_, áfeg, _fuhħ,
   {{0x68fb22b0,0x2d8b22b1,0x3f92008b,0x6f1e22b2}},	//   _kaud, _oice_, _suyu_, _ropc,
   {{0x61461a18,0x2eaa0be4,0x637405fe,0x68fb129d}},	//   тема, कर्त, tànc, _jaud,
   {{0x200422b3,0x68fb22b4,0x291f023e,0x2d930cf8}},	//   ími_, _maud, _moua_, _auxe_,
   {{0x2d8b0091,0x80a213ae,0x394622b5,0x63740428}},	//   _aice_, _क्रे, zios_, rànc,
   {{0x2d8b22b6,0x63bb22b7,0x7ed60a85,0x00000000}},	//   _bice_, lsun, _یزدا, --,
   {{0x291f002d,0x68fb06e8,0x394608a8,0x57d106ae}},	//   _noua_, _naud, xios_, _समूह,
   {{0x63bb22b8,0x39461e30,0x6f1e22b9,0xac86004b}},	// [18c0] nsun, vios_, _topc, тгал,
   {{0x5fb700a1,0x6f1e0268,0x81e40081,0x63bb22ba}},	//   _שהיא_, _uopc, নির_, isun,
   {{0x39460610,0x68fb22bb,0x2d8b0044,0x2ca922bc}},	//   tios_, _baud, _fice_, bbad_,
   {{0x3eb822bd,0xc7c622be,0x1e5700ca,0x621a006e}},	//   lart_, вски, _ישיר_, וועק,
   {{0x394622bf,0x68fb22c0,0x291f0012,0x2d8022c1}},	//   rios_, _daud, _doua_, mmie_,
   {{0x394601b3,0x63bb22c2,0x2d8b00d3,0x290d22c3}},	//   sios_, dsun, _zice_, _enea_,
   {{0x39461946,0x68fb0257,0x7afc22c4,0x48fd02d5}},	//   pios_, _faud, _iart, _रोको_,
   {{0x7afc22c5,0x68fb22c6,0x3eb80049,0x29dc11ce}},	//   _hart, _gaud, hart_, mía_,
   {{0x63bb22c7,0x29dc22a6,0x3eb822c8,0x1c0514e5}},	//   gsun, lía_, kart_, रियल_,
   {{0x68fb22c9,0x7afc0a00,0xdb0d016d,0x77630072}},	//   _zaud, _jart, rsaç, conx,
   {{0x29dc11ce,0x7c3a01d4,0x69de1695,0x68fb22ca}},	//   nía_, _ətra, ntpe, _yaud,
   {{0x7afc01e5,0x64a622cb,0x68e222cc,0x2d93002b}},	//   _lart, _рада, nfod, _ruxe_,
   {{0xdb0411ce,0xb4ae114d,0x29dc22cd,0x3eb80429}},	//   nsió, करी_, hía_, fart_,
   {{0x0ccb0da9,0x63a20256,0x3eb822ce,0x2d8b030b}},	//   िल्म, _iton, gart_, _sice_,
   {{0x29dc0487,0x2ca901cb,0xdb04014b,0x69de0216}},	//   jía_, tbad_, mpiè, jtpe,
   {{0xa3e6009d,0x29dc0fb6,0x7afc22cf,0x63a2010a}},	//   _पहा_, día_, _aart, _kton,
   {{0x3eb322d0,0x3eb8057e,0x5c7522d1,0x2ca922d2}},	// [18d0] _text_, bart_, улат, rbad_,
   {{0x7afc22d3,0xe4e21344,0x29dc11ce,0x69de22d4}},	//   _cart, क्ति_, fía_, ftpe,
   {{0x9a8722d5,0x29dc09e9,0x2d8b03ce,0xaca30134}},	//   туал, gía_, _tice_, _alụb,
   {{0x63a222d6,0x7afc22d7,0x23c20980,0x63bb22d8}},	//   _oton, _eart, _शिंद, ysun,
   {{0xb8db0378,0x69dc22d9,0x63a216da,0x68fb22da}},	//   _आज_, _eqre, _nton, _vaud,
   {{0x7afc22db,0x29dc11ce,0x2abc02c6,0x61ea0381}},	//   _gart, bía_, rábí_, _opfl,
   {{0x29dc11ce,0x63a222dc,0x74d70034,0x69de029a}},	//   cía_, _aton, _यादृ, ctpe,
   {{0x7afc22dd,0x394402a1,0x79950350,0x290d0634}},	//   _zart, _gmms_, _iuzw, _unea_,
   {{0xa85522de,0x0ed30789,0x25be01bf,0x61ea009c}},	//   _скач, _तांड, _evtl_, _apfl,
   {{0x63bb22df,0x386d22e0,0x316905aa,0x98ad007e}},	//   rsun, _iyer_, _akaz_, _mleč_,
   {{0x63bb22e1,0x3eb822e2,0x63a222e3,0xe8df00de}},	//   ssun, vart_, _eton, _ngừa_,
   {{0x7fd60f1e,0x8fa622e4,0x34950831,0x63bb22e5}},	//   лігі, ламе, _садр, psun,
   {{0xa2e50231,0x672122e6,0xb1431147,0x7995039f}},	//   _болд, _kolj, снял, _luzw,
   {{0xdbd10364,0x61260103,0x0876006e,0x083a006e}},	//   _süße, _rólu, טערט_, געשל,
   {{0xa2d81a09,0x29dc22e7,0xe8df0174,0xe4f922e8}},	//   _मात्, xía_, _amọn_, ्यपि_,
   {{0x7afc22e9,0x29dc11ce,0x5c160084,0xa3b00789}},	//   _sart, vía_, льзу, टीव_,
   {{0x3eb8014b,0x386d22ea,0x2d8022eb,0x60c422ec}},	// [18e0] part_, _nyer_, rmie_, _idim,
   {{0x7afc00dd,0x29dc04d8,0x2d800031,0x60c40090}},	//   _qart, tía_, smie_, _hdim,
   {{0x7afc0963,0x386d22ed,0x9d4622ee,0xbf9b0161}},	//   _vart, _ayer_, _бенд, nvên,
   {{0x29dc11d1,0x7afc22ef,0x61fc0400,0x386d01df}},	//   ría_, _wart, ærli, _byer_,
   {{0x7afc22f0,0x6d4607d1,0x29dc0fb6,0x23651197}},	//   _tart, _imka, sía_, kolj_,
   {{0xa2d822f1,0xdb0411c4,0x29dc22f2,0xbcfb22f3}},	//   _माध्, rsió, pía_, _akéh,
   {{0xf41f0d64,0x672100cb,0x60c40174,0x63a222f4}},	//   ään_, _dolj, _odim, _ston,
   {{0xb4ae0e72,0x60c422f5,0x80d6009d,0x186a22f6}},	//   करे_, _ndim, _भाषे, _заби_,
   {{0x67212181,0x14d5055c,0xb7f100aa,0x79820d2a}},	//   _folj, _धारण, _आईएम_, mmow,
   {{0xa3b504a9,0x60c422f7,0x672122f8,0x23650dd9}},	//   _जबर_, _adim, _golj, golj_,
   {{0xe693054f,0x415522f9,0x6d4622fa,0x925822fb}},	//   _المد, ивос, _omka, тант_,
   {{0x6ed70efb,0x672102ef,0x798201c2,0x63a20361}},	//   _बाहु, _zolj, nmow, _tton,
   {{0x63a222fc,0x60c422fd,0x5ede0033,0x23650128}},	//   _uton, _ddim, য়নে, bolj_,
   {{0x88bd00a5,0x2fc0033b,0x6d461f9e,0x6b8e00bd}},	//   _kośc, _dvig_, _amka, _nibg,
   {{0x2bc71376,0xd2b722fe,0x2fc00407,0xa3b002d5}},	//   _लिहा, _גלות_, _evig_, टीर_,
   {{0x798200a5,0x31690540,0x79950169,0x00000000}},	//   jmow, _ukaz_, _ruzw, --,
   {{0x7522023e,0xdb04002b,0x8aa722ff,0x00000000}},	// [18f0] _mooz, esiñ, гред, --,
   {{0xf09f0428,0x9b440037,0x200919ea,0x386d02ac}},	//   lcà_, منقو, _irai_, _ryer_,
   {{0xeb9f0c08,0xdb580084,0x386d00dc,0x6b8e030a}},	//   _grøn_, уют_, _syer_, _dibg,
   {{0x20092190,0xb4ae09a1,0x752206b0,0x3f8300e8}},	//   _krai_, करो_, _nooz, lmju_,
   {{0xb9650065,0xdcef007f,0x00000000,0x00000000}},	//   _adìé, _chcą, --, --,
   {{0x8cad00b6,0x386d02c2,0x637d0113,0x00000000}},	//   जरको, _vyer_, mèng, --,
   {{0x236502dd,0x7bcd003e,0x389e0129,0x61ed0a39}},	//   volj_, lrau, _ịre_, _ćalo,
   {{0x2009013f,0xf8b900bc,0x00000000,0x00000000}},	//   _orai_, _उजिय, --, --,
   {{0x36d52300,0xa3b02301,0xe3b60109,0x7bcd2302}},	//   _возр, टील_, абы_, nrau,
   {{0x27ed2303,0x7bcd2304,0x00000000,0x00000000}},	//   _ipen_, irau, --, --,
   {{0x88bd00a5,0x7bcd2305,0x7be10033,0x637d00d1}},	//   _gośc, hrau, নিয়ো, hèng,
   {{0x291d214f,0x7bcd2306,0x00860ac6,0x20092307}},	//   njwa_, krau, илно, _brai_,
   {{0xa0760077,0x273903a9,0xe7b30022,0x20092308}},	//   рынш, _cèng_, _ƙaƙƙ, _crai_,
   {{0x82a502fd,0x7bcd2309,0x56b500c1,0x798200a5}},	//   _такж, drau, יפֿן_, zmow,
   {{0x63a9230a,0x99d70081,0x69c3230b,0xa0a6230c}},	//   lpen, সবুক, šnej, _кайд,
   {{0xf38800ef,0x27ed230d,0x63a9024a,0x200901ff}},	//   _hợp_, _open_, open, _frai_,
   {{0x63a9230e,0x7bcd230f,0x4d63004d,0x0b4601b6}},	// [1900] npen, grau, ікув, анан,
   {{0x68e92310,0x63a91e12,0x09e6075f,0xaca40032}},	//   _abed, ipen, иозн, _ijọs,
   {{0xa2d80789,0xe9da2311,0xaca40134,0xfce62312}},	//   _मास्, тке_, _agụt, _коно,
   {{0x7bcd2313,0xa3e6099d,0x88e600c2,0x76000103}},	//   brau, _पहल_, ржде, házá,
   {{0x798200a5,0x76002314,0xbcfb0af0,0x6d560201}},	//   rmow, kázá, _akéw, mnya,
   {{0x6d560167,0x88bd007f,0x68e904d6,0x6374015e}},	//   lnya, _pośc, _ebed, vàno,
   {{0xd5b70b2f,0x6d56008a,0x63a91226,0xdced00a7}},	//   асы_, onya, epen, nmağ,
   {{0x6d562315,0xa91d2316,0x68e90065,0x25a10206}},	//   nnya, _bižu, _gbed, íhla_,
   {{0x63a92317,0x07a30131,0x27e92318,0xc7a30e3a}},	//   gpen, _матн, çant_, _митк,
   {{0x27390113,0x75220172,0x00000000,0x00000000}},	//   _rèng_, _wooz, --, --,
   {{0x6d562319,0xfa970089,0x752200e7,0x7bcd01d3}},	//   knya, ידיש_, _tooz, zrau,
   {{0x9d210033,0x2bc7231a,0x70220033,0x00000000}},	//   _নগ্ন_, _लिला, _পেইজ_, --,
   {{0xc05b0120,0xe53b0054,0xb4c406ec,0x637d00ee}},	//   тін_, _בתאר, ौली_, fènd,
   {{0x2009025a,0x6d560172,0x637d01dc,0xf09f00ee}},	//   _vrai_, enya, gènd, scà_,
   {{0x937b0089,0x00000000,0x00000000,0x00000000}},	//   _שטות, --, --, --,
   {{0x7bcd231b,0x20090028,0xc0cb231c,0x6d56231d}},	//   trau, _trai_, _руке_, gnya,
   {{0xe4f9231e,0x2d9c01f9,0x00000000,0x00000000}},	// [1910] ्यति_, _éven_, --, --,
   {{0x6d56231f,0x7bcd2320,0xfaa700c6,0xdab901c3}},	//   anya, rrau, ршан, اهات_,
   {{0x81e40081,0x63a90a00,0xceb20341,0x0b882321}},	//   নিক_, zpen, _מיי_, рсти_,
   {{0x273900fd,0x637d2322,0x63a92323,0x7bcd2324}},	//   _mène_, mène, ypen, prau,
   {{0x98e40037,0x6d4d2325,0x9ac70103,0x00000000}},	//   تكنو, miaa, _نگاہ_, --,
   {{0x9b450401,0x6aa90233,0x00000000,0x00000000}},	//   _طنزو, _şeff, --, --,
   {{0x80c200c7,0x7c2d2326,0x760000d2,0x00000000}},	//   ষ্ট্, lyar, vázá, --,
   {{0x58d40b0a,0x68e90284,0x63a92327,0x1e5800ca}},	//   _мост, _ubed, tpen, ישור_,
   {{0x7c2d2328,0xe2990131,0x63a92329,0xd6db00d3}},	//   nyar, лап_, upen, _ате_,
   {{0xf5e700d6,0x63a9202c,0x6d4d00bc,0xdced232a}},	//   _відм, rpen, hiaa, dlač,
   {{0xa2d81da8,0x7c2d232b,0x2249232c,0xdced013c}},	//   _मार्, hyar, упни_, xmağ,
   {{0x04950037,0x645e0034,0x61e100b3,0x00000000}},	//   _الإح, _śpie, rtll, --,
   {{0x7c2d02a4,0xdced0344,0x753b0350,0xd49600d7}},	//   jyar, jmađ, mhuz, _הכנת_,
   {{0x442d232d,0xdced00a7,0x00000000,0x00000000}},	//   mye_, tmağ, --, --,
   {{0x442d232e,0x6d56005c,0x637d232f,0x443f2330}},	//   lye_, tnya, rènd, lzu_,
   {{0x6d4d2331,0xdced2332,0xe0da0831,0x6d56008c}},	//   giaa, rmağ, _сви_, unya,
   {{0x442d2333,0x7c2d0068,0x443f2334,0xec7a123a}},	// [1920] nye_, gyar, nzu_, упа_,
   {{0x8a3a0084,0x442d2335,0x2ca0028e,0x443f01c8}},	//   ляет_, iye_, scid_, izu_,
   {{0xb4f910e9,0xd91000bf,0xdce400cb,0x442d023b}},	//   ्याय_, ویس_, jlić, hye_,
   {{0x7c2d2208,0x6d4d0ab2,0x442d2336,0xf9690120}},	//   byar, ciaa, kye_, арій_,
   {{0xa2d82337,0x291203a3,0x442d0a4d,0x7c2d02a4}},	//   _माल्, ıya_, jye_, cyar,
   {{0x7d042338,0x443f00d9,0x442d2339,0x29000774}},	//   ldis, dzu_, dye_, žia_,
   {{0xe7f40da9,0x7bd614cb,0x442d0188,0x2d9a233a}},	//   _इनका_, luyu, eye_, _jupe_,
   {{0x7d04233b,0x442d0c56,0xdce40095,0x6abe007e}},	//   ndis, fye_, koič, lapf,
   {{0x442d233c,0x7d04233d,0x78a20146,0xfc4a02c6}},	//   gye_, idis, mcov, blíž_,
   {{0xdced0106,0x7d040084,0x78a20146,0xd6d200b1}},	//   vlač, hdis, lcov, _رقص_,
   {{0x442d233e,0x65690113,0x00000000,0x00000000}},	//   aye_, boeh, --, --,
   {{0x78a20074,0x442d1a80,0x753b0010,0xdced233f}},	//   ncov, bye_, chuz, tlač,
   {{0x7d042340,0x50672341,0x443f00a5,0xa2b10096}},	//   ddis, стна, czu_, _आजच्,
   {{0x6d5a2342,0x7bd62343,0xa85700ca,0xdcef00e8}},	//   étan, duyu, מיכה_, _ticī,
   {{0x6d4d2344,0xdced0335,0x8d770604,0x2d9a044c}},	//   tiaa, slač, مارا, _cupe_,
   {{0x2d9a2345,0xdced02dd,0x7d042346,0x78a22347}},	//   _dupe_, plač, gdis, jcov,
   {{0xac182348,0x6d4d2349,0x7bd6234a,0x78a2035d}},	// [1930] боту_, riaa, guyu, dcov,
   {{0x6d4d234b,0x7c2d234c,0x6440234d,0x7d041350}},	//   siaa, ryar, izmi, adis,
   {{0x7c2d0496,0x637d0472,0x442d02f1,0x4c95234e}},	//   syar, lènc, zye_, _минс,
   {{0x273000ef,0x26de0fb6,0x442d234f,0x7bd60167}},	//   _hành_, _acto_, yye_, buyu,
   {{0x81e40081,0x637d0428,0xb90100c3,0x18690b1b}},	//   নিট_, nènc, _दा_, јали_,
   {{0xe73616d9,0x442d2350,0x443f0092,0xdce4042d}},	//   жеш_, vye_, vzu_, tlić,
   {{0xf77000bf,0x78a22351,0x442d2352,0x273000fe}},	//   راه_, bcov, wye_, _mành_,
   {{0x442d0c56,0x443f0a00,0x273000de,0xb3c90c79}},	//   tye_, tzu_, _lành_, ализ_,
   {{0x442d2353,0xdce40b18,0x753b01f9,0x00000000}},	//   uye_, slić, rhuz, --,
   {{0x443f2354,0xa1c50562,0x442d2355,0x637d0472}},	//   rzu_, обод, rye_, dènc,
   {{0x442d2356,0x2d5704f9,0x5f1d0469,0xe7842357}},	//   sye_, għek_, मान्_, _хуто,
   {{0x3eba2358,0x442d06a3,0x6abe2359,0x7bd6235a}},	//   _sept_, pye_, zapf, yuyu,
   {{0x41c50336,0x637d05fe,0xe8df0023,0x7d04235b}},	//   _विकस, gènc, _ngửa_, vdis,
   {{0x78bb0d4d,0x6d5d007e,0x3f81009c,0x27300023}},	//   _leuv, _ajsa, _chhu_, _cành_,
   {{0x27300028,0x7d0408bc,0x78bb0257,0x6da3235c}},	//   _dành_, tdis, _oeuv, диса,
   {{0x78bb235d,0x2fcd02dd,0x0d991ad1,0x7d04235e}},	//   _neuv, šega_, стры_, udis,
   {{0x637d0472,0x78a20146,0x6abe235f,0xac072360}},	// [1940] cènc, vcov, tapf, онта_,
   {{0x91ed1d7d,0x7bd607aa,0x200000ac,0x2d9a2361}},	//   _जहाज_, ruyu, _isii_, _tupe_,
   {{0x6abe02a4,0x3e83020d,0x78bb014b,0x78a22362}},	//   rapf, rété_, _beuv, tcov,
   {{0x7d04025e,0x1d0a2363,0x69c32364,0x00000000}},	//   qdis, _теми_, ânea, --,
   {{0x78a22365,0x386000a7,0x6b830174,0xaae20473}},	//   rcov, çir_, ọgar, _पापक,
   {{0x78a22366,0x00000000,0x00000000,0x00000000}},	//   scov, --, --, --,
   {{0xa3dc0980,0x3f4d00e7,0x27ff0032,0x78a21515}},	//   तून_, džul_, _esun_, pcov,
   {{0x63740428,0x7bc40138,0x6440042c,0x80d602c6}},	//   màni, osiu, tzmi, _भागे,
   {{0x7bc42367,0x741400e3,0x64400106,0x6abc003e}},	//   nsiu, سودا, uzmi, _kerf,
   {{0x799c023f,0x29040dc2,0x637d05fe,0x27e62368}},	//   _kurw, _hama_, vènc, mton_,
   {{0x29042369,0x6abc02a1,0x27e6236a,0x2ef80313}},	//   _kama_, _merf, lton_, derf_,
   {{0x29040a75,0x09cf00c7,0x2906236b,0x637d0472}},	//   _jama_, _রহমা, ndoa_, tènc,
   {{0x64400063,0x6abc236c,0x74130076,0x00000000}},	//   qzmi, _oerf, _يوما, --,
   {{0x2904236d,0x637d0990,0x6abc236e,0x26dc004b}},	//   _lama_, rènc, _nerf, ngvo_,
   {{0x637d0472,0xdcbb236f,0x31352370,0xce94013d}},	//   sènc, ища_, _некр, даръ,
   {{0x5c992371,0x27e62372,0xa3ae2373,0x6abc0037}},	//   ская_, kton_, _ओझा_, _aerf,
   {{0x6abc2374,0xdfdb013d,0x27e6023b,0x7bc42375}},	// [1950] _berf, _тъй_, jton_, gsiu,
   {{0x6abc2376,0x60dd2377,0x6e2a0052,0x799c0b58}},	//   _cerf, lgsm, ëmbë, _burw,
   {{0x6abc1a08,0x78bb025a,0x29042378,0x637405fe}},	//   _derf, _peuv, _bama_, gàni,
   {{0x7af72379,0x2904237a,0x27e6237b,0x69d7237c}},	//   sext, _cama_, fton_, ruxe,
   {{0x29041114,0x01e000c7,0x2d89237d,0x6abc237e}},	//   _dama_, ববিদ, mmae_, _ferf,
   {{0x27390154,0xb6a500d3,0x69d70042,0xdb040131}},	//   _bèna_, чикл, puxe, rpiã,
   {{0x27e60d64,0x672803ce,0x2904237f,0x6b9d207a}},	//   aton_, _dodj, _fama_, _husg,
   {{0x29042380,0x6b9d2381,0x2ee11d21,0x27e60124}},	//   _gama_, _kusg, _lchf_, bton_,
   {{0x27ff034c,0x1c0e0179,0x36d500ae,0x00000000}},	//   _usun_, सियल_, _ноар, --,
   {{0x29040a75,0x6b9d2382,0x466b2383,0x69c52384}},	//   _zama_, _musg, _крем_, oshe,
   {{0xe8030a30,0x69c52385,0x29042386,0x2ef82387}},	//   लिका_, nshe, _yama_, verf_,
   {{0x67232388,0x2ef8000b,0x2129037a,0x23a00154}},	//   ljnj, werf_, _coah_, _fòj_,
   {{0x88bd00a5,0x200f1e6c,0x24640052,0x69c52389}},	//   _rośl, _ágil_, rëmë_, hshe,
   {{0x69c70268,0x395f0149,0x2d9c0103,0x69c5238a}},	//   _ovje, _ljus_, _évek_, kshe,
   {{0x6b9d02dc,0x69c5238b,0x6b40238c,0x88bd007f}},	//   _ausg, jshe, _högg, _pośl,
   {{0x2bc70cf6,0x6b9d238d,0x6b9501d3,0x799c0169}},	//   _लिखा, _busg, _aizg, _rurw,
   {{0x2904238e,0x6b9505db,0x6b9d01c2,0x27e61d91}},	// [1960] _rama_, _bizg, _cusg, xton_,
   {{0x799c238f,0x7bc42390,0x637405fe,0x69c50052}},	//   _purw, rsiu, tàni, fshe,
   {{0x6abc2391,0x4ae202e8,0x67281419,0x69c72392}},	//   _verf, _पाठव, _rodj, _cvje,
   {{0x0edc030b,0x27e62393,0x63740428,0x69c70dd9}},	//   _बाँड, tton_, ràni, _dvje,
   {{0x67281548,0x290402e6,0x29062394,0x6abc1a49}},	//   _podj, _vama_, rdoa_, _terf,
   {{0x395f05aa,0x29042395,0x7d062396,0x28d82397}},	//   _ejus_, _wama_, _haks, _डाकि,
   {{0x29042398,0x7d062399,0x27e6239a,0x67282024}},	//   _tama_, _kaks, ston_, _vodj,
   {{0x7d06239b,0x27e6239c,0xda5b0327,0x394d239d}},	//   _jaks, pton_, _הכלל, _gmes_,
   {{0x7d06239e,0x69c7239f,0x0edc00df,0x00000000}},	//   _maks, _zvje, _बांड, --,
   {{0x883b00a1,0x637d06a3,0x394d23a0,0x00000000}},	//   _התמו, tèna, _zmes_, --,
   {{0x76430067,0x26cc02ad,0xa3b0097c,0x325300d3}},	//   czny, _iddo_, टीज_, евэр,
   {{0xf4870177,0x867b006e,0x27390154,0x60dd00e8}},	//   _کامی, _פראו, _jènn_, ugsm,
   {{0xfc3f23a1,0x60dd23a2,0xcfa7007b,0x00000000}},	//   _afín_, rgsm, яшни, --,
   {{0x3da723a3,0x7d0607ac,0x69c523a4,0x6b9d23a5}},	//   зраб, _aaks, yshe, _rusg,
   {{0x9e14004d,0x6b950216,0x2bda0285,0x00000000}},	//   ндрі, _rizg, यूसा, --,
   {{0x6b9d19db,0x69c50ac1,0x7d0601ee,0x00000000}},	//   _pusg, vshe, _caks, --,
   {{0x69c7029b,0x60cd23a6,0x2d8903a9,0x7d0623a7}},	// [1970] _svje, _idam, rmae_, _daks,
   {{0x69c5067d,0x394d0078,0x23d414db,0x69c30131}},	//   tshe, _smes_, _दिनद, âneo,
   {{0x6aa523a8,0xa3dc02d5,0xf9f908ba,0x6b830174}},	//   rchf, तूत_, تفاع_, ọgor,
   {{0x69c523a9,0xac1923aa,0xe9d00602,0x26cc23ab}},	//   rshe, _дому_, اغل_, _addo_,
   {{0x69c523ac,0x394d033b,0xfc6400e5,0x69da00f3}},	//   sshe, _vmes_, _зърн, _åten,
   {{0xe29a00de,0x69c51175,0xa2d800b6,0x69c70141}},	//   _ngư_, pshe, _माग्, _tvje,
   {{0x69c7029b,0xba7700d0,0x7d0623ad,0x60cd23ae}},	//   _uvje, _راست, _yaks, _odam,
   {{0x60cd23af,0xbe3c00ca,0x26cc010a,0x76430034}},	//   _ndam, מעות, _eddo_, rzny,
   {{0xb4ad10ed,0x387f23b0,0x67d423b1,0x395d023e}},	//   _कभी_, _uzur_, _поту, mnws_,
   {{0x60cd23b2,0x644d013f,0xd75b0100,0x81c900c2}},	//   _adam, _žais, _اجرا_, огов_,
   {{0x77640428,0x61e80124,0x6ed7052c,0x00000000}},	//   éixe, gtdl, _बाजु, --,
   {{0x60430134,0x00000000,0x00000000,0x00000000}},	//   _ọmaj, --, --, --,
   {{0x7d060b4b,0x6b400149,0x60cd23b3,0x00000000}},	//   _raks, _höge, _ddam, --,
   {{0x6d4f23b4,0x60cd23b5,0x4f9500ae,0x00000000}},	//   _amca, _edam, ерсу, --,
   {{0x7d0623b6,0x2d9e025a,0x2d9607cb,0x1b060081}},	//   _paks, ête_, драс, রামে_,
   {{0x395d023e,0x6b402104,0xd2dd023a,0x00000000}},	//   jnws_, _möge, _माँझ, --,
   {{0x7d0600f3,0x5ed30081,0xed570161,0x2739022b}},	// [1980] _vaks, দ্ধে, фот_, _rènn_,
   {{0x5fd3009f,0x6d4f063d,0x9f48007b,0x27390154}},	//   _तितल, _emca, öhän_, _sènn_,
   {{0x7d0623b7,0x63740428,0x752b0381,0x48e623b8}},	//   _taks, mànt, _oogz, доев,
   {{0x395d023e,0x63740428,0xa3ae00c3,0x00000000}},	//   gnws_, lànt, _ओझल_, --,
   {{0xc7a318c6,0xf74623b9,0x07fa15af,0x07a323ba}},	//   вичк, медо, تراع_, вачн,
   {{0xeb9f1484,0xb86523bb,0xf1c00031,0x6b4002db}},	//   _prøv_, رانو, úšky_, _böge,
   {{0x8a03121c,0x395d01fa,0x752b078e,0x00000000}},	//   _изре, bnws_, _bogz, --,
   {{0x4906009f,0x00000000,0x00000000,0x00000000}},	//   _सोचो_, --, --, --,
   {{0x671e0e72,0x14180076,0x00000000,0x00000000}},	//   पादक_, سيدة_, --, --,
   {{0xf7721823,0x778300ae,0x6b4002c3,0x00000000}},	//   _شاء_, _алуз, _högb, --,
   {{0x2fc923bc,0x945d007f,0x00000000,0x00000000}},	//   _svag_, tańc, --, --,
   {{0x92be00c7,0x914b0c10,0xae0d00aa,0x00000000}},	//   ইলে_, ічна_, हिसन_, --,
   {{0xb4da009f,0xf41f007b,0x6b400364,0x945d007f}},	//   ़ली_, äät_, _zöge, rańc,
   {{0x6b4001cd,0x09e50033,0x00000000,0x00000000}},	//   _lögb, নবতা, --, --,
   {{0xf206013d,0x7bd603a9,0x2012041c,0x00000000}},	//   _цяло, eryu, _eryi_, --,
   {{0x9d18008f,0x2c0b0096,0xe0df00b3,0x00000000}},	//   мост_, हटलं_, riòs_, --,
   {{0x63ad23bd,0x395d023e,0xfd1f0023,0x21390167}},	// [1990] _çant, vnws_, _chìa_, mksh_,
   {{0xdb0d003e,0x637400b3,0x00000000,0x00000000}},	//   gsað, cànt, --, --,
   {{0x69c80537,0x00000000,0x00000000,0x00000000}},	//   _ædel, --, --, --,
   {{0xa2d80454,0x656201e5,0xdce4026a,0x8ccb00aa}},	//   _माझ्, _njoh, mliğ, तृशो,
   {{0x7ac70114,0xdce401e8,0x2ca923be,0x00000000}},	//   _осве, lliğ, mcad_, --,
   {{0x6d910181,0x395d023e,0x2ca9008c,0xd7060120}},	//   _sťah, snws_, lcad_, енше_,
   {{0x58d523bf,0x2d9923c0,0xdce401e8,0xd5b10037}},	//   _повт, _kise_, nliğ, دفع_,
   {{0x6b400364,0xd6180f98,0x00000000,0x00000000}},	//   _vöge, بتها_, --, --,
   {{0x2d9923c1,0x47d50080,0x6d5a025a,0x443923c2}},	//   _mise_, _سيار, étai, ás_,
   {{0x422523c3,0x2d9923c4,0xdce4026a,0x6562039f}},	//   едов, _lise_, kliğ, _ejoh,
   {{0x78a423c5,0x4ae20fdd,0x443900d9,0x2d9900fd}},	//   žive, _पासव, šs_, _oise_,
   {{0x2d9923c6,0xa06a0284,0x00000000,0x00000000}},	//   _nise_, зама_, --, --,
   {{0x98a401d3,0xa2d702d5,0x1b060033,0xa07500d3}},	//   _jomā_, _मयप्, রাতে_, вырш,
   {{0xa35700bf,0x2d9923c7,0xd37b00ae,0xcad50033}},	//   _تخصص, _aise_, _ьче_, স্তফ,
   {{0x2d9923c8,0x637400b3,0x00000000,0x00000000}},	//   _bise_, rànt, --, --,
   {{0x628302e6,0x2d990e2a,0xa1c200e5,0x00000000}},	//   _izno, _cise_, _сбъд, --,
   {{0xe7da00c7,0x2d9923c9,0x4f961b10,0xbea60d9b}},	// [19a0] _ধন্য, _dise_, _проу, _папк,
   {{0x2d990313,0x2d9e0161,0xdce407e7,0x00000000}},	//   _eise_, ítes_, bliğ, --,
   {{0xdebb00f5,0x53360130,0x2d9923ca,0x5ebb00ca}},	//   _ממיל, ענען_, _fise_, _מזיק,
   {{0xe1ff00a5,0xeb9a23cb,0x597600cd,0xfd1f0023}},	//   łów_, _ним_, رداز, _thìa_,
   {{0x6d5623cc,0x4e96001c,0x6d4423cd,0x3f9a23ce}},	//   miya, _تشکر, mhia, _kipu_,
   {{0x6d5623cf,0xa5a40034,0x6d440124,0x98a401d3}},	//   liya, _चंदौ, lhia, _domā_,
   {{0xceb30054,0x6b6323d0,0x2d9923d1,0x60c623d2}},	//   ניה_, _скра, _yise_, kakm,
   {{0x6d5623d3,0x60c623d4,0x6d4423d5,0x657b0a69}},	//   niya, jakm, nhia, gluh,
   {{0xe3af03ed,0x60c609a4,0x69de23d6,0xdce4026a}},	//   یری_, dakm, lupe, zliğ,
   {{0x6d5623d7,0xfd1f0028,0x3f9a0479,0x68e223d8}},	//   hiya, _nhìn_, _nipu_, lgod,
   {{0x6d5623d9,0x6d44048e,0xf41f00bc,0x00000000}},	//   kiya, khia, äär_, --,
   {{0x6d5623da,0x88bd00a5,0x68e223db,0xbcfb0032}},	//   jiya, _dośw, ngod, _ajén,
   {{0x6d5623dc,0x5433012b,0xb4bc030b,0x557700c1}},	//   diya, _مرور, अरी_, _װעגן_,
   {{0x2d9923dd,0xae0d007d,0x69de23de,0x15f40e28}},	//   _sise_, हिलन_, kupe, _आहार_,
   {{0x63a223df,0x2d9904a3,0x6d5623e0,0xf8d0009d}},	//   _huon, _pise_, fiya, हणाय,
   {{0x63a21ee3,0x6d5623e1,0x6d441031,0xdce401e8}},	//   _kuon, giya, ghia, rliğ,
   {{0x2ca90188,0x63a200c2,0x656010e4,0x68e223e2}},	// [19b0] rcad_, _juon, inmh, dgod,
   {{0xaa6723e3,0x63a223e4,0x5f950291,0x3a2b00fe}},	//   нтек, _muon, _шипт, _đểđă,
   {{0x6d5623e5,0x63a223e6,0xda6700e3,0x6d44033f}},	//   biya, _luon, رائي, bhia,
   {{0x6d4423e7,0x6d5623e8,0x637d0c56,0xacbb0257}},	//   chia, ciya, vènm, _coût,
   {{0x7c8423e9,0x63a223ea,0x7d0d003e,0x66e5107a}},	//   _буре, _nuon, mdas, вола,
   {{0x7d0d23eb,0x68e20072,0x7bdf008c,0x61f818f0}},	//   ldas, agod, muqu, _opvl,
   {{0xae1405d4,0x7bdf0314,0xc179013f,0x657b0bb6}},	//   डियन_, luqu, ntės_, tluh,
   {{0x63a223ec,0x7d0d23ed,0xacbb0257,0xc1790138}},	//   _buon, ndas, _goût, itės_,
   {{0x63a200de,0xa3dc02d5,0x6b400212,0xa82200d1}},	//   _cuon, तूल_, _höga, _نکون,
   {{0x6d5623ee,0x63a223ef,0x88bd0034,0x7d0d00c2}},	//   ziya, _duon, _pośw, hdas,
   {{0x216a1a2b,0x614602b3,0x7d1d0313,0x6d5623f0}},	//   дини_, вена, _onss, yiya,
   {{0x26c723f1,0x7afe23f2,0x8fa623f3,0x6d5623f4}},	//   lano_, zept, каме, xiya,
   {{0xf9920130,0x7d0d23f5,0xa3a802e8,0x60c6026a}},	//   ירט_, ddas, _खूप_, rakm,
   {{0x26c723f6,0x752920e4,0x60c623f7,0xd24e001c}},	//   nano_, ljez, sakm, _ژنو_,
   {{0x6d5623f8,0x6d4402ad,0x50b623f9,0x26c723fa}},	//   tiya, thia, _испу, iano_,
   {{0x26c723fb,0x7d0d23fc,0x752923fd,0x261211d7}},	//   hano_, gdas, njez, थिती_,
   {{0x26c70c50,0x7afe002d,0x644902e2,0x6d440991}},	// [19c0] kano_, tept, nzei, rhia,
   {{0x6d440197,0x6d5623fe,0x60c423ff,0x69de00d4}},	//   shia, siya, _heim, tupe,
   {{0x60c40e95,0x3ed900c1,0x644901bf,0xa3a81152}},	//   _keim, _אַרא, hzei, _खून_,
   {{0x7afe2400,0x79892401,0x69de2402,0x6c860037}},	//   sept, _chew, rupe, _للجم,
   {{0xb90a2403,0x26c72404,0x798900bf,0x87e300c2}},	//   _मा_, fano_, _dhew, ающе,
   {{0x6a861722,0x3d1601e4,0x68e22405,0x60c42406}},	//   _алга, _पोते_, sgod, _leim,
   {{0x2d9c0068,0x63a22407,0x248000d9,0x98a4020a}},	//   _éves_, _suon, _šim_, _comă_,
   {{0x644901bf,0x6b9c0188,0x00000000,0x00000000}},	//   fzei, _hirg, --, --,
   {{0x07a60eaf,0x46ea007e,0x6b9c2408,0x3cea0caf}},	//   _разн, _одан_, _kirg, _छाने_,
   {{0x39460396,0xdced00e9,0x63a22409,0x7d0d0018}},	//   lhos_, plać, _vuon, zdas,
   {{0x53d4009d,0x7d0d0491,0x60c4240a,0xfb15006e}},	//   _दिवश, ydas, _beim, אַרט_,
   {{0x394600c9,0x63a2240b,0x51870291,0xdb0f015e}},	//   nhos_, _tuon, ђуна, _etcè,
   {{0x934613cb,0x14d70105,0x60c4240c,0x2ba702d5}},	//   _инде, _יואל_, _deim, _कंधा,
   {{0x69d30789,0x53330b1b,0x6b9c240d,0x00000000}},	//   _डिली, _вешт, _nirg, --,
   {{0x2fc0240e,0xa3a8240f,0x139b00ca,0x60c42410}},	//   _ewig_, _खंड_, _קבוע, _feim,
   {{0x60c42411,0xe7d20789,0xd7d209c4,0xc1790138}},	//   _geim, _सिंप, _सिंच, rtės_,
   {{0x7d0d2412,0xdd940138,0x2bda0b94,0x26c72413}},	// [19d0] rdas, раты, यंगा, yano_,
   {{0x7d0d01af,0x7cde00d3,0x26c703eb,0x79892414}},	//   sdas, tărâ, xano_, _shew,
   {{0x26c72415,0x6b9c2416,0xfaa40c3f,0x7d0d2417}},	//   vano_, _dirg, ршун, pdas,
   {{0x26c72418,0x6b9c0503,0x6d5a2419,0x00000000}},	//   wano_, _eirg, état, --,
   {{0x26c7241a,0x3869241b,0x6b9c0d2a,0x7bdf00a7}},	//   tano_, çar_, _firg, ququ,
   {{0x386904f9,0x6b9c241c,0xa03c00a1,0x394600c4}},	//   ħar_, _girg, ועדפ, ahos_,
   {{0x78a403ce,0xa3a80da9,0xa2b8030b,0xdb0600b6}},	//   živa, _खूब_, ोरन्, _utká,
   {{0xf3ff241d,0x3946241e,0xb4ad02e8,0x97c50080}},	//   ção_, chos_, कडे_, _مقرو,
   {{0x26c7241f,0x290d2420,0xf8ae0018,0xc9520089}},	//   pano_, _iaea_, _رکن_, _המן_,
   {{0x644902dc,0x60c42421,0x753b030b,0x2b1c0034}},	//   rzei, _seim, skuz, नाएँ_,
   {{0x64492422,0x7ae503dc,0x7bcd10f4,0x2fc00f5a}},	//   szei, ight, hsau, _swig_,
   {{0xe4cb00cd,0x26c5142a,0x6d1202d5,0x290f03e3}},	//   _آبان_, _helo_, _ढोंग_, ndga_,
   {{0xb4df009d,0xfd1f00de,0x25a52423,0xdb0f0610}},	//   तली_, _chìm_, _hull_, _etcé,
   {{0x25a504f9,0xe8e000b6,0x26c5005f,0x200900dc}},	//   _kull_, _पञ्च, _jelo_, _dsai_,
   {{0x26c52424,0x60c42425,0x1609022d,0x68e9077e}},	//   _melo_, _teim, विटर_, _oced,
   {{0x2d8b12fb,0x61e12426,0x6b9c2427,0x26c52428}},	//   _chce_, mull, _sirg, _lelo_,
   {{0x61e12429,0x7bcd08bc,0xac860ef7,0x2120242a}},	// [19e0] lull, gsau, угал, _inih_,
   {{0x68e90558,0xec77242b,0xfd1f0139,0xaf0617a8}},	//   _aced, упу_, _enì_, _спол,
   {{0x61e1242c,0xaca40134,0x637d0bb3,0x212000b6}},	//   null, _alụs, gèni, _knih_,
   {{0x68e9242d,0x6b40003e,0x290d03a8,0x7bcd042c}},	//   _cced, _gögn, _caea_, bsau,
   {{0x6b9c0029,0x26c5242e,0x7e7e242f,0x2d802430}},	//   _tirg, _belo_, _hypp, mlie_,
   {{0x61e101e5,0x26c52431,0x6b9c01b9,0xfaa32432}},	//   kull, _celo_, _uirg, _гаро,
   {{0x212003ce,0x26c52433,0x394601af,0x637d0428}},	//   _onih_, _delo_, phos_, cèni,
   {{0x9d220f71,0x61e12434,0xa534002d,0x774a0139}},	//   _নতুন_, dull, рнич, _dàbọ,
   {{0x7866088c,0x26c52435,0x77862436,0x6fa00442}},	//   _сказ, _felo_, _блаз, _गंगू,
   {{0x25a52437,0x26c52438,0x61e12439,0x29260a39}},	//   _full_, _gelo_, full, štač_,
   {{0x61e1243a,0x774a0065,0x521300ae,0x25a5243b}},	//   gull, _gàbọ, бдэт, _gull_,
   {{0x26c50b27,0x613f0216,0x64a61502,0xa159243c}},	//   _zelo_, _gëll, _сада, таму_,
   {{0x543600b1,0x26c5243d,0x2d80243e,0x2612080f}},	//   _حرار, _yelo_, dlie_, थिवी_,
   {{0xa2940f1e,0x2d80243f,0x26c50072,0x92942440}},	//   _калі, elie_, _xelo_, _калц,
   {{0x61e12441,0x1df8055b,0x25a50072,0x23d400b6}},	//   cull, леры_, _xull_, _दिँद,
   {{0x2d800982,0x20090044,0x7bcd2442,0x7e7e0ac9}},	//   glie_, _tsai_, tsau, _dypp,
   {{0x20092443,0x5c990109,0x3b551722,0x6fd9074c}},	// [19f0] _usai_, ткая_, акар, _भटिं,
   {{0x7bcd2444,0x3ea10124,0x6d5a2445,0x7ae500ca}},	//   rsau, _ught_, étar, ught,
   {{0x7bcd2446,0x2d800b4e,0x26c52447,0x63a4028d}},	//   ssau, blie_, _relo_, _èinf,
   {{0x26c5042d,0x98c700e3,0x25a52448,0x78a42449}},	//   _selo_, اغان, _rull_, živn,
   {{0xf77116cc,0x26c50303,0x25a5013d,0x61e1244a}},	//   يات_, _pelo_, _sull_, zull,
   {{0x61e122ea,0x7bda00ca,0xaae2030b,0x7bc00052}},	//   yull, _בקשו, _पाएक, _çmua,
   {{0x6b4002dc,0x26c5244b,0x7d0f244c,0xb0b50789}},	//   _mögl, _velo_, _kacs, ंडाग,
   {{0xb4df244d,0x613f00dd,0x61e1244e,0x25a50472}},	//   तले_, _qëll, vull, _vull_,
   {{0xa3e50e50,0xa3dc007d,0x9345244f,0x26c52450}},	//   बंध_, तंग_, иние, _telo_,
   {{0x61e12451,0x63a9023b,0x25a52452,0x00000000}},	//   tull, rqen, _tull_, --,
   {{0xe1262453,0x00000000,0x00000000,0x00000000}},	//   амни, --, --, --,
   {{0xa3e50789,0x7d0f2454,0x6579063d,0x00000000}},	//   बंद_, _nacs, _ukwh, --,
   {{0x22590034,0x31690383,0x00000000,0x00000000}},	//   ńsk_, _djaz_, --, --,
   {{0x61e12455,0x3f9e2456,0x8f761ba7,0x00000000}},	//   pull, ötu_, румі, --,
   {{0x3f8400d9,0x427900c1,0xed5a1278,0x3cb30294}},	//   ēmu_, _באַג, вов_, _ụzụ_,
   {{0x20562457,0x212005db,0xdca32458,0x637d0113}},	//   _втор, _unih_, жати, gènv,
   {{0x0c260058,0xe4f809a1,0x7d0f03a8,0x67210090}},	// [1a00] шман, ्जति_, _dacs, _onlj,
   {{0x973c14f3,0x7e7e2459,0x7d0f0503,0x00000000}},	//   _kiće, _typp, _eacs, --,
   {{0x6edb00a1,0xa3e5245a,0x2d80014b,0xf1ab0e4c}},	//   _בחיפ, बूत_, plie_, _घूमन,
   {{0xebe60e3f,0xaae202e8,0xdb06023b,0x387f0113}},	//   _комп, _पाकक, _kukë, _byur_,
   {{0x7d04245b,0xfaa6245c,0x88bd0034,0x6d46245d}},	//   meis, _ваго, _pośr, _ilka,
   {{0x7d04245e,0x26120aa6,0xed590220,0x6d4601ee}},	//   leis, थिली_, ďže_, _hlka,
   {{0x645d003e,0x1c0e02d5,0x00000000,0x00000000}},	//   úsin, सिकल_, --, --,
   {{0x7d040084,0x2b5803c3,0x00000000,0x00000000}},	//   neis, _hmrc_, --, --,
   {{0xc34a013d,0xa4140081,0x6aa9245f,0x66e61009}},	//   вяне_, িহ্য_, _şefi, _воза,
   {{0x7d042460,0x79820054,0x973c2461,0x60d62462}},	//   heis, llow, _biće, _adym,
   {{0x7d041736,0x6b400212,0x6d46007b,0x00000000}},	//   keis, _rögl, _olka, --,
   {{0x85560103,0x9257007b,0xdb060052,0x7d04007b}},	//   _خیبر_, рают_, _bukë, jeis,
   {{0x3202030b,0x75222463,0x74160504,0x661a007e}},	//   ňky_, _inoz, _خوشا, _hrtk,
   {{0x6d462464,0xc05800d6,0x973c00c4,0x661a0094}},	//   _alka, рію_, _fiće, _krtk,
   {{0xd37802e6,0x7d042465,0x7982007f,0x637d00b3}},	//   moć_, feis, klow, gènu,
   {{0x929b0054,0x7d042466,0x7c87014d,0xe29b1777}},	//   _ביות, geis, аузе, _בשור,
   {{0xdfd100e3,0xfaa72467,0x69d80146,0x63a4028d}},	// [1a10] _عيد_, ашен, áven, _èind,
   {{0x6d462468,0xd3780542,0x98b80325,0xd5a40103}},	//   _elka, noć_, _ērā_, _يہ_,
   {{0x3f8300e9,0x7d0f2469,0x387f171d,0x98bf0580}},	//   mlju_, _tacs, _syur_, _smuđ_,
   {{0xae1a00a1,0x3e16006e,0xfcab0281,0x7982246a}},	//   _עורכ, _פֿיל_, _جادو_, glow,
   {{0x1b0f0081,0xd3780ac3,0xf807246b,0x00000000}},	//   সাবে_, koć_, рчен, --,
   {{0xd246003f,0x38ad0065,0x7522246c,0xdb230421}},	//   _فن_, _bóró_, _anoz, _بوسی,
   {{0x6eba0285,0x79820034,0x69de007e,0x00000000}},	//   ्रतु, blow, crpe, --,
   {{0x8938246d,0x7bdf00ee,0x637d01dc,0x00000000}},	//   _кпсс_, orqu, hènt, --,
   {{0x68fb14a2,0x973c0095,0x52e200c3,0x46150e27}},	//   _ibud, _siće, पलूस, _گوار,
   {{0x27ff00d1,0x38ad0139,0x973c0995,0x7522246e}},	//   _ipun_, _fóró_, _piće, _enoz,
   {{0x7d04246f,0x3f830357,0x00000000,0x00000000}},	//   yeis, dlju_, --, --,
   {{0x752200e7,0x973c007e,0xdb060216,0x9f420113}},	//   _gnoz, _viće, _pukë, muké_,
   {{0x442904ea,0x7d042470,0x057400e3,0xd3a708f9}},	//   _ça_, veis, _بالد, _треп,
   {{0x63bb0b19,0x02391dec,0x7d0402e2,0x59a709c3}},	//   mpun, _مثبت_, weis, गदार,
   {{0x68fb2471,0x7d042472,0x63bb2473,0x6ade0081}},	//   _obud, teis, lpun, ন্ডো,
   {{0x90c60832,0x68fb0129,0x2b5800c4,0x27ff044c}},	//   _убие, _nbud, _smrc_, _opun_,
   {{0x3f83084f,0x63bb2474,0x637d03a9,0x6d5800c6}},	// [1a20] blju_, npun, bènt, _įvad,
   {{0x7d041d2d,0x637d2475,0x00000000,0x00000000}},	//   seis, cènt, --, --,
   {{0x993a0426,0x7d042476,0xe9da0277,0x63a4016d}},	//   ляду_, peis, уке_, _éinv,
   {{0x63bb2477,0x68fb009c,0xe4470076,0x9f420113}},	//   kpun, _cbud, _فض_, duké_,
   {{0xe73a064f,0xbcfb0139,0x798202ac,0xacf70103}},	//   лед_, _ajéw, rlow, _اسپت,
   {{0x68fb2478,0x63bb2479,0x78250037,0x00000000}},	//   _ebud, dpun, تعمل, --,
   {{0xceb30341,0x8f9b0266,0xa96a247a,0xd6d9004d}},	//   ליג_, ניצי, _бива_, рті_,
   {{0x63bb0b8e,0xdb060113,0x93b40120,0x00000000}},	//   fpun, _sukè, обиц, --,
   {{0x63bb247b,0x2906024a,0x00000000,0x00000000}},	//   gpun, meoa_, --, --,
   {{0xdb04247c,0x27e602c9,0x68fb247d,0x1b0f0033}},	//   mpió, muon_, _zbud, সাথে_,
   {{0x3f8302e6,0x63bb0634,0x2e1805aa,0x4b7b0142}},	//   vlju_, apun, _nčf_, רטיג,
   {{0xddcb003d,0x1a9b006e,0xb17f0174,0x73e601b3}},	//   ġiżl, טייע, _ụụlọ_, _годз,
   {{0x637d0428,0x27e602c9,0x3f8309ac,0x96ac00b6}},	//   tènt, nuon_, tlju_, _चलाउ,
   {{0xc90500c3,0x2e1805aa,0xf1f701f3,0x3ea500f3}},	//   _रस्म_, _bčf_, جعیت_, ølt_,
   {{0x20000154,0x29060062,0x00000000,0x00000000}},	//   _epii_, keoa_, --, --,
   {{0x52830080,0x78a40ea3,0x27e60009,0x6b4002c3}},	//   _عليك, živj, kuon_, _högh,
   {{0xfd4f0028,0x26ce010a,0x3f83031a,0x29060a00}},	// [1a30] _khiế, kafo_, plju_, deoa_,
   {{0x27e60d58,0x00000000,0x00000000,0x00000000}},	//   duon_, --, --, --,
   {{0x27ff002d,0x3ce9247e,0x00000000,0x00000000}},	//   _spun_, pgav_, --, --,
   {{0x63bb247f,0x224a0206,0x00000000,0x00000000}},	//   ypun, úbky_, --, --,
   {{0x6aa900ae,0x6d4d18f0,0x65a701f9,0xdd980012}},	//   _şefu, mhaa, _műhe, _ышь_,
   {{0x70b52480,0xfd4f00de,0x6d4d2481,0x6d5f2482}},	//   ंडुल, _nhiế, lhaa, liqa,
   {{0x27ff0063,0xc5d5004d,0x00000000,0x00000000}},	//   _wpun_, ціль, --, --,
   {{0x63bb02e6,0x68fb2483,0x6d4d2484,0x9c130294}},	//   tpun, _ubud, nhaa, họmm,
   {{0x69da070a,0x63bb00c2,0x7c2d2485,0x1425004d}},	//   _åter, upun, nxar, ідом,
   {{0xfd4f00ef,0x6d4d2486,0x63bb2487,0xe1f90848}},	//   _chiế, hhaa, rpun, аго_,
   {{0x63bb2488,0x6d4d2489,0x6f0700b6,0xdced0a9e}},	//   spun, khaa, dejc, hlađ,
   {{0xdced2392,0xaca30139,0x63bb248a,0xd24e001c}},	//   klađ, _alọb, ppun, خچه_,
   {{0x6d4d248b,0x2329248c,0x297a0142,0x00000000}},	//   dhaa, _воли_, שטרא, --,
   {{0x6da6248d,0x6569248e,0x63ab0270,0x973c007e}},	//   жива, lneh, _iugn, _kića,
   {{0x63ab248f,0xa3e50251,0x417609b4,0xad5a18a2}},	//   _hugn, बूर_, _وابس, арах_,
   {{0x63a32490,0x6d4d2491,0x65692492,0x6d4300d3}},	//   _hinn, ghaa, nneh, _înal,
   {{0x63a32493,0x443f2494,0x442d2495,0xfd1f00de}},	// [1a40] _kinn, nyu_, nxe_, _nhìu_,
   {{0x63a32496,0x261a0ed3,0x62830bea,0x63ab028d}},	//   _jinn, _मछली_, _kyno, _mugn,
   {{0x443f1084,0x2d8c2497,0x63ab0149,0x9a6a00e3}},	//   hyu_, ïdes_, _lugn, جمال_,
   {{0x63a32498,0x6d4d2499,0x443f249a,0x98a6249b}},	//   _linn, chaa, kyu_, циде,
   {{0xd70a00ae,0x63ab0270,0xc8cc030b,0x65690031}},	//   инде_, _nugn, ारबट, dneh,
   {{0x1754249c,0xfaa61b82,0xd04e0092,0x501b040a}},	//   явля, _фаво, ükəs, יונו,
   {{0xd94622ee,0x628302ec,0x65690364,0x56930da5}},	//   _деви, _nyno, fneh, машт,
   {{0x6d4401b3,0x63ab249d,0x7d16249e,0x63a3152f}},	//   nkia, _bugn, ndys, _ainn,
   {{0x63a31db2,0xdce404a3,0xfd4f0019,0x443f249f}},	//   _binn, jnič, _phiế, gyu_,
   {{0x63a30514,0x6d5f0415,0x63ab24a0,0x321c24a1}},	//   _cinn, ziqa, _dugn, _prvy_,
   {{0x442d08a8,0x62830150,0x6d4400c2,0x63a31814}},	//   axe_, _cyno, kkia, _dinn,
   {{0x63a30102,0x62830150,0x80b502d5,0x443f24a2}},	//   _einn, _dyno, ंडें, byu_,
   {{0x63a324a3,0xfd4f00ef,0x63ab0036,0x7d1624a4}},	//   _finn, _thiế, _gugn, ddys,
   {{0x63a324a5,0xf4870281,0x26cc24a6,0x93770037}},	//   _ginn, _بامی, _jedo_, _وصور_,
   {{0x26cc24a7,0x6d5f24a8,0x6d4d24a9,0x628300f0}},	//   _medo_, tiqa, thaa, _gyno,
   {{0x91b700d0,0x63a324aa,0x61e8019c,0x7c2d01e9}},	//   _بطور_, _zinn, mudl, txar,
   {{0x6d4d24ab,0x6d5f061d,0x61e824ac,0xdce400d4}},	// [1a50] rhaa, riqa, ludl, cnič,
   {{0x6d4d24ad,0xce95013d,0x26cc02ef,0x6d5f019f}},	//   shaa, _напъ, _nedo_, siqa,
   {{0x60cd0496,0xdced0335,0x2fc907ac,0x61e802c9}},	//   _keam, slađ, _hwag_, nudl,
   {{0x6d5f0063,0x6d4400da,0x443f24ae,0x64400dd8}},	//   qiqa, ckia, yyu_, kymi,
   {{0x880700d0,0x6d5d24af,0x2be20d75,0x65690220}},	//   تظام, _imsa, _पिया, vneh,
   {{0x60cd0527,0x26cc24b0,0x61e80201,0x973c00c4}},	//   _leam, _cedo_, kudl, _pića,
   {{0x63a324b1,0x656924b2,0x63ab008a,0x61e802fa}},	//   _rinn, tneh, _sugn, judl,
   {{0x60cd22c4,0x442d0809,0x63ab24b3,0x63a31556}},	//   _neam, txe_, _pugn, _sinn,
   {{0x656924b4,0xb4bb10ed,0x442d0161,0xb4ab152c}},	//   rneh, _अभी_, uxe_, _खली_,
   {{0xdce424b5,0x442d08a8,0x6d9324b6,0x6d440a00}},	//   vnič, rxe_, lçad, zkia,
   {{0x63a324b7,0x6d4424b8,0x443f090a,0x60cd24b9}},	//   _vinn, ykia, syu_, _beam,
   {{0xdce400e9,0x6d9324ba,0x63ab24bb,0x60cd0037}},	//   tnič, nçad, _tugn, _ceam,
   {{0x60cd07bc,0xe81e0f53,0x823500cd,0x63ab07ac}},	//   _deam, पिया_, زرگا, _uugn,
   {{0x6d5d24bc,0x61e824bd,0x63a30441,0x987a00ca}},	//   _amsa, budl, _uinn, מארט,
   {{0x614624be,0x60cd1ab6,0x00000000,0x00000000}},	//   _нека, _feam, --, --,
   {{0x60cd24bf,0xdce411c1,0x6d440138,0x2d9524c0}},	//   _geam, pnič, ukia, друс,
   {{0x6d4424c1,0x2fc900f0,0x7d1624c2,0x00000000}},	// [1a60] rkia, _gwag_, rdys, --,
   {{0x78a900e5,0x6d5d24c3,0xbcfb0154,0x6d4424c4}},	//   _agev, _emsa, _améd, skia,
   {{0x644024c5,0x7ae324c6,0x00000000,0x00000000}},	//   zymi, ónta, --, --,
   {{0xdb0424c7,0x26cc24c8,0x00000000,0x00000000}},	//   rpiñ, _sedo_, --, --,
   {{0x2d82191c,0x26cc1333,0xdb040072,0x680101f9}},	//   _ikke_, _pedo_, spiñ, _rájö,
   {{0x6d93016d,0x64400206,0x00000000,0x00000000}},	//   açad, vymi, --, --,
   {{0x78ad02e6,0x26cc24c9,0x64401765,0xdb0f0103}},	//   žava, _vedo_, wymi, _utcá,
   {{0x644024ca,0x6d93020d,0x26cc0113,0x945d007f}},	//   tymi, rçag, _wedo_, jańs,
   {{0x7bd624cb,0x60cd24cc,0x00000000,0x00000000}},	//   nsyu, _ream, --, --,
   {{0x60cd24cd,0x6560009e,0x61e802c9,0x394624ce}},	//   _seam, simh, tudl, lkos_,
   {{0x628704f9,0x60cd007a,0x7bd6005c,0x6728003d}},	//   żjon, _peam, hsyu, _indj,
   {{0x3946013f,0xf8cc24cf,0x7bd606a8,0x00000000}},	//   nkos_, ारिय, ksyu, --,
   {{0x61e824d0,0x60cd24d1,0x394624d2,0xb97b00ca}},	//   sudl, _veam, ikos_, מנטי,
   {{0x2d82010a,0x973c0a39,0x673a0216,0x00000000}},	//   _akke_, _mićo, _jotj, --,
   {{0xf8cc0bd9,0x6fd9009d,0xfe700037,0x00000000}},	//   ाराय, _भटकं, هدف_, --,
   {{0x2d5824d3,0x6b400088,0x2fc900f9,0x673a0381}},	//   пись_, _mögu, _twag_, _lotj,
   {{0x6b400088,0x67280dd9,0xb0c307d5,0x2129037a}},	// [1a70] _lögu, _ondj, _व्यग, _inah_,
   {{0x2d8224d4,0xe1ab034c,0x2aab0291,0x00000000}},	//   _ekke_, _घूँघ, стао_, --,
   {{0x7f3c00a1,0x62860034,0x442b0023,0x394602ac}},	//   _לעזו, ękow, ̣c_, fkos_,
   {{0x6d5d24d5,0x67280095,0xbcfb09b3,0x39460510}},	//   _umsa, _andj, _ejér, gkos_,
   {{0x248624d6,0x6d9324d7,0x2ba70096,0x673a0fcf}},	//   _nyom_, rçad, _कंटा, _botj,
   {{0x2be216e2,0x66e500ae,0x00000000,0x00000000}},	//   _पिता, фока, --, --,
   {{0x24860113,0xf8ae0018,0x673a04e9,0xe51e0ee0}},	//   _ayom_, اکہ_, _dotj, _मोहि_,
   {{0x25de049d,0xe3b924d8,0xf99312eb,0x6b400088}},	//   _गिरी_, оби_, _سبز_, _dögu,
   {{0x394d24d9,0x395f24da,0x25a624db,0x2d890113}},	//   _iles_, _imus_, _diol_, ilae_,
   {{0x673a0a39,0xaadd0096,0xc24524dc,0x00000000}},	//   _gotj, मणिक, днок, --,
   {{0x779012eb,0x6b9b0036,0x25a624dd,0x69d70072}},	//   _حیوا, _èugu, _fiol_, nsxe,
   {{0x69d8001f,0x2ec60e19,0x6b400149,0xb05b0fe8}},	//   ávei, वर्त, _högt, rbän,
   {{0x657c01f9,0x00000000,0x00000000,0x00000000}},	//   _írha, --, --, --,
   {{0x394d24de,0x62650058,0x776324df,0x2d89084e}},	//   _lles_, _овла, ninx, elae_,
   {{0x8fa31357,0x394d0167,0x945d007f,0x00000000}},	//   таре, _oles_, pańs, --,
   {{0xa187008f,0x00000000,0x00000000,0x00000000}},	//   _обща_, --, --, --,
   {{0x248601fa,0x00000000,0x00000000,0x00000000}},	// [1a80] _xyom_, --, --, --,
   {{0x394d002d,0x7bd6005a,0x395f24e0,0xe84102c6}},	//   _ales_, rsyu, _amus_, ůběž,
   {{0x6b5201c5,0x973c007e,0x776301ff,0x394624e1}},	//   _lægg, _sićo, dinx, tkos_,
   {{0x3946013f,0x395f002b,0x9cb6001c,0x394d24e2}},	//   ukos_, _cmus_, _زمست, _cles_,
   {{0x394624e3,0x6b400088,0x77630072,0x00000000}},	//   rkos_, _sögu, finx, --,
   {{0x394d0ba0,0xd5ba24e4,0x394624e5,0x25a624e6}},	//   _eles_, оси_, skos_, _siol_,
   {{0x394d24e7,0x09d80081,0xfbb00033,0xda650037}},	//   _fles_, _সহকা, _ছবিত, _كافي,
   {{0xb4e80557,0x2d800036,0x00000000,0x00000000}},	//   बले_, noie_, --, --,
   {{0xd90d1e49,0x25a60df4,0xdc1100a7,0x00000000}},	//   _دین_, _viol_, _məğl, --,
   {{0x25f60034,0x628f0034,0x764324e8,0x00000000}},	//   _एमपी_, ęcon, byny, --,
   {{0x6b400222,0x2129005c,0x25a60072,0x3b1800fc}},	//   _högs, _pnah_, _tiol_, _marq_,
   {{0x78a400d4,0x2d470231,0x056624e9,0x00000000}},	//   živu, _põem_, _ювен, --,
   {{0x6d43002d,0x59ce009d,0x63a40036,0x104b004d}},	//   _înai, हीतर, _èino, іями_,
   {{0x2bb5110f,0x00000000,0x00000000,0x00000000}},	//   _अंबा, --, --, --,
   {{0x27e624ea,0x3da701b3,0x6f1703a9,0xbf9b084e}},	//   hron_, драб, _vaxc, fwêr,
   {{0xa3e5007d,0x98a4022b,0x21290063,0xbf9b02ac}},	//   बूक_, _anmč_, _unah_, gwêr,
   {{0x1eab0037,0x6f17037a,0x21f803a9,0x00000000}},	// [1a90] _وادي_, _taxc, léh_, --,
   {{0xa3e624eb,0x6ec00096,0x7f5924ec,0xb4bb02d5}},	//   _बटन_, वडणु, _хаос_, _अभ्_,
   {{0x27e60890,0x21f801dc,0x27e000e3,0xab840f50}},	//   eron_, néh_, áinn_, тутк,
   {{0x26de02c9,0x0e9a00ca,0xab5b0233,0x00000000}},	//   _adto_, _משתל, _stüd, --,
   {{0x7d0d24ed,0x78ad08a9,0xf210009f,0x6d4f028d}},	//   meas, žavo, ़बड़_, _ilca,
   {{0xf77302fc,0xae03009d,0x7d0d24ee,0x76430084}},	//   خاص_, _लहान_, leas, tyny,
   {{0x27e624ef,0x776324f0,0xfbb50851,0xb9050033}},	//   aron_, rinx, _अंडम, _বউ_,
   {{0x76430a4f,0x7d0d24f1,0x00000000,0x00000000}},	//   ryny, neas, --, --,
   {{0x764300c2,0x99850103,0xf8b20266,0x3160022b}},	//   syny, _élő_, _תשמ_, _rmiz_,
   {{0x7d0d24f2,0x6b400222,0x6b5202b6,0x2be224f3}},	//   heas, _högr, _vægg, _पिसा,
   {{0x26c702dd,0x7d0d0084,0xe1f6002d,0x6d4f24f4}},	//   mbno_, keas, нгэ_, _olca,
   {{0x361a00a1,0x261100c4,0x7d0d044c,0xdb070216}},	//   _מועד, _išo_, jeas, _bijë,
   {{0x2d8024f5,0xdb06045e,0x7d0d24f6,0xab6403e0}},	//   voie_, _luká, deas, lmüş,
   {{0x6d4f0e4d,0x6b400088,0x21f801dc,0x3eac181f}},	//   _alca, _lögr, béh_, ødt_,
   {{0x23650222,0x7d0d036b,0x6b52181f,0x2d9624f7}},	//   milj_, feas, _jæge, ерас,
   {{0x1de10980,0xf11a0cd2,0x7d0d24f8,0x00000000}},	//   _फिरत, _رغبت_, geas, --,
   {{0x6b5201c5,0xec770012,0x63ad028d,0xed57001f}},	// [1aa0] _læge, епт_, _èand, хот_,
   {{0xaca40174,0x27e624f9,0x2d800036,0x06e50033}},	//   _nzụt, vron_, soie_, প্তি,
   {{0x2d730542,0x7d0d24fa,0xeef700ca,0xdb070113}},	//   mćen_, beas, _אמיר_, _mijè,
   {{0x27e624fb,0xaca40294,0x6d4f009c,0xdb060437}},	//   tron_, _azụt, _glca, _duká,
   {{0x27e624fc,0x58831855,0x00000000,0x00000000}},	//   uron_, лыша, --, --,
   {{0x7bc424fd,0xf0930130,0x27e624fe,0x27e024ff}},	//   mpiu, אנד_, rron_, šino_,
   {{0x387200d3,0x27e62500,0x06cf0033,0xe1e70397}},	//   _ţară_, sron_, _রাশি, _حس_,
   {{0xe9a30b9c,0x69dc209a,0xdb1d0154,0x27e62501}},	//   _басп, _ivre, _atsè, pron_,
   {{0xb60300d9,0x888100cd,0x7bc40063,0xd7ca0076}},	//   āšan, _پیون, npiu, _رواه_,
   {{0x26de0124,0x77830915,0x973c007e,0x7d0d00ae}},	//   _udto_, _блуз, _mićk, zeas,
   {{0xdb072502,0x2fc0030a,0x00000000,0x00000000}},	//   _dijè, _atig_, --, --,
   {{0x613f00dd,0x29020149,0xd04600a7,0x9f4b0216}},	//   _pëlq, _ökad_, lakə, pucë_,
   {{0x656200f9,0xe53b00ca,0x2bb50980,0x7d0d020a}},	//   _imoh, _מתאר, _अंधा, veas,
   {{0x4ea72503,0xdb070052,0xd0ed0096,0x69dc0117}},	//   ерба, _vijë, _झाकण_, _ovre,
   {{0x3ea52504,0x7d0d2505,0xdcfd00bd,0xd24f23b8}},	//   ält_, teas, _jisħ, _сц_,
   {{0xdb06025b,0x2bb5114d,0x3ceb00c3,0x6ab90d77}},	//   _ruká, _अंदा, टलें_, इड्र,
   {{0x69dc19a6,0xe7cf0034,0x7d0d2506,0x00000000}},	// [1ab0] _avre, _सौंप, reas, --,
   {{0x7d0d2507,0x20090167,0x64c402c6,0x00000000}},	//   seas, _ipai_, lčič, --,
   {{0x7d0d2508,0x26c7033b,0xdcfd2509,0x69dc05db}},	//   peas, vbno_, _eksā, _cvre,
   {{0x3f83250a,0x64c4103b,0x2139250b,0x7982250c}},	//   loju_, nčič, njsh_, goow,
   {{0xb909250d,0x69dc250e,0x399e02c6,0xa2b800b6}},	//   _मय_, _evre, _růst_, ोरञ्,
   {{0x65620124,0x3f83250f,0x00000000,0x00000000}},	//   _amoh, noju_, --, --,
   {{0xc8f50465,0xda050f53,0xf77016c4,0xc447010d}},	//   _извъ, _रहित_, حان_, کیشن_,
   {{0xab6403e0,0x7c2000c4,0xdb0f0113,0x2ebf0b76}},	//   rmüş, _šmri, _sucè, ्रुत,
   {{0x290f2510,0x3f832511,0x2365031a,0x98a400e8}},	//   mega_, koju_, tilj_, _domē_,
   {{0x290f2512,0x65621195,0x628a0ac9,0x3f8300c6}},	//   lega_, _emoh, _byfo, joju_,
   {{0x2fc02085,0x628a0150,0x63aa00bd,0xa3e502d5}},	//   _stig_, _cyfo, _difn, बूज_,
   {{0x290f0b27,0x291d2513,0x628a0150,0x50460831}},	//   nega_, ndwa_, _dyfo, вемб,
   {{0x61e82514,0x659401b6,0xc8da00d7,0x00000000}},	//   ardl, _сацу, וקרט, --,
   {{0x290f2515,0xdf1502ec,0x3f830880,0x2d9901ee}},	//   hega_, льсь, goju_, _ahse_,
   {{0x290f0b27,0x5ed400c7,0x628a00f0,0x200901c8}},	//   kega_, _তাদে, _gyfo, _epai_,
   {{0x290f2516,0x247e0134,0x7c290357,0x00000000}},	//   jega_, ịme_, _šera, --,
   {{0xc4d20130,0x290f0006,0x6da30012,0x291d0a15}},	// [1ac0] יגן_, dega_, рита, ddwa_,
   {{0x7bc4004b,0x6d9300b3,0x00000000,0x00000000}},	//   rpiu, rçaa, --, --,
   {{0xab5b02e2,0xa9a6008f,0xe8fa01b3,0xbea600f6}},	//   _stüc, вижд, дле_, _јанк,
   {{0x290f2517,0xd7e6224a,0x81bc01d3,0x6d932518}},	//   gega_, віко, lvēc, lçan,
   {{0xa41c00c7,0x79820188,0xe7b32519,0x00000000}},	//   _তথ্য_, roow, لمند, --,
   {{0x6d93251a,0xbcfb000d,0x69d80618,0x69c501fa}},	//   nçan, _jmén, áves, bphe,
   {{0x6f030b88,0x69dc1419,0x290f251b,0x69c50441}},	//   _önce, _uvre, bega_, cphe,
   {{0x290f08a9,0x38c809e5,0x151400d3,0xd9430950}},	//   cega_, _ساری_, удия, _кеси,
   {{0xa8870077,0x98a317a6,0xdb0f002b,0x49170096}},	//   _айта_, _вите, _sucé, _नसतो_,
   {{0x5fdc02b0,0x2bb5009f,0xdcfd0078,0x00000000}},	//   _बिजल, _अंसा, _tisħ, --,
   {{0xe737251c,0x3f83251d,0x6d56026d,0x00000000}},	//   _шеф_, voju_, khya, --,
   {{0xbcfb0257,0x27e904fa,0xfd1f0139,0x628a0094}},	//   _amén, šane_, _akìn_, _vyfo,
   {{0xc0ab06fa,0x5064251e,0x6d56251f,0x3f832520}},	//   بادل_, атра, dhya, toju_,
   {{0x44262521,0x628a2522,0x69c52523,0x973c0559}},	//   _iro_, _tyfo, yphe, _bići,
   {{0x3f832524,0x1df81402,0x00000000,0x00000000}},	//   roju_, керы_, --, --,
   {{0x44262525,0x63ad0451,0x6e2504e9,0xf8cc1677}},	//   _kro_, _èanc, _vrhb, ारोप,
   {{0x290f2526,0x27e00ebd,0x442603a9,0x69d002d5}},	// [1ad0] vega_, šinj_, _jro_, डीसी,
   {{0x69c52527,0x44262528,0x3b542529,0x290f0079}},	//   tphe, _mro_, акур, wega_,
   {{0x290f252a,0x7c260364,0x00000000,0x00000000}},	//   tega_, _erkr, --, --,
   {{0x4426252b,0xa6cf0033,0x00000000,0x00000000}},	//   _oro_, _রাইট, --, --,
   {{0x4426252c,0x290f252d,0x6d4d252e,0x69c5252f}},	//   _nro_, rega_, mkaa, sphe,
   {{0x290f05a7,0x6d4d025e,0x778400f7,0x69c52530}},	//   sega_, lkaa, аліз, pphe,
   {{0x290f1abe,0x6446004d,0x7f3c006e,0x69d80218}},	//   pega_, økin, ועגו, šver,
   {{0xdb0d11c4,0x6d4d2531,0x7d1d2532,0x00000000}},	//   mpañ, nkaa, _jass, --,
   {{0x7d1d0d63,0x44262533,0x79890134,0x38600037}},	//   _mass, _cro_, _ikew, úirt_,
   {{0x7d1d2534,0x96ca0455,0xdced0039,0x44262535}},	//   _lass, _स्पॉ, dnač, _dro_,
   {{0x44262536,0x6d4d2537,0xfb1600c1,0xe6590037}},	//   _ero_, kkaa, אַכט_, _ثلاث_,
   {{0x7d1d2538,0x442600f0,0x6d4d2539,0x7bc100d2}},	//   _nass, _fro_, jkaa, _člun,
   {{0x4426253a,0x6d4d008a,0x65690084,0x79890051}},	//   _gro_, dkaa, mieh, _mkew,
   {{0x973c14f3,0x06e50081,0x6569253b,0x645b0239}},	//   _pići, প্রি, lieh, mzui,
   {{0x7d1d253c,0xfce62348,0x6d93253d,0xb06300aa}},	//   _bass, лово, rçan, äärs,
   {{0x7d1d253e,0x6d4d253f,0x79890294,0xbacd0033}},	//   _cass, gkaa, _nkew, _লাগছ,
   {{0x5f7600cd,0x64490b8b,0x645b01cb,0xdce400c4}},	// [1ae0] _مادر, nyei, nzui, hnić,
   {{0x6d56023f,0x79892540,0x799b0d2a,0x6d9303e0}},	//   shya, _akew, _ahuw, lçal,
   {{0x7d1d2541,0x6d4d0188,0x6e4609b9,0xdce414f3}},	//   _fass, bkaa, _сенз, jnić,
   {{0x3940003e,0x6d932542,0x799b0350,0x753b083e}},	//   ðis_, nçal, _chuw, jjuz,
   {{0x6f1e00fb,0x799b00bf,0x65690407,0x48e32543}},	//   _kapc, _dhuw, dieh, сочв,
   {{0x779100d0,0x7c2406d1,0x79890134,0x7d1d1404}},	//   قیقا, mvir, _ekew, _zass,
   {{0xdced18cc,0x44262544,0x1c1c0469,0x63a40036}},	//   znač, _sro_, निकल_, _èini,
   {{0x44261000,0x69de2545,0x7414177a,0x645b01c0}},	//   _pro_, mspe, لوبا, fzui,
   {{0x7c242546,0x69de2547,0x136a0476,0x06f60241}},	//   nvir, lspe, ешни_, _مساج,
   {{0xa3e510ed,0xbcfb025a,0xe3bf03be,0x07a60291}},	//   _फिर_, _amél, íña_, _сазн,
   {{0xe13502fd,0x69de2548,0x92942549,0x65690220}},	//   анны, nspe, ранц, bieh,
   {{0x25f3007d,0x4426254a,0x69de00e3,0x65690220}},	//   ्झरी_, _tro_, ispe, cieh,
   {{0x442602dd,0x644600aa,0x7d0413ea,0x60d6254b}},	//   _uro_, äkid, dfis, _deym,
   {{0x7d1d254c,0x2b8f02e2,0x69de254d,0x7c24254e}},	//   _sass, rück_, kspe, dvir,
   {{0x7d04254f,0xd9040068,0x6d4d2550,0x8d770604}},	//   ffis, _ٹی_, tkaa, هارا,
   {{0x629800e9,0x69de0bab,0x7d1d0078,0x9d181a57}},	//   _izvo, dspe, _qass, лост_,
   {{0x6d4d025e,0x81b600c7,0x7d1d2551,0x69de2552}},	// [1af0] rkaa, _ছবি_, _vass, espe,
   {{0x7d1d2553,0x6d4d2554,0x656902e2,0x799b0d2a}},	//   _wass, skaa, zieh, _shuw,
   {{0x7d1d2555,0x69de2556,0x6d4d2557,0x7c2400ce}},	//   _tass, gspe, pkaa, avir,
   {{0xa3e504f1,0xe0e70033,0x973c031a,0xdce40034}},	//   _फिल_, গ্রহ_, _miću, knię,
   {{0x6d932558,0x69de00ae,0xdb0d0328,0x5fb50285}},	//   nçam, aspe, spañ, ंदिल,
   {{0x6d5801b3,0xb8ec0789,0x99d70f36,0x5fbc006e}},	//   _įvai, _श्_, _مترا, עצונ,
   {{0xb8db00c7,0x65692559,0xf8c90257,0xeef800ca}},	//   _আজ_, tieh, _créé_, אמור_,
   {{0x7545255a,0xdce40335,0x79a40396,0x7bdf255b}},	//   рниз, rnić, _груе, osqu,
   {{0xdb0f255c,0x65690407,0x7bdf042c,0xdce4255d}},	//   _lucí, rieh, nsqu, snić,
   {{0x7bdf0161,0xe787255e,0x60d6255f,0x65692560}},	//   isqu, _субо, _seym, sieh,
   {{0x291f00aa,0x7d042561,0x656901c0,0x7c29215a}},	//   _kaua_, yfis, pieh, _šerl,
   {{0x6026022a,0x291f034f,0xc4f80037,0x6f1e2562}},	//   адма, _jaua_, _معها_, _sapc,
   {{0xb4c306e4,0x291f0051,0x6d930511,0x60db01cd}},	//   ्री_, _maua_, rçal, ðuma,
   {{0x2d8b030b,0x69de2563,0x644600c2,0x25af007e}},	//   _akce_, yspe, äkie, _higl_,
   {{0x7d040dfd,0xbea60ebf,0x6d9305fe,0x60d62564}},	//   tfis, равк, pçal, _teym,
   {{0x7c2401b3,0x27e0011d,0x69de032e,0x00000000}},	//   tvir, šini_, vspe, --,
   {{0xdee61f0d,0x7d040088,0xab662565,0x63bb019f}},	// [1b00] _копи, rfis, авал, nqun,
   {{0x69de2566,0x68fb2567,0xb4c30be4,0xd00f015a}},	//   tspe, _acud, ्रु_, _کلی_,
   {{0xbd8a003f,0x399c00e3,0x69de2568,0x200200bc}},	//   _لندن_, híse_, uspe, ltki_,
   {{0x6d4300d3,0x68fb009c,0x63a4028d,0xc7c62569}},	//   _înap, _ccud, _èinv, аски,
   {{0x779412eb,0x27e0152f,0xdb0d01cd,0xdb0f044c}},	//   میرا, éin_, ppað, _ducâ,
   {{0x69de256a,0x2d92256b,0x7bc6007b,0x00000000}},	//   pspe, llye_, _itku, --,
   {{0xdb0e023b,0x25af007e,0xcb67002d,0xb4c30b2b}},	//   _libë, _bigl_, _таре_, ्रू_,
   {{0x27e90b4b,0x399c0037,0xa5340b1b,0x291f0634}},	//   šana_, físe_, снич, _gaua_,
   {{0x973c00cc,0xd497002d,0x8cd709a1,0x00000000}},	//   _siću, ирь_, बरतो, --,
   {{0x3944256c,0x316b0034,0xb354256d,0x291f024a}},	//   _homs_, wicz_, скош, _zaua_,
   {{0xe81e218b,0x44e80081,0x7c29003d,0x291f0239}},	//   पिका_, ক্ষক_, _ġerm, _yaua_,
   {{0x7bc602e6,0x26dc256e,0x2b061687,0x8c480511}},	//   _otku, lavo_, स्तु_, _kağı,
   {{0xb4d21981,0x7afc00cc,0x1b1d0033,0x3944256f}},	//   वरी_, _ocrt, নাতে_, _moms_,
   {{0x2005003d,0x26dc2570,0xdb0e0216,0x6d932571}},	//   ċli_, navo_, _dibë, rçam,
   {{0x139b040a,0x539b00a1,0x629800cc,0xc1790138}},	//   _שבוע, _שיוו, _uzvo, urės_,
   {{0x39442572,0x3a2d2573,0x00000000,0x00000000}},	//   _noms_, _čep_, --, --,
   {{0x60dd00f9,0x291f09a1,0x26dc2574,0xdb0e0154}},	// [1b10] masm, _raua_, kavo_, _kibè,
   {{0x7bdf025a,0x26dc2575,0x68fb00e5,0x2ef52576}},	//   rsqu, javo_, _scud, _узор,
   {{0x26dc013f,0x79a705da,0x6f15034f,0x1ddb023a}},	//   davo_, арде, mezc, _बबित,
   {{0x39442577,0x8c4808bb,0xdb0e06a3,0xaca30134}},	//   _coms_, _bağı, _libè, _anụb,
   {{0xdc350132,0x27ff014b,0xec350142,0x26dc004b}},	//   _האָט_, _qqun_, _האָר_, favo_,
   {{0x8c4807d1,0x6dbc0087,0xf3fe0081,0x6f152578}},	//   _dağı, _očal, ্টার_, nezc,
   {{0x6b52052f,0x291f2579,0xb345016d,0xcf580327}},	//   _mægl, _taua_, _loçã, שבות_,
   {{0xb4c30c3c,0xe3bf03be,0x741500e3,0x5e7800ca}},	//   ्रे_, íño_, موعا, יתון_,
   {{0x69c70ea3,0x2120048e,0x26dc0087,0xb3450161}},	//   _htje, _raih_, bavo_, _noçã,
   {{0xda0e1179,0x26dc0451,0x4374004d,0x00000000}},	//   _सहमत_, cavo_, жуют, --,
   {{0xe69500e3,0x6f150a43,0xdb0e0113,0x00000000}},	//   _الاد, dezc, _dibè, --,
   {{0x6721257a,0xf652028c,0x8c4807aa,0x04c900b9}},	//   _halj, _מצב_, _yağı, _صوتي_,
   {{0x6721257b,0xc88200a7,0x9879006e,0x297a0142}},	//   _kalj, _peşə_, ראָט, רטרא,
   {{0x2002257c,0x69c70268,0x67210167,0x00000000}},	//   rtki_, _otje, _jalj, --,
   {{0xed5a0b99,0x2002257d,0x6b6f0138,0xaea90037}},	//   гов_, stki_, _mėgė, لطفل_,
   {{0x26dc043c,0x7afc02ef,0xc21200ca,0x60dd0850}},	//   zavo_, _scrt, _זהה_, casm,
   {{0x3944257e,0xdca30565,0x6fb2007f,0x69c71341}},	// [1b20] _roms_, зати, _इंटू, _atje,
   {{0x39440934,0xb05b0149,0x6721257f,0xef1a0831}},	//   _soms_, rbät, _nalj, _смо_,
   {{0x260108a8,0x26dc0138,0x3f8a2580,0x8c480342}},	//   jóo_, vavo_, mobu_, _sağı,
   {{0x3f8a08dd,0xd91000d0,0xb4c32581,0x69c30037}},	//   lobu_, بیر_, ्रो_, ínea,
   {{0x7d16008a,0xdb0e0257,0x6d460113,0x2be20c54}},	//   meys, _libé, _ioka, _पिटा,
   {{0xa09b0130,0x06d800c7,0x7d162582,0x6d460449}},	//   ניסט, _সাহি, leys, _hoka,
   {{0x6d462583,0x39442584,0x60c404c3,0x6dbc0031}},	//   _koka, _toms_, _ofim, _očam,
   {{0x6d462585,0x7d162586,0x26dc2587,0x8c48013c}},	//   _joka, neys, savo_, _tağı,
   {{0x6d462588,0x6721023b,0x26dc0077,0x00000000}},	//   _moka, _falj, pavo_, --,
   {{0x6d462589,0x69c104ea,0x8c1b00a1,0x7d160188}},	//   _loka, _élec, נויי, heys,
   {{0x60c908a8,0x60dd0a00,0x7179215d,0x61151402}},	//   ñemo, tasm, ибор_, одну,
   {{0x27e0005f,0xdb0e00d1,0x6d46258a,0xb3450131}},	//   šinu_, _dibé, _noka, _poçã,
   {{0xc058258b,0xd4670114,0x60dd258c,0x7d16258d}},	//   бір_, _лице_, rasm, deys,
   {{0x3f8a258e,0xc058097a,0x2bdb0861,0x60dd258f}},	//   gobu_, сію_, मीफा, sasm,
   {{0x6f150890,0xdb0e0113,0x6d9300ee,0xa2b70285}},	//   rezc, _gibé, lçai, ोडर्,
   {{0x22ae0253,0x7d16008a,0x6d4603e3,0x2b9411d0}},	//   mək_, geys, _coka, bäck_,
   {{0x6d9304ea,0x69c700f2,0x7ff70037,0x63a40036}},	// [1b30] nçai, _stje, _اسعا, _èins,
   {{0x8aa70161,0x00000000,0x00000000,0x00000000}},	//   бред, --, --, --,
   {{0x7d160188,0x2bb50096,0x26010072,0xc8b50fe9}},	//   beys, _अंका, xóo_, ослы,
   {{0x6dbc005f,0x75220181,0x7d16008c,0x00000000}},	//   _očaj, _naoz, ceys, --,
   {{0x672113e3,0x261b007d,0xf80700d3,0x387f02a1}},	//   _palj, _मनही_, счен, _qxur_,
   {{0x2fc90124,0x27e90128,0x7bcd2590,0xdb07037a}},	//   _mtag_, šano_, mpau, _fijá,
   {{0x672102e6,0x69c70ea3,0x672304a3,0x6d460517}},	//   _valj, _utje, rdnj, _yoka,
   {{0x22ae0092,0xdb0e2591,0x67212592,0x195800ae}},	//   dək_, _ribé, _walj, _ласы_,
   {{0xe3b60ff8,0x7bcd2593,0x67212594,0x27e000e3}},	//   обы_, npau, _talj, áint_,
   {{0x98ad0220,0x798b2595,0x8c1c00ca,0x43690077}},	//   _hneď_, logw, רוזי, раон_,
   {{0xe299153d,0x4427037f,0x7d160188,0x2fc901cb}},	//   ран_, _گراف, yeys, _atag_,
   {{0x7d160188,0xe4350281,0x00000000,0x00000000}},	//   xeys, _وفاد, --, --,
   {{0x6d462596,0x2bb52183,0x7bcd2597,0x656b2598}},	//   _roka, _अंगा, jpau, _imgh,
   {{0x6d462599,0xbf9b0396,0x83fd0018,0xdb0e259a}},	//   _soka, stên, rződ, _tibé,
   {{0x22ae0253,0x3f8a025b,0x61460424,0x7d16259b}},	//   cək_, robu_, _мека, teys,
   {{0x68e900d1,0x2b94042c,0x3f8a259c,0xb05b02c3}},	//   _nded, päck_, sobu_, rbär,
   {{0x7d16259d,0x7bcd259e,0x6ab202d5,0xed57001f}},	// [1b40] reys, gpau, जश्र, цот_,
   {{0x68e9259f,0x7d16008c,0x6d46007f,0x290d044c}},	//   _aded, seys, _woka, _abea_,
   {{0x32050054,0x6d4625a0,0xaca40af0,0xc8ca25a1}},	//   ntly_, _toka, _ilọs, لوان_,
   {{0xc27a006e,0x7d160188,0x25ef0096,0x798b25a2}},	//   ברעי, qeys, ींनी_, gogw,
   {{0x8816177a,0x68e925a3,0x6dbc0220,0x3ce0023e}},	//   تباط, _dded, _očak, maiv_,
   {{0x05ea25a4,0xe3a7048f,0x68e9063d,0xba090033}},	//   афии_, _زر_, _eded, রয়েড_,
   {{0xd6d90a8d,0xda0e0782,0xd5b702fd,0x79830294}},	//   сті_, _सहित_, осы_, ọwap,
   {{0x7c291197,0x00000000,0x00000000,0x00000000}},	//   _šeri, --, --, --,
   {{0x8d5b006e,0x00000000,0x00000000,0x00000000}},	//   יכקי, --, --, --,
   {{0xc7b90103,0x3ce001fa,0xd7640281,0x6d93014b}},	//   _erős_, haiv_, _عنای, rçai,
   {{0x2c060081,0x2b9401bf,0x2012022b,0x84ea02d1}},	//   রিয়ে_, räch_, _apyi_, _نفاق_,
   {{0x81bc0b4b,0x22ae01d4,0x6dbc0234,0x9cfc0033}},	//   lvēk, rək_, _ečak, ঁজুন_,
   {{0x22ae013c,0x320500d7,0x69c80231,0x00000000}},	//   sək_, atly_, _édef, --,
   {{0x6d9325a5,0xdefb013f,0x7c3b00b3,0x389b0142}},	//   nçav, шым_, _àuri, ייכנ,
   {{0xd25000e3,0x320525a6,0x6d580138,0x20120154}},	//   _سنة_, ctly_, _įvar, _epyi_,
   {{0x395d023e,0x6ecb09c4,0x8d770103,0x7bcd10a5}},	//   xhws_, _त्रु, زازا, tpau,
   {{0x4c9400c2,0x0cab25a7,0x00000000,0x00000000}},	// [1b50] дитс, ртви_, --, --,
   {{0x7bcd25a8,0x399c003e,0x88d70033,0x00000000}},	//   rpau, vísa_, _হাইক, --,
   {{0x391506e7,0x7bcd013f,0x998702c6,0x0a681c47}},	//   змер, spau, ínů_, орци_,
   {{0x28f825a9,0x9b45001c,0x7bcd007b,0x628e007f}},	//   жець_, _کنسو, ppau, żbow,
   {{0x798b25aa,0xdd3a00ca,0x5d3a00ca,0x3d3a00ca}},	//   rogw, _הערכ, _התרא, _הגרס,
   {{0x9a871057,0x70b706e4,0x81bc00e8,0x00000000}},	//   _дубл, ःशुल, rvēj, --,
   {{0xd90f0068,0x64460329,0xb9010033,0x80dc0a43}},	//   _لیا_, äkin, _দা_, _ভাস্,
   {{0xea0000de,0xab5b042c,0x6d930231,0x68e9063d}},	//   _hiếp_, _stüh, açav, _uded,
   {{0x657e0257,0xb7d5001c,0xea000023,0xf3f10037}},	//   épha, _رقاب, _kiếp_, رأة_,
   {{0x0cb80e46,0xdce40233,0x6d5a00e8,0x26c5039f}},	//   _अल्म, kniğ, ītai, _uflo_,
   {{0xbcfb0065,0x00000000,0x00000000,0x00000000}},	//   _iléf, --, --, --,
   {{0x9f42030b,0xf8cb0179,0x320500d7,0x00000000}},	//   mské_, ाडिय, rtly_, --,
   {{0x9f420363,0x44290bfe,0x659a0089,0x23290e21}},	//   lské_, _éa_, _פינק, _голи_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x9f420343,0x6da625ab,0x2bb5000f,0x442f0085}},	//   nské_, зива, _अंजा, _hrg_,
   {{0xf8b900de,0x442f09a4,0xc6920266,0x657b25ac}},	//   _ngũ_, _krg_, גאל_, nnuh,
   {{0x27e925ad,0xaaba0867,0xf3f900ae,0x81a501c3}},	// [1b60] šanj_, مدار_, nuţ_, _تحول,
   {{0x8b230ae3,0x442f009c,0xed160034,0x8b26013f}},	//   ндуе, _mrg_, _łódź_, ядзе,
   {{0x9f420146,0x7c2f25ae,0xbed7021e,0x69da0037}},	//   jské_, _ercr, _מויז_, صباح_,
   {{0xa6d80081,0x9f42033d,0xf99225a1,0x00000000}},	//   _সাইট, dské_, ربا_, --,
   {{0x181800bf,0x98a600ae,0x28cb25af,0x00000000}},	//   تراک_, чиде, ाड़ि, --,
   {{0xbb4a0080,0x7bcb2567,0x6d5603e3,0x00000000}},	//   _الآن_, ígue, lkya, --,
   {{0x442f03bd,0xdb0f0131,0x6b5201cd,0x6d9325b0}},	//   _arg_, _sucç, _nægi, rçav,
   {{0x6d440759,0xd90d09b4,0x442f0808,0xceb3040a}},	//   njia, _نیم_, _brg_, עיה_,
   {{0x9f590222,0x68e20231,0x00000000,0x00000000}},	//   ltså_, maod, --, --,
   {{0x27e625b1,0x442f0479,0x68e225b2,0xdb1d0161}},	//   mson_, _drg_, laod, _ausê,
   {{0x442f0272,0x6d56006d,0x27e625b3,0x98bf0090}},	//   _erg_, kkya, lson_, _qmuħ_,
   {{0x463b00c1,0x26de06a8,0x68e20239,0x55bb0327}},	//   _לעבע, _heto_, naod, _המאו,
   {{0x26de00dd,0x24aa0081,0x6283034f,0xbf9b0131}},	//   _keto_, _গ্রহ, _exno, stêm,
   {{0x27e604ea,0xd37000bf,0xbf9b00fd,0x2327007b}},	//   ison_, _جهت_, ptêm, _ночи_,
   {{0x27e601c2,0x80dc0081,0x2cb90167,0x26de25b4}},	//   hson_, _ভার্, _pgsd_, _meto_,
   {{0x26de25b5,0x6d440216,0x5d9901b3,0x61fa25b6}},	//   _leto_, gjia, ікаў_, mutl,
   {{0x68e225b7,0x27e60a39,0x7bc0020d,0x61fa25b8}},	// [1b70] daod, json_, _émul, lutl,
   {{0x8aa70c58,0x6d5625b9,0x3213007f,0x7ac413c7}},	//   пред, akya, łbyś_, есце,
   {{0x98bf00d3,0x657b008a,0x61fa25ba,0xd8ca0134}},	//   _nouă_, ynuh, nutl, _ịpịr,
   {{0x1a6803ed,0x9f42025b,0xdb0625bb,0x0dba0018}},	//   سیقی_, vské_, _zukü, _گئیں_,
   {{0xea0000ef,0x26de25bc,0x7d0d25bd,0x443f003d}},	//   _tiếp_, _beto_, mfas, xxu_,
   {{0x9f420074,0x7c2d25be,0x26de0044,0xe7360e21}},	//   tské_, mvar, _ceto_, деш_,
   {{0xa3df0296,0x26de0063,0x442f25bf,0xe70801c3}},	//   धीन_, _deto_, _srg_, ستون_,
   {{0x7d0d25c0,0x98bf002d,0x9f420618,0xd4d90426}},	//   nfas, _două_, rské_, цькі_,
   {{0xb4bd02e8,0xbcfb25c1,0xdc0b0081,0x7c2d25c2}},	//   _आली_, _elég, রিকস_, nvar,
   {{0x04ff0081,0x9f4200b6,0xdb1d0212,0x443f25c3}},	//   ্যের_, pské_, _utsä, rxu_,
   {{0x6d5d0511,0x61fa1192,0x7c2d25c4,0xbcfb0113}},	//   _olsa, gutl, hvar, _kléd,
   {{0x442f0660,0x6560152f,0xdb06002b,0x348e0129}},	//   _trg_, chmh, _yukó, ịdị_,
   {{0x442f0063,0x7d0d25c5,0x995c0e43,0x7c2d05db}},	//   _urg_, dfas, níš_, jvar,
   {{0xdfcf0080,0x442d25c6,0x6d5d25c7,0x61fa25c8}},	//   شيف_, mve_, _alsa, butl,
   {{0x7d0d25c9,0x7c2d0138,0x78bb0361,0x00000000}},	//   ffas, evar, _oguv, --,
   {{0x752925ca,0x78bb068d,0x6da3017b,0x6d5625cb}},	//   ndez, _nguv, виса, ukya,
   {{0x7c2d25cc,0x442d25cd,0x6d440063,0xdced0e94}},	// [1b80] gvar, nve_, rjia, znać,
   {{0xa3df0557,0xeb9f00d6,0x995c0146,0xda660037}},	//   धीय_, _spør_, díš_, واضي,
   {{0x26de22bf,0x442d25ce,0x7c2d25cf,0x69c10103}},	//   _reto_, hve_, avar, _élel,
   {{0x442d02e6,0x26de25d0,0x98a025d1,0x6f1c047e}},	//   kve_, _seto_, žič_, lerc,
   {{0xa3f80081,0x442d00dd,0x8b660260,0x75290036}},	//   _অন্য_, jve_, _قاسم, ddez,
   {{0x27e6064b,0x644600aa,0x442d25d2,0xbcfb0af0}},	//   rson_, äkim, dve_, _eléd,
   {{0xe1e700fb,0x442d25d3,0x27e625d4,0x16de0285}},	//   _جس_, eve_, sson_, _नजीब,
   {{0x6f1c25d5,0xbcfb0113,0xfaa325d6,0x03c625d7}},	//   herc, _gléd, _расо, мсом,
   {{0x26de25d8,0xea0000de,0x15ea0980,0x442d25d9}},	//   _teto_, _khắp_, _टिकर_, gve_,
   {{0x6d9325da,0x68e025db,0x61fa25dc,0x06d80033}},	//   nçar, _hemd, tutl, _সাকি,
   {{0x442d25dd,0x68e00da7,0x7d0d25de,0xdb150383}},	//   ave_, _kemd, yfas, _dizè,
   {{0x442d25df,0x68e000e7,0x394625e0,0x9f4000ee}},	//   bve_, _jemd, njos_, _avià_,
   {{0x3946016d,0x6f1c25e1,0x672825e2,0x00000000}},	//   ijos_, ferc, _kadj, --,
   {{0x6f1c25e3,0x61fa25e4,0x399525e5,0x7c2d013c}},	//   gerc, putl, låst_, vvar,
   {{0x672800dd,0x7d0d25e6,0xbf9b0131,0x6e9425e7}},	//   _madj, tfas, ntêi, виру,
   {{0xbcfb25e8,0x672825e9,0x2fc0015e,0x6abc05db}},	//   _amér, _ladj, _fuig_, _agrf,
   {{0x7d0d25ea,0x6f1c25eb,0xdd9400c6,0xe81e121d}},	// [1b90] rfas, berc, таты, _मैला_,
   {{0x6f1c25ec,0x6728113c,0x386625ed,0x7d0d25ee}},	//   cerc, _nadj, dzor_, sfas,
   {{0x442d25ef,0x3f9125f0,0x2bdf1687,0x68e0039f}},	//   zve_, mozu_, _पौरा, _bemd,
   {{0xb4bd02e8,0x8aa41b48,0xdb1d25f1,0x63b825f2}},	//   _आले_, труд, _musé, _livn,
   {{0xe73925f3,0xdd910068,0x27e925f4,0x69dc25f5}},	//   зел_, _لوگ_, éan_, _ewre,
   {{0x25a60018,0x442d25f6,0x29040090,0x9f59020d}},	//   _ahol_, vve_, _ecma_, fusé_,
   {{0xf7700602,0x995c0074,0x7ae525f7,0xe61112eb}},	//   جان_, síš_, maht, اشت_,
   {{0x442d25f8,0x6f1c0074,0x942519a9,0x6934129c}},	//   tve_, zerc, емие, _инсу,
   {{0x442d25f9,0x291d25fa,0x75290018,0x96ca0455}},	//   uve_, mewa_, rdez, _स्कॉ,
   {{0x291d068d,0x1b1d00c7,0x62980185,0x672825fb}},	//   lewa_, নাকে_, _byvo, _gadj,
   {{0x63b8042d,0x442d25fc,0x6f1c04d6,0x395f25fd}},	//   _divn, sve_, verc, _klus_,
   {{0x2fc005fe,0x291d25fe,0x6f05009c,0x25a6033c}},	//   _puig_, newa_, _achc, _ghol_,
   {{0x25ad25ff,0x394d0665,0xdbd71d2d,0x442d0052}},	//   mmel_, _moes_, _jäät, qve_,
   {{0x7ae50991,0x291d2600,0x2bb20154,0x394d2601}},	//   jaht, hewa_, _gņch_, _loes_,
   {{0x291d2602,0x7bdd0f20,0x2129008c,0x629800c6}},	//   kewa_, _awsu, _faah_, _gyvo,
   {{0xa0a6004b,0x2fc011b9,0x291d2603,0xb4bd0096}},	//   _пайд, _tuig_, jewa_, _आलो_,
   {{0xac861211,0x291d2604,0x2bdb030b,0xa8020092}},	// [1ba0] хгал, dewa_, मीला, _çıxd,
   {{0x395f2605,0xe6250028,0x6b5202b6,0x31720094}},	//   _alus_, _đông_, _nægt, _hmyz_,
   {{0x67282606,0xfce62607,0x68e02608,0x21292609}},	//   _radj, _поно, _pemd, _yaah_,
   {{0x8c461a67,0x672802dd,0xab5b0364,0x291d260a}},	//   _земе, _sadj, _stüt, gewa_,
   {{0x394d260b,0xea000023,0x2d80260c,0x6728260d}},	//   _does_, _thắp_, mnie_, _padj,
   {{0x2d800067,0x69dc016d,0x395f260e,0x96f8260f}},	//   lnie_, _twre, _elus_, фект_,
   {{0xfaa32610,0x56932611,0x395f003d,0x2d801b50}},	//   _баро, лашт, _flus_, onie_,
   {{0x291d2612,0xa53411d9,0x248603be,0x2d802613}},	//   cewa_, тнич, _pxom_, nnie_,
   {{0x63b82614,0x2d802615,0x2bb20154,0x00000000}},	//   _pivn, inie_, _pņch_, --,
   {{0x2d802616,0x7c3b124d,0x3f8509ac,0xd62a001f}},	//   hnie_, _áure, čluk_, _нозе_,
   {{0x7d06070a,0x3f912617,0x63b801fa,0x2d922618}},	//   _ocks, vozu_, _vivn, koye_,
   {{0x25d90979,0xea0000ef,0x7c262619,0x62980579}},	//   _آهنگ_, _nhập_, _oskr, _vyvo,
   {{0x2d800067,0xe5a3180b,0x00000000,0x00000000}},	//   dnie_, _сици, --, --,
   {{0x4426261a,0x2d8000a5,0x2129261b,0x291d261c}},	//   _iso_, enie_, _waah_, zewa_,
   {{0xbe88261d,0x59b0261e,0x3da7261f,0x31600036}},	//   есте_, जगार, ераб, _fliz_,
   {{0x2d802620,0x44262621,0x2d922622,0xea000023}},	//   gnie_, _kso_, goye_, _chập_,
   {{0x7ae513e1,0x44260095,0xab640233,0x394d2623}},	// [1bb0] taht, _jso_, klüğ, _roes_,
   {{0x6d5a074a,0x2d800034,0x63ad0036,0xae2100aa}},	//   ëtar, anie_, _èant, मबदन_,
   {{0xf7711e49,0x395f2198,0x2d92023f,0xdbd700c2}},	//   یات_, _plus_, boye_, _säät,
   {{0xdbd702fd,0x442602a7,0x2d8000a5,0xd8792296}},	//   _päät, _oso_, cnie_, ومات_,
   {{0x44262624,0xb8e9007d,0x7ae502fd,0xbcfb0fb6}},	//   _nso_, _ईल_, paht, _eléc,
   {{0x394d0185,0x6d4f01e8,0xbcfb020d,0x23a201cd}},	//   _woes_, _hoca, _fléc, yðja_,
   {{0x44262625,0x291d0010,0x6d4f2626,0x6b52052f}},	//   _aso_, pewa_, _koca, _vægt,
   {{0x74150391,0x84770139,0x1da708d4,0x44260381}},	//   نوعا, _aáwẹ, _कीमत, _bso_,
   {{0xe4c80190,0xc89500d1,0xc9840450,0x00000000}},	//   ربين_, _شارژ, _сури, --,
   {{0x2d802627,0x6b52003e,0x60cd2628,0x8c1c00ca}},	//   znie_, _hægr, _afam, לוחי,
   {{0x44262629,0x96ca0455,0x36d40084,0x2d800034}},	//   _eso_, _स्टॉ, _сохр, ynie_,
   {{0x27e90b4b,0x29020149,0x6dbc0f72,0x6aba0301}},	//   šanu_, _ökat_, _očar, _útfe,
   {{0xd24e00d0,0x84770032,0x44260141,0x2d9200fc}},	//   منی_, _fáwẹ, _gso_, voye_,
   {{0x7bc00161,0x3ebe004d,0x2d80262a,0x636400b3}},	//   _émui, øtt_, wnie_, _cònd,
   {{0x6d4f262b,0x2d800067,0xfce6014d,0xdee31278}},	//   _boca, tnie_, ково, роси,
   {{0x2bc3262c,0xc5f200c1,0x2b1407ad,0xab640233}},	//   _वंशा, ידל_, न्नु_, zlüğ,
   {{0x2d80262d,0x81bc00e8,0x00000000,0x00000000}},	// [1bc0] rnie_, svēt, --, --,
   {{0x998d18b4,0xab5b0364,0x2d800034,0x6d4f033c}},	//   _češ_, _stür, snie_, _eoca,
   {{0x6d4f0080,0x6dbc02dd,0xea0000de,0xeb970291}},	//   _foca, _včas, _thập_, њих_,
   {{0x6d4f262e,0x00000000,0x00000000,0x00000000}},	//   _goca, --, --, --,
   {{0xf7460303,0x7c26005f,0x6e93262f,0x00000000}},	//   кедо, _uskr, _ملیا, --,
   {{0x7bd62630,0x7d042631,0x6d4f2632,0x63640383}},	//   mpyu, lgis, _zoca, _kòne,
   {{0x27ed0054,0xab6401e8,0x752b007e,0x7c242633}},	//   _even_, rlüğ, _bagz, lwir,
   {{0x7d042634,0x6d4f2635,0x00000000,0x00000000}},	//   ngis, _xoca, --, --,
   {{0x7c240364,0x7bd60124,0x27ed0218,0x872600ae}},	//   nwir, npyu, _gven_, _имаж,
   {{0x44260087,0x60cd028d,0x80dc0033,0x00000000}},	//   _vso_, _sfam, _ভাগ্, --,
   {{0xd5af00c2,0x21790109,0x81bc01d3,0xa266008f}},	//   _вс_, ейны_, evēr, тъпл,
   {{0x442601bb,0x7c240193,0x925700c2,0xd5e90037}},	//   _tso_, kwir, тают_, _أعلن_,
   {{0x250b0103,0x81bc00e8,0x7520024a,0x7c240172}},	//   _آرمی_, tvēs, memz, jwir,
   {{0x65620031,0x69c1028d,0x247e0174,0x2afe052c}},	//   _hloh, _èleg, ịms_, _लागु_,
   {{0xd3780995,0xf1a72636,0xbcfb00fd,0x798200ca}},	//   mić_, _ирин, _aléa, know,
   {{0x798200a5,0x7d042637,0x9f59025b,0x2d5502b6}},	//   jnow, ggis, musí_, _nået_,
   {{0x6c54184d,0x7c240435,0x65620357,0xd0110308}},	// [1bd0] акту, gwir, _mloh, _الخ_,
   {{0x7d042638,0x7658007b,0x31792639,0xf0e3007f}},	//   agis, kyvy, lisz_, _ख़ुद_,
   {{0x3f830995,0xdb050080,0x6562263a,0x27ed263b}},	//   mnju_, gmhá, _oloh, _sven_,
   {{0xd37804eb,0x7c24023f,0x6d4f00e7,0x9f42033d}},	//   hić_, bwir, _uoca, mská_,
   {{0xd37803ce,0x9f420579,0xbcfb0037,0x4424023e}},	//   kić_, lská_, _gléa, jwm_,
   {{0x65620af0,0xd37800e9,0x4908009f,0x628a263c}},	//   _aloh, jić_, _हाथो_, _oxfo,
   {{0x9f420074,0xd37800e9,0x2d5501c5,0x95c5001c}},	//   nská_, dić_, _fået_, ديبه,
   {{0xdb1d0871,0x2d5501c5,0x661a061d,0x442401fa}},	//   _musí, _gået_, _dptk, fwm_,
   {{0x3f830fa3,0xe70500d1,0x00000000,0x00000000}},	//   knju_, _مسای, --, --,
   {{0xd37804eb,0x29020149,0x656222cf,0x3f83042d}},	//   gić_, _ökar_, _eloh, jnju_,
   {{0x3f8300e9,0x9f42035d,0xc0e6263d,0x2fd2057a}},	//   dnju_, jská_, лонк, _styg_,
   {{0x741200cd,0x9f420146,0xd4350a09,0xf5300037}},	//   جویا, dská_, _معتب, _وإن_,
   {{0xd378263e,0xa3df2125,0x7d0403e0,0x442400f0}},	//   bić_, धीश_, vgis, cwm_,
   {{0xd37800a5,0x2d99263f,0x3f830357,0x6364022b}},	//   cić_, _akse_, gnju_, _pòne,
   {{0x31790034,0xa3df1c05,0x79820034,0x81bd01d3}},	//   bisz_, धीर_, ynow, rvēr,
   {{0x7c242640,0x2d960109,0x81bd01d3,0xbcfb0076}},	//   twir, ургс, svēr, _pléa,
   {{0x6da300d3,0x09cc009d,0x3f831912,0x5baa2641}},	// [1be0] сита, ाऱ्य, bnju_, екам_,
   {{0x7c242642,0xfbcd0081,0x20022643,0xdb1d20df}},	//   rwir, _লিখত, muki_, _fusí,
   {{0xe8fa2644,0x20022645,0x7c242646,0x79822647}},	//   еле_, luki_, swir, tnow,
   {{0xd3782648,0x786a0018,0x88e600c2,0xea0000fe}},	//   zić_, _növé, ужде, _chạp_,
   {{0x20022649,0xe3c800de,0x4424023e,0x7982264a}},	//   nuki_, _mực_, xwm_, rnow,
   {{0xdb1c00dd,0xe3c80028,0xfee20033,0x7982007f}},	//   _mirë, _lực_, _বাঁধ, snow,
   {{0xd37800e9,0x6b63264b,0x7bc60d2a,0xd6d9004d}},	//   vić_, _укра, _huku, тті_,
   {{0x7bc6264c,0x1db402e8,0xd37800a5,0x3f830ca7}},	//   _kuku, ंगित, wić_, znju_,
   {{0xd37802e6,0x7bc6264d,0xe64403a3,0x12e607bf}},	//   tić_, _juku, ılığ, лінг,
   {{0x2002264e,0x7bc61a80,0x44240150,0x257a0139}},	//   duki_, _muku, rwm_, _bàlè_,
   {{0xd37802e6,0x7bc6264f,0x3f832650,0xe3c80023}},	//   rić_, _luku, vnju_, _bực_,
   {{0xe3c80028,0x9f42025b,0xf1ab00bf,0x29060a00}},	//   _cực_, vská_, عاده_, ngoa_,
   {{0x7bc62651,0x3f830039,0x69c10257,0xd3782652}},	//   _nuku, tnju_, _élev, pić_,
   {{0x9f42025b,0x317900a5,0x00000000,0x00000000}},	//   tská_, sisz_, --, --,
   {{0x31790067,0x7bc62653,0x3f830106,0x539b0266}},	//   pisz_, _auku, rnju_, _ריוו,
   {{0x7bc62654,0x9f42025b,0x3f8308a9,0x20022655}},	//   _buku, rská_, snju_, buki_,
   {{0x7bc60f8b,0x3f8316a2,0x00000000,0x00000000}},	// [1bf0] _cuku, pnju_, --, --,
   {{0x7bc62656,0x9f4202c6,0x332e00bd,0xa3e606e4}},	//   _duku, pská_, _jafx_, यीय_,
   {{0xfaa712d1,0x2b141bc3,0x0b882657,0x8aa7007e}},	//   ушан, न्धु_, усти_, урад,
   {{0xdc34025b,0x3835002d,0x2d9900bc,0xf1c900fe}},	//   _zúča, инер, _ukse_, _hạc_,
   {{0x7bc62658,0x3b0a00b3,0x6d4d2659,0x00000000}},	//   _guku, _fcbq_, mjaa, --,
   {{0x6d4d265a,0x29060a00,0x2b1404f8,0x38ba0342}},	//   ljaa, agoa_, न्दु_, _sürü_,
   {{0x7bc601bf,0xd0560092,0xf1c900de,0xcf5800a1}},	//   _zuku, _deyə, _mạc_, רבות_,
   {{0x6d4d168b,0xf1c90028,0xdb1d016d,0x69d50634}},	//   njaa, _lạc_, _fusã, _itze,
   {{0x7bc60694,0x68eb265b,0x799b198f,0xe3c800de}},	//   _xuku, magd, _ikuw, _rực_,
   {{0x69c7265c,0x68eb0407,0xdced0367,0xdbd200aa}},	//   _kuje, lagd, ynağ, _rüüt,
   {{0x216a265d,0x67231c54,0x7ae7265e,0x75d100d9}},	//   вини_, menj, _mejt, _bāze,
   {{0x69c703cc,0x672302dd,0xdc340181,0x68eb00a6}},	//   _muje, lenj, _súča, nagd,
   {{0x6603265f,0xe3c80028,0xf1c90019,0xb4d1009d}},	//   lunk, _vực_, _bạc_, वडी_,
   {{0x7bc62660,0x20022661,0x67232662,0xdee3002d}},	//   _ruku, ruki_, nenj, жори,
   {{0x13da00c7,0x7bc62663,0x2002048e,0x799b0a15}},	//   _দিয়, _suku, suki_, _okuw,
   {{0x7bc62664,0x67232665,0x64460149,0x75d101d3}},	//   _puku, henj, åkig, _gāze,

   {{0x67232666,0x644908a8,0x69d502a7,0x68eb1281}},	// [1c00] kenj, nxei, _atze, dagd,
   {{0xaaba09b4,0x66032667,0x79890139,0x69c72668}},	//   ندار_, kunk, _ajew, _buje,
   {{0x7ae72669,0x6723011d,0x69c704a3,0x6da6266a}},	//   _dejt, denj, _cuje, _вина,
   {{0x7bc6266b,0xe3c80019,0xdb0f266c,0xd91012eb}},	//   _tuku, _lựa_, _bucó, ثیر_,
   {{0x3860266d,0x2906266e,0x6569266f,0x7bc62670}},	//   áir_, rgoa_, dheh, _uuku,
   {{0x67232671,0x78a900e7,0x3f982672,0x799b2673}},	//   genj, _dzev, noru_, _ekuw,
   {{0x25fd2674,0x9f5900fd,0xb4d10096,0x69c72675}},	//   रंगी_, ursé_, वडू_, _guje,
   {{0x3f98030b,0xdb1c2676,0xa6e90019,0x7ae72677}},	//   horu_, _sirè, _ngươ, _zejt,
   {{0x69c02678,0x67232679,0xdb07267a,0x69c700e7}},	//   _iime, benj, _gijó, _zuje,
   {{0x4aaa267b,0x672300e9,0x69c0267c,0x60c4267d}},	//   _कराव, cenj, _hime, _agim,
   {{0x69c10068,0x69c0267e,0xe3c800de,0xa159267f}},	//   _élet, _kime, _dựa_, гану_,
   {{0x50672680,0xf1c900de,0x2c5e00d9,0x69c02681}},	//   атга, _sạc_, _kādā_, _jime,
   {{0x938a013d,0x69c02682,0x8ca20fef,0xb4c203a2}},	//   _иска_, _mime, _खरगो, ंशी_,
   {{0x69c02683,0x3f9808a9,0x09d70081,0x6d4d0126}},	//   _lime, goru_, _হিসা, wjaa,
   {{0x7ae72684,0xa187163d,0xdef801b3,0x9ce70307}},	//   _rejt, _выпл, шыя_, ицал,
   {{0x69c02685,0x672300cc,0x69c70079,0x7ae72686}},	//   _nime, zenj, _ruje, _sejt,
   {{0x69c72687,0x6d4d2688,0x6723083e,0x66032689}},	// [1c10] _suje, rjaa, yenj, zunk,
   {{0x69c0268a,0x6d4d268b,0x69c700b3,0xaad2058f}},	//   _aime, sjaa, _puje, दुलक,
   {{0x6723268c,0x69c0268d,0xdb0f00b3,0xc879020a}},	//   venj, _bime, _bucò, _ieşi_,
   {{0x98a90995,0xdb0f037a,0x69c700c4,0xc984268e}},	//   žač_, _pucó, _vuje, оучи,
   {{0xe8f802b7,0x7ae70038,0x67232024,0x68eb00a6}},	//   рлі_, _tejt, tenj, ragd,
   {{0x2fc901bb,0x6603268f,0x69c72690,0x68eb0124}},	//   _muag_, tunk, _tuje, sagd,
   {{0x672308a9,0x2fc901bb,0x69c00383,0x68eb1281}},	//   renj, _luag_, _fime, pagd,
   {{0x66032691,0x99850080,0x67230542,0x799b019f}},	//   runk, _الرو, senj, _ukuw,
   {{0x681a00d9,0x67232692,0x66032693,0x44392694}},	//   gādā, penj, sunk, ís_,
   {{0x69c00010,0x65692695,0xb4e60034,0x68e92696}},	//   _zime, sheh, _बड़ी_, _heed,
   {{0xb6350241,0x68e92697,0x644600c2,0x26c505db}},	//   _دفاع, _keed, äkir, _iglo_,
   {{0x68e90694,0x3f982698,0xdb1c014b,0xd05d013c}},	//   _jeed, woru_, _viré, lasə,
   {{0x34380177,0x68e92699,0x2fc90197,0xe3c800de}},	//   _پسند_, _meed, _cuag_, _tựa_,
   {{0x50d80c16,0x68e9269a,0x98a0084f,0xdb1c020d}},	//   _भ्रष, _leed, žić_, _tiré,
   {{0xc87900d3,0xbcfb269b,0x25fd269c,0x59b91926}},	//   _deşi_, _elém, रंटी_, ेदार,
   {{0xbf9b001f,0x68e900a1,0x3f98269d,0xc692006e}},	//   quên, _need, soru_, פאן_,
   {{0x69c0269e,0x26c500e7,0x3f98269f,0x7ff626a0}},	// [1c20] _rime, _oglo_, poru_, _اسبا,
   {{0x69c026a1,0x290d00d3,0x2b4300ee,0x7d162452}},	//   _sime, _acea_, _cnjc_, sfys,
   {{0xcf57004f,0xe80a007d,0x69c018a4,0x0f5700c1}},	//   _הבית_, हूना_, _pime, _היים_,
   {{0xb4e60abe,0x2fc9022e,0xea000023,0xdb150094}},	//   _बजे_, _yuag_, _nhấp_, _vizá,
   {{0x69c026a2,0x68e926a3,0x00000000,0x00000000}},	//   _vime, _deed, --, --,
   {{0xaa461e65,0xb4c202d5,0x681a00e8,0x98a400c6}},	//   _легл, ्ड्_, vādā, _namą_,
   {{0x69c026a4,0xf38a0649,0x68e926a5,0x6b63163d}},	//   _time, nṣe_, _feed, _экра,
   {{0x68e9008a,0xea000019,0xf3f8090f,0x32050094}},	//   _geed, _chấp_, аниш_, duly_,
   {{0x78660ed8,0x7c290095,0xb4c200b6,0x00000000}},	//   _указ, _šerz, ्डौ_, --,
   {{0x681a0029,0x2fc926a6,0x68e901cb,0x00000000}},	//   rādā, _ruag_, _zeed, --,
   {{0x6b9b00c1,0x68e90188,0xcb9b0796,0x2c140033}},	//   רשיד, _yeed, רסיט, ঠিয়ে_,
   {{0x2fc90197,0xe57203ef,0xbcfb0113,0x216726a7}},	//   _puag_, _عطا_, _plém, стог,
   {{0x2fc9023e,0xf8ba09c4,0x91ca00c0,0x7cff0139}},	//   _quag_, ेशिय, _संवै, _làrà,
   {{0x2fc9006c,0x995c02c6,0x25ef0096,0x00000000}},	//   _vuag_, jíž_, ींची_, --,
   {{0xf1c90028,0x2cd60134,0x995c02c6,0xdbd111bc}},	//   _hạn_, _ọhụ_, díž_, _küçe,
   {{0x2fc926a8,0xbcfb0139,0xf1c900fe,0x00000000}},	//   _tuag_, _ilék, _kạn_, --,
   {{0x68e926a9,0xd05d01d4,0x3b550d9b,0x636d26aa}},	// [1c30] _reed, yasə, окар, _dúnf,
   {{0xf1c900de,0x7cff0032,0x68e926ab,0xdb050076}},	//   _mạn_, _bàrà, _seed, lmhú,
   {{0x9d1900d3,0x6aba01cd,0x636d0065,0x79990313}},	//   _конт_, _útfl, _fúnf, toww,
   {{0xbcfb00b6,0x9f520154,0x8ed81ac9,0xad271ac9}},	//   _mlék, _avyè_, _پذیر_, _اردو,
   {{0xf1c90019,0x26060ed3,0xbae80081,0xb4e608d4}},	//   _nạn_, सूसी_, _পারছ, _बड़े_,
   {{0x7c2f0465,0xe73925e7,0x45d523bf,0xaded009f}},	//   _iscr, рек_, оцит, _जबान_,
   {{0x636d2027,0x68e91953,0x27e001d3,0x00000000}},	//   _húng, _teed, ģina_, --,
   {{0xf1c9011b,0xf7730e8c,0xf1cf030b,0x160b0034}},	//   _bạn_, _کار_, _संबन, संबर_,
   {{0x25fd0ccb,0xf1c90023,0x7c3b00c4,0x6d5a014b}},	//   रूजी_, _cạn_, _šurj, êtai,
   {{0x6d9326ac,0x32050146,0x43740686,0xf1c900fe}},	//   lħad, tuly_, зуют, _dạn_,
   {{0xea000019,0xe1261c0e,0x2d890da7,0x316905db}},	//   _thấp_, омни, knae_, _blaz_,
   {{0x26130396,0x24190084,0x61fc26ad,0x8cd91f88}},	//   mão_, _воды_, árla, _फ्लो,
   {{0x26130396,0x442926ae,0xbcfb0065,0xead0026e}},	//   lão_, _èa_, _elék, _kẹta_,
   {{0x88ba00a1,0x443d09a1,0x5334007b,0x00000000}},	//   יזרי, _irw_, _нечт, --,
   {{0x3ebe26af,0x443d26b0,0x26130161,0x3eac0430}},	//   ätt_, _hrw_, não_, ådt_,
   {{0x2d890085,0x9f420220,0xf1c90023,0x3cf600bc}},	//   gnae_, nskú_, _hạo_, ेलें_,
   {{0x26130161,0x636d0076,0xdca326b1,0x00000000}},	// [1c40] hão_, _cúng, дати, --,
   {{0x443d0328,0x8a3a007b,0x636d033c,0x670e0e28}},	//   _mrw_, ияет_, _dúng, _साधक_,
   {{0x442f0085,0x26130161,0x2d9e00fd,0xf1c900de}},	//   _lsg_, jão_, îtes_, _mạo_,
   {{0x26130396,0x8c4626b2,0x443d06b0,0x9f420206}},	//   dão_, _деме, _orw_, jskú_,
   {{0x274a00b8,0x6d4626b3,0x443d26b4,0x636d0065}},	//   ичко_, _inka, _nrw_, _gúng,
   {{0x29d700bd,0x2613016d,0xf1c900fe,0xa09b0266}},	//   _bħad_, fão_, _rạn_, סיסט,
   {{0x2613001f,0xf1c90019,0xc2e80033,0x443d26b5}},	//   gão_, _sạn_, _খালি_, _arw_,
   {{0x54541681,0xf1c900fe,0x69de007b,0x442f26b6}},	//   звит, _pạn_, mppe, _bsg_,
   {{0x68e226b7,0xf1c900de,0x186726b8,0xe947001c}},	//   mbod, _bạo_, _дати_, _ظرفی,
   {{0x2d6801e8,0x26130161,0xf1c90023,0x68e2004d}},	//   rşey_, bão_, _vạn_, lbod,
   {{0x6d4626b9,0x2613001f,0x29d7003d,0x31690e9e}},	//   _onka, cão_, _għad_, _plaz_,
   {{0xdb1d02e2,0x68e226ba,0x443d0193,0x2b58009c}},	//   _zusä, nbod, _frw_, _lorc_,
   {{0xdb1c0076,0x60c9007e,0x26060285,0x443d00eb}},	//   _airí, žemo, सूरी_, _grw_,
   {{0x6d4626bb,0xf1c900de,0x533418b9,0x7ada0096}},	//   _anka, _gạo_, _хект, _प्लॅ,
   {{0xdb1c0072,0x9e34002d,0xcdd80284,0xbcfb00d2}},	//   _cirí, мерч, жњу_, _ulék,
   {{0x316904a3,0xdb1c04d8,0x200202ef,0xd65700ca}},	//   _ulaz_, _dirí, brki_, חילת_,
   {{0x2613001f,0x636d002b,0x20040428,0x2d8900da}},	// [1c50] zão_, _fúnd, àmit_, rnae_,
   {{0xfaa726bc,0x6d4626bd,0x8aa71907,0x628b042d}},	//   ошен, _enka, оред, šloš,
   {{0x26130396,0x2d5c0042,0x68e201c2,0x539b00ca}},	//   xão_, _cíes_, fbod, סיבו,
   {{0x68e20af0,0xa2da16f8,0x2613016d,0x2d5c00ee}},	//   gbod, पुत्, vão_, _díes_,
   {{0xf74526be,0xb8d302d5,0x9cd60327,0x9f420031}},	//   зело, _ऑर_, _מורה_, vskú_,
   {{0x26130303,0x7d0d26bf,0x7c2d1f1a,0x6fdc0089}},	//   tão_, lgas, mwar, סקוס,
   {{0xf9930241,0xf1c602d5,0x3c2d00c4,0x9f420031}},	//   _قبر_, _रंगन, _hžv_, tskú_,
   {{0x261300c9,0x7d0d26c0,0x442f26c1,0x200201cd}},	//   rão_, ngas, _psg_, yrki_,
   {{0x261300c9,0xa3e6007d,0x7c2d26c2,0x68fb0d16}},	//   são_, यील_, nwar, _idud,
   {{0x2613001f,0x31b6055c,0x6d9303e5,0x77ad0072}},	//   pão_, ृद्ध, nħab, búxa,
   {{0xe2990326,0x7c2d26c3,0x636d0037,0x7d0d26c4}},	//   сан_, hwar, _rúnd, kgas,
   {{0x7c2d06c0,0xfc3f0649,0xf8cb02d5,0x22580212}},	//   kwar, _orí_, िशिय, ärka_,
   {{0xf1c900ef,0x55520103,0x645d01bf,0x81cc0081}},	//   _tạo_, _سپور, äsid, শীল_,
   {{0x442d26c5,0x7c2d26c6,0x752926c7,0xdc3a0092}},	//   mwe_, dwar, leez, xçıv,
   {{0x442d26c8,0xf2d200c1,0x2ca700a7,0x291f0027}},	//   lwe_, _טעג_, əndi_, _obua_,
   {{0x7d0d26c9,0xdb1c26ca,0x442d26cb,0xfc3f0076}},	//   ggas, _virí, owe_, _brí_,
   {{0x442d26cc,0x7c2d26cd,0x2b581065,0xed570396}},	// [1c60] nwe_, gwar, _porc_, чот_,
   {{0x291f0134,0x7d0d26ce,0xf1c90023,0x636d04c3}},	//   _abua_, agas, _lạm_, _fúne,
   {{0xa92607df,0x442d26cf,0xdb1c016d,0x68e2225b}},	//   здел, hwe_, _pirâ, tbod,
   {{0x442d1a84,0xfc3f01cd,0xc7c619e8,0x31b20579}},	//   kwe_, _frí_, пски, báze_,
   {{0x07a626d0,0x442d092f,0x68e226d1,0x684601b6}},	//   падн, jwe_, rbod, янда,
   {{0xe3a71dec,0x501b00a1,0x212002e7,0x1b030081}},	//   _سر_, מונו, _lbih_, র্বে_,
   {{0x442d0185,0xbcfb0037,0x7529083e,0x00000000}},	//   ewe_, _sléi, feez, --,
   {{0x69ce00d3,0x75290283,0xbcfb0076,0x6b9e26d2}},	//   _iube, geez, _pléi, lopg,
   {{0x442d26d3,0x69ce26d4,0xbcfb0065,0x69dc009c}},	//   gwe_, _hube, _eléw, _htre,
   {{0x69ce0c50,0xb4ac000d,0x27f7000d,0x798226d5}},	//   _kube, _गरी_, ření_, liow,
   {{0xcfc40081,0x52130077,0x442d26d6,0x7c2d26d7}},	//   ্ঠান, ндэт, awe_, zwar,
   {{0x442d26d8,0x798200a5,0x69ce26d9,0xe3b8026a}},	//   bwe_, niow, _mube, smı_,
   {{0x69ce26da,0x43461b48,0x7d0d0233,0x660a26db}},	//   _lube, _недв, vgas, lufk,
   {{0x69dc26dc,0x69ce010a,0x00000000,0x00000000}},	//   _otre, _oube, --, --,
   {{0xd78800ef,0x212026dd,0x69ce04d8,0x798b0150}},	//   yển_, _fbih_, _nube, yngw,
   {{0xbcfb26de,0x7c2d26df,0x7aee0062,0x7d0d0653}},	//   _llév, twar, _aebt, ugas,
   {{0x69dc26e0,0x7d0d26e1,0x2d5814fa,0x7c2d01c0}},	// [1c70] _atre, rgas, чить_, uwar,
   {{0x212b26e2,0x69ce26e3,0x7c2d26e4,0x65a50103}},	//   lech_, _bube, rwar, róhi,
   {{0x69ce26e5,0x442d26e6,0x200b00cc,0x7c2d26e7}},	//   _cube, zwe_, luci_, swar,
   {{0xfc3f26e8,0x212b26e9,0x69ce26ea,0x442d26eb}},	//   _trí_, nech_, _dube, ywe_,
   {{0xf77003ed,0x201926ec,0x69dc26ed,0x200b042d}},	//   گان_, ntsi_, _etre, nuci_,
   {{0x7bdd26ee,0xf09400c1,0x660a01c2,0xdb1c0131}},	//   _itsu, ענס_, fufk, _virã,
   {{0xf770006f,0xa3c21843,0x69ce26ef,0x442d057a}},	//   دان_, ्दन_, _gube, wwe_,
   {{0x442d1a80,0x798200a5,0x68fb26f0,0x7bc7037a}},	//   twe_, ciow, _udud, _hiju,
   {{0x442d26f1,0x200b1197,0x212b030b,0x69ce26f2}},	//   uwe_, juci_, dech_, _zube,
   {{0xe1f91681,0x442d26f3,0xdb1c0018,0x7bcf26f4}},	//   ого_, rwe_, _kirá, _mucu,
   {{0x7bcf26f5,0x3f831be3,0x442d26f6,0xf1c90019}},	//   _lucu, diju_, swe_, _tạm_,
   {{0x290f26f7,0x7bdd0006,0x5ec50033,0xdb1c0328}},	//   ngga_, _otsu, ্রাই, _mirá,
   {{0x7bdd01bb,0xbf9b001f,0x200b00cc,0x7bcf26f8}},	//   _ntsu, rrên, guci_, _nucu,
   {{0x3f8303ce,0x1b030033,0xdb1c037a,0x7bc70a4b}},	//   giju_, র্তে_, _oirá, _niju,
   {{0x7bcf04ea,0xddd40031,0xad5a0c4a,0x7bdd26f9}},	//   _aucu, ňažn, орах_, _atsu,
   {{0x7bcf0012,0x200b26fa,0xc692006e,0x2019006c}},	//   _bucu, buci_, דאל_, btsi_,
   {{0x3f832461,0x7bc726fb,0x672102df,0x7aee023e}},	// [1c80] biju_, _biju, _oblj, _pebt,
   {{0x09e61c00,0x7bcf26fc,0x290f0188,0xef8326fd}},	//   дожн, _ducu, egga_, _альп,
   {{0x7bc70cd0,0x6b9e26fe,0x7afc05db,0x69ce26ff}},	//   _diju, ropg, _vdrt, _qube,
   {{0x7aee2700,0xdb1c0328,0x6b9e02b6,0x7bcf01b9}},	//   _webt, _dirá, sopg, _fucu,
   {{0xb4ac000d,0x7bc7015c,0x7bcf0193,0x2baf1c83}},	//   _गरे_, _fiju, _gucu, _जीवा,
   {{0x212b06e4,0x5b3500d3,0x7afc05db,0xa3d10285}},	//   zech_, _пэсу, _udrt, वदन_,
   {{0x69dc2701,0x200b2702,0x8b03030b,0xdb1c002b}},	//   _utre, zuci_, _úřad, _girá,
   {{0xd8260859,0x636400b3,0x6d560079,0x00000000}},	//   _одби, _iòni, njya, --,
   {{0xf8b20251,0x212b2703,0x7bc704ff,0x76410178}},	//   _जरिय, vech_, _yiju, _erly,
   {{0xd370114c,0x200b08a9,0x212b0178,0x00000000}},	//   اهد_, vuci_, wech_, --,
   {{0x3f83005f,0x212b030b,0x69c80103,0x63a82704}},	//   viju_, tech_, _édes, rldn,
   {{0x80fb0d7e,0xe7f50034,0x63640428,0x7c261a39}},	//   ्लेख_, ुंचा_, _mòni, _opkr,
   {{0x3f830542,0x212b2705,0x75220027,0xbcfb0113}},	//   tiju_, rech_, _iboz, _mlét,
   {{0x44262706,0xa29408a1,0x212b2707,0xf487001c}},	//   _ipo_, _палі, sech_, _تامی,
   {{0x290f2708,0x212b2347,0x200b03a9,0x13e30033}},	//   ygga_, pech_, suci_, _মিয়,
   {{0x7bcf2709,0x7bc70010,0x44260294,0xa2da270a}},	//   _pucu, _siju, _kpo_, पुर्,
   {{0x60cd26f6,0x9f420579,0x7bc7270b,0xfc3f0032}},	// [1c90] _igam, lský_, _piju, _eyín_,
   {{0x4426270c,0x7980270d,0x7bcf047e,0x00000000}},	//   _mpo_, _ammw, _vucu, --,
   {{0x9f420618,0x7bc70fb2,0x636400ee,0x2d850103}},	//   nský_, _viju, _còni, éles_,
   {{0x4adf1a09,0x394911ce,0x4426270e,0xdb1c0018}},	//   _प्रव, ñas_, _opo_, _virá,
   {{0x4426022e,0x636d00e3,0x60cd270f,0xba74110a}},	//   _npo_, _lúna, _mgam, _یافت,
   {{0xbcfb2710,0x79800361,0x75222711,0x636405aa}},	//   _elét, _emmw, _aboz, _fòni,
   {{0x4426074a,0x9f420146,0x60cd2712,0x38690786}},	//   _apo_, jský_, _ogam, šar_,
   {{0x60cd2713,0x9f420146,0x77ad0042,0xbcfb0af0}},	//   _ngam, dský_, púxo, _ilés,
   {{0x6d5d2714,0x64422715,0x44260167,0x63a30063}},	//   _mosa, _croi, _cpo_, _pknn,
   {{0x644210d1,0x60cd1a9b,0x44262716,0xf1c90019}},	//   _droi, _agam, _dpo_, _hại_,
   {{0x4426026e,0x80c20789,0x636d0037,0x64422717}},	//   _epo_, रेने, _cúna, _eroi,
   {{0x64422718,0x6d5d2719,0x78a9010a,0x4426271a}},	//   _froi, _nosa, _kyev, _fpo_,
   {{0xf1c90028,0x27ed06a3,0x6569271b,0x00000000}},	//   _mại_, _jwen_, mkeh, --,
   {{0xf1c900ef,0x27ed0c3e,0xa3c00455,0x443f271c}},	//   _lại_, _mwen_, ंगण_, mvu_,
   {{0x6d5d0477,0x443f271d,0x27ed06a3,0x60cd002b}},	//   _bosa, lvu_, _lwen_, _fgam,
   {{0x6d5d271e,0x753b271f,0xed5707ec,0xf65200c1}},	//   _cosa, nduz, нос_, נצן_,
   {{0x6d5d2720,0x443f0283,0xf1ca0023,0xf1ac0ee0}},	// [1ca0] _dosa, nvu_, _nại_, _टीएन,
   {{0x5ba7002d,0x9971007f,0x909b00ca,0x443f2721}},	//   екум_, jął_, _מספק, ivu_,
   {{0x0906117f,0x6d5d17dc,0xbcfb2722,0x3709009f}},	//   епен, _fosa, _boéd, _साड़ी_,
   {{0x443f02e6,0x7e610222,0xf1ca00de,0xebe62723}},	//   kvu_, älpe, _bại_, _помп,
   {{0x69c92724,0x63a12725,0xbcfb0032,0x9f4202c6}},	//   _diee, koln, _elés, zský_,
   {{0xf1ca0023,0x44262726,0x27ed0154,0xb907097c}},	//   _dại_, _rpo_, _dwen_, _म्_,
   {{0xe5c608d8,0x443f122d,0x27ed01b9,0x44262727}},	//   нсио, evu_, _ewen_, _spo_,
   {{0x9f420074,0xd5b7055b,0xdb1c01e8,0x636d2728}},	//   vský_, нсы_, _birç, _rúna,
   {{0x70af0abe,0xbcfb03a9,0xe4522729,0x443f0227}},	//   _घरेल, _klér, اضع_, gvu_,
   {{0x8883272a,0x9f42025b,0xbf9b0257,0x60cd272b}},	//   _служ, tský_, trêm, _sgam,
   {{0xa294224a,0x25710094,0x66e30077,0x69c903a9}},	//   тані, _sále_, _соха, _yiee,
   {{0x3202272c,0x6442272d,0x9f420244,0x6569272e}},	//   čky_, _troi, rský_, ckeh,
   {{0x386605fe,0x4426272f,0x63a12730,0x644201ff}},	//   nyor_, _upo_, boln, _uroi,
   {{0x6d5d1114,0xbf9b020d,0x9f420a7f,0x00000000}},	//   _sosa, prêm, pský_, --,
   {{0xf1a72731,0x644700d9,0x1dac02d5,0x1c0300aa}},	//   _прин, ājie, चतंत, _लिहल_,
   {{0x60cd2732,0xbcfb2733,0x29d700bd,0x5ba90d7e}},	//   _ugam, _alér, _bħan_, कत्व,
   {{0xfbd3006f,0x6d5d2734,0x6386020d,0xbcfb0113}},	// [1cb0] اتر_, _vosa, _génè, _roéd,
   {{0x673a1d88,0xf1bf0072,0x78bd00d4,0xe1cf00a3}},	//   _natj, lmá_, _úsvi, _सूँघ,
   {{0x6d5d0080,0x69c90029,0x61fa2735,0x443f0579}},	//   _tosa, _piee, nstl, zvu_,
   {{0xbcfb0068,0x27ed06a3,0xd70e0b42,0x25a605db}},	//   _elér, _pwen_, _साउथ_, _nkol_,
   {{0xa3c2033a,0xe73913b0,0xa3c00a35,0x29d703e5}},	//   ्दा_, дел_, ंगा_, _għan_,
   {{0x25a62736,0xdb050037,0x61fa2737,0x00000000}},	//   _akol_, rmhó, kstl, --,
   {{0x63a1033d,0x210400c6,0x673a18f0,0xab94004d}},	//   voln, lčių_, _datj, _сирі,
   {{0xf1ca00ef,0x63a100a5,0x7af72738,0x67240e94}},	//   _tại_, woln, laxt, đija,
   {{0x02c9022d,0x210401b3,0xe3b90c28,0x656902e2}},	//   रश्न, nčių_, мби_, rkeh,
   {{0x443f2739,0x6569273a,0x21040138,0x673a02ac}},	//   rvu_, skeh, ičių_, _gatj,
   {{0x77900688,0x443f273b,0x395f02f1,0x2c1d0033}},	//   _دیوا, svu_, _kous_, নিয়ে_,
   {{0x395f05aa,0x636d0032,0x63a10103,0x6386014b}},	//   _jous_, _gúnn, soln, _pénè,
   {{0x63a10b27,0xb0a512e5,0x61e4042d,0x2d820063}},	//   poln, _गुदग, _čile, _rmke_,
   {{0x25ad273c,0xa28300cd,0x25bf00d3,0x395f022b}},	//   llel_, _میخو, lmul_, _lous_,
   {{0xbea61cf2,0x7af7008a,0xe3c800de,0x21040138}},	//   тавк, daxt, _cựu_, ečių_,
   {{0x395f273d,0x41b60018,0x27e000ae,0x6386020d}},	//   _nous_, _جمعر, ţini_, _ténè,
   {{0x91bb00ca,0x29d7013c,0x00000000,0x00000000}},	// [1cc0] _קמפי, _aça_, --, --,
   {{0x395f009c,0x7af7008c,0x394d273e,0x0e66273f}},	//   _aous_, gaxt, _anes_, _акон,
   {{0xc332040a,0x395f2740,0x673a2741,0x00000000}},	//   שוב_, _bous_, _ratj, --,
   {{0x395f2742,0x272200b6,0x02b6006e,0x38662743}},	//   _cous_, _oční_, דלעך_, tyor_,
   {{0x394d0897,0x395f2744,0x261406ed,0x2d922745}},	//   _dnes_, _dous_, नूनी_, mnye_,
   {{0x394d2746,0xbf9b0257,0x2d92005c,0x38662747}},	//   _enes_, quêt, lnye_, ryor_,
   {{0x6aa301bf,0x2bd82748,0x395f2749,0xa3c000b7}},	//   ünft, _भंडा, _fous_, ंगस_,
   {{0x2d92274a,0x316001e9,0x2ef80364,0x395f274b}},	//   nnye_, _noiz_, harf_, _gous_,
   {{0xd0e3274c,0x2d920063,0xdcc500b6,0x47c6013f}},	//   _क्षण_, inye_, लेपछ, _абав,
   {{0x2d9200dc,0x316001ff,0x6376020a,0xc44500d1}},	//   hnye_, _aoiz_, _mâng, ایون_,
   {{0x27e612b7,0xcb1300a1,0xc22409b4,0x2ef801bf}},	//   lpon_, בלת_, اکتو, darf_,
   {{0x25a60bb6,0x2bd800a8,0x395f00b3,0x210400c6}},	//   _ukol_, _भूभा, _xous_, yčių_,
   {{0x27e6274d,0xf1bf0956,0x2d920063,0x3a3801b9}},	//   npon_, rmá_, dnye_, _lsrp_,
   {{0x29d703e5,0x27e607ac,0x69c101dc,0x2d920361}},	//   _bħal_, ipon_, _èlev, enye_,
   {{0x636d0037,0xc3330327,0x260600b6,0x3da7001f}},	//   _múnl, _כוס_, सूची_, враб,
   {{0x31600634,0x9f59014b,0x00000000,0x00000000}},	//   _goiz_, issé_, --, --,
   {{0x0dc8274e,0x64440b14,0xc05b004d,0x5bb91402}},	// [1cd0] тури_, _šiij, _цій_, елая_,
   {{0x395f274f,0x25712750,0x2d92083e,0xe3c80023}},	//   _sous_, _mála_, anye_, _tựu_,
   {{0x29d72751,0x395f2752,0xe8cb11c7,0x2104013f}},	//   _għal_, _pous_, िश्च, sčių_,
   {{0x69c80036,0x67d511f7,0x26de033c,0x210400c6}},	//   _èdel, году, _afto_, pčių_,
   {{0x395f1729,0x6d4f0707,0xb80a02d5,0xd8252753}},	//   _vous_, _inca, हंगम_, удли,
   {{0xa3b20251,0xf1ca0019,0x4639002d,0x394d00f0}},	//   _झील_, _hạt_, ечия_, _wnes_,
   {{0x395f10af,0x637600ae,0x25bf020a,0x00000000}},	//   _tous_, _mând, tmul_, --,
   {{0x224902e6,0x394d0472,0x84590396,0x7af501c8}},	//   _čak_, _unes_, ерот_, _hezt,
   {{0xc98410fb,0x69d52754,0x636d0139,0x321e0143}},	//   _тури, _huze, _fúnl, etty_,
   {{0x25bf002d,0x25ad0146,0x69d52755,0xf1ca00de}},	//   smul_, slel_, _kuze, _lạt_,
   {{0x7515054f,0xa18a11d9,0x6d4f01dc,0x200b0034}},	//   _مواض, ебна_, _onca, erci_,
   {{0x69d52756,0x9f5e00b6,0xd00a0e3a,0xdb1d042c}},	//   _muze, čtí_, неме_, _ausü,
   {{0x69d52757,0xaac3000d,0x2d8903a9,0xe44e0c79}},	//   _luze, वेतक, diae_, _уж_,
   {{0x6d4f2758,0x77ad0072,0x63760606,0xe299065c}},	//   _anca, fúxi, _când, _пал_,
   {{0xa3c2000f,0x2d922759,0x6376020a,0x200b0451}},	//   ्दर_, tnye_, _sâng, arci_,
   {{0x2614009d,0xcd360103,0x7e6102c3,0x00000000}},	//   नंती_, درآب, älpa, --,
   {{0x1c460138,0xf1ca00fe,0x69d5020a,0x7de905aa}},	// [1ce0] ынам, _dạt_, _auze, _pèsò,
   {{0x6d4f275a,0x637600d3,0x69d5275b,0x2d920063}},	//   _enca, _gând, _buze, snye_,
   {{0xd94619a6,0x2d920063,0x68e4037a,0x3f8a0079}},	//   лежи, pnye_, ñido, mibu_,
   {{0x2d89002b,0x99900220,0x2578029a,0xf1ca0023}},	//   ciae_, ťaži_, _zélf_, _gạt_,
   {{0x77611f72,0xe7861472,0x69e00117,0x63640139}},	//   _bolx, луко, _žveč, _mònr,
   {{0x69d5275c,0xfaa6275d,0x22470141,0x07a326fd}},	//   _fuze, _баго, _ornk_, бачн,
   {{0x27e6275e,0xe1e70018,0x2a35002d,0x69d5275f}},	//   spon_, _دس_, _кэтр, _guze,
   {{0x7bce0484,0x3f8a0a4b,0x78b1003e,0x636d0076}},	//   _hibu, hibu_, ðkvæ, _dúnm,
   {{0xa3c202e8,0x7bce2760,0x69d503f3,0xb71600e3}},	//   ्दल_, _kibu, _zuze, _مباش,
   {{0x3f8a068d,0x69d514cb,0x69c21570,0x28b9002d}},	//   jibu_, _yuze, lmoe, _русэ_,
   {{0x6b7b13b6,0x637600d3,0x80c202d5,0x2d5c2243}},	//   גרינ, _rând, रेसे, _díez_,
   {{0x84462761,0x7bce2762,0x69c21044,0xdb1c0558}},	//   _مختل, _libu, nmoe, _cirú,
   {{0x2000009c,0x69c20167,0x200b020d,0x645d00f2}},	//   _cvii_, imoe, urci_, øsit,
   {{0x447b07a6,0x7bce1632,0xf487010d,0x841700ca}},	//   _אנדע, _nibu, _حامی, _עקוב_,
   {{0x2904005f,0x6376044c,0x63030037,0x00000000}},	//   _odma_, _vând, _طويل, --,
   {{0x7bce2763,0x3d0f02d5,0x69d50169,0xfbdf00eb}},	//   _aibu, िलें_, _ruze, _drên_,
   {{0x7bce21e9,0x3f8a1cd1,0x69d52764,0x65620113}},	// [1cf0] _bibu, bibu_, _suze, _mooh,
   {{0x7bce2765,0x59d9018b,0x34d1116e,0x2d890133}},	//   _cibu, _बंदर, _हल्द, siae_,
   {{0x5a352766,0x6fdd0033,0xf1ca00fe,0x2d89066a}},	//   рнет, _বিয়ে, _tạt_, piae_,
   {{0xe9ab0421,0x69c20a88,0xe0df0036,0x65620172}},	//   ردان_, gmoe, ncò_, _nooh,
   {{0x68f90067,0xda01007d,0xf80710f7,0x21290510}},	//   rawd, _लटकत_, учен, _mbah_,
   {{0xf7450467,0x7bce11b9,0x68f90150,0x290403a9}},	//   реко, _gibu, sawd, _edma_,
   {{0x7f3c00c1,0x62fa0033,0x636d0032,0x2129001c}},	//   געוו, ংলায়_, _fúnj, _obah_,
   {{0x3f8a0283,0xdb150072,0x7bce0584,0x656200c4}},	//   zibu_, _tizó, _zibu, _cooh,
   {{0x7bce2767,0xb0c702d5,0x320b0034,0x671300a4}},	//   _yibu, रेमग, ącym_, _ठाऊक_,
   {{0x25a019d0,0x4225232c,0x21291d49,0x671c16e2}},	//   čila_, адов, _abah_, _नायक_,
   {{0xe29904b3,0x45d52768,0xe3b600d3,0x00000000}},	//   тан_, _тоес, рбэ_, --,
   {{0x69d80396,0x257b0139,0x798b2769,0xe6f00032}},	//   ívei, _dàlù_, nigw, _iṣẹd,
   {{0x3f8a068d,0x671c00af,0x00000000,0x00000000}},	//   tibu_, _नामक_, --, --,
   {{0xb4c11362,0x21290113,0xa3c22647,0x25710065}},	//   ंधी_, _ebah_, ्दः_, _kálo_,
   {{0x3f8a068d,0x7bce0991,0x0fc300d6,0x798b0ab9}},	//   ribu_, _ribu, ійсн, kigw,
   {{0x7bce276a,0x3f8a276b,0x25710579,0x4aa9009f}},	//   _sibu, sibu_, _málo_, _कड़व,
   {{0x3b86013f,0x9c870031,0x25710065,0xd7a500a4}},	// [1d00] алаг, vočí, _lálo_, खकाच,
   {{0xfbdf011b,0x6ffb0089,0x1db80096,0x29d70090}},	//   _trên_, _שפיג, _आठवत, _għak_,
   {{0x69c201a2,0xe8fa276c,0x7bce276d,0x25780381}},	//   tmoe, вле_, _vibu, _héle_,
   {{0xc8ca012b,0x636d0143,0xfd120037,0x7bce05bd}},	//   نوان_, _búnk, _بجد_, _wibu,
   {{0x7bce11b9,0x69c2276e,0x97c6276f,0xa01b0364}},	//   _tibu, rmoe, айде, rzög,
   {{0x637600d3,0x69c22770,0x6562008c,0x00000000}},	//   _mânc, smoe, _sooh, --,
   {{0x9c87025b,0xbcfb0113,0x798b2771,0xd6d90120}},	//   počí, _moén, bigw, уті_,
   {{0x29042772,0xa4f80470,0x636d2773,0x3426116a}},	//   _udma_, اکار_, _fúnk, афов,
   {{0xf1d00285,0x68ed0042,0x00000000,0x00000000}},	//   _संजन, ñade, --, --,
   {{0xf366117a,0x65620167,0x29c40294,0x76550103}},	//   ртин, _wooh, _ịchụ_, ógyí,
   {{0x1b0300c7,0x0bb700a1,0xa2a60285,0x81de0a43}},	//   র্কে_, שלים_, _घुश्, দীন_,
   {{0x672d00cb,0x51f710e0,0xa1941536,0x00000000}},	//   đaje, шнюю_, жаюч, --,
   {{0x63760161,0x04140081,0x49070096,0xe0df028d}},	//   _cânc, _তৈরী_, हणतो_, rcò_,
   {{0x93fb0054,0x257802c6,0x00000000,0x00000000}},	//   _ילדי, _déle_, --, --,
   {{0x63a82774,0x798b2775,0x00000000,0x00000000}},	//   modn, yigw, --, --,
   {{0x2129063f,0x2baf0fef,0x25780103,0xead00032}},	//   _ubah_, _जीजा, _féle_, _kẹfa_,
   {{0x25780139,0x91bc00ca,0x00000000,0x00000000}},	// [1d10] _géle_, _במהי, --, --,
   {{0x8ae702ec,0x3b542776,0x09de0081,0x3f152777}},	//   ріал, окур, _ডিজা, _удос,
   {{0xcfe200c7,0x69da0018,0x1fe20033,0x798b18fe}},	//   _বিএন, _étel, _বিএস, tigw,
   {{0x63a82778,0x2bd90a85,0x00000000,0x00000000}},	//   hodn, _ماسک_, --, --,
   {{0x8d5a0054,0xf1d002d5,0x66e502a0,0x00000000}},	//   _עכשי, _संघन, бола, --,
   {{0xcc3a0130,0xdc3a0130,0xf1ca0023,0x8038006e}},	//   _געשט, _געשר, _lạp_, ינדע_,
   {{0x798b0010,0x644601cd,0xb9e40120,0xa3c000c3}},	//   pigw, ækin, _міти, ंगई_,
   {{0x7bc52779,0xf1ca00de,0xddd501f9,0x00000000}},	//   lmhu, _nạp_, nyző, --,
   {{0x79890051,0xe80e034c,0x26130f78,0x636d0154}},	//   _imew, _सिया_, _धमकी_, _húni,
   {{0xf77311a2,0x63a8277a,0xc6a70b1b,0x8339007b}},	//   _بار_, godn, _креи, учит_,
   {{0x636d0018,0x216a0d76,0x6146277b,0x00000000}},	//   _júni, гини_, бена, --,
   {{0x249d0197,0xdb050212,0x636d167e,0xf1ca0023}},	//   _txwm_, llhä, _múni, _cạp_,
   {{0x63a80d94,0x232910a6,0x7989024a,0x00000000}},	//   bodn, _боли_, _mmew, --,
   {{0x2bdb05d4,0x533408d8,0xdee30f76,0x442f00dc}},	//   _बढ़ा, _мечт, зори, _ipg_,
   {{0x22580e74,0x31b201f9,0xdb05014b,0x00000000}},	//   ärkt_, házi_, cohé, --,
   {{0xf1d0277c,0xa19307ed,0x1c030006,0x442f00dc}},	//   _सूचन, _најч, _लिखल_, _kpg_,
   {{0xd1170eda,0x00000000,0x00000000,0x00000000}},	// [1d20] _הקפה_, --, --, --,
   {{0xf3f90f71,0x79890051,0x799b277d,0x636d003e}},	//   _আমার_, _amew, _ajuw, _búni,
   {{0x6e460979,0x2002277e,0x2571003e,0x7c3d02a1}},	//   _انجم, lski_, _páll_, _essr,
   {{0x9f490682,0xf8fa0037,0x442f0234,0xcd36001c}},	//   _hvað_, اءات_, _opg_, _اردب,
   {{0xbf9b020d,0x657b277f,0x443d0703,0x00000000}},	//   prêt, dhuh, _nsw_, --,
   {{0x6d4402a7,0x79890e62,0x3940013f,0x7c242780}},	//   ldia, _emew, žis_, mtir,
   {{0x644b2781,0x65be023b,0x8afb040a,0x7afe0483}},	//   _argi, hëhe, _תהלי, mapt,
   {{0x25a02782,0x63a800a5,0xb99600e3,0x657b2783}},	//   čilo_, wodn, _الرب, ghuh,
   {{0x7c242784,0x69c00084,0x6d442785,0xf1ca00de}},	//   ntir, _ihme, idia, _rạp_,
   {{0x20020335,0x68e201cb,0x7afe2786,0xf1ca00fe}},	//   dski_, lcod, napt, _sạp_,
   {{0x9f5d02b4,0xe1352787,0x442f057c,0xdb1c095d}},	//   _ìwé_, онны, _epg_, _chré,
   {{0x5a9b00c1,0x7afe00d1,0x63a82788,0xf6510018}},	//   רשטא, hapt, sodn, _کئے_,
   {{0x6d4402e0,0x63a800e9,0x7afe2789,0x644b1912}},	//   ddia, podn, kapt, _grgi,
   {{0x60d60018,0x6d44278a,0x7c24278b,0x7c3d01ff}},	//   _egym, edia, dtir, _rssr,
   {{0x41e61790,0xf1ca0019,0xdb1c0037,0xa2930120}},	//   _استف, _tạp_, _ghré, _наші,
   {{0x161902e8,0xd011097d,0x2002278c,0x7c24278d}},	//   नंतर_, _قلب_, bski_, ftir,
   {{0x7c2407ac,0xe520278e,0x442f0131,0x00000000}},	// [1d30] gtir, _यानि_, _xpg_, --,
   {{0x636d1094,0x2efa02ac,0x798900bd,0x00000000}},	//   _púni, _gepf_, _smew, --,
   {{0x6d440947,0x7c24278f,0x7a350037,0xce590e3a}},	//   bdia, atir, تفاص, _танц_,
   {{0xac192790,0x68e22791,0x7c242792,0x69c00094}},	//   _кому_, gcod, btir, _chme,
   {{0x7afe2793,0xe8f816dd,0x44240063,0xa3b8136b}},	//   bapt, слі_, jtm_, चता_,
   {{0x7afe2794,0xd7c80981,0x442f0d07,0xbae50076}},	//   capt, مونه_, _rpg_, _ذكري,
   {{0x442f0085,0x443d2795,0x00000000,0x00000000}},	//   _spg_, _ssw_, --, --,
   {{0x24092796,0x68e22797,0x442f030a,0x79890239}},	//   ании_, ccod, _ppg_, _umew,
   {{0x75ca00a5,0xdced0a39,0x00000000,0x00000000}},	//   _języ, jkač, --, --,
   {{0x657b0010,0xb80e00c3,0x2b430117,0x68fb01ec}},	//   shuh, _सितम_, _jajc_, _heud,
   {{0xcb1209c1,0x200200a5,0x68fb005c,0x7c2401e9}},	//   ולי_, wski_, _keud, ztir,
   {{0x200202e6,0x68fb025a,0x443d006c,0xa4f700d0}},	//   tski_, _jeud, _tsw_, _اکثر_,
   {{0x443d01bf,0x442f002b,0xbee5009d,0x68fb0441}},	//   _usw_, _upg_, कडून_, _meud,
   {{0x947406fa,0x68fb01b5,0xdb1c0037,0x65be023b}},	//   _عدنا, _leud, _thré, rëhe,
   {{0xfc3f11c4,0xdce40307,0x00000000,0x00000000}},	//   _así_, nkić, --, --,
   {{0x20022461,0x7c242798,0x7529008f,0x291f006c}},	//   pski_, ttir, nfez, _ncua_,
   {{0xab662799,0x6449279a,0x7afe279b,0x6fb60c5e}},	// [1d40] овал, nvei, tapt, _ومعا,
   {{0x6d44002b,0x2fd7001c,0x75e70233,0x00000000}},	//   sdia, _گوید_, _kızd, --,
   {{0x68e201cb,0xdce4050d,0xfc3f0af0,0x68fb279c}},	//   tcod, jkić, _esí_, _beud,
   {{0x68fb0441,0x671c00aa,0x7afe279d,0x23670154}},	//   _ceud, _नाहक_, sapt, _lonj_,
   {{0x68fb279e,0x183600ab,0x68ed04d8,0x68e20742}},	//   _deud, تراح, ñada, rcod,
   {{0x68e2279f,0x69d81e14,0x644927a0,0x7529010a}},	//   scod, íves, dvei, efez,
   {{0x7afc00ae,0x699600d3,0x637f02ac,0xd95a0284}},	//   _iert, _драх, _kênf, _краљ_,
   {{0x7ae9007e,0x8ebf0033,0x69dc27a1,0x2b430141}},	//   _đeti, _আলমগ, _iure, _zajc_,
   {{0x7afc27a2,0x6603023e,0x3946004b,0x00000000}},	//   _kert, asnk, mdos_, --,
   {{0x69dc27a3,0x394627a4,0x442400dc,0x68fb01e9}},	//   _kure, ldos_, rtm_, _zeud,
   {{0xc4e627a5,0xbcfb026e,0x394627a6,0x64490231}},	//   _джей, _eléy, odos_, avei,
   {{0x69dc27a7,0x3946226a,0x7afc0b7d,0x21200154}},	//   _mure, ndos_, _lert, _ccih_,
   {{0x81ba0081,0x394627a8,0x84960018,0x7afc27a9}},	//   _অংশ_, idos_, _بجائ, _oert,
   {{0x69dc0933,0x25a90ebd,0x7afc249e,0x67380dd9}},	//   _oure, čale_, _nert, nevj,
   {{0xccfb0291,0x645d007b,0xed8b0095,0x00000000}},	//   ића_, äsiv, асак_, --,
   {{0xdb1c0072,0x394401d3,0x7afc27aa,0xfc3f0a7f}},	//   _oiró, _nams_, _aert, _psí_,
   {{0x7afc0cfb,0x69dc27ab,0x0bd500e3,0x2139023b}},	// [1d50] _bert, _aure, سياح, mesh_,
   {{0x69dc27ac,0x7afc0b87,0x201927ad,0x3946001f}},	//   _bure, _cert, musi_, edos_,
   {{0x2019159d,0x7afc27ae,0xea000019,0x68fb037a}},	//   lusi_, _dert, _đảo_, _peud,
   {{0x69dc27af,0x3f9104a3,0x777a01e9,0x213927b0}},	//   _dure, lizu_, _altx, nesh_,
   {{0x69dc27b1,0x66e50e4a,0x201927b2,0xa3ca009d}},	//   _eure, пола, nusi_, लगा_,
   {{0x7afc27b3,0x39460b0b,0x213900dd,0x69dc27b4}},	//   _gert, ados_, hesh_, _fure,
   {{0x7c3901e8,0x7bdd27b5,0xf7700f36,0x69dc27b6}},	//   şarı, _husu, خان_, _gure,
   {{0x7bdd27b7,0x201927b8,0x7afc27b9,0x21390052}},	//   _kusu, kusi_, _zert, jesh_,
   {{0x201927ba,0x69dc27b9,0x7bdd27bb,0x752927bc}},	//   jusi_, _zure, _jusu, rfez,
   {{0x7bdd27bd,0x644927be,0x201927bf,0x25710088}},	//   _musu, rvei, dusi_, _máli_,
   {{0xcb1207a6,0x644927c0,0x7ae50013,0xa91d013f}},	//   עלט_, svei, icht, _amži,
   {{0x291d27c1,0x201927c2,0xb9230065,0xcf890089}},	//   ngwa_, fusi_, _aarẹ_, _גט_,
   {{0x201927c3,0x7bdd27c4,0x3f910022,0x31690634}},	//   gusi_, _nusu, fizu_, _doaz_,
   {{0xdb1c01b9,0x636d0076,0x7bd527c5,0x394600c6}},	//   _chrì, _cúnt, _nizu, zdos_,
   {{0xe2960dc0,0xed5a27c6,0x272f03a3,0x3ebe0578}},	//   _наш_, бов_, mını_, ått_,
   {{0x7afc10f3,0x201927c7,0x7bdd27c8,0xa0a627c9}},	//   _sert, busi_, _busu, _найд,
   {{0x7afc27ca,0x69dc27cb,0x7bdd0694,0xdca31107}},	// [1d60] _pert, _sure, _cusu, еати,
   {{0xef860a18,0x272f0511,0x394427cc,0x636d0139}},	//   _хлоп, nını_, _sams_, _gúnt,
   {{0x7afc27cd,0x19ba14fa,0x7bd50a00,0x7bdd002b}},	//   _vert, будь_, _dizu, _eusu,
   {{0x7ae5054f,0x7afc27ce,0x7bdd0baa,0xdb1c0bac}},	//   acht, _wert, _fusu, _piró,
   {{0x7afc03b4,0x2d9227cf,0x25ad0305,0x7bdd0193}},	//   _tert, miye_, doel_, _gusu,
   {{0x69dc27d0,0x6d4627d1,0x2d9227d2,0xa3c2000d}},	//   _ture, _haka, liye_, ्दछ_,
   {{0x6d4627d3,0x272f008e,0xfaa327d4,0x98ac00a7}},	//   _kaka, dını_, _заро, ılıq_,
   {{0x6d4627d5,0x2d9227d6,0x7ec70018,0xdb1c27d7}},	//   _jaka, niye_, lépé, _tiró,
   {{0x6d4627d8,0x7bdd27d9,0x66180146,0xb4c80789}},	//   _maka, _xusu, suvk, ोखे_,
   {{0x6d4627da,0x684327db,0x201927dc,0x29d703e5}},	//   _laka, _януа, vusi_, _għas_,
   {{0x2d9227dd,0x213900dd,0x25ad27de,0x69c80036}},	//   kiye_, tesh_, boel_, _èdes,
   {{0x6d4627df,0x201927e0,0x63640154,0x25ad03a9}},	//   _naka, tusi_, _jònz, coel_,
   {{0x2d9227e1,0x2139023b,0x645d27e2,0x2d801d42}},	//   diye_, resh_, äsit, dhie_,
   {{0x201927e3,0x6d4606a8,0x1be3009f,0x2139023b}},	//   rusi_, _aaka, _कंबल_, sesh_,
   {{0x201927e4,0x4ea424e9,0x7bdd27e5,0x213900dd}},	//   susi_, ерта, _susu, pesh_,
   {{0x2d8027e6,0x201927e7,0x6d4618c4,0x2d92023f}},	//   ghie_, pusi_, _caka, giye_,
   {{0x071c1e5e,0x6d4627e8,0xea000028,0x7ae527e9}},	// [1d70] _नांव_, _daka, _đạo_, tcht,
   {{0xe3b806d7,0x7ae501bf,0xad2701f3,0x0bb40686}},	//   nlı_, ucht, _کردو, ебую,
   {{0x7bd527ea,0x6d4627eb,0x68ed0fb6,0x2d9227ec}},	//   _vizu, _faka, ñado, biye_,
   {{0x2d8027ed,0x4426002b,0x7ae501bf,0x64420084}},	//   chie_, _oqo_, scht, _osoi,
   {{0x25ad01a2,0xe3b801e8,0x442627ee,0xb905009f}},	//   voel_, klı_, _nqo_, _नल_,
   {{0xaca30174,0x32050094,0xe80e0336,0xe3b8071d}},	//   _laịb, ysly_, _सिरा_, jlı_,
   {{0x6d4627ef,0x25ad0db1,0xe3b800a7,0xda34013f}},	//   _yaka, toel_, dlı_, _перы,
   {{0x5ebf0081,0xc17401c2,0xa3de02d5,0x1dbf2172}},	//   _আলাই, _kiɗe_, _दंश_, ्षित,
   {{0xe3b80740,0x272f08bb,0x290d27f0,0x31b20103}},	//   flı_, tını_, _idea_, zázs_,
   {{0x29d7003d,0x27ed27f1,0xd389004d,0x69cb27f2}},	//   _għar_, _iten_, ійне_, lmge,
   {{0x272f08f5,0xaca300ac,0x9f5900c2,0x25ad27f3}},	//   rını_, _baịb, issä_, poel_,
   {{0x272f0390,0x72070018,0xe3b800a7,0x645d007b}},	//   sını_, _ہفتہ_, alı_, äsis,
   {{0x6d4627f4,0xa01b0068,0xe3ae08a1,0xd469171b}},	//   _raka, szön, _аб_, _филе_,
   {{0x6d4627f5,0xdb1c00e3,0x2d9227f6,0x81bd01d3}},	//   _saka, _phrí, wiye_, ntēj,
   {{0x6d4627f7,0x2d9227f8,0xa2c901e4,0x2d8027f9}},	//   _paka, tiye_, हेश्, thie_,
   {{0xed570e96,0x9f5900c2,0x753b2153,0xa2a6058f}},	//   мос_, essä_, neuz, _घुट्,
   {{0x6d4627fa,0x2d9227fb,0x656b27fc,0x27ed27fd}},	// [1d80] _vaka, riye_, _mogh, _nten_,
   {{0x6d4627fe,0x2d9227ff,0x656b2800,0x290d2801}},	//   _waka, siye_, _logh, _adea_,
   {{0x6d462802,0x2d802803,0x637f2804,0x443f005c}},	//   _taka, phie_, _gêne, hwu_,
   {{0x3d1804a9,0x443f06c0,0xe3b80587,0x6d460027}},	//   _फाटे_, kwu_, zlı_, _uaka,
   {{0x7d042805,0xe3b807d1,0xd90d00d0,0xb8f6009d}},	//   mais, ylı_, صیل_, _सण_,
   {{0x7d042806,0x75220451,0x656b01b9,0x290d0113}},	//   lais, _scoz, _aogh, _edea_,
   {{0x27ed2807,0xa3c309c3,0x656b2808,0xa3c10f42}},	//   _eten_, ्षन_, _bogh, ंतन_,
   {{0x7d042809,0x25780257,0x753b0051,0x656b0a9a}},	//   nais, _vélo_, geuz, _cogh,
   {{0x656b280a,0xe3b803a3,0xa2d0280b,0x443f06c0}},	//   _dogh, tlı_, डेन्, gwu_,
   {{0x7d04280c,0x636d00b3,0x656b03dc,0x6724007e}},	//   hais, _búnq, _eogh, đijs,
   {{0x7d04280d,0x656b0a21,0x81bd0029,0xa3de245a}},	//   kais, _fogh, stēm, _दूर_,
   {{0x7d04280e,0xe3b80491,0x2d9e0103,0xc5f30327}},	//   jais, slı_, étel_, _ידע_,
   {{0x9f5900c2,0xe3b80233,0xdb1c009c,0x637f084e}},	//   yssä_, plı_, _ohrà, _sêne,
   {{0xe3b801d4,0x81bd00d9,0xd2502296,0xc05807bf}},	//   qlı_, otēk, _منت_, фію_,
   {{0xdfd4280f,0xd90414df,0x8d7700e3,0xaca30174}},	//   торы, _پی_, وارا, _mbụb,
   {{0x7d042810,0x656b2811,0x75200350,0x00000000}},	//   gais, _xogh, ngmz, --,
   {{0xfbdf2812,0xdb1c0441,0x2bbd00b6,0x3b552813}},	// [1d90] _quê_, _bhrà, ्गला, нкар,
   {{0x31a403a3,0xa3c31ab1,0xdb1c01f7,0x60c02814}},	//   mıza_, ्षय_, _chrà, ümme,
   {{0x7d042815,0x27ed2816,0xdb1c2817,0x290d00f9}},	//   bais, _sten_, _virð, _pdea_,
   {{0xaca30294,0x7d042818,0x00000000,0x00000000}},	//   _abụb, cais, --, --,
   {{0x656b0514,0x31a403a3,0x69cb2819,0xa3c300c3}},	//   _rogh, nıza_, rmge, ्षम_,
   {{0xf1ca0019,0x656b00e3,0xdb07004d,0xdb1c0441}},	//   _dạy_, _sogh, _skjæ, _ghrà,
   {{0x81bd0029,0xd90f00d0,0x45d5016e,0xbbbd05a5}},	//   rtēj, _نیا_, нцит, ्गीक,
   {{0x79820067,0x443f0034,0x290d281a,0x81bd01d3}},	//   chow, twu_, _udea_, stēj,
   {{0x27ed02ec,0x656b0451,0xfbdf281b,0x753b281c}},	//   _uten_, _vogh, _trêu_, reuz,
   {{0x2d8c020d,0xc48205b6,0xc8a800bc,0x00000000}},	//   édez_, ульк, _छुटट, --,
   {{0x68e40039,0x656b0037,0x1ddb00b7,0x443f0027}},	//   žide, _togh, _मंगत, swu_,
   {{0x92df0081,0xe4510037,0x31a40233,0x00000000}},	//   তরে_, _مضت_, fıza_, --,
   {{0x600702ec,0x7d04281d,0x00000000,0x00000000}},	//   нням_, vais, --, --,
   {{0xdb1c0094,0x00000000,0x00000000,0x00000000}},	//   _ohrá, --, --, --,
   {{0xf77200f5,0x7d04281e,0xed5a124c,0x00000000}},	//   נקל_, tais, пов_, --,
   {{0x61ee058a,0x7bc713db,0xdb1c01f7,0x5d6700d3}},	//   íble, _ahju, _shrà, нисм_,
   {{0x7d04281f,0xdee62820,0xc19b00ca,0xdb1c01b9}},	// [1da0] rais, _попи, _משקי, _phrà,
   {{0x7d042821,0x60c40060,0x8fa60d5b,0xdb1c0037}},	//   sais, _izim, _سمجه, _bhrá,
   {{0xdb1c0074,0xe9da225d,0xc332028c,0x4efb00a1}},	//   _chrá, чке_, רוב_, _מהיו,
   {{0xfbdf0257,0x4aaf0096,0x307a006e,0x2571003e}},	//   _prêt_, _जुळव, ּאַנ, _máls_,
   {{0xb8e80ccb,0xdb1c0441,0x75e7047e,0x00000000}},	//   _उर_, _thrà, _rıza, --,
   {{0x38cb1e49,0x60c42822,0xfc3f0042,0x2bd80034}},	//   سانی_, _mzim, _uxía_, _भूचा,
   {{0xdb1c0076,0xfaa60095,0xe2870037,0x00000000}},	//   _ghrá, _чаво, _إذ_, --,
   {{0x60c42823,0x04660221,0x00000000,0x00000000}},	//   _ozim, етом, --, --,
   {{0x60c42824,0x81e70033,0xe8e00174,0x18a32825}},	//   _nzim, মীম_, niọs_, _батм,
   {{0x29060062,0x00000000,0x00000000,0x00000000}},	//   laoa_, --, --, --,
   {{0x60c42826,0x63760231,0x00000000,0x00000000}},	//   _azim, _jâni, --, --,
   {{0x4a9b00c1,0x546a008f,0xc486002d,0xbcfb00fd}},	//   לייג, _наем_, _плек, _inég,
   {{0xc953040a,0x25710103,0x06d50033,0x74132827}},	//   אמר_, _vált_, _স্পি, _مونا,
   {{0xa3c300e2,0x60c400d9,0x25a002dd,0xadc40065}},	//   ्षण_, _dzim, čilu_, _ikẹt,
   {{0x60c42828,0x5e5800ae,0x00000000,0x00000000}},	//   _ezim, ниря_, --, --,
   {{0x3eba0120,0x2906024a,0x212f009c,0x00000000}},	//   _dypt_, jaoa_, _ùgh_, --,
   {{0x2ef50465,0xe802030b,0xafdb00f2,0xdb1c0076}},	// [1db0] _изпр, रीमा_, rvøs, _shrá,
   {{0xc5f60081,0x200b2829,0x8aa7282a,0x7e610212}},	//   _ঘটনা_, msci_, нред, älps,
   {{0xd5df000f,0x321e282b,0xdd91001c,0x200b0036}},	//   _पूंज, nuty_, _نود_, lsci_,
   {{0xc17403e3,0x7ec70065,0x1a680281,0x27e60381}},	//   _kiɗa_, _eépí, ریقی_, fqon_,
   {{0x6d5d08f8,0xdbdb0032,0x200b0036,0x00000000}},	//   _insa, _fàáj, nsci_, --,
   {{0x7c2d01e5,0x3949282c,0x6d4d0b54,0xdb1c0037}},	//   mtar, žas_, ldaa, _thrá,
   {{0xfbdf0396,0xe708012b,0xadc40065,0xcf5800a1}},	//   _três_, رتون_, _akẹt, תבות_,
   {{0x6d4d282d,0x4904177a,0x7c2d282e,0xe4590927}},	//   ndaa, _موفق, otar, джи_,
   {{0x200b00cc,0x6d5d00f9,0xd6db282f,0x62880031}},	//   jsci_, _mnsa, _ете_, ezdo,
   {{0x7c2d2830,0x69da2831,0x6d4d008c,0x27ff0139}},	//   itar, _éter, hdaa, _iwun_,
   {{0x7c2d2832,0x69c901bb,0x6f070220,0x6d5d2833}},	//   htar, _khee, dajc, _onsa,
   {{0x04b500e5,0xafe610e0,0x00000000,0x00000000}},	//   _исля, комл, --, --,
   {{0x6d4d2834,0x7c2d023b,0x1b0c0033,0x69c901b9}},	//   ddaa, jtar, স্টে_, _mhee,
   {{0x6d5d2835,0x6d4d2836,0x4255002d,0x321e00e2}},	//   _ansa, edaa, _атит, buty_,
   {{0x7c2d2837,0x20192838,0x637f020d,0x3f810206}},	//   etar, arsi_, _gêna, _dlhu_,
   {{0xe8021376,0x656900dd,0x6d4d2839,0x69db0113}},	//   रीडा_, njeh, gdaa, _niue,
   {{0x60c408a9,0x7c2d283a,0x1ae6283b,0x6376020a}},	// [1dc0] _uzim, gtar, возм, _sâni,
   {{0x6d5d283c,0x61e3283d,0xa3c105d4,0x6f0700e9}},	//   _ensa, _kunl, ंति_, cajc,
   {{0x442d283e,0xbcfb283f,0x3f98005f,0x7c2d2840}},	//   hte_, _poét, miru_, atar,
   {{0x3f98063f,0x6d4d008a,0x7c2d2841,0x69c92842}},	//   liru_, cdaa, btar, _chee,
   {{0x69c90694,0x7c2d2843,0xa3c10f73,0x69db05fe}},	//   _dhee, ctar, ंता_, _diue,
   {{0x442d2844,0xbb76008f,0xa9250031,0x63760131}},	//   dte_, _румъ, _rožň, _tâni,
   {{0x442d24d4,0xe1e70214,0x00000000,0x00000000}},	//   ete_, _خس_, --, --,
   {{0x7bdc2845,0x657b2846,0x628815fe,0x3f982847}},	//   _hiru, gkuh, vzdo, hiru_,
   {{0x442d2848,0x75e701e8,0x37e600d6,0x23470018}},	//   gte_, _hızl, _розг, چسپی_,
   {{0x671c10e9,0x61e30702,0x201908a9,0x75e701e8}},	//   _नाटक_, _bunl, vrsi_, _kızl,
   {{0x442d2849,0x7bdc284a,0xf3630fe9,0x6d4d008a}},	//   ate_, _miru, ртын, ydaa,
   {{0x442d284b,0x7c2d284c,0xfd550134,0x29040239}},	//   bte_, ytar, _draị, _jema_,
   {{0x442d284d,0x29040051,0x7c2d284e,0x3f8101fa}},	//   cte_, _mema_, xtar, _plhu_,
   {{0x2904284f,0xfd550294,0x7bdc0ee7,0xdce601d3}},	//   _lema_, _fraị, _niru, _rokā,
   {{0x7c2d0034,0x6d4d000b,0x91e30291,0xdced007e}},	//   wtar, tdaa, _које, nkać,
   {{0x7c2d2850,0x672d0106,0xdd1100a7,0xa3e71115}},	//   ttar, đaji, _düşd, _मूड_,
   {{0x6d4d2851,0x7bdc2852,0xd1b8110a,0x69c91c02}},	// [1dd0] rdaa, _biru, _جاوا_, _rhee,
   {{0x09cb0c16,0x2d820db8,0xd9cb2853,0x7bdc0623}},	//   िष्य, _elke_, िष्ट, _ciru,
   {{0x442d2854,0x7bdc2855,0x69c90197,0x29042856}},	//   zte_, _diru, _phee, _bema_,
   {{0x7c2d074a,0x6d5d1098,0x442d2857,0x27e400a4}},	//   ptar, _unsa, yte_, _bumn_,
   {{0x442d2858,0x7bdc2859,0x69db0428,0xec3500c1}},	//   xte_, _firu, _viue, _גאָר_,
   {{0x442d025b,0x7bdc285a,0xf1bf285b,0x69c9285c}},	//   vte_, _giru, hlá_, _whee,
   {{0x69c9285d,0xc79400cd,0x6abc0150,0x442d285e}},	//   _thee, جشنب, _gyrf, wte_,
   {{0x7bdc285f,0x6f0500b6,0x75451a0c,0xa3e70980}},	//   _ziru, _lehc, униз, _मंद_,
   {{0x442d2860,0xf1bf0038,0x77930068,0x25a605aa}},	//   ute_, dlá_, _پیغا, _djol_,
   {{0xe1f90a54,0x657b2861,0x61e32862,0xf7700192}},	//   нго_, skuh, _punl, _وال_,
   {{0x35f52863,0x656903c6,0x395f2864,0x25a60212}},	//   _спер, pjeh, _knus_, _fjol_,
   {{0x06d50033,0x3f9805bd,0x00000000,0x00000000}},	//   _স্থি, wiru_, --, --,
   {{0x394d02ad,0x442d023b,0xdb150094,0xd0960ae3}},	//   _maes_, qte_, _ekzé, ушны,
   {{0x749a2865,0x649a0130,0x61e30139,0x25bf2866}},	//   _אינפ, _אינה, _tunl, llul_,
   {{0xe1f1172a,0x20002867,0x3f982868,0x61e30270}},	//   _است_, _wwii_, riru_, _uunl,
   {{0x0ce20081,0x2258052f,0x3f982869,0x7f9400a7}},	//   বর্ত, ærke_, siru_, _müqə,
   {{0x3f980106,0x64440b14,0x25bf00ae,0x2904286a}},	// [1de0] piru_, _šiiz, ilul_, _rema_,
   {{0xdd040dea,0x2904286b,0x09dc0096,0x69c3020d}},	//   ısın, _sema_, यद्य, înen,
   {{0x75e70092,0x7bdc286c,0x2904286d,0x00000000}},	//   _qızl, _viru, _pema_, --,
   {{0x394d0850,0x25780103,0xdcf7020a,0x7bdc286e}},	//   _caes_, _téli_, ăcăr, _wiru,
   {{0x29040051,0x9f40009c,0x00000000,0x00000000}},	//   _vema_, _stiù_, --, --,
   {{0x6fb4000f,0x7d06286f,0x29042822,0xc3190081}},	//   ंकिं, _heks, _wema_, ত্তি_,
   {{0x7d062870,0xfbde0072,0x637600ae,0x394d00f0}},	//   _keks, _iiª_, _mânt, _faes_,
   {{0x782600e3,0x746a0084,0x5e5700c1,0x81bd00d9}},	//   _معطل, еров_, ריקע_, ntēt,
   {{0x644d007e,0x5fb4023a,0x49910401,0xa3e70ff9}},	//   _šair, ंकाल, _بینر, _मूद_,
   {{0x7d060b85,0x883b00ca,0x25bf00ae,0x38cb0281}},	//   _leks, _אתמו, alul_, _ساقی_,
   {{0x4ebf00c7,0xf1bf0031,0x25bf020a,0x877b006e}},	//   _আল্ল, tlá_, blul_, _ראבי,
   {{0x25bf00ae,0x6fc009b5,0x00000000,0x00000000}},	//   clul_, böck, --, --,
   {{0x33f600ae,0x637f0231,0x8cb00ff9,0x6376044c}},	//   _счес, _gêno, _अँगो, _sânu,
   {{0x637600d3,0xf1bf035d,0x1b1a0033,0x00000000}},	//   _cânt, slá_, ন্তে_, --,
   {{0xa3c316e2,0xa3c11493,0x7d062871,0x3da72872}},	//   ्षर_, ंतर_, _beks, граб,
   {{0x9e430146,0xfc15002d,0x00000000,0x00000000}},	//   žďov, имбэ, --, --,
   {{0x7d062873,0xbcfb0610,0x6376020a,0xd0110d83}},	// [1df0] _deks, _anéc, _fânt, _بلخ_,
   {{0x7d060270,0x3d1b0139,0x3dc006a8,0x395f2874}},	//   _eeks, _bàwà_, aliw_, _snus_,
   {{0x394d2875,0x7d0601f9,0x00000000,0x00000000}},	//   _paes_, _feks, --, --,
   {{0x4dfa0130,0xa9072876,0x7d061cab,0x00000000}},	//   _שפרא, ابان, _geks, --,
   {{0xd7050b1e,0x1b1a0033,0x00000000,0x00000000}},	//   азли, ন্ধে_, --, --,
   {{0xe7392877,0x257801dc,0x6b810294,0x394d01cb}},	//   тек_, _mélu_, ịgbo, _waes_,
   {{0x6d4f2878,0x25bf00d3,0x27f80087,0x7c3d01ff}},	//   _kaca, tlul_, _črne_, _hpsr,
   {{0x395f2879,0x6d4f287a,0x2d89287b,0x6fc002db}},	//   _unus_, _jaca, nhae_, töck,
   {{0xb81c0d7e,0x87271850,0x64a5287c,0x27f8025b}},	//   _नियम_, _معام, рапа, čený_,
   {{0x6d4f0694,0x00000000,0x00000000,0x00000000}},	//   _laca, --, --, --,
   {{0xb1130129,0x49b80103,0x25bf287d,0x255e0174}},	//   _tụle, _شاہد_, plul_, ọlam_,
   {{0x249600bf,0x6d4f0188,0x672d0106,0xe80200c3}},	//   انید_, _naca, đaju, रीवा_,
   {{0x764e0088,0x7d060088,0x63761497,0x00000000}},	//   _ábyr, _reks, _pânt, --,
   {{0x64590090,0x248d01fa,0x6376020a,0x00000000}},	//   _irwi, mzem_, _dâns, --,
   {{0xe81c0251,0x2d9600c6,0x7d06287e,0x3ebe0088}},	//   _निभा_, арас, _peks, ætt_,
   {{0x6d4f287f,0x6459007f,0xa1930b36,0x00000000}},	//   _caca, _krwi, _мајч, --,
   {{0x7d0600f3,0x6d4f0188,0x81bd01d3,0x63760231}},	// [1e00] _veks, _daca, rtēt, _tânt,
   {{0x644b00bf,0x6d4f01f7,0x25780088,0x29d70090}},	//   _msgi, _eaca, _hélt_, _għaz_,
   {{0x7d0601ce,0x6d4f0013,0x7c3d2880,0x81e70081}},	//   _teks, _faca, _epsr, মীর_,
   {{0x6d4f2881,0x323600c1,0x2d8918c7,0x6e3e0063}},	//   _gaca, יטען_, chae_, _ippb,
   {{0x6d442882,0x69da0036,0x7c3d0062,0xa01b0103}},	//   meia, _ètem, _gpsr, szöv,
   {{0x2d8000a5,0x248d2702,0x6d4f2883,0xab090182}},	//   lkie_, dzem_, _zaca, _متفق_,
   {{0xfaa32884,0xeb970b3b,0x6d4f2885,0x64592886}},	//   _даро, _тир_, _yaca, _arwi,
   {{0x2d800665,0xdb0700f3,0x6d4f002b,0xa3e700c3}},	//   nkie_, _skjø, _xaca, _मूह_,
   {{0xb71600cd,0xa3c300a4,0x69c200bc,0xf4862887}},	//   _نباش, ्षं_, mloe, руйн,
   {{0x69c20150,0x443d0167,0x6e3e004d,0x6d442888}},	//   lloe, _dpw_, _oppb, heia,
   {{0x2d800665,0x0cc30abe,0x64592889,0x443d0063}},	//   kkie_, _शर्म, _erwi, _epw_,
   {{0x7c241fce,0xdb1c0503,0x00000000,0x00000000}},	//   kuir, _chrú, --, --,
   {{0x6d44288a,0x7bce0063,0x248d0034,0xdb050072}},	//   deia, _ohbu, czem_, rohú,
   {{0x6d4f288b,0x7c24288c,0xdb050149,0x4ea7288d}},	//   _saca, duir, llhö, арба,
   {{0x6d4f288e,0x8de8036a,0xf206008f,0x69c201c8}},	//   _paca, ифта_, _тяло, kloe,
   {{0x69c80029,0xdb1c0037,0xccf80284,0x7c24288f}},	//   _ūden, _ghrú, ићу_, fuir,
   {{0x44242890,0x65620074,0x7bce02ef,0x69c300fd}},	// [1e10] num_, _mnoh, _bhbu, înem,
   {{0x25a91c56,0x6d4f2891,0xde470504,0x68e400d4}},	//   čali_, _waca, _پیرو_, židl,
   {{0x6d4f0422,0x442411b9,0xa91d0220,0x5a3510b8}},	//   _taca, hum_, _dlžn, снет,
   {{0x44242892,0x2d802893,0x79a423c3,0xac1900d6}},	//   kum_, ckie_, орче, _йому_,
   {{0x765a0067,0x44242894,0xbcfb0037,0x7c2400ae}},	//   _arty, jum_, _gnéa, cuir,
   {{0xbb85054f,0x44242895,0x7d0d2896,0x248d02dd}},	//   _السي, dum_, laas, vzem_,
   {{0x636d2897,0x69c22898,0xff1800ca,0x443d2899}},	//   _gúny, bloe, בקות_, _spw_,
   {{0x7d0d289a,0x44240102,0x248d05fe,0xa01b01bf}},	//   naas, fum_, tzem_, nzös,
   {{0x4424289b,0xe3b91510,0x00000000,0x00000000}},	//   gum_, лби_, --, --,
   {{0xd7740080,0x7d0d289c,0x248d289d,0x2d8001e9}},	//   _والع, haas, rzem_, zkie_,
   {{0x7d0d289e,0x248d1feb,0xdb1c01f7,0x29d702a1}},	//   kaas, szem_, _chrù, _bħax_,
   {{0x7d0d289f,0x442428a0,0xdb1c01b9,0x00000000}},	//   jaas, bum_, _dhrù, --,
   {{0x442428a1,0x7d0d0694,0x55520068,0x645902a4}},	//   cum_, daas, _رپور, _urwi,
   {{0xa0270102,0x752928a2,0x644900f0,0x00000000}},	//   _stöð, lgez, mwei, --,
   {{0x51f51857,0x644901bf,0x7d0d1e09,0xdb1c009c}},	//   _استر, lwei, faas, _ghrù,
   {{0x7d0d28a3,0x752928a4,0x7c2428a5,0x29d703e5}},	//   gaas, ngez, tuir, _għax_,
   {{0x69c201a2,0x644902e2,0x3b861b48,0x2d800abf}},	// [1e20] vloe, nwei, благ, rkie_,
   {{0x2d8028a6,0x4f2607df,0x7c2428a7,0xa01b01f9}},	//   skie_, _удоб, ruir, rzöt,
   {{0x644928a8,0x7d0d28a9,0x7c2408a9,0x6e3e1df0}},	//   hwei, baas, suir, _uppb,
   {{0x442428aa,0x7529029a,0x6f0e01c2,0x645501d3}},	//   yum_, jgez, labc, āzij,
   {{0x7c2428ab,0xe80b000f,0xa3e71358,0x44241a4a}},	//   quir, _सौदा_, _मूल_, xum_,
   {{0x64490150,0x6f0e0d2a,0x9f4000b3,0x69c228ac}},	//   dwei, nabc, _juià_, sloe,
   {{0x442428ad,0x69c21030,0x3f9a0063,0x75290364}},	//   wum_, ploe, _mmpu_, fgez,
   {{0x752928ae,0x64490364,0x9f8400c2,0x3e580383}},	//   ggez, fwei, löä_, _mčt_,
   {{0x6449133e,0x394628af,0x81ae0033,0x77ca28b0}},	//   gwei, meos_, কতা_, _благ_,
   {{0x442428b1,0xf36628b2,0x39461ba6,0xa3e7009d}},	//   rum_, стин, leos_, _मूळ_,
   {{0x7d0d025e,0xb7d70c5e,0x3e580383,0x6f0e00ee}},	//   yaas, _اولا_, _nčt_, dabc,
   {{0x798200a5,0x4424003e,0x394628b3,0x65620084}},	//   nkow, pum_, neos_, _unoh,
   {{0x54330688,0x657d02c3,0x7d0d28b4,0x00000000}},	//   _فرور, öshe, vaas, --,
   {{0x7d0d28b5,0x3e580383,0x6f0e01c2,0x2d9928b6}},	//   waas, _bčt_, gabc, _smse_,
   {{0x7d0d28b7,0x63ba109b,0x7a1c00d3,0x877b0089}},	//   taas, motn, nătă, נאלי,
   {{0x63ba02dd,0xdd940138,0x3253008f,0x3f9a00d1}},	//   lotn, пасы, _хвър, _empu_,
   {{0x7d0d28b8,0x79820034,0x2d5800c2,0xdb9928b9}},	// [1e30] raas, dkow, щить_, авач_,
   {{0x7d0d28ba,0x3e5806a3,0x5b1528bb,0x60cd1937}},	//   saas, _fčt_, імет, _izam,
   {{0x27f80087,0x39460610,0x64490364,0x7d0d28bc}},	//   _črna_, feos_, zwei, paas,
   {{0x41c90403,0xf1c904f8,0x63ba28bd,0x61ea28be}},	//   रतिस, रतिन, hotn, _mufl,
   {{0x18691d5c,0x63ba28bf,0xf8b10504,0x00000000}},	//   рали_, kotn, ذکر_, --,
   {{0x36190084,0xa09c00c1,0xb09c006e,0x60cd28c0}},	//   ацию_, ניגט, ניגר, _mzam,
   {{0x752901c0,0x994d0220,0x63ba0167,0x39460328}},	//   tgez, môžu_, dotn, beos_,
   {{0x644928c1,0xdb1c2502,0x394609d3,0xe57928c2}},	//   twei, _akrè, ceos_, рзи_,
   {{0x290f28c3,0xe10100c7,0x79890139,0x752928c4}},	//   maga_, ্লাহ_, _ilew, rgez,
   {{0x290f28c5,0x644928c6,0x752928c7,0x00000000}},	//   laga_, rwei, sgez, --,
   {{0x644928c8,0x60cd28c9,0x76ab28ca,0x79892502}},	//   swei, _azam, _став_, _klew,
   {{0x290f28cb,0xc17401c2,0x61ea28cc,0x98a4009e}},	//   naga_, _kiɗi_, _dufl, _qamħ_,
   {{0x799b0361,0x798902a1,0x637f00fe,0xafdb0120}},	//   _mmuw, _mlew, _lêni, lvøy,
   {{0x60cd050d,0xd347001c,0x79890178,0x56b5006e}},	//   _dzam, _ایده_, _llew, ַפּן_,
   {{0x290f28cd,0xdee328ce,0xe2960036,0x798928cf}},	//   kaga_, дори, _маш_, _olew,
   {{0xa3c30bd9,0xa0a6004d,0x72420018,0xb4f9006e}},	//   ्षक_, _майд, _کھیل, שפּי,
   {{0x290f28d0,0x9f8400c2,0xada30231,0xa01b0103}},	// [1e40] daga_, töä_, фатл, ször,
   {{0x76410021,0xa2d00789,0x61e428d1,0x798928d2}},	//   _oply, डेक्, _hiil, _alew,
   {{0x79820067,0x61e428d3,0x9f40016d,0x8a0601ce}},	//   tkow, _kiil, _guiá_, ізде,
   {{0x5f46037f,0xed5a28d4,0x08c61e13,0x290f28d5}},	//   _انگل, _том_, обен, gaga_,
   {{0x798228d6,0x3946222b,0x61e428d7,0x798901dc}},	//   rkow, reos_, _miil, _dlew,
   {{0x798928d8,0x39460fb6,0x798200a5,0x39520138}},	//   _elew, seos_, skow, žys_,
   {{0x63ba28d9,0x290f0549,0x394604d8,0x637f016d}},	//   votn, baga_, peos_, _gêni,
   {{0x61e40857,0x6d5628da,0x290f28db,0x63ba0034}},	//   _niil, ndya, caga_, wotn,
   {{0x98a328dc,0x61ea002d,0x60c428dd,0x7c360429}},	//   _жите, _sufl, _nyim, ntyr,
   {{0x61e4009c,0x63a80167,0xd37a23b9,0xdb17002b}},	//   _aiil, undn, рчи_, toxé,
   {{0x63ba28de,0x326600d6,0xa3ab02d5,0x60cd2214}},	//   rotn, ітов, _गदर_, _szam,
   {{0x63ba28df,0x60c405bd,0xdb17002b,0x61e4008c}},	//   sotn, _byim, roxé, _ciil,
   {{0x63ba0087,0x9f490161,0x60c405bd,0x490b10e9}},	//   potn, _itaú_, _cyim, ारतो_,
   {{0x290f28e0,0x60cd0087,0xa294224a,0xdb170072}},	//   zaga_, _vzam, _налі, poxé,
   {{0x290f28e1,0xdd9b1d18,0x3f83003e,0x61e428e2}},	//   yaga_, аша_, rkju_, _fiil,
   {{0xf1a400d3,0x3f8328e3,0x1b040081,0x61e40009}},	//   _орын, skju_, _লাগে_, _giil,
   {{0x6ebb04dd,0x60cd28e4,0x290f28e5,0x637f0131}},	// [1e50] _शुरु, _uzam, vaga_, _sêni,
   {{0x69c022bb,0x637f0161,0xc17401c2,0xddeb001c}},	//   _akme, _pêni, _riɗi_, _پرده_,
   {{0xdced084f,0x290f28e6,0xdb07003e,0xfc3f00fe}},	//   ljač, taga_, _skjó, _axít_,
   {{0x20090d2a,0xe81c0287,0x00000000,0x00000000}},	//   _kwai_, _निशा_, --, --,
   {{0x290f28e7,0x64460092,0xf84b00ae,0x764100d4}},	//   raga_, çkil, рчей_, _sply,
   {{0x290f28e8,0x637f001f,0x69c0026a,0x200928e9}},	//   saga_, _têni, _ekme, _mwai_,
   {{0x64420ba0,0xf96b28ea,0x00000000,0x00000000}},	//   _apoi, _край_, --, --,
   {{0xe79500d0,0x76410220,0x799b0bb6,0x64420037}},	//   _کارک, _vply, _umuw, _bpoi,
   {{0xdced1419,0xd7f8090f,0x68e90090,0x00000000}},	//   jjač, _дух_, _iged, --,
   {{0x61e4289c,0xdced042d,0x69d928eb,0x60c40079}},	//   _siil, djač, lmwe, _ryim,
   {{0x4b7c0130,0x76410146,0x61e4032c,0xbcfb00fc}},	//   יאזו, _uply, _piil, _aném,
   {{0xe8020976,0x644f052f,0x27ed03a9,0x68e90090}},	//   रीका_, æcis, _kuen_, _jged,
   {{0x27e520bb,0x61e428ec,0x27ed01ff,0x68e902a1}},	//   _kiln_, _viil, _juen_, _mged,
   {{0x61e4008a,0xdce40995,0x2d8b0231,0x221500e5}},	//   _wiil, ljić, _alce_, _ефир,
   {{0x63a128ed,0x68e928ee,0x257100d4,0x61e428ef}},	//   miln, _oged, _sály_, _tiil,
   {{0x68e928f0,0xdce403d6,0x63a12516,0x65790188}},	//   _nged, njić, liln, _jowh,
   {{0x27ed0a00,0x8c4328f1,0x27f80087,0x6b810174}},	// [1e60] _nuen_, нете, _črno_, _ịgak,
   {{0xe7ef0251,0x63a11d67,0x68e9059f,0x69d90381}},	//   _चढ़ा_, niln, _aged, emwe,
   {{0x7c3617d2,0x6ac600e3,0x62810891,0x5eda0033}},	//   styr, أقام, nylo, _ব্রে,
   {{0xb4ea007d,0x27ed0081,0x290d002d,0x7e6101c5}},	//   _मले_, _buen_, _ceea_, ælpe,
   {{0xa3cb1115,0x7d041d60,0x63a128f2,0x9f410113}},	//   लता_, mbis, kiln, _sihé_,
   {{0x26c5000d,0x27ed02a7,0x69d928f3,0x68ff0092}},	//   _bylo_, _duen_, amwe, ıqda,
   {{0x63a128f4,0x68ed28f5,0x6b6304a1,0xaa430975}},	//   diln, žada, _якра, _перл,
   {{0xb608030b,0x7f8b0092,0x7d0428f6,0xe944010d}},	//   jišť, _müqa, nbis, _ترسی,
   {{0xdb050610,0x7d0428f7,0xbcfb0031,0x26081c05}},	//   cohó, ibis, _poéz, _सबकी_,
   {{0xfbbe1860,0x63a11a79,0x57fb00a1,0xb5fc009e}},	//   ्तिम, giln, _ללמו, _arġe,
   {{0x27ed03f3,0x20090a4b,0x00000000,0x00000000}},	//   _zuen_, _swai_, --, --,
   {{0xa3e717ff,0x7c2428f8,0x320200d4,0x63a101b9}},	//   _मूक_, krir, ďky_, ailn,
   {{0x63a128f9,0x533400c2,0x7d0428fa,0xfbbe28fb}},	//   biln, _желт, dbis, ्ताम,
   {{0x7c2428fc,0x7d0400bc,0x00000000,0x00000000}},	//   drir, ebis, --, --,
   {{0xdced1197,0x433b00a1,0x777a28fd,0xe3b3006e}},	//   sjač, _העוב, _motx, _אױס_,
   {{0x7c2428fe,0x7d041ba1,0xb60614f3,0x3eac00d8}},	//   frir, gbis, mošć, _šitý_,
   {{0x7c2428ff,0xb6061197,0x00000000,0x00000000}},	// [1e70] grir, lošć, --, --,
   {{0x3b5407bf,0x44240a1b,0x2fc700fe,0xeb9b01f9}},	//   нкур, irm_, _óng_, حضرت_,
   {{0xb6060039,0x7c242900,0xbefb0285,0x00000000}},	//   nošć, arir, ्रीन_, --,
   {{0xdb1c0076,0x442400d4,0xf1bf0231,0x00000000}},	//   _bhró, krm_, noá_, --,
   {{0x27ed2901,0xdb1722e7,0xdb1c2902,0x7c2400fd}},	//   _quen_, loxí, _chró, crir,
   {{0x777a0472,0x3dc92903,0xf7710037,0x7d1d080e}},	//   _cotx, llaw_, ضات_, _hdss,
   {{0x63a12904,0x44240090,0x7d0f0103,0x777a01ff}},	//   viln, erm_, _kecs, _dotx,
   {{0xb60600cb,0x63a10034,0x3dc90eaa,0x27ed007b}},	//   došć, wiln, nlaw_, _tuen_,
   {{0x63a12905,0x69c300fd,0x3dc90270,0x753b23ca}},	//   tiln, îneu, ilaw_, rfuz,
   {{0x645b2906,0x62812907,0x7d0f0103,0x00000000}},	//   rvui, tylo, _lecs, --,
   {{0x63a102dd,0x3ce60220,0xb6062908,0x3dc90bb6}},	//   riln, ľovi_, gošć, klaw_,
   {{0xa0a60307,0x7c24003e,0x777a01ff,0x3ce60206}},	//   дамд, yrir, _zotx, žovi_,
   {{0x63a12909,0x3dc902c9,0xbcfb0220,0x31b90094}},	//   piln, dlaw_, _inéh, nézy_,
   {{0x7c24290a,0xf8ab00fe,0x637f0231,0x7df500c6}},	//   vrir, _đời_, _cênt, _sąsa,
   {{0xafe30036,0x7d0f0103,0xdb170042,0x25ad0ac1}},	//   торл, _becs, goxí, onel_,
   {{0x25ad290b,0x7c24290c,0x25bf020a,0x637f0231}},	//   nnel_, trir, noul_, _vênu,
   {{0x7d04290d,0xdca3290e,0x629c1515,0xa01b00c2}},	// [1e80] rbis, вати, úrov, lyön,
   {{0x25bf022b,0x7c2402a7,0xdcef020a,0x637f0231}},	//   houl_, rrir, _pocă, _tênu,
   {{0xdb1c01f7,0x68ed0031,0x3dc900f0,0x00000000}},	//   _bhrò, ľadn, blaw_, --,
   {{0x7c24008f,0x3dc9290f,0xdb1c033f,0xda650037}},	//   prir, claw_, _phró, عالي,
   {{0xb8f60d0b,0xaca40174,0xdb1c01b9,0x25bf2910}},	//   _हर_, _maịs, _dhrò, doul_,
   {{0x4b5500e5,0x00000000,0x00000000,0x00000000}},	//   _пъст, --, --, --,
   {{0x2b580095,0x9f8d003e,0x00000000,0x00000000}},	//   _iarc_, nþá_, --, --,
   {{0xa5341940,0xbf0a0096,0xb6060995,0x2d920085}},	//   хнич, वरुन_, vošć, nhye_,
   {{0x29062911,0x777a2912,0x00000000,0x00000000}},	//   mboa_, _totx, --, --,
   {{0x2b582913,0xb6060995,0x42742914,0x00000000}},	//   _jarc_, tošć, егос, --,
   {{0xa2c1121d,0x3218025b,0x2b582915,0x25bf2916}},	//   _रुद्, éry_, _marc_, boul_,
   {{0xe4a60221,0xc486164d,0x68e400e7,0x5a17006e}},	//   _орло, _олек, židu, וקטן_,
   {{0xa3e705d4,0xc058224a,0xbf0a009d,0x10742917}},	//   _मंच_, мір_, वरून_, вляю,
   {{0x0efb2918,0x2b582919,0x47cc0081,0x3dc900f9}},	//   ्रेस_, _narc_, াদকী, wlaw_,
   {{0x3ceb291a,0x9e340036,0xf1bf0231,0x5e5800ae}},	//   _pgcv_, керч, poá_, миря_,
   {{0x3dc90124,0x7f570188,0x637f02ac,0xcdd80284}},	//   ulaw_, _waxq, _fêns, дњу_,
   {{0x3dc90373,0x7d020328,0x7d0f291b,0x2b580178}},	// [1e90] rlaw_, ñosa, _vecs, _barc_,
   {{0xdb1c01ec,0x00000000,0x00000000,0x00000000}},	//   _shrò, --, --, --,
   {{0xb50e009f,0x7d0f291c,0xdb1c01b5,0x2b5800fc}},	//   सराय_, _tecs, _phrò, _darc_,
   {{0x645c00d9,0x68ed0220,0x31b9291d,0x00000000}},	//   ārij, ľado, tézy_, --,
   {{0x68ed025b,0x2b58291e,0x201900c2,0x6cfa0327}},	//   žado, _farc_, nssi_, _מפרס,
   {{0x7c2d291f,0xb17b0ac9,0x00000000,0x00000000}},	//   muar, lmåd, --, --,
   {{0x7c2d2920,0x2bbe046e,0xbcfb0161,0x1995055b}},	//   luar, ्तरा, _anéi, _завя,
   {{0xc867008f,0x6d4d2921,0x25ad078e,0x00000000}},	//   _отзи, neaa, unel_, --,
   {{0x38342922,0x7c2d2923,0x25bf00ae,0x25ad2924}},	//   _интр, nuar, roul_, rnel_,
   {{0x25ad2925,0x25bf0052,0x69cb2926,0xe2990291}},	//   snel_, soul_, llge, зао_,
   {{0x25ad01b9,0x2d890167,0x7c2d2927,0x69cb0313}},	//   pnel_, kkae_, huar, olge,
   {{0x7c2d2928,0xa3cf0179,0x865a00d7,0xe56e0077}},	//   kuar, _वीर_, _מדעי, _ёз_,
   {{0x656b2929,0xbcfb00e3,0x7c2d292a,0x80c80081}},	//   _ingh, _gnéi, juar, রেন্,
   {{0x7c2d292b,0xdb1e023b,0x442d292c,0x69cb0364}},	//   duar, ropë, mue_, hlge,
   {{0x442d292d,0x20191fc2,0x68fb05fb,0x00000000}},	//   lue_, assi_, _ofud, --,
   {{0xbefb02d5,0x7c2d0076,0x68fb06b0,0x0efb0285}},	//   ्रॉन_, fuar, _nfud, ्रॉस_,
   {{0x2b58292e,0x7c2d292f,0x6aa80386,0x442d2930}},	// [1ea0] _parc_, guar, कप्र, nue_,
   {{0x291f2931,0x2d92023f,0xa3c10852,0x68fb0361}},	//   _adua_, shye_, ूति_, _afud,
   {{0x27ff1bde,0x3ea60fe3,0xa92622be,0x6376020a}},	//   _atun_, _чинг, едел, _pânz,
   {{0x442d2932,0xb17b0149,0x7c2d2933,0x2b5802ac}},	//   kue_, rmåg, buar, _warc_,
   {{0xc7c62321,0x7d160694,0x6376002d,0x6e2e017a}},	//   нски, mays, _vânz, lubb,
   {{0x7d162934,0x656b2935,0xfaa60f00,0x442d2936}},	//   lays, _angh, _заго, due_,
   {{0xbbbe0966,0x442d020d,0x6e2e2937,0x5bbe2674}},	//   ्तीक, eue_, nubb, ्तीव,
   {{0x7d162938,0x09e317e9,0x442d2939,0x2c520154}},	//   nays, _босн, fue_, _kņd_,
   {{0x442d22d3,0x98af00c6,0x6e2e225b,0xdb1e00ee}},	//   gue_, degė_, hubb, topè,
   {{0x656b0150,0x7d16008a,0x96960a29,0x21200154}},	//   _engh, hays, _преш, _adih_,
   {{0x7d16293a,0x7c2d293b,0xd5af0e05,0xbcfb020d}},	//   kays, zuar, _бс_, _inév,
   {{0xdce605aa,0x0efb0179,0xbbbe00b6,0x00000000}},	//   _ankč, ्र्स_, ्तुक, --,
   {{0x7d16008a,0x7c2d293c,0x5fd2007a,0xa2cc023a}},	//   days, xuar, _दीहल, _हरक्,
   {{0x201901a5,0x7c2d0216,0x00000000,0x00000000}},	//   rssi_, vuar, --, --,
   {{0x656b02ad,0x6f151427,0x6e2e293d,0x5d67293e}},	//   _yngh, razc, gubb, нтаз,
   {{0x7d16008a,0x7c22003d,0x7c2d293f,0x40950037}},	//   gays, ġorn, tuar, _للبر,
   {{0xb81c1ae6,0x6d4d2940,0x00000000,0x00000000}},	// [1eb0] _निगम_, reaa, --, --,
   {{0x7c2d2011,0x6e2e2941,0xb17b02b6,0x3df5247a}},	//   ruar, bubb, småd, _изос,
   {{0x7d16008a,0x442d0a00,0x6d4d2942,0xf7780090}},	//   bays, zue_, peaa, _jiħu_,
   {{0xa91d0087,0x3c4301d3,0x7d160188,0x27ff0167}},	//   _možg, tīvā_, cays, _ptun_,
   {{0x7c2d2943,0xe10c00c1,0x89340037,0x8d8400ae}},	//   quar, פּאָ, اعما, _суэд,
   {{0x442d2944,0xa3cf0034,0x394400f9,0x386400c4}},	//   vue_, _वीं_, _ebms_, _drmr_,
   {{0xead400c2,0x442d0174,0xe8df0065,0x00000000}},	//   _борь, wue_, _ibọn_, --,
   {{0x27ff01ff,0xa01b007b,0x00000000,0x00000000}},	//   _ttun_, työl, --, --,
   {{0xe43200e3,0x00000000,0x00000000,0x00000000}},	//   لفيد, --, --, --,
   {{0x442d2945,0x394f2946,0xdb1e2947,0x260e0096}},	//   rue_, legs_, topé, णीही_,
   {{0x200000d3,0x442d00a1,0x27f8033b,0xfbd200ca}},	//   _stii_, sue_, _črni_, שתי_,
   {{0xdb1e025a,0x656b2948,0x7d16008a,0x0f0a0176}},	//   ropé, _ungh, xays, वर्स_,
   {{0x442d2949,0x8edf00c7,0x45d400c2,0x212005db}},	//   que_, _ব্লগ, _соцс, _vdih_,
   {{0x7d16026d,0xdb1c023c,0x03a5294a,0x00000000}},	//   ways, _okrá, _шило, --,
   {{0x6da6075f,0x7d16008c,0x7d020328,0x22470062}},	//   вива, tays, ñoso, _upnk_,
   {{0x6e2e294b,0x12e800c1,0xdd920867,0x320500ca}},	//   rubb, _אַפּ, جور_, mply_,
   {{0xa91d02e6,0x7d160694,0x2bf624d3,0x67211912}},	// [1ec0] _možd, rays, тябр, _odlj,
   {{0x6e2e294c,0x7d16294d,0xaf0a0037,0xb17b0537}},	//   pubb, says, _تقدم_, rmåe,
   {{0xa3c2294e,0x7d16020d,0x00000000,0x00000000}},	//   ंवत_, pays, --, --,
   {{0x7d160188,0x637e02c6,0x00000000,0x00000000}},	//   qays, _záně, --, --,
   {{0x6d460139,0xe9470103,0x25780206,0x00000000}},	//   _ibka, ئرمی, _gély_, --,
   {{0xe8df0065,0x8b0501c2,0xa09b2252,0xe81309a1}},	//   _gbọn_, ƙƙau, וינט, _डबरा_,
   {{0x6ae000c7,0x98b2026a,0xfaa60e05,0x00000000}},	//   _প্রো, ıyı_, _раво, --,
   {{0x80d300a4,0x00000000,0x00000000,0x00000000}},	//   _ठरले, --, --, --,
   {{0xdb1c00b6,0x00000000,0x00000000,0x00000000}},	//   _zkrá, --, --, --,
   {{0xf3660a3a,0xa91d0141,0x27f903a9,0x00000000}},	//   ттин, _požg, _ésna_, --,
   {{0x7980294f,0x00000000,0x00000000,0x00000000}},	//   _komw, --, --, --,
   {{0x316d2950,0xfbdf00f0,0x00000000,0x00000000}},	//   ñez_, _apêl_, --, --,
   {{0x75220294,0x60d6007f,0x94760076,0x00000000}},	//   _idoz, _czym, _جداا, --,
   {{0x547b00a1,0x9e352951,0x6d462952,0x79800172}},	//   _קטגו, легч, _abka, _lomw,
   {{0x2bec02d5,0xdb0602c6,0x236e0350,0x63a82953}},	//   _अंजू_, ámýc, _infj_, midn,
   {{0xa91d025b,0x7bc70d3e,0x7e65211b,0x62882954}},	//   _kože, _skju, _vrhp, mydo,
   {{0xdb1c2955,0x62880138,0xa91d2956,0xebd91510}},	// [1ed0] _skrá, lydo, _jože, едаш_,
   {{0xa91d02e6,0x4ea72957,0x8f5502ec,0x63a800e7}},	//   _može, _арма, _свої, nidn,
   {{0x75222958,0x61ed2959,0xa91d015c,0x798002ac}},	//   _odoz, _kial, _lože, _bomw,
   {{0x60cd295a,0x75220294,0xafdb02b6,0xaa64013f}},	//   _kyam, _ndoz, stød, штук,
   {{0xa3c20454,0xa91d042d,0x6d5d0a6c,0xc19c00ca}},	//   ंवा_, _nože, _iasa, ושאי,
   {{0x7522295b,0x60cd295c,0x61ed03d3,0x00000000}},	//   _adoz, _myam, _lial, --,
   {{0x6d5d295d,0xe5a5290e,0x798001c2,0x27ec00a1}},	//   _kasa, лики, _fomw, _didn_,
   {{0x61ed295e,0x7bc50af0,0xe4591d7b,0x60cd06b0}},	//   _nial, lohu, ежи_, _oyam,
   {{0x6d5d295f,0x60cd2960,0xa91d0307,0x69db0294}},	//   _masa, _nyam, _vožd, _ihue,
   {{0x6d5d2961,0x2bd902b0,0x490b000d,0x75222962}},	//   _lasa, _बीमा, ारको_, _edoz,
   {{0x61ed2963,0x60cd2964,0x69c90172,0x60d62965}},	//   _bial, _ayam, _kkee, _szym,
   {{0x6d5d2966,0x60cd21e9,0x00000000,0x00000000}},	//   _nasa, _byam, --, --,
   {{0x61ed1206,0x44292967,0x343900c1,0x7bc50f18}},	//   _dial, _ía_, _נײַע, kohu,
   {{0x9474006f,0x443f2968,0x63a80580,0x6d5d2969}},	//   _خدما, mtu_, cidn, _aasa,
   {{0x6d5d296a,0xa2ca0e72,0x61ed296b,0x69c916ae}},	//   _basa, _सुप्, _fial, _okee,
   {{0x5bbe0c3c,0x61ed296c,0x69c9006c,0xed5711b6}},	//   ्त्व, _gial, _nkee, лос_,
   {{0x443f296d,0x6d5d26f7,0xbcfb00b3,0x60cd083e}},	// [1ee0] ntu_, _dasa, _anés, _gyam,
   {{0x443f296e,0xa09b006e,0x69c9296f,0x69db024a}},	//   itu_, _נייט, _akee, _ahue,
   {{0x6d5d2970,0x443f2971,0x6da62972,0x69db0037}},	//   _fasa, htu_, _бина, _bhue,
   {{0x6d5d2973,0x644b02b6,0x8d56203c,0x7d56004d}},	//   _gasa, _opgi, _сточ, _стої,
   {{0x443f2974,0xa2ca0354,0x8eb3001c,0x69db0113}},	//   jtu_, _सुन्, _نمیش, _dhue,
   {{0x6d5d12c5,0xdb1c052f,0x7c2b01ab,0xfbb8203b}},	//   _zasa, _skræ, ágre, _आदिम,
   {{0x6d5d2975,0xb8eb000c,0xbb3b00c1,0x56942976}},	//   _yasa, _रु_, _רעלי, райт,
   {{0xa91d00cb,0x6d5d0694,0x7df50138,0x69c901ff}},	//   _pože, _xasa, _sąsk, _gkee,
   {{0x61ed054f,0x20e3034d,0x63a80149,0x7bdc2977}},	//   _rial, _गणेश_, tidn, _khru,
   {{0x2d822978,0x61ed2979,0xa91d05db,0xf206297a}},	//   _loke_, _sial, _vože, лямо,
   {{0x61ed1084,0x60cd048e,0x443f297b,0xf3631ad1}},	//   _pial, _syam, atu_, стын,
   {{0x6288297c,0xa91d0087,0x7bc50051,0xe80b030b}},	//   rydo, _tože, zohu, सीका_,
   {{0x629a297d,0x61ed297e,0x143900cd,0x7bc50051}},	//   szto, _vial, _لينک_, yohu,
   {{0x6d5d27e5,0x60cd0010,0x98a9007f,0xd3700037}},	//   _sasa, _vyam, żać_, _ذهب_,
   {{0x6d5d297f,0xcddb0cb8,0x6d442980,0x2d822981}},	//   _pasa, ења_, ffia, _boke_,
   {{0x6d5d2982,0x2d582983,0x5d55001f,0x645900f0}},	//   _qasa, лись_, јкат, _yswi,
   {{0x5b152984,0x6d5d2985,0x7bc52986,0x7bdc0091}},	// [1ef0] имат, _vasa, tohu, _bhru,
   {{0x6d5d2987,0x7bdc0a21,0x69c92988,0x9d150081}},	//   _wasa, _chru, _skee, িলেন_,
   {{0x6d5d2989,0x443f02a7,0x2cae0092,0x7bdc03ea}},	//   _tasa, ztu_, _əldə_, _dhru,
   {{0x6d5d0a02,0xbcfb298a,0x25fb0034,0x6440298b}},	//   _uasa, _enér, _लंबी_, ktmi,
   {{0xe739298c,0x443f298d,0xb8fd14e5,0x99870103}},	//   вел_, xtu_, _डर_, énő_,
   {{0x8ae7116d,0x7bdc0a02,0x321e0034,0x66050161}},	//   _бібл, _ghru, ksty_, апка,
   {{0x69db298e,0x01d60033,0x61fc0072,0x98a700c4}},	//   _thue, _সংসদ, írll, điđi_,
   {{0x443f298f,0x1425022f,0x7c2d296c,0x7bdc033d}},	//   ttu_, адим, orar, _zhru,
   {{0x443f2990,0x998400e3,0x7c2d026e,0xa91d0087}},	//   utu_, _القو, nrar, _tožb,
   {{0x395f2991,0x443f2992,0x25a62993,0x7d0d0113}},	//   _haus_, rtu_, _emol_, hbas,
   {{0x395f2994,0x65952995,0xe10a1510,0xd5751c32}},	//   _kaus_, _кажу, кенд_, _вуль,
   {{0x9f490088,0x7c2d2996,0x2935006e,0xc0e61720}},	//   _stað_, krar, סאָן_, ионк,
   {{0x2d820087,0x395f2997,0x64590239,0x3f9800eb}},	//   _roke_, _maus_, _uswi, thru_,
   {{0x395f0197,0x442d20a8,0x2d822998,0x765a02ad}},	//   _laus_, mre_, _soke_, _ysty,
   {{0xeab00f71,0xdee61a18,0xa3c22999,0x7c2d01e9}},	//   _কর্ম, рови, ंवर_, erar,
   {{0x7d0d299a,0x442d299b,0x7bdc299c,0x395f299d}},	//   gbas, ore_, _shru, _naus_,
   {{0x7c2d299e,0x6db70106,0x6d44299f,0x7bdc01b9}},	// [1f00] grar, pćan, rfia, _phru,
   {{0x442d29a0,0x2d8229a1,0x316029a2,0x8b26004d}},	//   ire_, _woke_, _haiz_, рдже,
   {{0x6f1c2243,0x442d29a3,0x7c2d29a4,0x7d0d29a5}},	//   marc, hre_, arar, bbas,
   {{0xd9462240,0x442d29a6,0x6f1c29a7,0x395f29a8}},	//   реди, kre_, larc, _caus_,
   {{0x395f022e,0x7c2d002d,0x442d29a9,0x31601a86}},	//   _daus_, crar, jre_, _maiz_,
   {{0x442d0b81,0x0eba009f,0x7df529aa,0xa50e0521}},	//   dre_, _उखाड, _sąsi, सर्च_,
   {{0xd5ba29ab,0x395f022e,0x70d3030b,0xe8fa002d}},	//   кси_, _faus_, _सर्ल, _алб_,
   {{0x442d29ac,0x6f1c29ad,0x31600a00,0x395f29ae}},	//   fre_, harc, _naiz_, _gaus_,
   {{0x57ea29af,0x442d0b6a,0x6fc60096,0x765a007f}},	//   _адам_, gre_, लकां, _wsty,
   {{0x46a6013d,0x07a31d68,0x883b00a1,0x395f0197}},	//   _казв, _даун, _בתמו, _zaus_,
   {{0x442d29b0,0x644029b1,0x6f1c29b2,0x395f006c}},	//   are_, stmi, darc, _yaus_,
   {{0x442d29b3,0x04460fa5,0x395f006c,0xa91d015c}},	//   bre_, _ведн, _xaus_, _koža,
   {{0x6f1c1064,0x2fc70023,0xdcef01d3,0x9f84003e}},	//   farc, _ưng_, ādīt, töð_,
   {{0x6f1c29b4,0x7c2d0012,0x533300ae,0xa91d0117}},	//   garc, vrar, _дешт, _moža,
   {{0x316029b5,0x3da729b6,0xbe8829b7,0xa3110031}},	//   _faiz_, араб, асте_, äčšo,
   {{0x527b040a,0xdd9814e8,0x40c80134,0x00000000}},	//   _ינוא, ашу_, ọrị_, --,
   {{0x7d0d29b8,0x7c2d29b9,0xdce6013f,0x395f29ba}},	// [1f10] rbas, urar, _mokė, _raus_,
   {{0x7c2d29bb,0x6f1c29bc,0x395f29bd,0xd9bf0557}},	//   rrar, carc, _saus_, एक्ट,
   {{0x395f29be,0x2bbe0378,0x442d0103,0x7d0d0381}},	//   _paus_, ्तजा, zre_, pbas,
   {{0x442d29bf,0x395f023e,0x7c2d29c0,0x75e70103}},	//   yre_, _qaus_, prar, _tűzi,
   {{0x395f023e,0x4dda00ca,0x9f400428,0xdb1c01df}},	//   _vaus_, _תחרו, _guió_, _skrå,
   {{0x442d29c1,0x06b20081,0x395f01c2,0xd874001c}},	//   vre_, য়েছি, _waus_, تامب,
   {{0xa6c929c2,0x395f006c,0xaa950037,0xcae50033}},	//   ылка_, _taus_, _الأث, _প্রফ,
   {{0x6f1c29c3,0xa2c10096,0xa2ca0403,0xa3cf0096}},	//   zarc, _रुग्, _सुध्, _वीज_,
   {{0x442d29c4,0x7f8b01d4,0x291d29c5,0x6f1c0044}},	//   ure_, _hüqu, mawa_, yarc,
   {{0x442d0519,0x291d29c6,0x316008d3,0x61f80542}},	//   rre_, lawa_, _saiz_, _buvl,
   {{0xa2ca009d,0x442d0018,0x6f1c29c7,0xe6b30260}},	//   _सुद्, sre_, varc, _بلاگ,
   {{0x442d1f17,0x291d29c8,0xd00a29c9,0x68ed025b}},	//   pre_, nawa_, леме_, žadu,
   {{0x6f1c29ca,0x31601820,0x76430085,0x7dfc0383}},	//   tarc, _vaiz_, ltny, _pčso,
   {{0x291d29cb,0x76430167,0xafe61e11,0xdb1e1f20}},	//   hawa_, otny, согл, kopá,
   {{0x291d29cc,0x2d9620da,0x38660094,0x29dc00b3}},	//   kawa_, брас, zvor_, níac_,
   {{0x6da3187c,0x6f1c29cd,0x2b4a0167,0x291d29ce}},	//   писа, sarc, _sbbc_, jawa_,
   {{0x291d29cf,0xcaf600e3,0x249f0268,0x6f1c29d0}},	// [1f20] dawa_, مساب, nzum_, parc,
   {{0xa91d29d1,0xa3dd0789,0x61e60973,0x764329d2}},	//   _roža, _थीम_, lmkl, ktny,
   {{0x25ad29d3,0xdb070018,0x291d006d,0xb17b13c8}},	//   kiel_, ámár, fawa_, kmål,
   {{0x291d29d4,0xa91d0d95,0x38661419,0x38cb010d}},	//   gawa_, _poža, tvor_, گامی_,
   {{0x53c70693,0x25ad0181,0x6d5629d5,0x394629d6}},	//   रकाश, diel_, meya, rfos_,
   {{0x38cb00cd,0x6d5629d7,0x9b960037,0x386629d8}},	//   دامی_, leya, _الست, rvor_,
   {{0x25ad0272,0x291d29d9,0x77610188,0xdb1c0031}},	//   fiel_, bawa_, _dalx, _okrú,
   {{0x2d8029da,0xd94329db,0x25ad29dc,0x6d561dbd}},	//   njie_, _неси, giel_, neya,
   {{0x764329dd,0x61f80f39,0xf8dc00aa,0x09e30036}},	//   atny, _suvl, _बरिय, _хотн,
   {{0x5c5b00c1,0x388e00d9,0x00000000,0x00000000}},	//   נדיק, _vērā_, --, --,
   {{0xa91d0ec8,0x25ad122f,0x6d560113,0xcb1303c2}},	//   _možn, biel_, keya, הלת_,
   {{0x25ad29de,0xa91d00b6,0x7df50138,0xf09f015e}},	//   ciel_, _ložn, _mąst, tzà_,
   {{0x2d800185,0x6d5629df,0x7df50138,0x23e6097a}},	//   djie_, deya, _ląst, _лікв,
   {{0x291d29e0,0xdbf1030b,0xa91d1c56,0x92940832}},	//   zawa_, _příl, _nožn, _малц,
   {{0x291d001b,0xfdc4009f,0x00000000,0x00000000}},	//   yawa_, वकूफ, --, --,
   {{0x6d5629e1,0x2d800216,0x00000000,0x00000000}},	//   geya, gjie_, --, --,
   {{0x212902fa,0x4dd40037,0x00000000,0x00000000}},	// [1f30] _idah_, ستفس, --, --,
   {{0xdea403ed,0x291d29e2,0x25ad29e3,0xe3b829e4}},	//   _کیفی, wawa_, ziel_, nnı_,
   {{0x291d29e5,0x6d5629e6,0x9f8400aa,0x2d85020d}},	//   tawa_, beya, töö_, êles_,
   {{0x6ab909c3,0x291d0051,0x8f55001c,0xe3b800a7}},	//   _आशीर, uawa_, _انگش, hnı_,
   {{0x291d29e7,0xf770037f,0x25ad29e8,0x2d9901d0}},	//   rawa_, کان_, viel_, _ilse_,
   {{0x291d29e9,0x25ad0371,0x776100a7,0xdb15022b}},	//   sawa_, wiel_, _qalx, _ekzò,
   {{0x291d0a4b,0x25ad29ea,0x66e2004b,0x19950138}},	//   pawa_, tiel_, моша, _давя,
   {{0x20090332,0x764329eb,0x7d1f0216,0x29dc00ee}},	//   _otai_, rtny, naqs, ríac_,
   {{0x25ad29ec,0x92e60081,0xb17b0073,0x764329ed}},	//   riel_, যুৎ_, rmål, stny,
   {{0x422529ee,0x2129005c,0xb17b0c96,0x25ad29ef}},	//   одов, _adah_, smål, siel_,
   {{0x80d100c7,0x25ad29f0,0x09b500c1,0x6d5629f1}},	//   সেম্, piel_, ַפֿט_, yeya,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x6d5629f2,0x10a300ae,0x61e629f3,0xb5c800d1}},	//   veya, диян, rmkl, _اونم_,
   {{0x69cb29f4,0x212900dc,0xaab90252,0xe3b30b9f}},	//   hoge, _edah_, _आशंक, _عرش_,
   {{0x59c906e4,0x2d800665,0xa91d29f5,0x6d5629f6}},	//   िकार, tjie_, _rožn, teya,
   {{0x753b29f7,0xa01b007b,0x69cb083e,0x00000000}},	//   nguz, työt, joge, --,
   {{0x6d5629f8,0x3b86249b,0xae1a009f,0x8c4311f8}},	// [1f40] reya, олаг, _फौरन_, мете,
   {{0xa91d29f9,0x394d0063,0x6d5629fa,0x2d9900ca}},	//   _božo, _abes_, seya, _else_,
   {{0xe8fa12e9,0x69cb29fb,0x2904039f,0x00000000}},	//   але_, foge, _pfma_, --,
   {{0x69cb29fc,0x7d1f00a7,0xfd120076,0xe3b811bc}},	//   goge, caqs, _تجد_, znı_,
   {{0xa91d0087,0x386d0558,0xbcfb01dc,0x97c61ad2}},	//   _tožn, _crer_, _kaén, ойде,
   {{0x7c24152f,0x7d0429fd,0xf0930796,0x81c20033}},	//   msir, lcis, ונד_, ্গি_,
   {{0x41ca277c,0x69cb29fe,0xbf9b00fd,0x7c2429ff}},	//   रवास, boge, mpêt, lsir,
   {{0x69cb2a00,0x7d042a01,0x386d0154,0xa2ca08c0}},	//   coge, ncis, _frer_, _सुष्,
   {{0x7c242a02,0xdb1e052f,0xc31e0081,0xb8660281}},	//   nsir, ropæ, _দাবি_, _بازو,
   {{0x779200bf,0x7c242a03,0x926a2a04,0x212909a4}},	//   _زیبا, isir, арма_, _sdah_,
   {{0x20092a05,0xe3b81577,0x7dfc022b,0x8afb0a41}},	//   _stai_, rnı_, _dčsk, יליז,
   {{0x7c24181b,0x96330f1e,0xa194224a,0x00000000}},	//   ksir, _ініц, даюч, --,
   {{0xa2ca000c,0x78a20146,0x7c24042d,0x48b80081}},	//   _सुर्, nzov, jsir, _জরুর,
   {{0x442600cb,0x69cb02e2,0xc05800d6,0x09b72a06}},	//   _ivo_, zoge, цію_, _अद्य,
   {{0x69cb0283,0x44262a07,0xddab00d3,0x8d770037}},	//   yoge, _hvo_, атал_, يارا,
   {{0x212902e8,0x7c242a08,0x2bbf2a09,0x75200a4b}},	//   _udah_, fsir, ्वभा, namz,
   {{0x69cb2a0a,0x78a20b14,0x7c242a0b,0x442603a9}},	// [1f50] voge, jzov, gsir, _jvo_,
   {{0x09b30454,0x69cb0517,0x63ba01bf,0x78a20220}},	//   ंच्य, woge, nntn, dzov,
   {{0x69cb2a0c,0x7c240361,0x00000000,0x00000000}},	//   toge, asir, --, --,
   {{0x442603ce,0x7d041c9a,0x44240063,0xceb20142}},	//   _ovo_, ccis, ksm_, _טיי_,
   {{0x1869021c,0x7d1d03a8,0x6c79006e,0x48e6023a}},	//   сали_, _iess, _האָפ, जेलो_,
   {{0x7d1d2a0d,0x69cb2a0e,0xbdf81ac9,0x80c80033}},	//   _hess, soge, _دریا_, রেক্,
   {{0xa2ca1bc3,0x44262a0f,0x98bf00c4,0x29dc2a10}},	//   _सुल्, _avo_, _obuć_, mían_,
   {{0xc485064f,0xf1c00094,0x386d00f3,0xdb1c00f2}},	//   злик, čák_, _trer_, _skrø,
   {{0x7d1d0e04,0xe3b1003f,0x937900e3,0x753b0d2a}},	//   _mess, فرد_, مصدر_, rguz,
   {{0xf8ae00d0,0x798901a2,0x29dc0890,0x7d1d089a}},	//   _حکم_, _hoew, nían_, _less,
   {{0x442602e6,0x799b2a11,0x9ad30134,0x216a090f}},	//   _evo_, _kluw, _dịgo, бини_,
   {{0x7d1d1880,0xe610001c,0xbcfb00cd,0xafdb0120}},	//   _ness, _ششم_, _saén, støl,
   {{0xb4fa00a1,0x764b013f,0x92b50470,0x7989084e}},	//   _הפני, žnyč, تحکا, _moew,
   {{0x6dac026a,0x22450124,0x9f58013c,0x799b03a8}},	//   rşam, ptlk_, _özün_, _lluw,
   {{0x7d1d02e2,0x29dc04d8,0x2d96287c,0x78a20f1c}},	//   _bess, dían_, прас, zzov,
   {{0x7c242a12,0x7d1d2a13,0xb88300b6,0x91e31bc1}},	//   tsir, _cess, _klíč, _поще,
   {{0x7d1d2a14,0x7d042a15,0xe3190023,0x61e40372}},	// [1f60] _dess, rcis, _điể, _ihil,
   {{0xa01b0084,0x799b0361,0x29dc00e1,0x7d040d63}},	//   pyör, _aluw, gían_, scis,
   {{0x4efb0054,0x7c242a16,0x61e42a17,0xc33200a1}},	//   _להיו, ssir, _khil, תוב_,
   {{0xd7fa0562,0x7d1d2a18,0x799b0113,0xdb052a19}},	//   бук_, _gess, _cluw, rihá,
   {{0x29dc0fb6,0x61e40a02,0x799b01dc,0x79890113}},	//   bían_, _mhil, _dluw, _doew,
   {{0xc7a307c8,0x29dc04d8,0x78a22316,0x60d600c2}},	//   ничк, cían_, rzov, _myym,
   {{0x44260682,0x7d1d2a1a,0xdb1e01bf,0x9f480d79}},	//   _svo_, _yess, ropä, óhùn_,
   {{0x2abb00a1,0x44260f13,0x79890313,0x00000000}},	//   _המלא, _pvo_, _goew, --,
   {{0x3a3a03e5,0x212203a9,0x75202a1b,0x00000000}},	//   lupp_, dakh_, ramz, --,
   {{0xe44f0080,0x6f1e0995,0x00000000,0x00000000}},	//   اضي_, _nepc, --, --,
   {{0x61e40a02,0xaabe00a8,0x7dda0b8e,0x2bbf18ff}},	//   _bhil, ्थिक, eïsm, ्वता,
   {{0x61e42a1c,0x4426003e,0x867b00ca,0xc10800ae}},	//   _chil, _tvo_, _לרבו, зэре_,
   {{0x7d1d2a1d,0xa91d2a1e,0x44262a1f,0x61e42a20}},	//   _ress, _božj, _uvo_, _dhil,
   {{0x7d1d2a21,0xa91d2a22,0x6447020a,0x61e40415}},	//   _sess, _rožm, ăjit, _ehil,
   {{0x7d1d00c9,0xd3e512eb,0x29dc0610,0x61e4009b}},	//   _pess, _تقوی, vían_, _fhil,
   {{0x61e42a23,0xbcfb0042,0x5d6400e5,0x00000000}},	//   _ghil, _gaél, нтуз, --,
   {{0x6ecd2a24,0x6c5407c6,0x29dc0610,0xa3d00d77}},	// [1f70] _दुरु, нкту, tían_, वकप_,
   {{0x7d1d084e,0x69c00234,0x7e6102b6,0xa2a00096}},	//   _wess, _ajme, ælps, खनप्,
   {{0x7d1d2a25,0x29dc11ce,0xbb8400e3,0xecf90f1e}},	//   _tess, rían_, علمي, _менш_,
   {{0x6f1e2a26,0x00000000,0x00000000,0x00000000}},	//   _zepc, --, --, --,
   {{0xa3cc2a27,0x6d4d0167,0xa3c10096,0x00000000}},	//   लवा_, mfaa, ्कम_, --,
   {{0x2d8b04eb,0x6d4d2a28,0x79890113,0x00000000}},	//   _hoce_, lfaa, _woew, --,
   {{0xb8f42a29,0x6b830088,0x79892a2a,0x29dc0072}},	//   _सु_, öngu, _toew, cíao_,
   {{0x6d4d2a2b,0x799b005c,0x2d8b2a2c,0x2409007b}},	//   nfaa, _uluw, _joce_, онии_,
   {{0xafdb0537,0xd4692914,0x00000000,0x00000000}},	//   rtøj, ципе_, --, --,
   {{0x61e42a2d,0x69d901bf,0x2d8b002b,0x6d4d0188}},	//   _shil, llwe, _loce_, hfaa,
   {{0x61e42a2e,0x95cb0e06,0x00000000,0x00000000}},	//   _phil, _луда_, --, --,
   {{0x67232a2f,0x2d8b2a30,0x6f1e044c,0x00000000}},	//   lanj, _noce_, _sepc, --,
   {{0x81c20081,0x27ff2a31,0x291f015e,0x6f1e05db}},	//   ্গল_, _juun_, _meua_, _pepc,
   {{0x82351e49,0x67232a32,0xe2992a33,0x61e40054}},	//   _قربا, nanj, _мал_, _whil,
   {{0x61e42a34,0x6d4d2a35,0x2d8b0106,0x68fb06b0}},	//   _thil, ffaa, _boce_, _ogud,
   {{0x67232a36,0x291f01fa,0x65690e32,0x68fb2a37}},	//   hanj, _neua_, ndeh, _ngud,
   {{0x64492a38,0x67232a39,0x2d8b2a3a,0xbfc62a3b}},	// [1f80] ntei, kanj, _doce_, _обик,
   {{0xd9b80386,0x69d9281c,0x00000000,0x00000000}},	//   ेक्ट, elwe, --, --,
   {{0x236702dd,0x64492a3c,0x6d4d023e,0x2d8b2a3d}},	//   _manj_, htei, bfaa, _foce_,
   {{0x2d8b2a3e,0x64492a3f,0x3a3a2a40,0x20000113}},	//   _goce_, ktei, rupp_, _kuii_,
   {{0x26030eb8,0xdcb902fd,0xc7c629db,0xdb0e0088}},	//   _año_, _ещё_, мски, þjón,
   {{0x31bb1c0a,0x65690cad,0x29062a41,0xdce40146}},	//   _उद्ध, edeh, scoa_, ndič,
   {{0xc34e00de,0x6e3c037a,0x45d4139c,0x291f01dc}},	//   _bổng_, nurb, нокс, _feua_,
   {{0xc34e0019,0x64492a42,0x68fb010a,0xafdb0565}},	//   _cổng_, ftei, _ggud, ttøk,
   {{0x29e80092,0x3944016d,0x6e3c0112,0x27e5009c}},	//   _uşaq_, _icms_, hurb, _fhln_,
   {{0x672302e6,0x9696013d,0x6e3c003e,0x68fb00ae}},	//   canj, _ореш, kurb, _zgud,
   {{0xa2940c10,0x777a0634,0x00000000,0x00000000}},	//   хані, _intx, --, --,
   {{0x2000010a,0x14af0096,0x64490364,0x6e3c2a43}},	//   _buii_, _जेवण, btei, durb,
   {{0x14e21e9f,0x2d8b030b,0xdb1c2a44,0x3e480364}},	//   _परिण, _roce_, _skrý, eßt_,
   {{0x61ee0181,0x2000009c,0x00000000,0x00000000}},	//   _ďale, _duii_, --, --,
   {{0x2bbf2a45,0x2d8b0a39,0xdb0e00ee,0x6e3c01cd}},	//   ्वसा, _poce_, _imbè, gurb,
   {{0x236706c6,0xa2ad000d,0x7d160313,0x00000000}},	//   _zanj_, ुपर्, gbys, --,
   {{0x2d8b11f4,0xf1bf025b,0x67232a46,0x6d4d0188}},	// [1f90] _voce_, mná_, yanj, rfaa,
   {{0xf1bf0618,0xa3e4074c,0x291f05fe,0x6d4d2a47}},	//   lná_, _भीम_, _seua_, sfaa,
   {{0x6e3c2502,0x2d8b0036,0xdb1c0094,0x23a00154}},	//   curb, _toce_, _ukrý, _gòje_,
   {{0xf1bf2a48,0x67232a49,0xa91d0ebd,0x777a01e9}},	//   nná_, wanj, _koži, _antx,
   {{0x672303ce,0x644910f4,0xd05401c2,0xdb0e00d1}},	//   tanj, xtei, ɓaɓa, _ombè,
   {{0xf77100e3,0xa3dd00a5,0x66e50077,0x23dd03b3}},	//   طات_, _थीं_, нола, _नींद,
   {{0x67232a4a,0x92c20081,0xe91900d6,0xa91d2a4b}},	//   ranj, ্ধু_, _нові_, _loži,
   {{0x64492a4c,0xf1bf0579,0xdb0e0113,0x2367033b}},	//   ttei, jná_, _ambè, _sanj_,
   {{0xf1bf0897,0xa91d038d,0x65692a4d,0x23672a4e}},	//   dná_, _noži, rdeh, _panj_,
   {{0x64492a4f,0x4374004d,0x2fd100c4,0x9cd800ca}},	//   rtei, вуют, jozg_, ווחה_,
   {{0xc34e0028,0xfbd200a1,0x61460a51,0xb34520df}},	//   _tổng_, רתי_, нена, _acçã,
   {{0x5694245c,0x64492a50,0x67212a51,0x2000020a}},	//   _шахт, ptei, _helj, _puii_,
   {{0x25bf002d,0x7f5c2a52,0x66012a53,0x02cf04f1}},	//   mnul_, terq, _hulk, _सुरभ,
   {{0x66012a54,0xe8df0129,0x81bd01d3,0xa2ca2a55}},	//   _kulk, _arịa_, nsēj, _सुक्,
   {{0x660102fd,0xf1bf025b,0xe2990426,0x25bf00ae}},	//   _julk, bná_, _хай_, onul_,
   {{0x66011114,0xf1bf0146,0xdd921d28,0xdb0e2a56}},	//   _mulk, cná_, دور_, _imbé,
   {{0xdca32135,0x7d162a57,0x45da006e,0x395d02ac}},	// [1fa0] гати, rbys, פֿלא, dews_,
   {{0xa3c1000f,0x6721198c,0xf40100c7,0x7d1602ad}},	//   ्कि_, _nelj, _এবার_, sbys,
   {{0x1b1f0081,0xdb1c0034,0xa91d0141,0x00000000}},	//   _পাশে_, _skró, _zoži, --,
   {{0x6da6004d,0x00000000,0x00000000,0x00000000}},	//   _чима, --, --, --,
   {{0x1b1f00c7,0x67211d67,0x66010634,0x69c3020d}},	//   _পারে_, _belj, _aulk, énea,
   {{0x672102dd,0xf1bf0579,0xd7ef0037,0x764a0212}},	//   _celj, zná_, مكن_, ttfy,
   {{0x67212a58,0x6601022b,0x6db700e7,0x1ae32a59}},	//   _delj, _culk, mćar, _борм,
   {{0xa2ca088d,0x66010138,0xf1bf0031,0x25bf020a}},	//   _सुग्, _dulk, xná_, gnul_,
   {{0x6d4602e5,0xf1bf135f,0xb7da1915,0xe73a2a5a}},	//   _mcka, vná_, _فورا_, _неа_,
   {{0xc45300e3,0xa91d2a5b,0x25bf2a5c,0x6b8e0090}},	//   اضيع, _roži, anul_, _jobg,
   {{0xf1bf0074,0x363612eb,0x668105d1,0xa91d0141}},	//   tná_, _سراس, _نیول, _soži,
   {{0x672100cc,0xa91d2a5d,0xf484001c,0x6b8e0090}},	//   _zelj, _poži, _لاتی, _lobg,
   {{0x55770130,0xf1bf0074,0x66012a5e,0x3325010a}},	//   _רעדן_, rná_, _zulk, balx_,
   {{0xe47b0105,0xf1bf025b,0x53342a5f,0x00000000}},	//   _מרדכ, sná_, _рект, --,
   {{0xf1bf025b,0x66010188,0x2fd100c4,0xdd9b0b0a}},	//   pná_, _xulk, rozg_, пша_,
   {{0x13d50081,0xa91d033b,0xa3e409c3,0xcdd80291}},	//   _হওয়, _toži, _भीत_, ењу_,
   {{0x41c40c5e,0x00000000,0x00000000,0x00000000}},	// [1fb0] _حقيق, --, --, --,
   {{0x75220231,0x6d461d79,0x00000000,0x00000000}},	//   _leoz, _ecka, --, --,
   {{0x7cea01f9,0x00000000,0x00000000,0x00000000}},	//   töré, --, --, --,
   {{0xc98423c3,0xdd160031,0x98b90095,0x00000000}},	//   лучи, _päťd, млет_, --,
   {{0x66012a60,0x67212388,0xa3d0030b,0xf7452a61}},	//   _sulk, _pelj, वका_, вело,
   {{0x66012a62,0x6d5f0216,0x7c3f0188,0xb17b02c3}},	//   _pulk, leqa, muqr, llåd,
   {{0x67212a63,0xbbbf0f62,0x19ab2a64,0x3666008f}},	//   _velj, ्वीक, _етап_, ващо_,
   {{0x6d5f1a4a,0x25bf00ae,0x2d892a65,0x00000000}},	//   neqa, unul_, njae_, --,
   {{0x67212a66,0x9f530990,0x25bf00d3,0x57f52657}},	//   _telj, _així_, rnul_, _апат,
   {{0x66012a67,0x25bf2a68,0x43751c1b,0xe8740397}},	//   _tulk, snul_, туит, _حافظ,
   {{0x2d892a69,0xb2f400c2,0x0cde261e,0x27e00d2a}},	//   kjae_, ляющ, _मर्म, ɓin_,
   {{0xe2962a6a,0x7afa2a6b,0x75c800d2,0xe196007b}},	//   таю_, _útte, těze, троэ,
   {{0x6d5f061d,0x2ca92a6c,0x656b009c,0x00000000}},	//   deqa, jzad_, _iagh, --,
   {{0x656b0080,0x2ca902ef,0x443f008c,0xe3b30246}},	//   _hagh, dzad_, muu_, _حرص_,
   {{0x443f2a6d,0x6d460124,0x7e230e2c,0x00000000}},	//   luu_, _pcka, идрж, --,
   {{0xdde900cd,0xfce62a6e,0x656b0078,0xed570a54}},	//   فرقه_, вобо, _jagh, кос_,
   {{0x656b2a6f,0x443f2a70,0x6f02044c,0xfc032012}},	// [1fc0] _magh, nuu_, _şocu, ипто,
   {{0x4e060747,0x656b2a71,0x9f4c00c2,0xb17b0120}},	//   _изоб, _lagh, ödä_, småt,
   {{0x6a86013d,0x3ea62a72,0x443f2a73,0x91fc01d3}},	//   ължа, _ринг, huu_, lvār,
   {{0x443f2a74,0x656b2a75,0x290d002b,0x64591044}},	//   kuu_, _nagh, _cfea_, _opwi,
   {{0x92bd00c7,0xd943255a,0x91fc00d9,0xd90d010d}},	//   _আরো_, речи, nvār, سیل_,
   {{0x6d442a76,0x244b052f,0x443f008a,0xafdb01df}},	//   lgia, døm_, duu_, støv,
   {{0x64590154,0xacbb020d,0xdce60154,0x00000000}},	//   _apwi, _jeûn, _makč, --,
   {{0x6d442a77,0x443f0051,0xa2a0009d,0xa91d09ac}},	//   ngia, fuu_, खनस्, _božu,
   {{0x80e1110f,0x656b2a78,0x443f2a79,0x6d442a7a}},	//   _नरें, _dagh, guu_, igia,
   {{0x6d442a7b,0xb4e20104,0xa91d0234,0x69c2007e}},	//   hgia, _धरी_, _dožu, lnoe,
   {{0x656b2a7c,0x752202ef,0xc7d700ca,0xbb3b00ca}},	//   _fagh, _teoz, _יומי_, ועיי,
   {{0x80d10081,0x656b00ac,0x69c200f0,0x443f2a7d}},	//   _সৃষ্, _gagh, nnoe, buu_,
   {{0xa3c102d5,0xb17b0212,0x753d01f9,0x443f2a7e}},	//   ्कश_, vlåd, ósze, cuu_,
   {{0x656b2a7f,0x64402a80,0xf45700ca,0x4fc40ed4}},	//   _zagh, mumi, _סיור_, асса,
   {{0x64402a81,0xa3c10b7f,0x93fb0341,0x75e50103}},	//   lumi, ्कर_, _קלוי, lóza,
   {{0x6d440465,0x46b500aa,0x7bde0381,0x656b00bd}},	//   ggia, _अइसह, elpu, _xagh,
   {{0x64402a82,0x3b5500d3,0x2d890072,0x6d5f2a83}},	// [1fd0] numi, лкар, rjae_, reqa,
   {{0x6d5f0372,0xbbbf000c,0x765a0034,0x6f090065}},	//   seqa, ्वेक, _opty, _dèbó,
   {{0x6440068d,0x6e952a84,0x443f0a4b,0xb17b02c3}},	//   humi, _сину, zuu_, plåd,
   {{0x64402a85,0x99d10081,0x443f2a86,0x57cb0096}},	//   kumi, িষ্ক, yuu_, िव्ह,
   {{0x443f025e,0x64400029,0x7c842863,0x656b2a87}},	//   xuu_, jumi, _куре, _ragh,
   {{0x64402a88,0xb6050343,0x7d0d2a89,0x7c2d2a8a}},	//   dumi, hláš, lcas, msar,
   {{0x656b1336,0x99670aeb,0x7d0d028d,0x45d50e3a}},	//   _pagh, _итал, ocas, лцит,
   {{0x4efc0054,0x443f2a8b,0x64402a8c,0xa91d0106}},	//   ולוג, tuu_, fumi, _požu,
   {{0x64402a8d,0xa3c1022d,0x656b028d,0x7bc7010a}},	//   gumi, ्कल_, _vagh, _kjju,
   {{0x244b038c,0x443f2a8e,0x7d0d009c,0x656b2a8f}},	//   røm_, ruu_, hcas, _wagh,
   {{0xe2992a90,0x656b2a91,0x6d4400f0,0x443f2a92}},	//   хан_, _tagh, ygia, suu_,
   {{0xe5701850,0x64402a93,0x443f2a94,0x7c2d2a95}},	//   _وطن_, bumi, puu_, ksar,
   {{0xad9b2a96,0x64400ee7,0x7d0d2a97,0x7c2d02c3}},	//   _miúd, cumi, dcas, jsar,
   {{0x442d2a98,0x7c2d0bc6,0x442f2a99,0x75292a9a}},	//   mse_, dsar, _ivg_, laez,
   {{0x442d2a9b,0xed5a142f,0xd5ac0068,0x442f0103}},	//   lse_, нов_, _رہی_, _hvg_,
   {{0x442d2a9c,0x69c30103,0x7bc7083e,0x75290062}},	//   ose_, énel, _ajju, naez,
   {{0x442d2a9d,0x707700e3,0x6d442a9e,0x6abe0bba}},	// [1fe0] nse_, _مميز_, rgia, ्थ्र,
   {{0x442d2a9f,0x442f2aa0,0x6d4400f0,0x7d0d002b}},	//   ise_, _mvg_, sgia, acas,
   {{0x64402aa1,0x442d2aa2,0x7c2d2aa3,0xb17b02b6}},	//   zumi, hse_, asar, slåe,
   {{0x442d2aa4,0x9f5a06a3,0x7d0d028d,0xafdb01df}},	//   kse_, _sipè_, ccas, støt,
   {{0x64e205d4,0x442d2aa5,0x69c22aa6,0xb4e2009f}},	//   _परेश, jse_, rnoe, _धरे_,
   {{0x38cb0e8c,0x442d2aa7,0xb7d20081,0x64402aa8}},	//   رانی_, dse_, াষ্ট, vumi,
   {{0xfaa60424,0x499412eb,0x7bcb283f,0xaab822a0}},	//   _саво, _پیشر, égue, _आधिक,
   {{0x64402aa9,0xad9b0076,0xafdb00f2,0x442d2aaa}},	//   tumi, _giúd, ntør, fse_,
   {{0xd3262aab,0x442d2aac,0xb99300e3,0x48e302b3}},	//   льни, gse_, _القب, _готв,
   {{0x64402aad,0xf3662aae,0x39462aaf,0xaca40134}},	//   rumi, утин, lgos_, _nsọt,
   {{0x442d2ab0,0x7c2d0029,0xafdb038c,0x66e600c2}},	//   ase_, zsar, ktør, _сожа,
   {{0x39462ab1,0xaca40032,0x442f028d,0x64402ab2}},	//   ngos_, _asọt, _fvg_, pumi,
   {{0xc5f300a1,0x442d2ab3,0x6440063d,0x88bd0034}},	//   _הדף_, cse_, qumi, _leśn,
   {{0x6ed61792,0x7d0d2ab4,0x75e500d4,0x672a23ff}},	//   _मुहु, wcas, nózn, nafj,
   {{0x7c2d01af,0x98ad0117,0x539b0327,0x00000000}},	//   wsar, _rdeč_, _איגו, --,
   {{0x63ba0343,0x7c2d2ab5,0xc27b0341,0x27ec00dc}},	//   litn, tsar, _טרוי, _lhdn_,
   {{0x7d0d2ab6,0x69c3025a,0x61ed2ab7,0x212b2ab8}},	// [1ff0] rcas, énem, _ihal, mach_,
   {{0x212b2ab9,0x63ba1b32,0x39462aba,0x798002f1}},	//   lach_, nitn, egos_, _anmw,
   {{0x7c2d2abb,0x61ed2abc,0xf1ca0c38,0x5fdc00ca}},	//   ssar, _khal, रवचन, _אחזק,
   {{0x212b2abd,0x442d2abe,0x7c2d2abf,0x61ed00bd}},	//   nach_, yse_, psar, _jhal,
   {{0x39490029,0x18692ac0,0x61ed117b,0x63ba0a1d}},	//   ļas_, тали_, _mhal, kitn,
   {{0x212b0091,0xe7362ac1,0x629a013f,0x3946013f}},	//   hach_, аеш_, kyto, agos_,
   {{0x212b2ac2,0x442d2ac3,0x61ed00e7,0x69ca00fd}},	//   kach_, wse_, _ohal, éfec,
   {{0x442d2ac4,0x629a16e0,0x212b0034,0x2bbf1e05}},	//   tse_, dyto, jach_, ्वका,
   {{0x212b2ab9,0x291d2ac5,0x442d2ac6,0x75290634}},	//   dach_, mbwa_, use_, raez,
   {{0xe7a9033a,0x61ed02a7,0x63ba06a8,0x7bd70042}},	//   _कतिप, _ahal, gitn, noxu,
   {{0x61ed2ac7,0x212b2ac8,0x60cd01ee,0x61ff01ee}},	//   _bhal, fach_, _axam, _biql,
   {{0x442d2ac9,0x212b2aca,0x3f812acb,0x442f08a8}},	//   pse_, gach_, _anhu_, _tvg_,
   {{0x76432acc,0x61ed025e,0x15f40d74,0x3f930a7f}},	//   luny, _dhal, _اسلح, _boxu_,
   {{0x629a2acd,0x63ba0f1c,0x61ed2ace,0x39462acf}},	//   byto, citn, _ehal, zgos_,
   {{0x212b2ad0,0x3946013f,0x76432343,0xc7b200ca}},	//   bach_, ygos_, nuny, קבל_,
   {{0x61ed2ad1,0x3d2000a5,0xd1ba0068,0x4ad9097c}},	//   _ghal, बरें_, _جاتا_, _बुधव,

   {{0x76432ad2,0x8c462ad3,0x4b26261f,0xafdb01df}},	// [2000] huny, резе, имав, rtør,
   {{0x76431c7b,0x69db0350,0x109b03c2,0xafdb13c8}},	//   kuny, _akue, _סביב, stør,
   {{0x32070990,0x34e208fa,0x76430808,0x7f3b00a1}},	//   _juny_, _पर्द, juny, _בעיו,
   {{0x3946013f,0xeae6009d,0x320703a9,0x76430372}},	//   ugos_, _करीत_, _muny_, duny,
   {{0x39462ad4,0x8eb300cd,0x2d8201c2,0xa91d2ad5}},	//   rgos_, _همیش, _inke_, _požr,
   {{0x81bd0029,0x39460890,0x76432ad6,0x69c90172}},	//   lsēt, sgos_, funy, _ejee,
   {{0x76430b32,0x569405e1,0x7980010a,0x68e90415}},	//   guny, сайт, _tnmw, _ezed,
   {{0x6d5606a3,0x63ba2ad7,0xe5c60291,0x28160411}},	//   nfya, witn, јско, _نورس,
   {{0x88bd0067,0x2fd80149,0x29042ad8,0x77632ad9}},	//   _jeśl, korg_, _igma_, benx,
   {{0x61ed2ada,0x386900dd,0x26de030b,0x212b0034}},	//   _shal, çare_, _tyto_, wach_,
   {{0x212b2adb,0x76432adc,0x63ba2add,0x6ed6030b}},	//   tach_, cuny, ritn, _मुलु,
   {{0x29dc0610,0x96950d62,0x629a2ade,0xbcfb01dc}},	//   mías_, _уруш, ryto, _maér,
   {{0x212b2adf,0x29dc0610,0x67282ae0,0x66080429}},	//   rach_, lías_, _kedj, _hudk,
   {{0x212b2ae1,0x2d822ae2,0x644f0472,0xd83f0618}},	//   sach_, _anke_, àcie, _účet_,
   {{0x61ed2ae3,0x67282ae4,0x212b2ae5,0x29dc0610}},	//   _thal, _medj, pach_, nías_,
   {{0x67280ca7,0x61ed0051,0xdce601d3,0xdda8002d}},	//   _ledj, _uhal, _sakā, атул_,
   {{0x2fd82ae6,0xdce601d3,0x6be50037,0x3f9301ff}},	// [2010] borg_, _pakā, مكرم, _toxu_,
   {{0x67280292,0xa3e61344,0x69db038c,0x76432ae7}},	//   _nedj, पति_, _skue, yuny,
   {{0x68e90018,0x200100f9,0x200901c2,0x7ff41f11}},	//   _szed, _iihi_, _huai_, _بسيا,
   {{0x76432ae8,0x29dc04d8,0x200901c2,0xbcfb00d1}},	//   vuny, días_, _kuai_, _daér,
   {{0xa3e600c3,0xa2d80455,0xe7391312,0x68e002ad}},	//   पता_, _नुस्, гел_, _cymd,
   {{0x785a0029,0x8a1700bf,0x76432ae9,0x29dc0fb6}},	//   dāvā, _نظرا, tuny, fías_,
   {{0xf77000b1,0x29dc0890,0x69c9029a,0x7763002b}},	//   بان_, gías_, _tjee, renx,
   {{0x76430808,0x2fd80126,0x69c9008a,0x2009020d}},	//   runy, zorg_, _ujee, _ouai_,
   {{0xbee4033a,0x76432aea,0x68e00150,0x69d92aeb}},	//   _गर्न_, suny, _gymd, mowe,
   {{0x76430706,0x29dc05e6,0x20010134,0x69d92aec}},	//   puny, bías_, _nihi_, lowe,
   {{0xe1fa2aed,0x6b9509ef,0x29dc04d8,0xd575013f}},	//   лго_, _mozg, cías_, _гуль,
   {{0x200900dc,0x672800e7,0xdcfd05aa,0x35f50f91}},	//   _buai_, _zedj, _ansč, _упер,
   {{0xd24e037f,0x200900dc,0x2fd8003e,0x212901b9}},	//   ونی_, _cuai_, torg_, _deah_,
   {{0x443f2aee,0x20090063,0xf41200a1,0x69d92aef}},	//   mru_, _duai_, _צפו_, howe,
   {{0x23652af0,0x69d90034,0xdee623b1,0x394d0218}},	//   melj_, kowe, сови, _oces_,
   {{0x2900013f,0x394d023e,0xdced0220,0x2fd82af1}},	//   žiai_, _nces_, adač, sorg_,
   {{0x69d900a5,0x20092af2,0x6b952af3,0x3f8c00bc}},	// [2020] dowe, _guai_, _bozg, ödus_,
   {{0x443f2af4,0x68e00212,0x00000000,0x00000000}},	//   iru_, _rymd, --, --,
   {{0x29dc08a8,0x490600e3,0x443f2af5,0x69d90201}},	//   xías_, مواق, hru_, fowe,
   {{0x5d860080,0x70530814,0x29dc0328,0x6d980072}},	//   _الحل, _بنیا, vías_, _vías,
   {{0x6b9500e7,0x67280095,0xdb0e0072,0x23650141}},	//   _fozg, _pedj, _embá, kelj_,
   {{0x443f2af6,0x29dc255c,0x236502ef,0x7bdc0ac1}},	//   dru_, tías_, jelj_, _ukru,
   {{0x443f2af7,0x9f52037a,0x386d0233,0x69d9007f}},	//   eru_, _huyó_, _eser_, bowe,
   {{0x29dc11c4,0x443f2af8,0x98a60012,0x29040009}},	//   rías_, fru_, _либе, _ugma_,
   {{0x443f2af9,0x29dc0610,0x9f5a028d,0x6b950233}},	//   gru_, sías_, _pipì_, _yozg,
   {{0x29dc0328,0x23650141,0x00000000,0x00000000}},	//   pías_, gelj_, --, --,
   {{0x20090332,0x225800c2,0x4df80cce,0xe71700ca}},	//   _suai_, шины_, ंगाई_, _החבר_,
   {{0x443f2afa,0x25a60270,0xeae600aa,0x00000000}},	//   bru_, _ulol_, _करैत_, --,
   {{0x443f0012,0x20092afb,0x6ac4055c,0x53340aeb}},	//   cru_, _quai_, वपुर, _делт,
   {{0x4426026e,0x33f607c8,0x4fc700c2,0x69d92afc}},	//   _iwo_, _учес, ссма, zowe,
   {{0x69d90051,0x6b952afd,0x3da707ef,0xdced0580}},	//   yowe, _rozg, браб, rdač,
   {{0xd13100cd,0x200900dc,0x64402afe,0x44260517}},	//   _کمک_, _tuai_, ormi, _kwo_,
   {{0xdcfd00e7,0xb606080e,0xd011015a,0xf1bf0072}},	// [2030] _posđ, lišć, _تلخ_, miá_,
   {{0x6ac41344,0x44262aff,0x64400037,0x66022b00}},	//   वपूर, _mwo_, irmi, _liok,
   {{0x69d92b01,0x3cde009d,0xdd9500c6,0x44262b02}},	//   towe, _कुठे_, _даны, _lwo_,
   {{0x19590138,0x44260649,0x127b00c1,0x443f2b03}},	//   рады_, _owo_, טאבע, yru_,
   {{0x44260af0,0xf09f2b04,0x69d92b05,0x6d4f00bd}},	//   _nwo_, nyà_, rowe, _icca,
   {{0x645c002d,0xbcfb104d,0x01cf0081,0x69d92b06}},	//   ăril, _abég, রতিদ, sowe,
   {{0x44262b07,0x443f043f,0x64400a2c,0x2365033b}},	//   _awo_, wru_, ermi, velj_,
   {{0x44260b92,0x84592b08,0x394d15b1,0xb60602f7}},	//   _bwo_, арот_, _uces_, dišć,
   {{0x443f2b09,0x386d0054,0xf1bf0220,0x44260085}},	//   uru_, _user_, diá_, _cwo_,
   {{0x443f182f,0xdb0e003e,0xfe0902d5,0x44260154}},	//   rru_, _embæ, वदास_, _dwo_,
   {{0x6d5d0871,0x66022b0a,0x6d4f1ef7,0x44262b0b}},	//   _obsa, _fiok, _occa, _ewo_,
   {{0x443f2b0c,0x66020036,0x23650141,0xbcfb0032}},	//   pru_, _giok, selj_, _gbég,
   {{0x44262b0d,0x2365015c,0x25bf00ae,0xeae600b7}},	//   _gwo_, pelj_, miul_, _कर्त_,
   {{0x6d5d2b0e,0x6d4f013d,0x25bf00d3,0x3cdd02ed}},	//   _absa, _acca, liul_, _खड़े_,
   {{0x9f520032,0x1d0a00e5,0xf1bf0956,0x00000000}},	//   _buyò_, иеви_, biá_, --,
   {{0x25bf002d,0x3dc9019c,0xf1bf13a9,0x0c260b36}},	//   niul_, gnaw_, ciá_, жман,
   {{0x249f2b0f,0x752b2b10,0x248d00b3,0xfce32348}},	// [2040] nyum_, _megz, nxem_, дото,
   {{0x25bf00ae,0x61e60650,0x6d4f0027,0x248d00ee}},	//   hiul_, llkl, _ecca, ixem_,
   {{0xed5a00c9,0x3dc90270,0x00000000,0x00000000}},	//   _кон_, bnaw_, --, --,
   {{0xe9da2311,0xd378042d,0x00000000,0x00000000}},	//   шке_, moće_, --, --,
   {{0x25bf002d,0x25ad00d1,0x999c01f9,0x00000000}},	//   diul_, dhel_, évő_, --,
   {{0x4426023f,0xc7a31510,0x38690131,0x207b006e}},	//   _rwo_, мичк, çara_, יאנא,
   {{0x81c30033,0x7bce01cb,0xd37814f3,0x00000000}},	//   ্তত_, _ijbu, noće_, --,
   {{0x2cbf14f3,0x25ad2b11,0x2d92023f,0x7e9b00c1}},	//   _žudi_, ghel_, njye_, יסצו,
   {{0x938a2610,0xa73a0103,0xbcfb0065,0xf1bf2b12}},	//   асна_, _نثار_, _gbéd, viá_,
   {{0xa3e40251,0x442601c0,0x61e62b13,0x7c291930}},	//   _भीख_, _vwo_, elkl, _çere,
   {{0x86c600e3,0x25bf2b14,0xcb1300a1,0xf1bf03be}},	//   _بيان, biul_, ולת_, tiá_,
   {{0xb6062b15,0x44260054,0x25bf002d,0x2900013f}},	//   rišć, _two_, ciul_, žiau_,
   {{0x4426092f,0x25d900cd,0xcf0000a7,0xf1bf0031}},	//   _uwo_, _اهنگ_, əşən_, riá_,
   {{0x437400cd,0xad9b00da,0x00000000,0x00000000}},	//   _رهبر, _ciún, --, --,
   {{0x3ea50018,0x6d5d009c,0xf1bf0231,0x00000000}},	//   ált_, _pbsa, piá_, --,
   {{0x321e03a9,0xdb170042,0x51872b16,0x463b006e}},	//   mpty_, rixí, _фука, יעלע,
   {{0x030e0cce,0xad9b2b17,0xa1f90103,0xc19c00ca}},	// [2050] _सलाह_, _fiún, _پڑھا_, _כשהי,
   {{0x09d309a0,0x1fa72972,0x6ed61da8,0xda7b00e5}},	//   तव्य, _фриг, _मुकु, ияе_,
   {{0xf0b800d1,0xfd470103,0xaf010033,0x00000000}},	//   _هایش_, _ویسٹ_, ্রহণ_, --,
   {{0x249f1732,0x67ed04c3,0x7aed00e8,0x2ca02b18}},	//   yyum_, dúja, _ģitā, byid_,
   {{0xdb1e00b3,0x6d4d10ad,0xb17c006e,0x5d7a0142}},	//   kipè, mgaa, יטאר, _פאשק,
   {{0x81c30f71,0x2d990193,0x6cfa00a1,0x7b642b19}},	//   ্তি_, _hose_, _לפרס, _отсе,
   {{0x2d992b1a,0x25ad2b1b,0x67ed0018,0x25bf00ae}},	//   _kose_, thel_, gúja, tiul_,
   {{0x6d4d2b1c,0x3915097a,0x2d992b1d,0x00000000}},	//   ngaa, _хмар, _jose_, --,
   {{0x81c300c7,0x25bf002d,0x395f0154,0x57b51c4c}},	//   ্তা_, riul_, _ibus_, _ебат,
   {{0xbcfb0065,0x2d9906dc,0x752b0dbc,0x249f2b1e}},	//   _gbée, _lose_, _wegz, ryum_,
   {{0x69cb2b1f,0x249f2b20,0x25bf00d3,0x95cb194c}},	//   onge, syum_, piul_, _куда_,
   {{0x2ca02b21,0x69cb2b22,0x6d4d2b23,0xbcfb01dc}},	//   yyid_, nnge, jgaa, _mbéb,
   {{0x69cb2b24,0x6d4d2b25,0x920b08d4,0x26110023}},	//   inge, dgaa, _सूरज_, _háo_,
   {{0xd9b8000c,0xa4fa00ca,0x2d990113,0x4abd0f35}},	//   _अष्ट, _פלסט, _aose_, ्पाव,
   {{0x2d99023f,0x59db05a5,0x764302e7,0x8e83117c}},	//   _bose_, यकार, nrny, нгре,
   {{0x6d4d2b26,0x2d99013d,0x7643005c,0xa3b70ff9}},	//   ggaa, _cose_, irny, घोर_,
   {{0xdb1e01e5,0x6ac40569,0x76430167,0x7a0c013c}},	// [2060] qipë, वप्र, hrny, _iğti,
   {{0x6d4d29cb,0x65692b27,0x395f080b,0xa3cb0096}},	//   agaa, heeh, _abus_, रचि_,
   {{0x2d992b28,0x2ca0117e,0x98b0005f,0x9f9b00ca}},	//   _fose_, syid_, đači_, _הסיפ,
   {{0x5f460018,0x2d990634,0xe8fa2360,0x00000000}},	//   _بنگل, _gose_, бле_, --,
   {{0xa3bd02e8,0xa3cb009d,0x7d7b00ca,0x395f01ff}},	//   ीचा_, रचा_, _הנכו, _dbus_,
   {{0x261100ef,0xdb1e03a9,0x64490472,0x2d990193}},	//   _báo_, kipé, duei, _zose_,
   {{0x26110028,0x2d99023f,0xdbc713e1,0x7c36057e}},	//   _cáo_, _yose_, töös, lsyr,
   {{0x7bde2b29,0x69c30018,0x00000000,0x00000000}},	//   lopu, énet, --, --,
   {{0x64492b2a,0x76432b2b,0xdce40138,0x7c360b97}},	//   guei, arny, keič, nsyr,
   {{0x31600167,0x69c22b2c,0x290000c6,0xdc9b006e}},	//   _abiz_, lioe, žias_, צייל,
   {{0xe4d614df,0x6d4d2b2d,0x0edb2b2e,0xf77300ca}},	//   _کتاب, ygaa, _मुंड, _רקע_,
   {{0x7bde0294,0xfbc40081,0x64490428,0x69c22b2f}},	//   hopu, ্তিত, buei, nioe,
   {{0x644904ea,0x7bde00c2,0xad9b0037,0x78a22b30}},	//   cuei, kopu, _diúl, nyov,
   {{0x225900a5,0x69c201ff,0x00000000,0x00000000}},	//   ńska_, hioe, --, --,
   {{0x6d4d1f58,0xdb1e00e3,0x69cb14ef,0x649502a1}},	//   tgaa, cipé, ynge, _eżiġ,
   {{0x91e40291,0xdd9403a7,0x69c20062,0x00000000}},	//   _поје, насы, jioe, --,
   {{0x113c00ca,0x9c190037,0x00000000,0x00000000}},	// [2070] _התחל, زياء_, --, --,
   {{0x6d4d2b31,0x09c50096,0x2d9902a4,0x2a630085}},	//   sgaa, लच्य, _wose_, _ppjb_,
   {{0x6d4d2b32,0x69c201ff,0x671000aa,0x2d9901b6}},	//   pgaa, fioe, ाशनक_, _tose_,
   {{0x69cb008f,0xdb1e00c2,0x69c22b33,0x68220294}},	//   unge, enpä, gioe, _ọdac,
   {{0x26110023,0xeab00018,0x69cb2b34,0x656901cb}},	//   _sáo_, نٹے_, rnge, veeh,
   {{0x69da2b35,0xdb2300cd,0x66e52b36,0xac182b37}},	//   _íten, _سوری, мола, _хору_,
   {{0xe7302b38,0x69c20062,0x00000000,0x00000000}},	//   اصه_, bioe, --, --,
   {{0x69c22b39,0x395f02c9,0x64492b3a,0x387f00f3}},	//   cioe, _ubus_, tuei, _trur_,
   {{0x387f0188,0x29000220,0x79892b3b,0x00000000}},	//   _urur_, žiar_, _inew, --,
   {{0x261100de,0x799b01cb,0xad9b0076,0xe2a200fe}},	//   _táo_, _houw, _siúl, _thử_,
   {{0x61460ef7,0x799b02f1,0x798902ac,0x3f9a13be}},	//   мена, _kouw, _knew, _ropu_,
   {{0x5ec10081,0x799b2b3c,0xdb1e1e7d,0x7bde024a}},	//   _শুভে, _jouw, ripé, zopu,
   {{0x64492b3d,0x799b01c0,0xad9b016d,0xafdb0120}},	//   quei, _mouw, _ciúm, rrøn,
   {{0x69c20a00,0x799b2b3e,0xd84f0134,0xbef900a4}},	//   zioe, _louw, lọsi_, ंधून_,
   {{0xdb0e00fc,0x00000000,0x00000000,0x00000000}},	//   _embû, --, --, --,
   {{0x69bf0e72,0xdb1c119e,0x79890172,0x2be60285}},	//   लोमी, _imré, _nnew, _जीजू_,
   {{0x7bde2b3f,0x5f760391,0x7e65009c,0x3f9a2b40}},	// [2080] topu, _قادر, _ephp, _topu_,
   {{0xd84f0134,0x78a20a4b,0xfaa60974,0x00000000}},	//   họsi_, vyov, мазо, --,
   {{0x81c300c7,0x799b0ab2,0x7c3602c3,0x7bde055f}},	//   ্তর_, _bouw, ssyr, ropu,
   {{0x7bde2b41,0x00000000,0x00000000,0x00000000}},	//   sopu, --, --, --,
   {{0x69c201e9,0x799b2b42,0x2a6d007e,0x61e40aa9}},	//   rioe, _douw, _ćebe_, _mkil,
   {{0x7a0c00d3,0x79892b43,0x69c32b44,0x69c22b45}},	//   _aşte, _enew, éner, sioe,
   {{0x799b0154,0x6b9c2843,0x69c201c8,0x00000000}},	//   _fouw, _iorg, pioe, --,
   {{0x6b9c2b46,0x61e42b47,0x320e028d,0x799b000b}},	//   _horg, _nkil, _rufy_, _gouw,
   {{0x69c02b48,0xbeeb02d5,0xdb1c0113,0x6b9c07f9}},	//   _imme, _टर्न_, _amré, _korg,
   {{0x61e40010,0xf3662b49,0x00000000,0x00000000}},	//   _akil, фтин, --, --,
   {{0xbcfb0037,0x6b9c1556,0x316b007f,0x00000000}},	//   _mbéa, _morg, tecz_, --,
   {{0x6b9c0a02,0x61f60d7b,0x00000000,0x00000000}},	//   _lorg, _chyl, --, --,
   {{0x6b9c0185,0x0cc90081,0x65620169,0x00000000}},	//   _oorg, _শর্ত, _iboh, --,
   {{0x6b9c0a8d,0x61e42b4a,0xe4c7001c,0xa5c604c8}},	//   _norg, _ekil, _تصمی, bjóð,
   {{0x69c02b4b,0xdd9b11cc,0xa3bd007f,0x3ced00d8}},	//   _omme, оша_, ीचर_, _šev_,
   {{0xc5f801d3,0x00000000,0x00000000,0x00000000}},	//   _spēj_, --, --, --,
   {{0x3cfc01e9,0x6b9c2b4c,0x7989028d,0x799b029a}},	// [2090] рvv_, _borg, _rnew, _rouw,
   {{0x799b022b,0x69c02b4d,0x21f20220,0x6b9c2b4e}},	//   _souw, _amme, máha_, _corg,
   {{0x65620146,0xafdb004d,0xfd100103,0x799b022b}},	//   _oboh, nrøm, اجہ_, _pouw,
   {{0x9f5a00c2,0x49b8001c,0x4c951009,0x00000000}},	//   _eipä_, واند_, _зимс, --,
   {{0x6b9c2b4f,0x2d8b026a,0x799b029a,0x7e620a39}},	//   _forg, _ince_, _vouw, _ćopi,
   {{0x69c02b50,0xdce40b88,0x65622b51,0x6b9c2b52}},	//   _emme, ldiğ, _aboh, _gorg,
   {{0x16a92b53,0xdcfd0138,0x799b2b3c,0x4ae401b3}},	//   явки_, _posė, _touw, _аўта,
   {{0x6b9c2b54,0xc8c002e8,0x7bc52b55,0xdce401e8}},	//   _zorg, _शेवट, lihu, ndiğ,
   {{0x44392b56,0x290d028d,0x6b9c2b57,0xafdb0120}},	//   és_, _igea_, _yorg, støy,
   {{0x61e4238c,0x7bc52b58,0x57f400ae,0x6562039f}},	//   _skil, nihu, _апут, _eboh,
   {{0x2d8b1647,0x98a4020a,0x969000d1,0x00000000}},	//   _once_, _temă_, _نیوش, --,
   {{0x22590034,0xe29a0023,0xa91d0138,0x65620032}},	//   ńsko_, _ngưu_, _požy, _gboh,
   {{0x32090270,0xa5c60088,0x6abd0966,0x7bc52b59}},	//   _diay_, sjóð, ्पुर, kihu,
   {{0x2d8b2b5a,0x3cf502d5,0x7bc52b5b,0x65620094}},	//   _ance_, ्धने_, jihu, _zboh,
   {{0x645b2b5c,0x24592b5d,0x3d1506c0,0x61f6030a}},	//   ltui, lèm_, _ụwa_, _thyl,
   {{0x657b2b5e,0x32090019,0x61e40239,0x628300e1}},	//   nduh, _giay_, _ukil, _irno,
   {{0x68e9001c,0xf39000de,0x6b9c2b5f,0x8c431272}},	// [20a0] _nyed, _mảnh_, _porg, лете,
   {{0x6abd08fa,0x2d8b0042,0x290d0a43,0x7bc50193}},	//   ्पूर, _ence_, _agea_, gihu,
   {{0x6b9c02e2,0x68e92b60,0x645b2b61,0x7c292b62}},	//   _vorg, _ayed, htui, _çern,
   {{0x68e9010a,0x645b0f5a,0xe8fa100c,0x6b9c084e}},	//   _byed, ktui, пле_, _worg,
   {{0x6b9c2b63,0x20120022,0xdb1e2b64,0x7bc505bd}},	//   _torg, _juyi_, lipí, bihu,
   {{0x290d002b,0x20120022,0x62832b65,0x00000000}},	//   _egea_, _muyi_, _orno, --,
   {{0xfa672b66,0x56942b67,0x7c242b68,0xd9462a6e}},	//   _парк_, тайт, lpir, _певи,
   {{0xd5b72b69,0xf3900028,0x69c02b6a,0x657b019c}},	//   есь_, _cảnh_, _umme, gduh,
   {{0x62832b6b,0x7c242b6c,0xb886033d,0x657901b9}},	//   _arno, npir, _blíž, _dawh,
   {{0xafdb01df,0xdb1700a7,0x21f200d4,0x00000000}},	//   trøm, rixç, váha_, --,
   {{0x628300e9,0xf8bf0102,0xf36301b6,0x0bb700ca}},	//   _crno, _þér_, утын, גלים_,
   {{0x20122b6d,0x645b057a,0x65790090,0x62830147}},	//   _buyi_, btui, _gawh, _drno,
   {{0xdce4026a,0x777a01c8,0xf1c02b6e,0x7bc52b6f}},	//   vdiğ, _katx, शोधन, yihu,
   {{0x229400e3,0x7c240087,0x777a01ff,0x81c30033}},	//   _للتس, dpir, _jatx, ্তই_,
   {{0xfe700068,0x777a2b70,0x0edb2171,0x00000000}},	//   یدہ_, _matx, _मुखड, --,
   {{0xdced007e,0x777a0062,0x7bc50169,0x00000000}},	//   ndać, _latx, wihu, --,
   {{0x3cfc2b71,0xdce40b88,0x7c242b72,0xd164013d}},	// [20b0] लेले_, rdiğ, gpir, _същи,
   {{0x657b2b73,0xa91d2b74,0xe1ff2b75,0x777a0062}},	//   zduh, _inži, lmó_, _natx,
   {{0xc33300a1,0xdcef00ae,0xbcfb0032,0xad9b033c}},	//   רוע_, _bacă, _gbén, _liúi,
   {{0x7bc52b76,0x00000000,0x00000000,0x00000000}},	//   sihu, --, --, --,
   {{0x777a2b77,0x65792b78,0xf3900023,0xed6002c6}},	//   _batx, _rawh, _rảnh_, ížet_,
   {{0xf7710192,0xf3900023,0x777a00ee,0x98a22b79}},	//   شات_, _sảnh_, _catx, рише,
   {{0x067524c0,0x777a01ff,0x39152b7a,0xd91501b3}},	//   туля, _datx, _амбр, _адбы,
   {{0xd6ce0080,0x645b00c2,0xdb0e0154,0xa50900ae}},	//   تقى_, ttui, _albè, мейа_,
   {{0x777a2b7b,0x657b2b7c,0xad9b0076,0x7a0c020e}},	//   _fatx, rduh, _ciúi, _işta,
   {{0x645b0934,0x5ed70081,0x21320063,0x777a01c8}},	//   rtui, _ধরনে, _seyh_, _gatx,
   {{0x65792b7d,0x645b2b7e,0xa91d00e7,0x20120d2a}},	//   _tawh, stui, _anži, _suyi_,
   {{0x628302ef,0x201203a9,0x645b2843,0xcec400d2}},	//   _vrno, _puyi_, ptui, hoří_,
   {{0x75292b7f,0x98a40138,0x7c240113,0x99e80031}},	//   mbez, _temą_, xpir, liňá,
   {{0x64492b80,0x644614f3,0x43452b81,0x75292b82}},	//   mrei, škic, _рекв, lbez,
   {{0xdee62348,0xd0071c30,0xed5a21b4,0x64492b83}},	//   тови, тере_, мов_, lrei,
   {{0x661c0018,0xd00f0068,0xb6020088,0x75292b84}},	//   _érke, صلہ_, _þátt, nbez,
   {{0xff262b85,0x973c084f,0x64492b86,0x62810629}},	// [20c0] _импо, _hoće, nrei, lvlo,
   {{0x64492b87,0xd00f0260,0x7c242b88,0x442f0178}},	//   irei, _گلی_, rpir, _mwg_,
   {{0x64492b89,0xf1c62b8a,0x442f01fa,0x2d9e0257}},	//   hrei, _लगान, _lwg_, êtes_,
   {{0x64492b8b,0x6cc60450,0x442f0063,0xd00f0470}},	//   krei, _айма, _owg_, _دلی_,
   {{0xb82200c7,0x442f022e,0xaca40294,0x777a01e9}},	//   _নিহত_, _nwg_, _kpọt, _patx,
   {{0x64492b8c,0xb17b0149,0xbcfb01dc,0x00000000}},	//   drei, llåt, _mbél, --,
   {{0x973c2b8d,0x163700e3,0x660b2b8e,0x2b582b8f}},	//   _noće, نسية_, _bigk, _icrc_,
   {{0x64492b90,0xd01a00c7,0x557401c9,0xadf800a5}},	//   frei, তীয়_, угит, ंगटन_,
   {{0x64492b91,0xa80600ae,0x660b0313,0xdb0e01f9}},	//   grei, _азал, _digk, _albé,
   {{0x442f02e5,0x6e3e007e,0x75c802c6,0x00000000}},	//   _dwg_, _ovpb, tězs, --,
   {{0xf1f60034,0x69bf02d5,0xcb370266,0x261105db}},	//   ीगढ़_, लोवी, כניק_, _cšod_,
   {{0xf1a721b6,0x64492b92,0x973c02ef,0x442f0178}},	//   трон, brei, _doće, _fwg_,
   {{0xe1ff0890,0xc0580565,0x6e220a9e,0x64492b93}},	//   rmó_, кір_, _čoba, crei,
   {{0x9f530990,0x26180019,0x3869023b,0x9f430216}},	//   _això_, _kéo_, çari_, mojë_,
   {{0x4ea42b94,0x2fcd0106,0x9f43023b,0x9f34004d}},	//   арта, đeg_, lojë_, ресі,
   {{0x442f0197,0x24862b95,0x261800fe,0x00000000}},	//   _ywg_, _krom_, _méo_, --,
   {{0x6abd0179,0x69c30257,0x9f43023b,0x26182b96}},	// [20d0] ्प्र, ènem, nojë_, _léo_,
   {{0x8aa71c30,0x2d9e020d,0x21392b97,0x7529007e}},	//   кред, êter_, lash_, zbez,
   {{0x2618020d,0x9f430216,0x00000000,0x00000000}},	//   _néo_, hojë_, --, --,
   {{0xdd950ff8,0x9f43023b,0x21390052,0x64492b98}},	//   _самы, kojë_, nash_, yrei,
   {{0x2486023e,0x9f430052,0xafdb02b6,0xf7452b99}},	//   _nrom_, jojë_, gsøg, гело,
   {{0x261800de,0x442f01fa,0xdb070018,0x9f430052}},	//   _béo_, _rwg_, _eljá, dojë_,
   {{0xcf9413b6,0x24862b9a,0xfc3f01ab,0x442f009c}},	//   יטס_, _arom_, _hví_, _swg_,
   {{0x442f01fa,0x24861cab,0xafdb02b6,0x21390216}},	//   _pwg_, _brom_, bsøg, jash_,
   {{0x752918c4,0x24862b9b,0x9f430052,0x21392b9c}},	//   rbez, _crom_, gojë_, dash_,
   {{0x64492b9d,0x62811570,0x75292b9e,0x248614bd}},	//   rrei, tvlo, sbez, _drom_,
   {{0x64492b9f,0x660b0124,0x248601cb,0x35552ba0}},	//   srei, _tigk, _erom_, _مناز,
   {{0x2486004f,0x442f01bb,0x6449091f,0x6446013f}},	//   _from_, _twg_, prei, škia,
   {{0x3fc800bf,0xf5390220,0x6281000b,0x291f2ba1}},	//   ندسی_, mať_, svlo, _mfua_,
   {{0xf5390220,0x25ad0fcf,0x200c2ba2,0x00000000}},	//   lať_, lkel_, ödi_, --,
   {{0xfc3f00b3,0x261800fe,0x61ef0113,0x00000000}},	//   _aví_, _xéo_, blcl, --,
   {{0x25ad2ba3,0xf5390220,0x40e50129,0x67380234}},	//   nkel_, nať_, ụrị_, zavj,
   {{0xb17b0212,0x5ed70033,0xac86022a,0xdb1e00b3}},	// [20e0] rlåt, _ধরণে, ыгал, tipà,
   {{0xb3460396,0x9f5e0084,0xf5390220,0xb17b2ba4}},	//   moçõ, ötä_, hať_, slåt,
   {{0x25ad2ba5,0xbea62ba6,0x3ea62ba7,0x533600c1}},	//   kkel_, _санк, _синг, רנען_,
   {{0x3ea52ba8,0xf5390031,0x1ad50d7a,0xe9e50120}},	//   älte_, jať_, _दशरथ, аціо,
   {{0xe8942a6a,0xf5392ba9,0x07a6067f,0xc7c611b7}},	//   раль, dať_, ладн, лски,
   {{0xafdb0021,0x9f43023b,0x6e020129,0x21390216}},	//   rsøg, vojë_, _ọchụ, zash_,
   {{0x67380b27,0x61e600e7,0xad9b0558,0xdb07003e}},	//   ravj, kokl, _viúv, _smjö,
   {{0x6d562baa,0xd49a1c0e,0x2d802bab,0x9f43023b}},	//   ngya, еро_, ndie_, tojë_,
   {{0xa84a0dd0,0x61e600d9,0x2d802bac,0x21391175}},	//   _سلام_, dokl, idie_, vash_,
   {{0x9f4300dd,0x21f202c6,0x248601cb,0x00000000}},	//   rojë_, sáhl_, _vrom_, --,
   {{0x9f43023b,0x2139023b,0xe81a0034,0xf5390031}},	//   sojë_, tash_, _फंडा_, bať_,
   {{0x24862bad,0x2d80020a,0x25ad2bae,0xf5390031}},	//   _trom_, jdie_, ckel_, cať_,
   {{0x21392baf,0x73c4262f,0x5ff500d3,0x00000000}},	//   rash_, _پيغم, изму, --,
   {{0x2a660034,0x14d700ca,0x6d560188,0x21392bb0}},	//   łoby_, _גודל_, egya, sash_,
   {{0x3944037a,0xbcfb0139,0x21390216,0x00000000}},	//   _odms_, _gbéj, pash_, --,
   {{0x6d562bb1,0x61e62bb2,0x21392bb3,0x7c292bb4}},	//   ggya, cokl, qash_, _çerk,
   {{0x48b60033,0x00000000,0x00000000,0x00000000}},	// [20f0] জপুর, --, --, --,
   {{0x91fd0029,0xf5390181,0x2fca007e,0xdb1e2bb5}},	//   stād, zať_, cibg_, tipá,
   {{0x3a7501b6,0x20d41e49,0x25ad2bb6,0x2ca9134a}},	//   рлер, _نتیج, ykel_, syad_,
   {{0x6e25009c,0x57dd0096,0x3e41004b,0x00000000}},	//   _ithb, यव्ह, mėt_, --,
   {{0xf5392ba9,0xd5b100fe,0xa3d400a4,0x3d3a00d7}},	//   vať_, _lúc_, सचा_, _בגרס,
   {{0x225900a5,0x10380341,0x69ca2bb7,0xdd1c00c6}},	//   ński_, נטום_, éfer, _iššo,
   {{0xf5390181,0x25ad007a,0x98d20134,0x1a680a85}},	//   tať_, tkel_, sịpụ, _میلی_,
   {{0xa4450450,0x00000000,0x00000000,0x00000000}},	//   анид, --, --, --,
   {{0x69cb2bb8,0xf5390181,0x9848013d,0x6446013f}},	//   mige, rať_, _бяха_, škin,
   {{0x69cb040f,0xf5390181,0x25ad075b,0x386d1cb2}},	//   lige, sať_, skel_, _iper_,
   {{0x27e72bb9,0xd6d10867,0x25b00103,0xf5390031}},	//   monn_, _بقا_, álló_, pať_,
   {{0x69cb2bba,0x91e62bbb,0x61e600c6,0x00000000}},	//   nige, роме, uokl, --,
   {{0x6e2500e3,0x80c000b6,0x00000000,0x00000000}},	//   _athb, _लेखे, --, --,
   {{0x443f2bbc,0x69cb2bbd,0x753b2bbe,0xdfd20037}},	//   msu_, hige, lauz, زيز_,
   {{0xa91d0871,0x09b5009d,0x63a30049,0x69cb149c}},	//   _každ, ंसाठ, _ionn, kige,
   {{0x63a32bbf,0x1d260e20,0x27e72bc0,0x32da00ca}},	//   _honn, рмам, honn_, _שחקנ,
   {{0x63a32bc1,0x443f2bc2,0x2d80040c,0x69cb2bc3}},	// [2100] _konn, nsu_, rdie_, dige,
   {{0x443f2bc4,0x63a32bc5,0x2f1c0139,0xeab20037}},	//   isu_, _jonn, _dàgó_, يعا_,
   {{0x69cb2bc6,0x3dd70649,0x63a32bc7,0x973c0335}},	//   fige, úewé_, _monn, _noća,
   {{0x63a30037,0x88862bc8,0x69cb2bc9,0xa01b003e}},	//   _lonn, илеж, gige, kvöl,
   {{0x91fd00d9,0x38cb015a,0x6eca0635,0x76410572}},	//   ltāc, پانی_, _हेतु, _avly,
   {{0x63a32bca,0x98a400b6,0x973c2bcb,0xc66a00c2}},	//   _nonn, _země_, _boća, вшие_,
   {{0x69cb2bcc,0x2956013d,0xafdb038c,0x443f2bcd}},	//   bige, _възр, prøv, esu_,
   {{0x443f2bce,0xd37802e6,0x6d460063,0x04662bcf}},	//   fsu_, moći_, _jdka, атом,
   {{0x26160067,0x63a32bd0,0x443f00f9,0xb0c50034}},	//   _पूरी_, _bonn, gsu_, _लेंग,
   {{0x63a32bd1,0x7980023f,0x3d1d0032,0x79821b0d}},	//   _conn, _hamw, _káwó_, ldow,
   {{0x6d460871,0x79802bd2,0x63a315bc,0x443f2bd3}},	//   _odka, _kamw, _donn, asu_,
   {{0x7c2600e9,0x79822bd4,0x63a300a4,0x31c71eac}},	//   _otkr, ndow, _eonn, рсов,
   {{0x63a32bd5,0x8463008f,0x7980030a,0x443f2bd6}},	//   _fonn, _дъще, _mamw, csu_,
   {{0x44262bd7,0x63a32bd8,0x6d46008a,0x64422bd9}},	//   _ito_, _gonn, _adka, _ivoi,
   {{0x7c2624e5,0xc3fb00a1,0x644001df,0x69cb2bda}},	//   _atkr, _שלוש, lsmi, yige,
   {{0x44262bdb,0xa91d08a9,0x63a32bdc,0x79800198}},	//   _kto_, _kaže, _zonn, _namw,
   {{0x63a30283,0x61ed1331,0x69cb0727,0xdb1e00c2}},	// [2110] _yonn, _ikal, vige, kipä,
   {{0x44262bdd,0x69d80257,0xa91d013f,0x69cb2bde}},	//   _mto_, éven, _maže, wige,
   {{0x69cb2bdf,0x79800ab1,0x386d00d3,0x61ed2be0}},	//   tige, _bamw, _sper_, _kkal,
   {{0x44262be1,0x443f2be2,0x64402be3,0x79822be4}},	//   _oto_, ysu_, ksmi, gdow,
   {{0x44262be5,0xfd9600a1,0x61ed0051,0xe6cb0088}},	//   _nto_, _הדרך_, _mkal, _íbúð,
   {{0x64402be6,0x628a2be7,0xdb1e00aa,0x3d1d0139}},	//   dsmi, _orfo, gipä, _fáwó_,
   {{0x44262be8,0x3f8118c4,0x64422be9,0x28a702d5}},	//   _ato_, _mahu_, _avoi, _कॅरि,
   {{0x81bd0b4b,0x63a32bea,0x973c2beb,0x27e706a3}},	//   spēj, _sonn, _voća, sonn_,
   {{0x69c92bec,0x27e70c56,0x63a32bed,0x64402bee}},	//   _imee, ponn_, _ponn, gsmi,
   {{0x443f2bef,0xd7fb02fd,0x61ed2bf0,0xaca30294}},	//   rsu_, _руб_, _akal, _adịb,
   {{0x44262bf1,0x443f2bf2,0x63a32bf3,0x79802bf4}},	//   _eto_, ssu_, _vonn, _yamw,
   {{0x443f2bf5,0x63a3083e,0x64402bf6,0x00000000}},	//   psu_, _wonn, bsmi, --,
   {{0x628a02dc,0x3f810d17,0x973c005f,0x644f18c8}},	//   _erfo, _bahu_, _moćn, ácid,
   {{0x63ba2bf7,0x23262440,0x61ed2bf8,0x7982007f}},	//   chtn, _лоши_, _ekal, zdow,
   {{0xdfcf00e3,0x65b50146,0xa91d1f54,0x3f8114f3}},	//   ريف_, _záha, _zaže, _dahu_,
   {{0x973c00e9,0x3d28001c,0x68fb2bf9,0xdcfd04a8}},	//   _noćn, شتری_, _ozud, _alsı,
   {{0x6da32bfa,0x3f810234,0x4426037a,0x68fb010a}},	// [2120] чита, _fahu_, _xto_, _nzud,
   {{0xa3ca08e7,0x69c92bfb,0x6ee10134,0x79802bfc}},	//   रोप_, _amee, _ịbel, _samw,
   {{0x8e8600e3,0x7980022b,0x2bb9009d,0x0a4a00c2}},	//   _الجه, _pamw, _इतरा, узей_,
   {{0xe93a1823,0x8d560aad,0xe9da0fd6,0x6d4602b6}},	//   اسات_, _уточ, ыке_, _udka,
   {{0x79822bfd,0xa3e70ded,0x515b00ca,0x60000ee2}},	//   rdow, पवा_, רכנו, römf,
   {{0xbcfb0065,0x69c92bfe,0x79802bff,0x7982033c}},	//   _abéw, _emee, _wamw, sdow,
   {{0x442603ce,0x2d821114,0xa91d2c00,0x65b51ba6}},	//   _sto_, _kake_, _saže, _sáha,
   {{0x64400f05,0xa91d013f,0xa3ca0179,0xb8ce0081}},	//   tsmi, _paže, रोन_, _ওই_,
   {{0x2d820054,0x4426016d,0x64402c01,0x81bd01d3}},	//   _make_, _qto_, usmi, spēk,
   {{0xa91d005f,0x61ed2c02,0xd37a1121,0xd4e300c2}},	//   _važe, _skal, учи_, яющи,
   {{0x9f8d00b6,0xc7b300ca,0xdddc0117,0xd2f800ae}},	//   uží_, _צבע_, zvrš, ренц_,
   {{0xdb1c0102,0x2d820044,0x3f810022,0x64402c03}},	//   _umræ, _nake_, _sahu_, psmi,
   {{0x44262c04,0xafdb038c,0x673a0084,0xd4f60281}},	//   _uto_, drør, _ketj, _اثاث,
   {{0x623412e7,0x2d820139,0x82330018,0x43940219}},	//   _деку, _aake_, _کروا, _факс,
   {{0x25a62c05,0x673a007e,0x61ed2c06,0x3f832c07}},	//   _kool_, _metj, _tkal, rdju_,
   {{0x673a0268,0x7bdc0078,0x61ed2c08,0x21f90094}},	//   _letj, _ajru, _ukal, mého_,
   {{0x3f812c09,0x21f90074,0x2d820a75,0xdb0e00ee}},	// [2130] _tahu_, lého_, _dake_, _albà,
   {{0x673a0cad,0x69c90a9f,0x661a01c2,0x75d300ae}},	//   _netj, _smee, _outk, răzi,
   {{0x21f90897,0x1df90fe9,0x973c00c4,0x2d8200d7}},	//   ného_, _вены_, _poćn, _fake_,
   {{0xd37800e9,0x25a6008a,0x2d820079,0xad9b0076}},	//   moću_, _nool_, _gake_, _dhúc,
   {{0x973c2c0a,0x673a038c,0x21f90146,0xdcfd05aa}},	//   _voćn, _betj, hého_, _kasč,
   {{0x21f90871,0x7c2d22d3,0x2d82068d,0x661a2c0b}},	//   kého_, mpar, _zake_, _butk,
   {{0x2d822c0c,0x2013009e,0x660505b6,0x2f5c0266}},	//   _yake_, _mixi_, опка, אדונ,
   {{0x69c92c0d,0x9425004c,0x25a600ca,0x21f90094}},	//   _umee, омие, _cool_, dého_,
   {{0x6f002c0e,0x7c2d2c0f,0x57d50396,0xdfe90179}},	//   _kábí, npar, _доаѓ, ओवाद_,
   {{0x387f01ff,0x673a02ac,0xd378037d,0x37f900d3}},	//   _isur_, _getj, koću_, _тезэ_,
   {{0x395f0b14,0xd6db1eb9,0x27e00037,0x56942c10}},	//   _kcus_, _ста_, éine_, _нафт,
   {{0x65bf0139,0x20130428,0x25a6008c,0x69d90364}},	//   _dàhù, _aixi_, _gool_, nnwe,
   {{0x09a7007d,0x20130188,0x64a52c11,0xdbc600aa}},	//   _खवैय, _bixi_, _фала, mööb,
   {{0x2d822c12,0x44072c13,0x7c2d2c14,0x21f90094}},	//   _sake_, _учеб, dpar, bého_,
   {{0x2d822c15,0x442d2c16,0x76432c17,0x7c2d2c18}},	//   _pake_, lpe_, nsny, epar,
   {{0x65692c19,0x60000149,0x201b2c1a,0x69d901c0}},	//   nfeh, döme, _fuqi_, jnwe,
   {{0x90c302fd,0xfaf80029,0x442d0c56,0x7c2d2c1b}},	// [2140] _объе, _šī_, npe_, gpar,
   {{0xdb1c0501,0x442d2c1c,0x7a0c01d4,0xe81d0251}},	//   _områ, ipe_, _işti, _पढ़ा_,
   {{0x6da60581,0x2d820054,0x65b50244,0x387f2c1d}},	//   _дина, _take_, _náho, _asur_,
   {{0xa96a007e,0x442d2c1e,0x673a23ff,0x2d82006c}},	//   рида_, kpe_, _setj, _uake_,
   {{0x7c2d009c,0x661a2c1f,0x7a400065,0x673a2c20}},	//   cpar, _sutk, _bátá, _petj,
   {{0x661a00c2,0x25a6019a,0xe7930291,0x395f009c}},	//   _putk, _sool_, дишњ, _ecus_,
   {{0xd5ba1102,0x8f9b00f5,0x442d0185,0x673a2c21}},	//   иси_, ייסי, epe_, _vetj,
   {{0x21f90c01,0x746a2c22,0x77b400b3,0x00000000}},	//   vého_, аров_, _tàxo, --,
   {{0x7643005c,0x442d0270,0x7c290c2f,0x65b500d2}},	//   asny, gpe_, _çert, _táhn,
   {{0x661a2c23,0x21f90579,0xe73700d3,0x3160173c}},	//   _tutk, tého_, _меу_, _aciz_,
   {{0x25a62c24,0x741400cd,0x442d2c25,0xe57a008f}},	//   _tool_, _کوتا, ape_, _взе_,
   {{0x21f90074,0xd46a2c26,0x442d03a9,0x00000000}},	//   rého_, _виде_, bpe_, --,
   {{0x38662c27,0x65b515bf,0x9f4e0146,0x7c2d2c28}},	//   ntor_, _záho, šným_, xpar,
   {{0xa91d013f,0xb4c80521,0x9f5a06a3,0x38662c29}},	//   _maža, ोपी_, _sipò_, itor_,
   {{0xa91d031a,0x20132c2a,0x6602063d,0x38660216}},	//   _laža, _vixi_, _khok, htor_,
   {{0x65b5033d,0xd3780034,0x22510031,0xdd982c2b}},	//   _náhl, leć_, ázke_, ошу_,
   {{0xa91d02e6,0xf1bf0037,0x3a2a0bb6,0x3866023b}},	// [2150] _naža, mhá_, _atbp_, jtor_,
   {{0x7c2d2c2c,0x66020085,0x2b4a03a8,0xf1bf2c2d}},	//   rpar, _lhok, _cdbc_, lhá_,
   {{0x7a400080,0x37d00033,0x76580350,0x00000000}},	//   _rátá, াকার, juvy, --,
   {{0xa3ca0469,0x195902e3,0xbd6b1ad1,0x4e7a00c1}},	//   रोत_, сады_, _трое_, _פארצ,
   {{0xf1b400a1,0x76430167,0x69d902db,0x00000000}},	//   וסף_, wsny, rnwe, --,
   {{0xa91d2c2e,0xec3600ca,0x66022c2f,0x31a20094}},	//   _daža, _מאשר_, _ahok, _dózy_,
   {{0x6602101e,0x38662c30,0x9aa513c3,0xc9772c31}},	//   _bhok, ator_, _عمرو, _وارث,
   {{0x31790067,0x66022c32,0xdb07023b,0x65b5035d}},	//   jesz_, _chok, _lojë, _váho,
   {{0x442d2c33,0x38662c34,0x764302ae,0x31790103}},	//   upe_, ctor_, ssny, desz_,
   {{0x75d300d3,0x65692c35,0x76432c36,0x1b1d0033}},	//   văzu, sfeh, psny, _পড়তে_,
   {{0x656902e2,0x65151a13,0x00000000,0x00000000}},	//   pfeh, _فوائ, --, --,
   {{0x442d0b65,0x216a2c37,0xd5b801d3,0x91fd00e8}},	//   ppe_, щими_, _stāv_, stān,
   {{0xbcfb01dc,0x43951605,0xd37800c4,0x00000000}},	//   _mbés, _надс, beć_, --,
   {{0x66092c38,0x35d1009f,0x21f20094,0x1c1f00aa}},	//   lmek, _तगड़, váhu_, _बढ़ल_,
   {{0xa3b81f11,0x59bd02d5,0xbcfb020d,0x00000000}},	//   _ظاهر_, ्फार, _obés, --,
   {{0x317900a5,0xf1bf025b,0x9c260d5e,0x66092c39}},	//   cesz_, chá_, здад, nmek,
   {{0x90460037,0x25bf00dc,0x60002c3a,0x1d072c3b}},	// [2160] _عنده, ihul_, römb, зети_,
   {{0xdb070052,0x66090e5b,0xa91d2c3c,0x00000000}},	//   _gojë, hmek, _raža, --,
   {{0x66092c3d,0xa91d00cc,0x200a0063,0x2eff0022}},	//   kmek, _saža, mmbi_, ƙufa_,
   {{0x38662c3e,0x58862787,0x25bf2acb,0xa91d0138}},	//   ttor_, зыка, jhul_, _paža,
   {{0xd90d09b4,0x660900bc,0xc18d006e,0x91fd00e8}},	//   لیف_, dmek, יטאָ, dtāl,
   {{0x66022c3f,0x38662c40,0xa91d005f,0xaa462c41}},	//   _shok, rtor_, _važa, _негл,
   {{0x7bce2c42,0x3e8702c6,0xd3780880,0x200a06b0}},	//   _imbu, mítá_, već_, imbi_,
   {{0xbcfb2c43,0x9adb00a1,0x38660ab0,0x25bf2c44}},	//   _ibér, _החלט, ptor_, ghul_,
   {{0xa91d0039,0x6d4b0037,0x386600b3,0x00000000}},	//   _kažn, ógai, qtor_, --,
   {{0xad9b0019,0x644f2c45,0x00000000,0x00000000}},	//   _nhún, ácia, --, --,
   {{0x7bce02e7,0xdcfd01d3,0x21790fe9,0x66022c46}},	//   _mmbu, _masā, ойны_, _thok,
   {{0xa91d042d,0x80ab0081,0x25bf2c47,0x7bce0042}},	//   _lažn, _চেষ্, chul_, _lmbu,
   {{0x4420002d,0x26091362,0xbcfb2c48,0x00000000}},	//   _îi_, ागरी_, _océa, --,
   {{0xad9b00ef,0xefc82c49,0x03a3060b,0xf09f00ee}},	//   _chún, пуск_, _пичо, rxà_,
   {{0xdb070113,0xad9b0076,0x00000000,0x00000000}},	//   _gojè, _dhún, --, --,
   {{0x40ee06c0,0x22f700a1,0x9df907bf,0x63aa14bd}},	//   ọrọ_, _מזון_, інат_, _hofn,
   {{0xa91d013f,0xbcfb0139,0x6285003e,0xc1050076}},	// [2170] _bažn, _abér, _áhor, _توظي,
   {{0xbcfb033c,0x91fd00e8,0xad9b033c,0x00000000}},	//   _ccéa, itām, _ghún, --,
   {{0xa91d01b3,0xfe24007b,0x00000000,0x00000000}},	//   _dažn, _пьян, --, --,
   {{0x7bce2c4a,0x6aaa0222,0x63aa0178,0x7af500d2}},	//   _embu, äffa, _lofn, _vyzt,
   {{0x81b003e3,0x2d992c4b,0xdcfd00e8,0x00000000}},	//   _jiɓa, _inse_, _fasā, --,
   {{0xab842c4c,0xbcfb00e3,0xbcb600ca,0x75f70231}},	//   _пуск, _gcéa, _חפשו_, mãzi,
   {{0x66092c4d,0x25bf2c4e,0xbcfb0af0,0x00000000}},	//   tmek, thul_, _gbér, --,
   {{0x2d892c4f,0x75fe023b,0x6d5f019f,0x9f4a13c6}},	//   ndae_, tëza, ngqa, robé_,
   {{0x91fd0029,0x66092c50,0x394d00cc,0x44392c51}},	//   rtāl, rmek, _ides_, ès_,
   {{0x63aa0150,0xe3b10037,0x65620231,0x25bf0ac1}},	//   _cofn, ئرة_, _ecoh, shul_,
   {{0x91e62c52,0x2d992c53,0x61ef0503,0x2d8902ac}},	//   доне, _onse_, focl, kdae_,
   {{0x44b52c54,0xa91d0138,0x600002c3,0x00000000}},	//   _обес, _mažo, döma, --,
   {{0xa3ca034d,0xa91d00cc,0x2d890f5a,0x00000000}},	//   रोह_, _lažo, ddae_, --,
   {{0x2d992c55,0x3fcc0081,0x63aa00f0,0x98ad0031}},	//   _anse_, লক্ষ, _gofn, _oceľ_,
   {{0x394d08a9,0xa91d0b18,0x248d2c56,0xdb1e0052}},	//   _odes_, _ražn, lvem_, shpë,
   {{0xbcfb00e3,0x394d03a9,0x70ef0294,0x2176036c}},	//   _scéa, _ndes_, ụrụi, _цукр,
   {{0xa91d03ce,0xdcfd0029,0x64460335,0x3a2d1523}},	// [2180] _pažn, _pasā, škiv, _čepa_,
   {{0x973c2c57,0x2d992c58,0x394d00b3,0x6b87007e}},	//   _voćk, _ense_, _ades_, _cajg,
   {{0xa91d02e6,0x00000000,0x00000000,0x00000000}},	//   _važn, --, --, --,
   {{0xe8fa2c59,0x394d0231,0xa91d2c5a,0x00000000}},	//   оле_, _cdes_, _dažo, --,
   {{0x6b872c5b,0x394d030a,0xa91d1405,0x00000000}},	//   _fajg, _ddes_, _tažn, --,
   {{0x6d442c5c,0x394d0084,0xc5f82c5d,0x7bce0201}},	//   laia, _edes_, ुष्य_, _umbu,
   {{0xd90d0068,0x5a55013d,0xba232c4c,0x00000000}},	//   لیہ_, _пъту, _адск, --,
   {{0x77b40472,0x6d442c5e,0x1dde2c5f,0x973c09ac}},	//   _màxi, naia, नचित, _moći,
   {{0x628300f9,0x186a117c,0x00000000,0x00000000}},	//   _asno, _фази_, --, --,
   {{0x6d4401e9,0x69c22c60,0x69b40096,0xa91d0880}},	//   haia, lhoe, _आवडी, _lažl,
   {{0x6d4406ee,0x973c00cc,0x452a00ae,0xc7d70289}},	//   kaia, _noći, _джен_, _קובי_,
   {{0x850606f6,0x22510579,0x69c22c61,0xa194224a}},	//   _قوان, ázka_, nhoe, ваюч,
   {{0x6d442c62,0x64b60182,0x3c2400a7,0x4613001c}},	//   daia, _تحار, _növ_, _شوهر,
   {{0x7bde0381,0x00000000,0x00000000,0x00000000}},	//   jnpu, --, --, --,
   {{0x05b20789,0x6d441789,0xafdb00f3,0x69c21cab}},	//   _जवाब, faia, lsøk, khoe,
   {{0xa91d0029,0x6d442c63,0x973c007e,0xe3b80233}},	//   _ražo, gaia, _doći, lkı_,
   {{0x2d890313,0x2616034c,0x69c22c64,0xafdb0ac9}},	// [2190] rdae_, _पूछी_, dhoe, nsøk,
   {{0x2d89057a,0x09d70096,0x69c21570,0xe3b807e7}},	//   sdae_, ढच्य, ehoe, nkı_,
   {{0x6d442c65,0x248d00b6,0xb17b0120,0x63a702c3}},	//   baia, zvem_, pnåd, öjni,
   {{0xd5a62c66,0x69c22c67,0xafdb00f3,0x6d44078e}},	//   _صف_, ghoe, ksøk, caia,
   {{0xe7eb007d,0xe3b801e8,0x394d023b,0x6d4f2c68}},	//   टवला_, kkı_, _vdes_, _idca,
   {{0x65bc2c69,0xe79b0076,0xafdb0170,0xd7c81cc8}},	//   _réha, تخصص_, dsøk, وونه_,
   {{0x65bc01dc,0x00000000,0x00000000,0x00000000}},	//   _séha, --, --, --,
   {{0x394d21d5,0x91fd00d9,0xff1800ca,0x644f0031}},	//   _udes_, stāj, וקות_, ácio,
   {{0xa924025b,0x60000149,0x799b0d2a,0x00000000}},	//   _úžas, dömn, _inuw, --,
   {{0xf7702c6a,0xb6050146,0xa3ca2853,0x656000e3}},	//   _نام_, dnáš, रोल_, agmh,
   {{0xeb920130,0xe2992c6b,0x79890113,0x00000000}},	//   אָר_, чан_, _kaew, --,
   {{0xdb070102,0x1df902d5,0xcb120327,0x56b6006e}},	//   _hljó, ंतोष_, טלי_, _אפען_,
   {{0xbcfb2c6c,0x6d440131,0x79890113,0x00000000}},	//   _scén, vaia, _maew, --,
   {{0x6d44063f,0x75292c6d,0xb4cb0336,0x973c0357}},	//   waia, lcez, रछी_, _poći,
   {{0x670f000c,0x64492c6e,0xa91d0039,0x6d442c6f}},	//   ाधिक_, lsei, _pažl, taia,
   {{0x973c00c4,0x442f2c70,0x00000000,0x00000000}},	//   _voći, _ktg_, --, --,
   {{0x64492c71,0x6d442c72,0x6b5600e3,0x9f4a015e}},	// [21a0] nsei, raia, فضائ, lobí_,
   {{0x6d442c73,0x7c2b2c74,0x644901ec,0xaca40134}},	//   saia, ígra, isei, _nrụt,
   {{0xc0a900bf,0x6d441a47,0x69c22c75,0x443d2c76}},	//   _فایل_, paia, thoe, _lww_,
   {{0xdca62249,0x68460642,0x394000e3,0xaca40134}},	//   _зами, енда, úis_, _arụt,
   {{0x69c204e2,0x2ac60065,0x201a024a,0xad1b00ca}},	//   rhoe, _bíbé_, _kipi_, _מוכר,
   {{0x64492c77,0x61e41100,0xc7a32549,0x69c201d0}},	//   dsei, _ljil, личк, shoe,
   {{0x644b0578,0x69c22c78,0x201a03a9,0x442f07ee}},	//   _avgi, phoe, _mipi_, _atg_,
   {{0x38cb00d0,0x9f4a0363,0x75fe00dd,0xa91d0087}},	//   _کافی_, dobí_, rëzo, _lažj,
   {{0x69c02c79,0x91fd00d9,0x3946001c,0xdb072c7a}},	//   _ilme, stāk, maos_, _fljó,
   {{0xa3ca0d1b,0x61e4068d,0x442f0808,0xafdb00d6}},	//   रों_, _ajil, _dtg_, rsøk,
   {{0xe3b803a3,0x443d00f9,0x969601b6,0xa281001c}},	//   rkı_, _eww_, _яраш, لیوو,
   {{0x644902e2,0x39462c7b,0x7529028d,0xe3b8026a}},	//   bsei, naos_, ccez, skı_,
   {{0xecd002d5,0x61e42c7c,0x201a00c4,0x443d0381}},	//   _सेलफ, _djil, _bipi_, _gww_,
   {{0x6d4f1df6,0x64460087,0x24860027,0xa91d0141}},	//   _sdca, škis, _isom_, _ražm,
   {{0x69c02c7d,0x7c2f0381,0x39460324,0xb60500d2}},	//   _olme, _stcr, kaos_, snáš,
   {{0x61e4023b,0x39462c7e,0x00000000,0x00000000}},	//   _gjil, jaos_, --, --,
   {{0x6ad900c3,0x39462c7f,0xa01b0c19,0x3209020b}},	// [21b0] भप्र, daos_, rvös, _ihay_,
   {{0x69c02c80,0xdb150072,0x61fd2c81,0x973c00c4}},	//   _alme, _alzá, llsl, _koću,
   {{0x29040239,0x32090023,0x2a780027,0xb7b500fe}},	//   _azma_, _khay_, _cprb_, _lịc,
   {{0x28d22c82,0x248600e7,0x201a2c83,0x3237006e}},	//   _देहि, _osom_, _zipi_, גטאן_,
   {{0x69c0009c,0x50b30c38,0x63ba010a,0x00000000}},	//   _dlme, ुनिष, kktn, --,
   {{0x2d8b0f71,0x9a872c84,0x69c02c85,0xa91d013f}},	//   _hace_, _публ, _elme, _kažk,
   {{0x2d8b2c86,0x973c015c,0xdb071405,0x600002c3}},	//   _kace_, _noću, _kojí, döml,
   {{0x64492c87,0x2d8b08a9,0x442f18c4,0x69c0009c}},	//   tsei, _jace_, _ptg_, _glme,
   {{0x2d8b006d,0x75290451,0xb4cb00a3,0xdb072c88}},	//   _mace_, rcez, रछे_, _mojí,
   {{0x61f625c5,0x64492c89,0x3209008a,0xb7b500fe}},	//   _skyl, rsei, _ahay_, _dịc,
   {{0x13090084,0xa2e501b6,0x320900f9,0x920d0034}},	//   ьной_, тонд, _bhay_, सगंज_,
   {{0x442f2c8a,0x201a06a8,0x32092c8b,0x9f4a1515}},	//   _ttg_, _sipi_, _chay_, robí_,
   {{0x9f4a025b,0x644603da,0x442f2c8c,0x7bd701ff}},	//   sobí_, škir, _utg_, kixu,
   {{0x2b43033b,0x61fd0381,0x00000000,0x00000000}},	//   _nejc_, alsl, --, --,
   {{0x201a2c8d,0x2d8b0044,0xdb071054,0x7bd701ff}},	//   _vipi_, _bace_, _bojí, dixu,
   {{0xc69200f5,0x2d8b00e7,0xdb07034f,0x291f00fe}},	//   סאן_, _cace_, _cojí, _ngua_,
   {{0x201a2c8e,0x2d8b1114,0xab661c4c,0x68fb2c8f}},	// [21c0] _tipi_, _dace_, квал, _nyud,
   {{0x291f2c90,0x2d8b0167,0x6d4b01cd,0xa01b2a6b}},	//   _agua_, _eace_, ógar, svör,
   {{0x68fb0eb8,0xcf570054,0x0f570130,0x2d8b2c91}},	//   _ayud, _בבית_, _ביים_, _face_,
   {{0x2d8b02a4,0x68fb0537,0x7a470103,0x00000000}},	//   _gace_, _byud, _sétá, --,
   {{0x2d80002d,0x39462c92,0x63ba0120,0x1874186f}},	//   meie_, raos_, yktn, угля,
   {{0x2d8b2c93,0x2d80004d,0x7bc5225b,0x7c362c94}},	//   _zace_, leie_, chhu, mpyr,
   {{0xfaa32c95,0x2d8b1114,0xc7b80b14,0x69262c96}},	//   _каро, _yace_, _niđe_, _амба,
   {{0xa2c50d77,0x5e5700c1,0x2d8b0072,0x69c02c97}},	//   ानन्, דיקע_, _xace_, _ulme,
   {{0x68fb2c98,0x29042c99,0x65b500d8,0x00000000}},	//   _gyud, _uzma_, _náhu, --,
   {{0x21200063,0x3209008c,0x394413ea,0x7afc033c}},	//   _agih_, _shay_, _hems_, _kyrt,
   {{0x2d800185,0xd7ef00e3,0xe3af08ba,0x63ba01cb}},	//   keie_, _بكل_, تري_, rktn,
   {{0xb6d900c1,0x2486006c,0x39440294,0xa5da2c9a}},	//   _אַנט, _tsom_, _jems_, _غبار_,
   {{0x2d8b2c9b,0x61fd2c9c,0x00000000,0x00000000}},	//   _race_, rlsl, --, --,
   {{0x2d8b0044,0x040d00fe,0x39440144,0x00000000}},	//   _sace_, _mườn, _lems_, --,
   {{0x32090028,0x2d8b2c9d,0xdb0e023b,0x040d0023}},	//   _thay_, _pace_, _dobë, _lườn,
   {{0x32090270,0x21200113,0xd8482c9e,0x60b50103}},	//   _uhay_, _ggih_, kọ_, _ممبئ,
   {{0x52e2178c,0x00000000,0x00000000,0x00000000}},	// [21d0] _पशुस, --, --, --,
   {{0x1ae70081,0xe1ff2c9f,0x2d8b0044,0xad9b0037}},	//   _করবে_, lló_, _wace_, _mhúi,
   {{0x2d8b006d,0x68fb0a69,0x7afc03a8,0x65b500d4}},	//   _tace_, _syud, _cyrt, _záhu,
   {{0xe1ff0018,0x68fb0270,0xa91d2ca0,0x00000000}},	//   nló_, _pyud, _kaži, --,
   {{0x040d0019,0x7c220037,0x39440180,0xdb0e0154}},	//   _cườn, íort, _dems_, _lobè,
   {{0xa91d013f,0x69d804d4,0x040d00de,0x66e501b6}},	//   _maži, éver, _dườn, лола,
   {{0xf7701fa7,0x39442ca1,0xdb0e05aa,0x7afc03a8}},	//   تان_, _fems_, _nobè, _gyrt,
   {{0x7f450090,0xad9b0503,0x291f0350,0x00000000}},	//   _lehq, _bhúi, _ugua_, --,
   {{0x7afc00dd,0xad9b00e3,0x98680018,0xc7b8042d}},	//   _zyrt, _chúi, _لینے_, _siđe_,
   {{0x69d92ca2,0x52a9193d,0xd7740470,0xa91d00d4}},	//   liwe, евом_, _نامع, _naži,
   {{0xd5750805,0x61462ca3,0x216a2ca4,0xdb0e0052}},	//   _буль, лена, нини_, _robë,
   {{0x60000212,0x69d92ca5,0x9f4a0146,0xe1ff0301}},	//   römm, niwe, dobá_, gló_,
   {{0x753b2ca6,0xe3b3001c,0xad9b033c,0x00000000}},	//   mbuz, _پرش_, _ghúi, --,
   {{0xe1ff034f,0x3eb82ca7,0x645b112f,0x434518d4}},	//   aló_, tyrt_, mrui, _секв,
   {{0x3ebe0088,0xe1ff2ca8,0x69d92ca9,0xe2a800e3}},	//   átt_, bló_, kiwe, _لاين_,
   {{0x69d90051,0x3f8c1e3a,0xd8482caa,0x7bd50350}},	//   jiwe, ždu_, yọ_, _amzu,
   {{0x645b2cab,0x6721033b,0x2d802cac,0xdca30b1e}},	// [21e0] nrui, _oglj, reie_, бати,
   {{0x3ea62cad,0x69d902ac,0x8b262cae,0x645b02ac}},	//   _биог, eiwe, удже, irui,
   {{0x7c362caf,0x645b0037,0x7bcb0216,0xdb1c042c}},	//   spyr, hrui, ëgua, _umrü,
   {{0x91fd0029,0xa91d1b32,0x645b0a9f,0x08c600d3}},	//   stāv, _zaži, krui, лбен,
   {{0x6d4601d3,0x645b0381,0x00000000,0x00000000}},	//   _ieka, jrui, --, --,
   {{0x91fd0029,0x6d462cb0,0x645b2cb1,0xa63400d6}},	//   ltāt, _heka, drui, анкі,
   {{0x2605007d,0x6d462cb2,0xf1c1025b,0xad9b0076}},	//   _हीही_, _keka, ášky_, _shúi,
   {{0x54542cb3,0x645b2cb4,0x040d0019,0x6d462cb5}},	//   авит, frui, _tườn, _jeka,
   {{0xa2d92cb6,0x973c0095,0x645b112f,0x136a008f}},	//   _फेब्, _anće, grui, ншни_,
   {{0x1ae70f71,0x6d462cb7,0x42742cb8,0x7c262cb9}},	//   _করতে_, _leka, агос, _mukr,
   {{0xb3450161,0x75fe0052,0xd377004b,0xa3ca2cba}},	//   _seçã, hëzi, учы_, रोग_,
   {{0x6d462cbb,0x645b2cbc,0x04462cbd,0x0ecf00bc}},	//   _neka, brui, _бедн, _हेगड,
   {{0x645b2cbe,0xa91d013f,0x10742cbf,0x7c262cc0}},	//   crui, _paži, бляю, _nukr,
   {{0xa3e82087,0x92942cc1,0x69d92cc2,0x53342cc3}},	//   _यदि_, _вакц, ziwe, _тект,
   {{0x6d462cc4,0x4426068d,0xdd9b2cc5,0xa91d013f}},	//   _beka, _huo_, нша_, _važi,
   {{0x6d462cc6,0x4426013f,0x7c262cc7,0x628a0078}},	//   _ceka, _kuo_, _bukr, _isfo,
   {{0x62982cc8,0x44262cc9,0xa3e82cca,0x41c408ba}},	// [21f0] _hrvo, _juo_, _यदा_, _دقيق,
   {{0xf1bf00b6,0x7c260138,0x6d462ccb,0x69d8014b}},	//   lká_, _dukr, _eeka, èven,
   {{0x6d462ccc,0x3f830095,0x44262ccd,0x69d92cce}},	//   _feka, meju_, _luo_, tiwe,
   {{0x195900c6,0xf1bf2ccf,0x3ebe1484,0x893700e3}},	//   тады_, nká_, øtte_, اعضا,
   {{0x442608a1,0x69d92cd0,0xb7b50174,0x386d0231}},	//   _nuo_, riwe, _dịn, _qqer_,
   {{0x6d462cd1,0x65b50074,0x62980018,0xd2461a13}},	//   _zeka, _náhr, _orvo, _ون_,
   {{0x6d462cd2,0x7982002b,0x00000000,0x00000000}},	//   _yeka, beow, --, --,
   {{0x44262cd3,0x6442010a,0x6b8e01c2,0x7c26010a}},	//   _buo_, _bwoi, _zabg, _yukr,
   {{0x629802fd,0x442604a3,0x05a60084,0xf1bf0146}},	//   _arvo, _cuo_, рвый_, dká_,
   {{0xf7730dd0,0x645b2cd4,0x6721005f,0xe2990291}},	//   _دار_, rrui, _uglj, вао_,
   {{0x62980580,0x645b2cd5,0xd5ae015a,0x59b91b11}},	//   _crvo, srui, سفی_, _आवार,
   {{0x629808a9,0x645b2cd6,0x22582cd7,0x947900ae}},	//   _drvo, prui, árka_, _аску_,
   {{0x6d4603ce,0x628a2b2a,0x62980126,0x03a52cd8}},	//   _reka, _esfo, _ervo, _вило,
   {{0x6d4610e3,0x91fd00d9,0x4ab502d5,0xbcfb0076}},	//   _seka, tuāc, ंहाव, _gcéi,
   {{0x7c262cd9,0x44260294,0xf233001c,0x629e0231}},	//   _sukr, _zuo_, _ابتک, _àpop,
   {{0xf1bf0871,0x65b50181,0x3dc91ef8,0x25bf2cda}},	//   cká_, _záhr, ghaw_, nkul_,
   {{0xd7c50096,0x0b462cdb,0xab2a193d,0xa91d00c4}},	// [2200] वसाच, инан, воза_, _kažu,
   {{0x75fe00dd,0x91fd01d3,0x6d462cdc,0x29db0174}},	//   rëzi, grāf, _weka, ụala_,
   {{0x6d460706,0xbea62cdd,0xa9262cde,0xae1f009f}},	//   _teka, _танк, адел, _मंचन_,
   {{0x25ad2cdf,0xd37809ac,0xda650037,0x6d460113}},	//   jjel_, miće_, صامي, _ueka,
   {{0xd3780ca7,0x83fd0103,0xe8942246,0x63a401c2}},	//   liće_, ntős, саль, _ɗinb,
   {{0x91fd0b4b,0xd90d00d0,0x442600ac,0x75220036}},	//   ntār, ریل_, _ruo_, _sgoz,
   {{0x44260465,0x4b7b09c1,0x64420067,0xd37803d6}},	//   _suo_, _שאלו, _swoi, niće_,
   {{0x2d9214b1,0xbcfb00e3,0x44262ce0,0xa3d30251}},	//   ndye_, _scéi, _puo_, सोस_,
   {{0x81b003e3,0xa91d007e,0x98bd007f,0x3a2d0141}},	//   _giɓi, _sažv, tawą_, _čepi_,
   {{0x62980954,0xa5070291,0xd37800c4,0xa91d00c6}},	//   _prvo, шења_, kiće_, _pažv,
   {{0xe7e3007d,0x3f830138,0xf1bf035d,0xd37809ac}},	//   कचरा_, veju_, tká_, jiće_,
   {{0x44262ce1,0x28db143d,0x644200a5,0xd37801ac}},	//   _tuo_, _मेडि, _twoi, diće_,
   {{0xe3af0177,0xdb0e01e8,0x75d30037,0xf1bf2ce2}},	//   سری_, _albü, _بينا, rká_,
   {{0xf1bf0074,0x33f32ce3,0xbcfb0065,0xd3780559}},	//   ská_, _وسوس, _gbéy, fiće_,
   {{0x3dc92ce4,0x3f832ce5,0x24520103,0x00000000}},	//   thaw_, reju_, _انڈس, --,
   {{0x3dc907ac,0x3f832ce6,0x3ead0357,0x00000000}},	//   uhaw_, seju_, ćet_, --,
   {{0x91fd00d9,0x26e20034,0xa3da00c3,0x4c94007b}},	// [2210] stās, गपुर_, _ठगा_, оитс,
   {{0x3dc9006c,0x60c01484,0xd3780542,0x2ca90188}},	//   shaw_, ømme, biće_, rxad_,
   {{0x200300e9,0x6e950080,0x3a750221,0xad9b033c}},	//   mlji_, _الجا, слер, _bhút,
   {{0x628600a5,0xdb0e034f,0xaa58022f,0xad9b033c}},	//   łkow, _albó, рицу_, _chút,
   {{0x9f51030b,0x182113ae,0x260a148e,0xb4e5007f}},	//   hozí_, मदेव_, ातनी_, _नशे_,
   {{0x600000c2,0xdb1c009c,0x26e20096,0x68190154}},	//   tömi, _flrà, गपूर_, _kňdi,
   {{0x7c2d2ce7,0x200300e7,0x7bc7009e,0x75fe0216}},	//   lqar, ilji_, _ilju, hëzu,
   {{0x59f90084,0x39400088,0x77bd0428,0xc7b80995}},	//   _себя_, ðist_, _mèxi, _viđa_,
   {{0x7bc703f1,0x26c10181,0x38600013,0x25bf16cf}},	//   _klju, šho_, àirt_, rkul_,
   {{0x25bf2ce8,0xd6db2ce9,0x68e40037,0x00000000}},	//   skul_, _ите_, úide, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xd3782cea,0xd5430139,0xad9b0076,0x930d0233}},	//   viće_, _dẹ̀d, _mhús, _ışık,
   {{0x7bc72ceb,0x34ab0037,0x61e603bd,0x75fe0216}},	//   _olju, _جداً_, rnkl, gëzu,
   {{0xd3780335,0x65690eb3,0x6d4b003e,0x9f580052}},	//   tiće_, lgeh, ðgan, morë_,
   {{0xed5a062a,0xada621a1,0x6da61d3f,0x75fe023b}},	//   лов_, бавл, бива, rëzv,
   {{0x65692cec,0xd3780335,0xb14600d3,0x29db0134}},	//   ngeh, riće_, _унил, ụaja_,
   {{0xdca321be,0xd378077e,0x7bc700cb,0x9f58023b}},	// [2220] пати, siće_, _blju, norë_,
   {{0x65bc025a,0x7f8600e3,0xd3780335,0x61180139}},	//   _véhi, _الدن, piće_, _e̟lò,
   {{0xdb0e05aa,0x387f01e9,0x7c2d041c,0x1617110d}},	//   _albò, _apur_, aqar, दगार_,
   {{0x27e90037,0x9f58023b,0xdb1c0212,0x6569029a}},	//   éann_, korë_, _omrö, jgeh,
   {{0x28d21efb,0xfbd10103,0xa2d909b0,0xb4d600c3}},	//   _देखि, ستے_, _फेस्, _सधे_,
   {{0xab270058,0x207b0266,0xfaa60836,0x00000000}},	//   _гора_, ראסא, _лаго, --,
   {{0x7bde2ced,0x8f9b00a1,0x65692cee,0x2b4a2cef}},	//   mipu, טיסי, fgeh, _iebc_,
   {{0x7bde0706,0x69cb20a0,0x65690a2c,0x743400d3}},	//   lipu, chge, ggeh, ониф,
   {{0xc34a2cf0,0xdb0e0131,0x387f009c,0x00000000}},	//   ляне_, _mobí, _gpur_, --,
   {{0x7bde0979,0x32540c58,0xd62a2cf1,0x66e62cf2}},	//   nipu, овор, _боже_, _лоза,
   {{0xd5af160f,0x20031271,0x38660063,0xc205007f}},	//   _ес_, vlji_, luor_, रतलब_,
   {{0x645d0fb6,0x7bde00cd,0xba9b0341,0x69c22cf3}},	//   ásic, hipu, אסטי, nkoe,
   {{0x7bde2cf4,0x2bfa0285,0x107406c4,0x644f0143}},	//   kipu, ्तां_, пляю, ácit,
   {{0x75fe0052,0xb4e40179,0x02a62cf5,0x8f340221}},	//   rëzu, फपी_, _грим, зерц,
   {{0x7bde2cf6,0x91fd00d9,0x7de50138,0x637700a1}},	//   dipu, trād, lėsi, _הגוף_,
   {{0x1ae70081,0x7c2d2cf7,0x7bc70995,0x7bcb00e8}},	//   _করলে_, tqar, _slju, īgum,
   {{0x2003005f,0xcf8e00cd,0x22ae0092,0xdb0e033d}},	// [2230] plji_, رژی_, dəki_, _dobí,
   {{0x7bde2cf8,0x61ed2085,0xad9b00e3,0x2bbb0037}},	//   gipu, _hjal, _chúr, دارة_,
   {{0x387f2cf9,0xc33300ca,0x7bc7033b,0x61ed01cd}},	//   _spur_, פוף_, _vlju, _kjal,
   {{0x39492cfa,0x2b58039f,0x38662cfb,0x7bde18f0}},	//   úas_, _edrc_, fuor_, aipu,
   {{0x7c2d0090,0x27e904d8,0x61ed2cfc,0xdd9800ae}},	//   qqar, éano_, _mjal, _ушэ_,
   {{0x7bc71197,0x98482787,0xad9b0503,0xdb0e00ae}},	//   _ulju, сяца_, _thús, _dobâ,
   {{0x61ed2cfd,0x65692cfe,0x3ffc006e,0xa01b0364}},	//   _ojal, tgeh, אפגע, rwöh,
   {{0xe459215f,0x61ed2cff,0x9f58023b,0x8beb0033}},	//   ажи_, _njal, torë_, _কঠিন_,
   {{0x65692d00,0x69c92d01,0x2919020d,0xb3c900d3}},	//   rgeh, _ilee, _àsa_, илиз_,
   {{0xa3d3000f,0x61ed2d02,0xd7fb2d03,0x394f0088}},	//   सों_, _ajal, _суб_, lags_,
   {{0xf77011a2,0x69c92d04,0x9f58023b,0x00000000}},	//   _سال_, _klee, sorë_, --,
   {{0x216a08d1,0x3860042d,0xb1da004d,0x7de5004b}},	//   шими_, šire_, рьох_, bėsi,
   {{0x61ed2d05,0x69c900e7,0xdb0e0031,0x3f930062}},	//   _djal, _mlee, _robí, _baxu_,
   {{0xee3a2d06,0xd9b62b8a,0x69c22d07,0xa3cd0179}},	//   инг_, _अक्ट, zkoe, _रति_,
   {{0x61ed2d08,0x69c92d09,0x80db0081,0x9f58014b}},	//   _fjal, _olee, _যুদ্, noré_,
   {{0x61ed2d0a,0x8066225a,0x22510074,0xe1f200cd}},	//   _gjal, _движ, ázku_, _تست_,
   {{0x7bde2d0b,0xd3780039,0x394f2d0c,0x3f9300d8}},	// [2240] tipu, lića_, dags_, _faxu_,
   {{0x69c92d0d,0x69db0a43,0xb7b50134,0x61ed007e}},	//   _alee, _amue, _dịk, _zjal,
   {{0x7bde2d0e,0xd378005f,0xdb0e1ba6,0x8eb30018}},	//   ripu, nića_, _tobí, _ہمیش,
   {{0x7bde2d0f,0x0906002d,0x7ae30037,0xa9672440}},	//   sipu, опен, únta, жица_,
   {{0x69c22d10,0x91fd00d9,0x7bde00cd,0xd3782d11}},	//   rkoe, duāl, pipu, hića_,
   {{0x69c92d12,0xa09b0341,0xd3780335,0x69c22d13}},	//   _elee, יינט, kića_, skoe,
   {{0xeb910130,0xd37801ac,0x3a2a0124,0xa3bf00aa}},	//   _אָן_, jića_, _uubp_, ीसन_,
   {{0xd37800e9,0x35f700d1,0x00000000,0x00000000}},	//   dića_, يريد_, --, --,
   {{0xb7e625d6,0x249d030a,0x61ed00bd,0x38660158}},	//   _джак, _crwm_, _rjal, quor_,
   {{0x61ed2d14,0xd3780106,0x9f5800fd,0x7de50138}},	//   _sjal, fića_, boré_, rėsi,
   {{0x69c90084,0xd3781197,0x27fc02ef,0x67280dd9}},	//   _ylee, gića_, movn_, _igdj,
   {{0xfec20033,0x20180216,0x00000000,0x00000000}},	//   োপাধ, emri_, --, --,
   {{0xa5071121,0xc953040a,0x60f81402,0x7bdc2d15}},	//   _деца_, ומר_, жняя_, _omru,
   {{0xcf2700e3,0xd3780106,0x42550018,0x00000000}},	//   ترحي, bića_, _کنٹر, --,
   {{0xcddb2d16,0x61ed003e,0x91fd01d3,0xd37809ac}},	//   ања_, _tjal, grāc, cića_,
   {{0x7bdc2d17,0x61ed00d8,0xad9b00da,0xdda800d3}},	//   _amru, _ujal, _chúp, отул_,
   {{0x61fd2d18,0x7e67023e,0xbcfb016f,0x00000000}},	// [2250] mosl, sujp, _acér, --,
   {{0x69c92d19,0x7a330090,0x91fd01d3,0x9f43034f}},	//   _slee, _aħta, zuāl, rojó_,
   {{0x69c92d1a,0x8ae702ec,0xaa9500e3,0x394f2d1b}},	//   _plee, ціал, ثلاث, tags_,
   {{0x61fd2d1c,0xbcfb0220,0x160a0034,0xfbdf00eb}},	//   nosl, _dcér, _हीलर_, _gwên_,
   {{0x69c903ee,0x21290124,0xe73902b3,0x394f2d1d}},	//   _vlee, _mgah_, бел_, rags_,
   {{0x290402ad,0x61fd00d4,0x00000000,0x00000000}},	//   _dyma_, hosl, --, --,
   {{0x6fc20220,0x91fd00d9,0x21292d1e,0x61fd0d95}},	//   _dôch, tuāl, _ogah_, kosl,
   {{0xd37800e9,0xd90e0068,0x2d8903a9,0x2129061d}},	//   vića_, ئیے_, neae_, _ngah_,
   {{0x478b0084,0x00000000,0x00000000,0x00000000}},	//   _всем_, --, --, --,
   {{0xd3781419,0x63b8023e,0x25a60072,0x394d0188}},	//   tića_, _covn, _enol_, _hees_,
   {{0x88bd0081,0x7bc52d1f,0x9f4e033d,0x6b95129d}},	//   _অধিক, ikhu, áním_, _mazg,
   {{0xd3780039,0x200102e7,0xdb070139,0x6b950062}},	//   rića_, _akhi_, _bojú, _lazg,
   {{0x64a52d20,0x394d2d21,0xd9bd0081,0xd3780106}},	//   _хала, _mees_, _আগাম, sića_,
   {{0x394d2d22,0x437507a6,0x443f1bd6,0xdd92110a}},	//   _lees_, _זײַן_, mpu_, کور_,
   {{0x443f2d23,0x60120088,0x61fd2d24,0xc332006e}},	//   lpu_, væmd, bosl, _אוו_,
   {{0x394d022e,0xc8bd0e72,0xb7b50134,0x62832d25}},	//   _nees_, ्नाट, _dịi, _ipno,
   {{0x443f0154,0x6b950234,0xdd8f097d,0xafe600ae}},	// [2260] npu_, _bazg, دوق_, _ноил,
   {{0x6000173a,0x3a242d26,0xa09b0089,0x2bc10096}},	//   röms, _simp_, _פייט, _शकणा,
   {{0x394d2d27,0xc7b80995,0x3f8a03a9,0x00000000}},	//   _bees_, _rođ_, mebu_, --,
   {{0x2d892d28,0xa96a0c3f,0x3f8a2d29,0x394d2d2a}},	//   ceae_, сида_, lebu_, _cees_,
   {{0x6d441763,0x394d2d2b,0xbcfb0139,0x68430c2b}},	//   mbia, _dees_, _adéf, енча,
   {{0x6d44013f,0x3f982d2c,0x6e260270,0x628318f0}},	//   lbia, ndru_, _hikb, _opno,
   {{0x3a240012,0x63b80074,0xd9461a54,0x2bc10096}},	//   _timp_, _rovn, _неви, _शकता,
   {{0x394d0f87,0x6fcb0367,0x3f8a2d2d,0x6d442d2e}},	//   _gees_, _müca, hebu_, nbia,
   {{0x443f0270,0x6b952d2f,0x3f8a2d30,0xd49700ae}},	//   gpu_, _yazg, kebu_, прэ_,
   {{0x63ad01c2,0x6027020d,0x260a0096,0x3f8a14f3}},	//   _ɗang, hémè, ातही_, jebu_,
   {{0x394d0197,0x61fd2d31,0x7d060f5a,0xd6c4001c}},	//   _yees_, tosl, _lyks, _تمای,
   {{0x394d01fa,0x25a60150,0xdceb033b,0x3f9801d3}},	//   _xees_, _unol_, _žičn, edru_,
   {{0x61fd2d32,0x64a32d33,0x66020032,0x77bd0428}},	//   rosl, _паца, _ikok, _tèxt,
   {{0xb7bd002d,0x3f8a2d34,0x00000000,0x00000000}},	//   _puţi, gebu_, --, --,
   {{0x644004e2,0xbcfb0072,0xddd00fb0,0xd37800c4}},	//   lpmi, _acép, _šeši, lićo_,
   {{0x6d442d35,0x00000000,0x00000000,0x00000000}},	//   gbia, --, --, --,
   {{0x394d2d36,0x6e2602ac,0x7de500c6,0x66020a3d}},	// [2270] _rees_, _dikb, dėst, _mkok,
   {{0xfe6e14df,0x60cf07aa,0xbca40037,0x7dca0094}},	//   دگی_, ınmı, عملي, _výsa,
   {{0x6d442d37,0x66022d38,0x394d2d39,0x6b95026a}},	//   bbia, _okok, _pees_, _vazg,
   {{0x394d022e,0x3ebe2d3a,0x66022d3b,0x3eac0170}},	//   _qees_, ätte_, _nkok, ådte_,
   {{0x394d2d3c,0x315800c1,0x6b950141,0x00000000}},	//   _vees_, ליאן_, _tazg, --,
   {{0x394d040c,0x66020d79,0xbcfb0032,0x6d4f2d3d}},	//   _wees_, _akok, _adég, _heca,
   {{0x6d4f1084,0x996700ae,0x9f5e014b,0x00000000}},	//   _keca, _нтал, ôté_, --,
   {{0x84592d3e,0x7c272d3f,0x6e380103,0x3860042d}},	//   орот_, _hijr, _évbe, šira_,
   {{0x855400cd,0x6f0900b6,0x6add0a50,0x00000000}},	//   ریور_, řech, _मधुर, --,
   {{0x6d4f2d40,0x443f2d41,0x798b2d42,0x00000000}},	//   _leca, rpu_, legw, --,
   {{0x7c2f0a29,0xa18a1147,0x6d4400f0,0x6d5d0edb}},	//   _lucr, обна_, ybia, _odsa,
   {{0x443f0cbc,0x6d4f2d43,0x798b00f0,0x3f8a2d44}},	//   ppu_, _neca, negw, webu_,
   {{0x661b2d45,0xc4fb00cd,0x66092d46,0x9554001c}},	//   mmuk, _اعضا_, mlek, _سخنا,
   {{0x661b2d47,0x7d062d48,0x443d00fc,0x00000000}},	//   lmuk, _ryks, _itw_, --,
   {{0x6d4f2c34,0x442f2d49,0x7d060084,0x3f8a2d4a}},	//   _beca, _hug_, _syks, rebu_,
   {{0x44272d4b,0x6d4f2d4c,0x7e610088,0x66092d4d}},	//   _hin_, _ceca, álpa, nlek,
   {{0x6d442421,0xfce3016c,0x442f28f8,0x7c2f00de}},	// [2280] rbia, вото, _jug_, _cucr,
   {{0x44270913,0x8bf100c7,0x7d06013f,0x66090201}},	//   _jin_, _জীবন_, _vyks, hlek,
   {{0x442f2d4e,0xbcfb2d4f,0x7c2f0072,0x6eb51fb4}},	//   _lug_, _adéd, _eucr, _उपयु,
   {{0x44272d50,0x66092d51,0x442f00ae,0x6d4f2d52}},	//   _lin_, jlek, _oug_, _geca,
   {{0x645d0146,0x443d023e,0x442f0197,0xa3bf07d5}},	//   ásil, _ntw_, _nug_, ीसा_,
   {{0x44272d53,0x66092d54,0xb8d6278e,0x661b0e91}},	//   _nin_, elek, _छप_, emuk,
   {{0x34b8099d,0xd6d000e3,0x443d0085,0x442f00ca}},	//   ेन्द, طقة_, _atw_, _aug_,
   {{0xd5b0054f,0x44272d55,0x661b0d1f,0x66090ac9}},	//   افة_, _ain_, gmuk, glek,
   {{0x44272d56,0x442f0531,0x443d033c,0x00000000}},	//   _bin_, _cug_, _ctw_, --,
   {{0x3946013f,0xa3d800a5,0x66092d57,0xe8d70327}},	//   lbos_, ठों_, alek, _חומר_,
   {{0xbcfb2d58,0x442f01f7,0x200f00c6,0x00000000}},	//   _idée, _eug_, _ūgio_, --,
   {{0x44272d59,0x7dc3007a,0x39461570,0xf6690037}},	//   _ein_, _tõsi, nbos_, _رحمه_,
   {{0x6d4f1e6c,0x29f82d5a,0x443d0167,0x39462d5b}},	//   _reca, mčad_, _gtw_, ibos_,
   {{0x44272d5c,0x6d4f2c09,0x9f4300dd,0xa2d9023a}},	//   _gin_, _seca, mijë_, _फेक्,
   {{0x7c2f2d5d,0x7dd10073,0x442f0364,0x9f5800b3}},	//   _sucr, _låse, _zug_, corí_,
   {{0x44272d5e,0x442f0197,0xa01b0364,0x29f80995}},	//   _zin_, _yug_, gwör, nčad_,
   {{0x44272d5f,0x6d4f2d60,0x62970072,0x00000000}},	// [2290] _yin_, _veca, _áxor, --,
   {{0x2fc700ef,0x44270028,0x60c00222,0x66090018}},	//   _ông_, _xin_, ämme, zlek,
   {{0x386600dc,0x6d4f2d61,0xf09f015e,0x798b2d62}},	//   eror_, _teca, lvà_, tegw,
   {{0x6d5d052f,0x6eae030b,0x38660150,0x7f55037a}},	//   _udsa, ीहरु, fror_, lazq,
   {{0xdd3a0054,0x798b2d63,0x6609103b,0x52ca034d}},	//   _מערכ, regw, vlek, ानुस,
   {{0x2d99008a,0xe7392d64,0xe611001c,0xa6950859}},	//   _hase_, чек_, گشت_, ериј,
   {{0x44272d65,0x2d992d66,0x27e901ac,0x442f2d67}},	//   _rin_, _kase_, đan_, _sug_,
   {{0x44272d68,0x9f580181,0xfc3f00e3,0x3866017a}},	//   _sin_, vorí_, _tríd_, bror_,
   {{0x661b26f7,0x66092d69,0x442706f5,0x998a02c6}},	//   rmuk, rlek, _pin_, _zubů_,
   {{0xe3b1054f,0x2d992d6a,0xe8bd0455,0x66092d6b}},	//   ارة_, _lase_, ्नीच, slek,
   {{0x44272d6c,0x66092d6d,0x443d084e,0x00000000}},	//   _vin_, plek, _wtw_, --,
   {{0x442f01bb,0x44272d6e,0x76430167,0xe296083c}},	//   _tug_, _win_, mpny, хаю_,
   {{0x44272d6f,0x30752d70,0x2ec817ad,0x443d0027}},	//   _tin_, курс, रन्त, _utw_,
   {{0x44272d71,0x25bd0188,0xd0122ba0,0x63a40044}},	//   _uin_, _howl_, الس_, _ɗink,
   {{0xf8bd000d,0x3946013f,0xfc3f0065,0x2d992d72}},	//   ्नुप, ybos_, _atí_, _base_,
   {{0x2d992d73,0xdb1c0257,0xa3cd007f,0x7dca00d4}},	//   _case_, _forê, रसव_, _výso,
   {{0xa3c302e8,0x3dd202e0,0x8fa61bb8,0xbcfb0af0}},	// [22a0] _एका_, rhyw_, _запе, _adéb,
   {{0x61e62d74,0xfc3f0080,0x395f2d75,0x66002d76}},	//   likl, _dtí_, _adus_, zomk,
   {{0x160f0971,0x66001a87,0xfc3f0af0,0x7dd102c3}},	//   ातार_, yomk, _etí_, _såse,
   {{0x3f9a2d77,0x61e62d78,0x38662d79,0x39462d7a}},	//   _hapu_, nikl, tror_, ubos_,
   {{0xe8942d7b,0x6d562d7c,0xa92702ec,0x39462d7d}},	//   таль, maya, ніше_, rbos_,
   {{0x2d991b32,0x2d802d7e,0x38662d7f,0xa3e10285}},	//   _zase_, lfie_, rror_, नोम_,
   {{0x3f9a2a4b,0xdb1c023b,0x61e62d80,0xd90d0018}},	//   _mapu_, _morë, kikl, میہ_,
   {{0xceb30054,0x6d562d81,0x3f9a00d9,0x39490088}},	//   ריה_, naya, _lapu_, ðast_,
   {{0x61e62d82,0x18670396,0x29f8007e,0x778602f3}},	//   dikl, _пати_, rčad_, _плаз,
   {{0x6d562d83,0xb34620df,0x7dca003e,0x3f9a00c4}},	//   haya, diçõ, _sýsl, _napu_,
   {{0x6d5612f5,0xd257004d,0x2ca000aa,0x61e62d84}},	//   kaya, нця_, hvid_, fikl,
   {{0x6d562cb2,0xab64026a,0x25bd0078,0x61e62d85}},	//   jaya, ldüğ, _gowl_, gikl,
   {{0x7dca0074,0x6d562d86,0x1ae700c7,0xe516030b}},	//   _výsl, daya, _করছে_, देखि_,
   {{0xb4be02d5,0x6fcb0092,0x2ca00149,0x20050220}},	//   ीनी_, _gücl, dvid_, ôli_,
   {{0x2d9914b1,0x2d802d87,0xdb1c00dd,0xdb1519a3}},	//   _pase_, ffie_, _dorë, _pozí,
   {{0x6d562d88,0x32530465,0xb3460396,0x3ebe0149}},	//   gaya, _свър, biçõ, ätta_,
   {{0xdb15025b,0xa91d15fe,0xacf82d89,0x9f5800ee}},	// [22b0] _vozí, _obža, енту_, borà_,
   {{0xdb1c2d8a,0x9f5800b3,0xe7e200b6,0x00000000}},	//   _korè, corà_, कोमा_, --,
   {{0x6d562d8b,0x20030138,0x3a752d8c,0x2d992d8d}},	//   baya, moji_, тлер, _tase_,
   {{0x20032d8e,0x6d562d8f,0xaf4b0103,0x9f580131}},	//   loji_, caya, _بشکل_, porã_,
   {{0x7dda02c6,0x83fd0103,0xdb1c03a9,0xa01b003e}},	//   růst, rtőz, _lorè, rtöf,
   {{0x61e62d90,0x20032d91,0x00000000,0x00000000}},	//   zikl, noji_, --, --,
   {{0x34c9099d,0x00000000,0x00000000,0x00000000}},	//   िन्द, --, --, --,
   {{0x20030051,0x00000000,0x00000000,0x00000000}},	//   hoji_, --, --, --,
   {{0x61e605a3,0x20031177,0x998700c6,0x91a900fe}},	//   vikl, koji_, ūnų_, _giả_,
   {{0xad9b01cd,0xd7591dec,0x20032d92,0x799b1a3b}},	//   _skúl, _آلات_, joji_, _hauw,
   {{0x6d562d93,0x27e70088,0x216a19a9,0x799b2d94}},	//   yaya, minn_, мини_, _kauw,
   {{0xe3b11e49,0x27e72d95,0x3f9a2d96,0xb3460161}},	//   ارک_, linn_, _sapu_, tiçõ,
   {{0x61e62d97,0x799b2d98,0x3f9a2d99,0x32020146}},	//   rikl, _mauw, _papu_, roky_,
   {{0x20030b27,0x6d5623b0,0xb346001f,0x27e7003e}},	//   goji_, waya, riçõ, ninn_,
   {{0x6d562d9a,0xb346001f,0xa3d60592,0x61e62d9b}},	//   taya, siçõ, _सतत_, pikl,
   {{0x27e70049,0x799b2d9c,0x69cb029a,0xdce40357}},	//   hinn_, _nauw, jkge, ngić,
   {{0x6d562d9d,0x27e70088,0x7e7c0128,0x61e42d9e}},	// [22c0] raya, kinn_, strp, _imil,
   {{0x6d562d9f,0x80db2da0,0xfaa62da1,0x9f4a05e6}},	//   saya, _যুক্, казо, robó_,
   {{0x6d562da2,0x799b2da3,0x81f70260,0x7c36023b}},	//   paya, _bauw, _سفیر_, sqyr,
   {{0x5e570130,0x6d560188,0xe8ea2753,0x186a001f}},	//   _ביטע_, qaya, ммед_, дади_,
   {{0xf772003f,0x27e72da4,0x799b2da5,0x61e42da6}},	//   لاغ_, finn_, _dauw, _mmil,
   {{0x27e72da7,0xf0930341,0x7a3302a1,0x69cb05c2}},	//   ginn_, ינד_, _oħth, akge,
   {{0x61e400cb,0xbcfb2da8,0xd6cf00ab,0x7dc3007a}},	//   _omil, _idéa, يقه_, _tõst,
   {{0x6b9c2da9,0xd8760068,0xad9b0139,0x69cb01bf}},	//   _harg, _لائب, _akúj, ckge,
   {{0xb4be2daa,0xb4cc110f,0x6b9c2dab,0xd3780335}},	//   ीने_, रने_, _karg, lići_,
   {{0x61e42dac,0x69c02dad,0x27e701b5,0x79822dae}},	//   _amil, _home, cinn_, lfow,
   {{0xd6c41e49,0xa3e30abe,0xa3c30006,0x6b9c2daf}},	//   _حمای, _नगर_, _एकर_, _marg,
   {{0x6b9c2db0,0xdb1c2db1,0x3869228d,0x80db0a43}},	//   _larg, _coré, šare_, _যুগ্,
   {{0xdb151ba6,0xdb1c2db2,0x20032db3,0x6b9c01ff}},	//   _mozá, _doré, toji_, _oarg,
   {{0x61e42db4,0xbcfb00e3,0xa3e11efb,0x60c00149}},	//   _emil, _ndéa, नोद_, ämma,
   {{0xdd9b065c,0x9e0702ec,0x20032db5,0x9c130065}},	//   мша_, вчал, roji_, _bọnn,
   {{0xd378005f,0x6b9c2db6,0xdb1c03a9,0x20032db7}},	//   dići_, _aarg, _goré, soji_,
   {{0x320912f5,0x78a20d62,0xa3d6009f,0x799b2db8}},	// [22d0] _ikay_, jvov, _सता_, _rauw,
   {{0x6b9c0d9f,0xd3782461,0xfc3f0610,0x799b2db9}},	//   _carg, fići_, _cría_, _sauw,
   {{0x6b9c2dba,0x799b2dbb,0x69c01b05,0x65620031}},	//   _darg, _pauw, _bome, _odoh,
   {{0x70010134,0x27e70364,0x64420634,0x6b9c01b9}},	//   _ịcho, winn_, _otoi, _earg,
   {{0x27e72dbc,0x69cb03ee,0x6b9c2dbd,0x26c702ad}},	//   tinn_, rkge, _farg, wyno_,
   {{0x6b9c2dbe,0xd37808a9,0x628a052f,0x656201dc}},	//   _garg, bići_, _opfo, _adoh,
   {{0x27e72dbf,0x69c02dc0,0x06e316f8,0x64422dc1}},	//   rinn_, _fome, _केशव_, _atoi,
   {{0x27e72dc2,0x69c02dc3,0x6b9c1114,0x09ca0081}},	//   sinn_, _gome, _zarg, লোবা,
   {{0x3f910a00,0x6b9c026a,0x753b028d,0x27e7056e}},	//   kezu_, _yarg, rcuz, pinn_,
   {{0x69c00ab2,0x3a2d00de,0x645b2dc4,0x6b9c008c}},	//   _zome, _hiep_, rsui, _xarg,
   {{0xdb1c0bfe,0x4226016a,0x645b2dc5,0x3f912dc6}},	//   _poré, лдов, ssui, dezu_,
   {{0x9f4e0074,0x7dca035d,0xa06a0291,0x645b2dc7}},	//   čník_, _výsk, нама_, psui,
   {{0xc60f06ed,0xa91d013f,0x6fcb01bf,0xd37800cc}},	//   ातीय_, _pažy, _küch, zići_,
   {{0x3a2d01c0,0xdee62dc8,0x8335006e,0x69da00c6}},	//   _liep_, гоги, _גאַס_, _įtem,
   {{0xdb1c00d1,0xa26300fe,0x80a200aa,0x00000000}},	//   _toré, _xuố, खिहे, --,
   {{0xd37804a3,0xa01b0018,0x7dd12dc9,0x68fb00a7}},	//   vići_, gtöb, _påsa, _oxud,
   {{0x5baa2cbf,0x6b9c2dca,0x3b860dd8,0xb88600b6}},	// [22e0] нкам_, _parg, ллаг, _kníž,
   {{0x69c02dcb,0xd3780106,0x5eff00c3,0x6b9c02a1}},	//   _some, tići_, _शुक्_, _qarg,
   {{0x68fb22e7,0x69c0230b,0x6b9c2dcc,0xc33200a1}},	//   _axud, _pome, _varg, צוא_,
   {{0x6b9c2dcd,0x9f5805fe,0xd3780106,0x2b470233}},	//   _warg, forç_, rići_, ınca_,
   {{0x2d922dce,0x17540a01,0x3a2d0305,0xd7e60c10}},	//   meye_, авля, _diep_, ліко,
   {{0x6fcb02e2,0x78a20146,0x69c02dcf,0xd3780995}},	//   _rück, rvov, _wome, pići_,
   {{0x64422dd0,0xb4cc0285,0xa2630023,0x22400357}},	//   _stoi, रन्_, _quố, _čiko_,
   {{0x2d9227dd,0xa3d606ed,0xa2a20557,0xa5340e0e}},	//   neye_, _सतह_, गिस्, шнич,
   {{0x98a32dd1,0xf7460870,0x7c2e2dd2,0xdb1e2dd3}},	//   _лите, _безо, _kibr, skpä,
   {{0x7c2e2dd4,0x3dc2039f,0x2d9205bd,0xdcef0559}},	//   _jibr, _lokw_, heye_, šeće,
   {{0x3f9104a3,0x86462dd5,0x2d922dd6,0x05860036}},	//   vezu_, _снеж, keye_, _булм,
   {{0x7c2e2bd4,0xf65100fb,0x6fcb0364,0x3dc2039f}},	//   _libr, _گئے_, _züch, _nokw_,
   {{0x7c2e0080,0x3f910ca7,0xbcfb1561,0x2d9204d6}},	//   _oibr, tezu_, _adén, deye_,
   {{0x40341553,0x00000000,0x00000000,0x00000000}},	//   серс, --, --, --,
   {{0x629800e9,0xddab002d,0x442e02a1,0x00000000}},	//   _usvo, нтал_, _iif_, --,
   {{0x7c2e00e3,0xb8860220,0x442e2dd7,0x32090d16}},	//   _aibr, _zníž, _hif_, _ukay_,
   {{0x442e04f9,0x3b552dd8,0x7c2e0062,0x3a2d029a}},	// [22f0] _kif_, икар, _bibr, _riep_,
   {{0x7c2e2dd9,0x3a2d0381,0x00000000,0x00000000}},	//   _cibr, _siep_, --, --,
   {{0x2d922dda,0x7c2e2ddb,0x3a2d07e6,0xfd1f0032}},	//   beye_, _dibr, _piep_, _gbìn_,
   {{0xaca30174,0xd37800cb,0x2d922ddc,0x6fcb042c}},	//   _agụb, miću_, ceye_, _süch,
   {{0x6d4d2ddd,0xd37801ac,0xbcfb20ed,0x9984020a}},	//   mbaa, liću_, _idéo, _simţ_,
   {{0xdcfd0029,0x7c2e2dde,0xf7710e5a,0x6d4d2ddf}},	//   _lasī, _gibr, زات_, lbaa,
   {{0x45d52de0,0xd3780106,0x3a2d0023,0x63a401c2}},	//   ицит, niću_, _tiep_, _ɗint,
   {{0x6d4d2de1,0xb88600b6,0x44652de2,0x05a900c2}},	//   nbaa, _sníž, авив, твий_,
   {{0x851f2de3,0xd37802ef,0x79890139,0x6e37078e}},	//   मेंट_, hiću_, _ibew, _luxb,
   {{0x442e03e3,0x2d922de4,0x98170037,0x7c2e0858}},	//   _cif_, zeye_, _إبرا, _xibr,
   {{0x629e199c,0x6d4d04ee,0x6b600103,0xd3780995}},	//   _špor, kbaa, lágí, jiću_,
   {{0x78a92de5,0xd3780039,0x442e2de6,0x6d4d01c0}},	//   _krev, diću_, _eif_, jbaa,
   {{0x6d4d2de7,0x32db0af0,0x442e2de8,0x78a901ff}},	//   dbaa, _báyé_, _fif_, _jrev,
   {{0xbcfb0032,0xd3780106,0xfe4609e0,0x6d4d010a}},	//   _adéo, fiću_, инго, ebaa,
   {{0xed5a2de9,0x2d922dea,0xdbcf0220,0x6d4d2deb}},	//   ков_, teye_, bľúb, fbaa,
   {{0x38600335,0x78a92dec,0x6d4d2ded,0x442e2dee}},	//   širi_, _orev, gbaa, _zif_,
   {{0x2d9227dd,0xd00f0068,0x32db0032,0x64492c6f}},	// [2300] reye_, سلہ_, _fáyé_, npei,
   {{0x2d922def,0x79892df0,0xd3780995,0x00000000}},	//   seye_, _abew, biću_, --,
   {{0x7f5c2df1,0xeb971bf9,0x78a91428,0xfc3f04d8}},	//   marq, рих_, _arev, _frío_,
   {{0x225118ed,0xa96a2b16,0x3a990109,0x973c0559}},	//   ázky_, тида_, ытую_, _maće,
   {{0x78a92df2,0x386000e3,0x7c2e2df3,0xad9b0139}},	//   _crev, éir_, _tibr, _akúw,
   {{0x78a923a0,0x7f5c1c40,0x600000c2,0x63a401c2}},	//   _drev, narq, tömy, _ɗins,
   {{0x442e2df4,0xd9100421,0xdb1c0032,0x64490381}},	//   _rif_, _کیش_, _korí, epei,
   {{0x69d92df5,0x7dd800e3,0x442e2df6,0x1dbf058f}},	//   chwe, _físe, _sif_, _एकछत,
   {{0x030b00a5,0x2e3c0088,0xd378015c,0xdb1c2df7}},	//   _सुबह_, _líf_, ziću_, _morí,
   {{0x66e62df8,0x2b58015e,0x442e0f09,0xdb1c0139}},	//   _коза, _jerc_, _qif_, _lorí,
   {{0xbcfb2df9,0xe7370084,0x29f8042d,0x442e2dfa}},	//   _adél, _тех_, nčao_, _vif_,
   {{0xd37800e9,0x973c0a39,0x9257007b,0x9f8f013c}},	//   viću_, _daće, шают_, _küç_,
   {{0x90982dfb,0x7dd12dfc,0x92b60033,0x10740686}},	//   авят_, _såso, ছনে_, оляю,
   {{0xd3782c0a,0x92172dfd,0xc88400a7,0xb6010231}},	//   tiću_, _धीरज_, mağı_, _àáre,
   {{0x6d4d2dfe,0x637b0089,0x4ea41e61,0xdb1c0103}},	//   tbaa, _סנהד, орта, _borí,
   {{0xcdd80831,0xd3780335,0xdb1c016d,0x6d4d2dff}},	//   ању_, riću_, _corí, ubaa,
   {{0xdce606d7,0x6d4d09e3,0x7f5c2e00,0xd90400cd}},	// [2310] _bakı, rbaa, barq, _آی_,
   {{0x6d4d19fb,0x3ceb009d,0xfaa7075f,0x2b58020a}},	//   sbaa, _घेणे_, ишен, _cerc_,
   {{0x69d90201,0x6d4d0a9f,0xfc3f0610,0xd8b8001c}},	//   thwe, pbaa, _trío_, یدها_,
   {{0xf99300cd,0x7dd8030b,0x6ec400b6,0x80a40a85}},	//   تبط_, _píse, रहरु, _امین,
   {{0x2d8b023e,0x98a52e01,0xf7451c21,0xaf080281}},	//   _ibce_, силе, бело, _مقیم_,
   {{0x78a9031a,0x69d92e02,0x940f0d2a,0xc8841577}},	//   _vrev, shwe, ɗaɗe_, dağı_,
   {{0x6b6001f9,0x00000000,0x00000000,0x00000000}},	//   ságí, --, --, --,
   {{0x78a92e03,0xdce80034,0x29f8033b,0x7989039f}},	//   _trev, śląs, nčal_, _ubew,
   {{0xdce60b88,0xcdb800a1,0x6fcb0092,0x9f8f026a}},	//   _yakı, שפחה_, _hücu, _güç_,
   {{0xa3e12e04,0x395d2e05,0x3cff00a5,0x62811a92}},	//   नों_, laws_, _रखने_, ttlo,
   {{0x64492e06,0x2d8b1b6d,0x11d600e3,0x7c250076}},	//   spei, _obce_, متحد, imhr,
   {{0xbcfb0065,0x64490d67,0x9f510103,0xc88407e7}},	//   _adém, ppei, kozó_, bağı_,
   {{0xc88408bb,0x53a5002d,0x7f5c0db4,0xd469231c}},	//   cağı_, _галб, tarq, _силе_,
   {{0x395d0197,0xd91a22fe,0x248f0063,0x66092e07}},	//   haws_, טורל, _ipgm_, loek,
   {{0x6fd009b5,0x601201cd,0x00000000,0x00000000}},	//   _häck, næmi, --, --,
   {{0x25bf00d1,0xdce6026a,0xad9b01cd,0x00000000}},	//   njul_, _sakı, _ljúf, --,
   {{0x2b580018,0x395d022e,0x7f5c2bb5,0x5b360c5e}},	// [2320] _perc_, daws_, parq, معار,
   {{0x66092e08,0x25bf2e09,0x2f560284,0xa01b1c49}},	//   hoek, hjul_, _утис, ltön,
   {{0x6fd00149,0x66092e0a,0x4e1a0260,0xdce60233}},	//   _läck, koek, _متحد_, _vakı,
   {{0x200a2e0b,0x29f809ac,0xc884020e,0x7dd8217f}},	//   lobi_, rčao_, yağı_, _dísc,
   {{0x1cba029e,0xc7c60747,0x06e500c7,0xdce60b88}},	//   _صاحب_, йски, _পুলি, _takı,
   {{0x3a382e0c,0x7dca033d,0x29f800e7,0xdb1c0231}},	//   _turp_, _výsu, pčao_, _corã,
   {{0xe0df0451,0x91fd00e8,0x00000000,0x00000000}},	//   zzò_, nsāc, --, --,
   {{0x6fd00f3a,0xd6d9004d,0xc884020e,0x660901c8}},	//   _bäck, шті_, tağı_, goek,
   {{0xbcfb0139,0xdb1c015e,0x70b400b6,0xad9b0065}},	//   _adéj, _horà, ुहोल, _ikút,
   {{0x6fd00212,0x249d0154,0xc88403e0,0x25bf020a}},	//   _däck, _dswm_, rağı_, ajul_,
   {{0x66090cad,0x51f900d6,0x200a2e0d,0x91fd01d3}},	//   boek, иною_, dobi_, krāt,
   {{0xdb1c00b3,0x3860007e,0xc8840342,0x00000000}},	//   _morà, širu_, pağı_, --,
   {{0x63bc2e0e,0x91fd01d3,0x2ed102f0,0xdb1c0065}},	//   örns, drāt, सन्त, _lorà,
   {{0x63ad03e3,0x3fe70033,0x03a300ae,0x200a010a}},	//   _ɗank, পক্ষ, _ничо, gobi_,
   {{0xd35b09c1,0xe2460192,0x6fd00364,0xe6b6023a}},	//   _גדול, _اختي, _mäch, _अपोज,
   {{0x395d022e,0x6fd00364,0x72070103,0x3ebf0234}},	//   xaws_, _läch, _دفعہ_, ćut_,
   {{0xf1f800d0,0x71f81487,0x320b00a5,0x200a0044}},	// [2330] _دعوت_, _دروس_, mocy_, bobi_,
   {{0x66090ab2,0x6fd002e2,0x200a0113,0x9f510103}},	//   zoek, _näch, cobi_, rozó_,
   {{0x6fb500cd,0xad270470,0xfbd00037,0x00000000}},	//   _همکا, _گردو, رتك_, --,
   {{0x7dd10021,0x6fcb01e8,0x7dd80072,0x39152e0f}},	//   _måsk, _vücu, _vísc, омер,
   {{0x7dca0618,0x6d5f2e10,0x9ccb055b,0x893400e3}},	//   _výst, maqa, _сына_, أعما,
   {{0x6fd00222,0x395d023e,0x61ef2e11,0x6d5f2e12}},	//   _räck, saws_, hicl, laqa,
   {{0x7ac41cf2,0x66092e13,0x2ca92e14,0x6fd017a5}},	//   _есте, toek, lvad_, _säck,
   {{0x59f90084,0x6d5f008c,0xa2d7058f,0xe6190396}},	//   _тебя_, naqa, मनस्, јди_,
   {{0x224700a4,0x66092e15,0x38600037,0x61ef14d9}},	//   _stnk_, roek, áirt_, dicl,
   {{0xdb1c0f3f,0xd26508d8,0x66090185,0x6498013d}},	//   _horá, окой, soek, стър_,
   {{0xdb1c2e16,0x27e0006d,0x2ca92e17,0x59dd00aa}},	//   _korá, ɗin_, hvad_, _मतार,
   {{0x7bc72e18,0x6fd00149,0x249d022e,0x9c130139}},	//   _loju, _täck, _tswm_, _dọin,
   {{0x200a0032,0xb9150139,0xdb1c2e19,0x6d5f2e1a}},	//   tobi_, _agbẹ_, _morá, daqa,
   {{0x34b20979,0x23292e1b,0xb4c700aa,0x25e516e2}},	//   _آموز, _коли_, ैनी_, जोरी_,
   {{0x200a2e1c,0x443f2e1d,0x61ef22d4,0x63a32e1e}},	//   robi_, lqu_, bicl, _iann,
   {{0x63a32e1f,0xdd922761,0x657b1a45,0x6d5f2e20}},	//   _hann, بور_, nguh, gaqa,
   {{0x63a32e21,0x7bc72e22,0x443f02a1,0x2f2300fd}},	// [2340] _kann, _boju, nqu_, tégé_,
   {{0x63a32e23,0xad9b2e24,0x443f014b,0xdb1c033c}},	//   _jann, _skút, iqu_, _aorá,
   {{0x63a32e25,0x3f9803e4,0x6d5f2e26,0x91fd01d3}},	//   _mann, meru_, baqa, prāt,
   {{0x63a32e27,0xdb1c04c3,0x6fd0042c,0x29f800c4}},	//   _lann, _corá, _säch, pčam_,
   {{0x91a00023,0x7bc70065,0xdb1c00d4,0xdbdc0af0}},	//   _chỉ_, _foju, _dorá, _láél,
   {{0x63a32e28,0x6d441834,0x3f982e29,0x3cff0034}},	//   _nann, lcia, neru_, _रखते_,
   {{0xdb1c0037,0xd90d0018,0x9f9d0139,0x00000000}},	//   _forá, نیہ_, _dìè_, --,
   {{0x6d442e2a,0x39420006,0x26c004a3,0x63a309e3}},	//   ncia, _üks_, ćio_, _aann,
   {{0x63a32e2b,0x22492e2c,0x6d442e2d,0x3f982e2e}},	//   _bann, _čaka_, icia, keru_,
   {{0x69c20934,0x3f9800cb,0x63a3188c,0x7dd12e2f}},	//   ljoe, jeru_, _cann, _påsk,
   {{0x61ef2e30,0x6d5f2e26,0x973c14f3,0x6d442e31}},	//   ticl, yaqa, _gaća, kcia,
   {{0x63a31909,0x51f80fe9,0x6d442e32,0x00000000}},	//   _eann, жнюю_, jcia, --,
   {{0x63a32e33,0x3f982e34,0xa3c3009d,0x2d8701f9}},	//   _fann, feru_, _एकच_, őnek_,
   {{0xa3ce018b,0x65602e35,0x3f982e36,0x6d462e37}},	//   _रवि_, lamh, geru_, _afka,
   {{0x9f340120,0xbcfb001f,0x6d5f041c,0x244000fe}},	//   дері, _idéi, taqa, _hòm_,
   {{0x63a32e38,0x24400c56,0xad9b0af0,0x65602e39}},	//   _zann, _kòm_, _ojúe, namh,
   {{0x63a32e3a,0xad9b0181,0x3f982e3b,0x6d5f2e3c}},	// [2350] _yann, _skús, beru_, raqa,
   {{0x6d5f2e3d,0xdb1c0018,0x7dd8003e,0x2ca92e3e}},	//   saqa, _sorá, _vísa, rvad_,
   {{0xdd910080,0x61ed0087,0x5a350a7c,0xdb1c2e3f}},	//   _كود_, _kmal, чнет, _porá,
   {{0x6d44013d,0xfe9a00c1,0xf1bf2e40,0x6d5f2e41}},	//   ccia, _פירמ, zmán_, qaqa,
   {{0x6d5d00d9,0x61ed0129,0x65602e42,0xa01b007b}},	//   _iesa, _mmal, damh, ytöl,
   {{0x6d5d2e43,0x05a3049d,0x61ed2e44,0x60c013ce}},	//   _hesa, _खोजब, _lmal, ämmi,
   {{0x63a32e45,0x6d5d2e46,0x7c3d2df3,0xdb1c10d9}},	//   _rann, _kesa, _husr, _torá,
   {{0x63a32e47,0x3f982e48,0x6d5d2e49,0x65602e4a}},	//   _sann, zeru_, _jesa, gamh,
   {{0x6d5d2e4b,0x63a32e4c,0xb4d50cce,0xf1ba0023}},	//   _mesa, _pann, सने_, _đơ_,
   {{0x61ed2e4d,0x443f2e4e,0x6d5d2e4f,0xbcfb0139}},	//   _amal, rqu_, _lesa, _eeég,
   {{0x63a32e50,0x443f025a,0x3f980dab,0x7c350154}},	//   _vann, squ_, veru_, _mizr,
   {{0x63a32e51,0x6d5d2e52,0xdb1c01c5,0x3f982e53}},	//   _wann, _nesa, _foræ, weru_,
   {{0x7c3d2e54,0x63a32e55,0x3ea1023b,0xe4490037}},	//   _nusr, _tann, _asht_, _التى_,
   {{0xf8a50979,0x69db2e56,0x63a30565,0x04540018}},	//   _یک_, _llue, _uann, _آئند,
   {{0x6d5d2c09,0x7c3d02e2,0xaca40294,0x443d0319}},	//   _besa, _ausr, _mpụt, _huw_,
   {{0xf0662e57,0x7c3501d3,0x1c461f47,0xf1bf003e}},	//   _екип, _aizr, знам, nmál_,
   {{0x6d5d2e58,0xdb1c00dd,0x3f982e59,0x3ea1023b}},	// [2360] _desa, _korç, peru_, _esht_,
   {{0x6d442e5a,0x69db02fd,0xe81b009f,0x6d5d01ee}},	//   scia, _alue, _पीला_, _eesa,
   {{0x69c202ac,0xcf5700ca,0x160b09c3,0x443d0483}},	//   tjoe, _מבית_, हकार_, _luw_,
   {{0x6d5d2e5b,0xf3f12e5c,0xaca40129,0x79a32458}},	//   _gesa, hị_, _apụt, ерше,
   {{0x2d820149,0xb4d500bc,0x00000000,0x00000000}},	//   _icke_, सनो_, --, --,
   {{0x569400a0,0xbcfb0af0,0x24402e5d,0x69c22e5e}},	//   дакт, _adéw, _ròm_, sjoe,
   {{0x69db2e5f,0x6d5d2e60,0x64590078,0x8f9b0266}},	//   _flue, _yesa, _awwi, מיסי,
   {{0xe9a313fc,0x7c3d02e7,0x66040031,0x244005aa}},	//   _пасп, _yusr, čiko, _pòm_,
   {{0xdb1c008b,0x28160103,0x65602e61,0x2ca205db}},	//   _borç, _فورس, ramh, _jskd_,
   {{0x46a62e62,0x65602e63,0x61ed00a1,0xa01b0084}},	//   _назв, samh, _smal, ttöm,
   {{0xdb050113,0x6b6701f9,0x24400383,0x00000000}},	//   gdhè, légí, _wòm_, --,
   {{0x3946132d,0x7ae10103,0x443d03a8,0x00000000}},	//   ncos_, _ülte, _fuw_, --,
   {{0xdb1c2e64,0x39462027,0x7dd800b6,0xf8be10e9}},	//   _forç, icos_, _písn, ्हिय,
   {{0x6d5d2d96,0x925700bf,0x3ea10167,0x38660063}},	//   _sesa, _کشور_, _psht_, isor_,
   {{0x6d5d2e65,0x7c3d02e6,0x9f4a0314,0xdb05023b}},	//   _pesa, _susr, cibí_, rdhë,
   {{0x61ed2e66,0x42fb00a1,0x7c3d2e67,0x131700d7}},	//   _umal, _להוס, _pusr, _מחול_,
   {{0x7bdc010a,0x6d5d2e68,0xa01b2e69,0x25a62e6a}},	// [2370] _blru, _vesa, ntök, _maol_,
   {{0x3f812e6b,0x6e992610,0x39462e6c,0x2d820364}},	//   _uchu_, _двор_, ecos_, _ecke_,
   {{0xdb5800c2,0xdd0c0034,0x20042e6d,0x61fd2e6e}},	//   яют_, góło, émie_, onsl,
   {{0x61fd2e6f,0x23c8030b,0x22580094,0x3a24037a}},	//   nnsl, ाउँद, árky_, _chmp_,
   {{0x07a52e70,0xf3f10134,0x5fd10ff9,0x78a60206}},	//   далн, yị_, _सकाल, _škvr,
   {{0x443d01cb,0x945d007f,0xdb1c02c3,0x27c7007b}},	//   _ruw_, zyńs, _borä, ящег,
   {{0x6446003e,0x56921009,0xa01b007b,0x25a60076}},	//   íkin, вајт, ttöj, _baol_,
   {{0x25a60a02,0x63b80154,0x39462e71,0x291f01ff}},	//   _caol_, _anvn, ccos_, _tzua_,
   {{0xf1bf2e72,0xdb1c0161,0x443d0113,0x62880f5a}},	//   rmál_, _porç, _quw_, etdo,
   {{0x395f2e73,0x7dd8037a,0xf1bf003e,0xa01b007b}},	//   _heus_, _aísl, smál_, stöj,
   {{0x395f01c0,0xfc3f0037,0x2d9b2e74,0xfbd200ca}},	//   _keus_, _luí_, keqe_, דתי_,
   {{0x25a60a02,0x77630858,0xaca30139,0x67210fa3}},	//   _gaol_, lanx, _afọb, _izlj,
   {{0x395f2e75,0x644b0ec9,0xdb1c255b,0x20b504d9}},	//   _meus_, _utgi, _torç, нёрс,
   {{0x7dd80220,0x61fd1cab,0xe82006e4,0x395f2e76}},	//   _píso, ansl, यतया_, _leus_,
   {{0xe7e5007a,0x628801cb,0x83fd01f9,0x00000000}},	//   _कतना_, ctdo, lsőo, --,
   {{0x26130161,0x395f2e77,0xe1f2001c,0x9f9400c2}},	//   mãos_, _neus_, _جست_, _sää_,
   {{0x39a601b3,0xfc3f0037,0xdbdc0af0,0x9f94007b}},	// [2380] _jūsų_, _cuí_, _fáìl, _pää_,
   {{0x39a601b3,0xafdb038c,0x67212e78,0x3ebe02c3}},	//   _mūsų_, spør, _ozlj, ätts_,
   {{0x395f00b3,0x776300ee,0xa5bd00c6,0x00000000}},	//   _beus_, danx, rmųj, --,
   {{0x395f009c,0xbcfb00b3,0xfc3f034f,0xa01b007b}},	//   _ceus_, _adéu, _fuí_, ytök,
   {{0x395f2e79,0x5fd20067,0x186715a7,0x9f9400c2}},	//   _deus_, _हवाल, дачи_, _tää_,
   {{0x25a600e3,0x77630428,0x2d802e7a,0x7a2300aa}},	//   _saol_, ganx, lgie_, võte,
   {{0xc7b80028,0x69d800dd,0xdb1c0149,0x61fd2e7b}},	//   _vnđ_, ëves, _borå, ynsl,
   {{0x746a2082,0x395f2e7c,0x2d802e7d,0x69d801d3}},	//   оров_, _geus_, ngie_, īves,
   {{0xd49a004d,0x211d2918,0x38c300c6,0xdbdc0139}},	//   іри_, _नरेश_, gūrą_, _láíl,
   {{0x1b210081,0xf1bf0146,0x77630072,0x26130131}},	//   _বলতে_, rmám_, canx, fãos_,
   {{0xc7b3040a,0xdb1c038c,0x26130161,0xa01b2e7e}},	//   _שבע_, _forå, gãos_, stök,
   {{0x22ac00b6,0xa01b003e,0x3cff007a,0x00000000}},	//   _věk_, ptök, _रखले_, --,
   {{0x7dd1070a,0x2ca01d49,0x61fd2e7f,0x9f58034f}},	//   _måst, jwid_, rnsl, joró_,
   {{0x75222e80,0x7dd1032e,0x2d8002ac,0x00000000}},	//   _izoz, _låst, egie_, --,
   {{0x40342e81,0x1d4c0134,0x2ee603e3,0xfc3f0076}},	//   терс, _ọdịm, _ƙofa_, _suí_,
   {{0x2d802e82,0x6d562e83,0x442c01cb,0xd83800c4}},	//   ggie_, gbya, lmd_, _lič_,
   {{0x395f0472,0xfc3f0023,0x442c029a,0x212f01b9}},	// [2390] _reus_, _quí_, omd_, _àgh_,
   {{0x395f2e84,0xd8382e85,0x75220239,0x7e7c01e9}},	//   _seus_, _nič_, _mzoz, burp,
   {{0x395f0428,0xbcfb0af0,0xe1ff2e86,0x442c029a}},	//   _peus_, _adét, onó_, imd_,
   {{0x20112e87,0x66022e88,0x9f5800e1,0x3ebe0b81}},	//   lozi_, _njok, boró_, åtte_,
   {{0x7b670d64,0x386900e3,0x395f05fe,0x6e2d2e89}},	//   _отве, éar_, _veus_, mmab,
   {{0x48e00081,0x660200c2,0x63ad03e3,0x7b74001c}},	//   বপূর, _ajok, _ɗans, _لطفا,
   {{0x395f2e8a,0x776308a8,0x260b05a5,0xd8380146}},	//   _teus_, ranx, ावली_, _dič_,
   {{0x442c0cad,0xd5b106f6,0xdcef0740,0x20112e8b}},	//   emd_, افظ_, _hacı, hozi_,
   {{0x20111a80,0x6012052f,0x31602e8c,0xd838007e}},	//   kozi_, kæmp, _reiz_, _fič_,
   {{0x9f9d0139,0x69d9000b,0x66020372,0x28be2c82}},	//   _bìí_, lkwe, _ejok, ्हरि,
   {{0xd24e037f,0x7dd826e0,0xb81b0034,0x69d92e8d}},	//   ینی_, _sísm, _पीएम_, okwe,
   {{0x7dd8025b,0x6602023b,0x9f9d0065,0x442c18f0}},	//   _písm, _gjok, _dìí_, amd_,
   {{0x76411331,0xa3d51612,0x661b024a,0x26130131}},	//   _huly, _подч, mluk, sãos_,
   {{0x20112e8e,0x661b20bc,0x7641083e,0x66020141}},	//   gozi_, lluk, _kuly, _zjok,
   {{0x442702e2,0xdee61a18,0xdb150031,0x236500c4}},	//   _ihn_, хови, _pozý, malj_,
   {{0x76412e8f,0xd24e00e3,0x6e2d019c,0x661b2e90}},	//   _muly, _اني_, gmab, nluk,
   {{0x2011092f,0xfce32e91,0x91fd00d9,0x921700c1}},	// [23a0] bozi_, гото, ksāj, _אַזױ_,
   {{0x9f9d02b4,0xfc3f00e3,0x661b067d,0xbcfb0065}},	//   _yìí_, _arís_, hluk, _adés,
   {{0x7dd109ce,0xdb1c0181,0x44270085,0x9f580036}},	//   _påst, _horú, _mhn_, borò_,
   {{0xceb3028c,0x69d90d1f,0xdb1c2e92,0x661b031a}},	//   _עיר_, gkwe, _korú, jluk,
   {{0xdb0703a9,0x661b2e93,0x6d3b00ca,0x442c2e94}},	//   _lajè, dluk, _מתכנ, ymd_,
   {{0x66022e95,0x76412e96,0x998d0031,0x44272e97}},	//   _sjok, _buly, _vieš_, _nhn_,
   {{0xfc032e98,0x09e600d6,0x69962e99,0xdb152e9a}},	//   _спро, _зовн, _прах, _dozó,
   {{0x661b2e9b,0x69d92e9c,0x7bce00aa,0x76412e9d}},	//   gluk, ckwe, _hobu, _duly,
   {{0x09e32e9e,0xb4da0251,0x7bce2e9f,0xa492001c}},	//   _сотн, ठने_, _kobu, ایتت,
   {{0x7bce00d3,0x224e01ff,0x236500c4,0x00000000}},	//   _jobu, _ptfk_, galj_, --,
   {{0x76412ea0,0x7bce2ea1,0x442c0126,0x45e400de}},	//   _guly, _mobu, rmd_, _đượ,
   {{0x79822ea2,0x7bce0201,0x20112ea3,0x44272ea4}},	//   ngow, _lobu, wozi_, _ehn_,
   {{0x20112ea5,0xe3b200cd,0x2365077e,0x9f580036}},	//   tozi_, _مرغ_, balj_, vorò_,
   {{0x644f1f8d,0x7bce2ea6,0xdb1c0065,0xa3d70096}},	//   ície, _nobu, _dorú, _सवय_,
   {{0x20110193,0xe28f0037,0x6e942ea7,0x20040031}},	//   rozi_, _هذي_, лиру, émia_,
   {{0x63aa2ea8,0x20112ea9,0x3f850078,0xdb1c0032}},	//   _hafn, sozi_, żlu_, _forú,
   {{0x7dd82eaa,0x7bce2eab,0xbcfb0032,0x20110a4b}},	// [23b0] _získ, _bobu, _adér, pozi_,
   {{0x63aa0102,0x64422eac,0x7bce2ead,0x661b047e}},	//   _jafn, _muoi, _cobu, zluk,
   {{0xa03600a1,0xbb840037,0x29d7026a,0x9f8f00aa}},	//   _שאתה_, المي, _uçak_, _müü_,
   {{0x65622eae,0x9f580088,0xdb0e0131,0x91a000fe}},	//   _neoh, lorð_, _robô, _khí_,
   {{0x76412eaf,0x69d92eb0,0x98a52eb1,0x661b015c}},	//   _suly, rkwe, тиле, vluk,
   {{0x69d92eb2,0x62980305,0x63aa0088,0x3f83003e}},	//   skwe, _opvo, _nafn, ngju_,
   {{0x2365031a,0x69d901cb,0x00000000,0x00000000}},	//   valj_, pkwe, --, --,
   {{0xceb40130,0x7bce2eb3,0x44272eb4,0xf9932eb5}},	//   ריק_, _zobu, _shn_, _حبس_,
   {{0x661b06ee,0x23652ceb,0xf8bf0146,0x64422eb6}},	//   rluk, talj_, _šéf_, _cuoi,
   {{0x9aa40018,0x7641083e,0x7dd82eb7,0xd7670018}},	//   _جمہو, _tuly, _písk, _سائٹ,
   {{0x386d2eb8,0xb17b038c,0xd6db0084,0x63aa2eb9}},	//   _hver_, rhån, _эта_, _dafn,
   {{0x999800d9,0xa06a192f,0xdb1c2eba,0x2365015c}},	//   _kurš_, мама_, _corù, salj_,
   {{0x4427063f,0x9f9d0139,0x2365015c,0x2ee601c2}},	//   _thn_, _bìà_, palj_, _ƙofo_,
   {{0xb4bf02e8,0xb4cd009d,0x29f80ebd,0x3f8301cd}},	//   ीही_, रही_, nčar_, ggju_,
   {{0x248d2ebb,0x91a000de,0x6fd901b9,0x7dd80503}},	//   ltem_, _thì_, _mìch, _hísi,
   {{0x386d0054,0xbcfb020d,0x7bce0201,0xb17b02c3}},	//   _over_, _adéq, _sobu, nhål,
   {{0x248d2ebc,0x9f58003e,0xe7f208d4,0xa2a92ebd}},	// [23c0] ntem_, borð_, _अगला_, टिक्,
   {{0xeafa1629,0x7dd82ebe,0x248d2ebf,0x7bce2ec0}},	//   ورات_, _mísi, item_, _qobu,
   {{0x386d013d,0xdb1c0649,0x6f79006e,0x317200b6}},	//   _aver_, _yorù, _אָרג, _kdyz_,
   {{0xe9da00d6,0x248d2ec1,0x7bce019f,0xe8fa007b}},	//   ьке_, ktem_, _wobu, мле_,
   {{0xe8942ec2,0x7bce2ec3,0x6b87009c,0x7982007f}},	//   уаль, _tobu, _fcjg, rgow,
   {{0x248d2ec4,0x65622ec5,0x25ad2c97,0x394d2ec6}},	//   dtem_, _seoh, edel_, _efes_,
   {{0x386d00a1,0x973c0a39,0x00000000,0x00000000}},	//   _ever_, _jaći, --, --,
   {{0x63aa0088,0xa01b0103,0xab270e05,0xb4cd0d75}},	//   _safn, ltöt, _роса_, रहू_,
   {{0x64422ec7,0x98a3038f,0x248d2ec8,0x9987020a}},	//   _quoi, _ките, gtem_, ţiţi_,
   {{0x32020038,0x7c3c03e5,0x660d2ec9,0x25ad2eca}},	//   enky_, _jirr, čaka, adel_,
   {{0x51f9036c,0x7c3c2ecb,0x386d096d,0x27e90044}},	//   енню_, _mirr, _zver_, ɗan_,
   {{0xcb13040a,0x973c14f3,0x91a000fe,0x644200fe}},	//   ילת_, _naći, _phí_, _tuoi,
   {{0x6abf009d,0x248d00ee,0xfc3f0139,0x7c3c01b5}},	//   _एप्र, ctem_, _asín_, _oirr,
   {{0x7c3c2ecc,0xdb1c01df,0x200500bc,0x00000000}},	//   _nirr, _forø, õli_, --,
   {{0xbcfb0032,0xb5fc02a1,0x973c0357,0x9f58003e}},	//   _adép, _ewġe, _baći, rorð_,
   {{0x3253013d,0x7c3c009c,0x443c00d7,0x61e6042c}},	//   _твър, _airr, _hiv_, chkl,
   {{0x443c2ecd,0x7c3c2ece,0xbddb00fd,0xdb050037}},	// [23d0] _kiv_, _birr, _lièg, rdhí,
   {{0x7c3c2ecf,0x3b542ed0,0xe7bd0081,0x7c84016c}},	//   _cirr, икур, _অত্য, јуте,
   {{0x443c2ed1,0x20032461,0x248d0018,0x3a751894}},	//   _miv_, mnji_, ztem_, улер,
   {{0xe7e5110f,0x443c2ed2,0x973c01ac,0x00000000}},	//   कसभा_, _liv_, _gaći, --,
   {{0xd5b600c3,0x6d4d008c,0x851e074c,0x67d52877}},	//   _अफ़ज, mcaa, _परगट_, лоду,
   {{0x443c2ed3,0x6e3d03e3,0x00000000,0x00000000}},	//   _niv_, _hisb, --, --,
   {{0x6e3d2ed4,0xb17b02c3,0x32020e4b,0x00000000}},	//   _kisb, thål, ynky_, --,
   {{0x248d0068,0x069600e3,0x443c023e,0x26c9005f}},	//   ttem_, انية_, _aiv_, ćao_,
   {{0x6e3d2ed5,0x25ad17d2,0xb17b0222,0x20030141}},	//   _misb, rdel_, rhål, knji_,
   {{0x7dd80102,0x200308a9,0x248d2ed6,0xb17b0149}},	//   _vísi, jnji_, rtem_, shål,
   {{0x7d1d0222,0x17f800e3,0x998600c4,0x00000000}},	//   _lyss, _شركة_, lmoš_, --,
   {{0x64b50f43,0x6e3d2ed7,0x5ed70033,0x248d2ed8}},	//   _محتر, _nisb, _ডেভে, ptem_,
   {{0x443c2ed9,0x20041789,0x7d1d084e,0x00000000}},	//   _fiv_, émio_, _nyss, --,
   {{0x443c01c5,0x75fe00d9,0xa2ab06e4,0x6d4f041c}},	//   _giv_, vīzi, _जनप्, _afca,
   {{0x6e3d2eda,0xdee32edb,0xe81b009f,0xf3f000e3}},	//   _bisb, бори, _पीछा_, _بأن_,
   {{0x7c3c2edc,0x443c08a9,0xdca62edd,0x6d4f01ff}},	//   _sirr, _ziv_, лаби, _cfca,
   {{0x7c3c2ede,0xa3d71757,0x443c023e,0x61e42edf}},	// [23e0] _pirr, _सवा_, _yiv_, _ilil,
   {{0xfc3f00e3,0x79890022,0x63a12ee0,0x20030a39}},	//   _tsín_, _acew, neln, cnji_,
   {{0x7c3c2ee1,0x61e40113,0xdce400c6,0x9f580216}},	//   _virr, _klil, maič, hirë_,
   {{0x7cda01d3,0xaa57071c,0x5f46010d,0x63a12ee2}},	//   _pārā, النا_, _جنگل, heln,
   {{0xb4cd007d,0x7c3c003d,0xd917013a,0x62812ee3}},	//   रहो_, _tirr, льш_, hulo,
   {{0x62812ee4,0x63a108a9,0xbddb00fd,0xda660037}},	//   kulo, jeln, _pièg, _ماري,
   {{0x63a12ee5,0x1ae600c2,0x998d0220,0x61e40129}},	//   deln, _совм, _sieť_, _olil,
   {{0x443c0d7d,0x6e3d0694,0x20031197,0xa01b0149}},	//   _siv_, _xisb, znji_, ntör,
   {{0x443c0197,0x69c02ee6,0x80a40ed3,0x09060f99}},	//   _piv_, _inme, _चैले, _спан,
   {{0x61e42ee7,0x644f2ee8,0x443c006c,0x63a12ee9}},	//   _alil, ícia, _qiv_, geln,
   {{0x443c2eea,0xa01b2eeb,0x7bde00dc,0x20030357}},	//   _viv_, ktör, ikpu, vnji_,
   {{0x154628c2,0xa01b0084,0xe13500c2,0x61e4009c}},	//   _седм, ytös, инны, _clil,
   {{0x443c0197,0x20030039,0x6e3d0968,0xc10800ae}},	//   _tiv_, tnji_, _risb, гэре_,
   {{0x62812eec,0x53341f5d,0x7d1d2eed,0x3cff013f}},	//   bulo, _келт, _ryss, _žuvo_,
   {{0x62812eee,0x9f3500d6,0x539b00a1,0x7d1d0e3e}},	//   culo, реві, _ניהו, _syss,
   {{0x200304a3,0x5d550476,0x7d1d1531,0x7bde1183}},	//   snji_, ркат, _pyss, ekpu,
   {{0x6e3d2eef,0x8f5500cd,0x20032ef0,0xad9b003e}},	// [23f0] _visb, _پنجش, pnji_, _hjúk,
   {{0x69c02ef1,0x6d4d2ef2,0x212907e7,0xad9b003e}},	//   _anme, scaa, _izah_, _kjúk,
   {{0x973c1523,0xa01b00c2,0x61e4007b,0x78a90172}},	//   _kaću, stös, _ylil, _ssev,
   {{0x63a12ef3,0x5fc30aa6,0xdb07003e,0x7d1d1aad}},	//   zeln, शावल, _snjó, _tyss,
   {{0x79c909e5,0x62812ef4,0x973c0218,0xad9b003e}},	//   _یوسف_, zulo, _maću, _ljúk,
   {{0x69c02ef5,0x244901cd,0x2d84026a,0x7bde2ef6}},	//   _enme, _rúm_, _ömer_, ckpu,
   {{0x0f5800ca,0xbddb014b,0x63a12ef7,0x4af900e5}},	//   ניהם_, _tièd, veln, _ревю_,
   {{0x660d02dd,0x9f58023b,0x78a901fa,0x9f410220}},	//   čako, tirë_, _tsev, _dlhé_,
   {{0x63a12294,0xa787110a,0x78a92ef8,0x2bc90f8f}},	//   teln, _مشاو, _usev, रापा,
   {{0x62812ef9,0x66190510,0x9f580216,0x00000000}},	//   tulo, _wkwk, rirë_, --,
   {{0x0206002d,0x21290063,0xc7c42efa,0xa2062efb}},	//   изон, _azah_, _усти, ипод,
   {{0x63a12efc,0xd9f70789,0xdb0700b6,0x3a2d0063}},	//   seln, ूचित_, _nají, _jhep_,
   {{0x7dd8000d,0x63a12efd,0x62812efe,0x3d0400a5}},	//   _míst, peln, sulo, _रखें_,
   {{0x7dd8025b,0x2d991b5a,0x0eb300aa,0x3a2d0113}},	//   _líst, _abse_, ुमंड, _lhep_,
   {{0x316b0067,0x21761067,0xdb07037a,0x420a00ae}},	//   bacz_, _купр, _bají, _инко_,
   {{0x260b07d5,0x290d0072,0x61e42eff,0x61f600d8}},	//   ावटी_, _oxea_, _ulil, _umyl,

   {{0xab662f00,0xf1bf1e6f,0xa01b186b,0x9f5801dc}},	// [2400] ивал, rmát_, rtör, hiré_,
   {{0xfbdf0f5a,0x973c0a39,0x9f5803a9,0x00000000}},	//   _stêr_, _zaću, kiré_, --,
   {{0xa01b2f01,0x0f7b0266,0x00000000,0x00000000}},	//   ptör, _בריל, --, --,
   {{0x20182f02,0x2d962f03,0xf296006e,0x23672f04}},	//   lori_, _трос, יכער_, _lenj_,
   {{0x9f512f05,0x3a2d0113,0xc7c6125f,0x69c00023}},	//   lizá_, _dhep_, иски, _vnme,
   {{0xdb07000d,0x20182f06,0x224000bc,0x7dd801cd}},	//   _zají, nori_, _liik_, _vísu,
   {{0xb76500d6,0x46671402,0xa5f82efb,0x9f582f07}},	//   стій, арым_, леку_, giré_,
   {{0xd5b719a0,0x20180150,0xba570089,0x3a3f0023}},	//   ась_, hori_, _כסלו_, _giup_,
   {{0xad9b0088,0xa4f800cd,0x20182f08,0x2247037a}},	//   _sjúk, دکار_, kori_, _aunk_,
   {{0x20182f09,0x9f58034f,0xf1bf0103,0xf7432b81}},	//   jori_, biré_, ymás_, _дефо,
   {{0x20182f0a,0x91fd00d9,0xa6ca00e3,0x0bb700a1}},	//   dori_, ksāt, _جوال_, בלים_,
   {{0x7dd82f0b,0xdb1c0cb6,0x05830d86,0xd49a2f0c}},	//   _míss, _horó, _душм, _арк_,
   {{0x76482f0d,0x24540182,0x291f023e,0x20182f0e}},	//   _hudy, _انتس, _xyua_, fori_,
   {{0xb7f8022d,0x7a2300aa,0xdb1c0139,0x00000000}},	//   ्चिम_, võtm, _joró, --,
   {{0x62350476,0xdb1c2df7,0xe8172397,0x22470090}},	//   _леку, _moró, दकता_, _gunk_,
   {{0x5d78007b,0x23672f0f,0xfe7902c6,0xaac700d1}},	//   ийся_, _zenj_, čů_, یتان,
   {{0x2018042d,0x409500e3,0xdb070146,0x71f800d1}},	// [2410] bori_, _الخر, _vají, _خروس_,
   {{0x20182f10,0xdb0e00cd,0x3a3f0167,0xcc250033}},	//   cori_, _kabè, _siup_, বদ্ধ_,
   {{0x24840124,0x44290022,0x3a2d0023,0xdb0e022b}},	//   humm_, _ɗa_, _phep_, _jabè,
   {{0x29d703e0,0x3219109b,0x00000000,0x00000000}},	//   _açar_, nosy_, --, --,
   {{0x7dd8124d,0xa8a700c2,0xdb0e0513,0x7648007f}},	//   _víst, ррек, _labè, _audy,
   {{0xf77104f4,0xab842f11,0x764800a5,0x61fd2f12}},	//   سات_, _муск, _budy, hisl,
   {{0x3a3f02e7,0x61fd2f13,0x2ca900f0,0xe8df0139}},	//   _tiup_, kisl, lwad_, _igọn_,
   {{0x61fd2f14,0x644f2f15,0x23670ebd,0x2d890a4b}},	//   jisl, ício, _senj_, ngae_,
   {{0x442e02ef,0x20182f16,0x2240007a,0x2ca900f0}},	//   _bhf_, yori_, _riik_, nwad_,
   {{0x53c92f17,0xdb0e0154,0xdb1c0139,0x60dd2f18}},	//   угом_, _babè, _goró, dysm,
   {{0x216a29db,0x7a23007a,0xdb1c015e,0x31690062}},	//   лини_, võtj, _horò, _beaz_,
   {{0x442e0088,0x78bb2f19,0xddce00e8,0x00000000}},	//   _ehf_, _kruv, rsbū, --,
   {{0x63c200b6,0x799b2f1a,0x442e2f1b,0x67212f1c}},	//   ávní, _mbuw, _fhf_, _hylj,
   {{0xd91a00a1,0xb4e317ff,0xe8df00de,0x76480167}},	//   רושל, ननी_, _ngọn_, _yudy,
   {{0x799b2f1d,0x20182f1e,0xe29900ae,0xc2551850}},	//   _obuw, rori_, _сай_, _اختت,
   {{0xfbdf0019,0x22910103,0xa2c400b7,0xdb1c042c}},	//   _quên_, mák_, िमर्, _vorü,
   {{0xbddb0257,0x7bd501e8,0x2ca90124,0x229110a8}},	// [2420] _sièc, _bozu, gwad_, lák_,
   {{0xbddb04ea,0x9f862f1f,0x20181a4a,0xdb0e2f20}},	//   _pièc, _угод, qori_, _habé,
   {{0xfe72223e,0x1c3900a9,0xdb0e01dc,0x6c330037}},	//   _عدد_, рять_, _kabé, أفلا,
   {{0xed3600ae,0x3eb8080e,0xed5a008f,0x78bb00f3}},	//   _гэгэ, mvrt_, _щом_, _bruv,
   {{0xdb1c2f21,0xad9b0032,0x25f60789,0x6d460124}},	//   _poró, _ajúw, एफसी_, _igka,
   {{0x6e24131f,0xa09b00f5,0x2bc907b2,0x22910103}},	//   llib, ריסט, राणा, kák_,
   {{0x22912f22,0x3eb80087,0x78bb037a,0x61fd2f23}},	//   ják_, nvrt_, _eruv, yisl,
   {{0x54542f24,0x61fd08a8,0xfbc904f8,0x6e240bb6}},	//   овит, xisl, राथम, nlib,
   {{0x61fd0074,0x7bd5013c,0x6d460270,0x78bb2ba4}},	//   visl, _yozu, _mgka, _gruv,
   {{0xb2742f25,0x764800f9,0xd4970109,0x4adc1e05}},	//   олош, _tudy, ёры_, _यथाव,
   {{0x61fd0038,0x764807ac,0x17570796,0x6d5f008c}},	//   tisl, _uudy, _הסבר_, ybqa,
   {{0xd46a00c9,0x6446003e,0x60dd007b,0x61fd0a4b}},	//   _биде_, íkis, tysm, uisl,
   {{0xdce60090,0x682d0031,0xdb071f20,0xdb0e00d8}},	//   _dekċ, súde, _majá, _dabé,
   {{0x22912f26,0x6d462f27,0x61fd2f28,0xdb0e01dc}},	//   bák_, _agka, sisl, _tabè,
   {{0x7bd52f29,0x8c000033,0x8234001c,0xdd9b00e5}},	//   _rozu, ্তান_, تریا, лша_,
   {{0x6e242f2a,0xbcfb0018,0x4cd10033,0x7bd52f2b}},	//   glib, _idéz, _সেগু, _sozu,
   {{0x7bd50092,0xe1ff275a,0x76420239,0x00000000}},	// [2430] _pozu, mió_, _mioy, --,
   {{0xe1ff2f2c,0x6e24083e,0xdb1c24c7,0x29fe0129}},	//   lió_, alib, _enrí, ọala_,
   {{0xe7c700a5,0x7bd502ef,0x00000000,0x00000000}},	//   लासप, _vozu, --, --,
   {{0xe1ff0990,0x78bb2f2d,0x3ebe052f,0xddab2f2e}},	//   nió_, _pruv, ætte_, _стол_,
   {{0x7bd52f2f,0x3ea10167,0x2bc90034,0x7c8400ae}},	//   _tozu, _hpht_, रादा, _нуре,
   {{0x22910103,0x8bcb00ae,0xe78700ba,0x2bcb0231}},	//   yák_, _сымб_, судо, _сумо_,
   {{0x99852f30,0xdddc0a39,0x75221c7b,0x00000000}},	//   _ولسو, lurš, _ayoz, --,
   {{0x64990f32,0x22912f31,0x91a90023,0x78bb2f32}},	//   атор_, vák_, _nhà_, _truv,
   {{0xe1ff2f33,0xb4e300a5,0x13e92f34,0x66df0139}},	//   dió_, नने_, имий_, _bàkú,
   {{0x22912e16,0x22510146,0xdb0e2f35,0xe2910076}},	//   ták_, ízko_, _sabé, وذج_,
   {{0xd5ae00bf,0xe29900f6,0x645b2f36,0x2329141a}},	//   رفی_, шан_, spui, рони_,
   {{0xe1ff2f37,0xbba60455,0x22910730,0x36340037}},	//   gió_, _ऑस्क, rák_, _فرنس,
   {{0x22912e16,0x601b020a,0x66091a8a,0x661b0dd8}},	//   sák_, tîmp, mnek, mouk,
   {{0xa2e5016a,0x3eb80542,0x645923d1,0x661b2f38}},	//   _молд, tvrt_, _itwi, louk,
   {{0xdb1c0102,0x7f432f39,0xe1ff0081,0x66090010}},	//   _norð, держ, bió_, onek,
   {{0xe1ff2f3a,0x66092f3b,0x644b092f,0x64432f3c}},	//   ció_, nnek, _kugi, _hini,
   {{0x656b2f3d,0x6e24005a,0x44252e6a,0x644b007e}},	// [2440] _megh, rlib, oll_, _jugi,
   {{0x9f580080,0xdb070068,0x644b2f3e,0xdb1c0088}},	//   oirí_, _sajá, _mugi, _borð,
   {{0x44252f3f,0x9d462a84,0x661b2f40,0x644b2f41}},	//   ill_, _менд, kouk, _lugi,
   {{0xa92607f3,0x661b00c2,0x2bdc030b,0x64590034}},	//   одел, jouk, _मकवा, _otwi,
   {{0x76420113,0xdce605db,0x7dd80231,0x682400ee}},	//   _rioy, _kekč, _uísq, lòdi,
   {{0x660901e9,0x64432f42,0xdb1c003e,0xe1ff0103}},	//   enek, _nini, _forð, zió_,
   {{0x644b013f,0x98a30138,0x656b028d,0x645905bd}},	//   _augi, _ąją_, _begh, _atwi,
   {{0x64432f43,0x644b2f44,0x44252f45,0xd49a0a52}},	//   _aini, _bugi, ell_, аро_,
   {{0x64432f46,0x656b2f47,0xe1ff058a,0x644b2f48}},	//   _bini, _degh, vió_, _cugi,
   {{0x64432f49,0x644b0995,0xa2f400d6,0x539700c2}},	//   _cini, _dugi, зпоч, овья_,
   {{0xe1ff0890,0x661b2f4a,0xe3b801e8,0x644b01ff}},	//   tió_, bouk, llık_, _eugi,
   {{0x644b2f4b,0x64430e78,0x81e30033,0xd5a6001c}},	//   _fugi, _eini, ফোন_, _گلچی,
   {{0xe1ff0890,0xe3b801e8,0x6443188c,0x62812f4c}},	//   rió_, nlık_, _fini, arlo,
   {{0xe1ff0990,0x64432f4d,0xd25000e3,0xbddb0472}},	//   sió_, _gini, _كنت_, _cièn,
   {{0x3a262f4e,0x2ee5003e,0xbddb01dc,0x2bc92f4f}},	//   klop_, álf_, _dièn, रासा,
   {{0x63a82f50,0x644b02e5,0x64432f51,0x62882f52}},	//   ledn, _yugi, _zini, mudo,
   {{0x62880081,0x25d70266,0x7dd800e1,0x64432f53}},	// [2450] ludo, קומן_, _vísp, _yini,
   {{0xa2be05a5,0x60c002b6,0x9b27007b,0x6443026d}},	//   षिप्, æmme, офел, _xini,
   {{0x62882f54,0x2bdc0285,0x66092f55,0x67ef0537}},	//   nudo, _मकरा, ynek, _højg,
   {{0x660002c6,0xda78097a,0xdb1c0653,0x2bc902c6}},	//   jimk, іях_, _vorð, राहा,
   {{0x44252f56,0x998d0181,0xad9b0103,0x656b2f57}},	//   yll_, _tiež_, _amúg, _regh,
   {{0x63a80ca7,0x644b2f58,0x62882f59,0x656b028d}},	//   jedn, _rugi, kudo, _segh,
   {{0xfbd20054,0x644b2f5a,0x661b2f5b,0x64432f5c}},	//   _אתם_, _sugi, touk, _rini,
   {{0x2bc917ff,0x644b2f5d,0xc6210033,0x3a2600b3}},	//   रावा, _pugi, _পূজা_, clop_,
   {{0x64432f5e,0x656b2f5f,0xdb070231,0x5a44002d}},	//   _pini, _vegh, _enjô, _цэра,
   {{0x656b2f60,0x6443019f,0x682d0031,0x66092f61}},	//   _wegh, _qini, búda, snek,
   {{0x442500eb,0x04c900d1,0xdce60154,0x39400234}},	//   rll_, _گوشي_, _rekč, žist_,
   {{0x644b2f62,0x7a310727,0x64432f63,0xdce600d4}},	//   _tugi, båte, _wini, _sekč,
   {{0x64432f64,0x63a80284,0x7bc701c0,0x64592f65}},	//   _tini, bedn, _onju, _utwi,
   {{0x628812fb,0xdfd20f98,0x682400b3,0x00000000}},	//   budo, ريز_, tòdi, --,
   {{0xf1bf0080,0x62882027,0xe7f30006,0xe3b8026a}},	//   mlán_, cudo, _अतना_, zlık_,
   {{0x7bc72f66,0x67ef052f,0x40962f67,0x6d4b0087}},	//   _anju, _højd, _ерот, žgan,
   {{0xdca31107,0x32020146,0x00000000,0x00000000}},	// [2460] нати, miky_, --, --,
   {{0xa09700f5,0x66000555,0x32021515,0xdb1c02c3}},	//   _צדיק_, zimk, liky_, _morö,
   {{0x3ce6135f,0xf1bf002b,0x34a81678,0x4a461982}},	//   šov_, ilán_, _कन्द, чнев,
   {{0x3202025b,0x63a800a5,0x8c4600c2,0xaca40294}},	//   niky_, zedn, _неме, _ahụr,
   {{0xd7c70b79,0xe8942f68,0x2bc9055c,0x394000ce}},	//   लांच, фаль, राशा, äis_,
   {{0xdb0e11ce,0xe3b801e8,0x9f582f69,0x7bc70357}},	//   _habí, rlık_, nirà_, _gnju,
   {{0xcfb60081,0xfbc90976,0x3a262253,0xa01b17a5}},	//   ঞাপন, रारम, plop_, krön,
   {{0xf64f00cd,0xceb300ca,0x682d0076,0x62882f6a}},	//   دئو_, תיה_, rúda, vudo,
   {{0x66002f6b,0x62880134,0x32020094,0x00000000}},	//   rimk, wudo, diky_, --,
   {{0x62882f6c,0x68420065,0x66000a4b,0xb05b0212}},	//   tudo, _dídì, simk, lväg,
   {{0x63a80fee,0xa75b00a1,0x32020146,0x9f582f6d}},	//   redn, _הדבר, fiky_, dirà_,
   {{0xdb0e033a,0x6288052f,0x63a8200b,0xaca40065}},	//   _nabí, rudo, sedn, _awọt,
   {{0x68e22f6e,0x2fda03a4,0x7a2300aa,0xbddb0113}},	//   nyod, _bopg_, mõtt, _dièl,
   {{0xa01b0103,0x2d9c0103,0xf1bf2f6f,0xe47b0142}},	//   ltöz, ővel_, clán_, _פרוכ,
   {{0xa3b50490,0x245200de,0x32020031,0xe3b803e0}},	//   _चोट_, _hâm_, biky_, mdı_,
   {{0xe3b80702,0xdb0e065b,0x3ebe2f70,0x61e62f71}},	//   ldı_, _cabí, ætta_, ckkl,
   {{0x61ed2f72,0x67ef01c5,0x9f582f73,0x2bc92f74}},	// [2470] _ilal, _høje, birà_, राला,
   {{0xe3b80702,0x68e22f75,0x9f580451,0x24520023}},	//   ndı_, dyod, cirà_, _mâm_,
   {{0x20032f76,0x24520019,0xbd02029a,0xdb0e0231}},	//   miji_, _lâm_, _éénm, _fabí,
   {{0x9f5810d9,0xa954004d,0x00000000,0x00000000}},	//   mirá_, екці, --, --,
   {{0x61ed198d,0xbc770031,0x9f58034f,0x00000000}},	//   _mlal, ýšľa, lirá_, --,
   {{0xb8d504dd,0x7bc70479,0x61ed2f77,0xdb0e1054}},	//   _जन_, _unju, _llal, _zabí,
   {{0xdce600d9,0x9f582ad4,0xe69200cd,0x67ef02b6}},	//   _iekā, nirá_, نلود, _nøje,
   {{0x20032f78,0xb9c500e3,0xe459079c,0x61ed03a9}},	//   hiji_, _تقري, ожи_, _nlal,
   {{0xdcfd0587,0x69c92851,0xf1bf0a43,0x245200fe}},	//   _kası, _inee, tlán_, _câm_,
   {{0x61ed23b6,0x20032f79,0x69c901fa,0x24520019}},	//   _alal, jiji_, _hnee, _dâm_,
   {{0x3202025b,0x61ed2f7a,0x69db0313,0x7a430065}},	//   tiky_, _blal, _koue, _gìtì,
   {{0x471a07a6,0x69db04ea,0xd6d80084,0x9f582f7b}},	//   _וועג, _joue, _эту_, dirá_,
   {{0x2509172a,0x69db2f7c,0x32020146,0x2bb2023a}},	//   _برای_, _moue, riky_, ीयमा,
   {{0xdcfd0b88,0xdb0e0af3,0x69db2f7d,0xdce600d9}},	//   _nası, _sabí, _loue, _nekā,
   {{0x9f582f7e,0x69c92f7f,0x50431262,0x00000000}},	//   rirà_, _onee, терб, --,
   {{0x61ed0113,0x69c90517,0x69db2f80,0x20030350}},	//   _glal, _nnee, _noue, aiji_,
   {{0x20031386,0xdcfd03a3,0x245200de,0xdb150052}},	// [2480] biji_, _bası, _xâm_, _fazë,
   {{0x9f5804d8,0x69c92f81,0xe50e00c0,0x68e20239}},	//   birá_, _anee, ापति_, vyod,
   {{0x69db2f82,0x9f580610,0xfc3f0328,0x00000000}},	//   _boue, cirá_, _asís_, --,
   {{0xa9670ac6,0x79a31fdb,0x09061bb8,0xe3b80511}},	//   дица_, врше, мпен, zdı_,
   {{0x7a23007a,0xd6cf00cd,0xe3b803a3,0xe9ff00de}},	//   võtt, یقه_, ydı_, _giận_,
   {{0x68e22f83,0xb05b0149,0x69c9083e,0xe3b800a7}},	//   ryod, sväg, _enee, xdı_,
   {{0x24522f84,0x7a2300aa,0x69db020d,0x7bdc0076}},	//   _sâm_, tõtt, _foue, _ioru,
   {{0x7bdc008a,0xc88301e8,0x69db1a8d,0x00000000}},	//   _horu, üğü_, _goue, --,
   {{0x7bdc2f85,0xe3b800a7,0x9f580131,0xdcfd0342}},	//   _koru, tdı_, zirá_, _yası,
   {{0x61ed0d62,0x88bd00a5,0x7bdc00f3,0x00000000}},	//   _slal, _myśl, _joru, --,
   {{0x200308a9,0xe3b80702,0x61ed2f86,0x9f580042}},	//   viji_, rdı_, _plal, xirá_,
   {{0x245200ef,0x7bdc0032,0x9f580165,0x3869020a}},	//   _tâm_, _loru, virá_, ţare_,
   {{0x60f8055b,0xdb0e0154,0xd5cf020b,0xdb150216}},	//   дняя_, _labà, _kềnh_, _pazë,
   {{0x9f5809d3,0x67ef02b6,0x14d70266,0x00000000}},	//   tirá_, _tøje, _קוגל_, --,
   {{0x61ed2f87,0xdb1505aa,0xe7e6007a,0xd5cf00fe}},	//   _tlal, _gazè, _कवना_, _mềnh_,
   {{0x200308a9,0x9f582f7b,0x63b80856,0x61ed0415}},	//   siji_, rirá_, _havn, _ulal,
   {{0x69db0257,0x22980470,0x629a2c37,0xad9b003e}},	// [2490] _roue, lék_, ltto, _djúp,
   {{0x7bdc2f88,0xfe710068,0x69c92f89,0x69db0154}},	//   _coru, _مگر_, _snee, _soue,
   {{0x7bdc01d9,0x69db2f8a,0x495c0129,0xdb0e0db4}},	//   _doru, _poue, _ịtụ_, _cabà,
   {{0x7bdc0154,0xdb0e0161,0x629a007b,0xf1bf2f8b}},	//   _eoru, _sabã, itto, klám_,
   {{0x18692887,0x07a508c3,0xd5cf00fe,0x22490350}},	//   чали_, еалн, _bềnh_, _miak_,
   {{0x63b80939,0x7bdc2f8c,0xdb0705fe,0x76b300a7}},	//   _navn, _goru, _majú, _həyə,
   {{0x26c1033a,0xd6d118a9,0x48ff009f,0x00000000}},	//   ího_, اقع_, _शेरो_, --,
   {{0x22980018,0x7bdc01e8,0x99980138,0x7a311f60}},	//   dék_, _zoru, _durų_, båta,
   {{0x7bdc2f8d,0x21290063,0xdb070031,0x629a166f}},	//   _yoru, _nyah_, _najú, etto,
   {{0xf6e7166f,0x2bd20096,0x224901ff,0x63b8044c}},	//   _оцен, साया, _aiak_, _cavn,
   {{0x63b803ce,0x2129005a,0xdb15025b,0xdb0e2299}},	//   _davn, _ayah_, _bazé, _kabá,
   {{0x22492f8e,0xbddb03a9,0x70cb2f8f,0x386d0154}},	//   _ciak_, _dièk, ामूल, _kwer_,
   {{0x629a0084,0x25ad2f90,0x64a501b3,0x2bd20096}},	//   atto, meel_, _чала, सामा,
   {{0x21292f91,0x63b802b6,0x25ad2f92,0xdb0e02c3}},	//   _dyah_, _gavn, leel_, _inbö,
   {{0x5f1a0251,0x6da62f93,0x76b30092,0xada600c2}},	//   _मुख्_, нива, _bəyə, навл,
   {{0x7bdc210e,0x25ad04ee,0xc1ba00ab,0x22490124}},	//   _soru, neel_, _رابط_, _giak_,
   {{0x7bdc021d,0x76b30092,0x248d2f94,0x1de1007a}},	// [24a0] _poru, _dəyə, nuem_, _नवरत,
   {{0xa09b0130,0x25ad0cad,0x7bdc01d4,0x1f6616dd}},	//   _צייט, heel_, _qoru, _яком,
   {{0x386d0113,0x88bd00a5,0x7bdc0088,0xed5a0dcc}},	//   _awer_, _wyśl, _voru, _нон_,
   {{0x60c42f95,0xd9100260,0x70770421,0x386d2f96}},	//   _krim, لیز_, _تمیز_, _bwer_,
   {{0x25ad0305,0xbcfb0065,0x7bdc2f97,0x21290063}},	//   deel_, _aféf, _toru, _xyah_,
   {{0x60c4270d,0xe7c700a3,0xd6da0208,0x00000000}},	//   _mrim, लागप, зти_, --,
   {{0x63b8011d,0x629a01b9,0x2cb20150,0xa96a2f98}},	//   _ravn, xtto, lwyd_, _нива_,
   {{0x63b82f99,0x2d922f9a,0x60c42f9b,0x7af20233}},	//   _savn, ngye_, _orim, ıktı,
   {{0x248d24ba,0x2cb202ad,0x22492f9c,0x60c400d1}},	//   guem_, nwyd_, _riak_, _nrim,
   {{0x22980068,0xa87b0054,0xa01b2f9d,0xdb0e2c85}},	//   ték_, _מאמר, tröm, _zabá,
   {{0x60c42f9e,0x05662f9f,0x7dd80018,0x21290706}},	//   _arim, _звен, _dísz, _syah_,
   {{0x60c42fa0,0x22980470,0x20010212,0x248d0131}},	//   _brim, rék_, _smhi_, buem_,
   {{0x60c42fa1,0xd5af0867,0x629a2fa2,0x66022fa3}},	//   _crim, _دفن_, stto, _imok,
   {{0x2cb20150,0x7c3e0381,0x00000000,0x00000000}},	//   dwyd_, jmpr, --, --,
   {{0x443e02dc,0x60c42fa4,0x6e260167,0x00000000}},	//   mmt_, _erim, _bkkb, --,
   {{0x7c3e124d,0x442c2fa5,0x60c40407,0xbcfb0103}},	//   empr, lld_, _frim, _beép,
   {{0x644a2fa6,0x60c421ad,0x2cb20150,0x443e01cb}},	// [24b0] _kifi, _grim, gwyd_, omt_,
   {{0x62880036,0x644a009e,0xdb150031,0xdb0e0850}},	//   ordo, _jifi, _enzý, _sabá,
   {{0x442c003e,0x67ef02b6,0x25ad008c,0x443e2fa7}},	//   ild_, _nøja, yeel_, imt_,
   {{0x443e0364,0x644a2fa8,0x24670139,0xf1bf00d4}},	//   hmt_, _lifi, _jímò_, dlák_,
   {{0x25ad0db8,0x644a003b,0x7ae5007b,0xa91d0141}},	//   veel_, _oifi, syht, _odže,
   {{0x644a2fa9,0x660202a4,0xd83805aa,0x6e2d2faa}},	//   _nifi, _amok, _chč_, llab,
   {{0x6e2d0cfd,0x25ad2fab,0x2011028d,0x79a701b3}},	//   olab, teel_, inzi_, _прае,
   {{0x6e2d2fac,0x2bc9030b,0x02a20294,0xa91d009a}},	//   nlab, राका, _chọọ, _adže,
   {{0x8cc400a5,0x6e2d0054,0x644a0193,0x25ad04e2}},	//   रियो, ilab, _bifi, reel_,
   {{0x6e2d0060,0xd6db00d3,0xee0e0285,0xd7f82fad}},	//   hlab, _нте_, _िद्ध_, _пух_,
   {{0x60c42fae,0x6e2d2faf,0x25ad000b,0x6d5d2fb0}},	//   _srim, klab, peel_, _ofsa,
   {{0xd70d0557,0x442c01c0,0x443e0d87,0x644a2fb1}},	//   िपीठ_, ald_, amt_, _eifi,
   {{0x644a2998,0x248d2fb2,0xe3ae263d,0x6e2d2fb3}},	//   _fifi, quem_, _кб_, dlab,
   {{0x6569038c,0x7a382fb4,0x644a02a4,0x6e2d2fb5}},	//   lbeh, míte, _gifi, elab,
   {{0x91fd00d9,0x6e2d2fb6,0x44270063,0x7a380182}},	//   mpān, flab, _ikn_, líte,
   {{0x6e2d2fb7,0xa6e90019,0x65692fb8,0x60c41173}},	//   glab, _trươ, nbeh, _trim,
   {{0x7a382fb9,0x1d071121,0x60c42fba,0x44270479}},	// [24c0] níte, вети_, _urim, _kkn_,
   {{0xdca31dde,0x2bd20d88,0x6e2d2fbb,0x2cb20150}},	//   рафи, साधा, alab, rwyd_,
   {{0xee3a2311,0x44271d49,0xeb972fbc,0xb11300ac}},	//   _оно_, _mkn_, тих_, bụsa,
   {{0x656901c0,0xa3c82fbd,0x58860109,0x44272fbe}},	//   jbeh, _लोन_, выка, _lkn_,
   {{0x443e1df0,0x442c2fbf,0xdce40106,0x26c501e9}},	//   ymt_, yld_, obič, _arlo_,
   {{0x65690220,0x02a20134,0x66022fc0,0xc8650037}},	//   ebeh, _shọọ, _smok, اطني,
   {{0x644a2fc1,0x6009042d,0xa3d52fc2,0x764b2fc3}},	//   _rifi, nžma, हान_, _bigy,
   {{0x644a2fc4,0x44272fc5,0x6adb0081,0x7ae316f9}},	//   _sifi, _akn_, _যেকো, änte,
   {{0x41d6000c,0x44270808,0x7a380018,0x644a034f}},	//   धानस, _bkn_, gíte, _pifi,
   {{0x442c0054,0x38662fc6,0x52d80120,0xdce405db}},	//   uld_, mpor_, емою_, jbič,
   {{0x764b0068,0x443e0f05,0x442c2042,0xd5af2fc7}},	//   _figy, rmt_, rld_, _кс_,
   {{0xad9b0065,0x6e2d0072,0x764b030a,0x6602063d}},	//   _amún, xlab, _gigy, _umok,
   {{0x442c0063,0x7bce02ac,0x7a15007f,0x00000000}},	//   pld_, _onbu, kątn, --,
   {{0x44270072,0x6e2d2fc8,0x764b0172,0x00000000}},	//   _gkn_, wlab, _zigy, --,
   {{0x6e2d2fc9,0xd3780034,0xdbdc003e,0x00000000}},	//   tlab, mać_, _ráðl, --,
   {{0x51872c49,0x6e2401e9,0x7bce2fca,0xd3780034}},	//   _рука, goib, _anbu, lać_,
   {{0x6e2d2fcb,0x31792fcc,0xe3b8013c,0x00000000}},	// [24d0] rlab, masz_, llıq_, --,
   {{0x317900fb,0xd37800a5,0x6e2d2fcd,0xa3d50efb}},	//   lasz_, nać_, slab, हाय_,
   {{0xf09f2fce,0x1622269c,0x78a90220,0x6e242fcf}},	//   ltà_, मवार_, _spev, boib,
   {{0xd3782fd0,0xf1bf0065,0xfd1f0032,0xa01b003e}},	//   hać_, ndá_, _adìe_, fsög,
   {{0xd37800a5,0xf09f2fd1,0xa7a92fd2,0x9d140120}},	//   kać_, ntà_, екла_, _вдяч,
   {{0xe7392277,0xf09f2af2,0xd378007f,0x7a382fd3}},	//   нел_, ità_, jać_, víte,
   {{0xd3780067,0x9f510890,0x31792214,0x6569225b}},	//   dać_, lizó_, kasz_, tbeh,
   {{0x26c502e6,0xe3b80092,0xa2d61678,0x00000000}},	//   _vrlo_, dlıq_, यमन्, --,
   {{0x75f5030b,0x39152fd4,0x78a90146,0x2ed02fd5}},	//   _náze, _смар, _upev, _हप्त,
   {{0x7a380b05,0x7c250146,0xd3780034,0x9f410206}},	//   ríte, nohr, gać_, _dlhú_,
   {{0x420a0d47,0xf09f013d,0x7a382fd6,0xa91d005f}},	//   енно_, età_, síte, _udžb,
   {{0x28c70569,0x7a380103,0x442718ef,0xf1bf0231}},	//   लिपि, píte, _wkn_, gdá_,
   {{0x66091cab,0xdb1c2fd7,0x44272fd8,0x53a5065c}},	//   miek, _carê, _tkn_, _балб,
   {{0x66092fd9,0x25bd2fda,0xd378007f,0xc30401f3}},	//   liek, _hawl_, cać_, ابیو,
   {{0x44252fdb,0x249f2fdc,0x539a00a1,0x9324001c}},	//   mol_, ltum_, _ניקו, _پرون,
   {{0x66090b4b,0xe1f200bf,0x25bf2fdd,0x44252fde}},	//   niek, _دست_, ndul_, lol_,
   {{0xa3c80e28,0x6e242fdf,0xf09f00ee,0x25bd00eb}},	// [24e0] _लोड_, roib, ctà_, _mawl_,
   {{0x442502e0,0x249f2fe0,0x2d99009c,0xeb9700d3}},	//   nol_, itum_, _ecse_, лиу_,
   {{0xdee60161,0x7f9b00a1,0xc98603f2,0xb05b0212}},	//   _сони, _אביז, гули, nvän,
   {{0x44252fe1,0x200a2fe2,0xd3780034,0x249f2fe3}},	//   hol_, libi_, zać_, ktum_,
   {{0x44252fe4,0x7a1c00b6,0x25bf01c2,0xb4bf0179}},	//   kol_, jčte, ddul_, ुमो_,
   {{0x44252fe5,0x2ca00bab,0x38662fe6,0xbddb05aa}},	//   jol_, mtid_, rpor_, _chèf,
   {{0x2ca02fe7,0x44252fe1,0x09a900c7,0x38662fe8}},	//   ltid_, dol_, ওয়া, spor_,
   {{0xd3780d1b,0x200a03a3,0xb05b0149,0xf8760037}},	//   wać_, hibi_, dvän, _مهرج,
   {{0x200a2fe9,0x442502ad,0x2ca02fea,0xc79600b1}},	//   kibi_, fol_, ntid_, _مشاب,
   {{0x3a2601a2,0x44252feb,0x200a006d,0xad9b0065}},	//   loop_, gol_, jibi_, _amúl,
   {{0x53342fec,0x66092fed,0xa91d02ef,0x25bf2fee}},	//   рент, biek, _idža, bdul_,
   {{0xf09f0465,0xe3b80092,0xd37800a5,0x2ca0007a}},	//   ttà_, rlıq_, sać_, ktid_,
   {{0x44252fef,0x3dc00150,0x200a2ff0,0xf1bf2ff1}},	//   bol_, ddiw_, fibi_, rdá_,
   {{0x44252ff2,0xf09f2ff3,0xc3560465,0x682d077f}},	//   col_, rtà_, _съдъ, túdi,
   {{0x3a260a9f,0xa36f0220,0xf09f2ff4,0xe3b800a7}},	//   koop_, äčši, stà_, qlıq_,
   {{0x270e01d4,0x9f510487,0x443c0430,0xa3d509a1}},	//   _mən_, tizó_, _hhv_, हाथ_,
   {{0x9f4100dd,0x200a2ff5,0xa91d031a,0x1ae20081}},	// [24f0] _kohë_, bibi_, _odža, _গেলে_,
   {{0x320b2ff6,0x66092ff7,0xbcfb0072,0x9f510314}},	//   licy_, ziek, _aféc, rizó_,
   {{0xddd001e8,0x9e352ff8,0xa3d52ff9,0x28c700b6}},	//   _çeşi, _венч, हात_, लिभि,
   {{0x320b0034,0x44252ffa,0xdb1c00b3,0xac951be7}},	//   nicy_, zol_, _marè, _камш,
   {{0x44252ffb,0x2ca000f0,0xa3e51101,0xdb1c05aa}},	//   yol_, ctid_, _नवल_, _larè,
   {{0xba770f36,0x660900a5,0x25bd0150,0x00000000}},	//   _مارت, wiek, _sawl_, --,
   {{0x66092ffc,0xec3600a1,0x44252694,0xa26500fe}},	//   tiek, _כאשר_, vol_, _cuộ,
   {{0x249f2ffd,0x44252ffe,0x270e0092,0x3ebe003e}},	//   ttum_, wol_, _dən_, ætti_,
   {{0x44252fff,0x25bf3000,0xfa34001c,0x443c3001}},	//   tol_, rdul_, _طرفد, _bhv_,
   {{0x66093002,0x249f3003,0x78bb0a39,0x7a383004}},	//   siek, rtum_, _isuv, míta,
   {{0x249f3005,0xddc701b3,0xc5d53006,0x216a0245}},	//   stum_, gpjū, _віль, кини_,
   {{0x442502ad,0x249f003e,0xb05b0222,0xdb070103}},	//   sol_, ptum_, rvän, _hajó,
   {{0x200a3007,0xdb1c023b,0xe7b90096,0xb05b0212}},	//   tibi_, _parë, _इसाप, svän,
   {{0x88bd00a5,0x248d3008,0x44253009,0xb4fa00ca}},	//   _wyśw, mrem_, qol_, _בפני,
   {{0x645b0eb8,0x200a300a,0x5275300b,0xdb1c300c}},	//   lqui, ribi_, _тулу, _garè,
   {{0xdd92300d,0x06af0081,0x8e5502ec,0x14a90096}},	//   تور_, কিপি, стрі, _कहाण,
   {{0x248d0167,0xb05b007b,0x245b02ac,0x51f60103}},	// [2500] nrem_, nväl, _jêm_, _مسکر,
   {{0x907b0130,0x2ca00170,0x307b00a1,0x27220220}},	//   _שטיי, rtid_, _שאינ, nčné_,
   {{0x2ca0300e,0xdb15001f,0x78bb0673,0xdb1c300f}},	//   stid_, _razã, _asuv, _karé,
   {{0x7ae315bd,0x7053110a,0xb05b0149,0x61e40084}},	//   änta, _دنیا, kväl, _joil,
   {{0x270e0092,0x3a261044,0xdb1c3010,0x61e40037}},	//   _sən_, roop_, _maré, _moil,
   {{0xdb073011,0xb227003e,0x248d3012,0x18670291}},	//   _cajó, _klæð, drem_, шаљи_,
   {{0x645b037a,0xdb15016d,0xdb050364,0x61e402ac}},	//   equi, _vazã, gehä, _ooil,
   {{0xe5c60459,0x61e43013,0x443c3014,0x786600d6}},	//   рско, _noil, _shv_, _вказ,
   {{0x7a3817eb,0x6aa900e7,0x91830023,0x69c001ff}},	//   cíta, _ćefi, _nếu_, _iame,
   {{0x69c2043e,0xdb1c06a3,0x6287003d,0x53e600ae}},	//   ldoe, _parè, ġjon, рциа,
   {{0x78a23015,0x4b7b00c1,0xec3700a1,0x248d3016}},	//   ltov, כטיג, שאיר_, arem_,
   {{0x61e40091,0x248d3017,0x69c23018,0x69c03019}},	//   _coil, brem_, ndoe, _jame,
   {{0x78a20094,0xfeb803ed,0x69c010f6,0x61e4301a}},	//   ntov, یافت_, _mame, _doil,
   {{0xd7d90096,0xdb070154,0xb22701cd,0x00000000}},	//   ढायच, _majò, _blæð, --,
   {{0x69c00012,0x61e41519,0x75f50018,0x34b61fb4}},	//   _oame, _foil, _háza, _अनुद,
   {{0x5d5507f3,0xdb05070a,0x78a20094,0x69c0301b}},	//   скат, nehå, ktov, _name,
   {{0x78a2301c,0xbddb00fd,0x69c200f0,0xdb070154}},	// [2510] jtov, _bièr, ddoe, _najò,
   {{0x6fb509e5,0x7a381e6f,0xeb93097d,0x61e4301d}},	//   _امدا, víta, تظر_, _zoil,
   {{0xdb150181,0x69c00b1a,0x645b00e1,0xbddb00b3}},	//   _bazá, _bame, zqui, _dièr,
   {{0xc987193d,0x69c029b0,0x34b60034,0x645b037a}},	//   ружи, _came, _अनूद, yqui,
   {{0xf1bf0103,0xf09400c1,0xb05b0212,0xbddb020d}},	//   llás_, ַנק_, kväm, _fièr,
   {{0x645d0fb6,0xf1bf002b,0xa01b02c3,0xe8f8013f}},	//   ísim, xoán_, mrös, шлі_,
   {{0x657b0bb6,0x69c0301e,0x7a38301f,0xa3d50296}},	//   tauh, _fame, síta, हास_,
   {{0x248d3020,0x69c03021,0xff18040a,0x7a380b66}},	//   trem_, _game, יקות_, píta,
   {{0x32f70092,0xf1bf0220,0x9f410113,0x78a200d8}},	//   məyə_, hlás_, _dohé_, ctov,
   {{0x61e41b08,0x69c03022,0x248d3023,0xdb1c00cd}},	//   _soil, _zame, rrem_, _saré,
   {{0x645b3024,0x61e43025,0x69c03026,0xdb1c3027}},	//   squi, _poil, _yame, _paré,
   {{0x245b0396,0xa06a3028,0xb0c33029,0x248d302a}},	//   _têm_, лама_, शिंग, prem_,
   {{0x61e4025a,0x705600e3,0x68fc00a7,0x00000000}},	//   _voil, إنسا, _ərdo, --,
   {{0x7afe302b,0x76aa01d4,0x51f6001c,0x64590113}},	//   yzpt, _həya, _گستر, _iuwi,
   {{0x670d033a,0x229500e3,0x52850037,0x64592fee}},	//   िपटक_, _العس, _البك, _huwi,
   {{0x78a20074,0x6459302c,0x51f60100,0xb17b17d2}},	//   ytov, _kuwi, _دستر, skår,
   {{0x22830b88,0x78a2025b,0x14620e62,0x7ae30212}},	// [2520] lık_, xtov, _kọọp, äntn,
   {{0x69c0302d,0x628109ac,0x78a20095,0x6b56302e}},	//   _same, oslo, vtov, стах,
   {{0xdcef0029,0x628116f3,0x7d09042d,0xcf5700a1}},	//   _vecā, nslo, _žest, _לבית_,
   {{0xe8fa1c32,0x69c0302f,0x65793030,0x78a23031}},	//   лле_, _qame, _newh, ttov,
   {{0x69c23032,0x17540243,0x64593033,0xb3b718ff}},	//   rdoe, овля, _nuwi, _असंख,
   {{0x69c01ee3,0x78a23034,0xab2a3035,0x6283042d}},	//   _wame, rtov, _бога_, _ovno,
   {{0x78a23036,0x69c03037,0x76aa0092,0x46670109}},	//   stov, _tame, _bəya, брым_,
   {{0x8a06062c,0x78a23038,0x228301e8,0x64590bb6}},	//   _узбе, ptov, dık_, _buwi,
   {{0x628300cc,0x7a380103,0x645903a9,0x62813039}},	//   _avno, líto, _cuwi, eslo,
   {{0x27e501c2,0x6459303a,0x75f50c90,0x9f4100d1}},	//   _goln_, _duwi, _váza, _wohé_,
   {{0x02a30938,0xdb050212,0x628113ea,0x7a3801f9}},	//   прям, pehå, gslo, níto,
   {{0x2240303b,0xa3c800aa,0x00000000,0x00000000}},	//   _chik_, _लोर_, --, --,
   {{0x25b700cd,0x224000d1,0x9f410031,0x777a01ff}},	//   _دهند_, _dhik_, _dlhý_, _ketx,
   {{0x765a303c,0xb4e40096,0xb4d40096,0x26cc007e}},	//   _kuty, नही_, हमी_, _krdo_,
   {{0xa3d50c8c,0x2283026a,0x0cd100c0,0x777a303d}},	//   हार_, cık_, सम्म, _metx,
   {{0x765a083e,0xf1bf0018,0x75f500b6,0x7bcb01d3}},	//   _muty, rlás_, _lázn, ēgum,
   {{0xc4b6110f,0xae021e93,0x13ac0033,0x00000000}},	// [2530] _अनोख, रोइन_, _কোয়, --,
   {{0x3a2d0185,0x60cd0169,0x41a5000c,0x26cc303e}},	//   _skep_, _iram, ग्रस, _ordo_,
   {{0x1dc4303f,0xbddb06a3,0xb4e40ec3,0x00000000}},	//   _लोकत, _chèc, नहु_, --,
   {{0x60cd3040,0x777a01ff,0xdb1c033c,0x2bf500a4}},	//   _kram, _aetx, _anró, _इतकं_,
   {{0x26cc3041,0x777a00b3,0x27e5033b,0x2283026a}},	//   _ardo_, _betx, _poln_, zık_,
   {{0x26cc04a3,0x765a3042,0x62813043,0xf7710037}},	//   _brdo_, _buty, yslo, ذات_,
   {{0x7bd53044,0xe7390084,0xa91d02ef,0x64593045}},	//   _inzu, шек_, _idžm, _suwi,
   {{0x7d090682,0x60cd3046,0x291f022e,0x7aea00a2}},	//   _þess, _oram, _txua_, äfte,
   {{0xa3d504f8,0x79890154,0x777a01ff,0x41dd11c7}},	//   हाल_, _idew, _fetx, यानस,
   {{0x7bc500bf,0x22830b88,0x981726a0,0x52a93047}},	//   ndhu, tık_, _ابرا, авом_,
   {{0x60cd3048,0xe9ff00de,0x28c70378,0x765a0435}},	//   _aram, _nhẫn_, लिवि, _guty,
   {{0x64593049,0x75f50244,0x60cd304a,0x6aa5304b}},	//   _tuwi, _zázn, _bram, ithf,
   {{0x316d1de1,0x6281304c,0x645900f9,0x442e0139}},	//   ñeza_, sslo, _uuwi, _fkf_,
   {{0x6281304d,0x6283304e,0xae0202d5,0x6a800139}},	//   pslo, _tvno, रोईन_, _jáfá,
   {{0x60cd304f,0xd34700cd,0x22403050,0xe2993051}},	//   _eram, _دیده_, _thik_, _тай_,
   {{0x60cd3052,0x7bd502e2,0x79893053,0x61fd0364}},	//   _fram, _anzu, _ndew, chsl,
   {{0xdca321b6,0xac0a0161,0x640200d1,0x7bc501cb}},	// [2540] мати, анаа_, _رژیم, fdhu,
   {{0x7bc53054,0x79893055,0x602600d6,0x91a60018}},	//   gdhu, _adew, _єдна, _اچھے_,
   {{0x75f53056,0x2bce02e8,0x1c3900a9,0x79890090}},	//   _názo, _होणा, сять_, _bdew,
   {{0xa3d50e5e,0x7bd53057,0x7a380103,0x7bc5009c}},	//   हाँ_, _enzu, ríto, adhu,
   {{0x79890150,0x2db700a1,0x7a380018,0x636600b6}},	//   _ddew, _ולכן_, síto, nční,
   {{0x7a383058,0x79893059,0xdb1c058a,0x2d80305a}},	//   píto, _edew, _harí, laie_,
   {{0xf1ca000c,0x26c30234,0x56940e3f,0x75fc01f9}},	//   ियान, _šjor_, чайт, _léze,
   {{0x2bce1e9f,0x442e07ee,0x95ca0291,0x636602c6}},	//   _होता, _skf_, рука_, kční,
   {{0xdb1c305b,0xa3d52171,0x75fc0018,0xe9ff00de}},	//   _marí, हां_, _néze, _hiến_,
   {{0xe9ff0028,0x26cc0117,0x6a800139,0x765a0517}},	//   _kiến_, _trdo_, _gáfá, _tuty,
   {{0x6fde017f,0x75f501f9,0x5fde02c6,0x0bb700d7}},	//   मानं, _gázo, मानल, חלים_,
   {{0x60cd305c,0x320b0231,0xe9ff00fe,0x442e0154}},	//   _pram, рхон_, _miến_, _wkf_,
   {{0x107413fc,0x2bbb00b6,0x845a0161,0x7a312059}},	//   мляю, _उसला, _трет_, mått,
   {{0xe9ff0023,0x24860218,0x05a600b6,0x442e305d}},	//   _phẫn_, _ivom_, क्रब, _ukf_,
   {{0x22630220,0xdb1c0032,0xe2971009,0x15ee00bc}},	//   ľské_, _barí, _дај_, _जवार_,
   {{0x442c305e,0x2d582082,0xc3330105,0x02fb0327}},	//   lod_, жить_, _קוק_, _כלומ,
   {{0xa80201e8,0x60cd305f,0xdb1c04d8,0x75fc01f9}},	// [2550] şıyo, _uram, _darí, _kézb,
   {{0x442c3060,0xe9ff0028,0xaca30134,0x6d5a00a7}},	//   nod_, _biến_, _nhục, _ştat,
   {{0x20113061,0xdb1c3062,0x7bc53063,0x9e350a51}},	//   mizi_, _farí, rdhu, _неоч,
   {{0x248603ce,0x20113064,0x442c3065,0xaca30174}},	//   _ovom_, lizi_, hod_, _ahục,
   {{0x442c3066,0x7e62033b,0x6e2d3067,0x00000000}},	//   kod_, _čopi, moab, --,
   {{0xcc760105,0x20113068,0x442c3069,0x7ae302b6}},	//   _מעשה_, nizi_, jod_, ønts,
   {{0x442c306a,0x69a602d5,0xea630018,0x00000000}},	//   dod_, _टॉकी, _آپری, --,
   {{0x2011306b,0x7642292c,0x9f580036,0x644818f0}},	//   hizi_, _choy, nirò_, emdi,
   {{0x442c02ad,0x201108a5,0x764201dc,0x6fcb0096}},	//   fod_, kizi_, _dhoy, ायां,
   {{0x442c306c,0x730500e5,0x2011024a,0x24860fee}},	//   god_, зпоз, jizi_, _dvom_,
   {{0x2011306d,0xdb070094,0x23290e96,0x00000000}},	//   dizi_, _objí, сони_, --,
   {{0x27340037,0x00000000,0x00000000,0x00000000}},	//   súnú_, --, --, --,
   {{0x442c02ad,0xa01b02e2,0x455a040a,0x2011306e}},	//   bod_, rsön, _הכנס, fizi_,
   {{0x7649306f,0x7fd50c10,0x644f0428,0x201101e2}},	//   lmey, місі, ïcid, gizi_,
   {{0xdb1c3070,0x2d8000ae,0xdee6004d,0xd0070b0a}},	//   _parí, taie_, чови, чере_,
   {{0x661b3071,0x764901e8,0xe1ff3072,0xbcfb002b}},	//   nnuk, nmey, chó_, _efém,
   {{0xd34700cd,0xdb1c3073,0x20113074,0xb05b00c2}},	// [2560] _دیگه_, _varí, bizi_, yväi,
   {{0x2d8000fd,0x5ebb0033,0x2011044c,0x76493075}},	//   saie_, _উপরে, cizi_, hmey,
   {{0x7a380018,0x05bd0096,0x661b00f9,0x76493076}},	//   sítm, ्याब, knuk, kmey,
   {{0x442c3077,0xad9b0032,0xdb1c016d,0x98a63078}},	//   zod_, _alúf, _parâ, зиде,
   {{0x442c1331,0xed5200cd,0x64430146,0xdb1c016d}},	//   yod_, _سپس_, _ohni, _barã,
   {{0xe9ff0028,0x2609000f,0xdb0e00b6,0x6d3b00ca}},	//   _tiến_, ़ोसी_, _zabý, _לתכנ,
   {{0x8c431b60,0x248603ce,0x36330260,0x7d040036}},	//   _чере, _svom_, کروس, lzis,
   {{0xd49a04e6,0xceb30054,0x442c00f0,0x64433079}},	//   бро_, גיה_, wod_, _ahni,
   {{0x38c80979,0x442c307a,0x7d04307b,0x29020222}},	//   _بازی_, tod_, nzis, _åka_,
   {{0xa2f400d6,0x6e2d0f61,0x6443036b,0x7d00003e}},	//   дпоч, zoab, _chni, _ýmsu,
   {{0x7642005c,0x644800d9,0x2011307c,0x6443009c}},	//   _thoy, rmdi, vizi_, _dhni,
   {{0x248604a3,0x442c307d,0x7a380146,0x79820051}},	//   _tvom_, sod_, dítk, naow,
   {{0x2011307e,0x5067307f,0x6443009c,0x7d041cc9}},	//   tizi_, ятна, _fhni, jzis,
   {{0x1ae200c7,0x442c3080,0x7d043081,0xdb0e3082}},	//   _গেছে_, qod_, dzis, _jabó,
   {{0x20113083,0xc43b00a1,0x53333084,0xbddb03a9}},	//   rizi_, _התגי, _пешт, _dhèn,
   {{0x63ba3085,0x67ef052f,0x753d00a5,0x76aa0092}},	//   letn, _højt, ższe, _rəyl,
   {{0x629a3086,0x271800a5,0x9f58028d,0x76aa013c}},	// [2570] luto, धपुर_, rirò_, _səyl,
   {{0xf04509b4,0x7a3806fa,0x76492ddc,0x629a0a4b}},	//   _تعبی, líth, zmey, outo,
   {{0x3f8303ce,0x629a0d9f,0xdb1c0472,0x9f580036}},	//   maju_, nuto, _carà, pirò_,
   {{0x63ba0018,0x391500c2,0x7aea0212,0xdb1c0065}},	//   hetn, ммер, äfta, _darà,
   {{0x48ab1da3,0x25e03087,0x63ba3088,0x629a09a1}},	//   стем_, कानी_, ketn, huto,
   {{0x63ba3089,0x629a308a,0xfe70001c,0x2ca90212}},	//   jetn, kuto, _جدی_, mtad_,
   {{0x2ca9308b,0x7649026a,0xdb1c0131,0x629a308c}},	//   ltad_, tmey, _varã, juto,
   {{0x629a308d,0x661b24ae,0x3f8318ea,0x7bc7308e}},	//   duto, unuk, haju_, _haju,
   {{0x3f8300e9,0x2ca9308f,0x764901e8,0x7bc73090}},	//   kaju_, ntad_, rmey, _kaju,
   {{0x3f8303ce,0xdb1c2ca8,0x386d3091,0xdb0e0072}},	//   jaju_, _hará, _iter_, _gabó,
   {{0x3f830335,0x629a3092,0x7bc70a55,0x7d043093}},	//   daju_, guto, _maju, zzis,
   {{0x7bc73094,0x2ca93095,0xa91d007e,0xe5e5001c}},	//   _laju, ktad_, _adži, _تزئی,
   {{0xa3c81349,0x53a50a52,0x2be007ad,0xdb0e0154}},	//   _लोक_, _жалб, नामा, _jabò,
   {{0x63ba00cc,0x3f830fbd,0xdb0e002b,0xad9b00ee}},	//   cetn, gaju_, _xabó, _llúd,
   {{0xe9ff0028,0x67ef052f,0xdb0e00b3,0x6da63096}},	//   _nhắn_, _højs, _labò, мива,
   {{0xee3a116d,0x51563097,0x3ce001fa,0xdb1c0146}},	//   іна_, _отпу, txiv_, _nará,
   {{0x3f8303ce,0xbc6a0dd0,0x2ca93098,0xad9b0139}},	// [2580] baju_, زمان_, gtad_, _amús,
   {{0x60c43099,0x3f8303ce,0x7d04309a,0xdb1c05fe}},	//   _isim, caju_, rzis, _parà,
   {{0xdb1c309b,0x09e60f2e,0x7bc72345,0xe9ff0019}},	//   _bará, можн, _daju, _chắn_,
   {{0xdb1c309c,0xaca40129,0x25ad01c0,0xad9b0037}},	//   _cará, _akụr, jfel_, _clúd,
   {{0x7a38309d,0x307a00c1,0xdb0e309e,0x61fd0052}},	//   níti, קאַנ, _cabò, ërli,
   {{0x60c40010,0x7bc70998,0xdb0e0383,0x629a03e3}},	//   _msim, _gaju, _dabò, yuto,
   {{0xa3c81085,0x25ad309f,0x63ba30a0,0xdb1c30a1}},	//   _लोग_, ffel_, vetn, _fará,
   {{0xdb1c128f,0x60c430a2,0x3f8300cc,0x63ba0167}},	//   _gará, _osim, zaju_, wetn,
   {{0x7bc730a3,0x60c430a4,0x8cc400b6,0x629a0027}},	//   _yaju, _nsim, रिटो, wuto,
   {{0x42740231,0xa3d50c13,0xdb1c30a5,0xb05b0364}},	//   нгос, हाग_, _zará, hwäc,
   {{0x3f8303ce,0x629a0270,0xe215163d,0x65c60110}},	//   vaju_, uuto, емны, _обжа,
   {{0x629a30a6,0x3f830d79,0x27ec0220,0x63ba23ff}},	//   ruto, waju_, _hodn_, setn,
   {{0x3f8303ce,0xbddb0113,0xc5f300ca,0x798002f1}},	//   taju_, _dhèl, _בדף_, _memw,
   {{0x629a30a7,0x67ef01c5,0x7a380103,0xbbc830a8}},	//   puto, _højr, síth, रयोक,
   {{0x3f8303ce,0x60c430a9,0x7bc730aa,0xa01b02c3}},	//   raju_, _esim, _raju, lsök,
   {{0x3f8304a3,0x2ca930ab,0x7bc730ac,0x79800ea4}},	//   saju_, ttad_, _saju, _nemw,
   {{0x645830ad,0x3f8304a3,0xe81f30ae,0x7bc702ab}},	// [2590] _kivi, paju_, _बदला_, _paju,
   {{0x2ca930af,0x2c640149,0x9f4506f0,0x61ed30b0}},	//   rtad_, _död_, óló_, _hoal,
   {{0x2ca930b1,0x3a2f30b2,0x628830b3,0x386d0db1}},	//   stad_, togp_, nsdo, _ster_,
   {{0x645830b4,0xdb2600bf,0x7bc70010,0xceb200c1}},	//   _livi, رونی, _waju, _גיט_,
   {{0x7bc730b5,0x9f5800e3,0x6d5d0009,0x61ed30b6}},	//   _taju, mhrá_, _igsa, _moal,
   {{0x07a20476,0xbcfb0065,0xf7450012,0xb05b0853}},	//   гашн, _agég, нело, lväs,
   {{0x25ad0012,0x49bb00bf,0x75f50018,0x7980010a}},	//   tfel_, _وارد_, _házi, _femw,
   {{0xcf58004f,0x6b850d17,0x649900d3,0xad9b0072}},	//   ובות_, lahg, птор_, _flúe,
   {{0x25ad30b7,0x645830b8,0xa91d0031,0x176b002d}},	//   rfel_, _bivi, _beže, _дреп_,
   {{0x69cb30b9,0xc7470037,0xa283001c,0x690103e0}},	//   ldge, _قضاي, نیتو, ızdı,
   {{0xa91d0087,0x61ed00d3,0x798005bd,0x25ad0364}},	//   _deže, _boal, _yemw, pfel_,
   {{0x61ed30ba,0x69cb0418,0x25e0009d,0x60c40106}},	//   _coal, ndge, काणी_, _psim,
   {{0xe9ff00ef,0x69c90167,0xbddb05aa,0x61ed01c8}},	//   _nhận_, _maee, _chèm, _doal,
   {{0x7a3830bb,0x2c640149,0x99dd0094,0x645800ca}},	//   ríti, _röd_, _ohňo, _givi,
   {{0x6e290146,0xa3dc0b7f,0x6288009c,0x00000000}},	//   čebn, डार_, csdo, --,
   {{0x60c430bc,0x91fd01d3,0x69c900f9,0xdb120103}},	//   _tsim, spār, _naee, _ígér,
   {{0xdd8f0a09,0x60c430bd,0x28bf0557,0xf652006e}},	// [25a0] صول_, _usim, _शैलि, רצן_,
   {{0x61ed0505,0x26c502ec,0x7aea0212,0x38a930be}},	//   _zoal, _oslo_, äfto, dúr_,
   {{0xdb1c0396,0x8f9b00c1,0x69cb029a,0xb05b30bf}},	//   _març, _ציטי, fdge, svät,
   {{0x5fde030b,0xa92630c0,0x491100b7,0x69cb04aa}},	//   मावल, ндел, _देहो_, gdge,
   {{0x6b85061d,0x27fe0085,0xb05b30c1,0x27ec0141}},	//   bahg, _pltn_, lvär, _podn_,
   {{0xfaa630c2,0x69db01ff,0x29061f72,0x6d5d00c4}},	//   _паго, _enue, rzoa_, _zgsa,
   {{0x4df430c3,0x2d8230c4,0x8f9b006e,0x798030c5}},	//   _इकाई_, _keke_, ליסי, _temw,
   {{0x645830c6,0xc1ca099d,0xa91d30c7,0x2d82039f}},	//   _sivi, ियोग, _seže, _jeke_,
   {{0x61ed30c8,0xdb1c30c9,0x765902ad,0x64580154}},	//   _roal, _barç, _diwy, _pivi,
   {{0xa01b070a,0x61ed1bd6,0xaca40129,0x66e62135}},	//   rsök, _soal, _ahịr, _поза,
   {{0x6458255c,0x645d0af0,0x61ed020a,0xb05b007b}},	//   _vivi, ísir, _poal, yväs,
   {{0x2d8203ce,0x628810ef,0xb05b0212,0x76aa013c}},	//   _neke_, rsdo, dvär, _nəyi,
   {{0x61ed020a,0x7bdc04e2,0x62880141,0xad9b015e}},	//   _voal, _onru, ssdo, _llúc,
   {{0xdb1c30ca,0xa91d30cb,0xa3c800a3,0x00000000}},	//   _garç, _idžt, _लोच_, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xbddb025a,0xe9ff0019,0x7bdc01bf,0xbedb0139}},	//   _thèm, _phận_, _anru, _aṣòw,
   {{0x76aa01d4,0x5d5530cc,0x4c94215d,0x2d8230cd}},	// [25b0] _dəyi, ткат, литс, _deke_,
   {{0xb6030181,0xb60600cb,0x69c901ee,0xfe7101f3}},	//   čšin, lešć, _saee, _نگر_,
   {{0x22490113,0x201300bd,0xb05b02c3,0xa01b01f9}},	//   _khak_, _imxi_, sväs, kröz,
   {{0x38a930ce,0xe9ff00de,0x98bf0090,0x614901d3}},	//   túr_, _thận_, _jfuħ_, _tūlī,
   {{0x69cb0eb3,0x491100c3,0x28f8004d,0xf09f00ee}},	//   rdge, _देशो_, нець_, nuà_,
   {{0xe7390a95,0x673a084e,0x00000000,0x00000000}},	//   мел_, _bytj, --, --,
   {{0x38a90037,0x3d150096,0x2001009c,0xa01b042c}},	//   súr_, _नेते_, _mlhi_, rsöh,
   {{0xa91d1cae,0x660d0220,0xb6060880,0x9b581c47}},	//   _vežb, ďako, ješć, _чист_,
   {{0xdb1c03a3,0xf1bf0220,0x00000000,0x00000000}},	//   _parç, deá_, --, --,
   {{0x75f50074,0x00000000,0x00000000,0x00000000}},	//   _názv, --, --, --,
   {{0xf1dd0454,0xfbd200a1,0x41dd0403,0x56941894}},	//   यांन, בתי_, यांस, _бахт,
   {{0x224914b1,0x151530cf,0xbddb03a9,0x7a380103}},	//   _chak_, _идея, _dhèk, sítv,
   {{0xd9e30081,0x2d8230d0,0x28c70592,0x22490113}},	//   _মতাম, _reke_, लिटि, _dhak_,
   {{0x35a7000f,0x2d8230d1,0x224901c8,0x25bf044c}},	//   _गाड़, _seke_, _ehak_, leul_,
   {{0x2d8230d2,0x8e8300ae,0x0eb9163d,0x2be0052c}},	//   _peke_, игре, нуты_, नासा,
   {{0xf1bf00e3,0x25bf30d3,0x395f009c,0x00000000}},	//   ceá_, neul_, _ngus_, --,
   {{0xb05b0149,0x25b201e8,0xd24f0037,0xad9b0031}},	// [25c0] rvär, _öyle_, _بني_, _slúc,
   {{0x395f1884,0x0e661c66,0xb05b30d4,0x2d820185}},	//   _agus_, _икон, svär, _weke_,
   {{0x201830d5,0x395f02e7,0x91a00174,0xaca40174}},	//   miri_, _bgus_, _ghị_, _ihọr,
   {{0x201830d6,0xb33c03e5,0x75f50094,0x60d630d7}},	//   liri_, ngħa, _zázv, _krym,
   {{0x25bf30d8,0x8b6603ef,0x18671510,0xf1aa0ff9}},	//   deul_, _لازم, вачи_, _कानन,
   {{0xe9ff0028,0xf1e40251,0x6d4628df,0x201830d9}},	//   _phản_, गाड़_, _izka, niri_,
   {{0xcac72f17,0x2ca00cad,0x1ae330da,0x25bf020a}},	//   _игре_, luid_, _корм, feul_,
   {{0x201830db,0x7c3e19ce,0x25bf30dc,0xbddb0154}},	//   hiri_, llpr, geul_, _chèh,
   {{0x201830dd,0x69d3025b,0xb606077e,0x2ca030de}},	//   kiri_, ádež, vešć, nuid_,
   {{0x201830df,0xaca400ac,0x9f5a00ee,0xe9ff0023}},	//   jiri_, _nhọr, _alpí_, _thản_,
   {{0x20181a8e,0x25bf01ec,0x2bf70266,0xdd2f02c6}},	//   diri_, beul_, דמין_, měťo,
   {{0x7a380b0b,0xaca40294,0xdb150146,0x2ca0007a}},	//   pítu, _ahọr, _nazý, kuid_,
   {{0x201830e0,0xb1130134,0x3eba30e1,0xf1bf0076}},	//   firi_, wụba, _appt_, reá_,
   {{0xdb17001f,0xaca406c0,0x6602063d,0x3eba0085}},	//   nexã, _chọr, _hlok, _bppt_,
   {{0x660230e2,0xbe8817b9,0x6d460a00,0x0d67008f}},	//   _klok, ксте_, _azka, възм,
   {{0x443e30e3,0xa91d30a0,0x60d600dd,0xd35700a1}},	//   llt_, _leža, _frym, _בשוק_,
   {{0x20181e59,0x60d61070,0xf09f0036,0xdb170072}},	// [25d0] biri_, _grym, quà_, rexí,
   {{0xaca40294,0x25bf00d3,0x61fd0eb3,0x75f50103}},	//   _ghọr, zeul_, lksl, _házt,
   {{0x443e30e4,0x660230e5,0xfb152c9a,0xf1aa099d}},	//   ilt_, _olok, دواج, _कामन,
   {{0x443e02e2,0x7c3e05c2,0x321930e6,0x629a007b}},	//   hlt_, alpr, nisy_, irto,
   {{0x69342223,0xa91d30e7,0x3f870131,0xe9d00037}},	//   анцу, _beža, _ônus_, تغل_,
   {{0x660230e8,0x02a2026e,0x7e650085,0x16a92a72}},	//   _alok, _akọọ, _kuhp, евки_,
   {{0x7a380068,0x2be00c9c,0x25bf00ae,0xe7362b49}},	//   gíts, नारा, teul_, леш_,
   {{0x201830e9,0xe51400b7,0xdb1e30ea,0x280900c6}},	//   ziri_, _तेहि_, depè, _šunį_,
   {{0x893706fa,0x644a00e3,0x629a30eb,0x20180198}},	//   _شعرا, _bhfi, erto, yiri_,
   {{0x660230ec,0x3fce0081,0x25bf00ae,0xbddb009c}},	//   _elok, _রক্ষ, seul_, _dhèi,
   {{0x660230ed,0x7a382c74,0x201830ee,0xb33c003d}},	//   _flok, mítr, viri_, tgħa,
   {{0x201830ef,0x443e30f0,0x7524215a,0x673c00f3}},	//   wiri_, alt_, _žize, _ørja,
   {{0x25e006ae,0x201830f1,0x657b0d2c,0x629a0381}},	//   कारी_, tiri_, mbuh, arto,
   {{0x5ebb00c7,0x6fde00a5,0x049200e3,0xf1dd030b}},	//   _উপজে, माइं, _الوح, याउन,
   {{0x201830f2,0x657b08a9,0x44270063,0x539a00ca}},	//   riri_, obuh, _ijn_, _טיסו,
   {{0x201830f3,0x60d630f4,0x657b0124,0x2ca000aa}},	//   siri_, _trym, nbuh, tuid_,
   {{0x271f0782,0x201830f5,0x248d30f6,0xfce318c6}},	// [25e0] यपुर_, piri_, nsem_, бото,
   {{0x2018023b,0x6d46033d,0xdb150072,0x207b006e}},	//   qiri_, _vzka, _nazó, _ראיא,
   {{0x657b06a8,0xa91d2a4e,0x9eaa2742,0xda650037}},	//   kbuh, _reža, _явна_, لاني,
   {{0x3f8a30f7,0x248d30f8,0x533600c1,0x6e9b00ca}},	//   labu_, ksem_, אנען_, _אבטח,
   {{0x443e30f9,0x81ce0081,0xddc40034,0x461400cd}},	//   ylt_, রাপ_, rmiń, یوتر,
   {{0x67d430fa,0x660230fb,0x57b301b6,0x3f8a024a}},	//   року, _slok, йбіт, nabu_,
   {{0x660230fc,0x25e000c0,0x7bce00f9,0xfc0330fd}},	//   _plok, काली_, _iabu, _упро,
   {{0x7bce30fe,0x442700e7,0x3f8a30ff,0x629a0220}},	//   _habu, _ajn_, habu_, vrto,
   {{0xa91d25d1,0x7a383100,0x248d0103,0x6602112f}},	//   _teža, síts, gsem_, _vlok,
   {{0x443e3101,0x7bce3102,0x78a230cf,0x3f8a0239}},	//   ult_, _jabu, muov, jabu_,
   {{0x7bce3103,0x81ce0033,0x3f85003e,0x629a3104}},	//   _mabu, রান_, ðlum_, urto,
   {{0x7bce3105,0x66020ec4,0xd7e20096,0x25e00096}},	//   _labu, _ulok, पावच, काळी_,
   {{0x78a20451,0x61fd3106,0x44f70214,0x06bc0033}},	//   nuov, rksl, _مروج_, _অপটি,
   {{0x7bce3107,0xbcfb0072,0xdb1c0065,0x629a033b}},	//   _nabu, _ofér, _darú, prto,
   {{0x32191670,0xa91d3108,0x78a211f1,0x629c0094}},	//   pisy_, _nežn, huov, árod,
   {{0x7bce3109,0x2bc7009f,0x78a2310a,0x82150018}},	//   _aabu, रजभा, kuov, _خوبص,
   {{0x3f8a068d,0x7bce310b,0x69c21484,0xbcfb310c}},	// [25f0] babu_, _babu, deoe, _afér,
   {{0x26e402ed,0xa91d0181,0x5d54139c,0x3f150120}},	//   _कपूर_, _bežn, скут, _вдос,
   {{0xdb15310d,0x5e470037,0x7bce310e,0xdce401d3}},	//   _razó, _مضحك, _dabu, rciā,
   {{0x65620415,0x248d310f,0xa91d033b,0xdb150143}},	//   _ngoh, ysem_, _dežn, _sazó,
   {{0xa3d4058f,0x225902c6,0xdb1c0139,0x00000000}},	//   हया_, írky_, _marù, --,
   {{0xb8cd0abe,0x248d0087,0x96950291,0xa69519e8}},	//   _कम_, vsem_, ариш, ариј,
   {{0x69c21cab,0x00000000,0x00000000,0x00000000}},	//   beoe, --, --, --,
   {{0x7bce3110,0x6b870a39,0x78a21054,0x5b14062a}},	//   _zabu, _hejg, buov, _умст,
   {{0x81ce0f71,0xccf20130,0xdb0501bf,0x7bce2127}},	//   রাম_, ַכט_, gehö, _yabu,
   {{0x3ea300dd,0x798b3111,0x248d3112,0x00000000}},	//   kujt_, lagw, rsem_, --,
   {{0x248d3113,0xfbcf0081,0x657b06a8,0x4226017b}},	//   ssem_, রাপত, pbuh, идов,
   {{0xdb053114,0xc0490341,0xc10600e3,0x22161c16}},	//   behö, _חז_, لوجي, рфор,
   {{0x3f8a3115,0x7d0d09ac,0xa91d00e8,0x00000000}},	//   tabu_, jzas, _mežo, --,
   {{0x2bd504a9,0x661b013f,0x8fa600c9,0x660903e5}},	//   _डोला, liuk, јаве, lhek,
   {{0x7bce3116,0x539a00a1,0x3f8a3117,0xa22500cd}},	//   _rabu, _סיקו, rabu_, _گروه,
   {{0x7bce3118,0x3f8a0051,0x75f50146,0x661b0138}},	//   _sabu, sabu_, _zázr, niuk,
   {{0xdca63119,0x7bce311a,0xed5a00c9,0x6b87003d}},	// [2600] рази, _pabu, тоа_, _bejg,
   {{0x9f4c2897,0x7bce311b,0x4f96311c,0x6441311d}},	//   ódó_, _qabu, _триу, nlli,
   {{0xbf9b0105,0x6441311e,0x661b311f,0xdee63120}},	//   _בייש, illi, kiuk, _тони,
   {{0x7bce3121,0xbcfb0018,0xe8fa3122,0xdca6168c}},	//   _wabu, _igén, кле_, _ками,
   {{0x7fe90f03,0xe7e21843,0x7d0d007f,0x660900d1}},	//   _شریف_, पालप, czas, dhek,
   {{0xdb17002b,0x4813004d,0x9b8901f3,0x69c201c8}},	//   sexá, оміс, _مخفف_, seoe,
   {{0xddc400d9,0x29003123,0x2cb2057a,0x798b3124}},	//   rmiņ, šia_, ltyd_, bagw,
   {{0x64410084,0xa01b3125,0x88810068,0x75fc0103}},	//   elli, nsör, _کیون, _kézi,
   {{0x75fc0154,0x07a6232c,0x186a004d,0x479602d1}},	//   _jézi, _вазн, _рази_, _نجاس,
   {{0xe9ff00ef,0xf3661e0e,0x690803a3,0x64410124}},	//   _phần_, штин, ırdı, glli,
   {{0x66090060,0x7bd900c1,0xbcfb00d1,0x53343126}},	//   bhek, אַרק, _ngén, сент,
   {{0x9f5800e3,0x66090051,0x64413127,0xd5b0110a}},	//   bhrú_, chek, alli, _رفت_,
   {{0xbcfb104d,0x6002016d,0xba570266,0x00000000}},	//   _agén, _cômo, יסטו_, --,
   {{0xe9ff0028,0x20050088,0x3317001c,0xfe73097d}},	//   _thần_, óli_, ازید_, قدر_,
   {{0x543900c1,0x798b3128,0x3a260629,0x22940190}},	//   _געװא, yagw, knop_, _البس,
   {{0x2cb20313,0x443c00c4,0x75fc020d,0xb7fe0033}},	//   ftyd_, _hkv_, _bézi, ্চিত_,
   {{0x6b87023b,0x7c870226,0x2cb20f5a,0x00000000}},	// [2610] _pejg, рубе, gtyd_, --,
   {{0x60cd3129,0x81ce0081,0x3ea30052,0x661b00c6}},	//   _isam, রাণ_, pujt_, ziuk,
   {{0x2c7d0065,0xa91d007e,0xdce70555,0xf09f015e}},	//   _bádò_, _pežo, ılıd, lrà_,
   {{0xa2d722a0,0x60cd312a,0x00000000,0x00000000}},	//   यित्, _ksam, --, --,
   {{0x98c70f99,0xe9ff0019,0x6441312b,0x49110034}},	//   рсел, _nhấn_, ylli, _देखो_,
   {{0x60cd0051,0x8d5a00ca,0xf09f312c,0x00000000}},	//   _msam, _תכשי, irà_, --,
   {{0x6609312d,0xa91d015c,0xfeca006e,0x661b0683}},	//   thek, _težo, ָמפּ, tiuk,
   {{0xc485312e,0x5bc70e50,0x9f580037,0x7bc5312f}},	//   блик, _रघुव, thrú_, lehu,
   {{0x999f025b,0xe9ff00de,0x64413130,0x661b02e3}},	//   _chuť_, _chấn_, tlli, riuk,
   {{0x75f50cda,0xf09f3131,0x66093132,0xf7700037}},	//   _vázq, drà_, shek, _قام_,
   {{0xd7f82a6a,0x60cd3133,0x7c220257,0xf09f00e5}},	//   _тут_, _asam, éori, erà_,
   {{0x7bc5023b,0x60cd0063,0x64413134,0xf09f00ee}},	//   hehu, _bsam, slli, frà_,
   {{0x7bc53135,0x79893136,0x60cd3137,0xf09f00ee}},	//   kehu, _meew, _csam, grà_,
   {{0x438500e3,0x183500c1,0x79893138,0x81ce0081}},	//   _الثق, מאָל_, _leew, রাধ_,
   {{0x60cd3139,0xf09f0428,0x7bc5313a,0x249f29fb}},	//   _esam, arà_, dehu, lrum_,
   {{0x249f313b,0x4d66313c,0xf09f0428,0x629c00e8}},	//   orum_, скав, brà_, šroc,
   {{0x61e4313d,0x1b150081,0x4d4a0291,0xa01b0212}},	// [2620] _inil, _তুলে_, упан_, rsör,
   {{0xf1bf00e3,0x7bc5313e,0x2cb2057a,0xac0a00ae}},	//   nnán_, gehu, rtyd_, ынза_,
   {{0x61e407ac,0x249f07e7,0x34c406ec,0x79890361}},	//   _knil, hrum_, _वन्द, _beew,
   {{0x61f602ac,0x994a0037,0xbddb00cd,0x9b96015a}},	//   _joyl, هلال_, _dhès, _گلست,
   {{0x2d80313f,0x98a33140,0x249f3141,0x60cd3142}},	//   mbie_, зиче, jrum_, _xsam,
   {{0x249f3143,0xdb1e301f,0x2bb700b6,0x7bc53144}},	//   drum_, lepí, _věcí_, cehu,
   {{0xfaa33145,0x61e43146,0xf1760139,0x6674010d}},	//   _наро, _onil, _abọ́_, زگار,
   {{0x2be014e5,0xe5c60084,0xe9ff00de,0x443c003e}},	//   नाका, сско, _phấn_, _skv_,
   {{0x8cdb0179,0x2a6a0063,0x32ee00a7,0x249f0596}},	//   नियो, _hubb_, məyi_, grum_,
   {{0x61e43147,0xf09f008f,0x2ca03148,0x79893149}},	//   _anil, vrà_, irid_, _zeew,
   {{0x61f6314a,0x60cd0172,0x7989083e,0x00000000}},	//   _boyl, _ssam, _yeew, --,
   {{0x64a6314b,0xf09f314c,0x201a0451,0x02a8009f}},	//   _гада, trà_, _ampi_, _कमीन,
   {{0x41aa314d,0x44fa00b9,0x2ca00063,0x7bc50239}},	//   _कारस, _حراج_, jrid_, yehu,
   {{0x3e6e000d,0xf09f314e,0x61e40150,0x2ca00133}},	//   _být_, rrà_, _enil, drid_,
   {{0xa3d5030b,0xa3c5314f,0x7bc500f2,0x32b70076}},	//   ाएर_, उजर_, vehu, _هدية_,
   {{0x60cd3150,0xf09f0451,0xa91d033b,0x61e43151}},	//   _tsam, prà_, _dežj, _gnil,
   {{0x3209041c,0x7bc53152,0x798901ee,0x00000000}},	// [2630] _ilay_, tehu, _reew, --,
   {{0x7b673153,0xbddb3154,0x79893155,0xdcfd00c6}},	//   стае, _chèr, _seew, _nesą,
   {{0x2ca0007a,0xb9950f36,0xbddb01dc,0x998c00c4}},	//   arid_, قلاب, _dhèr, _šoša_,
   {{0x80cc0081,0xdb1c003e,0x249f3156,0x00000000}},	//   ামর্, _farþ, yrum_, --,
   {{0xb05b0220,0x7bc53157,0x75fc0103,0x32090350}},	//   dväz, pehu, _jézu, _mlay_,
   {{0x249f3158,0xbddb00fd,0x4cba006e,0x86990d81}},	//   vrum_, _thès, _דזשו, атит_,
   {{0x41aa0eeb,0x2d8b3159,0x3209008b,0x59d4058f}},	//   _कालस, _kece_, _olay_, _ठोकर,
   {{0xf1d9000f,0xb05b01bf,0x32ee00a7,0xa91d04ad}},	//   _बोलन, swäh, cəyi_, _ježk,
   {{0xdb1e00d3,0x2d8b03e3,0xc7ab001c,0x00000000}},	//   cepâ, _mece_, _مدال_, --,
   {{0x3209315a,0x61e4315b,0x249f315c,0x2d8b0218}},	//   _alay_, _snil, rrum_, _lece_,
   {{0xf1bf315d,0x320900ee,0x81ce0033,0x249f315e}},	//   rnán_, _blay_, রাস_, srum_,
   {{0x2d8b08a9,0xcad600a1,0x201a061d,0xb1130174}},	//   _nece_, קורת_, _smpi_, pụla,
   {{0x248601c2,0xa06a315f,0x628e0103,0x05743160}},	//   _gwom_, рага_, ábor, _راند,
   {{0xee3f0220,0x3a2d0357,0x6b503161,0x00000000}},	//   _aký_, _ljep_, _jógí, --,
   {{0x32090154,0x0f040285,0x24860381,0x9e053162}},	//   _flay_, रनेस_, _zwom_, रसंघ_,
   {{0x3d1505a7,0x2d8b3163,0x2bac00b6,0x00000000}},	//   _नइखे_, _cece_, _चाहा, --,
   {{0x2d8b0291,0xbddb0257,0xee37084c,0xdb1e0669}},	// [2640] _dece_, _chèq, іну_, repí,
   {{0xa91d033b,0x41aa0557,0xeb9a2766,0x2ca0058f}},	//   _težj, _काँस, риж_, rrid_,
   {{0x2d8b00e5,0xf1bf0103,0x6ac60867,0x32ee013c}},	//   _fece_, knál_, تقام, təyi_,
   {{0xa3d50067,0xfce63164,0x3a3f0899,0x2d8b0587}},	//   ाएँ_, _домо, _ckup_, _gece_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x2d8b00d3,0xec341ac9,0x7aea02c3,0xdb1e0231}},	//   _zece_, _روزگ, äfts, repâ,
   {{0x491a000d,0x6fad000f,0xdb1c00dd,0x02a80852}},	//   _मेरो_, _जासू, _mbrë, _कमेन,
   {{0x16370080,0x7ae10068,0xd5b72983,0xf1bf15bf}},	//   يسية_, _álta, ось_, gnál_,
   {{0xa3d50067,0x79823165,0x6fca009d,0x69dd0143}},	//   ाएं_, mbow, ाजां, _ósea,
   {{0x22400018,0x25da09a1,0x00000000,0x00000000}},	//   _akik_, _खोरी_, --, --,
   {{0x32093166,0xe73a004d,0x2a64024a,0x48f400b6}},	//   _play_, _теж_, _kimb_, ्नको_,
   {{0x60100222,0x80ac0cce,0x78a20146,0x00000000}},	//   _jämf, _जमशे, orov, --,
   {{0x2d8b3167,0xf9930796,0xd25808a1,0x76900139}},	//   _rece_, ורר_, юць_, _fóyá,
   {{0xb4d60d88,0x600b00aa,0x2d8b007e,0x78a200c6}},	//   ाटी_, _sümb, _sece_, irov,
   {{0x28d1000c,0x2d8b00d4,0x657900fd,0x78a200e7}},	//   _दैनि, _pece_, _éché, hrov,
   {{0xdb1c02e2,0xb5fc0090,0x31353168,0x12770076}},	//   _darü, _buġi, _нейр, _بحوث_,
   {{0x2d8b04a3,0x31690018,0x69c6003e,0x78a20b14}},	// [2650] _vece_, _igaz_, _ókey, jrov,
   {{0xdb1c3169,0x78a2316a,0x26de316b,0x9f580088}},	//   _naró, drov, _orto_, skrá_,
   {{0x3f91316c,0xa91d02dd,0x81ce0081,0x78a2316d}},	//   mazu_, _težk, রার_, erov,
   {{0x3f91005f,0x2a642fc5,0xdb1c034f,0x78a200d4}},	//   lazu_, _cimb_, _aaró, frov,
   {{0x78a2025b,0xdb1c27d7,0xdb150161,0x26de316e}},	//   grov, _baró, _razõ, _arto_,
   {{0xf77104f4,0xdb1c03be,0xa3da17ff,0xa91d0954}},	//   رات_, _caró, _ढोल_, _ježi,
   {{0x78a200d4,0x1ab41bec,0x7bd5020a,0x7982010a}},	//   arov, _обря, _iazu, bbow,
   {{0xc4852dd1,0xa91d316f,0xdce40034,0x7bd53170}},	//   плик, _leži, ecię, _hazu,
   {{0x629c08a8,0xf1bf3171,0xdb1c3172,0x442e007e}},	//   áron, rnál_, _abrè, _bjf_,
   {{0xa91d3173,0xf1bf0103,0x22403174,0x4374004d}},	//   _neži, snál_, _skik_, муют,
   {{0x7bd53175,0x09be0033,0xb1130134,0x3f910634}},	//   _mazu, _ইফতা, bụka, dazu_,
   {{0xdb1c0034,0x06c30081,0xad9b3176,0x98bf007f}},	//   _zaró, ্মদি, _flúi, _czuć_,
   {{0xa91d21b8,0x386d01c2,0xad9b0037,0x799b0113}},	//   _beži, _juer_, _glúi, _mduw,
   {{0x316901ff,0xdb1c05aa,0x25ad00b7,0x386d3177}},	//   _egaz_, _marò, lgel_, _muer_,
   {{0xdee33178,0x6d4f034f,0x25ad00f0,0x7982007f}},	//   нори, _azca, ogel_, ybow,
   {{0x799b00bf,0x386d0185,0x75fc0113,0xe9ff00fe}},	//   _nduw, _ouer_, _hézr, _thẹn_,
   {{0x7bd53179,0x386d01c2,0xed57001f,0x602600ae}},	// [2660] _bazu, _nuer_, зот_, _ндиа,
   {{0x7bd50012,0x799b317a,0x2a64061d,0x60c40169}},	//   _cazu, _aduw, _simb_, _ipim,
   {{0xf1bf0146,0x386d317b,0x7bd5317c,0xd9100504}},	//   znám_, _auer_, _dazu, چیز_,
   {{0x38c8010d,0xdb1c015e,0x25ad007e,0x6abb0995}},	//   قاتی_, _barò, jgel_, _ćuft,
   {{0xdb1c317d,0x2d92317e,0xdce40034,0x386d2307}},	//   _paró, maye_, ycię, _cuer_,
   {{0x2d92317f,0x25ad3180,0x0ee0055c,0x386d0c89}},	//   laye_, egel_, _पछाड, _duer_,
   {{0xdb1c0610,0x2a640063,0x386d0364,0xb05b0212}},	//   _varó, _timb_, _euer_, rväx,
   {{0x78a23181,0x25ad3182,0x386d0364,0x2d923183}},	//   prov, ggel_, _fuer_, naye_,
   {{0x7bd53184,0xb4d60efd,0xb05b0212,0x7e663185}},	//   _yazu, ाटे_, pväx, _mikp,
   {{0x2d923186,0xd77600e3,0x6d4600dc,0xb8650037}},	//   haye_, _رائع, _myka, _قالو,
   {{0x600b01d4,0x60c43187,0x26de028d,0x2d923188}},	//   _nüma, _apim, _urto_, kaye_,
   {{0xb05b02db,0xa91d0141,0x00000000,0x00000000}},	//   hwät, _seži, --, --,
   {{0x2d923189,0x463b006e,0x3f91318a,0x6b9c0141}},	//   daye_, _פעדע, tazu_, _odrg,
   {{0x545300d6,0x7c3e00e7,0x644f1695,0x00000000}},	//   _звіт, jopr, ïcit, --,
   {{0x645a0102,0x69c00181,0x3f9106e9,0xa91d318b}},	//   mmti, _obme, razu_, _veži,
   {{0x443e2ef9,0x2d92318c,0x7e660063,0x6d46057a}},	//   lot_, gaye_, _cikp, _byka,
   {{0x423809c1,0xa91d02e6,0x7bd5318d,0x443e318e}},	// [2670] _מנהל_, _teži, _pazu, oot_,
   {{0x443e318f,0xf09209c1,0x442c3190,0x69c00364}},	//   not_, _שני_, nnd_, _abme,
   {{0x2d923191,0x7bd5002d,0x386d3192,0x600b013c}},	//   baye_, _vazu, _suer_, _güma,
   {{0xa2a40557,0x7bd53193,0x2d923194,0xdb1c3195}},	//   _किन्, _wazu, caye_, _parò,
   {{0x443e3196,0xddc40dea,0x386d0396,0x89370080}},	//   kot_, lmiş, _quer_, أعضا,
   {{0xd3660080,0x443e0029,0x7642283d,0x7c3e0451}},	//   _له_, jot_, _akoy, copr,
   {{0x443e3197,0x6e2d3198,0xddc40587,0xc1740022}},	//   dot_, onab, nmiş, _haɗe_,
   {{0x6e2d0283,0x644819fb,0x442c3199,0x386d00fd}},	//   nnab, eldi, end_, _tuer_,
   {{0x6298008f,0x442c0088,0x443e319a,0xdb1c003e}},	//   _avvo, fnd_, fot_, _harð,
   {{0x443e319b,0x69d927a9,0x69cb319c,0x25ad00c4}},	//   got_, ldwe, lege, sgel_,
   {{0x81d70081,0xdb1c0088,0x2d92006d,0xd1ca00c2}},	//   সান_, _jarð, yaye_, олне_,
   {{0x69d9319d,0x64480a00,0x442c319e,0x7ae300c2}},	//   ndwe, aldi, and_, änty,
   {{0x2004001f,0x5155319f,0x6e2d0150,0x628a0090}},	//   êmio_, етру, dnab, _ewfo,
   {{0x443e31a0,0x2d9231a1,0x200c31a2,0x81ce0081}},	//   cot_, waye_, ódi_, রাই_,
   {{0x7c3e0ca7,0x7f430084,0x2d9231a3,0x69cb31a4}},	//   vopr, верж, taye_, kege,
   {{0x6e2d31a5,0x69cb31a6,0x764931a7,0x6b8e00bd}},	//   gnab, jege, nley, _sebg,
   {{0x7c3e31a8,0x2d9231a9,0x69cb31aa,0x60c431ab}},	// [2680] topr, raye_, dege, _upim,
   {{0x2d9231ac,0xc1740022,0x6d460146,0xa91d007e}},	//   saye_, _daɗe_, _vyka, _ježu,
   {{0x764931ad,0x6281022b,0x600b007a,0x6d460034}},	//   kley, nplo, _kümn, _wyka,
   {{0x69cb31ae,0x6b8e0a00,0x443e31af,0xbcfb00d1}},	//   gege, _webg, zot_, _ngéw,
   {{0x443e31b0,0x442c0088,0x64480bc6,0x2fc100dc}},	//   yot_, ynd_, yldi, _ybhg_,
   {{0x6e2431b1,0x656b028d,0x93bc020a,0x8cdb19af}},	//   liib, _aggh, lnăv, निरो,
   {{0x443e00d2,0xdb1c0088,0x7d0431b2,0xb4d60179}},	//   vot_, _garð, lyis, ाट्_,
   {{0xceb30054,0xd49a0114,0x442c31b3,0xb05b0364}},	//   דיה_, оро_, wnd_, nwär,
   {{0x443e31b4,0x7d040863,0x64a3001f,0x26c509a1}},	//   tot_, nyis, вања, _eplo_,
   {{0x442c0054,0x9f5a0052,0xb05b042c,0x765b010a}},	//   und_, _copë_, hwär, amuy,
   {{0x443e1ee8,0x442c31b5,0x271c0033,0xd5af31b6}},	//   rot_, rnd_, _পুরো_, _ис_,
   {{0x443e31b7,0x20ca0455,0x7d040084,0x84ea06cf}},	//   sot_, िबंध, kyis, _وفاق_,
   {{0xe8e00134,0x6e240188,0xdb1e1d4b,0x6281084e}},	//   daịs_, diib, lepä, aplo,
   {{0xdb1e0161,0xa294258b,0xc17403e3,0xddc4008b}},	//   cepç, _закі, _raɗe_, tmiş,
   {{0x69cb31b8,0x81d70033,0xb05b042c,0x15f20386}},	//   yege, সাব_, fwär, _आचार_,
   {{0xc33300a1,0xddc4008e,0x764031b9,0x600b00aa}},	//   _שוק_, rmiş, nomy, _gümn,
   {{0x69cb31ba,0xd90431bb,0xde6400e5,0xdc550c37}},	// [2690] vege, _ئی_, търп, евањ,
   {{0x69cb31bc,0x9f89003e,0x7649020e,0xb05b042c}},	//   wege, _góðu_, zley, rwäs,
   {{0x69cb31bd,0x764031be,0x764901e8,0xe0df0036}},	//   tege, komy, yley, lvò_,
   {{0xdb1c0088,0x764000a5,0xdddd007f,0xd9f91147}},	//   _varð, jomy, _wisł, янец_,
   {{0xf1c100b7,0x69d9000b,0x7d1600a5,0x5d7a006e}},	//   ष्यन, rdwe, czys, _מארק,
   {{0x78ab0a9f,0x9f5a022b,0x3e7505e8,0x00000000}},	//   rugv, _bopè_, _kåt_, --,
   {{0x764931bf,0x69cb2774,0x00000000,0x00000000}},	//   tley, pege, --, --,
   {{0xb8d500c7,0x6ec2009f,0xad9b31c0,0x53d700aa}},	//   _জন_, _लहसु, _glút, _भोजश,
   {{0x3e7531c1,0x764931c2,0xe7e00714,0xf1bf0076}},	//   _låt_, rley, _गोवा_, dfá_,
   {{0x764931c3,0x628131c4,0x3707246b,0xa93400d3}},	//   sley, tplo, _очев, _реуш,
   {{0x3e750149,0x76490fa0,0xc7d600ca,0x0ece007f}},	//   _nåt_, pley, _רועי_, _हैंड,
   {{0x6e24008a,0x628131c5,0x7d16007f,0x76400113}},	//   xiib, rplo, yzys, comy,
   {{0xe8e00174,0x70ca00b6,0x00000000,0x00000000}},	//   vaịs_, िबेल, --, --,
   {{0x66091816,0x3e750ec9,0x25bf21d8,0x62810e37}},	//   lkek, _båt_, lful_, pplo,
   {{0x6e240283,0x8464008f,0xcee70c3f,0x00000000}},	//   tiib, _ръце, ндре_, --,
   {{0x7d0402fd,0x644131c6,0xee3a00d6,0xa2a40403}},	//   tyis, loli, їна_, _कित्,
   {{0x44251519,0xdca30ba4,0xa3b6000d,0x25bf31c7}},	// [26a0] oil_, лати, ङ्क_, iful_,
   {{0x7d160d1b,0x442531c8,0x25bf31c9,0x41c1030b}},	//   rzys, nil_, hful_, ष्ठस,
   {{0xa3b702e8,0x387f210f,0xad9b31ca,0x93bc00ae}},	//   _छान_, _atur_, _clús, mnăt,
   {{0x442513b5,0xaca40134,0x13d80033,0x81ce0033}},	//   hil_, _ajụr, তায়, রাক_,
   {{0x644131cb,0x25bf0178,0x76400169,0x00000000}},	//   koli, dful_, vomy, --,
   {{0x442531cc,0x644131cd,0xf09300ca,0x6609168b}},	//   jil_, joli, ננו_, ekek,
   {{0x644131ce,0x0cd0143d,0xa3b3034c,0x764031cf}},	//   doli, _हनुम, टलन_, tomy,
   {{0xe7e00789,0xdb1e00aa,0x442531d0,0x9f5a020d}},	//   _गोरा_, repä, eil_, _copé_,
   {{0x644131d1,0xddde00d9,0xf8d4121d,0xdb1e0302}},	//   foli, _atpū, _धनिय, sepä,
   {{0x644131d2,0x600b008e,0x76400435,0xdcef01d3}},	//   goli, _cüml, somy, _secī,
   {{0xa3b6030b,0xdb1c31d3,0xb05b042c,0x46a60a3a}},	//   ङ्ग_, _obrí, ltäg, _чаев,
   {{0x44250a1b,0x660931d4,0xad9b00b3,0x3e750537}},	//   ail_, ckek, _llúr, _råt_,
   {{0xc05b00d6,0x29060a4b,0x62950094,0xf1bf0076}},	//   зів_, nyoa_, ázor, rfá_,
   {{0x442531d5,0x644131d6,0x20d60c27,0xdb1c24c7}},	//   cil_, coli, džić_, _abrí,
   {{0x9f3400f3,0x80c40081,0x28e231d7,0xdd95013f}},	//   гері, শিষ্, पिडि, кавы,
   {{0xe7e7009f,0x3e750b85,0x629a256f,0x00000000}},	//   _टोना_, _våt_, msto, --,
   {{0x629a1b1a,0x61ed31d8,0xd2f80018,0x905531d9}},	// [26b0] lsto, _inal, _رکھا_, _ивиц,
   {{0x600b31da,0x61ed1d89,0x629a0dd8,0x00000000}},	//   _kümm, _hnal, osto, --,
   {{0xd01100fb,0x61ed31db,0xc1740044,0xe9d90034}},	//   _ملک_, _knal, _haɗa_, _paź_,
   {{0x644131dc,0xdbd70fc4,0x629a1ff7,0xc1740d2a}},	//   zoli, _sääs, isto, _kaɗa_,
   {{0xdbd7069d,0x442531dd,0x644131de,0xfd96028c}},	//   _pääs, yil_, yoli, _בדרך_,
   {{0x442501d4,0x2ca931df,0x64410415,0x25bf0158}},	//   xil_, mrad_, xoli, wful_,
   {{0x629a00e9,0x25bf31e0,0x61ed31e1,0x442531e2}},	//   jsto, tful_, _onal, vil_,
   {{0x442531e3,0x78a40039,0x644131e4,0x2ca90a02}},	//   wil_, šiva, woli, orad_,
   {{0x629a0181,0x6fb200a5,0xc1740d2a,0x25bf31e5}},	//   esto, _जालं, _naɗa_, rful_,
   {{0x69db02a7,0x629a31e6,0x2b9c030b,0x13090084}},	//   _haue, fsto, mácí_, дной_,
   {{0x15b901b6,0x629a31e7,0x2ca90146,0x69db31e8}},	//   _жылы_, gsto, hrad_, _kaue,
   {{0x442531e9,0xe5e5001c,0x412a004d,0xdb17002b}},	//   sil_, _جزئی, домо_, lexó,
   {{0x442531ea,0x66060018,0x224231eb,0x69db0364}},	//   pil_, ökke, rokk_, _maue,
   {{0x7fd501ce,0x61ed31ec,0x442531ed,0xc1740022}},	//   лісі, _enal, qil_, _daɗa_,
   {{0x629a24db,0xa06731ee,0x539a00ca,0x7db631ef}},	//   csto, тара_, _חיצו, ксац,
   {{0x645801e5,0xf1bf0328,0xc1740d2a,0x69db0827}},	//   _zhvi, lián_, _faɗa_, _naue,
   {{0x2ca92461,0xdd8f06fa,0x8e5500d6,0x6b970072}},	// [26c0] grad_, زول_, утрі, faxg,
   {{0x61ed31f0,0x6286077e,0x81ce0033,0xaf0605da}},	//   _znal, ćkov, রাও_, _апол,
   {{0x3f98006d,0x69db01bf,0x93bc020a,0xbf9b2252}},	//   maru_, _baue, onăr, _קיטש,
   {{0x69db2f7c,0x2ca931f1,0x3ced015c,0xc1740d2a}},	//   _caue, brad_, _ševe_, _yaɗa_,
   {{0x69db23f2,0xa9671111,0xd7fa00ae,0x629a31f2}},	//   _daue, вица_, дуй_, zsto,
   {{0xbcfb0068,0x25da1592,0x629a31f3,0xdb210031}},	//   _egés, _खोजी_, ysto, štát,
   {{0x48ee0067,0x59dd31f4,0xf1bf0094,0x7bdc07bc}},	//   _आपको_, _नोकर, onát_, _iaru,
   {{0x7bdc31f5,0xe5c631f6,0x765931f7,0x3f9831f8}},	//   _haru, тско, _chwy, haru_,
   {{0x260331f9,0x3f980a75,0x629a31fa,0x7bdc31fb}},	//   _años_, karu_, wsto, _karu,
   {{0x629a31fc,0x7bdc0022,0x7bde000b,0x61ed08c5}},	//   tsto, _jaru, ndpu, _snal,
   {{0x81dc0081,0x629a31fd,0xa1950b9c,0x68e201b6}},	//   ঠান_, usto, ланч, lvod,
   {{0x7bdc31fe,0x3f9331ff,0xa526020f,0xe8df00fe}},	//   _laru, _sexu_, _имед, _uyển_,
   {{0x629a3200,0xf1bf06cb,0x68e202ef,0x3f983201}},	//   ssto, bián_, nvod, faru_,
   {{0x629a0429,0x6fca0034,0xf1bf0072,0xb4be03b3}},	//   psto, ाजगं, cián_, ँझी_,
   {{0x5f943202,0x81ce0033,0xbcfb03a9,0x26030062}},	//   рист, রাজ_, _ngér, _iñor_,
   {{0x7bdc0af0,0x61ed3203,0x2ca9236c,0xdb050f05}},	//   _aaru, _unal, trad_, nghå,
   {{0x68e22461,0x7bdc08cc,0x3f983204,0x5d550950}},	// [26d0] jvod, _baru, baru_, укат,
   {{0x7bdc3205,0x600b07d1,0x69db3206,0x2ca93207}},	//   _caru, _mümk, _saue, rrad_,
   {{0xba740037,0x69db3208,0xb4ce00a3,0x68e2044c}},	//   لانت, _paue, शबु_, evod,
   {{0xc3330054,0xb05b0704,0x2ca90220,0x60100212}},	//   בוע_, städ, prad_, _jämn,
   {{0x7bdc3209,0x76590150,0x80d9320a,0x621c006e}},	//   _faru, _rhwy, मिटे, וואק,
   {{0x6010070a,0x7bdc320b,0xf1bf002b,0x2b9c02c6}},	//   _lämn, _garu, xián_, rácí_,
   {{0xaa67320c,0x8cdb0976,0xf1bf0072,0x69db10a5}},	//   _атак, निको, vián_, _taue,
   {{0x7bdc00d4,0x60100149,0xb4ce009f,0x2459020d}},	//   _zaru, _nämn, शबू_, ième_,
   {{0x7bdc320d,0x2919320e,0x58d4007b,0x2459020d}},	//   _yaru, _åsa_, _котт, hème_,
   {{0x7bdc0694,0x6b950039,0xa2a40789,0x224908d3}},	//   _xaru, _jezg, _किश्, _akak_,
   {{0x3f98320f,0xf1bf3210,0x6b953211,0xb7da00ca}},	//   varu_, rián_, _mezg, _רקעי,
   {{0x3f983212,0xa2a4201e,0x79992190,0x394d022b}},	//   waru_, _किर्, naww, _kyes_,
   {{0x93bc020a,0xdb1c00da,0x00000000,0x00000000}},	//   rnăr, _mbrá, --, --,
   {{0x70562ba0,0x799903e3,0x2a6d0364,0xdb15014b}},	//   انسا, haww, _lieb_, _eczé,
   {{0xdb1c0871,0x6da62887,0x3f983213,0x04560037}},	//   _obrá, лива, raru_, _حلوة_,
   {{0x7bdc3214,0x2bc606ed,0x22490113,0x394d037a}},	//   _saru, र्ना, _gkak_, _oyes_,
   {{0x6b953215,0x1bea0231,0x3f983216,0x629c2347}},	// [26e0] _bezg, ндаи_, paru_, árov,
   {{0x20130167,0xb05b00c2,0xdb1c033c,0xd0f700ca}},	//   _glxi_, ttäe, _abrá, _עמית_,
   {{0x7bdc3217,0x81d70081,0x09e6062a,0x2a6d0078}},	//   _varu, সার_, ложн, _bieb_,
   {{0x7bdc3218,0xe9470260,0x386c3219,0x02b6006e}},	//   _waru, گرمی, _sidr_, טלעך_,
   {{0x7bdc321a,0xa3b3009d,0x69c2321b,0x984a0219}},	//   _taru, टला_, rfoe, няка_,
   {{0xd6da321c,0xa2a4009d,0xbddb00d1,0x78a4015c}},	//   ети_, _किल्, _akèh, šivo,
   {{0x5fb2007d,0xfd500023,0x394d00ca,0xb05b02c3}},	//   _जाईल, _nghẹ, _eyes_, ltäc,
   {{0xa5bd0138,0x00000000,0x00000000,0x00000000}},	//   liųj, --, --, --,
   {{0x27ef000d,0x2018321d,0x75fc01f9,0x00000000}},	//   ální_, khri_, _kézz, --,
   {{0x63ad0044,0x1cbb006e,0xe7ae0096,0x77920d7f}},	//   _ɓang, עמיע, _घाटप, _ایثا,
   {{0xa686133d,0x2bc607ad,0xfbc60c38,0xe9ff00de}},	//   _след, र्या, र्यम, _chặn_,
   {{0x54e60dd0,0xaca4321e,0xf1bf321f,0xdb050364}},	//   _مستق, _akọr, ciál_, pfhö,
   {{0x75d30037,0x00000000,0x00000000,0x00000000}},	//   _دينا, --, --, --,
   {{0x2bc606ae,0xddd0042d,0xc17401c2,0x75fc0103}},	//   र्मा, _češk, _faɗo_, _nézz,
   {{0x6e9522ee,0xe1ff0103,0x00000000,0x00000000}},	//   рибу, tmód_, --, --,
   {{0x66020006,0x6288028d,0xfc240033,0x2459020d}},	//   _jook, mpdo, বকোষ_, rème_,
   {{0x823409b4,0x200100aa,0xfbab1728,0x2bc60bf5}},	// [26f0] _دروا, _tohi_, етей_, र्भा,
   {{0x66023220,0x6fb200a5,0x60cd3221,0xbd681ad1}},	//   _look, _जाएं, _ipam, урсе_,
   {{0xdddc0995,0x00000000,0x00000000,0x00000000}},	//   sprš, --, --, --,
   {{0xfde90f35,0x6602010a,0x60cd0294,0x2bc6142e}},	//   _ऑफिस_, _nook, _kpam, र्बा,
   {{0x26cc00f9,0x02d11678,0x6b953222,0x0ff80103}},	//   _apdo_, _तन्न, _tezg, _شعیب_,
   {{0x60cd3223,0x60103224,0x79993225,0xa3e3034c}},	//   _mpam, _näml, saww, _पों_,
   {{0x66023226,0xe57100e3,0xc9872bcf,0x00000000}},	//   _book, يطة_, _бузи, --,
   {{0x7aea01c5,0x66023227,0xf1bf0031,0x79990063}},	//   æfte, _cook, fiám_, qaww,
   {{0xf1bf0074,0xc7d9008f,0x6288084e,0x69c9026e}},	//   riál_, _имах_, epdo, _ibee,
   {{0x68e93228,0x291d0a4b,0x4ac900a4,0xe4c80076}},	//   _ired, mzwa_, _रहाव, ابين_,
   {{0xfbd200a1,0x60cd01dc,0x244b3229,0x2d9b0052}},	//   חתי_, _apam, dømt_, kaqe_,
   {{0x01662dfb,0x998f0138,0xb34500ee,0x660206b0}},	//   икно, mogų_, _alçà, _gook,
   {{0xe0d7013d,0x291d322a,0xaca40174,0x69c90517}},	//   авя_, nzwa_, _kwụt, _mbee,
   {{0x66020172,0x6e260063,0x68e903a9,0x7bc501cb}},	//   _zook, _smkb, _mred, jfhu,
   {{0x44d60d1b,0x66020032,0x249f01cd,0x9e660113}},	//   _zł_, _yook, lsum_, لارن,
   {{0x0d8603a0,0xee372fad,0x3ced015c,0x7e6f034f}},	//   рлан, анс_, _ševa_, _cicp,
   {{0x249f322b,0x8fa6322c,0x6010322d,0x0c26322e}},	// [2700] nsum_, _капе, _hämm, аман,
   {{0x69c90283,0x515b00ca,0x6010322f,0x00000000}},	//   _abee, _בכפו, _kämm, --,
   {{0xf1eb0ed3,0x68e93230,0xf778003d,0x69c906b0}},	//   _जोड़_, _ared, _naħa_, _bbee,
   {{0x68e90b97,0xb05b0149,0x249f3231,0xda6500e3}},	//   _bred, ptäc, ksum_, ماني,
   {{0x68e929b0,0x66023232,0x60100084,0x80c40081}},	//   _cred, _rook, _lämm, শিক্,
   {{0xb8ce3233,0x66023234,0x44273235,0x69c9083e}},	//   _कि_, _sook, _nmn_, _ebee,
   {{0x68e917c7,0xfaa30265,0x2bc605a5,0x8f9b006e}},	//   _ered, _маро, र्णा, דיצי,
   {{0x68e90501,0x2d803236,0x28da0006,0x3e7c030b}},	//   _fred, ncie_, _मैथि, _mít_,
   {{0x68e93237,0xfbc60d7a,0x3e7c3238,0x2bc60403}},	//   _gred, र्थम, _lít_, र्था,
   {{0x5fb2007d,0xe3b80f28,0x660200a4,0x44270da7}},	//   _जागल, lnız_, _wook, _cmn_,
   {{0x2d803239,0x68e900f1,0xae940139,0x6602323a}},	//   kcie_, _zred, _bẹmb, _took,
   {{0x2bc60be4,0x2ca00006,0x2d800034,0xe4e6004d}},	//   र्ता, ksid_, jcie_, _вікн,
   {{0x4427323b,0x601002c3,0x25a60158,0x00000000}},	//   _fmn_, _täml, _idol_, --,
   {{0x442700a4,0x2d8000a5,0x24860009,0x2ca000aa}},	//   _gmn_, ecie_, _itom_, dsid_,
   {{0x6448323c,0xf09f323d,0x442c323e,0x6d4f323f}},	//   modi, ssà_, mid_, _syca,
   {{0x442c3240,0xef190034,0x51870cc6,0x131700ca}},	//   lid_, ąż_, _тука, _כחול_,
   {{0x60cd3241,0x442c3242,0xddc400e8,0x00000000}},	// [2710] _upam, oid_, kliņ, --,
   {{0x64483243,0x442c3244,0x1fa72a84,0x46a7034c}},	//   nodi, nid_, _триг, _गिलह,
   {{0x2bc63245,0x25a63246,0x7e6401dc,0x2ca009a1}},	//   र्धा, _odol_, bmip, asid_,
   {{0x68e93247,0x64481b32,0x2d80028d,0x7e6403a9}},	//   _pred, hodi, ccie_, cmip,
   {{0x442c3248,0x2ca03249,0xb9c400e3,0x2486023e}},	//   kid_, csid_, تقني, _ntom_,
   {{0x68e9324a,0x6e2d324b,0xe73913cb,0x442c324c}},	//   _vred, liab, лел_, jid_,
   {{0x2486324d,0x7d0d324e,0x68e9324f,0x2d993250}},	//   _atom_, lyas, _wred, _kese_,
   {{0x249f04de,0x68e90d3e,0x442c3251,0xdb160037}},	//   tsum_, _tred, eid_, _ócái,
   {{0x2d993252,0x7d0d3253,0x8939101b,0x644800f0}},	//   _mese_, nyas, _спас_, fodi,
   {{0x644802e6,0x6e2d3254,0x249f3255,0x2d993256}},	//   godi, hiab, rsum_, _lese_,
   {{0x249f3257,0x8c1a00a1,0x2d800034,0x24860113}},	//   ssum_, רותי, ycie_, _etom_,
   {{0x2d993258,0x442c3259,0x2ca00188,0x28ae030b}},	//   _nese_, aid_, ysid_, _घिमि,
   {{0xddc608a9,0x442702e7,0x442c325a,0x661b0239}},	//   _nikš, _tmn_, bid_, mhuk,
   {{0x7d0d325b,0x44271d42,0x661b0167,0x6010007b}},	//   dyas, _umn_, lhuk, _tämm,
   {{0x81bf00c7,0x2d99325c,0xddc6013f,0x81cd0081}},	//   ীয়_, _bese_, _aikš, রয়_,
   {{0x2ca0007a,0xdb170161,0xf2d200c1,0x2d990610}},	//   tsid_, nexõ, _זעה_, _cese_,
   {{0x2d99325d,0x2d80325e,0x7d0d0018,0x6e36325f}},	// [2720] _dese_, rcie_, gyas, rnyb,
   {{0x80ad0be4,0xe7e700aa,0x2d990139,0x78a40094}},	//   _जिते, _टोला_, _eese_, šivk,
   {{0x2ca000aa,0x6e2d3260,0xd24f0421,0xb5fd00e7}},	//   ssid_, biab, _زنی_, zmša,
   {{0x6e2d3261,0x753d0034,0x64483262,0x2d99057a}},	//   ciab, ższy, zodi, _gese_,
   {{0x442c3263,0xdb1e0018,0x64483264,0xe3b8026a}},	//   yid_, lepü, yodi, ygı_,
   {{0x442c3265,0xf09300ca,0xc8793266,0x00000000}},	//   xid_, לנד_, _duş_, --,
   {{0x24863267,0x09e61c66,0x2d993268,0x07a30e2c}},	//   _stom_, _ловн, _yese_, чајн,
   {{0x442c3269,0xd5ba2d70,0x3f9a077e,0xf1bf0103}},	//   wid_, уск_, _lepu_, riák_,
   {{0x38cb110a,0xa3b3009d,0x693400d1,0x00000000}},	//   _مالی_, टलं_, _بکار, --,
   {{0x3e41013f,0x6e2d20a6,0x2a66016d,0x79820034}},	//   mėte_, ziab, lmob_, lcow,
   {{0x442c326a,0x6448326b,0x95ca00d6,0x4bfb0341}},	//   rid_, rodi, _була_, אליס,
   {{0x442c05a7,0x661b068d,0xdb1e0034,0x78a209ac}},	//   sid_, chuk, lepó, osov,
   {{0x2d99028d,0x2486326c,0x442c326d,0x6b9e19e6}},	//   _rese_, _utom_, pid_, kapg,
   {{0x2d99326e,0x7d0d326f,0x3f9a3270,0x09cc0033}},	//   _sese_, vyas, _cepu_, _রোমা,
   {{0x2d993271,0x877b028c,0x59c80455,0x53333272}},	//   _pese_, ראלי, रभार, _нешт,
   {{0x7d0d3273,0x3eac3274,0x2bc600b6,0x2d990216}},	//   tyas, ádta_, र्सा, _qese_,
   {{0x2d993275,0x6e2d3276,0x443c11bc,0xdb993277}},	// [2730] _vese_, riab, _kjv_, ивач_,
   {{0x224b3278,0x6e2d04de,0x2d993279,0x7d0d327a}},	//   lock_, siab, _wese_, ryas,
   {{0x7d0d327b,0x2d99327c,0x6a730090,0x78a20094}},	//   syas, _tese_, _aħfr, esov,
   {{0x224b0154,0xddc601d3,0xbf050179,0x2a66016d}},	//   nock_, _tikš, रहीन_, gmob_,
   {{0x26de01c8,0xbddb0139,0x2bc602d5,0x6e3d327d}},	//   _asto_, _ajèg, र्हा, _ijsb,
   {{0x6d5d01d3,0x1869327e,0x00000000,0x00000000}},	//   _izsa, шали_, --, --,
   {{0xb05b0084,0x661b327f,0x2a66022e,0xe3ae0033}},	//   ytän, thuk, bmob_, কভাব,
   {{0xc4850408,0x7bd73280,0x06093281,0x34a90291}},	//   олик, lexu, рник_, авио_,
   {{0x2bc611c6,0x26de0eb8,0xe3b11857,0xe61600d6}},	//   र्वा, _esto_, ورد_, ідь_,
   {{0x661b3282,0x42c93283,0x799b0313,0x00000000}},	//   shuk, агон_, _heuw, --,
   {{0xb05b0084,0xd7f80019,0x26de00f9,0xc17403e3}},	//   ttän, _khăn_, _gsto_, _haɗi_,
   {{0xb6860018,0x00000000,0x00000000,0x00000000}},	//   _بھول_, --, --, --,
   {{0xb05b0853,0x53a50231,0x00000000,0x00000000}},	//   rtän, _далб, --, --,
   {{0xb05b3284,0x799b0085,0x248d080f,0x00000000}},	//   stän, _leuw, mpem_, --,
   {{0xdee30f99,0x248d016d,0x3f6a078b,0x7bd7044c}},	//   мори, lpem_, риво_, dexu,
   {{0xe1ff0610,0xd7f80023,0x3f9a0294,0x799b0364}},	//   lmón_, _nhăn_, _wepu_, _neuw,
   {{0xad6600bf,0x3f9a3285,0xafe60d85,0x248d0063}},	// [2740] زاره, _tepu_, _допл, npem_,
   {{0x6b561e6d,0x61e63286,0xc17403e3,0x80d70034}},	//   отех, ldkl, _naɗi_, यबरे,
   {{0x61e40256,0x00000000,0x00000000,0x00000000}},	//   _kail, --, --, --,
   {{0xd7f800de,0xdcfd0138,0x27e90022,0x78a23287}},	//   _chăn_, _nesė, ɓani_, tsov,
   {{0xe8943288,0x2d923289,0x68460036,0xc17401c2}},	//   чаль, mbye_, онда, _baɗi_,
   {{0xacd90130,0x76aa328a,0x2cb202ad,0x78a2328b}},	//   _פֿרי, атив_, mryd_, rsov,
   {{0xa01b00c2,0xc1740d2a,0x26de0036,0x7bce009e}},	//   mpöt, _daɗi_, _qsto_, _ibbu,
   {{0x78ad03ce,0x6b9c328c,0x2bc609f6,0x2bd8009f}},	//   šava, _herg, र्रा, ड़वा,
   {{0x07a6328d,0x6b9c007a,0x7aee0087,0xc1740d2a}},	//   _маан, _kerg, _hrbt, _faɗi_,
   {{0x3eb800dd,0x6b9c328e,0x136a0c59,0x2fd802b6}},	//   kurt_, _jerg, ишни_, jerg_,
   {{0x61e4328f,0x6b9c3290,0x26de04e9,0x4b7b006e}},	//   _bail, _merg, _usto_, יטיג,
   {{0x61e43291,0x201a3292,0x6b9c3293,0x00000000}},	//   _cail, _alpi_, _lerg, --,
   {{0x61e43294,0x660f00a2,0x6b9c0178,0x7bce010a}},	//   _dail, öcke, _oerg, _obbu,
   {{0xcbd500c7,0x3eb83295,0x6b9c3296,0x2fd8010a}},	//   _হচ্ছ, furt_, _nerg, gerg_,
   {{0xdd9b0508,0x2d880294,0x93cb0018,0x3ea50103}},	//   иша_, _ọlị_, _خانہ_, élt_,
   {{0x3ead0897,0x61e43297,0x7bce003d,0xbddb0139}},	//   čet_, _gail, _abbu, _akèr,
   {{0x6b9c3298,0x2fd802c3,0xc05b02ec,0x40353299}},	// [2750] _berg, berg_, _він_, _неис,
   {{0xa2a40dba,0x6b9c329a,0x61e40a00,0x3eb80364}},	//   _किञ्, _cerg, _zail, burt_,
   {{0x23c2000f,0x6b9c329b,0xb05b00c2,0x0a6b0d85}},	//   _शानद, _derg, ntäm, арди_,
   {{0x6b9c1044,0x69c00f09,0x7bce083e,0x2cb200f0}},	//   _eerg, _ccme, _ebbu, bryd_,
   {{0x6b9c329c,0x6d5d00e4,0x00000000,0x00000000}},	//   _ferg, _uzsa, --, --,
   {{0x3abb0979,0x6b9c329d,0x66e5268e,0xa69519e8}},	//   _پاسخ_, _gerg, зока, приј,
   {{0x1995329e,0x09c20033,0x00000000,0x00000000}},	//   _навя, োয়া, --, --,
   {{0x6b9c0a00,0xd6ce00e3,0x6b8500f0,0xbcfb300f}},	//   _zerg, اقي_, lchg, _izéb,
   {{0x69d9329f,0x6d4301bf,0xc17401c2,0x3a2d00b3}},	//   mewe, ßnah, _taɗi_, _imep_,
   {{0x69d932a0,0x69cb32a1,0x6b9c0072,0x942200c2}},	//   lewe, lfge, _xerg, емье,
   {{0x81e500c7,0xef2000a5,0xb05b0212,0x91e611cc}},	//   নান_, ążki_, rtäl, поне,
   {{0xb05b070a,0x614632a2,0x69d9089a,0x00000000}},	//   stäl, зема, newe, --,
   {{0x61e6084e,0x61e432a3,0xf99200ca,0xc7b800fe}},	//   rdkl, _vail, ערך_, _tmđt_,
   {{0xb4d70409,0xe3b3001c,0xa06a0077,0xb05b007b}},	//   ाबी_, _آرش_, сага_, ltäj,
   {{0x61e432a4,0x6aba00b6,0x00000000,0x00000000}},	//   _tail, _उमेर, --, --,
   {{0x2cb20185,0xbddb10fe,0x69d901cb,0xbc760037}},	//   tryd_, _ajèb, jewe, كهرب,
   {{0x69d932a5,0x3eb832a6,0xee37004d,0x224003a9}},	// [2760] dewe, surt_, їну_, _ijik_,
   {{0xdce600d9,0xef1a0284,0x27e502ac,0x3eb832a7}},	//   _iekļ, _гмо_, _naln_, purt_,
   {{0x6b9c32a8,0x9f9700a1,0x78b901cb,0xc98605cb}},	//   _verg, _מדיה_, euwv, пули,
   {{0x69d90b7c,0x63a132a9,0xe8fa32aa,0x320900de}},	//   gewe, haln, йле_, _xoay_,
   {{0x6b9c06ee,0xc5c30081,0x3a3f0572,0x7e7e32ab}},	//   _terg, ্যাপ, _djup_, _hupp,
   {{0xfaa632ac,0xb05b00c2,0x5fc00285,0x7e7e32ad}},	//   _наго, ytäm, श्चल, _kupp,
   {{0x8c1b00a1,0x7c2e0f2c,0x69d932ae,0xbb4300c2}},	//   _פולי, _imbr, bewe, _зерк,
   {{0x44f40f94,0xbb3b040a,0xc1740022,0xd5e200fe}},	//   дпис, _העלי, _haɗu_, _khỏ,
   {{0x63a10995,0x81e50081,0x7e7e1894,0xc17401c2}},	//   faln, নাম_, _lupp, _kaɗu_,
   {{0xb05b02fd,0x2281003e,0x320932af,0x26c70141}},	//   ttäm, _bók_, _soay_, btno_,
   {{0xe1d902ec,0x316032b0,0xd5af180b,0x7e7e0f18}},	//   одні_, _aziz_, _пс_, _nupp,
   {{0x250b0260,0xa194224a,0x63a100aa,0xb05b00c2}},	//   _گرمی_, наюч, aaln, rtäm,
   {{0xd6250080,0xb05b32b1,0xf1a40138,0x0cd70081}},	//   _تعلي, stäm, эрэн, _সপ্ত,
   {{0x63a132b2,0xb4e802d5,0x3e4100c6,0x00000000}},	//   caln, मटी_, dėta_, --,
   {{0x628a3135,0x69d90239,0x00000000,0x00000000}},	//   _utfo, yewe, --, --,
   {{0x433b00ca,0xd25100b9,0x7e7e0ac9,0xc3330eda}},	//   _לעוב, _جنب_, _dupp, _רוק_,
   {{0x69d91e72,0xb05b16c7,0x00000000,0x00000000}},	// [2770] vewe, ntäk, --, --,
   {{0x69d90361,0x7055001c,0xf77800bd,0x6f0300b3}},	//   wewe, _زنجا, _daħk_, _ànco,
   {{0x34d9000d,0x442e031a,0xd7f80019,0x6b8501bf}},	//   _भन्द, _mmf_, _chăm_, rchg,
   {{0x63a105c5,0xf1bf32b3,0x7c2e32b4,0x6b850364}},	//   zaln, ngá_, _embr, schg,
   {{0x37e50769,0x7e7e0451,0x69cb31fc,0x7c2e0381}},	//   долг, _zupp, rfge, _fmbr,
   {{0xacfa00a1,0x69d932b5,0x78ad031a,0x9be40120}},	//   _והשכ, sewe, šavo, _піск,
   {{0x63a10b27,0xb05b0084,0x69d9010a,0xb7c80037}},	//   valn, ttäj, pewe, سبوك_,
   {{0x60100222,0x26c70660,0x63a10034,0x00000000}},	//   _hämt, rtno_, waln, --,
   {{0x26c702dd,0xc17403e3,0xf2b60033,0xb4d700c3}},	//   stno_, _yaɗu_, _জনগণ, ाबे_,
   {{0x60100212,0x52a9248d,0xb05b00c2,0x78a9039f}},	//   _jämt, овом_, stäj, _ivev,
   {{0x387f16b4,0x56940831,0xfbcf0469,0x04ef0033}},	//   _huur_, _захт, स्यम, য়নের_,
   {{0x63a132b6,0x387f32b7,0x600b00bc,0x1515166f}},	//   saln, _kuur_, _sümp, _одея,
   {{0x7e7e32b8,0x63a132b9,0xe44e32ba,0xa5bd013f}},	//   _supp, paln, _аж_, siųs,
   {{0x22810088,0x387f0305,0x7e7e32bb,0x2bcf1e05}},	//   _tók_, _muur_, _pupp, स्मा,
   {{0x41c60034,0x00000000,0x00000000,0x00000000}},	//   _वापस, --, --, --,
   {{0x25bf32bc,0xb7d40065,0x00000000,0x00000000}},	//   ngul_, _iṣeg, --, --,
   {{0xdca330fa,0x387f32bd,0xed570396,0x7e7e32be}},	// [2780] кати, _nuur_, дот_, _wupp,
   {{0x7e7e32bf,0x8d6300c2,0x4d63004d,0x798932c0}},	//   _tupp, твуе, ткув, _afew,
   {{0x78a90465,0x78ad2f54,0x0e661b04,0xb9e600d6}},	//   _avev, šavl, _окон, діли,
   {{0xd3780106,0x81e50033,0x387f32c1,0xb05b007b}},	//   meće_, নাথ_, _buur_, ytäk,
   {{0xd3781100,0x02da046e,0x41c6023a,0xb4d700c3}},	//   leće_, _बन्न, _वानस, ाबो_,
   {{0x387f32c2,0xd7f80019,0x6d4600bd,0x368a004d}},	//   _duur_, _thăm_, _ixka, осин_,
   {{0x6a830231,0xd378077e,0x7a370174,0x81e50033}},	//   _алса, neće_, ụtaa, নাত_,
   {{0x973c02e6,0x25bf32c3,0xd5b00103,0x3ced00c4}},	//   _neće, ggul_, اہش_, _ševi_,
   {{0xe3ce0028,0x47c60831,0x442e32c4,0x60101531}},	//   _dựng_, _обав, _pmf_, _jäms,
   {{0x25bf020a,0x7863002d,0x7c3e32c5,0x3cfb021e}},	//   agul_, _акуз, nnpr, קלינ,
   {{0x0bb70054,0xd37820e4,0x225900c2,0x387f029a}},	//   ולים_, jeće_, зины_, _zuur_,
   {{0xd37802e6,0x442e08bc,0x00000000,0x00000000}},	//   deće_, _wmf_, --, --,
   {{0x764232c6,0xf1bf037a,0x00000000,0x00000000}},	//   _ijoy, rgá_, --, --,
   {{0x656228e4,0xdb1c32c7,0x442e32c8,0x7c3e01cb}},	//   _izoh, _acrí, _umf_, jnpr,
   {{0x768701e8,0xe6dc32c9,0x660b023e,0x443e32ca}},	//   _kıya, _मनोज, _yogk, mnt_,
   {{0x645a02ad,0xf1d00019,0x601001bf,0x7c3e01ff}},	//   llti, _hạng_, _sämt, enpr,
   {{0x443e01b5,0x2d580978,0xf4bc0081,0x9cc800c2}},	// [2790] ont_, дить_, _অনুব, дыха_,
   {{0x443e32cb,0x3dc00270,0xdefb1402,0x2bbb0037}},	//   nnt_, agiw_, _дым_, تارة_,
   {{0x443e32cc,0xf1d00028,0x387f007a,0x645a32cd}},	//   int_, _mạng_, _suur_, ilti,
   {{0x443e02e2,0x321932ce,0xdb1c0037,0x387f32cf}},	//   hnt_, nksy_, _gcrí, _puur_,
   {{0x7e6d32d0,0x625d014b,0xa3be32d1,0x497400d1}},	//   mmap, véol, इला_, ندهآ,
   {{0xb9070d0b,0x764208dd,0xd3661f11,0x7e6d32d2}},	//   _बन_, _ajoy, _مه_, lmap,
   {{0x7ac432d3,0x2aa832d4,0x65621c64,0x443e32d5}},	//   _исте, _отто_, _azoh, dnt_,
   {{0x443e32d6,0xceb42865,0x387f1973,0x645a18ef}},	//   ent_, דיק_, _tuur_, elti,
   {{0x2bcf20cd,0x2ca90fa0,0x25bf32d7,0xa954004d}},	//   स्था, nsad_, rgul_, _акті,
   {{0xd3780039,0x443e32d8,0x69320018,0x73050b1b}},	//   zeće_, gnt_, _حکمر, епоз,
   {{0xf1d00019,0xc6a40095,0x973c00c4,0x656232d9}},	//   _dạng_, _арчи, _peće, _ezoh,
   {{0x2bcf0fef,0x443e32da,0xfbcf1678,0x2ca900bc}},	//   स्ता, ant_, स्तम, ksad_,
   {{0x973c04a3,0xa1550465,0xd3780335,0x443e036b}},	//   _veće, върш, veće_, bnt_,
   {{0xdb1c0080,0x201e32db,0x6606003e,0x62840ebd}},	//   _scrí, óti_, ökkv, _čiov,
   {{0xd3782461,0x60100212,0x00000000,0x00000000}},	//   teće_, _säms, --, --,
   {{0x201832dc,0x7e6d0eac,0x7c3e32dd,0x2ca932de}},	//   skri_, gmap, wnpr, fsad_,
   {{0x15f20251,0xd3780106,0x2b580113,0xfe4332df}},	// [27a0] _अफसर_, reće_, _syrc_, унто,
   {{0xaf9a0084,0x24820220,0x25af1bbd,0xb05b007b}},	//   _этих_, íkmi_, _ldgl_, ytäi,
   {{0x3f9832e0,0x2bc60efd,0x7c3e32e1,0xe8032748}},	//   mbru_, र्गा, rnpr, लाना_,
   {{0xda650037,0x2d96227c,0x0f37006e,0x3946007b}},	//   ناني, _ярос, _טריט_, ннег,
   {{0x443e32e2,0x64431e4d,0x00000000,0x00000000}},	//   ynt_, _ojni, --, --,
   {{0xb05b02fd,0x6e240124,0x2bc605fa,0xf6e600d3}},	//   ttäi, lhib, र्खा, ецин,
   {{0x8c431116,0xd6d732e3,0x443e0856,0x765b32e4}},	//   _сере, еты_, vnt_, fluy,
   {{0xa3d22c5f,0x443e32e5,0x2bd800c3,0xfaf700ca}},	//   ह्न_, wnt_, ड़का, _אצלי_,
   {{0x290200dd,0x2bc70640,0x443e32e6,0x6846001f}},	//   _çka_, _लामा, tnt_, _знаа,
   {{0xe8d700a1,0x443e32e7,0x69c21044,0xb05b0853}},	//   _אומר_, unt_, lgoe, ltäv,
   {{0xa195055b,0x443e32e8,0x7bde02ac,0xf1d0020b}},	//   канч, rnt_, iepu, _vạng_,
   {{0x765b14e2,0x2bc7007d,0x69c232e9,0xb05b00c2}},	//   cluy, _लाभा, ngoe, ntäv,
   {{0x6e2432ea,0x7bde32eb,0xf1d00023,0x6606003e}},	//   dhib, kepu, _tạng_, ökku,
   {{0xb05b0084,0x60100149,0xb80332ec,0xe8030034}},	//   htäv, _sämr, लायम_, लाया_,
   {{0x69c218f0,0xdb1c0503,0x00000000,0x00000000}},	//   kgoe, _mbró, --, --,
   {{0x6e2432ed,0x09d50081,0x2ca932ee,0xc1520174}},	//   ghib, _সোনা, tsad_, ọkọr,
   {{0xd90411a2,0x7e6d32ef,0xe803030b,0xe8df0174}},	// [27b0] _ای_, rmap, लामा_, _kwụa_,
   {{0x7e6d0113,0x2bd80034,0x2ca932f0,0x7bde32f1}},	//   smap, ड़गा, rsad_, gepu,
   {{0x2ca932f2,0xa3d21fb4,0x69c201c0,0x1eab0037}},	//   ssad_, ह्य_, fgoe, _عادي_,
   {{0x6e2432f3,0xddc4044c,0x00000000,0x00000000}},	//   chib, rmiţ, --, --,
   {{0x260416e2,0x601032f4,0x9f5a022b,0x2ca9041c}},	//   वानी_, _kämp, _anpè_, qsad_,
   {{0x7bde0012,0xec350130,0xa3d2009d,0x69c20634}},	//   cepu, _יאָר_, ह्म_, agoe,
   {{0xf4c200c7,0x765b0233,0x99850076,0x00000000}},	//   ্টোব, tluy, _للزو, --,
   {{0x601032f5,0x00000000,0x00000000,0x00000000}},	//   _lämp, --, --, --,
   {{0xe1ff0034,0x9f5a0154,0x5a440ff1,0x68e20113}},	//   lmów_, _enpè_, _сэра, cwod,
   {{0x2496001c,0x6e24033b,0xa934001f,0x28da32f6}},	//   کنید_, zhib, _сеуш, _मैटि,
   {{0x232909f2,0x2bc632f7,0xfbc609c4,0x00000000}},	//   фони_, र्टा, र्टम, --,
   {{0x65951b77,0x7aea052f,0x80cb0033,0x7bde007f}},	//   _раду, æfti, িবন্, zepu,
   {{0xbcfb0103,0xc24332f8,0x661b0350,0x00000000}},	//   _szén, рняк, mkuk, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x6e2432f9,0x8fa32ca3,0x60100f3a,0xb05b00c2}},	//   thib, расе, _dämp, ytäv,
   {{0x63a332fa,0x68e202ad,0x7bd501bf,0x661b32fb}},	//   _henn, ywod, _abzu, nkuk,
   {{0x644132fc,0x628332fd,0x7bde32fe,0x6e2432ff}},	// [27c0] onli, _huno, tepu, rhib,
   {{0x62833300,0x64413301,0xd3780335,0x973c0234}},	//   _kuno, nnli, leća_, _leća,
   {{0x81e50f71,0x26040789,0x63a33302,0xb05b02fd}},	//   নার_, वामी_, _menn, ttäv,
   {{0x63a33303,0x62833304,0x7bde3305,0xaca40294}},	//   _lenn, _muno, sepu, _amụr,
   {{0xe3a70434,0x69c23306,0x92cd0081,0x62833307}},	//   _پر_, rgoe, রিয়_, _luno,
   {{0x63a33308,0x64410ab2,0xb05b0084,0x8d770103}},	//   _nenn, jnli, stäv, _جاپا,
   {{0x29000012,0x973c00cc,0xc5eb0081,0x4ab900d3}},	//   ţia_, _beća, কানা_, _путя_,
   {{0xd3780292,0x64413309,0x661b00a6,0xcb67330a}},	//   jeća_, enli, gkuk, _расе_,
   {{0x70dc02e8,0xd37803ce,0x63a3330b,0x6283330c}},	//   यबोल, deća_, _benn, _auno,
   {{0x63a3330d,0xe7c900a5,0x2bc6030b,0x6283330e}},	//   _cenn, _रायप, र्चा, _buno,
   {{0x63a3017a,0x62830012,0x42752777,0x601000bc}},	//   _denn, _cuno, лгос, _rämp,
   {{0x628319a1,0x9f410094,0x058300d3,0x27ec0158}},	//   _duno, _nahá_, _кушм, _hadn_,
   {{0xc05b02ec,0x63a3330f,0xe7c91687,0x81e50033}},	//   дів_, _fenn, _रामप, নাল_,
   {{0x63a33310,0x44253311,0xe44f0281,0x628301ff}},	//   _genn, chl_, _وضو_, _funo,
   {{0x63a805f1,0x628300d3,0x9f4104bf,0x645800d9}},	//   madn, _guno, _bahá_, _ikvi,
   {{0x78ad0039,0x337700a1,0x2bc6077d,0xf365004d}},	//   šavi, _בתוך_, र्घा, _стін,
   {{0x63a30283,0x39490034,0x61ed0270,0x16bf0469}},	// [27d0] _yenn, żasz_, _iaal, _एम्ब,
   {{0x61ed3312,0xddc43313,0x63a82029,0x6283029a}},	//   _haal, rmiš, nadn, _yuno,
   {{0x61ed3314,0xfe6e12eb,0x00000000,0x00000000}},	//   _kaal, تگی_, --, --,
   {{0x61ed008a,0x63a83315,0xc33300a1,0x3a2600f9}},	//   _jaal, hadn, סוף_, ghop_,
   {{0x61ed3316,0x394900c9,0x66090292,0x7e7d3317}},	//   _maal, ças_, vjek, _iisp,
   {{0xd37800e9,0xa3d22480,0x973c104b,0xab9400d6}},	//   zeća_, _हॉल_, _seća, _вирі,
   {{0x63a33318,0xadc40065,0x973c0580,0x644113c8}},	//   _renn, _ajẹs, _peća, vnli,
   {{0x61ed3319,0x2bcf080f,0x7e7d003d,0x3a26029a}},	//   _naal, स्रा, _jisp, chop_,
   {{0x69cc025b,0x7e7d331a,0x661b331b,0x6283265b}},	//   ílež, _misp, rkuk, _suno,
   {{0x7bc5331c,0x6283331d,0x6609331e,0x661b331f}},	//   nghu, _puno, sjek, skuk,
   {{0x63a33320,0xc5d502ec,0x61ed3321,0xbcfb0018}},	//   _venn, _біль, _baal, _szél,
   {{0x61ed0694,0x63a305c9,0x7e7d3322,0xaca30174}},	//   _caal, _wenn, _nisp, _akọc,
   {{0x61ed3323,0x04c80037,0x63a33324,0x63a83325}},	//   _daal, _لوني_, _tenn, badn,
   {{0x62833326,0xf77803e5,0x34b200cd,0xd378031a}},	//   _tuno, _taħt_, _اموز, seća_,
   {{0x61ed3327,0x6d5d0694,0xb05b0003,0x7e7d3328}},	//   _faal, _aysa, kräf, _bisp,
   {{0xc6920130,0x61ed3329,0x69c9006c,0xfce60859}},	//   מאל_, _gaal, _ncee, лобо,
   {{0xdd8f0602,0x2604332a,0xaca40174,0xbcfb03a9}},	// [27e0] سول_, वाती_, _otụt, _nyéd,
   {{0x69c9002d,0x309b09c1,0x61ed0517,0x7e7d332b}},	//   _acee, _רשימ, _zaal, _eisp,
   {{0x61ed332c,0x68e9332d,0xbcfb0af0,0xb05b17a5}},	//   _yaal, _ased, _ayéd, rtät,
   {{0x61ed0694,0xb05b02e2,0x63a80087,0x7e7d00ee}},	//   _xaal, stät, zadn, _gisp,
   {{0x522d00c1,0xd5e200fe,0x09360076,0x6d5d03a8}},	//   וואַ, _nhó, دراج, _gysa,
   {{0xcaa600e3,0x3a26332e,0xdd3b006e,0x3db00033}},	//   _مصري, shop_, _װעלכ, ঙ্খল,
   {{0x63a81b30,0x68e9332f,0xd5e200fe,0x0b59022a}},	//   vadn, _esed, _phò, _арты_,
   {{0xa28100a5,0xe4e600d6,0xb05b15e6,0xd49a3330}},	//   łość_, гіон, ntär, нро_,
   {{0x61ed008a,0x2ba8063c,0x39460291,0x27fe0113}},	//   _raal, गरपा, _снаг, _tntn_,
   {{0x61ed3331,0x25070103,0x00000000,0x00000000}},	//   _saal, ارٹی_, --, --,
   {{0x2604022d,0x61ed3332,0xb05b0212,0xcc57006e}},	//   वादी_, _paal, ktär, רביי_,
   {{0x63a81d25,0x64a63333,0x61ed0188,0xf8c80ded}},	//   sadn, _бада, _qaal, _रमाय,
   {{0x7e7d07fa,0x61ed3334,0x68e90063,0xf1bf1ac3}},	//   _risp, _vaal, _xsed, bhán_,
   {{0x43943335,0xf1bf0080,0x61ed3336,0x7e7d06a3}},	//   _такс, chán_, _waal, _sisp,
   {{0x61ed3337,0x5f943338,0x3e410138,0x248600c2}},	//   _taal, сист, lėti_, _huom_,
   {{0x92b30f36,0x387e3339,0x95e200a3,0x00000000}},	//   _احوا, _litr_, _खसोट_, --,
   {{0x7e7d0029,0x3e41013f,0xc04731bb,0x00000000}},	// [27f0] _visp, nėti_, _مخدو, --,
   {{0x25a60150,0x6d5d0579,0x7e7d02ac,0xb05b0212}},	//   _leol_, _vysa, _wisp, dräg,
   {{0x78bc00d9,0xb05b333a,0x7e7d333b,0xe80309c4}},	//   _ārva, träf, _tisp, लासा_,
   {{0x973c0f39,0x3e41013f,0x2bc70096,0x2d8201ff}},	//   _pećn, kėti_, _लावा, _ggke_,
   {{0xe945001c,0x05260033,0xae9500fe,0x00000000}},	//   جرای, মপুর_, _kẹos, --,
   {{0x3e4101b3,0x25a90087,0x973c0095,0x20130062}},	//   dėti_, _žal_, _većn, _joxi_,
   {{0xbddb0154,0x00000000,0x00000000,0x00000000}},	//   _skèy, --, --, --,
   {{0x25a60a1b,0x68e901c2,0x9b5800ae,0x2486281b}},	//   _ceol_, _tsed, _сист_, _buom_,
   {{0x387e333c,0x68e9333d,0xf1bf0037,0xf77802a1}},	//   _fitr_, _used, thán_, _daħq_,
   {{0x22490d17,0x391400ae,0x893800d3,0x00000000}},	//   _ajak_, _умур, _спус_, --,
   {{0x2a6d333e,0x69cc000d,0x63bc0088,0x31690103}},	//   _kheb_, _हामी, órna, _azaz_,
   {{0xd575333f,0x20010124,0xa4d5004d,0x3e410138}},	//   _куль, _anhi_, _воді, bėti_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xa06a01b3,0xfaf801d3,0x8fa33028,0x00000000}},	//   тага_, _šīm_, жаре, --,
   {{0xb05b00c2,0x25a60da7,0xdee63340,0x4375006e}},	//   ttär, _yeol_, шови, _דײַן_,
   {{0x644f0257,0x2249023b,0x9ac700bd,0x3dd90178}},	//   écif, _gjak_, _miċħ, _cbsw_,

   {{0x6fd600d6,0xc0e62bbb,0xa2a10e28,0xe1ff2a6b}},	// [2800] _кінц, _топк, कीर्, rmót_,
   {{0xb05b3341,0xd00f0076,0x5faa007f,0x00000000}},	//   stär, _يلي_, _क़िल, --,
   {{0x395f07ac,0xe6d403b3,0x79a6016d,0xaca40032}},	//   _ayus_, _दहेज, арле, _ijọr,
   {{0xb05b02d6,0x2efa2243,0x2a6d3342,0x5fd2314f}},	//   träg, _irpf_, _cheb_, द्रल,
   {{0x26041344,0x386c0094,0xda650076,0xb05b02c3}},	//   वासी_, _phdr_, حالي, bräd,
   {{0x25a600e3,0xdca3215c,0x68431165,0x9856002d}},	//   _seol_, _фари, онча, штеш,
   {{0x973c0106,0x387e3343,0x00000000,0x00000000}},	//   _većo, _vitr_, --, --,
   {{0xb05b0fe8,0xd8480134,0x387e020b,0x6b630120}},	//   präg, wọd_, _witr_, _єкта,
   {{0x87da03ed,0x6f1c00f0,0x81ac0033,0x00000000}},	//   _لباس_, hyrc, খলা_, --,
   {{0xbcfb0018,0x3e410138,0xa9230206,0x00000000}},	//   _szék, rėti_, úžen, --,
   {{0x233801b3,0x05ea00ae,0xb6cb0103,0x00000000}},	//   упны_, _афли_, _لانے_, --,
   {{0xd25800d6,0x25dd3344,0xd377013f,0x3e4100c6}},	//   иця_, _कॉपी_, шчы_, pėti_,
   {{0x04943345,0xfd560294,0x66023346,0x625d014b}},	//   _التح, robị, _inok, déot,
   {{0x251b0266,0x04db0142,0x26040096,0x398d0065}},	//   _בודא, _סקול, वावी_, _kósó_,
   {{0x6f1c02ad,0xbe883347,0x66023348,0x6367008f}},	//   gyrc, исте_, _knok, _кръг_,
   {{0x30a722ff,0xdd98231c,0x2249042d,0xa3d200b6}},	//   _кров, ишу_, _ujak_, ह्र_,
   {{0xb05b0149,0x786d016d,0x629a3349,0x25dd136b}},	// [2810] träd, lúve, lpto, _कॉफी_,
   {{0x2bb80076,0x00000000,0x00000000,0x00000000}},	//   لامة_, --, --, --,
   {{0x19b9334a,0xd8480294,0x6602334b,0xb05b3341}},	//   гуль_, kọb_, _onok, rräd,
   {{0x2a6d022e,0x4975107a,0x6602010a,0x9f430216}},	//   _qheb_, блес, _nnok, hejë_,
   {{0x26de1f97,0xe8030096,0x8cf4013f,0xd8e702e1}},	//   _apto_, लाला_, _дзяц, рцеп,
   {{0x66022eab,0x1d1600ca,0xb8ff0d7a,0x00000000}},	//   _anok, _הקשר_, _तह_, --,
   {{0x2a7f061d,0x6dbb007f,0x00000000,0x00000000}},	//   _tiub_, ałał, --, --,
   {{0xb8cd00c7,0x3dc90fa0,0x26de334c,0x1c0503b3}},	//   _কম_, ngaw_, _dpto_, रावल_,
   {{0x81d60033,0xe4590c59,0x629a05c2,0x00000000}},	//   _সফল_, лжи_, epto, --,
   {{0x981400bf,0x9b4400fb,0x68fb02a7,0x9f4c0579}},	//   _وبلا, _انہو, _irud, ždé_,
   {{0x68fb0146,0xe7190d59,0x00000000,0x00000000}},	//   _hrud, _حيات_, --, --,
   {{0x68fb334d,0x625d014b,0x00000000,0x00000000}},	//   _krud, déos, --, --,
   {{0x2604334e,0x291d334f,0x850500cd,0xf1bf0094}},	//   वारी_, nywa_, _دوشن, chám_,
   {{0x3cfe00b6,0xc2c8001c,0xe3b80233,0x656b02a1}},	//   _čtv_, دبیل_, lkın_, _izgh,
   {{0x66f91677,0xfbcd0033,0x66f73350,0xd7f100fe}},	//   ्मिक_, রজাত, ंटिक_, _mã_,
   {{0x0d8616a1,0x68fb3351,0xe3b8028e,0x442701cb}},	//   слан, _orud, nkın_, _hln_,
   {{0x61e63352,0x6fb100a3,0x00000000,0x00000000}},	// [2820] mekl, _जयचं, --, --,
   {{0x69db0890,0x44270710,0x61e63353,0x3b0a176e}},	//   _abue, _jln_, lekl, лезо_,
   {{0x44273354,0xfc3f0990,0x6d4f0575,0x25ad3355}},	//   _mln_, _avís_, _exca, kael_,
   {{0x68fb0429,0x80cb00c7,0x61e63356,0xb3460161}},	//   _brud, িবর্, nekl, leçõ,
   {{0x25ad0150,0xddcd2326,0x656f0220,0x7e643357}},	//   dael_, llaş, ýchl, mlip,
   {{0xe4470246,0x69db039f,0x629a1190,0x66021e95}},	//   _رض_, _ebue, ypto, _snok,
   {{0xddcd008e,0x61e601e8,0x26040409,0x00000000}},	//   nlaş, kekl, वाली_, --,
   {{0x61e60dd9,0x7e640bb6,0x291d007f,0x7afc042c}},	//   jekl, nlip, bywa_, _irrt,
   {{0xa9260084,0x61e63358,0x44272058,0x26180113}},	//   _удал, dekl, _bln_, _béor_,
   {{0xddcd01e8,0xb3460131,0xe8240103,0x00000000}},	//   klaş, jeçõ, _بذری, --,
   {{0x5c5b00c1,0x2bf700ca,0x7bdc3359,0x04fa0033}},	//   רדיק, זמין_, _mbru, েনের_,
   {{0xad9b0396,0x2604009d,0x5b7b0341,0xc0cb0284}},	//   _anún, वाळी_, טריא, луге_,
   {{0x661d0853,0x629a2b12,0xdb070216,0x4427335a}},	//   öske, spto, _pejë, _fln_,
   {{0xa2c0142e,0xb9210065,0x70a90179,0x3dc90270}},	//   _विप्, _aisọ_, _कबील, wgaw_,
   {{0x443e335b,0x543b00c1,0x644f0257,0x61e6335c}},	//   mit_, _געגא, écie, bekl,
   {{0x645a335d,0x7bdc335e,0x61e6335f,0x7e642783}},	//   loti, _abru, cekl, glip,
   {{0x7bdc009c,0x973c3360,0x64483361,0x443e27aa}},	// [2830] _bbru, _bećk, ondi, oit_,
   {{0x645a3362,0x64483363,0x7afc0167,0x3dc90124}},	//   noti, nndi, _brrt, sgaw_,
   {{0x64483364,0x68fb0234,0x207c006e,0xdb6b0231}},	//   indi, _srud, _גאזא, урал_,
   {{0x443e3365,0x1df90084,0x7e643366,0xc1b70ff9}},	//   hit_, _темы_, clip, _अयोग,
   {{0x443e3367,0x645a3368,0x65620027,0x7c3e3369}},	//   kit_, koti, _nyoh, bipr,
   {{0x62980954,0x443e336a,0x63aa0102,0x645a336b}},	//   _otvo, jit_, _nefn, joti,
   {{0xa3be0f53,0x443e336c,0x645a336d,0x6562336e}},	//   ेलन_, dit_, doti, _ayoh,
   {{0xe619336f,0x64483370,0x68fb3371,0x6e2d3372}},	//   рди_, endi, _trud, nhab,
   {{0x44270714,0x25ad3373,0x64483374,0x645a0146}},	//   _pln_, rael_, fndi, foti,
   {{0x443e3375,0xddcd1f8a,0x63aa02ad,0xe705001c}},	//   git_, ylaş, _cefn, _وسای,
   {{0x63aa02e0,0x27e73376,0xdb1c00e3,0x6e2d3377}},	//   _defn, menn_, _scrú, khab,
   {{0x69cb1084,0x27e73378,0x60c6117e,0x64480010}},	//   ngge, lenn_, tukm, andi,
   {{0xe3ae3379,0x645a337a,0x61e6337b,0x6e2d337c}},	//   _об_, boti, rekl, dhab,
   {{0x442c337d,0x645a337e,0x61e6337f,0x27e73380}},	//   chd_, coti, sekl, nenn_,
   {{0xa3d20067,0x26c73381,0x61e63382,0xb346016d}},	//   _हॉट_, nuno_, pekl, reçõ,
   {{0x22b500d9,0xddcd0740,0x27e73383,0x76493384}},	//   māk_, rlaş, henn_, nney,
   {{0x22b500d9,0x7e640f22,0x81d30081,0x27e706a3}},	// [2840] lāk_, rlip, _হোক_, kenn_,
   {{0x27e73385,0xebe33386,0xddcd07e7,0x7e643387}},	//   jenn_, моуп, plaş, slip,
   {{0x27e705aa,0x6e2d3388,0xd24f0260,0x22b500d9}},	//   denn_, bhab, _سنی_, nāk_,
   {{0x6e2d3389,0x443e338a,0xe8fa1491,0xddcd002d}},	//   chab, zit_, иле_, rmaţ,
   {{0x6448338b,0x3ead00e9,0x645a338c,0x28f8338d}},	//   yndi, ćete_, yoti, сель_,
   {{0x443e338e,0x27e7009c,0x973c00e7,0x645a338f}},	//   xit_, genn_, _heći, xoti,
   {{0x645a03ce,0xdcf6008e,0x26c73390,0xe5c61ac7}},	//   voti, mayı, guno_, оспо,
   {{0xdcf607d1,0x443e3391,0x22a70103,0x22b500e8}},	//   layı, wit_, dők_, dāk_,
   {{0x443e3392,0x629803ce,0x645a3393,0x27e70383}},	//   tit_, _stvo, toti, benn_,
   {{0x186a0465,0x47c30e38,0xd37808a9,0x64483394}},	//   _тази_, _обув, leći_, undi,
   {{0x443e0bb0,0x2bcf0521,0x1bfb00c1,0x26c71ce2}},	//   rit_, स्टा, בליב, cuno_,
   {{0x443e3395,0x95c70508,0xd37808a9,0xa2c00096}},	//   sit_, _душа_, neći_, _विठ्,
   {{0x443e3396,0xda7b0054,0x51843397,0xdcf603e0}},	//   pit_, ינטר, дура, kayı,
   {{0x7640013f,0x22b500d9,0x443e023b,0xc05b004d}},	//   limy, bāk_, qit_, рім_,
   {{0x69cb1484,0x6e2d3398,0x973c050d,0x539b040a}},	//   ygge, thab, _beći, _דיוו,
   {{0x2bdd09c3,0x27e7022b,0xd378005f,0x6e240270}},	//   न्ना, zenn_, jeći_, gkib,
   {{0xd37802e6,0x6e2d3399,0x26c721c8,0xacf8339a}},	// [2850] deći_, rhab, zuno_, онту_,
   {{0x6e2d339b,0x1c050251,0x26c7339c,0xad9b0161}},	//   shab, राइल_, yuno_, _inúm,
   {{0x2c00007d,0xce590231,0x76490188,0x7640339d}},	//   राजू_, _ганц_, yney, kimy,
   {{0x26c7339e,0x656f0031,0x76400169,0x00000000}},	//   vuno_, ýchk, jimy, --,
   {{0x8cc207e2,0x22b500d9,0x22a70018,0x27e7339f}},	//   _लियो, zāk_, zők_, tenn_,
   {{0xf80733a0,0x26c70150,0xbff20129,0x00000000}},	//   ючен, tuno_, _ọṅụ_, --,
   {{0x27e733a1,0xd3780542,0x2a660eac,0x5ed90033}},	//   renn_, beći_, blob_, ডিকে,
   {{0x060933a2,0x22a70103,0x22b500e8,0x76400027}},	//   сник_, vők_, vāk_, gimy,
   {{0x27e733a3,0x764933a4,0xe4d600e3,0x443c037a}},	//   penn_, rney, كويت_, _bmv_,
   {{0x22a70018,0x26c70fa0,0x870700e3,0x22b501d3}},	//   tők_, puno_, _وبال, tāk_,
   {{0x2bdd0efd,0xfbdd0473,0x625d020d,0x28f800d3}},	//   न्या, न्यम, téop, _леӂь_,
   {{0x22b50b4b,0x2c6d18ed,0x26f90b89,0xe803045f}},	//   rāk_, _vždy_, ्मीर_, लाका_,
   {{0x48fe06ec,0x22b501d3,0xdcf60342,0x00000000}},	//   लियो_, sāk_, yayı, --,
   {{0xd3780ca7,0xd8480134,0xb4fa0327,0x9f4c1e15}},	//   zeći_, họn_, _לפני, ždí_,
   {{0x644133a5,0x973c0335,0x0e6a00e3,0xf1d402d5}},	//   mili, _peći, مصري_, _थापन,
   {{0xe1ff0fb6,0xa2c00abe,0x798933a6,0x41c602d5}},	//   llón_, _वित्, _ngew, _वाटस,
   {{0x973c02e6,0x52db10e9,0x6e2433a7,0xd37808a9}},	// [2860] _veći, _बहुस, rkib, veći_,
   {{0x6e2433a8,0x7989010a,0xddcd0b14,0x61f633a9}},	//   skib, _agew, rmaš, _hayl,
   {{0x61f633aa,0xd378005f,0xbcfb0103,0xdcf60511}},	//   _kayl, teći_, _szét, rayı,
   {{0x98a033ab,0x2242004d,0x61f6041c,0xddc400c4}},	//   šič_, nikk_, _jayl, lmiž,
   {{0x644133ac,0x201a1584,0xd37804a3,0x61f633ad}},	//   kili, _kopi_, reći_, _mayl,
   {{0xd37808a9,0x64410051,0x442533ae,0xb05b01bf}},	//   seći_, jili, jkl_, hrän,
   {{0x644133af,0xd3780995,0x442500dc,0x443c33b0}},	//   dili, peći_, dkl_, _rmv_,
   {{0xa3d91b79,0x61f633b1,0x644133b2,0xf7720103}},	//   ड्स_, _nayl, eili, واں_,
   {{0x644133b3,0xbcfb33b4,0x764033b5,0x786d0031}},	//   fili, _nyél, rimy, súva,
   {{0x682f09af,0x3a260abf,0x3949002b,0x764033b6}},	//   _rødg, lkop_, úase_, simy,
   {{0x644f04ea,0x61f633b7,0x46a30581,0xe7b30103}},	//   écia, _bayl, _захв, _سمند,
   {{0xb05b0222,0x7ae101bf,0x3a2605c2,0x22420120}},	//   grän, _älte, nkop_, gikk_,
   {{0x21672a6a,0x2baf00a5,0xe1ff33b8,0x682f0b81}},	//   ятог, टरमा, blón_, _fødd,
   {{0x201a00f0,0xe1ff0328,0x80df0033,0xbddb0113}},	//   _copi_, clón_, মিল্, _njèr,
   {{0x629c0618,0xf1c6009d,0x61f61321,0xb05b33b9}},	//   írod, _वाचन, _fayl, brän,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x3209025e,0xbcfb0068,0x91bc00a1,0xc1bc00a1}},	// [2870] _inay_, _azér, _המחי, _המחש,
   {{0x682f02b6,0x320900fe,0x62860231,0x201a0178}},	//   _køde, _hnay_, _éhor, _gopi_,
   {{0x682f13c8,0x998900b6,0x61f6020e,0x3a2602ac}},	//   _jøde, íkům_, _yayl, fkop_,
   {{0x682f01c5,0x3a260bb6,0x644133ba,0x78a9022b}},	//   _møde, gkop_, zili, _pwev,
   {{0xa3be0553,0xbcfb0018,0xd37800cc,0x644133bb}},	//   ेला_, _ezér, meću_, yili,
   {{0xd378031a,0x66e52bcf,0x00000000,0x00000000}},	//   leću_, дока, --, --,
   {{0xe81e17ff,0x3209026a,0x64410fda,0x682f0170}},	//   _बकरा_, _onay_, vili, _rødd,
   {{0x644102e0,0xc7440080,0xdb07030b,0x63a400e7}},	//   wili, عضوي, _její, _đina,
   {{0x3d000b95,0x280800b6,0x61f607e7,0xdb072df7}},	//   रिये_, átní_, _rayl, _mejí,
   {{0x61f633bc,0x320933bd,0xe7b512eb,0x66190167}},	//   _sayl, _anay_, _آماد, _wowk,
   {{0x61f60702,0xb05b1680,0x1b1f0081,0x224202ec}},	//   _payl, trän, _যেতে_, tikk_,
   {{0x644133be,0x2bdd0d7a,0xd3782392,0xdb0e0161}},	//   sili, न्ता, jeću_, _bebê,
   {{0x644133bf,0xd37801ac,0x2242004d,0xb05b09df}},	//   pili, deću_, rikk_, rrän,
   {{0x682f0c08,0x224200d6,0xdee600c2,0x23290236}},	//   _føde, sikk_, моги, _моли_,
   {{0x682f0537,0x00000000,0x00000000,0x00000000}},	//   _kødb, --, --, --,
   {{0x7bc301cd,0x9f4300d2,0x00000000,0x00000000}},	//   ónun, cejí_, --, --,
   {{0x224033c0,0x201a33c1,0xac8633c2,0xdb0e0f5a}},	// [2880] _imik_, _topi_, дгал, _gebê,
   {{0xf1bf33c3,0x25dd1c3b,0x3a2d33c4,0x93bc020a}},	//   nkán_, क्ती_, _alep_, lhăr,
   {{0x2bdd030b,0x63bc0ce1,0x3e4800ae,0x5f46001c}},	//   न्धा, órni, eşte_, _آنجل,
   {{0xfaf800d9,0x1d0a1e11,0xb9e30120,0x00000000}},	//   _šīs_, _деми_, віши, --,
   {{0x2bc733c5,0x249d023e,0x089733c6,0x3a2633c7}},	//   _लाचा, _ntwm_, وضوع_, rkop_,
   {{0x0ee2099d,0x2bdd2010,0x68ed0161,0x9f4302c6}},	//   _पहाड, न्दा, çada, zejí_,
   {{0xdb8300d3,0x7c2e0036,0x3a2633c8,0xe803023a}},	//   _агри, _ilbr, pkop_, लाजा_,
   {{0x26c033c9,0x2487003b,0x44f433ca,0xe5c617ab}},	//   čio_, _ainm_, епис, фско,
   {{0x83fc053f,0x25af0036,0x682f0430,0x25bd030a}},	//   hođe, _degl_, _søde, _ddwl_,
   {{0x83fc0292,0xd3780335,0x224033cb,0x00000000}},	//   kođe, zeću_, _amik_, --,
   {{0xd6cf006f,0x9726001c,0x78a20234,0x00000000}},	//   _نقل_, _تفاو, lpov, --,
   {{0xc7b802e6,0x64a6013f,0xd25131bb,0x7afa003e}},	//   _dođe_, _жада, انح_, _áttu,
   {{0xd8480294,0xe8030096,0x7c2e33cc,0xd3780995}},	//   họm_, लाचा_, _olbr, veću_,
   {{0x656f01bf,0xd8480134,0x9f4302c6,0x00000000}},	//   üche, kọm_, sejí_, --,
   {{0x5f94133b,0x83fc00e9,0x442e01ff,0xd378007e}},	//   тист, gođe, _ilf_, teću_,
   {{0x41e7116d,0x32090124,0x5c990109,0xddc4007f}},	//   _ціка, _unay_, зкая_, enił,
   {{0x5c750084,0x78a22c0a,0xd37808a9,0x7bde33cd}},	// [2890] елат, jpov, reću_, ffpu,
   {{0x78a20074,0x83fc04a3,0x9f4c025b,0x6f030072}},	//   dpov, bođe, ždá_, _ánco,
   {{0xb5fd03d6,0x00000000,0x00000000,0x00000000}},	//   loše, --, --, --,
   {{0xdb1c24c7,0xd37b006e,0x8c490233,0x2cc4020e}},	//   _acró, קראט, _başö, ürdü_,
   {{0x5d8533ce,0xb5fd00cb,0x682f0170,0x00000000}},	//   _سلسل, noše, _rødb, --,
   {{0xd8480174,0x2c050034,0x46f5004d,0xb05b007b}},	//   bọm_, राओं_, ечит, ttäy,
   {{0xa2c0077d,0xf4140033,0x661d1b80,0x7b64007b}},	//   _विष्, িসার_, ösko, _атте,
   {{0x442e2452,0x248f0063,0xb5fd33cf,0x3a3f03a9}},	//   _alf_, _pugm_, koše, _umup_,
   {{0xb5fd0307,0x26040f42,0xdb1c06a3,0xf992006e}},	//   joše, वाजी_, _adrè, _תרמ_,
   {{0xa2c00851,0x7af50034,0xb5fd2281,0x25a2026a}},	//   _विश्, _kszt, doše, ıkla_,
   {{0x25af0ac9,0x3169173c,0x43740120,0x00000000}},	//   _tegl_, _ayaz_, куют, --,
   {{0x83fc03ce,0xc7b80ca7,0x349507c8,0xdb0e0154}},	//   vođe, _vođe_, _задр, _debè,
   {{0x660b172a,0x65940291,0xb5fd0095,0x2bff00c3}},	//   _ingk, _рачу, goše, ईयां_,
   {{0x26c7013d,0x7af50018,0x95cc0092,0x3169022b}},	//   orno_, _oszt, _çərç, _dyaz_,
   {{0xdee333d0,0xbcfb0018,0x2604009d,0xe29a00de}},	//   лори, _szép, वाची_, _trưa_,
   {{0x2612099d,0x83fc005f,0x9f5833d1,0xd7df00aa}},	//   थायी_, rođe, ndré_, प्तच,
   {{0x61e433d2,0x660b02e7,0x7af50018,0xed572b85}},	// [28a0] _ibil, _mngk, _aszt, еот_,
   {{0x799b0d2a,0xa7fc0233,0xc5eb0033,0x3ec5020e}},	//   _afuw, _akın, কাটা_, üstü_,
   {{0x4fd707a6,0x7fd70130,0xe7c9034c,0x660b1f12}},	//   _אויב_, _אויס_, _राजप, _ongk,
   {{0x6ad00034,0x660b0113,0xd7d20285,0x78a200c4}},	//   _हमीर, _nngk, _साहच, tpov,
   {{0x61e433d3,0x67d433d4,0x2bdd33d5,0x7af50103}},	//   _mbil, волу, न्हा, _eszt,
   {{0x660b159d,0x25dd1c0a,0x7c2e00e8,0xa2c03162}},	//   _angk, क्सी_, _ulbr, _विल्,
   {{0x61e403ce,0x78a20ca7,0x799b010a,0x6b8e0139}},	//   _obil, spov, _ffuw, _igbg,
   {{0x78a200c4,0x7d090072,0xdb0e05aa,0x442e32a7}},	//   ppov, _áesc, _rebè, _slf_,
   {{0x545433d6,0x69c00090,0x00000000,0x00000000}},	//   квит, _idme, --, --,
   {{0x660b14f7,0xccf300a1,0x26c733d7,0x88bb00ca}},	//   _engk, רכז_, brno_, _מזמי,
   {{0x6fd7007a,0xdb0e2218,0x61e400bd,0x31690063}},	//   _बाबू, _bebé, _bbil, _syaz_,
   {{0x5ab707a6,0x290405db,0x00000000,0x00000000}},	//   עלכע_, _krma_, --, --,
   {{0x442e1484,0x64a307bf,0xdb0e0328,0x76420065}},	//   _tlf_, _бача, _debé, _imoy,
   {{0x61e433d8,0xb5fd0660,0xdb070103,0x442e0572}},	//   _ebil, roše, _lejá, _ulf_,
   {{0xa3d933d9,0x69c033da,0xb5fd33db,0xc0ab1ac9}},	//   _डॉट_, _odme, soše, _کابل_,
   {{0xdb0e03a9,0x28d133dc,0x61e40032,0x00000000}},	//   _gebé, _समलि, _gbil, --,
   {{0x8bc7121c,0xf1bf045e,0xb05b02c3,0xb5fd00c4}},	// [28b0] есед, nkám_, nräk, lošc,
   {{0x69c033dd,0x61e433de,0x61fd33df,0xf1bf0031}},	//   _adme, _zbil, ldsl, chár_,
   {{0xdb070103,0x8f3500ae,0xb5fd0357,0x76420372}},	//   _bejá, _ренц, nošc, _omoy,
   {{0x61fd25be,0x61ef33e0,0xaca30174,0x68ed33e1}},	//   ndsl, necl, _amục, çado,
   {{0xd36600bf,0x7e6d33e2,0xfd660294,0xdb070487}},	//   _چه_, mlap, _mkpị, _dejá,
   {{0xd36600bf,0x7e6d33e3,0x764233e4,0x7bd50034}},	//   _نه_, llap, _amoy, _uczu,
   {{0x8f9c00c1,0x6c5403a0,0x316c007f,0x644f020d}},	//   ליגי, _скру, ędzi_, écim,
   {{0x24991f84,0x59d802d5,0x7e6d0018,0x60dd33e5}},	//   ísmo_, _डायर, nlap, ktsm,
   {{0x9f4a05fe,0x25dd022d,0x91a20179,0x78bb0239}},	//   rebé_, क्षी_, _क्षै, _uvuv,
   {{0x61e4028d,0x7642019f,0x7e6d33e6,0xe3b10076}},	//   _sbil, _emoy, hlap, جرة_,
   {{0x6fdf0789,0xe6c700e3,0x26dc035d,0x13a733e7}},	//   _पॉइं, _ستاي, ctvo_, ونکی_,
   {{0x660b10dd,0xa69600f5,0x60dd33e8,0x61e40090}},	//   _ungk, _סכנה_, ftsm, _qbil,
   {{0x463a0130,0x628e33e9,0x7e6d33ea,0x54e500c3}},	//   _קענע, íbor, dlap, _कहिए_,
   {{0x6a782b39,0x25dd1fb4,0xb5fd00e7,0xa0a31d57}},	//   mífe, क्री_, bošc, рард,
   {{0x998f013f,0x61e433eb,0x644333ec,0x60dd05c9}},	//   nigų_, _tbil, _imni, atsm,
   {{0x61e4042d,0x7e6d12ff,0xe8d10378,0xa7fc026a}},	//   _ubil, glap, _समूच, _akıl,
   {{0x0d8612d1,0x6a781f72,0x3e5a02c6,0xc7b80218}},	// [28c0] тлан, nífe, jďte_, _lođa_,
   {{0xe0b70c6a,0x9f5a0052,0x29fe0134,0xfce32b79}},	//   _שליט_, _japë_, _ịa_, рофо,
   {{0xe9da2c37,0x3daa007b,0xcb0a0037,0x6fd700a3}},	//   дке_, _окно_, بيان_, _बातू,
   {{0x98a61d3f,0x831a00c1,0xceb80138,0xbcfb0113}},	//   виде, וועז, šęs_, _nyéw,
   {{0x83fc00e7,0xb17b09af,0x00000000,0x00000000}},	//   hođa, leår, --, --,
   {{0xf1bf0094,0x6b9c0131,0x913b021e,0x69b400a4}},	//   vkám_, _ufrg, וענק, _उजवी,
   {{0x8c4333ed,0xddcd00d3,0x27ee00f0,0xcf9300ca}},	//   _тере, noaş, refn_, סטה_,
   {{0x644333ee,0x35f4192f,0xf1bf0094,0xceb30327}},	//   _amni, упир, tkám_, ביה_,
   {{0x29040012,0x61ef02e5,0xd9100260,0xba5500e5}},	//   _urma_, vecl, _دیش_, _стръ,
   {{0x1e1f33c5,0xa84a04c6,0x7e6d33ef,0xf1bf00d4}},	//   _यक्ष_, _غلام_, zlap, rkám_,
   {{0x83fc0106,0x1db21b11,0x0bb70327,0xf1bf0437}},	//   gođa, जरात, כלים_, skám_,
   {{0x27e904eb,0x76420060,0x644333f0,0x60dd05e8}},	//   đane_, _umoy, _emni, ttsm,
   {{0x61fd33f1,0x6a780072,0x041e0033,0xdb050076}},	//   rdsl, cífe, যোগী_, rbhé,
   {{0xdb05003e,0x69b40789,0x61ef33f2,0xb5fd00e8}},	//   rahú, आरडी, secl, moša,
   {{0x442c33f3,0x69d300aa,0xf487001c,0x7e6d0103}},	//   mkd_, _डाली, _شاهی, tlap,
   {{0x2d8f052f,0x64430034,0xfda40284,0x00000000}},	//   øge_, _zmni, ијум, --,
   {{0x23b6000f,0x3d0d00a5,0xb5fd00d9,0xd7d200aa}},	// [28d0] _आजाद, समें_, noša, _सांच,
   {{0x7e6d33f4,0x00000000,0x00000000,0x00000000}},	//   slap, --, --, --,
   {{0x68e9013d,0xe0df028d,0x613801f9,0x7e6d33f5}},	//   _sped, ltò_, _túlé, plap,
   {{0x644833f6,0x6e36025b,0xe1ff33f7,0x628d33f8}},	//   hidi, chyb, ndó_, _jiao,
   {{0x6e2d33f9,0xe0df33fa,0xb5fd01d3,0x89a8004d}},	//   mkab, ntò_, joša, тків_,
   {{0xb5fd00d9,0x628d03e3,0x6e2d33fb,0x00000000}},	//   doša, _liao, lkab, --,
   {{0x644833fc,0x81cb0081,0x366933fd,0x81b90081}},	//   didi, র্য_, нако_, _চান_,
   {{0x83fc02e6,0xc7b80039,0x6a7833fe,0x64430063}},	//   vođa, _vođa_, tífe, _smni,
   {{0x9f4300c2,0x629c03be,0xb5fd00e8,0x6e2d1f9e}},	//   lejä_, íron, goša, ikab,
   {{0x644833ff,0xe576004b,0x628d009c,0x81cb0033}},	//   gidi, ызы_, _aiao, র্ম_,
   {{0x6e2d3400,0x05130033,0x8458008f,0x7e640a4b}},	//   kkab, িনের_, ърът_, yoip,
   {{0x83fc01ac,0x628d3401,0x82361ac9,0xddc43402}},	//   rođa, _ciao, اردا, kliš,
   {{0x64483403,0x7d0908a9,0x628d2a7b,0x656b0063}},	//   bidi, _šesn, _diao, _uygh,
   {{0xddc4030b,0x9f430084,0x6443019f,0x661b3404}},	//   dliš, kejä_, _umni, ljuk,
   {{0x75290018,0xd5b706ed,0x3ebe0088,0xb7b50134}},	//   lyez, _इजाज, étt_, _nọm,
   {{0x661b06ee,0x6e2d20c1,0x81cb0081,0x764900f9}},	//   njuk, gkab, র্ব_, niey,
   {{0x75293405,0x753b3406,0xec7a2cf1,0xdcff00a7}},	// [28e0] nyez, nzuz, епа_, faqı,
   {{0x661b13e1,0xbc6a1790,0x1c0e11bb,0x00000000}},	//   hjuk, رمان_, साइल_, --,
   {{0x6e462383,0x49ca3407,0xae1c00a3,0x8cd5023a}},	//   _бенз, елен_, _पचपन_, यूबो,
   {{0x64483408,0xb05b0212,0x9f5a05aa,0xb4f80285}},	//   zidi, tsäg, _rapè_, ्टमय_,
   {{0x28f80bb9,0xad9b0181,0x64483409,0x627c0034}},	//   тель_, _vnút, yidi, _głoś,
   {{0x7d04340a,0xb5fd00d9,0xb8dc007a,0x00000000}},	//   mvis, voša, _आब_, --,
   {{0xa3d707d5,0xddc401d3,0x627c007f,0xfaa30da5}},	//   िलन_, rniņ, _złoś, _гасо,
   {{0xb5fd0029,0xceb300a1,0x644802ad,0x7d0400bc}},	//   toša, זיה_, widi, ovis,
   {{0x81cb00c7,0x7d040501,0x3ce0340b,0x049e0174}},	//   র্ড_, nvis, ntiv_, _bọọd_,
   {{0xb5fd00d9,0x2a6600a6,0xbddb00b3,0x5c37006e}},	//   roša, loob_, _amèl, ָרטן_,
   {{0xd7930080,0xddc4035c,0x7d040084,0xb5fd0106}},	//   _المخ, zliš, hvis, mošn,
   {{0xb5fd340c,0x6448340d,0x2a6604de,0x66760018}},	//   lošn, sidi, noob_, _صدار,
   {{0xa2c00efd,0x6448340e,0xe1ff340f,0xc5f300a1}},	//   _विक्, pidi, rdó_, _לדף_,
   {{0xe0df0451,0x2a66006c,0xb5fd00e7,0x682f0430}},	//   rtò_, hoob_, nošn, _nødl,
   {{0xd9040434,0xf8d13410,0xe0df3411,0x9f34004d}},	//   _کی_, _सम्प, stò_, бері,
   {{0xddc40095,0x3ceb00b3,0x7d043412,0x00000000}},	//   tliš, _ppcv_, fvis, --,
   {{0xdb0e04d8,0xbcfb01dc,0x62950e43,0x661d007b}},	// [28f0] _debí, _nyét, ízov, öski,
   {{0xad9b0ba0,0x6e2d01c5,0x224b3413,0x63ba3414}},	//   _saúd, skab, lick_, natn,
   {{0x81cb0081,0x7d043415,0x09bc0081,0xbcfb0af0}},	//   র্ণ_, avis, _ইউজা, _ayét,
   {{0x98a92461,0xdb070149,0x63ba3416,0x7d04037a}},	//   šač_, _rejä, hatn, bvis,
   {{0x212b3417,0x3ce000d3,0x61ff3418,0x30840470}},	//   nych_, ctiv_, _maql, _خلیف,
   {{0x63ba084f,0x2ca900cd,0xfbcc0081,0xb5fd00e7}},	//   jatn, mpad_, র্বত, gošn,
   {{0x2ca93419,0x75d5001c,0xc7c400c2,0x224b341a}},	//   lpad_, ليغا, ссчи, kick_,
   {{0x0609185c,0x212b0181,0x248e02a1,0x81cb0033}},	//   тник_, kych_, _aifm_, র্ত_,
   {{0x680b0029,0x63ba341b,0xe61610e0,0xb5fd02ef}},	//   _pēdē, fatn, рды_, bošn,
   {{0x212b341c,0x13090084,0x661b0160,0x63ba341d}},	//   dych_, вной_, sjuk, gatn,
   {{0x35f514fa,0x75290154,0x9f4c0220,0xb05b042c}},	//   _впер, syez, ždú_, nräu,
   {{0x61ff0188,0x224b341e,0x7d04341f,0x255e0129}},	//   _caql, gick_, yvis, ịla_,
   {{0xd176065c,0x63ba005a,0xae0005a7,0x25ad3420}},	//   рыны, batn, _लोगन_, mbel_,
   {{0x7d040f2f,0x98a002e6,0x645d3421,0x63ba3422}},	//   vvis, šić_, ésid, catn,
   {{0xc44700fb,0x6fd70557,0xdfcf00e3,0x71a63423}},	//   _لیکن_, _बारू, ظيف_, _кайз,
   {{0x7d043424,0x3ce003e5,0x3126008f,0xfbb20033}},	//   tvis, ttiv_, _вдиг, _চাইত,
   {{0x212b0067,0x1c46013f,0x68fb0172,0x6834009c}},	// [2900] cych_, анам, _nsud, _làda,
   {{0x629e132d,0x69db14e2,0x3ce03425,0xda0b0096}},	//   _époc, _acue, rtiv_, _सोबत_,
   {{0x68fb3426,0x7d040dd8,0x3ce03427,0x25ad3428}},	//   _asud, svis, stiv_, kbel_,
   {{0x09e63429,0x09061994,0x7d04342a,0x25ad01c0}},	//   родн, ипен, pvis, jbel_,
   {{0x63ba063f,0xb5fd342b,0x9f5805fe,0xaca40174}},	//   yatn, tošn, ldrà_, _mmịr,
   {{0xd90d0260,0x69db0143,0x25ad342c,0xb05b042c}},	//   عیل_, _ecue, ebel_, bräu,
   {{0x63ba00e9,0x212b00a5,0x9f580472,0x27fe0c09}},	//   vatn, zych_, ndrà_, _vatn_,
   {{0x27e903ce,0x2c0a02e8,0x63ba0808,0xddcd14f3}},	//   đana_, _होतं_, watn, zmaž,
   {{0x63ba12fb,0x15e2009d,0x27e00044,0x3d0900c3}},	//   tatn, क्षर_, ƙin_, सिये_,
   {{0x61ff342d,0xaca40134,0x3cf90cce,0x212b0146}},	//   _saql, _amịr, _उनसे_, vych_,
   {{0x212b0d1b,0x25ad342e,0x14c200a4,0x9f510216}},	//   wych_, bbel_, _शिकण, rezë_,
   {{0x2ca9342f,0x212b3430,0x05863431,0xdb15022b}},	//   ypad_, tych_, _кулм, _dezè,
   {{0x224b3432,0x63ba3433,0xd8480174,0x925800e5}},	//   rick_, patn, bọt_, раят_,
   {{0x212b3434,0x63ba02a1,0xf1a7049d,0x104b1b60}},	//   rych_, qatn, _क्रन, тями_,
   {{0xc05802ec,0xe29700c9,0x645d3435,0x61ff3436}},	//   рія_, _кај_, ésie, _taql,
   {{0x2ca93437,0xdda800d3,0x5baf0285,0x682f00f2}},	//   tpad_, итул_, टर्व, _rødm,
   {{0xdb050080,0xb5fd3438,0x63b8023e,0xbcfb0139}},	// [2910] rbhí, došl, _kevn, _ayér,
   {{0x62983439,0x0ba70f6b,0x63b8004d,0x2ca9343a}},	//   _kuvo, ршам, _jevn, rpad_,
   {{0xb9950037,0xdb150103,0xddc4007f,0x68e209a1}},	//   ملاب, _kezé, nniś, etod,
   {{0x6298343b,0x63b8030b,0x2ca90212,0x3a240d63}},	//   _muvo, _levn, ppad_, _comp_,
   {{0x2001343c,0xe1ff343d,0xa3b60592,0xb05b042c}},	//   _kahi_, llós_, जरा_, sräu,
   {{0x63b800d6,0x81dd0081,0x9f580487,0x2003343e}},	//   _nevn, ড়ি_, ldrá_, ndji_,
   {{0x26c1272c,0x6298343f,0xad9b0161,0x7afc0063}},	//   ého_, _nuvo, _gaúc, _gsrt,
   {{0xa2c0218b,0x20013440,0x9f5809b3,0x26c91419}},	//   _विज्, _lahi_, ndrá_, čao_,
   {{0x81dd00c7,0x25ad3441,0x68fb0559,0x2ba400b6}},	//   ড়া_, rbel_, _usud, खुवा,
   {{0xc6e70a8d,0x200103f3,0x62980138,0x22490634}},	//   _відп, _nahi_, _buvo, _amak_,
   {{0x2a7f022e,0xd6db0831,0xe36500a9,0x9f5a0036}},	//   _khub_, _шта_, скни, _capì_,
   {{0x69d93442,0xf59500e3,0x81cb0081,0xb21b02b6}},	//   ngwe, _الإج, র্স_, smæn,
   {{0x20013443,0x66ea00a7,0xdb1500d4,0x5fdc0386}},	//   _bahi_, _təkc, _dezé, _बादल,
   {{0x8fa30a99,0x22493444,0xa879006e,0xb21b01cd}},	//   заре, _emak_, טאָר, lmæl,
   {{0x9e5a3445,0xdb1c0146,0x20010847,0xb05b0212}},	//   граф_, _odrá, _dahi_, vrät,
   {{0x2a7f023e,0xb05b3341,0x7bc73446,0xdb0e00d4}},	//   _nhub_, tsäc, _adju, _nebá,
   {{0x629801bf,0x3a243447,0x66ea00a7,0xb05b02c3}},	// [2920] _zuvo, _romp_, _məka, trät,
   {{0xd37e1197,0xddcd007f,0x60c4063d,0x69d90381}},	//   šćem_, gnał, _ivim, egwe,
   {{0xb05b3448,0x5f062787,0x3a243449,0x9f5a0154}},	//   rrät, _узна, _pomp_, _enpò_,
   {{0xb05b0149,0xb7b50174,0x9acb0103,0x69d90361}},	//   srät, _kọw, ادلہ_, ggwe,
   {{0xa3d70efd,0xb05b0212,0xc7b8007e,0xe918018a}},	//   िला_, prät, _peđ_, ролі_,
   {{0x6c3609b4,0xd6da344a,0xc5e50033,0x3bd500d3}},	//   _افسا, гти_, _খোলা_, _мюсс,
   {{0xb5fd03ce,0x68e2344b,0x63b8344c,0x3d000d75}},	//   pošl, stod, _revn, रिके_,
   {{0xb8ce0f71,0x60c40559,0x63b81c54,0xf1bf0103}},	//   _কি_, _ovim, _sevn, nkát_,
   {{0x63b818ed,0x62980fb0,0xdb050555,0x00000000}},	//   _pevn, _suvo, zahü, --,
   {{0x96ba344d,0x2249344e,0x682f00f2,0x9f580206}},	//   _буду_, _smak_, _nødh, zdrá_,
   {{0xe69600e3,0x88810421,0xd5af344f,0xd8480134}},	//   _الصد, _تیون, _нс_, sọs_,
   {{0xe7170054,0x80dd00c7,0x3cf9000d,0xddcd007f}},	//   _לחבר_, যবস্, _उनले_, znał,
   {{0xdb150103,0x914b24ec,0x645d0145,0x85760103}},	//   _vezé, учна_, ésic, _ادائ,
   {{0xf1db00ec,0x25de1117,0xdb1c052f,0x234800cd}},	//   _भावन, _गाडी_, _idræ, _پستی_,
   {{0x02a20134,0x81cb0033,0x80ce0096,0x9f34004d}},	//   _klọọ, র্ষ_, _तिथे, пері,
   {{0x6602007a,0x2001024a,0x22491912,0x6a7800e1}},	//   _jaok, _wahi_, _umak_, dífo,
   {{0x61ed3450,0x20013451,0x6e260113,0xd7c80096}},	// [2930] _ibal, _tahi_, _dokb, रणाच,
   {{0x44e20088,0xb6062461,0x81cb0081,0x00000000}},	//   ið_, lašć, র্শ_, --,
   {{0x2a7f036b,0xaab5004d,0x00000000,0x00000000}},	//   _phub_, ійді, --, --,
   {{0x2a7f01fa,0x66023452,0x998d3453,0x27ec3454}},	//   _qhub_, _naok, _aleš_, _abdn_,
   {{0x61ed3455,0x4ac5007d,0x7bc30102,0x998d05db}},	//   _mbal, _लटकव, ónus, _bleš_,
   {{0x16a93456,0xbcfb0257,0x23d402d5,0x7bc703a9}},	//   авки_, _exéc, _दागद, _udju,
   {{0xe7390a29,0x46393457,0x02a20294,0xb21b003e}},	//   рей_, ичия_, _blọọ, tmæl,
   {{0xe7f500a5,0x25de009d,0x79e70018,0xb5fd0f1c}},	//   _इसका_, _गाणी_, _دورہ_, mošk,
   {{0x998d0d12,0xd83805aa,0x8459001f,0xb21b2b4c}},	//   _fleš_, _flč_, ирот_, rmæl,
   {{0x61ed3458,0x72c500d3,0x81b90033,0xb21b3459}},	//   _abal, обоз, _চাষ_, smæl,
   {{0x60c402e6,0xfbd2040a,0x61ed083e,0x7c27007e}},	//   _svim, ותי_, _bbal, _mojr,
   {{0x7c27023b,0x02a20174,0xe5ef00c2,0x7b20031a}},	//   _lojr, _glọọ, äkää, _ušuš,
   {{0x644f025a,0xe44e345a,0x25de02d5,0x6286345b}},	//   écis, _жж_, _गाती_, rmko,
   {{0xb5fd038d,0x61ed345c,0xdfd20037,0x16170096}},	//   košk, _ebal, بيس_, थावर_,
   {{0xb5fd04a3,0x81b90081,0xa3a9142e,0x44272ab4}},	//   jošk, _চার_, गुण_, _ion_,
   {{0x4427345d,0x78a9030b,0x6d0502d5,0xee37345e}},	//   _hon_, _otev, रिंग_, онс_,
   {{0x4427345f,0x0c263460,0xec4a0084,0x9c260476}},	// [2940] _kon_, оман, азал_, одад,
   {{0x69c90694,0x44273461,0x61ed3462,0xb05b02c3}},	//   _adee, _jon_, _zbal, lsän,
   {{0x442710af,0x290d3463,0x6286028d,0x7c27007f}},	//   _mon_, _area_, _èhos, _dojr,
   {{0x290d3464,0x44270019,0x38c8010d,0x8f7b00ca}},	//   _brea_, _lon_, ماتی_, _כניק,
   {{0xa88a0077,0x290d2af2,0x44270878,0x7761016d}},	//   айда_, _crea_, _oon_, _axlx,
   {{0x44273465,0xb8f20c38,0x764b02ad,0xf1bf2e92}},	//   _non_, _वि_, _amgy, nkár_,
   {{0xab2a0020,0xb5fd00e7,0xd6d00037,0xd838080e}},	//   _това_, cošk, رقة_, _vlč_,
   {{0x44270fab,0x25bf3466,0x290d0072,0xcf9300ca}},	//   _aon_, gaul_, _frea_, וטו_,
   {{0x44273467,0xe4e602ec,0x25eb05a7,0x290d00ae}},	//   _bon_, ційн, _अउरी_, _grea_,
   {{0x44273468,0x44e20102,0x61ed3469,0x66020a4b}},	//   _con_, rð_, _sbal, _waok,
   {{0x2be2244d,0x44270054,0xd25100bf,0xe7f717ff}},	//   _पाना, _don_, فند_, ंजरा_,
   {{0x9258007b,0x9f451405,0xe80200b6,0x00000000}},	//   жают_, ýlí_, लयका_, --,
   {{0x4427346a,0xc21800d6,0x8556001c,0xb60600cc}},	//   _fon_, ією_, _بخاط, rašć,
   {{0x4427346b,0x9f4c0618,0xdb1e016d,0xddcd007f}},	//   _gon_, ždý_, rapê, znań,
   {{0x764b02ad,0x6235338d,0x61310af0,0x645a01c2}},	//   _ymgy, _неку, _bólú, mnti,
   {{0x4427346c,0x61ed346d,0xc7b800cb,0x443e0124}},	//   _zon_, _ubal, _dođi_, lht_,
   {{0x4427346e,0x2d8f02d6,0xe04b00cd,0x645a346f}},	// [2950] _yon_, äge_, _نشده_, onti,
   {{0xfbab004b,0x645a3470,0xae140179,0x683400b3}},	//   ртай_, nnti, डाउन_, _bàdm,
   {{0xc7b8007e,0x61310065,0x443e042c,0xdb1e00b3}},	//   _gođi_, _fólú, iht_, napè,
   {{0xb5fd0b27,0x290d002d,0xf9c702ec,0x7b64008f}},	//   rošk, _prea_, іщен, фтуе,
   {{0x8d873471,0xf9902b38,0x25bf00e7,0x00000000}},	//   _фунд, نبه_, vaul_, --,
   {{0x290d002d,0x2be20096,0xb5fd3472,0x09340037}},	//   _vrea_, _पाया, pošk, برمج,
   {{0x443e3473,0x7ac41141,0x2b57001c,0x44273474}},	//   dht_, _осте, _بیاد_, _ron_,
   {{0x44270632,0x682f1484,0x443e01bf,0x645a3475}},	//   _son_, _nødv, eht_, enti,
   {{0x25bf3476,0xb5fd00e8,0x60c904e9,0x3d0e00b7}},	//   raul_, noši, šemj, ठिये_,
   {{0x443e004f,0x44271175,0x9f5a0139,0x00000000}},	//   ght_, _qon_, _lapá_, --,
   {{0x44273477,0xa82200cd,0xdb0e01bf,0x25bf3478}},	//   _von_, _سکون, _gebä, paul_,
   {{0x645a3479,0xfc3f266d,0xc04900a1,0x4427347a}},	//   anti, _stíl_, _גז_, _won_,
   {{0x4427347b,0x443e0527,0x645a01fa,0xb5fd347c}},	//   _ton_, bht_, bnti, joši,
   {{0x443e347d,0x9f5a00e5,0xb05b347e,0x32040031}},	//   cht_, _papà_, ssän, žmy_,
   {{0xe7ed13b4,0x25bd00f9,0xfbd20018,0xdb1e0216}},	//   च्या_, _kewl_, ہتا_, rapë,
   {{0x9f4b0103,0xc7b8031a,0x00000000,0x00000000}},	//   áját_, _vođi_, --, --,
   {{0x629c0094,0xdb1c20df,0x6284009c,0xb5fd347f}},	// [2960] írov, _gerê, _ihio, goši,
   {{0x62960875,0xc8620294,0x628401b9,0x9f580216}},	//   _hiyo, kọọd, _hhio, nerë_,
   {{0xeb971c00,0x62963480,0x4f9b00ca,0xef1700d3}},	//   чих_, _kiyo, _לביצ, _емэ_,
   {{0x62960dc2,0xdb1c023b,0x9f580052,0x628702c6}},	//   _jiyo, _herë, herë_, ňkov,
   {{0x645a3481,0x62963482,0x62840091,0x6e240239}},	//   ynti, _miyo, _mhio, mjib,
   {{0x186710e8,0x9f580052,0x6296019f,0x6d440350}},	//   пачи_, jerë_, _liyo, mzia,
   {{0x81d400c7,0x8f9b0341,0xf1be030b,0xe3c30081}},	//   স্য_, זיצי, ्णान, ্ভাব,
   {{0x62963483,0x645a32dd,0x6e360138,0xaad108c0}},	//   _niyo, wnti, nkyb, _हितक,
   {{0x6d440465,0x682f181f,0xa4f8015a,0xa3d700a4}},	//   nzia, _rødv, تکار_, िलं_,
   {{0x645a3484,0x7bde11b9,0x81b90081,0x53340e21}},	//   unti, ngpu, _চাই_, деот,
   {{0x62963485,0xddcd030b,0x62840049,0xe41a0220}},	//   _biyo, hlaš, _bhio, _kľúč,
   {{0x443e074a,0x62843486,0x26f8009d,0x6d4431cc}},	//   sht_, _chio, ंबीर_, kzia,
   {{0x62963487,0x6284151d,0x6d44022e,0x9f5a0231}},	//   _diyo, _dhio, jzia, _rapá_,
   {{0x6d440067,0xc9530054,0xc05b0f1e,0xb7b50134}},	//   dzia, תמש_, сім_, _họr,
   {{0x6284003b,0x7e6d3488,0x9f5a0610,0xb17b052f}},	//   _fhio, toap, _papá_, dgåe,
   {{0x33770054,0x6296058d,0x62843489,0x443c00de}},	//   _מתוך_, _giyo, _ghio, _hlv_,
   {{0x7e6d002d,0x8d7700e3,0xdb1c015e,0xd8620129}},	// [2970] roap, سارا, _herè, zọọt,
   {{0x6296348a,0xdb1c0154,0x7e6d020a,0x7a330342}},	//   _ziyo, _kerè, soap, _içti,
   {{0x3cf910ed,0x6296348b,0x682f02b6,0x69c200f0}},	//   _उनके_, _yiyo, _mødt, faoe,
   {{0xddcd348c,0xdb1c00b3,0x7bde02ac,0x00000000}},	//   blaš, _merè, agpu, --,
   {{0x8c3b02dc,0x9984030b,0x443c178f,0xc7b814f3}},	//   _auße, _domů_, _olv_, _lođu_,
   {{0x7d0d348d,0x66ea0092,0xddc4015c,0x443c02ac}},	//   mvas, _təkl, moiš, _nlv_,
   {{0x7d0d348e,0x261900c3,0x69c20231,0x00000000}},	//   lvas, भाली_, baoe, --,
   {{0x443c00c2,0xbddb0154,0x80b30033,0x69c20231}},	//   _alv_, _imès, _জিন্, caoe,
   {{0x799b0124,0x7d0d348f,0x58d43490,0x9f580052}},	//   _iguw, nvas, _потт, terë_,
   {{0x62963491,0x62840a02,0xdb1c0154,0xd8620174}},	//   _siyo, _shio, _berè, pọọt,
   {{0xb05b0222,0x6fd7009d,0x7d0d0673,0x62963492}},	//   rsäl, _बाजू, hvas, _piyo,
   {{0xc7b804a3,0x1c0a009d,0x5eac0081,0x443c3493}},	//   _dođu_, _होईल_, _ছিলে, _elv_,
   {{0xdb1c00dd,0xdb1e0610,0xd0120018,0x443c3494}},	//   _perë, rapé, پلز_, _flv_,
   {{0x409506d5,0x66093495,0xddcd2c0a,0xdfd20037}},	//   ерст, ldek, vlaš, ضير_,
   {{0xdee33496,0x62843497,0xdb1c3498,0x26c709ac}},	//   кори, _thio, _verë, nsno_,
   {{0x6d440a00,0x799b3499,0xa3a90bd9,0x682f0537}},	//   tzia, _nguw, गुर_, _køds,
   {{0x7d0d17be,0x6e240167,0x61e4349a,0xdb1c05aa}},	// [2980] gvas, rjib, _icil, _zerè,
   {{0x6d44349b,0x64410201,0x660900c2,0x3eba016d}},	//   rzia, nhli, hdek, _twpt_,
   {{0x7d09200b,0xdb1c349c,0x25de00af,0xf0930796}},	//   _šest, _keré, _गाली_, _שנת_,
   {{0x8c480092,0xa2d5349d,0xceb3040a,0xddcd01d3}},	//   _başç, _भिन्, _שיר_, plaš,
   {{0x81cb0081,0x66090517,0x81d40081,0x201a0167}},	//   র্ক_, ddek, স্থ_, _knpi_,
   {{0x76aa349e,0x9f5806a3,0x645d00fd,0xfbd50033}},	//   отив_, terè_, ésil, স্বত,
   {{0x6441064b,0x8c3b01bf,0x61e4007e,0x6d4100a7}},	//   dhli, _fußb, _ocil, _əlam,
   {{0x60c90995,0x81d40081,0x682f0537,0xa3b0349f}},	//   šemi, স্ত_, _bøds, टुन_,
   {{0x998d025b,0x69c000d9,0x6ad30081,0x7d090072}},	//   _pleť_, _ieme, _সহযো, _áest,
   {{0x69c034a0,0x682f0856,0x290434a1,0x61e434a2}},	//   _heme, _døds, _isma_, _acil,
   {{0x69c034a3,0xbbd70341,0x78a00169,0x27fc00fe}},	//   _keme, וויץ_, _humv, mevn_,
   {{0x69c034a4,0x78a0023f,0x682f0856,0x201a34a5}},	//   _jeme, _kumv, _føds, _anpi_,
   {{0x69c003b4,0x394634a6,0x656f01bf,0x644110e4}},	//   _meme, nzos_, ücht, bhli,
   {{0x644102e2,0x69c034a7,0xdb0e0072,0x443c13c8}},	//   chli, _leme, _debú, _ulv_,
   {{0xfe731850,0x3267008f,0x9f41028d,0xdb1c00b3}},	//   ندر_, _отив, _xchè_, _feré,
   {{0x69c034a8,0x27e903ce,0xdb15025b,0xe5080019}},	//   _neme, đani_, _nezá, _kỷ_,
   {{0xa2da0961,0x61fd34a9,0xddc40a87,0x682f01df}},	// [2990] पूर्, mesl, bliž, _mødr,
   {{0x69c01f72,0x320934aa,0x4ea73283,0x6609026a}},	//   _aeme, _haay_, _орма, zdek,
   {{0x69c034ab,0x290434ac,0x3ce934ad,0x7d0d34ae}},	//   _beme, _asma_, stav_, svas,
   {{0xfe350130,0x61fd34af,0xdb05095d,0x78a00193}},	//   _נאָך_, nesl, nché, _bumv,
   {{0x69c00902,0xadd6040a,0x29040124,0x320934b0}},	//   _deme, _אורח_, _csma_, _maay_,
   {{0xa3b000bc,0x682f00f2,0x013800ca,0x61fd00d4}},	//   टुम_, _røds, ורדת_, hesl,
   {{0x69c034b1,0x7bc534b2,0x66090cad,0x3ea100aa}},	//   _feme, mahu, tdek, _juht_,
   {{0x69c034b3,0x7bc534b4,0x32090124,0xd90e0018}},	//   _geme, lahu, _naay_, جیے_,
   {{0x644134b5,0x290434b6,0x27e90d2a,0x00000000}},	//   thli, _gsma_, ƙan_, --,
   {{0x69c034b7,0x7bc51098,0xc9841104,0x61e40037}},	//   _zeme, nahu, _руси, _scil,
   {{0x69c034b8,0x35b516dd,0xdb1c33b4,0x320934b9}},	//   _yeme, _збер, _peré, _baay_,
   {{0xcb120130,0x61fd01a2,0x68340472,0x6a7810d9}},	//   אלט_, gesl, _ràdi, tífi,
   {{0x7bc534ba,0x78a0023e,0x6f0534bb,0xfc3f0139}},	//   kahu, _xumv, _ashc, _etíi_,
   {{0xf8b200a1,0x3a2d1183,0x7bc534bc,0x15f900a4}},	//   רשם_, _loep_, jahu, ्यकर_,
   {{0xdb1c2299,0x3a3f34bd,0x61fd34be,0x7bc534bf}},	//   _teré, _olup_, besl, dahu,
   {{0x61e4015c,0x2be20096,0xa3d700c3,0x66ea013c}},	//   _ucil, _पाहा, िलक_, _səkk,
   {{0xc6920c6a,0x69c034c0,0x7afb1a5d,0x6bd60103}},	// [29a0] ראן_, _reme, _ćuta, فتار,
   {{0x7bc534c1,0x6cd30037,0x09d80096,0xec771fbf}},	//   gahu, اقلا, डल्य, епу_,
   {{0x69c0117e,0x68e90372,0x3a2d02ac,0x06b40033}},	//   _peme, _aqed, _boep_, _টিভি,
   {{0x4ad1009d,0x9fb80033,0xc9861675,0x00000000}},	//   _हिरव, _জায়গ, нули, --,
   {{0xa3cf3245,0x7bc534c2,0x2610206b,0x69c00052}},	//   षणा_, bahu, _दोषी_, _veme,
   {{0x26dc34c3,0x394634c4,0x7bce052f,0x7bc534c5}},	//   tuvo_, rzos_, _udbu, cahu,
   {{0x81cb00c7,0x8c1b0130,0x316c00a5,0xcb67334a}},	//   র্ট_, _צולי, ędzy_, _заре_,
   {{0x3a3f08c5,0xb21b02b6,0x7c2e34c6,0x9b1700ca}},	//   _glup_, mlæg, _hobr, _אחלה_,
   {{0x7c2e34c7,0xb21b02b6,0x61fd04d6,0x00000000}},	//   _kobr, llæg, vesl, --,
   {{0xb05b0222,0xb8060068,0x22400e69,0x73380d86}},	//   rsäk, _سکتے_, _alik_, дзор_,
   {{0x1de10b95,0x224034c8,0xb21b34c9,0xb05b0853}},	//   _फालत, _blik_, nlæg, ssäk,
   {{0x64a634ca,0xe5080028,0x60dd03cf,0xb0a5009f}},	//   _зада, _tỷ_, tusm, _गंदग,
   {{0x61fd34cb,0xdb0534cc,0x7bc534cd,0x3ea10673}},	//   resl, rché, yahu, _suht_,
   {{0x7c2e34ce,0xdb050503,0x61fd00a7,0x224034cf}},	//   _nobr, sché, sesl, _elik_,
   {{0xb5fd00cc,0xddc40034,0x60dd00aa,0x59d00096}},	//   pošt, bliż, susm, हणार,
   {{0x442e34d0,0xa2d5000d,0xb21b052f,0x7bc50051}},	//   _hof_, _भित्, dlæg, wahu,
   {{0x7bc534d1,0x5c750fe3,0x3a2d1507,0x3d1b0034}},	// [29b0] tahu, влат, _roep_, नमें_,
   {{0xddeb00bf,0x3a2d01c0,0xe1ff2e56,0x7c2e34d2}},	//   _کرده_, _soep_, leó_, _cobr,
   {{0x7bc534d3,0x442e34d4,0x3a2d1183,0xfbe2023a}},	//   rahu, _mof_, _poep_, _पारम,
   {{0x7bc509cf,0x442e34d5,0xe1ff037a,0x60cd13c8}},	//   sahu, _lof_, neó_, _kvam,
   {{0x7bc534d6,0xbddb05fe,0x26cc02ef,0xe0df028d}},	//   pahu, _elèc, _avdo_, nuò_,
   {{0x81cb00c7,0xbddb34d7,0x28d2201e,0x7d090072}},	//   র্চ_, _flèc, _सिरि, _áesq,
   {{0x1c0a34d8,0x3a2d057a,0x6e2f0141,0x68340441}},	//   _होटल_, _toep_, _kocb, _nàdu,
   {{0x7c2e0c01,0x60cd34d9,0xb9070033,0xe1ff037a}},	//   _zobr, _ovam, _বন_, jeó_,
   {{0xe1ff0018,0xe81e0251,0x98f4003f,0x26cc0085}},	//   deó_, पाशा_, _مثلا, _evdo_,
   {{0x224000f3,0x442e00f0,0xddcd0034,0x9f580036}},	//   _slik_, _cof_, niał, ferì_,
   {{0xb21b34da,0x60cd34db,0xe81e02d5,0x22400034}},	//   klæd, _avam, पारा_, _plik_,
   {{0x6b9a003e,0x81cb0033,0x27e90b18,0x6e2f009c}},	//   _útge, র্ঘ_, đanu_, _nocb,
   {{0xf1bf0018,0x7e690995,0xa50934dc,0xdd0102c6}},	//   pján_, čepl, _цела_, čtět,
   {{0xd47900c1,0x60cd0357,0x660b34dd,0x442e0178}},	//   _קאַל, _dvam, _hagk, _gof_,
   {{0xe45600c1,0x660b0124,0x60cd34de,0xd46634df}},	//   _ביסט_, _kagk, _evam, _шише_,
   {{0xb17b0149,0x22400120,0x28d202f0,0xb21b0537}},	//   mgån, _ulik_, _सिलि, glæd,
   {{0xed571a6d,0x7c2e34e0,0x660b34e1,0xdca3167b}},	// [29c0] вот_, _pobr, _magk, иати,
   {{0x14d4009d,0x1c1c00aa,0x660b0b97,0x2137006e}},	//   _दिसण, नाइल_, _lagk, _סטיל_,
   {{0x9f480084,0x8b96245c,0x403b0289,0xb17b02c3}},	//   ähän_, трач, _חגיג, ngån,
   {{0x660b03cb,0xb21b34e2,0xd838080e,0x6da6268e}},	//   _nagk, rlæg, _miče_, _шима,
   {{0x61f600dd,0x09e32dc8,0xd9461612,0xd838042d}},	//   _mbyl, рочн, ъеди, _liče_,
   {{0xddcd00a5,0x7d0402a4,0x7c2e042d,0xb8da030b}},	//   ciał, mwis, _uobr, _अझ_,
   {{0x442000ef,0x660b34e3,0x7d0434e4,0xd838031a}},	//   _đi_, _bagk, lwis, _niče_,
   {{0x442e34e5,0x26192a45,0xb17b0212,0xddcd00d4}},	//   _sof_, भागी_, dgån, plať,
   {{0x18a634e6,0x2ca60080,0x57ea001f,0x660b34e7}},	//   _разм, íodh_, _одам_, _dagk,
   {{0x442e0694,0x6a782b12,0x683400b3,0xdb1c0f20}},	//   _qof_, rífu, _pàdu, _lerí,
   {{0x60cd34e8,0x442e01cb,0x9f58037a,0x7d0434e9}},	//   _svam, _vof_, ferí_, hwis,
   {{0x7d0434ea,0xddcd0034,0x44eb0120,0x80d732d1}},	//   kwis, ział, bø_, _बिदे,
   {{0x442e34eb,0x66000a4b,0x76420065,0x628f0381}},	//   _tof_, memk, _iloy, rmco,
   {{0xb21b0537,0x24400383,0x6e2f34ec,0xe1ff037a}},	//   gmær, _fòma_, _socb, seó_,
   {{0x67380103,0x9f53002b,0x925934ed,0x2c1c00c3}},	//   nyvj, _raxó_, _пакт_, नाईं_,
   {{0x6d0e110f,0xddcd0034,0x1287001c,0xd258002d}},	//   सिंग_, wiał, _جمعی_, _аць_,
   {{0xd9041b67,0x2d5802fd,0x225902fe,0xb21b052f}},	// [29d0] _بی_, вить_, misk_, smæs,
   {{0x764234ee,0x5fb722a0,0x2259040f,0x61f602c6}},	//   _lloy, _अभिल, lisk_, _zbyl,
   {{0xddcd00a5,0x98b801d3,0x0ba404e6,0x61fa01f9}},	//   riał, _ārā_, ршум, őtle,
   {{0x225902fe,0x629e0257,0x6600033b,0xddcd0034}},	//   nisk_, _épou, jemk, siał,
   {{0x4dda0054,0xdb1c34ef,0x62560117,0xbd6b0284}},	//   _אחרו, _cerâ, dšol, _црне_,
   {{0xd3660981,0x764234f0,0x00000000,0x00000000}},	//   _هه_, _aloy, --, --,
   {{0x660b1395,0x2259057e,0xf094006e,0x00000000}},	//   _pagk, kisk_, בנס_, --,
   {{0xd83802ef,0xf5091369,0xdb0701f9,0x2bcb0287}},	//   _riče_, енил_, _bejö, ाणका,
   {{0x225917d2,0x03a5090f,0x9f580031,0xdb050076}},	//   disk_, липо, verí_, ichí,
   {{0x2c1c0034,0x58870ab3,0x76420154,0x44eb004d}},	//   नाएं_, _рыба, _eloy, rø_,
   {{0x225902fe,0xc73500d0,0x660b34f1,0x7d0434f2}},	//   fisk_, _حفاظ, _tagk, zwis,
   {{0x225902fe,0x764200eb,0x68fb0174,0xb17b0212}},	//   gisk_, _gloy, _kpud, rgån,
   {{0x51560077,0x51550231,0xb21b0537,0x00000000}},	//   утну, атру, tmær, --,
   {{0xdee60b99,0xdb1c11ce,0xc5e3009f,0x25ad0314}},	//   логи, _serí, _गाँठ_, lcel_,
   {{0xdb1c34f3,0x225917d2,0x644305db,0xb21b0537}},	//   _perí, bisk_, _ilni, rmær,
   {{0x25ad34f4,0x6d4101d4,0x7d0434f5,0x22590034}},	//   ncel_, _əlav, twis, cisk_,
   {{0xdb1c34f6,0x0d862549,0x00000000,0x00000000}},	// [29e0] _verí, улан, --, --,
   {{0x7d0434f7,0x66000074,0xc00634f8,0x629e05fe}},	//   rwis, zemk, _спок, _èpoc,
   {{0xdb1c34f9,0x91a934fa,0x28c60455,0x41b8007a}},	//   _terí, _hoá_, रीनि, _आभास,
   {{0x66ea01d4,0x61e60918,0x9f5834fb,0xfe421aaa}},	//   _məkt, ngkl, merà_, _اکسی,
   {{0x9f580451,0xc7b80218,0xbddb03a9,0xed3600d3}},	//   lerà_, _anđa_, _klèn, _сэнэ,
   {{0xdcfd00d9,0x6d4800a7,0xbddb0113,0x66000174}},	//   _uzsā, _ədal, _jlèn, wemk,
   {{0xf1ba0028,0x9f580451,0xd5e20294,0x660001ff}},	//   _đơn_, nerà_, _nhọ, temk,
   {{0x7e64007a,0x963434fc,0xb05b0212,0x7c3e000b}},	//   nnip, рниц, lsät, lkpr,
   {{0x80a034fd,0x3d170fef,0x89660457,0x9f5800e5}},	//   _गंगे, निये_, _скаж, herà_,
   {{0x2619009d,0x5454008f,0xb05b34fe,0x660034ff}},	//   _मोठी_, рвот, nsät, semk,
   {{0x225902fe,0xa3e502e8,0xb89300e3,0x7e6418ef}},	//   tisk_, _फार_, _اللع, knip,
   {{0x9f5800e5,0xdb050161,0xbb3b006e,0x64433500}},	//   derà_, lchã, געטי, _elni,
   {{0x225902fe,0xf1bf0018,0xe3af00cd,0xbddb03a9}},	//   risk_, lják_, غری_, _blèn,
   {{0x225902fe,0xbddb03a9,0xdb1e037a,0x7afc05db}},	//   sisk_, _clèn, zapá, _oprt,
   {{0x645a3501,0x22593502,0x331706fa,0x2139023b}},	//   miti, pisk_, _مزيد_, sysh_,
   {{0x443e3503,0x7e642375,0x442c0212,0x31660095}},	//   lkt_, gnip, ljd_, _žoze_,
   {{0xdc550a28,0x26c10018,0xad9b002b,0x28c60c22}},	// [29f0] авањ, ához_, _naút, रीमि,
   {{0xe7e0110f,0x645a3504,0xb05b0149,0x68e20138}},	//   _नागप, niti, gsät, duod,
   {{0x443e3505,0x20033506,0xdb0e01bf,0x629f1097}},	//   ikt_, meji_, _gebü, _épos,
   {{0x20033507,0xdb1c0396,0x645a3508,0x39151165}},	//   leji_, _serã, hiti, имер,
   {{0x628d117b,0xfc3f0037,0x443e003e,0x64480188}},	//   _mhao, _dtír_, kkt_, khdi,
   {{0x443e0505,0x645a3509,0x2011350a,0x7c3e227a}},	//   jkt_, jiti, ndzi_, ckpr,
   {{0x645a350b,0xfc3f0fb6,0xdb1c001f,0xaa9500d6}},	//   diti, _guía_, _verã, _вивч,
   {{0xceb4193b,0x6e2d350c,0x443e1324,0x7bc70193}},	//   זיק_, njab, ekt_, _heju,
   {{0x645a350d,0x2003350e,0x7bc70496,0x87e70391}},	//   fiti, keji_, _keju, _مثال,
   {{0x69cb350f,0x7bc73510,0xdb1c002b,0x25ad3511}},	//   lage, _jeju, _herá, scel_,
   {{0x38ab01df,0x7bc70294,0x2003033d,0x9f580428}},	//   _hør_, _meju, deji_, xerà_,
   {{0x628d1519,0x69cb3512,0x7bc72d60,0x443e0126}},	//   _chao, nage, _leju, akt_,
   {{0x645a3513,0x628d10f0,0x9f580ba0,0x32020146}},	//   biti, _dhao, derá_, reky_,
   {{0x443e3514,0x69cb3515,0x9f58343f,0x26193516}},	//   ckt_, hage, terà_, _मोती_,
   {{0x69cb3517,0x38ab038c,0x628d0013,0x7e56014d}},	//   kage, _lør_, _fhao, атац,
   {{0x628d0091,0x9f583518,0xfe433519,0x764901af}},	//   _ghao, rerà_, онсо, nhey,
   {{0xb05b09df,0x6486003e,0x7afc351a,0x753b0193}},	// [2a00] tsät, iðin, _sprt, nyuz,
   {{0x628d01c2,0x9f58351b,0x765b019c,0x68e200c2}},	//   _zhao, perà_, hiuy, vuod,
   {{0xb05b0704,0x9f58351c,0xf1da1b92,0x7bc7351d}},	//   rsät, berá_, _भयान, _deju,
   {{0x9f580d9f,0x38ab1a08,0x644800dd,0xdb1c04d8}},	//   cerá_, _bør_, zhdi, _cerá,
   {{0x645a0283,0x3940351e,0x443e351f,0x76493520}},	//   yiti, áis_, ykt_, dhey,
   {{0x645a3521,0xf1bf0018,0x26dc3522,0x2c1c00a5}},	//   xiti, tják_, trvo_, नाओं_,
   {{0x69cb28e1,0x12e00081,0x394033f4,0xab2708f9}},	//   bage, _বন্দ, šis_, _кора_,
   {{0x38ab1a08,0x261930a8,0x69cb3523,0xf1bf0103}},	//   _før_, _मोदी_, cage, rják_,
   {{0x38ab0021,0x645a3524,0xb8db0081,0xd943022f}},	//   _gør_, titi, _আয়_, _дети,
   {{0x628d0099,0x9f580220,0x443e01d3,0x7d5700ca}},	//   _shao, zerá_, ukt_, ייפד_,
   {{0x443e3525,0x6d4d0517,0x63a300dc,0xd5af0cb1}},	//   rkt_, zzaa, _dgnn, _мс_,
   {{0x443e0173,0x645a3526,0x64483527,0xdb1c002b}},	//   skt_, siti, shdi, _xerá,
   {{0x645a0239,0x9f58001f,0xc05b00d6,0x68e40049}},	//   piti, verá_, вів_, àidh,
   {{0x02a63528,0x69cb3529,0xc05b00d6,0xdb1e0428}},	//   _крим, zage, тім_, capç,
   {{0x628d10f0,0x69cb352a,0x44f0352b,0x9f5810d9}},	//   _thao, yage, là_, terá_,
   {{0x7bc706ee,0xb05b00c2,0xf8a607d5,0x92b3071c}},	//   _seju, tsäs, खदाय, _بحوا,
   {{0xdb05135f,0x7bc70d17,0x44f0352c,0xf1bf352d}},	// [2a10] dchá, _peju, nà_, mbá_,
   {{0xdb1c11ce,0x6d4d0ab2,0x69cb352e,0x38ab01df}},	//   _será, rzaa, wage, _rør_,
   {{0x69cb352f,0x38ab00f3,0xb05b16f9,0x6d4d3530}},	//   tage, _sør_, ssäs, szaa,
   {{0xceb20132,0xbddb0383,0x00000000,0x00000000}},	//   _מיט_, _klèm, --, --,
   {{0xdb1c3531,0x81d40081,0xe9d8013f,0x798000f0}},	//   _verá, স্ক_, ркі_, _cymw,
   {{0x44f03532,0xdb050037,0x81ad0033,0x7bd51819}},	//   dà_, achá, গরি_, _udzu,
   {{0xdb1c26ca,0x7649063d,0xb9e7004d,0xdb050206}},	//   _terá, they, _візи, bchá,
   {{0x38ab038c,0x683d05fe,0x81cc0081,0xbddb0154}},	//   _tør_, _mèdi, _লাভ_, _amèz,
   {{0x64860102,0xf80700d6,0x79800150,0x76493533}},	//   rðin, _вчен, _gymw, rhey,
   {{0x76493534,0xe0df3535,0x61ed3536,0xddcd033b}},	//   shey, drò_, _acal, jlaž,
   {{0x78a90033,0x9f580472,0xe0df028d,0x60c43537}},	//   _huev, merç_, erò_, _swim,
   {{0x78a13538,0x66ea00a7,0x6458039f,0x44f02269}},	//   _hilv, _təkr, _emvi, bà_,
   {{0x78a93539,0x25bf2f9c,0xf6741823,0x645d353a}},	//   _juev, mbul_, _بالخ, ésis,
   {{0x78a9058a,0x25bf0124,0x7e7d353b,0xf1bf016d}},	//   _muev, lbul_, _aksp, abá_,
   {{0xddcb2c0a,0x7ae5007a,0xf1bf0103,0x61ed0090}},	//   _šiša, juht, bbá_, _fcal,
   {{0x25bf0b88,0x290d0a43,0xf8a500cd,0xe0df0036}},	//   nbul_, _osea_, _يک_, brò_,
   {{0x78a931f9,0x7c3505aa,0x925a0470,0x644100c6}},	// [2a20] _nuev, _bozr, _لشکر_, okli,
   {{0xdd8f048f,0x09d0009d,0x3212003a,0x6441353c}},	//   رول_, हण्य, _hayy_, nkli,
   {{0xdb1c353d,0xb09b00a1,0x25bf353e,0x6441353f}},	//   _merç, _תייר, kbul_, ikli,
   {{0xd9100177,0xdb1e00bc,0x64411d7e,0x0dba0076}},	//   ویز_, vapä, hkli, _حادث_,
   {{0x64413540,0x78a90328,0x78a10b97,0xda1d0336}},	//   kkli, _cuev, _bilv, फाजत_,
   {{0x78a10b4b,0x44f03541,0xaad100c3,0x78a90036}},	//   _cilv, và_, _हिचक, _duev,
   {{0x64410149,0x290d037a,0x56940e65,0x26193542}},	//   dkli, _esea_, оакт, _मोही_,
   {{0x44f03543,0xc8e0000f,0x44b400d6,0xbb3b00c1}},	//   tà_, _निपट, обис, _געלי,
   {{0xdb1c0161,0x7afb0b18,0x3ea201cb,0x3ebf0218}},	//   _berç, _ćuti, _mikt_, ćuti_,
   {{0x44f03544,0x15ea0557,0xe0df0451,0x9f5a0428}},	//   rà_, _टावर_, vrò_, _japó_,
   {{0x6d4101d4,0x44f03545,0xd7640018,0x92953546}},	//   _əlaq, sà_, _بنای, жанц,
   {{0x78a10126,0x64410185,0x3ea200a5,0xe0df00e5}},	//   _zilv, akli, _nikt_, trò_,
   {{0xdb1c0084,0x64410ac1,0x867b0a41,0xf5960076}},	//   _herä, bkli, _גראו, _الشج,
   {{0x64413547,0xdb1c3548,0xe0df0451,0x61ed0034}},	//   ckli, _gerç, rrò_, _wcal,
   {{0x62350231,0x7c351799,0xc0580c10,0xce6b3549}},	//   _меку, _rozr, сія_, град_,
   {{0x4caa0081,0xbddb0113,0xe0df028d,0xa1490103}},	//   _চৌধু, _ilèk, prò_, _نسخے_,
   {{0x7c350038,0x7cd900cd,0xdd9400c6,0x3ea20f63}},	// [2a30] _pozr, شواز_, заты, _dikt_,
   {{0x4d981736,0x9f5a2df7,0x00000000,0x00000000}},	//   скую_, _capó_, --, --,
   {{0x25a6354a,0x78a90042,0xa91d0141,0x5f950161}},	//   _ogol_, _suev, _izži, _финт,
   {{0x6441316d,0x7e9902d1,0x7d0e00ce,0x00000000}},	//   zkli, _خنجر_, änsä, --,
   {{0x78a1354b,0xbcfb137f,0x7ae52a3c,0x6441286f}},	//   _pilv, _exér, suht, ykli,
   {{0x8aa7064f,0xdb1c0222,0x25b3023a,0xdd3100a5}},	//   _град, _berä, ीर्ण, zęśc,
   {{0x81d40f71,0xa6b40081,0x78a1354c,0x2249354d}},	//   স্ট_, _টিউট, _vilv, _olak_,
   {{0x62560094,0xd83805db,0xb05b042c,0xe8920206}},	//   lšov, _fičo_, lpäd, ĺňať_,
   {{0x78a1354e,0x89370d74,0xe9d90034,0xbddb05aa}},	//   _tilv, _اعزا, _idź_, _alèk,
   {{0xf9901574,0x2249354f,0x261917ff,0x99480037}},	//   _سبق_, _alak_, _मोरी_, _الكل_,
   {{0x64413550,0xdb1c3551,0x22493552,0xb21b052f}},	//   rkli, _gerä, _blak_, rlæn,
   {{0x81e200c7,0x64413553,0x28e01efb,0x28c600a8}},	//   ন্ন_, skli, _निमि, रीवि,
   {{0xdb1c0396,0xa2d51d96,0xbddb0383,0x2249033b}},	//   _terç, _भिक्, _elèk, _dlak_,
   {{0x22493554,0x3ea22ba4,0xbddb03a9,0x2d823555}},	//   _elak_, _sikt_, _flèk, _ryke_,
   {{0x032500d6,0x8fa31110,0x2d821aad,0x4fa300e5}},	//   _єдин, даре, _syke_, дирв,
   {{0x00e63556,0x3f8400e8,0x00000000,0x00000000}},	//   _джин, āmu_, --, --,
   {{0x3ea20149,0x00000000,0x00000000,0x00000000}},	// [2a40] _vikt_, --, --, --,
   {{0x62863557,0x2a7f01c2,0x81b001c2,0xc8e000c3}},	//   llko, _akub_, _daɓe, _निबट,
   {{0x6da60fa5,0xe7ed009d,0xad9b0139,0x3ea23558}},	//   _мина, च्छा_, _abúd, _tikt_,
   {{0x387e0085,0x2d8200b3,0xf9861e46,0x66fc00e8}},	//   _sktr_, _tyke_, огео, nākš,
   {{0xa3e90454,0x15e33559,0x00000000,0x00000000}},	//   यला_, _गाजर_, --, --,
   {{0xd6da355a,0xdb1c0084,0xa3e50336,0x201301ff}},	//   ати_, _perä, _फाग_, _xaxi_,
   {{0x27e00b88,0x81e20081,0xdca3355b,0x81b00044}},	//   ğin_, ন্য_, _цари, _zaɓe,
   {{0xa534355c,0x91e60490,0xdb1c02e2,0x27e008bb}},	//   знич, _कागज_, _verä, şin_,
   {{0xd40623a3,0x69c2355d,0xad9b0139,0x746a166f}},	//   ояни, mboe, _gbúd, иров_,
   {{0x81e20081,0xb35400d6,0xdb1c00c2,0x69c2355e}},	//   ন্ম_, зкош, _terä, lboe,
   {{0x28c60c16,0x683d00ee,0x68e20381,0x68e40076}},	//   रीरि, _cèdu, lrod, áidf,
   {{0x69c20ab2,0x64a601b3,0x68e20a4b,0x00000000}},	//   nboe, _дада, orod, --,
   {{0x2249355f,0x1a9b0130,0x2beb009d,0x62560146}},	//   _vlak_, ייטע, _चालू_, yšov,
   {{0x9f5a06a3,0x62863560,0x741400d1,0x60db250f}},	//   _rapò_, alko, _روبا, šumo,
   {{0xd8383561,0x69c201d0,0x2ca301c0,0x644a0167}},	//   _moč_, kboe, _rijd_, _ilfi,
   {{0x2cb902e5,0x68e23562,0x224900f9,0xa91d00b6}},	//   _ptsd_, krod, _ulak_, _lyža,
   {{0xa3ae009f,0x5d5501c9,0xfbab00a9,0x6b9a01cd}},	// [2a50] _कला_, чкат, атей_, _útgj,
   {{0x64dd02e8,0x68e23563,0xd8380087,0x69c23564}},	//   _मिसळ, drod, _noč_, eboe,
   {{0x625610e1,0x69c202ac,0x00000000,0x00000000}},	//   ršov, fboe, --, --,
   {{0xc3330130,0x69c20a9f,0x5a352a6e,0x68e20178}},	//   ווע_, gboe, янет, frod,
   {{0x2ca30505,0x68e200a5,0xb5fd0335,0x62560146}},	//   _tijd_, grod, niše, pšov,
   {{0xd7fb004c,0x7d0d3565,0x38b0009c,0x9f580036}},	//   руд_, mwas, _dàr_, ffrè_,
   {{0xe7393566,0x7d0d3567,0x44290028,0x3ffc0130}},	//   сей_, lwas, _đa_, יפגע,
   {{0xb0dc04a9,0xecdf0034,0x38b0009c,0xdb17002b}},	//   _बिलग, _फटाफ, _fàr_, saxó,
   {{0xdb0502dc,0x81e200c7,0x7d0d3568,0x83fc2a6c}},	//   schä, ন্ড_, nwas, ziđe,
   {{0x28e01b92,0xb5fd015c,0x7d0d06a8,0xd838007e}},	//   _निति, diše, iwas, _goč_,
   {{0x59cf022d,0x7d0d3569,0x3ce90197,0x60db09ac}},	//   _हजार, hwas, huav_, šuml,
   {{0x7d0d356a,0x83fc0039,0x80b30081,0xdb120018}},	//   kwas, viđe, _জিজ্, égév,
   {{0xa567001c,0x271c0023,0x6609356b,0x6f1e0a39}},	//   _بدان, _ảnh_, meek, _srpc,
   {{0xdb150364,0x6609356c,0x3af50212,0xbddb0154}},	//   _bezü, leek, kåp_, _klèw,
   {{0x44271c1a,0xe29a2569,0x00000000,0x00000000}},	//   _inn_, _лак_, --, --,
   {{0x7c270449,0x6f1e00cb,0x291f0134,0x6609356d}},	//   _anjr, _vrpc, _orua_, neek,
   {{0x7d0d0a69,0x28e00179,0x78bb0027,0x6abb05db}},	// [2a60] gwas, _निधि, _ntuv, _čufa,
   {{0x69db034f,0x8b9608f9,0x8cdd0557,0xac8311a0}},	//   _adue, преч, _पिरो, егул,
   {{0x291f356e,0x69c21044,0x103b00ca,0x78bb0bbd}},	//   _arua_, tboe, _הגיע, _atuv,
   {{0xdca61c66,0x2018356f,0x200a3570,0x4427009c}},	//   _нами, ldri_, lebi_, _lnn_,
   {{0x44273571,0x291f00e3,0x69c21183,0xb05b007a}},	//   _onn_, _crua_, rboe, späe,
   {{0x68e23572,0x69c204e2,0x69db0072,0xb17b0b85}},	//   rrod, sboe, _edue, pgåv,
   {{0xa91d025b,0x1c020455,0x7bdc00dc,0xa09b006e}},	//   _vyža, _रॉयल_, _idru, זיסט,
   {{0x44273573,0x81e20f71,0x54b80e38,0x200a1a0d}},	//   _ann_, ন্ত_, огия_, hebi_,
   {{0x7bce0f8b,0x48e33574,0x291f023b,0x44273575}},	//   _kebu, _потв, _grua_, _bnn_,
   {{0xb5fd04eb,0x7bce001c,0xaae00179,0x200a0880}},	//   više, _jebu, _पटाक, jebi_,
   {{0x212003a9,0x67bb00ca,0x6609083e,0xf3660dfb}},	//   _arih_, _המבק, beek, ятин,
   {{0x44270c09,0x7bce3576,0x3ce9023e,0x9f580206}},	//   _enn_, _lebu, yuav_, berú_,
   {{0x3ce9006c,0x81cc0033,0xbddb0154,0x660d00d2}},	//   xuav_, _লাশ_, _klèv, ánků,
   {{0x7bce3577,0xb5fd0786,0x44273578,0x64a31982}},	//   _nebu, riše, _gnn_, _зача,
   {{0x543309b4,0x81e20081,0xff042c37,0x8c3b0364}},	//   _سرور, ন্ধ_, нятн, _mußt,
   {{0x7d0d3579,0xb5fd0128,0x00000000,0x00000000}},	//   twas, piše, --, --,
   {{0x7bce357a,0xdcef01d3,0x200a026a,0x2d8f2222}},	// [2a70] _bebu, _izcī, bebi_, åge_,
   {{0x81e200c7,0xfbab00c6,0x200a357b,0x6609357c}},	//   ন্দ_, стай_, cebi_, zeek,
   {{0x81b00d2a,0x3ce9022e,0x78bb032e,0x7ac400d3}},	//   _haɓa, suav_, _stuv, есче,
   {{0xdb15025b,0xfd1f0019,0xa3dc04f8,0x81b001c2}},	//   _sezó, _trì_, तृत_, _kaɓa,
   {{0x7e6d357d,0x9f51058a,0x6609357e,0xdb050076}},	//   mnap, pezó_, veek, nchú,
   {{0x7bce357f,0x66093580,0x6fbf02d5,0x81b003e3}},	//   _gebu, week, ्रिं, _maɓa,
   {{0x66090a15,0x7bc53581,0xac9416d9,0x6d4000bc}},	//   teek, mbhu, _чарш, _ümar,
   {{0x7bdc19be,0x7e6d3582,0x7bce3583,0xdb26010d}},	//   _zdru, nnap, _zebu, _توفی,
   {{0x5fbf000d,0x66093584,0x14dd009d,0x81cc0081}},	//   ्राल, reek, _मिळण, _লাল_,
   {{0x68e4054f,0x66093585,0x7e6d3586,0xb4ad0096}},	//   áide, seek, hnap, _कढी_,
   {{0x7e6d18f0,0xe29a2cad,0xc7b200a1,0x420a2976}},	//   knap, жан_, _סבא_, онно_,
   {{0xd9ff0b7f,0x9f58037a,0x68e40094,0x7bc50076}},	//   ोजित_, perú_, šide, hbhu,
   {{0x7e6d3587,0x68eb02c9,0xd4350037,0x241910e0}},	//   dnap, nugd, _يعتب, _моды_,
   {{0xe8000c38,0xa91d0146,0x672109ac,0xd49b2f34}},	//   ल्पा_, _lyžo, _krlj, _уре_,
   {{0xa0a30360,0x7bce3588,0x10a31aad,0x00000000}},	//   тард, _rebu, тирн, --,
   {{0x7bce2c09,0x7ae500cc,0x67210106,0xbf280139}},	//   _sebu, drht, _mrlj, _aṣòr,
   {{0x62843589,0x81b00022,0x7bce0085,0x2bb2034c}},	// [2a80] _ikio, _gaɓa, _pebu, _जलदा,
   {{0x1daa074c,0x8b6a008f,0x67210357,0xfce32fad}},	//   _कलकत, оизв_, _orlj, тофо,
   {{0x28e00557,0x3cea009f,0x81b00d2a,0x00000000}},	//   _निहि, _चमके_, _zaɓa, --,
   {{0x7bce358a,0x1bf00251,0x5336006e,0xfd1f0139}},	//   _webu, _चावल_, ונען_, _iyìn_,
   {{0x7bce358b,0x83fc00e7,0x644f01d3,0xb17b032e}},	//   _tebu, hiđa, īcij, lgår,
   {{0x7bdc02e6,0x59cc000d,0x67210995,0x7e64358c}},	//   _udru, ारहर, _brlj, liip,
   {{0xb17b040f,0x2bc4277c,0x68e40076,0x28e0136b}},	//   ngår, _ल्या, áidb, _निवि,
   {{0x4420016a,0x1514060b,0x7e640032,0x67210542}},	//   _şi_, едия, niip, _drlj,
   {{0x7c3c358d,0x6d441bd6,0xd8380335,0x68e400c4}},	//   _korr, nyia, _liči_, šidb,
   {{0xdb1c038c,0x62840051,0x7c3c01e9,0x6296010a}},	//   _berø, _akio, _jorr, _ahyo,
   {{0x81b00d2a,0x672114f3,0xbddb022b,0x00000000}},	//   _saɓa, _grlj, _klèt, --,
   {{0x81e20081,0x63ad358e,0x68ed0138,0xa91d0117}},	//   ন্স_, _şant, žodž, _izžr,
   {{0x629600f9,0xbddb0113,0x7c3c0313,0xa19404a1}},	//   _dhyo, _mlèt, _oorr, каюч,
   {{0x7c3c358f,0x62843590,0x75220027,0x00000000}},	//   _norr, _ekio, _iroz, --,
   {{0xe80013b4,0x9f5f0b88,0x7522025b,0xb5fd0039}},	//   ल्या_, _ürün_, _hroz, liša,
   {{0x443c3591,0x7e6400f9,0x81b00d2a,0xe3b8047e}},	//   _hov_, giip, _taɓa, lcı_,
   {{0x443c3592,0x660200bf,0xfd1f0139,0x7c3c3593}},	// [2a90] _kov_, _mbok, _eyìn_, _borr,
   {{0x7c3c3594,0xe3b80587,0x6f050019,0xbddb0154}},	//   _corr, ncı_, _tphc, _alèt,
   {{0x443c3595,0x7c3c3596,0x60cd0167,0x629d169c}},	//   _mov_, _dorr, _hwam, omso,
   {{0x60cd3597,0x443c3598,0x75223599,0x625600e7}},	//   _kwam, _lov_, _oroz, nšop,
   {{0x7c3c3320,0xa80301e8,0x6e3d0124,0x6721042d}},	//   _forr, _çıkt, _iosb, _srlj,
   {{0x672104a3,0x6602359a,0x7c3c359b,0x60cd359c}},	//   _prlj, _abok, _gorr, _mwam,
   {{0x3949359d,0xddc402dd,0x98bf008b,0x60cd019b}},	//   šas_, lniš, ırım_, _lwam,
   {{0x83fc08a9,0x752209ac,0x7c3c1075,0x3ce60031}},	//   viđa, _broz, _zorr, šove_,
   {{0x7522209a,0x60cd0294,0xd7fb359e,0x6e3d0216}},	//   _croz, _nwam, _муж_, _mosb,
   {{0x443c1071,0x20cd359f,0x67210106,0x6e3d35a0}},	//   _cov_, dži_, _trlj, _losb,
   {{0x443c35a1,0x60cd35a2,0x63ad35a3,0x13a709e5}},	//   _dov_, _awam, _şans, بندی_,
   {{0x23bf05cd,0x60cd2622,0xd5750457,0x66020139}},	//   _श्रद, _bwam, _пуль, _gbok,
   {{0x752235a4,0x1bf0007d,0xddc41271,0xc56b03ef}},	//   _groz, _चालल_, jniš, _بحال_,
   {{0x6aa935a5,0xddc415f4,0x653a00c1,0x44f902f1}},	//   _lief, dniš, _מענד, mè_,
   {{0x44f935a6,0x661910a4,0x6e3d1044,0x75221799}},	//   lè_, _kawk, _bosb, _zroz,
   {{0x661b35a7,0xb17b0bab,0x62840239,0x443c006c}},	//   nduk, rgår, _ukio, _zov_,
   {{0xfce335a8,0x60cd0a75,0x44f906a3,0x6e3d0150}},	// [2aa0] лото, _gwam, nè_, _dosb,
   {{0x443c01bb,0x7e7b0335,0x7d1b003d,0x3157006e}},	//   _xov_, čupa, _ġust, _ניין_,
   {{0x7c3c35a9,0x6d4435aa,0x6aa935ab,0x9f5a0131}},	//   _vorr, syia, _bief, _capô_,
   {{0xddc40b27,0x7ae335ac,0x2bb206ed,0x661b1912}},	//   bniš, ánta, _जलवा, jduk,
   {{0x44f906a3,0x6aa904e2,0x7c3c35ad,0x661b0283}},	//   jè_, _dief, _torr, dduk,
   {{0x752435ae,0x98a335af,0x661b02b1,0xb5fd35b0}},	//   _šizo, гиче, eduk, viša,
   {{0x443c01bb,0x09e602ec,0x798935b1,0x201a25d1}},	//   _rov_, _повн, _eyew, _mapi_,
   {{0x752235b2,0x443c35b3,0x661b019c,0x6aa90036}},	//   _proz, _sov_, gduk, _gief,
   {{0x443c0197,0xc8ca1f11,0xbddb03a9,0x798926e3}},	//   _pov_, _روان_, _klèr, _gyew,
   {{0xa2b4007d,0x60cd3223,0x61f622d4,0x201a0018}},	//   _ईंद्, _rwam, _acyl, _napi_,
   {{0x443c35b4,0xddc40087,0xcf120081,0x39460103}},	//   _vov_, zniš, হমুদ_, lyos_,
   {{0xb5fd35b5,0x764935b6,0x752235b7,0x201a07ac}},	//   lišn, ckey, _troz, _aapi_,
   {{0x81a900c7,0x443c35b8,0x39460018,0x26190ed3}},	//   খুন_, _tov_, nyos_, _मोटी_,
   {{0x201a35b9,0xc5692ba0,0x229235ba,0xb5fd35bb}},	//   _capi_, _تحمل_, ráka_, unšv,
   {{0x81b003e3,0x141b00ca,0x6e3d35bc,0xddd414f3}},	//   _gaɓo, _מוגב, _posb, _šaša,
   {{0x6d1c0789,0xddc419d0,0x60cd35bd,0xbddb00b3}},	//   निंग_, tniš, _twam, _alèr,
   {{0x30a7008d,0x313533d4,0x22ac00b6,0x60cd02a4}},	// [2ab0] _пров, _репр, _věku_, _uwam,
   {{0xb5fd04a3,0xddc40087,0x394600f9,0xbddb0113}},	//   jišn, rniš, dyos_, _clèr,
   {{0xb5fd02e6,0xddc40106,0x5b241ad1,0xcfb600a1}},	//   dišn, sniš, льца, _בלתי_,
   {{0x44f935be,0xd838080e,0x3cea0096,0xddc407c0}},	//   yè_, _miču_, _चमचे_, pniš,
   {{0xca7435bf,0x201a35c0,0x00000000,0x00000000}},	//   دالغ, _yapi_, --, --,
   {{0x6bd409f4,0xd94235c1,0x201a01ff,0xddeb00d1}},	//   _متفر, реши, _xapi_, _برگه_,
   {{0x6aa901bf,0x79c900e3,0xd838015c,0x394606a8}},	//   _tief, _يوسف_, _niču_, ayos_,
   {{0x44f906a3,0x7bd735c2,0x39460113,0x00000000}},	//   tè_, laxu, byos_, --,
   {{0xb5fd0580,0x3d170096,0x81b003e3,0x661b35c3}},	//   bišn, निटे_, _saɓo, rduk,
   {{0x44f935c4,0x7bd7020b,0xd838007e,0x764935c5}},	//   rè_, naxu, _biču_, skey,
   {{0x201a0d17,0x3a3f06a3,0x44f935c6,0x3a2d057e}},	//   _rapi_, _koup_, sè_, _knep_,
   {{0x44f935c7,0x201a072f,0x216a35c8,0x3ce90c96}},	//   pè_, _sapi_, дими_, krav_,
   {{0x212400e3,0x64860088,0x9f5801cd,0x44f90036}},	//   ímh_, gðis, rfrí_, qè_,
   {{0x3a3f201c,0xb05b0c19,0x00000000,0x00000000}},	//   _loup_, spän, --, --,
   {{0xe1ff35c9,0xfc3f137f,0x7bd701ff,0xb5fd0e31}},	//   mión_, _luís_, daxu, nišo,
   {{0x201a0010,0x224b171d,0x3dc9019c,0x33760327}},	//   _wapi_, ckck_, gbaw_, _בעצם_,
   {{0x201a042b,0xbea335ca,0xe7f20096,0x3eab35cb}},	// [2ac0] _tapi_, ратк, _घाला_, _dict_,
   {{0xe1ff0f07,0x3eab0027,0xf1a700b6,0x224001ff}},	//   nión_, _eict_, _गणतन, _hoik_,
   {{0xb5fd005f,0x3a3f022b,0x00000000,0x00000000}},	//   višn, _boup_, --, --,
   {{0x3a3f025a,0xc3320327,0x27e903e3,0x9f5800b3}},	//   _coup_, יוב_, ɗani_, mfrà_,
   {{0x99dd0154,0x3ea035cc,0xc7b814f3,0xee3700ae}},	//   _alňs, mmit_, _lađe_, _рня_,
   {{0xdb1c0068,0x3ea035cd,0xb7d80037,0x394600f9}},	//   _kerü, lmit_, روبا_, ryos_,
   {{0x7c2e35ce,0xc7b8005f,0xb5fd031a,0x81d90033}},	//   _inbr, _nađe_, rišn, ালত_,
   {{0xeb971b60,0x5eea00b6,0x9f58037a,0x692600ae}},	//   _рис_, _छिन्_, leró_, _имба,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xe1ff35cf,0x9f580314,0xb5fd1515,0x3ea00052}},	//   gión_, neró_, bišo, hmit_,
   {{0xad9b026e,0x2252057a,0x3a3f01cb,0x25bd030a}},	//   _abúl, _blyk_, _youp_, _ffwl_,
   {{0xdb1c35d0,0xacbb00fd,0x3ea035d1,0xb5da2259}},	//   _heró, _brûl, jmit_, _آباء_,
   {{0xe1ff08a8,0x81cc0081,0x7c2e112f,0x00000000}},	//   bión_, _লাখ_, _onbr, --,
   {{0xe1ff35d2,0x545335d3,0x14d70130,0x64860088}},	//   ción_, _квіт, _יודל_, rðis,
   {{0x3eab0085,0x9f580487,0x00000000,0x00000000}},	//   _pict_, deró_, --, --,
   {{0x320f0068,0x02a4022c,0x5bcb0f8f,0x7c2e35d4}},	//   _úgy_, _крым, िर्व, _anbr,
   {{0x5c752f11,0xad9b0065,0x3eab0169,0x2fd80027}},	// [2ad0] глат, _gbúl, _vict_, barg_,
   {{0x7ae335d5,0x3a2d2618,0x3a3f35d6,0x00000000}},	//   ánto, _snep_, _soup_, --,
   {{0x629f00e5,0xe81d0789,0x3ea000a1,0x201135d7}},	//   _èpos, _योगा_, bmit_, mezi_,
   {{0x201135d8,0x3ce902dd,0x7c2e0062,0x3ce61b62}},	//   lezi_, prav_, _enbr, šova_,
   {{0x26de35d9,0x9f5805b4,0x99d400d1,0x3a3f022b}},	//   _avto_, beró_, شتنا, _voup_,
   {{0xe1ff0fb6,0x81d90033,0x9f5800ee,0x628f00d4}},	//   xión_, ালি_, ceró_, hlco,
   {{0x27e908bb,0x8aa70095,0xead40c4a,0x9f580036}},	//   ğan_, _арад, _вось, lerò_,
   {{0x1dd3007d,0x27e90702,0x442e01af,0x3a2d35da}},	//   तरित, şan_, _anf_, _unep_,
   {{0x2a64013d,0xe1ff1ba6,0xe80013b8,0x442e35db}},	//   _търг, tión_, ल्हा_, _bnf_,
   {{0x3ea000dd,0x69d935dc,0x442e35dd,0x201135de}},	//   zmit_, lawe, _cnf_, jezi_,
   {{0x7bd535df,0x25af005c,0x9f580451,0xdb1c00b3}},	//   _mezu, _tggl_, herò_, _herò,
   {{0xe1ff11d1,0x69d9068d,0xddd6025b,0x442e022b}},	//   sión_, nawe, chyň, _enf_,
   {{0xdb0e0065,0x648601cd,0x224002ac,0x2fd8007f}},	//   _egbè, rðir, _voik_, targ_,
   {{0x201135e0,0x9f58028d,0xdb1c002b,0x7bd5063d}},	//   gezi_, derò_, _xeró, _nezu,
   {{0x2d8f01bf,0x37d80033,0x38b9098c,0x69d935e1}},	//   ügen_, _সামর, _lèr_, kawe,
   {{0x69d935e2,0xdb050037,0xad9b0139,0x229935e3}},	//   jawe, hchó, _ibúj, téke_,
   {{0x61e435e4,0x3ea00539,0x628635e5,0x69d90201}},	// [2ae0] _idil, rmit_, moko, dawe,
   {{0x628635e6,0x09cc0d88,0xdb1c0018,0x3ea035e7}},	//   loko, ार्य, _terü, smit_,
   {{0x27230702,0x7bd535e8,0xdb1c015e,0x8cb0007f}},	//   _nın_, _dezu, _aerò, _अंको,
   {{0x248535e9,0x628635ea,0x69d935eb,0x9f4100e1}},	//   holm_, noko, gawe, _echó_,
   {{0x1ae033d9,0x186a35c1,0x9f5835ec,0x62860350}},	//   _पटकथ, нади_, peró_, ioko,
   {{0x628635ed,0x7bd535ee,0xddcd0034,0xdb1c05aa}},	//   hoko, _gezu, chał, _derò,
   {{0xeb970d62,0x69d935ef,0x628635f0,0xdb1c0328}},	//   _бир_, bawe, koko, _veró,
   {{0x60c4129e,0x61e435f1,0x2bc00469,0x20112002}},	//   _otim, _ndil, शुरा, zezi_,
   {{0x54542007,0x2011083e,0xb21b01df,0x60c435f2}},	//   ивит, yezi_, klær, _ntim,
   {{0xdb0e0032,0xe6440491,0x59cc00b6,0xb7b5020b}},	//   _agbé, ılış, ारकर, _hạn,
   {{0x60c435f3,0x439435f4,0x61e40090,0x26010096}},	//   _atim, ранс, _bdil, व्ही_,
   {{0x201135f5,0xe4520688,0x628635f6,0x61e4009c}},	//   wezi_, _گفتگ, goko, _cdil,
   {{0x201135f7,0x61e40150,0x9f4103a9,0xb7b50023}},	//   tezi_, _ddil, _idhé_, _mạn,
   {{0x61e435f8,0x7642008a,0x9f580451,0x27170092}},	//   _edil, _hooy, verò_, _sənə_,
   {{0x201135f9,0xa91d0244,0x69d935fa,0xda040176}},	//   rezi_, _vyži, yawe, रभात_,
   {{0x7bd535fb,0x7642321d,0x9f58028d,0x244901cd}},	//   _sezu, _jooy, terò_, _rúmi_,
   {{0x201135fc,0xdb0501bf,0x320900f9,0x76420188}},	// [2af0] pezi_, schü, _ibay_, _mooy,
   {{0x69c035fd,0x69d90010,0x9f580451,0x2129001c}},	//   _afme, wawe, rerò_, _irah_,
   {{0x7bd50e94,0x69d935fe,0x8af90f32,0x5b151272}},	//   _vezu, tawe, тнес_, рмет,
   {{0x7f3a00c1,0x2129023b,0x7d1600f0,0xd0110018}},	//   _סערו, _krah_, bwys, _الگ_,
   {{0xe0df35ff,0x67283600,0x65ab013c,0x80a4015a}},	//   nsò_, _ardj, _möhü, _خمین,
   {{0xe80020cd,0xb34601e8,0x67280a39,0x635300a7}},	//   ल्ला_, _kaçı, _brdj, sənə,
   {{0xe7390274,0x62863601,0x39be0294,0xdb050076}},	//   тей_, yoko, _ịse_, rchó,
   {{0x8aa43602,0xb5fd0138,0x2129037d,0xb346026a}},	//   _груд, mišk, _orah_, _maçı,
   {{0xb5fd3603,0x76423604,0xf1c800b6,0xdb1c01cd}},	//   lišk, _dooy, ndář_, _herð,
   {{0x62863605,0x32093606,0x290d0131,0xb4651440}},	//   woko, _abay_, _ipea_, ркол,
   {{0x21291084,0x62863607,0xb5fd3603,0xe29a0831}},	//   _arah_, toko, nišk, као_,
   {{0x76420188,0x69ac00a3,0x543501f9,0x00000000}},	//   _gooy, ुँची, ارکر, --,
   {{0x62863608,0x62460139,0x212903a9,0xb5fd033b}},	//   roko, _bóor, _crah_, hišk,
   {{0x9f580088,0x25bf3609,0xb5fd013f,0x7e660063}},	//   ferð_, lcul_, kišk, _smkp,
   {{0x8fa6266a,0x6286360a,0x9f580088,0xb5fd360b}},	//   раве, poko, gerð_, jišk,
   {{0x25bf048e,0x13da0081,0x6443360c,0xb5fd360d}},	//   ncul_, _দায়, _honi, dišk,
   {{0x6443360e,0xb21b00d6,0x21291cb4,0x60c4360f}},	// [2b00] _koni, plær, _grah_, _utim,
   {{0x7d160185,0x64433610,0xddd500e8,0x3ce600d4}},	//   rwys, _joni, ābša, šovo_,
   {{0x64433611,0xb5fd013f,0xe9da3612,0xc7b80a39}},	//   _moni, gišk, вке_, _nađa_,
   {{0x64431622,0xa92613cb,0x62872650,0x6aa20baa}},	//   _loni, идел, čkog, umof,
   {{0xd37803ce,0x6728077e,0x76420313,0x2ba73613}},	//   maće_, _srdj, _rooy, केबा,
   {{0xdb1c0102,0x64433614,0x6aa23615,0xb5fd3616}},	//   _ferð, _noni, smof, bišk,
   {{0xdb1c0102,0xd6d70761,0x290d0a00,0xd5e20174}},	//   _gerð, аты_, _epea_, _nkọ,
   {{0x7e7601af,0x96343617,0xddcd020a,0xd01f0033}},	//   nnyp, сниц, mnaţ, দায়_,
   {{0xd90e1e49,0xd49a2a84,0x3ce20113,0x99340018}},	//   _آیت_, кро_, _jvkv_, _دہشت,
   {{0x656f3618,0x76423619,0x320900f9,0x6443361a}},	//   úcha, _wooy, _sbay_, _coni,
   {{0xc5e800c7,0x0bb70054,0x6f0900a5,0xc7b8015c}},	//   ক্ষা_, ילים_, łecz, _gađa_,
   {{0xd3782461,0x21290128,0x32673051,0x81b003e3}},	//   jaće_, _prah_, ртов, _zaɓi,
   {{0xdfdb013d,0x6443361b,0xd37800cb,0xc69300ca}},	//   къв_, _foni, daće_, _ואף_,
   {{0x6443361c,0xd48f004d,0xe0df0036,0x916900fe}},	//   _goni, _єр_, rsò_, _vừa_,
   {{0x09d70081,0xe0df361d,0xb05b00c2,0xb34600a7}},	//   _হাসা, ssò_, npäi, _qaçı,
   {{0xb5fd013f,0x877b006e,0x443e0212,0xd3780095}},	//   višk, דאלי, ljt_, gaće_,
   {{0x656d0181,0x21290087,0x6443361e,0x2d8f052f}},	// [2b10] _ľahk, _urah_, _yoni, æge_,
   {{0xa80207e7,0xb5fd013f,0x6443361f,0x270e0092}},	//   çıla, tišk, _xoni, _kənd_,
   {{0x95ff0033,0x6aa3029a,0xd3780e94,0xc5ff0033}},	//   ্যতম_, ïnfo, baće_, ্যতা_,
   {{0xdb1c0682,0xb5fd3603,0xc7b808a9,0xd378007e}},	//   _verð, rišk, _rađa_, caće_,
   {{0x634a01d4,0xb5fd013f,0x645a008a,0x628d3620}},	//   lənd, sišk, khti, _mkao,
   {{0x89340068,0x1ed80260,0x7e6d065c,0xb5fd00c6}},	//   تعما, _حبیب_, liap, pišk,
   {{0x81e200c7,0x6d4d0b5b,0xb9200134,0x36693621}},	//   ন্ট_, lyaa, _karị_, лако_,
   {{0x80b800c7,0x64433622,0xb9200174,0xceb400ca}},	//   _অবস্, _soni, _jarị_, חיק_,
   {{0x6d4d3623,0x64433624,0x25bf00d3,0xb5fd0b9c}},	//   nyaa, _poni, rcul_, niši,
   {{0x25bf3625,0x799b0d2a,0x628d3626,0x2ab70090}},	//   scul_, _izuw, _akao, _aħbi_,
   {{0xd7950080,0x64433627,0x7e6d3628,0xe1ff0018}},	//   _الاخ, _voni, kiap, ciók_,
   {{0xc0493629,0x64430505,0x425621fd,0x22991e6f}},	//   _אז_, _woni, стот, téka_,
   {{0xd3780039,0x2ba7009d,0x6443362a,0x00000000}},	//   vaće_, केता, _toni, --,
   {{0x645a362b,0x10a6002d,0xb5fd362c,0x4613001c}},	//   chti, сигн, diši, _دوچر,
   {{0xd3782a6c,0x6d4d0188,0x934500d3,0x00000000}},	//   taće_, eyaa, _ынке, --,
   {{0x765b362d,0x7e6d362e,0x00000000,0x00000000}},	//   nhuy, giap, --, --,
   {{0xd37801ac,0x6da3362f,0x6d4d3630,0x101605b6}},	// [2b20] raće_, зита, gyaa, _льня,
   {{0xb3d50033,0x3ce03631,0xd378031a,0x00000000}},	//   _দাঁড়, rsiv_, saće_, --,
   {{0x3ce03632,0x6d4d3633,0xff261942,0xaca40174}},	//   ssiv_, ayaa, _умно, _nnụr,
   {{0xeb9714fa,0xddcd00d3,0x6d4d3634,0xb5fd0234}},	//   щих_, rnaţ, byaa, biši,
   {{0xaca40129,0xdd921850,0x2d8400fd,0x645a00c2}},	//   _anụr, _روس_, _âme_, yhti,
   {{0x6e24073b,0x99dd0094,0xb90000c3,0x7d043635}},	//   ldib, _voňa, _दब_, mtis,
   {{0x7bde3636,0x6b630b0c,0x09d70081,0x04200081}},	//   mapu, _екра, _হারা, বামী_,
   {{0x6e243637,0x645d00dd,0xceb300a1,0xdb1c0149}},	//   ndib, ësin, היה_, _berö,
   {{0x7d043638,0xb05b00c2,0x3eba044c,0x00000000}},	//   ntis, späi, _lupt_, --,
   {{0x7bde3639,0x634a01d4,0x7d04363a,0xe7f20490}},	//   napu, yənd, itis, _घाटा_,
   {{0x7d04363b,0x539800d6,0x9f45008b,0x81b003e3}},	//   htis, рвня_, ülü_, _maɓu,
   {{0x645a01e5,0x7d040e9f,0x6d4d363c,0x7ae30610}},	//   shti, ktis, yyaa, ánti,
   {{0x7bde363d,0x6d4d008a,0x68e2363e,0xc05b004d}},	//   kapu, xyaa, nsod, гів_,
   {{0x80b80081,0x634a0092,0x7bde363f,0xdb1c3640}},	//   _অবশ্, tənd, japu, _afrí,
   {{0x6fda0c13,0x7e6d2c6f,0xe3b80367,0x00000000}},	//   _बजरं, tiap, ndım_, --,
   {{0xdceb135f,0x7d043641,0x6e243642,0x22c40294}},	//   žičk, ftis, gdib, _ịkwa_,
   {{0x68e20117,0x7d043643,0x60d600eb,0x00000000}},	// [2b30] jsod, gtis, _gwym, --,
   {{0x7e6d18c4,0x7bde3644,0xb5fd0995,0x6d4d008a}},	//   siap, gapu, riši, ryaa,
   {{0x6d4d17b6,0x6e243645,0x39be0134,0x200400a7}},	//   syaa, bdib, _ịsa_, əmi_,
   {{0xb5fd191d,0x27fe0234,0x5a350e3f,0x00000000}},	//   piši, _actn_, юнет, --,
   {{0xab6207d1,0x645814e2,0x7d043646,0xe9d808a1}},	//   _çünk, _olvi, ctis, скі_,
   {{0xd5e20065,0xe9d9007f,0x00000000,0x00000000}},	//   _amò, _weź_, --, --,
   {{0x70b50034,0x765b00fe,0x00000000,0x00000000}},	//   ंदुल, thuy, --, --,
   {{0x245b04ea,0x81b003e3,0x7996007f,0x656f3647}},	//   _même_, _zaɓu, żywa, úcho,
   {{0x1fa617ad,0xe45908c3,0x69db00f0,0x68e201f9}},	//   _खण्ड, ижи_, _ieue, csod,
   {{0xdb1c25ea,0x69db1399,0x765b0169,0x99dd0206}},	//   _verö, _heue, shuy, _koňo,
   {{0x2c0b00b7,0x765b0079,0x00000000,0x00000000}},	//   स्यं_, phuy, --, --,
   {{0xa3b504f8,0x7bde03be,0x7de60018,0x7d04003e}},	//   _झलक_, zapu, _késő, ytis,
   {{0xe820000d,0x7bde3648,0x69db00ee,0x3eba3649}},	//   _यसमा_, yapu, _meue, _supt_,
   {{0x9f580257,0x660913fb,0x69db057a,0xdb05016d}},	//   lgré_, lfek, _leue, lchõ,
   {{0xe29a364a,0x1faa1c00,0xfd1f0139,0x7bde0f06}},	//   _как_, ркви_, _asì_, vapu,
   {{0x69db02dc,0x7bde03fa,0x6e24209a,0x7d04364b}},	//   _neue, wapu, udib, ttis,
   {{0x7bde2846,0x0eb6000f,0xd3780106,0x1c460b22}},	// [2b40] tapu, _आंकड, maća_, онам,
   {{0x765902ad,0x212000bf,0x8b96364c,0xe3b8071d}},	//   _llwy, _isih_, ореч, ydım_,
   {{0x8fa620e6,0x9f0600b9,0x69db364d,0x3bd500c2}},	//   _фане, _بوجو, _beue, яютс,
   {{0x2018074e,0x2120005c,0x634a0092,0x7ff6015a}},	//   leri_, _ksih_, lənc, _اسکا,
   {{0x7bde364e,0xcaa500e3,0x69c208a8,0xdca62d70}},	//   papu, أصلي, rcoe, _мами,
   {{0x2018364f,0xab2a0cc1,0x75290018,0x212009a4}},	//   neri_, _кога_, dvez, _msih_,
   {{0xf8bf0ab2,0x66090f05,0x68e23650,0x69db01bf}},	//   _één_, ffek, ssod, _feue,
   {{0x7bdc3651,0x20183652,0xe3b808bb,0x68ed0d62}},	//   _heru, heri_, rdım_, šada,
   {{0x7bdc3653,0xd3780dd9,0xdb21007b,0xbddb022b}},	//   _keru, daća_, ätös, _plèz,
   {{0x201802e6,0xddc41b32,0x344a1352,0x29060239}},	//   jeri_, jniž, рчин_, mtoa_,
   {{0x7bdc2c09,0x21201bdf,0x765902ad,0xdb0501bf}},	//   _meru, _asih_, _flwy, schö,
   {{0xbddb00fd,0x75290128,0x2906358c,0x6abc3654}},	//   _poèm, bvez, otoa_, _murf,
   {{0x29063655,0xddcd00b6,0xe3af0018,0xdb1502f1}},	//   ntoa_, chař, ٹری_, _egzè,
   {{0x20183656,0x7bdc3657,0xe3af0018,0x270e0092}},	//   geri_, _neru, عری_, _gənc_,
   {{0x6abc005c,0xcddb07ed,0x212000d1,0xff04163d}},	//   _nurf, иња_, _esih_, мятн,
   {{0x7bdc3658,0x20180172,0x29060062,0x00000000}},	//   _aeru, aeri_, ktoa_, --,
   {{0x7bdc3659,0x2018365a,0xdb0e0032,0xb5fd1912}},	// [2b50] _beru, beri_, _agbà, mišt,
   {{0xb5fd02e6,0x2018365b,0x7bdc365c,0x69db0428}},	//   lišt, ceri_, _ceru, _seue,
   {{0x7bdc365d,0x200100f0,0x69db365e,0x6abc0076}},	//   _deru, _ichi_, _peue, _curf,
   {{0x61fd1842,0x78bb0673,0x81d90081,0x6abc365f}},	//   ngsl, _puuv, ালক_, _durf,
   {{0x3ea902fd,0x7bdc3660,0x61fd1d09,0x69db0428}},	//   mmat_, _feru, igsl, _veue,
   {{0x7bdc0b7c,0x3ea93661,0xb5fd0087,0xeafb0470}},	//   _geru, lmat_, hišt, _پرست_,
   {{0x7bc51644,0x69db01bf,0x6abc0044,0x645d0052}},	//   mchu, _teue, _gurf, ësim,
   {{0xe9df0682,0xb5fd0d95,0x386c01af,0x7bdc3662}},	//   _þú_, jišt, _emdr_, _zeru,
   {{0x7bdc3663,0x1c0b000d,0x1a6800cd,0x20183664}},	//   _yeru, स्थल_, _بینی_, yeri_,
   {{0x20011ee3,0x75290068,0x3ea93665,0x7bc53666}},	//   _nchi_, rvez, hmat_, nchu,
   {{0x3ea90496,0x7ae5023b,0x75293667,0xb5fd02ef}},	//   kmat_, nsht, svez, fišt,
   {{0x20183668,0x7bc5151d,0x6721015c,0x3ce60094}},	//   weri_, hchu, _islj, šovi_,
   {{0x20183669,0x3ea908d3,0xd3780106,0x55ba00ca}},	//   teri_, dmat_, raća_, _המנו,
   {{0x394000c2,0x2a7f033b,0xb5fd366a,0x7bc500d4}},	//   äisi_, _ljub_, rišu, jchu,
   {{0x2018366b,0x43750130,0x7bdc366c,0x634a00a7}},	//   reri_, _מײַן_, _reru, rənc,
   {{0x7bdc113a,0x20010294,0x3ea9366d,0xb5fd015c}},	//   _seru, _echi_, gmat_, cišt,
   {{0x7bdc2590,0x2018366e,0x6abc366f,0xc5e80033}},	// [2b60] _peru, peri_, _surf, ক্কা_,
   {{0xdb0e026e,0xf1bf3670,0x8fa63671,0x20180052}},	//   _agbá, ndán_, _напе, qeri_,
   {{0x7bdc3672,0x2ba70b94,0x68f901c0,0x1c020034}},	//   _veru, केला, euwd, र्गल_,
   {{0x7bdc3673,0xfc3f03be,0x290600c2,0xda650190}},	//   _weru, _xuíz_, ttoa_, واني,
   {{0x7bdc0332,0x3a26000b,0xf918001c,0x3a241d91}},	//   _teru, rdop_, تراژ_, _vamp_,
   {{0x7bc53674,0xb5fd08c5,0x6e260bb6,0x2a7f3675}},	//   cchu, zišt, _hakb, _ejub_,
   {{0x29063676,0x98a4020a,0xc66a007b,0x7ae5009c}},	//   stoa_, _armă_, йшие_, csht,
   {{0xb86600d0,0xa5343677,0x6e260034,0xddc40034}},	//   _کارو, днич, _jakb, jniż,
   {{0xb5fd2188,0xfc3f167e,0x6e263678,0x32190031}},	//   višt, _ruíz_, _makb, vesy_,
   {{0x3ea93679,0x6e26367a,0xe9ff020b,0x00000000}},	//   zmat_, _lakb, _toản_, --,
   {{0xb5fd2617,0x04fe0081,0xe9ff0023,0x3ea90a5d}},	//   tišt, ্টের_, _hoạn_, ymat_,
   {{0x2001367b,0x76bb00ca,0x3ea911bc,0x00000000}},	//   _schi_, _המאפ, xmat_, --,
   {{0xb5fd02e6,0x32191670,0x61fd093e,0x9f5101cd}},	//   rišt, resy_, rgsl, _íbúa_,
   {{0x04200081,0xb5fd0234,0x752209d8,0x00000000}},	//   বাহী_, sišt, _isoz, --,
   {{0xb5fd030b,0xe9ff0019,0x9f34004d,0x6e26367c}},	//   pišt, _loạn_, нері, _bakb,
   {{0x5f9400d6,0x5eb40870,0x644a1e72,0x3ea931cf}},	//   хист, ейст, _hofi, umat_,
   {{0x644a367d,0x61ed29e6,0x628f0181,0xad9b0065}},	// [2b70] _kofi, _idal, moco, _abúr,
   {{0x60cd367e,0x5ba733d4,0x628f3536,0x2001367f}},	//   _itam, през, loco, _uchi_,
   {{0x7bc53680,0x644a0f20,0xa1340260,0x6602007e}},	//   rchu, _mofi, _قریش, _ocok,
   {{0xe1ff3681,0x7bc53682,0x7ae500dd,0x6e260090}},	//   ngó_, schu, rsht, _gakb,
   {{0xa95400d6,0x08c400f3,0xddd60031,0x75223683}},	//   нкці, ебін, dkyň, _nsoz,
   {{0xf7700979,0x644a3684,0x7ae5023b,0x60cd0051}},	//   گاه_, _nofi, psht, _mtam,
   {{0x16a90ed1,0x628f3685,0x61ed3686,0xab95004d}},	//   овки_, koco, _odal, _циві,
   {{0x7c273687,0x61ed3688,0x60cd3689,0x2a7f368a}},	//   _hajr, _ndal, _otam, _ujub_,
   {{0x644a368b,0x68e400e3,0x60cd1a0f,0x7c27368c}},	//   _bofi, áidt, _ntam, _kajr,
   {{0x61ed1268,0x644a368d,0x6602063d,0x55ff0033}},	//   _adal, _cofi, _ecok, ্যেক_,
   {{0x60cd368e,0x1c0208fa,0x67210477,0x628f305a}},	//   _atam, र्टल_, _uslj, foco,
   {{0x628f002b,0x68e933c2,0x00000000,0x00000000}},	//   goco, _kved, --, --,
   {{0x98a400d3,0x61ed368f,0x6e263690,0x644a3691}},	//   _urmă_, _ddal, _rakb, _fofi,
   {{0x764b0068,0x7c273692,0x60cd3693,0x661b3694}},	//   _hogy, _najr, _dtam, leuk,
   {{0x2dcb0857,0x628f3695,0x60cd2c58,0x28dd2373}},	//   _ụlọ_, boco, _etam, नीति,
   {{0x44273696,0x661b3697,0xf1bf1125,0x764b1a3a}},	//   _han_, neuk, ndál_, _jogy,
   {{0x44273698,0x7c273699,0xfce30084,0x3cf500a5}},	// [2b80] _kan_, _bajr, кото, एंगे_,
   {{0x4427369a,0x61ed1d25,0xb05b32ee,0x69c9026d}},	//   _jan_, _zdal, spär, _afee,
   {{0x4427256f,0x6e26369b,0xe1ff369c,0xa05700c1}},	//   _man_, _takb, ciós_, _חסיד_,
   {{0x4427369d,0xe1ff00a5,0x7c270634,0x6e26010a}},	//   _lan_, chód_, _eajr, _uakb,
   {{0x09e310f7,0x44270023,0xe3e30081,0x3e77003d}},	//   точн, _oan_, _মানব, għtu_,
   {{0x4427369e,0x68e9007e,0xb8e609a1,0x7afa02c3}},	//   _nan_, _dved, _ईं_, _åtto,
   {{0x69c9083e,0xeb972c37,0x752206b0,0x644a369f}},	//   _ffee, _жир_, _ssoz, _rofi,
   {{0x442736a0,0x661b0051,0x7c270034,0x764b00eb}},	//   _aan_, geuk, _zajr, _cogy,
   {{0x442736a1,0x628f36a2,0xe7cf332a,0xd7cf034d}},	//   _ban_, voco, _स्वप, _स्वच,
   {{0x4427004f,0xddd624a1,0x00000000,0x00000000}},	//   _can_, skyň, --, --,
   {{0x442736a3,0x764b0018,0x68e92449,0xd3700037}},	//   _dan_, _fogy, _zved, اهج_,
   {{0xc7b836a4,0x442736a5,0x925800c2,0x644a36a6}},	//   _nađi_, _ean_, дают_, _wofi,
   {{0x442736a7,0xe8050b95,0x644a36a8,0xe1ff36a9}},	//   _fan_, _रामा_, _tofi, rgó_,
   {{0x442736aa,0xa3df2014,0x628f36ab,0xd4c50037}},	//   _gan_, तरण_, soco, _أغني,
   {{0x764b36ac,0x2bdd0096,0x3f852ddc,0x626b00d2}},	//   _yogy, यरसा, çlu_, dřov,
   {{0x61ed36ad,0x442736ae,0x7c2700cd,0x2cb8152f}},	//   _udal, _zan_, _sajr, _aird_,
   {{0x442736af,0x6e940b26,0x60cd03ec,0xe1ff36b0}},	// [2b90] _yan_, титу, _utam, biór_,
   {{0x69c90126,0x4cc80081,0x442736b1,0x22990103}},	//   _sfee, _লিখু, _xan_, déki_,
   {{0x68e936b2,0xaca30134,0xa3df02d5,0x2ef400ae}},	//   _sved, _nrụb, तरत_, _изэр,
   {{0x5ba400d3,0xdd91212c,0xdb0e01f9,0x37d80033}},	//   труз, _موج_, áján, _সাগর,
   {{0x7c2702a1,0xe6ed0181,0xcce700e3,0xcdf60266}},	//   _tajr, _väčš, _تسجي, _אמרי_,
   {{0x07a50318,0xa15800ca,0x00000000,0x00000000}},	//   налн, ובדה_, --, --,
   {{0x442736b3,0x3eb936b4,0x2bae045f,0x661b01ce}},	//   _ran_, _kist_, झेदा, teuk,
   {{0x2d9900c2,0x1c100096,0x66c70233,0x68e90b81}},	//   _kyse_, ठ्ठल_, _cıka, _tved,
   {{0x68e90618,0x3eb936b5,0xe5790084,0x442736b6}},	//   _uved, _mist_, язи_, _pan_,
   {{0x3eb936b7,0x442736b8,0x98ad007e,0x00000000}},	//   _list_, _qan_, _kreč_, --,
   {{0x442736b9,0xe29a0aeb,0x2d9901df,0x3eb90270}},	//   _van_, зан_, _lyse_, _oist_,
   {{0x442736ba,0x00000000,0x00000000,0x00000000}},	//   _wan_, --, --, --,
   {{0xdb1c0222,0x442736bb,0x634a00a7,0x00000000}},	//   _ifrå, _tan_, lənl, --,
   {{0x442736bc,0x3eb9009c,0x6d4036bd,0x00000000}},	//   _uan_, _aist_, _àmai, --,
   {{0x3eb936be,0x66c7026a,0xa0a336bf,0x3229007b}},	//   _bist_, _yıka, уард, ötyä_,
   {{0x3eb936c0,0x2d9903a8,0x00000000,0x00000000}},	//   _cist_, _byse_, --, --,
   {{0x61e636c1,0x626b00b6,0x0d8600ae,0x6e9336c2}},	// [2ba0] makl, třov, хлан, القا,
   {{0x61e636c3,0xa3df0ff9,0x3eb936c4,0x4f2636c5}},	//   lakl, तरि_, _eist_, _здоб,
   {{0x09d700c7,0xb3460161,0x20c600de,0x6296010a}},	//   _হাজা, maçõ, _hôi_, _kkyo,
   {{0x2cb802d6,0xb346001f,0x61e636c6,0x320236c7}},	//   _wird_, laçõ, nakl, ngky_,
   {{0x626b02c6,0xa3df0c17,0xb4de00aa,0x00000000}},	//   přov, तरा_, _तबे_, --,
   {{0xeee700bf,0x20c60019,0xd6da09f2,0xb3460161}},	//   _تغیی, _môi_, пти_, naçõ,
   {{0xf0930105,0x20c600de,0x61e636c8,0x44dd0031}},	//   אנג_, _lôi_, kakl, eň_,
   {{0x96342249,0x629606b0,0x7e64024a,0x354636c9}},	//   тниц, _nkyo, nhip, ехов,
   {{0x06e004f1,0x61e62b0f,0x7afe36ca,0x20c60023}},	//   _गौरव_, dakl, lupt, _nôi_,
   {{0x54542de0,0x629636cb,0xdb1c023b,0x6d5636cc}},	//   твот, _akyo, _ngrë, iyya,
   {{0xb346016d,0x7e640201,0x66c70233,0x7afe078e}},	//   daçõ, khip, _tıka, nupt,
   {{0x20c600de,0xa75b0327,0xbddb0154,0x634a00a7}},	//   _bôi_, _מדבר, _inèg, səno,
   {{0x518436cd,0x7e6403a9,0x20c60023,0x3eb9300e}},	//   гура, dhip, _côi_, _rist_,
   {{0x3eb902ec,0xb34636ce,0x634a0092,0x20050103}},	//   _sist_, gaçõ, lənm, üli_,
   {{0x61f40212,0x5f95016d,0xe8120096,0x78ba042c}},	//   ådlö, тивт, ढ्या_, _mitv,
   {{0x78ba36cf,0x61e601e8,0x439b00a1,0x7e6436d0}},	//   _litv, cakl, _מבוג, ghip,
   {{0x3eb936d1,0x8d770bf4,0x442c0150,0x67020096}},	// [2bb0] _vist_, رارا, odd_, रंडक_,
   {{0x645a36d2,0xb3460396,0xe80509c3,0x3eb90126}},	//   nkti, caçõ, _राधा_, _wist_,
   {{0x442c36d3,0x2d99057a,0x443c007e,0x7afe0090}},	//   idd_, _wyse_, _mnv_, gupt,
   {{0x7d09020a,0x443c0381,0x98ad0141,0x200336d4}},	//   _ţesu, _lnv_, _vreč_, lgji_,
   {{0x6e3d01bf,0x26de36d5,0x20c60023,0x88c8004d}},	//   _insb, _awto_, _xôi_, елів_,
   {{0xa3bc1244,0x61e6062d,0x6e2d36d6,0xc7b800e7}},	//   _अलग_, zakl, ldab, _lađu_,
   {{0x7d0d36d7,0xddcd00d3,0x81e70033,0xdb1c01dc}},	//   ltas, ciaţ, _পান_, _ngrè,
   {{0x6e2d36d8,0xb34600c9,0x442c02e0,0x443c36d9}},	//   ndab, zaçõ, edd_, _anv_,
   {{0x12bd00c7,0x443c36da,0xc48500d6,0x2c640149}},	//   _আবেদ, _bnv_, клик, _född_,
   {{0x799b01c2,0x629d0313,0x443c36db,0x61e60063}},	//   _iyuw, elso, _cnv_, wakl,
   {{0x61e636dc,0x7d0d36dd,0x20c600de,0xb3460161}},	//   takl, htas, _sôi_, vaçõ,
   {{0x27e736de,0x7d0d36df,0x443c36e0,0x6e2d023e}},	//   lann_, ktas, _env_, jdab,
   {{0xb3460396,0x61e636e1,0x6e2d008a,0x443c36e2}},	//   taçõ, rakl, ddab, _fnv_,
   {{0x27e70080,0x7d0d01c5,0x10a633d6,0x61e636e3}},	//   nann_, dtas, тигн, sakl,
   {{0xb3460396,0xdee31693,0xafe30070,0x7e6436e4}},	//   raçõ, иори, росл, thip,
   {{0x20c600ef,0x27e736e5,0xdcf402ef,0x6d440a00}},	//   _tôi_, hann_, žačk, txia,
   {{0x7d0d2783,0x799b00bf,0xdbdf003e,0x614636e6}},	// [2bc0] gtas, _nyuw, tíði, _репа,
   {{0x61e423ff,0xe3b80740,0x3f9a1670,0x27e702f1}},	//   _heil, mdır_, _typu_, jann_,
   {{0xbddb36e7,0x27e736e8,0x09e636e9,0x61e436ea}},	//   _poèt, dann_, воен, _keil,
   {{0x6aa936eb,0x7afe36ec,0x60c40010,0x6abb36ed}},	//   _chef, rupt, _kuim, _ciuf,
   {{0x442c1a2e,0xe3b8008e,0x27e736ee,0x645a05e8}},	//   ydd_, ndır_, fann_, ykti,
   {{0xcee914df,0x27e736ef,0x61e436f0,0x60c436f1}},	//   _ترین_, gann_, _leil, _muim,
   {{0x8a0628b9,0xa7fc0587,0xb8c90ccb,0x60c40076}},	//   _изве, _alıc, _गी_, _luim,
   {{0xfaa636f2,0x61e436f3,0x442c02ad,0x765b019c}},	//   _рабо, _neil, wdd_, gkuy,
   {{0xd3781419,0x27e736f4,0x47e10081,0x090619e8}},	//   maći_, bann_, _নারী, _шпан,
   {{0x78ba04ee,0xdb1c0257,0x27e7033f,0x6b9c36f5}},	//   _uitv, _agré, cann_, _kyrg,
   {{0x442c02e0,0x7d0d36f6,0x2c140789,0xa2b500e5}},	//   rdd_, ztas, न्यू_, лбоч,
   {{0xd378084f,0x7d0d36f7,0x442a0087,0x645a36f8}},	//   naći_, ytas, žb_, skti,
   {{0x61e436f9,0x60c410f0,0xd2510018,0x46130281}},	//   _deil, _cuim, لنگ_, _خونر,
   {{0xa2ca167f,0x645d023b,0x394636fa,0xe5a31c3e}},	//   _संप्, ësit, ixos_, _тичи,
   {{0x61e436fb,0x260f13ae,0x2003023b,0x3ce8009f}},	//   _feil, थ्वी_, rgji_, _चौबे_,
   {{0x7d0d32a7,0x61e436fc,0x60c436fd,0x22990094}},	//   ttas, _geil, _fuim, téku_,
   {{0x60c436fe,0x16df121d,0xf1c40094,0xd3780357}},	// [2bd0] _guim, _नब्ब, ášť_, daći_,
   {{0x7d0d36ff,0xbbdd0455,0x61e43700,0x6aa93701}},	//   rtas, यरेक, _zeil, _shef,
   {{0x27e73702,0xddc600a5,0x3946002b,0xd9f93703}},	//   vann_, _dokł, exos_, енец_,
   {{0x27e73704,0xa2ca167f,0x99d40190,0x00000000}},	//   wann_, _संन्, لتها, --,
   {{0x27e73705,0xee3f0181,0xe9d801b3,0xa3e300a3}},	//   tann_, _iný_, ткі_, _फजल_,
   {{0xfa230081,0x6b9c3706,0x00000000,0x00000000}},	//   ফাইল_, _fyrg, --, --,
   {{0x27e73707,0x12bd0081,0xe3b8008b,0x6aa93708}},	//   rann_, _আব্দ, zdır_, _thef,
   {{0x27e73709,0xddcd0029,0x060914fb,0xf6250e3a}},	//   sann_, skaņ, хник_, удио,
   {{0x27e7370a,0x61e4370b,0x3a3f0124,0xe6160c5f}},	//   pann_, _reil, _inup_, уды_,
   {{0x60c404ee,0x61e4370c,0xe3e30033,0x765b0124}},	//   _ruim, _seil, _মাহব, skuy,
   {{0x91e6370d,0x60c4370e,0x212923b0,0x65690103}},	//   лоне, _suim, _asah_, szeh,
   {{0x94030022,0xe3b800a7,0x00000000,0x00000000}},	//   ƙƙoƙ, tdır_, --, --,
   {{0x61e4370f,0x645d01e5,0x290f0324,0xc6922252}},	//   _veil, ësis, ntga_, _פאד_,
   {{0xe3b80702,0x26c53710,0x61e43711,0x99dd00d2}},	//   rdır_, _kulo_, _weil, _koňs,
   {{0x61e43712,0x21290063,0x9975007f,0x26c50af0}},	//   _teil, _esah_, nęło_, _julo_,
   {{0xa2060eea,0x26c53713,0x6fd4014e,0x60c43714}},	//   _спид, _mulo_, _ब्रू, _tuim,
   {{0x0eb90963,0x22400383,0x4c863715,0xe3b80092}},	// [2be0] туры_, _inik_, глав, qdır_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xd37803d6,0x22400abf,0xfaa60284,0x00000000}},	//   taći_, _knik_, гажо, --,
   {{0x1efb0341,0xc9860c59,0x2cb000c6,0x3ce805cd}},	//   _אלטע, лули, _žodį_, _चौथे_,
   {{0xed57036a,0xf9920308,0xd37814f3,0x00000000}},	//   _боя_, حبا_, raći_, --,
   {{0x3ea03716,0x66c70b88,0xf7720068,0xf72a004c}},	//   llit_, _tıkl, یاں_, еций_,
   {{0x26c53717,0xb8eb0c9c,0xd378037d,0x224001c8}},	//   _culo_, _रू_, paći_, _onik_,
   {{0x7c2e3718,0x26c50bb6,0x3ea0003e,0x09de0033}},	//   _habr, _dulo_, nlit_, _ডাকা,
   {{0x59863719,0x634a01d4,0x7c2e371a,0x270e0092}},	//   _слаб, məni, _kabr, _məni_,
   {{0x634a0092,0xd91b0089,0x245200ae,0x38a90206}},	//   ləni, _אומל, _câmp_, túre_,
   {{0x3ea0371b,0x7c2e1606,0x36060602,0x26c5371c}},	//   klit_, _mabr, _مواف, _gulo_,
   {{0x7c2e371d,0x21b500d6,0xa2950426,0xdbdf003e}},	//   _labr, ийня, рамі, _líðu,
   {{0x667b00c1,0x463b006e,0x3ea0371e,0x26c50634}},	//   _אטאק, _רעדע, dlit_, _zulo_,
   {{0x224000e7,0xe1ff0328,0x3e6700aa,0x5334371f}},	//   _enik_, chón_, _mõte_, _вект,
   {{0xe7f7143d,0x442e0149,0x634a0092,0x316b3720}},	//   ीलता_, _iaf_, kəni, szcz_,
   {{0x3ea03721,0x442e3722,0xddcd3723,0x2bdd0d7a}},	//   glit_, _haf_, snaž, यर्थ,
   {{0x3cee0067,0x634a01d4,0x21290655,0x442e3724}},	// [2bf0] ेंगे_, dəni, _usah_, _kaf_,
   {{0x442e3725,0x3ea009d6,0x9f4300b6,0x3a3f02b6}},	//   _jaf_, alit_, lají_, _snup_,
   {{0x2baa02e8,0x3ea03726,0x7c2e3727,0xbb840037}},	//   _करणा, blit_, _dabr, ملكي,
   {{0x27e50b14,0x9f4300b6,0x7c2e009c,0x442e3728}},	//   _seln_, nají_, _eabr, _laf_,
   {{0x7c2e3729,0xd3780106,0xd945372a,0x00000000}},	//   _fabr, maću_, рели, --,
   {{0x46f52e81,0x442e372b,0x26c5372c,0x2c142010}},	//   ачит, _naf_, _pulo_, न्दू_,
   {{0xf7710fba,0x3669372d,0x270e0092,0x9f4300b6}},	//   غات_, како_, _yəni_, kají_,
   {{0x7c2e11d5,0xbb840080,0x2baa02e8,0x7ae300d3}},	//   _zabr, _الفي, _करता, ântu,
   {{0x81eb0081,0x9f43030b,0x98b9372e,0x6e2f372f}},	//   মলা_, dají_, _алат_, _macb,
   {{0x26c53730,0xd3781528,0xf8b91f11,0x7c2e002b}},	//   _tulo_, haću_, _شهاب_, _xabr,
   {{0x03a50d9b,0xd37809ac,0x53a5016d,0x383400d3}},	//   рино, kaću_, ранб, _ынфр,
   {{0x67b80192,0xcb1200ca,0xd378007e,0x00000000}},	//   _صالح_, חלט_, jaću_, --,
   {{0xd3780995,0x04453283,0x00000000,0x00000000}},	//   daću_, _велн, --, --,
   {{0x442e3731,0x05a800d6,0x270e0092,0xad9b0037}},	//   _gaf_, _свій_, _səni_, _gcúi,
   {{0x634a0092,0xdee63732,0x3ea03733,0xa2a70096}},	//   yəni, роби, tlit_, _टीव्,
   {{0xdbdf0102,0x22403734,0x3f8c003d,0x3ea03735}},	//   _síðu, _unik_, ħdu_, ulit_,

   {{0x3ea00088,0x7c2e3736,0x645c3737,0x37e60033}},	// [2c00] rlit_, _pabr, örig, _নাসর,
   {{0xa7fc0702,0x3ea03738,0x7c2e0188,0x2baa00aa}},	//   _alın, slit_, _qabr, _करदा,
   {{0x62870074,0xf1a9001c,0x634a0092,0xd37809ac}},	//   čkov, _لایه_, təni, baću_,
   {{0xeb973739,0x6286373a,0x2c640149,0x3e7f007b}},	//   ших_, nnko, _döda_, rätä_,
   {{0x7c2e373b,0x634a00a7,0x93bc00ae,0x3e7f00c2}},	//   _tabr, rəni, ndăr, sätä_,
   {{0x7d043589,0xceb40092,0x2c640212,0x634a00a7}},	//   muis, lmə_, _föda_, səni,
   {{0x7d04373c,0xa2ca03a2,0x368a0ef1,0x81e70033}},	//   luis, _संध्, ксин_, _পাস_,
   {{0x2bd20ded,0x442e373d,0x95d700e5,0xceb4013c}},	//   दुरा, _saf_, адът_, nmə_,
   {{0x9f43030b,0x7d04373e,0x00000000,0x00000000}},	//   vají_, nuis, --, --,
   {{0x6286373f,0xb80600cd,0x6e2401bf,0x442e3740}},	//   enko, _خبره, heib, _qaf_,
   {{0x7d043741,0x22920094,0x9f4302c6,0x43940859}},	//   huis, láky_, tají_, санс,
   {{0x7d043742,0x442e3743,0x62860b81,0x00000000}},	//   kuis, _waf_, gnko, --,
   {{0x442e1599,0x7d043744,0x61f602ad,0xe4d409e5}},	//   _taf_, juis, _ddyl, _اقتد,
   {{0x03770260,0x7d043745,0x251b0089,0x62863746}},	//   احیت_, duis, _סווא, anko,
   {{0xf0b400d6,0xe80e00b6,0x6aa23747,0x1df90fe9}},	//   ійсь, _साना_, klof, левы_,
   {{0x2c640149,0xdce601e8,0x5f943748,0x00000000}},	//   _röda_, _aykı, цист, --,
   {{0x7d043749,0xd90412eb,0xa2ca1687,0xd378042d}},	// [2c10] guis, _تی_, _सूत्, raću_,
   {{0x38a9374a,0x80dd0033,0xd3780e94,0x2292023c}},	//   kúra_, _বিপ্, saću_, dáky_,
   {{0x5b151087,0x76420172,0x00000000,0x00000000}},	//   смет, _onoy, --, --,
   {{0x7d04374b,0xe8f500e3,0x3d0702d5,0x00000000}},	//   buis, مستخ, िंदे_, --,
   {{0x3cfe0067,0x7d04374c,0x8d840e1d,0xb7c30231}},	//   _लिये_, cuis, _дурд, çãoz,
   {{0xf1bf0103,0x26d90094,0x2bcb0450,0xd3662164}},	//   ldás_, _čsob_, _шумо_, _فه_,
   {{0xda351ad1,0x62860034,0x9986374d,0x81bf0033}},	//   _левы, ynko, rdoš_, েরি_,
   {{0x7c25374e,0xf1bf01f9,0x229200d4,0x80dd0033}},	//   lehr, ndás_, báky_, _বিন্,
   {{0x78bd0036,0x673a0f5a,0x229200d4,0x2aff074c}},	//   _èsvo, _ertj, cáky_, शंकु_,
   {{0xb46502fd,0x98650018,0x81bf0033,0x6e24374f}},	//   скол, _دیتے_, েরা_, zeib,
   {{0x6e243750,0x673a0381,0x60d63751,0x00000000}},	//   yeib, _grtj, _stym, --,
   {{0x99800038,0x628601e9,0x201a0063,0x17680b9e}},	//   žiť_, unko, _sbpi_, _труп_,
   {{0xf65200a1,0xd5480adb,0x7c250364,0x62860b84}},	//   _מצא_, _نجوم_, kehr, rnko,
   {{0x753600c1,0x1c0305a7,0x75293752,0x66093753}},	//   _לאנד_, _लागल_, mwez, lgek,
   {{0x64433754,0x44253755,0xceb40092,0x81e70033}},	//   _inni, mel_, tmə_, _পার_,
   {{0x66093756,0x7d040423,0xf1d10179,0x75290a4b}},	//   ngek, tuis, थुआन, owez,
   {{0x75290ab2,0x6e243757,0x291f006c,0xceb40092}},	// [2c20] nwez, reib, _npua_, rmə_,
   {{0x22920146,0xa3ab1fbb,0x7c250364,0xc006186d}},	//   váky_, _खरा_, gehr, _упок,
   {{0x291f0084,0x7d043758,0x75293759,0x201813ea}},	//   _apua_, suis, hwez, mfri_,
   {{0x4425375a,0x22920146,0x7d041c1e,0x75290201}},	//   hel_, táky_, puis, kwez,
   {{0x4425375b,0x64430084,0x2baa02b0,0x660904e2}},	//   kel_, _onni, _करवा, dgek,
   {{0xbb460978,0xd90d00d0,0x38a9375c,0x200a375d}},	//   _легк, ئیل_, túra_, ngbi_,
   {{0xe80e1349,0xf1bf0220,0xf1c80e19,0x6aa20f5a}},	//   _साठा_, ndár_, रखान, plof,
   {{0x4425043e,0x660902f9,0x6443375e,0x26ca0131}},	//   eel_, ggek, _anni, _ébom_,
   {{0x4425375f,0x89663760,0xd90d0504,0x96170037}},	//   fel_, _укаж, _لین_, صغير_,
   {{0xe8d700ca,0x29060a4b,0x00000000,0x00000000}},	//   _לומר_, muoa_, --, --,
   {{0xf7433761,0xdb0e0065,0x2f380383,0x9f4a00d1}},	//   _нефо, _igbó, _nčg_, babé_,
   {{0x32670b57,0x64433762,0x466900d6,0x21200167}},	//   стов, _enni, _крім_, _bpih_,
   {{0x44253763,0x2018003d,0x9f4100b3,0x752904ff}},	//   bel_, ffri_, _vehí_, cwez,
   {{0x44253764,0x27ee003e,0x2e350134,0xe81b0296}},	//   cel_, nafn_, _ụf_, प्पा_,
   {{0x447b00ca,0x00000000,0x00000000,0x00000000}},	//   _תנוע, --, --, --,
   {{0x7c250364,0x62870094,0x2906024a,0x00000000}},	//   wehr, čkos, kuoa_, --,
   {{0xa7fc026a,0x463b00c1,0xdb1c0428,0xdc550291}},	// [2c30] _alım, נעמע, _agrà, овањ,
   {{0x61ef0e2a,0xba3d00b6,0x00000000,0x00000000}},	//   lacl, _lhůt, --, --,
   {{0x50d40068,0x212b02ad,0x99d700e3,0xfbab00c6}},	//   _وزیر, lwch_, متشا, утай_,
   {{0x44253765,0x61ef3766,0xdb0e0af0,0x00000000}},	//   zel_, nacl, _agbó, --,
   {{0x44253767,0x212b0150,0xa2bc006e,0xfbe80033}},	//   yel_, nwch_, אמאט, _পারত,
   {{0xf9902ce3,0x7e6d2c70,0xb901007a,0x00000000}},	//   ربن_, lhap, _दऽ_, --,
   {{0x44253768,0x2bdf0e4c,0xb8d005cd,0x66090db1}},	//   vel_, _प्या, _टी_, tgek,
   {{0x44253769,0x0f7c00a1,0xd04d03e3,0x7e6d376a}},	//   wel_, טרול, _kwaɓ, nhap,
   {{0x4425376b,0x66092d6d,0x61ef0072,0x20181307}},	//   tel_, rgek, dacl, yfri_,
   {{0x66090f7a,0x212b0150,0x752901c0,0x44251aab}},	//   sgek, dwch_, rwez, uel_,
   {{0x44250fd1,0x7e6d376c,0x224a0161,0x634a013c}},	//   rel_, khap, апни_, dəns,
   {{0x4425376d,0xd6ab2c66,0x2f3805aa,0x00000000}},	//   sel_, _صدام_, _rčg_, --,
   {{0xa4f709b4,0x7e6d00d1,0x212b00f0,0x00000000}},	//   _اکبر_, dhap, gwch_, --,
   {{0x64430088,0x316c007f,0x00000000,0x00000000}},	//   _unni, ądz_, --, --,
   {{0xe81b0096,0x1fb5376e,0xa0a3376f,0x749a021e}},	//   प्या_, зстр, фард, _דיספ,
   {{0x00ca11f8,0x7bd5029a,0x7e6d243d,0xf1bf0072}},	//   _клик_, _afzu, ghap, meán_,
   {{0x63a302ad,0xf1bf00e3,0xec7a2657,0x6da30bb4}},	// [2c40] _hynn, leán_, апа_, дита,
   {{0x63a33770,0x67210039,0x0c2300c2,0x3e6700aa}},	//   _kynn, _oplj, ммун, _võta_,
   {{0x49ca0fa5,0xdb0e0065,0x7e6d0201,0xddc4020a}},	//   ален_, _agbò, bhap, ghiţ,
   {{0x7e6d3771,0x63a33772,0x09e30396,0x6d4d008c}},	//   chap, _mynn, доцн, bxaa,
   {{0xb5fd0031,0x67d40379,0x522d0142,0x00000000}},	//   chši, полу, טואַ, --,
   {{0x6e36013f,0x3a260167,0x00000000,0x00000000}},	//   ldyb, seop_, --, --,
   {{0xdb0e0032,0x7d163773,0x61ef013c,0x63a313ea}},	//   _egbò, ltys, yacl, _nynn,
   {{0x6e363774,0xf1bf00e3,0x27ee0088,0x7bc7023b}},	//   ndyb, deán_, safn_, _zgju,
   {{0xceb3040a,0x7d163775,0x63a3026d,0x7afa04c8}},	//   ויה_, ntys, _aynn, _ættb,
   {{0x31e3009d,0x63a30150,0xc8660037,0xb8660dd0}},	//   पर्ध, _bynn, _بطري, _بارو,
   {{0x63a302e0,0x61ef3776,0xe3b8026a,0x7e6400c2}},	//   _cynn, tacl, ldız_, kkip,
   {{0x212b0150,0x63b50146,0x63a300f0,0x00000000}},	//   twch_, ýzna, _dynn, --,
   {{0xa2ca04a9,0x26cc3777,0x61ef0d54,0x00000000}},	//   _सूर्, _hudo_, racl, --,
   {{0x80dd00c7,0x26cc023b,0x212b0150,0x61ef028d}},	//   _বিদ্, _kudo_, rwch_, sacl,
   {{0x63a302e0,0x8f343778,0x7e6d3779,0x64580036}},	//   _gynn, мерц, thap, _iovi,
   {{0x26cc0188,0x645813a2,0xa195036c,0x60dd1a88}},	//   _mudo_, _hovi, _найч, ppsm,
   {{0x6458377a,0x7e6d377b,0xa3b600b6,0x00000000}},	// [2c50] _kovi, rhap, चेर_, --,
   {{0x6458031a,0x61ed377c,0x7e6d377d,0xc8a900c3}},	//   _jovi, _heal, shap, _चींट,
   {{0x6458377e,0x7e6d377f,0x61ed02e7,0x26cc3780}},	//   _movi, phap, _keal, _nudo_,
   {{0x64583781,0x60cd0010,0xf1af0557,0x7e640312}},	//   _lovi, _kuam, _घरान, ckip,
   {{0xcfbd0081,0x6d4b0149,0x60cd3782,0xa3ca030b}},	//   _অভিন, ågad, _juam, लखा_,
   {{0x61ed3783,0x26cc3784,0xd5e20139,0xdced0094}},	//   _leal, _budo_, _alò, nzač,
   {{0x26cc0580,0x25a90660,0xad9b0037,0x9a870077}},	//   _cudo_, _šal_, _gcúr, _дуал,
   {{0xdb1c0018,0x26cc034f,0x629d0850,0x7c353785}},	//   _ugrá, _dudo_, joso, _hazr,
   {{0x63a33786,0x656000f0,0x69c93787,0x49040037}},	//   _synn, gymh, _igee, _يوفق,
   {{0x68e90134,0x26cc3788,0xf1bf0037,0x1309007b}},	//   _iwed, _fudo_, teán_, бной_,
   {{0x61ed3789,0x7c35378a,0x6458378b,0xbddb00ee}},	//   _beal, _mazr, _dovi, _anèm,
   {{0xf1bf00e3,0x61ed378c,0x66d70134,0x7d1600c2}},	//   reán_, _ceal, _ụkwa, ytys,
   {{0xf1bf00e3,0x61ed378d,0x60cd009c,0x63a3378e}},	//   seán_, _deal, _cuam, _wynn,
   {{0x653a00c1,0x63a3378f,0x7c353790,0x09a90034}},	//   _לענד, _tynn, _nazr, _औरैय,
   {{0x629d20bb,0x69c93791,0x61ed3792,0xbbaa149b}},	//   boso, _ogee, _feal, _करेक,
   {{0x61ed0091,0x6458015c,0x644600d9,0x69c907f5}},	//   _geal, _zovi, ēkie, _ngee,
   {{0xf1bf00e3,0x60cd00dc,0x6458039f,0x7d160381}},	// [2c60] neál_, _guam, _yovi, utys,
   {{0x7e643793,0x69c906b0,0xeb9a0231,0x61ed3794}},	//   skip, _agee, биз_, _zeal,
   {{0xe8052065,0x7d163795,0x6d4b0149,0x68e93796}},	//   _राजा_, stys, ägar, _awed,
   {{0x765900a5,0x60cd023e,0x0ae90037,0xdce40a39}},	//   _nowy, _yuam, تركي_, jzić,
   {{0x7c350063,0x63a60034,0x00000000,0x00000000}},	//   _fazr, ękni, --, --,
   {{0xb8f41cd4,0x26cc0890,0xa3ab0096,0x2bdb261e}},	//   _सं_, _pudo_, _खरं_, मुदा,
   {{0x7522138c,0x629d3797,0xd6d70ae3,0x25c10092}},	//   _spoz, yoso, пты_, ərlə_,
   {{0x80dd00c7,0xfaa300d6,0xb17b01df,0x69c90172}},	//   _বিস্, _засо, dbån, _ggee,
   {{0x64583798,0x68e90150,0xb5fd01d3,0xf64f0037}},	//   _povi, _gwed, ukša, ائى_,
   {{0x26cc00c9,0x7d043799,0xb5fd01d3,0x61ed379a}},	//   _tudo_, iris, rkša, _seal,
   {{0x61ed05a7,0x60cd06ee,0xe61a0c43,0x7d04008a}},	//   _peal, _suam, _где_, hris,
   {{0x7d04379b,0xad9b002b,0xbddb02f1,0x60cd0154}},	//   kris, _ocúp, _enèj, _puam,
   {{0xf48705bc,0xe5342c37,0x386c02c6,0x645813a2}},	//   _کانی, _цель, _kldr_, _tovi,
   {{0x629d379c,0x7d04379d,0x61e0008b,0x55bb0327}},	//   soso, dris, ımla, _המדו,
   {{0xda0d05d4,0x25af379e,0x60c500aa,0x26c60239}},	//   _हालत_, _zzgl_, _vihm, _kioo_,
   {{0x7d04379f,0x7c350335,0x60cd37a0,0xe0df028d}},	//   fris, _sazr, _tuam, ppò_,
   {{0xe7cc007d,0x22490181,0x82341f11,0x786f004d}},	// [2c70] ाशाप, _inak_, _سريا, _høve,
   {{0xdfd10037,0xdb1c02c3,0x00000000,0x00000000}},	//   _جيد_, _ogrä, --, --,
   {{0xaac70a09,0x7d0437a1,0xde59004d,0x78bd0036}},	//   ستان, aris, _дані_, _èsvi,
   {{0x7d0437a2,0x7d180080,0x68e900a6,0x37e60081}},	//   bris, éasá, _pwed, _নাগর,
   {{0x20d300c3,0x3ea90212,0x786f01df,0x2616007a}},	//   _धूमध, mlat_, _løve, _भउजी_,
   {{0x3ea937a3,0xad9b0065,0x013800a1,0xc7a500d6}},	//   llat_, _adúg, פרות_, милк,
   {{0xe80e034c,0x12c70081,0x765937a4,0xb8f40b95}},	//   _सारा_, _শব্দ, _powy, _सू_,
   {{0xd8770979,0x645c37a5,0x386c0090,0x7afa01cd}},	//   _کارب, örin, _eldr_, _ætta,
   {{0xbddb022b,0xddcd0138,0xdce40a39,0x661b1088}},	//   _anèk, kiaž, rzić, rfuk,
   {{0x224937a6,0x2a6d37a7,0x25a60383,0x3ea9007b}},	//   _anak_, _hleb_, _dyol_, hlat_,
   {{0x3ea90484,0xa22a37a8,0x04ff0033,0x80dd0033}},	//   klat_, ожна_, ্বের_, _বিষ্,
   {{0x7d040088,0x1fc50081,0x2a6d0167,0xd04d37a9}},	//   yris, ্রাস, _jleb_, _kwaɗ,
   {{0x3ea937aa,0x66c7026a,0xbbaa09a0,0x13a700d1}},	//   dlat_, _fıkr, _कर्क, تنگی_,
   {{0x80dd0f71,0x224937ab,0x63850c58,0x7d0437ac}},	//   _বিশ্, _enak_, _огла, vris,
   {{0xe29f0088,0x4f9537ad,0x8fa301a0,0x3ea937ae}},	//   boð_, ерту, варе, flat_,
   {{0xe1ff1515,0xecea1bc1,0xe058001c,0x00000000}},	//   lkón_, ждал_, _کیست_, --,
   {{0x32d30028,0xe80e10e9,0xd12f001c,0xbea337af}},	// [2c80] _hãy_, _साला_, _نمي_, татк,
   {{0x645700b3,0x3ea900ee,0x3cf90131,0x3ac8013c}},	//   _òxid, alat_, _dvsv_, _aşpa_,
   {{0x3ea937b0,0x00000000,0x00000000,0x00000000}},	//   blat_, --, --, --,
   {{0x7d040b87,0xaca40174,0x3ea90428,0x224900dc}},	//   pris, _inọr, clat_, _xnak_,
   {{0x20d41d2d,0xaac5001c,0xbdfb0281,0x2bdf055c}},	//   _jäi_, رتمن, _برپا_, _प्वा,
   {{0xd6da37b1,0xbddb0113,0x186726d0,0x4c350012}},	//   оти_, _anèh, мачи_, _пэст,
   {{0xdca31728,0x32d30023,0x7a240154,0xdc370142}},	//   _рари, _nãy_, _pčtč, _קאלט_,
   {{0xa3c30851,0xa5341693,0x786f0f04,0x3ea037b2}},	//   ्शन_, енич, _røve, noit_,
   {{0x64c837b3,0x26c60a4b,0x6d4000d8,0x00000000}},	//   रदेश, _vioo_, _šmaj, --,
   {{0x83860077,0x22491e8d,0x80dd0033,0x25a60154}},	//   дыме, _snak_, _বিল্, _vyol_,
   {{0xd37a00d6,0x22490113,0x00000000,0x00000000}},	//   ючи_, _pnak_, --, --,
   {{0x05660012,0x32d30023,0xb5fd00c6,0x475900ae}},	//   _овен, _dãy_, nkšl, _эруя_,
   {{0xa2ca000c,0x3ea937b4,0xaca40134,0xd8380141}},	//   _संक्, vlat_, _anọr, _kač_,
   {{0xdbf307aa,0x9f430220,0x961d01d3,0x29060072}},	//   _işçi, majú_, miņa, iroa_,
   {{0x442c37b5,0xc0580f1e,0x4908009f,0xd838042d}},	//   med_, фія_, _समझो_, _mač_,
   {{0x442c37b6,0x3ea937b7,0xd8380154,0xc1150da5}},	//   led_, ulat_, _chčz_, _змиј,
   {{0x442c0150,0x9f430031,0x865b00ca,0xdfd50ae3}},	// [2c90] oed_, najú_, קדמי, _попы,
   {{0x3ea9030b,0xb5fd01d3,0x290637b8,0xa1f90103}},	//   slat_, ekšl, droa_, _بڑھا_,
   {{0x2a6d023e,0x9f4337b9,0x5ba70ed7,0x29062c6f}},	//   _pleb_, hajú_, фраз, eroa_,
   {{0x442c37ba,0xdd140038,0x9f430220,0x22990146}},	//   hed_, _súťa, kajú_, téky_,
   {{0x26de008f,0x442c37bb,0xf1a50557,0x644a02ac}},	//   _atto_, ked_, _गुमन, _onfi,
   {{0x442c37bc,0x7d0d063f,0x9f430220,0x201137bd}},	//   jed_, muas, dajú_, ngzi_,
   {{0x442c004f,0x7d0d37be,0x46a5261f,0x626b01c2}},	//   ded_, luas, накв, nƙos,
   {{0xbb4800bf,0x2a7f03a9,0x442c01ee,0x290601ff}},	//   _تلفن_, _umub_, eed_, broa_,
   {{0x442c37bf,0x2bc30b94,0x79a707c8,0x7d0d00da}},	//   fed_, _वृता, _црве, nuas,
   {{0xe4510080,0x442c37c0,0x3ea00167,0x291a00ae}},	//   اضة_, ged_, zoit_, ăpat_,
   {{0xe28609b9,0x4e0f030b,0x7d0d37c1,0x69c400c6}},	//   елни, िलाई_, huas, žiet,
   {{0x7d0d048e,0x644a37c2,0x9f4337c3,0x442c00bc}},	//   kuas, _enfi, bajú_, aed_,
   {{0x764b0068,0x3e6e003e,0x442c37c4,0x3ea037c5}},	//   _ingy, _nýta_, bed_, voit_,
   {{0x2bdf097c,0x442c260b,0xa2ca18ff,0xa06a013f}},	//   _प्ला, ced_, _सूक्, чага_,
   {{0x3ea00e22,0x62580131,0x00000000,0x00000000}},	//   toit_, _mãoz, --, --,
   {{0x6e2d37c6,0x7d0d0051,0xbea32972,0x68fb010a}},	//   geab, fuas, гаск, _ovud,
   {{0x628637c7,0x3ea037c8,0x7d0d37c9,0x1c460f80}},	// [2ca0] miko, roit_, guas, ннам,
   {{0x628637ca,0x69db37cb,0xc19b0327,0x3ea000fc}},	//   liko, _afue, _משפי, soit_,
   {{0x9f430220,0x961d00d9,0xb5fd01d3,0x68fb0361}},	//   zajú_, ziņa, ekšm, _avud,
   {{0xfce637cc,0x628637cd,0x442c37ce,0x290637cf}},	//   _помо, niko, zed_, troa_,
   {{0xa967123a,0xd83802dd,0xaca40294,0x442c37d0}},	//   ница_, _pač_, _arụs, yed_,
   {{0x9f430181,0x628637d1,0x29060a00,0x442c00a1}},	//   vajú_, hiko, rroa_, xed_,
   {{0x628637d2,0x442c0054,0x7bce37d3,0x68fb06b0}},	//   kiko, ved_, _igbu, _evud,
   {{0x442c37d4,0x628637d5,0x9f430031,0x68e20668}},	//   wed_, jiko, tajú_, ppod,
   {{0x442c004f,0x628637d6,0xdb1c0076,0xf09f00b3}},	//   ted_, diko, _ngrú, dràn_,
   {{0x6aa201a2,0x9980013f,0x9f430220,0x764b37d7}},	//   loof, žių_, rajú_, _engy,
   {{0x442c37d8,0x628637d9,0xdb1c002b,0x7bce0134}},	//   red_, fiko, _agrú, _mgbu,
   {{0x442c37da,0x628637db,0x99890220,0x961d00e8}},	//   sed_, giko, žať_, piņa,
   {{0x442c00a1,0x7bce37dc,0x7bdc0052,0x38c60139}},	//   ped_, _ogbu, _ofru, _gírì_,
   {{0x741300cd,0x6aa201d0,0x41a500b6,0xc0581536}},	//   _موها, hoof, _गुणस, ніс_,
   {{0x02a737dd,0x5334117a,0x62860ab1,0xc90d030b}},	//   _прим, _рейт, biko, _सम्म_,
   {{0x7bce37de,0x7d0d37df,0x7bdc37e0,0x628637e1}},	//   _agbu, tuas, _afru, ciko,
   {{0x6e2d1c5d,0xbbeb0037,0x9f4a0131,0x7e62007b}},	// [2cb0] reab, كرام_, rabá_, öopa,
   {{0x6e2d37e2,0x21290167,0xf8b80023,0xed040103}},	//   seab, _ipah_, _nhĩ_, اولپ,
   {{0x68fb0039,0x20010188,0x7d0d024a,0x7afc0128}},	//   _svud, _idhi_, suas, _cvrt,
   {{0x7d0d063f,0x7bce0129,0x636b0103,0x212900de}},	//   puas, _egbu, lönö, _kpah_,
   {{0x7d0d0036,0xb5fd00c6,0x5fd5142e,0x62580231}},	//   quas, ukšm, _दलाल, _pãoz,
   {{0x628637e3,0x00000000,0x00000000,0x00000000}},	//   ziko, --, --, --,
   {{0x62862767,0xdb1505aa,0x394400b3,0xa6951009}},	//   yiko, _egzò, _erms_, криј,
   {{0x628637e4,0xf1650032,0x212937e5,0x6edc033b}},	//   xiko, _ayọ̀_, _opah_, _učbe,
   {{0x58d500d6,0x69c437e6,0x62860f06,0xa2cb0bf5}},	//   _розт, žier, viko, _संज्,
   {{0x446531f6,0x2bb80378,0x58d408c3,0x290f37e7}},	//   твов, _अरमा, _софт, muga_,
   {{0xe29a37e8,0x628637e9,0xfbd20054,0x63aa02ad}},	//   дан_, tiko, יתי_, _cyfn,
   {{0x200137ea,0x63aa0178,0x00000000,0x00000000}},	//   _adhi_, _dyfn, --, --,
   {{0x628637eb,0xa56400e3,0x290f37ec,0x867a00d7}},	//   riko, _مدون, nuga_, _קרנו,
   {{0x291d0051,0x290f058f,0xe804007f,0x00000000}},	//   itwa_, iuga_, रणया_, --,
   {{0x8fa6016e,0x63aa0150,0x290f37ed,0xb21b08ca}},	//   таве, _gyfn, huga_, rnær,
   {{0x7bdc37ee,0x291d06a3,0x290f00aa,0x2bb802d5}},	//   _sfru, ktwa_, kuga_, _अरबा,
   {{0xc5f2193b,0x290f37ef,0x6f1c00d8,0x6284007f}},	// [2cc0] ידן_, juga_, strc, _imio,
   {{0x20040138,0x1f6637f0,0xf0ba0504,0xa2d800b6}},	//   ėmis_, _аком, _تابش_, _नंम्,
   {{0x78a337f1,0xdbde0139,0x00000000,0x00000000}},	//   donv, _bíòd, --, --,
   {{0x290f0517,0xe8df0134,0xc98637f2,0x00000000}},	//   fuga_, _erọn_, кули, --,
   {{0x6aa237f3,0x290f37f4,0x78a337f5,0x00000000}},	//   roof, guga_, fonv, --,
   {{0x7afc37f6,0xa3c30f53,0xa7fc0511,0x3a240124}},	//   _tvrt, ्शा_, _alır, _wbmp_,
   {{0x7c3c0fab,0x6d460995,0x39440131,0x7afc09ac}},	//   _iarr, _hrka, _wrms_, _uvrt,
   {{0x290f3289,0x6d4602ef,0x7c3c293f,0x3e6e00d4}},	//   buga_, _krka, _harr, _mýto_,
   {{0x7c3c37f7,0x291d0034,0x08c60792,0xe60f001c}},	//   _karr, ctwa_, _абан, زشي_,
   {{0x7c3c03f3,0x628437f8,0x25e20789,0x6d46007e}},	//   _jarr, _amio, _ट्री_, _mrka,
   {{0x7c3c377b,0xd25112eb,0xd7a9152c,0x64a30396}},	//   _marr, مند_, _चुपच, раќа,
   {{0x7c3c02a7,0x6d4637f9,0xa77b006e,0x00000000}},	//   _larr, _orka, _קראפ, --,
   {{0x955300cd,0x518437fa,0x660237fb,0x316d0328}},	//   _نخوا, аура, _idok, áez_,
   {{0x8cd60251,0x8c080081,0x3e7500d6,0x258401d3}},	//   _बढ़ो, র্তন_, _måte_, rīlī_,
   {{0x54331850,0x443c022e,0x6d4637fc,0xdef8002d}},	//   _ضرور, _iav_, _arka, кыт_,
   {{0x443e37fd,0x443c37fe,0x3cfe000f,0x6d460995}},	//   ldt_, _hav_, _लिखे_, _brka,
   {{0x80dd00c7,0x443c0197,0x2129063f,0x961d00d9}},	// [2cd0] _বিক্, _kav_, _upah_, ziņo,
   {{0x443e37ff,0x7c3c2dad,0x290f092f,0x443c16fc}},	//   ndt_, _carr, vuga_, _jav_,
   {{0x7c3c3800,0x443c01fa,0x6d463801,0x443e3802}},	//   _darr, _mav_, _erka, idt_,
   {{0x443c3803,0x7c3c10f0,0x66023804,0x9984013f}},	//   _lav_, _earr, _ndok, _namų_,
   {{0x7c3c3805,0xe8df00de,0x443c3806,0x78a33807}},	//   _farr, _trọn_, _oav_, tonv,
   {{0x443c0b4b,0x7c3c1164,0x290f3808,0x443e0126}},	//   _nav_, _garr, ruga_, jdt_,
   {{0x6d460220,0x290f3809,0x6e3d380a,0x291d380b}},	//   _zrka, suga_, _kasb, stwa_,
   {{0x443e0126,0x7e6d380c,0x7c3c380d,0xc1e32172}},	//   edt_, nkap, _zarr, _क्लब_,
   {{0x9a84380e,0x6e3d380f,0xaca30174,0x7c3c3810}},	//   _турл, _masb, _nrịb, _yarr,
   {{0x443c006c,0x649d0472,0x66020294,0x6284036b}},	//   _cav_, nèix, _edok, _smio,
   {{0x443c0197,0x46152b38,0x7e6d3811,0xf7700397}},	//   _dav_, _موار, kkap, _وام_,
   {{0xe0c900c1,0x6e3d3812,0x6d03218b,0x443e01cb}},	//   _זײ_, _nasb, _लिंग_, adt_,
   {{0x81ac0081,0x321e0034,0x443e0072,0xfbc3030b}},	//   কেন_, ęty_, bdt_, वेतम,
   {{0x4095131b,0x443c3813,0x66020146,0x2c7602b6}},	//   арст, _gav_, _zdok, _kæde_,
   {{0x7c3c0044,0x656900f9,0x6d4605db,0x9f580216}},	//   _rarr, lyeh, _srka, marë_,
   {{0x7e6d3814,0x7c3c3815,0x44270063,0x6aa90095}},	//   gkap, _sarr, _hbn_, _nkef,
   {{0x0c261a77,0x443c0197,0x261b0101,0x61463816}},	// [2ce0] лман, _yav_, _यानी_, _сепа,
   {{0x443c0d7d,0xf54f0134,0x7c3c3817,0x786f01df}},	//   _xav_, _bụzi_, _qarr, _søvn,
   {{0x7c3c3818,0x645c00aa,0x6e3d007e,0x16030096}},	//   _varr, örii, _fasb, ळणार_,
   {{0x6d46077e,0x998d00a5,0xe3c50081,0x7c3c3819}},	//   _trka, _oceń_, _এভাব, _warr,
   {{0x7c3c381a,0x442703ab,0x6abb0188,0x0d830829}},	//   _tarr, _obn_, _dhuf, _глян,
   {{0x61f6381b,0x4427381c,0x60d600f9,0x98a30a54}},	//   _leyl, _nbn_, _muym, биче,
   {{0x6d44381d,0x9f58023b,0xbddb00ee,0x6e3d0027}},	//   lvia, darë_, _inèr, _yasb,
   {{0x443c381e,0x9b9300e3,0x7ae3381f,0xfaa63820}},	//   _sav_, _الفت, ínte, _сабо,
   {{0x443c3821,0x6d440472,0xd94314fb,0x442710e9}},	//   _pav_, nvia, _лети, _bbn_,
   {{0xd5c004dd,0x443c022e,0x443e0629,0x19b91e20}},	//   शेषज, _qav_, udt_, _русь_,
   {{0x443e3822,0x5fa4007d,0x7e6d06a8,0x61f63823}},	//   rdt_, _खुलल, ykap, _beyl,
   {{0x201a02a1,0x66023824,0x673a0dd9,0xd7f80023}},	//   _acpi_, _udok, _istj, _xoăn_,
   {{0x443c3825,0x6d440181,0x9f510146,0x257a0065}},	//   _tav_, jvia, razí_, _dàlé_,
   {{0x443c3826,0x60d60367,0x6d440031,0x83660037}},	//   _uav_, _duym, dvia, _مدبل,
   {{0xb4c00176,0xb4c2009f,0x7e6d3827,0x80d50557}},	//   ंगी_, ्दी_, tkap, _यूरे,
   {{0xe80e07e2,0x4ea7004b,0x228b0139,0x76403828}},	//   _साझा_, урга, _dòkè_, ndmy,
   {{0xb8042ebd,0x6e3d3829,0x38bb0313,0x5d5502b3}},	// [2cf0] रणाम_, _vasb, lêre_, шкат,
   {{0x7e6d382a,0x673a00aa,0x6e3d1030,0x9ed90cba}},	//   skap, _ostj, _wasb, _имот_,
   {{0x649d0472,0x6e3d00dc,0x38bb0313,0x228b0032}},	//   rèix, _tasb, nêre_, _gòkè_,
   {{0xb4c2382b,0x6e3d0167,0x61f600a7,0xbddb00ee}},	//   ्दु_, _uasb, _xeyl, _enèr,
   {{0x673a0090,0xa3ab030b,0xc27c006e,0x2c760537}},	//   _astj, _कुन_, ערדי, _sæde_,
   {{0x1bd40a67,0x7d0d382c,0x41c70b2b,0x00000000}},	//   _горя, mras, रेयस, --,
   {{0x9f580052,0x442705db,0x1a650504,0x6aa90090}},	//   varë_, _rbn_, _پیشی_, _tkef,
   {{0x9a87197f,0x00000000,0x00000000,0x00000000}},	//   _сугл, --, --, --,
   {{0xb4c2382d,0x7d0d382e,0x9f5800dd,0xb4c00592}},	//   ्दू_, nras, tarë_, ंगू_,
   {{0x03250b1b,0xddc40138,0x61f6382f,0x38bb084e}},	//   адон, nkiš, _seyl, fêre_,
   {{0x7d0d3830,0xe1ff00a5,0x3a3f3831,0xe70b0214}},	//   hras, nków_, _kaup_, _ستان_,
   {{0x80dd0f71,0x614602e3,0x216a00d6,0x6d440138}},	//   _বিজ্, аема, вими_, yvia,
   {{0xe2970ee6,0x9f583832,0x201a0042,0x442700fe}},	//   рая_, maré_, _pcpi_, _tbn_,
   {{0xd46615de,0x6d440451,0x442700dc,0x26cf3833}},	//   _више_, vvia, _ubn_, _higo_,
   {{0x26cf3834,0x6e240036,0x7d0d3835,0x00000000}},	//   _kigo_, tfib, eras, --,
   {{0x26cf006d,0xddc93836,0xe1ff0034,0x29000138}},	//   _jigo_, _šošt, dków_, šiai_,
   {{0x7d0d3837,0x291f023e,0xac863671,0x26cf037a}},	// [2d00] gras, _nqua_, агал, _migo_,
   {{0xd12f00d0,0x26cf3838,0x0eb8009d,0x6d443839}},	//   _کمی_, _ligo_, _आठवड, rvia,
   {{0x7d0d383a,0xdddd0018,0x2abc0a43,0x64411e03}},	//   aras, _első, híbe_, idli,
   {{0x6da6004d,0x64410167,0x9f58034f,0x00000000}},	//   _вима, hdli, jaré_, --,
   {{0x44e90b0b,0x7d0d383b,0x2900001f,0x2240383c}},	//   _nº_, cras, éia_, _maik_,
   {{0x2018383d,0x37062c37,0x26cf0085,0x3eb200c2}},	//   ngri_, ачив, _aigo_, llyt_,
   {{0x26cf383e,0x291f028d,0x9f5800b3,0xb17b059a}},	//   _bigo_, _equa_, faré_, lbåt,
   {{0x2240383f,0x644102e2,0xeb9700d6,0x26cf0344}},	//   _naik_, edli, _тис_, _cigo_,
   {{0x26cf1f84,0xd5b73840,0x644101cb,0x00000000}},	//   _digo_, ись_, fdli, --,
   {{0xb4c00067,0xb4c224eb,0x38bb057a,0x20cf0090}},	//   ंगे_, ्दे_, têre_, _ażin_,
   {{0x22402c09,0x3946013f,0x22520808,0x3e750149}},	//   _baik_, lvos_, _bnyk_, _låta_,
   {{0xc5f000c7,0x38bb0313,0x7d0d3841,0xe81c0285}},	//   _টাকা_, rêre_, yras, _नाडा_,
   {{0x22400063,0x3946002b,0xd5b02ce3,0xe1ff007f}},	//   _daik_, nvos_, _عفت_, zków_,
   {{0x83f8188d,0x53343842,0x27fc01df,0x7d0d3843}},	//   _секс_, _гект, navn_, vras,
   {{0x06fd00b6,0x22403844,0x3eb200f3,0xcf150033}},	//   žívá_, _faik_, flyt_, াব্দ_,
   {{0x27fc0c08,0x2c190096,0x2a64022b,0x00000000}},	//   havn_, _पाहू_, _nomb_, --,
   {{0xddc40335,0xdb1c0034,0x6d40033b,0x66d50138}},	// [2d10] tkiš, _ogró, _šmar, _iške,
   {{0xe1ff0034,0x61fd1a4a,0x9f580623,0xa3aa24f3}},	//   tków_, lasl, zaré_, _खडा_,
   {{0x1da73845,0x7d0d3846,0x3a3f0154,0x7e9901f9}},	//   _कुरत, sras, _paup_, _مندر_,
   {{0x7d0d3847,0xa3e60c16,0xde590426,0x7e55010d}},	//   pras, युत_, _самі_, _انحص,
   {{0x39490fb6,0x0dcb00c9,0x26cf3848,0x64413849}},	//   ías_, _јуни_, _rigo_, ydli,
   {{0x26cf384a,0xb4c2030b,0xb4c00e52,0x00000000}},	//   _sigo_, ्दो_, ंगो_, --,
   {{0xb4c2033a,0x61fd02a7,0x261b009d,0x9f58384b}},	//   ्दै_, kasl, _यादी_, taré_,
   {{0x2f9800ca,0x61fd01d3,0x2018080e,0x3ea900ce}},	//   יכון_, jasl, zgri_, noat_,
   {{0x26cf22e7,0x880709f4,0x9f582e56,0xa3c909c4}},	//   _vigo_, _نظام, raré_, लेन_,
   {{0x26c40036,0x26cf0a4b,0x66d505db,0x2abc0076}},	//   ammo_, _wigo_, _aške, ríbe_,
   {{0x6441384c,0x69cb0bf5,0xa25b0161,0x9f58384d}},	//   rdli, _तृती, rmôn, paré_,
   {{0x2721310d,0x6f15384e,0x625a384f,0x7d0200c6}},	//   món_, duzc, урор_, šosi,
   {{0x27213850,0xa5091a18,0x5a9a0142,0x200c0231}},	//   lón_, _села_, רשרא, ódio_,
   {{0x645c3851,0x00000000,0x00000000,0x00000000}},	//   örit, --, --, --,
   {{0x27210933,0xb21b052f,0x224000dc,0xdee63852}},	//   nón_, dhæf, _taik_, соби,
   {{0x61fd0307,0x27210072,0x394600c6,0xbda60037}},	//   casl, ión_, yvos_, محذو,
   {{0x61e43853,0xed573854,0x27213855,0x00000000}},	// [2d20] _ifil, бот_, hón_, --,
   {{0xa3ab3856,0x27213857,0xb17b0572,0x290f0141}},	//   कअप_, kón_, rbåt, drga_,
   {{0x27213858,0xdb1c00ee,0x5f4602fc,0xfbc30ff9}},	//   jón_, _agrò, _انجل, वेलम,
   {{0x27213859,0xa3c90096,0x82d6006e,0xef22007f}},	//   dón_, लेय_, צונג_, ążę_,
   {{0x19581402,0x186a385a,0xceb40092,0x92e30081}},	//   ралы_, лади_, mlə_, _ফটো_,
   {{0xfce3385b,0x2721385c,0x6e362040,0x3946385d}},	//   _хоро, fón_, leyb, rvos_,
   {{0x3946385e,0x27210fb6,0x61e4385f,0xa3c90296}},	//   svos_, gón_, _ofil, लेम_,
   {{0xceb40092,0x20cf00bd,0x27fc066a,0x2d800036}},	//   nlə_, _ażil_, savn_, ozie_,
   {{0x2d803860,0xb5fd00d9,0x61fd0103,0x7e663861}},	//   nzie_, ekšs, vasl, _mokp,
   {{0xd6d206f6,0xb8653862,0x27213863,0x61fd0167}},	//   _فقط_, _والو, bón_, wasl,
   {{0xceb40092,0x27210af3,0xd5b200cd,0x61fd3864}},	//   klə_, cón_, _کفش_, tasl,
   {{0x9c8700b6,0x27240129,0x7cff0065,0x290000c6}},	//   _kočá, _ịnwe_, _jàrá, šiau_,
   {{0x61e4002b,0xb5fd00c6,0x64a60ad8,0xa3c903b3}},	//   _dfil, rkšt, _лада, लेब_,
   {{0x2d800d1b,0x61e43865,0x644d01c2,0x61fd3866}},	//   dzie_, _efil, _ɗaik, sasl,
   {{0x93fb00f5,0x61fd3867,0x61e40150,0x4fc435c8}},	//   _גלוי, pasl, _ffil, зста,
   {{0x5f941e54,0xa1951031,0x00000000,0x00000000}},	//   чист, _майч, --, --,
   {{0x272111ce,0x2d58249c,0x628f226a,0x261b0285}},	// [2d30] zón_, бить_, mico, _यासी_,
   {{0xf21f0336,0x9d181110,0x6f153868,0xaae70037}},	//   _भाड़_, софт_, puzc, مسؤو,
   {{0x272103be,0xb5fd0087,0xb21b003e,0xddcf020a}},	//   xón_, ljše, rhæf, _focş,
   {{0x7d160124,0xdb1f04c8,0x290f05db,0x27210143}},	//   buys, _ávís, trga_, vón_,
   {{0xae1a0130,0xd5a609e5,0xb5fd033b,0x786f00f3}},	//   _דורכ, _آف_, njše, _høvi,
   {{0x272106cb,0xd7fb0036,0x628f020a,0x00000000}},	//   tón_, ууд_, hico, --,
   {{0x32090188,0x628f3869,0x00000000,0x00000000}},	//   _oday_, kico, --, --,
   {{0x2721386a,0x628f042d,0xb5fd01d3,0xb4d13613}},	//   rón_, jico, ekšr, वद्_,
   {{0x6499036f,0x272106cb,0x00000000,0x00000000}},	//   итор_, són_, --, --,
   {{0x27210610,0x61e4386b,0x4489129c,0x730500d6}},	//   pón_, _sfil, рбон_, опоз,
   {{0x628f132d,0xe7ef009d,0x320933aa,0xceb40092}},	//   fico, _घ्या_, _bday_, ylə_,
   {{0xd57521f4,0x628f386c,0xf1bf037a,0xe29726fd}},	//   _муль, gico, rfán_, жаю_,
   {{0x2a3a006e,0xceb4013c,0x00000000,0x00000000}},	//   בערמ, vlə_, --, --,
   {{0x201e2ba2,0x661b2c70,0x753b0027,0x00000000}},	//   üti_, lguk, mwuz, --,
   {{0xceb40092,0x7e660270,0x64430a05,0xdee31e46}},	//   tlə_, _pokp, _iani, доси,
   {{0xee3a07ed,0x2d800062,0x38b200ae,0x394d386d}},	//   јна_, tzie_, râri_, _ores_,
   {{0x6443386e,0xa3c30336,0x7fd600f7,0xceb401d4}},	// [2d40] _kani, ्शक_, _міні, rlə_,
   {{0xa3bd0378,0x2d800d6d,0x6fde02d5,0x6ee30174}},	//   _आरा_, rzie_, _मलिं, ọbat,
   {{0xe9da2f93,0x6a86386f,0x68e93870,0x7e660113}},	//   аке_, олжа, _ated, _tokp,
   {{0x64433871,0x9c8700b6,0x394d1868,0x00000000}},	//   _lani, _počá, _bres_, --,
   {{0x81ac00c7,0x394d3872,0xa3c90096,0xdb0700b6}},	//   কের_, _cres_, लेत_, _vyjá,
   {{0x644334b2,0xb9023873,0xd90d00cd,0xc17300a1}},	//   _nani, _नं_, ایل_, וחד_,
   {{0x394d3874,0xe3a70177,0xd6d732e3,0x8b230a28}},	//   _eres_, _آر_, оты_, _одре,
   {{0x628f3875,0x64433876,0x395d023e,0x661b3877}},	//   xico, _aani, bxws_, gguk,
   {{0x7d043878,0x64433879,0xd90d0470,0xd49a125f}},	//   nsis, _bani, _مین_, иро_,
   {{0x6443387a,0x7d04387b,0xe46a387c,0xa25b016d}},	//   _cani, isis, ршил_, rmôm,
   {{0x628f387d,0x7d04387e,0x00000000,0x00000000}},	//   tico, hsis, --, --,
   {{0x7d04387f,0xdb213880,0xd377013f,0x95ca1d7b}},	//   ksis, étét, ючы_, _кула_,
   {{0x628f3881,0x66003633,0xe1ff3882,0x66d50138}},	//   rico, mamk, raó_, _iška,
   {{0x628f2733,0x64433883,0x6600008a,0xdfd8008f}},	//   sico, _gani, lamk, жът_,
   {{0x628f3884,0x81ac0081,0x44e03885,0x7d043886}},	//   pico, কেল_, _hò_, esis,
   {{0x44e03887,0x7c2e3888,0x66000010,0x2a7d023e}},	//   _kò_, _abbr, namk, xhwb_,
   {{0xd9040814,0x7d040256,0xbe750065,0xdddd0034}},	// [2d50] _جی_, gsis, _aṣàl, _posł,
   {{0x44e03889,0x6600388a,0xfc330037,0x6443388b}},	//   _mò_, hamk, بحر_, _xani,
   {{0x44e0388c,0x68e9388d,0x6600388e,0x442e061d}},	//   _lò_, _sted, kamk, _mbf_,
   {{0x66000808,0x7c2e08b9,0x787d022b,0x00000000}},	//   jamk, _ebbr, _mève, --,
   {{0x44e002f1,0x6600388f,0x81cd0033,0x2d9c026a}},	//   _nò_, damk, শুর_, şver_,
   {{0xbca500e3,0x68e90220,0x3e7c00b6,0xb5fd01d3}},	//   _رمزي, _vted, _víte_, ekšp,
   {{0xf77100b1,0x644308a9,0x68e900a5,0xb902007a}},	//   عات_, _rani, _wted, _नू_,
   {{0x394d3890,0x44e03891,0x9f5a022b,0x6d4f0995}},	//   _tres_, _bò_, _depè_, _krca,
   {{0x64433892,0x44e03893,0x798200a5,0x6d4f0124}},	//   _pani, _cò_, czow, _jrca,
   {{0x44e00d79,0x629d3894,0x628d0294,0xc4822cbf}},	//   _dò_, éron, _amao, ельк,
   {{0xf1a90132,0x2292013f,0xa3ab121d,0x32460805}},	//   _עס_, eška_, _कुश_, пенг,
   {{0x6443117e,0xe29a0d6f,0x44e03895,0x7d043896}},	//   _wani, сам_, _fò_, ysis,
   {{0x44e01610,0x64433897,0xbbb8000d,0xa7fc026a}},	//   _gò_, _tani, _अर्क, _alıy,
   {{0xf09f1b27,0x15420e3a,0x64430350,0x787d014b}},	//   dràs_, _чешм, _uani, _fève,
   {{0x1fb53898,0x44e0022b,0x00000000,0x00000000}},	//   дстр, _zò_, --, --,
   {{0x3e6e0088,0x7d043899,0x6d4f389a,0x71a628bb}},	//   _nýtt_, tsis, _brca, _найз,
   {{0xed57389b,0x44e0028d,0x6d4f009c,0x3202028a}},	// [2d60] пот_, _xò_, _crca, maky_,
   {{0x7d04389c,0x99dd0220,0xe058001c,0x320200d4}},	//   rsis, _raňa, _بیست_, laky_,
   {{0x2baf009f,0xbddb03a9,0xf09f00b3,0x6d4f0233}},	//   _जुदा, _kaèl, aràs_, _erca,
   {{0x81ac0081,0x32020146,0xfaa304a1,0x7d04389d}},	//   কেঃ_, naky_, нахо, psis,
   {{0x9f580428,0x2fda0063,0x6d4f00c4,0xbddb0113}},	//   larà_, _kgpg_, _grca, _maèl,
   {{0x44e002b4,0x79820034,0x91bb00ca,0x00000000}},	//   _rò_, rzow, זמני, --,
   {{0x44e0389e,0xa3ab00af,0x9f5805fe,0x6600389f}},	//   _sò_, _कुल_, narà_, tamk,
   {{0x44e038a0,0x32020146,0x7e640085,0x00000000}},	//   _pò_, jaky_, njip, --,
   {{0xa3c9000c,0x1dbe0213,0x787d0154,0x00000000}},	//   लेस_, ्धित, _sève, --,
   {{0x628d10f0,0xa3e602d5,0x22920087,0x660038a1}},	//   _smao, युं_, vška_, samk,
   {{0xd25112eb,0x44e00649,0x9f58015e,0x00000000}},	//   نند_, _wò_, jarà_, --,
   {{0x44e00d79,0x9f5805fe,0xa75b00ca,0x11d90037}},	//   _tò_, darà_, _לדבר, توحة_,
   {{0xc05b00d6,0x41c70034,0x442e38a2,0x29060095}},	//   бів_, रेंस, _tbf_, nsoa_,
   {{0x26de38a3,0x229238a4,0x98bf0995,0x9f5800ee}},	//   _kuto_, rška_, _vruć_, farà_,
   {{0xb5fd03f1,0x645838a5,0x9f5805fe,0x6d4f00cc}},	//   ljša, _invi, garà_, _srca,
   {{0x81ac0081,0x26de0435,0x644838a6,0xbddb00ee}},	//   কেই_, _muto_, lddi, _gaèl,
   {{0x2d5802fd,0x26de38a7,0xb5fd0087,0x442c38a8}},	// [2d70] пить_, _luto_, njša, ofd_,
   {{0x644819c2,0x9f5805fe,0xf09f0428,0x62960094}},	//   nddi, barà_, rràs_, ézov,
   {{0x200338a9,0x9f5805fe,0x64480150,0x629d38aa}},	//   maji_, carà_, iddi, onso,
   {{0x2ea802e8,0x6d4f08a9,0x629d004d,0x200309c0}},	//   ककृत, _trca, nnso, laji_,
   {{0x9f5822a4,0x6d4f00ae,0x6458225b,0x60d70062}},	//   mará_, _urca, _onvi, _kixm,
   {{0x26de38ab,0x200338ac,0x660b005c,0x9f580165}},	//   _buto_, naji_, _sdgk, lará_,
   {{0xa6c92b19,0x6d4d28ac,0x60df38ad,0x47d00081}},	//   олка_, lvaa, _luqm, _স্বী,
   {{0x200338ae,0x9f581946,0x442c01c0,0xa3c224eb}},	//   haji_, nará_, efd_, ्धन_,
   {{0x6d4d38af,0x200338b0,0x442c05db,0x9f58002b}},	//   nvaa, kaji_, ffd_, iará_,
   {{0x200338b1,0xd90d0018,0x629d0b8e,0x2b430090}},	//   jaji_, _میچ_, enso, _ksjc_,
   {{0xaca30294,0x9f580428,0x3e7c003e,0x06d70033}},	//   _nnọc, xarà_, _líta_, _সবকি,
   {{0x645838b2,0x9f5838b3,0x644838b4,0x68fb0174}},	//   _envi, jará_, addi, _kwud,
   {{0x9f5822bf,0xaca30294,0x5155002d,0x26de09ac}},	//   dará_, _anọc, нтру, _zuto_,
   {{0x9f5805fe,0x200338b5,0x6e2d01c0,0x764938b6}},	//   tarà_, gaji_, efab, ldey,
   {{0x4aad007d,0xa3c9048a,0x752938b7,0x6d4d2e08}},	//   टकाव, लेश_, ltez, evaa,
   {{0x9f5838b8,0x764938b9,0x22920117,0x6d4d02ac}},	//   gará_, ndey, mško_, fvaa,
   {{0x200338ba,0x75292af9,0xdb0e030b,0x9f5805fe}},	// [2d80] baji_, ntez, _vybí, sarà_,
   {{0x69db38bb,0x7e7d009c,0xfbd2029e,0x9f580428}},	//   _ague, _elsp, نتا_, parà_,
   {{0xaec60743,0xaca40174,0x9f5822a4,0x2292389a}},	//   _обол, _haịr, bará_, nško_,
   {{0x9f581f9f,0x99dd025b,0xed5a38bc,0x6f1c0d30}},	//   cará_, _daňo, _дом_, murc,
   {{0x64481a2e,0x764938bd,0xaca400ac,0xa96707ed}},	//   yddi, ddey, _asụs, мица_,
   {{0x29060933,0xd6ea1121,0x3ead0117,0x69c0033b}},	//   rsoa_, офил_, čete_, _vzme,
   {{0x29060396,0x7bdc38be,0x68fb063d,0x00000000}},	//   ssoa_, _igru, _ewud, --,
   {{0x2003068d,0xc95602fd,0x00000000,0x00000000}},	//   zaji_, _отзы, --, --,
   {{0x6f1c38bf,0x66d500c6,0x26de0113,0x00000000}},	//   hurc, _iškl, _wuto_, --,
   {{0x9f5838c0,0x26de030b,0x1620009d,0x64480d19}},	//   zará_, _tuto_, _यावर_, uddi,
   {{0xd62a1c47,0x644838c1,0xa3c90096,0x26de00f9}},	//   _може_, rddi, लेल_, _uuto_,
   {{0x6f1c02e2,0x20030051,0x9f580558,0x68e038c2}},	//   durc, waji_, xará_, _kumd,
   {{0x2003068d,0x9f5822bf,0x752900ae,0x786f02b6}},	//   taji_, vará_, ctez, _iøvr,
   {{0xddcd1100,0xc058018a,0x656f01bf,0x7bdc00cd}},	//   jkaš, міс_, äche, _ngru,
   {{0x9f58132d,0x26c638c3,0xf54800ac,0x6f1c01c2}},	//   tará_, _khoo_, _hụ_, gurc,
   {{0x4ea42de0,0x7bdc38c4,0x6d4d1237,0x200338c5}},	//   вруа, _agru, tvaa, saji_,
   {{0x9f582c90,0xdd94055b,0xf5480134,0x200321ef}},	// [2d90] rará_, ваты, _jụ_, paji_,
   {{0x31560054,0xf5480129,0x6d4d38c6,0x9f5822bf}},	//   _ניתן_, _mụ_, rvaa, sará_,
   {{0x9f581f84,0x6f1c00ae,0x752938c7,0x6d4d38c8}},	//   pará_, curc, ztez, svaa,
   {{0xb4ca0b94,0x387e0036,0x6d4d029a,0x7d1638c9}},	//   लगु_, _altr_, pvaa, brys,
   {{0x224938ca,0x80180688,0xd90f09e5,0xf54838cb}},	//   _maak_, _عزیز_, شیا_, _nụ_,
   {{0x2b43015e,0x22490381,0x26c6026d,0x68e00565}},	//   _tsjc_, _laak_, _ahoo_, _dumd,
   {{0x7afc0150,0x38c90018,0x200100bc,0x7c3001f9}},	//   _gwrt, _ہائی_, _mehi_, ékrő,
   {{0x26c638cc,0xf54838cd,0x06093097,0x752938ce}},	//   _choo_, _bụ_, чник_, ttez,
   {{0xf5480028,0x2a7f0009,0x68e003e3,0x76490233}},	//   _cụ_, _ilub_, _gumd, rdey,
   {{0x752938cf,0x2a7f01bb,0x291d38d0,0xf5480019}},	//   rtez, _hlub_, muwa_, _dụ_,
   {{0xa3c90b89,0xe8d600a1,0x291d38d1,0xf7700281}},	//   लें_, _נוער_, luwa_, _پال_,
   {{0xbbdc000f,0x25a00128,0x2292191d,0x7529020a}},	//   _बल्क, _žile_, rško_, ptez,
   {{0xf5482e5c,0x70ab0034,0x26cd1fc2,0x20010634}},	//   _gụ_, चकूल, mmeo_, _behi_,
   {{0xd11c17ff,0x2a6d38d2,0x38a90031,0x6f1c38d3}},	//   भूषण_, _loeb_, túry_, turc,
   {{0xc7b207a6,0x2baf00af,0x2a7f01d4,0x291d38d4}},	//   ָבן_, _जुला, _olub_, huwa_,
   {{0x291d1a7e,0x9f5c38d5,0x68330dea,0xb21b02b6}},	//   kuwa_, _því_, lıdı, lhæn,
   {{0xafe62ff8,0xf8af09c3,0x291d38d6,0xe3b8026a}},	// [2da0] _попл, टवाय, juwa_, ngın_,
   {{0x64571f84,0x22490126,0xb21b052f,0x291d38d7}},	//   _óxid, _zaak_, nhæn, duwa_,
   {{0xddcd1419,0x3ce5009f,0x386c0072,0x22490167}},	//   rkaš, _झूठे_, _rodr_, _yaak_,
   {{0x09e638d8,0x2a7f38d9,0x7d1638da,0xa3c20096}},	//   ходн, _club_, prys, ्धत_,
   {{0xaca40129,0x291d38db,0x3ea038dc,0xe297006e}},	//   _abụr, guwa_, mnit_, עכנט_,
   {{0x6d4638dd,0x3b0a1456,0x3ea038de,0xf5480294}},	//   _iska, _него_, lnit_, _rụ_,
   {{0x3ea0023b,0x26c6023e,0xdca3007e,0x638638df}},	//   onit_, _phoo_, _сари, _méné,
   {{0x3ea015bd,0x291d006d,0xfd550174,0x940500a7}},	//   nnit_, buwa_, _nkaọ, milə_,
   {{0x22490665,0x3ea038e0,0xb21b052f,0x672a38e1}},	//   _raak_, init_, fhæn, stfj,
   {{0xf54800ef,0x22490185,0xfd550294,0x638638df}},	//   _vụ_, _saak_, _akaọ, _néné,
   {{0x7ae92c0a,0x26c61423,0x224938e2,0xd764001c}},	//   _četk, _thoo_, _paak_, _جنای,
   {{0x6d4638e3,0x09d400c7,0xf54800de,0x877b006e}},	//   _oska, _হ্যা, _tụ_, _מאבי,
   {{0x22490ab2,0x6386025a,0x3ea002c6,0x7c3e38e4}},	//   _vaak_, _béné, dnit_, kepr,
   {{0x638603a9,0xf1c70034,0x7c3e17d2,0x660238e5}},	//   _céné, रेगन, jepr, _heok,
   {{0x443e0052,0x6d4638e6,0x9f34004d,0x22490a9f}},	//   met_, _aska, лері, _taak_,
   {{0x644a38e7,0x20010113,0x291d1114,0x626726a0}},	//   _hafi, _wehi_, yuwa_, _سابق,
   {{0x644a38e8,0xdb0e025b,0x7c3e0218,0xad9b38e9}},	// [2db0] _kafi, _rybá, fepr, _adúr,
   {{0x638604ea,0x64840013,0x3ea038ea,0x319c00ca}},	//   _géné, _dòig, anit_, _מבחנ,
   {{0x6d4603f3,0x7f4500dd,0xa3c2303f,0x291d0044}},	//   _eska, _ushq, ्धि_, wuwa_,
   {{0x443e38eb,0x644a1114,0x291d38ec,0xd99900e3}},	//   het_, _lafi, tuwa_, ونات_,
   {{0x443e38ed,0xd94508c3,0x61ed0051,0x27ec0063}},	//   ket_, тели, _mfal, _bfdn_,
   {{0x443e38ee,0xa3c20714,0x291d38ef,0x2c1e0034}},	//   jet_, ्धा_, ruwa_, _पाएं_,
   {{0x443e38f0,0x291d38f1,0x94240092,0x61ed0150}},	//   det_, suwa_, _ötən_, _ofal,
   {{0x81ac0081,0x644a0032,0x291d0bb6,0x6d460313}},	//   কেট_, _aafi, puwa_, _yska,
   {{0x443e38f2,0x644a38f3,0x26cd2d07,0xe5710037}},	//   fet_, _bafi, rmeo_, شطة_,
   {{0x443e085d,0xf9900604,0x61ed38f4,0x644a0188}},	//   get_, _طبق_, _afal, _cafi,
   {{0x03a50097,0x644a38f5,0x68330511,0x4e2100b6}},	//   тино, _dafi, rıdı, यलाई_,
   {{0x7c3e00a5,0x68330511,0x638600fd,0xe1ff01cd}},	//   zepr, sıdı, _séné, sjón_,
   {{0x443e38f6,0x644a1f90,0x64840441,0x638600fd}},	//   bet_, _fafi, _bòid, _péné,
   {{0x764b0068,0x61ed02ad,0x644a38f7,0x6484009c}},	//   _hagy, _efal, _gafi, _ròig,
   {{0x764b38f8,0x7c3e2241,0x6386020d,0x3ea038f9}},	//   _kagy, vepr, _véné, tnit_,
   {{0x644a38fa,0x940500a7,0x00000000,0x00000000}},	//   _zafi, vilə_, --, --,
   {{0x764b00fb,0x7c3e38fb,0x3ea038fc,0x644a38fd}},	// [2dc0] _magy, tepr, rnit_, _yafi,
   {{0x644a008a,0x3ea038fe,0x711b00c1,0x2bc616e2}},	//   _xafi, snit_, _קויפ, _वरदा,
   {{0x290d0012,0x7c3e38ff,0x6d4600a5,0xa3d10557}},	//   _avea_, repr, _wska, वधि_,
   {{0x764b00fb,0x443e3900,0x7c3e3901,0x6d4601c2}},	//   _nagy, zet_, sepr, _tska,
   {{0x443e3902,0x94050092,0x6d463903,0x442700eb}},	//   yet_, silə_, _uska, _ocn_,
   {{0x66023904,0x443e3905,0x68ed3906,0x270c00d2}},	//   _seok, xet_, íada, těn_,
   {{0x443e02fe,0x644a0a55,0x764b3907,0x37d50081}},	//   vet_, _rafi, _bagy, _স্বর,
   {{0x6e243908,0x443e3909,0x4427390a,0xddc60154}},	//   ngib, wet_, _acn_, _lakō,
   {{0x443e0bb0,0x7ae900e9,0x48e602ec,0x4427390b}},	//   tet_, _četi, _розв, _bcn_,
   {{0x443e390c,0x442700ee,0x61ed0036,0x545300c2}},	//   uet_, _ccn_, _sfal, авьт,
   {{0x443e390d,0x8c1b0130,0x261b009d,0xd6cf0ff7}},	//   ret_, וויי, _याची_, _вт_,
   {{0x443e3903,0x92580084,0x644a03e1,0xa3e60569}},	//   set_, вают_, _wafi, युज_,
   {{0x443e390e,0x644a1114,0x3e750212,0xf1c40094}},	//   pet_, _tafi, _mått_, _ruší_,
   {{0x443e01e5,0x1c1e0490,0x843800e3,0x74140018}},	//   qet_, _पागल_, _أكثر_, _صوبا,
   {{0xf2c7107a,0x61fb0653,0x66c50103,0x764b0172}},	//   _исин, ðuls, lóka, _yagy,
   {{0x6e242a8c,0x61ed0051,0xaee30032,0x2ebf1efb}},	//   ggib, _ufal, _aiṣe, ्षेत,
   {{0x51870c10,0x6aa212b1,0x5d550fe9,0xfd7400d3}},	// [2dd0] _шука, dnof, ыкат, алтэ,
   {{0x1acb0c16,0x041400c7,0x673a390f,0x6e240172}},	//   िष्ठ, ত্রী_, _optj, agib,
   {{0x7640007b,0xc61a0033,0x290d15cd,0x787d022b}},	//   kemy, থ্যা_, _svea_, _sèvo,
   {{0xb21b052f,0xdea10103,0x6aa202ac,0x00000000}},	//   skæf, _ایری, gnof, --,
   {{0x76403910,0x66ea0034,0x0d6400e5,0x66c50e67}},	//   demy, _ręka, _кърм, jóka,
   {{0xfaf30241,0xb4ac030b,0x7d0d3911,0x66d50138}},	//   _نثر_, कको_, msas, _iški,
   {{0x3e750572,0x44271333,0xe73900d3,0x7d0d36ea}},	//   _fått_, _rcn_, хей_, lsas,
   {{0x3e75038b,0x9f513912,0x7bc70877,0x7d0d3913}},	//   _gått_, lazó_, _izju, osas,
   {{0x764b3914,0xdd1203a3,0x955500e3,0xb5fd033b}},	//   _vagy, _müşt, اخبا, ljšk,
   {{0x764b010a,0x2292033b,0x7c253915,0x6e241d67}},	//   _wagy, mški_, nghr, zgib,
   {{0xe29a15e9,0x7c250076,0x764b010a,0x6d44007f}},	//   еан_, ighr, _tagy, zwia,
   {{0xad9b3916,0x7d0d3917,0x95551d28,0x6d443918}},	//   _reún, ksas, _مختا, ywia,
   {{0x6484009c,0xc8710139,0x9f583919,0x4427020b}},	//   _dòib, _ko̟_, mbré_, _tcn_,
   {{0x628600dd,0x20cf0090,0x659a0266,0xd378007f}},	//   shko, _bżiq_, _אינק, być_,
   {{0xe29a1880,0xa3c93245,0x26dd391a,0xa3ab3845}},	//   _пак_, लेख_, _kiwo_, _कुच_,
   {{0x6441391b,0x44e90d79,0x26dd0113,0x539a0327}},	//   leli, _kú_, _jiwo_, _ריקו,
   {{0x44e9391c,0x7d0d0256,0xa3e7382d,0x6284391d}},	// [2de0] _jú_, gsas, _भला_, _ilio,
   {{0x6441391e,0x44e90649,0x629d025b,0x764000a5}},	//   neli, _mú_, érov, zemy,
   {{0x44e9391f,0x66093920,0x61e93921,0x644100d3}},	//   _lú_, kaek, žele, ieli,
   {{0xa3ab3922,0x644108a3,0x200a3923,0xaca40174}},	//   _कुछ_, heli, labi_, _krịs,
   {{0x44e93924,0xd37800a5,0x7d0d3925,0x62840239}},	//   _nú_, zyć_, csas, _mlio,
   {{0x7ae900e9,0x200a27d3,0x64413926,0x2242003d}},	//   _četv, nabi_, jeli, hekk_,
   {{0x64413927,0xd6da3928,0x09b50081,0x76403929}},	//   deli, нти_, জেলা, temy,
   {{0x44e9392a,0x26dd0d2a,0x644132d7,0x66c50103}},	//   _bú_, _ciwo_, eeli, tóka,
   {{0x6441392b,0xd49a392c,0x7640392d,0x200a392e}},	//   feli, ерн_, remy, kabi_,
   {{0x6441392f,0x27f7000d,0x62840010,0x44e93930}},	//   geli, čení_, _alio, _dú_,
   {{0xd7ef00e3,0x44e90220,0x6284009c,0x200a0d2a}},	//   _ركن_, _eú_, _blio, dabi_,
   {{0x62840441,0x7d0d3931,0x75200051,0x0cb009c4}},	//   _clio, ysas, pumz, जकुम,
   {{0x44e9187e,0x628401ec,0x518413a4,0xd378007f}},	//   _gú_, _dlio, бура, syć_,
   {{0x6441020e,0x200a3932,0x224d3933,0x20050155}},	//   celi, gabi_, žek_, úli_,
   {{0x447b0130,0x1ee700cd,0xdfd50ab3,0xe80c07d5}},	//   _אנגע, اوری_, ровы, _सजना_,
   {{0x628407bc,0x7d0d3934,0xf3130dce,0xe3130dce}},	//   _glio, tsas, _ابوظ, _ابوب,
   {{0xe21400ab,0xd83800d4,0xddc600c6,0x320b0133}},	// [2df0] _طبيع, _obč_, _pokš, macy_,
   {{0x7d0d3935,0x2292033b,0x320b007f,0xb21b0537}},	//   rsas, vški_, lacy_, skæd,
   {{0x62840084,0x9f51037a,0x645e009c,0x66d500c6}},	//   _ylio, razó_, _òpiu, _iškv,
   {{0x64413936,0xa3c90635,0x7c250037,0xdb1c0052}},	//   zeli, लेट_, sghr, _zyrë,
   {{0x44250150,0x64413937,0x7ae9033b,0xdb1c0206}},	//   ygl_, yeli, _četu, _vzrá,
   {{0x44e90d79,0x7e6d007a,0xfc67008f,0x0715166f}},	//   _rú_, ljap, _съмн, афия,
   {{0x44e93938,0xb5fd0087,0x26dd3939,0x00000000}},	//   _sú_, ljši, _piwo_, --,
   {{0x6441393a,0x7f3c00c1,0xd8380154,0x200a393b}},	//   weli, געהו, _ebč_, zabi_,
   {{0xc48519e8,0x26c300d9,0xe8df00de,0xb5fd033b}},	//   илик, ējo_, _trốn_, njši,
   {{0x99840080,0x7ae700dd,0x44e900de,0x6284152f}},	//   _الكو, _kujt, _vú_, _slio,
   {{0x62662de9,0x200a393c,0x6abb0172,0x6aa900f3}},	//   авна, vabi_, _kkuf, _kjef,
   {{0x44e9393d,0xe29a393e,0xc5d502ec,0x6723393f}},	//   _tú_, там_, _кіль, munj,
   {{0x273100ef,0x644130da,0x672302e7,0x200a3940}},	//   _hơn_, peli, lunj, tabi_,
   {{0xe3b000cd,0x69c90350,0x057400d1,0x224200f3}},	//   _کره_, _mzee, _دامد, sekk_,
   {{0x672306ee,0x200a3941,0xb4c3034d,0xb4c10f42}},	//   nunj, rabi_, ्षी_, ंती_,
   {{0x6284068d,0x200a3942,0x7e6d0167,0x39490094}},	//   _ulio, sabi_, gjap, ťasy_,
   {{0xb2bb00a1,0x61e43943,0x6146001f,0x4d661b29}},	// [2e00] _במקר, _igil, _тепа, шкав,
   {{0x6723063d,0xc5d70081,0x6abb3944,0xf8a50281}},	//   kunj, _সভাপ, _akuf, _رک_,
   {{0xf1bf0830,0x0b4617e3,0xa3c90096,0x657b0027}},	//   ngán_, рнен, लेच_, hyuh,
   {{0x53360130,0xb4c12235,0x67230580,0x7e6d1175}},	//   ינען_, ंतु_, dunj, cjap,
   {{0x656f01bf,0x68460c3f,0x186a1c0e,0xe6da01cd}},	//   ächl, инда, кади_, ðsíð,
   {{0xfb2600cd,0xaca40174,0x57f31fdb,0x6abb019f}},	//   _پرسپ, _krọs, општ, _ekuf,
   {{0x3cec0455,0x27310019,0xa7b832e3,0x67233945}},	//   _अंडे_, _cơn_, ылку_, gunj,
   {{0x66c50102,0x2baf0775,0x61e43946,0xfaa63947}},	//   sókn, _जुटा, _ngil, _табо,
   {{0x320b3948,0x657b00f9,0x3e7c0206,0x54b800e5}},	//   vacy_, gyuh, _cíti_, лгия_,
   {{0x37b20033,0x7ae000da,0x229200c6,0x00000000}},	//   টেগর, _himt, išku_, --,
   {{0x9473054f,0x7ae03949,0x0eb6074c,0x00000000}},	//   تديا, _kimt, ंवाड, --,
   {{0x48fd000d,0x22820032,0x9f61020d,0x7ae000bd}},	//   रीको_, _dóko_, _épée_, _jimt,
   {{0x64a61553,0x320b394a,0xe693015a,0xe29801b3}},	//   _када, racy_, _بلند, раў_,
   {{0x653b0341,0x61e4394b,0x69c017e1,0x27240294}},	//   _סעוד, _egil, _myme, _ịnye_,
   {{0xa3b709b4,0x9e070c3f,0xddc60034,0xcebb0291}},	//   _پاور_, ичал, _nakł, вља_,
   {{0x33db00ca,0xdc0f045f,0x2904010a,0x7ae0394c}},	//   _בחוד, ाण्ड_, _owma_, _nimt,
   {{0x629d394d,0x7e6d13ce,0x291d0169,0x78b80537}},	// [2e10] miso, rjap, xrwa_, kovv,
   {{0xfd4d00ef,0x91bc00a1,0x629d394e,0x6abb038c}},	//   _khoả, _במחי, liso, _skuf,
   {{0x69c0394f,0x7ae00167,0x39f40134,0x60990018}},	//   _ayme, _bimt, _ịzọ_, _لنکس_,
   {{0x672330ff,0x69c0057a,0xbddb01dc,0x7ae00381}},	//   vunj, _byme, _daèr, _cimt,
   {{0x27310019,0x69c00150,0xc879078e,0x00000000}},	//   _sơn_, _cyme, _huşi_, --,
   {{0x6723048e,0x6c8500e3,0x6d9e0090,0x291d18fe}},	//   tunj, _السم, _dħaħ, rrwa_,
   {{0x629d3950,0x3e7c02c6,0x7ae03951,0x00000000}},	//   kiso, _síti_, _fimt, --,
   {{0x9aa500bf,0x6abb0060,0x7ae0013f,0xe51800b7}},	//   _امرو, _ukuf, _gimt, _दिशि_,
   {{0xddc600a5,0x1fd4039d,0x69c00150,0x69c90a4b}},	//   _zakł, _दण्ड, _gyme, _uzee,
   {{0xd8740080,0xb4c33952,0x61e43953,0x5f180034}},	//   _والب, ्षे_, _sgil, _फिल्_,
   {{0xdb1c0257,0x7ae0023e,0x657b2375,0xf1d00d61}},	//   _pyré, _yimt, syuh, _सृजन,
   {{0x68e13954,0x629d3955,0xbb3a0266,0xeb3a006e}},	//   _hild, giso, נערי, נערש,
   {{0x68e10400,0x940c00a7,0x61e40090,0x00000000}},	//   _kild, hidə_, _vgil, --,
   {{0x037909e5,0x68e109aa,0xa3b2009f,0x44fb0072}},	//   _محبت_, _jild, _झुक_, _iª_,
   {{0x629d3956,0x44fb002b,0x03a20036,0x61e91656}},	//   biso, _hª_, _нишо, žela,
   {{0x681b01d3,0x6e3b037a,0x0206007e,0x68e9014b}},	//   lādē, _ñubl, _узин, _oued,
   {{0x6ab9009c,0x7ae00138,0x0dca11c0,0x648401f7}},	// [2e20] dowf, _rimt, улай_, _mòin,
   {{0x7ae93957,0x7ae03958,0x44fb3959,0x7e210789}},	//   _četr, _simt, _mª_, यलॉग_,
   {{0xb5fd0087,0x394d00b3,0x22520154,0x6f6300d3}},	//   ljšu, _ases_, _kayk_, _евэз,
   {{0x69c0058a,0x7f3b00c1,0x09d10033,0x68e913ea}},	//   _pyme, _געטו, িশনা, _bued,
   {{0x68e1395a,0x7ae0023e,0xbcfb0139,0x391300d6}},	//   _bild, _vimt, _aréf, змір,
   {{0xb4c306ed,0x69c0135f,0x629d395b,0xbcfb003e}},	//   ्षो_, _vyme, ziso, _bréf,
   {{0x68e1395c,0x394d08a8,0xd6d00b05,0xbb860037}},	//   _dild, _eses_, وقت_, _الأي,
   {{0xdd080038,0x44f42ac0,0x994c0220,0x5678098e}},	//   _môže, опис, môže_, рбия_,
   {{0x68e9395d,0xbcfb0032,0x6484009c,0xd5ba022a}},	//   _gued, _eréf, _dòin, ыск_,
   {{0x68e10088,0x046633ca,0x44fb002b,0x629d0178}},	//   _gild, стим, _dª_, wiso,
   {{0x629d395e,0x44fb0072,0x00000000,0x00000000}},	//   tiso, _eª_, --, --,
   {{0x25a90335,0x85030d5b,0xe7f80ff9,0xc879044c}},	//   _žale_, _کوون, ुरवा_, _ruşi_,
   {{0x787d0c56,0x68e10233,0xe1ff395f,0xc50a0037}},	//   _sèvi, _yild, rbó_, _إتصل_,
   {{0x629d3960,0x68e1008a,0xfd4d0019,0xc879044c}},	//   siso, _xild, _thoả, _puşi_,
   {{0x443c374d,0x66d50138,0xe7f006eb,0xe43700ca}},	//   _ibv_, _iškr, _चलना_, _הרוח_,
   {{0x9df91a0e,0x6e943961,0x00000000,0x00000000}},	//   рнат_, пису, --, --,
   {{0xe29f0102,0x5c7505cb,0x7e2100aa,0x00000000}},	// [2e30] mið_, олат, यलौग_, --,
   {{0xe29f0102,0x68e93962,0xa3cf0ccb,0x7c2e0350}},	//   lið_, _rued, _शरम_, _ccbr,
   {{0xda7b0f1e,0xe80c0251,0x68e93963,0x7bda0146}},	//   ляд_, _सज़ा_, _sued, _útul,
   {{0x68e931f9,0x02c90336,0x66f10029,0xe29f0088}},	//   _pued, रतिभ, _nāka, nið_,
   {{0x68e93964,0x68e13965,0x3ea93966,0xa9693967}},	//   _qued, _pild, mnat_, рила_,
   {{0x46f53968,0xbcfb025a,0x68e111bc,0x26c4028d}},	//   очит, _préf, _qild, elmo_,
   {{0xe29f0682,0x68e13969,0x3ea9396a,0xf7710192}},	//   kið_, _vild, onat_, ظات_,
   {{0x3ea9396b,0xa3bc00c3,0x68e1396c,0x442e396d}},	//   nnat_, _आड़_, _wild, _acf_,
   {{0xe29f003e,0x68e1396e,0x9425129c,0x394d396f}},	//   dið_, _tild, омпе, _uses_,
   {{0x6d5d08a9,0x3ea93970,0x443c0231,0x00000000}},	//   _mrsa, hnat_, _cbv_, --,
   {{0xe29f0102,0x3ea93971,0x37ab1acb,0x52aa327e}},	//   fið_, knat_, _стан_, ивом_,
   {{0x6d4f3972,0xe29f0102,0x442e02e5,0x6d5d3973}},	//   _osca, gið_, _ecf_, _orsa,
   {{0xa5093974,0x3ea900b6,0x442e00b3,0xbbc63856}},	//   _тела_, dnat_, _fcf_, _वर्क,
   {{0x39400092,0xbcfb0113,0x70b40ff9,0x00000000}},	//   çisi_, _mréd, ंकेल, --,
   {{0x6d5d3975,0xafe30565,0x935800ae,0xe3d70033}},	//   _arsa, дорл, _грыу_, _দ্রব,
   {{0x3ea93976,0x6d5d02fa,0xd1322259,0xbddb0154}},	//   gnat_, _brsa, _قمع_, _obèd,
   {{0x660b0068,0x3ce30126,0x9f490220,0x6d5d009c}},	// [2e40] _megk, _bijv_, _škôl_, _crsa,
   {{0x85210b86,0x660b0018,0x3ea93094,0xa7fc0367}},	//   _मिनट_, _legk, anat_, _anın,
   {{0x6d5d3977,0x6d4f3978,0xbddb2502,0x2a640063}},	//   _ersa, _esca, _abèd, _pnmb_,
   {{0x6d4f00b3,0xfaa33979,0x00000000,0x00000000}},	//   _fsca, махо, --, --,
   {{0xbcfb397a,0x82d7006e,0x3ea0397b,0x00000000}},	//   _créd, קונג_, miit_, --,
   {{0x3ea0397c,0xb4b3000f,0x66f101d3,0x100a278e}},	//   liit_, झको_, _sāka, वरिश_,
   {{0xbcfb04d4,0x443c007e,0x8cb90287,0xa3de1e05}},	//   _prég, _rbv_, ्तरो, _दृढ_,
   {{0xbcfb00fd,0x9f582df7,0x3ea0397d,0x7bce30d9}},	//   _fréd, laró_, niit_, _izbu,
   {{0xe29f01cd,0x2d800d0a,0x442e014b,0x6484009c}},	//   við_, nyie_, _pcf_, _fòil,
   {{0x6fc0009d,0x7a4001cd,0xf7460b9e,0x3ea0010a}},	//   _शुभं, _fátæ, _мезо, hiit_,
   {{0xe29f0682,0xa3cf397e,0x249e397f,0xbcfb1e7d}},	//   tið_, _शरण_, ritm_, _trég,
   {{0x442e0090,0x81af0033,0x00000000,0x00000000}},	//   _wcf_, _করব_, --, --,
   {{0xe29f0682,0x3ea9030b,0x443c01cb,0x61e9195e}},	//   rið_, vnat_, _tbv_, želo,
   {{0xe29f0088,0xf8ca0e4c,0x66d500d8,0x00000000}},	//   sið_, ितिय, _uškr, --,
   {{0x3f850074,0xc05802ec,0x64483980,0x4fc4067f}},	//   álu_, ція_, medi, дста,
   {{0x64483981,0x3ea007ac,0xe29804f5,0x442c3982}},	//   ledi, giit_, _мај_, lgd_,
   {{0x3ea93983,0x442c01c0,0x7bce0095,0x98ca0034}},	// [2e50] rnat_, ogd_, _azbu, िताए,
   {{0x64483984,0x442c3985,0x3e7c04c8,0x6d5d2a4e}},	//   nedi, ngd_, _sítt_, _vrsa,
   {{0x20113986,0x442c3987,0xa8010143,0x3ea93988}},	//   mazi_, igd_, _íñig, pnat_,
   {{0xbcfb3989,0x6d5d080e,0x6448398a,0x628f00fe}},	//   _préd, _trsa, hedi, nhco,
   {{0x6d4f00d3,0x6d5d398b,0x7d010139,0x660b0313}},	//   _usca, _ursa, _dárò, _regk,
   {{0x644803ce,0xbcfb04ea,0x20112e60,0x1fdf0033}},	//   jedi, _crée, nazi_, _ব্যস,
   {{0x6448398c,0x6d4d398d,0x3e7c01ab,0x00000000}},	//   dedi, lwaa, _títt_, --,
   {{0x6e2d398e,0x2011398f,0x442c029a,0xbcfb0076}},	//   ngab, hazi_, egd_, _tréd,
   {{0x20113990,0x64483991,0x6d4d3992,0x6484009c}},	//   kazi_, fedi, nwaa, _eòim,
   {{0x20113993,0x68fb0124,0xa3cf22a3,0x660b3994}},	//   jazi_, _itud, _शरद_, _wegk,
   {{0x6d4d026d,0x395f0479,0xe7f00034,0x660b0113}},	//   hwaa, _hrus_, _चलता_, _tegk,
   {{0x6d4d3995,0x442c0ab2,0x395f3996,0x64480072}},	//   kwaa, agd_, _krus_, aedi,
   {{0x76490694,0x64483997,0x6f1500a5,0x3ea00e22}},	//   meey, bedi, eszc, viit_,
   {{0x64482b75,0x6d4d3998,0x20110c69,0x7649008a}},	//   cedi, dwaa, gazi_, leey,
   {{0x6e2d01bf,0x66f101d3,0x3ea03999,0x7529020a}},	//   fgab, _māko, tiit_, luez,
   {{0x88d10081,0x6d4d399a,0x7649399b,0x628f399c}},	//   াদিক, fwaa, neey, chco,
   {{0x6d4d399d,0x2011399e,0x9f5805fe,0x395f023e}},	// [2e60] gwaa, bazi_, taró_, _nrus_,
   {{0x31370054,0x66f100d9,0x3ea0399f,0x76490188}},	//   _צריך_, _nāko, siit_, heey,
   {{0x395f39a0,0x307b00a1,0x7649008a,0x68fb083e}},	//   _arus_, _האינ, keey, _atud,
   {{0x316039a1,0x7bce39a2,0x66c501cd,0xcee9010d}},	//   _kriz_, _vzbu, bóki, _گرین_,
   {{0x7649008a,0x442c0f63,0x9f5839a3,0xb9e3004d}},	//   deey, ygd_, paró_, ніши,
   {{0x644803be,0x7d160381,0x752901ff,0x648d00da}},	//   xedi, msys, duez, _lúib,
   {{0x68fb39a4,0xbb430b2e,0x7d160973,0xa7370037}},	//   _etud, _перк, lsys, كثير_,
   {{0xd90d1e49,0x20111b24,0x64480150,0x76490188}},	//   _چین_, zazi_, wedi, geey,
   {{0x64480b88,0x7d1639a5,0x201139a6,0x395f0b97}},	//   tedi, nsys, yazi_, _grus_,
   {{0x6aa20051,0x6f150034,0xc9170089,0x672314f3}},	//   liof, yszc, _מחמת_, brnj,
   {{0x442c0126,0x644839a7,0x201139a8,0x6d4d01c0}},	//   rgd_, redi, vazi_, zwaa,
   {{0x644839a9,0x201139aa,0xa25b0257,0x7649008c}},	//   sedi, wazi_, plôm, ceey,
   {{0x201139ab,0x644839ac,0x7aee01fa,0xd627004d}},	//   tazi_, pedi, _lubt, _хоче_,
   {{0xe521000d,0xe4d7001c,0x7d1607ee,0xe3af0281}},	//   _मिति_, _فونت_, dsys, ئری_,
   {{0x201139ad,0x543b00c1,0x643b00ca,0x31600062}},	//   razi_, _לעגא, _העונ, _eriz_,
   {{0x6d4d39ae,0x8c090033,0x201139af,0x62862271}},	//   twaa, _লাইন_, sazi_, ckko,
   {{0x6e2d39b0,0x31600218,0xbc79141b,0x201139b1}},	// [2e70] rgab, _griz_, обах_, pazi_,
   {{0x6d4d39b2,0x6e2d39b3,0x787d00fd,0x7982008c}},	//   rwaa, sgab, _lèvr, dyow,
   {{0x81af00c7,0x6d4d39b4,0x1a6509b4,0x628d1523}},	//   _করি_, swaa, ویسی_, _klao,
   {{0x7aee0472,0x7649008a,0x22593502,0xfbd000e3}},	//   _dubt, xeey, ndsk_, اتك_,
   {{0x6d4d02e7,0x81df0081,0x2d4d00cb,0x224b042c}},	//   qwaa, দুর_, _uže_, ieck_,
   {{0x81af0f71,0x7649332c,0x224b39b5,0xbcfb39b6}},	//   _করা_, weey, heck_, _eréc,
   {{0xe73939b7,0x764939b8,0x7aee008c,0x44f203a8}},	//   цей_, teey, _gubt, _aâ_,
   {{0x61e900cb,0x395f06dd,0xbcfb0220,0x656400e7}},	//   želj, _trus_, _gréc, _šiha,
   {{0xb3450396,0x395f18c4,0x76490694,0x394400dc}},	//   _opçã, _urus_, reey, _gpms_,
   {{0x212b0146,0xdeff003d,0x76493634,0xb21b02b6}},	//   duch_, ċċju_, seey, skæl,
   {{0x78a30087,0x628d0503,0xdc38006e,0x00000000}},	//   minv, _blao, לאזט_, --,
   {{0x7649008a,0x316039b9,0x628d152f,0x75290174}},	//   qeey, _priz_, _clao, puez,
   {{0x752908ec,0x628602fd,0x628d033c,0x00000000}},	//   quez, rkko, _dlao, --,
   {{0x62860006,0x92ae0081,0x648d0076