// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef EXTENSIONS_RENDERER_SERVICE_WORKER_DATA_H_
#define EXTENSIONS_RENDERER_SERVICE_WORKER_DATA_H_

#include <memory>

#include "base/macros.h"
#include "extensions/renderer/service_worker_request_sender.h"
#include "extensions/renderer/v8_schema_registry.h"

namespace extensions {
class ExtensionBindingsSystem;

// Per ServiceWorker data in worker thread.
// Contains: RequestSender, V8SchemaRegistry.
// TODO(lazyboy): Also put worker ScriptContexts in this.
class ServiceWorkerData {
 public:
  ServiceWorkerData(int64_t service_worker_version_id,
                    std::unique_ptr<ExtensionBindingsSystem> bindings_system);
  ~ServiceWorkerData();

  V8SchemaRegistry* v8_schema_registry() { return v8_schema_registry_.get(); }
  ExtensionBindingsSystem* bindings_system() { return bindings_system_.get(); }
  int64_t service_worker_version_id() const {
    return service_worker_version_id_;
  }

 private:
  const int64_t service_worker_version_id_;

  std::unique_ptr<V8SchemaRegistry> v8_schema_registry_;
  std::unique_ptr<ExtensionBindingsSystem> bindings_system_;

  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerData);
};

}  // namespace extensions

#endif  // EXTENSIONS_RENDERER_SERVICE_WORKER_DATA_H_
