// Copyright 2015 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

chrome.test.runTests([
  function waitForDeviceChangedEventTests() {
    chrome.test.listenOnce(chrome.audio.OnDevicesChanged, function(devices) {
      var deviceList = devices.map(function(device) {
        return {
          id: device.id,
          stableDeviceId: device.stableDeviceId,
          isInput: device.isInput,
          deviceType: device.deviceType,
          deviceName: device.deviceName,
          displayName: device.displayName
        };
      }).sort(function(lhs, rhs) {
        return Number.parseInt(lhs.id) - Number.parseInt(rhs.id);
      });

     chrome.test.assertEq([{
        id: '30001',
        stableDeviceId: '116606' /* 80001 ^ 0xFFFF */,
        isInput: false,
        deviceType: 'USB',
        deviceName: 'Jabra Speaker',
        displayName: 'Jabra Speaker 1'
      }, {
        id: '30002',
        stableDeviceId: '116605' /* 80002 ^ 0xFFFF */,
        isInput: false,
        deviceType: 'USB',
        deviceName: 'Jabra Speaker',
        displayName: 'Jabra Speaker 2'
      }, {
        id: '30003',
        stableDeviceId: '116604' /* 80003 ^ 0xFFFF */,
        isInput: false,
        deviceType: 'HDMI',
        deviceName: 'HDMI output',
        displayName: 'HDA Intel MID'
      }], deviceList);
    });
  }
]);

chrome.test.sendMessage('loaded');
