A type with `packed` representation hint has a field with `align`
representation hint.

Erroneous code example:

```compile_fail,E0588
#[repr(align(16))]
struct Aligned(i32);

#[repr(packed)] // error!
struct Packed(Aligned);
```

Just like you cannot have both `align` and `packed` representation hints on the
same type, a `packed` type cannot contain another type with the `align`
representation hint. However, you can do the opposite:

```
#[repr(packed)]
struct Packed(i32);

#[repr(align(16))] // ok!
struct Aligned(Packed);
```
