// Licensed under the Apache License, Version 2.0
// <LICENSE-APACHE or http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your option.
// All files in the project carrying such notice may not be copied, modified, or distributed
// except according to those terms.
use shared::basetsd::UINT64;
use shared::guiddef::GUID;
use shared::minwindef::{BOOL, DWORD};
use um::bits1_5::BG_AUTH_TARGET;
use um::bits3_0::{IBackgroundCopyJob4, IBackgroundCopyJob4Vtbl};
use um::bits4_0::{IBackgroundCopyFile4, IBackgroundCopyFile4Vtbl};
use um::winnt::{HRESULT, LPWSTR};
pub const BITS_COST_STATE_UNRESTRICTED: DWORD = 0x1;
pub const BITS_COST_STATE_CAPPED_USAGE_UNKNOWN: DWORD = 0x2;
pub const BITS_COST_STATE_BELOW_CAP: DWORD = 0x4;
pub const BITS_COST_STATE_NEAR_CAP: DWORD = 0x8;
pub const BITS_COST_STATE_OVERCAP_CHARGED: DWORD = 0x10;
pub const BITS_COST_STATE_OVERCAP_THROTTLED: DWORD = 0x20;
pub const BITS_COST_STATE_USAGE_BASED: DWORD = 0x40;
pub const BITS_COST_STATE_ROAMING: DWORD = 0x80;
pub const BITS_COST_OPTION_IGNORE_CONGESTION: DWORD = 0x80000000;
pub const BITS_COST_STATE_RESERVED: DWORD = 0x40000000;
pub const BITS_COST_STATE_TRANSFER_NOT_ROAMING: DWORD = BITS_COST_OPTION_IGNORE_CONGESTION
    | BITS_COST_STATE_USAGE_BASED | BITS_COST_STATE_OVERCAP_THROTTLED
    | BITS_COST_STATE_OVERCAP_CHARGED | BITS_COST_STATE_NEAR_CAP | BITS_COST_STATE_BELOW_CAP
    | BITS_COST_STATE_CAPPED_USAGE_UNKNOWN | BITS_COST_STATE_UNRESTRICTED;
pub const BITS_COST_STATE_TRANSFER_NO_SURCHARGE: DWORD = BITS_COST_OPTION_IGNORE_CONGESTION
    | BITS_COST_STATE_USAGE_BASED | BITS_COST_STATE_OVERCAP_THROTTLED | BITS_COST_STATE_NEAR_CAP
    | BITS_COST_STATE_BELOW_CAP | BITS_COST_STATE_CAPPED_USAGE_UNKNOWN
    | BITS_COST_STATE_UNRESTRICTED;
pub const BITS_COST_STATE_TRANSFER_STANDARD: DWORD = BITS_COST_OPTION_IGNORE_CONGESTION
    | BITS_COST_STATE_USAGE_BASED | BITS_COST_STATE_OVERCAP_THROTTLED | BITS_COST_STATE_BELOW_CAP
    | BITS_COST_STATE_CAPPED_USAGE_UNKNOWN | BITS_COST_STATE_UNRESTRICTED;
pub const BITS_COST_STATE_TRANSFER_UNRESTRICTED: DWORD = BITS_COST_OPTION_IGNORE_CONGESTION
    | BITS_COST_STATE_OVERCAP_THROTTLED | BITS_COST_STATE_UNRESTRICTED;
pub const BITS_COST_STATE_TRANSFER_ALWAYS: DWORD = BITS_COST_OPTION_IGNORE_CONGESTION
    | BITS_COST_STATE_ROAMING | BITS_COST_STATE_USAGE_BASED | BITS_COST_STATE_OVERCAP_THROTTLED
    | BITS_COST_STATE_OVERCAP_CHARGED | BITS_COST_STATE_NEAR_CAP | BITS_COST_STATE_BELOW_CAP
    | BITS_COST_STATE_CAPPED_USAGE_UNKNOWN | BITS_COST_STATE_UNRESTRICTED;
ENUM!{enum BITS_JOB_TRANSFER_POLICY {
    BITS_JOB_TRANSFER_POLICY_ALWAYS = 0x800000ff,
    BITS_JOB_TRANSFER_POLICY_NOT_ROAMING = 0x8000007f,
    BITS_JOB_TRANSFER_POLICY_NO_SURCHARGE = 0x8000006f,
    BITS_JOB_TRANSFER_POLICY_STANDARD = 0x80000067,
    BITS_JOB_TRANSFER_POLICY_UNRESTRICTED = 0x80000021,
}}
ENUM!{enum BITS_JOB_PROPERTY_ID {
    BITS_JOB_PROPERTY_ID_COST_FLAGS = 1,
    BITS_JOB_PROPERTY_NOTIFICATION_CLSID = 2,
    BITS_JOB_PROPERTY_DYNAMIC_CONTENT = 3,
    BITS_JOB_PROPERTY_HIGH_PERFORMANCE = 4,
    BITS_JOB_PROPERTY_MAX_DOWNLOAD_SIZE = 5,
    BITS_JOB_PROPERTY_USE_STORED_CREDENTIALS = 7,
    BITS_JOB_PROPERTY_MINIMUM_NOTIFICATION_INTERVAL_MS = 9,
    BITS_JOB_PROPERTY_ON_DEMAND_MODE = 10,
}}
UNION!{union BITS_JOB_PROPERTY_VALUE {
    [u64; 2],
    Dword Dword_mut: DWORD,
    ClsID ClsID_mut: GUID,
    Enable Enable_mut: BOOL,
    Uint64 Uint64_mut: UINT64,
    Target Target_mut: BG_AUTH_TARGET,
}}
ENUM!{enum BITS_FILE_PROPERTY_ID {
    BITS_FILE_PROPERTY_ID_HTTP_RESPONSE_HEADERS = 1,
}}
UNION!{union BITS_FILE_PROPERTY_VALUE {
    [usize; 1],
    String String_mut: LPWSTR,
}}
RIDL!{#[uuid(0xe847030c, 0xbbba, 0x4657, 0xaf, 0x6d, 0x48, 0x4a, 0xa4, 0x2b, 0xf1, 0xfe)]
interface IBackgroundCopyJob5(IBackgroundCopyJob5Vtbl):
    IBackgroundCopyJob4(IBackgroundCopyJob4Vtbl) {
    fn SetProperty(
        PropertyId: BITS_JOB_PROPERTY_ID,
        PropertyValue: BITS_JOB_PROPERTY_VALUE,
    ) -> HRESULT,
    fn GetProperty(
        PropertyId: BITS_JOB_PROPERTY_ID,
        PropertyValue: *mut BITS_JOB_PROPERTY_VALUE,
    ) -> HRESULT,
}}
RIDL!{#[uuid(0x85c1657f, 0xdafc, 0x40e8, 0x88, 0x34, 0xdf, 0x18, 0xea, 0x25, 0x71, 0x7e)]
interface IBackgroundCopyFile5(IBackgroundCopyFile5Vtbl):
    IBackgroundCopyFile4(IBackgroundCopyFile4Vtbl) {
    fn SetProperty(
        PropertyId: BITS_JOB_PROPERTY_ID,
        PropertyValue: BITS_JOB_PROPERTY_VALUE,
    ) -> HRESULT,
    fn GetProperty(
        PropertyId: BITS_JOB_PROPERTY_ID,
        PropertyValue: *mut BITS_JOB_PROPERTY_VALUE,
    ) -> HRESULT,
}}
