/* SourceCollection.c generated by valac 0.40.4, the Vala compiler
 * generated from SourceCollection.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;
typedef struct _DataCollectionPrivate DataCollectionPrivate;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;

#define TYPE_MARKER (marker_get_type ())
#define MARKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MARKER, Marker))
#define IS_MARKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MARKER))
#define MARKER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MARKER, MarkerIface))

typedef struct _Marker Marker;
typedef struct _MarkerIface MarkerIface;

#define TYPE_SOURCE_COLLECTION (source_collection_get_type ())
#define SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_COLLECTION, SourceCollection))
#define SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_COLLECTION, SourceCollectionClass))
#define IS_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_COLLECTION))
#define IS_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_COLLECTION))
#define SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_COLLECTION, SourceCollectionClass))

typedef struct _SourceCollection SourceCollection;
typedef struct _SourceCollectionClass SourceCollectionClass;
typedef struct _SourceCollectionPrivate SourceCollectionPrivate;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_SOURCE_BACKLINK (source_backlink_get_type ())
#define SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_BACKLINK, SourceBacklink))
#define SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))
#define IS_SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_BACKLINK))
#define IS_SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_BACKLINK))
#define SOURCE_BACKLINK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))

typedef struct _SourceBacklink SourceBacklink;
typedef struct _SourceBacklinkClass SourceBacklinkClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;

#define SOURCE_COLLECTION_TYPE_DESTROY_COUNTER (source_collection_destroy_counter_get_type ())
#define SOURCE_COLLECTION_DESTROY_COUNTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SOURCE_COLLECTION_TYPE_DESTROY_COUNTER, SourceCollectionDestroyCounter))
#define SOURCE_COLLECTION_DESTROY_COUNTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SOURCE_COLLECTION_TYPE_DESTROY_COUNTER, SourceCollectionDestroyCounterClass))
#define SOURCE_COLLECTION_IS_DESTROY_COUNTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SOURCE_COLLECTION_TYPE_DESTROY_COUNTER))
#define SOURCE_COLLECTION_IS_DESTROY_COUNTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SOURCE_COLLECTION_TYPE_DESTROY_COUNTER))
#define SOURCE_COLLECTION_DESTROY_COUNTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SOURCE_COLLECTION_TYPE_DESTROY_COUNTER, SourceCollectionDestroyCounterClass))

typedef struct _SourceCollectionDestroyCounter SourceCollectionDestroyCounter;
typedef struct _SourceCollectionDestroyCounterClass SourceCollectionDestroyCounterClass;
typedef struct _SourceCollectionDestroyCounterPrivate SourceCollectionDestroyCounterPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	SOURCE_COLLECTION_DESTROY_COUNTER_0_PROPERTY,
	SOURCE_COLLECTION_DESTROY_COUNTER_NUM_PROPERTIES
};
static GParamSpec* source_collection_destroy_counter_properties[SOURCE_COLLECTION_DESTROY_COUNTER_NUM_PROPERTIES];
enum  {
	SOURCE_COLLECTION_ITEMS_UNLINKING_SIGNAL,
	SOURCE_COLLECTION_ITEMS_RELINKED_SIGNAL,
	SOURCE_COLLECTION_ITEM_DESTROYED_SIGNAL,
	SOURCE_COLLECTION_ITEMS_DESTROYED_SIGNAL,
	SOURCE_COLLECTION_UNLINKED_DESTROYED_SIGNAL,
	SOURCE_COLLECTION_BACKLINK_REMOVED_SIGNAL,
	SOURCE_COLLECTION_NUM_SIGNALS
};
static guint source_collection_signals[SOURCE_COLLECTION_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef gint64 (*Comparator) (void* a, void* b, void* user_data);
typedef gboolean (*ComparatorPredicate) (DataObject* object, Alteration* alteration, void* user_data);
typedef gboolean (*ProgressMonitor) (guint64 current, guint64 total, gboolean do_event_loop, void* user_data);
struct _MarkerIface {
	GTypeInterface parent_iface;
	void (*mark) (Marker* self, DataObject* object);
	void (*unmark) (Marker* self, DataObject* object);
	gboolean (*toggle) (Marker* self, DataObject* object);
	void (*mark_many) (Marker* self, GeeCollection* list);
	void (*unmark_many) (Marker* self, GeeCollection* list);
	void (*mark_all) (Marker* self);
	gint (*get_count) (Marker* self);
	GeeCollection* (*get_all) (Marker* self);
};

struct _DataCollection {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DataCollectionPrivate * priv;
};

struct _DataCollectionClass {
	GTypeClass parent_class;
	void (*finalize) (DataCollection *self);
	gchar* (*to_string) (DataCollection* self);
	void (*notify_items_added) (DataCollection* self, GeeIterable* added);
	void (*notify_items_removed) (DataCollection* self, GeeIterable* removed);
	void (*notify_contents_altered) (DataCollection* self, GeeIterable* added, GeeIterable* removed);
	void (*notify_items_altered) (DataCollection* self, GeeMap* items);
	void (*notify_ordering_changed) (DataCollection* self);
	void (*notify_property_set) (DataCollection* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_property_cleared) (DataCollection* self, const gchar* name);
	gboolean (*valid_type) (DataCollection* self, DataObject* object);
	void (*set_comparator) (DataCollection* self, Comparator comparator, void* comparator_target, ComparatorPredicate predicate, void* predicate_target);
	void (*reset_comparator) (DataCollection* self);
	GeeCollection* (*get_all) (DataCollection* self);
	gint (*get_count) (DataCollection* self);
	DataObject* (*get_at) (DataCollection* self, gint index);
	gint (*index_of) (DataCollection* self, DataObject* object);
	gboolean (*contains) (DataCollection* self, DataObject* object);
	gboolean (*add) (DataCollection* self, DataObject* object);
	GeeCollection* (*add_many) (DataCollection* self, GeeCollection* objects, ProgressMonitor monitor, void* monitor_target);
	void (*remove_marked) (DataCollection* self, Marker* m);
	void (*clear) (DataCollection* self);
	void (*close) (DataCollection* self);
	void (*notify_frozen) (DataCollection* self);
	void (*notify_thawed) (DataCollection* self);
	void (*items_added) (DataCollection* self, GeeIterable* added);
	void (*items_removed) (DataCollection* self, GeeIterable* removed);
	void (*contents_altered) (DataCollection* self, GeeIterable* added, GeeIterable* removed);
	void (*items_altered) (DataCollection* self, GeeMap* items);
	void (*ordering_changed) (DataCollection* self);
	void (*property_set) (DataCollection* self, const gchar* name, GValue* old, GValue* val);
	void (*property_cleared) (DataCollection* self, const gchar* name);
	void (*frozen) (DataCollection* self);
	void (*thawed) (DataCollection* self);
};

struct _SourceCollection {
	DataCollection parent_instance;
	SourceCollectionPrivate * priv;
};

struct _SourceCollectionClass {
	DataCollectionClass parent_class;
	gboolean (*holds_type_of_source) (SourceCollection* self, DataSource* source);
	void (*notify_items_unlinking) (SourceCollection* self, GeeCollection* unlinking);
	void (*notify_items_relinked) (SourceCollection* self, GeeCollection* relinked);
	void (*notify_item_destroyed) (SourceCollection* self, DataSource* source);
	void (*notify_items_destroyed) (SourceCollection* self, GeeCollection* destroyed);
	void (*notify_unlinked_destroyed) (SourceCollection* self, DataSource* unlinked);
	void (*notify_backlink_removed) (SourceCollection* self, SourceBacklink* backlink, GeeCollection* sources);
	gboolean (*has_backlink) (SourceCollection* self, SourceBacklink* backlink);
	void (*remove_backlink) (SourceCollection* self, SourceBacklink* backlink);
	void (*items_unlinking) (SourceCollection* self, GeeCollection* unlinking);
	void (*items_relinked) (SourceCollection* self, GeeCollection* relinked);
	void (*item_destroyed) (SourceCollection* self, DataSource* source);
	void (*items_destroyed) (SourceCollection* self, GeeCollection* destroyed);
	void (*unlinked_destroyed) (SourceCollection* self, DataSource* source);
	void (*backlink_removed) (SourceCollection* self, SourceBacklink* backlink, GeeCollection* sources);
};

struct _SourceCollectionPrivate {
	GeeMultiMap* backlinks;
};

typedef gboolean (*MarkedAction) (DataObject* object, GObject* user, void* user_data);
struct _SourceCollectionDestroyCounter {
	GObject parent_instance;
	SourceCollectionDestroyCounterPrivate * priv;
	Marker* remove_marker;
	GeeArrayList* notify_list;
	GeeArrayList* not_removed;
};

struct _SourceCollectionDestroyCounterClass {
	GObjectClass parent_class;
};


static gpointer source_collection_parent_class = NULL;
static gpointer source_collection_destroy_counter_parent_class = NULL;

gpointer data_collection_ref (gpointer instance);
void data_collection_unref (gpointer instance);
GParamSpec* param_spec_data_collection (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
void value_set_data_collection (GValue* value,
                                gpointer v_object);
void value_take_data_collection (GValue* value,
                                 gpointer v_object);
gpointer value_get_data_collection (const GValue* value);
GType data_collection_get_type (void) G_GNUC_CONST;
GType data_object_get_type (void) G_GNUC_CONST;
gpointer alteration_ref (gpointer instance);
void alteration_unref (gpointer instance);
GParamSpec* param_spec_alteration (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
void value_set_alteration (GValue* value,
                           gpointer v_object);
void value_take_alteration (GValue* value,
                            gpointer v_object);
gpointer value_get_alteration (const GValue* value);
GType alteration_get_type (void) G_GNUC_CONST;
GType marker_get_type (void) G_GNUC_CONST;
GType source_collection_get_type (void) G_GNUC_CONST;
GType data_source_get_type (void) G_GNUC_CONST;
gpointer source_backlink_ref (gpointer instance);
void source_backlink_unref (gpointer instance);
GParamSpec* param_spec_source_backlink (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
void value_set_source_backlink (GValue* value,
                                gpointer v_object);
void value_take_source_backlink (GValue* value,
                                 gpointer v_object);
gpointer value_get_source_backlink (const GValue* value);
GType source_backlink_get_type (void) G_GNUC_CONST;
#define SOURCE_COLLECTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SOURCE_COLLECTION, SourceCollectionPrivate))
SourceCollection* source_collection_construct (GType object_type,
                                               const gchar* name);
DataCollection* data_collection_new (const gchar* name);
DataCollection* data_collection_construct (GType object_type,
                                           const gchar* name);
gboolean source_collection_holds_type_of_source (SourceCollection* self,
                                                 DataSource* source);
static gboolean source_collection_real_holds_type_of_source (SourceCollection* self,
                                                      DataSource* source);
void source_collection_notify_items_unlinking (SourceCollection* self,
                                               GeeCollection* unlinking);
static void source_collection_real_notify_items_unlinking (SourceCollection* self,
                                                    GeeCollection* unlinking);
void source_collection_notify_items_relinked (SourceCollection* self,
                                              GeeCollection* relinked);
static void source_collection_real_notify_items_relinked (SourceCollection* self,
                                                   GeeCollection* relinked);
void source_collection_notify_item_destroyed (SourceCollection* self,
                                              DataSource* source);
static void source_collection_real_notify_item_destroyed (SourceCollection* self,
                                                   DataSource* source);
void source_collection_notify_items_destroyed (SourceCollection* self,
                                               GeeCollection* destroyed);
static void source_collection_real_notify_items_destroyed (SourceCollection* self,
                                                    GeeCollection* destroyed);
void source_collection_notify_unlinked_destroyed (SourceCollection* self,
                                                  DataSource* unlinked);
static void source_collection_real_notify_unlinked_destroyed (SourceCollection* self,
                                                       DataSource* unlinked);
void source_collection_notify_backlink_removed (SourceCollection* self,
                                                SourceBacklink* backlink,
                                                GeeCollection* sources);
static void source_collection_real_notify_backlink_removed (SourceCollection* self,
                                                     SourceBacklink* backlink,
                                                     GeeCollection* sources);
static gboolean source_collection_real_valid_type (DataCollection* base,
                                            DataObject* object);
GType thumbnail_source_get_type (void) G_GNUC_CONST;
GType media_source_get_type (void) G_GNUC_CONST;
gint source_collection_destroy_marked (SourceCollection* self,
                                       Marker* marker,
                                       gboolean delete_backing,
                                       ProgressMonitor monitor,
                                       void* monitor_target,
                                       GeeList* not_removed);
static GType source_collection_destroy_counter_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
Marker* data_collection_start_marking (DataCollection* self);
static SourceCollectionDestroyCounter* source_collection_destroy_counter_new (Marker* remove_marker);
static SourceCollectionDestroyCounter* source_collection_destroy_counter_construct (GType object_type,
                                                                             Marker* remove_marker);
void data_collection_act_on_marked (DataCollection* self,
                                    Marker* m,
                                    MarkedAction action,
                                    void* action_target,
                                    ProgressMonitor monitor,
                                    void* monitor_target,
                                    GObject* user);
static gboolean source_collection_destroy_and_delete_source (SourceCollection* self,
                                                      DataObject* object,
                                                      GObject* user);
static gboolean _source_collection_destroy_and_delete_source_marked_action (DataObject* object,
                                                                     GObject* user,
                                                                     gpointer self);
static gboolean source_collection_destroy_source (SourceCollection* self,
                                           DataObject* object,
                                           GObject* user);
static gboolean _source_collection_destroy_source_marked_action (DataObject* object,
                                                          GObject* user,
                                                          gpointer self);
void data_collection_remove_marked (DataCollection* self,
                                    Marker* m);
gboolean data_source_internal_delete_backing (DataSource* self,
                                              GError** error);
void data_source_internal_mark_for_destroy (DataSource* self);
void data_source_destroy (DataSource* self);
void marker_mark (Marker* self,
                  DataObject* object);
void source_collection_internal_backlink_set (SourceCollection* self,
                                              DataSource* source,
                                              SourceBacklink* backlink);
guint source_backlink_hash_func (SourceBacklink* backlink);
static guint _source_backlink_hash_func_gee_hash_data_func (gconstpointer v,
                                                     gpointer self);
gboolean source_backlink_equal_func (SourceBacklink* alink,
                                     SourceBacklink* blink);
static gboolean _source_backlink_equal_func_gee_equal_data_func (gconstpointer a,
                                                          gconstpointer b,
                                                          gpointer self);
void source_collection_internal_backlink_removed (SourceCollection* self,
                                                  DataSource* source,
                                                  SourceBacklink* backlink);
gboolean source_collection_has_backlink (SourceCollection* self,
                                         SourceBacklink* backlink);
static gboolean source_collection_real_has_backlink (SourceCollection* self,
                                              SourceBacklink* backlink);
GeeCollection* source_collection_unlink_marked (SourceCollection* self,
                                                Marker* marker,
                                                ProgressMonitor monitor,
                                                void* monitor_target);
static gboolean source_collection_prepare_for_unlink (SourceCollection* self,
                                               DataObject* object,
                                               GObject* user);
static gboolean _source_collection_prepare_for_unlink_marked_action (DataObject* object,
                                                              GObject* user,
                                                              gpointer self);
Marker* data_collection_mark_many (DataCollection* self,
                                   GeeCollection* objects);
void data_source_notify_unlinking (DataSource* self,
                                   SourceCollection* collection);
void source_collection_relink (SourceCollection* self,
                               DataSource* source);
void data_source_notify_relinking (DataSource* self,
                                   SourceCollection* collection);
gboolean data_collection_add (DataCollection* self,
                              DataObject* object);
GeeCollection* data_collection_get_singleton (DataObject* object);
void data_source_notify_relinked (DataSource* self);
void source_collection_relink_many (SourceCollection* self,
                                    GeeCollection* relink);
GeeCollection* data_collection_add_many (DataCollection* self,
                                         GeeCollection* objects,
                                         ProgressMonitor monitor,
                                         void* monitor_target);
void source_collection_remove_backlink (SourceCollection* self,
                                        SourceBacklink* backlink);
static void source_collection_real_remove_backlink (SourceCollection* self,
                                             SourceBacklink* backlink);
gboolean data_source_remove_backlink (DataSource* self,
                                      SourceBacklink* backlink);
static void source_collection_real_items_unlinking (SourceCollection* self,
                                             GeeCollection* unlinking);
static void source_collection_real_items_relinked (SourceCollection* self,
                                            GeeCollection* relinked);
static void source_collection_real_item_destroyed (SourceCollection* self,
                                            DataSource* source);
static void source_collection_real_items_destroyed (SourceCollection* self,
                                             GeeCollection* destroyed);
static void source_collection_real_unlinked_destroyed (SourceCollection* self,
                                                DataSource* source);
static void source_collection_real_backlink_removed (SourceCollection* self,
                                              SourceBacklink* backlink,
                                              GeeCollection* sources);
static void g_cclosure_user_marshal_VOID__SOURCE_BACKLINK_OBJECT (GClosure * closure,
                                                           GValue * return_value,
                                                           guint n_param_values,
                                                           const GValue * param_values,
                                                           gpointer invocation_hint,
                                                           gpointer marshal_data);
static void source_collection_destroy_counter_finalize (GObject * obj);
static void source_collection_finalize (DataCollection * obj);


SourceCollection*
source_collection_construct (GType object_type,
                             const gchar* name)
{
	SourceCollection* self = NULL;
#line 50 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 51 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	self = (SourceCollection*) data_collection_construct (object_type, name);
#line 50 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	return self;
#line 451 "SourceCollection.c"
}


static gboolean
source_collection_real_holds_type_of_source (SourceCollection* self,
                                             DataSource* source)
{
	gboolean _tmp0_ = FALSE;
#line 54 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_critical ("Type `%s' does not implement abstract method `source_collection_holds_type_of_source'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 54 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	return _tmp0_;
#line 464 "SourceCollection.c"
}


gboolean
source_collection_holds_type_of_source (SourceCollection* self,
                                        DataSource* source)
{
#line 54 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_val_if_fail (IS_SOURCE_COLLECTION (self), FALSE);
#line 54 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	return SOURCE_COLLECTION_GET_CLASS (self)->holds_type_of_source (self, source);
#line 476 "SourceCollection.c"
}


static void
source_collection_real_notify_items_unlinking (SourceCollection* self,
                                               GeeCollection* unlinking)
{
#line 56 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (GEE_IS_COLLECTION (unlinking));
#line 57 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_signal_emit (self, source_collection_signals[SOURCE_COLLECTION_ITEMS_UNLINKING_SIGNAL], 0, unlinking);
#line 488 "SourceCollection.c"
}


void
source_collection_notify_items_unlinking (SourceCollection* self,
                                          GeeCollection* unlinking)
{
#line 56 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (IS_SOURCE_COLLECTION (self));
#line 56 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	SOURCE_COLLECTION_GET_CLASS (self)->notify_items_unlinking (self, unlinking);
#line 500 "SourceCollection.c"
}


static void
source_collection_real_notify_items_relinked (SourceCollection* self,
                                              GeeCollection* relinked)
{
#line 60 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (GEE_IS_COLLECTION (relinked));
#line 61 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_signal_emit (self, source_collection_signals[SOURCE_COLLECTION_ITEMS_RELINKED_SIGNAL], 0, relinked);
#line 512 "SourceCollection.c"
}


void
source_collection_notify_items_relinked (SourceCollection* self,
                                         GeeCollection* relinked)
{
#line 60 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (IS_SOURCE_COLLECTION (self));
#line 60 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	SOURCE_COLLECTION_GET_CLASS (self)->notify_items_relinked (self, relinked);
#line 524 "SourceCollection.c"
}


static void
source_collection_real_notify_item_destroyed (SourceCollection* self,
                                              DataSource* source)
{
#line 64 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (IS_DATA_SOURCE (source));
#line 65 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_signal_emit (self, source_collection_signals[SOURCE_COLLECTION_ITEM_DESTROYED_SIGNAL], 0, source);
#line 536 "SourceCollection.c"
}


void
source_collection_notify_item_destroyed (SourceCollection* self,
                                         DataSource* source)
{
#line 64 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (IS_SOURCE_COLLECTION (self));
#line 64 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	SOURCE_COLLECTION_GET_CLASS (self)->notify_item_destroyed (self, source);
#line 548 "SourceCollection.c"
}


static void
source_collection_real_notify_items_destroyed (SourceCollection* self,
                                               GeeCollection* destroyed)
{
#line 68 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (GEE_IS_COLLECTION (destroyed));
#line 69 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_signal_emit (self, source_collection_signals[SOURCE_COLLECTION_ITEMS_DESTROYED_SIGNAL], 0, destroyed);
#line 560 "SourceCollection.c"
}


void
source_collection_notify_items_destroyed (SourceCollection* self,
                                          GeeCollection* destroyed)
{
#line 68 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (IS_SOURCE_COLLECTION (self));
#line 68 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	SOURCE_COLLECTION_GET_CLASS (self)->notify_items_destroyed (self, destroyed);
#line 572 "SourceCollection.c"
}


static void
source_collection_real_notify_unlinked_destroyed (SourceCollection* self,
                                                  DataSource* unlinked)
{
#line 73 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (IS_DATA_SOURCE (unlinked));
#line 74 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_signal_emit (self, source_collection_signals[SOURCE_COLLECTION_UNLINKED_DESTROYED_SIGNAL], 0, unlinked);
#line 584 "SourceCollection.c"
}


void
source_collection_notify_unlinked_destroyed (SourceCollection* self,
                                             DataSource* unlinked)
{
#line 73 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (IS_SOURCE_COLLECTION (self));
#line 73 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	SOURCE_COLLECTION_GET_CLASS (self)->notify_unlinked_destroyed (self, unlinked);
#line 596 "SourceCollection.c"
}


static void
source_collection_real_notify_backlink_removed (SourceCollection* self,
                                                SourceBacklink* backlink,
                                                GeeCollection* sources)
{
#line 77 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (IS_SOURCE_BACKLINK (backlink));
#line 77 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (GEE_IS_COLLECTION (sources));
#line 79 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_signal_emit (self, source_collection_signals[SOURCE_COLLECTION_BACKLINK_REMOVED_SIGNAL], 0, backlink, sources);
#line 611 "SourceCollection.c"
}


void
source_collection_notify_backlink_removed (SourceCollection* self,
                                           SourceBacklink* backlink,
                                           GeeCollection* sources)
{
#line 77 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (IS_SOURCE_COLLECTION (self));
#line 77 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	SOURCE_COLLECTION_GET_CLASS (self)->notify_backlink_removed (self, backlink, sources);
#line 624 "SourceCollection.c"
}


static gboolean
source_collection_real_valid_type (DataCollection* base,
                                   DataObject* object)
{
	SourceCollection * self;
	gboolean result = FALSE;
#line 82 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SOURCE_COLLECTION, SourceCollection);
#line 82 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
#line 83 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	result = G_TYPE_CHECK_INSTANCE_TYPE (object, TYPE_DATA_SOURCE);
#line 83 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	return result;
#line 642 "SourceCollection.c"
}


static gboolean
_source_collection_destroy_and_delete_source_marked_action (DataObject* object,
                                                            GObject* user,
                                                            gpointer self)
{
	gboolean result;
	result = source_collection_destroy_and_delete_source ((SourceCollection*) self, object, user);
#line 93 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	return result;
#line 655 "SourceCollection.c"
}


static gboolean
_source_collection_destroy_source_marked_action (DataObject* object,
                                                 GObject* user,
                                                 gpointer self)
{
	gboolean result;
	result = source_collection_destroy_source ((SourceCollection*) self, object, user);
#line 95 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	return result;
#line 668 "SourceCollection.c"
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 98 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	return self ? g_object_ref (self) : NULL;
#line 677 "SourceCollection.c"
}


gint
source_collection_destroy_marked (SourceCollection* self,
                                  Marker* marker,
                                  gboolean delete_backing,
                                  ProgressMonitor monitor,
                                  void* monitor_target,
                                  GeeList* not_removed)
{
	gint result = 0;
	SourceCollectionDestroyCounter* counter = NULL;
	Marker* _tmp0_;
	Marker* _tmp1_;
	SourceCollectionDestroyCounter* _tmp2_;
	SourceCollectionDestroyCounter* _tmp3_;
	SourceCollectionDestroyCounter* _tmp19_;
	GeeArrayList* _tmp20_;
	SourceCollectionDestroyCounter* _tmp21_;
	Marker* _tmp22_;
	SourceCollectionDestroyCounter* _tmp25_;
	GeeArrayList* _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
#line 88 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_val_if_fail (IS_SOURCE_COLLECTION (self), 0);
#line 88 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_val_if_fail (IS_MARKER (marker), 0);
#line 88 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_val_if_fail ((not_removed == NULL) || GEE_IS_LIST (not_removed), 0);
#line 90 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp0_ = data_collection_start_marking (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
#line 90 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp1_ = _tmp0_;
#line 90 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp2_ = source_collection_destroy_counter_new (_tmp1_);
#line 90 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp3_ = _tmp2_;
#line 90 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_g_object_unref0 (_tmp1_);
#line 90 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	counter = _tmp3_;
#line 92 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	if (delete_backing) {
#line 723 "SourceCollection.c"
		SourceCollectionDestroyCounter* _tmp4_;
#line 93 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp4_ = counter;
#line 93 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		data_collection_act_on_marked (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), marker, _source_collection_destroy_and_delete_source_marked_action, self, monitor, monitor_target, G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, G_TYPE_OBJECT, GObject));
#line 729 "SourceCollection.c"
	} else {
		SourceCollectionDestroyCounter* _tmp5_;
#line 95 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp5_ = counter;
#line 95 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		data_collection_act_on_marked (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), marker, _source_collection_destroy_source_marked_action, self, monitor, monitor_target, G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, G_TYPE_OBJECT, GObject));
#line 736 "SourceCollection.c"
	}
	{
		GeeArrayList* _source_list = NULL;
		SourceCollectionDestroyCounter* _tmp6_;
		GeeArrayList* _tmp7_;
		GeeArrayList* _tmp8_;
		gint _source_size = 0;
		GeeArrayList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _source_index = 0;
#line 98 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp6_ = counter;
#line 98 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp7_ = _tmp6_->notify_list;
#line 98 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp8_ = _g_object_ref0 (_tmp7_);
#line 98 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_source_list = _tmp8_;
#line 98 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp9_ = _source_list;
#line 98 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp10_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 98 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp11_ = _tmp10_;
#line 98 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_source_size = _tmp11_;
#line 98 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_source_index = -1;
#line 98 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		while (TRUE) {
#line 768 "SourceCollection.c"
			gint _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			DataSource* source = NULL;
			GeeArrayList* _tmp15_;
			gint _tmp16_;
			gpointer _tmp17_;
			DataSource* _tmp18_;
#line 98 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			_tmp12_ = _source_index;
#line 98 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			_source_index = _tmp12_ + 1;
#line 98 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			_tmp13_ = _source_index;
#line 98 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			_tmp14_ = _source_size;
#line 98 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			if (!(_tmp13_ < _tmp14_)) {
#line 98 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
				break;
#line 789 "SourceCollection.c"
			}
#line 98 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			_tmp15_ = _source_list;
#line 98 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			_tmp16_ = _source_index;
#line 98 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			_tmp17_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp16_);
#line 98 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			source = (DataSource*) _tmp17_;
#line 99 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			_tmp18_ = source;
#line 99 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			source_collection_notify_item_destroyed (self, _tmp18_);
#line 98 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			_g_object_unref0 (source);
#line 805 "SourceCollection.c"
		}
#line 98 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_g_object_unref0 (_source_list);
#line 809 "SourceCollection.c"
	}
#line 100 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp19_ = counter;
#line 100 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp20_ = _tmp19_->notify_list;
#line 100 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	source_collection_notify_items_destroyed (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, GEE_TYPE_COLLECTION, GeeCollection));
#line 103 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp21_ = counter;
#line 103 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp22_ = _tmp21_->remove_marker;
#line 103 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	data_collection_remove_marked (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), _tmp22_);
#line 105 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	if (NULL != not_removed) {
#line 825 "SourceCollection.c"
		SourceCollectionDestroyCounter* _tmp23_;
		GeeArrayList* _tmp24_;
#line 106 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp23_ = counter;
#line 106 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp24_ = _tmp23_->not_removed;
#line 106 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		gee_collection_add_all (G_TYPE_CHECK_INSTANCE_CAST (not_removed, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, GEE_TYPE_COLLECTION, GeeCollection));
#line 834 "SourceCollection.c"
	}
#line 109 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp25_ = counter;
#line 109 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp26_ = _tmp25_->not_removed;
#line 109 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp27_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 109 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp28_ = _tmp27_;
#line 109 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	result = _tmp28_;
#line 109 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_g_object_unref0 (counter);
#line 109 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	return result;
#line 850 "SourceCollection.c"
}


static gboolean
source_collection_destroy_and_delete_source (SourceCollection* self,
                                             DataObject* object,
                                             GObject* user)
{
	gboolean result = FALSE;
	gboolean success = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	gboolean _tmp5_ = FALSE;
	GError * _inner_error_ = NULL;
#line 112 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_val_if_fail (IS_SOURCE_COLLECTION (self), FALSE);
#line 112 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
#line 112 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_val_if_fail ((user == NULL) || G_IS_OBJECT (user), FALSE);
#line 113 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	success = FALSE;
#line 873 "SourceCollection.c"
	{
		gboolean _tmp0_ = FALSE;
#line 115 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp0_ = data_source_internal_delete_backing (G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DATA_SOURCE, DataSource), &_inner_error_);
#line 115 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 880 "SourceCollection.c"
			goto __catch53_g_error;
		}
#line 115 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		success = _tmp0_;
#line 885 "SourceCollection.c"
	}
	goto __finally53;
	__catch53_g_error:
	{
		GError* err = NULL;
#line 114 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		err = _inner_error_;
#line 114 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_inner_error_ = NULL;
#line 117 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		success = FALSE;
#line 114 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_g_error_free0 (err);
#line 899 "SourceCollection.c"
	}
	__finally53:
#line 114 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 904 "SourceCollection.c"
		gboolean _tmp1_ = FALSE;
#line 114 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 114 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		g_clear_error (&_inner_error_);
#line 114 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		return _tmp1_;
#line 912 "SourceCollection.c"
	}
#line 120 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp3_ = success;
#line 120 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	if (!_tmp3_) {
#line 120 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp2_ = G_TYPE_CHECK_INSTANCE_TYPE (object, TYPE_MEDIA_SOURCE);
#line 920 "SourceCollection.c"
	} else {
#line 120 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp2_ = FALSE;
#line 924 "SourceCollection.c"
	}
#line 120 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	if (_tmp2_) {
#line 928 "SourceCollection.c"
		GeeArrayList* _tmp4_;
#line 121 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp4_ = G_TYPE_CHECK_INSTANCE_CAST (user, SOURCE_COLLECTION_TYPE_DESTROY_COUNTER, SourceCollectionDestroyCounter)->not_removed;
#line 121 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MEDIA_SOURCE, MediaSource));
#line 934 "SourceCollection.c"
	}
#line 124 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	if (source_collection_destroy_source (self, object, user)) {
#line 938 "SourceCollection.c"
		gboolean _tmp6_;
#line 124 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp6_ = success;
#line 124 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp5_ = _tmp6_;
#line 944 "SourceCollection.c"
	} else {
#line 124 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp5_ = FALSE;
#line 948 "SourceCollection.c"
	}
#line 124 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	result = _tmp5_;
#line 124 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	return result;
#line 954 "SourceCollection.c"
}


static gboolean
source_collection_destroy_source (SourceCollection* self,
                                  DataObject* object,
                                  GObject* user)
{
	gboolean result = FALSE;
	DataSource* source = NULL;
	DataSource* _tmp0_;
	Marker* _tmp1_;
	GeeArrayList* _tmp2_;
#line 127 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_val_if_fail (IS_SOURCE_COLLECTION (self), FALSE);
#line 127 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
#line 127 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_val_if_fail ((user == NULL) || G_IS_OBJECT (user), FALSE);
#line 128 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DATA_SOURCE, DataSource));
#line 128 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	source = _tmp0_;
#line 130 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	data_source_internal_mark_for_destroy (source);
#line 131 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	data_source_destroy (source);
#line 133 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (user, SOURCE_COLLECTION_TYPE_DESTROY_COUNTER, SourceCollectionDestroyCounter)->remove_marker;
#line 133 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	marker_mark (_tmp1_, G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_DATA_OBJECT, DataObject));
#line 134 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp2_ = G_TYPE_CHECK_INSTANCE_CAST (user, SOURCE_COLLECTION_TYPE_DESTROY_COUNTER, SourceCollectionDestroyCounter)->notify_list;
#line 134 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), source);
#line 136 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	result = TRUE;
#line 136 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_g_object_unref0 (source);
#line 136 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	return result;
#line 996 "SourceCollection.c"
}


static guint
_source_backlink_hash_func_gee_hash_data_func (gconstpointer v,
                                               gpointer self)
{
	guint result;
	result = source_backlink_hash_func ((SourceBacklink*) v);
#line 142 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	return result;
#line 1008 "SourceCollection.c"
}


static gboolean
_source_backlink_equal_func_gee_equal_data_func (gconstpointer a,
                                                 gconstpointer b,
                                                 gpointer self)
{
	gboolean result;
	result = source_backlink_equal_func ((SourceBacklink*) a, (SourceBacklink*) b);
#line 142 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	return result;
#line 1021 "SourceCollection.c"
}


void
source_collection_internal_backlink_set (SourceCollection* self,
                                         DataSource* source,
                                         SourceBacklink* backlink)
{
	GeeMultiMap* _tmp0_;
	GeeMultiMap* _tmp2_;
#line 140 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (IS_SOURCE_COLLECTION (self));
#line 140 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (IS_DATA_SOURCE (source));
#line 140 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (IS_SOURCE_BACKLINK (backlink));
#line 141 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp0_ = self->priv->backlinks;
#line 141 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	if (_tmp0_ == NULL) {
#line 1042 "SourceCollection.c"
		GeeHashMultiMap* _tmp1_;
#line 142 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp1_ = gee_hash_multi_map_new (TYPE_SOURCE_BACKLINK, (GBoxedCopyFunc) source_backlink_ref, (GDestroyNotify) source_backlink_unref, TYPE_DATA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _source_backlink_hash_func_gee_hash_data_func, NULL, NULL, _source_backlink_equal_func_gee_equal_data_func, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 142 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_g_object_unref0 (self->priv->backlinks);
#line 142 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		self->priv->backlinks = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_MULTI_MAP, GeeMultiMap);
#line 1050 "SourceCollection.c"
	}
#line 146 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp2_ = self->priv->backlinks;
#line 146 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	gee_multi_map_set (_tmp2_, backlink, source);
#line 1056 "SourceCollection.c"
}


void
source_collection_internal_backlink_removed (SourceCollection* self,
                                             DataSource* source,
                                             SourceBacklink* backlink)
{
	GeeMultiMap* _tmp0_;
	gboolean removed = FALSE;
	GeeMultiMap* _tmp1_;
#line 150 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (IS_SOURCE_COLLECTION (self));
#line 150 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (IS_DATA_SOURCE (source));
#line 150 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (IS_SOURCE_BACKLINK (backlink));
#line 151 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp0_ = self->priv->backlinks;
#line 151 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_vala_assert (_tmp0_ != NULL, "backlinks != null");
#line 153 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp1_ = self->priv->backlinks;
#line 153 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	removed = gee_multi_map_remove (_tmp1_, backlink, source);
#line 154 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_vala_assert (removed, "removed");
#line 1084 "SourceCollection.c"
}


static gboolean
source_collection_real_has_backlink (SourceCollection* self,
                                     SourceBacklink* backlink)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GeeMultiMap* _tmp1_;
#line 157 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_val_if_fail (IS_SOURCE_BACKLINK (backlink), FALSE);
#line 158 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp1_ = self->priv->backlinks;
#line 158 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	if (_tmp1_ != NULL) {
#line 1101 "SourceCollection.c"
		GeeMultiMap* _tmp2_;
#line 158 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp2_ = self->priv->backlinks;
#line 158 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp0_ = gee_multi_map_contains (_tmp2_, backlink);
#line 1107 "SourceCollection.c"
	} else {
#line 158 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp0_ = FALSE;
#line 1111 "SourceCollection.c"
	}
#line 158 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	result = _tmp0_;
#line 158 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	return result;
#line 1117 "SourceCollection.c"
}


gboolean
source_collection_has_backlink (SourceCollection* self,
                                SourceBacklink* backlink)
{
#line 157 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_val_if_fail (IS_SOURCE_COLLECTION (self), FALSE);
#line 157 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	return SOURCE_COLLECTION_GET_CLASS (self)->has_backlink (self, backlink);
#line 1129 "SourceCollection.c"
}


static gboolean
_source_collection_prepare_for_unlink_marked_action (DataObject* object,
                                                     GObject* user,
                                                     gpointer self)
{
	gboolean result;
	result = source_collection_prepare_for_unlink ((SourceCollection*) self, object, user);
#line 163 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	return result;
#line 1142 "SourceCollection.c"
}


GeeCollection*
source_collection_unlink_marked (SourceCollection* self,
                                 Marker* marker,
                                 ProgressMonitor monitor,
                                 void* monitor_target)
{
	GeeCollection* result = NULL;
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GeeArrayList* _tmp5_;
	GeeArrayList* _tmp6_;
	Marker* _tmp7_;
	Marker* _tmp8_;
#line 161 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_val_if_fail (IS_SOURCE_COLLECTION (self), NULL);
#line 161 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_val_if_fail (IS_MARKER (marker), NULL);
#line 162 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp0_ = gee_array_list_new (TYPE_DATA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 162 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	list = _tmp0_;
#line 163 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp1_ = list;
#line 163 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	data_collection_act_on_marked (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), marker, _source_collection_prepare_for_unlink_marked_action, self, monitor, monitor_target, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, G_TYPE_OBJECT, GObject));
#line 165 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp2_ = list;
#line 165 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp3_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 165 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp4_ = _tmp3_;
#line 165 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	if (_tmp4_ == 0) {
#line 166 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		result = NULL;
#line 166 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_g_object_unref0 (list);
#line 166 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		return result;
#line 1189 "SourceCollection.c"
	}
#line 168 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp5_ = list;
#line 168 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	source_collection_notify_items_unlinking (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_COLLECTION, GeeCollection));
#line 170 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp6_ = list;
#line 170 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp7_ = data_collection_mark_many (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_COLLECTION, GeeCollection));
#line 170 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp8_ = _tmp7_;
#line 170 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	data_collection_remove_marked (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), _tmp8_);
#line 170 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_g_object_unref0 (_tmp8_);
#line 172 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (list, GEE_TYPE_COLLECTION, GeeCollection);
#line 172 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	return result;
#line 1209 "SourceCollection.c"
}


static gboolean
source_collection_prepare_for_unlink (SourceCollection* self,
                                      DataObject* object,
                                      GObject* user)
{
	gboolean result = FALSE;
	DataSource* source = NULL;
	DataSource* _tmp0_;
#line 175 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_val_if_fail (IS_SOURCE_COLLECTION (self), FALSE);
#line 175 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
#line 175 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_val_if_fail ((user == NULL) || G_IS_OBJECT (user), FALSE);
#line 176 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DATA_SOURCE, DataSource));
#line 176 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	source = _tmp0_;
#line 178 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	data_source_notify_unlinking (source, self);
#line 179 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (user, GEE_TYPE_LIST, GeeList), GEE_TYPE_COLLECTION, GeeCollection), source);
#line 181 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	result = TRUE;
#line 181 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_g_object_unref0 (source);
#line 181 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	return result;
#line 1241 "SourceCollection.c"
}


void
source_collection_relink (SourceCollection* self,
                          DataSource* source)
{
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
#line 184 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (IS_SOURCE_COLLECTION (self));
#line 184 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (IS_DATA_SOURCE (source));
#line 185 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	data_source_notify_relinking (source, self);
#line 187 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	data_collection_add (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_DATA_OBJECT, DataObject));
#line 188 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp0_ = data_collection_get_singleton (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_DATA_OBJECT, DataObject));
#line 188 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection);
#line 188 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	source_collection_notify_items_relinked (self, _tmp1_);
#line 188 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_g_object_unref0 (_tmp1_);
#line 190 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	data_source_notify_relinked (source);
#line 1269 "SourceCollection.c"
}


void
source_collection_relink_many (SourceCollection* self,
                               GeeCollection* relink)
{
	gint _tmp0_;
	gint _tmp1_;
	GeeCollection* _tmp7_;
	GeeCollection* _tmp8_;
#line 193 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (IS_SOURCE_COLLECTION (self));
#line 193 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (GEE_IS_COLLECTION (relink));
#line 194 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp0_ = gee_collection_get_size (relink);
#line 194 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp1_ = _tmp0_;
#line 194 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	if (_tmp1_ == 0) {
#line 195 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		return;
#line 1293 "SourceCollection.c"
	}
	{
		GeeIterator* _source_it = NULL;
		GeeIterator* _tmp2_;
#line 197 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp2_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (relink, GEE_TYPE_ITERABLE, GeeIterable));
#line 197 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_source_it = _tmp2_;
#line 197 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		while (TRUE) {
#line 1304 "SourceCollection.c"
			GeeIterator* _tmp3_;
			DataSource* source = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			DataSource* _tmp6_;
#line 197 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			_tmp3_ = _source_it;
#line 197 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			if (!gee_iterator_next (_tmp3_)) {
#line 197 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
				break;
#line 1316 "SourceCollection.c"
			}
#line 197 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			_tmp4_ = _source_it;
#line 197 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			_tmp5_ = gee_iterator_get (_tmp4_);
#line 197 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			source = (DataSource*) _tmp5_;
#line 198 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			_tmp6_ = source;
#line 198 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			data_source_notify_relinking (_tmp6_, self);
#line 197 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			_g_object_unref0 (source);
#line 1330 "SourceCollection.c"
		}
#line 197 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_g_object_unref0 (_source_it);
#line 1334 "SourceCollection.c"
	}
#line 200 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp7_ = data_collection_add_many (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), relink, NULL, NULL);
#line 200 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp8_ = _tmp7_;
#line 200 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_g_object_unref0 (_tmp8_);
#line 201 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	source_collection_notify_items_relinked (self, relink);
#line 1344 "SourceCollection.c"
	{
		GeeIterator* _source_it = NULL;
		GeeIterator* _tmp9_;
#line 203 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp9_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (relink, GEE_TYPE_ITERABLE, GeeIterable));
#line 203 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_source_it = _tmp9_;
#line 203 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		while (TRUE) {
#line 1354 "SourceCollection.c"
			GeeIterator* _tmp10_;
			DataSource* source = NULL;
			GeeIterator* _tmp11_;
			gpointer _tmp12_;
			DataSource* _tmp13_;
#line 203 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			_tmp10_ = _source_it;
#line 203 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			if (!gee_iterator_next (_tmp10_)) {
#line 203 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
				break;
#line 1366 "SourceCollection.c"
			}
#line 203 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			_tmp11_ = _source_it;
#line 203 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			_tmp12_ = gee_iterator_get (_tmp11_);
#line 203 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			source = (DataSource*) _tmp12_;
#line 204 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			_tmp13_ = source;
#line 204 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			data_source_notify_relinked (_tmp13_);
#line 203 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			_g_object_unref0 (source);
#line 1380 "SourceCollection.c"
		}
#line 203 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_g_object_unref0 (_source_it);
#line 1384 "SourceCollection.c"
	}
}


static void
source_collection_real_remove_backlink (SourceCollection* self,
                                        SourceBacklink* backlink)
{
	GeeMultiMap* _tmp0_;
	GeeArrayList* sources = NULL;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeMultiMap* _tmp3_;
	GeeCollection* _tmp4_;
	GeeCollection* _tmp5_;
	GeeArrayList* _tmp18_;
#line 207 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (IS_SOURCE_BACKLINK (backlink));
#line 208 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp0_ = self->priv->backlinks;
#line 208 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	if (_tmp0_ == NULL) {
#line 209 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		return;
#line 1409 "SourceCollection.c"
	}
#line 212 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp1_ = gee_array_list_new (TYPE_DATA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 212 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	sources = _tmp1_;
#line 213 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp2_ = sources;
#line 213 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp3_ = self->priv->backlinks;
#line 213 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp4_ = gee_multi_map_get (_tmp3_, backlink);
#line 213 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp5_ = _tmp4_;
#line 213 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	gee_array_list_add_all (_tmp2_, _tmp5_);
#line 213 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_g_object_unref0 (_tmp5_);
#line 1427 "SourceCollection.c"
	{
		GeeArrayList* _source_list = NULL;
		GeeArrayList* _tmp6_;
		GeeArrayList* _tmp7_;
		gint _source_size = 0;
		GeeArrayList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _source_index = 0;
#line 215 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp6_ = sources;
#line 215 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp7_ = _g_object_ref0 (_tmp6_);
#line 215 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_source_list = _tmp7_;
#line 215 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp8_ = _source_list;
#line 215 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp9_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 215 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp10_ = _tmp9_;
#line 215 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_source_size = _tmp10_;
#line 215 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_source_index = -1;
#line 215 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		while (TRUE) {
#line 1455 "SourceCollection.c"
			gint _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			DataSource* source = NULL;
			GeeArrayList* _tmp14_;
			gint _tmp15_;
			gpointer _tmp16_;
			DataSource* _tmp17_;
#line 215 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			_tmp11_ = _source_index;
#line 215 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			_source_index = _tmp11_ + 1;
#line 215 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			_tmp12_ = _source_index;
#line 215 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			_tmp13_ = _source_size;
#line 215 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			if (!(_tmp12_ < _tmp13_)) {
#line 215 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
				break;
#line 1476 "SourceCollection.c"
			}
#line 215 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			_tmp14_ = _source_list;
#line 215 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			_tmp15_ = _source_index;
#line 215 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			_tmp16_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp15_);
#line 215 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			source = (DataSource*) _tmp16_;
#line 216 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			_tmp17_ = source;
#line 216 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			data_source_remove_backlink (_tmp17_, backlink);
#line 215 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			_g_object_unref0 (source);
#line 1492 "SourceCollection.c"
		}
#line 215 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_g_object_unref0 (_source_list);
#line 1496 "SourceCollection.c"
	}
#line 218 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp18_ = sources;
#line 218 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	source_collection_notify_backlink_removed (self, backlink, G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_COLLECTION, GeeCollection));
#line 207 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_g_object_unref0 (sources);
#line 1504 "SourceCollection.c"
}


void
source_collection_remove_backlink (SourceCollection* self,
                                   SourceBacklink* backlink)
{
#line 207 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (IS_SOURCE_COLLECTION (self));
#line 207 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	SOURCE_COLLECTION_GET_CLASS (self)->remove_backlink (self, backlink);
#line 1516 "SourceCollection.c"
}


static void
source_collection_real_items_unlinking (SourceCollection* self,
                                        GeeCollection* unlinking)
{
#line 20 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (GEE_IS_COLLECTION (unlinking));
#line 1526 "SourceCollection.c"
}


static void
source_collection_real_items_relinked (SourceCollection* self,
                                       GeeCollection* relinked)
{
#line 25 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (GEE_IS_COLLECTION (relinked));
#line 1536 "SourceCollection.c"
}


static void
source_collection_real_item_destroyed (SourceCollection* self,
                                       DataSource* source)
{
#line 30 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (IS_DATA_SOURCE (source));
#line 1546 "SourceCollection.c"
}


static void
source_collection_real_items_destroyed (SourceCollection* self,
                                        GeeCollection* destroyed)
{
#line 35 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (GEE_IS_COLLECTION (destroyed));
#line 1556 "SourceCollection.c"
}


static void
source_collection_real_unlinked_destroyed (SourceCollection* self,
                                           DataSource* source)
{
#line 40 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (IS_DATA_SOURCE (source));
#line 1566 "SourceCollection.c"
}


static void
source_collection_real_backlink_removed (SourceCollection* self,
                                         SourceBacklink* backlink,
                                         GeeCollection* sources)
{
#line 44 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (IS_SOURCE_BACKLINK (backlink));
#line 44 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (GEE_IS_COLLECTION (sources));
#line 1579 "SourceCollection.c"
}


static void
g_cclosure_user_marshal_VOID__SOURCE_BACKLINK_OBJECT (GClosure * closure,
                                                      GValue * return_value,
                                                      guint n_param_values,
                                                      const GValue * param_values,
                                                      gpointer invocation_hint,
                                                      gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__SOURCE_BACKLINK_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__SOURCE_BACKLINK_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (n_param_values == 3);
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		data1 = closure->data;
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		data2 = param_values->data[0].v_pointer;
#line 1605 "SourceCollection.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		data1 = param_values->data[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		data2 = closure->data;
#line 1611 "SourceCollection.c"
	}
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	callback = (GMarshalFunc_VOID__SOURCE_BACKLINK_OBJECT) (marshal_data ? marshal_data : cc->callback);
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	callback (data1, value_get_source_backlink (param_values + 1), g_value_get_object (param_values + 2), data2);
#line 1617 "SourceCollection.c"
}


static SourceCollectionDestroyCounter*
source_collection_destroy_counter_construct (GType object_type,
                                             Marker* remove_marker)
{
	SourceCollectionDestroyCounter * self = NULL;
	Marker* _tmp0_;
#line 13 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_val_if_fail (IS_MARKER (remove_marker), NULL);
#line 13 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	self = (SourceCollectionDestroyCounter*) g_object_new (object_type, NULL);
#line 14 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp0_ = _g_object_ref0 (remove_marker);
#line 14 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_g_object_unref0 (self->remove_marker);
#line 14 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	self->remove_marker = _tmp0_;
#line 13 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	return self;
#line 1639 "SourceCollection.c"
}


static SourceCollectionDestroyCounter*
source_collection_destroy_counter_new (Marker* remove_marker)
{
#line 13 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	return source_collection_destroy_counter_construct (SOURCE_COLLECTION_TYPE_DESTROY_COUNTER, remove_marker);
#line 1648 "SourceCollection.c"
}


static void
source_collection_destroy_counter_class_init (SourceCollectionDestroyCounterClass * klass)
{
#line 8 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	source_collection_destroy_counter_parent_class = g_type_class_peek_parent (klass);
#line 8 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	G_OBJECT_CLASS (klass)->finalize = source_collection_destroy_counter_finalize;
#line 1659 "SourceCollection.c"
}


static void
source_collection_destroy_counter_instance_init (SourceCollectionDestroyCounter * self)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
#line 10 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp0_ = gee_array_list_new (TYPE_DATA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 10 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	self->notify_list = _tmp0_;
#line 11 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp1_ = gee_array_list_new (TYPE_MEDIA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 11 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	self->not_removed = _tmp1_;
#line 1676 "SourceCollection.c"
}


static void
source_collection_destroy_counter_finalize (GObject * obj)
{
	SourceCollectionDestroyCounter * self;
#line 8 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SOURCE_COLLECTION_TYPE_DESTROY_COUNTER, SourceCollectionDestroyCounter);
#line 9 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_g_object_unref0 (self->remove_marker);
#line 10 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_g_object_unref0 (self->notify_list);
#line 11 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_g_object_unref0 (self->not_removed);
#line 8 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	G_OBJECT_CLASS (source_collection_destroy_counter_parent_class)->finalize (obj);
#line 1694 "SourceCollection.c"
}


static GType
source_collection_destroy_counter_get_type (void)
{
	static volatile gsize source_collection_destroy_counter_type_id__volatile = 0;
	if (g_once_init_enter (&source_collection_destroy_counter_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SourceCollectionDestroyCounterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) source_collection_destroy_counter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SourceCollectionDestroyCounter), 0, (GInstanceInitFunc) source_collection_destroy_counter_instance_init, NULL };
		GType source_collection_destroy_counter_type_id;
		source_collection_destroy_counter_type_id = g_type_register_static (G_TYPE_OBJECT, "SourceCollectionDestroyCounter", &g_define_type_info, 0);
		g_once_init_leave (&source_collection_destroy_counter_type_id__volatile, source_collection_destroy_counter_type_id);
	}
	return source_collection_destroy_counter_type_id__volatile;
}


static void
source_collection_class_init (SourceCollectionClass * klass)
{
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	source_collection_parent_class = g_type_class_peek_parent (klass);
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	((DataCollectionClass *) klass)->finalize = source_collection_finalize;
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_type_class_add_private (klass, sizeof (SourceCollectionPrivate));
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	((SourceCollectionClass *) klass)->holds_type_of_source = (gboolean (*) (SourceCollection *, DataSource*)) source_collection_real_holds_type_of_source;
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	((SourceCollectionClass *) klass)->notify_items_unlinking = (void (*) (SourceCollection *, GeeCollection*)) source_collection_real_notify_items_unlinking;
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	((SourceCollectionClass *) klass)->notify_items_relinked = (void (*) (SourceCollection *, GeeCollection*)) source_collection_real_notify_items_relinked;
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	((SourceCollectionClass *) klass)->notify_item_destroyed = (void (*) (SourceCollection *, DataSource*)) source_collection_real_notify_item_destroyed;
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	((SourceCollectionClass *) klass)->notify_items_destroyed = (void (*) (SourceCollection *, GeeCollection*)) source_collection_real_notify_items_destroyed;
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	((SourceCollectionClass *) klass)->notify_unlinked_destroyed = (void (*) (SourceCollection *, DataSource*)) source_collection_real_notify_unlinked_destroyed;
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	((SourceCollectionClass *) klass)->notify_backlink_removed = (void (*) (SourceCollection *, SourceBacklink*, GeeCollection*)) source_collection_real_notify_backlink_removed;
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	((DataCollectionClass *) klass)->valid_type = (gboolean (*) (DataCollection *, DataObject*)) source_collection_real_valid_type;
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	((SourceCollectionClass *) klass)->has_backlink = (gboolean (*) (SourceCollection *, SourceBacklink*)) source_collection_real_has_backlink;
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	((SourceCollectionClass *) klass)->remove_backlink = (void (*) (SourceCollection *, SourceBacklink*)) source_collection_real_remove_backlink;
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	((SourceCollectionClass *) klass)->items_unlinking = source_collection_real_items_unlinking;
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	((SourceCollectionClass *) klass)->items_relinked = source_collection_real_items_relinked;
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	((SourceCollectionClass *) klass)->item_destroyed = source_collection_real_item_destroyed;
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	((SourceCollectionClass *) klass)->items_destroyed = source_collection_real_items_destroyed;
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	((SourceCollectionClass *) klass)->unlinked_destroyed = source_collection_real_unlinked_destroyed;
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	((SourceCollectionClass *) klass)->backlink_removed = source_collection_real_backlink_removed;
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	source_collection_signals[SOURCE_COLLECTION_ITEMS_UNLINKING_SIGNAL] = g_signal_new ("items-unlinking", TYPE_SOURCE_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (SourceCollectionClass, items_unlinking), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_COLLECTION);
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	source_collection_signals[SOURCE_COLLECTION_ITEMS_RELINKED_SIGNAL] = g_signal_new ("items-relinked", TYPE_SOURCE_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (SourceCollectionClass, items_relinked), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_COLLECTION);
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	source_collection_signals[SOURCE_COLLECTION_ITEM_DESTROYED_SIGNAL] = g_signal_new ("item-destroyed", TYPE_SOURCE_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (SourceCollectionClass, item_destroyed), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_DATA_SOURCE);
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	source_collection_signals[SOURCE_COLLECTION_ITEMS_DESTROYED_SIGNAL] = g_signal_new ("items-destroyed", TYPE_SOURCE_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (SourceCollectionClass, items_destroyed), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_COLLECTION);
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	source_collection_signals[SOURCE_COLLECTION_UNLINKED_DESTROYED_SIGNAL] = g_signal_new ("unlinked-destroyed", TYPE_SOURCE_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (SourceCollectionClass, unlinked_destroyed), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_DATA_SOURCE);
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	source_collection_signals[SOURCE_COLLECTION_BACKLINK_REMOVED_SIGNAL] = g_signal_new ("backlink-removed", TYPE_SOURCE_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (SourceCollectionClass, backlink_removed), NULL, NULL, g_cclosure_user_marshal_VOID__SOURCE_BACKLINK_OBJECT, G_TYPE_NONE, 2, TYPE_SOURCE_BACKLINK, GEE_TYPE_COLLECTION);
#line 1765 "SourceCollection.c"
}


static void
source_collection_instance_init (SourceCollection * self)
{
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	self->priv = SOURCE_COLLECTION_GET_PRIVATE (self);
#line 48 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	self->priv->backlinks = NULL;
#line 1776 "SourceCollection.c"
}


static void
source_collection_finalize (DataCollection * obj)
{
	SourceCollection * self;
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SOURCE_COLLECTION, SourceCollection);
#line 48 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_g_object_unref0 (self->priv->backlinks);
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	DATA_COLLECTION_CLASS (source_collection_parent_class)->finalize (obj);
#line 1790 "SourceCollection.c"
}


GType
source_collection_get_type (void)
{
	static volatile gsize source_collection_type_id__volatile = 0;
	if (g_once_init_enter (&source_collection_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SourceCollectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) source_collection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SourceCollection), 0, (GInstanceInitFunc) source_collection_instance_init, NULL };
		GType source_collection_type_id;
		source_collection_type_id = g_type_register_static (TYPE_DATA_COLLECTION, "SourceCollection", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&source_collection_type_id__volatile, source_collection_type_id);
	}
	return source_collection_type_id__volatile;
}



