/*
 * Copyright (C) 2020 Apple Inc. All rights reserved.
 * Copyright (C) 2021 Igalia S.L.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

#if ENABLE(DATE_AND_TIME_INPUT_TYPES)

#include "WebDateTimePicker.h"
#include <WebCore/DateComponents.h>
#include <WebCore/DateTimeChooserParameters.h>

namespace WebKit {

class WebDateTimePickerGtk final : public WebDateTimePicker {
public:
    static Ref<WebDateTimePickerGtk> create(WebPageProxy&);
    ~WebDateTimePickerGtk();

private:
    WebDateTimePickerGtk(WebPageProxy&);

    void endPicker() final;
    void showDateTimePicker(WebCore::DateTimeChooserParameters&&) final;

    void update(WebCore::DateTimeChooserParameters&&);
    void didChooseDate();
    void invalidate();

    GtkWidget* m_popover { nullptr };
    GtkWidget* m_calendar { nullptr };
    std::optional<WebCore::DateComponents> m_currentDate;
    WebCore::SecondFormat m_secondFormat { WebCore::SecondFormat::None };
    bool m_inUpdate { false };
};

} // namespace WebKit

#endif // ENABLE(DATE_AND_TIME_INPUT_TYPES)
