// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: internal/module/gitops/rpc/rpc.proto

package rpc

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on GitRefCF with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *GitRefCF) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on GitRefCF with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in GitRefCFMultiError, or nil
// if none found.
func (m *GitRefCF) ValidateAll() error {
	return m.validate(true)
}

func (m *GitRefCF) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	oneofRefPresent := false
	switch v := m.Ref.(type) {
	case *GitRefCF_Tag:
		if v == nil {
			err := GitRefCFValidationError{
				field:  "Ref",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofRefPresent = true

		if len(m.GetTag()) < 1 {
			err := GitRefCFValidationError{
				field:  "Tag",
				reason: "value length must be at least 1 bytes",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	case *GitRefCF_Branch:
		if v == nil {
			err := GitRefCFValidationError{
				field:  "Ref",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofRefPresent = true

		if len(m.GetBranch()) < 1 {
			err := GitRefCFValidationError{
				field:  "Branch",
				reason: "value length must be at least 1 bytes",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	case *GitRefCF_Commit:
		if v == nil {
			err := GitRefCFValidationError{
				field:  "Ref",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofRefPresent = true

		if len(m.GetCommit()) < 1 {
			err := GitRefCFValidationError{
				field:  "Commit",
				reason: "value length must be at least 1 bytes",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	default:
		_ = v // ensures v is used
	}
	if !oneofRefPresent {
		err := GitRefCFValidationError{
			field:  "Ref",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return GitRefCFMultiError(errors)
	}

	return nil
}

// GitRefCFMultiError is an error wrapping multiple validation errors returned
// by GitRefCF.ValidateAll() if the designated constraints aren't met.
type GitRefCFMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m GitRefCFMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m GitRefCFMultiError) AllErrors() []error { return m }

// GitRefCFValidationError is the validation error returned by
// GitRefCF.Validate if the designated constraints aren't met.
type GitRefCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GitRefCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GitRefCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GitRefCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GitRefCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GitRefCFValidationError) ErrorName() string { return "GitRefCFValidationError" }

// Error satisfies the builtin error interface
func (e GitRefCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGitRefCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GitRefCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GitRefCFValidationError{}

// Validate checks the field values on PathCF with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *PathCF) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on PathCF with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in PathCFMultiError, or nil if none found.
func (m *PathCF) ValidateAll() error {
	return m.validate(true)
}

func (m *PathCF) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	oneofPathPresent := false
	switch v := m.Path.(type) {
	case *PathCF_Glob:
		if v == nil {
			err := PathCFValidationError{
				field:  "Path",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofPathPresent = true

		if len(m.GetGlob()) < 1 {
			err := PathCFValidationError{
				field:  "Glob",
				reason: "value length must be at least 1 bytes",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	case *PathCF_File:
		if v == nil {
			err := PathCFValidationError{
				field:  "Path",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofPathPresent = true

		if len(m.GetFile()) < 1 {
			err := PathCFValidationError{
				field:  "File",
				reason: "value length must be at least 1 bytes",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	default:
		_ = v // ensures v is used
	}
	if !oneofPathPresent {
		err := PathCFValidationError{
			field:  "Path",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return PathCFMultiError(errors)
	}

	return nil
}

// PathCFMultiError is an error wrapping multiple validation errors returned by
// PathCF.ValidateAll() if the designated constraints aren't met.
type PathCFMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m PathCFMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m PathCFMultiError) AllErrors() []error { return m }

// PathCFValidationError is the validation error returned by PathCF.Validate if
// the designated constraints aren't met.
type PathCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e PathCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e PathCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e PathCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e PathCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e PathCFValidationError) ErrorName() string { return "PathCFValidationError" }

// Error satisfies the builtin error interface
func (e PathCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sPathCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = PathCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = PathCFValidationError{}

// Validate checks the field values on ObjectsToSynchronizeRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *ObjectsToSynchronizeRequest) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ObjectsToSynchronizeRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// ObjectsToSynchronizeRequestMultiError, or nil if none found.
func (m *ObjectsToSynchronizeRequest) ValidateAll() error {
	return m.validate(true)
}

func (m *ObjectsToSynchronizeRequest) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetProjectId()) < 1 {
		err := ObjectsToSynchronizeRequestValidationError{
			field:  "ProjectId",
			reason: "value length must be at least 1 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetRef()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ObjectsToSynchronizeRequestValidationError{
					field:  "Ref",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ObjectsToSynchronizeRequestValidationError{
					field:  "Ref",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetRef()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ObjectsToSynchronizeRequestValidationError{
				field:  "Ref",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for CommitId

	if len(m.GetPaths()) < 1 {
		err := ObjectsToSynchronizeRequestValidationError{
			field:  "Paths",
			reason: "value must contain at least 1 item(s)",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetPaths() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ObjectsToSynchronizeRequestValidationError{
						field:  fmt.Sprintf("Paths[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ObjectsToSynchronizeRequestValidationError{
						field:  fmt.Sprintf("Paths[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ObjectsToSynchronizeRequestValidationError{
					field:  fmt.Sprintf("Paths[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return ObjectsToSynchronizeRequestMultiError(errors)
	}

	return nil
}

// ObjectsToSynchronizeRequestMultiError is an error wrapping multiple
// validation errors returned by ObjectsToSynchronizeRequest.ValidateAll() if
// the designated constraints aren't met.
type ObjectsToSynchronizeRequestMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ObjectsToSynchronizeRequestMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ObjectsToSynchronizeRequestMultiError) AllErrors() []error { return m }

// ObjectsToSynchronizeRequestValidationError is the validation error returned
// by ObjectsToSynchronizeRequest.Validate if the designated constraints
// aren't met.
type ObjectsToSynchronizeRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ObjectsToSynchronizeRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ObjectsToSynchronizeRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ObjectsToSynchronizeRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ObjectsToSynchronizeRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ObjectsToSynchronizeRequestValidationError) ErrorName() string {
	return "ObjectsToSynchronizeRequestValidationError"
}

// Error satisfies the builtin error interface
func (e ObjectsToSynchronizeRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sObjectsToSynchronizeRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ObjectsToSynchronizeRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ObjectsToSynchronizeRequestValidationError{}

// Validate checks the field values on ObjectsToSynchronizeResponse with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *ObjectsToSynchronizeResponse) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ObjectsToSynchronizeResponse with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// ObjectsToSynchronizeResponseMultiError, or nil if none found.
func (m *ObjectsToSynchronizeResponse) ValidateAll() error {
	return m.validate(true)
}

func (m *ObjectsToSynchronizeResponse) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	oneofMessagePresent := false
	switch v := m.Message.(type) {
	case *ObjectsToSynchronizeResponse_Header_:
		if v == nil {
			err := ObjectsToSynchronizeResponseValidationError{
				field:  "Message",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofMessagePresent = true

		if m.GetHeader() == nil {
			err := ObjectsToSynchronizeResponseValidationError{
				field:  "Header",
				reason: "value is required",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetHeader()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ObjectsToSynchronizeResponseValidationError{
						field:  "Header",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ObjectsToSynchronizeResponseValidationError{
						field:  "Header",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetHeader()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ObjectsToSynchronizeResponseValidationError{
					field:  "Header",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *ObjectsToSynchronizeResponse_Object_:
		if v == nil {
			err := ObjectsToSynchronizeResponseValidationError{
				field:  "Message",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofMessagePresent = true

		if m.GetObject() == nil {
			err := ObjectsToSynchronizeResponseValidationError{
				field:  "Object",
				reason: "value is required",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetObject()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ObjectsToSynchronizeResponseValidationError{
						field:  "Object",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ObjectsToSynchronizeResponseValidationError{
						field:  "Object",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetObject()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ObjectsToSynchronizeResponseValidationError{
					field:  "Object",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *ObjectsToSynchronizeResponse_Trailer_:
		if v == nil {
			err := ObjectsToSynchronizeResponseValidationError{
				field:  "Message",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofMessagePresent = true

		if m.GetTrailer() == nil {
			err := ObjectsToSynchronizeResponseValidationError{
				field:  "Trailer",
				reason: "value is required",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetTrailer()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ObjectsToSynchronizeResponseValidationError{
						field:  "Trailer",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ObjectsToSynchronizeResponseValidationError{
						field:  "Trailer",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetTrailer()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ObjectsToSynchronizeResponseValidationError{
					field:  "Trailer",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}
	if !oneofMessagePresent {
		err := ObjectsToSynchronizeResponseValidationError{
			field:  "Message",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return ObjectsToSynchronizeResponseMultiError(errors)
	}

	return nil
}

// ObjectsToSynchronizeResponseMultiError is an error wrapping multiple
// validation errors returned by ObjectsToSynchronizeResponse.ValidateAll() if
// the designated constraints aren't met.
type ObjectsToSynchronizeResponseMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ObjectsToSynchronizeResponseMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ObjectsToSynchronizeResponseMultiError) AllErrors() []error { return m }

// ObjectsToSynchronizeResponseValidationError is the validation error returned
// by ObjectsToSynchronizeResponse.Validate if the designated constraints
// aren't met.
type ObjectsToSynchronizeResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ObjectsToSynchronizeResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ObjectsToSynchronizeResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ObjectsToSynchronizeResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ObjectsToSynchronizeResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ObjectsToSynchronizeResponseValidationError) ErrorName() string {
	return "ObjectsToSynchronizeResponseValidationError"
}

// Error satisfies the builtin error interface
func (e ObjectsToSynchronizeResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sObjectsToSynchronizeResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ObjectsToSynchronizeResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ObjectsToSynchronizeResponseValidationError{}

// Validate checks the field values on ObjectsToSynchronizeResponse_Header with
// the rules defined in the proto definition for this message. If any rules
// are violated, the first error encountered is returned, or nil if there are
// no violations.
func (m *ObjectsToSynchronizeResponse_Header) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ObjectsToSynchronizeResponse_Header
// with the rules defined in the proto definition for this message. If any
// rules are violated, the result is a list of violation errors wrapped in
// ObjectsToSynchronizeResponse_HeaderMultiError, or nil if none found.
func (m *ObjectsToSynchronizeResponse_Header) ValidateAll() error {
	return m.validate(true)
}

func (m *ObjectsToSynchronizeResponse_Header) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetCommitId()) < 1 {
		err := ObjectsToSynchronizeResponse_HeaderValidationError{
			field:  "CommitId",
			reason: "value length must be at least 1 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for ProjectId

	if len(errors) > 0 {
		return ObjectsToSynchronizeResponse_HeaderMultiError(errors)
	}

	return nil
}

// ObjectsToSynchronizeResponse_HeaderMultiError is an error wrapping multiple
// validation errors returned by
// ObjectsToSynchronizeResponse_Header.ValidateAll() if the designated
// constraints aren't met.
type ObjectsToSynchronizeResponse_HeaderMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ObjectsToSynchronizeResponse_HeaderMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ObjectsToSynchronizeResponse_HeaderMultiError) AllErrors() []error { return m }

// ObjectsToSynchronizeResponse_HeaderValidationError is the validation error
// returned by ObjectsToSynchronizeResponse_Header.Validate if the designated
// constraints aren't met.
type ObjectsToSynchronizeResponse_HeaderValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ObjectsToSynchronizeResponse_HeaderValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ObjectsToSynchronizeResponse_HeaderValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ObjectsToSynchronizeResponse_HeaderValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ObjectsToSynchronizeResponse_HeaderValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ObjectsToSynchronizeResponse_HeaderValidationError) ErrorName() string {
	return "ObjectsToSynchronizeResponse_HeaderValidationError"
}

// Error satisfies the builtin error interface
func (e ObjectsToSynchronizeResponse_HeaderValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sObjectsToSynchronizeResponse_Header.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ObjectsToSynchronizeResponse_HeaderValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ObjectsToSynchronizeResponse_HeaderValidationError{}

// Validate checks the field values on ObjectsToSynchronizeResponse_Object with
// the rules defined in the proto definition for this message. If any rules
// are violated, the first error encountered is returned, or nil if there are
// no violations.
func (m *ObjectsToSynchronizeResponse_Object) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ObjectsToSynchronizeResponse_Object
// with the rules defined in the proto definition for this message. If any
// rules are violated, the result is a list of violation errors wrapped in
// ObjectsToSynchronizeResponse_ObjectMultiError, or nil if none found.
func (m *ObjectsToSynchronizeResponse_Object) ValidateAll() error {
	return m.validate(true)
}

func (m *ObjectsToSynchronizeResponse_Object) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetSource()) < 1 {
		err := ObjectsToSynchronizeResponse_ObjectValidationError{
			field:  "Source",
			reason: "value length must be at least 1 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for Data

	if len(errors) > 0 {
		return ObjectsToSynchronizeResponse_ObjectMultiError(errors)
	}

	return nil
}

// ObjectsToSynchronizeResponse_ObjectMultiError is an error wrapping multiple
// validation errors returned by
// ObjectsToSynchronizeResponse_Object.ValidateAll() if the designated
// constraints aren't met.
type ObjectsToSynchronizeResponse_ObjectMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ObjectsToSynchronizeResponse_ObjectMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ObjectsToSynchronizeResponse_ObjectMultiError) AllErrors() []error { return m }

// ObjectsToSynchronizeResponse_ObjectValidationError is the validation error
// returned by ObjectsToSynchronizeResponse_Object.Validate if the designated
// constraints aren't met.
type ObjectsToSynchronizeResponse_ObjectValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ObjectsToSynchronizeResponse_ObjectValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ObjectsToSynchronizeResponse_ObjectValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ObjectsToSynchronizeResponse_ObjectValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ObjectsToSynchronizeResponse_ObjectValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ObjectsToSynchronizeResponse_ObjectValidationError) ErrorName() string {
	return "ObjectsToSynchronizeResponse_ObjectValidationError"
}

// Error satisfies the builtin error interface
func (e ObjectsToSynchronizeResponse_ObjectValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sObjectsToSynchronizeResponse_Object.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ObjectsToSynchronizeResponse_ObjectValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ObjectsToSynchronizeResponse_ObjectValidationError{}

// Validate checks the field values on ObjectsToSynchronizeResponse_Trailer
// with the rules defined in the proto definition for this message. If any
// rules are violated, the first error encountered is returned, or nil if
// there are no violations.
func (m *ObjectsToSynchronizeResponse_Trailer) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ObjectsToSynchronizeResponse_Trailer
// with the rules defined in the proto definition for this message. If any
// rules are violated, the result is a list of violation errors wrapped in
// ObjectsToSynchronizeResponse_TrailerMultiError, or nil if none found.
func (m *ObjectsToSynchronizeResponse_Trailer) ValidateAll() error {
	return m.validate(true)
}

func (m *ObjectsToSynchronizeResponse_Trailer) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(errors) > 0 {
		return ObjectsToSynchronizeResponse_TrailerMultiError(errors)
	}

	return nil
}

// ObjectsToSynchronizeResponse_TrailerMultiError is an error wrapping multiple
// validation errors returned by
// ObjectsToSynchronizeResponse_Trailer.ValidateAll() if the designated
// constraints aren't met.
type ObjectsToSynchronizeResponse_TrailerMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ObjectsToSynchronizeResponse_TrailerMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ObjectsToSynchronizeResponse_TrailerMultiError) AllErrors() []error { return m }

// ObjectsToSynchronizeResponse_TrailerValidationError is the validation error
// returned by ObjectsToSynchronizeResponse_Trailer.Validate if the designated
// constraints aren't met.
type ObjectsToSynchronizeResponse_TrailerValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ObjectsToSynchronizeResponse_TrailerValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ObjectsToSynchronizeResponse_TrailerValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ObjectsToSynchronizeResponse_TrailerValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ObjectsToSynchronizeResponse_TrailerValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ObjectsToSynchronizeResponse_TrailerValidationError) ErrorName() string {
	return "ObjectsToSynchronizeResponse_TrailerValidationError"
}

// Error satisfies the builtin error interface
func (e ObjectsToSynchronizeResponse_TrailerValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sObjectsToSynchronizeResponse_Trailer.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ObjectsToSynchronizeResponse_TrailerValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ObjectsToSynchronizeResponse_TrailerValidationError{}
