// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: internal/module/modserver/modserver.proto

package modserver

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on Repository with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Repository) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Repository with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in RepositoryMultiError, or
// nil if none found.
func (m *Repository) ValidateAll() error {
	return m.validate(true)
}

func (m *Repository) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for StorageName

	// no validation rules for RelativePath

	// no validation rules for GitObjectDirectory

	// no validation rules for GlRepository

	// no validation rules for GlProjectPath

	if len(errors) > 0 {
		return RepositoryMultiError(errors)
	}

	return nil
}

// RepositoryMultiError is an error wrapping multiple validation errors
// returned by Repository.ValidateAll() if the designated constraints aren't met.
type RepositoryMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RepositoryMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RepositoryMultiError) AllErrors() []error { return m }

// RepositoryValidationError is the validation error returned by
// Repository.Validate if the designated constraints aren't met.
type RepositoryValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RepositoryValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RepositoryValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RepositoryValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RepositoryValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RepositoryValidationError) ErrorName() string { return "RepositoryValidationError" }

// Error satisfies the builtin error interface
func (e RepositoryValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRepository.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RepositoryValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RepositoryValidationError{}

// Validate checks the field values on GitalyAddress with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *GitalyAddress) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on GitalyAddress with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in GitalyAddressMultiError, or
// nil if none found.
func (m *GitalyAddress) ValidateAll() error {
	return m.validate(true)
}

func (m *GitalyAddress) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Address

	// no validation rules for Token

	if len(errors) > 0 {
		return GitalyAddressMultiError(errors)
	}

	return nil
}

// GitalyAddressMultiError is an error wrapping multiple validation errors
// returned by GitalyAddress.ValidateAll() if the designated constraints
// aren't met.
type GitalyAddressMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m GitalyAddressMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m GitalyAddressMultiError) AllErrors() []error { return m }

// GitalyAddressValidationError is the validation error returned by
// GitalyAddress.Validate if the designated constraints aren't met.
type GitalyAddressValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GitalyAddressValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GitalyAddressValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GitalyAddressValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GitalyAddressValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GitalyAddressValidationError) ErrorName() string { return "GitalyAddressValidationError" }

// Error satisfies the builtin error interface
func (e GitalyAddressValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGitalyAddress.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GitalyAddressValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GitalyAddressValidationError{}

// Validate checks the field values on Project with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Project) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Project with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in ProjectMultiError, or nil if none found.
func (m *Project) ValidateAll() error {
	return m.validate(true)
}

func (m *Project) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if m.GetId() <= 0 {
		err := ProjectValidationError{
			field:  "Id",
			reason: "value must be greater than 0",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(m.GetFullPath()) < 1 {
		err := ProjectValidationError{
			field:  "FullPath",
			reason: "value length must be at least 1 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return ProjectMultiError(errors)
	}

	return nil
}

// ProjectMultiError is an error wrapping multiple validation errors returned
// by Project.ValidateAll() if the designated constraints aren't met.
type ProjectMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ProjectMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ProjectMultiError) AllErrors() []error { return m }

// ProjectValidationError is the validation error returned by Project.Validate
// if the designated constraints aren't met.
type ProjectValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ProjectValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ProjectValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ProjectValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ProjectValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ProjectValidationError) ErrorName() string { return "ProjectValidationError" }

// Error satisfies the builtin error interface
func (e ProjectValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sProject.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ProjectValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ProjectValidationError{}
