/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.filter;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.filter.SamRecordFilter;
import java.util.Arrays;
import java.util.List;

public class TagFilter
implements SamRecordFilter {
    private final String tag;
    private final List<Object> values;

    public TagFilter(String tag, Object value) {
        this.tag = tag;
        this.values = Arrays.asList(value);
    }

    public TagFilter(String tag, List<Object> values) {
        this.tag = tag;
        this.values = values;
    }

    @Override
    public boolean filterOut(SAMRecord record) {
        return this.values.contains(record.getAttribute(this.tag));
    }

    @Override
    public boolean filterOut(SAMRecord first, SAMRecord second) {
        return this.values.contains(first.getAttribute(this.tag)) && this.values.contains(second.getAttribute(this.tag));
    }
}

