#!/bin/sh -e
#
# Removes unwanted content from the upstream sources.
# Called by uscan with '--upstream-version' <version> <file>
#

VERSION=$2
TAR=../apache-directory-server_$VERSION.orig.tar.xz
DIR=apache-directory-server-$VERSION
TAG=$(echo "$VERSION" | sed -re's/~(alpha|beta|rc|m)/-\1/i')

svn export http://svn.apache.org/repos/asf/directory/apacheds/tags/${TAG}/ $DIR
XZ_OPT=--best tar -c -J -f $TAR \
    --exclude '*.jar' \
    --exclude '*.class' \
    --exclude '*.exe' \
    --exclude 'installers-maven-plugin/src/main/resources/org/apache/directory/server/installers/wrapper*' \
    $DIR
rm -rf $DIR ../$TAG
