/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.util;

import java.util.Collection;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RegexUtil {
    private static final Logger logger = LoggerFactory.getLogger(RegexUtil.class);
    private static final Perl5Matcher pm = new Perl5Matcher();

    public static boolean matches(Collection<Pattern> regexs, String str) {
        for (Pattern regex : regexs) {
            if (!pm.matches(str, regex)) continue;
            return true;
        }
        return false;
    }

    public static void addRegex(Collection<Pattern> list, String regex) {
        try {
            Perl5Compiler pc = new Perl5Compiler();
            Pattern pattern = pc.compile(regex);
            list.add(pattern);
        }
        catch (MalformedPatternException e) {
            logger.warn("The regular expression " + regex + " is invalid: " + e.getLocalizedMessage());
        }
    }
}

