/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 11:22:15 GMT 2018
 */

package uk.ac.sanger.artemis.components.alignment;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.HeadlessException;
import java.awt.SystemColor;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.JLayer;
import javax.swing.JPanel;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.components.alignment.LineAttributes;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class LineAttributes_ESTest extends LineAttributes_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      List<String> list0 = SAMSequenceDictionary.DEFAULT_DICTIONARY_EQUAL_TAG;
      LineAttributes[] lineAttributesArray0 = new LineAttributes[2];
      // Undeclared exception!
      try { 
        LineAttributes.configurePlots(list0, lineAttributesArray0, (JPanel) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.alignment.LineAttributes", e);
      }
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      LineAttributes lineAttributes0 = new LineAttributes((Color) null);
      lineAttributes0.getLineColour();
      assertEquals("Open", lineAttributes0.getPlotType());
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      DefaultTreeCellRenderer defaultTreeCellRenderer0 = new DefaultTreeCellRenderer();
      Color color0 = defaultTreeCellRenderer0.getTextNonSelectionColor();
      LineAttributes lineAttributes0 = new LineAttributes(color0);
      lineAttributes0.getLineColour();
      assertEquals("Open", lineAttributes0.getPlotType());
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      Color color0 = Color.RED;
      LineAttributes lineAttributes0 = new LineAttributes(color0);
      lineAttributes0.getLineColour();
      assertEquals("Open", lineAttributes0.getPlotType());
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      // Undeclared exception!
      try { 
        LineAttributes.init((-2241));
        fail("Expecting exception: NegativeArraySizeException");
      
      } catch(NegativeArraySizeException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.alignment.LineAttributes", e);
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      String[] stringArray0 = new String[0];
      LineAttributes.PLOT_TYPES = stringArray0;
      // Undeclared exception!
      try { 
        LineAttributes.init(44);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // 0
         //
         verifyException("uk.ac.sanger.artemis.components.alignment.LineAttributes", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      SystemColor systemColor0 = SystemColor.controlShadow;
      LineAttributes lineAttributes0 = new LineAttributes(systemColor0);
      BasicStroke basicStroke0 = new BasicStroke(0.0F);
      lineAttributes0.setStroke(basicStroke0);
      VCFHeader vCFHeader0 = new VCFHeader();
      Set<VCFHeaderLine> set0 = vCFHeader0.getMetaDataInSortedOrder();
      Charset charset0 = Charset.defaultCharset();
      Set<String> set1 = charset0.aliases();
      VCFHeader vCFHeader1 = new VCFHeader(set0, set1);
      ArrayList<String> arrayList0 = vCFHeader1.getSampleNamesInOrder();
      LineAttributes[] lineAttributesArray0 = new LineAttributes[3];
      lineAttributesArray0[0] = lineAttributes0;
      JPanel jPanel0 = new JPanel(true);
      // Undeclared exception!
      try { 
        LineAttributes.configurePlots(arrayList0, lineAttributesArray0, jPanel0);
        fail("Expecting exception: IllegalArgumentException");
      
      } catch(IllegalArgumentException e) {
         //
         // invalid range properties
         //
         verifyException("javax.swing.DefaultBoundedRangeModel", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      Color color0 = Color.red;
      LineAttributes lineAttributes0 = new LineAttributes(color0);
      BasicStroke basicStroke0 = lineAttributes0.getStroke();
      assertEquals(1.0F, basicStroke0.getLineWidth(), 0.01F);
      assertEquals("Open", lineAttributes0.getPlotType());
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      Color color0 = new Color(44, true);
      LineAttributes lineAttributes0 = new LineAttributes(color0);
      lineAttributes0.getLineColour();
      assertEquals("Open", lineAttributes0.getPlotType());
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      DefaultTreeCellRenderer defaultTreeCellRenderer0 = new DefaultTreeCellRenderer();
      Color color0 = defaultTreeCellRenderer0.getTextNonSelectionColor();
      LineAttributes lineAttributes0 = new LineAttributes(color0);
      List<String> list0 = SAMSequenceDictionary.DEFAULT_DICTIONARY_EQUAL_TAG;
      LineAttributes[] lineAttributesArray0 = new LineAttributes[5];
      lineAttributesArray0[0] = lineAttributes0;
      lineAttributesArray0[1] = lineAttributes0;
      JLayer<Container> jLayer0 = new JLayer<Container>(defaultTreeCellRenderer0);
      JPanel jPanel0 = jLayer0.createGlassPane();
      // Undeclared exception!
      try { 
        LineAttributes.configurePlots(list0, lineAttributesArray0, jPanel0);
        fail("Expecting exception: HeadlessException");
      
      } catch(HeadlessException e) {
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      LineAttributes[] lineAttributesArray0 = LineAttributes.init(153);
      assertNotNull(lineAttributesArray0);
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      LineAttributes[] lineAttributesArray0 = LineAttributes.init(1);
      assertNotNull(lineAttributesArray0);
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      LineAttributes[] lineAttributesArray0 = LineAttributes.init(0);
      ArrayList<String> arrayList0 = new ArrayList<String>();
      arrayList0.add("Select");
      // Undeclared exception!
      try { 
        LineAttributes.configurePlots(arrayList0, lineAttributesArray0, (JPanel) null);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // 0
         //
         verifyException("uk.ac.sanger.artemis.components.alignment.LineAttributes", e);
      }
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      LineAttributes lineAttributes0 = new LineAttributes((Color) null);
      lineAttributes0.setStroke((BasicStroke) null);
      lineAttributes0.getStroke();
      assertEquals("Open", lineAttributes0.getPlotType());
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      BasicStroke[] basicStrokeArray0 = LineAttributes.getStrokes();
      assertNotNull(basicStrokeArray0);
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      LineAttributes lineAttributes0 = new LineAttributes((Color) null);
      lineAttributes0.setLineColour((Color) null);
      assertEquals("Open", lineAttributes0.getPlotType());
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      LineAttributes lineAttributes0 = new LineAttributes((Color) null);
      String string0 = lineAttributes0.getPlotType();
      assertEquals("Open", string0);
  }
}
