/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 11:46:28 GMT 2018
 */

package uk.ac.sanger.artemis.components.database;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.util.HashSet;
import javax.swing.JPasswordField;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.gmod.schema.organism.Organism;
import org.gmod.schema.organism.OrganismProp;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.components.database.DatabaseTreeNode;
import uk.ac.sanger.artemis.util.DatabaseDocument;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class DatabaseTreeNode_ESTest extends DatabaseTreeNode_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      DatabaseTreeNode databaseTreeNode0 = new DatabaseTreeNode("");
      databaseTreeNode0.getOrganism();
      assertFalse(databaseTreeNode0.isExplored());
      assertTrue(databaseTreeNode0.getAllowsChildren());
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      Organism organism0 = new Organism();
      JPasswordField jPasswordField0 = new JPasswordField(1167);
      DatabaseDocument databaseDocument0 = new DatabaseDocument("g)RD GW", jPasswordField0, "dxAe$5!A>", "g)RD GW", true);
      DatabaseTreeNode databaseTreeNode0 = new DatabaseTreeNode("", true, organism0, "g)RD GW", databaseDocument0);
      DataFlavor dataFlavor0 = DataFlavor.javaFileListFlavor;
      try { 
        databaseTreeNode0.getTransferData(dataFlavor0);
        fail("Expecting exception: UnsupportedFlavorException");
      
      } catch(UnsupportedFlavorException e) {
         //
         // application/x-java-file-list
         //
         verifyException("uk.ac.sanger.artemis.components.database.DatabaseTreeNode", e);
      }
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      DatabaseTreeNode databaseTreeNode0 = new DatabaseTreeNode("");
      DataFlavor dataFlavor0 = DataFlavor.selectionHtmlFlavor;
      boolean boolean0 = databaseTreeNode0.isDataFlavorSupported(dataFlavor0);
      assertFalse(boolean0);
      assertFalse(databaseTreeNode0.isExplored());
      assertFalse(databaseTreeNode0.isLeaf());
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      DatabaseTreeNode databaseTreeNode0 = new DatabaseTreeNode("");
      boolean boolean0 = databaseTreeNode0.isDataFlavorSupported(databaseTreeNode0.STRING_DATA_FLAVOUR);
      assertTrue(databaseTreeNode0.isDirectory());
      assertTrue(boolean0);
      assertFalse(databaseTreeNode0.isExplored());
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      DatabaseTreeNode databaseTreeNode0 = new DatabaseTreeNode("");
      // Undeclared exception!
      try { 
        databaseTreeNode0.explore();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.database.DatabaseTreeNode", e);
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      DatabaseTreeNode databaseTreeNode0 = new DatabaseTreeNode("");
      boolean boolean0 = databaseTreeNode0.isDirectory();
      assertFalse(databaseTreeNode0.isExplored());
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      HashSet<OrganismProp> hashSet0 = new HashSet<OrganismProp>();
      OrganismProp organismProp0 = new OrganismProp();
      hashSet0.add(organismProp0);
      // Undeclared exception!
      try { 
        DatabaseTreeNode.setOrganismProps(hashSet0, true);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.database.DatabaseTreeNode", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      Organism organism0 = new Organism();
      JPasswordField jPasswordField0 = new JPasswordField(1167);
      DatabaseDocument databaseDocument0 = new DatabaseDocument("g)RD GW", jPasswordField0, "dxAe$5!A>", "g)RD GW", true);
      DatabaseTreeNode databaseTreeNode0 = new DatabaseTreeNode("", true, organism0, "g)RD GW", databaseDocument0);
      Object object0 = databaseTreeNode0.getTransferData(databaseTreeNode0.STRING_DATA_FLAVOUR);
      assertEquals("null.null:featureId=null", object0);
      assertFalse(databaseTreeNode0.isExplored());
      assertEquals("g)RD GW", databaseTreeNode0.getUserName());
      assertEquals("null.null", databaseTreeNode0.getOrganismCommonName());
      assertFalse(databaseTreeNode0.isDirectory());
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      DatabaseTreeNode databaseTreeNode0 = new DatabaseTreeNode("database_manager_cache_off");
      databaseTreeNode0.getOrganismCommonName();
      assertFalse(databaseTreeNode0.isExplored());
      assertFalse(databaseTreeNode0.isLeaf());
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      DatabaseTreeNode databaseTreeNode0 = null;
      try {
        databaseTreeNode0 = new DatabaseTreeNode("UlB%_[ hwK6bH-8", false, (Organism) null, "", (DatabaseDocument) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.database.DatabaseTreeNode", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      DatabaseTreeNode databaseTreeNode0 = new DatabaseTreeNode("mitochondrialTranslationTable");
      boolean boolean0 = databaseTreeNode0.isExplored();
      assertFalse(boolean0);
      assertTrue(databaseTreeNode0.getAllowsChildren());
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      DatabaseTreeNode databaseTreeNode0 = new DatabaseTreeNode("database_manager_cache_off");
      databaseTreeNode0.getUserName();
      assertTrue(databaseTreeNode0.isDirectory());
      assertFalse(databaseTreeNode0.isExplored());
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      DatabaseTreeNode databaseTreeNode0 = new DatabaseTreeNode("");
      boolean boolean0 = databaseTreeNode0.isLeaf();
      assertFalse(databaseTreeNode0.isExplored());
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      DatabaseTreeNode databaseTreeNode0 = new DatabaseTreeNode("");
      databaseTreeNode0.getFeatureType();
      assertFalse(databaseTreeNode0.isExplored());
      assertFalse(databaseTreeNode0.isLeaf());
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      DatabaseTreeNode databaseTreeNode0 = new DatabaseTreeNode((String) null);
      databaseTreeNode0.getFeatureId();
      assertFalse(databaseTreeNode0.isExplored());
      assertFalse(databaseTreeNode0.isLeaf());
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      DatabaseTreeNode databaseTreeNode0 = new DatabaseTreeNode("_");
      databaseTreeNode0.getTransferDataFlavors();
      assertFalse(databaseTreeNode0.isExplored());
      assertTrue(databaseTreeNode0.getAllowsChildren());
  }
}
