/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 15:52:21 GMT 2018
 */

package uk.ac.sanger.artemis.plot;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.io.EmblStreamSequence;
import uk.ac.sanger.artemis.io.GenbankStreamSequence;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.plot.ATDeviationAlgorithm;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.Strand;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class ATDeviationAlgorithm_ESTest extends ATDeviationAlgorithm_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("Scaled Chi Square");
      assertNotNull(emblStreamSequence0);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(17, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(2, emblStreamSequence0.getACount());
      assertEquals(14, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      
      Bases bases0 = new Bases(emblStreamSequence0);
      assertNotNull(bases0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(17, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(2, emblStreamSequence0.getACount());
      assertEquals(14, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      
      Strand strand0 = bases0.getReverseStrand();
      assertNotNull(strand0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(17, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(2, emblStreamSequence0.getACount());
      assertEquals(14, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      
      ATDeviationAlgorithm aTDeviationAlgorithm0 = new ATDeviationAlgorithm(strand0);
      assertNotNull(aTDeviationAlgorithm0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(17, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(2, emblStreamSequence0.getACount());
      assertEquals(14, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertFalse(aTDeviationAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aTDeviationAlgorithm0.getUserMax(), 0.01F);
      assertTrue(aTDeviationAlgorithm0.scalingFlag());
      assertFalse(aTDeviationAlgorithm0.isUserMaxMin());
      assertEquals("AT Deviation (A-T)/(A+T)", aTDeviationAlgorithm0.getAlgorithmName());
      assertEquals("at_deviation", aTDeviationAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aTDeviationAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aTDeviationAlgorithm0.getValueCount());
      
      Float float0 = aTDeviationAlgorithm0.getAverage();
      assertNotNull(float0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(17, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(2, emblStreamSequence0.getACount());
      assertEquals(14, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertFalse(aTDeviationAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aTDeviationAlgorithm0.getUserMax(), 0.01F);
      assertTrue(aTDeviationAlgorithm0.scalingFlag());
      assertFalse(aTDeviationAlgorithm0.isUserMaxMin());
      assertEquals("AT Deviation (A-T)/(A+T)", aTDeviationAlgorithm0.getAlgorithmName());
      assertEquals("at_deviation", aTDeviationAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aTDeviationAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aTDeviationAlgorithm0.getValueCount());
      assertEquals((-1.0F), (float)float0, 0.01F);
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      assertNotNull(bases0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      
      Strand strand0 = bases0.getForwardStrand();
      assertNotNull(strand0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      
      ATDeviationAlgorithm aTDeviationAlgorithm0 = new ATDeviationAlgorithm(strand0);
      assertNotNull(aTDeviationAlgorithm0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals(3.4028235E38F, aTDeviationAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, aTDeviationAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, aTDeviationAlgorithm0.getUserMin(), 0.01F);
      assertFalse(aTDeviationAlgorithm0.isUserMaxMin());
      assertEquals("AT Deviation (A-T)/(A+T)", aTDeviationAlgorithm0.getAlgorithmName());
      assertTrue(aTDeviationAlgorithm0.scalingFlag());
      assertEquals("at_deviation", aTDeviationAlgorithm0.getAlgorithmShortName());
      assertFalse(aTDeviationAlgorithm0.isRevCompDisplay());
      
      // Undeclared exception!
      try { 
        aTDeviationAlgorithm0.getValues(1, 2, (float[]) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      assertNotNull(bases0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      
      Strand strand0 = bases0.getReverseStrand();
      assertNotNull(strand0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      
      ATDeviationAlgorithm aTDeviationAlgorithm0 = new ATDeviationAlgorithm(strand0);
      assertNotNull(aTDeviationAlgorithm0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals("at_deviation", aTDeviationAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aTDeviationAlgorithm0.getUserMin(), 0.01F);
      assertEquals("AT Deviation (A-T)/(A+T)", aTDeviationAlgorithm0.getAlgorithmName());
      assertTrue(aTDeviationAlgorithm0.scalingFlag());
      assertEquals(1, aTDeviationAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, aTDeviationAlgorithm0.getUserMax(), 0.01F);
      assertFalse(aTDeviationAlgorithm0.isRevCompDisplay());
      assertFalse(aTDeviationAlgorithm0.isUserMaxMin());
      
      float[] floatArray0 = new float[8];
      // Undeclared exception!
      try { 
        aTDeviationAlgorithm0.getValues(2, 1, floatArray0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - unexpected exception: org.evosuite.runtime.mock.java.lang.MockThrowable: start: 2 > end: 1
         //
         verifyException("uk.ac.sanger.artemis.plot.ATDeviationAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      ATDeviationAlgorithm aTDeviationAlgorithm0 = null;
      try {
        aTDeviationAlgorithm0 = new ATDeviationAlgorithm((Strand) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.BaseAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("Y+dP9ZU-7#e[");
      assertNotNull(genbankStreamSequence0);
      assertEquals(0, genbankStreamSequence0.getACount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(12, genbankStreamSequence0.length());
      assertEquals(12, genbankStreamSequence0.getOtherCount());
      
      Bases bases0 = new Bases(genbankStreamSequence0);
      assertNotNull(bases0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(0, genbankStreamSequence0.getACount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(12, genbankStreamSequence0.length());
      assertEquals(12, genbankStreamSequence0.getOtherCount());
      
      Strand strand0 = bases0.getReverseStrand();
      assertNotNull(strand0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, genbankStreamSequence0.getACount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(12, genbankStreamSequence0.length());
      assertEquals(12, genbankStreamSequence0.getOtherCount());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      
      ATDeviationAlgorithm aTDeviationAlgorithm0 = new ATDeviationAlgorithm(strand0);
      assertNotNull(aTDeviationAlgorithm0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, genbankStreamSequence0.getACount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(12, genbankStreamSequence0.length());
      assertEquals(12, genbankStreamSequence0.getOtherCount());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals("at_deviation", aTDeviationAlgorithm0.getAlgorithmShortName());
      assertEquals("AT Deviation (A-T)/(A+T)", aTDeviationAlgorithm0.getAlgorithmName());
      assertTrue(aTDeviationAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, aTDeviationAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, aTDeviationAlgorithm0.getValueCount());
      assertFalse(aTDeviationAlgorithm0.isRevCompDisplay());
      assertEquals(1.4E-45F, aTDeviationAlgorithm0.getUserMin(), 0.01F);
      assertFalse(aTDeviationAlgorithm0.isUserMaxMin());
      
      genbankStreamSequence0.setFromChar(bases0.letter_index);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(5, genbankStreamSequence0.length());
      assertEquals(1, genbankStreamSequence0.getTCount());
      assertEquals(1, genbankStreamSequence0.getACount());
      assertEquals(1, genbankStreamSequence0.getOtherCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertEquals(1, genbankStreamSequence0.getCCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      
      Float float0 = aTDeviationAlgorithm0.getAverage();
      assertNotNull(float0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(5, genbankStreamSequence0.length());
      assertEquals(1, genbankStreamSequence0.getTCount());
      assertEquals(1, genbankStreamSequence0.getACount());
      assertEquals(1, genbankStreamSequence0.getOtherCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertEquals(1, genbankStreamSequence0.getCCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals("at_deviation", aTDeviationAlgorithm0.getAlgorithmShortName());
      assertEquals("AT Deviation (A-T)/(A+T)", aTDeviationAlgorithm0.getAlgorithmName());
      assertTrue(aTDeviationAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, aTDeviationAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, aTDeviationAlgorithm0.getValueCount());
      assertFalse(aTDeviationAlgorithm0.isRevCompDisplay());
      assertEquals(1.4E-45F, aTDeviationAlgorithm0.getUserMin(), 0.01F);
      assertFalse(aTDeviationAlgorithm0.isUserMaxMin());
      assertEquals(0.0F, (float)float0, 0.01F);
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("Y+dP9ZU-7#e[");
      assertNotNull(genbankStreamSequence0);
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(12, genbankStreamSequence0.length());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(12, genbankStreamSequence0.getOtherCount());
      
      Bases bases0 = new Bases(genbankStreamSequence0);
      assertNotNull(bases0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(12, genbankStreamSequence0.length());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(12, genbankStreamSequence0.getOtherCount());
      
      Strand strand0 = bases0.getReverseStrand();
      assertNotNull(strand0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(12, genbankStreamSequence0.length());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(12, genbankStreamSequence0.getOtherCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      
      ATDeviationAlgorithm aTDeviationAlgorithm0 = new ATDeviationAlgorithm(strand0);
      assertNotNull(aTDeviationAlgorithm0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(12, genbankStreamSequence0.length());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(12, genbankStreamSequence0.getOtherCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertTrue(aTDeviationAlgorithm0.scalingFlag());
      assertEquals(1, aTDeviationAlgorithm0.getValueCount());
      assertFalse(aTDeviationAlgorithm0.isUserMaxMin());
      assertEquals(3.4028235E38F, aTDeviationAlgorithm0.getUserMax(), 0.01F);
      assertEquals("at_deviation", aTDeviationAlgorithm0.getAlgorithmShortName());
      assertFalse(aTDeviationAlgorithm0.isRevCompDisplay());
      assertEquals("AT Deviation (A-T)/(A+T)", aTDeviationAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, aTDeviationAlgorithm0.getUserMin(), 0.01F);
      
      Float float0 = aTDeviationAlgorithm0.getAverage();
      assertNotNull(float0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(12, genbankStreamSequence0.length());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(12, genbankStreamSequence0.getOtherCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertTrue(aTDeviationAlgorithm0.scalingFlag());
      assertEquals(1, aTDeviationAlgorithm0.getValueCount());
      assertFalse(aTDeviationAlgorithm0.isUserMaxMin());
      assertEquals(3.4028235E38F, aTDeviationAlgorithm0.getUserMax(), 0.01F);
      assertEquals("at_deviation", aTDeviationAlgorithm0.getAlgorithmShortName());
      assertFalse(aTDeviationAlgorithm0.isRevCompDisplay());
      assertEquals("AT Deviation (A-T)/(A+T)", aTDeviationAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, aTDeviationAlgorithm0.getUserMin(), 0.01F);
      assertEquals(0.0F, (float)float0, 0.01F);
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("Y+dP9ZU-7#e[");
      assertNotNull(genbankStreamSequence0);
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(12, genbankStreamSequence0.getOtherCount());
      assertEquals(12, genbankStreamSequence0.length());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getGCount());
      
      Bases bases0 = new Bases(genbankStreamSequence0);
      assertNotNull(bases0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(12, genbankStreamSequence0.getOtherCount());
      assertEquals(12, genbankStreamSequence0.length());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getGCount());
      
      Strand strand0 = bases0.getReverseStrand();
      assertNotNull(strand0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(12, genbankStreamSequence0.getOtherCount());
      assertEquals(12, genbankStreamSequence0.length());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      
      ATDeviationAlgorithm aTDeviationAlgorithm0 = new ATDeviationAlgorithm(strand0);
      assertNotNull(aTDeviationAlgorithm0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(12, genbankStreamSequence0.getOtherCount());
      assertEquals(12, genbankStreamSequence0.length());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertTrue(aTDeviationAlgorithm0.scalingFlag());
      assertFalse(aTDeviationAlgorithm0.isUserMaxMin());
      assertEquals(1, aTDeviationAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, aTDeviationAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, aTDeviationAlgorithm0.getUserMin(), 0.01F);
      assertFalse(aTDeviationAlgorithm0.isRevCompDisplay());
      assertEquals("at_deviation", aTDeviationAlgorithm0.getAlgorithmShortName());
      assertEquals("AT Deviation (A-T)/(A+T)", aTDeviationAlgorithm0.getAlgorithmName());
      
      Integer integer0 = aTDeviationAlgorithm0.getDefaultStepSize(1197);
      assertNotNull(integer0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(12, genbankStreamSequence0.getOtherCount());
      assertEquals(12, genbankStreamSequence0.length());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertTrue(aTDeviationAlgorithm0.scalingFlag());
      assertFalse(aTDeviationAlgorithm0.isUserMaxMin());
      assertEquals(1, aTDeviationAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, aTDeviationAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, aTDeviationAlgorithm0.getUserMin(), 0.01F);
      assertFalse(aTDeviationAlgorithm0.isRevCompDisplay());
      assertEquals("at_deviation", aTDeviationAlgorithm0.getAlgorithmShortName());
      assertEquals("AT Deviation (A-T)/(A+T)", aTDeviationAlgorithm0.getAlgorithmName());
      assertEquals(119, (int)integer0);
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("Scaled Chi Square");
      assertNotNull(emblStreamSequence0);
      assertEquals(17, emblStreamSequence0.length());
      assertEquals(14, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(2, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertNull(emblStreamSequence0.getHeader());
      
      Bases bases0 = new Bases(emblStreamSequence0);
      assertNotNull(bases0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(17, emblStreamSequence0.length());
      assertEquals(14, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(2, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertNull(emblStreamSequence0.getHeader());
      
      Strand strand0 = bases0.getReverseStrand();
      assertNotNull(strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(17, emblStreamSequence0.length());
      assertEquals(14, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(2, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertNull(emblStreamSequence0.getHeader());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      
      ATDeviationAlgorithm aTDeviationAlgorithm0 = new ATDeviationAlgorithm(strand0);
      assertNotNull(aTDeviationAlgorithm0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(17, emblStreamSequence0.length());
      assertEquals(14, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(2, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertNull(emblStreamSequence0.getHeader());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertFalse(aTDeviationAlgorithm0.isRevCompDisplay());
      assertEquals("AT Deviation (A-T)/(A+T)", aTDeviationAlgorithm0.getAlgorithmName());
      assertFalse(aTDeviationAlgorithm0.isUserMaxMin());
      assertEquals("at_deviation", aTDeviationAlgorithm0.getAlgorithmShortName());
      assertTrue(aTDeviationAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, aTDeviationAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aTDeviationAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, aTDeviationAlgorithm0.getUserMax(), 0.01F);
      
      Integer integer0 = aTDeviationAlgorithm0.getDefaultStepSize((-5));
      assertNull(integer0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(17, emblStreamSequence0.length());
      assertEquals(14, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(2, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertNull(emblStreamSequence0.getHeader());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertFalse(aTDeviationAlgorithm0.isRevCompDisplay());
      assertEquals("AT Deviation (A-T)/(A+T)", aTDeviationAlgorithm0.getAlgorithmName());
      assertFalse(aTDeviationAlgorithm0.isUserMaxMin());
      assertEquals("at_deviation", aTDeviationAlgorithm0.getAlgorithmShortName());
      assertTrue(aTDeviationAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, aTDeviationAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aTDeviationAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, aTDeviationAlgorithm0.getUserMax(), 0.01F);
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("Y+dP9ZU-7#e[");
      assertNotNull(genbankStreamSequence0);
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(12, genbankStreamSequence0.getOtherCount());
      assertEquals(12, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      
      Bases bases0 = new Bases(genbankStreamSequence0);
      assertNotNull(bases0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(12, genbankStreamSequence0.getOtherCount());
      assertEquals(12, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      
      Strand strand0 = bases0.getReverseStrand();
      assertNotNull(strand0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(12, genbankStreamSequence0.getOtherCount());
      assertEquals(12, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      
      ATDeviationAlgorithm aTDeviationAlgorithm0 = new ATDeviationAlgorithm(strand0);
      assertNotNull(aTDeviationAlgorithm0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(12, genbankStreamSequence0.getOtherCount());
      assertEquals(12, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals("at_deviation", aTDeviationAlgorithm0.getAlgorithmShortName());
      assertFalse(aTDeviationAlgorithm0.isUserMaxMin());
      assertEquals("AT Deviation (A-T)/(A+T)", aTDeviationAlgorithm0.getAlgorithmName());
      assertTrue(aTDeviationAlgorithm0.scalingFlag());
      assertFalse(aTDeviationAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aTDeviationAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, aTDeviationAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, aTDeviationAlgorithm0.getUserMin(), 0.01F);
      
      Integer integer0 = aTDeviationAlgorithm0.getDefaultMinWindowSize();
      assertNotNull(integer0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(12, genbankStreamSequence0.getOtherCount());
      assertEquals(12, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals("at_deviation", aTDeviationAlgorithm0.getAlgorithmShortName());
      assertFalse(aTDeviationAlgorithm0.isUserMaxMin());
      assertEquals("AT Deviation (A-T)/(A+T)", aTDeviationAlgorithm0.getAlgorithmName());
      assertTrue(aTDeviationAlgorithm0.scalingFlag());
      assertFalse(aTDeviationAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aTDeviationAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, aTDeviationAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, aTDeviationAlgorithm0.getUserMin(), 0.01F);
      assertEquals(10, (int)integer0);
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("Scaled Chi Square");
      assertNotNull(emblStreamSequence0);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(14, emblStreamSequence0.getOtherCount());
      assertEquals(17, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(2, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getGCount());
      
      Bases bases0 = new Bases(emblStreamSequence0);
      assertNotNull(bases0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(14, emblStreamSequence0.getOtherCount());
      assertEquals(17, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(2, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getGCount());
      
      Strand strand0 = bases0.getReverseStrand();
      assertNotNull(strand0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(14, emblStreamSequence0.getOtherCount());
      assertEquals(17, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(2, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      
      ATDeviationAlgorithm aTDeviationAlgorithm0 = new ATDeviationAlgorithm(strand0);
      assertNotNull(aTDeviationAlgorithm0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(14, emblStreamSequence0.getOtherCount());
      assertEquals(17, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(2, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertFalse(aTDeviationAlgorithm0.isUserMaxMin());
      assertEquals("at_deviation", aTDeviationAlgorithm0.getAlgorithmShortName());
      assertTrue(aTDeviationAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, aTDeviationAlgorithm0.getUserMin(), 0.01F);
      assertFalse(aTDeviationAlgorithm0.isRevCompDisplay());
      assertEquals(1, aTDeviationAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, aTDeviationAlgorithm0.getUserMax(), 0.01F);
      assertEquals("AT Deviation (A-T)/(A+T)", aTDeviationAlgorithm0.getAlgorithmName());
      
      Integer integer0 = aTDeviationAlgorithm0.getDefaultMaxWindowSize();
      assertNotNull(integer0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(14, emblStreamSequence0.getOtherCount());
      assertEquals(17, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(2, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertFalse(aTDeviationAlgorithm0.isUserMaxMin());
      assertEquals("at_deviation", aTDeviationAlgorithm0.getAlgorithmShortName());
      assertTrue(aTDeviationAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, aTDeviationAlgorithm0.getUserMin(), 0.01F);
      assertFalse(aTDeviationAlgorithm0.isRevCompDisplay());
      assertEquals(1, aTDeviationAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, aTDeviationAlgorithm0.getUserMax(), 0.01F);
      assertEquals("AT Deviation (A-T)/(A+T)", aTDeviationAlgorithm0.getAlgorithmName());
      assertEquals(5000, (int)integer0);
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("Scaled Chi Square");
      assertNotNull(emblStreamSequence0);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(17, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(14, emblStreamSequence0.getOtherCount());
      assertEquals(2, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      
      Bases bases0 = new Bases(emblStreamSequence0);
      assertNotNull(bases0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(17, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(14, emblStreamSequence0.getOtherCount());
      assertEquals(2, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      
      Strand strand0 = bases0.getReverseStrand();
      assertNotNull(strand0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(17, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(14, emblStreamSequence0.getOtherCount());
      assertEquals(2, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      
      ATDeviationAlgorithm aTDeviationAlgorithm0 = new ATDeviationAlgorithm(strand0);
      assertNotNull(aTDeviationAlgorithm0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(17, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(14, emblStreamSequence0.getOtherCount());
      assertEquals(2, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals("AT Deviation (A-T)/(A+T)", aTDeviationAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, aTDeviationAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, aTDeviationAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, aTDeviationAlgorithm0.getValueCount());
      assertFalse(aTDeviationAlgorithm0.isUserMaxMin());
      assertTrue(aTDeviationAlgorithm0.scalingFlag());
      assertEquals("at_deviation", aTDeviationAlgorithm0.getAlgorithmShortName());
      assertFalse(aTDeviationAlgorithm0.isRevCompDisplay());
      
      Integer integer0 = aTDeviationAlgorithm0.getDefaultWindowSize();
      assertNotNull(integer0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(17, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(14, emblStreamSequence0.getOtherCount());
      assertEquals(2, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals("AT Deviation (A-T)/(A+T)", aTDeviationAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, aTDeviationAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, aTDeviationAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, aTDeviationAlgorithm0.getValueCount());
      assertFalse(aTDeviationAlgorithm0.isUserMaxMin());
      assertTrue(aTDeviationAlgorithm0.scalingFlag());
      assertEquals("at_deviation", aTDeviationAlgorithm0.getAlgorithmShortName());
      assertFalse(aTDeviationAlgorithm0.isRevCompDisplay());
      assertEquals(30, (int)integer0);
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("Scaled Chi Square");
      Bases bases0 = new Bases(emblStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      ATDeviationAlgorithm aTDeviationAlgorithm0 = new ATDeviationAlgorithm(strand0);
      float[] floatArray0 = new float[2];
      aTDeviationAlgorithm0.getValues(1, 1333, floatArray0);
      assertArrayEquals(new float[] {(-0.33333334F), 0.0F}, floatArray0, 0.01F);
      assertTrue(aTDeviationAlgorithm0.scalingFlag());
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("Y+dP9ZU-7#e[");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      ATDeviationAlgorithm aTDeviationAlgorithm0 = new ATDeviationAlgorithm(strand0);
      float[] floatArray0 = new float[8];
      aTDeviationAlgorithm0.getValues(592, 1197, floatArray0);
      assertArrayEquals(new float[] {0.0F, 0.0F, 0.0F, 0.0F, 0.0F, 0.0F, 0.0F, 0.0F}, floatArray0, 0.01F);
      assertTrue(aTDeviationAlgorithm0.scalingFlag());
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = bases0.getReverseStrand();
      ATDeviationAlgorithm aTDeviationAlgorithm0 = new ATDeviationAlgorithm(strand0);
      Float float0 = aTDeviationAlgorithm0.getMaximumInternal();
      assertTrue(aTDeviationAlgorithm0.scalingFlag());
      assertEquals(1.0F, (float)float0, 0.01F);
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("Scaled Chi Square");
      Bases bases0 = new Bases(emblStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      ATDeviationAlgorithm aTDeviationAlgorithm0 = new ATDeviationAlgorithm(strand0);
      int int0 = aTDeviationAlgorithm0.getValueCount();
      assertEquals(1, int0);
      assertTrue(aTDeviationAlgorithm0.scalingFlag());
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("Scaled Chi Square");
      Bases bases0 = new Bases(emblStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      ATDeviationAlgorithm aTDeviationAlgorithm0 = new ATDeviationAlgorithm(strand0);
      Float float0 = aTDeviationAlgorithm0.getMinimumInternal();
      assertEquals((-1.0F), (float)float0, 0.01F);
      assertTrue(aTDeviationAlgorithm0.scalingFlag());
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = bases0.getForwardStrand();
      ATDeviationAlgorithm aTDeviationAlgorithm0 = new ATDeviationAlgorithm(strand0);
      // Undeclared exception!
      try { 
        aTDeviationAlgorithm0.getAverage();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }
}
