/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 16:20:47 GMT 2018
 */

package uk.ac.sanger.artemis.plot;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.io.FileNotFoundException;
import javax.swing.JPasswordField;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.mock.java.io.MockFile;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.io.RawStreamSequence;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.j2ssh.SshLogin;
import uk.ac.sanger.artemis.plot.UserDataAlgorithm;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.Strand;
import uk.ac.sanger.artemis.util.ByteBuffer;
import uk.ac.sanger.artemis.util.DatabaseDocument;
import uk.ac.sanger.artemis.util.FileDocument;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class UserDataAlgorithm_ESTest extends UserDataAlgorithm_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test0()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("-i");
      Bases bases0 = new Bases(rawStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      JPasswordField jPasswordField0 = new JPasswordField(0);
      ByteBuffer byteBuffer0 = new ByteBuffer();
      DatabaseDocument databaseDocument0 = new DatabaseDocument("", jPasswordField0, " ", "X'\"OJJ;&HK", byteBuffer0, " ");
      UserDataAlgorithm userDataAlgorithm0 = null;
      try {
        userDataAlgorithm0 = new UserDataAlgorithm(strand0, databaseDocument0, false);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
      }
  }

  @Test(timeout = 4000)
  public void test1()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = bases0.getReverseStrand();
      MockFile mockFile0 = new MockFile("%.2f");
      FileDocument fileDocument0 = new FileDocument(mockFile0);
      UserDataAlgorithm userDataAlgorithm0 = null;
      try {
        userDataAlgorithm0 = new UserDataAlgorithm(strand0, fileDocument0, true);
        fail("Expecting exception: FileNotFoundException");
      
      } catch(Throwable e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.mock.java.io.MockFileInputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test2()  throws Throwable  {
      SshLogin sshLogin0 = new SshLogin();
      JPasswordField jPasswordField0 = sshLogin0.getJPasswordField();
      DatabaseDocument databaseDocument0 = new DatabaseDocument(" - ", jPasswordField0);
      UserDataAlgorithm userDataAlgorithm0 = null;
      try {
        userDataAlgorithm0 = new UserDataAlgorithm((Strand) null, databaseDocument0, false);
        fail("Expecting exception: StringIndexOutOfBoundsException");
      
      } catch(StringIndexOutOfBoundsException e) {
      }
  }
}
