/*
 * This file was automatically generated by EvoSuite
 * Thu Sep 20 13:45:47 GMT 2018
 */

package uk.ac.sanger.artemis;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.datatransfer.Clipboard;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.FeatureVector;
import uk.ac.sanger.artemis.Selection;
import uk.ac.sanger.artemis.SimpleEntryGroup;
import uk.ac.sanger.artemis.io.FastaStreamSequence;
import uk.ac.sanger.artemis.io.GenbankStreamFeature;
import uk.ac.sanger.artemis.io.GenbankStreamSequence;
import uk.ac.sanger.artemis.sequence.Bases;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, useJEE = true) 
public class FeatureVector_ESTest extends FeatureVector_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("");
      assertNotNull(genbankStreamSequence0);
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.length());
      
      Bases bases0 = new Bases(genbankStreamSequence0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertNotNull(bases0);
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.length());
      assertEquals(0, bases0.getLength());
      
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertNotNull(simpleEntryGroup0);
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.length());
      assertEquals(0, bases0.getLength());
      assertEquals(0, simpleEntryGroup0.getSequenceLength());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      
      FeatureVector featureVector0 = simpleEntryGroup0.getAllFeatures();
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertNotNull(featureVector0);
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.length());
      assertEquals(0, bases0.getLength());
      assertEquals(0, simpleEntryGroup0.getSequenceLength());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      
      Entry entry0 = Entry.newEntry(bases0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertNotNull(entry0);
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.length());
      assertEquals(0, bases0.getLength());
      assertFalse(entry0.isReadOnly());
      
      genbankStreamSequence0.setFromChar(bases0.letter_index);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(1, genbankStreamSequence0.getACount());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertEquals(1, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(1, genbankStreamSequence0.getTCount());
      assertEquals(5, genbankStreamSequence0.length());
      assertEquals(1, genbankStreamSequence0.getOtherCount());
      assertEquals(5, bases0.getLength());
      
      Feature feature0 = entry0.createFeature();
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertNotNull(feature0);
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(1, genbankStreamSequence0.getACount());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertEquals(1, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(1, genbankStreamSequence0.getTCount());
      assertEquals(5, genbankStreamSequence0.length());
      assertEquals(1, genbankStreamSequence0.getOtherCount());
      assertEquals(5, bases0.getLength());
      assertFalse(entry0.isReadOnly());
      assertFalse(feature0.isReadOnly());
      assertFalse(feature0.isCDS());
      assertFalse(feature0.isProteinFeature());
      
      featureVector0.insertElementAfter(feature0, (Feature) null);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(1, genbankStreamSequence0.getACount());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertEquals(1, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(1, genbankStreamSequence0.getTCount());
      assertEquals(5, genbankStreamSequence0.length());
      assertEquals(1, genbankStreamSequence0.getOtherCount());
      assertEquals(5, bases0.getLength());
      assertEquals(5, simpleEntryGroup0.getSequenceLength());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      assertFalse(entry0.isReadOnly());
      assertFalse(feature0.isReadOnly());
      assertFalse(feature0.isCDS());
      assertFalse(feature0.isProteinFeature());
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard("");
      assertNotNull(clipboard0);
      assertEquals("", clipboard0.getName());
      
      Selection selection0 = new Selection(clipboard0);
      assertNotNull(selection0);
      assertEquals("", clipboard0.getName());
      
      FeatureVector featureVector0 = selection0.getAllFeatures();
      assertNotNull(featureVector0);
      assertEquals("", clipboard0.getName());
      
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      assertNotNull(genbankStreamFeature0);
      
      Feature feature0 = new Feature(genbankStreamFeature0);
      assertNotNull(feature0);
      assertTrue(feature0.isProteinFeature());
      assertFalse(feature0.isReadOnly());
      assertTrue(feature0.isCDS());
      
      featureVector0.add(feature0);
      assertEquals("", clipboard0.getName());
      assertTrue(feature0.isProteinFeature());
      assertFalse(feature0.isReadOnly());
      assertTrue(feature0.isCDS());
      
      featureVector0.removeElementAt(0);
      assertEquals("", clipboard0.getName());
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard("uk.ac.sanger.artemis.plot.UserDawaAlgorithm$TabixIdxGraph");
      assertNotNull(clipboard0);
      assertEquals("uk.ac.sanger.artemis.plot.UserDawaAlgorithm$TabixIdxGraph", clipboard0.getName());
      
      Selection selection0 = new Selection(clipboard0);
      assertNotNull(selection0);
      assertEquals("uk.ac.sanger.artemis.plot.UserDawaAlgorithm$TabixIdxGraph", clipboard0.getName());
      
      FeatureVector featureVector0 = selection0.getAllFeatures();
      assertNotNull(featureVector0);
      assertEquals("uk.ac.sanger.artemis.plot.UserDawaAlgorithm$TabixIdxGraph", clipboard0.getName());
      
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("uk.ac.sanger.artemis.plot.UserDawaAlgorithm$TabixIdxGraph");
      assertNotNull(fastaStreamSequence0);
      assertEquals(44, fastaStreamSequence0.getOtherCount());
      assertEquals(1, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(7, fastaStreamSequence0.getACount());
      assertEquals(57, fastaStreamSequence0.length());
      assertEquals(2, fastaStreamSequence0.getGCount());
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertNotNull(bases0);
      assertEquals(44, fastaStreamSequence0.getOtherCount());
      assertEquals(1, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(7, fastaStreamSequence0.getACount());
      assertEquals(57, fastaStreamSequence0.length());
      assertEquals(2, fastaStreamSequence0.getGCount());
      assertEquals(57, bases0.getLength());
      
      Entry entry0 = Entry.newEntry(bases0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertNotNull(entry0);
      assertEquals(44, fastaStreamSequence0.getOtherCount());
      assertEquals(1, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(7, fastaStreamSequence0.getACount());
      assertEquals(57, fastaStreamSequence0.length());
      assertEquals(2, fastaStreamSequence0.getGCount());
      assertEquals(57, bases0.getLength());
      assertFalse(entry0.isReadOnly());
      
      Feature feature0 = entry0.createFeature();
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertNotNull(feature0);
      assertEquals(44, fastaStreamSequence0.getOtherCount());
      assertEquals(1, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(7, fastaStreamSequence0.getACount());
      assertEquals(57, fastaStreamSequence0.length());
      assertEquals(2, fastaStreamSequence0.getGCount());
      assertEquals(57, bases0.getLength());
      assertFalse(entry0.isReadOnly());
      assertFalse(feature0.isProteinFeature());
      assertFalse(feature0.isCDS());
      assertFalse(feature0.isReadOnly());
      
      featureVector0.addElementAtEnd(feature0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals("uk.ac.sanger.artemis.plot.UserDawaAlgorithm$TabixIdxGraph", clipboard0.getName());
      assertEquals(44, fastaStreamSequence0.getOtherCount());
      assertEquals(1, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(7, fastaStreamSequence0.getACount());
      assertEquals(57, fastaStreamSequence0.length());
      assertEquals(2, fastaStreamSequence0.getGCount());
      assertEquals(57, bases0.getLength());
      assertFalse(entry0.isReadOnly());
      assertFalse(feature0.isProteinFeature());
      assertFalse(feature0.isCDS());
      assertFalse(feature0.isReadOnly());
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard("");
      assertNotNull(clipboard0);
      assertEquals("", clipboard0.getName());
      
      Selection selection0 = new Selection(clipboard0);
      assertNotNull(selection0);
      assertEquals("", clipboard0.getName());
      
      FeatureVector featureVector0 = selection0.getAllFeatures();
      assertNotNull(featureVector0);
      assertEquals("", clipboard0.getName());
      
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      assertNotNull(genbankStreamFeature0);
      
      Feature feature0 = new Feature(genbankStreamFeature0);
      assertNotNull(feature0);
      assertTrue(feature0.isCDS());
      assertFalse(feature0.isReadOnly());
      assertTrue(feature0.isProteinFeature());
      
      featureVector0.add(feature0);
      assertEquals("", clipboard0.getName());
      assertTrue(feature0.isCDS());
      assertFalse(feature0.isReadOnly());
      assertTrue(feature0.isProteinFeature());
      
      int int0 = featureVector0.size();
      assertEquals("", clipboard0.getName());
      assertEquals(1, int0);
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      FeatureVector featureVector0 = new FeatureVector();
      assertNotNull(featureVector0);
      
      featureVector0.insertElementAfter((Feature) null, (Feature) null);
      boolean boolean0 = featureVector0.remove((Feature) null);
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      FeatureVector featureVector0 = new FeatureVector();
      assertNotNull(featureVector0);
      
      featureVector0.insertElementAfter((Feature) null, (Feature) null);
      Feature feature0 = featureVector0.lastElement();
      assertNull(feature0);
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard("uk.ac.sanger.artemis.plot.UserDawaAlgorithm$TabixIdxGraph");
      assertNotNull(clipboard0);
      assertEquals("uk.ac.sanger.artemis.plot.UserDawaAlgorithm$TabixIdxGraph", clipboard0.getName());
      
      Selection selection0 = new Selection(clipboard0);
      assertNotNull(selection0);
      assertEquals("uk.ac.sanger.artemis.plot.UserDawaAlgorithm$TabixIdxGraph", clipboard0.getName());
      
      FeatureVector featureVector0 = selection0.getAllFeatures();
      assertNotNull(featureVector0);
      assertEquals("uk.ac.sanger.artemis.plot.UserDawaAlgorithm$TabixIdxGraph", clipboard0.getName());
      
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("uk.ac.sanger.artemis.plot.UserDawaAlgorithm$TabixIdxGraph");
      assertNotNull(fastaStreamSequence0);
      assertEquals(3, fastaStreamSequence0.getTCount());
      assertEquals(44, fastaStreamSequence0.getOtherCount());
      assertEquals(7, fastaStreamSequence0.getACount());
      assertEquals(57, fastaStreamSequence0.length());
      assertEquals(2, fastaStreamSequence0.getGCount());
      assertEquals(1, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertNotNull(bases0);
      assertEquals(3, fastaStreamSequence0.getTCount());
      assertEquals(44, fastaStreamSequence0.getOtherCount());
      assertEquals(7, fastaStreamSequence0.getACount());
      assertEquals(57, fastaStreamSequence0.length());
      assertEquals(2, fastaStreamSequence0.getGCount());
      assertEquals(1, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(57, bases0.getLength());
      
      Entry entry0 = Entry.newEntry(bases0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertNotNull(entry0);
      assertEquals(3, fastaStreamSequence0.getTCount());
      assertEquals(44, fastaStreamSequence0.getOtherCount());
      assertEquals(7, fastaStreamSequence0.getACount());
      assertEquals(57, fastaStreamSequence0.length());
      assertEquals(2, fastaStreamSequence0.getGCount());
      assertEquals(1, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(57, bases0.getLength());
      assertFalse(entry0.isReadOnly());
      
      Feature feature0 = entry0.createFeature();
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertNotNull(feature0);
      assertEquals(3, fastaStreamSequence0.getTCount());
      assertEquals(44, fastaStreamSequence0.getOtherCount());
      assertEquals(7, fastaStreamSequence0.getACount());
      assertEquals(57, fastaStreamSequence0.length());
      assertEquals(2, fastaStreamSequence0.getGCount());
      assertEquals(1, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(57, bases0.getLength());
      assertFalse(entry0.isReadOnly());
      assertFalse(feature0.isReadOnly());
      assertFalse(feature0.isCDS());
      assertFalse(feature0.isProteinFeature());
      
      featureVector0.insertElementAt(feature0, 0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals("uk.ac.sanger.artemis.plot.UserDawaAlgorithm$TabixIdxGraph", clipboard0.getName());
      assertEquals(3, fastaStreamSequence0.getTCount());
      assertEquals(44, fastaStreamSequence0.getOtherCount());
      assertEquals(7, fastaStreamSequence0.getACount());
      assertEquals(57, fastaStreamSequence0.length());
      assertEquals(2, fastaStreamSequence0.getGCount());
      assertEquals(1, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(57, bases0.getLength());
      assertFalse(entry0.isReadOnly());
      assertFalse(feature0.isReadOnly());
      assertFalse(feature0.isCDS());
      assertFalse(feature0.isProteinFeature());
      
      Feature feature1 = featureVector0.lastElement();
      assertSame(feature1, feature0);
      assertNotNull(feature1);
      assertEquals("uk.ac.sanger.artemis.plot.UserDawaAlgorithm$TabixIdxGraph", clipboard0.getName());
      assertFalse(feature1.isCDS());
      assertFalse(feature1.isProteinFeature());
      assertFalse(feature1.isReadOnly());
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      FeatureVector featureVector0 = new FeatureVector();
      assertNotNull(featureVector0);
      
      featureVector0.insertElementAfter((Feature) null, (Feature) null);
      int int0 = featureVector0.indexOf((Feature) null);
      assertEquals(0, int0);
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard("uk.ac.sanger.artemis.plot.UserDawaAlgorithm$TabixIdxGraph");
      assertNotNull(clipboard0);
      assertEquals("uk.ac.sanger.artemis.plot.UserDawaAlgorithm$TabixIdxGraph", clipboard0.getName());
      
      Selection selection0 = new Selection(clipboard0);
      assertNotNull(selection0);
      assertEquals("uk.ac.sanger.artemis.plot.UserDawaAlgorithm$TabixIdxGraph", clipboard0.getName());
      
      FeatureVector featureVector0 = selection0.getAllFeatures();
      assertNotNull(featureVector0);
      assertEquals("uk.ac.sanger.artemis.plot.UserDawaAlgorithm$TabixIdxGraph", clipboard0.getName());
      
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("uk.ac.sanger.artemis.plot.UserDawaAlgorithm$TabixIdxGraph");
      assertNotNull(fastaStreamSequence0);
      assertEquals(57, fastaStreamSequence0.length());
      assertEquals(2, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getTCount());
      assertEquals(7, fastaStreamSequence0.getACount());
      assertEquals(44, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(1, fastaStreamSequence0.getCCount());
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertNotNull(bases0);
      assertEquals(57, fastaStreamSequence0.length());
      assertEquals(2, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getTCount());
      assertEquals(7, fastaStreamSequence0.getACount());
      assertEquals(44, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(1, fastaStreamSequence0.getCCount());
      assertEquals(57, bases0.getLength());
      
      Entry entry0 = Entry.newEntry(bases0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertNotNull(entry0);
      assertEquals(57, fastaStreamSequence0.length());
      assertEquals(2, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getTCount());
      assertEquals(7, fastaStreamSequence0.getACount());
      assertEquals(44, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(1, fastaStreamSequence0.getCCount());
      assertEquals(57, bases0.getLength());
      assertFalse(entry0.isReadOnly());
      
      Feature feature0 = entry0.createFeature();
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertNotNull(feature0);
      assertEquals(57, fastaStreamSequence0.length());
      assertEquals(2, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getTCount());
      assertEquals(7, fastaStreamSequence0.getACount());
      assertEquals(44, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(1, fastaStreamSequence0.getCCount());
      assertEquals(57, bases0.getLength());
      assertFalse(entry0.isReadOnly());
      assertFalse(feature0.isCDS());
      assertFalse(feature0.isReadOnly());
      assertFalse(feature0.isProteinFeature());
      
      featureVector0.insertElementAt(feature0, 0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals("uk.ac.sanger.artemis.plot.UserDawaAlgorithm$TabixIdxGraph", clipboard0.getName());
      assertEquals(57, fastaStreamSequence0.length());
      assertEquals(2, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getTCount());
      assertEquals(7, fastaStreamSequence0.getACount());
      assertEquals(44, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(1, fastaStreamSequence0.getCCount());
      assertEquals(57, bases0.getLength());
      assertFalse(entry0.isReadOnly());
      assertFalse(feature0.isCDS());
      assertFalse(feature0.isReadOnly());
      assertFalse(feature0.isProteinFeature());
      
      boolean boolean0 = featureVector0.contains(feature0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals("uk.ac.sanger.artemis.plot.UserDawaAlgorithm$TabixIdxGraph", clipboard0.getName());
      assertEquals(57, fastaStreamSequence0.length());
      assertEquals(2, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getTCount());
      assertEquals(7, fastaStreamSequence0.getACount());
      assertEquals(44, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(1, fastaStreamSequence0.getCCount());
      assertEquals(57, bases0.getLength());
      assertFalse(entry0.isReadOnly());
      assertFalse(feature0.isCDS());
      assertFalse(feature0.isReadOnly());
      assertFalse(feature0.isProteinFeature());
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      FeatureVector featureVector0 = new FeatureVector();
      assertNotNull(featureVector0);
      
      // Undeclared exception!
      try { 
        featureVector0.removeElementAt(491);
        fail("Expecting exception: IndexOutOfBoundsException");
      
      } catch(IndexOutOfBoundsException e) {
         //
         // Index: 491, Size: 0
         //
         verifyException("java.util.ArrayList", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      
      FeatureVector featureVector0 = simpleEntryGroup0.getAllFeatures();
      assertNotNull(featureVector0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      
      // Undeclared exception!
      try { 
        featureVector0.elementAt((-3419));
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      FeatureVector featureVector0 = new FeatureVector();
      assertNotNull(featureVector0);
      
      // Undeclared exception!
      try { 
        featureVector0.contains((Feature) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.FeatureVector", e);
      }
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard("");
      assertNotNull(clipboard0);
      assertEquals("", clipboard0.getName());
      
      Selection selection0 = new Selection(clipboard0);
      assertNotNull(selection0);
      assertEquals("", clipboard0.getName());
      
      FeatureVector featureVector0 = selection0.getSelectedFeatures();
      assertNotNull(featureVector0);
      assertEquals("", clipboard0.getName());
      
      Object object0 = featureVector0.clone();
      assertNotSame(featureVector0, object0);
      assertNotSame(object0, featureVector0);
      assertNotNull(object0);
      assertEquals("", clipboard0.getName());
      assertFalse(object0.equals((Object)featureVector0));
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard("uk.ac.sanger.artemis.plot.UserDawaAlgorithm$TabixIdxGraph");
      assertNotNull(clipboard0);
      assertEquals("uk.ac.sanger.artemis.plot.UserDawaAlgorithm$TabixIdxGraph", clipboard0.getName());
      
      Selection selection0 = new Selection(clipboard0);
      assertNotNull(selection0);
      assertEquals("uk.ac.sanger.artemis.plot.UserDawaAlgorithm$TabixIdxGraph", clipboard0.getName());
      
      FeatureVector featureVector0 = selection0.getAllFeatures();
      assertNotNull(featureVector0);
      assertEquals("uk.ac.sanger.artemis.plot.UserDawaAlgorithm$TabixIdxGraph", clipboard0.getName());
      
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("uk.ac.sanger.artemis.plot.UserDawaAlgorithm$TabixIdxGraph", "uk.ac.sanger.artemis.plot.UserDawaAlgorithm$TabixIdxGraph");
      assertNotNull(fastaStreamSequence0);
      assertEquals(44, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(1, fastaStreamSequence0.getCCount());
      assertEquals(57, fastaStreamSequence0.length());
      assertEquals(2, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getTCount());
      assertEquals(7, fastaStreamSequence0.getACount());
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertNotNull(bases0);
      assertEquals(44, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(1, fastaStreamSequence0.getCCount());
      assertEquals(57, fastaStreamSequence0.length());
      assertEquals(2, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getTCount());
      assertEquals(7, fastaStreamSequence0.getACount());
      assertEquals(57, bases0.getLength());
      
      Entry entry0 = Entry.newEntry(bases0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertNotNull(entry0);
      assertEquals(44, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(1, fastaStreamSequence0.getCCount());
      assertEquals(57, fastaStreamSequence0.length());
      assertEquals(2, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getTCount());
      assertEquals(7, fastaStreamSequence0.getACount());
      assertEquals(57, bases0.getLength());
      assertFalse(entry0.isReadOnly());
      
      Feature feature0 = entry0.createFeature();
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertNotNull(feature0);
      assertEquals(44, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(1, fastaStreamSequence0.getCCount());
      assertEquals(57, fastaStreamSequence0.length());
      assertEquals(2, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getTCount());
      assertEquals(7, fastaStreamSequence0.getACount());
      assertEquals(57, bases0.getLength());
      assertFalse(entry0.isReadOnly());
      assertFalse(feature0.isReadOnly());
      assertFalse(feature0.isCDS());
      assertFalse(feature0.isProteinFeature());
      
      boolean boolean0 = featureVector0.contains(feature0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals("uk.ac.sanger.artemis.plot.UserDawaAlgorithm$TabixIdxGraph", clipboard0.getName());
      assertEquals(44, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(1, fastaStreamSequence0.getCCount());
      assertEquals(57, fastaStreamSequence0.length());
      assertEquals(2, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getTCount());
      assertEquals(7, fastaStreamSequence0.getACount());
      assertEquals(57, bases0.getLength());
      assertFalse(entry0.isReadOnly());
      assertFalse(feature0.isReadOnly());
      assertFalse(feature0.isCDS());
      assertFalse(feature0.isProteinFeature());
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      FeatureVector featureVector0 = new FeatureVector();
      featureVector0.insertElementAfter((Feature) null, (Feature) null);
      Feature feature0 = featureVector0.elementAt(0);
      assertNull(feature0);
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard("uk.ac.sanger.artemis.plot.UserDawaAlgorithm$TabixIdxGraph");
      Selection selection0 = new Selection(clipboard0);
      FeatureVector featureVector0 = selection0.getAllFeatures();
      // Undeclared exception!
      try { 
        featureVector0.lastElement();
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      FeatureVector featureVector0 = new FeatureVector();
      // Undeclared exception!
      try { 
        featureVector0.elementAt(2360);
        fail("Expecting exception: IndexOutOfBoundsException");
      
      } catch(IndexOutOfBoundsException e) {
         //
         // Index: 2360, Size: 0
         //
         verifyException("java.util.ArrayList", e);
      }
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      FeatureVector featureVector0 = new FeatureVector();
      // Undeclared exception!
      try { 
        featureVector0.insertElementAt((Feature) null, 45);
        fail("Expecting exception: IndexOutOfBoundsException");
      
      } catch(IndexOutOfBoundsException e) {
         //
         // Index: 45, Size: 0
         //
         verifyException("java.util.ArrayList", e);
      }
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      FeatureVector featureVector0 = new FeatureVector();
      int int0 = featureVector0.size();
      assertEquals(0, int0);
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      FeatureVector featureVector0 = new FeatureVector();
      org.biojava.bio.seq.Feature.ByLocationComparator feature_ByLocationComparator0 = org.biojava.bio.seq.Feature.byLocationOrder;
      FeatureVector featureVector1 = featureVector0.sort(feature_ByLocationComparator0);
      assertNotSame(featureVector1, featureVector0);
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("");
      Bases bases0 = new Bases(genbankStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      FeatureVector featureVector0 = simpleEntryGroup0.getAllFeatures();
      Entry entry0 = Entry.newEntry(bases0);
      genbankStreamSequence0.setFromChar(bases0.letter_index);
      Feature feature0 = entry0.createFeature();
      featureVector0.indexOf(feature0);
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard("Q/w,]7O7I2{TFytqYE");
      Selection selection0 = new Selection(clipboard0);
      FeatureVector featureVector0 = selection0.getAllFeatures();
      featureVector0.removeAllElements();
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      FeatureVector featureVector0 = new FeatureVector();
      boolean boolean0 = featureVector0.remove((Feature) null);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test23()  throws Throwable  {
      FeatureVector featureVector0 = new FeatureVector();
      // Undeclared exception!
      try { 
        featureVector0.add((Feature) null);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - adding a null object
         //
         verifyException("uk.ac.sanger.artemis.util.FastVector", e);
      }
  }

  @Test(timeout = 4000)
  public void test24()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard("m3s`d0PFla<g");
      Selection selection0 = new Selection(clipboard0);
      FeatureVector featureVector0 = selection0.getSelectedFeatures();
      // Undeclared exception!
      try { 
        featureVector0.removeElementAt((-831));
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test25()  throws Throwable  {
      FeatureVector featureVector0 = new FeatureVector();
      // Undeclared exception!
      try { 
        featureVector0.addElementAtEnd((Feature) null);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - adding a null object
         //
         verifyException("uk.ac.sanger.artemis.util.FastVector", e);
      }
  }
}
