/*
 * This file was automatically generated by EvoSuite
 * Wed Sep 19 21:17:54 GMT 2018
 */

package uk.ac.sanger.artemis.circular;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.shaded.org.mockito.Mockito.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.Stack;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import org.apache.xmlgraphics.java2d.DefaultGraphics2D;
import org.apache.xmlgraphics.java2d.GraphicsConfigurationWithoutTransparency;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.ViolatedAssumptionAnswer;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.SimpleEntryGroup;
import uk.ac.sanger.artemis.circular.Block;
import uk.ac.sanger.artemis.circular.DNADraw;
import uk.ac.sanger.artemis.circular.Track;
import uk.ac.sanger.artemis.circular.TrackManager;
import uk.ac.sanger.artemis.io.BlastDocumentEntry;
import uk.ac.sanger.artemis.io.MSPcrunchEntryInformation;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.util.StringVector;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = false, useJEE = true) 
public class Block_ESTest extends Block_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      Color color0 = Color.lightGray;
      Track track0 = new Track(1.0, (Entry) null);
      Vector<String> vector0 = new Vector<String>();
      DNADraw dNADraw0 = new DNADraw(vector0, vector0, vector0, vector0);
      Block block0 = new Block("fm3", (-535), 279, color0, 279, track0, dNADraw0);
      block0.getLinePoints((-705));
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      Color color0 = Color.white;
      Track track0 = new Track((-3195.1743F), (String) null, (String) null, false, false, false, (Entry) null);
      DNADraw dNADraw0 = new DNADraw();
      Block block0 = new Block("NVDj-VFoVP{T\"J", 0, (-8050), color0, (-3195.1743F), track0, dNADraw0);
      // Undeclared exception!
      try { 
        block0.setBlockLocation(13, 0, (TrackManager) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.circular.Block", e);
      }
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      Vector<Object> vector0 = new Vector<Object>();
      DNADraw dNADraw0 = new DNADraw(vector0, vector0, vector0, (Vector) null);
      Color color0 = dNADraw0.getForeground();
      Block block0 = new Block("spacingAndGlyphs", 1031, 1031, color0, 2.0F, (Track) null, dNADraw0);
      block0.setArrowHead(true);
      block0.isArrowHead();
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      DNADraw dNADraw0 = new DNADraw();
      Block block0 = new Block("*x>CV0rM", 0, 0, (Color) null, 0, (Track) null, dNADraw0);
      block0.getTrack();
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      Color color0 = Color.white;
      Track track0 = new Track((-3195.1743F), (String) null, (String) null, false, false, false, (Entry) null);
      DNADraw dNADraw0 = new DNADraw();
      Block block0 = new Block("NVDj-VFoVP{T\"J", 13, (-8050), color0, (-3195.1743F), track0, dNADraw0);
      block0.getTrack();
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      JPanel jPanel0 = new JPanel(true);
      Color color0 = jPanel0.getForeground();
      Entry entry0 = mock(Entry.class, new ViolatedAssumptionAnswer());
      Track track0 = new Track(0.05, "", "", true, true, true, entry0);
      Block block0 = new Block("", 151, 151, color0, 0.0F, track0, (DNADraw) null);
      block0.getTrack();
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      Color color0 = Color.ORANGE;
      Track track0 = new Track((-1617), (Entry) null);
      Block block0 = new Block("uk.ac.sanger.artemis.circular.Block$4", (-1617), (-1617), color0, (-1617), track0);
      block0.getTrack();
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      Vector<Object> vector0 = new Vector<Object>();
      DNADraw dNADraw0 = new DNADraw(vector0, vector0, vector0, (Vector) null);
      Color color0 = dNADraw0.getForeground();
      Block block0 = new Block("spacingAndGlyphs", 1031, 1031, color0, 2.0F, (Track) null, dNADraw0);
      block0.setStrokeSize(0.0F);
      block0.getStrokeSize();
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      SystemColor systemColor0 = SystemColor.text;
      Track track0 = new Track(646.65F, "2aPzp@3;sf4(Hs", false, false, (Entry) null);
      Block block0 = new Block("2aPzp@3;sf4(Hs", 3152, 0, systemColor0, 646.65F, track0);
      block0.getStrokeSize();
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      Color color0 = Color.WHITE;
      Block block0 = new Block("`r?s+j(PaS=", 2047, 3991, color0, 0.5F, (Track) null, (DNADraw) null);
      block0.setAngStart(601.4503);
      block0.getMidAngle();
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      Color color0 = Color.orange;
      Track track0 = new Track(3.0, "drawString(String)", false, false, (Entry) null);
      Block block0 = new Block("", 1164, (-1024), color0, 0.0F, track0);
      block0.getLabel();
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      Color color0 = Color.lightGray;
      Track track0 = new Track(1.0, (Entry) null);
      Vector<String> vector0 = new Vector<String>();
      DNADraw dNADraw0 = new DNADraw(vector0, vector0, vector0, vector0);
      Block block0 = new Block("fm3", (-535), 279, color0, 279, track0, dNADraw0);
      block0.getColour();
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      DNADraw dNADraw0 = new DNADraw();
      Block block0 = new Block("*x>CV0rM", 0, 0, (Color) null, 0, (Track) null, dNADraw0);
      block0.getBstart();
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      Track track0 = new Track(0.0, (Entry) null);
      Block block0 = new Block("uuNdHXLfp/.0]e", 2139536721, 2139536721, (Color) null, (-1220.31F), track0);
      block0.getBstart();
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      Color color0 = Color.magenta;
      Vector<AffineTransform> vector0 = new Vector<AffineTransform>();
      Vector<Rectangle> vector1 = new Vector<Rectangle>();
      DNADraw dNADraw0 = new DNADraw(vector0, vector0, vector0, vector1);
      Block block0 = new Block("wf-invalid-character", 292, 3, color0, 3, (Track) null, dNADraw0);
      block0.getBend();
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      Color color0 = Color.orange;
      Track track0 = new Track(3.0, "drawString(String)", false, false, (Entry) null);
      Block block0 = new Block("", 1164, (-1024), color0, 0.0F, track0);
      block0.getBend();
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      DNADraw dNADraw0 = new DNADraw();
      Color color0 = dNADraw0.getForeground();
      MSPcrunchEntryInformation mSPcrunchEntryInformation0 = new MSPcrunchEntryInformation();
      BlastDocumentEntry blastDocumentEntry0 = new BlastDocumentEntry(mSPcrunchEntryInformation0);
      Entry entry0 = new Entry((Bases) null, blastDocumentEntry0);
      Track track0 = new Track((-1.0F), entry0);
      Block block0 = new Block("r]Ed-oA7QN", 8913, 8913, color0, (-1.0F), track0);
      // Undeclared exception!
      try { 
        block0.isOverMe(0, (-1314));
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.circular.Block", e);
      }
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      JList<Integer> jList0 = new JList<Integer>((Integer[]) null);
      Color color0 = jList0.getSelectionForeground();
      Track track0 = new Track(861, (String) null, true, true, (Entry) null);
      DNADraw dNADraw0 = new DNADraw((Vector) null, (Vector) null, (Vector) null, (Vector) null);
      Block block0 = new Block("", 861, 861, color0, 861, track0, dNADraw0);
      // Undeclared exception!
      try { 
        block0.getTransferData((DataFlavor) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.circular.Block", e);
      }
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      Color color0 = Color.WHITE;
      Block block0 = new Block("`r?s+j(PaS=", 2047, 3991, color0, 0.5F, (Track) null, (DNADraw) null);
      // Undeclared exception!
      try { 
        block0.getLinePoints(3991);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.circular.Block", e);
      }
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      Color color0 = Color.WHITE;
      Block block0 = new Block("`r?s+j(PaS=", 2047, 3991, color0, 0.5F, (Track) null, (DNADraw) null);
      // Undeclared exception!
      try { 
        block0.getColour();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.circular.Block", e);
      }
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      Color color0 = Color.white;
      Track track0 = new Track((-1258.0F), (Entry) null);
      Block block0 = new Block("specularExponent", (-321), (-321), color0, (-1258.0F), track0);
      DefaultGraphics2D defaultGraphics2D0 = new DefaultGraphics2D(false);
      // Undeclared exception!
      try { 
        block0.drawLinear(defaultGraphics2D0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.apache.xmlgraphics.java2d.AbstractGraphics2D", e);
      }
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      Track track0 = new Track(1.0, (Entry) null);
      StringVector stringVector0 = new StringVector();
      DNADraw dNADraw0 = new DNADraw(stringVector0, stringVector0, stringVector0, stringVector0);
      Block block0 = new Block("gK", (-2721), (-2721), (Color) null, 0, track0, dNADraw0);
      block0.getColour();
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      Color color0 = Color.lightGray;
      Track track0 = new Track(1.0, (Entry) null);
      Vector<String> vector0 = new Vector<String>();
      DNADraw dNADraw0 = new DNADraw(vector0, vector0, vector0, vector0);
      Block block0 = new Block("fm3", (-535), 279, color0, 279, track0, dNADraw0);
      block0.getAngEnd();
  }

  @Test(timeout = 4000)
  public void test23()  throws Throwable  {
      Color color0 = Color.DARK_GRAY;
      assertEquals(64, color0.getBlue());
      assertEquals(1, color0.getTransparency());
      assertEquals(64, color0.getGreen());
      assertEquals(255, color0.getAlpha());
      assertEquals(64, color0.getRed());
      assertEquals((-12566464), color0.getRGB());
      assertNotNull(color0);
      
      Bases bases0 = new Bases((Sequence) null);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertNotNull(bases0);
      
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertNotNull(simpleEntryGroup0);
      
      Entry entry0 = simpleEntryGroup0.createEntry("XhAqG GKSq/^0iNS}U");
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(1, simpleEntryGroup0.size());
      assertFalse(entry0.isReadOnly());
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertNotNull(entry0);
      
      Track track0 = new Track(17.7, entry0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(1, simpleEntryGroup0.size());
      assertFalse(entry0.isReadOnly());
      assertFalse(track0.isNotQualifier());
      assertTrue(track0.isShowForward());
      assertEquals(17.7, track0.getPosition(), 0.01);
      assertNull(track0.getKeyStr());
      assertTrue(track0.isShowReverse());
      assertNull(track0.getQualifierValue());
      assertFalse(track0.isAny());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertNull(track0.getQualifier());
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertNotNull(track0);
      
      Stack<String> stack0 = new Stack<String>();
      assertEquals(0, stack0.size());
      assertTrue(stack0.empty());
      assertTrue(stack0.isEmpty());
      assertEquals("[]", stack0.toString());
      assertEquals(10, stack0.capacity());
      assertFalse(stack0.contains("XhAqG GKSq/^0iNS}U"));
      assertNotNull(stack0);
      
      DNADraw dNADraw0 = new DNADraw(stack0, stack0, stack0, stack0);
      assertEquals(0, stack0.size());
      assertTrue(stack0.empty());
      assertTrue(stack0.isEmpty());
      assertEquals("[]", stack0.toString());
      assertEquals(10, stack0.capacity());
      assertEquals(200.0F, dNADraw0.getLineHeight(), 0.01F);
      assertEquals(0.0F, dNADraw0.getSingleBaseWidth(), 0.01F);
      assertFalse(dNADraw0.isFocusCycleRoot());
      assertFalse(dNADraw0.isFocusTraversalPolicySet());
      assertFalse(dNADraw0.isFocusTraversalPolicyProvider());
      assertEquals(0, dNADraw0.getNumberOfLines());
      assertTrue(dNADraw0.getFocusTraversalKeysEnabled());
      assertFalse(dNADraw0.getScrollableTracksViewportWidth());
      assertEquals(0, dNADraw0.getBorderWidth2());
      assertFalse(dNADraw0.getIgnoreRepaint());
      assertEquals(20000, dNADraw0.getBasesPerLine());
      assertEquals(0, dNADraw0.getBorderHeight2());
      assertFalse(dNADraw0.getScrollableTracksViewportHeight());
      assertFalse(stack0.contains("XhAqG GKSq/^0iNS}U"));
      assertNotNull(dNADraw0);
      
      Block block0 = new Block("iO(W", 65, 0, color0, (-4620), track0, dNADraw0);
      assertEquals(64, color0.getBlue());
      assertEquals(1, color0.getTransparency());
      assertEquals(64, color0.getGreen());
      assertEquals(255, color0.getAlpha());
      assertEquals(64, color0.getRed());
      assertEquals((-12566464), color0.getRGB());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(1, simpleEntryGroup0.size());
      assertFalse(entry0.isReadOnly());
      assertFalse(track0.isNotQualifier());
      assertTrue(track0.isShowForward());
      assertEquals(17.7, track0.getPosition(), 0.01);
      assertNull(track0.getKeyStr());
      assertTrue(track0.isShowReverse());
      assertNull(track0.getQualifierValue());
      assertFalse(track0.isAny());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertNull(track0.getQualifier());
      assertEquals(0, stack0.size());
      assertTrue(stack0.empty());
      assertTrue(stack0.isEmpty());
      assertEquals("[]", stack0.toString());
      assertEquals(10, stack0.capacity());
      assertEquals(200.0F, dNADraw0.getLineHeight(), 0.01F);
      assertEquals(0.0F, dNADraw0.getSingleBaseWidth(), 0.01F);
      assertFalse(dNADraw0.isFocusCycleRoot());
      assertFalse(dNADraw0.isFocusTraversalPolicySet());
      assertFalse(dNADraw0.isFocusTraversalPolicyProvider());
      assertEquals(0, dNADraw0.getNumberOfLines());
      assertTrue(dNADraw0.getFocusTraversalKeysEnabled());
      assertFalse(dNADraw0.getScrollableTracksViewportWidth());
      assertEquals(0, dNADraw0.getBorderWidth2());
      assertFalse(dNADraw0.getIgnoreRepaint());
      assertEquals(20000, dNADraw0.getBasesPerLine());
      assertEquals(0, dNADraw0.getBorderHeight2());
      assertFalse(dNADraw0.getScrollableTracksViewportHeight());
      assertEquals(65, block0.getBstart());
      assertEquals((-4620.0F), block0.getStrokeSize(), 0.01F);
      assertEquals(0.0, block0.getAngStart(), 0.01);
      assertEquals(0.0, block0.getAngEnd(), 0.01);
      assertEquals(0, block0.getBend());
      assertFalse(block0.isDrawLabel());
      assertFalse(block0.isArrowHead());
      assertEquals("iO(W", block0.getLabel());
      assertFalse(block0.isArrowTail());
      assertFalse(stack0.contains("iO(W"));
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertNotNull(block0);
      
      int int0 = block0.getBend();
      assertEquals(64, color0.getBlue());
      assertEquals(1, color0.getTransparency());
      assertEquals(64, color0.getGreen());
      assertEquals(255, color0.getAlpha());
      assertEquals(64, color0.getRed());
      assertEquals((-12566464), color0.getRGB());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(1, simpleEntryGroup0.size());
      assertFalse(entry0.isReadOnly());
      assertFalse(track0.isNotQualifier());
      assertTrue(track0.isShowForward());
      assertEquals(17.7, track0.getPosition(), 0.01);
      assertNull(track0.getKeyStr());
      assertTrue(track0.isShowReverse());
      assertNull(track0.getQualifierValue());
      assertFalse(track0.isAny());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertNull(track0.getQualifier());
      assertEquals(0, stack0.size());
      assertTrue(stack0.empty());
      assertTrue(stack0.isEmpty());
      assertEquals("[]", stack0.toString());
      assertEquals(10, stack0.capacity());
      assertEquals(200.0F, dNADraw0.getLineHeight(), 0.01F);
      assertEquals(0.0F, dNADraw0.getSingleBaseWidth(), 0.01F);
      assertFalse(dNADraw0.isFocusCycleRoot());
      assertFalse(dNADraw0.isFocusTraversalPolicySet());
      assertFalse(dNADraw0.isFocusTraversalPolicyProvider());
      assertEquals(0, dNADraw0.getNumberOfLines());
      assertTrue(dNADraw0.getFocusTraversalKeysEnabled());
      assertFalse(dNADraw0.getScrollableTracksViewportWidth());
      assertEquals(0, dNADraw0.getBorderWidth2());
      assertFalse(dNADraw0.getIgnoreRepaint());
      assertEquals(20000, dNADraw0.getBasesPerLine());
      assertEquals(0, dNADraw0.getBorderHeight2());
      assertFalse(dNADraw0.getScrollableTracksViewportHeight());
      assertEquals(65, block0.getBstart());
      assertEquals((-4620.0F), block0.getStrokeSize(), 0.01F);
      assertEquals(0.0, block0.getAngStart(), 0.01);
      assertEquals(0.0, block0.getAngEnd(), 0.01);
      assertEquals(0, block0.getBend());
      assertFalse(block0.isDrawLabel());
      assertFalse(block0.isArrowHead());
      assertEquals("iO(W", block0.getLabel());
      assertFalse(block0.isArrowTail());
      assertFalse(stack0.contains("iO(W"));
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, int0);
  }

  @Test(timeout = 4000)
  public void test24()  throws Throwable  {
      Color color0 = Color.lightGray;
      assertEquals(1, color0.getTransparency());
      assertEquals(192, color0.getRed());
      assertEquals(192, color0.getBlue());
      assertEquals(255, color0.getAlpha());
      assertEquals((-4144960), color0.getRGB());
      assertEquals(192, color0.getGreen());
      assertNotNull(color0);
      
      Track track0 = new Track(1.0, (Entry) null);
      assertTrue(track0.isShowReverse());
      assertNull(track0.getQualifier());
      assertNull(track0.getQualifierValue());
      assertFalse(track0.isAny());
      assertEquals(1.0, track0.getPosition(), 0.01);
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertNull(track0.getKeyStr());
      assertTrue(track0.isShowForward());
      assertFalse(track0.isNotQualifier());
      assertNotNull(track0);
      
      Vector<String> vector0 = new Vector<String>();
      assertTrue(vector0.isEmpty());
      assertEquals(0, vector0.size());
      assertEquals("[]", vector0.toString());
      assertEquals(10, vector0.capacity());
      assertNotNull(vector0);
      
      DNADraw dNADraw0 = new DNADraw(vector0, vector0, vector0, vector0);
      assertTrue(vector0.isEmpty());
      assertEquals(0, vector0.size());
      assertEquals("[]", vector0.toString());
      assertEquals(10, vector0.capacity());
      assertFalse(dNADraw0.isFocusTraversalPolicyProvider());
      assertFalse(dNADraw0.getIgnoreRepaint());
      assertEquals(20000, dNADraw0.getBasesPerLine());
      assertEquals(0, dNADraw0.getNumberOfLines());
      assertFalse(dNADraw0.isFocusTraversalPolicySet());
      assertFalse(dNADraw0.isFocusCycleRoot());
      assertEquals(0, dNADraw0.getBorderHeight2());
      assertEquals(200.0F, dNADraw0.getLineHeight(), 0.01F);
      assertEquals(0.0F, dNADraw0.getSingleBaseWidth(), 0.01F);
      assertFalse(dNADraw0.getScrollableTracksViewportWidth());
      assertTrue(dNADraw0.getFocusTraversalKeysEnabled());
      assertFalse(dNADraw0.getScrollableTracksViewportHeight());
      assertEquals(0, dNADraw0.getBorderWidth2());
      assertNotNull(dNADraw0);
      
      Block block0 = new Block("fm3", (-535), 279, color0, 279, track0, dNADraw0);
      assertEquals(1, color0.getTransparency());
      assertEquals(192, color0.getRed());
      assertEquals(192, color0.getBlue());
      assertEquals(255, color0.getAlpha());
      assertEquals((-4144960), color0.getRGB());
      assertEquals(192, color0.getGreen());
      assertTrue(track0.isShowReverse());
      assertNull(track0.getQualifier());
      assertNull(track0.getQualifierValue());
      assertFalse(track0.isAny());
      assertEquals(1.0, track0.getPosition(), 0.01);
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertNull(track0.getKeyStr());
      assertTrue(track0.isShowForward());
      assertFalse(track0.isNotQualifier());
      assertTrue(vector0.isEmpty());
      assertEquals(0, vector0.size());
      assertEquals("[]", vector0.toString());
      assertEquals(10, vector0.capacity());
      assertFalse(dNADraw0.isFocusTraversalPolicyProvider());
      assertFalse(dNADraw0.getIgnoreRepaint());
      assertEquals(20000, dNADraw0.getBasesPerLine());
      assertEquals(0, dNADraw0.getNumberOfLines());
      assertFalse(dNADraw0.isFocusTraversalPolicySet());
      assertFalse(dNADraw0.isFocusCycleRoot());
      assertEquals(0, dNADraw0.getBorderHeight2());
      assertEquals(200.0F, dNADraw0.getLineHeight(), 0.01F);
      assertEquals(0.0F, dNADraw0.getSingleBaseWidth(), 0.01F);
      assertFalse(dNADraw0.getScrollableTracksViewportWidth());
      assertTrue(dNADraw0.getFocusTraversalKeysEnabled());
      assertFalse(dNADraw0.getScrollableTracksViewportHeight());
      assertEquals(0, dNADraw0.getBorderWidth2());
      assertFalse(block0.isArrowTail());
      assertEquals("fm3", block0.getLabel());
      assertEquals(0.0, block0.getAngStart(), 0.01);
      assertFalse(block0.isDrawLabel());
      assertFalse(block0.isArrowHead());
      assertEquals(279, block0.getBend());
      assertEquals(0.0, block0.getAngEnd(), 0.01);
      assertEquals(279.0F, block0.getStrokeSize(), 0.01F);
      assertEquals((-535), block0.getBstart());
      assertFalse(vector0.contains("fm3"));
      assertNotNull(block0);
      
      int int0 = block0.getBstart();
      assertEquals(1, color0.getTransparency());
      assertEquals(192, color0.getRed());
      assertEquals(192, color0.getBlue());
      assertEquals(255, color0.getAlpha());
      assertEquals((-4144960), color0.getRGB());
      assertEquals(192, color0.getGreen());
      assertTrue(track0.isShowReverse());
      assertNull(track0.getQualifier());
      assertNull(track0.getQualifierValue());
      assertFalse(track0.isAny());
      assertEquals(1.0, track0.getPosition(), 0.01);
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertNull(track0.getKeyStr());
      assertTrue(track0.isShowForward());
      assertFalse(track0.isNotQualifier());
      assertTrue(vector0.isEmpty());
      assertEquals(0, vector0.size());
      assertEquals("[]", vector0.toString());
      assertEquals(10, vector0.capacity());
      assertFalse(dNADraw0.isFocusTraversalPolicyProvider());
      assertFalse(dNADraw0.getIgnoreRepaint());
      assertEquals(20000, dNADraw0.getBasesPerLine());
      assertEquals(0, dNADraw0.getNumberOfLines());
      assertFalse(dNADraw0.isFocusTraversalPolicySet());
      assertFalse(dNADraw0.isFocusCycleRoot());
      assertEquals(0, dNADraw0.getBorderHeight2());
      assertEquals(200.0F, dNADraw0.getLineHeight(), 0.01F);
      assertEquals(0.0F, dNADraw0.getSingleBaseWidth(), 0.01F);
      assertFalse(dNADraw0.getScrollableTracksViewportWidth());
      assertTrue(dNADraw0.getFocusTraversalKeysEnabled());
      assertFalse(dNADraw0.getScrollableTracksViewportHeight());
      assertEquals(0, dNADraw0.getBorderWidth2());
      assertFalse(block0.isArrowTail());
      assertEquals("fm3", block0.getLabel());
      assertEquals(0.0, block0.getAngStart(), 0.01);
      assertFalse(block0.isDrawLabel());
      assertFalse(block0.isArrowHead());
      assertEquals(279, block0.getBend());
      assertEquals(0.0, block0.getAngEnd(), 0.01);
      assertEquals(279.0F, block0.getStrokeSize(), 0.01F);
      assertEquals((-535), block0.getBstart());
      assertFalse(vector0.contains("fm3"));
      assertEquals((-535), int0);
  }

  @Test(timeout = 4000)
  public void test25()  throws Throwable  {
      Color color0 = Color.GREEN;
      assertEquals(0, color0.getRed());
      assertEquals(1, color0.getTransparency());
      assertEquals((-16711936), color0.getRGB());
      assertEquals(255, color0.getGreen());
      assertEquals(0, color0.getBlue());
      assertEquals(255, color0.getAlpha());
      assertNotNull(color0);
      
      Track track0 = new Track(0.0, (Entry) null);
      assertEquals(0.0, track0.getPosition(), 0.01);
      assertFalse(track0.isAny());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertNull(track0.getQualifier());
      assertNull(track0.getKeyStr());
      assertTrue(track0.isShowReverse());
      assertFalse(track0.isNotQualifier());
      assertTrue(track0.isShowForward());
      assertNull(track0.getQualifierValue());
      assertNotNull(track0);
      
      DNADraw dNADraw0 = new DNADraw();
      assertFalse(dNADraw0.isFocusCycleRoot());
      assertEquals(0, dNADraw0.getBorderHeight2());
      assertFalse(dNADraw0.isFocusTraversalPolicySet());
      assertEquals(200.0F, dNADraw0.getLineHeight(), 0.01F);
      assertEquals(0, dNADraw0.getBorderWidth2());
      assertFalse(dNADraw0.getIgnoreRepaint());
      assertEquals(0.0F, dNADraw0.getSingleBaseWidth(), 0.01F);
      assertEquals(0, dNADraw0.getNumberOfLines());
      assertFalse(dNADraw0.getScrollableTracksViewportWidth());
      assertFalse(dNADraw0.isFocusTraversalPolicyProvider());
      assertFalse(dNADraw0.getScrollableTracksViewportHeight());
      assertTrue(dNADraw0.getFocusTraversalKeysEnabled());
      assertEquals(20000, dNADraw0.getBasesPerLine());
      assertNotNull(dNADraw0);
      
      Block block0 = new Block(" Label", 554, 561, color0, 0.0F, track0, dNADraw0);
      assertEquals(0, color0.getRed());
      assertEquals(1, color0.getTransparency());
      assertEquals((-16711936), color0.getRGB());
      assertEquals(255, color0.getGreen());
      assertEquals(0, color0.getBlue());
      assertEquals(255, color0.getAlpha());
      assertEquals(0.0, track0.getPosition(), 0.01);
      assertFalse(track0.isAny());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertNull(track0.getQualifier());
      assertNull(track0.getKeyStr());
      assertTrue(track0.isShowReverse());
      assertFalse(track0.isNotQualifier());
      assertTrue(track0.isShowForward());
      assertNull(track0.getQualifierValue());
      assertFalse(dNADraw0.isFocusCycleRoot());
      assertEquals(0, dNADraw0.getBorderHeight2());
      assertFalse(dNADraw0.isFocusTraversalPolicySet());
      assertEquals(200.0F, dNADraw0.getLineHeight(), 0.01F);
      assertEquals(0, dNADraw0.getBorderWidth2());
      assertFalse(dNADraw0.getIgnoreRepaint());
      assertEquals(0.0F, dNADraw0.getSingleBaseWidth(), 0.01F);
      assertEquals(0, dNADraw0.getNumberOfLines());
      assertFalse(dNADraw0.getScrollableTracksViewportWidth());
      assertFalse(dNADraw0.isFocusTraversalPolicyProvider());
      assertFalse(dNADraw0.getScrollableTracksViewportHeight());
      assertTrue(dNADraw0.getFocusTraversalKeysEnabled());
      assertEquals(20000, dNADraw0.getBasesPerLine());
      assertFalse(block0.isDrawLabel());
      assertEquals(561, block0.getBend());
      assertFalse(block0.isArrowHead());
      assertEquals(554, block0.getBstart());
      assertFalse(block0.isArrowTail());
      assertEquals(0.0, block0.getAngEnd(), 0.01);
      assertEquals(0.0, block0.getAngStart(), 0.01);
      assertEquals(" Label", block0.getLabel());
      assertEquals(0.0F, block0.getStrokeSize(), 0.01F);
      assertNotNull(block0);
      
      Track track1 = block0.getTrack();
      assertEquals(0, color0.getRed());
      assertEquals(1, color0.getTransparency());
      assertEquals((-16711936), color0.getRGB());
      assertEquals(255, color0.getGreen());
      assertEquals(0, color0.getBlue());
      assertEquals(255, color0.getAlpha());
      assertEquals(0.0, track0.getPosition(), 0.01);
      assertFalse(track0.isAny());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertNull(track0.getQualifier());
      assertNull(track0.getKeyStr());
      assertTrue(track0.isShowReverse());
      assertFalse(track0.isNotQualifier());
      assertTrue(track0.isShowForward());
      assertNull(track0.getQualifierValue());
      assertFalse(dNADraw0.isFocusCycleRoot());
      assertEquals(0, dNADraw0.getBorderHeight2());
      assertFalse(dNADraw0.isFocusTraversalPolicySet());
      assertEquals(200.0F, dNADraw0.getLineHeight(), 0.01F);
      assertEquals(0, dNADraw0.getBorderWidth2());
      assertFalse(dNADraw0.getIgnoreRepaint());
      assertEquals(0.0F, dNADraw0.getSingleBaseWidth(), 0.01F);
      assertEquals(0, dNADraw0.getNumberOfLines());
      assertFalse(dNADraw0.getScrollableTracksViewportWidth());
      assertFalse(dNADraw0.isFocusTraversalPolicyProvider());
      assertFalse(dNADraw0.getScrollableTracksViewportHeight());
      assertTrue(dNADraw0.getFocusTraversalKeysEnabled());
      assertEquals(20000, dNADraw0.getBasesPerLine());
      assertFalse(block0.isDrawLabel());
      assertEquals(561, block0.getBend());
      assertFalse(block0.isArrowHead());
      assertEquals(554, block0.getBstart());
      assertFalse(block0.isArrowTail());
      assertEquals(0.0, block0.getAngEnd(), 0.01);
      assertEquals(0.0, block0.getAngStart(), 0.01);
      assertEquals(" Label", block0.getLabel());
      assertEquals(0.0F, block0.getStrokeSize(), 0.01F);
      assertNull(track1.getKeyStr());
      assertNull(track1.getQualifierValue());
      assertTrue(track1.isShowReverse());
      assertFalse(track1.isNotQualifier());
      assertTrue(track1.isShowForward());
      assertEquals(10.0F, track1.getSize(), 0.01F);
      assertEquals(0.0, track1.getPosition(), 0.01);
      assertFalse(track1.isAny());
      assertNull(track1.getQualifier());
      assertSame(track0, track1);
      assertSame(track1, track0);
      assertNotNull(track1);
  }

  @Test(timeout = 4000)
  public void test26()  throws Throwable  {
      Block block0 = new Block("q|;=.7", 131336, 131336, (Color) null, 25.0F, (Track) null);
      assertEquals(0.0, block0.getAngStart(), 0.01);
      assertEquals("q|;=.7", block0.getLabel());
      assertEquals(0.0, block0.getAngEnd(), 0.01);
      assertEquals(131336, block0.getBstart());
      assertFalse(block0.isArrowTail());
      assertEquals(25.0F, block0.getStrokeSize(), 0.01F);
      assertEquals(131336, block0.getBend());
      assertFalse(block0.isDrawLabel());
      assertFalse(block0.isArrowHead());
      assertNotNull(block0);
      
      double double0 = block0.getAngStart();
      assertEquals(0.0, block0.getAngStart(), 0.01);
      assertEquals("q|;=.7", block0.getLabel());
      assertEquals(0.0, block0.getAngEnd(), 0.01);
      assertEquals(131336, block0.getBstart());
      assertFalse(block0.isArrowTail());
      assertEquals(25.0F, block0.getStrokeSize(), 0.01F);
      assertEquals(131336, block0.getBend());
      assertFalse(block0.isDrawLabel());
      assertFalse(block0.isArrowHead());
      assertEquals(0.0, double0, 0.01);
  }

  @Test(timeout = 4000)
  public void test27()  throws Throwable  {
      Track track0 = new Track((-850), (Entry) null);
      assertNull(track0.getQualifierValue());
      assertNull(track0.getQualifier());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertFalse(track0.isAny());
      assertEquals((-850.0), track0.getPosition(), 0.01);
      assertFalse(track0.isNotQualifier());
      assertTrue(track0.isShowForward());
      assertTrue(track0.isShowReverse());
      assertNull(track0.getKeyStr());
      assertNotNull(track0);
      
      Block block0 = new Block("", (-850), (-850), (Color) null, (-850), track0);
      assertNull(track0.getQualifierValue());
      assertNull(track0.getQualifier());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertFalse(track0.isAny());
      assertEquals((-850.0), track0.getPosition(), 0.01);
      assertFalse(track0.isNotQualifier());
      assertTrue(track0.isShowForward());
      assertTrue(track0.isShowReverse());
      assertNull(track0.getKeyStr());
      assertEquals((-850.0F), block0.getStrokeSize(), 0.01F);
      assertEquals(0.0, block0.getAngStart(), 0.01);
      assertEquals((-850), block0.getBstart());
      assertFalse(block0.isArrowHead());
      assertFalse(block0.isDrawLabel());
      assertFalse(block0.isArrowTail());
      assertEquals(0.0, block0.getAngEnd(), 0.01);
      assertEquals((-850), block0.getBend());
      assertEquals("", block0.getLabel());
      assertNotNull(block0);
      
      float float0 = block0.getStrokeSize();
      assertNull(track0.getQualifierValue());
      assertNull(track0.getQualifier());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertFalse(track0.isAny());
      assertEquals((-850.0), track0.getPosition(), 0.01);
      assertFalse(track0.isNotQualifier());
      assertTrue(track0.isShowForward());
      assertTrue(track0.isShowReverse());
      assertNull(track0.getKeyStr());
      assertEquals((-850.0F), block0.getStrokeSize(), 0.01F);
      assertEquals(0.0, block0.getAngStart(), 0.01);
      assertEquals((-850), block0.getBstart());
      assertFalse(block0.isArrowHead());
      assertFalse(block0.isDrawLabel());
      assertFalse(block0.isArrowTail());
      assertEquals(0.0, block0.getAngEnd(), 0.01);
      assertEquals((-850), block0.getBend());
      assertEquals("", block0.getLabel());
      assertEquals((-850.0F), float0, 0.01F);
  }

  @Test(timeout = 4000)
  public void test28()  throws Throwable  {
      Track track0 = new Track((-850), (Entry) null);
      assertEquals((-850.0), track0.getPosition(), 0.01);
      assertFalse(track0.isNotQualifier());
      assertNull(track0.getQualifierValue());
      assertNull(track0.getKeyStr());
      assertNull(track0.getQualifier());
      assertTrue(track0.isShowReverse());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertFalse(track0.isAny());
      assertTrue(track0.isShowForward());
      assertNotNull(track0);
      
      Block block0 = new Block("", (-850), (-850), (Color) null, (-850), track0);
      assertEquals((-850.0), track0.getPosition(), 0.01);
      assertFalse(track0.isNotQualifier());
      assertNull(track0.getQualifierValue());
      assertNull(track0.getKeyStr());
      assertNull(track0.getQualifier());
      assertTrue(track0.isShowReverse());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertFalse(track0.isAny());
      assertTrue(track0.isShowForward());
      assertFalse(block0.isDrawLabel());
      assertEquals("", block0.getLabel());
      assertFalse(block0.isArrowTail());
      assertEquals(0.0, block0.getAngEnd(), 0.01);
      assertFalse(block0.isArrowHead());
      assertEquals((-850), block0.getBend());
      assertEquals(0.0, block0.getAngStart(), 0.01);
      assertEquals((-850.0F), block0.getStrokeSize(), 0.01F);
      assertEquals((-850), block0.getBstart());
      assertNotNull(block0);
      
      Block block1 = (Block)block0.getTransferData(block0.BLOCK);
      assertEquals((-850.0), track0.getPosition(), 0.01);
      assertFalse(track0.isNotQualifier());
      assertNull(track0.getQualifierValue());
      assertNull(track0.getKeyStr());
      assertNull(track0.getQualifier());
      assertTrue(track0.isShowReverse());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertFalse(track0.isAny());
      assertTrue(track0.isShowForward());
      assertFalse(block0.isDrawLabel());
      assertEquals("", block0.getLabel());
      assertFalse(block0.isArrowTail());
      assertEquals(0.0, block0.getAngEnd(), 0.01);
      assertFalse(block0.isArrowHead());
      assertEquals((-850), block0.getBend());
      assertEquals(0.0, block0.getAngStart(), 0.01);
      assertEquals((-850.0F), block0.getStrokeSize(), 0.01F);
      assertEquals((-850), block0.getBstart());
      assertFalse(block1.isArrowHead());
      assertFalse(block1.isDrawLabel());
      assertEquals("", block1.getLabel());
      assertEquals((-850), block1.getBend());
      assertEquals((-850), block1.getBstart());
      assertFalse(block1.isArrowTail());
      assertEquals((-850.0F), block1.getStrokeSize(), 0.01F);
      assertEquals(0.0, block1.getAngStart(), 0.01);
      assertEquals(0.0, block1.getAngEnd(), 0.01);
      assertSame(block0, block1);
      assertSame(block1, block0);
      assertNotNull(block1);
  }

  @Test(timeout = 4000)
  public void test29()  throws Throwable  {
      DNADraw dNADraw0 = new DNADraw();
      assertFalse(dNADraw0.getScrollableTracksViewportWidth());
      assertEquals(0, dNADraw0.getBorderWidth2());
      assertFalse(dNADraw0.getIgnoreRepaint());
      assertEquals(20000, dNADraw0.getBasesPerLine());
      assertEquals(0, dNADraw0.getBorderHeight2());
      assertFalse(dNADraw0.isFocusCycleRoot());
      assertEquals(200.0F, dNADraw0.getLineHeight(), 0.01F);
      assertFalse(dNADraw0.getScrollableTracksViewportHeight());
      assertEquals(0.0F, dNADraw0.getSingleBaseWidth(), 0.01F);
      assertTrue(dNADraw0.getFocusTraversalKeysEnabled());
      assertEquals(0, dNADraw0.getNumberOfLines());
      assertFalse(dNADraw0.isFocusTraversalPolicyProvider());
      assertFalse(dNADraw0.isFocusTraversalPolicySet());
      assertNotNull(dNADraw0);
      
      Block block0 = new Block("*_9F>-`ts6^\"$bYp)", 0, 0, (Color) null, 0, (Track) null, dNADraw0);
      assertFalse(dNADraw0.getScrollableTracksViewportWidth());
      assertEquals(0, dNADraw0.getBorderWidth2());
      assertFalse(dNADraw0.getIgnoreRepaint());
      assertEquals(20000, dNADraw0.getBasesPerLine());
      assertEquals(0, dNADraw0.getBorderHeight2());
      assertFalse(dNADraw0.isFocusCycleRoot());
      assertEquals(200.0F, dNADraw0.getLineHeight(), 0.01F);
      assertFalse(dNADraw0.getScrollableTracksViewportHeight());
      assertEquals(0.0F, dNADraw0.getSingleBaseWidth(), 0.01F);
      assertTrue(dNADraw0.getFocusTraversalKeysEnabled());
      assertEquals(0, dNADraw0.getNumberOfLines());
      assertFalse(dNADraw0.isFocusTraversalPolicyProvider());
      assertFalse(dNADraw0.isFocusTraversalPolicySet());
      assertFalse(block0.isArrowHead());
      assertEquals(0, block0.getBend());
      assertEquals(0.0, block0.getAngEnd(), 0.01);
      assertEquals(0.0F, block0.getStrokeSize(), 0.01F);
      assertEquals(0.0, block0.getAngStart(), 0.01);
      assertEquals(0, block0.getBstart());
      assertFalse(block0.isDrawLabel());
      assertEquals("*_9F>-`ts6^\"$bYp)", block0.getLabel());
      assertFalse(block0.isArrowTail());
      assertNotNull(block0);
      
      DataFlavor dataFlavor0 = DataFlavor.getTextPlainUnicodeFlavor();
      assertEquals("plain", dataFlavor0.getSubType());
      assertFalse(dataFlavor0.isRepresentationClassCharBuffer());
      assertEquals("Plain Text", dataFlavor0.getHumanPresentableName());
      assertFalse(dataFlavor0.isRepresentationClassReader());
      assertFalse(dataFlavor0.isRepresentationClassRemote());
      assertEquals("text", dataFlavor0.getPrimaryType());
      assertFalse(dataFlavor0.isRepresentationClassByteBuffer());
      assertFalse(dataFlavor0.isRepresentationClassSerializable());
      assertFalse(dataFlavor0.isFlavorJavaFileListType());
      assertTrue(dataFlavor0.isRepresentationClassInputStream());
      assertNotNull(dataFlavor0);
      
      try { 
        block0.getTransferData(dataFlavor0);
        fail("Expecting exception: UnsupportedFlavorException");
      
      } catch(UnsupportedFlavorException e) {
         //
         // Plain Text
         //
         verifyException("uk.ac.sanger.artemis.circular.Block", e);
      }
  }

  @Test(timeout = 4000)
  public void test30()  throws Throwable  {
      Color color0 = Color.magenta;
      assertEquals(255, color0.getBlue());
      assertEquals(255, color0.getRed());
      assertEquals(0, color0.getGreen());
      assertEquals((-65281), color0.getRGB());
      assertEquals(255, color0.getAlpha());
      assertEquals(1, color0.getTransparency());
      assertNotNull(color0);
      
      Block block0 = new Block("~iW34pv.4 ?DV8~@{RC", 128, 128, color0, 128, (Track) null);
      assertEquals(255, color0.getBlue());
      assertEquals(255, color0.getRed());
      assertEquals(0, color0.getGreen());
      assertEquals((-65281), color0.getRGB());
      assertEquals(255, color0.getAlpha());
      assertEquals(1, color0.getTransparency());
      assertEquals(128.0F, block0.getStrokeSize(), 0.01F);
      assertFalse(block0.isDrawLabel());
      assertFalse(block0.isArrowTail());
      assertEquals(0.0, block0.getAngStart(), 0.01);
      assertEquals(128, block0.getBstart());
      assertFalse(block0.isArrowHead());
      assertEquals(128, block0.getBend());
      assertEquals(0.0, block0.getAngEnd(), 0.01);
      assertEquals("~iW34pv.4 ?DV8~@{RC", block0.getLabel());
      assertNotNull(block0);
      
      boolean boolean0 = block0.isDataFlavorSupported(block0.BLOCK);
      assertEquals(255, color0.getBlue());
      assertEquals(255, color0.getRed());
      assertEquals(0, color0.getGreen());
      assertEquals((-65281), color0.getRGB());
      assertEquals(255, color0.getAlpha());
      assertEquals(1, color0.getTransparency());
      assertEquals(128.0F, block0.getStrokeSize(), 0.01F);
      assertFalse(block0.isDrawLabel());
      assertFalse(block0.isArrowTail());
      assertEquals(0.0, block0.getAngStart(), 0.01);
      assertEquals(128, block0.getBstart());
      assertFalse(block0.isArrowHead());
      assertEquals(128, block0.getBend());
      assertEquals(0.0, block0.getAngEnd(), 0.01);
      assertEquals("~iW34pv.4 ?DV8~@{RC", block0.getLabel());
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test31()  throws Throwable  {
      DNADraw dNADraw0 = new DNADraw();
      assertEquals(0, dNADraw0.getNumberOfLines());
      assertFalse(dNADraw0.getScrollableTracksViewportHeight());
      assertTrue(dNADraw0.getFocusTraversalKeysEnabled());
      assertEquals(0.0F, dNADraw0.getSingleBaseWidth(), 0.01F);
      assertEquals(200.0F, dNADraw0.getLineHeight(), 0.01F);
      assertFalse(dNADraw0.getScrollableTracksViewportWidth());
      assertFalse(dNADraw0.isFocusCycleRoot());
      assertFalse(dNADraw0.isFocusTraversalPolicyProvider());
      assertEquals(0, dNADraw0.getBorderWidth2());
      assertFalse(dNADraw0.getIgnoreRepaint());
      assertFalse(dNADraw0.isFocusTraversalPolicySet());
      assertEquals(20000, dNADraw0.getBasesPerLine());
      assertEquals(0, dNADraw0.getBorderHeight2());
      assertNotNull(dNADraw0);
      
      Block block0 = new Block("*_9F>-`ts6^\"$bYp)", 0, 0, (Color) null, 0, (Track) null, dNADraw0);
      assertEquals(0, dNADraw0.getNumberOfLines());
      assertFalse(dNADraw0.getScrollableTracksViewportHeight());
      assertTrue(dNADraw0.getFocusTraversalKeysEnabled());
      assertEquals(0.0F, dNADraw0.getSingleBaseWidth(), 0.01F);
      assertEquals(200.0F, dNADraw0.getLineHeight(), 0.01F);
      assertFalse(dNADraw0.getScrollableTracksViewportWidth());
      assertFalse(dNADraw0.isFocusCycleRoot());
      assertFalse(dNADraw0.isFocusTraversalPolicyProvider());
      assertEquals(0, dNADraw0.getBorderWidth2());
      assertFalse(dNADraw0.getIgnoreRepaint());
      assertFalse(dNADraw0.isFocusTraversalPolicySet());
      assertEquals(20000, dNADraw0.getBasesPerLine());
      assertEquals(0, dNADraw0.getBorderHeight2());
      assertEquals("*_9F>-`ts6^\"$bYp)", block0.getLabel());
      assertFalse(block0.isArrowHead());
      assertEquals(0, block0.getBend());
      assertFalse(block0.isArrowTail());
      assertEquals(0.0, block0.getAngEnd(), 0.01);
      assertFalse(block0.isDrawLabel());
      assertEquals(0.0, block0.getAngStart(), 0.01);
      assertEquals(0, block0.getBstart());
      assertEquals(0.0F, block0.getStrokeSize(), 0.01F);
      assertNotNull(block0);
      
      DataFlavor dataFlavor0 = DataFlavor.getTextPlainUnicodeFlavor();
      assertEquals("plain", dataFlavor0.getSubType());
      assertEquals("Plain Text", dataFlavor0.getHumanPresentableName());
      assertFalse(dataFlavor0.isRepresentationClassReader());
      assertFalse(dataFlavor0.isRepresentationClassRemote());
      assertFalse(dataFlavor0.isRepresentationClassByteBuffer());
      assertFalse(dataFlavor0.isFlavorJavaFileListType());
      assertFalse(dataFlavor0.isRepresentationClassCharBuffer());
      assertFalse(dataFlavor0.isRepresentationClassSerializable());
      assertEquals("text", dataFlavor0.getPrimaryType());
      assertNotNull(dataFlavor0);
      
      boolean boolean0 = block0.isDataFlavorSupported(dataFlavor0);
      assertEquals(0, dNADraw0.getNumberOfLines());
      assertFalse(dNADraw0.getScrollableTracksViewportHeight());
      assertTrue(dNADraw0.getFocusTraversalKeysEnabled());
      assertEquals(0.0F, dNADraw0.getSingleBaseWidth(), 0.01F);
      assertEquals(200.0F, dNADraw0.getLineHeight(), 0.01F);
      assertFalse(dNADraw0.getScrollableTracksViewportWidth());
      assertFalse(dNADraw0.isFocusCycleRoot());
      assertFalse(dNADraw0.isFocusTraversalPolicyProvider());
      assertEquals(0, dNADraw0.getBorderWidth2());
      assertFalse(dNADraw0.getIgnoreRepaint());
      assertFalse(dNADraw0.isFocusTraversalPolicySet());
      assertEquals(20000, dNADraw0.getBasesPerLine());
      assertEquals(0, dNADraw0.getBorderHeight2());
      assertEquals("*_9F>-`ts6^\"$bYp)", block0.getLabel());
      assertFalse(block0.isArrowHead());
      assertEquals(0, block0.getBend());
      assertFalse(block0.isArrowTail());
      assertEquals(0.0, block0.getAngEnd(), 0.01);
      assertFalse(block0.isDrawLabel());
      assertEquals(0.0, block0.getAngStart(), 0.01);
      assertEquals(0, block0.getBstart());
      assertEquals(0.0F, block0.getStrokeSize(), 0.01F);
      assertEquals("plain", dataFlavor0.getSubType());
      assertEquals("Plain Text", dataFlavor0.getHumanPresentableName());
      assertFalse(dataFlavor0.isRepresentationClassReader());
      assertFalse(dataFlavor0.isRepresentationClassRemote());
      assertFalse(dataFlavor0.isRepresentationClassByteBuffer());
      assertFalse(dataFlavor0.isFlavorJavaFileListType());
      assertTrue(dataFlavor0.isRepresentationClassInputStream());
      assertFalse(dataFlavor0.isRepresentationClassCharBuffer());
      assertFalse(dataFlavor0.isRepresentationClassSerializable());
      assertEquals("text", dataFlavor0.getPrimaryType());
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test32()  throws Throwable  {
      Color color0 = Color.lightGray;
      assertEquals(255, color0.getAlpha());
      assertEquals(1, color0.getTransparency());
      assertEquals(192, color0.getGreen());
      assertEquals(192, color0.getBlue());
      assertEquals(192, color0.getRed());
      assertEquals((-4144960), color0.getRGB());
      assertNotNull(color0);
      
      Track track0 = new Track(1.0, (Entry) null);
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertTrue(track0.isShowForward());
      assertFalse(track0.isNotQualifier());
      assertTrue(track0.isShowReverse());
      assertNull(track0.getQualifierValue());
      assertNull(track0.getKeyStr());
      assertNull(track0.getQualifier());
      assertEquals(1.0, track0.getPosition(), 0.01);
      assertFalse(track0.isAny());
      assertNotNull(track0);
      
      DNADraw dNADraw0 = new DNADraw();
      assertEquals(0.0F, dNADraw0.getSingleBaseWidth(), 0.01F);
      assertEquals(200.0F, dNADraw0.getLineHeight(), 0.01F);
      assertFalse(dNADraw0.isFocusCycleRoot());
      assertFalse(dNADraw0.isFocusTraversalPolicyProvider());
      assertEquals(0, dNADraw0.getBorderHeight2());
      assertEquals(0, dNADraw0.getBorderWidth2());
      assertFalse(dNADraw0.getScrollableTracksViewportHeight());
      assertTrue(dNADraw0.getFocusTraversalKeysEnabled());
      assertEquals(20000, dNADraw0.getBasesPerLine());
      assertFalse(dNADraw0.getScrollableTracksViewportWidth());
      assertFalse(dNADraw0.isFocusTraversalPolicySet());
      assertFalse(dNADraw0.getIgnoreRepaint());
      assertEquals(0, dNADraw0.getNumberOfLines());
      assertNotNull(dNADraw0);
      
      Block block0 = new Block("fm3", (-535), 279, color0, 279, track0, dNADraw0);
      assertEquals(255, color0.getAlpha());
      assertEquals(1, color0.getTransparency());
      assertEquals(192, color0.getGreen());
      assertEquals(192, color0.getBlue());
      assertEquals(192, color0.getRed());
      assertEquals((-4144960), color0.getRGB());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertTrue(track0.isShowForward());
      assertFalse(track0.isNotQualifier());
      assertTrue(track0.isShowReverse());
      assertNull(track0.getQualifierValue());
      assertNull(track0.getKeyStr());
      assertNull(track0.getQualifier());
      assertEquals(1.0, track0.getPosition(), 0.01);
      assertFalse(track0.isAny());
      assertEquals(0.0F, dNADraw0.getSingleBaseWidth(), 0.01F);
      assertEquals(200.0F, dNADraw0.getLineHeight(), 0.01F);
      assertFalse(dNADraw0.isFocusCycleRoot());
      assertFalse(dNADraw0.isFocusTraversalPolicyProvider());
      assertEquals(0, dNADraw0.getBorderHeight2());
      assertEquals(0, dNADraw0.getBorderWidth2());
      assertFalse(dNADraw0.getScrollableTracksViewportHeight());
      assertTrue(dNADraw0.getFocusTraversalKeysEnabled());
      assertEquals(20000, dNADraw0.getBasesPerLine());
      assertFalse(dNADraw0.getScrollableTracksViewportWidth());
      assertFalse(dNADraw0.isFocusTraversalPolicySet());
      assertFalse(dNADraw0.getIgnoreRepaint());
      assertEquals(0, dNADraw0.getNumberOfLines());
      assertFalse(block0.isArrowHead());
      assertEquals(279.0F, block0.getStrokeSize(), 0.01F);
      assertFalse(block0.isArrowTail());
      assertEquals((-535), block0.getBstart());
      assertEquals("fm3", block0.getLabel());
      assertEquals(0.0, block0.getAngEnd(), 0.01);
      assertEquals(279, block0.getBend());
      assertEquals(0.0, block0.getAngStart(), 0.01);
      assertFalse(block0.isDrawLabel());
      assertNotNull(block0);
      
      DNADraw.THETA = 2139814063;
      boolean boolean0 = block0.isOverMe(279, (-535));
      assertEquals(255, color0.getAlpha());
      assertEquals(1, color0.getTransparency());
      assertEquals(192, color0.getGreen());
      assertEquals(192, color0.getBlue());
      assertEquals(192, color0.getRed());
      assertEquals((-4144960), color0.getRGB());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertTrue(track0.isShowForward());
      assertFalse(track0.isNotQualifier());
      assertTrue(track0.isShowReverse());
      assertNull(track0.getQualifierValue());
      assertNull(track0.getKeyStr());
      assertNull(track0.getQualifier());
      assertEquals(1.0, track0.getPosition(), 0.01);
      assertFalse(track0.isAny());
      assertEquals(0.0F, dNADraw0.getSingleBaseWidth(), 0.01F);
      assertEquals(200.0F, dNADraw0.getLineHeight(), 0.01F);
      assertFalse(dNADraw0.isFocusCycleRoot());
      assertFalse(dNADraw0.isFocusTraversalPolicyProvider());
      assertEquals(0, dNADraw0.getBorderHeight2());
      assertEquals(0, dNADraw0.getBorderWidth2());
      assertFalse(dNADraw0.getScrollableTracksViewportHeight());
      assertTrue(dNADraw0.getFocusTraversalKeysEnabled());
      assertEquals(20000, dNADraw0.getBasesPerLine());
      assertFalse(dNADraw0.getScrollableTracksViewportWidth());
      assertFalse(dNADraw0.isFocusTraversalPolicySet());
      assertFalse(dNADraw0.getIgnoreRepaint());
      assertEquals(0, dNADraw0.getNumberOfLines());
      assertFalse(block0.isArrowHead());
      assertEquals(279.0F, block0.getStrokeSize(), 0.01F);
      assertFalse(block0.isArrowTail());
      assertEquals((-535), block0.getBstart());
      assertEquals("fm3", block0.getLabel());
      assertEquals(0.0, block0.getAngEnd(), 0.01);
      assertEquals(279, block0.getBend());
      assertEquals(0.0, block0.getAngStart(), 0.01);
      assertFalse(block0.isDrawLabel());
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test33()  throws Throwable  {
      Color color0 = Color.lightGray;
      assertEquals(255, color0.getAlpha());
      assertEquals(192, color0.getGreen());
      assertEquals(192, color0.getRed());
      assertEquals((-4144960), color0.getRGB());
      assertEquals(192, color0.getBlue());
      assertEquals(1, color0.getTransparency());
      assertNotNull(color0);
      
      Track track0 = new Track(1.0, (Entry) null);
      assertTrue(track0.isShowReverse());
      assertNull(track0.getQualifier());
      assertFalse(track0.isAny());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertEquals(1.0, track0.getPosition(), 0.01);
      assertNull(track0.getQualifierValue());
      assertTrue(track0.isShowForward());
      assertFalse(track0.isNotQualifier());
      assertNull(track0.getKeyStr());
      assertNotNull(track0);
      
      DNADraw dNADraw0 = new DNADraw();
      assertFalse(dNADraw0.isFocusTraversalPolicyProvider());
      assertEquals(0.0F, dNADraw0.getSingleBaseWidth(), 0.01F);
      assertEquals(200.0F, dNADraw0.getLineHeight(), 0.01F);
      assertFalse(dNADraw0.getScrollableTracksViewportHeight());
      assertTrue(dNADraw0.getFocusTraversalKeysEnabled());
      assertEquals(0, dNADraw0.getBorderWidth2());
      assertFalse(dNADraw0.getIgnoreRepaint());
      assertFalse(dNADraw0.isFocusTraversalPolicySet());
      assertFalse(dNADraw0.isFocusCycleRoot());
      assertEquals(0, dNADraw0.getBorderHeight2());
      assertEquals(20000, dNADraw0.getBasesPerLine());
      assertFalse(dNADraw0.getScrollableTracksViewportWidth());
      assertEquals(0, dNADraw0.getNumberOfLines());
      assertNotNull(dNADraw0);
      
      Block block0 = new Block("fm3", (-535), 279, color0, 279, track0, dNADraw0);
      assertEquals(255, color0.getAlpha());
      assertEquals(192, color0.getGreen());
      assertEquals(192, color0.getRed());
      assertEquals((-4144960), color0.getRGB());
      assertEquals(192, color0.getBlue());
      assertEquals(1, color0.getTransparency());
      assertTrue(track0.isShowReverse());
      assertNull(track0.getQualifier());
      assertFalse(track0.isAny());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertEquals(1.0, track0.getPosition(), 0.01);
      assertNull(track0.getQualifierValue());
      assertTrue(track0.isShowForward());
      assertFalse(track0.isNotQualifier());
      assertNull(track0.getKeyStr());
      assertFalse(dNADraw0.isFocusTraversalPolicyProvider());
      assertEquals(0.0F, dNADraw0.getSingleBaseWidth(), 0.01F);
      assertEquals(200.0F, dNADraw0.getLineHeight(), 0.01F);
      assertFalse(dNADraw0.getScrollableTracksViewportHeight());
      assertTrue(dNADraw0.getFocusTraversalKeysEnabled());
      assertEquals(0, dNADraw0.getBorderWidth2());
      assertFalse(dNADraw0.getIgnoreRepaint());
      assertFalse(dNADraw0.isFocusTraversalPolicySet());
      assertFalse(dNADraw0.isFocusCycleRoot());
      assertEquals(0, dNADraw0.getBorderHeight2());
      assertEquals(20000, dNADraw0.getBasesPerLine());
      assertFalse(dNADraw0.getScrollableTracksViewportWidth());
      assertEquals(0, dNADraw0.getNumberOfLines());
      assertEquals(279, block0.getBend());
      assertEquals(0.0, block0.getAngStart(), 0.01);
      assertEquals(0.0, block0.getAngEnd(), 0.01);
      assertEquals(279.0F, block0.getStrokeSize(), 0.01F);
      assertFalse(block0.isDrawLabel());
      assertEquals((-535), block0.getBstart());
      assertFalse(block0.isArrowHead());
      assertEquals("fm3", block0.getLabel());
      assertFalse(block0.isArrowTail());
      assertNotNull(block0);
      
      boolean boolean0 = block0.isOverMe(2078458288, 279);
      assertEquals(255, color0.getAlpha());
      assertEquals(192, color0.getGreen());
      assertEquals(192, color0.getRed());
      assertEquals((-4144960), color0.getRGB());
      assertEquals(192, color0.getBlue());
      assertEquals(1, color0.getTransparency());
      assertTrue(track0.isShowReverse());
      assertNull(track0.getQualifier());
      assertFalse(track0.isAny());
      assertEquals(10.0F, track0.getSize(), 0.01F);
      assertEquals(1.0, track0.getPosition(), 0.01);
      assertNull(track0.getQualifierValue());
      assertTrue(track0.isShowForward());
      assertFalse(track0.isNotQualifier());
      assertNull(track0.getKeyStr());
      assertFalse(dNADraw0.isFocusTraversalPolicyProvider());
      assertEquals(0.0F, dNADraw0.getSingleBaseWidth(), 0.01F);
      assertEquals(200.0F, dNADraw0.getLineHeight(), 0.01F);
      assertFalse(dNADraw0.getScrollableTracksViewportHeight());
      assertTrue(dNADraw0.getFocusTraversalKeysEnabled());
      assertEquals(0, dNADraw0.getBorderWidth2());
      assertFalse(dNADraw0.getIgnoreRepaint());
      assertFalse(dNADraw0.isFocusTraversalPolicySet());
      assertFalse(dNADraw0.isFocusCycleRoot());
      assertEquals(0, dNADraw0.getBorderHeight2());
      assertEquals(20000, dNADraw0.getBasesPerLine());
      assertFalse(dNADraw0.getScrollableTracksViewportWidth());
      assertEquals(0, dNADraw0.getNumberOfLines());
      assertEquals(279, block0.getBend());
      assertEquals(0.0, block0.getAngStart(), 0.01);
      assertEquals(0.0, block0.getAngEnd(), 0.01);
      assertEquals(279.0F, block0.getStrokeSize(), 0.01F);
      assertFalse(block0.isDrawLabel());
      assertEquals((-535), block0.getBstart());
      assertFalse(block0.isArrowHead());
      assertEquals("fm3", block0.getLabel());
      assertFalse(block0.isArrowTail());
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test34()  throws Throwable  {
      DNADraw dNADraw0 = new DNADraw();
      assertEquals(0.0F, dNADraw0.getSingleBaseWidth(), 0.01F);
      assertEquals(200.0F, dNADraw0.getLineHeight(), 0.01F);
      assertFalse(dNADraw0.isFocusCycleRoot());
      assertFalse(dNADraw0.isFocusTraversalPolicySet());
      assertFalse(dNADraw0.isFocusTraversalPolicyProvider());
      assertEquals(0, dNADraw0.getNumberOfLines());
      assertTrue(dNADraw0.getFocusTraversalKeysEnabled());
      assertFalse(dNADraw0.getScrollableTracksViewportWidth());
      assertEquals(0, dNADraw0.getBorderWidth2());
      assertFalse(dNADraw0.getIgnoreRepaint());
      assertEquals(20000, dNADraw0.getBasesPerLine());
      assertEquals(0, dNADraw0.getBorderHeight2());
      assertFalse(dNADraw0.getScrollableTracksViewportHeight());
      assertNotNull(dNADraw0);
      
      Block block0 = new Block("*x>CV0rM", 0, 0, (Color) null, 0, (Track) null, dNADraw0);
      assertEquals(0.0F, dNADraw0.getSingleBaseWidth(), 0.01F);
      assertEquals(200.0F, dNADraw0.getLineHeight(), 0.01F);
      assertFalse(dNADraw0.isFocusCycleRoot());
      assertFalse(dNADraw0.isFocusTraversalPolicySet());
      assertFalse(dNADraw0.isFocusTraversalPolicyProvider());
      assertEquals(0, dNADraw0.getNumberOfLines());
      assertTrue(dNADraw0.getFocusTraversalKeysEnabled());
      assertFalse(dNADraw0.getScrollableTracksViewportWidth());
      assertEquals(0, dNADraw0.getBorderWidth2());
      assertFalse(dNADraw0.getIgnoreRepaint());
      assertEquals(20000, dNADraw0.getBasesPerLine());
      assertEquals(0, dNADraw0.getBorderHeight2());
      assertFalse(dNADraw0.getScrollableTracksViewportHeight());
      assertEquals("*x>CV0rM", block0.getLabel());
      assertEquals(0, block0.getBend());
      assertFalse(block0.isDrawLabel());
      assertFalse(block0.isArrowHead());
      assertEquals(0.0, block0.getAngEnd(), 0.01);
      assertFalse(block0.isArrowTail());
      assertEquals(0.0F, block0.getStrokeSize(), 0.01F);
      assertEquals(0.0, block0.getAngStart(), 0.01);
      assertEquals(0, block0.getBstart());
      assertNotNull(block0);
      
      boolean boolean0 = block0.isOverMe(0, 514);
      assertEquals(0.0F, dNADraw0.getSingleBaseWidth(), 0.01F);
      assertEquals(200.0F, dNADraw0.getLineHeight(), 0.01F);
      assertFalse(dNADraw0.isFocusCycleRoot());
      assertFalse(dNADraw0.isFocusTraversalPolicySet());
      assertFalse(dNADraw0.isFocusTraversalPolicyProvider());
      assertEquals(0, dNADraw0.getNumberOfLines());
      assertTrue(dNADraw0.getFocusTraversalKeysEnabled());
      assertFalse(dNADraw0.getScrollableTracksViewportWidth());
      assertEquals(0, dNADraw0.getBorderWidth2());
      assertFalse(dNADraw0.getIgnoreRepaint());
      assertEquals(20000, dNADraw0.getBasesPerLine());
      assertEquals(0, dNADraw0.getBorderHeight2());
      assertFalse(dNADraw0.getScrollableTracksViewportHeight());
      assertEquals("*x>CV0rM", block0.getLabel());
      assertEquals(0, block0.getBend());
      assertFalse(block0.isDrawLabel());
      assertFalse(block0.isArrowHead());
      assertEquals(0.0, block0.getAngEnd(), 0.01);
      assertFalse(block0.isArrowTail());
      assertEquals(0.0F, block0.getStrokeSize(), 0.01F);
      assertEquals(0.0, block0.getAngStart(), 0.01);
      assertEquals(0, block0.getBstart());
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test35()  throws Throwable  {
      DNADraw dNADraw0 = new DNADraw();
      Block block0 = new Block("*x>CV0rM", 0, 0, (Color) null, 0, (Track) null, dNADraw0);
      block0.isOverMe((-2440), 0);
      assertEquals(0, block0.getBend());
      assertFalse(block0.isDrawLabel());
      assertEquals(0, block0.getBstart());
  }

  @Test(timeout = 4000)
  public void test36()  throws Throwable  {
      Color color0 = Color.lightGray;
      Track track0 = new Track((-535), (Entry) null);
      Vector<String> vector0 = new Vector<String>();
      DNADraw dNADraw0 = new DNADraw(vector0, vector0, vector0, vector0);
      Block block0 = new Block("fm3", (-535), (-535), color0, (-535), track0, dNADraw0);
      block0.isOverMe((-535), (-535));
      assertEquals((-535), block0.getBend());
      assertFalse(block0.isDrawLabel());
      assertEquals((-535), block0.getBstart());
  }

  @Test(timeout = 4000)
  public void test37()  throws Throwable  {
      Color color0 = Color.lightGray;
      Track track0 = new Track(1.0, (Entry) null);
      Vector<String> vector0 = new Vector<String>();
      DNADraw dNADraw0 = new DNADraw(vector0, vector0, vector0, vector0);
      Block block0 = new Block("fm3", (-535), 279, color0, 279, track0, dNADraw0);
      block0.isOverMe(279, (-535));
      assertEquals(279, block0.getBend());
      assertEquals((-535), block0.getBstart());
      assertFalse(block0.isDrawLabel());
  }

  @Test(timeout = 4000)
  public void test38()  throws Throwable  {
      Color color0 = Color.lightGray;
      Track track0 = new Track(1.0, (Entry) null);
      Vector<String> vector0 = new Vector<String>();
      DNADraw dNADraw0 = new DNADraw(vector0, vector0, vector0, vector0);
      Block block0 = new Block("fm3", (-535), 279, color0, 279, track0, dNADraw0);
      GraphicsConfigurationWithoutTransparency graphicsConfigurationWithoutTransparency0 = new GraphicsConfigurationWithoutTransparency();
      BufferedImage bufferedImage0 = graphicsConfigurationWithoutTransparency0.createCompatibleImage(279, 251, 2147);
      Graphics2D graphics2D0 = bufferedImage0.createGraphics();
      block0.drawLinear(graphics2D0);
      assertEquals(279, block0.getBend());
  }

  @Test(timeout = 4000)
  public void test39()  throws Throwable  {
      DNADraw dNADraw0 = new DNADraw();
      Block block0 = new Block("*x>CV0rM", 0, 0, (Color) null, 0, (Track) null, dNADraw0);
      // Undeclared exception!
      try { 
        block0.draw((Graphics2D) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.circular.Block", e);
      }
  }

  @Test(timeout = 4000)
  public void test40()  throws Throwable  {
      Color color0 = Color.lightGray;
      Track track0 = new Track(1.0, (Entry) null);
      Vector<String> vector0 = new Vector<String>();
      DNADraw dNADraw0 = new DNADraw(vector0, vector0, vector0, vector0);
      Block block0 = new Block("fm3", (-535), 279, color0, 279, track0, dNADraw0);
      // Undeclared exception!
      try { 
        block0.showProperties((JFrame) null, dNADraw0, (JButton) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.circular.Block", e);
      }
  }

  @Test(timeout = 4000)
  public void test41()  throws Throwable  {
      Color color0 = Color.white;
      Track track0 = new Track((-3195.1743F), (String) null, (String) null, false, false, false, (Entry) null);
      DNADraw dNADraw0 = new DNADraw();
      Block block0 = new Block("NVDj-VFoVP{T\"J", 1, (-8050), color0, (-3195.1743F), track0, dNADraw0);
      block0.getFeature();
      assertFalse(block0.isDrawLabel());
      assertEquals((-8050), block0.getBend());
      assertEquals(1, block0.getBstart());
  }

  @Test(timeout = 4000)
  public void test42()  throws Throwable  {
      Color color0 = Color.WHITE;
      Block block0 = new Block("`r?s+j(PaS=", 2047, 3991, color0, 0.5F, (Track) null, (DNADraw) null);
      block0.isArrowHead();
      assertEquals(2047, block0.getBstart());
      assertEquals(3991, block0.getBend());
      assertFalse(block0.isDrawLabel());
  }

  @Test(timeout = 4000)
  public void test43()  throws Throwable  {
      DNADraw dNADraw0 = new DNADraw();
      Block block0 = new Block("*x>CV0rM", 0, 0, (Color) null, 0, (Track) null, dNADraw0);
      boolean boolean0 = block0.isDrawLabel();
      assertEquals(0, block0.getBstart());
      assertFalse(boolean0);
      assertEquals(0, block0.getBend());
  }

  @Test(timeout = 4000)
  public void test44()  throws Throwable  {
      Color color0 = Color.WHITE;
      Block block0 = new Block("`r?s+j(PaS=", 2047, 3991, color0, 0.5F, (Track) null, (DNADraw) null);
      assertFalse(block0.isDrawLabel());
      
      block0.setDrawLabel(true);
      boolean boolean0 = block0.isDrawLabel();
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test45()  throws Throwable  {
      Vector<Object> vector0 = new Vector<Object>();
      DNADraw dNADraw0 = new DNADraw(vector0, vector0, vector0, (Vector) null);
      Color color0 = dNADraw0.getForeground();
      Block block0 = new Block("spacingAndGlyphs", 1031, 1031, color0, 2.0F, (Track) null, dNADraw0);
      block0.getTransferDataFlavors();
      assertEquals(1031, block0.getBstart());
      assertEquals(1031, block0.getBend());
      assertFalse(block0.isDrawLabel());
  }

  @Test(timeout = 4000)
  public void test46()  throws Throwable  {
      SystemColor systemColor0 = SystemColor.text;
      Track track0 = new Track(646.65F, "2aPzp@3;sf4(Hs", false, false, (Entry) null);
      Block block0 = new Block("2aPzp@3;sf4(Hs", 3152, 0, systemColor0, 646.65F, track0);
      block0.setTrack(track0);
      assertEquals(3152, block0.getBstart());
      assertEquals(0, block0.getBend());
      assertFalse(block0.isDrawLabel());
  }

  @Test(timeout = 4000)
  public void test47()  throws Throwable  {
      Color color0 = Color.lightGray;
      Track track0 = new Track(1.0, (Entry) null);
      Vector<String> vector0 = new Vector<String>();
      DNADraw dNADraw0 = new DNADraw(vector0, vector0, vector0, vector0);
      Block block0 = new Block("fm3", (-535), 279, color0, 279, track0, dNADraw0);
      block0.setFeature((uk.ac.sanger.artemis.Feature) null);
      assertEquals(279, block0.getBend());
      assertFalse(block0.isDrawLabel());
      assertEquals((-535), block0.getBstart());
  }

  @Test(timeout = 4000)
  public void test48()  throws Throwable  {
      Block block0 = new Block("q|;=.7", 131336, 131336, (Color) null, 25.0F, (Track) null);
      block0.setLabel("q|;=.7");
      assertFalse(block0.isDrawLabel());
      assertEquals(131336, block0.getBend());
      assertEquals(131336, block0.getBstart());
  }

  @Test(timeout = 4000)
  public void test49()  throws Throwable  {
      Color color0 = Color.lightGray;
      Track track0 = new Track(1.0, (Entry) null);
      DNADraw dNADraw0 = new DNADraw();
      Block block0 = new Block("fm3", (-535), 279, color0, 279, track0, dNADraw0);
      block0.getLabel();
      assertEquals(279, block0.getBend());
      assertFalse(block0.isDrawLabel());
      assertEquals((-535), block0.getBstart());
  }

  @Test(timeout = 4000)
  public void test50()  throws Throwable  {
      Track track0 = new Track((-850), (Entry) null);
      Block block0 = new Block("", (-850), (-850), (Color) null, (-850), track0);
      block0.setColour((Color) null);
      assertEquals((-850), block0.getBend());
      assertFalse(block0.isDrawLabel());
      assertEquals((-850), block0.getBstart());
  }

  @Test(timeout = 4000)
  public void test51()  throws Throwable  {
      Color color0 = Color.lightGray;
      Track track0 = new Track(1.0, (Entry) null);
      Vector<String> vector0 = new Vector<String>();
      DNADraw dNADraw0 = new DNADraw(vector0, vector0, vector0, vector0);
      Block block0 = new Block("fm3", (-535), 279, color0, 279, track0, dNADraw0);
      GraphicsConfigurationWithoutTransparency graphicsConfigurationWithoutTransparency0 = new GraphicsConfigurationWithoutTransparency();
      BufferedImage bufferedImage0 = graphicsConfigurationWithoutTransparency0.createCompatibleImage(279, 251, 2147);
      Graphics2D graphics2D0 = bufferedImage0.createGraphics();
      block0.drawCircular(graphics2D0);
      double double0 = block0.getAngEnd();
      assertEquals((-73.25999999999999), double0, 0.01);
  }

  @Test(timeout = 4000)
  public void test52()  throws Throwable  {
      Vector<Object> vector0 = new Vector<Object>();
      DNADraw dNADraw0 = new DNADraw(vector0, vector0, vector0, (Vector) null);
      Color color0 = dNADraw0.getForeground();
      Block block0 = new Block("spacingAndGlyphs", 1031, 1031, color0, 2.0F, (Track) null, dNADraw0);
      block0.setBend(3);
      assertEquals(3, block0.getBend());
  }

  @Test(timeout = 4000)
  public void test53()  throws Throwable  {
      Color color0 = Color.WHITE;
      Block block0 = new Block("`r?s+j(PaS=", 2047, 3991, color0, 0.5F, (Track) null, (DNADraw) null);
      block0.setAngEnd(2077778691);
      double double0 = block0.getMidAngle();
      assertEquals(2.077778691E9, block0.getAngEnd(), 0.01);
      assertEquals(1.0388893455E9, double0, 0.01);
  }

  @Test(timeout = 4000)
  public void test54()  throws Throwable  {
      Color color0 = Color.WHITE;
      Block block0 = new Block("`r?s+j(PaS=", 2047, 3991, color0, 0.5F, (Track) null, (DNADraw) null);
      block0.setAngStart(601.4503);
      double double0 = block0.getAngStart();
      assertEquals(601.4503, double0, 0.01);
  }

  @Test(timeout = 4000)
  public void test55()  throws Throwable  {
      JList<Integer> jList0 = new JList<Integer>((Integer[]) null);
      Color color0 = jList0.getSelectionForeground();
      Track track0 = new Track(861, (String) null, true, true, (Entry) null);
      DNADraw dNADraw0 = new DNADraw((Vector) null, (Vector) null, (Vector) null, (Vector) null);
      Block block0 = new Block("", 861, 861, color0, 861, track0, dNADraw0);
      block0.isArrowTail();
      assertEquals(861, block0.getBstart());
      assertEquals(861.0F, block0.getStrokeSize(), 0.01F);
      assertFalse(block0.isDrawLabel());
      assertEquals(861, block0.getBend());
  }

  @Test(timeout = 4000)
  public void test56()  throws Throwable  {
      Color color0 = Color.WHITE;
      Block block0 = new Block("`r?s+j(PaS=", 2047, 3991, color0, 0.5F, (Track) null, (DNADraw) null);
      double double0 = block0.getMidAngle();
      assertFalse(block0.isDrawLabel());
      assertEquals(0.0, block0.getAngEnd(), 0.01);
      assertEquals(0.0, double0, 0.01);
      assertEquals(3991, block0.getBend());
      assertEquals(2047, block0.getBstart());
      assertEquals(0.5F, block0.getStrokeSize(), 0.01F);
      assertEquals(0.0, block0.getAngStart(), 0.01);
  }

  @Test(timeout = 4000)
  public void test57()  throws Throwable  {
      Color color0 = Color.WHITE;
      Block block0 = new Block("`r?s+j(PaS=", 2047, 3991, color0, 0.5F, (Track) null, (DNADraw) null);
      block0.setArrowTail(true);
      assertTrue(block0.isArrowTail());
  }

  @Test(timeout = 4000)
  public void test58()  throws Throwable  {
      Vector<Object> vector0 = new Vector<Object>();
      DNADraw dNADraw0 = new DNADraw(vector0, vector0, vector0, (Vector) null);
      Color color0 = dNADraw0.getForeground();
      Block block0 = new Block("spacingAndGlyphs", 1031, 1031, color0, 2.0F, (Track) null, dNADraw0);
      block0.setBstart(3);
      assertEquals(3, block0.getBstart());
  }

  @Test(timeout = 4000)
  public void test59()  throws Throwable  {
      Color color0 = Color.white;
      Track track0 = new Track((-3195.1743F), (String) null, (String) null, false, false, false, (Entry) null);
      DNADraw dNADraw0 = new DNADraw();
      Block block0 = new Block("NVDj-VFoVP{T\"J", 1, (-8050), color0, (-3195.1743F), track0, dNADraw0);
      // Undeclared exception!
      try { 
        block0.setBlockLocation(0, 1, (TrackManager) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.circular.Block", e);
      }
  }
}
