/*
 * This file was automatically generated by EvoSuite
 * Thu Sep 20 11:53:49 GMT 2018
 */

package uk.ac.sanger.artemis.io;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.HeadlessException;
import java.io.File;
import javax.swing.JFrame;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.System;
import org.evosuite.runtime.mock.java.io.MockFile;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.SimpleEntryGroup;
import uk.ac.sanger.artemis.components.database.DatabaseEntrySource;
import uk.ac.sanger.artemis.io.BlastEntryInformation;
import uk.ac.sanger.artemis.io.EntryInformation;
import uk.ac.sanger.artemis.io.Feature;
import uk.ac.sanger.artemis.io.GenbankStreamFeature;
import uk.ac.sanger.artemis.io.ReadAndWriteEntry;
import uk.ac.sanger.artemis.io.SimpleEntryInformation;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, useJEE = true) 
public class ReadAndWriteEntry_ESTest extends ReadAndWriteEntry_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      uk.ac.sanger.artemis.Entry entry0 = simpleEntryGroup0.createEntry();
      MockFile mockFile0 = new MockFile("PO~_}nJ(ph0:", "");
      // Undeclared exception!
      try { 
        ReadAndWriteEntry.writeDatabaseEntryToFile(entry0, mockFile0, false, false, true, true, (-394), (JFrame) null);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - unknown DocumentEntry type
         //
         verifyException("uk.ac.sanger.artemis.io.DocumentEntryFactory", e);
      }
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      String[] stringArray0 = new String[6];
      stringArray0[0] = "Q0e'0";
      stringArray0[1] = "sid";
      stringArray0[2] = "Q0e'0";
      stringArray0[3] = "";
      stringArray0[4] = "-fp";
      stringArray0[5] = "-r";
      // Undeclared exception!
      try { 
        ReadAndWriteEntry.main(stringArray0);
        fail("Expecting exception: System.SystemExitException");
      
      } catch(System.SystemExitException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.System", e);
      }
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      String[] stringArray0 = new String[3];
      stringArray0[0] = "-flt";
      stringArray0[1] = "-flt";
      stringArray0[2] = "vRX~ucb,\"-^Lh-w&";
      // Undeclared exception!
      try { 
        ReadAndWriteEntry.main(stringArray0);
        fail("Expecting exception: System.SystemExitException");
      
      } catch(System.SystemExitException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.System", e);
      }
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      String[] stringArray0 = new String[8];
      stringArray0[0] = "-p";
      stringArray0[1] = "-p";
      // Undeclared exception!
      try { 
        ReadAndWriteEntry.main(stringArray0);
        fail("Expecting exception: System.SystemExitException");
      
      } catch(System.SystemExitException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.System", e);
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      String[] stringArray0 = new String[1];
      stringArray0[0] = "-C";
      // Undeclared exception!
      try { 
        ReadAndWriteEntry.main(stringArray0);
        fail("Expecting exception: System.SystemExitException");
      
      } catch(System.SystemExitException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.System", e);
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      String[] stringArray0 = new String[6];
      stringArray0[0] = "auVD>k`jr-(";
      stringArray0[1] = "-c\tthe URL for your Chado database e.g. server_name:port/database_name?user (if not using default)";
      stringArray0[2] = "org.biojava.bio.seq.MergeFeatureHolder";
      stringArray0[3] = "tlnG";
      stringArray0[4] = "-u";
      stringArray0[5] = "C*-XhR!1yQ:M<fjL";
      // Undeclared exception!
      try { 
        ReadAndWriteEntry.main(stringArray0);
        fail("Expecting exception: System.SystemExitException");
      
      } catch(System.SystemExitException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.System", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      String[] stringArray0 = new String[4];
      stringArray0[0] = "-a";
      stringArray0[1] = "-o";
      // Undeclared exception!
      try { 
        ReadAndWriteEntry.main(stringArray0);
        fail("Expecting exception: System.SystemExitException");
      
      } catch(System.SystemExitException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.System", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      String[] stringArray0 = new String[4];
      stringArray0[0] = "-pp";
      stringArray0[1] = "ALL_CHANGED ";
      stringArray0[2] = "-np";
      // Undeclared exception!
      try { 
        ReadAndWriteEntry.main(stringArray0);
        fail("Expecting exception: System.SystemExitException");
      
      } catch(System.SystemExitException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.System", e);
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      String[] stringArray0 = new String[9];
      stringArray0[0] = "";
      stringArray0[1] = "";
      stringArray0[2] = "";
      stringArray0[3] = "";
      stringArray0[4] = "";
      stringArray0[5] = "";
      stringArray0[6] = "-z";
      // Undeclared exception!
      try { 
        ReadAndWriteEntry.main(stringArray0);
        fail("Expecting exception: System.SystemExitException");
      
      } catch(System.SystemExitException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.System", e);
      }
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      String[] stringArray0 = new String[4];
      stringArray0[0] = "-a";
      stringArray0[1] = "-a";
      stringArray0[2] = "n";
      // Undeclared exception!
      try { 
        ReadAndWriteEntry.main(stringArray0);
        fail("Expecting exception: System.SystemExitException");
      
      } catch(System.SystemExitException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.System", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      String[] stringArray0 = new String[7];
      stringArray0[0] = "~yHCOQ)c-U";
      stringArray0[1] = "?`vBdx$9l.vMJnHP";
      stringArray0[2] = "cWgLqB ([vus,n";
      stringArray0[3] = "-i";
      // Undeclared exception!
      try { 
        ReadAndWriteEntry.main(stringArray0);
        fail("Expecting exception: System.SystemExitException");
      
      } catch(System.SystemExitException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.System", e);
      }
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      String[] stringArray0 = new String[4];
      stringArray0[0] = "A";
      stringArray0[1] = "-f";
      stringArray0[2] = "n";
      // Undeclared exception!
      try { 
        ReadAndWriteEntry.main(stringArray0);
        fail("Expecting exception: System.SystemExitException");
      
      } catch(System.SystemExitException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.System", e);
      }
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      String[] stringArray0 = new String[0];
      // Undeclared exception!
      try { 
        ReadAndWriteEntry.main(stringArray0);
        fail("Expecting exception: System.SystemExitException");
      
      } catch(System.SystemExitException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.System", e);
      }
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      File file0 = MockFile.createTempFile("t#IMH", "t#IMH", (File) null);
      // Undeclared exception!
      try { 
        ReadAndWriteEntry.writeDatabaseEntryToFile((uk.ac.sanger.artemis.Entry) null, file0, true, false, true, true, 8192, (JFrame) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.genebuilder.GeneUtils", e);
      }
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      DatabaseEntrySource databaseEntrySource0 = new DatabaseEntrySource();
      // Undeclared exception!
      try { 
        ReadAndWriteEntry.getFeatureId(databaseEntrySource0, " > ");
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - created a null Document
         //
         verifyException("uk.ac.sanger.artemis.util.Document", e);
      }
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      DatabaseEntrySource databaseEntrySource0 = new DatabaseEntrySource();
      databaseEntrySource0.setLocation(false);
      // Undeclared exception!
      try { 
        ReadAndWriteEntry.getFeatureId(databaseEntrySource0, " BP.");
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         
      }
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      // Undeclared exception!
      try { 
        ReadAndWriteEntry.addQualifierToEntryInfo(blastEntryInformation0, (String) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      SimpleEntryInformation simpleEntryInformation0 = new SimpleEntryInformation();
      // Undeclared exception!
      try { 
        ReadAndWriteEntry.addAllKeysQualifiers(simpleEntryInformation0, (Feature) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.ReadAndWriteEntry", e);
      }
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      // Undeclared exception!
      try { 
        ReadAndWriteEntry.readEntryFromDatabase("[1nSq\"", (DatabaseEntrySource) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
        
      }
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      EntryInformation entryInformation0 = SimpleEntryInformation.getDefaultEntryInformation();
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      ReadAndWriteEntry.addAllKeysQualifiers(entryInformation0, genbankStreamFeature0);
      assertFalse(entryInformation0.useEMBLFormat());
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      uk.ac.sanger.artemis.Entry entry0 = simpleEntryGroup0.createEntry();
      MockFile mockFile0 = new MockFile("");
      // Undeclared exception!
      try { 
        ReadAndWriteEntry.writeDatabaseEntryToFile(entry0, mockFile0, false, false, false, false, (-363), (JFrame) null);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - unknown DocumentEntry type
         //
         verifyException("uk.ac.sanger.artemis.io.DocumentEntryFactory", e);
      }
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      uk.ac.sanger.artemis.Entry entry0 = simpleEntryGroup0.createEntry();
      MockFile mockFile0 = new MockFile("PO~_}nJ(ph0:", "");
      // Undeclared exception!
      try { 
        ReadAndWriteEntry.writeDatabaseEntryToFile(entry0, mockFile0, true, false, true, true, (-394), (JFrame) null);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - unknown DocumentEntry type
         //
         verifyException("uk.ac.sanger.artemis.io.DocumentEntryFactory", e);
      }
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      DatabaseEntrySource databaseEntrySource0 = new DatabaseEntrySource();
      databaseEntrySource0.setLocation(false);
      // Undeclared exception!
      try { 
        ReadAndWriteEntry.readEntryFromDatabase("-l\tlocation of EMBL apping files (qualifier_mapping and key_mapping)", databaseEntrySource0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         
      }
  }

  @Test(timeout = 4000)
  public void test23()  throws Throwable  {
      DatabaseEntrySource databaseEntrySource0 = new DatabaseEntrySource();
      // Undeclared exception!
      try { 
        ReadAndWriteEntry.readEntryFromDatabase("Q'E", databaseEntrySource0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.ReadAndWriteEntry", e);
      }
  }

  @Test(timeout = 4000)
  public void test24()  throws Throwable  {
      // Undeclared exception!
      try { 
        ReadAndWriteEntry.readEntryFromDatabase("");
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
        
      }
  }

  @Test(timeout = 4000)
  public void test25()  throws Throwable  {
      DatabaseEntrySource databaseEntrySource0 = ReadAndWriteEntry.getEntrySource();
      assertNull(databaseEntrySource0);
  }

  @Test(timeout = 4000)
  public void test26()  throws Throwable  {
      // Undeclared exception!
      try { 
        ReadAndWriteEntry.getFeatureId((DatabaseEntrySource) null, (String) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.ReadAndWriteEntry", e);
      }
  }

  @Test(timeout = 4000)
  public void test27()  throws Throwable  {
      ReadAndWriteEntry readAndWriteEntry0 = new ReadAndWriteEntry();
  }

  @Test(timeout = 4000)
  public void test28()  throws Throwable  {
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      ReadAndWriteEntry.addQualifierToEntryInfo(blastEntryInformation0, "[1nSq\"");
      assertFalse(blastEntryInformation0.useEMBLFormat());
  }
}
