/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiapi.reflect.instruction;

import net.sf.jiapi.reflect.Instruction;

public abstract class LVInstruction
extends Instruction {
    protected LVInstruction(byte[] bytes) {
        super(bytes);
    }

    public int getLVIndex() {
        switch (this.getOpcode()) {
            case 21: 
            case 22: 
            case 23: 
            case 54: 
            case 55: 
            case 56: {
                return this.getBytes()[1] & 0xFF;
            }
            case 26: 
            case 30: 
            case 34: 
            case 59: 
            case 63: 
            case 67: {
                return 0;
            }
            case 27: 
            case 31: 
            case 35: 
            case 60: 
            case 64: 
            case 68: {
                return 1;
            }
            case 28: 
            case 32: 
            case 36: 
            case 61: 
            case 65: 
            case 69: {
                return 2;
            }
            case 29: 
            case 33: 
            case 37: 
            case 62: 
            case 66: 
            case 70: {
                return 3;
            }
            case -124: {
                return this.getBytes()[1] & 0xFF;
            }
            case -60: {
                return (this.getBytes()[2] << 8 | this.getBytes()[3]) & 0xFFFF;
            }
            case -87: {
                return this.getBytes()[1] & 0xFF;
            }
        }
        throw new RuntimeException(this.getOpcode() + " is not recoqnized as known LVInstruction");
    }

    public LVType getLVType() {
        switch (this.getOpcode()) {
            case -124: 
            case 21: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 54: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                return LVType.INT;
            }
            case 22: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 55: 
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                return LVType.LONG;
            }
            case 23: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 56: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                return LVType.FLOAT;
            }
            case 24: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 57: 
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                return LVType.DOUBLE;
            }
            case 25: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 58: 
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                return LVType.REFERENCE;
            }
            case -60: {
                switch (this.getBytes()[1]) {
                    case -124: 
                    case 21: 
                    case 54: {
                        return LVType.INT;
                    }
                    case 22: 
                    case 55: {
                        return LVType.LONG;
                    }
                    case 23: 
                    case 56: {
                        return LVType.FLOAT;
                    }
                    case 24: 
                    case 57: {
                        return LVType.DOUBLE;
                    }
                    case 25: 
                    case 58: {
                        return LVType.REFERENCE;
                    }
                    case -87: {
                        return LVType.RETURN_ADDRESS;
                    }
                }
                throw new RuntimeException("wide opcode unknown: " + this.getBytes()[1]);
            }
        }
        throw new RuntimeException(this.getOpcode() + " is not recoqnized as known LVInstruction");
    }

    public static enum LVType {
        INT,
        LONG,
        DOUBLE,
        FLOAT,
        REFERENCE,
        RETURN_ADDRESS;

    }
}

