/* Copyright (c) 2007  Dmitry Xmelkov
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:

   * Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in
     the documentation and/or other materials provided with the
     distribution.
   * Neither the name of the copyright holders nor the names of
     contributors may be used to endorse or promote products derived
     from this software without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE.
 */

/* Test of acos() function. Random cases.
   $Id$
 */
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include "progmem.h"

union lofl_u {
    long lo;
    float fl;
};

volatile union lofl_u v = { .lo = 1 };

PROGMEM const struct {		/* Table of test cases.	*/
    long x;		/* argument	*/
    long z;		/* acos(x)	*/
} t[] = {

    /* x, acos(x)	*/
    { 0x3f0badc6,0x3f7e60f9 }, /*   1:  5.4562032e-01  9.9366719e-01 */
    { 0xbedbb62c,0x4000ea9c }, /*   2: -4.2912424e-01  2.0143194e+00 */
    { 0xbf7953ff,0x403a6b19 }, /*   3: -9.7393793e-01  2.9127867e+00 */
    { 0xbe5adb17,0x3fe4a1af }, /*   4: -2.1372639e-01  1.7861842e+00 */
    { 0x3dada88c,0x3fbe31fb }, /*   5:  8.4794134e-02  1.4859003e+00 */
    { 0xbec84091,0x3ffc7f88 }, /*   6: -3.9111760e-01  1.9726419e+00 */
    { 0x3ede4f98,0x3f8f9212 }, /*   7:  4.3420100e-01  1.1216452e+00 */
    { 0x3f41eca1,0x3f361773 }, /*   8:  7.5751692e-01  7.1129531e-01 */
    { 0x3ea8498e,0x3f9e3174 }, /*   9:  3.2868618e-01  1.2358842e+00 */
    { 0xbf6bdaca,0x402f809f }, /*  10: -9.2130721e-01  2.7422254e+00 */
    { 0x3f4b5c6e,0x3f271ea9 }, /*  11:  7.9437912e-01  6.5281159e-01 */
    { 0x3dd4bc6d,0x3fbbbded }, /*  12:  1.0387502e-01  1.4667336e+00 */
    { 0xbe16feac,0x3fdc015f }, /*  13: -1.4745587e-01  1.7187918e+00 */
    { 0xbf14a651,0x400c2e83 }, /*  14: -5.8066279e-01  2.1903389e+00 */
    { 0x3ed4acbf,0x3f923b52 }, /*  15:  4.1538045e-01  1.1424353e+00 */
    { 0x3f20811e,0x3f64a4b8 }, /*  16:  6.2697017e-01  8.9313841e-01 */
    { 0x3f7c4898,0x3e2eb25d }, /*  17:  9.8548269e-01  1.7060228e-01 */
    { 0x3f3eb6d7,0x3f3af4a3 }, /*  18:  7.4497741e-01  7.3029536e-01 */
    { 0xbeb4a7b5,0x3ff73837 }, /*  19: -3.5284200e-01  1.9314030e+00 */
    { 0xbf782470,0x40392a00 }, /*  20: -9.6930599e-01  2.8931885e+00 */
    { 0xbf0c54d2,0x4009a97e }, /*  21: -5.4816926e-01  2.1509700e+00 */
    { 0xbdff66d0,0x3fd910f2 }, /*  22: -1.2470782e-01  1.6958296e+00 */
    { 0x3ee75acc,0x3f8d0c6f }, /*  23:  4.5186460e-01  1.1019419e+00 */
    { 0x3f01e52c,0x3f84f1c2 }, /*  24:  5.0740314e-01  1.0386279e+00 */
    { 0x3f034118,0x3f842782 }, /*  25:  5.1271200e-01  1.0324557e+00 */
    { 0xbe1c70d0,0x3fdcb1a3 }, /*  26: -1.5277410e-01  1.7241710e+00 */
    { 0x3f756918,0x3e93c741 }, /*  27:  9.5863485e-01  2.8862956e-01 */
    { 0xbf1988c1,0x400db1c9 }, /*  28: -5.9974295e-01  2.2139761e+00 */
    { 0xbf426a44,0x401bba30 }, /*  29: -7.5943398e-01  2.4332390e+00 */
    { 0x3f49af36,0x3f29dc62 }, /*  30:  7.8782976e-01  6.6351902e-01 */
    { 0xbf044c0a,0x400749f1 }, /*  31: -5.1678526e-01  2.1138880e+00 */
    { 0x3f494382,0x3f2a8af6 }, /*  32:  7.8618634e-01  6.6618288e-01 */
    { 0xbf242be0,0x40111635 }, /*  33: -6.4129448e-01  2.2669804e+00 */
    { 0xbefb4013,0x40055b9a }, /*  34: -4.9072322e-01  2.0837159e+00 */
    { 0xbedae688,0x4000cde2 }, /*  35: -4.2754006e-01  2.0125661e+00 */
    { 0x3ee31264,0x3f8e3ef8 }, /*  36:  4.4349968e-01  1.1112967e+00 */
    { 0x3df1fd70,0x3fb9e6f3 }, /*  37:  1.1815917e-01  1.4523605e+00 */
    { 0xbf7e4b78,0x4041abc1 }, /*  38: -9.9333906e-01  3.0261080e+00 */
    { 0x3e4dd74a,0x3faf27c2 }, /*  39:  2.0101658e-01  1.3684008e+00 */
    { 0xbf0d9b8b,0x400a0b59 }, /*  40: -5.5315465e-01  2.1569426e+00 */
    { 0xbf6a2642,0x402e6d6b }, /*  41: -9.1464627e-01  2.7254283e+00 */
    { 0xbb96dfab,0x3fc9a6ba }, /*  42: -4.6043000e-03  1.5754006e+00 */
    { 0x3f0cfc03,0x3f7cd157 }, /*  43:  5.5072039e-01  9.8756927e-01 */
    { 0xbd7e5ece,0x3fd10421 }, /*  44: -6.2102132e-02  1.6329385e+00 */
    { 0x3ed457df,0x3f9252a5 }, /*  45:  4.1473290e-01  1.1431471e+00 */
    { 0xbd0ad9db,0x3fcd66e0 }, /*  46: -3.3899169e-02  1.6047020e+00 */
    { 0xbedec99e,0x400157c1 }, /*  47: -4.3513197e-01  2.0209811e+00 */
    { 0x3ecce90f,0x3f945b90 }, /*  48:  4.0021560e-01  1.1590443e+00 */
    { 0xbe93ed8e,0x3fee942b }, /*  49: -2.8892177e-01  1.8638967e+00 */
    { 0x3e591d5a,0x3fadb70c }, /*  50:  2.1202603e-01  1.3571486e+00 */
    { 0x3edca02f,0x3f9009b1 }, /*  51:  4.3090960e-01  1.1252958e+00 */
    { 0x3e26d19a,0x3fb41dc1 }, /*  52:  1.6290894e-01  1.4071580e+00 */
    { 0xbf69a583,0x402e1e3b }, /*  53: -9.1268176e-01  2.7205951e+00 */
    { 0xbdf01416,0x3fd819f6 }, /*  54: -1.1722581e-01  1.6882923e+00 */
    { 0xbea8ccdb,0x3ff41104 }, /*  55: -3.2968792e-01  1.9067693e+00 */
    { 0x3f199b95,0x3f6d60be }, /*  56:  6.0003024e-01  9.2725742e-01 */
    { 0x3f3ae149,0x3f40a227 }, /*  57:  7.3000008e-01  7.5247425e-01 */
    { 0xbebdfaaa,0x3ff9b85f }, /*  58: -3.7105304e-01  1.9509391e+00 */
    { 0xbf7fed2c,0x4047871c }, /*  59: -9.9971271e-01  3.1176214e+00 */
    { 0x3f787705,0x3e79103c }, /*  60:  9.7056609e-01  2.4322599e-01 */
    { 0xbf154e1f,0x400c6219 }, /*  61: -5.8322328e-01  2.1934874e+00 */
    { 0xbf043936,0x40074471 }, /*  62: -5.1649797e-01  2.1135523e+00 */
    { 0x3f41ba87,0x3f366425 }, /*  63:  7.5675243e-01  7.1246558e-01 */
    { 0xbe65e7f9,0x3fe60c1b }, /*  64: -2.2451772e-01  1.7972444e+00 */
    { 0xbbec9fc3,0x3fc9fc7b }, /*  65: -7.2211935e-03  1.5780176e+00 */
    { 0xbf2bb8bd,0x40139698 }, /*  66: -6.7078763e-01  2.3060665e+00 */
    { 0xbf47f0cc,0x401de4d0 }, /*  67: -7.8101802e-01  2.4670906e+00 */
    { 0xbf639992,0x402aa132 }, /*  68: -8.8906205e-01  2.6660886e+00 */
    { 0xbf2a0435,0x4013040a }, /*  69: -6.6412669e-01  2.2971215e+00 */
    { 0x3ed70a0c,0x3f9194c5 }, /*  70:  4.1999853e-01  1.1373526e+00 */
    { 0xbee26a39,0x4001d8ec }, /*  71: -4.4221666e-01  2.0288649e+00 */
    { 0xbf142a77,0x400c0883 }, /*  72: -5.7877296e-01  2.1880195e+00 */
    { 0xbf15a8b9,0x400c7e00 }, /*  73: -5.8460575e-01  2.1951904e+00 */
    { 0xbf64391a,0x402af8c5 }, /*  74: -8.9149630e-01  2.6714337e+00 */
    { 0x3eb7df38,0x3f9a0b2f }, /*  75:  3.5912490e-01  1.2034663e+00 */
    { 0x3f548336,0x3f1769f8 }, /*  76:  8.3012712e-01  5.9146070e-01 */
    { 0x3d98ca44,0x3fbf80f0 }, /*  77:  7.4604541e-02  1.4961224e+00 */
    { 0x3f6c8acd,0x3ec8e900 }, /*  78:  9.2399293e-01  3.9240265e-01 */
    { 0x3e6bdef7,0x3fab4f98 }, /*  79:  2.3034273e-01  1.3383665e+00 */
    { 0x3f492281,0x3f2ac056 }, /*  80:  7.8568274e-01  6.6699731e-01 */
    { 0x3e0b488d,0x3fb798ed }, /*  81:  1.3601895e-01  1.4343544e+00 */
    { 0xbead7056,0x3ff54c00 }, /*  82: -3.3874768e-01  1.9163818e+00 */
    { 0xbd52917f,0x3fcfa525 }, /*  83: -5.1408287e-02  1.6222273e+00 */
    { 0x3e64b280,0x3fac3b4c }, /*  84:  2.2333717e-01  1.3455596e+00 */
    { 0x3f0b4552,0x3f7edd89 }, /*  85:  5.4402649e-01  9.9556786e-01 */
    { 0x3f1e707b,0x3f67487f }, /*  86:  6.1890382e-01  9.0344995e-01 */
    { 0xbe34df2c,0x3fdfca47 }, /*  87: -1.7663258e-01  1.7483605e+00 */
    { 0x3e8c4d38,0x3fa58832 }, /*  88:  2.7402663e-01  1.2932189e+00 */
    { 0xbf408cda,0x401b03e9 }, /*  89: -7.5214922e-01  2.4221137e+00 */
    { 0xbe3493dd,0x3fdfc0b7 }, /*  90: -1.7634530e-01  1.7480687e+00 */
    { 0x3e7a7684,0x3fa96ee5 }, /*  91:  2.4459273e-01  1.3236967e+00 */
    { 0xbeabb5f2,0x3ff4d688 }, /*  92: -3.3537251e-01  1.9127970e+00 */
    { 0x3e9d43a5,0x3fa1198f }, /*  93:  3.0715671e-01  1.2585925e+00 */
    { 0x3ab05024,0x3fc8e3c7 }, /*  94:  1.3451618e-03  1.5694512e+00 */
    { 0x3ee15611,0x3f8ebacb }, /*  95:  4.4010976e-01  1.1150755e+00 */
    { 0xbf33376d,0x40162985 }, /*  96: -7.0006448e-01  2.3462842e+00 */
    { 0x3ea93ed6,0x3f9df081 }, /*  97:  3.3055753e-01  1.2339021e+00 */
    { 0x3f28ba3c,0x3f59e752 }, /*  98:  6.5909171e-01  8.5118592e-01 */
    { 0xbf16d0fe,0x400cd97a }, /*  99: -5.8912647e-01  2.2007737e+00 */
    { 0x3f2a9b35,0x3f576504 }, /* 100:  6.6643077e-01  8.4138513e-01 */
    { 0x3da1fa13,0x3fbeed84 }, /* 101:  7.9090260e-02  1.4916234e+00 */
    { 0xbd0061ae,0x3fcd1313 }, /* 102: -3.1343155e-02  1.6021446e+00 */
    { 0xbf698f42,0x402e10a1 }, /* 103: -9.1234219e-01  2.7197649e+00 */
    { 0x3efd2d12,0x3f86dae1 }, /* 104:  4.9448448e-01  1.0535547e+00 */
    { 0x3d9e065a,0x3fbf2cf1 }, /* 105:  7.7160552e-02  1.4935590e+00 */
    { 0x3ee4c0b4,0x3f8dc6d5 }, /* 106:  4.4678271e-01  1.1076304e+00 */
    { 0x3ea6337e,0x3f9ebeb8 }, /* 107:  3.2461160e-01  1.2401953e+00 */
    { 0xbf5925ec,0x40255714 }, /* 108: -8.4823489e-01  2.5834398e+00 */
    { 0x3ebdd64e,0x3f987120 }, /* 109:  3.7077564e-01  1.1909523e+00 */
    { 0xbee3dd06,0x40020ca4 }, /* 110: -4.4504565e-01  2.0320215e+00 */
    { 0x3f6ffc95,0x3eb60d68 }, /* 111:  9.3744785e-01  3.5557103e-01 */
    { 0xbefc856c,0x40058a50 }, /* 112: -4.9320543e-01  2.0865669e+00 */
    { 0x3e5d6548,0x3fad2ace }, /* 113:  2.1620667e-01  1.3528688e+00 */
    { 0xbde96416,0x3fd7ae3d }, /* 114: -1.1396043e-01  1.6850048e+00 */
    { 0x3f3ae9ea,0x3f409587 }, /* 115:  7.3013175e-01  7.5228161e-01 */
    { 0xbe75856e,0x3fe80dd4 }, /* 116: -2.3976681e-01  1.8129220e+00 */
    { 0xbefd7810,0x4005ad33 }, /* 117: -4.9505663e-01  2.0886962e+00 */
    { 0xbee49bc2,0x40022747 }, /* 118: -4.4650084e-01  2.0336473e+00 */
    { 0xbf773ac0,0x403842cc }, /* 119: -9.6574020e-01  2.8790770e+00 */
    { 0xbe7d238a,0x3fe90928 }, /* 120: -2.4720588e-01  1.8205919e+00 */
    { 0x3ec11a50,0x3f978fc5 }, /* 121:  3.7715387e-01  1.1840750e+00 */
    { 0x3e8ec5c3,0x3fa4e3a6 }, /* 122:  2.7885255e-01  1.2881973e+00 */
    { 0x3ed5b849,0x3f91f1c1 }, /* 123:  4.1742161e-01  1.1401902e+00 */
    { 0xbea1a20b,0x3ff22c62 }, /* 124: -3.1568941e-01  1.8919795e+00 */
    { 0xbf3844f7,0x4017f4c2 }, /* 125: -7.1980232e-01  2.3743138e+00 */
    { 0xbe11e34c,0x3fdb5c34 }, /* 126: -1.4246863e-01  1.7137513e+00 */
    { 0xbc810e45,0x3fcb1419 }, /* 127: -1.5753875e-02  1.5865508e+00 */
    { 0x3f1c5a74,0x3f69eda3 }, /* 128:  6.1075521e-01  9.1378230e-01 */
    { 0xbef77d2d,0x4004d1ca }, /* 129: -4.8337689e-01  2.0753045e+00 */
    { 0x3eca4d1f,0x3f95118e }, /* 130:  3.9511964e-01  1.1645982e+00 */
    { 0x3e8deb54,0x3fa51c7f }, /* 131:  2.7718604e-01  1.2899321e+00 */
    { 0x3f1880ac,0x3f6ec1ae }, /* 132:  5.9571338e-01  9.3264282e-01 */
    { 0xbf22df8b,0x4010aa39 }, /* 133: -6.3622350e-01  2.2603896e+00 */
    { 0x3ebaccd0,0x3f994226 }, /* 134:  3.6484385e-01  1.1973312e+00 */
    { 0x3db8b9a6,0x3fbd803b }, /* 135:  9.0197846e-02  1.4804758e+00 */
    { 0x3ee1c280,0x3f8e9c98 }, /* 136:  4.4093704e-01  1.1141539e+00 */
    { 0xbe40e4f8,0x3fe15193 }, /* 137: -1.8837345e-01  1.7603019e+00 */
    { 0xbf15cf0c,0x400c89d0 }, /* 138: -5.8519053e-01  2.1959114e+00 */
    { 0x3f17bb54,0x3f6fb709 }, /* 139:  5.9270215e-01  9.3638664e-01 */
    { 0xbf514e17,0x4021cb21 }, /* 140: -8.1759781e-01  2.5280230e+00 */
    { 0xbcf7b1e5,0x3fcceec9 }, /* 141: -3.0236194e-02  1.6010371e+00 */
    { 0x3f07b7e9,0x3f8189d6 }, /* 142:  5.3015000e-01  1.0120189e+00 */
    { 0xbe9f219a,0x3ff183ca }, /* 143: -3.1080323e-01  1.8868344e+00 */
    { 0xbf50643d,0x40216609 }, /* 144: -8.1402951e-01  2.5218527e+00 */
    { 0xbf15749a,0x400c6df2 }, /* 145: -5.8381045e-01  2.1942105e+00 */
    { 0xbf14a6e3,0x400c2eb0 }, /* 146: -5.8067149e-01  2.1903496e+00 */
    { 0xbd5c5989,0x3fcff381 }, /* 147: -5.3796325e-02  1.6246186e+00 */
    { 0xbda18510,0x3fd32adb }, /* 148: -7.8867078e-02  1.6497453e+00 */
    { 0xbcde987a,0x3fcc8a59 }, /* 149: -2.7172316e-02  1.5979720e+00 */
    { 0xbca00b0a,0x3fcb9011 }, /* 150: -1.9536514e-02  1.5903341e+00 */
    { 0x3f2c867c,0x3f54cf16 }, /* 151:  6.7392707e-01  8.3128488e-01 */
    { 0xbf26679c,0x4011d163 }, /* 152: -6.5001845e-01  2.2784050e+00 */
    { 0xbf3d9d77,0x4019e99f }, /* 153: -7.4068397e-01  2.4048841e+00 */
    { 0x3dbb14ff,0x3fbd5a5d }, /* 154:  9.1348641e-02  1.4793202e+00 */
    { 0x3d0c75ec,0x3fc4abf3 }, /* 155:  3.4292147e-02  1.5364975e+00 */
    { 0xbeebc4db,0x40032860 }, /* 156: -4.6048626e-01  2.0493393e+00 */
    { 0x3f72e9cd,0x3ea46ae0 }, /* 157:  9.4888002e-01  3.2112789e-01 */
    { 0xbf7b4113,0x403cb82d }, /* 158: -9.8146170e-01  2.9487412e+00 */
    { 0xbf5987f9,0x40258578 }, /* 159: -8.4973103e-01  2.5862713e+00 */
    { 0xbf08d4ca,0x40089f11 }, /* 160: -5.3449690e-01  2.1347086e+00 */
    { 0x3ed3caf8,0x3f927958 }, /* 161:  4.1365790e-01  1.1443281e+00 */
    { 0x3edadb61,0x3f908706 }, /* 162:  4.2745498e-01  1.1291206e+00 */
    { 0xbf70541e,0x40328d5e }, /* 163: -9.3878353e-01  2.7898784e+00 */
    { 0x3f4705f1,0x3f2e22e5 }, /* 164:  7.7743441e-01  6.8021995e-01 */
    { 0xbe54af9e,0x3fe3d7b7 }, /* 165: -2.0770118e-01  1.7800206e+00 */
    { 0x3e1b0c5b,0x3fb59b27 }, /* 166:  1.5141432e-01  1.4187974e+00 */
    { 0x3e5f9cc2,0x3face222 }, /* 167:  2.1837142e-01  1.3506510e+00 */
    { 0x3f1a9adb,0x3f6c210e }, /* 168:  6.0392541e-01  9.2237937e-01 */
    { 0x3f10f40b,0x3f780876 }, /* 169:  5.6622380e-01  9.6887910e-01 */
    { 0xbe4175f0,0x3fe16407 }, /* 170: -1.8892646e-01  1.7608651e+00 */
    { 0x3f494cc3,0x3f2a7bfc }, /* 171:  7.8632754e-01  6.6595435e-01 */
    { 0xbeed9309,0x40036986 }, /* 172: -4.6401241e-01  2.0533156e+00 */
    { 0xbf28a593,0x40128f28 }, /* 173: -6.5877646e-01  2.2899876e+00 */
    { 0xbf064409,0x4007dd85 }, /* 174: -5.2447563e-01  2.1228955e+00 */
    { 0xbe8e5b83,0x3fed2067 }, /* 175: -2.7804193e-01  1.8525513e+00 */
    { 0xbe7868b4,0x3fe86d0c }, /* 176: -2.4258691e-01  1.8158278e+00 */
    { 0xbdd75763,0x3fd68bb2 }, /* 177: -1.0514715e-01  1.6761382e+00 */
    { 0x3f2b0ca6,0x3f56ccb4 }, /* 178:  6.6816175e-01  8.3906102e-01 */
    { 0x3f2db531,0x3f53342d }, /* 179:  6.7854601e-01  8.2501489e-01 */
    { 0x3f5e2050,0x3f053100 }, /* 180:  8.6768055e-01  5.2027893e-01 */
    { 0xbeb3e765,0x3ff704d9 }, /* 181: -3.5137478e-01  1.9298354e+00 */
    { 0x3eb47759,0x3f9af46a }, /* 182:  3.5247305e-01  1.2105839e+00 */
    { 0xbf48474c,0x401e077c }, /* 183: -7.8233790e-01  2.4692068e+00 */
    { 0xbdbc894c,0x3fd4dcb6 }, /* 184: -9.2058748e-02  1.6629856e+00 */
    { 0xbf0e61b4,0x400a46e3 }, /* 185: -5.5617833e-01  2.1605766e+00 */
    { 0x3e810025,0x3fa875e0 }, /* 186:  2.5195423e-01  1.3160973e+00 */
    { 0x3ee518d2,0x3f8dae34 }, /* 187:  4.4745499e-01  1.1068788e+00 */
    { 0xbf1b77e7,0x400e4d09 }, /* 188: -6.0729831e-01  2.2234519e+00 */
    { 0x3e8a7dff,0x3fa6008c }, /* 189:  2.7049252e-01  1.2968917e+00 */
    { 0x3f190470,0x3f6e1d79 }, /* 190:  5.9772396e-01  9.3013722e-01 */
    { 0xbe1132c1,0x3fdb45e9 }, /* 191: -1.4179517e-01  1.7130710e+00 */
    { 0xbea1b709,0x3ff231ea }, /* 192: -3.1584957e-01  1.8921483e+00 */
    { 0x3cce440e,0x3fc5d6b4 }, /* 193:  2.5178935e-02  1.5456147e+00 */
    { 0xbda50672,0x3fd3631f }, /* 194: -8.0578700e-02  1.6514624e+00 */
    { 0xbf09d594,0x4008eb23 }, /* 195: -5.3841519e-01  2.1393516e+00 */
    { 0x3f514639,0x3f1d2092 }, /* 196:  8.1747776e-01  6.1377823e-01 */
    { 0xbf6dddb8,0x4030d40c }, /* 197: -9.2916441e-01  2.7629423e+00 */
    { 0x3f2e119d,0x3f52b63f }, /* 198:  6.7995626e-01  8.2309335e-01 */
    { 0x3ed7c227,0x3f916209 }, /* 199:  4.2140314e-01  1.1358043e+00 */
    { 0x3f231653,0x3f614f7b }, /* 200:  6.3705939e-01  8.8011903e-01 */
    { 0xbf024bdf,0x4006b4c9 }, /* 201: -5.0897020e-01  2.1047843e+00 */
    { 0x3e54b75d,0x3fae4701 }, /* 202:  2.0773073e-01  1.3615419e+00 */
    { 0xbf53b331,0x4022d87c }, /* 203: -8.2695299e-01  2.5444632e+00 */
    { 0xbe2bc5ca,0x3fdea2b0 }, /* 204: -1.6774669e-01  1.7393398e+00 */
    { 0x3f2ee9ce,0x3f518eca }, /* 205:  6.8325508e-01  8.1858504e-01 */
    { 0xbdd70799,0x3fd686af }, /* 206: -1.0499496e-01  1.6759852e+00 */
    { 0x3f16f461,0x3f70adb5 }, /* 207:  5.8966643e-01  9.4015056e-01 */
    { 0xbed8023d,0x400067ac }, /* 208: -4.2189208e-01  2.0063276e+00 */
    { 0xbedfa89b,0x400176ba }, /* 209: -4.3683323e-01  2.0228715e+00 */
    { 0x3e895323,0x3fa64e21 }, /* 210:  2.6821241e-01  1.2992593e+00 */
    { 0xbf0de0cf,0x400a2024 }, /* 211: -5.5421156e-01  2.1582117e+00 */
    { 0x3e58e001,0x3fadbee5 }, /* 212:  2.1179201e-01  1.3573881e+00 */
    { 0xbec23584,0x3ffadc6c }, /* 213: -3.7931454e-01  1.9598517e+00 */
    { 0xbeac5036,0x3ff4ff7a }, /* 214: -3.3654946e-01  1.9140465e+00 */
    { 0xbf615929,0x40296c0f }, /* 215: -8.8026673e-01  2.6472204e+00 */
    { 0x3d841c55,0x3fc0cc9d }, /* 216:  6.4507164e-02  1.5062443e+00 */
    { 0x3f6a57f8,0x3ed41d06 }, /* 217:  9.1540480e-01  4.1428393e-01 */
    { 0x3f113340,0x3f77bbbf }, /* 218:  5.6718826e-01  9.6770853e-01 */
    { 0x3eea1748,0x3f8c47d4 }, /* 219:  4.5720887e-01  1.0959420e+00 */
    { 0x3e3e5bdc,0x3fb120bb }, /* 220:  1.8589729e-01  1.3838114e+00 */
    { 0x3e28debe,0x3fb3db36 }, /* 221:  1.6491219e-01  1.4051273e+00 */
    { 0xbf2f410c,0x4014ca0d }, /* 222: -6.8458629e-01  2.3248322e+00 */
    { 0x3f5ebb72,0x3f03f7a1 }, /* 223:  8.7004769e-01  5.1549727e-01 */
    { 0xbf4f5630,0x4020f25f }, /* 224: -8.0990887e-01  2.5147932e+00 */
    { 0x3e707897,0x3faab83d }, /* 225:  2.3483501e-01  1.3337475e+00 */
    { 0xbf2b1a22,0x40136136 }, /* 226: -6.6836751e-01  2.3028083e+00 */
    { 0xbf7e0ff7,0x40412ec3 }, /* 227: -9.9243110e-01  3.0184791e+00 */
    { 0x3e9c80dc,0x3fa14cb7 }, /* 228:  3.0567062e-01  1.2601537e+00 */
    { 0xbf7d0885,0x403f4f1d }, /* 229: -9.8841125e-01  2.9892037e+00 */
    { 0x3edba23a,0x3f905003 }, /* 230:  4.2897207e-01  1.1274418e+00 */
    { 0xbd6a93ec,0x3fd06581 }, /* 231: -5.7269976e-02  1.6280977e+00 */
    { 0xbefea8c9,0x4005d913 }, /* 232: -4.9738148e-01  2.0913742e+00 */
    { 0xbeba0218,0x3ff8a725 }, /* 233: -3.6329722e-01  1.9426008e+00 */
    { 0x3ded1c7e,0x3fba358c }, /* 234:  1.1577700e-01  1.4547591e+00 */
    { 0x3eab7453,0x3f9d5a97 }, /* 235:  3.3487186e-01  1.2293271e+00 */
    { 0xbf2e173e,0x40146436 }, /* 236: -6.8004215e-01  2.3186164e+00 */
    { 0xbf7d3d63,0x403fa7be }, /* 237: -9.8921794e-01  2.9946132e+00 */
    { 0xbd9a8bb1,0x3fd2baf0 }, /* 238: -7.5461753e-02  1.6463299e+00 */
    { 0xbdd0c2e9,0x3fd621d9 }, /* 239: -1.0193426e-01  1.6729079e+00 */
    { 0xbeda2361,0x4000b2e9 }, /* 240: -4.2605117e-01  2.0109198e+00 */
    { 0xbf4ea7e4,0x4020a850 }, /* 241: -8.0724931e-01  2.5102730e+00 */
    { 0x3eb00da8,0x3f9c21b0 }, /* 242:  3.4385419e-01  1.2197781e+00 */
    { 0x3f492650,0x3f2aba2e }, /* 243:  7.8574085e-01  6.6690338e-01 */
    { 0xbe3f0a99,0x3fe11536 }, /* 244: -1.8656386e-01  1.7584598e+00 */
    { 0xbf7e2147,0x40415252 }, /* 245: -9.9269527e-01  3.0206494e+00 */
    { 0x3f67cd26,0x3ee068fa }, /* 246:  9.0547407e-01  4.3830091e-01 */
    { 0x3f60c0e4,0x3eff9d51 }, /* 247:  8.7794328e-01  4.9924710e-01 */
    { 0x3f6c36b1,0x3eca9f20 }, /* 248:  9.2270952e-01  3.9574528e-01 */
    { 0x3ef200cc,0x3f8a0bdc }, /* 249:  4.7266233e-01  1.0784869e+00 */
    { 0x3eab9911,0x3f9d50d7 }, /* 250:  3.3515218e-01  1.2290295e+00 */
    { 0x3dde6d3f,0x3fbb21fe }, /* 251:  1.0860681e-01  1.4619749e+00 */
    { 0xbeb98fd5,0x3ff8887d }, /* 252: -3.6242548e-01  1.9416653e+00 */
    { 0x3f268b7c,0x3f5ccaa4 }, /* 253:  6.5056586e-01  8.6246705e-01 */
    { 0xbcaedcb5,0x3fcbcb5b }, /* 254: -2.1345476e-02  1.5921434e+00 */
    { 0xbe307869,0x3fdf3b3d }, /* 255: -1.7233433e-01  1.7439953e+00 */
    { 0xbdeab2f0,0x3fd7c34e }, /* 256: -1.1459911e-01  1.6856477e+00 */
    { 0x3e9eddf2,0x3fa0adb7 }, /* 257:  3.1028706e-01  1.2553014e+00 */
    { 0xbe28b844,0x3fde3f9e }, /* 258: -1.6476542e-01  1.7363164e+00 */
    { 0xbf4f15f0,0x4020d704 }, /* 259: -8.0892849e-01  2.5131235e+00 */
    { 0x3ea4cce8,0x3f9f1d73 }, /* 260:  3.2187581e-01  1.2430862e+00 */
    { 0xbf3c5cf4,0x401972d5 }, /* 261: -7.3579335e-01  2.3976338e+00 */
    { 0x3e090345,0x3fb7e242 }, /* 262:  1.3380153e-01  1.4365923e+00 */
    { 0x3f531210,0x3f19fb23 }, /* 263:  8.2449436e-01  6.0148829e-01 */
    { 0xbdcaf003,0x3fd5c431 }, /* 264: -9.9090599e-02  1.6700498e+00 */
    { 0xbf401b9f,0x401ad905 }, /* 265: -7.5042146e-01  2.4194958e+00 */
    { 0x3e2330e3,0x3fb49362 }, /* 266:  1.5936618e-01  1.4107478e+00 */
    { 0x3e622b05,0x3fac8e4e }, /* 267:  2.2086723e-01  1.3480928e+00 */
    { 0xbf3d5902,0x4019d02c }, /* 268: -7.3963940e-01  2.4033308e+00 */
    { 0xbf6a853d,0x402ea865 }, /* 269: -9.1609555e-01  2.7290280e+00 */
    { 0xbf618d9c,0x402987bd }, /* 270: -8.8106704e-01  2.6489098e+00 */
    { 0xbe29aacb,0x3fde5e5c }, /* 271: -1.6569059e-01  1.7372546e+00 */
    { 0xbf392d22,0x40184898 }, /* 272: -7.2334492e-01  2.3794308e+00 */
    { 0x3eecf270,0x3f8b79f7 }, /* 273:  4.6278715e-01  1.0896596e+00 */
    { 0xbec288c6,0x3ffaf2eb }, /* 274: -3.7994975e-01  1.9605383e+00 */
    { 0x3db881bf,0x3fbd83bd }, /* 275:  9.0091221e-02  1.4805828e+00 */
    { 0x3ef0afe2,0x3f8a6b5d }, /* 276:  4.7009188e-01  1.0814015e+00 */
    { 0xbef2ee7a,0x40042ba8 }, /* 277: -4.7447568e-01  2.0651646e+00 */
    { 0xbd02ee3d,0x3fcd277a }, /* 278: -3.1965483e-02  1.6027672e+00 */
    { 0x3ec91d44,0x3f956434 }, /* 279:  3.9280140e-01  1.1671205e+00 */
    { 0x3f7f8929,0x3d76b505 }, /* 280:  9.9818665e-01  6.0231227e-02 */
    { 0xbf32625b,0x4015df17 }, /* 281: -6.9681329e-01  2.3417413e+00 */
    { 0xbeff476c,0x4005eff1 }, /* 282: -4.9859178e-01  2.0927699e+00 */
    { 0xbeba7d82,0x3ff8c844 }, /* 283: -3.6423880e-01  1.9436116e+00 */
    { 0x3f742921,0x3e9c5222 }, /* 284:  9.5375258e-01  3.0531412e-01 */
    { 0x3ef5cac9,0x3f88f80e }, /* 285:  4.8006275e-01  1.0700700e+00 */
    { 0x3eed464a,0x3f8b6250 }, /* 286:  4.6342689e-01  1.0889378e+00 */
    { 0xbe24b4f5,0x3fddbd78 }, /* 287: -1.6084655e-01  1.7323446e+00 */
    { 0xbe56ae8c,0x3fe41905 }, /* 288: -2.0965022e-01  1.7820135e+00 */
    { 0xbf338aec,0x401646c7 }, /* 289: -7.0133853e-01  2.3480699e+00 */
    { 0x3cf79a5e,0x3fc5314b }, /* 290:  3.0224975e-02  1.5405668e+00 */
    { 0xbf63452f,0x402a733c }, /* 291: -8.8777441e-01  2.6632833e+00 */
    { 0xbedfcfc1,0x40017c2b }, /* 292: -4.3713191e-01  2.0232036e+00 */
    { 0xbf56025c,0x4023e285 }, /* 293: -8.3597350e-01  2.5607007e+00 */
    { 0x3f6fcce0,0x3eb71eb8 }, /* 294:  9.3671989e-01  3.5765624e-01 */
    { 0x3eed743e,0x3f8b5559 }, /* 295:  4.6377748e-01  1.0885421e+00 */
    { 0xbf161dfb,0x400ca229 }, /* 296: -5.8639497e-01  2.1973975e+00 */
    { 0x3dc4c8c9,0x3fbcbe71 }, /* 297:  9.6086092e-02  1.4745618e+00 */
    { 0xbea17640,0x3ff220d8 }, /* 298: -3.1535530e-01  1.8916273e+00 */
    { 0xbea6edfa,0x3ff3924b }, /* 299: -3.2603437e-01  1.9029020e+00 */
    { 0x3e384f70,0x3fb1e59b }, /* 300:  1.7999053e-01  1.3898195e+00 */
    { 0xbe4922ef,0x3fe25e58 }, /* 301: -1.9642232e-01  1.7685041e+00 */
    { 0x3f021e50,0x3f84d098 }, /* 302:  5.0827503e-01  1.0376158e+00 */
    { 0x3ee9cd74,0x3f8c5c94 }, /* 303:  4.5664561e-01  1.0965753e+00 */
    { 0xbf3bcf84,0x40193eb5 }, /* 304: -7.3363519e-01  2.3944523e+00 */
    { 0xbf5f2613,0x4028482e }, /* 305: -8.7167472e-01  2.6294055e+00 */
    { 0xbee8121c,0x4002a355 }, /* 306: -4.5326316e-01  2.0412190e+00 */
    { 0x3f3c886d,0x3f3e33dc }, /* 307:  7.3645669e-01  7.4297881e-01 */
    { 0xbeb13a9f,0x3ff64e2f }, /* 308: -3.4615037e-01  1.9242610e+00 */
    { 0x3f03c80e,0x3f83d8db }, /* 309:  5.1477134e-01  1.0300554e+00 */
    { 0x3e045c3d,0x3fb87871 }, /* 310:  1.2925811e-01  1.4411756e+00 */
    { 0xbeb2284d,0x3ff68d8b }, /* 311: -3.4796372e-01  1.9261945e+00 */
    { 0x3f5165b3,0x3f1ce9e3 }, /* 312:  8.1795806e-01  6.1294383e-01 */
    { 0x3f217359,0x3f636d30 }, /* 313:  6.3066632e-01  8.8838482e-01 */
    { 0x3e935a31,0x3fa3b204 }, /* 314:  2.8779748e-01  1.2788701e+00 */
    { 0x3f458ed4,0x3f3073fc }, /* 315:  7.7171063e-01  6.8926978e-01 */
    { 0x3de2c5ec,0x3fbadc07 }, /* 316:  1.1072907e-01  1.4598397e+00 */
    { 0xbe7ebf0a,0x3fe93e40 }, /* 317: -2.4877563e-01  1.8222122e+00 */
    { 0xbec73cd3,0x3ffc3902 }, /* 318: -3.8913593e-01  1.9704897e+00 */
    { 0x3f66ad1b,0x3ee5a7bc }, /* 319:  9.0107888e-01  4.4854534e-01 */
    { 0x3d4c5512,0x3fc2ac84 }, /* 320:  4.9885817e-02  1.5208898e+00 */
    { 0x3f241e69,0x3f5ff821 }, /* 321:  6.4108902e-01  8.7487990e-01 */
    { 0xbf7c9815,0x403e9c4a }, /* 322: -9.8669559e-01  2.9782891e+00 */
    { 0x3f1cdd71,0x3f69480d }, /* 323:  6.1275393e-01  9.1125566e-01 */
    { 0x3f4e1c0e,0x3f228a83 }, /* 324:  8.0511558e-01  6.3492602e-01 */
    { 0x3f7334cc,0x3ea28d0d }, /* 325:  9.5002437e-01  3.1748238e-01 */
    { 0x3d9cbc7c,0x3fbf419f }, /* 326:  7.6531380e-02  1.4941901e+00 */
    { 0xbf4801ed,0x401debac }, /* 327: -7.8127939e-01  2.4675093e+00 */
    { 0x3d3cde4f,0x3fc3285f }, /* 328:  4.6110447e-02  1.5246695e+00 */
    { 0x3f42dc70,0x3f34a6e6 }, /* 329:  7.6117611e-01  7.0567167e-01 */
    { 0xbddbc74c,0x3fd6d318 }, /* 330: -1.0731372e-01  1.6783171e+00 */
    { 0xbf461e3f,0x401d2b5b }, /* 331: -7.7389902e-01  2.4557712e+00 */
    { 0xbeded899,0x400159d6 }, /* 332: -4.3524626e-01  2.0211082e+00 */
    { 0xbf195a99,0x400da35f }, /* 333: -5.9903866e-01  2.2130964e+00 */
    { 0x3f2ec87b,0x3f51bc69 }, /* 334:  6.8274659e-01  8.1928116e-01 */
    { 0xbe2cef41,0x3fdec869 }, /* 335: -1.6888143e-01  1.7404910e+00 */
    { 0xbef10158,0x4003e5b6 }, /* 336: -4.7071338e-01  2.0608954e+00 */
    { 0xbf454093,0x401cd422 }, /* 337: -7.7051657e-01  2.4504476e+00 */
    { 0xbedd66c6,0x40012687 }, /* 338: -4.3242472e-01  2.0179765e+00 */
    { 0x3e3b8812,0x3fb17cc9 }, /* 339:  1.8313625e-01  1.3866206e+00 */
    { 0x3f3e877b,0x3f3b3b96 }, /* 340:  7.4425477e-01  7.3137796e-01 */
    { 0x3f3263ad,0x3f4cc139 }, /* 341:  6.9683343e-01  7.9982334e-01 */
    { 0x3f55cdde,0x3f1514e2 }, /* 342:  8.3517253e-01  5.8234990e-01 */
    { 0x3f0fed2e,0x3f7946d7 }, /* 343:  5.6221282e-01  9.7373718e-01 */
    { 0x3ea7ae0b,0x3f9e5a9c }, /* 344:  3.2749972e-01  1.2371402e+00 */
    { 0x3dfbd7b7,0x3fb94826 }, /* 345:  1.2297004e-01  1.4475143e+00 */
    { 0x3eaaf804,0x3f9d7b91 }, /* 346:  3.3392346e-01  1.2303334e+00 */
    { 0xbf0fd03d,0x400ab565 }, /* 347: -5.6177121e-01  2.1673214e+00 */
    { 0x3f5fcb34,0x3f01cc33 }, /* 348:  8.7419438e-01  5.0702208e-01 */
    { 0x3f71dd98,0x3eaaee7e }, /* 349:  9.4478750e-01  3.3385080e-01 */
    { 0xbf292322,0x4012b8ed }, /* 350: -6.6069233e-01  2.2925370e+00 */
    { 0xbd9b7bd4,0x3fd2c9fd }, /* 351: -7.5919777e-02  1.6467892e+00 */
    { 0x3f15fc02,0x3f71e0b5 }, /* 352:  5.8587658e-01  9.4483501e-01 */
    { 0xbf25bb37,0x401198c2 }, /* 353: -6.4738792e-01  2.2749486e+00 */
    { 0xbeed2414,0x400359df }, /* 354: -4.6316588e-01  2.0523603e+00 */
    { 0x3ec8301f,0x3f95a4a5 }, /* 355:  3.9099213e-01  1.1690871e+00 */
    { 0xbf32866b,0x4015ebaa }, /* 356: -6.9736356e-01  2.3425088e+00 */
    { 0x3f1d0585,0x3f691552 }, /* 357:  6.1336547e-01  9.1048157e-01 */
    { 0x3f1c1623,0x3f6a43df }, /* 358:  6.0971278e-01  9.1509813e-01 */
    { 0x3eb28ef4,0x3f9b76ca }, /* 359:  3.4874690e-01  1.2145627e+00 */
    { 0x3ebfc3ea,0x3f97ec25 }, /* 360:  3.7454158e-01  1.1868941e+00 */
    { 0xbefec58d,0x4005dd38 }, /* 361: -4.9760094e-01  2.0916271e+00 */
    { 0x3f13293b,0x3f755844 }, /* 362:  5.7484788e-01  9.5837808e-01 */
    { 0x3f7075a9,0x3eb350c3 }, /* 363:  9.3929535e-01  3.5022554e-01 */
    { 0xbdc5eafe,0x3fd5737e }, /* 364: -9.6639618e-02  1.6675870e+00 */
    { 0x3e83e36b,0x3fa7b6c0 }, /* 365:  2.5759444e-01  1.3102646e+00 */
    { 0xbe6b189e,0x3fe6b6a4 }, /* 366: -2.2958609e-01  1.8024487e+00 */
    { 0x3edd83e9,0x3f8fca93 }, /* 367:  4.3264702e-01  1.1233696e+00 */
    { 0x3ef96246,0x3f87f170 }, /* 368:  4.8707789e-01  1.0620556e+00 */
    { 0x3ead0cec,0x3f9cee1e }, /* 369:  3.3798921e-01  1.2260168e+00 */
    { 0xbec4b80e,0x3ffb8a38 }, /* 370: -3.8421673e-01  1.9651556e+00 */
    { 0x3e6ce278,0x3fab2e41 }, /* 371:  2.3133266e-01  1.3373491e+00 */
    { 0x3d0ea225,0x3fc49a8e }, /* 372:  3.4822602e-02  1.5359666e+00 */
    { 0xbf0c8e29,0x4009baa4 }, /* 373: -5.4904419e-01  2.1520166e+00 */
    { 0xbe5368cf,0x3fe3adf6 }, /* 374: -2.0645450e-01  1.7787464e+00 */
    { 0xbf233ed8,0x4010c921 }, /* 375: -6.3767767e-01  2.2622759e+00 */
    { 0x3f12ecce,0x3f75a216 }, /* 376:  5.7392585e-01  9.5950449e-01 */
    { 0xbf5f5e32,0x402864da }, /* 377: -8.7253106e-01  2.6311555e+00 */
    { 0xbe4c3c53,0x3fe2c385 }, /* 378: -1.9944887e-01  1.7715918e+00 */
    { 0x3ee57005,0x3f8d95d3 }, /* 379:  4.4812027e-01  1.1061348e+00 */
    { 0xbf6d8099,0x4030955f }, /* 380: -9.2774349e-01  2.7591169e+00 */
    { 0x3e0f3724,0x3fb719e3 }, /* 381:  1.3985878e-01  1.4304775e+00 */
    { 0xbf20b778,0x400ff820 }, /* 382: -6.2779951e-01  2.2495193e+00 */
    { 0x3f287b68,0x3f5a3ad1 }, /* 383:  6.5813303e-01  8.5245997e-01 */
    { 0x3efc2524,0x3f8726be }, /* 384:  4.9247086e-01  1.0558698e+00 */
    { 0xbdba4c0f,0x3fd4b8bc }, /* 385: -9.0965383e-02  1.6618876e+00 */
    { 0x3d493781,0x3fc2c579 }, /* 386:  4.9125198e-02  1.5216514e+00 */
    { 0x3f4b8c27,0x3f26d008 }, /* 387:  7.9510731e-01  6.5161180e-01 */
    { 0xbef487f9,0x400465dd }, /* 388: -4.7759989e-01  2.0687172e+00 */
    { 0xbeaeacca,0x3ff5a020 }, /* 389: -3.4116203e-01  1.9189491e+00 */
    { 0x3e134e84,0x3fb695a1 }, /* 390:  1.4385420e-01  1.4264413e+00 */
    { 0x3f659df9,0x3eea7e0d }, /* 391:  8.9694172e-01  4.5799294e-01 */
    { 0x3e251b51,0x3fb45546 }, /* 392:  1.6123702e-01  1.4088523e+00 */
    { 0xbe900648,0x3fed8f88 }, /* 393: -2.8129792e-01  1.8559427e+00 */
    { 0x3f5613a1,0x3f1495db }, /* 394:  8.3623701e-01  5.8041161e-01 */
    { 0xbf6f768b,0x4031eeab }, /* 395: -9.3540257e-01  2.7801921e+00 */
    { 0x3f79ee92,0x3e5f664c }, /* 396:  9.7629654e-01  2.1816367e-01 */
    { 0xbec9650c,0x3ffccf05 }, /* 397: -3.9334905e-01  1.9750677e+00 */
    { 0x3efe96d2,0x3f8672bd }, /* 398:  4.9724442e-01  1.0503765e+00 */
    { 0x3eed3f69,0x3f8b6441 }, /* 399:  4.6337441e-01  1.0889970e+00 */
    { 0x3f71d3f0,0x3eab2964 }, /* 400:  9.4464016e-01  3.3430016e-01 */
    { 0xbf63109e,0x402a56bb }, /* 401: -8.8697231e-01  2.6615436e+00 */
    { 0xbe9c4f5b,0x3ff0c5ff }, /* 402: -3.0529293e-01  1.8810424e+00 */
    { 0xbca83dc1,0x3fcbb0de }, /* 403: -2.0537259e-02  1.5913351e+00 */
    { 0xbedf3d8d,0x400167db }, /* 404: -4.3601647e-01  2.0219638e+00 */
    { 0x3ef9fc3d,0x3f87c559 }, /* 405:  4.8825255e-01  1.0607101e+00 */
    { 0x3eaefe74,0x3f9c69dc }, /* 406:  3.4178507e-01  1.2219806e+00 */
    { 0xbf5cb1f8,0x40270d24 }, /* 407: -8.6209059e-01  2.6101770e+00 */
    { 0x3f1d9fed,0x3f685198 }, /* 408:  6.1572152e-01  9.0749502e-01 */
    { 0xbf5b8fdb,0x40267f10 }, /* 409: -8.5766381e-01  2.6015053e+00 */
    { 0x3f16060a,0x3f71d454 }, /* 410:  5.8602965e-01  9.4464612e-01 */
    { 0x3f301f53,0x3f4fe59a }, /* 411:  6.8797797e-01  8.1209719e-01 */
    { 0x3e907bdc,0x3fa4718b }, /* 412:  2.8219497e-01  1.2847151e+00 */
    { 0x3f754e92,0x3e94812d }, /* 413:  9.5823014e-01  2.9004803e-01 */
    { 0x3eb13577,0x3f9bd2e6 }, /* 414:  3.4611103e-01  1.2173736e+00 */
    { 0xbe66bdfe,0x3fe62790 }, /* 415: -2.2533414e-01  1.7980824e+00 */
    { 0xbe07ebbf,0x3fda1a32 }, /* 416: -1.3273524e-01  1.7039244e+00 */
    { 0xbf1ad1cc,0x400e18d5 }, /* 417: -6.0476375e-01  2.2202656e+00 */
    { 0xbedc46b1,0x4000fe9d }, /* 418: -4.3022683e-01  2.0155404e+00 */
    { 0x3ec78228,0x3f95d3e2 }, /* 419:  3.8966489e-01  1.1705287e+00 */
    { 0x3d5d7cea,0x3fc22316 }, /* 420:  5.4074205e-02  1.5166957e+00 */
    { 0x3f36b049,0x3f46b0b1 }, /* 421:  7.1362740e-01  7.7613360e-01 */
    { 0x3e92be19,0x3fa3dac1 }, /* 422:  2.8660658e-01  1.2801133e+00 */
    { 0xbf48e15d,0x401e4579 }, /* 423: -7.8468877e-01  2.4729903e+00 */
    { 0xbf1152dc,0x400b2a84 }, /* 424: -5.6767058e-01  2.1744699e+00 */
    { 0x3dfb956e,0x3fb94c52 }, /* 425:  1.2284361e-01  1.4476416e+00 */
    { 0xbf3857e8,0x4017fb95 }, /* 426: -7.2009134e-01  2.3747303e+00 */
    { 0xbf17644a,0x400d0718 }, /* 427: -5.9137404e-01  2.2035580e+00 */
    { 0x3f3ac028,0x3f40d29b }, /* 428:  7.2949457e-01  7.5321358e-01 */
    { 0x3f46f381,0x3f2e4033 }, /* 429:  7.7715307e-01  6.8066710e-01 */
    { 0x3f5f3b6a,0x3f02f320 }, /* 430:  8.7200034e-01  5.1152229e-01 */
    { 0x3f2c9417,0x3f54bcab }, /* 431:  6.7413467e-01  8.3100384e-01 */
    { 0x3f63e2e3,0x3ef23435 }, /* 432:  8.9018077e-01  4.7305456e-01 */
    { 0xbeddd887,0x4001364d }, /* 433: -4.3329260e-01  2.0189393e+00 */
    { 0xbeb15bad,0x3ff656fe }, /* 434: -3.4640256e-01  1.9245298e+00 */
    { 0xbf0bbbe4,0x40097bd3 }, /* 435: -5.4583573e-01  2.1481826e+00 */
    { 0xbf71ee25,0x4033beaf }, /* 436: -9.4504005e-01  2.8085134e+00 */
    { 0x3f7ed163,0x3dc4e2fa }, /* 437:  9.9538249e-01  9.6136048e-02 */
    { 0xbed0dbb8,0x3ffed85e }, /* 438: -4.0792632e-01  1.9909780e+00 */
    { 0x3f2bb1c8,0x3f55ee6a }, /* 439:  6.7068148e-01  8.3566916e-01 */
    { 0xbf5cbe77,0x4027134f }, /* 440: -8.6228126e-01  2.6105535e+00 */
    { 0xbf5267d2,0x4022461b }, /* 441: -8.2189667e-01  2.5355289e+00 */
    { 0x3eb7a236,0x3f9a1b86 }, /* 442:  3.5865945e-01  1.2039649e+00 */
    { 0x3ed6feed,0x3f9197d6 }, /* 443:  4.1991368e-01  1.1374462e+00 */
    { 0xbf5d1940,0x4027403b }, /* 444: -8.6366653e-01  2.6132953e+00 */
    { 0xbe972853,0x3fef6c49 }, /* 445: -2.9522952e-01  1.8704921e+00 */
    { 0xbf4e3009,0x402075a7 }, /* 446: -8.0542046e-01  2.5071809e+00 */
    { 0x3b6bd0a2,0x3fc899f2 }, /* 447:  3.5982509e-03  1.5671980e+00 */
    { 0x3dccd053,0x3fbc3d59 }, /* 448:  1.0000672e-01  1.4706222e+00 */
    { 0xbe714d85,0x3fe782db }, /* 449: -2.3564728e-01  1.8086809e+00 */
    { 0xbf1b531b,0x400e4176 }, /* 450: -6.0673684e-01  2.2227454e+00 */
    { 0xbf588e27,0x40250fb0 }, /* 451: -8.4591907e-01  2.5790825e+00 */
    { 0xbf05a319,0x4007ae4e }, /* 452: -5.2201992e-01  2.1200137e+00 */
    { 0x3f2e0bf1,0x3f52bdfb }, /* 453:  6.7986971e-01  8.2321137e-01 */
    { 0xbf216f84,0x40103353 }, /* 454: -6.3060784e-01  2.2531326e+00 */
    { 0xbdb7afa5,0x3fd48ec9 }, /* 455: -8.9690484e-02  1.6606075e+00 */
    { 0xbe4a0585,0x3fe27b3c }, /* 456: -1.9728668e-01  1.7693858e+00 */
    { 0xbeb38ed9,0x3ff6ed35 }, /* 457: -3.5069922e-01  1.9291140e+00 */
    { 0x3ea34b82,0x3f9f832a }, /* 458:  3.1893545e-01  1.2461903e+00 */
    { 0xbeef8273,0x4003af83 }, /* 459: -4.6779212e-01  2.0575874e+00 */
    { 0xbf12d3ec,0x400b9fbd }, /* 460: -5.7354617e-01  2.1816247e+00 */
    { 0x3e4384ad,0x3fb0789e }, /* 461:  1.9093581e-01  1.3786809e+00 */
    { 0xbf4b2d22,0x401f34bd }, /* 462: -7.9365742e-01  2.4875939e+00 */
    { 0xbf2ef109,0x4014aea2 }, /* 463: -6.8336540e-01  2.3231587e+00 */
    { 0x3f41f4e8,0x3f360ac5 }, /* 464:  7.5764322e-01  7.1110183e-01 */
    { 0xbe0f6be4,0x3fdb0c7b }, /* 465: -1.4006001e-01  1.7113184e+00 */
    { 0xbe6ab3b2,0x3fe6a9ae }, /* 466: -2.2920111e-01  1.8020532e+00 */
    { 0x3f5006c3,0x3f1f47f1 }, /* 467:  8.1260318e-01  6.2219149e-01 */
    { 0xbe142656,0x3fdba558 }, /* 468: -1.4467749e-01  1.7159834e+00 */
    { 0x3eb9ca6f,0x3f998780 }, /* 469:  3.6287257e-01  1.1994476e+00 */
    { 0x3ef77116,0x3f887f96 }, /* 470:  4.8328465e-01  1.0663936e+00 */
    { 0xbbe4068d,0x3fc9f3e2 }, /* 471: -6.9587887e-03  1.5777552e+00 */
    { 0x3f0a7d65,0x3f7fcb87 }, /* 472:  5.4097587e-01  9.9919933e-01 */
    { 0xbe21d969,0x3fdd60d7 }, /* 473: -1.5805592e-01  1.7295178e+00 */
    { 0xbf164896,0x400caf50 }, /* 474: -5.8704507e-01  2.1982002e+00 */
    { 0x3f2d6426,0x3f53a26c }, /* 475:  6.7730939e-01  8.2669711e-01 */
    { 0x3f0bf57d,0x3f7e0b5c }, /* 476:  5.4671460e-01  9.9236083e-01 */
    { 0xbec8f13e,0x3ffcaf8a }, /* 477: -3.9246553e-01  1.9741070e+00 */
    { 0xbea36013,0x3ff2a1f9 }, /* 478: -3.1909236e-01  1.8955680e+00 */
    { 0xbeb4e0f2,0x3ff74783 }, /* 479: -3.5327870e-01  1.9318699e+00 */
    { 0x3ebe67ff,0x3f9849e6 }, /* 480:  3.7188718e-01  1.1897552e+00 */
    { 0x3d97e6d8,0x3fbf8f31 }, /* 481:  7.4170768e-02  1.4965574e+00 */
    { 0xbe4bfa80,0x3fe2bb20 }, /* 482: -1.9919777e-01  1.7713356e+00 */
    { 0x3f5990e7,0x3f0e189a }, /* 483:  8.4986728e-01  5.5506289e-01 */
    { 0xbe7bdcd0,0x3fe8df03 }, /* 484: -2.4595952e-01  1.8193058e+00 */
    { 0x3e2e4770,0x3fb32ba5 }, /* 485:  1.7019439e-01  1.3997694e+00 */
    { 0xbe759438,0x3fe80fbb }, /* 486: -2.3982322e-01  1.8129801e+00 */
    { 0x3f0e876b,0x3f7af67c }, /* 487:  5.5675381e-01  9.8032355e-01 */
    { 0x3f51ca6f,0x3f1c3a72 }, /* 488:  8.1949514e-01  6.1026680e-01 */
    { 0xbf6bbf4d,0x402f6ef8 }, /* 489: -9.2088777e-01  2.7411480e+00 */
    { 0xbf6939cf,0x402ddca3 }, /* 490: -9.1103834e-01  2.7165916e+00 */
    { 0xbf41097c,0x401b3345 }, /* 491: -7.5405097e-01  2.4250042e+00 */
    { 0x3e8a43bd,0x3fa60fad }, /* 492:  2.7004805e-01  1.2973534e+00 */
    { 0xbf3466f1,0x4016941f }, /* 493: -7.0469576e-01  2.3527906e+00 */
    { 0xbedff50a,0x4001815a }, /* 494: -4.3741637e-01  2.0235200e+00 */
    { 0x3ce2d8cd,0x3fc5845a }, /* 495:  2.7691269e-02  1.5431015e+00 */
    { 0x3e1ef858,0x3fb51c27 }, /* 496:  1.5524423e-01  1.4149216e+00 */
    { 0x3eaab11d,0x3f9d8e5e }, /* 497:  3.3338252e-01  1.2309072e+00 */
    { 0xbe2389db,0x3fdd9797 }, /* 498: -1.5970556e-01  1.7311887e+00 */
    { 0xbf7d4b80,0x403fbff4 }, /* 499: -9.8943329e-01  2.9960909e+00 */
    { 0xbe9b8475,0x3ff090be }, /* 500: -3.0374494e-01  1.8794172e+00 */
};

void x_exit (int index)
{
#ifndef	__AVR__
    fprintf (stderr, "t[%d]:  %#lx\n", index - 1, v.lo);
#endif
    exit (index ? index : -1);
}

int main ()
{
    union lofl_u x, z;
    unsigned long v1, z1, r;
    int i;
    
    for (i = 0; i < (int) (sizeof(t) / sizeof(t[0])); i++) {
	x.lo = pgm_read_dword (& t[i].x);
	z.lo = pgm_read_dword (& t[i].z);
	v.fl = acos (x.fl);
	
	v1 = (v.lo < 0) ? (unsigned long)~(v.lo) : v.lo + 0x80000000;
	z1 = (z.lo < 0) ? (unsigned long)~(z.lo) : z.lo + 0x80000000;
	r = (v1 >= z1) ? v1 - z1 : z1 - v1;
	
	if (r > 2) x_exit (i+1);
    }
    return 0;
}
