/*
 * File    : DiskManagerListener.java
 * Created : 13-Jan-2004
 * By      : parg
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details ( see the LICENSE file ).
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package com.biglybt.core.disk;

import java.util.Collections;
import java.util.List;

/**
 * @author parg
 *
 */
public interface
DiskManagerListener
{
	public void
	stateChanged(
		DiskManager		dm,
		int 			oldState,
		int				newState );

	public default void
	filePriorityChanged(
		DiskManager			dm,
		DiskManagerFileInfo	file )
	{
		filePriorityChanged( dm, Collections.singletonList( file ));
	}

	
	public void
	filePriorityChanged(
		DiskManager					dm,
		List<DiskManagerFileInfo>	files );

	public void
	pieceDoneChanged(
		DiskManager				dm,
		DiskManagerPiece		piece );

	public default void
	fileCompleted(
		DiskManager				dm,
		DiskManagerFileInfo		file )
	{
	}
}
