//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Toplevel/ProjectsView.h
//! @brief     Defines class ProjectsView
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_TOPLEVEL_PROJECTSVIEW_H
#define BORNAGAIN_GUI_VIEW_TOPLEVEL_PROJECTSVIEW_H

#include <QWidget>

class ProjectManager;

namespace Ui {
class ProjectsView;
}

class ProjectsView : public QWidget {
    Q_OBJECT
public:
    ProjectsView(QWidget* parent);

private:
    ProjectManager* projectManager();
    void updateRecentProjectPanel();

    Ui::ProjectsView* m_ui;
};

#endif // BORNAGAIN_GUI_VIEW_TOPLEVEL_PROJECTSVIEW_H
