+++
title = "MacOS"
weight = 70
+++

## Install on MacOS

#### Prequisite: Python

As a prerequisite, Python must be installed, see [Python on Mac](/deploy/py/mac).

#### Install BornAgain GUI application

To install BornAgain on MacOS, one should use the official MLZ Homebrew Tap hosted at <https://jugit.fz-juelich.de/mlz/homebrew/>.

First, add the tap to the local Homebrew taps via
```
$ brew tap mlz/homebrew https://jugit.fz-juelich.de/mlz/homebrew/
```

After that, Homebrew will be able to work with formulae in `mlz/homebrew` as if they were
in `homebrew-core` canonical repository.

To install BornAgain v22.2 from the tap, use
```
$ brew install mlz/homebrew/bornagain@22.2
```

To install another version, say `v22`, use
```
$ brew install mlz/homebrew/bornagain@22
```

After a successfull installation, in order to obtain detailed information about
the BornAgain installation, use
```
$ bornagain_info
```

This will display the paths to BornAgain installation, the examples, the Python wheel and the build log.

Run the BornAgain GUI (with Python support) via
```
$ bornagain
```

#### Using BornAgain as Python-only package

To use BornAgain as a Python package, install the wheel via
```
$ python3 -m pip install /path/to/bornagain/python/wheel
```

The path to the Python wheel is obtained via the above-mentioned command, `bornagain_info`.

#### Uninstalling BornAgain

To purge BornAgain from the local Homebrew repository, use
```
$ brew rm bornagain@22.2 && brew cleanup
```

To remove the  MLZ Homebrew Tap, use
```
$ brew untap mlz/homebrew
```
