<?xml version="1.0" encoding="utf-8"?>
<!--
    Copyright (c) 2011-2012 KO GmbH.  All rights reserved.
    Copyright (c) 2011-2012 Stuart Dickson <stuartmd@kogmbh.com>
     
    The use and distribution terms for this software are covered by the
    Common Public License 1.0 (http://opensource.org/licenses/cpl1.0.php)
    which can be found in the file CPL.TXT at the root of this distribution.
    By using this software in any fashion, you are agreeing to be bound by
    the terms of this license.
    
    You must not remove this notice, or any other, from this software.
    
    Based on an example from Mark Lines-Davies' blog entry "Preserve GUIDs
    in Wix generated by the Heat harvesting tool" at 
    http://marklinesdavies.blogware.com/blog/_archives/2011/3/14/4771326.html
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:wix="http://schemas.microsoft.com/wix/2006/wi"
	xmlns:msxsl="urn:schemas-microsoft-com:xslt" exclude-result-prefixes="msxsl">
	
	<xsl:output method="xml" indent="yes"/>
	
	<!--Identity Transform-->
	<xsl:template match="@*|node()">
		<xsl:copy>
			<xsl:apply-templates select="@*|node()"/>
		</xsl:copy>
	</xsl:template>
	
	<!--Set up keys of component Ids from PreviousHeatFragment.xml-->
	<xsl:key name="previousfragment-search" match="wix:Component[@Id = document('PreviousHeatFragment.xml')//wix:Component/@Id]" use="@Id"/>
	
	<!--Match Components that also exist in PreviousHeatFragment.xml, and use the previous version-->
	<xsl:template match="wix:Component[key('previousfragment-search', @Id)]">
		<xsl:variable name="component" select="."/>
		<xsl:copy-of select="document('PreviousHeatFragment.xml')//wix:Component[@Id = $component/@Id]"/>
	</xsl:template>
</xsl:stylesheet>	