from __future__ import nested_scopes, generators, division, absolute_import
from __future__ import  with_statement, print_function, unicode_literals
from io import StringIO

from mmtbx.suitename.suitename import main
from mmtbx.suitename import suites

in_1ehz = \
""" :1: A:   1: : :  G:__?__:-128.053:67.793:82.863:-155.568:-68.623
 :1: A:   2: : :  C:-67.449:-178.393:53.832:83.378:-145.149:-76.788
 :1: A:   3: : :  G:-74.460:169.695:59.477:80.733:-148.283:-80.025
 :1: A:   4: : :  G:-64.437:162.194:60.724:82.164:-157.372:-68.659
 :1: A:   5: : :  A:-74.745:-176.472:53.356:84.944:-137.465:-81.718
 :1: A:   6: : :  U:-48.819:157.567:55.308:81.262:-150.997:-77.008
 :1: A:   7: : :  U:-59.498:-178.720:62.506:137.257:-105.934:-51.960
 :1: A:   8: : :  U:-83.821:-145.649:55.418:78.644:-142.800:-118.577
 :1: A:   9: : :  A:-69.711:-141.745:52.257:147.772:-106.213:-77.257
 :1: A:  10: : :2MG:177.814:147.203:__?__:__?__:-126.196:-88.738
 :1: A:  11: : :  C:-56.137:167.906:48.160:87.215:-150.469:-69.893
 :1: A:  12: : :  U:-67.796:172.869:51.821:80.665:-158.532:-65.168
 :1: A:  13: : :  C:166.574:-169.891:178.570:82.512:-153.131:-97.390
 :1: A:  14: : :  A:83.353:-158.279:-114.591:92.038:-125.519:-57.251
 :1: A:  15: : :  G:-55.064:162.460:51.892:79.826:-136.303:-143.947
 :1: A:  16: : :H2U:-6.131:91.184:__?__:__?__:-61.796:-131.179
 :1: A:  17: : :H2U:27.788:107.741:__?__:__?__:177.959:76.191
 :1: A:  18: : :  G:45.383:-159.437:59.039:150.600:-95.226:-179.094
 :1: A:  19: : :  G:-71.420:-178.863:53.824:153.803:-91.620:-83.735
 :1: A:  20: : :  G:-81.332:-150.736:47.756:89.936:-122.273:-54.104
 :1: A:  21: : :  A:-75.551:148.565:-176.602:78.228:-168.936:-75.552
 :1: A:  22: : :  G:158.774:153.494:179.253:81.999:-144.965:-80.445
 :1: A:  23: : :  A:-53.308:174.758:52.482:82.300:-155.347:-66.440
 :1: A:  24: : :  G:-68.767:178.230:46.822:83.604:-144.254:-72.825
 :1: A:  25: : :  C:-65.087:168.872:53.883:83.255:-145.086:-68.361
 :1: A:  26: : :M2G:-53.808:170.843:__?__:__?__:-136.277:-76.875
 :1: A:  27: : :  C:-52.975:166.853:43.623:83.427:-148.537:-73.433
 :1: A:  28: : :  C:-72.439:178.326:49.309:80.115:-152.098:-66.986
 :1: A:  29: : :  A:-66.553:173.956:55.560:81.361:-155.521:-78.260
 :1: A:  30: : :  G:-53.966:165.929:56.930:83.563:-144.716:-62.268
 :1: A:  31: : :  A:-69.947:177.767:52.310:83.748:-136.979:-75.532
 :1: A:  32: : :OMC:-52.715:__?__:__?__:__?__:-145.941:-71.172
 :1: A:  33: : :  U:-67.688:-177.012:47.001:82.123:-148.003:-53.686
 :1: A:  34: : :OMG:171.113:148.145:__?__:__?__:-132.519:-71.830
 :1: A:  35: : :  A:-47.663:163.713:40.211:80.882:-143.671:-59.500
 :1: A:  36: : :  A:-52.433:165.690:51.257:72.220:-160.374:-85.207
 :1: A:  37: : :YYG:-57.536:162.974:__?__:__?__:-148.148:-67.046
 :1: A:  38: : :  A:-61.808:-179.981:46.930:82.458:-136.769:-76.362
 :1: A:  39: : :PSU:-47.734:160.379:53.321:79.261:-140.089:-68.553
 :1: A:  40: : :5MC:-67.366:172.001:__?__:__?__:-154.223:-74.895
 :1: A:  41: : :  U:-68.226:-179.367:52.444:78.871:-137.302:-84.708
 :1: A:  42: : :  G:-47.869:158.673:55.597:79.758:-160.327:-70.305
 :1: A:  43: : :  G:-67.015:-178.303:55.596:81.592:-154.873:-76.392
 :1: A:  44: : :  A:-59.692:162.125:60.042:85.307:-142.834:-57.171
 :1: A:  45: : :  G:-71.930:-176.932:50.985:87.553:-135.100:-78.652
 :1: A:  46: : :7MG:-56.771:-146.515:__?__:__?__:-102.653:-137.859
 :1: A:  47: : :  U:62.398:-164.007:44.365:146.142:-93.662:-78.042
 :1: A:  48: : :  C:-73.483:-174.257:161.496:145.555:-143.540:75.586
 :1: A:  49: : :5MC:50.694:168.495:__?__:__?__:-145.028:-82.064
 :1: A:  50: : :  U:-51.651:177.223:42.076:80.392:-150.600:-67.789
 :1: A:  51: : :  G:-63.906:176.814:52.813:79.429:-150.411:-71.324
 :1: A:  52: : :  U:-64.688:173.639:48.543:80.289:-156.462:-69.422
 :1: A:  53: : :  G:-56.867:171.464:56.154:83.914:-159.389:-64.873
 :1: A:  54: : :5MU:-79.665:__?__:__?__:__?__:-128.577:-70.746
 :1: A:  55: : :PSU:-49.745:168.796:44.052:76.601:-140.782:-69.884
 :1: A:  56: : :  C:166.416:171.805:53.305:83.405:-132.708:-70.648
 :1: A:  57: : :  G:-65.658:167.070:57.463:81.657:-145.232:-67.602
 :1: A:  58: : :1MA:-60.812:-146.102:__?__:__?__:-78.282:-169.333
 :1: A:  59: : :  U:72.618:-158.840:63.678:84.575:-148.820:-53.724
 :1: A:  60: : :  C:-72.162:179.454:66.018:148.304:-97.069:-66.356
 :1: A:  61: : :  C:-84.288:179.827:38.237:82.964:-152.342:-74.495
 :1: A:  62: : :  A:-60.070:179.638:46.853:80.531:-145.618:-74.140
 :1: A:  63: : :  C:-62.017:167.262:50.948:80.715:-152.333:-70.724
 :1: A:  64: : :  A:-66.852:179.977:44.052:75.809:-147.481:-76.520
 :1: A:  65: : :  G:-43.958:164.226:49.876:79.755:-152.032:-73.335
 :1: A:  66: : :  A:-57.891:178.545:52.046:81.724:-150.972:-73.549
 :1: A:  67: : :  A:-61.953:164.096:54.240:83.200:-152.186:-78.339
 :1: A:  68: : :  U:-59.846:175.336:47.283:82.185:-152.942:-65.390
 :1: A:  69: : :  U:-63.754:168.082:55.094:79.119:-155.366:-85.643
 :1: A:  70: : :  C:-61.653:164.642:53.122:78.973:-158.517:-64.505
 :1: A:  71: : :  G:-78.355:173.623:60.313:80.276:-149.552:-68.409
 :1: A:  72: : :  C:-73.183:176.236:62.079:82.989:-152.335:-67.878
 :1: A:  73: : :  A:-63.297:177.662:50.401:81.559:-148.155:-66.150
 :1: A:  74: : :  C:-66.885:-174.928:50.690:85.875:-145.004:-58.835
 :1: A:  75: : :  C:-52.334:175.666:42.302:85.557:-131.936:163.904
 :1: A:  76: : :  A:-70.955:130.178:164.639:160.907:__?__:__?__
"""

out_1ehz = (\
  " :1: A:   1: : :  G inc  __ 0.000\n"+
  " :1: A:   2: : :  C 33 p 1a 0.935\n"+
  " :1: A:   3: : :  G 33 p 1a 0.868\n"+
  " :1: A:   4: : :  G 33 p 1a 0.842\n"+
  " :1: A:   5: : :  A 33 p 1a 0.847\n"+
  " :1: A:   6: : :  U 33 p 1a 0.664\n"+
  " :1: A:   7: : :  U 32 p 1b 0.803\n"+
  " :1: A:   8: : :  U 23 p 2a 0.509\n"+
  " :1: A:   9: : :  A 32 p 1[ 0.046\n"+
  " :1: A:  10: : :2MG inc  __ 0.000\n"+
  " :1: A:  11: : :  C inc  __ 0.000\n"+
  " :1: A:  12: : :  U 33 p 1a 0.898\n"+
  " :1: A:  13: : :  C 33 t 1c 0.824\n"+
  " :1: A:  14: : :  A trig !! 0.000 gamma\n"+
  " :1: A:  15: : :  G 33 p 1a 0.484\n"+
  " :1: A:  16: : :H2U inc  __ 0.000\n"+
  " :1: A:  17: : :H2U inc  __ 0.000\n"+
  " :1: A:  18: : :  G inc  __ 0.000\n"+
  " :1: A:  19: : :  G 22 p 4b 0.512\n"+
  " :1: A:  20: : :  G 23 p 2a 0.623\n"+
  " :1: A:  21: : :  A 33 t !! 0.000\n"+
  " :1: A:  22: : :  G 33 t 1f 0.714\n"+
  " :1: A:  23: : :  A 33 p 1a 0.840\n"+
  " :1: A:  24: : :  G 33 p 1a 0.881\n"+
  " :1: A:  25: : :  C 33 p 1a 0.967\n"+
  " :1: A:  26: : :M2G inc  __ 0.000\n"+
  " :1: A:  27: : :  C inc  __ 0.000\n"+
  " :1: A:  28: : :  C 33 p 1a 0.923\n"+
  " :1: A:  29: : :  A 33 p 1a 0.973\n"+
  " :1: A:  30: : :  G 33 p 1a 0.838\n"+
  " :1: A:  31: : :  A 33 p 1a 0.914\n"+
  " :1: A:  32: : :OMC inc  __ 0.000\n"+
  " :1: A:  33: : :  U inc  __ 0.000\n"+
  " :1: A:  34: : :OMG inc  __ 0.000\n"+
  " :1: A:  35: : :  A inc  __ 0.000\n"+
  " :1: A:  36: : :  A 33 p 1a 0.670\n"+
  " :1: A:  37: : :YYG inc  __ 0.000\n"+
  " :1: A:  38: : :  A inc  __ 0.000\n"+
  " :1: A:  39: : :PSU 33 p 1a 0.680\n"+
  " :1: A:  40: : :5MC inc  __ 0.000\n"+
  " :1: A:  41: : :  U inc  __ 0.000\n"+
  " :1: A:  42: : :  G 33 p 1a 0.630\n"+
  " :1: A:  43: : :  G 33 p 1a 0.882\n"+
  " :1: A:  44: : :  A 33 p 1a 0.837\n"+
  " :1: A:  45: : :  G 33 p 1a 0.749\n"+
  " :1: A:  46: : :7MG inc  __ 0.000\n"+
  " :1: A:  47: : :  U inc  __ 0.000\n"+
  " :1: A:  48: : :  C 22 t 2u 0.283 wannabe\n"+
  " :1: A:  49: : :5MC inc  __ 0.000\n"+
  " :1: A:  50: : :  U inc  __ 0.000\n"+
  " :1: A:  51: : :  G 33 p 1a 0.981\n"+
  " :1: A:  52: : :  U 33 p 1a 0.945\n"+
  " :1: A:  53: : :  G 33 p 1a 0.896\n"+
  " :1: A:  54: : :5MU inc  __ 0.000\n"+
  " :1: A:  55: : :PSU inc  __ 0.000\n"+
  " :1: A:  56: : :  C 33 p 1g 0.894\n"+
  " :1: A:  57: : :  G 33 p 1a 0.837\n"+
  " :1: A:  58: : :1MA inc  __ 0.000\n"+
  " :1: A:  59: : :  U inc  __ 0.000\n"+
  " :1: A:  60: : :  C 32 p 1b 0.662\n"+
  " :1: A:  61: : :  C 23 p 2a 0.553\n"+
  " :1: A:  62: : :  A 33 p 1a 0.895\n"+
  " :1: A:  63: : :  C 33 p 1a 0.964\n"+
  " :1: A:  64: : :  A 33 p 1a 0.791\n"+
  " :1: A:  65: : :  G 33 p 1a 0.586\n"+
  " :1: A:  66: : :  A 33 p 1a 0.940\n"+
  " :1: A:  67: : :  A 33 p 1a 0.941\n"+
  " :1: A:  68: : :  U 33 p 1a 0.891\n"+
  " :1: A:  69: : :  U 33 p 1a 0.951\n"+
  " :1: A:  70: : :  C 33 p 1a 0.809\n"+
  " :1: A:  71: : :  G 33 p 1a 0.761\n"+
  " :1: A:  72: : :  C 33 p 1a 0.832\n"+
  " :1: A:  73: : :  A 33 p 1a 0.965\n"+
  " :1: A:  74: : :  C 33 p 1a 0.886\n"+
  " :1: A:  75: : :  C 33 p 1a 0.639\n"+
  " :1: A:  76: : :  A 32 t !! 0.000\n"+
  " all general case widths, power = 3.00\n"+
  "Found 52 complete suites derived from 76 entries\n"+
  "1 suites were triaged, leaving 51 assigned to bins\n"+
  "For all 51 suites: average suiteness== 0.750 (power==3.00)\n"+
  "     2 suites are  outliers\n"+
  "     0 suites have suiteness == 0    \n"+
  "     1 suites have suiteness >  0 <.1\n"+
  "     0 suites have suiteness >=.1 <.2\n"+
  "     1 suites have suiteness >=.2 <.3\n"+
  "     0 suites have suiteness >=.3 <.4\n"+
  "     1 suites have suiteness >=.4 <.5\n"+
  "     4 suites have suiteness >=.5 <.6\n"+
  "     7 suites have suiteness >=.6 <.7\n"+
  "     4 suites have suiteness >=.7 <.8\n"+
  "    19 suites have suiteness >=.8 <.9\n"+
  "    12 suites have suiteness >=.9    \n"+
  " A form (1a) 38 suites: average suiteness== 0.838 (power==3.00)\n"+
  "     0 suites have suiteness == 0    \n"+
  "     0 suites have suiteness >  0 <.1\n"+
  "     0 suites have suiteness >=.1 <.2\n"+
  "     0 suites have suiteness >=.2 <.3\n"+
  "     0 suites have suiteness >=.3 <.4\n"+
  "     1 suites have suiteness >=.4 <.5\n"+
  "     1 suites have suiteness >=.5 <.6\n"+
  "     5 suites have suiteness >=.6 <.7\n"+
  "     3 suites have suiteness >=.7 <.8\n"+
  "    16 suites have suiteness >=.8 <.9\n"+
  "    12 suites have suiteness >=.9    \n"+
  " non-1a  has 11 suites: average suiteness== 0.584 (power==3.00)\n"+
  "     0 suites have suiteness == 0    \n"+
  "     1 suites have suiteness >  0 <.1\n"+
  "     0 suites have suiteness >=.1 <.2\n"+
  "     1 suites have suiteness >=.2 <.3\n"+
  "     0 suites have suiteness >=.3 <.4\n"+
  "     0 suites have suiteness >=.4 <.5\n"+
  "     3 suites have suiteness >=.5 <.6\n"+
  "     2 suites have suiteness >=.6 <.7\n"+
  "     1 suites have suiteness >=.7 <.8\n"+
  "     3 suites have suiteness >=.8 <.9\n"+
  "     0 suites have suiteness >=.9    \n"
)

def regression(name, input, canonical_output):
  inp = StringIO(input)
  out = StringIO()
  options2 = suites.parseOptions("report=True")

  main(inStream=inp, outFile=out, optionsIn=options2)
  output = out.getvalue()
  assert output == canonical_output, name + " regression test failed"


def test():
  regression("1ehz", in_1ehz, out_1ehz)

