/*
 * Copyright (C) 2025 The Phosh.mobi e.V.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 * Author: Guido Günther <agx@sigxcpu.org>
 */

#include "cbd-test.h"

const CbdChannelsRange expected_de[] = {
  {
    .level = LCB_SEVERITY_LEVEL_PRESIDENTIAL,
    .start = 4370,
    .end = 4370,
  },
  {
    .level = LCB_SEVERITY_LEVEL_EXTREME,
    .start = 4371,
    .end = 4371,
  },
  {
    .level = LCB_SEVERITY_LEVEL_EXTREME,
    .start = 4384,
    .end = 4385,
  },
  {
    .level = LCB_SEVERITY_LEVEL_SEVERE,
    .start = 4373,
    .end = 4377,
  },
  {
    .level = LCB_SEVERITY_LEVEL_SEVERE,
    .start = 4378,
    .end = 4378,
  },
  {
    .level = LCB_SEVERITY_LEVEL_SEVERE,
    .start = 4386,
    .end = 4391,
  },
  {
    .level = LCB_SEVERITY_LEVEL_PUBLIC_SAFETY,
    .start = 4396,
    .end = 4396,
  },
  {
    .level = LCB_SEVERITY_LEVEL_AMBER,
    .start = 4379,
    .end = 4379,
  },
  {
    .level = LCB_SEVERITY_LEVEL_TEST,
    .start = 4380,
    .end = 4380,
  },
  {
    .level = LCB_SEVERITY_LEVEL_TEST,
    .start = 4381,
    .end = 4381,
  },
  {
    .level = LCB_SEVERITY_LEVEL_TEST,
    .start = 4382,
    .end = 4382,
  },
};


const CbdChannelsRange expected_us[] = {
  {
    .level = LCB_SEVERITY_LEVEL_PRESIDENTIAL,
    .start = 4370,
    .end = 4370,
  },
  {
    .level = LCB_SEVERITY_LEVEL_EXTREME,
    .start = 4371,
    .end = 4372,
  },
  {
    .level = LCB_SEVERITY_LEVEL_SEVERE,
    .start = 4373,
    .end = 4378,
  },
  {
    .level = LCB_SEVERITY_LEVEL_PUBLIC_SAFETY,
    .start = 4397,
    .end = 4397,
  },
  {
    .level = LCB_SEVERITY_LEVEL_AMBER,
    .start = 4379,
    .end = 4379,
  },
};


GArray *
cbd_test_channels_get_expected (const char *country)
{
  g_assert_nonnull (country);

  if (g_str_equal (country, "de")) {
    return g_array_new_take (g_memdup2 (expected_de, sizeof (expected_de)),
                             G_N_ELEMENTS (expected_de),
                             FALSE,
                             sizeof (CbdChannelsRange));
  } else if (g_str_equal (country , "us")) {
    return g_array_new_take (g_memdup2 (expected_us, sizeof (expected_us)),
                             G_N_ELEMENTS (expected_us),
                             FALSE,
                             sizeof (CbdChannelsRange));
  } else {
    g_assert_not_reached();
  }
}
