/*
 * Copyright (c) 2011 The Native Client Authors. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

/*
 * This is the bitcode crtbegin (crtbegin.bc)
 */

/*
 * References to __dso_handle are generated by the compiler front end,
 * which uses it when registering destructors for C++ global
 * variables.  The compiler will generate a function call like the
 * following in an initializer:
 *
 *   __cxa_atexit(destructor_func, &global_obj, &__dso_handle);
 *
 * __cxa_atexit() arranges for destructor_func(&global_obj) to be
 * called on exit() or when the DSO uniquely identified by
 * &__dso_handle is dlclose()'d.  See:
 * http://gcc.gnu.org/ml/gcc-patches/1999-12n/msg00664.html
 *
 * (Note that __cxa_* functions are usually provided by libsupc++ or
 * its equivalent, but __cxa_atexit() happens to be provided by libc.)
 *
 * __dso_handle is zero for the main executable, which is the only
 * case PNaCl supports because PNaCl does not support DSOs.
 */
void *__dso_handle = 0;
