/*
 * Author: Andrei Zavada <johnhommer@gmail.com>
 *         building on original work by Thomas Nowotny
 *
 * License: GPL-2+
 *
 * Initial version: 2008-09-23
 *
 * A base class for integrators, to be plugged into CModel
 */


#ifndef LIBCN_INTEGRATE_BASE_H
#define LIBCN_INTEGRATE_BASE_H

#include "config.h"

namespace CNRun {

class CModel;

class CIntegrate_base {

//    friend class CModel;
//    protected:
    public:
	double	_dt_min, _dt_max,
		_eps, _eps_abs, _eps_rel,
		dt;  // that which is current

	bool	is_owned;

	CModel *model;

	CIntegrate_base( double dt_min, double dt_max,
			 double eps,  double eps_abs, double eps_rel,
			 bool inis_owned)
	      : _dt_min (dt_min), _dt_max (dt_max),
		_eps (eps), _eps_abs (eps_abs), _eps_rel (eps_rel),
		dt (dt_min),
		is_owned (inis_owned)
		{}
	virtual ~CIntegrate_base()
		{}

	virtual void cycle() = 0;
	virtual void fixate() = 0;
	virtual void prepare() = 0;
};

}

#endif

// EOF
