'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _index = require('../NotificationDrawer/index');

var _index2 = require('./index');

var _EmptyState = require('../../EmptyState');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var NotificationDrawerWrapper = function NotificationDrawerWrapper(_ref) {
  var panels = _ref.panels,
      toggleDrawerHide = _ref.toggleDrawerHide,
      toggleDrawerExpand = _ref.toggleDrawerExpand,
      isExpandable = _ref.isExpandable,
      isExpanded = _ref.isExpanded,
      expandedPanel = _ref.expandedPanel,
      togglePanel = _ref.togglePanel,
      onNotificationClick = _ref.onNotificationClick,
      onNotificationHide = _ref.onNotificationHide,
      onMarkPanelAsRead = _ref.onMarkPanelAsRead,
      onMarkPanelAsClear = _ref.onMarkPanelAsClear,
      onClickedLink = _ref.onClickedLink;

  var notificationPanels = panels.map(function (panel, i) {
    return _react2.default.createElement(_index2.NotificationDrawerPanelWrapper, {
      key: i,
      panelName: panel.panelName,
      panelkey: panel.panelkey,
      onClickedLink: onClickedLink,
      notifications: panel.notifications,
      togglePanel: togglePanel,
      isExpanded: expandedPanel === panel.panelkey,
      onNotificationClick: onNotificationClick,
      onNotificationHide: onNotificationHide,
      onMarkPanelAsRead: onMarkPanelAsRead,
      onMarkPanelAsClear: onMarkPanelAsClear,
      showLoading: panel.showLoading
    });
  });
  var noNotificationsMessage = _react2.default.createElement(
    _EmptyState.EmptyState,
    null,
    _react2.default.createElement(_EmptyState.EmptyStateIcon, { name: 'info' }),
    _react2.default.createElement(
      _EmptyState.EmptyStateTitle,
      null,
      'No Notifications Available'
    )
  );

  return _react2.default.createElement(
    _index.NotificationDrawer,
    { expanded: isExpanded },
    _react2.default.createElement(_index.NotificationDrawer.Title, {
      title: 'Notifications',
      onCloseClick: function onCloseClick() {
        return toggleDrawerHide();
      },
      expandable: isExpandable,
      onExpandClick: toggleDrawerExpand
    }),
    _react2.default.createElement(
      _index.NotificationDrawer.Accordion,
      null,
      notificationPanels.length === 0 ? noNotificationsMessage : notificationPanels
    )
  );
};

NotificationDrawerWrapper.propTypes = {
  /** toggleDrawer Hide/Expand func */
  toggleDrawerExpand: _propTypes2.default.func,
  toggleDrawerHide: _propTypes2.default.func,
  /** Notification Panels Array */
  panels: _propTypes2.default.array,
  /** is Expanded Bool */
  isExpanded: _propTypes2.default.bool,
  /** function(panelkey, notificationkey) on Notification Click */
  onNotificationClick: _propTypes2.default.func,
  /** on function(panelkey) Panel Read All Click */
  onMarkPanelAsRead: _propTypes2.default.func,
  /** function(url) on Dropdown Link Click */
  onClickedLink: _propTypes2.default.func,
  /** function(panelkey, notificationkey) on Notification Hide Click */
  onNotificationHide: _propTypes2.default.func,
  /** function(panelkey) Panel Clear All Click */
  onMarkPanelAsClear: _propTypes2.default.func,
  /** function() togglePanel Click */
  togglePanel: _propTypes2.default.func,
  /** show Loading notification Bool */
  isExpandable: _propTypes2.default.bool,
  /** expanded Panel */
  expandedPanel: _propTypes2.default.string
};

NotificationDrawerWrapper.defaultProps = {
  panels: null,
  toggleDrawerHide: null,
  toggleDrawerExpand: null,
  togglePanel: null,
  isExpanded: false,
  onNotificationClick: null,
  onMarkPanelAsRead: null,
  onClickedLink: null,
  onNotificationHide: null,
  onMarkPanelAsClear: null,
  isExpandable: true,
  expandedPanel: null
};

exports.default = NotificationDrawerWrapper;