/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.Err;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.SimpleNodeConstructor;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Whitespace;

public class ProcessingInstruction
extends SimpleNodeConstructor {
    private Expression name;

    public ProcessingInstruction(Expression expression) {
        this.name = expression;
        this.adoptChildExpression(expression);
    }

    public int getInstructionNameCode() {
        return 173;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return NodeKindTest.PROCESSING_INSTRUCTION;
    }

    public int getCardinality() {
        return 16384;
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.name = this.name.simplify(staticContext);
        return super.simplify(staticContext);
    }

    public void localTypeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.name = this.name.typeCheck(staticContext, itemType);
        this.adoptChildExpression(this.name);
        RoleLocator roleLocator = new RoleLocator(4, "processing-instruction:name", 0, null);
        roleLocator.setSourceLocator(this);
        this.name = TypeChecker.staticTypeCheck(this.name, SequenceType.SINGLE_STRING, false, roleLocator, staticContext);
        this.adoptChildExpression(this.name);
    }

    public int getDependencies() {
        return this.name.getDependencies() | super.getDependencies();
    }

    public Iterator iterateSubExpressions() {
        ArrayList<Expression> arrayList = new ArrayList<Expression>(6);
        if (this.select != null) {
            arrayList.add(this.select);
        }
        arrayList.add(this.name);
        return arrayList.iterator();
    }

    public boolean replaceSubExpression(Expression expression, Expression expression2) {
        boolean bl = false;
        if (this.select == expression) {
            this.select = expression2;
            bl = true;
        }
        if (this.name == expression) {
            this.name = expression2;
            bl = true;
        }
        return bl;
    }

    protected void promoteInst(PromotionOffer promotionOffer) throws XPathException {
        this.name = this.doPromotion(this.name, promotionOffer);
        super.promoteInst(promotionOffer);
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        String string = this.evaluateName(xPathContext);
        if (string != null) {
            String string2 = this.expandChildren(xPathContext).toString();
            string2 = this.checkContent(string2, xPathContext);
            SequenceReceiver sequenceReceiver = xPathContext.getReceiver();
            sequenceReceiver.processingInstruction(string, string2, this.locationId, 0);
        }
        return null;
    }

    protected String checkContent(String string, XPathContext xPathContext) throws DynamicError {
        int n;
        while ((n = string.indexOf("?>")) >= 0) {
            if (this.isXSLT()) {
                string = string.substring(0, n + 1) + ' ' + string.substring(n + 1);
                continue;
            }
            DynamicError dynamicError = new DynamicError("Invalid characters (?>) in processing instruction", this);
            dynamicError.setErrorCode("XQDY0026");
            dynamicError.setXPathContext(xPathContext);
            xPathContext.getController().recoverableError(dynamicError);
        }
        string = Whitespace.removeLeadingWhitespace(string).toString();
        return string;
    }

    public int evaluateNameCode(XPathContext xPathContext) throws XPathException {
        String string = this.evaluateName(xPathContext);
        return xPathContext.getNamePool().allocate("", "", string);
    }

    private String evaluateName(XPathContext xPathContext) throws XPathException {
        String string = this.name.evaluateAsString(xPathContext).trim();
        if (!xPathContext.getConfiguration().getNameChecker().isValidNCName(string)) {
            DynamicError dynamicError = new DynamicError("Processing instruction name " + Err.wrap(string) + " is not a valid NCName");
            dynamicError.setXPathContext(xPathContext);
            dynamicError.setErrorCode(this.isXSLT() ? "XTDE0890" : "XQDY0041");
            throw ProcessingInstruction.dynamicError(this, dynamicError, xPathContext);
        }
        if (string.equalsIgnoreCase("xml")) {
            DynamicError dynamicError = new DynamicError("Processing instructions cannot be named 'xml' in any combination of upper/lower case");
            dynamicError.setXPathContext(xPathContext);
            dynamicError.setErrorCode(this.isXSLT() ? "XTDE0890" : "XQDY0064");
            throw ProcessingInstruction.dynamicError(this, dynamicError, xPathContext);
        }
        return string;
    }

    public void display(int n, PrintStream printStream, Configuration configuration) {
        printStream.println(ExpressionTool.indent(n) + "processing-instruction");
        this.name.display(n + 1, printStream, configuration);
        super.display(n + 1, printStream, configuration);
    }
}

